# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AaaaRecord(_serialization.Model):
    """An AAAA record.

    :ivar ipv6_address: The IPv6 address of this AAAA record.
    :vartype ipv6_address: str
    """

    _attribute_map = {
        "ipv6_address": {"key": "ipv6Address", "type": "str"},
    }

    def __init__(self, *, ipv6_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ipv6_address: The IPv6 address of this AAAA record.
        :paramtype ipv6_address: str
        """
        super().__init__(**kwargs)
        self.ipv6_address = ipv6_address


class ARecord(_serialization.Model):
    """An A record.

    :ivar ipv4_address: The IPv4 address of this A record.
    :vartype ipv4_address: str
    """

    _attribute_map = {
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
    }

    def __init__(self, *, ipv4_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ipv4_address: The IPv4 address of this A record.
        :paramtype ipv4_address: str
        """
        super().__init__(**kwargs)
        self.ipv4_address = ipv4_address


class CaaRecord(_serialization.Model):
    """A CAA record.

    :ivar flags: The flags for this CAA record as an integer between 0 and 255.
    :vartype flags: int
    :ivar tag: The tag for this CAA record.
    :vartype tag: str
    :ivar value: The value for this CAA record.
    :vartype value: str
    """

    _attribute_map = {
        "flags": {"key": "flags", "type": "int"},
        "tag": {"key": "tag", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, flags: Optional[int] = None, tag: Optional[str] = None, value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword flags: The flags for this CAA record as an integer between 0 and 255.
        :paramtype flags: int
        :keyword tag: The tag for this CAA record.
        :paramtype tag: str
        :keyword value: The value for this CAA record.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.flags = flags
        self.tag = tag
        self.value = value


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.dns.v2018_05_01.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.dns.v2018_05_01.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CnameRecord(_serialization.Model):
    """A CNAME record.

    :ivar cname: The canonical name for this CNAME record.
    :vartype cname: str
    """

    _attribute_map = {
        "cname": {"key": "cname", "type": "str"},
    }

    def __init__(self, *, cname: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cname: The canonical name for this CNAME record.
        :paramtype cname: str
        """
        super().__init__(**kwargs)
        self.cname = cname


class DnsResourceReference(_serialization.Model):
    """Represents a single Azure resource and its referencing DNS records.

    :ivar dns_resources: A list of dns Records.
    :vartype dns_resources: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
    :ivar target_resource: A reference to an azure resource from where the dns resource value is
     taken.
    :vartype target_resource: ~azure.mgmt.dns.v2018_05_01.models.SubResource
    """

    _attribute_map = {
        "dns_resources": {"key": "dnsResources", "type": "[SubResource]"},
        "target_resource": {"key": "targetResource", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        dns_resources: Optional[List["_models.SubResource"]] = None,
        target_resource: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dns_resources: A list of dns Records.
        :paramtype dns_resources: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
        :keyword target_resource: A reference to an azure resource from where the dns resource value is
         taken.
        :paramtype target_resource: ~azure.mgmt.dns.v2018_05_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.dns_resources = dns_resources
        self.target_resource = target_resource


class DnsResourceReferenceRequest(_serialization.Model):
    """Represents the properties of the Dns Resource Reference Request.

    :ivar target_resources: A list of references to azure resources for which referencing dns
     records need to be queried.
    :vartype target_resources: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
    """

    _attribute_map = {
        "target_resources": {"key": "properties.targetResources", "type": "[SubResource]"},
    }

    def __init__(self, *, target_resources: Optional[List["_models.SubResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword target_resources: A list of references to azure resources for which referencing dns
         records need to be queried.
        :paramtype target_resources: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
        """
        super().__init__(**kwargs)
        self.target_resources = target_resources


class DnsResourceReferenceResult(_serialization.Model):
    """Represents the properties of the Dns Resource Reference Result.

    :ivar dns_resource_references: The result of dns resource reference request. A list of dns
     resource references for each of the azure resource in the request.
    :vartype dns_resource_references: list[~azure.mgmt.dns.v2018_05_01.models.DnsResourceReference]
    """

    _attribute_map = {
        "dns_resource_references": {"key": "properties.dnsResourceReferences", "type": "[DnsResourceReference]"},
    }

    def __init__(
        self, *, dns_resource_references: Optional[List["_models.DnsResourceReference"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword dns_resource_references: The result of dns resource reference request. A list of dns
         resource references for each of the azure resource in the request.
        :paramtype dns_resource_references:
         list[~azure.mgmt.dns.v2018_05_01.models.DnsResourceReference]
        """
        super().__init__(**kwargs)
        self.dns_resource_references = dns_resource_references


class MxRecord(_serialization.Model):
    """An MX record.

    :ivar preference: The preference value for this MX record.
    :vartype preference: int
    :ivar exchange: The domain name of the mail host for this MX record.
    :vartype exchange: str
    """

    _attribute_map = {
        "preference": {"key": "preference", "type": "int"},
        "exchange": {"key": "exchange", "type": "str"},
    }

    def __init__(self, *, preference: Optional[int] = None, exchange: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword preference: The preference value for this MX record.
        :paramtype preference: int
        :keyword exchange: The domain name of the mail host for this MX record.
        :paramtype exchange: str
        """
        super().__init__(**kwargs)
        self.preference = preference
        self.exchange = exchange


class NsRecord(_serialization.Model):
    """An NS record.

    :ivar nsdname: The name server name for this NS record.
    :vartype nsdname: str
    """

    _attribute_map = {
        "nsdname": {"key": "nsdname", "type": "str"},
    }

    def __init__(self, *, nsdname: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword nsdname: The name server name for this NS record.
        :paramtype nsdname: str
        """
        super().__init__(**kwargs)
        self.nsdname = nsdname


class PtrRecord(_serialization.Model):
    """A PTR record.

    :ivar ptrdname: The PTR target domain name for this PTR record.
    :vartype ptrdname: str
    """

    _attribute_map = {
        "ptrdname": {"key": "ptrdname", "type": "str"},
    }

    def __init__(self, *, ptrdname: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ptrdname: The PTR target domain name for this PTR record.
        :paramtype ptrdname: str
        """
        super().__init__(**kwargs)
        self.ptrdname = ptrdname


class RecordSet(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a DNS record set (a collection of DNS records with the same name and type).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the record set.
    :vartype id: str
    :ivar name: The name of the record set.
    :vartype name: str
    :ivar type: The type of the record set.
    :vartype type: str
    :ivar etag: The etag of the record set.
    :vartype etag: str
    :ivar metadata: The metadata attached to the record set.
    :vartype metadata: dict[str, str]
    :ivar ttl: The TTL (time-to-live) of the records in the record set.
    :vartype ttl: int
    :ivar fqdn: Fully qualified domain name of the record set.
    :vartype fqdn: str
    :ivar provisioning_state: provisioning State of the record set.
    :vartype provisioning_state: str
    :ivar target_resource: A reference to an azure resource from where the dns resource value is
     taken.
    :vartype target_resource: ~azure.mgmt.dns.v2018_05_01.models.SubResource
    :ivar a_records: The list of A records in the record set.
    :vartype a_records: list[~azure.mgmt.dns.v2018_05_01.models.ARecord]
    :ivar aaaa_records: The list of AAAA records in the record set.
    :vartype aaaa_records: list[~azure.mgmt.dns.v2018_05_01.models.AaaaRecord]
    :ivar mx_records: The list of MX records in the record set.
    :vartype mx_records: list[~azure.mgmt.dns.v2018_05_01.models.MxRecord]
    :ivar ns_records: The list of NS records in the record set.
    :vartype ns_records: list[~azure.mgmt.dns.v2018_05_01.models.NsRecord]
    :ivar ptr_records: The list of PTR records in the record set.
    :vartype ptr_records: list[~azure.mgmt.dns.v2018_05_01.models.PtrRecord]
    :ivar srv_records: The list of SRV records in the record set.
    :vartype srv_records: list[~azure.mgmt.dns.v2018_05_01.models.SrvRecord]
    :ivar txt_records: The list of TXT records in the record set.
    :vartype txt_records: list[~azure.mgmt.dns.v2018_05_01.models.TxtRecord]
    :ivar cname_record: The CNAME record in the  record set.
    :vartype cname_record: ~azure.mgmt.dns.v2018_05_01.models.CnameRecord
    :ivar soa_record: The SOA record in the record set.
    :vartype soa_record: ~azure.mgmt.dns.v2018_05_01.models.SoaRecord
    :ivar caa_records: The list of CAA records in the record set.
    :vartype caa_records: list[~azure.mgmt.dns.v2018_05_01.models.CaaRecord]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "fqdn": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "ttl": {"key": "properties.TTL", "type": "int"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "target_resource": {"key": "properties.targetResource", "type": "SubResource"},
        "a_records": {"key": "properties.ARecords", "type": "[ARecord]"},
        "aaaa_records": {"key": "properties.AAAARecords", "type": "[AaaaRecord]"},
        "mx_records": {"key": "properties.MXRecords", "type": "[MxRecord]"},
        "ns_records": {"key": "properties.NSRecords", "type": "[NsRecord]"},
        "ptr_records": {"key": "properties.PTRRecords", "type": "[PtrRecord]"},
        "srv_records": {"key": "properties.SRVRecords", "type": "[SrvRecord]"},
        "txt_records": {"key": "properties.TXTRecords", "type": "[TxtRecord]"},
        "cname_record": {"key": "properties.CNAMERecord", "type": "CnameRecord"},
        "soa_record": {"key": "properties.SOARecord", "type": "SoaRecord"},
        "caa_records": {"key": "properties.caaRecords", "type": "[CaaRecord]"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        ttl: Optional[int] = None,
        target_resource: Optional["_models.SubResource"] = None,
        a_records: Optional[List["_models.ARecord"]] = None,
        aaaa_records: Optional[List["_models.AaaaRecord"]] = None,
        mx_records: Optional[List["_models.MxRecord"]] = None,
        ns_records: Optional[List["_models.NsRecord"]] = None,
        ptr_records: Optional[List["_models.PtrRecord"]] = None,
        srv_records: Optional[List["_models.SrvRecord"]] = None,
        txt_records: Optional[List["_models.TxtRecord"]] = None,
        cname_record: Optional["_models.CnameRecord"] = None,
        soa_record: Optional["_models.SoaRecord"] = None,
        caa_records: Optional[List["_models.CaaRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword etag: The etag of the record set.
        :paramtype etag: str
        :keyword metadata: The metadata attached to the record set.
        :paramtype metadata: dict[str, str]
        :keyword ttl: The TTL (time-to-live) of the records in the record set.
        :paramtype ttl: int
        :keyword target_resource: A reference to an azure resource from where the dns resource value is
         taken.
        :paramtype target_resource: ~azure.mgmt.dns.v2018_05_01.models.SubResource
        :keyword a_records: The list of A records in the record set.
        :paramtype a_records: list[~azure.mgmt.dns.v2018_05_01.models.ARecord]
        :keyword aaaa_records: The list of AAAA records in the record set.
        :paramtype aaaa_records: list[~azure.mgmt.dns.v2018_05_01.models.AaaaRecord]
        :keyword mx_records: The list of MX records in the record set.
        :paramtype mx_records: list[~azure.mgmt.dns.v2018_05_01.models.MxRecord]
        :keyword ns_records: The list of NS records in the record set.
        :paramtype ns_records: list[~azure.mgmt.dns.v2018_05_01.models.NsRecord]
        :keyword ptr_records: The list of PTR records in the record set.
        :paramtype ptr_records: list[~azure.mgmt.dns.v2018_05_01.models.PtrRecord]
        :keyword srv_records: The list of SRV records in the record set.
        :paramtype srv_records: list[~azure.mgmt.dns.v2018_05_01.models.SrvRecord]
        :keyword txt_records: The list of TXT records in the record set.
        :paramtype txt_records: list[~azure.mgmt.dns.v2018_05_01.models.TxtRecord]
        :keyword cname_record: The CNAME record in the  record set.
        :paramtype cname_record: ~azure.mgmt.dns.v2018_05_01.models.CnameRecord
        :keyword soa_record: The SOA record in the record set.
        :paramtype soa_record: ~azure.mgmt.dns.v2018_05_01.models.SoaRecord
        :keyword caa_records: The list of CAA records in the record set.
        :paramtype caa_records: list[~azure.mgmt.dns.v2018_05_01.models.CaaRecord]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = etag
        self.metadata = metadata
        self.ttl = ttl
        self.fqdn = None
        self.provisioning_state = None
        self.target_resource = target_resource
        self.a_records = a_records
        self.aaaa_records = aaaa_records
        self.mx_records = mx_records
        self.ns_records = ns_records
        self.ptr_records = ptr_records
        self.srv_records = srv_records
        self.txt_records = txt_records
        self.cname_record = cname_record
        self.soa_record = soa_record
        self.caa_records = caa_records


class RecordSetListResult(_serialization.Model):
    """The response to a record set List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Information about the record sets in the response.
    :vartype value: list[~azure.mgmt.dns.v2018_05_01.models.RecordSet]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RecordSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.RecordSet"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Information about the record sets in the response.
        :paramtype value: list[~azure.mgmt.dns.v2018_05_01.models.RecordSet]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RecordSetUpdateParameters(_serialization.Model):
    """Parameters supplied to update a record set.

    :ivar record_set: Specifies information about the record set being updated.
    :vartype record_set: ~azure.mgmt.dns.v2018_05_01.models.RecordSet
    """

    _attribute_map = {
        "record_set": {"key": "RecordSet", "type": "RecordSet"},
    }

    def __init__(self, *, record_set: Optional["_models.RecordSet"] = None, **kwargs: Any) -> None:
        """
        :keyword record_set: Specifies information about the record set being updated.
        :paramtype record_set: ~azure.mgmt.dns.v2018_05_01.models.RecordSet
        """
        super().__init__(**kwargs)
        self.record_set = record_set


class Resource(_serialization.Model):
    """Common properties of an Azure Resource Manager resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class SoaRecord(_serialization.Model):
    """An SOA record.

    :ivar host: The domain name of the authoritative name server for this SOA record.
    :vartype host: str
    :ivar email: The email contact for this SOA record.
    :vartype email: str
    :ivar serial_number: The serial number for this SOA record.
    :vartype serial_number: int
    :ivar refresh_time: The refresh value for this SOA record.
    :vartype refresh_time: int
    :ivar retry_time: The retry time for this SOA record.
    :vartype retry_time: int
    :ivar expire_time: The expire time for this SOA record.
    :vartype expire_time: int
    :ivar minimum_ttl: The minimum value for this SOA record. By convention this is used to
     determine the negative caching duration.
    :vartype minimum_ttl: int
    """

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "int"},
        "refresh_time": {"key": "refreshTime", "type": "int"},
        "retry_time": {"key": "retryTime", "type": "int"},
        "expire_time": {"key": "expireTime", "type": "int"},
        "minimum_ttl": {"key": "minimumTTL", "type": "int"},
    }

    def __init__(
        self,
        *,
        host: Optional[str] = None,
        email: Optional[str] = None,
        serial_number: Optional[int] = None,
        refresh_time: Optional[int] = None,
        retry_time: Optional[int] = None,
        expire_time: Optional[int] = None,
        minimum_ttl: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host: The domain name of the authoritative name server for this SOA record.
        :paramtype host: str
        :keyword email: The email contact for this SOA record.
        :paramtype email: str
        :keyword serial_number: The serial number for this SOA record.
        :paramtype serial_number: int
        :keyword refresh_time: The refresh value for this SOA record.
        :paramtype refresh_time: int
        :keyword retry_time: The retry time for this SOA record.
        :paramtype retry_time: int
        :keyword expire_time: The expire time for this SOA record.
        :paramtype expire_time: int
        :keyword minimum_ttl: The minimum value for this SOA record. By convention this is used to
         determine the negative caching duration.
        :paramtype minimum_ttl: int
        """
        super().__init__(**kwargs)
        self.host = host
        self.email = email
        self.serial_number = serial_number
        self.refresh_time = refresh_time
        self.retry_time = retry_time
        self.expire_time = expire_time
        self.minimum_ttl = minimum_ttl


class SrvRecord(_serialization.Model):
    """An SRV record.

    :ivar priority: The priority value for this SRV record.
    :vartype priority: int
    :ivar weight: The weight value for this SRV record.
    :vartype weight: int
    :ivar port: The port value for this SRV record.
    :vartype port: int
    :ivar target: The target domain name for this SRV record.
    :vartype target: str
    """

    _attribute_map = {
        "priority": {"key": "priority", "type": "int"},
        "weight": {"key": "weight", "type": "int"},
        "port": {"key": "port", "type": "int"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        port: Optional[int] = None,
        target: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword priority: The priority value for this SRV record.
        :paramtype priority: int
        :keyword weight: The weight value for this SRV record.
        :paramtype weight: int
        :keyword port: The port value for this SRV record.
        :paramtype port: int
        :keyword target: The target domain name for this SRV record.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.priority = priority
        self.weight = weight
        self.port = port
        self.target = target


class SubResource(_serialization.Model):
    """A reference to a another resource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class TxtRecord(_serialization.Model):
    """A TXT record.

    :ivar value: The text value of this TXT record.
    :vartype value: list[str]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, *, value: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The text value of this TXT record.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.value = value


class Zone(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a DNS zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: The etag of the zone.
    :vartype etag: str
    :ivar max_number_of_record_sets: The maximum number of record sets that can be created in this
     DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
    :vartype max_number_of_record_sets: int
    :ivar max_number_of_records_per_record_set: The maximum number of records per record set that
     can be created in this DNS zone.  This is a read-only property and any attempt to set this
     value will be ignored.
    :vartype max_number_of_records_per_record_set: int
    :ivar number_of_record_sets: The current number of record sets in this DNS zone.  This is a
     read-only property and any attempt to set this value will be ignored.
    :vartype number_of_record_sets: int
    :ivar name_servers: The name servers for this DNS zone. This is a read-only property and any
     attempt to set this value will be ignored.
    :vartype name_servers: list[str]
    :ivar zone_type: The type of this DNS zone (Public or Private). Known values are: "Public" and
     "Private".
    :vartype zone_type: str or ~azure.mgmt.dns.v2018_05_01.models.ZoneType
    :ivar registration_virtual_networks: A list of references to virtual networks that register
     hostnames in this DNS zone. This is a only when ZoneType is Private.
    :vartype registration_virtual_networks: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
    :ivar resolution_virtual_networks: A list of references to virtual networks that resolve
     records in this DNS zone. This is a only when ZoneType is Private.
    :vartype resolution_virtual_networks: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "max_number_of_record_sets": {"readonly": True},
        "max_number_of_records_per_record_set": {"readonly": True},
        "number_of_record_sets": {"readonly": True},
        "name_servers": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "max_number_of_record_sets": {"key": "properties.maxNumberOfRecordSets", "type": "int"},
        "max_number_of_records_per_record_set": {"key": "properties.maxNumberOfRecordsPerRecordSet", "type": "int"},
        "number_of_record_sets": {"key": "properties.numberOfRecordSets", "type": "int"},
        "name_servers": {"key": "properties.nameServers", "type": "[str]"},
        "zone_type": {"key": "properties.zoneType", "type": "str"},
        "registration_virtual_networks": {"key": "properties.registrationVirtualNetworks", "type": "[SubResource]"},
        "resolution_virtual_networks": {"key": "properties.resolutionVirtualNetworks", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        zone_type: Union[str, "_models.ZoneType"] = "Public",
        registration_virtual_networks: Optional[List["_models.SubResource"]] = None,
        resolution_virtual_networks: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: The etag of the zone.
        :paramtype etag: str
        :keyword zone_type: The type of this DNS zone (Public or Private). Known values are: "Public"
         and "Private".
        :paramtype zone_type: str or ~azure.mgmt.dns.v2018_05_01.models.ZoneType
        :keyword registration_virtual_networks: A list of references to virtual networks that register
         hostnames in this DNS zone. This is a only when ZoneType is Private.
        :paramtype registration_virtual_networks: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
        :keyword resolution_virtual_networks: A list of references to virtual networks that resolve
         records in this DNS zone. This is a only when ZoneType is Private.
        :paramtype resolution_virtual_networks: list[~azure.mgmt.dns.v2018_05_01.models.SubResource]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.max_number_of_record_sets = None
        self.max_number_of_records_per_record_set = None
        self.number_of_record_sets = None
        self.name_servers = None
        self.zone_type = zone_type
        self.registration_virtual_networks = registration_virtual_networks
        self.resolution_virtual_networks = resolution_virtual_networks


class ZoneListResult(_serialization.Model):
    """The response to a Zone List or ListAll operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Information about the DNS zones.
    :vartype value: list[~azure.mgmt.dns.v2018_05_01.models.Zone]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Zone]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Zone"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Information about the DNS zones.
        :paramtype value: list[~azure.mgmt.dns.v2018_05_01.models.Zone]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ZoneUpdate(_serialization.Model):
    """Describes a request to update a DNS zone.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
