
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinTools_LocationSet.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Poly_Polygon3D.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Poly_Polygon3D.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>

// module includes
#include <BinTools.hxx>
#include <BinTools_Curve2dSet.hxx>
#include <BinTools_CurveSet.hxx>
#include <BinTools_FormatVersion.hxx>
#include <BinTools_IStream.hxx>
#include <BinTools_LocationSet.hxx>
#include <BinTools_LocationSetPtr.hxx>
#include <BinTools_ObjectType.hxx>
#include <BinTools_OStream.hxx>
#include <BinTools_ShapeReader.hxx>
#include <BinTools_ShapeSet.hxx>
#include <BinTools_ShapeSetBase.hxx>
#include <BinTools_ShapeWriter.hxx>
#include <BinTools_SurfaceSet.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinTools_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BinTools", R"#()#");

// user-defined inclusion per module in the body

// enums
    py::enum_<BinTools_FormatVersion>(m, "BinTools_FormatVersion",R"#(Defined BinTools format version)#")
        .value("BinTools_FormatVersion_VERSION_1",BinTools_FormatVersion::BinTools_FormatVersion_VERSION_1)
        .value("BinTools_FormatVersion_VERSION_2",BinTools_FormatVersion::BinTools_FormatVersion_VERSION_2)
        .value("BinTools_FormatVersion_VERSION_3",BinTools_FormatVersion::BinTools_FormatVersion_VERSION_3)
        .value("BinTools_FormatVersion_VERSION_4",BinTools_FormatVersion::BinTools_FormatVersion_VERSION_4)
        .value("BinTools_FormatVersion_CURRENT",BinTools_FormatVersion::BinTools_FormatVersion_CURRENT).export_values();
    m.attr("BinTools_FormatVersion_LOWER") = py::cast(int(BinTools_FormatVersion_LOWER));
    m.attr("BinTools_FormatVersion_UPPER") = py::cast(int(BinTools_FormatVersion_UPPER));
    py::enum_<BinTools_ObjectType>(m, "BinTools_ObjectType",R"#(Enumeration defining objects identifiers in the shape read/write format.)#")
        .value("BinTools_ObjectType_Unknown",BinTools_ObjectType::BinTools_ObjectType_Unknown)
        .value("BinTools_ObjectType_Reference8",BinTools_ObjectType::BinTools_ObjectType_Reference8)
        .value("BinTools_ObjectType_Reference16",BinTools_ObjectType::BinTools_ObjectType_Reference16)
        .value("BinTools_ObjectType_Reference32",BinTools_ObjectType::BinTools_ObjectType_Reference32)
        .value("BinTools_ObjectType_Reference64",BinTools_ObjectType::BinTools_ObjectType_Reference64)
        .value("BinTools_ObjectType_Location",BinTools_ObjectType::BinTools_ObjectType_Location)
        .value("BinTools_ObjectType_SimpleLocation",BinTools_ObjectType::BinTools_ObjectType_SimpleLocation)
        .value("BinTools_ObjectType_EmptyLocation",BinTools_ObjectType::BinTools_ObjectType_EmptyLocation)
        .value("BinTools_ObjectType_LocationEnd",BinTools_ObjectType::BinTools_ObjectType_LocationEnd)
        .value("BinTools_ObjectType_Curve",BinTools_ObjectType::BinTools_ObjectType_Curve)
        .value("BinTools_ObjectType_EmptyCurve",BinTools_ObjectType::BinTools_ObjectType_EmptyCurve)
        .value("BinTools_ObjectType_Curve2d",BinTools_ObjectType::BinTools_ObjectType_Curve2d)
        .value("BinTools_ObjectType_EmptyCurve2d",BinTools_ObjectType::BinTools_ObjectType_EmptyCurve2d)
        .value("BinTools_ObjectType_Surface",BinTools_ObjectType::BinTools_ObjectType_Surface)
        .value("BinTools_ObjectType_EmptySurface",BinTools_ObjectType::BinTools_ObjectType_EmptySurface)
        .value("BinTools_ObjectType_Polygon3d",BinTools_ObjectType::BinTools_ObjectType_Polygon3d)
        .value("BinTools_ObjectType_EmptyPolygon3d",BinTools_ObjectType::BinTools_ObjectType_EmptyPolygon3d)
        .value("BinTools_ObjectType_PolygonOnTriangulation",BinTools_ObjectType::BinTools_ObjectType_PolygonOnTriangulation)
        .value("BinTools_ObjectType_EmptyPolygonOnTriangulation",BinTools_ObjectType::BinTools_ObjectType_EmptyPolygonOnTriangulation)
        .value("BinTools_ObjectType_Triangulation",BinTools_ObjectType::BinTools_ObjectType_Triangulation)
        .value("BinTools_ObjectType_EmptyTriangulation",BinTools_ObjectType::BinTools_ObjectType_EmptyTriangulation)
        .value("BinTools_ObjectType_EmptyShape",BinTools_ObjectType::BinTools_ObjectType_EmptyShape)
        .value("BinTools_ObjectType_EndShape",BinTools_ObjectType::BinTools_ObjectType_EndShape).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BinTools , shared_ptr<BinTools>  >(m,"BinTools",R"#(Tool to keep shapes in binary format)#");
    py::class_<BinTools_Curve2dSet , shared_ptr<BinTools_Curve2dSet>  >(m,"BinTools_Curve2dSet",R"#(Stores a set of Curves from Geom2d in binary format)#");
    py::class_<BinTools_CurveSet , shared_ptr<BinTools_CurveSet>  >(m,"BinTools_CurveSet",R"#(Stores a set of Curves from Geom in binary format.)#");
    py::class_<BinTools_IStream , shared_ptr<BinTools_IStream>  >(m,"BinTools_IStream",R"#(Substitution of IStream for shape reader for fast management of position in the file (get and go) and operation on all reading types.)#");
    py::class_<BinTools_LocationSet , shared_ptr<BinTools_LocationSet>  >(m,"BinTools_LocationSet",R"#(The class LocationSet stores a set of location in a relocatable state.)#");
    py::class_<BinTools_OStream , shared_ptr<BinTools_OStream>  >(m,"BinTools_OStream",R"#(Substitution of OStream for shape writer for fast management of position in the file and operation on all writing types.)#");
    py::class_<BinTools_ShapeSetBase , shared_ptr<BinTools_ShapeSetBase>  >(m,"BinTools_ShapeSetBase",R"#(A base class for all readers/writers of TopoDS_Shape into/from stream.)#");
    py::class_<BinTools_SurfaceSet , shared_ptr<BinTools_SurfaceSet>  >(m,"BinTools_SurfaceSet",R"#(Stores a set of Surfaces from Geom in binary format.)#");
    py::class_<BinTools_ShapeReader , shared_ptr<BinTools_ShapeReader>  , BinTools_ShapeSetBase >(m,"BinTools_ShapeReader",R"#(Reads topology from IStream in binary format without grouping of objects by types and using relative positions in a file as references.)#");
    py::class_<BinTools_ShapeSet , shared_ptr<BinTools_ShapeSet>  , BinTools_ShapeSetBase >(m,"BinTools_ShapeSet",R"#(Writes topology in OStream in binary format)#");
    py::class_<BinTools_ShapeWriter , shared_ptr<BinTools_ShapeWriter>  , BinTools_ShapeSetBase >(m,"BinTools_ShapeWriter",R"#(Writes topology in OStream in binary format without grouping of objects by types and using relative positions in a file as references.)#");

};

// user-defined post-inclusion per module

// user-defined post
