---
title: "Python-TUF reaches version 1.0.0"
author: Jussi Kukkonen and Lukas Pühringer
---

The Python-TUF community is proud to announce the release of Python-TUF 1.0.0.
The release, which is available on [PyPI](https://pypi.org/project/tuf/) and
[GitHub](https://github.com/theupdateframework/python-tuf/), introduces new
stable and more ergonomic APIs.

<img align="right" src="../../../tuf-icon-200.png" width="200"/>

Python-TUF is the reference implementation of [The Update
Framework](https://theupdateframework.io/) specification, an open source
framework for securing content delivery and updates. It protects against
various types of supply chain attacks and provides resilience to compromise.

For the past 7 releases the project has introduced new designs and
implementations, which have gradually formed two new stable APIs:
- [`ngclient`](https://theupdateframework.readthedocs.io/en/latest/api/tuf.ngclient.html):
  A client API that offers a robust internal design providing implementation
  safety and flexibility to application developers.
- [`Metadata API`](https://theupdateframework.readthedocs.io/en/latest/api/tuf.api.html):
  A low-level interface for both consuming and creating TUF metadata. Metadata
  API is a flexible and easy-to-use building block for any higher level tool or
  library.

Python-TUF 1.0.0 is the result of a comprehensive rewrite of the project,
removing several hard to maintain modules and replacing them with safer and
easier to use APIs:
- The project was reduced from 4700 lines of hard to maintain code to 1400
  lines of modern, maintainable code
- The implementation details are now easier to reason about, which should
  accelerate future improvements on the project
- Metadata API provides a solid base to build other tools on top of – as proven
  by the ngclient implementation and the [repository code
  examples](https://github.com/theupdateframework/python-tuf/tree/develop/examples/repository)
- Both new APIs are highly extensible and allow application developers to
  include custom network stacks, file storage systems or public-key
  cryptography algorithms, while providing easy-to-use default implementations

With this foundation laid, Python-TUF developers are currently planning next
steps. At the very least, you can expect improved repository side tooling, but
we're also open to new ideas. Pop in to
[#tuf](https://cloud-native.slack.com/archives/C8NMD3QJ3) on CNCF Slack or
[Github issues](https://github.com/theupdateframework/python-tuf/issues/new)
and let’s talk.
