% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_edge_bundle_force.R
\name{geom_edge_bundle_force}
\alias{geom_edge_bundle_force}
\alias{geom_edge_bundle_force2}
\alias{geom_edge_bundle_force0}
\title{Bundle edges using force directed edge bundling}
\usage{
geom_edge_bundle_force(
  mapping = NULL,
  data = get_edges(),
  position = "identity",
  arrow = NULL,
  n = 100,
  force = 1,
  n_cycle = 6,
  cuts_start = 1,
  step = 0.04,
  cuts_new = 2,
  n_iter = 50,
  iter_new = 2/3,
  threshold = 0.6,
  eps = 1e-08,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  label_colour = "black",
  label_alpha = 1,
  label_parse = FALSE,
  check_overlap = FALSE,
  angle_calc = "rot",
  force_flip = TRUE,
  label_dodge = NULL,
  label_push = NULL,
  show.legend = NA,
  ...
)

geom_edge_bundle_force2(
  mapping = NULL,
  data = get_edges("long"),
  position = "identity",
  arrow = NULL,
  n = 100,
  force = 1,
  n_cycle = 6,
  cuts_start = 1,
  step = 0.04,
  cuts_new = 2,
  n_iter = 50,
  iter_new = 2/3,
  threshold = 0.6,
  eps = 1e-08,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  label_colour = "black",
  label_alpha = 1,
  label_parse = FALSE,
  check_overlap = FALSE,
  angle_calc = "rot",
  force_flip = TRUE,
  label_dodge = NULL,
  label_push = NULL,
  show.legend = NA,
  ...
)

geom_edge_bundle_force0(
  mapping = NULL,
  data = get_edges(),
  position = "identity",
  arrow = NULL,
  force = 1,
  n_cycle = 6,
  cuts_start = 1,
  step = 0.04,
  cuts_new = 2,
  n_iter = 50,
  iter_new = 2/3,
  threshold = 0.6,
  eps = 1e-08,
  lineend = "butt",
  show.legend = NA,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x, y, xend, yend, group and
circular are mapped to x, y, xend, yend, edge.id and circular in the edge
data.}

\item{data}{The return of a call to \code{get_edges()} or a data.frame
giving edges in correct format (see details for for guidance on the format).
See \code{\link[=get_edges]{get_edges()}} for more details on edge extraction.}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{n}{The number of points to create along the path.}

\item{force}{The spring force during bundling}

\item{n_cycle}{number of iteration cycles}

\item{cuts_start}{initial number of edge divisions}

\item{step}{initial step size}

\item{cuts_new}{factor for how many new division points to add after a cycle}

\item{n_iter}{number of iteration steps per cycle}

\item{iter_new}{factor of how to decrease the number of iterations per cycle}

\item{threshold}{threshold for considering two edges to be interacting}

\item{eps}{tolerance}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{label_colour}{The colour of the edge label. If \code{NA} it will use
the colour of the edge.}

\item{label_alpha}{The opacity of the edge label. If \code{NA} it will use
the opacity of the edge.}

\item{label_parse}{If \code{TRUE}, the labels will be parsed into expressions
and displayed as described in \code{\link[grDevices:plotmath]{grDevices::plotmath()}}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{angle_calc}{Either 'none', 'along', or 'across'. If 'none' the label will
use the angle aesthetic of the geom. If 'along' The label will be written
along the edge direction. If 'across' the label will be written across the
edge direction.}

\item{force_flip}{Logical. If \code{angle_calc} is either 'along' or 'across'
should the label be flipped if it is on it's head. Default to \code{TRUE}.}

\item{label_dodge}{A \code{\link[grid:unit]{grid::unit()}} giving a fixed vertical shift
to add to the label in case of \code{angle_calc} is either 'along' or 'across'}

\item{label_push}{A \code{\link[grid:unit]{grid::unit()}} giving a fixed horizontal shift
to add to the label in case of \code{angle_calc} is either 'along' or 'across'}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}
}
\description{
This geom performs force directed edge bundling to reduce visual clutter.
It uses a self-organizing approach to bundling in which edges are modeled as
flexible springs that can attract each other without the need of a hierarchy.
Be aware that this bundling technique works globally and thus may bundle
edges that is otherwise unrelated together. Care should be taken when
interpreting the resulting visual. An alternative approach to edge bundling
that uses the graph topology is provided by \code{\link[=geom_edge_bundle_path]{geom_edge_bundle_path()}}.
}
\section{Aesthetics}{

\code{geom_edge_bundle_force} and \code{geom_edge_bundle_force0} understand the following
aesthetics. Bold aesthetics are automatically set, but can be overwritten.
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{xend}
\item \strong{yend}
\item edge_colour
\item edge_width
\item edge_linetype
\item edge_alpha
\item filter
}

\code{geom_edge_bundle_force2} understand the following aesthetics. Bold aesthetics are
automatically set, but can be overwritten.
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{group}
\item edge_colour
\item edge_width
\item edge_linetype
\item edge_alpha
\item filter
}

\code{geom_edge_bundle_force} and \code{geom_edge_bundle_force2} furthermore takes the following
aesthetics.
\itemize{
\item start_cap
\item end_cap
\item label
\item label_pos
\item label_size
\item angle
\item hjust
\item vjust
\item family
\item fontface
\item lineheight
}
}

\section{Computed variables}{


\describe{
\item{index}{The position along the path (not computed for the *0 version)}
}
}

\section{Edge variants}{

Many geom_edge_* layers comes in 3 flavors depending on the level of control
needed over the drawing. The default (no numeric postfix) generate a number
of points (\code{n}) along the edge and draws it as a path. Each point along
the line has a numeric value associated with it giving the position along the
path, and it is therefore possible to show the direction of the edge by
mapping to this e.g. \code{colour = after_stat(index)}. The version postfixed with a
"2" uses the "long" edge format (see \code{\link[=get_edges]{get_edges()}}) and makes it
possible to interpolate node parameter between the start and end node along
the edge. It is considerable less performant so should only be used if this
is needed. The version postfixed with a "0" draws the edge in the most
performant way, often directly using an appropriate grob from the grid
package, but does not allow for gradients along the edge.

Often it is beneficial to stop the drawing of the edge before it reaches the
node, for instance in cases where an arrow should be drawn and the arrowhead
shouldn't lay on top or below the node point. geom_edge_* and geom_edge_*2
supports this through the start_cap and end_cap aesthetics that takes a
\code{\link[=geometry]{geometry()}} specification and dynamically caps the termini of the
edges based on the given specifications. This means that if
\code{end_cap = circle(1, 'cm')} the edges will end at a distance of 1cm even
during resizing of the plot window.

All \verb{geom_edge_*} and \code{geom_edge_*2} have the ability to draw a
label along the edge. The reason this is not a separate geom is that in order
for the label to know the location of the edge it needs to know the edge type
etc. Labels are drawn by providing a label aesthetic. The label_pos can be
used to specify where along the edge it should be drawn by supplying a number
between 0 and 1. The label_size aesthetic can be used to control the size of
the label. Often it is needed to have the label written along the direction
of the edge, but since the actual angle is dependent on the plot dimensions
this cannot be calculated beforehand. Using the angle_calc argument allows
you to specify whether to use the supplied angle aesthetic or whether to draw
the label along or across the edge.
}

\section{Edge aesthetic name expansion}{

In order to avoid excessive typing edge aesthetic names are
automatically expanded. Because of this it is not necessary to write
\code{edge_colour} within the \code{aes()} call as \code{colour} will
automatically be renamed appropriately.
}

\examples{
# (not necessarily an insightful use)
ggraph(highschool) +
  geom_edge_bundle_force(n_cycle = 2, threshold = 0.4)

}
\references{
Holten, D. and Wijk, J.J.V. (2009). \emph{Force‐Directed Edge Bundling for Graph
Visualization.} Computer Graphics Forum (Blackwell Publishing Ltd) 28, no. 3:
983-990. https://doi.org/10.1111/j.1467-8659.2009.01450.x
}
\seealso{
Other geom_edge_*: 
\code{\link{geom_edge_arc}()},
\code{\link{geom_edge_bend}()},
\code{\link{geom_edge_bundle_minimal}()},
\code{\link{geom_edge_bundle_path}()},
\code{\link{geom_edge_density}()},
\code{\link{geom_edge_diagonal}()},
\code{\link{geom_edge_elbow}()},
\code{\link{geom_edge_fan}()},
\code{\link{geom_edge_hive}()},
\code{\link{geom_edge_link}()},
\code{\link{geom_edge_loop}()},
\code{\link{geom_edge_parallel}()},
\code{\link{geom_edge_point}()},
\code{\link{geom_edge_sf}()},
\code{\link{geom_edge_span}()},
\code{\link{geom_edge_tile}()}
}
\author{
David Schoch
}
\concept{geom_edge_*}
