% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-client-credentials.R
\name{oauth_flow_client_credentials}
\alias{oauth_flow_client_credentials}
\title{OAuth flow: client credentials}
\usage{
oauth_flow_client_credentials(client, scope = NULL, token_params = list())
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
An \link{oauth_token}.
}
\description{
This function implements the OAuth client credentials flow, as defined
by \href{https://datatracker.ietf.org/doc/html/rfc6749#section-4.4}{rfc6749},
Section 4.4. It is used to allow the client to access resources that it
controls directly, not on behalf of an user.
}
\seealso{
Other OAuth flows: 
\code{\link{oauth_flow_auth_code}()},
\code{\link{oauth_flow_bearer_jwt}()},
\code{\link{oauth_flow_device}()},
\code{\link{oauth_flow_password}()},
\code{\link{oauth_flow_refresh}()}
}
\concept{OAuth flows}
\keyword{internal}
