% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{graph_center}
\alias{graph_center}
\title{Central vertices of a graph}
\usage{
graph_center(graph, ..., weights = NULL, mode = c("all", "out", "in", "total"))
}
\arguments{
\item{graph}{The input graph, it can be directed or undirected.}

\item{...}{These dots are for future extensions and must be empty.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is
\code{NULL} and the graph has a \code{weight} edge attribute, then the
attribute is used. If this is \code{NA} then no weights are used (even if
the graph has a \code{weight} attribute). In a weighted graph, the length
of a path is the sum of the weights of its constituent edges.}

\item{mode}{Character constant, gives whether the shortest paths to or from
the given vertices should be calculated for directed graphs. If \code{out}
then the shortest paths \emph{from} the vertex, if \verb{in} then \emph{to}
it will be considered. If \code{all}, the default, then the graph is treated
as undirected, i.e. edge directions are not taken into account. This
argument is ignored for undirected graphs.}
}
\value{
The vertex IDs of the central vertices.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The center of a graph is the set of its vertices with minimal eccentricity.
}
\examples{
tree <- make_tree(100, 7)
graph_center(tree)
graph_center(tree, mode = "in")
graph_center(tree, mode = "out")

# Without and with weights
ring <- make_ring(10)
graph_center(ring)
# Add weights
E(ring)$weight <- seq_len(ecount(ring))
graph_center(ring)

}
\seealso{
\code{\link[=eccentricity]{eccentricity()}}, \code{\link[=radius]{radius()}}

Other paths: 
\code{\link{all_simple_paths}()},
\code{\link{diameter}()},
\code{\link{distance_table}()},
\code{\link{eccentricity}()},
\code{\link{radius}()}
}
\concept{paths}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/latest/igraph-Structural.html#igraph_graph_center_dijkstra}{\code{igraph_graph_center_dijkstra()}}.}

