% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{articulation_points}
\alias{articulation_points}
\alias{bridges}
\title{Articulation points and bridges of a graph}
\usage{
articulation_points(graph)

bridges(graph)
}
\arguments{
\item{graph}{The input graph. It is treated as an undirected graph, even if
it is directed.}
}
\value{
For \code{articulation_points()}, a numeric vector giving the vertex
IDs of the articulation points of the input graph. For \code{bridges()}, a
numeric vector giving the edge IDs of the bridges of the input graph.
}
\description{
\code{articulation_points()} finds the articulation points (or cut vertices)
}
\details{
Articulation points or cut vertices are vertices whose removal increases the
number of connected components in a graph. Similarly, bridges or cut-edges
are edges whose removal increases the number of connected components in a
graph. If the original graph was connected, then the removal of a single
articulation point or a single bridge makes it disconnected. If a graph
contains no articulation points, then its vertex connectivity is at least
two.
}
\examples{

g <- disjoint_union(make_full_graph(5), make_full_graph(5))
clu <- components(g)$membership
g <- add_edges(g, c(match(1, clu), match(2, clu)))
articulation_points(g)

g <- make_graph("krackhardt_kite")
bridges(g)

}
\seealso{
\code{\link[=biconnected_components]{biconnected_components()}}, \code{\link[=components]{components()}},
\code{\link[=is_connected]{is_connected()}}, \code{\link[=vertex_connectivity]{vertex_connectivity()}},
\code{\link[=edge_connectivity]{edge_connectivity()}}

Connected components
\code{\link{biconnected_components}()},
\code{\link{component_distribution}()},
\code{\link{decompose}()},
\code{\link{is_biconnected}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{components}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_articulation_points}{\code{articulation_points()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_bridges}{\code{bridges()}}.}

