% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merData.R
\name{wiggle}
\alias{wiggle}
\title{Assign an observation to different values}
\usage{
wiggle(data, varlist, valueslist)
}
\arguments{
\item{data}{a data frame with one or more observations to be reassigned}

\item{varlist}{a character vector specifying the name(s) of the variable to adjust}

\item{valueslist}{a list of vectors with the values to assign to var}
}
\value{
a \code{data.frame} with each row assigned to the one of the new variable combinations.
All variable combinations are returned, eg wiggling two variables with 3 and 4 variables
respectively will return a new dataset with \code{3 * 4 = 12} observations.
}
\description{
Creates a new data.frame with copies of the original observation,
each assigned to a different user-specified value of a variable. Allows the
user to look at the effect on predicted values of changing either a single variable
or multiple variables.
}
\details{
If the variable specified is a factor, then wiggle will return it
as a character.
}
\examples{
data(iris)
wiggle(iris[3,], varlist = "Sepal.Width", valueslist = list(c(1, 2, 3, 5)))
wiggle(iris[3:5,], "Sepal.Width", valueslist = list(c(1, 2, 3, 5)))
wiggle(iris[3,], c("Sepal.Width", "Petal.Length"), list(c(1,2,3,5), c(3,5,6)))
wiggle(iris[3:5,], c("Sepal.Width", "Petal.Length"), list(c(1,2,3,5), c(3,5,6)))
}
