# ``PackageManagerDocs``

@Metadata {
    @DisplayName("Swift Package Manager")
}

Organize, manage, and edit Swift packages.

## Overview

The Swift Package Manager lets you share your code as a package, depend on and use other share packages, as well as build, test, document, and run your code.

## Topics

### Essentials

- <doc:GettingStarted>      <!-- tutorial or article based walk through -->
- <doc:IntroducingPackages>
- <doc:PackageSecurity>

### Guides

- <doc:CreatingSwiftPackage>
- <doc:SettingSwiftToolsVersion>
- <doc:AddingDependencies>
- <doc:ResolvingPackageVersions>
- <doc:CreatingCLanguageTargets>
- <doc:UsingBuildConfigurations>
- <doc:SwiftVersionSpecificPackaging>
- <doc:BundlingResources>
- <doc:ReleasingPublishingAPackage>
- <doc:ContinuousIntegration>
- <doc:Plugins>
- <doc:ModuleAliasing>
- <doc:PackageCollections>
- <doc:UsingShellCompletion>
- <doc:SwiftPMAsALibrary>

<!-- ### Command Plugins -->
<!-- placeholder for content about swift package manager extensions - command plugins -->
<!-- - <doc:swift-format> -->
<!-- - <doc:swift-docc-plugin> -->
<!-- - <doc:swift-container-plugin> -->

 ### Reference
- <doc:PackageDescription> <!-- redirect page to PackageDescription API reference docc -->
<!-- link to Command API reference docc - the DocC Plugin API (PackagePlugin) -->

<!-- reference content for the CLI commands `swift ...` -->
### Swift Commands

- <doc:SwiftBuild>
- <doc:SwiftTest>
- <doc:SwiftPackageCommands>
- <doc:SwiftSDKCommands>
- <doc:SwiftPackageRegistryCommands>
- <doc:SwiftPackageCollectionCommands>
- <doc:SwiftRun>
