#
# Copyright 2024 Ettus Research, a National Instruments Brand
#
# SPDX-License-Identifier: LGPL-3.0-or-later
#
# Description:
#   Clock definition constraints for X440 200 MHz BW type images
#

# Data clocks: Generated by the MMCM, used for data paths between the RFDC output and RFNoC.
# The RFDC block diagram is set up for the maximum required clock frequencies (rfdc_clk_1x @ 256 MHz), 
# which are used in the 1600 MHz bitfile.
# This is not required for the 200 MHz bitfile, hence we multiply the output clock divider values by 8
# to allow Vivado to auto-derive the correct clock periods. 

set data_clock_mmcm [get_cells -hierarchical -filter { PRIMITIVE_TYPE == CLOCK.PLL.MMCME4_ADV && NAME =~  "*data_clock_mmcm*" }]

set_property -dict [ list \   
   CLKOUT1_DIVIDE {32} \
   CLKOUT2_DIVIDE {32} \
   CLKOUT3_DIVIDE {16} \
   CLKOUT4_DIVIDE {16} \
   CLKOUT5_DIVIDE {32} \
   CLKOUT6_DIVIDE {16} \
] $data_clock_mmcm
