// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SABDL_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SABDL_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sabdl_8H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0022, 0x0028, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0001,
  0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028,
  0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a,
  0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076,
  0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b,
  0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c,
  0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d, 0x007d,
  0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e, 0x007e, 0x007e,
  0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f,
  0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0086,
  0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0x0082, 0x0087, 0x00b1,
  0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3,
  0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb,
  0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc,
  0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd,
  0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002,
  0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001,
  0x0022, 0x0028, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0028, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0001, 0x0027,
  0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028, 0x0049,
  0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a, 0x0075,
  0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076, 0x007a,
  0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b, 0x007b,
  0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c, 0x007c,
  0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d, 0x007d, 0x007d,
  0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e, 0x007e, 0x007e, 0x007e,
  0x0089, 0x0085, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007f,
  0x005d, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0085,
  0x0058, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0086, 0x00b0,
  0x0057, 0x007e, 0x007e, 0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2,
  0x0056, 0x007d, 0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa,
  0x0055, 0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb,
  0x0054, 0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc,
  0x0053, 0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003,
  0x004d, 0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002,
  0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028,
  0x0028, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0001, 0x0027,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022,
  0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e,
  0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053,
  0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054,
  0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055,
  0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056,
  0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057,
  0x00b1, 0x0086, 0x0082, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058,
  0x0085, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089,
  0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab,
  0x007e, 0x007e, 0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3,
  0x007d, 0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4,
  0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5,
  0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a,
  0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029,
  0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a,
  0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028, 0x0049,
  0x0001, 0x0001, 0x00ff, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x00ff, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c,
  0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031,
  0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032,
  0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033,
  0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034,
  0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035,
  0x00b2, 0x0087, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036,
  0x0086, 0x0082, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c,
  0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089,
  0x007f, 0x007f, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1,
  0x007e, 0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2,
  0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3,
  0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c,
  0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b,
  0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076,
  0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a, 0x0075,
  0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e,
  0x0001, 0x00ff, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00ff, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005,
  0x00fe, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006,
  0x00fd, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007,
  0x00fc, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008,
  0x00d5, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009,
  0x00b3, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a,
  0x0087, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010,
  0x0082, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b,
  0x0081, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085,
  0x007f, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086,
  0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087,
  0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078,
  0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077,
  0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b,
  0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076, 0x007a,
  0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053,
  0x00fe, 0x00fe, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031,
  0x00ff, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001,
  0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002,
  0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003,
  0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004,
  0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005,
  0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b,
  0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036,
  0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058,
  0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080,
  0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081,
  0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082,
  0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d,
  0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c,
  0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c,
  0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b, 0x007b,
  0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054,
  0x00fd, 0x00fd, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032,
  0x00fe, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006,
  0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001,
  0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002,
  0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003,
  0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004,
  0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a,
  0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035,
  0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057,
  0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f,
  0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080,
  0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081,
  0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e,
  0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d,
  0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d, 0x007d,
  0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c, 0x007c,
  0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055,
  0x00fc, 0x00fc, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033,
  0x00fd, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007,
  0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002,
  0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001,
  0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002,
  0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003,
  0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009,
  0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034,
  0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056,
  0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e,
  0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f,
  0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080,
  0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0x007f,
  0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e, 0x007e,
  0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e, 0x007e, 0x007e,
  0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d, 0x007d, 0x007d,
  0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056,
  0x00fb, 0x00d5, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034,
  0x00fc, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008,
  0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003,
  0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002,
  0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002,
  0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008,
  0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033,
  0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055,
  0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d,
  0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e,
  0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f,
  0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0x0080,
  0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0x007f, 0x007f,
  0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f,
  0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e, 0x007e, 0x007e, 0x007e,
  0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057,
  0x00d4, 0x00b3, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035,
  0x00d5, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009,
  0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004,
  0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003,
  0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002,
  0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007,
  0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032,
  0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054,
  0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c,
  0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d,
  0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e,
  0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0x0081,
  0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x0089, 0x0085, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007f,
  0x00b1, 0x0086, 0x0082, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058,
  0x00b2, 0x0087, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036,
  0x00b3, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a,
  0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005,
  0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004,
  0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003,
  0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002,
  0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006,
  0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031,
  0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053,
  0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b,
  0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c,
  0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d,
  0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0x0082,
  0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081,
  0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0086,
  0x005d, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0085,
  0x0085, 0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e,
  0x0086, 0x0082, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c,
  0x0087, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010,
  0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b,
  0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a,
  0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009,
  0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008,
  0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007,
  0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b,
  0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d,
  0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075,
  0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076,
  0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077,
  0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0x0088,
  0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0x0082, 0x0087,
  0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0x0082, 0x0087, 0x00b1,
  0x0058, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0086, 0x00b0,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089,
  0x0081, 0x0081, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067,
  0x0082, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b,
  0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036,
  0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035,
  0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034,
  0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033,
  0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032,
  0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031,
  0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a,
  0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b,
  0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c,
  0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0x00b3,
  0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0x0088, 0x00b2,
  0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3,
  0x0057, 0x007e, 0x007e, 0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2,
  0x007f, 0x007f, 0x007f, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089,
  0x0081, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d,
  0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058,
  0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057,
  0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056,
  0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055,
  0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054,
  0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053,
  0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028,
  0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029,
  0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a,
  0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x00d5,
  0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4,
  0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb,
  0x0056, 0x007d, 0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa,
  0x007e, 0x007e, 0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3,
  0x007f, 0x007f, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085,
  0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080,
  0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f,
  0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e,
  0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d,
  0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c,
  0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b,
  0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001,
  0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002,
  0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x00fd,
  0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc,
  0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc,
  0x0055, 0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb,
  0x007d, 0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4,
  0x007e, 0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2,
  0x007f, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086,
  0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081,
  0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080,
  0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f,
  0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e,
  0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d,
  0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c,
  0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076,
  0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b,
  0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029,
  0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001,
  0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x00fe,
  0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd,
  0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd,
  0x0054, 0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc,
  0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5,
  0x007d, 0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3,
  0x007e, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087,
  0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082,
  0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081,
  0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080,
  0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f,
  0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e,
  0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d,
  0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077,
  0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c,
  0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a,
  0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002,
  0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x00ff,
  0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe,
  0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002,
  0x0053, 0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003,
  0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a,
  0x007c, 0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c,
  0x007d, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078,
  0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d,
  0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e,
  0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0x007f,
  0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0x0080,
  0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0x0081,
  0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0x0082,
  0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0x0088,
  0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0x00b3,
  0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x00d5,
  0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x00fd,
  0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x00fe,
  0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x00ff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x00ff, 0x0001,
  0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x00ff, 0x0001, 0x0001,
  0x004d, 0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe, 0x0002, 0x0002,
  0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd, 0x00fd, 0x0003, 0x0029,
  0x0076, 0x004c, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0x002a, 0x004b,
  0x0077, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0x004c, 0x0077,
  0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0x0078, 0x007c,
  0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0x007d, 0x007d,
  0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0x007e, 0x007e,
  0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0x007f, 0x007f,
  0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
  0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0x0081, 0x0081,
  0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0x0082, 0x0087,
  0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0x0088, 0x00b2,
  0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0x00b3, 0x00d4,
  0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0x00d5, 0x00fc,
  0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0x00fd, 0x00fd,
  0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0x00fe, 0x00fe,
  0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0x00ff, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_sabdl_8H = 361;

#endif  // VIXL_SIM_SABDL_8H_TRACE_AARCH64_H_
