//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_45.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot45(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[45] = {1.363218446064655e-02,1.227143121292312e-01,3.410102265774382e-01,6.687841220517716e-01,1.106434494095849e+00,
    1.654496824492952e+00,2.313647229019849e+00,3.084707128763795e+00,3.968649024354158e+00,4.966603473575368e+00,6.079867397224717e+00,7.309913866697611e+00,
    8.658403560798874e+00,1.012719812017698e+01,1.171837567746325e+01,1.343424890213575e+01,1.527738597453940e+01,1.725063499764410e+01,1.935715247368910e+01,
    2.160043662350283e+01,2.398436651943605e+01,2.651324825285741e+01,2.919186968405330e+01,3.202556575438580e+01,3.502029691808950e+01,3.818274403277209e+01,
    4.152042411998880e+01,4.504183289995902e+01,4.875662211598719e+01,5.267582270425613e+01,5.681212932830451e+01,6.118026849586888e+01,6.579748277683728e+01,
    7.068417992710489e+01,7.586482229702409e+01,8.136917686847987e+01,8.723412564031283e+01,9.350638338661895e+01,1.002467601066914e+02,1.075372213306839e+02,
    1.154934331557267e+02,1.242892479663152e+02,1.342113040590704e+02,1.458087842455116e+02,1.604975908002699e+02};
  constexpr double aw[45] = {2.303579701819461e-01,2.066143037039248e-01,1.661949726099588e-01,1.198565559023908e-01,7.746762760551308e-02,
    4.484998813239049e-02,2.324322817375528e-02,1.077378662464251e-02,4.462299859503526e-03,1.649605536181237e-03,5.435922495296234e-04,1.594421436848044e-04,
    4.155792110254414e-05,9.607776074179279e-06,1.966140849465943e-06,3.553304582949643e-07,5.656785290092850e-08,7.910416614910463e-09,9.686384924880712e-10,
    1.035023372624045e-10,9.613782869159589e-12,7.729303108601910e-13,5.353372486198366e-14,3.177312959963773e-15,1.606474294270389e-16,6.873779799095932e-18,
    2.470550592287988e-19,7.396342358359291e-21,1.826917938282980e-22,3.682672905315781e-24,5.982751013848978e-26,7.719967821375217e-28,7.778849187290817e-30,
    5.998718551613889e-32,3.456007258807920e-34,1.444559003928653e-36,4.224614459802521e-39,8.256641293693982e-42,1.015984453644589e-44,7.264422087503349e-48,
    2.695943873799329e-51,4.384966299824010e-55,2.368390700183081e-59,2.506289389600479e-64,1.360224249235594e-70};
  constexpr double x[17280] = {  5.958695215714654e-04, -3.273044131107183e-06,  1.347978524364530e-08, -4.932792901140093e-11,  1.691444332854027e-13,
 -5.564640611969447e-16,  1.778602356083645e-18, -5.564426112115111e-21,  1.712103014232476e-23, -5.197654583738223e-26,  1.560393438154406e-28, -4.640016047792100e-31,
  5.358657599207876e-03, -2.936515053736232e-05,  1.203670354456164e-07, -4.369956538030501e-10,  1.480641854518110e-12, -4.789565460273694e-15,  1.496364552222974e-17,
 -4.543940452252456e-20,  1.345839477990497e-22, -3.894485602385265e-25,  1.101410430080640e-27, -3.041718099246496e-30,  1.486202339298491e-02, -8.105925375107369e-05,
  3.291138966840169e-07, -1.175837713487621e-09,  3.887403681680451e-12, -1.213723685985272e-14,  3.609198660267549e-17, -1.024294939704786e-19,  2.766067994413815e-22,
 -7.044198151338909e-25,  1.659415596312691e-27, -3.461857827991439e-30,  2.906163962809649e-02, -1.573840890105812e-04,  6.298769380586870e-07, -2.195718223049173e-09,
  6.984749538759799e-12, -2.058112936078278e-14,  5.615577625524856e-17, -1.398633979782543e-19,  3.056695023850451e-22, -5.206676565392571e-25,  3.156153214830529e-28,
  2.617739453432792e-30,  4.789124879748393e-02, -2.569049924258078e-04,  1.008412033461741e-06, -3.398349458655726e-09,  1.023181911605231e-11, -2.760188967102121e-14,
  6.496578035287175e-17, -1.218833239970680e-19,  1.149442586522338e-22,  4.041122812591039e-25, -3.136799064923538e-27,  1.335336051867835e-29,  7.126294264268969e-02,
 -3.777501551123481e-04,  1.446675841433754e-06, -4.665015111804531e-09,  1.302209182772949e-11, -3.068734295517663e-14,  5.419785081615774e-17, -2.903171519061996e-20,
 -3.032841457963348e-22,  1.825938626064102e-24, -6.878781821532515e-27,  1.972955150811960e-29,  9.906753377880982e-02, -5.176449256026720e-04,  1.923589185489632e-06,
 -5.865952119637291e-09,  1.476371797579131e-11, -2.785913995909007e-14,  2.012526430000231e-17,  1.307780600973132e-19, -8.287492099000190e-22,  3.024632087869097e-24,
 -7.799914305212529e-27,  1.143928174917326e-29,  1.311750185780428e-01, -6.739535708587576e-04,  2.415931182110231e-06, -6.870691432862185e-09,  1.495998079348254e-11,
 -1.812221093446841e-14, -3.468341352141598e-17,  3.200942515208716e-19, -1.241511732430669e-21,  3.110814309990587e-24, -3.445696418886746e-27, -1.383374244688003e-29,
  1.674351301871414e-01, -8.437277749156502e-04,  2.899327504443141e-06, -7.558582934914138e-09,  1.328008849368429e-11, -1.752990764380436e-15, -1.011917642918791e-16,
  4.800652776882334e-19, -1.301824127092149e-21,  1.505185294389172e-24,  5.929972953855587e-27, -4.476654654638429e-29,  2.076779803034648e-01, -1.023761033474467e-03,
  3.349292142249125e-06, -7.828710777332795e-09,  9.611517509288566e-12,  1.963138602468969e-14, -1.653858964468535e-16,  5.471034208577257e-19, -8.534600603120221e-22,
 -1.643473371963167e-24,  1.657705513680680e-26, -6.005486101701735e-29,  2.517147880704808e-01, -1.210647994579905e-03,  3.742279592424567e-06, -7.608444449074767e-09,
  4.087185770301723e-12,  4.324408655444616e-14, -2.111681955792671e-16,  4.734087963667345e-19,  9.021653961559208e-23, -5.335072780232757e-24,  2.252608374642113e-26,
 -4.108682029001951e-29,  2.993386941749169e-01, -1.400847701701566e-03,  4.056703701062604e-06, -6.859965654811057e-09, -2.916397397670924e-12,  6.551990731632073e-14,
 -2.240450105028213e-16,  2.451122795223040e-19,  1.315361936288269e-21, -8.005103617627390e-24,  1.858062619961171e-26,  1.350107864687728e-29,  3.503256579330574e-01,
 -1.590749617802822e-03,  4.273880425739645e-06, -5.584255247102985e-09, -1.081050082245187e-11,  8.266844808173474e-14, -1.947789444255432e-16, -1.079307422508778e-19,
  2.451727643672600e-21, -8.148326869984873e-24,  3.572791545269107e-27,  8.142766187819248e-29,  4.044354348420169e-01, -1.776741248883495e-03,  4.378854577316021e-06,
 -3.822208130375435e-09, -1.885209028873021e-11,  9.130100896927825e-14, -1.221414073447091e-16, -5.145382669838521e-19,  3.084071116797620e-21, -5.031931860886557e-24,
 -1.797261797388729e-26,  1.248911864236782e-28,  4.614126317427065e-01, -1.955276144397682e-03,  4.361075048335831e-06, -1.652754338632975e-09, -2.622215006866573e-11,
  8.902758486147143e-14, -1.406506223585380e-17, -8.772103993961307e-19,  2.896521568367135e-21,  8.240005845640197e-25, -3.700245314843442e-26,  1.108738201384987e-28,
  5.209878363945810e-01, -2.122941031035088e-03,  4.214888988275544e-06,  8.119136355924179e-10, -3.211574633161319e-11,  7.492188999164366e-14,  1.131721586540441e-16,
 -1.096413484008903e-18,  1.799687097215656e-21,  7.652233948994728e-24, -4.376333614650515e-26,  3.275258611718966e-29,  5.828788178985858e-01, -2.276520836525012e-03,
  3.939832630202485e-06,  3.433689837524065e-09, -3.583362175180169e-11,  4.977110525451540e-14,  2.376698153830846e-16, -1.097823735822058e-18, -7.911112607680751e-24,
  1.299098577314556e-23, -3.264222907915023e-26, -8.031671162653200e-29,  6.467917940249752e-01, -2.413060382007121e-03,  3.540704738437893e-06,  6.057966022519248e-09,
 -3.686472218307872e-11,  1.606027508954799e-14,  3.360394744978383e-16, -8.549297575164269e-19, -2.072580847402848e-21,  1.460519674063655e-23, -5.609943926372355e-27,
 -1.740650017755314e-28,  7.124227611084530e-01, -2.529921565427556e-03,  3.027417614518737e-06,  8.524429648303095e-09, -3.494989566714843e-11, -2.231621622364945e-14,
  3.881173843250671e-16, -4.002630428321067e-19, -3.809101687588019e-21,  1.141807804913645e-23,  2.768611265096121e-26, -1.962386367489152e-28,  7.794588817665487e-01,
 -2.624834924330922e-03,  2.414629914235935e-06,  1.067846023347047e-08, -3.011899671802690e-11, -6.057876490434498e-14,  3.812576874694631e-16,  1.786074358741717e-19,
 -4.679316611169889e-21,  4.058424083229546e-24,  5.359752564787650e-26, -1.261024809230724e-28,  8.475799252811397e-01, -2.695944553918982e-03,  1.721174812872672e-06,
  1.238227994182536e-08, -2.269656449125502e-11, -9.374509784190897e-14,  3.132616867641071e-16,  7.580654706369275e-19, -4.368005906114249e-21, -5.236897274157888e-24,
  6.044565286129703e-26,  1.071318956040455e-29,  9.164597550610325e-01, -2.741845464523402e-03,  9.693059204278896e-07,  1.352502120860183e-08, -1.327479722954252e-11,
 -1.173660701816048e-13,  1.932637907709717e-16,  1.207951270048291e-18, -2.896042369893846e-21, -1.337019930647855e-23,  4.403650505899029e-26,  1.519447661192412e-28,
  9.857678571796624e-01, -2.761612590457845e-03,  1.837914109977146e-07,  1.403094448397926e-08, -2.656312893882872e-12, -1.281982951302605e-13,  4.031859008656324e-17,
  1.423995819393625e-18, -6.296084298714911e-22, -1.751240523676801e-23,  1.000986712271923e-26,  2.293252438233464e-28,  1.055170903561060e+00, -2.754820807903934e-03,
 -6.091062698313551e-07,  1.386516863437086e-08,  8.227271331023236e-12, -1.247049954624277e-13, -1.200745326978666e-16,  1.354533583634638e-18,  1.821696636082177e-21,
 -1.617522096782683e-23, -2.827172453443407e-26,  2.041172028209782e-28,  1.124334342974660e+00, -2.721555480937325e-03, -1.382722340853071e-06,  1.303645652577290e-08,
  1.841201165841392e-11, -1.073024119776968e-13, -2.608211533796771e-16,  1.014181660976271e-18,  3.787299967452670e-21, -9.793800105971574e-24, -5.545756196479442e-26,
  8.797958545707612e-29,  1.192924012601255e+00, -2.662413229474602e-03, -2.111106823926225e-06,  1.159681606094829e-08,  2.700273816839877e-11, -7.830921481335092e-14,
 -3.584583300986412e-16,  4.806037774367531e-19,  4.739959332237625e-21, -5.769888074199414e-25, -6.094149380022444e-26, -6.272450560236694e-29,  1.260607762554955e+00,
 -2.578492797867716e-03, -2.770118737047392e-06,  9.637916483717950e-09,  3.326710795054207e-11, -4.160418044264730e-14, -3.976652128047511e-16, -1.249368173163369e-19,
  4.454909432803965e-21,  8.322347022507581e-24, -4.343790979792785e-26, -1.763144866446456e-28,  1.327057085396198e+00, -2.471376094760868e-03, -3.338449560295516e-06,
  7.284563050273693e-09,  3.671182930289912e-11, -2.045018468239346e-15, -3.741094481367801e-16, -6.680805494307563e-19,  3.071621298424203e-21,  1.398694525296197e-23,
 -1.126900440626282e-26, -2.027021947135677e-28,  1.391948742356017e+00, -2.343099669995052e-03, -3.798530667813167e-06,  4.685701413167521e-09,  3.713225431249245e-11,
  3.525937065743127e-14, -2.950362228419667e-16, -1.034734773927867e-18,  1.038925595458409e-21,  1.479371176351936e-23,  2.169203671823196e-26, -1.376116356898698e-28,
  1.454966377719121e+00, -2.196117088868885e-03, -4.137283940868231e-06,  2.003618197560056e-09,  3.462958625945421e-11,  6.570653286658126e-14, -1.774954441871982e-16,
 -1.158354799133061e-18, -1.036115748817238e-21,  1.093625438148526e-23,  4.239060579155666e-26, -2.146545732290595e-29,  1.515802112590509e+00, -2.033252853819071e-03,
 -4.346681190983121e-06, -5.978496329777236e-10,  2.959371836809556e-11,  8.586626348010072e-14, -4.461588187570031e-17, -1.033975850013193e-18, -2.582948786852643e-21,
  4.224961851345109e-24,  4.419494108847453e-26,  8.509735666874899e-29,  1.574158109104473e+00, -1.857648704344896e-03, -4.424086081779043e-06, -2.965199327493488e-09,
  2.265376755900665e-11,  9.394821413967133e-14,  7.924282115481385e-17, -7.156183364009561e-19, -3.239777153017821e-21, -2.720270854446039e-24,  2.915920847569348e-26,
  1.341714310706930e-28,  1.629748096033185e+00, -1.672703293540617e-03, -4.372361613936463e-06, -4.966328053676716e-09,  1.460220462087933e-11,  8.999831045210651e-14,
  1.733947256811293e-16, -2.983907378065821e-19, -2.947159373545357e-21, -7.525605287415274e-24,  6.125445858903961e-27,  1.133496937240223e-28,  1.682298846721290e+00,
 -1.482006389797537e-03, -4.199736529051487e-06, -6.499923201174499e-09,  6.301640739100978e-12,  7.579678345607970e-14,  2.247298185181517e-16,  1.091427053782817e-19,
 -1.936195084212620e-21, -8.925138697146479e-24, -1.408086125399905e-26,  4.686075949109109e-29,  1.731551600319565e+00, -1.289268881196247e-03, -3.919434740430152e-06,
 -7.502445332926463e-09, -1.414585074674276e-12,  5.448103404079583e-14,  2.298010074383147e-16,  4.142127603509769e-19, -6.224097356178712e-22, -7.095878598232554e-24,
 -2.378453286171430e-26, -2.306761749096294e-29,  1.777263417421325e+00, -1.098249964270460e-03, -3.549082623086378e-06, -7.952155979341873e-09, -7.836130994923823e-12,
  2.996287800714209e-14,  1.947109992379580e-16,  5.624668364965399e-19,  5.511696794634037e-22, -3.378064219978444e-24, -2.141504181904323e-26, -6.168631306435772e-29,
  1.819208461427926e+00, -9.126829750760072e-04, -3.109919191023145e-06, -7.869872263853985e-09, -1.245250975519803e-11,  6.243878847488053e-15,  1.329237582821340e-16,
  5.479982427932405e-19,  1.263018982581838e-21,  4.387860584727165e-25, -1.111123613897322e-26, -5.870513105791642e-29,  1.857179197298257e+00, -7.362013662652446e-04,
 -2.625843369709649e-06, -7.316387911448599e-09, -1.500398074220768e-11, -1.325154656220221e-14,  6.159680031181351e-17,  4.087885210765759e-19,  1.402395672742911e-21,
  2.913005715346144e-24,  3.711168378744650e-28, -2.840812521507336e-29,  1.890987499805079e+00, -5.722663471275444e-04, -2.122340285109701e-06, -6.386765040774898e-09,
 -1.550059143275240e-11, -2.621060929426790e-14, -2.646472592481853e-18,  2.099881816425550e-19,  1.072730657709000e-21,  3.477720240146599e-24,  7.488893677207517e-27,
  4.266569066686425e-30,  1.920465664131643e+00, -4.240976826529178e-04, -1.625334346934861e-06, -5.201951837714500e-09, -1.420743369555588e-11, -3.174476807106376e-14,
 -4.748583451633183e-17,  2.097788849012681e-20,  5.168965712287187e-22,  2.501176692901970e-24,  8.383665954182161e-27,  2.080175992031175e-29,  1.945467312972153e+00,
 -2.946090902410606e-04, -1.160020588485442e-06, -3.898397122333022e-09, -1.159838100753169e-11, -3.043189527812189e-14, -6.734157762244836e-17, -1.062902050712651e-19,
  1.027258996082854e-24,  9.177423205058927e-25,  4.912230642501932e-27,  1.827035009167656e-29,  1.965868197907209e+00, -1.863495700801941e-04, -7.497269944891544e-07,
 -2.616495790515841e-09, -8.284496547757045e-12, -2.408860393605068e-14, -6.395937621604080e-17, -1.510035309792612e-19, -2.934813778501028e-22, -3.370535052648609e-25,
  6.460011112510886e-28,  6.444167298205414e-30,  1.981566908051974e+00, -1.014518069820960e-04, -4.148590925401616e-07, -1.488794461141819e-09, -4.926450816461986e-12,
 -1.532204935612591e-14, -4.509328326801045e-17, -1.254828494778285e-19, -3.275142528297984e-22, -7.863103169231033e-25, -1.658826876457029e-27, -2.676523056146877e-30,
  1.992485602693366e+00, -4.158806261071439e-05, -1.719721484714605e-07, -6.288992944535591e-10, -2.142235952853352e-12, -6.949844423270134e-15, -2.171108998723984e-17,
 -6.568005104399281e-20, -1.929020331950362e-22, -5.502454354586895e-25, -1.522009750206151e-27, -4.066984000128930e-30,  1.998572348770904e+00, -7.925672240397323e-06,
 -3.297656888279834e-08, -1.218462985750220e-10, -4.215769527731863e-13, -1.398279518087209e-15, -4.501433413668513e-18, -1.416825985575137e-20, -4.380176259576178e-23,
 -1.334134842000262e-25, -4.011833150438793e-28, -1.192723973269487e-30,  5.829893365433045e-04, -3.167528413480317e-06,  1.290372806553181e-08, -4.670838491239138e-11,
  1.584297092832378e-13, -5.155870290271955e-16,  1.630195712051017e-18, -5.045325820944901e-21,  1.535747321626725e-23, -4.612468332393389e-26,  1.369974715744115e-28,
 -4.030593457876850e-31,  5.243090217081166e-03, -2.842279446607566e-05,  1.152621301499994e-07, -4.140526260012519e-10,  1.388341224886950e-12, -4.445231609079819e-15,
  1.374958724733447e-17, -4.134879269657707e-20,  1.213255850156114e-22, -3.479570844404603e-25,  9.758385849146970e-28, -2.674298871686396e-30,  1.454296430548068e-02,
 -7.848174356164542e-05,  3.153691741301076e-07, -1.115535105957275e-09,  3.653093782615031e-12, -1.130446826227427e-14,  3.334415792948645e-17, -9.397130471840019e-20,
  2.524064756335660e-22, -6.410106859895172e-25,  1.512978868996884e-27, -3.195826518353593e-30,  2.844201706996872e-02, -1.524485989430389e-04,  6.041855054036999e-07,
 -2.087183295829325e-09,  6.586292766849561e-12, -1.927929675851258e-14,  5.237374180357748e-17, -1.303792304705476e-19,  2.871783765380582e-22, -5.059668148432824e-25,
  4.140946972469128e-28,  1.885150893818713e-30,  4.687950902014791e-02, -2.489980752875417e-04,  9.685961486092176e-07, -3.238973092456230e-09,  9.695098880595513e-12,
 -2.608323549659126e-14,  6.160656319059971e-17, -1.179954425700064e-19,  1.273698491134913e-22,  2.897852688338121e-25, -2.594028268150670e-27,  1.136515901853885e-29,
  6.977473923411720e-02, -3.663971732843143e-04,  1.391925755391924e-06, -4.461501238789067e-09,  1.242128119207891e-11, -2.939738698653252e-14,  5.325860453073853e-17,
 -3.773650778683181e-20, -2.422990899423513e-22,  1.567576896111548e-24, -6.053307106780317e-27,  1.780743107948422e-29,  9.702729130466592e-02, -5.025338042586332e-04,
  1.854596778231184e-06, -5.634162658713862e-09,  1.421164677620032e-11, -2.733509046169830e-14,  2.343171610421393e-17,  1.059410554242830e-19, -7.253551849319200e-22,
  2.722904762944425e-24, -7.282267197405107e-27,  1.201571957850618e-29,  1.285173427289363e-01, -6.549518733006704e-04,  2.334906944044838e-06, -6.634273553242077e-09,
  1.458991576349546e-11, -1.885144799767183e-14, -2.626033212581315e-17,  2.821300006905224e-19, -1.132136868451233e-21,  2.962242603499792e-24, -3.949223145973794e-27,
 -9.209340435547013e-30,  1.641060389702352e-01, -8.208923581764051e-04,  2.809897825596661e-06, -7.346509465411616e-09,  1.322180733265364e-11, -4.024946957885418e-15,
 -8.832470294493449e-17,  4.393159503434200e-19, -1.243822655973948e-21,  1.705167128047294e-24,  4.121633642263349e-27, -3.755650980695346e-29,  2.036359335902542e-01,
 -9.973398316568355e-04,  3.256282590822929e-06, -7.671995986383528e-09,  9.965677280001509e-12,  1.584281492832423e-14, -1.504573623548258e-16,  5.189689517484530e-19,
 -9.013131486661267e-22, -1.031773880414515e-24,  1.404484353898249e-26, -5.498931815415983e-29,  2.469314959777760e-01, -1.181073787495148e-03,  3.651398290315887e-06,
 -7.536401275719795e-09,  4.902461780849068e-12,  3.833527010206449e-14, -1.978999866013929e-16,  4.733930345316542e-19, -8.607111122615221e-23, -4.471051910531058e-24,
  2.065684066143560e-26, -4.358059692554349e-29,  2.937996882789667e-01, -1.368724046000518e-03,  3.974146442401916e-06, -6.896434567015413e-09, -1.659190668942018e-12,
  6.022968001016581e-14, -2.166348798497690e-16,  2.827373017008959e-19,  1.040665478397937e-21, -7.253690578214890e-24,  1.890306618845484e-26,  1.558779565616755e-30,
  3.440306131576102e-01, -1.556829435103581e-03,  4.205885290693839e-06, -5.744251171773909e-09, -9.204078922567769e-12,  7.796608424134653e-14, -1.967464942316176e-16,
 -3.413460844602981e-20,  2.161777532923725e-21, -7.938816420901545e-24,  6.779872212986840e-27,  6.456412759867094e-29,  3.973982339743345e-01, -1.741898868304543e-03,
  4.331238008918461e-06, -4.109397385912403e-09, -1.705649411228272e-11,  8.820771025610697e-14, -1.351949757268111e-16, -4.188745868101390e-19,  2.891274646952608e-21,
 -5.644356340242891e-24, -1.273593738839512e-26,  1.129121789643236e-28,  4.536611688654653e-01, -1.920473873481993e-03,  4.338783346297017e-06, -2.058090829349206e-09,
 -2.444690928948085e-11,  8.840577192977004e-14, -3.732683326903324e-17, -7.843231332906925e-19,  2.900729571216825e-21, -5.574836874492617e-25, -3.205319678745075e-26,
  1.134331506078606e-28,  5.125635600185314e-01, -2.089191567968644e-03,  4.221598738510225e-06,  3.101864555460922e-10, -3.059259921051956e-11,  7.727637707890361e-14,
  8.331786425373822e-17, -1.034750469558353e-18,  2.044061856908288e-21,  5.936678947085665e-24, -4.187013400593628e-26,  5.256230086865898e-29,  5.738360191771003e-01,
 -2.244847027502560e-03,  3.977630704865436e-06,  2.868614741423004e-09, -3.478364710267459e-11,  5.510670640310044e-14,  2.069956797407906e-16, -1.090852467967910e-18,
  4.354901734885981e-22,  1.162336627355142e-23, -3.552550310789580e-26, -5.105208680762480e-29,  6.371966500578472e-01, -2.384453961717360e-03,  3.609873314041375e-06,
  5.471130039517670e-09, -3.646484286569116e-11,  2.383095554180511e-14,  3.112515747845115e-16, -9.128976468916840e-19, -1.552618542806276e-21,  1.423426992145370e-23,
 -1.276691518391294e-26, -1.508150796229598e-28,  7.023521479238645e-01, -2.505302588912334e-03,  3.126342480022034e-06,  7.962162774728819e-09, -3.530404916224367e-11,
 -1.314927405950755e-14,  3.752667622621804e-16, -5.153806275064636e-19, -3.380195936015116e-21,  1.235312694970940e-23,  1.908504887153347e-26, -1.936809998675348e-28,
  7.689989760278135e-01, -2.605013600135431e-03,  2.539841645717465e-06,  1.018736224141892e-08, -3.123875191066774e-11, -5.138533919958151e-14,  3.841872110158099e-16,
  3.160944022767605e-20, -4.496026176105928e-21,  6.084211014538771e-24,  4.752642228206359e-26, -1.488055072536780e-28,  8.368246180157848e-01, -2.681587119248263e-03,
  1.867522772466401e-06,  1.200455111810138e-08, -2.449464665849979e-11, -8.598805957734426e-14,  3.325056400950168e-16,  6.157397038977242e-19, -4.513004130813010e-21,
 -2.821078865285096e-24,  6.006627562211523e-26, -2.756993077116315e-29,  9.055089046686851e-01, -2.733445603589600e-03,  1.130255180092508e-06,  1.329410920340054e-08,
 -1.557305165315528e-11, -1.123327719443742e-13,  2.257191364851098e-16,  1.107929135443598e-18, -3.344141012319207e-21, -1.148485269081566e-23,  4.998109110006878e-26,
  1.176803161825156e-28,  9.747254125557663e-01, -2.759469690804457e-03,  3.518233351247498e-07,  1.396799783394885e-08, -5.207386938824262e-12, -1.267550423209649e-13,
  7.981429579931123e-17,  1.393858056916936e-18, -1.250441149391813e-21, -1.691305839799758e-23,  1.987313849305300e-26,  2.177545903430738e-28,  1.044142931290104e+00,
 -2.759026082654720e-03, -4.420172051587241e-07,  1.397670860591086e-08,  5.707457349734166e-12, -1.271256191221916e-13, -8.142046512734535e-17,  1.403310613635318e-18,
  1.221251001030424e-21, -1.712068928219336e-23, -1.887133102166520e-26,  2.220023981743934e-28,  1.113426995116608e+00, -2.731986666944164e-03, -1.224589203760437e-06,
  1.331355011268222e-08,  1.620573584555887e-11, -1.132080006316624e-13, -2.307833657129304e-16,  1.129314151204117e-18,  3.395830031007605e-21, -1.192335623244867e-23,
 -5.074390583402232e-26,  1.258948014768354e-28,  1.182241473540518e+00, -2.678738214193204e-03, -1.969405953297533e-06,  1.201586785090892e-08,  2.535170231953517e-11,
 -8.673362830872030e-14, -3.428844275541597e-16,  6.314749053448043e-19,  4.674742645213235e-21, -3.059037192122796e-24, -6.288658948062076e-26, -2.507885431311140e-29,
  1.250250214632289e+00, -2.600182145731604e-03, -2.651299237921164e-06,  1.016301409046306e-08,  3.233938571715123e-11, -5.117375089345823e-14, -3.991250810925909e-16,
  2.206371679414013e-20,  4.721411480183889e-21,  6.434441550888947e-24, -5.082652021567934e-26, -1.583513407280250e-28,  1.317118733540196e+00, -2.497724052907875e-03,
 -3.247513414913787e-06,  7.871131123069808e-09,  3.657968682336531e-11, -1.123655158978799e-14, -3.913646421033590e-16, -5.618368274685051e-19,  3.564858561325056e-21,
  1.335463664403268e-23, -2.041414746413728e-26, -2.119837243341943e-28,  1.382515937624897e+00, -2.373252850650465e-03, -3.738715556228477e-06,  5.285064477509815e-09,
  3.776430777818677e-11,  2.783508496257335e-14, -3.234621714752290e-16, -9.928128724492028e-19,  1.585580064305136e-21,  1.553172697158368e-23,  1.499926973018951e-26,
 -1.663481436242457e-28,  1.446115878523050e+00, -2.229109669159702e-03, -4.109873495928658e-06,  2.567962078740811e-09,  3.589847308471892e-11,  6.105406382736883e-14,
 -2.103320514992855e-16, -1.184886336385762e-18, -6.121969505507736e-22,  1.260415867080695e-23,  4.078021870107333e-26, -5.226284889611372e-29,  1.507599520375132e+00,
 -2.068046820548734e-03, -4.350957933635223e-06, -1.106797256067545e-10,  3.129794314004633e-11,  8.443887940046628e-14, -7.469902762335231e-17, -1.113848389404751e-18,
 -2.398168176354756e-21,  6.063096665552794e-24,  4.758987034911278e-26,  6.835203080850578e-29,  1.566656512442759e+00, -1.893177417304124e-03, -4.457431390604696e-06,
 -2.587611024179298e-09,  2.455006619778860e-11,  9.559779690065235e-14,  5.774103765753369e-17, -8.206213472265394e-19, -3.315278005733149e-21, -1.434618635500363e-24,
  3.514677302808588e-26,  1.373663812044309e-28,  1.622986953421703e+00, -1.707916460147489e-03, -4.430495615863007e-06, -4.718069978945604e-09,  1.644305268204467e-11,
  9.404861925833759e-14,  1.636791241830670e-16, -3.969772397546263e-19, -3.212422830290776e-21, -7.175786416484883e-24,  1.148989574869465e-26,  1.304178864213616e-28,
  1.676303133957602e+00, -1.515914447177669e-03, -4.277079672291369e-06, -6.386675507074551e-09,  7.871721643056531e-12,  8.121966910148256e-14,  2.268693459072092e-16,
  4.193922547346046e-20, -2.267093439942812e-21, -9.441837297529374e-24, -1.161882318008844e-26,  6.542769144181498e-29,  1.726331243221543e+00, -1.320984776485361e-03,
 -4.009562945760215e-06, -7.516058168434700e-09, -2.688853748099146e-13,  6.013294042487563e-14,  2.410804024399949e-16,  3.900229780929202e-19, -8.952066881062463e-22,
 -8.064867987357478e-24, -2.459331925363583e-26, -1.322885508951887e-29,  1.772813024931501e+00, -1.127026412949899e-03, -3.645240150741302e-06, -8.072480722593460e-09,
 -7.188857318705562e-12,  3.482680546472531e-14,  2.106875029893292e-16,  5.779878340102715e-19,  4.134813362901686e-22, -4.289487961197987e-24, -2.416690209849592e-26,
 -6.315620138461179e-29,  1.815507367942474e+00, -9.379434589124500e-04, -3.205548402243223e-06, -8.067934767474716e-09, -1.229446396258950e-11,  9.622754933763990e-15,
  1.488352747757330e-16,  5.885766186389338e-19,  1.270171168240598e-21, -5.969145559181833e-26, -1.387182003145179e-26, -6.682764131856423e-29,  1.854191816506396e+00,
 -7.575634005262400e-04, -2.715088881778388e-06, -7.558487544403843e-09, -1.525327468968142e-11, -1.163070241114599e-14,  7.368692298148071e-17,  4.553433645005467e-19,
  1.507210044653461e-21,  2.900660237810948e-24, -1.044733489611127e-27, -3.614549813995614e-29,  1.888663985573095e+00, -5.895558901435823e-04, -2.200486826923894e-06,
 -6.638969581809356e-09, -1.602494197321782e-11, -2.619957185530871e-14,  3.733015329097662e-18,  2.463768625564669e-19,  1.203358388901987e-21,  3.780200513009638e-24,
  7.612964380081830e-27,  1.221742062021471e-30,  1.918742867183365e+00, -4.373539641917877e-04, -1.689142834120302e-06, -5.434411626837678e-09, -1.485366805801934e-11,
 -3.287542487302979e-14, -4.665287567731343e-17,  3.902579369934590e-20,  6.131995409110967e-22,  2.855242856428713e-24,  9.329625068805720e-27,  2.217099615367932e-29,
  1.944270015488103e+00, -3.040795796024709e-04, -1.207935170795647e-06, -4.088929146526588e-09, -1.222342180410065e-11, -3.208377101200580e-14, -7.031199662498517e-17,
 -1.056891715534179e-19,  3.780367559662307e-23,  1.131099053126448e-24,  5.775724343999344e-27,  2.103296006752642e-29,  1.965110601911085e+00, -1.924752683808700e-04,
 -7.819364282611071e-07, -2.752986771724370e-09, -8.781966884240291e-12, -2.567543839954219e-14, -6.832073997838427e-17, -1.605835100487519e-19, -3.050778549342896e-22,
 -3.050998647571404e-25,  9.631560061314826e-28,  8.020494750743292e-30,  1.981154348007234e+00, -1.048435055287380e-04, -4.332078716949388e-07, -1.570129219986575e-09,
 -5.244005019936086e-12, -1.644766130291390e-14, -4.875787758961170e-17, -1.364292575023632e-19, -3.570442633236690e-22, -8.550292423165018e-25, -1.777291283528169e-27,
 -2.699859948787330e-30,  1.992316450255420e+00, -4.299462040365499e-05, -1.797292750005401e-07, -6.643159941303987e-10, -2.286596149453429e-12, -7.493695346150146e-15,
 -2.363961529852712e-17, -7.218196642647104e-20, -2.138512187978029e-22, -6.148568903865394e-25, -1.712446564151227e-27, -4.600330791306635e-30,  1.998540109031784e+00,
 -8.195450246924900e-06, -3.448013810723225e-08, -1.288212622008014e-10, -4.506558585786377e-13, -1.511237393693936e-15, -4.918512603653224e-18, -1.564996525939947e-20,
 -4.890661355393540e-23, -1.505619625104493e-25, -4.575651334973452e-28, -1.374653612871332e-30,  5.705221925220618e-04, -3.066498268666669e-06,  1.235810316830577e-08,
 -4.425392476498601e-11,  1.484980534993030e-13, -4.781035261106627e-16,  1.495564454482126e-18, -4.579430595027604e-21,  1.379149549056111e-23, -4.098347512841565e-26,
  1.204445832359700e-28, -3.506395544638977e-31,  5.131212289658863e-03, -2.752020096429885e-05,  1.104239025640856e-07, -3.925328598919220e-10,  1.302644933762053e-12,
 -4.128707306869027e-15,  1.264434417636274e-17, -3.765948803850159e-20,  1.094742701186173e-22, -3.111792955990468e-25,  8.653880142323605e-28, -2.353311260404628e-30,
  1.423399983783650e-02, -7.601135911685740e-05,  3.023261273529809e-07, -1.058851718030748e-09,  3.434798516342385e-12, -1.053489104024711e-14,  3.082265205241499e-17,
 -8.625210993251101e-20,  2.303862413713948e-22, -5.832277801401055e-25,  1.378028162485358e-27, -2.940247062868180e-30,  2.784173350740476e-02, -1.477135370932844e-04,
  5.797590835032721e-07, -1.984820226423770e-09,  6.212986125415298e-12, -1.806511265203118e-14,  4.884906464736980e-17, -1.214776113490533e-19,  2.692800328568330e-22,
 -4.879263049894428e-25,  4.836642636602158e-28,  1.298942633639718e-30,  4.589877176671834e-02, -2.414021788703404e-04,  9.306422432338804e-07, -3.087945608001589e-09,
  9.187954550827143e-12, -2.464385493227137e-14,  5.836118354234067e-17, -1.137717706006106e-19,  1.360501261754101e-22,  1.955010288613513e-25, -2.132702698260776e-27,
  9.645798321424532e-30,  6.833108699039780e-02, -3.554725849468231e-04,  1.339561005191706e-06, -4.267395246776224e-09,  1.184602561825917e-11, -2.813268558746042e-14,
  5.210159158835659e-17, -4.463238599625281e-20, -1.900408337310951e-22,  1.340571886606019e-24, -5.310184705298798e-27,  1.598964776312049e-29,  9.504640684246980e-02,
 -4.879636456184833e-04,  1.788333204877631e-06, -5.411118407300160e-09,  1.367079567482437e-11, -2.673966737447761e-14,  2.608744809354573e-17,  8.424290285378406e-20,
 -6.324456726036420e-22,  2.442266134063396e-24, -6.748363148604801e-27,  1.219590170802642e-29,  1.259343951065333e-01, -6.365871232854183e-04,  2.256683747604103e-06,
 -6.403882762702491e-09,  1.420720345140877e-11, -1.939089666766447e-14, -1.885207937334490e-17,  2.475766627611581e-19, -1.028426543393558e-21,  2.797331461879644e-24,
 -4.269064766875501e-27, -5.463328092390549e-30,  1.608668746362101e-01, -7.987622185401456e-04,  2.723005987201419e-06, -7.135715612908388e-09,  1.312108383339290e-11,
 -6.001569551536266e-15, -7.657165180602410e-17,  4.005245062914208e-19, -1.179849436731668e-21,  1.838935134083817e-24,  2.613705562480557e-27, -3.111160466561034e-29,
  1.996980955703780e-01, -9.716550932426853e-04,  3.165185178088544e-06, -7.510201614369284e-09,  1.024758385754952e-11,  1.240292209133531e-14, -1.363348578853281e-16,
  4.896364152741582e-19, -9.289137514237722e-22, -5.168227543595982e-25,  1.174125376625191e-26, -4.970084752930897e-29,  2.422650523912280e-01, -1.152222958348904e-03,
  3.561456588983310e-06, -7.452081806339592e-09,  5.622742622359321e-12,  3.374427613315107e-14, -1.847066237161323e-16,  4.682191294224607e-19, -2.326216683019620e-22,
 -3.683490724108505e-24,  1.871492954625780e-26, -4.444954856282802e-29,  2.883878537902917e-01, -1.337262264892970e-03,  3.891268789327485e-06, -6.913624604478382e-09,
 -5.059297486456997e-13,  5.512896960408204e-14, -2.082902339379700e-16,  3.120063551020131e-19,  7.931318647342701e-22, -6.499183020864206e-24,  1.875247853694419e-26,
 -8.032759118309375e-30,  3.378701496385347e-01, -1.523460463503185e-03,  4.136121311057693e-06, -5.879298606172237e-09, -7.692014527718184e-12,  7.324025406580702e-14,
 -1.967763478417803e-16,  3.052713102014731e-20,  1.881503729077065e-21, -7.615457612286131e-24,  9.275699505039124e-27,  4.913894531458335e-29,  3.904996196206661e-01,
 -1.707450721762812e-03,  4.280345452429642e-06, -4.368368154344729e-09, -1.532568348553109e-11,  8.483255279400185e-14, -1.456593661783398e-16, -3.296937761129045e-19,
  2.680070968247847e-21, -6.058209121913133e-24, -8.051563932313574e-27,  9.989746527553975e-29,  4.460485282792844e-01, -1.885868910606517e-03,  4.311797523245741e-06,
 -2.435152407031515e-09, -2.268947703703521e-11,  8.725685724734754e-14, -5.799307891323172e-17, -6.920585858692768e-19,  2.858784400625683e-21, -1.739871961524559e-24,
 -2.707431800965440e-26,  1.123317312333995e-28,  5.042743513087776e-01, -2.055412092180077e-03,  4.222435414205578e-06, -1.668319804241013e-10, -2.902938319987060e-11,
  7.893590702961816e-14,  5.529044325557103e-17, -9.662393809119216e-19,  2.228237813321557e-21,  4.312968660626263e-24, -3.920351531604940e-26,  6.792429554295974e-29,
  5.649204779287480e-01, -2.212897664043624e-03,  4.008752068120190e-06,  2.321153031441328e-09, -3.363429832175814e-11,  5.971002775473238e-14,  1.767078375363613e-16,
 -1.070499883696548e-18,  8.278860318537316e-22,  1.016555470492760e-23, -3.716839453345394e-26, -2.405786686807564e-29,  6.277169940384116e-01, -2.355322240583952e-03,
  3.672043268781503e-06,  4.891902592840780e-09, -3.591562084869795e-11,  3.098911511026636e-14,  2.850711277079494e-16, -9.544936043422919e-19, -1.050909662982458e-21,
  1.359821167023586e-23, -1.885170067354697e-26, -1.255298467385222e-28,  6.923815505931344e-01, -2.479919284793213e-03,  3.218492137281265e-06,  7.395678331126680e-09,
 -3.547820091127712e-11, -4.327846673162910e-15,  3.593895864962488e-16, -6.163007116835162e-19, -2.923777650743813e-21,  1.294817546448333e-23,  1.072891893485499e-26,
 -1.852461676827412e-28,  7.586203212385771e-01, -2.584214445373188e-03,  2.659058781037999e-06,  9.679821547845965e-09, -3.217426518998516e-11, -4.217026781421960e-14,
  3.830935234433804e-16, -1.084051178149541e-19, -4.244402097815427e-21,  7.849073655586619e-24,  4.059874825535449e-26, -1.650005960863258e-28,  8.261290526743543e-01,
 -2.666077509015710e-03,  2.009170567496458e-06,  1.159931783659212e-08, -2.613329467585416e-11, -7.781743202972626e-14,  3.477125474191871e-16,  4.701593273639710e-19,
 -4.571704952187378e-21, -4.533319410753827e-25,  5.806406739128992e-26, -6.283763333168977e-29,  8.945942104868125e-01, -2.723769849559202e-03,  1.288216319668094e-06,
  1.302727179636666e-08, -1.776308578145567e-11, -1.065557088910988e-13,  2.551836275584915e-16,  9.946966896013798e-19, -3.720459048999266e-21, -9.392801810636519e-24,
  5.435156999543142e-26,  8.065059307552786e-29,  9.636942222810239e-01, -2.755986248562630e-03,  5.188561148392606e-07,  1.386451609503056e-08, -7.720196818346421e-12,
 -1.243762411619495e-13,  1.181917912279862e-16,  1.344273888174764e-18, -1.842738497058870e-21, -1.593154721110941e-23,  2.906526421995134e-26,  1.989370461247310e-28,
  1.033100818850173e+00, -2.761889979708619e-03, -2.738329961327245e-07,  1.404759508378650e-08,  3.148607152749477e-12, -1.286043561093031e-13, -4.167423154755765e-17,
  1.432402776481073e-18,  5.937070038325841e-22, -1.767654810357987e-23, -8.845580056061485e-27,  2.324336108045710e-28,  1.102480472845117e+00, -2.741140096185792e-03,
 -1.063346513980255e-06,  1.355443863137639e-08,  1.388881083775864e-11, -1.183554828767777e-13, -1.977084938920328e-16,  1.230732585838152e-18,  2.931484848485577e-21,
 -1.383180445314491e-23, -4.442493882060317e-26,  1.606848129261814e-28,  1.171495932952068e+00, -2.693909939208666e-03, -1.822840451047617e-06,  1.240717690048582e-08,
  2.353625654227406e-11, -9.473389428593933e-14, -3.231288713402108e-16,  7.788177241940455e-19,  4.519180107350640e-21, -5.584774134348649e-24, -6.310400110952817e-26,
  1.557275673020524e-29,  1.239807849962142e+00, -2.620895999808906e-03, -2.526273947067661e-06,  1.067173652249223e-08,  3.122025981017058e-11, -6.072806713031755e-14,
 -3.963601559503924e-16,  1.764495142555453e-19,  4.914838683454080e-21,  4.268890569603143e-24, -5.726887836924212e-26, -1.333494852413155e-28,  1.307076489339765e+00,
 -2.523316416679255e-03, -3.149557274794120e-06,  8.454092813354990e-09,  3.625982251472324e-11, -2.080475150501586e-14, -4.054279710511593e-16, -4.402450120071851e-19,
  4.028666629865513e-21,  1.235021789780121e-23, -2.982666222731397e-26, -2.146987655247838e-28,  1.372963522992062e+00, -2.402898580591182e-03, -3.671652429662008e-06,
  5.893315879110454e-09,  3.824115869431529e-11,  1.974466160338474e-14, -3.504657940679685e-16, -9.330270408740837e-19,  2.153684499915322e-21,  1.597730477466143e-23,
  7.086557605597326e-27, -1.928326884601090e-28,  1.437133890940648e+00, -2.261855539598574e-03, -4.075572321233293e-06,  3.151820710847455e-09,  3.706637772571406e-11,
  5.560618947657472e-14, -2.437127037896712e-16, -1.196906896072470e-18, -1.297278184612399e-22,  1.417966022640780e-23,  3.775002654890044e-26, -8.586271740597121e-29,
  1.499257721541104e+00, -2.102851155943133e-03, -4.349226103012446e-06,  4.034894206670937e-10,  3.296622284044206e-11,  8.226339285968227e-14, -1.069256967226173e-16,
 -1.186724509103394e-18, -2.144962124508322e-21,  8.020730930898953e-24,  5.013090723246314e-26,  4.625448183812230e-29,  1.559012296832226e+00, -1.928954250381947e-03,
 -4.486062599962100e-06, -2.179447051705007e-09,  2.647395669347681e-11,  9.669582725906724e-14,  3.327263423383084e-17, -9.272534200480752e-19, -3.340161076131684e-21,
  9.216871131865448e-26,  4.118522786655872e-26,  1.363412481747221e-28,  1.616084047582269e+00, -1.743582275602085e-03, -4.485471169919415e-06, -4.439723910607833e-09,
  1.836234667843325e-11,  9.783168252450489e-14,  1.510864595414919e-16, -5.038078040891698e-19, -3.461050991026543e-21, -6.596553951412323e-24,  1.759013920164688e-26,
  1.466617521453109e-28,  1.670170560694725e+00, -1.550435378494749e-03, -4.352909529093768e-06, -6.247436728381510e-09,  9.550615074841970e-12,  8.667011003890357e-14,
  2.269762819844158e-16, -3.612997553094913e-20, -2.614617354951396e-21, -9.843054905457335e-24, -8.290824079367905e-27,  8.618734639912542e-29,  1.720982579907898e+00,
 -1.353422030517662e-03, -4.099740740715665e-06, -7.510421043841187e-09,  9.924994095594488e-13,  6.604640565458477e-14,  2.515549869715656e-16,  3.565402093223032e-19,
 -1.203357478612516e-21, -9.056691774211674e-24, -2.490437317351056e-26, -3.865666790363479e-31,  1.768245979240309e+00, -1.156577713850595e-03, -3.742776158984149e-06,
 -8.181649886864750e-09, -6.440438235360448e-12,  4.007885510668793e-14,  2.270318256061035e-16,  5.885564808644921e-19,  2.409889981584306e-22, -5.311813340458672e-24,
 -2.694774413128873e-26, -6.292531890329602e-29,  1.811703687469178e+00, -9.639784351777585e-04, -3.303536892786030e-06, -8.262906783070939e-09, -1.206492979207459e-11,
  1.339715025177257e-14,  1.658833361960191e-16,  6.290747257166242e-19,  1.257303684090389e-21, -6.758170935257558e-25, -1.699516054061878e-26, -7.515740348310203e-29,
  1.851117541157376e+00, -7.796510849057824e-04, -2.807262399608350e-06, -7.804300329922853e-09, -1.546714258275756e-11, -9.703674698185090e-15,  8.712738940208460e-17,
  5.052335392539209e-19,  1.610475271786138e-21,  2.824513851952522e-24, -2.827946036052109e-27, -4.512063946092005e-29,  1.886270043455574e+00, -6.074828538628718e-04,
 -2.281710125683436e-06, -6.899553291601279e-09, -1.654745567430369e-11, -2.602271767041549e-14,  1.119154979226980e-17,  2.871205385498315e-19,  1.344929892499032e-21,
  4.084680233640932e-24,  7.581497872715809e-27, -2.835137529942079e-30,  1.916966006255782e+00, -4.511320491844283e-04, -1.755803619504210e-06, -5.677390806435698e-09,
 -1.552227286310315e-11, -3.397966629355801e-14, -4.526946282239969e-17,  6.036675369291311e-20,  7.229440377526095e-22,  3.248299907796041e-24,  1.033173629984814e-26,
  2.333742362068588e-29,  1.943034054689499e+00, -3.139427037065988e-04, -1.258197244076084e-06, -4.289729988801414e-09, -1.288221093448236e-11, -3.380659452974280e-14,
 -7.324790723552958e-17, -1.037814895006721e-19,  8.291282784233862e-23,  1.381523922413338e-24,  6.768083359982491e-27,  2.413132183407044e-29,  1.964327977203247e+00,
 -1.988653314801447e-04, -8.158325769439901e-07, -2.897696950990456e-09, -9.312242576563461e-12, -2.737020524525802e-14, -7.295534717516737e-17, -1.705135816425391e-19,
 -3.152781166140243e-22, -2.589823339441410e-25,  1.356531916184668e-27,  9.917726665833905e-30,  1.980727921282164e+00, -1.083859864942881e-04, -4.525639118319450e-07,
 -1.656729828789903e-09, -5.584976353112645e-12, -1.766501060563041e-14, -5.274257921471543e-17, -1.483611235699502e-19, -3.891335513459646e-22, -9.284910318592000e-25,
 -1.895535036562009e-27, -2.663391274443667e-30,  1.992141544724062e+00, -4.446497531969101e-05, -1.879256277647852e-07, -7.021320511866605e-10, -2.442311357743731e-12,
 -8.086093475281065e-15, -2.575993990631073e-17, -7.939298923231866e-20, -2.372693719770108e-22, -6.875756136840736e-25, -1.927895051575597e-27, -5.205348101662759e-30,
  1.998506765582037e+00, -8.477599690265237e-06, -3.607027482343108e-08, -1.362801198962267e-10, -4.820974792876916e-13, -1.634722068402714e-15, -5.379462522137010e-18,
 -1.730535484479669e-20, -5.467141063776120e-23, -1.701343154592115e-25, -5.225961495898527e-28, -1.586679535430561e-30,  5.584506218806400e-04, -2.969717954498186e-06,
  1.184100253620115e-08, -4.195254497322436e-11,  1.392847843666890e-13, -4.437001285977039e-16,  1.373303643831788e-18, -4.160808731866950e-21,  1.239921866135635e-23,
 -3.646047432190467e-26,  1.060342486506219e-28, -3.054796592156798e-31,  5.022868927819871e-03, -2.665530317190268e-05,  1.058358896591723e-07, -3.723349974226467e-10,
  1.223022021292475e-12, -3.837510892789755e-15,  1.163728536527628e-17, -3.432906724729896e-20,  9.887072232347521e-23, -2.785493493778650e-25,  7.681526491127381e-28,
 -2.072675918930607e-30,  1.393471244485090e-02, -7.364265647122406e-05,  2.899428223529321e-07, -1.005541137974282e-09,  3.231306736741916e-12, -9.823314049604892e-15,
  2.850772398414731e-17, -7.920529972722063e-20,  2.103517045435008e-22, -5.306216264327337e-25,  1.254047896995817e-27, -2.697471637414675e-30,  2.726000700812906e-02,
 -1.431690729146935e-04,  5.565259677001703e-07, -1.888240306416253e-09,  5.863137100593649e-12, -1.693259395559069e-14,  4.556571555186806e-17, -1.131378590095608e-19,
  2.520753626785169e-22, -4.675817481659932e-25,  5.301722678717527e-28,  8.329718609422117e-31,  4.494782212266709e-02, -2.341028001595803e-04,  8.944529182101703e-07,
 -2.944806323172895e-09,  8.708828669878002e-12, -2.328091595037084e-14,  5.523746976277266e-17, -1.093212196801159e-19,  1.416507519053262e-22,  1.182287103814037e-25,
 -1.741707556842019e-27,  8.163275225980702e-30,  6.693030979770416e-02, -3.449577520806018e-04,  1.289471132004858e-06, -4.082292562809290e-09,  1.129577169475672e-11,
 -2.689788789805235e-14,  5.077371720916211e-17, -4.998117238432785e-20, -1.454386727230879e-22,  1.141726658167734e-24, -4.644441191783647e-27,  1.429213605727605e-29,
  9.312275954255728e-02, -4.739130356260526e-04,  1.724694644482240e-06, -5.196629243380199e-09,  1.314244289667698e-11, -2.608747052550542e-14,  2.817576590349560e-17,
  6.536033829595771e-20, -5.492537007223956e-22,  2.183047808547157e-24, -6.213427820134436e-27,  1.207706197328957e-29,  1.234236722747828e-01, -6.188372049403003e-04,
  2.181188174641506e-06, -6.179692342853759e-09,  1.381540369417621e-11, -1.976378774276667e-14, -1.236576616212130e-17,  2.162449056485106e-19, -9.308457004534564e-22,
  2.622692254493694e-24, -4.441125873358593e-27, -2.472554698369682e-30,  1.577148565691327e-01, -7.773171258096305e-04,  2.638632749655355e-06, -6.926834635109331e-09,
  1.298356184847881e-11, -7.708917468948603e-15, -6.587545699550095e-17,  3.638461557005913e-19, -1.112079971922422e-21,  1.917834191329669e-24,  1.372698270970766e-27,
 -2.541987084965634e-29,  1.958615513434346e-01, -9.466912964323487e-04,  3.076054149407107e-06, -7.344428985050479e-09,  1.046401500784691e-11,  9.292030330402172e-15,
 -1.230433667378629e-16,  4.596999441877153e-19, -9.395784228153999e-22, -8.934237585213785e-26,  9.671452272173856e-27, -4.439151709821781e-29,  2.377125797298512e-01,
 -1.124087426429221e-03,  3.472592893760013e-06, -7.356955256844392e-09,  6.254355627642513e-12,  2.946768017460885e-14, -1.717196297374856e-16,  4.587941998480377e-19,
 -3.522237200924079e-22, -2.973969738287657e-24,  1.676416412481317e-26, -4.403637499500890e-29,  2.831005395098759e-01, -1.306464024125912e-03,  3.808292238354045e-06,
 -6.913167436604619e-09,  5.473815411408681e-13,  5.023749505693496e-14, -1.992328790727110e-16,  3.337869801265065e-19,  5.725562948331517e-22, -5.758494380559099e-24,
  1.822767348919831e-26, -1.548923893689342e-29,  3.318420360897471e-01, -1.490655681915745e-03,  4.064878802855058e-06, -5.990908584519642e-09, -6.274332438129132e-12,
  6.853443169072703e-14, -1.951193555751228e-16,  8.642433155977249e-20,  1.614508525195843e-21, -7.205370295457433e-24,  1.112818217947500e-26,  3.534390803616266e-29,
  3.837379645482434e-01, -1.673421680704121e-03,  4.226509135020629e-06, -4.600198788410691e-09, -1.366468920042464e-11,  8.123543849954028e-14, -1.537233016625385e-16,
 -2.474748296897079e-19,  2.457201763836546e-21, -6.296303732807161e-24, -3.951051550441541e-27,  8.646595976291664e-29,  4.385738477870930e-01, -1.851497457166694e-03,
  4.280454831572944e-06, -2.784304968668726e-09, -2.095977466697749e-11,  8.564276392351100e-14, -7.610083454149211e-17, -6.017790538237249e-19,  2.777837838778828e-21,
 -2.725001172287341e-24, -2.221195896751417e-26,  1.082485680274561e-28,  4.961202382388936e-01, -2.021648392387798e-03,  4.217698916117711e-06, -6.186093196656884e-10,
 -2.743954457263221e-11,  7.994641133864935e-14,  2.925521009937827e-17, -8.927480869595957e-19,  2.356031431969872e-21,  2.808167566524629e-24, -3.595576343542333e-26,
  7.901996127819653e-29,  5.561331909192065e-01, -2.180725288476349e-03,  4.033417139183878e-06,  1.792778156683619e-09, -3.240009891043070e-11,  6.359464937574679e-14,
  1.471576941561012e-16, -1.038440739341099e-18,  1.166896685201097e-21,  8.664966958223007e-24, -3.768546106643451e-26,  3.604092734872116e-32,  6.183548158264641e-01,
 -2.325720802684908e-03,  3.727319832270200e-06,  4.322573501022383e-09, -3.522960400705490e-11,  3.750675910350245e-14,  2.579469948599876e-16, -9.804460238730461e-19,
 -5.762085928287612e-22,  1.274134933279055e-23, -2.380081961290836e-26, -9.937767663417749e-29,  6.825139177712081e-01, -2.453826008769177e-03,  3.303833015173101e-06,
  6.827797253249170e-09, -3.547995491631547e-11,  4.080287262070696e-15,  3.408938889089674e-16, -7.023363533325945e-19, -2.451850546700835e-21,  1.321792990649757e-23,
  2.856402364090133e-27, -1.718623751340398e-28,  7.483267316286724e-01, -2.562486155950192e-03,  2.772101692487170e-06,  9.158784311220861e-09, -3.292605213522727e-11,
 -3.302752318750010e-14,  3.782013184685373e-16, -2.394059037255731e-19, -3.934384947253716e-21,  9.324518280373194e-24,  3.310343555002587e-26, -1.746218114344429e-28,
  8.154977607281322e-01, -2.649454600791397e-03,  2.145803705993055e-06,  1.116919192827858e-08, -2.760521142582276e-11, -6.933088784082393e-14,  3.588295930279537e-16,
  3.240459221739456e-19, -4.546972058180527e-21,  1.804448094421863e-24,  5.459848825589107e-26, -9.391420808881913e-29,  8.837207255905638e-01, -2.712843801271710e-03,
  1.442769101400213e-06,  1.272635549351266e-08, -1.983077071520875e-11, -1.001108342031031e-13,  2.813205637891393e-16,  8.706576109699021e-19, -4.018713618684779e-21,
 -7.158983920661538e-24,  5.706074631188897e-26,  4.242670469380149e-29,  9.526796294753667e-01, -2.751172190752430e-03,  6.844076146720438e-07,  1.372125954034832e-08,
 -1.017634345388239e-11, -1.210951469967546e-13,  1.549213886313951e-16,  1.276370780432557e-18, -2.393300525214140e-21, -1.460085942018710e-23,  3.728553639934409e-26,
  1.737488196974304e-28,  1.022049946171607e+00, -2.763405698456367e-03, -1.050446064114432e-07,  1.407735542560346e-08,  5.697754972441164e-13, -1.291216934260906e-13,
 -1.397009086919261e-18,  1.441171515352004e-18, -4.653977184574603e-23, -1.782451035491641e-23,  1.465666849403600e-27,  2.349306997943362e-28,  1.091499934147566e+00,
 -2.748992659003177e-03, -8.994388418428773e-07,  1.375747681691916e-08,  1.147709523081796e-11, -1.226768323420751e-13, -1.620118962862422e-16,  1.316244411387822e-18,
  2.403342768830715e-21, -1.545814427346742e-23, -3.667245979123270e-26,  1.908130411753819e-28,  1.160692079538134e+00, -2.707890863159115e-03, -1.671758715919501e-06,
  1.276818592782298e-08,  2.156587768885997e-11, -1.022111662298480e-13, -2.993310690296207e-16,  9.197295729247977e-19,  4.272970818461046e-21, -8.082880516062795e-24,
 -6.149423949874653e-26,  5.770762193982853e-29,  1.229284668494392e+00, -2.640585551776680e-03, -2.395257713242424e-06,  1.116102933627104e-08,  2.991106461026481e-11,
 -7.016352586059016e-14, -3.891978345908461e-16,  3.357301610103509e-19,  5.025950789254131e-21,  1.869628193509610e-24, -6.246416065128431e-26, -1.017727994282580e-28,
  1.296933487145433e+00, -2.548097250828576e-03, -3.044642672545610e-06,  9.030388611408679e-09,  3.574550329545871e-11, -3.066797534739926e-14, -4.158848978648728e-16,
 -3.044626556089800e-19,  4.449529088344582e-21,  1.096903589093596e-23, -3.919836069209666e-26, -2.100108698179377e-28,  1.363293644843210e+00, -2.431978492271882e-03,
 -3.597249960686613e-06,  6.507867821195471e-09,  3.854986653960275e-11,  1.102830618933572e-14, -3.755389395645530e-16, -8.548685234647746e-19,  2.731860470532579e-21,
  1.608404692165064e-23, -1.915665760998044e-27, -2.156307429318414e-28,  1.428021513505741e+00, -2.294298666319488e-03, -4.034156460939733e-06,  3.753450546557471e-09,
  3.811729549601015e-11,  4.935493666994176e-14, -2.772054426868709e-16, -1.192607277862494e-18,  4.069155842616508e-22,  1.560376939528257e-23,  3.319728785915181e-26,
 -1.212860687409959e-28,  1.490776772787554e+00, -2.137616506384589e-03, -4.341165661583877e-06,  9.439602642566090e-10,  3.458309813704272e-11,  7.929096124861735e-14,
 -1.410687377721075e-16, -1.250352818459908e-18, -1.819700566250842e-21,  1.005896293365951e-23,  5.158027358919620e-26,  1.873999228544420e-29,  1.551224547551201e+00,
 -1.964940016509069e-03, -4.509610529592885e-06, -1.740358069329803e-09,  2.841369329452915e-11,  9.717075003164210e-14,  5.815979559965209e-18, -1.033755877582158e-18,
 -3.305755928082357e-21,  1.858158687420170e-24,  4.706991894812012e-26,  1.302389354276576e-28,  1.609037620770903e+00, -1.779674007191427e-03, -4.536919878119017e-06,
 -4.130081301978123e-09,  2.035403285055256e-11,  1.012757487157054e-13,  1.353946322238741e-16, -6.182123644041870e-19, -3.684266181468212e-21, -5.759450251078216e-24,
  2.437105118653733e-26,  1.611999748026172e-28,  1.663898701666631e+00, -1.585555800264064e-03, -4.426903751125196e-06, -6.080464210774125e-09,  1.133835938141504e-11,
  9.209561716151457e-14,  2.247396120264873e-16, -1.255235287936752e-19, -2.973963429137409e-21, -1.009229812233811e-23, -4.006251142356324e-27,  1.088461177280734e-28,
  1.715502725658158e+00, -1.386580084155422e-03, -4.189725851025132e-06, -7.483642288628933e-09,  2.374585560945690e-12,  7.219886338001970e-14,  2.609486242331744e-16,
  3.126240855481737e-19, -1.547293027253015e-21, -1.004869916791946e-23, -2.457826641719985e-26,  1.578192326375610e-29,  1.763559159770618e+00, -1.186914331245091e-03,
 -3.841546813328134e-06, -8.277982615914292e-09, -5.583034922692981e-12,  4.572606105148279e-14,  2.435891081750482e-16,  5.929951010838991e-19,  2.969868350808602e-23,
 -6.444558233385923e-24, -2.967180057701981e-26, -6.048605660490118e-29,  1.807794284552989e+00, -9.908066097074420e-04, -3.403840448072871e-06, -8.453579733582151e-09,
 -1.175572466138599e-11,  1.759423850438547e-14,  1.840560694446256e-16,  6.687813551136822e-19,  1.219918454467601e-21, -1.424212161530244e-24, -2.048489881506622e-26,
 -8.343181774849643e-29,  1.847953421534665e+00, -8.024880115684013e-04, -2.902404872257620e-06, -8.053208669293734e-09, -1.563912914150048e-11, -7.436942330010900e-15,
  1.020105286996943e-16,  5.583697793682494e-19,  1.709616676953022e-21,  2.668759193307359e-24, -5.034704227678271e-27, -5.540744679441279e-29,  1.883803073905825e+00,
 -6.260722537800637e-04, -2.366110440964896e-06, -7.168458800792629e-09, -1.706454714815655e-11, -2.565264675020281e-14,  1.985597520800754e-17,  3.325692706946550e-19,
  1.497393898779009e-21,  4.383988605517691e-24,  7.345530734863453e-27, -8.109745401684783e-30,  1.915132947690303e+00, -4.654552669869562e-04, -1.825445063487705e-06,
 -5.931242327096327e-09, -1.621257996881249e-11, -3.504312505327225e-14, -4.323715461439924e-17,  8.545377026091651e-20,  8.475717257986637e-22,  3.682383553530099e-24,
  1.137863946415931e-26,  2.418544404624982e-29,  1.941757821683983e+00, -3.242177446715052e-04, -1.310933320628219e-06, -4.501350916147445e-09, -1.357615594777452e-11,
 -3.559906719552081e-14, -7.610878235491772e-17, -1.002781360348794e-19,  1.377855654897732e-22,  1.674472805561709e-24,  7.904505004789099e-27,  2.758380111230324e-29,
  1.963519238699587e+00, -2.055336567082575e-04, -8.515172926270813e-07, -3.051168842733939e-09, -9.877548616634492e-12, -2.917957440511081e-14, -7.787229387760529e-17,
 -1.807402914379850e-19, -3.235138303763181e-22, -1.953530291555408e-25,  1.841508644716505e-27,  1.219459619012003e-29,  1.980287008221528e+00, -1.120875672390612e-04,
 -4.729927131199616e-07, -1.748986066573989e-09, -5.951278672378527e-12, -1.898212036538147e-14, -5.707615314959075e-17, -1.613630692542844e-19, -4.239520138460051e-22,
 -1.006628326750244e-24, -2.010476288931649e-27, -2.545787584855671e-30,  1.991960623696372e+00, -4.600275950187201e-05, -1.965911220040270e-07, -7.425371703835174e-10,
 -2.610400209246170e-12, -8.731889458399083e-15, -2.809307020560958e-17, -8.739699562911856e-20, -2.634671472476775e-22, -7.694678427905497e-25, -2.171712436083919e-27,
 -5.891469432602698e-30,  1.998472267513130e+00, -8.772836996307043e-06, -3.775301971848221e-08, -1.442624182925051e-10, -5.161232864570762e-13, -1.769847267028567e-15,
 -5.889455591573956e-18, -1.915701249105351e-20, -6.118997355513628e-23, -1.925045084668796e-25, -5.977153221554851e-28, -1.834170575833153e-30,  5.467580703204106e-04,
 -2.876966433888944e-06,  1.135065618824891e-08, -3.979322847548687e-11,  1.307311646295617e-13, -4.120952214975099e-16,  1.262164212611051e-18, -3.784241954719495e-21,
  1.115985591581134e-23, -3.247604077769532e-26,  9.347112180826043e-29, -2.665143652296597e-31,  4.917913253979333e-03, -2.582616120853809e-05,  1.014827953251102e-07,
 -3.533657923018985e-10,  1.148988702735137e-12, -3.569402152068707e-15,  1.071889932506909e-17, -3.131989228742618e-20,  8.937472105844765e-23, -2.495725429593938e-25,
  6.824755463929898e-28, -1.827128796517380e-30,  1.364470570443276e-02, -7.137051564519965e-05,  2.781801691454893e-07, -9.553755269347772e-10,  3.041506529280732e-12,
 -9.164998333072875e-15,  2.638140912957849e-17, -7.277023003354608e-20,  1.921242605978478e-22, -4.827651479770159e-25,  1.140440830339678e-27, -2.468905169721689e-30,
  2.669609384368176e-02, -1.388059312913002e-04,  5.344189592385073e-07, -1.797080971017712e-09,  5.535169041870726e-12, -1.587613500412420e-14,  4.250828427102928e-17,
 -1.053366168625642e-19,  2.356319208754902e-22, -4.457564928437461e-25,  5.584160878126577e-28,  4.654897540391845e-31,  4.402550166155807e-02, -2.270861936401628e-04,
  8.599361549815696e-07, -2.809119012823335e-09,  8.256222065249363e-12, -2.199143292776506e-14,  5.224048309170863e-17, -1.047330628823255e-19,  1.447359485693930e-22,
  5.535472107334731e-26, -1.411274024916238e-27,  6.888424372117798e-30,  6.557080435747095e-02, -3.348349010747106e-04,  1.241550475874161e-06, -3.905798153638022e-09,
  1.076988371025856e-11, -2.569660153877054e-14,  4.931501823617290e-17, -5.401222879358268e-20, -1.075332648252882e-22,  9.680548072767135e-25, -4.050579075001769e-27,
  1.272315061230775e-29,  9.125431256526535e-02, -4.603613813407119e-04,  1.663579670979779e-06, -4.990486823707193e-09,  1.262759394476503e-11, -2.539120624394075e-14,
  2.977126838205120e-17,  4.899472226976241e-20, -4.750103411248711e-22,  1.945052428059879e-24, -5.688815057304012e-27,  1.173841385291167e-29,  1.209827580745864e-01,
 -6.016805971215621e-04,  2.108345054430594e-06, -5.961822215545257e-09,  1.341763356897352e-11, -1.999118776939846e-14, -6.713979118094663e-18,  1.879340604744404e-19,
 -8.396458458047049e-22,  2.443605569652267e-24, -4.496116874650380e-27, -1.242823275844207e-31,  1.546472847200131e-01, -7.565370326047958e-04,  2.556751799120033e-06,
 -6.720413581636398e-09,  1.281437808187561e-11, -9.171633288461782e-15, -5.617553381102814e-17,  3.293727701926115e-19, -1.042305274285613e-21,  1.951886617286538e-24,
  3.661219679801750e-28, -2.044902610724896e-29,  1.921234488830090e-01, -9.224325365133505e-04,  2.988931171842630e-06, -7.175674153416626e-09,  1.062135024388045e-11,
  6.490050798984213e-15, -1.105926723124517e-16,  4.296529088399828e-19, -9.362880047216578e-22,  2.599890816745053e-25,  7.832848956591792e-27, -3.921315104914699e-29,
  2.332712348407545e-01, -1.096658072589086e-03,  3.384928584019651e-06, -7.252390316787060e-09,  6.803530079642418e-12,  2.549919587850972e-14, -1.590463826493581e-16,
  4.459356832417508e-19, -4.476803371849123e-22, -2.341806963659531e-24,  1.485414655959267e-26, -4.264392921490110e-29,  2.779350909972244e-01, -1.276329294679247e-03,
  3.725419101696675e-06, -6.896627919915293e-09,  1.505082485469263e-12,  4.556994219347356e-14, -1.896605083858496e-16,  3.489311651362507e-19,  3.781938605560471e-22,
 -5.044784039456833e-24,  1.741736427000257e-26, -2.105102491976324e-29,  3.259439938397998e-01, -1.458425819199599e-03,  3.992429974961798e-06, -6.080585905344522e-09,
 -4.950247272997925e-12,  6.388620725837157e-14, -1.920145409205609e-16,  1.340270398012878e-19,  1.363468542014444e-21, -6.732820294153874e-24,  1.241137924717322e-26,
  2.327008126854699e-29,  3.771115472703804e-01, -1.639834011796797e-03,  4.170047899400272e-06, -4.806038799439088e-09, -1.207739026771177e-11,  7.747160260756066e-14,
 -1.595860216275439e-16, -1.724943413511171e-19,  2.228570976937608e-21, -6.382203856633661e-24, -4.411631113656493e-28,  7.312560342569248e-29,  4.312361257507825e-01,
 -1.817393036706754e-03,  4.245087221134057e-06, -3.106063306041645e-09, -1.926649691769766e-11,  8.362409424777627e-14, -9.172209348275192e-17, -5.146201047339277e-19,
  2.664877503614124e-21, -3.519958227638722e-24, -1.758257692451785e-26,  1.018489622702832e-28,  4.881010704613810e-01, -1.987943836137497e-03,  4.207694273357468e-06,
 -1.044820802807258e-09, -2.583557545778361e-11,  8.035717609144482e-14,  5.327024665878169e-18, -8.160082067102554e-19,  2.432097380566484e-21,  1.441851955804438e-24,
 -3.230800080023675e-26,  8.616848355066164e-29,  5.474749483779847e-01, -2.148380612976434e-03,  4.051862634810043e-06,  1.284733805197023e-09, -3.109522026769807e-11,
  6.678201528270046e-14,  1.186489456833268e-16, -9.963995672876930e-19,  1.451760754343671e-21,  7.163946630599155e-24, -3.721418767381153e-26,  2.081540068981066e-29,
  6.091118847983186e-01, -2.295704283801860e-03,  3.775834490745018e-06,  3.765227915277087e-09, -3.441979419205092e-11,  4.336639060161792e-14,  2.303039636564276e-16,
 -9.917375158167165e-19, -1.356403203726117e-22,  1.170955437450605e-23, -2.759965637006346e-26, -7.340490638968762e-29,  6.727519803644364e-01, -2.427077251871108e-03,
  3.382364620824651e-06,  6.261208506067229e-09, -3.531817148927166e-11,  1.201732979817728e-14,  3.202016503482450e-16, -7.731744979880920e-19, -1.975727240798851e-21,
  1.318579101728002e-23, -4.337228058850654e-27, -1.545635025970764e-28,  7.381218239937890e-01, -2.539878723659591e-03,  2.878825995739166e-06,  8.627173716825945e-09,
 -3.349644943263724e-11, -2.404503973020159e-14,  3.697875474996894e-16, -3.596948628019268e-19, -3.576733157864626e-21,  1.049357703780533e-23,  2.532569458142580e-26,
 -1.778983716901460e-28,  8.049351133073555e-01, -2.631759660877231e-03,  2.277139673864708e-06,  1.071688630722456e-08, -2.890505980905507e-11, -6.062646514570224e-14,
  3.658785569147498e-16,  1.799951073454073e-19, -4.443770791543961e-21,  3.897701582119111e-24,  4.987488637910494e-26, -1.198953455016681e-28,  8.728933940815300e-01,
 -2.700696327111495e-03,  1.593516750493033e-06,  1.239342029493656e-08, -2.176357186714085e-11, -9.308135369256173e-14,  3.038630072379176e-16,  7.383786879269670e-19,
 -4.235005704617163e-21, -4.850440822101977e-24,  5.809045213005407e-26,  4.561174885105711e-30,  9.416869299012522e-01, -2.745041260034993e-03,  8.480065645883604e-07,
  1.353927682829271e-08, -1.255821719996992e-11, -1.169573022930340e-13,  1.895106883104449e-16,  1.191677357549696e-18, -2.890321267449131e-21, -1.296515345985049e-23,
  4.427816057840074e-26,  1.433448816474096e-28,  1.010995712503193e+00, -2.763570383477027e-03,  6.385316838881516e-08,  1.406582425025117e-08, -2.009728459149812e-12,
 -1.286717483130324e-13,  3.883867481291816e-17,  1.429446806906603e-18, -6.846842087947456e-22, -1.756019685733516e-23,  1.170961193447358e-26,  2.293887500787486e-28,
  1.080490622218030e+00, -2.755524876859333e-03, -7.333289353453180e-07,  1.392128346424216e-08,  8.987703667324645e-12, -1.261146931496361e-13, -1.241659357365561e-16,
  1.383981261909539e-18,  1.822538576721694e-21, -1.674955340650119e-23, -2.772228718051903e-26,  2.149203165799371e-28,  1.149834746401499e+00, -2.720646351895523e-03,
 -1.516538859686303e-06,  1.309650488673300e-08,  1.945197950532110e-11, -1.090709173926929e-13, -2.717114468285916e-16,  1.051339875193357e-18,  3.938436356917670e-21,
 -1.047945092725764e-23, -5.802865852623673e-26,  9.964136494601514e-29,  1.218684861743211e+00, -2.659203858193550e-03, -2.258501841381797e-06,  1.162787621566621e-08,
  2.841524217417975e-11, -7.937324997327846e-14, -3.775391313879065e-16,  4.971471369324798e-19,  5.047299865619528e-21, -7.078944541180575e-25, -6.614000436292160e-26,
 -6.445057229490455e-29,  1.286693083829253e+00, -2.572011260930595e-03, -2.932868445666754e-06,  9.596864869720766e-09,  3.503172555203018e-11, -4.073506924068426e-14,
 -4.223593600797580e-16, -1.560800695409373e-19,  4.813992097859323e-21,  9.219425853466686e-24, -4.819000355004426e-26, -1.973567310543302e-28,  1.353508684293899e+00,
 -2.460433615196458e-03, -3.515449089032934e-06,  7.125932558260717e-09,  3.867841779602617e-11,  1.738548248432484e-15, -3.981645524952007e-16, -7.582182684754505e-19,
  3.307168448002136e-21,  1.581204665057990e-23, -1.181310355057348e-26, -2.332865336807999e-28,  1.418780072332252e+00, -2.326381311861614e-03, -3.985424421614704e-06,
  4.370851268049613e-09,  3.903516992936518e-11,  4.230328934317846e-14, -3.103299370823209e-16, -1.170352997716202e-18,  9.911706851710396e-22,  1.681432627567356e-23,
  2.706813477013996e-26, -1.572929160711906e-28,  1.482156933289641e+00, -2.172290995714318e-03, -4.326466457631089e-06,  1.509780417298885e-09,  3.613219253002421e-11,
  7.547896182563274e-14, -1.768365577976566e-16, -1.302390009036264e-18, -1.420325124825332e-21,  1.212939605022302e-23,  5.170289979547770e-26, -1.399569232686607e-29,
  1.543292512555068e+00, -2.001092561709481e-03, -4.527702982012627e-06, -1.270194128068836e-09,  3.035609810444916e-11,  9.695111302861496e-14, -2.459745251511544e-17,
 -1.138095354680522e-18, -3.203618020514552e-21,  3.852491740890192e-24,  5.255957879086703e-26,  1.182616997058290e-28,  1.601846028158222e+00, -1.816161918765938e-03,
 -4.584459469351164e-06, -3.788042229424414e-09,  2.241057079202737e-11,  1.043039937201128e-13,  1.164043874818938e-16, -7.392240810882098e-19, -3.872315675866049e-21,
 -4.639040675356276e-24,  3.173558118427698e-26,  1.730106327116798e-28,  1.657485190431157e+00, -1.621259666638833e-03, -4.498719110486688e-06, -5.884023494238004e-09,
  1.323386753889398e-11,  9.743610151640016e-14,  2.198378338896704e-16, -2.265246651750420e-19, -3.338952825564986e-21, -1.014975760100796e-23,  1.308787417271123e-27,
  1.329329302364321e-28,  1.709888802010436e+00, -1.420456347938823e-03, -4.279252836897826e-06, -7.433753953333442e-09,  3.881869170961491e-12,  7.856073603867014e-14,
  2.689531844714922e-16,  2.571345989056659e-19, -1.926525161692092e-21, -1.101239477936978e-23, -2.346266339366486e-26,  3.553518907990003e-29,  1.758749406520329e+00,
 -1.218045495907454e-03, -3.941387352527513e-06, -8.359671720293442e-09, -4.608707787728603e-12,  5.177133070309242e-14,  2.601697351403118e-16,  5.899991959156852e-19,
 -2.242989280036783e-22, -7.683344593945641e-24, -3.222959631863447e-26, -5.526961087071089e-29,  1.803775949717994e+00, -1.018446274341850e-03, -3.506399547207148e-06,
 -8.638609795391203e-09, -1.135812706289006e-11,  2.224065272209629e-14,  2.033195932430512e-16,  7.068329336123989e-19,  1.152991428734841e-21, -2.319387160336478e-24,
 -2.433119960549903e-26, -9.129851081943632e-29,  1.844696412947369e+00, -8.260980688187875e-04, -3.000549195381687e-06, -8.304486196577708e-09, -1.576208675797716e-11,
 -4.794808159158820e-15,  1.184249284217138e-16,  6.145708845726680e-19,  1.801449360168004e-21,  2.415285285363670e-24, -7.723764274727587e-27, -6.704668108053978e-29,
  1.881260375716818e+00, -6.453499036947277e-04, -2.453786981086435e-06, -7.445566821090247e-09, -1.757205177255905e-11, -2.505879765678316e-14,  2.986287312045903e-17,
  3.830669529099547e-19,  1.660403487160775e-21,  4.668807891481525e-24,  6.846497223919880e-27, -1.483273887286116e-29,  1.913241462430609e+00, -4.803479905758969e-04,
 -1.898199687827096e-06, -6.196306017596010e-09, -1.692360920701910e-11, -3.604891379472099e-14, -4.044416946877112e-17,  1.147870528247514e-19,  9.885880674115228e-22,
  4.158964277741117e-24,  1.245319785259125e-26,  2.456707512848439e-29,  1.940439628384095e+00, -3.349250235550002e-04, -1.366276662046076e-06, -4.724365452864170e-09,
 -1.430662801082565e-11, -3.745881525179197e-14, -7.884533085040535e-17, -9.484103970368353e-20,  2.040602701372906e-22,  2.016023772885742e-24,  9.200849959180040e-27,
  3.140165578845484e-29,  1.962683244054944e+00, -2.124949828682645e-04, -8.890991556110146e-07, -3.213981639748233e-09, -1.048024544571281e-11, -3.111041398524253e-14,
 -8.307890582760491e-17, -1.911899461448960e-19, -3.290844193155702e-22, -1.101945037932057e-25,  2.436252914567156e-27,  1.491922524503226e-29,  1.979830954822271e+00,
 -1.159571083671276e-04, -4.945646422252272e-07, -1.847319656085569e-09, -6.344993394828228e-12, -2.040773308748124e-14, -6.178980937313465e-17, -1.755250883099385e-19,
 -4.616646631516393e-22, -1.089230103500778e-24, -2.117971261288807e-27, -2.319894694421969e-30,  1.991773409747390e+00, -4.761185380561752e-05, -2.057580504962471e-07,
 -7.857381589016446e-10, -2.791983586162791e-12, -9.436467438854272e-15, -3.066250625741063e-17, -9.628844363010361e-20, -2.927961037653126e-22, -8.617427205512004e-25,
 -2.447694684962785e-27, -6.669215555948002e-30,  1.998436560951083e+00, -9.081928876652065e-06, -3.953491005782617e-08, -1.528114327278263e-10, -5.529783205490214e-13,
 -1.917858792809363e-15, -6.454340720123098e-18, -2.123075129986531e-20, -6.857068035563612e-23, -2.181090785853482e-25, -6.846197526088578e-28, -2.123522978051962e-30,
  5.354288401866862e-04, -2.788036316340636e-06,  1.088542089016528e-08, -3.776585452827399e-11,  1.227838010132452e-13, -3.830354866932913e-16,  1.161034307860000e-18,
 -3.445133483603116e-21,  1.005528566755475e-23, -2.896146142943864e-26,  8.250299537905678e-29, -2.328432697835876e-31,  4.816205912241362e-03, -2.503095321517836e-05,
  9.735039740323573e-08, -3.355393924132590e-10,  1.080103797695891e-12, -3.322356990316938e-15,  9.880668201607555e-18, -2.859853958438348e-20,  8.086271590309693e-23,
 -2.238160338770107e-25,  6.069154984826201e-28, -1.612110863911081e-30,  1.336360306586750e-02, -6.919011873823616e-05,  2.670017081220015e-07, -9.081441013184350e-10,
  2.864376581331271e-12, -8.555616339047022e-15,  2.442736319053097e-17, -6.689173084984451e-20,  1.755402368975407e-22, -4.392561708694053e-25,  1.036564183171953e-27,
 -2.255247678198477e-30,  2.614928633784737e-02, -1.346153577145337e-04,  5.133750624166788e-07, -1.711004004809445e-09,  5.227613767698595e-12, -1.489049191248618e-14,
  3.966204060548340e-17, -9.804880557858080e-20,  2.199908556753822e-22, -4.230999971340011e-25,  5.723197515079737e-28,  1.784408562871427e-31,  4.313070549930210e-02,
 -2.203393294098325e-04,  8.270050277624162e-07, -2.680470955080782e-09,  7.828696299316097e-12, -2.077232681140248e-14,  4.937302427309412e-17, -1.000799506420793e-19,
  1.457825810598902e-22,  4.631397774975083e-27, -1.132853691162186e-27,  5.794930918821263e-30,  6.425103680478891e-02, -3.250870848143401e-04,  1.195698053995383e-06,
 -3.737527684526784e-09,  1.026766290720431e-11, -2.453154694024973e-14,  4.775952330980823e-17, -5.692589524739857e-20, -7.546874939536462e-23,  8.167952915318613e-25,
 -3.522869144300341e-27,  1.128526152735851e-29,  8.943910983607208e-02, -4.472888909750769e-04,  1.604889446873545e-06, -4.792468655515156e-09,  1.212701743625235e-11,
 -2.466188805854749e-14,  3.094053529660778e-17,  3.487182619731658e-20, -4.089611485396225e-22,  1.727693479829168e-24, -5.182740664379022e-27,  1.124379915609226e-29,
  1.186093212207306e-01, -5.850963849909547e-04,  2.038078062882189e-06, -5.750345687976504e-09,  1.301660934215592e-11, -2.009213353977830e-14, -1.815009327090976e-18,
  1.624382242048535e-19, -7.549093302672739e-22,  2.264219507207265e-24, -4.460033953639540e-27,  1.682955907328809e-30,  1.516615387687080e-01, -7.364021269544225e-04,
  2.477330734279058e-06, -6.516921177895910e-09,  1.261819110258600e-11, -1.041288083850740e-14, -4.740947504857465e-17,  2.971444340675470e-19, -9.719785622948873e-22,
  1.949847979442560e-24, -4.367723524067141e-28, -1.615321464015293e-29,  1.884810003749182e-01, -8.988626215427108e-04,  2.903846558944907e-06, -7.004834324715527e-09,
  1.072556601826032e-11,  3.976815151711461e-15, -9.898002882106856e-17,  3.998986297423756e-19, -9.216911084280874e-22,  5.402692671315374e-25,  6.217133645219088e-27,
 -3.427519393562483e-29,  2.289382128880626e-01, -1.069924870659661e-03,  3.298569208290684e-06, -7.139657145429857e-09,  7.276345565336512e-12,  2.183022438413044e-14,
 -1.467726216895248e-16,  4.303720691914567e-19, -5.217374263454167e-22, -1.784590736844424e-24,  1.302205832318674e-26, -4.053391647999230e-29,  2.728888570476826e-01,
 -1.246856502947300e-03,  3.642833338743187e-06, -6.865499382373538e-09,  2.371760556153144e-12,  4.113653536401908e-14, -1.797473595107799e-16,  3.582601455679474e-19,
  2.088872054002520e-22, -4.367878046806844e-24,  1.639943857399899e-26, -2.496756460333731e-29,  3.201737055431640e-01, -1.426779498503646e-03,  3.919029077880476e-06,
 -6.149817093707461e-09, -3.718278101577755e-12,  5.932760117502738e-14, -1.876866941479569e-16,  1.738775551570303e-19,  1.130240886393656e-21, -6.219056178300032e-24,
  1.320150458629988e-26,  1.292753211834822e-29,  3.706185622464578e-01, -1.606707487116870e-03,  4.111266457363824e-06, -4.987091187360493e-09, -1.056660933122312e-11,
  7.359142623464212e-14, -1.634519928368356e-16, -1.048535618361446e-19,  1.999234480985523e-21, -6.339328940629489e-24,  2.491287059844996e-27,  6.027607727965233e-29,
  4.240342317069225e-01, -1.783586544155603e-03,  4.206019669253216e-06, -3.401071734617635e-09, -1.761714620618989e-11,  8.125936611980978e-14, -1.049575589406437e-16,
 -4.314986268305531e-19,  2.526559000651977e-21, -4.135913009017895e-24, -1.327415599865874e-26,  9.375814981390318e-29,  4.802165290590091e-01, -1.954339338475581e-03,
  4.192729245873453e-06, -1.445333525164454e-09, -2.422895853396563e-11,  8.021967961979196e-14, -1.642555705866819e-17, -7.375925027102024e-19,  2.461668342685339e-21,
  2.266657169910100e-25, -2.842501313799176e-26,  8.978684819466041e-29,  5.389463415624810e-01, -2.115912400108060e-03,  4.064338850945411e-06,  7.980407332575140e-10,
 -2.973333594480684e-11,  6.930027737187571e-14,  9.143688160439216e-17, -9.461019675572428e-19,  1.683138397233274e-21,  5.699033448480704e-24, -3.590583329185251e-26,
  3.806489267011469e-29,  5.999897540443906e-01, -2.265326171298830e-03,  3.817742494300060e-06,  3.221740701816068e-09, -3.349944359962239e-11,  4.856035318938776e-14,
  2.025363649809139e-16, -9.895522428127206e-19,  2.653213596132979e-22,  1.054840561496346e-23, -3.027633463856259e-26, -4.850373187406503e-29,  6.630982515080086e-01,
 -2.399727382496821e-03,  3.454117841994926e-06,  5.698450594407338e-09, -3.500276512352584e-11,  1.943567563744345e-14,  2.977386860064523e-16, -8.288491986599720e-19,
 -1.505748450326990e-21,  1.288204392279936e-23, -1.070332799961132e-26, -1.344250135021378e-28,  7.280090130733867e-01, -2.516443155823066e-03,  2.979122103545284e-06,
  8.087861870061698e-09, -3.388948234031157e-11, -1.530357386169077e-14,  3.581718114291055e-16, -4.679258063276391e-19, -3.182613800680962e-21,  1.135041081685268e-23,
  1.753490653955509e-26, -1.753127128017340e-28,  7.944453121648629e-01, -2.613036084164998e-03,  2.402928959803757e-06,  1.024518364774755e-08, -3.002945247512090e-11,
 -5.180082694263537e-14,  3.689513883830403e-16,  4.041384255041275e-20, -4.268873984846138e-21,  5.780792430232802e-24,  4.413192928188890e-26, -1.401733575754018e-28,
  8.621170384005717e-01, -2.687359367500499e-03,  1.740088359496210e-06,  1.203071311777664e-08, -2.355067694645736e-11, -8.555600537425693e-14,  3.226172737371879e-16,
  6.005128533588026e-19, -4.367846618709188e-21, -2.533598526560298e-24,  5.748891914694431e-26, -3.149293586542085e-29,  9.307213568965370e-01, -2.737610914179630e-03,
  1.009195936883767e-06,  1.331989045799875e-08, -1.484923375536099e-11, -1.120195123401779e-13,  2.215151286387630e-16,  1.092072727834980e-18, -3.323755765934593e-21,
 -1.107773615314235e-23,  4.984303535176191e-26,  1.090892190185856e-28,  9.999435205935249e-01, -2.762385140396707e-03,  2.323654032197156e-07,  1.401314531715237e-08,
 -4.570615418867512e-12, -1.272623822135505e-13,  7.846216901220918e-17,  1.397532188073599e-18, -1.306017640949790e-21, -1.689332009256520e-23,  2.153724881298498e-26,
  2.160840032167464e-28,  1.069457850662470e+00, -2.760721034760812e-03, -5.654944381269123e-07,  1.404475974649713e-08,  6.438780518185944e-12, -1.286236319481308e-13,
 -8.469002870950816e-17,  1.432459576830213e-18,  1.201925090104592e-21, -1.766376777820349e-23, -1.786462934083781e-26,  2.319058928005393e-28,  1.138928898954678e+00,
 -2.732144907639044e-03, -1.357586517573440e-06,  1.338994116066345e-08,  1.720780691371907e-11, -1.152248649118224e-13, -2.405693663099936e-16,  1.170894989006156e-18,
  3.520561384796020e-21, -1.270094530432703e-23, -5.275472427702228e-26,  1.396138914520818e-28,  1.208012804747957e+00, -2.676706129741403e-03, -2.116293430894137e-06,
  1.206933312014613e-08,  2.673838947001584e-11, -8.824893857902770e-14, -3.613653213047294e-16,  6.577375528697285e-19,  4.973620569051442e-21, -3.398166546476187e-24,
 -6.806834130739280e-26, -2.256240249580407e-29,  1.276358855618165e+00, -2.595004095854458e-03, -2.814371694066489e-06,  1.015030294195960e-08,  3.411539514668255e-11,
 -5.090643643113706e-14, -4.245257872310878e-16,  2.889374966373241e-21,  5.109151253416194e-21,  7.123692979540534e-24, -5.644479953503064e-26, -1.765116169347693e-28,
  1.343611259070268e+00, -2.488204643381880e-03, -3.426225323820829e-06,  7.744539207753617e-09,  3.861597365220310e-11, -8.059681418729580e-15, -4.178282454081501e-16,
 -6.433926506680437e-19,  3.865387497178467e-21,  1.513043858399630e-23, -2.234842485455107e-26, -2.444050481549705e-28,  1.409411127549658e+00, -2.358044227190588e-03,
 -3.929200251019799e-06,  5.001766772930990e-09,  3.980412309326616e-11,  3.446628275514232e-14, -3.425633690815556e-16, -1.128755682810454e-18,  1.614212177983297e-21,
  1.774817932325866e-23,  1.936857155826597e-26, -1.924076519593109e-28,  1.473398674610833e+00, -2.206820316791019e-03, -4.304831367072080e-06,  2.099729050953362e-09,
  3.759635239306778e-11,  7.079256320096023e-14, -2.138713037740731e-16, -1.340456573549544e-18, -9.466860917604550e-22,  1.417448988307218e-23,  5.027888664401717e-26,
 -5.145221176424546e-29,  1.535215614376467e+00, -2.037366750922374e-03, -4.539967272398441e-06, -7.690274966879512e-10,  3.228657650437182e-11,  9.596693274925675e-14,
 -5.787554320431145e-17, -1.237976445468102e-18, -3.025875655527294e-21,  6.053986455376626e-24,  5.738026222698006e-26,  9.973282551254248e-29,  1.594507750056322e+00,
 -1.853013165380224e-03, -4.627695248819500e-06, -3.412639957653394e-09,  2.452283817164307e-11,  1.068351722529580e-13,  9.394804308756783e-17, -8.655502163888970e-19,
 -4.014612155204741e-21, -3.214708972373498e-24,  3.953899130290787e-26,  1.809527220669667e-28,  1.650927730352447e+00, -1.657528103084742e-03, -4.567991711136490e-06,
 -5.656407546889364e-09,  1.523477306261692e-11,  1.026236866198458e-13,  2.119445023485310e-16, -3.391954361178059e-19, -3.701925890995762e-21, -9.973141103405634e-24,
  7.703058661867120e-27,  1.577728061362241e-28,  1.704137945258948e+00, -1.455046013252833e-03, -4.368032232376867e-06, -7.358721296044170e-09,  5.518178256590773e-12,
  8.509467066697389e-14,  2.752289991371503e-16,  1.889649731292321e-19, -2.339427690139798e-21, -1.191298894350334e-23, -2.139591618245622e-26,  5.903143809419141e-29,
  1.753813525340824e+00, -1.249979031614371e-03, -4.042110565778820e-06, -8.424782771810986e-09, -3.509507628075072e-12,  5.821256842155311e-14,  2.765458436132676e-16,
  5.781425851813601e-19, -5.246705469602325e-22, -9.018898923871719e-24, -3.448546421763156e-26, -4.665654448167351e-29,  1.799645401378787e+00, -1.046915177838222e-03,
 -3.611137688732708e-06, -8.816509392209331e-09, -1.086289301435950e-11,  2.736190397796681e-14,  2.236135176827640e-16,  7.421968683361759e-19,  1.050987264384764e-21,
 -3.375119431406838e-24, -2.850648035438937e-26, -9.830079587561773e-29,  1.841343374683066e+00, -8.505053712621608e-04, -3.101718838145332e-06, -8.557286358987413e-09,
 -1.582813309339133e-11, -1.739521955649639e-15,  1.364525744056097e-16,  6.735428495283949e-19,  1.882093806603989e-21,  2.043608121545366e-24, -1.095466709652125e-26,
 -8.003038929919843e-29,  1.878639142849719e+00, -6.653424041667368e-04, -2.544837102346613e-06, -7.730686359065929e-09, -1.806516014487306e-11, -2.420721702792674e-14,
  4.135824491496545e-17,  4.389405382362989e-19,  1.833231620922962e-21,  4.927267709177597e-24,  6.015161166056335e-27, -2.325803379100996e-29,  1.911289221782710e+00,
 -4.958356691203618e-04, -1.974203986496802e-06, -6.472903171420250e-09, -1.765401467206702e-11, -3.697728884444914e-14, -3.676403855191006e-17,  1.489156869228203e-19,
  1.147537455896769e-21,  4.678685919530368e-24,  1.353093262996272e-26,  2.429542639881925e-29,  1.939077703241849e+00, -3.460859554057276e-04, -1.424367542063351e-06,
 -4.959368614516151e-09, -1.507493818722333e-11, -3.938216223084714e-14, -8.139802782133817e-17, -8.707607662847096e-20,  2.836056472820425e-22,  2.412896348652568e-24,
  1.067325152402199e-26,  3.558531739043491e-29,  1.961818790186720e+00, -2.197649458594190e-04, -9.286939276741691e-07, -3.386753409587762e-09, -1.112283244454416e-11,
 -3.316974047657041e-14, -8.858010871934581e-17, -2.017639736747510e-19, -3.311308488511194e-22,  1.300306443415434e-27,  3.162155073324295e-27,  1.817019529519212e-29,
  1.979359070480188e+00, -1.200040542382821e-04, -5.173553322072334e-07, -1.952187063110927e-09, -6.768384485212900e-12, -2.195137114310028e-14, -6.691735023064446e-17,
 -1.909422988904491e-19, -5.024256250466198e-22, -1.175893667265872e-24, -2.212527248990784e-27, -1.951287679097790e-30,  1.991579609395894e+00, -4.929640766858311e-05,
 -2.154612989655985e-07, -8.319606510666018e-10, -2.988295914552557e-12, -1.020580861188218e-14, -3.349455720372631e-17, -1.061737678380071e-19, -3.256541775211934e-22,
 -9.657708208218794e-25, -2.760125741063161e-27, -7.550254621104023e-30,  1.998399588847090e+00, -9.405696486837236e-06, -4.142302678247085e-08, -1.619745663962520e-10,
 -5.929340024613270e-13, -2.080151902879374e-15, -7.080740595392813e-18, -2.355611758845511e-20, -7.693891729703050e-23, -2.474584231426455e-25, -7.853143597641478e-28,
 -2.462370287040839e-30,  5.244480378441938e-04, -2.702732885580668e-06,  1.044376989344441e-08, -3.586111755682752e-11,  1.153941098569820e-13, -3.562928093309481e-16,
  1.068923026417280e-18, -3.139428722695695e-21,  9.069687569731757e-24, -2.585736156817939e-26,  7.291415371382100e-29, -2.037040437700854e-31,  4.717614612950955e-03,
 -2.426796710615959e-05,  9.342546290773802e-08, -3.187766914684604e-10,  1.015964636938811e-12, -3.094544944072202e-15,  9.114956915692169e-18, -2.613530060486951e-20,
  7.322574773632758e-23, -2.009008018735387e-25,  5.402181653360196e-28, -1.423672517447778e-30,  1.309104668232485e-02, -6.709692968039736e-05,  2.563734138194870e-07,
 -8.636517469234658e-10,  2.698978330789458e-12, -7.991214820600060e-15,  2.263071544441932e-17, -6.151964305911828e-20,  1.604499703595487e-22, -3.997186841611350e-25,
  9.417563484593015e-28, -2.056682068767902e-30,  2.561891084966437e-02, -1.305890857985939e-04,  4.933352025720784e-07, -1.629693863222907e-09,  4.939104496545433e-12,
 -1.397076576542720e-14,  3.701297170388766e-17, -9.124837437540559e-20,  2.051725773902119e-22, -4.001196953242219e-25,  5.750829657071312e-28, -4.313362227347917e-32,
  4.226237951142721e-02, -2.138498535485237e-04,  7.955774273816895e-07, -2.558471947435996e-09,  7.424875031524259e-12, -1.962047408904150e-14,  4.663606176744806e-17,
 -9.542050459326982e-20,  1.451924817149919e-22, -3.586932048260480e-26, -8.989947035659898e-28,  4.859246142102644e-30,  6.296953947641919e-02, -3.156981457929655e-04,
  1.151817426843564e-06, -3.577108393609180e-09,  9.788363847533826e-12, -2.340469215546840e-14,  4.613602034885754e-17, -5.889667021881928e-20, -4.848452315574006e-23,
  6.854171876335783e-25, -3.055564538921176e-27,  9.976930427320742e-30,  8.767527288338828e-02, -4.346765525692096e-04,  1.548527871372563e-06, -4.602341626069908e-09,
  1.164127708892972e-11, -2.390902101804592e-14,  3.174280241008822e-17,  2.274116774489179e-20, -3.503780671231211e-22,  1.530108016280503e-24, -4.700905030801484e-27,
  1.064408696627324e-29,  1.163011128616037e-01, -5.690642671111174e-04,  1.970310244757781e-06, -5.545295548387520e-09,  1.261468568640672e-11, -2.008377018236475e-14,
  2.407071015214300e-18,  1.395510557250278e-19, -6.765868450955490e-22,  2.087728235641561e-24, -4.354660917307882e-27,  3.039180649770973e-30,  1.487550770906581e-01,
 -7.168928773641909e-04,  2.400331961310091e-06, -6.316755236732997e-09,  1.239921124573178e-11, -1.145431767827430e-14, -3.951435646916201e-17,  2.671595385780647e-19,
 -9.022594811650809e-22,  1.919287009326404e-24, -1.064517505202811e-27, -1.247832633336132e-29,  1.849314831918351e-01, -8.759651585399227e-04,  2.820820418250786e-06,
 -6.832714300636820e-09,  1.078223694218721e-11,  1.732347180549509e-15, -8.819253535145127e-17,  3.707608391744736e-19, -8.981158743423086e-22,  7.601779255687728e-25,
  4.811976093687536e-27, -2.965209897317465e-29,  2.247107507351363e-01, -1.043877009411638e-03,  3.213605650811878e-06, -7.019930109507373e-09,  7.678690718345659e-12,
  1.845034402228340e-14, -1.349649035820570e-16,  4.127456326236422e-19, -5.770299695841918e-22, -1.298640448358690e-24,  1.129445916079560e-26, -3.792771111271629e-29,
  2.679591955826564e-01, -1.218042674067142e-03,  3.560701435376393e-06, -6.821200335964400e-09,  3.152167734603446e-12,  3.694358865990893e-14, -1.696452430004336e-16,
  3.625530414605815e-19,  6.317866850294117e-23, -3.734706370395972e-24,  1.524083386065130e-26, -2.748546276727574e-29,  3.145288233173775e-01, -1.395723379876364e-03,
  3.844912686180613e-06, -6.200060144363940e-09, -2.576356272942913e-12,  5.488542712262770e-14, -1.823446999631263e-16,  2.065659533179470e-19,  9.159725160450816e-22,
 -5.682288768037245e-24,  1.357377744812535e-26,  4.263915086832923e-30,  3.642571296305273e-01, -1.574059499482926e-03,  4.050454846119565e-06, -5.144596320697702e-09,
 -9.134210622923371e-12,  6.964036678226303e-14, -1.655263778733742e-16, -4.450530917402631e-20,  1.773418503515619e-21, -6.190249663950307e-24,  4.874815664006477e-27,
  4.821605369723318e-29,  4.169669167602718e-01, -1.750106307503304e-03,  4.163568739410543e-06, -3.670085385289772e-09, -1.601808071700733e-11,  7.860439616009068e-14,
 -1.159306902649827e-16, -3.531255891923285e-19,  2.369078955846782e-21, -4.587020737902628e-24, -9.348407742933826e-27,  8.454262123493103e-29,  4.724661363843159e-01,
 -1.920873349033978e-03,  4.173112120358534e-06, -1.820189993608419e-09, -2.263013392736165e-11,  7.958653644833333e-14, -3.597561262395552e-17, -6.589002437367352e-19,
  2.450318148573007e-21, -8.309513051792195e-25, -2.445177484500892e-26,  9.035280829996181e-29,  5.305477707569581e-01, -2.083367364745866e-03,  4.071107039564944e-06,
  3.335057411524032e-10, -2.832749908192055e-11,  7.118313824606134e-14,  6.572895969213138e-17, -8.892325512529565e-19,  1.862894501651201e-21,  4.300580673109985e-24,
 -3.391718919160955e-26,  5.174391428436173e-29,  5.909897653270305e-01, -2.234638624158461e-03,  3.853220315793958e-06,  2.693773969286553e-09, -3.248186569617375e-11,
  5.309003822743054e-14,  1.750031655976000e-16, -9.752235664646111e-19,  6.228142329072736e-22,  9.301621740544943e-24, -3.189447729431069e-26, -2.539353512268553e-29,
  6.535550275467549e-01, -2.371830402859328e-03,  3.519153047086162e-06,  5.141896328633648e-09, -3.454450048882882e-11,  2.629789125906612e-14,  2.739253964984908e-16,
 -8.697069121309011e-19, -1.051069007918764e-21,  1.234197393660172e-23, -1.614041444362271e-26, -1.125063202454041e-28,  7.179915080408181e-01, -2.492231199814078e-03,
  3.072914455580871e-06,  7.543643980018989e-09, -3.411071169661114e-11, -6.875799761620926e-15,  3.437063845511860e-16, -5.631112209495965e-19, -2.763215899444721e-21,
  1.189946790280050e-23,  9.974591541460338e-27, -1.675488139412676e-28,  7.840323816943369e-01, -2.593329127293259e-03,  2.522955706432314e-06,  9.756905498048963e-09,
 -3.097690793950686e-11, -4.294764664969545e-14,  3.682041638085252e-16, -9.253204009629453e-20, -4.030519897703169e-21,  7.418076816056559e-24,  3.762835936730835e-26,
 -1.544428110515497e-28,  8.513963474670806e-01, -2.672867719463695e-03,  1.882140962628946e-06,  1.164063945050199e-08, -2.518308887150524e-11, -7.762728110768180e-14,
  3.374642720410633e-16,  4.597229115756086e-19, -4.418089277848635e-21, -2.717203399885657e-25,  5.536481511267829e-26, -6.445200772248918e-29,  9.197880667623165e-01,
 -2.728902199276419e-03,  1.167536126617442e-06,  1.306467862738612e-08, -1.703404717756410e-11, -1.063485860291197e-13,  2.505469643471878e-16,  9.797253088713573e-19,
 -3.685607306860724e-21, -8.998674114543583e-24,  5.384321082296365e-26,  7.247457074152687e-29,  9.888987608682009e-01, -2.759855022111526e-03,  4.000007423297670e-07,
  1.391976901637228e-08, -7.093889307908408e-12, -1.249149974421706e-13,  1.169178392843294e-16,  1.346193614710941e-18, -1.896428411136695e-21, -1.584720070958983e-23,
  3.061982335649205e-26,  1.956558900525269e-28,  1.058406988228067e+00, -2.764569286607114e-03, -3.964244101341106e-07,  1.412710372551735e-08,  3.849251042528671e-12,
 -1.301711320584634e-13, -4.413916106746563e-17,  1.460629100102968e-18,  5.556568361203453e-22, -1.817100885434385e-23, -7.431184830897138e-27,  2.409941221046450e-28,
  1.127979621949757e+00, -2.742358379204085e-03, -1.195332307761031e-06,  1.364652776084621e-08,  1.484829250480519e-11, -1.205928153721254e-13, -2.062786633861966e-16,
  1.275842622503102e-18,  3.026925142966800e-21, -1.467727234324715e-23, -4.579726225998250e-26,  1.758852612604489e-28,  1.197273046890288e+00, -2.693050013524331e-03,
 -1.968954300885395e-06,  1.248256288470776e-08,  2.488826716890621e-11, -9.668285371835601e-14, -3.407426325935566e-16,  8.144094163176422e-19,  4.802156773803457e-21,
 -6.127687738126535e-24, -6.808002977085846e-26,  2.240136839698245e-29,  1.265934593704432e+00, -2.617022656451165e-03, -2.689328371392261e-06,  1.068745101561759e-08,
  3.299548320967183e-11, -6.107538878813777e-14, -4.221206239889239e-16,  1.700349806700809e-19,  5.323163399758580e-21,  4.718500315110580e-24, -6.360448654518411e-26,
 -1.476402962237852e-28,  1.333604224284426e+00, -2.515232220365564e-03, -3.329590820270061e-06,  8.360554521879337e-09,  3.835311637836392e-11, -1.828926539028037e-14,
 -4.340310125187906e-16, -5.111787886666585e-19,  4.391385267756979e-21,  1.401984035543946e-23, -3.320591383517961e-26, -2.477428800384726e-28,  1.399916478921287e+00,
 -2.389226868238508e-03, -3.865336582260521e-06,  5.643690011900764e-09,  4.040870621167633e-11,  2.587193227931594e-14, -3.733483407803471e-16, -1.066745568408370e-18,
  2.264961822821725e-21,  1.834377551990561e-23,  1.017390180966671e-26, -2.249653270593952e-28,  1.464502690197711e+00, -2.241147848796105e-03, -4.275979583934343e-06,
  2.712305794613911e-09,  3.895781874796616e-11,  6.520632053968426e-14, -2.517487526368829e-16, -1.362203006077256e-18, -4.008573502774116e-22,  1.612844590116701e-23,
  4.711768963976648e-26, -9.279129561705390e-29,  1.526993462040002e+00, -2.073714475152479e-03, -4.546033029975132e-06, -2.371750127374648e-10,  3.418916166374353e-11,
  9.415123548258402e-14, -9.385850587012883e-17, -1.330866220388577e-18, -2.765623629151817e-21,  8.429958912748604e-24,  6.123217588591381e-26,  7.416604274075837e-29,
  1.587021404542002e+00, -1.890191700733350e-03, -4.666221850942822e-06, -3.003066913570370e-09,  2.668005064129665e-11,  1.087844879429976e-13,  6.789895962044306e-17,
 -9.955485806690986e-19, -4.099942682476903e-21, -1.472660086600692e-24,  4.758435261041007e-26,  1.838021554751320e-28,  1.644224106243808e+00, -1.694339242711239e-03,
 -4.634337446010532e-06, -5.395958486595264e-09,  1.733727359981850e-11,  1.075826695695075e-13,  2.007350974762192e-16, -4.633281093027405e-19, -4.053673085787440e-21,
 -9.518864641362178e-24,  1.519074296640718e-26,  1.824657257337681e-28,  1.698247315719857e+00, -1.490341857105638e-03, -4.455749813229038e-06, -7.256454756396250e-09,
  7.286509780390292e-12,  9.175479746182372e-14,  2.794063357258825e-16,  1.070817682177592e-19, -2.783004275882606e-21, -1.270912560973537e-23, -1.821239273747231e-26,
  8.628609687938416e-29,  1.748748293933815e+00, -1.282721169446550e-03, -4.143505268400144e-06, -8.471254801284488e-09, -2.277585142883148e-12,  6.504171774946068e-14,
  2.924480529414885e-16,  5.558881968592418e-19, -8.746446845330620e-22, -1.043596473857592e-23, -3.627568346398732e-26, -3.399480156831534e-29,  1.795399288295612e+00,
 -1.076230382985911e-03, -3.717959616301154e-06, -8.985639051205057e-09, -1.026028525296274e-11,  3.298168657058256e-14,  2.448459876138895e-16,  7.736557539454184e-19,
  9.078996427767337e-22, -4.603647334939065e-24, -3.296051482915091e-26, -1.038639810494014e-28,  1.837891069262850e+00, -8.757341784204688e-04, -3.205926329122178e-06,
 -8.810630342428621e-09, -1.582861187000179e-11,  1.768520658698436e-15,  1.561653681893655e-16,  7.348552677402138e-19,  1.946890457643915e-21,  1.530887531983270e-24,
 -1.478518542170828e-26, -9.428265811600267e-29,  1.875936461322186e+00, -6.860771240776493e-04, -2.639355384385891e-06, -8.023543844865456e-09, -1.853834802868771e-11,
 -2.306034065541282e-14,  5.449685276788970e-17,  5.004863204733082e-19,  2.014671331214940e-21,  5.144498723904900e-24,  4.770670201790983e-27, -3.365884551271230e-29,
  1.909273793048176e+00, -5.119448587661505e-04, -2.053598166206566e-06, -6.761330218332975e-09, -1.840202395805862e-11, -3.780528118548006e-14, -3.205422470672388e-17,
  1.884383436993920e-19,  1.325967738446704e-21,  5.241035660343832e-24,  1.457815350082009e-26,  2.313743063786615e-29,  1.937670186758967e+00, -3.577231063734458e-04,
 -1.485353497774165e-06, -5.206975723953513e-09, -1.588230879546482e-11, -4.136386365653154e-14, -8.369543846533798e-17, -7.652532956810807e-20,  3.785438880472850e-22,
  2.872451542007997e-24,  1.233753629202002e-26,  4.011949389557529e-29,  1.960924609568583e+00, -2.273601380329773e-04, -9.704250319951154e-07, -3.570143337964131e-09,
 -1.180795026554348e-11, -3.536465219420398e-14, -9.437765614774443e-17, -2.123333718702263e-19, -3.286047657579717e-22,  1.448665404679177e-25,  4.044312162494735e-27,
  2.203757199468948e-29,  1.978870625567928e+00, -1.242384768177165e-04, -5.414461174855672e-07, -2.064082545445376e-09, -7.223914686815647e-12, -2.362340066172736e-14,
 -7.249530792447904e-17, -2.077144737074297e-19, -5.463701857861580e-22, -1.265963798309155e-24, -2.286944809710061e-27, -1.396486703955186e-30,  1.991378911987105e+00,
 -5.106086078974852e-05, -2.257385833145936e-07, -8.814510243589928e-10, -3.200697807601383e-12, -1.104656283988812e-14, -3.661869829002159e-17, -1.171729603547801e-19,
 -3.624918564858887e-22, -1.083104689719434e-24, -3.113828889624516e-27, -8.547436986210942e-30,  1.998361290750715e+00, -9.745019981285678e-06, -4.342504667779176e-08,
 -1.718037973929956e-10, -6.362913171078846e-13, -2.258291197382715e-15, -7.776164251464332e-18, -2.616698018280746e-20, -8.643997320937369e-23, -2.811502728210110e-25,
 -9.021717582993827e-28, -2.859838803903610e-30,  5.138015247837887e-04, -2.620873205533137e-06,  1.002428359891937e-08, -3.407045408112719e-11,  1.085178408886797e-13,
 -3.316615491773449e-16,  9.849462161214571e-19, -2.863546729315834e-21,  8.189231206942346e-24, -2.311235982910330e-26,  6.451980211238265e-29, -1.784501808062902e-31,
  4.622013708929033e-03, -2.353559296940952e-05,  8.969567064862998e-08, -3.030047426931040e-10,  9.562033934731985e-13, -2.884309191432278e-15,  8.414915397509212e-18,
 -2.390374454510009e-20,  6.636763945043118e-23, -1.804946852642551e-25,  4.812911237115031e-28, -1.258390829902521e-30,  1.282669632132291e-02, -6.508667548937276e-05,
  2.462635145910339e-07, -8.217177529457220e-10,  2.544448822532727e-12, -7.468181103540396e-15,  2.097793457337419e-17, -5.660838529677166e-20,  1.467168570972651e-22,
 -3.638031833224186e-25,  8.553563194945541e-28, -1.873019015511183e-30,  2.510432588198606e-02, -1.267193069732781e-04,  4.742439635406693e-07, -1.552856104391257e-09,
  4.668369121496170e-12, -1.311238514529066e-14,  3.454780070328017e-17, -8.490888816034157e-20,  1.911813811762870e-22, -3.772074007814708e-25,  5.693059280817206e-28,
 -2.116019747788857e-31,  4.141951770452805e-02, -2.076060506494301e-04,  7.655757970339320e-07, -2.442753308336508e-09,  7.043444498286016e-12, -1.853274631135889e-14,
  4.402909261440520e-17, -9.080154274938473e-20,  1.433031954525779e-22, -6.779736032052422e-26, -7.032231153792867e-28,  4.060440609090402e-30,  6.172490782415658e-02,
 -3.066526803332069e-04,  1.109816555292352e-06, -3.424179724989615e-09,  9.331208259327986e-12, -2.231737029110637e-14,  4.446873868303468e-17, -6.007612651144625e-20,
 -2.590698321495296e-23,  5.716171671944682e-25, -2.643053292002801e-27,  8.793742469030462e-30,  8.596099776376651e-02, -4.225061116407147e-04,  1.494401689126055e-06,
 -4.419865049054590e-09,  1.117076018158140e-11, -2.314077007243419e-14,  3.223061318942501e-17,  1.237502547640057e-20, -2.985677026495838e-22,  1.351246502787251e-24,
 -4.247016042096196e-27,  9.979306097738001e-30,  1.140559641184386e-01, -5.535645586453891e-04,  1.904964466408134e-06, -5.346669556425945e-09,  1.221389212788248e-11,
 -1.998148961020024e-14,  6.022450384004947e-18,  1.190694710186918e-19, -6.045288514790588e-22,  1.916530474500433e-24, -4.198067615441522e-27,  4.023267392859811e-30,
  1.459254355571204e-01, -6.979900710725515e-04,  2.325713502800407e-06, -6.120249588874706e-09,  1.216123077278830e-11, -1.231609567502395e-14, -3.242777898082274e-17,
  2.393835103969486e-19, -8.340551576276270e-22,  1.866680226971850e-24, -1.543161065617737e-27, -9.366090423024315e-30,  1.814722405410111e-01, -8.537236308086106e-04,
  2.739863721717775e-06, -6.660032865527288e-09,  1.079654189084891e-11, -2.629190599804486e-16, -7.820922323276128e-17,  3.424936673935418e-19, -8.675875585111740e-22,
  9.278448578568085e-25,  3.602415191635406e-27, -2.539004319531327e-29,  2.205861298573894e-01, -1.018503005326070e-03,  3.130115261586877e-06, -6.894291105928637e-09,
  8.016231173274939e-12,  1.534774216798706e-14, -1.236729605506909e-16,  3.936166357465651e-19, -6.160435672444751e-22, -8.793965066684270e-25,  9.689015617359894e-27,
 -3.500864442549802e-29,  2.631434789808061e-01, -1.189883568076466e-03,  3.479173315071586e-06, -6.765072441357079e-09,  3.851147588416022e-12,  3.299402902007578e-14,
 -1.594848410216164e-16,  3.625388317381011e-19, -6.059328478175333e-23, -3.149735628828916e-24,  1.399786440072142e-26, -2.883979785630196e-29,  3.090069763150157e-01,
 -1.365262300151733e-03,  3.770300093915365e-06, -6.232735930166592e-09, -1.521925637627774e-12,  5.058168737786557e-14, -1.761805015628959e-16,  2.327090984819318e-19,
  7.212082671439066e-22, -5.137780754623042e-24,  1.360005296325475e-26, -2.818742363822180e-30,  3.580253045510671e-01, -1.541905181393278e-03,  3.987888068624381e-06,
 -5.279817389318137e-09, -7.781198282934482e-12,  6.565898814277701e-14, -1.660112453172709e-16,  8.720081366963442e-21,  1.554560174715713e-21, -5.956160730275358e-24,
  6.749043802288984e-27,  3.715348104835145e-29,  4.100328237089232e-01, -1.716978160124023e-03,  4.118041359429664e-06, -3.913952356607185e-09, -1.447457343126914e-11,
  7.571182099938471e-14, -1.247821575794729e-16, -2.800222511239895e-19,  2.198085800047034e-21, -4.889426695896480e-24, -5.843637628990500e-27,  7.469838757270867e-29,
  4.648492659167651e-01, -1.887581855950978e-03,  4.149149705974798e-06, -2.169591316554478e-09, -2.104848608088540e-11,  7.851055741641162e-14, -5.333287491494053e-17,
 -5.811497040628766e-19,  2.403753246869693e-21, -1.729927333046673e-24, -2.051151026856750e-26,  8.837229532155815e-29,  5.222794536225862e-01, -2.050790096519826e-03,
  4.072436904222119e-06, -1.082675740359033e-10, -2.689004275900168e-11,  7.246872117505748e-14,  4.168645971357186e-17, -8.273999807701285e-19,  1.993873767386993e-21,
  2.992679325147000e-24, -3.140351307974863e-26,  6.195778817334253e-29,  5.821130547174387e-01, -2.203692313415483e-03,  3.882463097695660e-06,  2.182777488657232e-09,
 -3.138026305901245e-11,  5.696499173866213e-14,  1.480245006343699e-16, -9.501838072005644e-19,  9.344970004304433e-22,  8.009796133320575e-24, -3.254542020171842e-26,
 -4.614487069102882e-30,  6.441243899586776e-01, -2.343439721310872e-03,  3.577558021875905e-06,  4.593740839354816e-09, -3.395479098097390e-11,  3.257648444314501e-14,
  2.491685763102425e-16, -8.963660323306572e-19, -6.195115027343524e-22,  1.160400925035954e-23, -2.059235470055255e-26, -8.980222895269127e-29,  7.080723100811359e-01,
 -2.467295074938634e-03,  3.160160453736871e-06,  6.997215122547606e-09, -3.416706524621160e-11,  1.174354532066869e-15,  3.267662159738356e-16, -6.446172616340071e-19,
 -2.329400691543017e-21,  1.215428869518956e-23,  2.854781586260942e-27, -1.554352988811888e-28,  7.737001620240078e-01, -2.572685638063278e-03,  2.637037996063251e-06,
  9.254882345927420e-09, -3.174777597434967e-11, -3.415615503558088e-14,  3.638497335891951e-16, -2.169588450699530e-19, -3.738041226420325e-21,  8.784442623913700e-24,
  3.062990693845650e-26, -1.626880923786314e-28,  8.407358657109815e-01, -2.657258805983121e-03,  2.019361262213311e-06,  1.122573380616344e-08, -2.665368296523161e-11,
 -6.938964139585937e-14,  3.483587515394953e-16,  3.186088795905536e-19, -4.388772789798808e-21,  1.877344069566284e-24,  5.187851679413405e-26, -9.325695250021708e-29,
  9.088921247073448e-01, -2.718939598432095e-03,  1.322607894759977e-06,  1.277545389554962e-08, -1.909873570196348e-11, -1.000198826654771e-13,  2.762824165188868e-16,
  8.570238871947847e-19, -3.970124164417759e-21, -6.792179228012472e-24,  5.620869329677795e-26,  3.503762030191480e-29,  9.778667957210190e-01, -2.755988985615160e-03,
  5.662750418209494e-07,  1.378644553444190e-08, -9.561113453487891e-12, -1.216640240109401e-13,  1.536776762312792e-16,  1.276632706032711e-18, -2.442873423653572e-21,
 -1.445764817632981e-23,  3.866400206517275e-26,  1.690666439956776e-28,  1.047343443167822e+00, -2.767061732077991e-03, -2.266156986548166e-07,  1.416782073718335e-08,
  1.238555522858682e-12, -1.307382972680309e-13, -3.091242064759227e-18,  1.467907051859147e-18, -1.012857105706548e-22, -1.825534171475601e-23,  3.220278291252254e-27,
  2.417816282781382e-28,  1.116992105710076e+00, -2.751262150585685e-03, -1.030228967482266e-06,  1.386454893965433e-08,  1.238987737981340e-11, -1.251043752905343e-13,
 -1.692808710379531e-16,  1.363912280260202e-18,  2.467522076543913e-21, -1.634483692721791e-23, -3.735538596694099e-26,  2.068349751105013e-28,  1.186470301601910e+00,
 -2.708195865109236e-03, -1.816839500670616e-06,  1.286486963721478e-08,  2.287476775278216e-11, -1.045698932971325e-13, -3.158246977141701e-16,  9.640260476779980e-19,
  4.532903623982817e-21, -8.817581699319470e-24, -6.607721683632813e-26,  6.870296633948888e-29,  1.255424298614339e+00, -2.638015407403468e-03, -2.557953480350203e-06,
  1.120505820634460e-08,  3.167315220389319e-11, -7.112976435431352e-14, -4.149529022584198e-16,  3.425909315921628e-19,  5.445760342674306e-21,  2.054574149755417e-24,
 -6.932722784425250e-26, -1.113277342201149e-28,  1.323490672038268e+00, -2.541457239762793e-03, -3.225596183693553e-06,  8.970707550172575e-09,  3.788208828417606e-11,
 -2.886142985096961e-14, -4.463027535759357e-16, -3.628566599996368e-19,  4.869571560277778e-21,  1.247452691058107e-23, -4.402021085561449e-26, -2.423023532789525e-28,
  1.390298170548204e+00, -2.419867636495395e-03, -3.793717595245850e-06,  6.293871973985596e-09,  4.083416680212053e-11,  1.656194819780095e-14, -4.021027920507567e-16,
 -9.836421207686487e-19,  2.930197731632792e-21,  1.854408056344933e-23, -3.643544837450118e-28, -2.531794266571476e-28,  1.455469904352135e+00, -2.275214801346411e-03,
 -4.239650026495499e-06,  3.345722638240224e-09,  4.019843081379864e-11,  5.870575005585156e-14, -2.899801903963531e-16, -1.365385457567335e-18,  2.125911112152657e-22,
  1.791868540594445e-23,  4.207343404215796e-26, -1.368195220406618e-28,  1.518625862901850e+00, -2.110084682089830e-03, -4.545535262294608e-06,  3.247805340594385e-10,
  3.604659149539467e-11,  9.144175725955948e-14, -1.323127319238666e-16, -1.414031961323419e-18, -2.417353716819718e-21,  1.093537790591011e-23,  6.379967340776490e-26,
  4.133934189434208e-29,  1.579385760420178e+00, -1.927658199899446e-03, -4.699625311016250e-06, -2.558701789839066e-09,  2.886970146777368e-11,  1.100646977964947e-13,
  3.818156557092170e-17, -1.127211850882594e-18, -4.116752597748439e-21,  5.919332211480248e-25,  5.561997588406597e-26,  1.803039032163059e-28,  1.637372196656205e+00,
 -1.731668067344959e-03, -4.697352729812814e-06, -5.101091801910034e-09,  1.953597550430882e-11,  1.122296635362488e-13,  1.858952779126547e-16, -5.983951148902610e-19,
 -4.383415811020542e-21, -8.743638382164755e-24,  2.374122176369538e-26,  2.058742862048266e-28,  1.692214107788745e+00, -1.526334041670388e-03, -4.542066024650531e-06,
 -7.124824653548939e-09,  9.188852291211344e-12,  9.848603806028339e-14,  2.810881007002645e-16,  1.057252496712271e-20, -3.252650816841807e-21, -1.335286230476410e-23,
 -1.374979008413993e-26,  1.171242238096199e-28,  1.743550468615273e+00, -1.316276349960314e-03, -4.245334797042098e-06, -8.496902905859480e-09, -9.053203558994113e-13,
  7.224372951733198e-14,  3.075625899886742e-16,  5.216057546255793e-19, -1.276775785414864e-21, -1.191215898885755e-23, -3.740760561488885e-26, -1.662686557186999e-29,
  1.791034192630044e+00, -1.106408109145069e-03, -3.826749449895256e-06, -9.144199844018456e-09, -9.540117550126822e-12,  3.912105911592140e-14,  2.668883065341143e-16,
  7.997933730380742e-19,  7.173242602354725e-22, -6.014657073880406e-24, -3.761497825260029e-26, -1.072839458756876e-28,  1.834336162047063e+00, -9.018088006458783e-04,
 -3.313171593683399e-06, -9.063394406313615e-09, -1.575405853265585e-11,  5.770487457919800e-15,  1.776209457010136e-16,  7.979150328901094e-19,  1.990316941746276e-21,
  8.520642524536961e-25, -1.926783772718526e-26, -1.096364091398656e-28,  1.873149306186066e+00, -7.075821742537793e-04, -2.737432568226186e-06, -8.323771106033196e-09,
 -1.898530211324890e-11, -2.157679536598731e-14,  6.944112929947439e-17,  5.679527577207439e-19,  2.202919202521427e-21,  5.302152828271813e-24,  3.019848082565351e-27,
 -4.632067874355633e-29,  1.907192635038886e+00, -5.287032510231258e-04, -2.136525804894895e-06, -7.061851362892846e-09, -1.916536968323453e-11, -3.850629418541748e-14,
 -2.615473929884254e-17,  2.340026489717007e-19,  1.525381433843678e-21,  5.843932647522333e-24,  1.554975535631753e-26,  2.080595973680533e-29,  1.936215126764756e+00,
 -3.698602527640343e-04, -1.549389563714072e-06, -5.467820724354556e-09, -1.672983904090103e-11, -4.339679883421129e-14, -8.565231485609753e-17, -6.265861070756445e-20,
  4.912733592873303e-22,  3.402663985706840e-24,  1.420839817605973e-26,  4.496680398089030e-29,  1.959999366278902e+00, -2.352981714955939e-04, -1.014424060172365e-06,
 -3.764853997745874e-09, -1.253838163528679e-11, -3.770224220606418e-14, -1.004691875192117e-16, -2.227320861168372e-19, -3.202322943545533e-22,  3.273260608743047e-25,
  5.112053469043967e-27,  2.662379364139771e-29,  1.978364848830393e+00, -1.286711231562901e-04, -5.669245069952877e-07, -2.183541471953804e-09, -7.714263061950620e-12,
 -2.543509853465572e-14, -7.856306493628228e-17, -2.259452777198807e-19, -5.936043708000124e-22, -1.358455900477924e-24, -2.331872678392820e-27, -6.007610099222543e-31,
  1.991170988484733e+00, -5.290996680188278e-05, -2.366307111109836e-07, -9.344785296564071e-10, -3.430690230587097e-12, -1.196612939048226e-14, -4.006797503358838e-17,
 -1.294213615265972e-19, -4.038191324965635e-22, -1.215501461556105e-24, -3.514218831142938e-27, -9.674789517124840e-30,  1.998321602564008e+00, -1.010084350796343e-05,
 -4.554930022611722e-08, -1.823561800318411e-10, -6.833844231901255e-13, -2.454033419129165e-15, -8.549137509144790e-18, -2.910222057621488e-20, -9.724246485232294e-23,
 -3.198858003265470e-25, -1.038004567625984e-27, -3.326859065749512e-30,  5.034758721612787e-04, -2.542285297599258e-06,  9.625641053236303e-09, -3.238597684279111e-11,
  1.021146523145765e-13, -3.089561308057733e-16,  9.083140633982516e-19, -2.614320911195379e-21,  7.401809422030572e-24, -2.068192758551741e-26,  5.716138985860434e-29,
 -1.565325018041327e-31,  4.529283800911723e-03, -2.283231605851805e-05,  8.614954055106673e-08, -2.881562281401260e-10,  9.004837909231637e-13, -2.690148768442174e-15,
  7.774392291603558e-18, -2.188033509092676e-20,  6.020342023774667e-23, -1.623063459205244e-25,  4.291823053125533e-28, -1.113298003562447e-30,  1.257022834737243e-02,
 -6.315532891125369e-05,  2.366423268040618e-07, -7.821746550547909e-10,  2.399994208280410e-12, -6.983212432482479e-15,  1.945670619445036e-17, -5.211655128948444e-20,
  1.342164022470596e-22, -3.311863535646564e-25,  7.767175141956532e-28, -1.703808143155459e-30,  2.460492030718605e-02, -1.229986422036621e-04,  4.560493433002951e-07,
 -1.480215925792719e-09,  4.414223837524041e-12, -1.231108839374983e-14,  3.225399086417942e-17, -7.900398103075275e-20,  1.780092040059339e-22, -3.546611379133305e-25,
  5.570936320261935e-28, -3.371699041126563e-31,  4.060115973343919e-02, -2.015968084160691e-04,  7.369268800324970e-07, -2.332966876975654e-09,  6.683153284187765e-12,
 -1.750604166351037e-14,  4.155044558605287e-17, -8.625998382265287e-20,  1.403973158190458e-22, -9.256137738108204e-26, -5.399315843303526e-28,  3.380020306098873e-30,
  6.051579746898039e-02, -2.979360039775302e-04,  1.069607651390692e-06, -3.278393758225338e-09,  8.895396692074875e-12, -2.127038151772338e-14,  4.277795321852471e-17,
 -6.059556544783026e-20, -7.141458524189826e-24,  4.733118682968146e-25, -2.279963035730300e-27,  7.729358578259111e-30,  8.429455207802833e-02, -4.107600481036963e-04,
  1.442420565025069e-06, -4.244793281690367e-09,  1.071570280075804e-11, -2.236411317144603e-14,  3.245043967691358e-17,  3.567236691048980e-21, -2.528767147827666e-22,
  1.189943546803268e-24, -3.823224037201139e-27,  9.280511729560214e-30,  1.118717836185959e-01, -5.385781911895448e-04,  1.841963806035307e-06, -5.154435372423885e-09,
  1.181596674223397e-11, -1.979906683345175e-14,  9.095709921086281e-18,  1.007964200734556e-19, -5.385116593869155e-22,  1.752368408113670e-24, -4.005087665824402e-27,
  4.703562811604104e-30,  1.431702261948049e-01, -6.796748461597409e-04,  2.253429726387965e-06, -5.927680532180289e-09,  1.190765378919148e-11, -1.301688380624832e-14,
 -2.608868429103740e-17,  2.137562825794459e-19, -7.680576950129698e-22,  1.797514041355563e-24, -1.896153135832377e-27, -6.757141450684894e-30,  1.781006818193563e-01,
 -8.321214669992851e-04,  2.660979300244586e-06, -6.487429042647856e-09,  1.077327399265631e-11, -2.027967936606686e-15, -6.900287230755880e-17,  3.152910001802683e-19,
 -8.318499415455107e-22,  1.050767762570561e-24,  2.571969520214706e-27, -2.151286776355011e-29,  2.165616788218387e-01, -9.937908064923302e-04,  3.048162943765127e-06,
 -6.763733331145829e-09,  8.294385601380041e-12,  1.250959203922878e-14, -1.129319254656753e-16,  3.734685491232439e-19, -6.410888024199132e-22, -5.217434862378699e-25,
  8.216106464718920e-27, -3.192523436888003e-29,  2.584390988793154e-01, -1.162373808704051e-03,  3.398383267756992e-06, -6.698379557408526e-09,  4.473572481943307e-12,
  2.928788580672786e-14, -1.493771898884047e-16,  3.588911682373430e-19, -1.642128909188210e-22, -2.615381950782447e-24,  1.271686770751878e-26, -2.924820806366822e-29,
  3.036057777430604e-01, -1.335399409286086e-03,  3.695393803780858e-06, -6.249221149604575e-09, -5.520346598530896e-13,  4.643398632912224e-14, -1.693686045586558e-16,
  2.529330439595023e-19,  5.459941219292946e-22, -4.598016950905036e-24,  1.334714429827812e-26, -8.449428027359578e-30,  3.519210859103001e-01, -1.510257526168874e-03,
  3.923825899082859e-06, -5.394027420775928e-09, -6.507813223908436e-12,  6.168307330495885e-14, -1.651024857303469e-16,  5.509037684890487e-20,  1.345364126935835e-21,
 -5.656513076653013e-24,  8.160965442377429e-27,  2.721760937842475e-29,  4.032304968619421e-01, -1.684225522033524e-03,  4.069733807878726e-06, -4.133596880991726e-09,
 -1.299087943728124e-11,  7.263074592049164e-14, -1.316647850171745e-16, -2.125386761783061e-19,  2.018624212051774e-21, -5.060394098007774e-24, -2.777992767066897e-27,
  6.464521075583358e-29,  4.573651520734313e-01, -1.854498405017212e-03,  4.121145532460073e-06, -2.493880327688565e-09, -1.949234821292912e-11,  7.704393107121514e-14,
 -6.853863273602001e-17, -5.053768418522326e-19,  2.327635335551032e-21, -2.473672288679219e-24, -1.670507413049563e-26,  8.435214381589692e-29,  5.141414338184875e-01,
 -2.018223001754184e-03,  4.068604233460946e-06, -5.268666495919716e-10, -2.543250247551179e-11,  7.319849067771939e-14,  1.942701521279976e-17, -7.621091990015389e-19,
  2.079677835317302e-21,  1.793338938653155e-24, -2.851278322480961e-26,  6.892694590326851e-29,  5.733605588300912e-01, -2.172536282949814e-03,  3.905682119893358e-06,
  1.689991720708783e-09, -3.020757379917918e-11,  6.020195458726192e-14,  1.218795657555296e-16, -9.159175737018490e-19,  1.199418710865575e-21,  6.709445541896882e-24,
 -3.234038283952138e-26,  1.346834793074922e-29,  6.348082081553388e-01, -2.314607941694022e-03,  3.629445781579167e-06,  4.055992768172116e-09, -3.324550375270770e-11,
  3.825349126227615e-14,  2.238544109525191e-16, -9.096727920603839e-19, -2.174849937071475e-22,  1.070797573082548e-23, -2.404464996975590e-26, -6.720506257913144e-29,
  6.982542110226403e-01, -2.441687213902286e-03,  3.240849135157017e-06,  6.451149795364027e-09, -3.406665807005912e-11,  8.792133964295802e-15,  3.077392210500736e-16,
 -7.121482953986783e-19, -1.891399801471309e-21,  1.213605598712146e-23, -3.653067567401687e-27, -1.398875999964407e-28,  7.634523031950244e-01, -2.551153783983282e-03,
  2.745027785339182e-06,  8.741925100776933e-09, -3.234413578853022e-11, -2.550987604681340e-14,  3.561493892529061e-16, -3.312939397332392e-19, -3.401483940952727e-21,
  9.865341101038663e-24,  2.339710018135105e-26, -1.651555937946385e-28,  8.301399830526772e-01, -2.640572432971542e-03,  2.151466996229019e-06,  1.078862954448764e-08,
 -2.795722878874433e-11, -6.093777201802204e-14,  3.553265968293877e-16,  1.796415263691960e-19, -4.284892827933737e-21,  3.863017041695051e-24,  4.723133607165685e-26,
 -1.171108664973353e-28,  8.980384914430709e-01, -2.707750857993249e-03,  1.474015038438698e-06,  1.245423911320924e-08, -2.103095694086331e-11, -9.311571097034718e-14,
  2.984668184310613e-16,  7.265039101961989e-19, -4.173900382549292e-21, -4.523916553947013e-24,  5.693653019116908e-26, -1.724301656525676e-30,  9.668529440355186e-01,
 -2.750799820085486e-03,  7.307149050333464e-07,  1.361421385960254e-08, -1.195466354163878e-11, -1.175561145195533e-13,  1.882529496584552e-16,  1.190445657361593e-18,
 -2.933798961868686e-21, -1.277127617099565e-23,  4.542482686309524e-26,  1.375417360205109e-28,  1.036272647356365e+00, -2.768194464063818e-03, -5.656921066163593e-08,
  1.416672942712847e-08, -1.373627572189496e-12, -1.303202424003942e-13,  3.786627884166739e-17,  1.454196416152126e-18, -7.536092368402573e-22, -1.791538140235763e-23,
  1.372291896011143e-26,  2.342612968581409e-28,  1.105971631655249e+00, -2.758835305457499e-03, -8.627482000589162e-07,  1.404256267334047e-08,  9.850299587781884e-12,
 -1.287004726649915e-13, -1.300762861808465e-16,  1.433188246520703e-18,  1.854476012949071e-21, -1.764937789524740e-23, -2.769511255452097e-26,  2.310575275246336e-28,
  1.175609435010594e+00, -2.722107007010343e-03, -1.660335411715293e-06,  1.321373237141240e-08,  2.070984177080727e-11, -1.118096936951818e-13, -2.868525469491543e-16,
  1.103496647190624e-18,  4.168747327965406e-21, -1.138664199171667e-23, -6.204244036719454e-26,  1.144414386523071e-28,  1.244832173329003e+00, -2.657932688970055e-03,
 -2.420500847902174e-06,  1.169991039715630e-08,  3.015184720646886e-11, -8.095378260165084e-14, -4.029134039263881e-16,  5.174946289796462e-19,  5.468738807292626e-21,
 -8.043264011665920e-25, -7.330632434906375e-26, -6.858482582078542e-29,  1.313273929798153e+00, -2.566821159008215e-03, -3.114331955007398e-06,  9.571618022742812e-09,
  3.719701678489927e-11, -3.967660511369842e-14, -4.542162025123310e-16, -2.002055251938607e-19,  5.284422878961240e-21,  1.050417284087440e-23, -5.438914425683430e-26,
 -2.274221368321208e-28,  1.380558494564131e+00, -2.449904142787382e-03, -3.714261844251779e-06,  6.949335046738755e-09,  4.106672757067014e-11,  6.592189233220363e-15,
 -4.282318306596016e-16, -8.792194336948832e-19,  3.594772985979762e-21,  1.829970996706095e-23, -1.201498070146911e-26, -2.752299568028821e-28,  1.446301480571916e+00,
 -2.308960386186981e-03, -4.195604820026008e-06,  3.997899340207396e-09,  4.129986041854567e-11,  5.128883205560447e-14, -3.280165228432379e-16, -1.347949141099608e-18,
  8.863850493133953e-22,  1.946794940874113e-23,  3.506054154405389e-26, -1.819921892658530e-28,  1.510112834316260e+00, -2.146423432246602e-03, -4.538117667581385e-06,
  9.159705293291917e-10,  3.784042099290364e-11,  8.778277724289168e-14, -1.729258901505524e-16, -1.484593075302575e-18, -1.977407588520215e-21,  1.351248521336977e-23,
  6.476451119573942e-26,  1.368477016875528e-30,  1.571599750461144e+00, -1.965369999947238e-03, -4.727485467138825e-06, -2.079137424416110e-09,  3.107752568978460e-11,
  1.105874614341101e-13,  4.781682609802822e-18, -1.258162225195944e-18, -4.053507943397976e-21,  2.972731826693256e-24,  6.333950776672779e-26,  1.692410369303718e-28,
  1.630369986788842e+00, -1.769486255670076e-03, -4.756615537247657e-06, -4.770323025778819e-09,  2.182374335541948e-11,  1.164739551662118e-13,  1.671305350772220e-16,
 -7.434993714109074e-19, -4.678851780911169e-21, -7.606468440992792e-24,  3.326858863732831e-26,  2.266241588722455e-28,  1.686035560807880e+00, -1.563009910003362e-03,
 -4.626615602818770e-06, -6.961678828594142e-09,  1.122599549171061e-11,  1.052234955557691e-13,  2.798539825941665e-16, -1.012990357269133e-19, -3.741922884652584e-21,
 -1.378998564928505e-23, -7.858623257672546e-27,  1.511295826490379e-28,  1.738216791894504e+00, -1.350647013482832e-03, -4.347335549303941e-06, -8.499423095765077e-09,
  6.145266783406706e-13,  7.979546778981380e-14,  3.215290215569019e-16,  4.735976760718151e-19, -1.732666878294438e-21, -1.341682047979550e-23, -3.766020684634759e-26,
  6.072318290919019e-30,  1.786546633660965e+00, -1.137463559485648e-03, -3.937368731162303e-06, -9.290226674977047e-09, -8.691816725068043e-12,  4.579749220785722e-14,
  2.895692069777593e-16,  8.189836588882446e-19,  4.725723326462371e-22, -7.614042340823743e-24, -4.235757357376197e-26, -1.077198804650296e-28,  1.830675221244954e+00,
 -9.287534911165842e-04, -3.423440136317952e-06, -9.314296721187595e-09, -1.559417279005345e-11,  1.030870937802755e-14,  2.008577234505450e-16,  8.619374994912844e-19,
  2.005913006697397e-21, -1.984194921969799e-26, -2.444529187146005e-26, -1.258061412137353e-28,  1.870274538628533e+00, -7.298863719958432e-04, -2.839154342743541e-06,
 -8.630892123381678e-09, -1.939884211339345e-11, -1.971123327939847e-14,  8.635955145541100e-17,  6.415192862828801e-19,  2.395441159372093e-21,  5.377902294501471e-24,
  6.568804326917529e-28, -6.153027426986993e-29,  1.905043093484278e+00, -5.461396980479360e-04, -2.223133415039698e-06, -7.374690061201882e-09, -1.994121263936195e-11,
 -3.904966853155572e-14, -1.888680093503027e-17,  2.863027366140517e-19,  1.747170469364493e-21,  6.483221414912760e-24,  1.638665879852424e-26,  1.695157501568565e-29,
  1.934710473454162e+00, -3.825224418763422e-04, -1.616638482186557e-06, -5.742553890501906e-09, -1.761846400706107e-11, -4.547161403418535e-14, -8.716744539365535e-17,
 -4.486428136541617e-20,  6.244896239242638e-22,  4.012054928204453e-24,  1.629825388263122e-26,  5.005960273693224e-29,  1.959041651787675e+00, -2.435977455778638e-04,
 -1.060831306487532e-06, -3.971633615572696e-09, -1.331705017375483e-11, -4.018948628990085e-14, -1.068470834282694e-16, -2.327491329208457e-19, -3.044717341025811e-22,
  5.567678392642934e-25,  6.399499840571865e-27,  3.204429151392829e-29,  1.977840924582404e+00, -1.333134668202331e-04, -5.938846988996273e-07, -2.311143933148835e-09,
 -8.242343899498190e-12, -2.739872201209873e-14, -8.516294799421312e-17, -2.457411244422067e-19, -6.441914117288187e-22, -1.451959273643658e-24, -2.335255414599325e-27,
  5.045665668245961e-31,  1.990955490163979e+00, -5.484881914213493e-05, -2.481818700524204e-07, -9.913376615774334e-10, -3.679930381800085e-12, -1.297274800215067e-14,
 -4.387946077248163e-17, -1.430716865765976e-19, -4.502133046034896e-22, -1.364947536253010e-24, -3.967352232629575e-27, -1.094744799462798e-29,  1.998280456274673e+00,
 -1.047418069093776e-05, -4.780483583727813e-08, -1.936944077437428e-10, -7.345847518988857e-13, -2.669353628651889e-15, -9.409354366540447e-18, -3.240654256401799e-20,
 -1.095423977235717e-22, -3.644889147884603e-25, -1.196152891788831e-27, -3.876546339958551e-30,  4.934583184959170e-04, -2.466807382916112e-06,  9.246612196553827e-09,
 -3.080041536060930e-11,  9.614773125588926e-14, -2.880089126812047e-16,  8.383202277790152e-19, -2.388947634877952e-21,  6.696809524634339e-24, -1.852742009957526e-26,
  5.070267682989876e-29, -1.374837532099501e-31,  4.439311369929573e-03, -2.215671032564907e-05,  8.277636903828819e-08, -2.741689779329522e-10,  8.484981476992190e-13,
 -2.510702733296228e-15,  7.187858718158096e-18, -2.004409428509231e-20,  5.465795234486112e-23, -1.460800367332699e-25,  3.830613637400938e-28, -9.858195625872903e-31,
  1.232133477149059e-02, -6.129909233391311e-05,  2.274821023173807e-07, -7.448671777236191e-10,  2.264883831035499e-12, -6.533288124319725e-15,  1.805582124109046e-17,
 -4.800653731957183e-20,  1.228352900456686e-22, -3.015702897880141e-25,  7.052173116361836e-28, -1.548422810369138e-30,  2.412011170218409e-02, -1.194201155961000e-04,
  4.387025265742017e-07, -1.411516800018162e-09,  4.175567123558505e-12, -1.156290591379179e-14,  3.011973857817077e-17, -7.350770135708080e-20,  1.656386664390262e-22,
 -3.327031579469011e-25,  5.401428605272478e-28, -4.282411910801507e-31,  3.980638855606004e-02, -1.958115842294186e-04,  7.095614795237592e-07, -2.228784021415964e-09,
  6.342811530374229e-12, -1.653730986829914e-14,  3.919753500840928e-17, -8.182447317993164e-20,  1.367105720810122e-22, -1.113613361212760e-25, -4.042766307812247e-28,
  2.801723989777545e-30,  5.934092139122641e-02, -2.895341180903295e-04,  1.031107025039797e-06, -3.139415466882775e-09,  8.480118270861957e-12, -2.026408144287672e-14,
  4.108051785436868e-17, -6.056841798908580e-20,  8.335518108255417e-24,  3.886268468271957e-25, -1.961228948498194e-27,  6.776242211740983e-30,  8.267427208072317e-02,
 -3.994215527082834e-04,  1.392497129923895e-06, -4.076877961606674e-09,  1.027621217177195e-11, -2.158497988328441e-14,  3.244326764503626e-17, -3.868139753510161e-21,
 -2.126949571671879e-22,  1.044972795474686e-24, -3.430480276738494e-27,  8.571398201972531e-30,  1.097465550354026e-01, -5.240867097090833e-04,  1.781231887948832e-06,
 -4.968534969151516e-09,  1.142238716188501e-11, -1.954879226082374e-14,  1.168602222651140e-17,  8.454290564654006e-20, -4.782588423441673e-22,  1.596448097080617e-24,
 -3.787764442964787e-27,  5.138693528251935e-30,  1.404871357282546e-01, -6.619287181291353e-04,  2.183431998865254e-06, -5.739272806852998e-09,  1.164152552640304e-11,
 -1.357390815940416e-14, -2.043797761272800e-17,  1.901986251112814e-19, -7.047779420195385e-22,  1.716388903321553e-24, -2.144349807155423e-27, -4.593240963094455e-30,
  1.748142827077106e-01, -8.111421025132694e-04,  2.584162764181201e-06, -6.315468165472969e-09,  1.071685362971032e-11, -3.581071447357503e-15, -6.054157517010189e-17,
  2.892951120522584e-19, -7.923889564703091e-22,  1.135769509689483e-24,  1.703504264681562e-27, -1.802721182812647e-29,  2.126347753681659e-01, -9.697278879939184e-04,
  2.967802193729225e-06, -6.629165376514896e-09,  8.518308760450115e-12,  9.922377928868850e-15, -1.027644009780165e-16,  3.527139190543969e-19, -6.542861187369489e-22,
 -2.202720813953039e-25,  6.880273184350419e-27, -2.879493840179872e-29,  2.538434704749081e-01, -1.135507004700057e-03,  3.318450884369135e-06, -6.622307718943270e-09,
  5.024290212269128e-12,  2.582274333771583e-14, -1.394152736337980e-16,  3.522255548882755e-19, -2.495202575241923e-22, -2.132393480287269e-24,  1.143505915969072e-26,
 -2.890726305251032e-29,  2.983228313452488e-01, -1.306136302467587e-03,  3.620380092336848e-06, -6.250842681489877e-09,  3.365798216334513e-13,  4.245595035315358e-14,
 -1.620660284257268e-16,  2.678586275424771e-19,  3.899732880095654e-22, -4.072929476411063e-24,  1.287573683301762e-26, -1.277585571027891e-29,  3.459424246967802e-01,
 -1.479127510055131e-03,  3.858512835038026e-06, -5.488497824673786e-09, -5.313627057314251e-12,  5.774380299999029e-14, -1.629873831449849e-16,  9.494906151072440e-20,
  1.147869778082712e-21, -5.308784490682400e-24,  9.161763510380644e-27,  1.847170297549749e-29,  3.965583915170086e-01, -1.651869488466238e-03,  4.018930895803960e-06,
 -4.330003617727376e-09, -1.157030909760692e-11,  6.940650846883959e-14, -1.367390326993252e-16, -1.508735471320936e-19,  1.835108572618195e-21, -5.117565438091935e-24,
 -1.528523443372738e-28,  5.472570111480221e-29,  4.500128999155514e-01, -1.821654132429133e-03,  4.089398249802967e-06, -2.793524905359653e-09, -1.796902192458095e-11,
  7.523752727919485e-14, -8.166066903359230e-17, -4.324391402815859e-19,  2.227436074012769e-21, -3.069188990299110e-24, -1.311140806116450e-26,  7.877847045435802e-29,
  5.061335898181137e-01, -1.985706263735527e-03,  4.059888686994976e-06, -9.220567171600675e-10, -2.396555955199276e-11,  7.341624239940856e-14, -9.721756910131065e-19,
 -6.947406446009064e-19,  2.124452732704806e-21,  7.148709308900891e-25, -2.538131247877922e-26,  7.295624984122272e-29,  5.647330215737656e-01, -2.141217830351575e-03,
  3.923102317935507e-06,  1.216453144874556e-09, -2.897633758329507e-11,  6.282386724946817e-14,  9.680575289581258e-17, -8.739197585237295e-19,  1.417859514871223e-21,
  5.432365691057112e-24, -3.140301166229826e-26,  2.865254440900454e-29,  6.256081430892414e-01, -2.285386670566773e-03,  3.674952295615591e-06,  3.530468503144310e-09,
 -3.242877458420059e-11,  4.331991005884401e-14,  1.983427360606214e-16, -9.106555370245873e-19,  1.500364972915288e-22,  9.693530397413105e-24, -2.651930001627223e-26,
 -4.547806618484167e-29,  6.885397929798434e-01, -2.415460015824778e-03,  3.314999617416195e-06,  5.907884402080676e-09, -3.381860676807364e-11,  1.593215653356958e-14,
  2.870171327061815e-16, -7.657226559677045e-19, -1.458568659220508e-21,  1.187199203569415e-23, -9.418669319914892e-27, -1.218529382624923e-28,  7.532922604224751e-01,
 -2.528782782674923e-03,  2.846810508228613e-06,  8.220798395854550e-09, -3.276967098269511e-11, -1.708557096755177e-14,  3.454038909050570e-16, -4.342925566650632e-19,
 -3.031233429330140e-21,  1.065635915812726e-23,  1.617457394968931e-26, -1.623140251280547e-28,  8.196129258746820e-01, -2.622850536757527e-03,  2.278207942774797e-06,
  1.033202861942806e-08, -2.909037790301953e-11, -5.236492703430251e-14,  3.584603737041338e-16,  4.510424441643945e-20, -4.113113211931847e-21,  5.643392614687591e-24,
  4.165349457075075e-26, -1.354982178285110e-28,  8.872320105146200e-01, -2.695366793602634e-03,  1.621386758525745e-06,  1.210324113213836e-08, -2.282006999621982e-11,
 -8.572362962184900e-14,  3.169176669528964e-16,  5.907720972345580e-19, -4.295880448606312e-21, -2.258380429199179e-24,  5.608736738182428e-26, -3.642940216887900e-29,
  9.558624660498140e-01, -2.744304047283385e-03,  8.928610622882513e-07,  1.340438688332576e-08, -1.425796177636503e-11, -1.126490746079924e-13,  2.202045337792373e-16,
  1.089569751652180e-18, -3.359492207048998e-21, -1.084335684559332e-23,  5.071571099659615e-26,  1.024958130803356e-28,  1.025200040276028e+00, -2.767967586060769e-03,
  1.132138604961156e-07,  1.412396331214923e-08, -3.967662992725873e-12, -1.289261584178854e-13,  7.815007448812761e-17,  1.419887535196863e-18, -1.386233703149682e-21,
 -1.716430559990053e-23,  2.371832774335819e-26,  2.188212432099155e-28,  1.094923557220276e+00, -2.765060765426684e-03, -6.933772734186293e-07,  1.417941952864856e-08,
  7.248354435639514e-12, -1.313346407315343e-13, -8.921313595416652e-17,  1.482171852648381e-18,  1.201658486574778e-21, -1.854842905242308e-23, -1.713798869188031e-26,
  2.474470622213762e-28,  1.164695453585142e+00, -2.734749970400985e-03, -1.499857455165252e-06,  1.352683700450617e-08,  1.840738225275164e-11, -1.183087013893133e-13,
 -2.541520204588576e-16,  1.229869518162541e-18,  3.715489688991845e-21, -1.375466271761217e-23, -5.604364794494162e-26,  1.576530478488682e-28,  1.234162615164556e+00,
 -2.676727025189098e-03, -2.277262462890845e-06,  1.216886722994561e-08,  2.843734802745270e-11, -9.043009826039756e-14, -3.859819773067066e-16,  6.914599679392009e-19,
  5.386399841215224e-21, -3.783185241349090e-24, -7.528856873681080e-26, -2.082602179883808e-29,  1.302957557493095e+00, -2.591266323559228e-03, -2.995929734662451e-06,
  1.015982817870535e-08,  3.629411890969952e-11, -5.062562063615071e-14, -4.574007922913246e-16, -2.549266930356054e-20,  5.621059532344446e-21,  8.135004400616916e-24,
 -6.389033379475965e-26, -2.028567882817754e-28,  1.370699993731152e+00, -2.479273492957685e-03, -3.626924898140835e-06,  7.606890895290588e-09,  4.109387139454858e-11,
 -3.967188920021253e-15, -4.511412784579806e-16, -7.537628068406468e-19,  4.241948497038214e-21,  1.757211651849293e-23, -2.446785043626851e-26, -2.893686052694736e-28,
  1.436998829148749e+00, -2.342322016900203e-03, -4.143632811161728e-06,  4.666462820061261e-09,  4.224387529225578e-11,  4.296738662068625e-14, -3.652548026323467e-16,
 -1.308117068533415e-18,  1.610424556335168e-21,  2.069701294888138e-23,  2.606863986131724e-26, -2.264426718522932e-28,  1.501454615023060e+00, -2.182673982513212e-03,
 -4.523436173534093e-06,  1.535222758177197e-09,  3.955117228567468e-11,  8.312704964347155e-14, -2.153036838129568e-16, -1.539587611635573e-18, -1.444433082280533e-21,
  1.609100940254045e-23,  6.382222319038097e-26, -4.522585202875767e-29,  1.563662484834801e+00, -2.003281061120813e-03, -4.749378699202237e-06, -1.564209024204529e-09,
  3.328749374284420e-11,  1.102649385468258e-13, -3.224317369547026e-17, -1.385658934601446e-18, -3.899136190859957e-21,  5.650101207469268e-24,  7.038542957142162e-26,
  1.495201345940413e-28,  1.623215581988487e+00, -1.807762040995148e-03, -4.811686775504627e-06, -4.402296746695508e-09,  2.419155905352199e-11,  1.202181101409493e-13,
  1.441772065202572e-16, -8.973272972644311e-19, -4.926279964559814e-21, -6.071073114273810e-24,  4.362154057978637e-26,  2.431216254634834e-28,  1.679708970755260e+00,
 -1.600353779634072e-03, -4.709007426818270e-06, -6.764863425539102e-09,  1.339732873001337e-11,  1.118919633234208e-13,  2.752662426296074e-16, -2.290306310189416e-19,
 -4.242321898313164e-21, -1.396075163072936e-23, -4.139776594008395e-28,  1.875932555364891e-28,  1.732744000914975e+00, -1.385833378999592e-03, -4.449215596709479e-06,
 -8.476399730109104e-09,  2.288642807107178e-12,  8.766457113279171e-14,  3.339388423935906e-16,  4.101345016834634e-19, -2.242651600721188e-21, -1.490991723479796e-23,
 -3.678657130619715e-26,  3.464529886827696e-29,  1.781933072223355e+00, -1.169410732285255e-03, -4.049654394812349e-06, -9.421582721471060e-09, -7.704505102949475e-12,
  5.302377531280825e-14,  3.126688697508026e-16,  8.293840506445744e-19,  1.668330433001387e-22, -9.402424369769353e-24, -4.703597332636749e-26, -1.041936081601103e-28,
  1.826904718386446e+00, -9.565923226525704e-04, -3.536701062654131e-06, -9.561883837791769e-09, -1.533780041636621e-11,  1.542615144152509e-14,  2.258891054701546e-16,
  9.259154509947283e-19,  1.986219793432249e-21, -1.113225146710477e-24, -3.034448345153727e-26, -1.423568345276396e-28,  1.867308903235567e+00, -7.530191952432435e-04,
 -2.944599964630879e-06, -8.944308516272462e-09, -1.977083999554145e-11, -1.741421271384014e-14,  1.054243583282181e-16,  7.212705498694112e-19,  2.588820126483167e-21,
  5.344937528356238e-24, -2.436402955073265e-27, -7.955933876731879e-29,  1.902822396345135e+00, -5.642842340025312e-04, -2.313569897019532e-06, -7.700019196712634e-09,
 -2.072605592475998e-11, -3.940021605086114e-14, -1.005159481131357e-17,  3.460744012620304e-19,  1.992530750266710e-21,  7.152055643270195e-24,  1.701288697336305e-26,
  1.115433167689034e-29,  1.933154074179299e+00, -3.957360544000739e-04, -1.687270881943199e-06, -6.031838823936151e-09, -1.854890597331006e-11, -4.757631090387922e-14,
 -8.812123821926407e-17, -2.243944722276203e-20,  7.812031326932479e-22,  4.709571634113378e-24,  1.861569184791958e-26,  5.528960865170589e-29,  1.958049980464864e+00,
 -2.522787186852667e-04, -1.109796329175516e-06, -4.191278300080327e-09, -1.414701667932728e-11, -4.283310061374984e-14, -1.134970805355662e-16, -2.421192615439124e-19,
 -2.794643551015592e-22,  8.427511416336292e-25,  7.946141055703444e-27,  3.842765353675350e-29,  1.977297989692111e+00, -1.381777636171069e-04, -6.224281404910517e-07,
 -2.447518665535799e-09, -8.811327034073542e-12, -2.952758011892761e-14, -9.234028339874886e-17, -2.672095389761903e-19, -6.981343034635104e-22, -1.544515750663843e-24,
 -2.281649593258079e-27,  2.005417814828723e-30,  1.990732047196260e+00, -5.688287934858076e-05, -2.604399464619049e-07, -1.052350798107365e-09, -3.950249509334862e-12,
 -1.407560164110093e-14, -4.809477459236728e-17, -1.582963165419238e-19, -5.023277062651572e-22, -1.533685194867770e-24, -4.479973416667320e-27, -1.238149798697517e-29,
  1.998237779666228e+00, -1.086612065495492e-05, -5.020149124535282e-08, -2.058874459480591e-10, -7.903056673661182e-13, -2.906475300026879e-15, -1.036785298807753e-17,
 -3.613142364728002e-20, -1.235679887001777e-22, -4.159294139627485e-25, -1.380590349668134e-27, -4.524666290682604e-30,  4.837367302801999e-04, -2.394287183880555e-06,
  8.886050788499869e-09, -2.930706223183846e-11,  9.058345430845509e-14, -2.686683005456578e-16,  7.743323179198369e-19, -2.184941626474785e-21,  6.064916702356487e-24,
 -1.661525224219315e-26,  4.502641984286647e-29, -1.209057585559340e-31,  4.351988434556677e-03, -2.150743244909312e-05,  7.956616991002229e-08, -2.609855343644820e-10,
  7.999647203259501e-13, -2.344736052125507e-15,  6.650340858098851e-18, -1.837630746309437e-20,  4.966473341413842e-23, -1.315910625821636e-25,  3.422035707479535e-28,
 -8.737209926707417e-31,  1.207972236269915e-02, -5.951438287136875e-05,  2.187568881003179e-07, -7.096512668936903e-10,  2.138444840496163e-12, -6.115644278704541e-15,
  1.676507436368745e-17, -4.424419893083931e-20,  1.124704880161020e-22, -2.746814032318247e-25,  6.402633304725334e-28, -1.406124265323380e-30,  2.364934478551104e-02,
 -1.159771297595232e-04,  4.221576732392696e-07, -1.346519204006130e-09,  3.951374076107046e-12, -1.086414274504411e-14,  2.813395798299451e-17, -6.839476926464399e-20,
  1.540455247988184e-22, -3.114947747596407e-25,  5.198146081033565e-28, -4.917208969991715e-31,  3.903432821814162e-02, -1.902403735899812e-04,  6.834142300124444e-07,
 -2.129894663046884e-09,  6.021289702245305e-12, -1.562357151576291e-14,  3.696707250838524e-17, -7.751676800206134e-20,  1.324388152453027e-22, -1.252171607820367e-25,
 -2.920849808933170e-28,  2.311314633840425e-30,  5.819904725188137e-02, -2.814336776964814e-04,  9.942349284477122e-07, -3.006922834493273e-09,  8.084558805822898e-12,
 -1.929845746146214e-14,  3.939033506644700e-17, -6.009240538841645e-20,  2.098349851954999e-23,  3.158833934438813e-25, -1.682133837293281e-27,  5.926205968733905e-30,
  8.109855988439886e-02, -3.884745032158863e-04,  1.344547001573770e-06, -3.915869907844407e-09,  9.852286354670793e-12, -2.080837642855487e-14,  3.224514318173237e-17,
 -1.009823211275012e-20, -1.774568828467591e-22,  9.150888430838743e-25, -3.068829695253274e-27,  7.869676794893746e-30,  1.076783346452661e-01, -5.100722670059923e-04,
  1.722693166771116e-06, -4.788888568345340e-09,  1.103439898918800e-11, -1.924159862521856e-14,  1.384739770936207e-17,  7.012938274348519e-20, -4.234586295973342e-22,
  1.449542797344712e-24, -3.555758977352037e-27,  5.378475854624417e-30,  1.378739240259229e-01, -6.447336015346841e-04,  2.115669271362807e-06, -5.555205109292687e-09,
  1.136556068827284e-11, -1.400300486817568e-14, -1.541898768087425e-17,  1.686174546430834e-19, -6.445755360844655e-22,  1.627121576271280e-24, -2.306098859773085e-27,
 -2.818819264027830e-30,  1.716105850337695e-01, -7.907690338302464e-04,  2.509403352311324e-06, -6.144647722015235e-09,  1.063134369778401e-11, -4.939693159202188e-15,
 -5.279007044595419e-17,  2.646045250407957e-19, -7.504572828422203e-22,  1.188985807798461e-24,  9.798897273413799e-28, -1.492685735131504e-29,  2.088028481245597e-01,
 -9.463013391742825e-04,  2.889076090616813e-06, -6.491415545462350e-09,  8.692880566290782e-12,  7.572172795123902e-15, -9.318235893200337e-17,  3.317005788564555e-19,
 -6.575591246912750e-22,  3.051357640164239e-26,  5.681499836012736e-27, -2.570811074833367e-29,  2.493540363544798e-01, -1.109275863702654e-03,  3.239481986843774e-06,
 -6.537965898053155e-09,  5.508079308171861e-12,  2.259415445456360e-14, -1.296756686456285e-16,  3.430984520278633e-19, -3.183576543205162e-22, -1.700196072914798e-24,
  1.018150456905737e-26, -2.799065750539653e-29,  2.931557373654264e-01, -1.277473147455114e-03,  3.545429635207070e-06, -6.238873212704469e-09,  1.147417210995573e-12,
  3.865764435669343e-14, -1.544126195114180e-16,  2.780900043378924e-19,  2.524735132914798e-22, -3.570156244655205e-24,  1.223979208760426e-26, -1.595447868256552e-29,
  3.400872318096378e-01, -1.448524214182436e-03,  3.792178178040408e-06, -5.564488408303976e-09, -4.197631913445455e-12,  5.386798536037704e-14, -1.598427821217934e-16,
  1.286952133239821e-19,  9.635247154046061e-22, -4.928366383327380e-24,  9.804185061441945e-27,  1.092562527820439e-29,  3.900148830718261e-01, -1.619928924264746e-03,
  3.965905329785890e-06, -4.504203148743651e-09, -1.021530490493605e-11,  6.608054376539966e-14, -1.401690416151970e-16, -9.509443114835922e-20,  1.651320570277413e-21,
 -5.078359061233465e-24,  2.043828812008676e-27,  4.520817046130148e-29,  4.427914946997148e-01, -1.789077809550773e-03,  4.054200225764535e-06, -3.069101710554918e-09,
 -1.648480953108910e-11,  7.314032053355642e-14, -9.278836698424820e-17, -3.630235912116415e-19,  2.108323249232383e-21, -3.526219978758548e-24, -9.788824960826014e-27,
  7.210062338089858e-29,  4.982556438501546e-01, -1.953277820042011e-03,  4.046571745547218e-06, -1.293766814410693e-09, -2.249900392028158e-11,  7.316717627756808e-14,
 -1.947065045644209e-17, -6.265360169325508e-19,  2.132692956145930e-21, -2.355791528863596e-25, -2.213067711257725e-26,  7.440614618140544e-29,  5.562310013398539e-01,
 -2.109782407349466e-03,  3.934959877420418e-06,  7.630015717572980e-10, -2.769858167521038e-11,  6.485886736022244e-14,  7.299888769105078e-17, -8.256589443784910e-19,
  1.591153439696458e-21,  4.205272227769086e-24, -2.986261426277016e-26,  4.087975894193084e-29,  6.165256515955384e-01, -2.255826342856748e-03,  3.714234160577986e-06,
  3.018789278711259e-09, -3.151683534789474e-11,  4.777501303175871e-14,  1.729625782729793e-16, -9.004791722253169e-19,  4.794830469131379e-22,  8.598820427588252e-24,
 -2.806874244536594e-26, -2.523983202648486e-29,  6.789314289582390e-01, -2.388665612483261e-03,  3.382659351439689e-06,  5.369702729639520e-09, -3.343284177675077e-11,
  2.255840277871949e-14,  2.649871333173144e-16, -8.056414464714519e-19, -1.039198921122641e-21,  1.139369880936446e-23, -1.435319697332080e-26, -1.022611256600354e-28,
  7.432232904264522e-01, -2.505622636701717e-03,  2.942304371312182e-06,  7.694196048366009e-09, -3.302952557207885e-11, -8.952402231472179e-15,  3.319441888157947e-16,
 -5.250429579233523e-19, -2.637663291629745e-21,  1.116240157569073e-23,  9.182314090297428e-27, -1.548067878144770e-28,  8.091587490170937e-01, -2.604136924981145e-03,
  2.399366563748595e-06,  9.858671781305922e-09, -3.005161968592543e-11, -4.376139713169327e-14,  3.579133836647156e-16, -8.295513716032736e-20, -3.881435912175858e-21,
  7.186143701257203e-24,  3.539165470297486e-26, -1.481860076819297e-28,  8.764773964433897e-01, -2.681821078607331e-03,  1.764379701149044e-06,  1.172482283596385e-08,
 -2.445722302157153e-11, -7.793469982451096e-14,  3.315255749348616e-16,  4.524323796092101e-19, -4.337272764831028e-21, -5.647214155789315e-26,  5.377889932164808e-26,
 -6.787579717379671e-29,  9.449005486726858e-01, -2.736521795690709e-03,  1.052271550118303e-06,  1.315853293934741e-08, -1.645568729736786e-11, -1.070105647735063e-13,
  2.491515893868329e-16,  9.762199289605447e-19, -3.712349127352474e-21, -8.735343460365719e-24,  5.441496023213113e-26,  6.544980753852616e-29,  1.014131052993730e+00,
 -2.766385199381106e-03,  2.822358001371617e-07,  1.403996784651833e-08, -6.524238141731823e-12, -1.265790509866729e-13,  1.171944123327198e-16,  1.365842995325051e-18,
 -1.984806387014801e-21, -1.602917542391823e-23,  3.287343515830648e-26,  1.962189362381947e-28,  1.083853300277386e+00, -2.769925400238376e-03, -5.226154160230809e-07,
  1.427427750367973e-08,  4.603631856995616e-12, -1.329740222491345e-13, -4.727518416372487e-17,  1.509830208250452e-18,  5.242275122663755e-22, -1.901325540505082e-23,
 -6.046352925920970e-27,  2.552646150455661e-28,  1.153733490852571e+00, -2.746094716981431e-03, -1.335847427135813e-06,  1.380210625815733e-08,  1.598306852242643e-11,
 -1.239821511659211e-13, -2.181285773468562e-16,  1.340424126826897e-18,  3.181750214785538e-21, -1.584587822508644e-23, -4.823456047469829e-26,  1.964212916462028e-28,
  1.223420206432945e+00, -2.694353424996215e-03, -2.128567366147706e-06,  1.260889959346541e-08,  2.653777867014377e-11, -9.944200459690417e-14, -3.642326155947590e-16,
  8.610635128306718e-19,  5.195911387677127e-21, -6.798211026855246e-24, -7.509097304334031e-26,  3.018221231315332e-29,  1.292545343300652e+00, -2.614736298509357e-03,
 -2.870562905848827e-06,  1.073183765760807e-08,  3.517187861853153e-11, -6.159122689052883e-14, -4.555559406926516e-16,  1.585568526060420e-19,  5.865851452929085e-21,
  5.410222367386070e-24, -7.210090813575317e-26, -1.688375105332957e-28,  1.360725462851899e+00, -2.507912593733494e-03, -3.531701738635280e-06,  8.263162906705846e-09,
  4.090462590262581e-11, -1.503192787413309e-14, -4.702526354884637e-16, -6.081128518853548e-19,  4.853838896132915e-21,  1.633664981938496e-23, -3.733962206983721e-26,
 -2.940355981298329e-28,  1.427563613911126e+00, -2.375235536685436e-03, -4.083553063409211e-06,  5.348750974710970e-09,  4.301262810425680e-11,  3.376826248174381e-14,
 -4.010472798901279e-16, -1.244480996719085e-18,  2.371770715407934e-21,  2.152796172295209e-23,  1.517556051728745e-26, -2.680403298916482e-28,  1.492651676143010e+00,
 -2.218776898834293e-03, -4.501162673745192e-06,  2.181046342870997e-09,  4.115852395129881e-11,  7.743778947844255e-14, -2.589686725548747e-16, -1.576053124641307e-18,
 -8.198203084983439e-22,  1.858909034436499e-23,  6.070118420001309e-26, -9.746420914029783e-29,  1.555573264654188e+00, -2.041341951286265e-03, -4.764881006077857e-06,
 -1.014022221785146e-09,  3.548183947987239e-11,  1.090116293818219e-13, -7.275391222118260e-17, -1.506621049482504e-18, -3.643540147548364e-21,  8.589201902345910e-24,
  7.635663639413654e-26,  1.202708192210277e-28,  1.615907221793506e+00, -1.846460081429689e-03, -4.862112017956792e-06, -3.995817762643179e-09,  2.662839577383709e-11,
  1.233588583112207e-13,  1.168147353560802e-16, -1.058107288283710e-18, -5.110819550577382e-21, -4.108682056771347e-24,  5.457449474883916e-26,  2.535924152761061e-28,
  1.673231702760003e+00, -1.638346736023756e-03, -4.788824639581157e-06, -6.532246966852005e-09,  1.570063120299359e-11,  1.184055945257976e-13,  2.668773431409592e-16,
 -3.728127133316836e-19, -4.743116948242727e-21, -1.380114046685287e-23,  8.670539879205170e-27,  2.254658627827656e-28,  1.727128836801155e+00, -1.421833212351422e-03,
 -4.550653404283548e-06, -8.425315905431801e-09,  4.122965684980649e-12,  9.580829308215051e-14,  3.443352034133462e-16,  3.295011046779948e-19, -2.805439242061929e-21,
 -1.634110100858952e-23, -3.451885962716022e-26,  6.948912478635571e-29,  1.777189915934724e+00, -1.202262215755473e-03, -4.163416681963810e-06, -9.535955376407031e-09,
 -6.567106282348669e-12,  6.080677853168366e-14,  3.359128382306185e-16,  8.289349459871506e-19, -2.066063851393196e-22, -1.137343164322281e-23, -5.145193002027491e-26,
 -9.559845642532322e-29,  1.823021029319325e+00, -9.853490480539627e-04, -3.652904937737305e-06, -9.804516957457743e-09, -1.497292709613818e-11,  2.116573402074139e-14,
  2.526967972402398e-16,  9.885864649064367e-19,  1.922741940146611e-21, -2.457122498598880e-24, -3.696929279236014e-26, -1.586696866883976e-28,  1.864249025461980e+00,
 -7.770107249792165e-04, -3.053840696361550e-06, -9.263283719689207e-09, -2.009213743088600e-11, -1.463214309012349e-14,  1.268084764540061e-16,  8.071654683142392e-19,
  2.778586000290063e-21,  5.171492260999878e-24, -6.389390749504460e-27, -1.006417138132808e-28,  1.900527649051464e+00, -5.831680915439326e-04, -2.407985866028514e-06,
 -8.037949806009136e-09, -2.151564946864856e-11, -3.951772571323936e-14,  5.707904417115335e-19,  4.140871390220820e-19,  2.262352354342529e-21,  7.840157932821075e-24,
  1.733229444380019e-26,  2.916288071695981e-30,  1.931543667988772e+00, -4.095288680849959e-04, -1.761465415850047e-06, -6.336348600092289e-09, -1.952161689822108e-11,
 -4.969577352808169e-14, -8.837302291420700e-17,  5.420330207606174e-21,  9.647513408408579e-22,  5.504394871452139e-24,  2.116340845951977e-26,  6.049489640395658e-29,
  1.957022784792188e+00, -2.613621847449877e-04, -1.161478537976713e-06, -4.424634186015776e-09, -1.503147221282851e-11, -4.563936285093004e-14, -1.203966017965998e-16,
 -2.505119195983679e-19, -2.429774631593137e-22,  1.196531762610710e-24,  9.797405656725515e-27,  4.591506696811029e-29,  1.976735130332252e+00, -1.432771119949791e-04,
 -6.526641371824242e-07, -2.593347312546301e-09, -9.424659602731764e-12, -3.183610578090025e-14, -1.001433980027809e-16, -2.904568873882482e-19, -7.553534629618221e-22,
 -1.633467876053765e-24, -2.151379435316498e-27,  4.008980410651523e-30,  1.990500267115435e+00, -5.901800803644188e-05, -2.734568772392236e-07, -1.117871142431434e-09,
 -4.243672912683743e-12, -1.528493249056214e-14, -5.276066745585933e-17, -1.752898841485075e-19, -5.609014215932640e-22, -1.724240867105305e-24, -5.059550309046242e-27,
 -1.399368333762147e-29,  1.998193496002888e+00, -1.127783465288467e-05, -5.274997296790243e-08, -2.190112445452150e-10, -8.510077735216456e-13, -3.167904978339613e-15,
 -1.143722062474545e-17, -4.033623495701184e-20, -1.395854037036228e-22, -4.753508168100477e-25, -1.596052829891701e-27, -5.290205951765255e-30,  4.742995652743389e-04,
 -2.324581279777477e-06,  8.542887947132678e-09, -2.789972457469107e-11,  8.539108364649951e-14, -2.507970750780966e-16,  7.157835326125232e-19, -2.000097212992863e-21,
  5.497944850456140e-24, -1.491619610306474e-26,  4.003157643503144e-29, -1.064586812564556e-31,  4.267212231135784e-03, -2.088321631357123e-05,  7.650962020569806e-08,
 -2.485527563297310e-10,  7.546253135218099e-13, -2.191127007785214e-15,  6.157360287149746e-18, -1.686026401950184e-20,  4.516485118105275e-23, -1.186418407271808e-25,
  3.059758956240673e-28, -7.750616935265422e-31,  1.184511181701047e-02, -5.779781852618793e-05,  2.104423969592132e-07, -6.763932048765707e-10,  2.020057290635800e-12,
 -5.727750814769304e-15,  1.557517154729081e-17, -4.079853562746446e-20,  1.030283944005913e-22, -2.502691284197202e-25,  5.812972527167996e-28, -1.276109730629812e-30,
  2.319208994963753e-02, -1.126634427999911e-04,  4.063717214508824e-07, -1.284999436174329e-09,  3.740691087137897e-12, -1.021136158646039e-14,  2.628625939026606e-17,
 -6.364076365733783e-20,  1.432006383239026e-22, -2.911485556764706e-25,  4.971942665546719e-28, -5.332696693378386e-31,  3.828414176072319e-02, -1.848736803411815e-04,
  6.584233804632681e-07, -2.036006323588719e-09,  5.717517018365503e-12, -1.476193275191371e-14,  3.485524295601285e-17, -7.335291468844727e-20,  1.277440378675131e-22,
 -1.349938232790919e-25, -1.997690479903075e-28,  1.896373787462219e-30,  5.708899484002858e-02, -2.736219605677349e-04,  9.589153999224499e-07, -2.880606852381504e-09,
  7.707907482511696e-12, -1.837319453611210e-14,  3.771876818511961e-17, -5.925147447108806e-20,  3.120490963323271e-23,  2.535841837943384e-25, -1.438327431295912e-27,
  5.170815510490234e-30,  7.956588075936895e-02, -3.779034404930583e-04,  1.298488784555095e-06, -3.761520726029696e-09,  9.443831567497521e-12, -2.003849807323202e-14,
  3.188767941459441e-17, -1.527278740690095e-20, -1.466416377752752e-22,  7.990585765783402e-25, -2.737647793247444e-27,  7.188240915379276e-30,  1.056652489111801e-01,
 -4.965176160932888e-04,  1.666273167049466e-06, -4.615398142600594e-09,  1.065304173305354e-11, -1.888718158631711e-14,  1.562896286941356e-17,  5.738665798959929e-20,
 -3.737778626962130e-22,  1.312080778155246e-24, -3.316716861349409e-27,  5.464860241043378e-30,  1.353284224686959e-01, -6.280718271839160e-04,  2.050088601050983e-06,
 -5.375615161427643e-09,  1.108217063976743e-11, -1.431868241032697e-14, -1.097779100794199e-17,  1.489102409607968e-19, -5.876853415179696e-22,  1.532842789779461e-24,
 -2.397381009400808e-27, -1.381980351859975e-30,  1.684871964308471e-01, -7.709858663201881e-04,  2.436684712225861e-06, -5.975402941285778e-09,  1.052046648492773e-11,
 -6.120421593023394e-15, -4.571086707660853e-17,  2.412810780753084e-19, -7.070989547617249e-22,  1.215875610407903e-24,  3.844851584584632e-28, -1.219633447284043e-29,
  2.050633779899962e-01, -9.234979431962506e-04,  2.812018233162664e-06, -6.351236303511213e-09,  8.822700274342090e-12,  5.444872370799265e-15, -8.418886391582429e-17,
  3.107179645254347e-19, -6.526344819433134e-22,  2.360363077691621e-25,  4.616318728313681e-27, -2.273193116385910e-29,  2.449682698850673e-01, -1.083672298712806e-03,
  3.161569544945930e-06, -6.446387416592564e-09,  5.929612204660082e-12,  1.959601450127117e-14, -1.202201911366415e-16,  3.320079079190883e-19, -3.725275338167968e-22,
 -1.317198940333835e-24,  8.978140011622728e-27, -2.664880359631532e-29,  2.881020980118514e-01, -1.249408806725545e-03,  3.470698177783207e-06, -6.214528005933548e-09,
  1.884146004044085e-12,  3.504597725988437e-14, -1.465316474336018e-16,  2.842058210096134e-19,  1.325847661488900e-22, -3.095315155422545e-24,  1.148634277193001e-26,
 -1.814266778335800e-29,  3.343533853970003e-01, -1.418454945426113e-03,  3.725036225665484e-06, -5.623238790460581e-09, -3.158325272598200e-12,  5.007832307642906e-14,
 -1.558337849132311e-16,  1.567657748582708e-19,  7.932603974953230e-22, -4.528544655843535e-24,  1.014045614937950e-26,  4.547705549056833e-30,  3.835982757488519e-01,
 -1.588420562689684e-03,  3.910917241595251e-06, -4.657258720678202e-09, -8.927520128391435e-12,  6.269033794388876e-14, -1.421192439156799e-16, -4.515779949134171e-20,
  1.470426161479586e-21, -4.959496098626911e-24,  3.834365367777420e-27,  3.629219109614576e-29,  4.356998112287898e-01, -1.756795898124377e-03,  4.015836335080262e-06,
 -3.321280528150526e-09, -1.504505677275280e-11,  7.079892764949230e-14, -1.020280860841564e-16, -2.976578413152821e-19,  1.975076575499371e-21, -3.856458283494534e-24,
 -6.776883923106266e-27,  6.472030295267166e-29,  4.905071708984037e-01, -1.920973355593688e-03,  4.028934831526463e-06, -1.642075344696461e-09, -2.104171453374853e-11,
  7.249706259666259e-14, -3.606066842667323e-17, -5.585899825192001e-19,  2.109066628040268e-21, -1.055401109799860e-24, -1.886585152720088e-26,  7.366686036910740e-29,
  5.478548785510681e-01, -2.078273539103546e-03,  3.941499926416339e-06,  3.302891192332813e-10, -2.638572689009844e-11,  6.633930460267482e-14,  5.061441055548879e-17,
 -7.725466378912576e-19,  1.721502900405249e-21,  3.049694675434076e-24, -2.784830297266519e-26,  5.021330155079842e-29,  6.075619913937363e-01, -2.225976066225023e-03,
  3.747466254491321e-06,  2.522380920650274e-09, -3.052185620925231e-11,  5.162556595551415e-14,  1.480089508332644e-16, -8.804013228575243e-19,  7.686141169286178e-22,
  7.459395245328690e-24, -2.876933266378692e-26, -6.958793188213070e-30,  6.694312843651135e-01, -2.361355649178277e-03,  3.443902218127699e-06,  4.838724416378391e-09,
 -3.291992183135213e-11,  2.864401553605745e-14,  2.420244351682772e-16, -8.324522937717817e-19, -6.403903494083774e-22,  1.073552767984832e-23, -1.840757889260702e-26,
 -8.198333473391427e-29,  7.332484488107190e-01, -2.481723875172770e-03,  3.031459368924362e-06,  7.164718944850618e-09, -3.313014551765592e-11, -1.171320410303441e-15,
  3.161221528645518e-16, -6.029608951670250e-19, -2.230819359914893e-21,  1.139656633907245e-23,  2.609098216516280e-27, -1.434004088186486e-28,  7.987813288175384e-01,
 -2.584477013756225e-03,  2.514758296179620e-06,  9.371309722753422e-09, -3.084120804608818e-11, -3.521313563254847e-14,  3.538925212588422e-16, -2.027615532560338e-19,
 -3.598847340334597e-21,  8.468934446402483e-24,  2.869676661201549e-26, -1.552086253469894e-28,  8.657792237465223e-01, -2.667150017498495e-03,  1.902679656322342e-06,
  1.132147405010760e-08, -2.593540577280009e-11, -6.984173951396023e-14,  3.422532014002821e-16,  3.140159488518576e-19, -4.301381275930387e-21,  2.026608046372296e-24,
  5.017681289900011e-26, -9.509060398756873e-29,  9.339722913525093e-01, -2.727476650155718e-03,  1.208524649657715e-06,  1.287845419442869e-08, -1.853395869890122e-11,
 -1.007166160127812e-13,  2.747783636816895e-16,  8.528182535552033e-19, -3.987049377504923e-21, -6.512206359431769e-24,  5.646856487515844e-26,  2.794533689811527e-29,
  1.003071092248921e+00, -2.763455360459429e-03,  4.500060754920770e-07,  1.391549307657209e-08, -9.024634090901775e-12, -1.233151626158443e-13,  1.544639778906728e-16,
  1.293366582660637e-18, -2.536179638608074e-21, -1.454960955276378e-23,  4.089577129579885e-26,  1.675326472969463e-28,  1.072766323175763e+00, -2.773420108508077e-03,
 -3.509700605276148e-07,  1.432661252256766e-08,  1.936236771331456e-12, -1.336000616935061e-13, -4.868189518759189e-18,  1.515629176969179e-18, -1.618920786653628e-22,
 -1.903014705938663e-23,  5.193878278298266e-27,  2.541827000224437e-28,  1.142728793272676e+00, -2.756114838140172e-03, -1.168770491704241e-06,  1.403772673161672e-08,
  1.345417189916805e-11, -1.287558892872957e-13, -1.792595894847049e-16,  1.432758055181139e-18,  2.578745314129270e-21, -1.759231939178901e-23, -3.885012361895186e-26,
  2.289888213565947e-28,  1.212609703918860e+00, -2.710769672664678e-03, -1.974780091310413e-06,  1.301712690437243e-08,  2.446357170886891e-11, -1.078757283954249e-13,
 -3.378359743017358e-16,  1.022840721326148e-18,  4.897570095476282e-21, -9.759934277133738e-24, -7.261460709867040e-26,  8.240074810752577e-29,  1.282041298097505e+00,
 -2.637176204266682e-03, -2.738446923040542e-06,  1.128414096743210e-08,  3.383119057301631e-11, -7.244992372748459e-14, -4.484632163895285e-16,  3.488099427416624e-19,
  6.007024463143757e-21,  2.389589883678994e-24, -7.861934938421749e-26, -1.261069922554524e-28,  1.350637948921728e+00, -2.535758476624755e-03, -3.428628862130794e-06,
  8.914613136641583e-09,  4.048984048768461e-11, -2.650423307229153e-14, -4.850190631203169e-16, -4.436936220602922e-19,  5.411963211443610e-21,  1.458528334412381e-23,
 -5.018469968990434e-26, -2.879808505765364e-28,  1.417997758000613e+00, -2.407635473839153e-03, -4.015218278365056e-06,  6.041821296769432e-09,  4.358896689964715e-11,
  2.373427818331447e-14, -4.347129868776084e-16, -1.156090818571358e-18,  3.154758879067873e-21,  2.188792893138229e-23,  2.557135399118788e-27, -3.044781070099005e-28,
  1.483704731661619e+00, -2.254670199444503e-03, -4.470988925381107e-06,  2.851620027981016e-09,  4.264154013442299e-11,  7.069065789288505e-14, -3.033615477576402e-16,
 -1.591120807724398e-18, -1.080902261052151e-22,  2.091500795644013e-23,  5.518360435755372e-26, -1.538757262596271e-28,  1.547331595529878e+00, -2.079499856332048e-03,
 -4.773571415538772e-06, -4.289803767063061e-10,  3.764112731152038e-11,  1.067464428056793e-13, -1.165208633085005e-16, -1.617667763814264e-18, -3.278174064131037e-21,
  1.173847402337514e-23,  8.082063291836281e-26,  8.095519170262984e-29,  1.608443294467049e+00, -1.885541345458547e-03, -4.907423623169689e-06, -3.549884093786064e-09,
  2.912111265486105e-11,  1.257882861214696e-13,  8.487897861142742e-17, -1.223576879307600e-18, -5.216735601818638e-21, -1.701149493338958e-24,  6.582095215871106e-26,
  2.561455381126234e-28,  1.666601204440058e+00, -1.676966428204533e-03, -4.865625078058800e-06, -6.261747828021672e-09,  1.813185753944588e-11,  1.246677783834824e-13,
  2.542395719174689e-16, -5.324549004357089e-19, -5.231222327562441e-21, -1.324470935817502e-23,  1.942692264506354e-26,  2.633187166774915e-28,  1.721368054952183e+00,
 -1.458641584741864e-03, -4.651296694381388e-06, -8.343567167187445e-09,  6.122464535070819e-12,  1.041723529298296e-13,  3.522140976269970e-16,  2.300547600597399e-19,
 -3.417730029271605e-21, -1.764901981694528e-23, -3.057633546991958e-26,  1.107794338619827e-28,  1.772313525275903e+00, -1.236028966010896e-03, -4.278437015795098e-06,
 -9.630854088984881e-09, -5.268477124934503e-12,  6.914606897572367e-14,  3.589660255613016e-16,  8.153672314720288e-19, -6.540745736673619e-22, -1.351175538638846e-23,
 -5.535604989515402e-26, -8.072114885486742e-29,  1.819020435800383e+00, -1.015046942645998e-03, -3.771981479438566e-06, -1.004035822164962e-08, -1.448668752318532e-11,
  2.756948256077154e-14,  2.812231934530046e-16,  1.048399568716733e-18,  1.805943075839827e-21, -4.080119750088224e-24, -4.429166719524611e-26, -1.739059841988319e-28,
  1.861091409358056e+00, -8.018915743576797e-04, -3.166938046330714e-06, -9.586925836061565e-09, -2.035246295799048e-11, -1.130731465188884e-14,  1.506815003655847e-16,
  8.990006027721148e-19,  2.959029608732562e-21,  4.820436582073092e-24, -1.134037686457707e-26, -1.249425083711571e-28,  1.898155829686074e+00, -6.028237123614311e-04,
 -2.506532834204645e-06, -8.388518196634834e-09, -2.230488444061697e-11, -3.935644721600941e-14,  1.322214967082349e-17,  4.911322221609349e-19,  2.557080647214312e-21,
  8.532942546435849e-24,  1.722499890538663e-26, -8.344323160211094e-30,  1.929876879910451e+00, -4.239301223101496e-04, -1.839408846474245e-06, -6.656760915882540e-09,
 -2.053671077302819e-11, -5.181122723619489e-14, -8.775805985367801e-17,  3.963158185530280e-20,  1.178802262578825e-21,  6.405651523036323e-24,  2.393550545063102e-26,
  6.544378774735720e-29,  1.955958410259556e+00, -2.708705544539062e-04, -1.216047806629262e-06, -4.672599436789476e-09, -1.597372717700574e-11, -4.861388929941172e-14,
 -1.275127509648743e-16, -2.575182620794203e-19, -1.923389186402138e-22,  1.631310273515643e-24,  1.200518391703655e-26,  5.465867559199765e-29,  1.976151378479727e+00,
 -1.486255185240785e-04, -6.847105147655598e-07, -2.749369045097406e-09, -1.008608923884313e-11, -3.433992712540538e-14, -1.086235457352175e-16, -3.155852968407795e-19,
 -8.156582697170729e-22, -1.715269528343032e-24, -1.919497091665295e-27,  6.648590282965235e-30,  1.990259733154272e+00, -6.126049883674609e-05, -2.872890391136348e-07,
 -1.188286004141404e-09, -4.562442410837926e-12, -1.661217291212638e-14, -5.792968524403126e-17, -1.942721871372559e-19, -6.267700415649067e-22, -1.939454529436706e-24,
 -5.714293651992121e-27, -1.580092629463121e-29,  1.998147523686594e+00, -1.171058336453621e-05, -5.546194484834588e-08, -2.331495411425307e-10, -9.172049659313805e-13,
 -3.456472253242115e-15, -1.263183262070396e-17, -4.508956186051161e-20, -1.579055964235337e-22, -5.441038851005306e-25, -1.848195136584441e-27, -6.196075139131488e-30,
  4.651358382784195e-04, -2.257554511845787e-06,  8.216126242487381e-09, -2.657268007613180e-11,  8.054249465188971e-14, -2.342709077362546e-16,  6.621653149027116e-19,
 -1.832454593231763e-21,  4.988690783211421e-24, -1.340478153934014e-26,  3.563094141955698e-29, -9.385203630069302e-32,  4.184884915245164e-03, -2.028286790527721e-05,
  7.359801059309944e-08, -2.368214600580074e-10,  7.122431283522887e-13, -2.048855957174786e-15,  5.704881120712267e-18, -1.548102945836300e-20,  4.110607044519198e-23,
 -1.070584794310485e-25,  2.738249682398280e-28, -6.881552525926376e-31,  1.161723697976098e-02, -5.614620534489507e-05,  2.025158884292363e-07, -6.449688001375679e-10,
  1.909149675076282e-12, -5.367290622120126e-15,  1.447764618297969e-17, -3.764140208460537e-20,  9.442403442271777e-23, -2.281045155636008e-25,  5.277968178138525e-28,
 -1.157548010485257e-30,  2.274784188226234e-02, -1.094731468348877e-04,  3.913042044624031e-07, -1.226748516018411e-09,  3.542630855942631e-12, -9.601366392856778e-15,
  2.456692329502979e-17, -5.922225287085439e-20,  1.330715382051419e-22, -2.717383159214792e-25,  4.731415582573572e-28, -5.575165975857316e-31,  3.755502924327670e-02,
 -1.797024885826561e-04,  6.345305886787198e-07, -1.946843199365611e-09,  5.430479625263408e-12, -1.394959611951604e-14,  3.285785000499436e-17, -6.934424744348096e-20,
  1.227595493889458e-22, -1.414232290850611e-25, -1.242512870492089e-28,  1.546104645814349e-30,  5.600963364145133e-02, -2.660868375569285e-04,  9.250761082917415e-07,
 -2.760171420453137e-09,  7.349362331351093e-12, -1.748773170911221e-14,  3.607500244861229e-17, -5.811752400208521e-20,  3.935131737748403e-23,  2.003984774509404e-25,
 -1.225830467537996e-27,  4.501681465641636e-30,  7.807476052898797e-02, -3.676935446784047e-04,  1.254244052538535e-06, -3.613584153711250e-09,  9.050677380060368e-12,
 -1.927882984063857e-14,  3.139852326409304e-17, -1.952558974188063e-20, -1.197721846193897e-22,  6.956840134730723e-25, -2.435830501643470e-27,  6.536142470834078e-30,
  1.037054921003090e-01, -4.834061008138785e-04,  1.611898683256931e-06, -4.447950521203424e-09,  1.027917240210711e-11, -1.849411339985592e-14,  1.707525796419862e-17,
  4.615639022272370e-20, -3.288730447871174e-22,  1.184219294253985e-24, -3.076593719102826e-27,  5.432864016889855e-30,  1.328485322575749e-01, -6.119261554033586e-04,
  1.986635614577518e-06, -5.200604355376979e-09,  1.079348928143363e-11, -1.453419029950351e-14, -7.063424082158758e-18,  1.309686225153236e-19, -5.342404832605279e-22,
  1.436088489277583e-24, -2.431985837058404e-27, -2.350918628668839e-31,  1.654417898174581e-01, -7.517763560757635e-04,  2.365985615318630e-06, -5.808112100438848e-09,
  1.038762162812195e-11, -7.138928304617637e-15, -3.926518160452273e-17,  2.193562183426115e-19, -6.631732822744807e-22,  1.221247905624219e-24, -9.852102094304846e-29,
 -9.813856147878109e-30,  2.014138992129304e-01, -9.013042493215715e-04,  2.736653622729302e-06, -6.209308786131042e-09,  8.912084944133554e-12,  3.526390024761023e-15,
 -7.577962072845524e-17,  2.900033502397553e-19, -6.410467847765602e-22,  4.015270904089484e-25,  3.678746927752827e-27, -1.991414388067146e-29,  2.406836781924691e-01,
 -1.058687527311687e-03,  3.084794572854623e-06, -6.348531890184155e-09,  6.293425503866121e-12,  1.682089611793822e-14, -1.110975097232203e-16,  3.193953654450217e-19,
 -4.137608196211495e-22, -9.810594706792668e-25,  7.840785722096728e-27, -2.500945191136788e-29,  2.831595224438622e-01, -1.221940954117919e-03,  3.396327238534415e-06,
 -6.178962677798452e-09,  2.550544584901522e-12,  3.162509047241798e-14, -1.385306152912940e-16,  2.867527169058187e-19,  2.922697463152070e-23, -2.652280193398956e-24,
  1.065558820297559e-26, -1.949284073970948e-29,  3.287387377146647e-01, -1.388925355340765e-03,  3.657286558602978e-06, -5.665961128270543e-09, -2.193789179233323e-12,
  4.639370613764879e-14, -1.511129111338933e-16,  1.796202425377131e-19,  6.375671668980348e-22, -4.120553833871535e-24,  1.022069548610419e-26, -7.245056761135273e-31,
  3.773068109182408e-01, -1.557359107377463e-03,  3.854213869377190e-06, -4.790254248499476e-09, -7.707897622585751e-12,  5.926945629050790e-14, -1.427515237712076e-16,
 -9.282558723342392e-22,  1.295007353959824e-21, -4.776648121145490e-24,  5.248473279991703e-27,  2.811592353766196e-29,  4.287366229638073e-01, -1.724832614428093e-03,
  3.974582932180901e-06, -3.550809359587112e-09, -1.365420368891348e-11,  6.825725240941509e-14, -1.094988838886300e-16, -2.367235933421204e-19,  1.832030454023699e-21,
 -4.072841367071825e-24, -4.098641001244874e-27,  5.698524443213287e-29,  4.828876077004565e-01, -1.888826310040192e-03,  4.007257604335088e-06, -1.967195451401278e-09,
 -1.960165547751710e-11,  7.145150654758769e-14, -5.076303974426659e-17, -4.918471010548766e-19,  2.058264431237993e-21, -1.745836568404753e-24, -1.567439675726189e-26,
  7.113639198760629e-29,  5.396048634967706e-01, -2.046732761503713e-03,  3.942974343978799e-06, -8.120946250583045e-11, -2.504851290099865e-11,  6.730079360831564e-14,
  2.976933585198299e-17, -7.159124568414818e-19,  1.811793365756466e-21,  1.982084223389744e-24, -2.548417298788281e-26,  5.681385024971332e-29,  5.987182266744520e-01,
 -2.195883484166396e-03,  3.774839402632525e-06,  2.042475987209035e-09, -2.945580410429398e-11,  5.488498541909221e-14,  1.237408376888632e-16, -8.517314620229578e-19,
  1.016409404436734e-21,  6.307381600298312e-24, -2.871477725560843e-26,  9.043654945775753e-30,  6.600413193656334e-01, -2.333581081330171e-03,  3.498826504245736e-06,
  4.316896347341027e-09, -3.229085412927046e-11,  3.417093421574276e-14,  2.184859244815400e-16, -8.469099254382504e-19, -2.679797422054084e-22,  9.933050936432931e-24,
 -2.156917953133025e-26, -6.180009618458530e-29,  7.233705884575855e-01, -2.457137304242894e-03,  3.114256048498399e-06,  6.634855548133518e-09, -3.307911020369231e-11,
  6.205329269178684e-15,  2.983015922383567e-16, -6.677746523982982e-19, -1.820148378602794e-21,  1.137880329926021e-23, -3.391777343281589e-27, -1.289327695822237e-28,
  7.884843572049642e-01, -2.563917563864995e-03,  2.624231505222912e-06,  8.872675607428825e-09, -3.146106244888097e-11, -2.680056713693700e-14,  3.466502498365685e-16,
 -3.128384394143805e-19, -3.274958345817950e-21,  9.479364014431468e-24,  2.181289172647751e-26, -1.568391155100251e-28,  8.551419168875678e-01, -2.651392307170048e-03,
  2.036002903595596e-06,  1.089578188819401e-08, -2.724946765495466e-11, -6.153762606443288e-14,  3.491323094068346e-16,  1.779178332889525e-19, -4.193368205186029e-21,
  3.943068425447005e-24,  4.548394747925498e-26, -1.173617175233464e-28,  9.230826925929038e-01, -2.717195479115979e-03,  1.361221549206365e-06,  1.256616236449796e-08,
 -2.048048539237102e-11, -9.385000651053563e-14,  2.968389513517741e-16,  7.219193329285177e-19, -4.180634186788595e-21, -4.239732042402638e-24,  5.688927711896235e-26,
 -8.537588327366382e-30,  9.920255247709037e-01, -2.759190008958280e-03,  6.160449252192993e-07,  1.375158206789791e-08, -1.145098204077679e-11, -1.191830991442931e-13,
  1.894656228836429e-16,  1.204157827587545e-18, -3.028830486752045e-21, -1.277589654818914e-23,  4.754615989041372e-26,  1.340941620658463e-28,  1.061668116519130e+00,
 -2.775539867976586e-03, -1.789529887491686e-07,  1.433622436308809e-08, -7.335010857487450e-13, -1.332088632860400e-13,  3.739432060877954e-17,  1.499549114023931e-18,
 -8.405620839267063e-22, -1.860099283189967e-23,  1.619182050434025e-26,  2.443037742432780e-28,  1.131686705366024e+00, -2.764787728815198e-03, -9.991118688457619e-07,
  1.423217258523662e-08,  1.083932697809239e-11, -1.325679834021522e-13, -1.380843174355226e-16,  1.504864999578617e-18,  1.919951118444956e-21, -1.893689075254915e-23,
 -2.819714508411636e-26,  2.538629750005733e-28,  1.201736027222669e+00, -2.725936603995878e-03, -1.816298663210126e-06,  1.339085344876756e-08,  2.222738638562334e-11,
 -1.156227521870181e-13, -3.070590946058904e-16,  1.173388662897443e-18,  4.494942578750026e-21, -1.257678078493542e-23, -6.785440048633068e-26,  1.336210736510295e-28,
  1.271449648565607e+00, -2.658533052705922e-03, -2.599839138378853e-06,  1.181326694503633e-08,  3.227546454421256e-11, -8.307406184507969e-14, -4.359968445023753e-16,
  5.417941798636488e-19,  6.035235687077398e-21, -8.518751755588180e-25, -8.308819136024607e-26, -7.592257985922603e-29,  1.340440749953817e+00, -2.562748637269665e-03,
 -3.317786031999153e-06,  9.557573576484564e-09,  3.984244809911356e-11, -3.827373128108294e-14, -4.949418940130048e-16, -2.625216442506120e-19,  5.897884547418261e-21,
  1.232879714754042e-23, -6.251145522608308e-26, -2.703803636642876e-28,  1.408303448572243e+00, -2.439455324105393e-03, -3.938518083143333e-06,  6.742464594515605e-09,
  4.395676137868239e-11,  1.292485571792705e-14, -4.655517541377564e-16, -1.042538109227354e-18,  3.941252520992120e-21,  2.171313836960708e-23, -1.150749424065370e-26,
 -3.333884576875283e-28,  1.474614748276843e+00, -2.290289529782771e-03, -4.432630564142819e-06,  3.544784446490968e-09,  4.397893884547471e-11,  6.287568390216413e-14,
 -3.478452072073779e-16, -1.582120901705817e-18,  6.827944074834378e-22,  2.296977156405581e-23,  4.712735573843027e-26, -2.124942032606028e-28,  1.538937201026168e+00,
 -2.117698619137688e-03, -4.775035713950021e-06,  1.901895396800372e-10,  3.974436276614411e-11,  1.033949647735697e-13, -1.632161693137962e-16, -1.715177884045152e-18,
 -2.796664342860286e-21,  1.502870745865886e-23,  8.333064749585706e-26,  3.148070563765397e-29,  1.600822351951474e+00, -1.924963016079686e-03, -4.947143259328487e-06,
 -3.063721471714595e-09,  3.165437659723115e-11,  1.273953581855630e-13,  4.827627197670792e-17, -1.390962165179122e-18, -5.227880814604043e-21,  1.155731270098258e-24,
  7.697027005234656e-26,  2.488646892414645e-28,  1.659815020048304e+00, -1.716186869237124e-03, -4.938942053711256e-06, -5.951365149325529e-09,  2.068492338737929e-11,
  1.305712725261552e-13,  2.369167704502516e-16, -7.073096794081787e-19, -5.691153570965630e-21, -1.222511052149812e-23,  3.181549101156214e-26,  2.993204473839978e-28,
  1.715458436318560e+00, -1.496250622874708e-03, -4.750761496854620e-06, -8.228478910796133e-09,  8.290898349558015e-12,  1.126898358949918e-13,  3.570273475960453e-16,
  1.102958517989732e-19, -4.073812280509723e-21, -1.876102189646106e-23, -2.467699535166611e-26,  1.583829167950898e-28,  1.767300220594047e+00, -1.270720067977777e-03,
 -4.394465864894863e-06, -9.703610546413149e-09, -3.797568833195001e-12,  7.803238694589486e-14,  3.814270716781015e-16,  7.862201268420122e-19, -1.181156379109755e-21,
 -1.579101995673623e-23, -5.844388690356735e-26, -5.828058356770541e-29,  1.814899127754326e+00, -1.045708627716993e-03, -3.893837088805574e-06, -1.026735729337639e-08,
 -1.386539340751776e-11,  3.467748342777567e-14,  3.113628365533114e-16,  1.103482453709367e-18,  1.625287492171569e-21, -6.008869724943116e-24, -5.224115010647607e-26,
 -1.869712525532804e-28,  1.857832435609175e+00, -8.276928029056463e-04, -3.283941795303805e-06, -9.914169172048261e-09, -2.054035079107666e-11, -7.378037647388429e-15,
  1.772045619660441e-16,  9.963673538898537e-19,  3.123004037500941e-21,  4.248992370128505e-24, -1.743268411931795e-26, -1.525176641492538e-28,  1.895703784140122e+00,
 -6.232847505229550e-04, -2.609362227691547e-06, -8.751671291942363e-09, -2.308767717269260e-11, -3.886456022178016e-14,  2.816654703627232e-17,  5.780057961799641e-19,
  2.876543192261860e-21,  9.210491065754737e-24,  1.654361701995471e-26, -2.329590895558947e-29,  1.928151214974977e+00, -4.389705830855936e-04, -1.921296066577472e-06,
 -6.993752064343229e-09, -2.159388440952283e-11, -5.389962208724549e-14, -8.608425432901549e-17,  8.123340526227628e-20,  1.427345553634908e-21,  7.422003898825769e-24,
  2.691400149991401e-26,  6.981516575219997e-29,  1.954855109926568e+00, -2.808276415193177e-04, -1.273685108187629e-06, -4.936126033894974e-09, -1.697719542635245e-11,
 -5.176135925911758e-14, -1.347999126410392e-16, -2.626359181383352e-19, -1.243623630594394e-22,  2.162499319229935e-24,  1.462824581799591e-26,  6.481835579880184e-29,
  1.975545708142294e+00, -1.542379689047225e-04, -7.186943393897659e-07, -2.916385564533877e-09, -1.079968866680414e-11, -3.705593587443057e-14, -1.178347340537401e-16,
 -3.426885474732128e-19, -8.787109856679834e-22, -1.785250369966133e-24, -1.554506334847263e-27,  1.008963038028646e-29,  1.990010002438665e+00, -6.361711561282343e-05,
 -3.019976795172847e-07, -1.264020461778646e-09, -4.909041595557952e-12, -1.807009333884059e-14, -6.366091834974429e-17, -2.154914628252053e-19, -7.008774866714206e-22,
 -2.182509377915292e-24, -6.453149601096141e-27, -1.781958294790092e-29,  1.998099775883383e+00, -1.216572494407692e-05, -5.835012684544891e-08, -2.483947678299277e-10,
 -9.894713435961036e-13, -3.775375938280973e-15, -1.396813165101939e-17, -5.047076398763288e-20, -1.788924744483518e-22, -6.237870732087955e-25, -2.143781931133231e-27,
 -7.269969729830915e-30,  4.562350891930320e-04, -2.193079433558223e-06,  7.904834292350755e-09, -2.532063716940764e-11,  7.601193153739469e-14, -2.189770420745121e-16,
  6.130208884280574e-19, -1.680270446132281e-21,  4.530808415056833e-24, -1.205878379923794e-26,  3.174914601943175e-29, -8.283715327664885e-32,  4.104913282818038e-03,
 -1.970526058713458e-05,  7.082319986885823e-08, -2.257460925426176e-10,  6.726008230518505e-13, -1.916995283680748e-15,  5.289263150169977e-18, -1.422524477943510e-20,
  3.744203495024016e-23, -9.668780476556899e-26,  2.452666670700472e-28, -6.115351764154164e-31,  1.139584411747725e-02, -5.455652548853776e-05,  1.949560589736098e-07,
 -6.152626452843235e-10,  1.805194859938601e-12, -5.032140631943456e-15,  1.346478287297519e-17, -3.474724425533127e-20,  8.658030830901427e-23, -2.079787715158063e-25,
  4.792764713672117e-28, -1.049605447996419e-30,  2.231611827069489e-02, -1.064006479210748e-04,  3.769170801813182e-07, -1.171571160931443e-09,  3.356367722561964e-12,
 -9.031186633763994e-15,  2.296687137850669e-17, -5.511688050570680e-20,  1.236236706157881e-22, -2.533072923086114e-25,  4.483318959011207e-28, -5.682370457354162e-31,
  3.684622587597767e-02, -1.747182361845975e-04,  6.116807266037877e-07, -1.862145266335661e-09,  5.159218588174226e-12, -1.318386822341050e-14,  3.097043587700232e-17,
 -6.549823329121201e-20,  1.175944159890910e-22, -1.451232471679157e-25, -6.289695326627700e-29,  1.251147419609271e-30,  5.495988052341971e-02, -2.588167441706831e-04,
  8.926481990025853e-07, -2.645333169058451e-09,  7.008134649695061e-12, -1.664131050693855e-14,  3.446636044415307e-17, -5.675193914187918e-20,  4.572915766751442e-23,
  1.551473830290732e-25, -1.041027929935474e-27,  3.910664236779699e-30,  7.662378305987855e-02, -3.578306115519937e-04,  1.211737315796130e-06, -3.471817178116094e-09,
  8.672590002286610e-12, -1.853223649402528e-14,  3.080178298997273e-17, -2.297583882205660e-20, -9.641373120715799e-23,  6.038183540722182e-25, -2.161944804490123e-27,
  5.919403033047435e-30,  1.017973239420707e-01, -4.707216450022419e-04,  1.559497944714338e-06, -4.286420136267399e-09,  9.913486896839244e-12, -1.806994931227689e-14,
  1.822654412547117e-17,  3.629127768363310e-20, -2.883989514496421e-22,  1.065906349303770e-24, -2.839940487328205e-27,  5.311461368715690e-30,  1.304322226753691e-01,
 -5.962797858124715e-04,  1.925254918206923e-06, -5.030241995356046e-09,  1.050139750688075e-11, -1.466159173527885e-14, -3.628004166186529e-18,  1.146813360288578e-19,
 -4.842922276633022e-22,  1.338883628362567e-24, -2.421706447454878e-27,  6.649384031269197e-31,  1.624721027206141e-01, -7.331244462745841e-04,  2.297280609844025e-06,
 -5.643101539066827e-09,  1.023590469718754e-11, -8.009946432160749e-15, -3.341370985458198e-17,  1.988365449770093e-19, -6.193775928515429e-22,  1.209299712493989e-24,
 -4.838867921372474e-28, -7.753660226759251e-30,  1.978520001946553e-01, -8.797066383427208e-04,  2.662999492218232e-06, -6.066247301937729e-09,  8.965071443611649e-12,
  1.802816557986610e-15, -6.794435003168040e-17,  2.697478662072478e-19, -6.241470808143980e-22,  5.319405147644970e-25,  2.861064424967748e-27, -1.728650302388406e-29,
  2.364978047571815e-01, -1.034312163806312e-03,  3.009226999778785e-06, -6.245287596566953e-09,  6.603896549447051e-12,  1.426034604568621e-14, -1.023446945876244e-16,
  3.056483387999323e-19, -4.436940070103508e-22, -6.889082707913866e-25,  6.780115904749325e-27, -2.317902738592218e-29,  2.783256313033675e-01, -1.195066185759988e-03,
  3.322444833548558e-06, -6.133271863200854e-09,  3.150449584226676e-12,  2.839672497679911e-14, -1.305022229827221e-16,  2.862408350188184e-19, -5.879204768057774e-23,
 -2.243449062609814e-24,  9.781209736311836e-27, -2.014828839431800e-29,  3.232411215141494e-01, -1.359939556469898e-03,  3.589114407615994e-06, -5.693834063657774e-09,
 -1.301763432963593e-12,  4.282951986665241e-14, -1.458196529010028e-16,  1.977277137760094e-19,  4.965662823079868e-22, -3.713685572774962e-24,  1.009177245564251e-26,
 -4.974819678843394e-30,  3.711386750087383e-01, -1.526757336294053e-03,  3.796029375256395e-06, -4.904283572050534e-09, -6.556747435458583e-12,  5.584763318823950e-14,
 -1.422229006316254e-16,  3.780343373320963e-20,  1.127104690355485e-21, -4.544192733655647e-24,  6.320748027432291e-27,  2.076441685986172e-29,  4.219006108638901e-01,
 -1.693210000950671e-03,  3.930706997700474e-06, -3.758500380938039e-09, -1.231584160362515e-11,  6.555622819948818e-14, -1.153286349362998e-16, -1.804714502353451e-19,
  1.683040473875600e-21, -4.188939475866685e-24, -1.763090815843121e-27,  4.918673525181090e-29,  4.753962616906945e-01, -1.856867898083948e-03,  3.981816431090380e-06,
 -2.269460442264723e-09, -1.818588578218959e-11,  7.007531340264727e-14, -6.362293213834761e-17, -4.271031873637739e-19,  1.984873512002642e-21, -2.311281172541775e-24,
 -1.262652639007867e-26,  6.720266701480665e-29,  5.314810043848591e-01, -2.015199575485535e-03,  3.939639699122821e-06, -4.711854195728062e-10, -2.369694196432439e-11,
  6.778132154897497e-14,  1.054482362634036e-17, -6.569851508862502e-19,  1.865415117118142e-21,  1.014092865489733e-24, -2.288555778362688e-26,  6.091502342213116e-29,
  5.899952341966360e-01, -2.165594657643134e-03,  3.796558082066343e-06,  1.580118037509061e-09, -2.833031846562726e-11,  5.757246099599620e-14,  1.003802690090031e-16,
 -8.157939560979747e-19,  1.222934669878912e-21,  5.170916403536366e-24, -2.800986302599859e-26,  2.258313621777670e-29,  6.507632920195764e-01, -2.305391987633108e-03,
  3.547552792055872e-06,  3.805986860548593e-09, -3.155692324277349e-11,  3.912938998808403e-14,  1.947049330549118e-16, -8.499353246849035e-19,  7.347781417253307e-23,
  9.021691383225431e-24, -2.385728470513203e-26, -4.237895725554052e-29,  7.135923588996131e-01, -2.431913768379286e-03,  3.190704058395043e-06,  6.106965152043561e-09,
 -3.288495816210916e-11,  1.313399084195903e-14,  2.788498080156741e-16, -7.195022076566698e-19, -1.414277506420799e-21,  1.113444679490322e-23, -8.704548471844481e-27,
 -1.122643497295410e-28,  7.782713368458580e-01, -2.542506418618719e-03,  2.727667117751800e-06,  8.365459362247646e-09, -3.191464709274098e-11, -1.859759609749089e-14,
  3.364760170573374e-16, -4.120220643484905e-19, -2.919653948074374e-21,  1.021449186783464e-23,  1.496752818428830e-26, -1.535502374041177e-28,  8.445697412013866e-01,
 -2.634588788837887e-03,  2.164097201235915e-06,  1.045040107685088e-08, -2.839610266852025e-11, -5.311369000619168e-14,  3.522591629762335e-16,  4.634196448096828e-20,
 -4.019963413283177e-21,  5.653777078252735e-24,  3.992845077912710e-26, -1.342517024328995e-28,  9.122366372001931e-01, -2.705708241725039e-03,  1.509988701946320e-06,
  1.222385227421543e-08, -2.228468553027237e-11, -8.649854931362894e-14,  3.151599470175760e-16,  5.861347860466226e-19, -4.292488531148435e-21, -1.981929356678834e-24,
  5.575224123783582e-26, -4.265414443305828e-29,  9.809996619401816e-01, -2.753604867781445e-03,  7.798867860521162e-07,  1.354955538378205e-08, -1.378649960171602e-11,
 -1.142426909962293e-13,  2.217586635305421e-16,  1.100254301065831e-18, -3.453203902838057e-21, -1.076666300112756e-23,  5.264813516165536e-26,  9.740806748755624e-29,
  1.050564182804326e+00, -2.776283754719489e-03, -7.076433535066129e-09,  1.430323790293233e-08, -3.385321053259911e-12, -1.318112043203197e-13,  7.890546705929347e-17,
  1.462082707874679e-18, -1.495991504056259e-21, -1.774310127488212e-23,  2.657044032239077e-26,  2.261512338028827e-28,  1.120612654201228e+00, -2.772094733786515e-03,
 -8.273732611427515e-07,  1.438422532067176e-08,  8.158273288092180e-12, -1.353700669895875e-13, -9.519186955944719e-17,  1.555200288337814e-18,  1.220663354374513e-21,
 -1.983598394465735e-23, -1.664057872651691e-26,  2.699068395421847e-28,  1.190804246033337e+00, -2.739818364778281e-03, -1.653552169551884e-06,  1.372760304307208e-08,
  1.984398056362090e-11, -1.225820949360139e-13, -2.722622071273320e-16,  1.309471132902422e-18,  3.994872124820852e-21, -1.515894049025727e-23, -6.090398486053304e-26,
  1.815862427072110e-28,  1.260774828959535e+00, -2.678756080012374e-03, -2.455038145936594e-06,  1.231581953788295e-08,  3.051068543607729e-11, -9.333417127042556e-14,
 -4.181320385530152e-16,  7.337840236503561e-19,  5.944085603662711e-21, -4.226108346982191e-24, -8.521608953813267e-26, -2.002415767708644e-29,  1.330137412421323e+00,
 -2.588821387228155e-03, -3.199297631254975e-06,  1.018828143440050e-08,  3.895770391512065e-11, -5.021882497589221e-14, -4.995870975392722e-16, -6.719335916701281e-20,
  6.293915459027218e-21,  9.598212870857218e-24, -7.380328351085588e-26, -2.409378049877875e-28,  1.398483140314071e+00, -2.470627858577483e-03, -3.853382121483784e-06,
  7.447224014654254e-09,  4.410123830080495e-11,  1.416290754784350e-15, -4.928604300963107e-16, -9.040291895762962e-19,  4.711045163259040e-21,  2.095305036654063e-23,
 -2.663622006185819e-26, -3.524833407985876e-28,  1.465382954482416e+00, -2.325568369821584e-03, -4.385831185028134e-06,  4.258038979830713e-09,  4.514939747182387e-11,
  5.399905189282332e-14, -3.917119052870853e-16, -1.546696393835223e-18,  1.541226969272013e-21,  2.465057570933528e-23,  3.648720808375997e-26, -2.708898865974767e-28,
  1.530390035899796e+00, -2.155878809588915e-03, -4.768870474435418e-06,  8.424132006125275e-10,  4.176915009879551e-11,  9.889188716652781e-14, -2.124081229589906e-16,
 -1.795369574410062e-18, -2.195450205953413e-21,  1.837289513080259e-23,  8.344763301038198e-26, -2.769218416587655e-29,  1.593043125163188e+00, -1.964678416811702e-03,
 -4.980784848979285e-06, -2.536818817950288e-09,  3.421061790759344e-11,  1.280677816227629e-13,  6.997854793418939e-18, -1.556973283747265e-18, -5.128257878830738e-21,
  4.448873029540755e-24,  8.754908095515401e-26,  2.299279976010919e-28,  1.652870805401906e+00, -1.755978244454279e-03, -5.008285524382669e-06, -5.599213141002998e-09,
  2.335149663659986e-11,  1.359986425274570e-13,  2.144982035748263e-16, -8.961962892221326e-19, -6.105086771809452e-21, -1.067931451612511e-23,  4.570706830621386e-26,
  3.312366318240425e-28,  1.709396799692065e+00, -1.534649252395517e-03, -4.848631431953957e-06, -8.077327822864444e-09,  1.063055297856878e-11,  1.212801902148504e-13,
  3.581877540808805e-16, -3.104845587578448e-20, -4.765158229230020e-21, -1.959340471668585e-23, -1.655325464336451e-26,  2.117611363461067e-28,  1.762146290096122e+00,
 -1.306342479264384e-03, -4.511220625285296e-06, -9.751381683843431e-09, -2.143619811395886e-12,  8.744599404873089e-14,  4.028233727962860e-16,  7.388717899151427e-19,
 -1.792254272078399e-21, -1.817153698318021e-23, -6.035418858533754e-26, -2.698753001972802e-29,  1.810653206279452e+00, -1.077355873564311e-03, -4.018352222805088e-06,
 -1.048323856522622e-08, -1.309458448860673e-11,  4.252662394903011e-14,  3.429529845470945e-16,  1.151610959498831e-18,  1.369343062372010e-21, -8.266161188771349e-24,
 -6.069289575916105e-26, -1.964828927759578e-28,  1.854468359951640e+00, -8.544458140291667e-04, -3.404887793626660e-06, -1.024375450563271e-08, -2.064306374412221e-11,
 -2.778919754428428e-15,  2.065239111396198e-16,  1.098602672096935e-18,  3.261718959964743e-21,  3.408642503853792e-24, -2.480877123469979e-26, -1.832624995527120e-28,
  1.893168221272151e+00, -6.445860672221035e-04, -2.716624216343457e-06, -9.127250033443953e-09, -2.385684241528550e-11, -3.798364067665450e-14,  4.569014526963356e-17,
  6.754858187573382e-19,  3.219737055514328e-21,  9.846376283311182e-24,  1.510947575614592e-26, -4.269146311749149e-29,  1.926364051979433e+00, -4.546826079063649e-04,
 -2.007330039279746e-06, -7.347989538861895e-09, -2.269232508551260e-11, -5.593293402142107e-14, -8.312858381298700e-17,  1.313973881451985e-19,  1.714666078212749e-21,
  8.561081036358502e-24,  3.006439077997022e-26,  7.317477381126635e-29,  1.953711038628755e+00, -2.912587540633353e-04, -1.334583170096310e-06, -5.216221264706631e-09,
 -1.804537225250522e-11, -5.508517641265906e-14, -1.421968908253555e-16, -2.652512082295898e-19, -3.526256165887221e-23,  2.808004190884712e-24,  1.773247052801215e-26,
  7.655624645035135e-29,  1.974917031289324e+00, -1.601305049820056e-04, -7.547526999810750e-07, -3.095266509760802e-09, -1.156988161293051e-11, -4.000235005340217e-14,
 -1.278334178582650e-16, -3.718466636626390e-19, -9.439812107709915e-22, -1.837323717455928e-24, -1.016801242936624e-27,  1.453661579513458e-29,  1.989750604025810e+00,
 -6.609513330669170e-05, -3.176493939343167e-07, -1.345541454101869e-09, -5.286224230060245e-12, -1.967296930252491e-14, -7.002084841501703e-17, -2.392280579559327e-19,
 -7.842888836690524e-22, -2.456960449856398e-24, -7.285751892751924e-27, -2.006433028692293e-29,  1.998050160115900e+00, -1.264472390324491e-05, -6.142840539935404e-08,
 -2.648490763126330e-10, -1.068449115050515e-12, -4.128237507028711e-15, -1.546495452843302e-17, -5.657182142398057e-20, -2.029726687259220e-22, -7.162954313279988e-25,
 -2.490920925860545e-27, -8.545436171806741e-30,  4.475873531952503e-04, -2.131035802287998e-06,  7.608141813289242e-09, -2.413869891877350e-11,  7.177578785668845e-14,
 -2.048131207525160e-16,  5.679395630223068e-19, -1.541992285020422e-21,  4.118700023159072e-24, -1.085878491905568e-26,  2.832096128086754e-29, -7.320084591120607e-32,
  4.027208509457064e-03, -1.914933072288668e-05,  6.817757319806820e-08, -2.152844344490649e-10,  6.354987639902125e-13, -1.794700409731948e-15,  4.907220254355359e-18,
 -1.308094976921319e-20,  3.413156915251931e-23, -8.739477517728313e-26,  2.198771089283882e-28, -5.439253299384921e-31,  1.118069123575777e-02, -5.302592614712047e-05,
  1.877429407087009e-07, -5.871674371980650e-10,  1.707706377569284e-12, -4.720354630792395e-15,  1.252954829579223e-17, -3.209285869753389e-20,  7.942729204959552e-23,
 -1.897017952849885e-25,  4.352870422724938e-28, -9.514644546436459e-31,  2.189645858387394e-02, -1.034406472987295e-04,  3.631745725658203e-07, -1.119284835208521e-09,
  3.181133308902610e-12, -8.498062272819487e-15,  2.147763562234934e-17, -5.130341588679400e-20,  1.148213734651500e-22, -2.358748099782694e-25,  4.232905852981035e-28,
 -5.685009741939406e-31,  3.615700025487095e-02, -1.699127898172583e-04,  5.898216961728592e-07, -1.781667418347166e-09,  4.902827755387937e-12, -1.246216478949940e-14,
  2.918837937524272e-17, -6.181918547252789e-20,  1.123372618535092e-22, -1.466142086424103e-25, -1.345467496420213e-29,  1.003408990034383e-30,  5.393869753073926e-02,
 -2.518006533636155e-04,  8.615661427522953e-07, -2.535821217450589e-09,  6.683452528131286e-12, -1.583301626954951e-14,  3.289857707254983e-17, -5.520695092951548e-20,
  5.060494377793033e-23,  1.167895529365492e-25, -8.806548163811596e-28,  3.390011783393695e-30,  7.521158784608110e-02, -3.483010292148509e-04,  1.170895976517405e-06,
 -3.335980955144343e-09,  8.309283872440914e-12, -1.780104271504085e-14,  3.011841792232057e-17, -2.572947002291609e-20, -7.617168134311775e-23,  5.223766790137158e-25,
 -1.914346889612640e-27,  5.341682250670139e-30,  9.993906733201012e-02, -4.584487404528991e-04,  1.509000749543421e-06, -4.130671443217045e-09,  9.556539347842679e-12,
 -1.762132655084519e-14,  1.911911217834683e-17,  2.765500310861370e-20, -2.520152141695629e-22,  9.569318140475708e-25, -2.610150851761133e-27,  5.124411153699402e-30,
  1.280775293155414e-01, -5.811163640135330e-04,  1.865890459356554e-06, -4.864569160017012e-09,  1.020754618455470e-11, -1.471183823717747e-14, -6.267765307524820e-19,
  9.993655665854495e-20, -4.378269891550340e-22,  1.242818004659748e-24, -2.376540957428903e-27,  1.356616256932016e-30,  1.595759364637465e-01, -7.150142985525931e-04,
  2.230540615598256e-06, -5.480650373675219e-09,  1.006812603469682e-11, -8.747265982260704e-15, -2.811725336355364e-17,  1.797086484494123e-19, -5.762684668138632e-22,
  1.183661149895026e-24, -7.851836101157587e-28, -5.987839617358146e-30,  1.943753240438555e-01, -8.586913815987933e-04,  2.591066081235004e-06, -5.922603779993860e-09,
  8.985421332709915e-12,  2.605489725478469e-16, -6.066799973608969e-17,  2.501022008685575e-19, -6.031139106775342e-22,  6.318984350813552e-25,  2.154448308693787e-27,
 -1.486786570045119e-29,  2.324082316554946e-01, -1.010536304529866e-03,  2.934926510093563e-06, -6.137474173258494e-09,  6.865225571753050e-12,  1.190514572663817e-14,
 -9.398868259919481e-17,  2.911037007003920e-19, -4.638536823339266e-22, -4.375367432995055e-25,  5.802558848562765e-27, -2.124442354240623e-29,  2.735980608143062e-01,
 -1.168780125147829e-03,  3.249166212381785e-06, -6.078488648497279e-09,  3.687711338772022e-12,  2.536056398431182e-14, -1.225254316948628e-16,  2.831410351824126e-19,
 -1.327280433333952e-22, -1.869994970603095e-24,  8.890837445598996e-27, -2.024042918335265e-29,  3.178583559718113e-01, -1.331500235448723e-03,  3.520691086321096e-06,
 -5.707997791116234e-09, -4.797125401436253e-13,  3.939795953412005e-14, -1.400803610302093e-16,  2.115561686122332e-19,  3.700773184032062e-22, -3.315434974409699e-24,
  9.796548075541364e-27, -8.300426254782752e-30,  3.650920070006271e-01, -1.496626206653195e-03,  3.736584784482024e-06, -5.000440937074927e-09, -5.473822101275572e-12,
  5.245091176596184e-14, -1.406836971001677e-16,  7.130379277740244e-20,  9.682668041059647e-22, -4.275062597555598e-24,  7.088517344515549e-27,  1.427823759934875e-29,
  4.151903719268726e-01, -1.661948004235957e-03,  3.884465447862979e-06, -3.945216849008858e-09, -1.103277436134468e-11,  6.273364870288811e-14, -1.196505771412278e-16,
 -1.290364979129432e-19,  1.531470156840502e-21, -4.218442881652208e-24,  2.323528343165086e-28,  4.156019801186065e-29,  4.680323198386103e-01, -1.825127141341590e-03,
  3.952883030910517e-06, -2.549309466850950e-09, -1.680058093304900e-11,  6.841195343721030e-14, -7.470576857369825e-17, -3.650103084928715e-19,  1.893276278933693e-21,
 -2.758603868161463e-24, -9.775865269779614e-27,  6.222987719147868e-29,  5.234831955442943e-01, -1.983711417274520e-03,  3.931755331076391e-06, -8.394838618753194e-10,
 -2.234023983655760e-11,  6.782042319323051e-14, -7.010795385908749e-18, -5.968791383940664e-19,  1.886097495764764e-21,  1.529810984442821e-25, -2.015633678438876e-26,
  6.280017196855161e-29,  5.813937098219050e-01, -2.135153964845090e-03,  3.812838188750008e-06,  1.136167747017265e-09, -2.715660464571776e-11,  5.971206714115108e-14,
  7.811236859370266e-17, -7.738956828416571e-19,  1.389191540980884e-21,  4.073819962725227e-24, -2.676474480876995e-26,  3.359721768834789e-29,  6.415987621313040e-01,
 -2.276837400324402e-03,  3.590221795493424e-06,  3.307582603468813e-09, -3.072953129003035e-11,  4.351728923658367e-14,  1.709871548021372e-16, -8.425750381242252e-19,
  3.806818203697330e-22,  8.035549383668612e-24, -2.531781233452170e-26, -2.426151964631664e-29,  7.039162066218125e-01, -2.406103924001730e-03,  3.260840511604670e-06,
  5.583263943183755e-09, -3.255701109018109e-11,  1.957988720531986e-14,  2.581298759754938e-16, -7.584221957072993e-19, -1.020847616762438e-21,  1.069270766774564e-23,
 -1.325100317797742e-26, -9.423502069560060e-29,  7.681455773312509e-01, -2.520292245849277e-03,  2.824977959673954e-06,  7.852284050112727e-09, -3.220683234329821e-11,
 -1.067082498961940e-14,  3.236874229247841e-16, -4.994649985344732e-19, -2.542766691192011e-21,  1.068001252121123e-23,  8.363806647748200e-27, -1.459690035695767e-28,
  8.340667948249542e-01, -2.616782193463569e-03,  2.286742421790607e-06,  9.988024771869256e-09, -2.937380345376438e-11, -4.465823658502094e-14,  3.517885222058580e-16,
 -7.874382743121775e-20, -3.789137340789651e-21,  7.129032255558800e-24,  3.375170443193755e-26, -1.455946058367627e-28,  9.014388843380304e-01, -2.693047777415963e-03,
  1.654479856191829e-06,  1.185387380646881e-08, -2.393776921763394e-11, -7.875334157577057e-14,  3.296410045365169e-16,  4.480597362661648e-19, -4.324233822675199e-21,
  2.013283433386108e-25,  5.318766048986665e-26, -7.325519154696237e-29,  9.699987449033125e-01, -2.746719316481574e-03,  9.410835112975701e-07,  1.331099197821939e-08,
 -1.601570196533739e-11, -1.085636278273997e-13,  2.509634224502269e-16,  9.839643352374641e-19, -3.801966218246719e-21, -8.586238631798461e-24,  5.609362438280381e-26,
  5.906378357014892e-29,  1.039460020045404e+00, -2.775654931191616e-03,  1.641508061619181e-07,  1.422809968033933e-08, -5.999322257385544e-12, -1.294322052247526e-13,
  1.190791261876720e-16,  1.404215130641075e-18, -2.113277291720195e-21, -1.648828483065786e-23,  3.598438610409582e-26,  2.006338330350666e-28,  1.109512133355597e+00,
 -2.778021264505100e-03, -6.540690687671921e-07,  1.449298922879257e-08,  5.431573090784246e-12, -1.371283744821123e-13, -5.120753714844065e-17,  1.582730923310594e-18,
  4.974739206612457e-22, -2.026146826879943e-23, -4.586253677634298e-27,  2.764087221157479e-28,  1.179819566408947e+00, -2.752382648194382e-03, -1.486997930445960e-06,
  1.402515128641816e-08,  1.733003807218285e-11, -1.286624808042578e-13, -2.338926106467768e-16,  1.428121726095432e-18,  3.407343951055704e-21, -1.742232017760910e-23,
 -5.195497374553560e-26,  2.241212836372231e-28,  1.250021471556079e+00, -2.697797072309720e-03, -2.304382632409218e-06,  1.278851916356953e-08,  2.854542494437163e-11,
 -1.031014590714361e-13, -3.949507024428957e-16,  9.209019658975354e-19,  5.730535154229135e-21, -7.635050569470406e-24, -8.479767962261039e-26,  3.943414317510211e-29,
  1.319731727273485e+00, -2.613916214840494e-03, -3.073333569900345e-06,  1.080291799713214e-08,  3.783339301738586e-11, -6.220843508399665e-14, -4.986010709667552e-16,
  1.391506661180297e-19,  6.583858808596043e-21,  6.445303795470377e-24, -8.354361242428055e-26, -1.999610592694870e-28,  1.388539557687246e+00, -2.501085455324036e-03,
 -3.759782884280111e-06,  8.152419452958765e-09,  4.400931824293036e-11, -1.069838936044019e-14, -5.159509440305418e-16, -7.414429550915907e-19,  5.442409774748835e-21,
  1.957436527648765e-23, -4.235086892610795e-26, -3.597109496782415e-28,  1.456010848756445e+00, -2.360438274107348e-03, -4.330366430297899e-06,  4.988543781669965e-09,
  4.613189206177970e-11,  4.408467870606054e-14, -4.341936574147157e-16, -1.482921031894718e-18,  2.451894159328227e-21,  2.585506570672298e-23,  2.333378292120791e-26,
 -3.262420471264884e-28,  1.521690298992415e+00, -2.193977827911203e-03, -4.754687353212406e-06,  1.526248097254377e-09,  4.369189964292213e-11,  9.318354339864885e-14,
 -2.635580251007092e-16, -1.854400509257598e-18, -1.474412698038782e-21,  2.166705718331609e-23,  8.076669715157891e-26, -9.545822067305794e-29,  1.585104539533636e+00,
 -2.004636962971350e-03, -5.007857942479243e-06, -1.968964115039821e-09,  3.677002669045075e-11,  1.276942159666751e-13, -3.886584843590020e-17, -1.717819805020099e-18,
 -4.902700246292566e-21,  8.144710059152735e-24,  9.700857726799743e-26,  1.977543566594031e-28,  1.645766343557252e+00, -1.796306730781845e-03, -5.073143697530743e-06,
 -5.203558639736621e-09,  2.612080093175759e-11,  1.408230595601020e-13,  1.866145154036713e-16, -1.097328495252037e-18, -6.453046699392298e-21, -8.551538304091408e-24,
  6.086579470152689e-26,  3.564605137022378e-28,  1.703180015031654e+00, -1.573822936698536e-03, -4.944457276403966e-06, -7.887367681913027e-09,  1.314195959381173e-11,
  1.298483773652897e-13,  3.550767662965388e-16, -1.949278864584199e-19, -5.480041140875662e-21, -2.005237756388865e-23, -5.971966220193215e-27,  2.698708076224428e-28,
  1.756847998900485e+00, -1.342900757287028e-03, -4.628383558189685e-06, -9.771156050542293e-09, -2.963826792177897e-13,  9.735491396426130e-14,  4.226071765589122e-16,
  6.705852589833255e-19, -2.490068297468091e-21, -2.059804889691693e-23, -6.067030012408562e-26,  1.437092384517587e-29,  1.806278687484129e+00, -1.110009380924118e-03,
 -4.145378619331365e-06, -1.068548939778910e-08, -1.215910707857739e-11,  5.114909626695228e-14,  3.757633816110705e-16,  1.190183059508507e-18,  1.025962636367830e-21,
 -1.086848179339495e-23, -6.945441655495801e-26, -2.007458007743337e-28,  1.850995312035246e+00, -8.821822339292852e-04, -3.529795514453034e-06, -1.057420817324574e-08,
 -2.064652335974953e-11,  2.558685123024500e-15,  2.387630239701803e-16,  1.204733184291171e-18,  3.364536519219034e-21,  2.245324594114694e-24, -3.360181090384111e-26,
 -2.168480577578903e-28,  1.890545708108180e+00, -6.667637153308487e-04, -2.828466331740115e-06, -9.514970670324416e-09, -2.460395601692218e-11, -3.664813978402735e-14,
  6.610028736258530e-17,  7.843014860500770e-19,  3.584571082046670e-21,  1.040633830973231e-23,  1.270906508516428e-26, -6.735918648686248e-29,  1.924512636993152e+00,
 -4.711002097465402e-04, -2.097721640131325e-06, -7.720123043164635e-09, -2.383060333392676e-11, -5.787737704743329e-14, -7.863326254177127e-17,  1.914363221267194e-19,
  2.045293542149095e-21,  9.828710224959571e-24,  3.333006389819264e-26,  7.494716555976367e-29,  1.952524246807617e+00, -3.021907913327665e-04, -1.398947144767656e-06,
 -5.513948799958339e-09, -1.918180486855446e-11, -5.858705524078823e-14, -1.496235100956335e-16, -2.646184893592207e-19,  7.943945425452071e-23,  3.588506915825058e-24,
  2.139077003896591e-26,  9.002815109580526e-29,  1.974264193461556e+00, -1.663203082865254e-04, -7.930335580744619e-07, -3.286955288530200e-09, -1.240146988390523e-11,
 -4.319876736175943e-14, -1.386780198852131e-16, -4.031188669098402e-19, -1.010688619105268e-21, -1.863625335387566e-24, -2.567637612497308e-28,  2.024164388635800e-29,
  1.989481036771033e+00, -6.870238280860148e-05, -3.343166551853792e-07, -1.433362353598131e-09, -5.697046200034814e-12, -2.143677006335627e-14, -7.708430374466452e-17,
 -2.657985266189752e-19, -8.782044252316860e-22, -2.766760214749643e-24, -8.222314438631472e-27, -2.254654451518495e-29,  1.997998577818545e+00, -1.314916092893067e-05,
 -6.471195689488625e-08, -2.826254985356399e-10, -1.154857655995422e-12, -4.519163029918309e-15, -1.714391535830728e-17, -6.349952359107152e-20, -2.306472433559187e-22,
 -8.238798429898708e-25, -2.899348229515822e-27, -1.006318661106501e-29,  4.391831328714236e-04, -2.071310108891656e-06,  7.325235084739995e-09, -2.302233023556742e-11,
  6.781240916371851e-14, -1.916861409713871e-16,  5.265517119695753e-19, -1.416236051385239e-21,  3.747422142447747e-24, -9.787797721919607e-27,  2.528985725917928e-29,
 -6.476008634425491e-32,  3.951685906606241e-03, -1.861407362147190e-05,  6.565400375685395e-08, -2.053973296223888e-10,  6.007534467943552e-13, -1.681201750546588e-15,
  4.555783459570950e-18, -1.203742721324545e-20,  3.113806687988199e-23, -7.906023168881259e-26,  1.972848478990005e-28, -4.842144342582615e-31,  1.097154743992695e-02,
 -5.155170923258650e-05,  1.808578079427920e-07, -5.605833538033477e-10,  1.616235047931693e-12, -4.430147655223080e-15,  1.166552850487790e-17, -2.965717343693390e-20,
  7.290159046773210e-23, -1.731007409867722e-25,  3.954147352103778e-28, -8.623363542191863e-31,  2.148842292694396e-02, -1.005881238595239e-04,  3.500430240246660e-07,
 -1.069718866430924e-09,  3.016212452756629e-12, -7.999429502052513e-15,  2.009132641334520e-17, -4.776177685514600e-20,  1.066286362728888e-22, -2.194417039277768e-25,
  3.984210634601044e-28, -5.607964569794445e-31,  3.548665269403653e-02, -1.652784214129056e-04,  5.689042552895798e-07, -1.705178640253484e-09,  4.660451543391784e-12,
 -1.178201359789576e-14,  2.750697553976185e-17, -5.830886426060401e-20,  1.070595175116456e-22, -1.463331738174042e-25,  2.599580985186251e-29,  7.959076997990333e-31,
  5.294508978822064e-02, -2.450280495310109e-04,  8.317675873304264e-07, -2.431376882089709e-09,  6.374563613201319e-12, -1.506181331895579e-14,  3.137603870357155e-17,
 -5.352683724885493e-20,  5.420997028681107e-23,  8.440755264203738e-26, -7.417770165671844e-28,  2.932446432418579e-30,  7.383686768570502e-02, -3.390917551670025e-04,
  1.131650274158704e-06, -3.205841555285270e-09,  7.960431732355513e-12, -1.708710436446610e-14,  2.936659220034949e-17, -2.788040358489385e-20, -5.868927883507811e-23,
  4.503424716382622e-25, -1.691273645217872e-27,  4.804824242199040e-30,  9.812910608576507e-02, -4.465724339283209e-04,  1.460338571366585e-06, -3.980561047296223e-09,
  9.208759548123223e-12, -1.715405594272859e-14,  1.978558723707893e-17,  2.012199575476305e-20, -2.193912331235684e-22,  8.569693545626989e-25, -2.389673837752656e-27,
  4.891011795331673e-30,  1.257825522897949e-01, -5.664199855684938e-04,  1.808485843941452e-06, -4.703602209062911e-09,  9.913377640495675e-12, -1.469484468503904e-14,
  1.981896616642695e-18,  8.662373607201626e-20, -3.947807518941059e-22,  1.149114047932575e-24, -2.304892205972028e-27,  1.873978394787869e-30,  1.567511552382983e-01,
 -6.974303198411724e-04,  2.165733463836087e-06, -5.320994910736991e-09,  9.886829550405938e-12, -9.363742599537802e-15, -2.333721956976008e-17,  1.619432972593250e-19,
 -5.342812727529121e-22,  1.147444345176017e-24, -1.014734187574846e-27, -4.487738882556918e-30,  1.909815689071635e-01, -8.382446940020330e-04,  2.520857358435514e-06,
 -5.778872119894995e-09,  8.976628044285012e-12, -1.113607958354836e-15, -5.393180194271246e-17,  2.311819220107157e-19, -5.789659513957937e-22,  7.056563756944115e-25,
  1.549479104078359e-27, -1.266690777318160e-29,  2.284125814726176e-01, -9.873496065548938e-04,  2.861943349556504e-06, -6.025845561076548e-09,  7.081422701085385e-12,
  9.745537895475297e-15, -8.604764442488842e-17,  2.760513637199898e-19, -4.756471669620772e-22, -2.235503260718691e-25,  4.911111844213685e-27, -1.927505142897278e-29,
  2.689744664735880e-01, -1.143077522323052e-03,  3.176594596655734e-06, -6.015584663907335e-09,  4.166155943134904e-12,  2.251454927421658e-14, -1.146665860050258e-16,
  2.778835199256202e-19, -1.938604550873486e-22, -1.532097690805381e-24,  8.006611055398100e-27, -1.988722807798367e-29,  3.125882521728267e-01, -1.303608762425709e-03,
  3.452174476935622e-06, -5.709550146319356e-09,  2.751136310811815e-13,  3.610834434233430e-14, -1.340084019802501e-16,  2.215638186646454e-19,  2.576798325571991e-22,
 -2.931670663736072e-24,  9.373435630901683e-27, -1.080533890727564e-29,  3.591649054987217e-01, -1.466974959884796e-03,  3.676088031671688e-06, -5.079812656351868e-09,
 -4.458388737521280e-12,  4.910182214199848e-14, -1.382761472558207e-16,  9.988174274876143e-20,  8.196039559055004e-22, -3.980672768329684e-24,  7.590071513280041e-27,
  8.661932903899378e-30,  4.086044274084630e-01, -1.631064557640666e-03,  3.836104595019713e-06, -4.111861009942381e-09, -9.807082155410456e-12,  5.982407621228487e-14,
 -1.226002978021708e-16, -8.245403591988717e-20,  1.380194388498846e-21, -4.174747100418422e-24,  1.899455570783867e-27,  3.428808787148732e-29,  4.607948573390758e-01,
 -1.793630910370222e-03,  3.920723288670072e-06, -2.807273618481772e-09, -1.545106410939317e-11,  6.650312328522934e-14, -8.409330652072029e-17, -3.060846341094734e-19,
  1.787573027314781e-21, -3.096507369406483e-24, -7.160720851649840e-27,  5.654878519071614e-29,  5.156111857168714e-01, -1.952303643396579e-03,  3.919581578344677e-06,
 -1.186091133202334e-09, -2.098683243631668e-11,  6.745843250149603e-14, -2.287868969804754e-17, -5.365860937092374e-19,  1.877759524975009e-21, -5.978865174973008e-25,
 -1.738721840161477e-26,  6.278138671456381e-29,  5.729141754146096e-01, -2.104604018491792e-03,  3.823904887669811e-06,  7.113105865088630e-10, -2.594534502024960e-11,
  6.133188655349908e-14,  5.708623922595918e-17, -7.272986012611215e-19,  1.516959495960329e-21,  3.035483352124228e-24, -2.508997465954948e-26,  4.212707235893994e-29,
  6.325490957438571e-01, -2.247965152872828e-03,  3.626992173541732e-06,  2.823087843161481e-09, -2.982005132548460e-11,  4.733951254493543e-14,  1.476076834732243e-16,
 -8.259619853465694e-19,  6.515209347453518e-22,  7.006450292833592e-24, -2.601764452289558e-26, -7.859012496785716e-30,  6.943443762421075e-01, -2.379758026834432e-03,
  3.324728199046284e-06,  5.065813866978050e-09, -3.210519985959021e-11,  2.551683481604127e-14,  2.364938089912244e-16, -7.850404014958334e-19, -6.464004601577458e-22,
  1.008520045102740e-23, -1.698875641489418e-26, -7.562815622789091e-29,  7.581101923834133e-01, -2.497324286297515e-03,  2.916107823501201e-06,  7.335684573262000e-09,
 -3.234374265246684e-11, -3.078984462692279e-15,  3.086214321653010e-16, -5.746296617588499e-19, -2.153784833824753e-21,  1.088915923324417e-23,  2.174762157993640e-27,
 -1.348283623168992e-28,  8.236370016544441e-01, -2.598016883479614e-03,  2.403750842805162e-06,  9.511356337966974e-09, -3.018278730330878e-11, -3.625522535566086e-14,
  3.479265282795154e-16, -1.956420014627346e-19, -3.509754834468105e-21,  8.348857205107905e-24,  2.719673122012104e-26, -1.514776561452642e-28,  8.906940564540923e-01,
 -2.679249580589271e-03,  1.794377742200921e-06,  1.145870280064439e-08, -2.543278673850687e-11, -7.070702461298505e-14,  3.402533985123287e-16,  3.102040347559854e-19,
 -4.279541596832345e-21,  2.256319050887163e-24,  4.937114855005695e-26, -9.943164183242415e-29,  9.590279302441000e-01, -2.738556239892237e-03,  1.099207340714449e-06,
  1.303770693911942e-08, -1.812458387577459e-11, -1.022239115988493e-13,  2.767677877388789e-16,  8.577931886244873e-19, -4.070160533964783e-21, -6.301872201701422e-24,
  5.784471887945961e-26,  2.064678877715971e-29,  1.028361105507342e+00, -2.773660603435646e-03,  3.342271813044235e-07,  1.411156987428925e-08, -8.556244394504696e-12,
 -1.261106696394555e-13,  1.573632450395505e-16,  1.327387546225772e-18, -2.678899735871204e-21, -1.488126928223719e-23,  4.413572066665478e-26,  1.689865560607002e-28,
  1.098390686470121e+00, -2.782556884978426e-03, -4.797224468037092e-07,  1.455790217502245e-08,  2.680311860013165e-12, -1.378244335719569e-13, -6.777972680640426e-18,
  1.586967864207444e-18, -2.323110923604485e-22, -2.020193691521596e-23,  7.538874227658041e-27,  2.731245683656955e-28,  1.168787316155262e+00, -2.763600908085982e-03,
 -1.317118298888286e-06,  1.428155471250830e-08,  1.470395437614570e-11, -1.337843269901399e-13, -1.924757464179946e-16,  1.526740338442912e-18,  2.745210073705054e-21,
 -1.929235190051578e-23, -4.129046933194795e-26,  2.592635689608419e-28,  1.239194395822846e+00, -2.715610680108770e-03, -2.148249732042090e-06,  1.322824384982296e-08,
  2.639080212961250e-11, -1.122504085278394e-13, -3.666441309068466e-16,  1.099231124400574e-18,  5.395199498208889e-21, -1.097442416383106e-23, -8.172967098137024e-26,
  9.998615848750412e-29,  1.309227724496819e+00, -2.637974151425578e-03, -2.940109707206968e-06,  1.139765051555023e-08,  3.646999951602582e-11, -7.410410800258185e-14,
 -4.917250953383374e-16,  3.528853277327716e-19,  6.753748250806797e-21,  2.942046617667419e-24, -9.124355612175996e-26, -1.484044054306221e-28,  1.378475695796271e+00,
 -2.530760452396238e-03, -3.657738215023184e-06,  8.854177306259287e-09,  4.366994506228537e-11, -2.331001842998930e-14, -5.341697209068611e-16, -5.563688848571029e-19,
  6.112785637195978e-21,  1.756461021068613e-23, -5.809118625411255e-26, -3.534189431680559e-28,  1.446500206724732e+00, -2.394829144312750e-03, -4.266048019591593e-06,
  5.733127467896210e-09,  4.690606538498281e-11,  3.317550128177762e-14, -4.744759529271194e-16, -1.389416751981702e-18,  3.395879511780184e-21,  2.648628484720007e-23,
  7.868367026171372e-27, -3.754547288414449e-28,  1.512838445639483e+00, -2.231930043313412e-03, -4.732117614257077e-06,  2.239866438455202e-09,  4.548808638958934e-11,
  8.623048354707113e-14, -3.160201225987551e-16, -1.888487467201142e-18, -6.374540794610292e-22,  2.479219586921354e-23,  7.494700457054099e-26, -1.700033790339089e-28,
  1.577005730688473e+00, -2.044784141657983e-03, -5.027871520727865e-06, -1.360279963363141e-09,  3.931059681768612e-11,  1.261668180944190e-13, -8.911169917744079e-17,
 -1.869249669998507e-18, -4.537660685761126e-21,  1.218644048466391e-23,  1.047387343411378e-25,  1.511713623608923e-28,  1.638499561179031e+00, -1.837134330740477e-03,
 -5.132985102401024e-06, -4.762861659819437e-09,  2.897943912763981e-11,  1.449095044455768e-13,  1.529556011099640e-16, -1.308250775483959e-18, -6.713248276050851e-21,
 -5.797822783323209e-24,  7.693412417964024e-26,  3.720827685394653e-28,  1.696805017838998e+00, -1.613753413578437e-03, -5.037756866639944e-06, -7.655859788707186e-09,
  1.582359822296690e-11,  1.382842400819295e-13,  3.470550146357778e-16, -3.818611844332796e-19, -6.203202549499031e-21, -2.003591207053886e-23,  7.241230183546361e-27,
  3.310681423132242e-28,  1.751401599212382e+00, -1.380396770268257e-03, -4.745599827163650e-06, -9.759764094378307e-09,  1.753612707032942e-12,  1.077130968890786e-13,
  4.401532086397608e-16,  5.785723176185408e-19, -3.274996781042870e-21, -2.299761094806136e-23, -5.892588755677197e-26,  6.681907877230982e-29,  1.801771507242814e+00,
 -1.143688539660387e-03, -4.274736389647092e-06, -1.087134986772783e-08, -1.104322503862822e-11,  6.057064768757621e-14,  4.094853954907670e-16,  1.216200159037654e-18,
  5.825629381892771e-22, -1.382303308315201e-23, -7.825154025960348e-26, -1.977419455104310e-28,  1.847409294810958e+00, -9.109337699217449e-04, -3.658665349640995e-06,
 -1.090382012159387e-08, -2.053525103857327e-11,  8.706019152864780e-15,  2.740130566069197e-16,  1.313412971058875e-18,  3.418780957336004e-21,  7.000213565517480e-25,
 -4.392418639257984e-26, -2.526446599191579e-28,  1.887832665127168e+00, -6.898549119601208e-04, -2.945031847153912e-06, -9.914403769971550e-09, -2.531920747819808e-11,
 -3.478489626753808e-14,  8.972359937729708e-17,  9.050936228655380e-19,  3.967558083011861e-21,  1.084682987812253e-23,  9.091121568554518e-27, -9.818260110193060e-29,
  1.922594076610807e+00, -4.882591193279603e-04, -2.192689380475836e-06, -8.110773654798389e-09, -2.500654903646139e-11, -5.969252066132498e-14, -7.230168915724272e-17,
  2.628108165224433e-19,  2.423920134582967e-21,  1.122789936578917e-23,  3.662539611832701e-26,  7.438318037977395e-29,  1.951292673943027e+00, -3.136523458166448e-04,
 -1.466995289968062e-06, -5.830429228162686e-09, -2.039005375728930e-11, -6.226651857370904e-14, -1.569765944272184e-16, -2.598363026497068e-19,  2.250213156022581e-22,
  4.527738561104843e-24,  2.568254506360598e-26,  1.053706589594404e-28,  1.973585969032641e+00, -1.728257906611083e-04, -8.336966702540372e-07, -3.492475349825711e-09,
 -1.329966138042667e-11, -4.666620444553586e-14, -1.504282260644670e-16, -4.365344727857482e-19, -1.077731228203644e-21, -1.854068255441145e-24,  7.875438303357798e-28,
  2.751438552849255e-29,  1.989200767006314e+00, -7.144730028937126e-05, -3.520784007902040e-07, -1.528048082676656e-09, -6.144901476110493e-12, -2.337937159721479e-14,
 -8.493553580252965e-17, -2.955601854386926e-19, -9.839740546469198e-22, -3.116278252089963e-24, -9.273437999507277e-27, -2.527198117195120e-29,  1.997944923851272e+00,
 -1.368074374673638e-05, -6.821738596444066e-08, -3.018492626614356e-10, -1.249503902815670e-12, -4.952815086654901e-15, -1.902985556518282e-17, -7.137806928183315e-20,
 -2.625057581112188e-22, -9.492189207495336e-25, -3.380778185509322e-27, -1.187272669605871e-29,  4.310133721614799e-04, -2.013795142057700e-06,  7.055352788233074e-09,
 -2.196732809094800e-11,  6.410191540700165e-14, -1.795115232554976e-16,  4.885243364320132e-19, -1.301766514119339e-21,  3.412604013412260e-24, -8.830943020183813e-27,
  2.260677754941189e-29, -5.735751752825488e-32,  3.878264693351542e-03, -1.809853977569231e-05,  6.324581747443800e-08, -1.960484386158774e-10,  5.681960698722072e-13,
 -1.575797504231975e-15,  4.232268099543777e-18, -1.108506543357407e-20,  2.842895562722557e-23, -7.157893876824319e-26,  1.771641175416792e-28, -4.314340614088060e-31,
  1.076819233546785e-02, -5.013132179047048e-05,  1.742830908793090e-07, -5.354174824783950e-10,  1.530365897541392e-12, -4.159881819925514e-15,  1.086687208097663e-17,
 -2.742104871292084e-20,  6.694574117414266e-23, -1.580186310373514e-25,  3.592796574535308e-28, -7.814699044235234e-31,  2.109159096366283e-02, -9.783831775427674e-05,
  3.374907580393687e-07, -1.022713624665198e-09,  2.860939419441969e-12, -7.532907246739465e-15,  1.880060032252796e-17, -4.447303115873763e-20,  9.900968394854187e-23,
 -2.039947133221604e-25,  3.740281729598307e-28, -5.471323945630305e-31,  3.483451364918535e-02, -1.608077859808507e-04,  5.488818535150939e-07, -1.632461216836553e-09,
  4.431282681163146e-12, -1.114105569493339e-14,  2.592149986076302e-17, -5.496698165697818e-20,  1.018181905856881e-22, -1.446462407991227e-25,  5.708942302334504e-29,
  6.226333446119405e-31,  5.197810350483118e-02, -2.384889036720589e-04,  8.031932132040383e-07, -2.331753346069862e-09,  6.080737221508837e-12, -1.432657477502444e-14,
  2.990199073896433e-17, -5.174898096555063e-20,  5.674454089046579e-23,  5.719505914490637e-26, -6.217692522681392e-28,  2.531213452323387e-30,  7.249836644834035e-02,
 -3.301902938558928e-04,  1.093933222763185e-06, -3.081170559281856e-09,  7.625673359554678e-12, -1.639187166423449e-14,  2.856199461975615e-17, -2.951171532042372e-20,
 -4.364507709012202e-23,  3.867709296267226e-25, -1.490912452050069e-27,  4.309300680449762e-30,  9.636588274655324e-02, -4.350783134107086e-04,  1.413444642102887e-06,
 -3.835939565423972e-09,  8.870468625506161e-12, -1.667320632016475e-14,  2.025522465219973e-17,  1.357705878927226e-20, -1.902097258128570e-22,  7.656104985699184e-25,
 -2.180194881235828e-27,  4.626778769000349e-30,  1.235454544245707e-01, -5.521751975996607e-04,  1.752984613652710e-06, -4.547335958112978e-09,  9.620145646854339e-12,
 -1.461956352602687e-14,  4.236592564178002e-18,  7.463501654656141e-20, -3.550511932622985e-22,  1.058686758991496e-24, -2.213759698829578e-27,  2.246820445390392e-30,
  1.539956850762795e-01, -6.803571850916484e-04,  2.102824386027408e-06, -5.164332761052765e-09,  9.694311229387307e-12, -9.871317003027362e-15, -1.903601325978921e-17,
  1.454990280316157e-19, -4.937479112326841e-22,  1.103293713625480e-24, -1.183603544340165e-27, -3.224990294826921e-30,  1.876684880988403e-01, -8.183527814922954e-04,
  2.452371692423339e-06, -5.635492412038217e-09,  8.941925854615243e-12, -2.332363745765180e-15, -4.771418671298081e-17,  2.130723776234574e-19, -5.525755324089072e-22,
  7.570879128040661e-25,  1.036535962754095e-27, -1.068446178367503e-29,  2.245085189136221e-01, -9.647413601012553e-04,  2.790319095098627e-06, -5.911093120941201e-09,
  7.256299193182287e-12,  7.771421626223766e-15, -7.853224515644139e-17,  2.607381788640842e-19, -4.803581132126452e-22, -4.349097693052684e-26,  4.106063290012265e-27,
 -1.732498722034005e-29,  2.644525263571231e-01, -1.117952347155517e-03,  3.104821914106813e-06, -5.945470733953441e-09,  4.589553356584516e-12,  1.985517027738707e-14,
 -1.069805578220185e-16,  2.708576070725992e-19, -2.434604702608795e-22, -1.229151083637780e-24,  7.145789383367315e-27, -1.919253406546021e-29,  3.074286181655312e-01,
 -1.276265296426439e-03,  3.383709557345148e-06, -5.699543615255971e-09,  9.656254192372065e-13,  3.296742495251694e-14, -1.277045303417077e-16,  2.281923286030169e-19,
  1.587686582536372e-22, -2.566817077234734e-24,  8.856219596999549e-27, -1.259519214439814e-29,  3.533554353868365e-01, -1.437811225852439e-03,  3.614734100323653e-06,
 -5.143469894186228e-09, -3.509297275683075e-12,  4.581958825995779e-14, -1.351333976502784e-16,  1.238754538598602e-19,  6.818430003943940e-22, -3.670911505993399e-24,
  7.863255611306445e-27,  3.891971733261073e-30,  4.021412307026391e-01, -1.600575667844944e-03,  3.785859747107613e-06, -4.259363039968544e-09, -8.640186502470494e-12,
  5.685881701814889e-14, -1.243131564187542e-16, -4.067497762890727e-20,  1.231616088010133e-21, -4.070631092457951e-24,  3.256926580078300e-27,  2.750441234707346e-29,
  4.536828461165678e-01, -1.762403975525677e-03,  3.885596232260189e-06, -3.043962601149069e-09, -1.414184527494497e-11,  6.438839849565919e-14, -9.187996831414959e-17,
 -2.507164051318160e-19,  1.671526578428940e-21, -3.334946926570962e-24, -4.805700935467259e-27,  5.045059874356785e-29,  5.078645863815811e-01, -1.921009529244515e-03,
  3.903378161093974e-06, -1.511121923235374e-09, -1.964433665894770e-11,  6.673581644602801e-14, -3.706602560916835e-17, -4.769710175704158e-19,  1.844379393195921e-21,
 -1.238494786415036e-24, -1.465488554922996e-26,  6.118136688862764e-29,  5.645569860389142e-01, -2.073985599941994e-03,  3.829990563085136e-06,  3.060657845198665e-10,
 -2.470662735250187e-11,  6.246316342977003e-14,  3.741654493089639e-17, -6.771974061301310e-19,  1.608637171014817e-21,  2.070937888429862e-24, -2.309237916607708e-26,
  4.829751795508036e-29,  6.236154702073151e-01, -2.218821745154247e-03,  3.658038348929039e-06,  2.353726006521557e-09, -2.883969537390187e-11,  5.060715549058389e-14,
  1.248091135524467e-16, -8.012788669133706e-19,  8.849773589077835e-22,  5.963220255389721e-24, -2.603893034802108e-26,  6.544840335873725e-30,  6.848789125130259e-01,
 -2.352925734038904e-03,  3.382453685811906e-06,  4.556514239334269e-09, -3.153989579466600e-11,  3.092690590283308e-14,  2.142767003003526e-16, -8.000534748771349e-19,
 -2.963172470100115e-22,  9.344568748589732e-24, -1.990812633694842e-26, -5.714305323256021e-29,  7.481680980525192e-01, -2.473652110441118e-03,  3.001030295298456e-06,
  6.818088889707463e-09, -3.233259516966197e-11,  4.127428791126427e-15,  2.916258917818285e-16, -6.372732042705995e-19, -1.761603616964962e-21,  1.086142117291945e-23,
 -3.460267725723309e-27, -1.209193823506449e-28,  8.132841053379471e-01, -2.578338593521567e-03,  2.514967106841780e-06,  9.023082514035289e-09, -3.082489754520555e-11,
 -2.798313076364814e-14,  3.409227872752254e-16, -3.029483338285546e-19, -3.191226477094029e-21,  9.302851237394435e-24,  2.049768918791538e-26, -1.522106826602330e-28,
  8.800066291327840e-01, -2.664351563213741e-03,  1.929395406277049e-06,  1.104091145514767e-08, -2.676464248102980e-11, -6.245210085377213e-14,  3.470367538864970e-16,
  1.749305290609749e-19, -4.163881999627487e-21,  4.137068122860989e-24,  4.451251529066343e-26, -1.205411196337371e-28,  9.480922763060148e-01, -2.729141854116368e-03,
  1.253853586887242e-06,  1.273172657532163e-08, -2.010076925819806e-11, -9.530817751037110e-14,  2.989316501704195e-16,  7.243658479463385e-19, -4.255261559593341e-21,
 -3.980953559131675e-24,  5.793163538241362e-26, -1.634480917732386e-29,  1.017272879671242e+00, -2.770311948222748e-03,  5.026620860892862e-07,  1.395470991474029e-08,
 -1.103773221189576e-11, -1.218981189243722e-13,  1.932519222656371e-16,  1.233445798307150e-18, -3.181149940114529e-21, -1.297753183924286e-23,  5.078662052617067e-26,
  1.326927904013505e-28,  1.087253890524683e+00, -2.785695365679275e-03, -3.048612622960982e-07,  1.457874150117460e-08, -7.421146536326654e-14, -1.374553930883126e-13,
  3.744426952009919e-17,  1.567979127308354e-18, -9.512836581777038e-22, -1.966313468866890e-23,  1.930767781220514e-26,  2.602900605042288e-28,  1.157712929404544e+00,
 -2.773448545285273e-03, -1.144417133266105e-06,  1.449517620666930e-08,  1.198558484384772e-11, -1.378814860460032e-13, -1.486037138775655e-16,  1.603178732317959e-18,
  2.023783112065049e-21, -2.070742917336735e-23, -2.927301681114396e-26,  2.853832023827675e-28,  1.228298596358501e+00, -2.732154717635603e-03, -1.987052893386724e-06,
  1.363206932536124e-08,  2.406039161879923e-11, -1.206614043491331e-13, -3.335124470033424e-16,  1.264934947151181e-18,  4.942495411873518e-21, -1.413805372155146e-23,
 -7.602179099007682e-26,  1.589843710038497e-28,  1.298629666207991e+00, -2.660938138804291e-03, -2.799887756585736e-06,  1.196867644084575e-08,  3.487083021366870e-11,
 -8.576244688414498e-14, -4.788077956141011e-16,  5.699837378978837e-19,  6.792548731024965e-21, -8.210581769776539e-25, -9.647052728851306e-26, -8.786892873604003e-29,
  1.368294819809536e+00, -2.559585519362035e-03, -3.547313427066114e-06,  9.548465375351763e-09,  4.307439877032009e-11, -3.629436035673451e-14, -5.469178341946693e-16,
 -3.511211268917360e-19,  6.699582540398431e-21,  1.493502360953753e-23, -7.323591633945321e-26, -3.325115713264265e-28,  1.436853087170126e+00, -2.428669533558970e-03,
 -4.192727651640490e-06,  6.488300882591305e-09,  4.745261719090679e-11,  2.133439628036768e-14, -5.117146820407916e-16, -1.265464840707586e-18,  4.350954328732192e-21,
  2.645809971978172e-23, -9.568300763735426e-27, -4.153143851735467e-28,  1.503835199451000e+00, -2.269666969575301e-03, -4.700816832651783e-06,  2.981042598706923e-09,
  4.713255980245282e-11,  7.801000876779930e-14, -3.690451421345709e-16, -1.894043104128600e-18,  3.070152660762192e-22,  2.761749185890848e-23,  6.574365240920727e-26,
 -2.487811553772088e-28,  1.568746060143279e+00, -2.085061523850631e-03, -5.040338218623250e-06, -7.112580100220186e-10,  4.180822394017487e-11,  1.233840958263800e-13,
 -1.434117736122144e-16, -2.006614827122984e-18, -4.022087048376676e-21,  1.649198992583097e-23,  1.100902451954389e-25,  8.959614017788119e-29,  1.631068545537002e+00,
 -1.878418725017242e-03, -5.187261164891736e-06, -4.275818552501618e-09,  3.191124525237409e-11,  1.481164206770548e-13,  1.132900869548847e-16, -1.525788179697464e-18,
 -6.862612789620091e-21, -2.391135975433727e-24,  9.342187940840291e-26,  3.750071689216814e-28,  1.690268824586538e+00, -1.654418432650120e-03, -5.128015396039210e-06,
 -7.380108226371494e-09,  1.867159142292398e-11,  1.464621605445629e-13,  3.334760013366050e-16, -5.918188620421661e-19, -6.915604629873526e-21, -1.943664750363744e-23,
  2.317362388860233e-26,  3.930275846052696e-28,  1.745803341685977e+00, -1.418829393100109e-03, -4.862475685109982e-06, -9.713892950784591e-09,  4.014759108796869e-12,
  1.184585507121198e-13,  4.547583671333119e-16,  4.600777024643371e-19, -4.144466178495211e-21, -2.527780959398611e-23, -5.461624813356834e-26,  1.310508515532381e-28,
  1.797127526964573e+00, -1.178411163734266e-03, -4.406210999656003e-06, -1.103780458573940e-08, -9.730768392273927e-12,  7.080856515440924e-14,  4.437207731217457e-16,
  1.226259146377373e-18,  2.652109333494578e-23, -1.712418034982335e-23, -8.671435183017658e-26, -1.851414722768594e-28,  1.843706184530258e+00, -9.407320460554229e-04,
 -3.791475637095724e-06, -1.123062113584223e-08, -2.029232475824312e-11,  1.573601219339173e-14,  3.123214754735723e-16,  1.422855687695253e-18,  3.409578625133444e-21,
 -1.290117882269157e-24, -5.585234769337202e-26, -2.896330473339738e-28,  1.885025361683812e+00, -7.138979970118059e-04, -3.066457891175753e-06, -1.032495079420354e-08,
 -2.599124330210999e-11, -3.231270863767509e-14,  1.169028382591157e-16,  1.038364364340379e-18,  4.363452800081643e-21,  1.111346643956796e-23,  3.964889801608128e-27,
 -1.360661688254693e-28,  1.920605330961716e+00, -5.061968446206277e-04, -2.292458988280407e-06, -8.520520859557138e-09, -2.621710887972473e-11, -6.133030812009670e-14,
 -6.379425196423719e-17,  3.471326342653802e-19,  2.855276201501273e-21,  1.275751295802864e-23,  3.982730949821372e-26,  7.052317878149329e-29,  1.950014141566247e+00,
 -3.256738108211915e-04, -1.538959651557376e-06, -6.166839885732629e-09, -2.167364294928940e-11, -6.612029023135078e-14, -1.641252297000275e-16, -2.498200117537273e-19,
  4.076735042731099e-22,  5.652716861632555e-24,  3.069245338273977e-26,  1.226824945080382e-28,  1.972881056092926e+00, -1.796666925758063e-04, -8.769145885738622e-07,
 -3.712936909738892e-09, -1.427009870514267e-11, -5.042711592503615e-14, -1.631439913140381e-16, -4.720812173691556e-19, -1.143595870063677e-21, -1.795796012715767e-24,
  2.193162877538854e-27,  3.673377194727187e-29,  1.988909226011671e+00, -7.433898148731559e-05, -3.710206853221464e-07, -1.630220840788143e-09, -6.633562605034366e-12,
 -2.552079700317889e-14, -9.366942992637194e-17, -3.289161483005604e-19, -1.103112692793213e-21, -3.510310895250393e-24, -1.044979488100456e-26, -2.823750204297380e-29,
  1.997889085967623e+00, -1.424131915706550e-05, -7.196288062981350e-08, -3.226592874625356e-10, -1.353294298522880e-12, -5.434496406218532e-15, -2.115137342953640e-17,
 -8.035216095593782e-20, -2.992431893278432e-22, -1.095506436593086e-24, -3.949333113663224e-27, -1.403437416298762e-29,  4.230694319814599e-04, -1.958389584558585e-06,
  6.797782187607021e-09, -2.096979442693067e-11,  6.062604092672158e-14, -1.682122803866131e-16,  4.535571438450548e-19, -1.197480101585937e-21,  3.110376813884249e-24,
 -7.975172102778324e-27,  2.022909541033093e-29, -5.085766594724191e-32,  3.806867782720959e-03, -1.760183137149231e-05,  6.094676060054474e-08, -1.872040139313659e-10,
  5.376712445547506e-13, -1.477847185731686e-15,  3.934244594577394e-18, -1.021523689059241e-20,  2.597522674000887e-23, -6.485787706513888e-26,  1.592289734223968e-28,
 -3.847396415733167e-31,  1.057041546546988e-02, -4.876234707530563e-05,  1.680022958924617e-07, -5.115832955672442e-10,  1.449715348636423e-12, -3.908053445357831e-15,
  1.012823860400387e-17, -2.536709601109869e-20,  6.150766730473568e-23, -1.443130347462960e-25,  3.265340458047632e-28, -7.081565599514116e-31,  2.070556090224178e-02,
 -9.518671506124008e-05,  3.254879512810913e-07, -9.781197601587644e-10,  2.714694375620047e-12, -7.096284442056876e-15,  1.759862808432874e-17, -4.141938152231755e-20,
  9.192941809338122e-23, -1.895100298648360e-25,  3.503373113576922e-28, -5.291238110388921e-31,  3.419994222742508e-02, -1.564939006996178e-04,  5.297104770321140e-07,
 -1.563309977936549e-09,  4.214559944538839e-12, -1.053704522401334e-14,  2.442725953756529e-17, -5.179162417186268e-20,  9.665822493912509e-23, -1.418591421357196e-25,
  8.121568202509336e-29,  4.784219027929544e-31,  5.103682407490869e-02, -2.321736496920085e-04,  7.757865932539641e-07, -2.236715299229805e-09,  5.801265905004301e-12,
 -1.362610773043647e-14,  2.847871737364681e-17, -4.990479997370101e-20,  5.838175167850677e-23,  3.444497562913921e-26, -5.182915330631646e-28,  2.180101417258076e-30,
  7.119487693123085e-02, -3.215846747525525e-04,  1.057680541930745e-06, -2.961745523784383e-09,  7.304623109894696e-12, -1.571644508723183e-14,  2.771812684819652e-17,
 -3.069672494283854e-20, -3.075033528829974e-23,  3.307898482096383e-25, -1.311453443989939e-27,  3.854567158062590e-30,  9.464789644884081e-02, -4.239524937766385e-04,
  1.368254013871824e-06, -3.696653250414518e-09,  8.541893097059859e-12, -1.618318195984150e-14,  2.055419410950539e-17,  7.914901403692714e-21, -1.641691727055159e-22,
  6.823920321677722e-25, -1.982788801360583e-27,  4.344044578557382e-30,  1.213644594553454e-01, -5.383669983192214e-04,  1.699330487007667e-06, -4.395746545538582e-09,
  9.328933942800454e-12, -1.449405719401735e-14,  6.172919005562511e-18,  6.386629018056689e-20, -3.185077851238426e-22,  9.721961946847942e-25, -2.108919851669352e-27,
  2.500994939571513e-30,  1.513075127394379e-01, -6.637798562822322e-04,  2.041776455003869e-06, -5.010826661568117e-09,  9.492637165304717e-12, -1.028104267351931e-14,
 -1.517733516955797e-17,  1.303251967612770e-19, -4.549127521338710e-22,  1.053435775468706e-24, -1.301628936824083e-27, -2.172255295109825e-30,  1.844338900510550e-01,
 -7.990018833243559e-04,  2.385602472912737e-06, -5.492855003037336e-09,  8.884300204347548e-12, -3.407884573424443e-15, -4.199156473379248e-17,  1.958331581035704e-19,
 -5.246824530914028e-22,  7.896829145238254e-25,  6.060970210164792e-28, -8.915493303230576e-30,  2.206937521368311e-01, -9.427005549374587e-04,  2.720087386495023e-06,
 -5.793848861468176e-09,  7.393462261997736e-12,  5.972518445956337e-15, -7.144679442862995e-17,  2.453719099132435e-19, -4.791460126186446e-22,  1.060673336979246e-25,
  3.385620312028327e-27, -1.543510349543251e-29,  2.600299440644031e-01, -1.093397876793124e-03,  3.033929521954427e-06, -5.868997993429828e-09,  4.961591017068497e-12,
  1.737772573777069e-14, -9.951188346767662e-17,  2.624124101398287e-19, -2.827660920457989e-22, -9.599458774814298e-25,  6.321372822536693e-27, -1.824611600924711e-29,
  3.023772636029454e-01, -1.249468886371700e-03,  3.315428959037121e-06, -5.678983165613198e-09,  1.594844984768344e-12,  2.997967998868829e-14, -1.212574273471202e-16,
  2.318617010394980e-19,  7.260255750875161e-23, -2.224039787872966e-24,  8.274075933982488e-27, -1.377326790486334e-29,  3.476616340681375e-01, -1.409141125626676e-03,
  3.552705242505393e-06, -5.192462508316245e-09, -2.625044344352995e-12,  4.262035448117002e-14, -1.313788518844176e-16,  1.436409497656264e-19,  5.553817524189733e-22,
 -3.354180616871751e-24,  7.944395170313069e-27, -7.607116453382887e-32,  3.957991748704068e-01, -1.570495504054113e-03,  3.733954933575290e-06, -4.388671026467721e-09,
 -7.532915125193230e-12,  5.386595354537749e-14, -1.249221296243272e-16, -3.580548502092469e-21,  1.087692903974074e-21, -3.918020579415947e-24,  4.328406010631251e-27,
  2.130026732392827e-29,  4.466951631105948e-01, -1.731469065373819e-03,  3.847753165879041e-06, -3.260052072777780e-09, -1.287666635998333e-11,  6.210497062949773e-14,
 -9.816947238119833e-17, -1.991813520709863e-19,  1.548526622137534e-21, -3.484618253089534e-24, -2.723531554405452e-27,  4.418390980641547e-29,  5.002428800598051e-01,
 -1.889860279965290e-03,  3.883402718648498e-06, -1.814806334586991e-09, -1.831956366781342e-11,  6.569259373281418e-14, -4.960241118811869e-17, -4.187721641511122e-19,
  1.789884045165747e-21, -1.771612155094930e-24, -1.202186934912494e-26,  5.831848414562623e-29,  5.563223373873473e-01, -2.043337609252874e-03,  3.831332882647351e-06,
 -7.920369724414708e-11, -2.344988966517975e-11,  6.313950163012691e-14,  1.918564840705308e-17, -6.247021905520825e-19,  1.667088923998627e-21,  1.191071790060574e-24,
 -2.087182456277151e-26,  5.229683206388242e-29,  6.147988797517173e-01, -2.189452225969014e-03,  3.683548357468853e-06,  1.900543208369877e-09, -2.779939802322359e-11,
  5.333673578648295e-14,  1.028006192894699e-16, -7.697250055293063e-19,  1.081009206746963e-21,  4.931185543600790e-24, -2.547364848294969e-26,  1.878513087098573e-29,
  6.755216630838236e-01, -2.325655921934206e-03,  3.434125322701487e-06,  4.057095996520876e-09, -3.087175002873984e-11,  3.579996248636735e-14,  1.917919030221197e-16,
 -8.043114454357106e-19,  2.519580182753850e-23,  8.503257303109860e-24, -2.202798621900199e-26, -3.937594234453936e-29,  7.383220118658649e-01, -2.449325385564134e-03,
  3.079747371926871e-06,  6.301801858934126e-09, -3.218153310742668e-11,  1.090631652511892e-14,  2.730515762501066e-16, -6.874251911494756e-19, -1.374324806969122e-21,
  1.062115779035161e-23, -8.437205252158047e-27, -1.050467793261144e-28,  8.030116643026224e-01, -2.557794172739500e-03,  2.620267869666105e-06,  8.525848328043847e-09,
 -3.130348408327928e-11, -1.991399920018633e-14,  3.310619640238621e-16, -3.995639526240819e-19, -2.843172492216954e-21,  9.989650344461563e-24,  1.387092008372069e-26,
 -1.482866269904413e-28,  8.693809219166356e-01, -2.648393808176357e-03,  2.059277189459609e-06,  1.060313877157572e-08, -2.793007612148778e-11, -5.407934906142065e-14,
  3.500941677359162e-16,  4.440221083027381e-20, -3.984223126972307e-21,  5.806477552086075e-24,  3.884377380984303e-26, -1.362167943610264e-28,  9.371967302516968e-01,
 -2.718505512257667e-03,  1.404643009404859e-06,  1.239526138325394e-08, -2.193362637679787e-11, -8.790593448636363e-14,  3.172891691612065e-16,  5.863496524323752e-19,
 -4.357132773698607e-21, -1.688387853441827e-24,  5.644722422749003e-26, -5.057301397157085e-29,  1.006200730549041e+00, -2.765624011311761e-03,  6.689793778858725e-07,
  1.375886603089115e-08, -1.342657790323017e-11, -1.168575554367963e-13,  2.262958731486983e-16,  1.124576755368589e-18, -3.610471192749281e-21, -1.084070390677373e-23,
  5.576835124994133e-26,  9.339398400026646e-29,  1.076107338962655e+00, -2.787434704912248e-03, -1.300140103583942e-07,  1.455562493911688e-08, -2.810797057764874e-12,
 -1.360339776715789e-13,  8.081628394001082e-17,  1.526383207897911e-18, -1.642546335069294e-21, -1.866754605307246e-23,  3.031366056214197e-26,  2.386016376563281e-28,
  1.146601930507319e+00, -2.781905064576957e-03, -9.694159901245180e-07,  1.466470613218554e-08,  9.195961110995718e-12, -1.409026854022100e-13, -1.029215903800034e-16,
  1.655811227244373e-18,  1.260316294203689e-21, -2.162176046645411e-23, -1.632765690661978e-26,  3.012839722491327e-28,  1.217339229672833e+00, -2.747390443198341e-03,
 -1.821239275506463e-06,  1.399730722382895e-08,  2.157007971140721e-11, -1.282233037851660e-13, -2.959606457724871e-16,  1.414379071626546e-18,  4.380626702227623e-21,
 -1.702250316285382e-23, -6.780150269329494e-26,  2.137506618233002e-28,  1.287942038281534e+00, -2.682753393908645e-03, -2.652974649405255e-06,  1.251226923492621e-08,
  3.304208685389568e-11, -9.703781169108609e-14, -4.598149805703095e-16,  7.861212061751913e-19,  6.692776033444434e-21, -4.737797398338846e-24, -9.887586096875386e-26,
 -2.055674090986881e-29,  1.358000462862604e+00, -2.587494044019801e-03, -3.428622972809390e-06,  1.023113257649725e-08,  4.221658217435875e-11, -4.951366349931617e-14,
 -5.536711784158040e-16, -1.287253637039509e-19,  7.181072020712501e-21,  1.172246322131079e-23, -8.713040487028051e-26, -2.965866363572296e-28,  1.427071836763357e+00,
 -2.461886981183440e-03, -4.110300702791684e-06,  7.250277232173831e-09,  4.775370855141949e-11,  8.644657341507408e-15, -5.450560152522689e-16, -1.111104608941184e-18,
  5.292068477429304e-21,  2.570082704689937e-23, -2.849500534452156e-26, -4.426837803188916e-28,  1.494681563313802e+00, -2.307117478776246e-03, -4.660469717160900e-06,
  3.747145922705336e-09,  4.859990315411411e-11,  6.851857329865006e-14, -4.217878527480925e-16, -1.867826218914532e-18,  1.345728062388010e-21,  3.000478195980795e-23,
  5.303948754698694e-26, -3.285406912826080e-28,  1.560325130880742e+00, -2.125406811914224e-03, -5.044778950323362e-06, -2.279133790856920e-11,  4.423686330299880e-11,
  1.192540259541448e-13, -2.013035312684416e-16, -2.124965881170101e-18, -3.348353619486935e-21,  2.095301276758118e-23,  1.124044690685487e-25,  1.321636264406915e-29,
  1.623471562047947e+00, -1.920113147745365e-03, -5.235409313367795e-06, -3.741407243598673e-09,  3.489717430963788e-11,  1.502978497711469e-13,  6.748595483570008e-17,
 -1.746015720553883e-18, -6.877474341934739e-21,  1.673202390141114e-24,  1.097014948343707e-25,  3.621166875811332e-28,  1.683568549188299e+00, -1.695791496922567e-03,
 -5.214686164845841e-06, -7.057500057439426e-09,  2.167939467258845e-11,  1.542410873255070e-13,  3.137031678588886e-16, -8.240999203500636e-19, -7.594308323949344e-21,
 -1.814599188983541e-23,  4.179412496156529e-26,  4.526879683113767e-28,  1.740049488030687e+00, -1.458194189497827e-03, -4.978576868807450e-06, -9.630106332615801e-09,
  6.494034513549478e-12,  1.295114956287211e-13,  4.656440839368454e-16,  3.124856820303160e-19, -5.092206511962581e-21, -2.732556667685761e-23, -4.721649914486073e-26,
  2.072592614789700e-28,  1.792342540470585e+00, -1.214193201674472e-03, -4.539550168635781e-06, -1.118157722952346e-08, -8.205324957864702e-12,  8.186938874215575e-14,
  4.779703713055829e-16,  1.216559284775351e-18, -6.542911089146369e-22, -2.074935824072048e-23, -9.436426229883409e-26, -1.603444521504124e-28,  1.839881731451335e+00,
 -9.716084138461690e-04, -3.928179411344886e-06, -1.155235953612538e-08, -1.989935684563083e-11,  2.372207719269141e-14,  3.536787221389678e-16,  1.530762336283599e-18,
  3.319750242315696e-21, -3.789968434110298e-24, -6.940751634244739e-26, -3.263050136326282e-28,  1.882119911629163e+00, -7.389323754721815e-04, -3.192873264949675e-06,
 -1.074581810527801e-08, -2.660700266735372e-11, -2.914200137890927e-14,  1.479921600792150e-16,  1.184414349584822e-18,  4.764833233857513e-21,  1.113944228478689e-23,
 -2.999696921119062e-27, -1.818815645192441e-28,  1.918543206488900e+00, -5.249527263270977e-04, -2.397262819028972e-06, -8.949887142637183e-09, -2.745818316506997e-11,
 -6.273397341665194e-14, -5.272410412882434e-17,  4.461632183805840e-19,  3.343951779579308e-21,  1.441057712374926e-23,  4.276513758203995e-26,  6.215684457047988e-29,
  1.948686345831756e+00, -3.382874934840491e-04, -1.615086738994868e-06, -6.524413787929370e-09, -2.303599695260182e-11, -7.014156434988831e-14, -1.709052077162632e-16,
 -2.332706615910631e-19,  6.346209930194360e-22,  6.993916065552622e-24,  3.650819655622367e-26,  1.419981975301780e-28,  1.972148070923458e+00, -1.868641897769018e-04,
 -9.228737444436816e-07, -3.949544136703239e-09, -1.531888788429990e-11, -5.450538529655006e-14, -1.768841752477114e-16, -5.096903812916411e-19, -1.206246845523639e-21,
 -1.672513714928275e-24,  4.055575849620153e-27,  4.836147893910713e-29,  1.988605807258522e+00, -7.738724150030067e-05, -3.912374055392262e-07, -1.740566519495849e-09,
 -7.167226311277010e-12, -2.788348771513309e-14, -1.033928638698844e-16, -3.663208511591517e-19, -1.237315547403876e-21, -3.954075029876040e-24, -1.176164254063256e-26,
 -3.142650642328424e-29,  1.997830944232013e+00, -1.483288638745887e-05, -7.596838658107643e-08, -3.452098819526158e-10, -1.467248545933928e-12, -5.970247319649627e-15,
 -2.354144834323843e-17, -9.059069436286000e-20, -3.416803303338833e-22, -1.266557854425545e-24, -4.622072232641088e-27, -1.662176663831635e-29,  4.153430674019254e-04,
 -1.904997638803007e-06,  6.551855619464091e-09, -2.002611149945476e-11,  5.736799016961105e-14, -1.577182749350707e-16,  4.213790767569043e-19, -1.102389846165292e-21,
  2.837312168191522e-24, -7.209027824886573e-27,  1.811972325712846e-29, -4.514374047877410e-32,  3.737421581445097e-03, -1.712309904625098e-05,  5.875096985024195e-08,
 -1.788326948996709e-10,  5.090358278129629e-13, -1.386765822926967e-15,  3.659512428300678e-18, -9.420190879278547e-21,  2.375102303603195e-23, -5.881475452361210e-26,
  1.432282128388175e-28, -3.433940649657299e-31,  1.037801578253808e-02, -4.744249623939605e-05,  1.619999318351810e-07, -4.890001688710946e-10,  1.373928653828545e-12,
 -3.673281363185977e-15,  9.444751953886351e-18, -2.347951386118721e-20,  5.654017650369154e-23, -1.318548216947484e-25,  2.968603180715574e-28, -6.417333048787569e-31,
  2.032994854052268e-02, -9.262903344179921e-05,  3.140065145449406e-07, -9.357974954602935e-10,  2.576900109936889e-12, -6.687508071735413e-15,  1.647906317328432e-17,
 -3.858413849867515e-20,  8.535374348511866e-23, -1.759561507776798e-25,  3.275101572531164e-28, -5.080625975777488e-31,  3.358232477823331e-02, -1.523301252137805e-04,
  5.113485024502498e-07, -1.497531579741602e-09,  4.009565905353405e-12, -9.967848160100539e-15,  2.301963390139974e-17, -4.877960591759605e-20,  9.161450580957318e-23,
 -1.382263500990782e-25,  9.955343387049036e-29,  3.588442051371860e-31,  5.012037427195044e-02, -2.260731618087689e-04,  7.494940569641357e-07, -2.146038557021458e-09,
  5.535466553872873e-12, -1.295917441057988e-14,  2.710769694748713e-17, -4.802056284054470e-20,  5.927086364416476e-23,  1.553849930718749e-26, -4.292651893555734e-28,
  1.873442190034791e-30,  6.992523880200527e-02, -3.132634310003894e-04,  1.022830582888494e-06, -2.847350334898503e-09,  6.996876409159944e-12, -1.506162468617195e-14,
  2.684656233614096e-17, -3.150000093823162e-20, -1.974641681378973e-23,  2.815987043143932e-25, -1.151127726355068e-27,  3.439347331632591e-30,  9.297370084018479e-02,
 -4.131816020507311e-04,  1.324703602705786e-06, -3.562545402350945e-09,  8.223177441812373e-12, -1.568779336908425e-14,  2.070584967273662e-17,  3.039607317516358e-21,
 -1.409853805777250e-22,  6.068177833853960e-25, -1.798048030846739e-27,  4.052484083215533e-30,  1.192378502264572e-01, -5.249808347630476e-04,  1.647467567728676e-06,
 -4.248794014423711e-09,  9.040673331082873e-12, -1.432556802608741e-14,  7.823630356722893e-18,  5.421796373102825e-20, -2.850001321145219e-22,  8.900930187850073e-25,
 -1.995092169625080e-27,  2.658748195471736e-30,  1.486846845391777e-01, -6.476835980743738e-04,  1.982550981955441e-06, -4.860608013449795e-09,  9.283660974906734e-12,
 -1.060311973808712e-14, -1.172640202283784e-17,  1.163645484673743e-19, -4.179468073209063e-22,  9.997271967592899e-25, -1.377477012107571e-27, -1.303729430281426e-30,
  1.812756381046488e-01, -7.801783095781628e-04,  2.320538684132298e-06, -5.351304387764112e-09,  8.806498993697919e-12, -4.351753020829502e-15, -3.673899122505137e-17,
  1.795021174394549e-19, -4.959076674145000e-22,  8.065561567522734e-25,  2.489602700149580e-28, -7.350742759004186e-30,  2.169660338330617e-01, -9.212159410847121e-04,
  2.651274618913164e-06, -5.674688724121433e-09,  7.496312967736028e-12,  4.338512179805397e-15, -6.479028551893637e-17,  2.301251731614806e-19, -4.730487124378025e-22,
  2.284463831357974e-25,  2.746444503833026e-27, -1.363510352086907e-29,  2.557044513247633e-01, -1.069406777385011e-03,  2.963988914512428e-06, -5.786959385156330e-09,
  5.285852417533005e-12,  1.507655839673939e-14, -9.229587149423876e-17,  2.528582159618743e-19, -3.129633446311349e-22, -7.228277441829186e-25,  5.542712436242733e-27,
 -1.712420643297062e-29,  2.974320039893017e-01, -1.223217567540721e-03,  3.247453546606253e-06, -5.648824805622603e-09,  2.165863715398537e-12,  2.714759806838339e-14,
 -1.147443618078419e-16,  2.329666120285618e-19, -1.653744674460254e-24, -1.905426850723951e-24,  7.651742894362532e-27, -1.443760170482898e-29,  3.420815172983608e-01,
 -1.380969372222265e-03,  3.490171266458518e-06, -5.227813876946368e-09, -1.803832488014441e-12,  3.951742427343922e-14, -1.271258101705310e-16,  1.595424210743029e-19,
  4.403412013259498e-22, -3.037472702804067e-24,  7.867518643423677e-27, -3.301222834305607e-30,  3.895765998081045e-01, -1.540836488929673e-03,  3.680602745337509e-06,
 -4.500741979343456e-09, -6.485565707835001e-12,  5.087042337677876e-14, -1.245560545374243e-16,  2.900399119522507e-20,  9.499710422363630e-22, -3.727826810579763e-24,
  5.140708811264915e-27,  1.572988236496335e-29,  4.398305983145559e-01, -1.700846931440677e-03,  3.807436950706067e-06, -3.456271749185398e-09, -1.165855091952091e-11,
  5.968746125837754e-14, -1.030717974878048e-16, -1.516529737063124e-19,  1.421571159926319e-21, -3.556520081457410e-24, -9.169522358360739e-28,  3.795414585652640e-29,
  4.927454285545435e-01, -1.858885052428292e-03,  3.859909501498119e-06, -2.097477090873557e-09, -1.701853295951856e-11,  6.436783851194557e-14, -6.053638461628322e-17,
 -3.626041755813325e-19,  1.718059080351203e-21, -2.202232118530606e-24, -9.537007941095840e-27,  5.449511670516496e-29,  5.482102733789204e-01, -2.012697030233652e-03,
  3.828172985996140e-06, -4.442804317996697e-10, -2.218388059946166e-11,  6.339611942077251e-14,  2.446166507029827e-18, -5.708258704433648e-19,  1.695501314533284e-21,
  4.029586617800930e-25, -1.851885378284342e-26,  5.435746414952814e-29,  6.061001414958156e-01, -2.159900092564846e-03,  3.703721750386151e-06,  1.464413514307770e-09,
 -2.670971602267738e-11,  5.554938902044053e-14,  8.175790706392500e-17, -7.324871986421328e-19,  1.240418659739247e-21,  3.931880374829112e-24, -2.441865167788873e-26,
  2.880280985317003e-29,  6.662742819595373e-01, -2.297996519857961e-03,  3.479871203851198e-06,  3.569118434856644e-09, -3.011154325189718e-11,  4.013308731534123e-14,
  1.693272593250448e-16, -7.987804487045505e-19,  3.150808643259281e-22,  7.592464224830802e-24, -2.339096473891618e-26, -2.280926006526986e-29,  7.285744528855220e-01,
 -2.424393654618439e-03,  3.152287900507823e-06,  5.788991769918866e-09, -3.189945767228606e-11,  1.722396068743937e-14,  2.532449397940694e-16, -7.253596784937286e-19,
 -9.991067878489611e-22,  1.019618833893333e-23, -1.268695292897589e-26, -8.798997007250975e-29,  7.928230478051157e-01, -2.536431331094239e-03,  2.719561159467538e-06,
  8.022234063116866e-09, -3.162326711713908e-11, -1.211271065306764e-14,  3.186551861758356e-16, -4.846969937346104e-19, -2.475112075903830e-21,  1.041606633649802e-23,
  7.507865664951466e-27, -1.403367175945322e-28,  8.588210901277216e-01, -2.631418316213907e-03,  2.183799354374874e-06,  1.014806154666474e-08, -2.892761339768905e-11,
 -4.567637327011234e-14,  3.495859913515176e-16, -7.946045789638498e-20, -3.748698392916632e-21,  7.236972768948822e-24,  3.260713109038811e-26, -1.463595871746783e-28,
  9.263461159354243e-01, -2.706679492484793e-03,  1.551223854752926e-06,  1.203067745480779e-08, -2.361434743297480e-11, -8.010977703618132e-14,  3.317489052810468e-16,
  4.463797530395891e-19, -4.377893744359243e-21,  5.157506774395868e-25,  5.353859063848609e-26, -8.091785643101731e-29,  9.951499784601487e-01, -2.759615578402503e-03,
  8.327206773423272e-07,  1.352564913201054e-08, -1.570693640838399e-11, -1.110619971820321e-13,  2.561109738620715e-16,  1.003235289266690e-18, -3.959701352834983e-21,
 -8.539696505026085e-24,  5.898611872300914e-26,  5.279369573654000e-29,  1.064956624795327e+00, -2.787777117550126e-03,  4.429425076604518e-08,  1.448900655064383e-08,
 -5.508652164793319e-12, -1.335880736374154e-13,  1.227199093123696e-16,  1.463323297741474e-18, -2.290295261245568e-21, -1.725317662838697e-23,  4.019026856504068e-26,
  2.091682484875330e-28,  1.135459917358713e+00, -2.788954200267659e-03, -7.926500915366433e-07,  1.478917870660728e-08,  6.356982087537920e-12, -1.428126167830949e-13,
 -5.611201901164504e-17,  1.683587246291122e-18,  4.733939415987067e-22, -2.200746353122032e-23, -2.921115190610296e-27,  3.062768343428448e-28,  1.206321599889856e+00,
 -2.761282816932787e-03, -1.651286701225806e-06,  1.432154058036697e-08,  1.893787028813792e-11, -1.348358720477584e-13, -2.544912576475951e-16,  1.544250023162435e-18,
  3.721400922839232e-21, -1.953176524750196e-23, -5.731184148844233e-26,  2.617364156522781e-28,  1.277169540532808e+00, -2.703367766087096e-03, -2.499721343970580e-06,
  1.302482489297600e-08,  3.099288225399813e-11, -1.077852183309084e-13, -4.348363103729508e-16,  9.967972185880901e-19,  6.450995852968860e-21, -8.690107021303298e-24,
 -9.821938825722602e-26,  5.082164978664037e-29,  1.347596422391064e+00, -2.614420530483894e-03, -3.301831609941030e-06,  1.089795296436955e-08,  4.109327163742085e-11,
 -6.281869147701195e-14, -5.539998659136421e-16,  1.071237164286106e-19,  7.537326041859255e-21,  7.990098574485248e-24, -9.911952086595614e-26, -2.460380309360455e-28,
  1.417159093397317e+00, -2.494408376018818e-03, -4.018709644876974e-06,  8.014998738556047e-09,  4.779337076363808e-11, -4.790035955284728e-15, -5.736587953166784e-16,
 -9.272131282950889e-19,  6.192042355387725e-21,  2.416672230173536e-23, -4.829818026989725e-26, -4.547218804367809e-28,  1.485378829461378e+00, -2.344208053848621e-03,
 -4.610794983106122e-06,  4.535139652301089e-09,  4.986483874086936e-11,  5.777395336853485e-14, -4.733189660975387e-16, -1.807100358399979e-18,  2.460395022256277e-21,
  3.181426736124284e-23,  3.687437049833499e-26, -4.054159494858695e-28,  1.551742802661407e+00, -2.165753925614823e-03, -5.040727905929060e-06,  7.037961810122352e-10,
  4.656875204856877e-11,  1.136973730268896e-13, -2.621830547360571e-16, -2.219176874077648e-18, -2.513204971699324e-21,  2.543524718527404e-23,  1.110510522385342e-25,
 -7.684503010498656e-29,  1.615707072263331e+00, -1.962166288828453e-03, -5.276856636407994e-06, -3.158933865470492e-09,  3.791523979324430e-11,  1.513060691574972e-13,
  1.553167786204689e-17, -1.964253517115336e-18, -6.734483107640578e-21,  6.372067369473923e-24,  1.250117013506280e-25,  3.304908524051525e-28,  1.676701420489252e+00,
 -1.737841612385578e-03, -5.297191842089173e-06, -6.685550446870777e-09,  2.483749168208864e-11,  1.614650136722467e-13,  2.871304447283562e-16, -1.077207278279030e-18,
 -8.212522118927910e-21, -1.605951144601040e-23,  6.292046850227228e-26,  5.062414323310119e-28,  1.734136324912950e+00, -1.498483082359071e-03, -5.093427265712572e-06,
 -9.504870109392813e-09,  9.196628657512665e-12,  1.407726138927254e-13,  4.719620003266038e-16,  1.334503547521444e-19, -6.107498731593348e-21, -2.900682887919829e-23,
 -3.620783241966983e-26,  2.949413549154822e-28,  1.787412282079711e+00, -1.251048422030832e-03, -4.674460722319737e-06, -1.129912852330510e-08, -6.450480389662839e-12,
  9.374635907392090e-14,  5.116233425569179e-16,  1.182928654738439e-18, -1.470816788837762e-21, -2.465450715643817e-23, -1.006037783105767e-25, -1.205636873518258e-28,
  1.835931561356094e+00, -1.003593735892580e-03, -4.068700873191527e-06, -1.186647772923205e-08, -1.933649920701154e-11,  3.273656095244932e-14,  3.980028184395567e-16,
  1.634246789593363e-18,  3.129783240240558e-21, -6.863759970121777e-24, -8.453185705708392e-26, -3.605576123370027e-28,  1.879112269199018e+00, -7.649984409503547e-04,
 -3.324395931505572e-06, -1.117598829605986e-08, -2.715154771147792e-11, -2.517462736837023e-14,  1.833504336011748e-16,  1.343265611947197e-18,  5.161625714773398e-21,
  1.084400809972829e-23, -1.216894338665171e-26, -2.363889240164579e-28,  1.916404348516867e+00, -5.445679878683224e-04, -2.507339065310615e-06, -9.399319789982970e-09,
 -2.872443995090136e-11, -6.383685805920464e-14, -3.865306983943627e-17,  5.618054494895655e-19,  3.894149380816542e-21,  1.617214316976725e-23,  4.520867457864505e-26,
  4.778122474268004e-29,  1.947306849626325e+00, -3.515277331229335e-04, -1.695638181455282e-06, -6.904437426227857e-09, -2.448036166258925e-11, -7.431913045639347e-14,
 -1.771125429846130e-16, -2.086398662917496e-19,  9.142491022545951e-22,  8.585322319265989e-24,  4.321693706717229e-26,  1.632517541628078e-28,  1.971385542025486e+00,
 -1.944410089596771e-04, -9.717756214825705e-07, -4.203602792890689e-09, -1.645262654408014e-11, -5.892627766690116e-14, -1.917047076622789e-16, -5.492179384603769e-19,
 -1.262987946277016e-21, -1.463673211618602e-24,  6.492676957850577e-27,  6.295720930491187e-29,  1.988289863401759e+00, -8.060268069959929e-05, -4.128311070586609e-07,
 -1.859841892391338e-09, -7.750564861734939e-12, -3.049260922972708e-14, -1.142262278351362e-16, -4.082860589943484e-19, -1.388472796132063e-21, -4.453177937651917e-24,
 -1.321809948938092e-26, -3.480260799067346e-29,  1.997770370380683e+00, -1.545761192463865e-05, -8.025580323838460e-08, -3.696726815114736e-10, -1.592515468491332e-12,
 -6.566959512141935e-15, -2.623817812081317e-17, -1.022911666505061e-19, -3.907884360004057e-22, -1.466940396856257e-24, -5.419643916538983e-27, -1.972498288512129e-29,
  4.078264062698260e-04, -1.853528679319160e-06,  6.316947266133056e-09, -1.913291941560435e-11,  5.431230745316146e-14, -1.479655552548192e-16,  3.917452369183436e-19,
 -1.015612165504238e-21,  2.590368648477578e-24, -6.522438651836305e-27,  1.624635188095059e-29, -4.011492264345000e-32,  3.669855802222083e-03, -1.666153887637877e-05,
  5.665294490188099e-08, -1.709053203418686e-10,  4.821578650430163e-13, -1.302018742685086e-15,  3.406076951962859e-18, -8.692958601782811e-21,  2.173327653697860e-23,
 -5.337670695814036e-26,  1.289409656856922e-28, -3.067535186193663e-31,  1.019080115280383e-02, -4.616960058869329e-05,  1.562614418864126e-07, -4.675929393734705e-10,
  1.302677553801098e-12, -3.454296289102057e-15,  8.811957991243841e-18, -2.174393896466199e-20,  5.200050335720050e-23, -1.205269949795144e-25,  2.699690413076276e-28,
 -5.815836963673479e-31,  1.996438636668009e-02, -9.016120871559486e-05,  3.030199818717611e-07, -8.956159681367066e-10,  2.447018985416892e-12, -6.304671950661049e-15,
  1.543601127256619e-17, -3.595168440016999e-20,  7.924980246222189e-23, -1.632961612582035e-25,  3.056575587734533e-28, -4.849761131192197e-31,  3.298107356095795e-02,
 -1.483101430664682e-04,  4.937565590207770e-07, -1.434943821839340e-09,  3.815624714824349e-12, -9.431440185755712e-15,  2.169410580246834e-17, -4.592676252368828e-20,
  8.671356101485356e-23, -1.339588866940522e-25,  1.131009791304021e-28,  2.601075501012594e-31,  4.922791253063197e-02, -2.201787330274329e-04,  7.242645592770345e-07,
 -2.059509664922711e-09,  5.282681111720500e-12, -1.232450986721869e-14,  2.578973591206594e-17, -4.611810264300682e-20,  5.954029885040775e-23, -6.485667480792458e-29,
 -3.528492404379962e-28,  1.606096582492423e-30,  6.868833662560621e-02, -3.052155786706924e-04,  9.893242509103625e-07, -2.737775465432178e-09,  6.702015317989489e-12,
 -1.442795353688202e-14,  2.595717824989596e-17, -3.197828298635622e-20, -1.040224533009413e-23,  2.384664436101164e-25, -1.008234447348286e-27,  3.061857361440535e-30,
  9.134190206265748e-02, -4.027527623740522e-04,  1.282732216487415e-06, -3.433457589774211e-09,  7.914395321322866e-12, -1.519032177456450e-14,  2.073098435507314e-17,
 -1.135935143825170e-21, -1.203923485939362e-22,  5.383757178413789e-25, -1.626189289666381e-27,  3.759569909193318e-30,  1.171639669031402e-01, -5.120025989768575e-04,
  1.597340523733994e-06, -4.106424632008709e-09,  8.756157405760869e-12, -1.412058515909717e-14,  9.218761989932541e-18,  4.559548160960422e-20, -2.543647861174585e-22,
  8.126577082701190e-25, -1.876090182773647e-27,  2.739073127997478e-30,  1.461253050999410e-01, -6.320539904582878e-04,  1.925107872618627e-06, -4.713780147214934e-09,
  9.069040487590125e-12, -1.084693332180481e-14, -8.650100712207288e-18,  1.035553605120690e-19, -3.829602198057747e-22,  9.437001580074810e-25, -1.418718909902565e-27,
 -5.954608361298240e-31,  1.781916501587416e-01, -7.618684742655540e-04,  2.257165432632328e-06, -5.211142915050301e-09,  8.711044532718577e-12, -5.174942418093495e-15,
 -3.193072332677460e-17,  1.640989630185692e-19, -4.667665159848179e-22,  8.104634202808093e-25, -4.360105750136770e-29, -5.978065907670270e-30,  2.133231620728826e-01,
 -9.002760841386501e-04,  2.583900595924642e-06, -5.554135881099679e-09,  7.568046661281318e-12,  2.859165169976965e-15, -5.855732562441713e-17,  2.151392589793761e-19,
 -4.629871682599203e-22,  3.268111373131974e-25,  2.184101305836904e-27, -1.194540570208045e-29,  2.514738102879525e-01, -1.045971180221237e-03,  2.895062410921109e-06,
 -5.700091464391871e-09,  5.565800113507626e-12,  1.294526361557663e-14, -8.535966433038105e-17,  2.424683773501386e-19, -3.351727373116034e-22, -5.158316023335578e-25,
  4.816086942017822e-27, -1.589039348796969e-29,  2.925906645500836e-01, -1.197508453340368e-03,  3.179893010647939e-06, -5.609974780189744e-09,  2.681805105932836e-12,
  2.447194288562878e-14, -1.082319357961534e-16,  2.318739887649672e-19, -6.489390321847642e-23, -1.612161052075783e-24,  7.009798343731809e-27, -1.467900834247689e-29,
  3.366130846210543e-01, -1.353299368802000e-03,  3.427289880753108e-06, -5.250516634709331e-09, -1.043624546553593e-12,  3.652150448167713e-14, -1.224773571820618e-16,
  1.719441597427671e-19,  3.366144486711653e-22, -2.726474251015524e-24,  7.663836011489060e-27, -5.851765146321558e-30,  3.834717990500806e-01, -1.511609390386433e-03,
  3.626004276531878e-06, -4.596533847678205e-09, -5.497967680212115e-12,  4.789413595250137e-14, -1.233382404153875e-16,  5.729678600762107e-20,  8.196236983408823e-22,
 -3.509850198965530e-24,  5.722338155652293e-27,  1.081677094924721e-29,  4.330878625449734e-01, -1.670556418159920e-03,  3.764881423451247e-06, -3.633394328491827e-09,
 -1.048985681106406e-11,  5.716780464253816e-14, -1.067004968382644e-16, -1.082151722565218e-19,  1.293262331206992e-21, -3.561592396975030e-24,  6.194096132508355e-28,
  3.192497753942608e-29,  4.853714810818054e-01, -1.828110987048071e-03,  3.833148215146157e-06, -2.359557044694266e-09, -1.574649552084449e-11,  6.279926700718585e-14,
 -6.993202767014845e-17, -3.089637824583076e-19,  1.632478315319714e-21, -2.537042304017845e-24, -7.236348702191644e-27,  4.998912539208925e-29,  5.402206938688783e-01,
 -1.982098909465638e-03,  3.820753805465902e-06, -7.890812763199626e-10, -2.091663403999114e-11,  6.326916926603547e-14, -1.277618456597996e-17, -5.164759958377199e-19,
  1.697252910429202e-21, -2.897360186722640e-25, -1.611313670676837e-26,  5.473847293106254e-29,  5.975199018246102e-01, -2.130207206662391e-03,  3.718767568906146e-06,
  1.046045681526876e-09, -2.558074391392704e-11,  5.727007255960892e-14,  6.182392349548352e-17, -6.907149212853882e-19,  1.364713025716392e-21,  2.982940630325754e-24,
 -2.297134726522869e-26,  3.662897435688846e-29,  6.571382335917233e-01, -2.269994360482869e-03,  3.519837099271665e-06,  3.093968258821586e-09, -2.927004766111132e-11,
  4.392993669689083e-14,  1.471423559459853e-16, -7.845068689633393e-19,  5.713677555799392e-22,  6.641292382361851e-24, -2.405834197000963e-26, -7.808381870775667e-30,
  7.189277426246165e-01, -2.398906128170528e-03,  3.218705872315872e-06,  5.281679546159489e-09, -3.149586203413250e-11,  2.305484110285616e-14,  2.325417100873607e-16,
 -7.515632996031059e-19, -6.420648343620198e-22,  9.616424873627958e-24, -1.617355033773714e-26, -7.047112787350611e-29,  7.827214329848425e-01, -2.514298391847346e-03,
  2.812785473206330e-06,  7.514734511019893e-09, -3.179018815631120e-11, -4.636446123497788e-15,  3.040315360554160e-16, -5.578548619939623e-19, -2.096188336839163e-21,
  1.059598287015749e-23,  1.570009569262248e-27, -1.290837726082760e-28,  8.483311177091994e-01, -2.613468749206642e-03,  2.302770369646442e-06,  9.678366375541158e-09,
 -2.975748944385338e-11, -3.732631406848786e-14,  3.457225693166486e-16, -1.950112934013832e-19, -3.466259136538826e-21,  8.410680346476063e-24,  2.604364710864875e-26,
 -1.511160290115686e-28,  9.155451226537631e-01, -2.693698771167783e-03,  1.693273546637973e-06,  1.164046689721725e-08, -2.513599253519265e-11, -7.201361842454064e-14,
  3.422919372718208e-16,  3.069900994598470e-19, -4.321709587541436e-21,  2.578183814670810e-24,  4.939654586045729e-26, -1.065178079312886e-28,  9.841258613754682e-01,
 -2.752309020710237e-03,  9.934484073942824e-07,  1.325691148835754e-08, -1.786450952537314e-11, -1.045928327167684e-13,  2.823846683154583e-16,  8.720651823826798e-19,
 -4.224209277601437e-21, -6.145716162803160e-24,  6.041970434808314e-26,  1.256303236955275e-29,  1.053807323815997e+00, -2.786728991528612e-03,  2.175458866957203e-07,
  1.437966782558975e-08, -8.147687236691191e-12, -1.301599632755930e-13,  1.625758485930511e-16,  1.380423693039082e-18, -2.880345962202333e-21, -1.547161242941127e-23,
  4.862750847009347e-26,  1.734380079101283e-28,  1.124292544288142e+00, -2.794584008793800e-03, -6.146641262740553e-07,  1.486798328041957e-08,  3.491086982652837e-12,
 -1.435926403426450e-13, -8.878608323556866e-18,  1.686063318066980e-18, -3.177377645836837e-22, -2.185577209943875e-23,  1.046152570623936e-26,  3.002200990250531e-28,
  1.195251143471295e+00, -2.773800732526652e-03, -1.477700204626996e-06,  1.460265584373792e-08,  1.618364403714191e-11, -1.404120025893540e-13, -2.096937956042534e-16,
  1.651665377577421e-18,  2.979880525044219e-21, -2.158172357030161e-23, -4.490222281148726e-26,  3.006798569456608e-28,  1.266317075494332e+00, -2.722732082648687e-03,
 -2.340521076620805e-06,  1.350290825277668e-08,  2.873519714021943e-11, -1.178633551585871e-13, -4.040883473546000e-16,  1.197470981662128e-18,  6.068167249304494e-21,
 -1.255282234524504e-23, -9.438896144590504e-26,  1.231832393829297e-28,  1.337086754855819e+00, -2.640301004422079e-03, -3.167155016749424e-06,  1.154467341740404e-08,
  3.970432268078162e-11, -7.605120179940088e-14, -5.475860104007654e-16,  3.521351226131155e-19,  7.751155931177577e-21,  3.826709422771348e-24, -1.085840906156789e-25,
 -1.821108863516304e-28,  1.407117788015710e+00, -2.526160345624580e-03, -3.917947104106229e-06,  8.778169799869306e-09,  4.755790809077440e-11, -1.884621064703240e-14,
 -5.967188227014061e-16, -7.155597452264339e-19,  7.022448220836015e-21,  2.183494530389627e-23, -6.825001628507394e-26, -4.491149951853537e-28,  1.475928588455590e+00,
 -2.380863080052285e-03, -4.551550197840686e-06,  5.341586666876015e-09,  5.090267325761425e-11,  4.581707680991057e-14, -5.226415191781371e-16, -1.709794201124037e-18,
  3.627765174875282e-21,  3.291129466795884e-23,  1.746906776691866e-26, -4.750811401043819e-28,  1.542999206908287e+00, -2.206033129451730e-03, -5.027737876849841e-06,
  1.466724627842191e-09,  4.877469921739113e-11,  1.066511250678247e-13, -3.253022020188151e-16, -2.284099760476863e-18, -1.518658283101270e-21,  2.978051090838686e-23,
  1.054720833959922e-25, -1.784009347380952e-28,  1.607773752185581e+00, -2.004522227777834e-03, -5.311024104304255e-06, -2.528079939158725e-09,  4.094050902542802e-11,
  1.509947355078929e-13, -4.244294194522671e-17, -2.175093935847604e-18, -6.411699830240112e-21,  1.164942827710976e-23,  1.384718327977426e-25,  2.776699793476426e-28,
  1.669664800732574e+00, -1.780533049939719e-03, -5.374926297823152e-06, -6.261952555619200e-09,  2.813310448041985e-11,  1.679639904774651e-13,  2.532062365415080e-16,
 -1.348728120038703e-18, -8.739868429251190e-21, -1.308362531289268e-23,  8.618717868079927e-26,  5.491818525802114e-28,  1.728060179195790e+00, -1.539684014789543e-03,
 -5.206507924693835e-06, -9.334584133533249e-09,  1.212553621514403e-11,  1.521214822867671e-13,  4.728036281983363e-16, -7.895000946025111e-20, -7.174431920443685e-21,
 -3.016748449069131e-23, -2.111274110794549e-26,  3.926873324176066e-28,  1.782332436002674e+00, -1.288988073624752e-03, -4.810605446506295e-06, -1.138665848023122e-08,
 -4.450111792444342e-12,  1.064166167343753e-13,  5.439473958619593e-16,  1.120875389621129e-18, -2.431952903022667e-21, -2.876918783955256e-23, -1.047110220426937e-25,
 -6.295967358548790e-29,  1.831851177990976e+00, -1.036718140127390e-03, -4.212931579578730e-06, -1.217008911263517e-08, -1.858248340676660e-11,  4.284880038635232e-14,
  4.451218896966408e-16,  1.729762161125254e-18,  2.817918518075741e-21, -1.057135956545389e-23, -1.010599764332267e-25, -3.895879962091395e-28,  1.875998225250594e+00,
 -7.921374777088085e-04, -3.461130144661040e-06, -1.161418878259123e-08, -2.760789165112719e-11, -2.030385844475644e-14,  2.233321739781883e-16,  1.514568425637383e-18,
  5.540578292693130e-21,  1.013114950804840e-23, -2.393818789592836e-26, -3.001267217346597e-28,  1.914185233633552e+00, -5.650857781202798e-04, -2.622930729383761e-06,
 -9.869169521351667e-09, -3.000910457167499e-11, -6.456113333641745e-14, -2.108790425145483e-17,  6.960861659629844e-19,  4.509350816126562e-21,  1.801663626903917e-23,
  4.685439040603098e-26,  2.555992913861912e-29,  1.945873074194389e+00, -3.654310247045892e-04, -1.780891349314845e-06, -7.308247151455236e-09, -2.600970613530952e-11,
 -7.863633069278585e-14, -1.824959498996269e-16, -1.740906688200265e-19,  1.256228353135878e-21,  1.046431014611180e-23,  5.089984141051067e-26,  1.862272503712628e-28,
  1.970591903667916e+00, -2.024215531983748e-04, -1.023838022734810e-06, -4.476528316286016e-09, -1.767843065589198e-11, -6.371634159849813e-14, -2.076561597387009e-16,
 -5.904207881442346e-19, -1.310292117505495e-21, -1.143485491366347e-24,  9.649452002677122e-27,  8.119560009251029e-29,  1.987960702994696e+00, -8.399675745670719e-05,
 -4.359138824497579e-07, -1.988882677802185e-09, -8.388783923693164e-12, -3.337639538532761e-14, -1.263051190714065e-16, -4.553873190836648e-19, -1.558682589793198e-21,
 -5.013551965625195e-24, -1.482609344798962e-26, -3.830094417246457e-29,  1.997707227120036e+00, -1.611784601247417e-05, -8.484920464823238e-08, -3.962388569885295e-10,
 -1.730391333557402e-12, -7.232509045358378e-15, -2.928565151993834e-17, -1.156849533345684e-19, -4.477190543466021e-22, -1.702132163030442e-24, -6.367091596930855e-27,
 -2.345443445431484e-29,  4.005119291704580e-04, -1.803896930010523e-06,  6.092470186108312e-09, -1.828709565224959e-11,  5.144475930072189e-14, -1.388957610456093e-16,
  3.644341566042176e-19, -9.363552427404697e-22,  2.366845170250344e-24, -5.906540876311579e-27,  1.458079955956043e-29, -3.568406947837296e-32,  3.604103287605882e-03,
 -1.621638957621824e-05,  5.464752304495501e-08, -1.633947573411446e-10,  4.569156317722439e-13, -1.223116882976922e-15,  3.172128691196516e-18, -8.027269116992712e-21,
  1.990138994945123e-23, -4.847916311873936e-26,  1.161728651037195e-28, -2.742552485223519e-31,  1.000858788985442e-02, -4.494160436328688e-05,  1.507731404876853e-07,
 -4.472914987956654e-10,  1.235658137723115e-12, -3.249931162901544e-15,  8.225786207709488e-18, -2.014731130821323e-20,  4.784989236029117e-23, -1.102236062337480e-25,
  2.455968841432591e-28, -5.271376157193853e-31,  1.960852271189750e-02, -8.777938229193330e-05,  2.925034072720306e-07, -8.574526204965471e-10,  2.324550108962883e-12,
 -5.946006227337484e-15,  1.446400084575930e-17, -3.350743095001378e-20,  7.358613582667097e-23, -1.514895498530128e-25,  2.848500729121223e-28, -4.606756689661163e-31,
  3.239562548443414e-02, -1.444279442019724e-04,  4.768973988355176e-07, -1.375374999356202e-09,  3.632099936313744e-12, -8.925903906733460e-15,  2.044628548886400e-17,
 -4.322819488753173e-20,  8.197500167740153e-23, -1.292310117160326e-25,  1.227021318239524e-28,  1.789691710946020e-31,  4.835863131285995e-02, -2.144820546447989e-04,
  7.000495542537177e-07, -1.976925494070149e-09,  5.042276967474289e-12, -1.172083668630006e-14,  2.452508409958971e-17, -4.421544049330174e-20,  5.930029421841074e-23,
 -1.283631181766640e-26, -2.874176210965420e-28,  1.373430335466282e-30,  6.748309797293806e-02, -2.974305966496777e-04,  9.571049251562582e-07, -2.632818149760886e-09,
  6.419613281557027e-12, -1.381575591601047e-14,  2.505836270315985e-17, -3.218132444118924e-20, -2.511857772283217e-24,  2.007283670586580e-25, -8.811591080672421e-28,
  2.719981341815114e-30,  8.975115679475579e-02, -3.926535808046755e-04,  1.242280569268368e-06, -3.309230701334719e-09,  7.615559570269530e-12, -1.469357769537789e-14,
  2.064806843167990e-17, -4.690621623918223e-21, -1.021425910958365e-22,  4.765511489039590e-25, -1.467141653263923e-27,  3.470963754152793e-30,  1.151412052015082e-01,
 -4.994186228776068e-04,  1.548894739761627e-06, -3.968572968014172e-09,  8.476056975284185e-12, -1.388490805230479e-14,  1.038577626299820e-17,  3.790965226347586e-20,
 -2.264307542357455e-22,  7.400340334818715e-25, -1.754956822084536e-27,  2.758061413045270e-30,  1.436275360774664e-01, -6.168769387012202e-04,  1.869405945859416e-06,
 -4.570421327144975e-09,  8.850253635559493e-12, -1.102109492332455e-14, -5.917087820960634e-18,  9.183321179429439e-20, -3.500131766748189e-22,  8.866044836982690e-25,
 -1.431916067494038e-27, -2.552463312319100e-32,  1.751798981960790e-01, -7.440589243891007e-04,  2.195464431785690e-06, -5.072634298775710e-09,  8.600245878591854e-12,
 -5.887803419193201e-15, -2.754068280451834e-17,  1.496284323706764e-19, -4.376812801829106e-22,  8.038227045368719e-25, -2.797361083844071e-28, -4.783508804831273e-30,
  2.097629809427828e-01, -8.798694155249740e-04,  2.517979143057808e-06, -5.432664008694002e-09,  7.611655538312493e-12,  1.524413433351410e-15, -5.273896152461213e-17,
  2.005277743297782e-19, -4.497717847062932e-22,  4.041335600746479e-25,  1.693430366794689e-27, -1.037884727519235e-29,  2.473358155210034e-01, -1.023082752461523e-03,
  2.827203819728211e-06, -5.609076443112548e-09,  5.804762652872103e-12,  1.097687319902852e-14, -7.872324156428632e-17,  2.314815659144829e-19, -3.504401582213423e-22,
 -3.367936987972761e-25,  4.145235229792627e-27, -1.459673104233030e-29,  2.878510837445225e-01, -1.172337822302293e-03,  3.112846466906322e-06, -5.563289319526795e-09,
  3.145792755902842e-12,  2.195199970694213e-14, -1.017768830934875e-16,  2.289216313895855e-19, -1.180402784060665e-22, -1.344679563438877e-24,  6.365006659204074e-27,
 -1.457986782959437e-29,  3.312543244158143e-01, -1.326133303937047e-03,  3.364207084551563e-06, -5.261529239544510e-09, -3.421931398353659e-13,  3.364094975349692e-14,
 -1.175264544002121e-16,  1.812039965170890e-19,  2.439116134505880e-22, -2.425685152810689e-24,  7.361431896049128e-27, -7.800826219483665e-30,  3.774830262038345e-01,
 -1.482823413488991e-03,  3.570349156226972e-06, -4.676998504567375e-09, -4.569541362237763e-12,  4.495611851126735e-14, -1.213854143383258e-16,  8.154809929774585e-20,
  6.974919536351117e-22, -3.272738048373453e-24,  6.102265994389195e-27,  6.559679611160465e-30,  4.264655949224547e-01, -1.640614536954812e-03,  3.720310942687984e-06,
 -3.792225273762922e-09, -9.372330602882574e-12,  5.457519062141762e-14, -1.091703659739172e-16, -6.887482805287621e-20,  1.165813932807906e-21, -3.510427950292048e-24,
  1.897259573497562e-27,  2.622115810377918e-29,  4.781201822571520e-01, -1.797563248263582e-03,  3.803363011379661e-06, -2.601547117902965e-09, -1.450796445449955e-11,
  6.102290326927936e-14, -7.786576755455722e-17, -2.582374602001111e-19,  1.536451727040543e-21, -2.783936277288583e-24, -5.144361231136983e-27,  4.504819752302844e-29,
  5.323533624163646e-01, -1.951576348210698e-03,  3.809318523798209e-06, -1.113645820623092e-09, -1.965545664498205e-11,  6.279512819970736e-14, -2.647957082827088e-17,
 -4.624504837586697e-19,  1.675799662967337e-21, -8.863012405750750e-25, -1.372264465622031e-26,  5.371023738295500e-29,  5.890586430709189e-01, -2.100413726338771e-03,
  3.728902407310371e-06,  6.459911232956562e-10, -2.442204536055359e-11,  5.852679427667326e-14,  4.311019528322434e-17, -6.455000042959787e-19,  1.455964910214628e-21,
  2.098156027321771e-24, -2.122610400846024e-26,  4.236777656408072e-29,  6.481147975348305e-01, -2.241695046682060e-03,  3.554184388778519e-06,  2.632860731176865e-09,
 -2.835790243237029e-11,  4.720003926095337e-14,  1.254667521789022e-16, -7.625838756445348e-19,  7.930863077544231e-22,  5.676105874479247e-24, -2.410494549251707e-26,
  5.375310658918844e-30,  7.093840067677660e-01, -2.372911490470484e-03,  3.279078602924454e-06,  4.781730569978616e-09, -3.098067040543436e-11,  2.838131044208791e-14,
  2.112614129378808e-16, -7.667009304492282e-19, -3.082189517873189e-22,  8.912604833495564e-24, -1.889109479157572e-26, -5.313101030840825e-29,  7.727098028913354e-01,
 -2.491444052234892e-03,  2.899908638620985e-06,  7.005740683630247e-09, -3.181125240213171e-11,  2.465644318431005e-15,  2.875298761996140e-16, -6.188283613489526e-19,
 -1.714936127108899e-21,  1.054909009071402e-23, -3.814142924815218e-27, -1.152967378652182e-28,  8.379148110961312e-01, -2.594590172517730e-03,  2.416030866523653e-06,
  9.196723078061434e-09, -3.042154815929319e-11, -2.910674355389335e-14,  3.387562456032619e-16, -3.008990054922994e-19, -3.146328729200270e-21,  9.319175122180848e-24,
  1.938312895561024e-26, -1.508448130176510e-28,  9.047982948284552e-01, -2.679600783921013e-03,  1.830500018285460e-06,  1.122721782901536e-08, -2.649349893647434e-11,
 -6.371099139815056e-14,  3.489681510609648e-16,  1.705522117713012e-19, -4.194517655746392e-21,  4.453942401250457e-24,  4.424368862972761e-26, -1.267915657528393e-28,
  9.731335209259055e-01, -2.743730117394882e-03,  1.150748535880614e-06,  1.295472073712052e-08, -1.988669576422389e-11, -9.753804925743063e-14,  3.048801154197820e-16,
  7.338173848105982e-19, -4.401924351194506e-21, -3.729336748297953e-24,  6.012009024678828e-26, -2.574606913788576e-29,  1.042664978051086e+00, -2.784300812951687e-03,
  3.892345392150808e-07,  1.422870418237864e-08, -1.070879345938692e-11, -1.258052367486987e-13,  1.998563441767481e-16,  1.279730616027247e-18, -3.400578159768755e-21,
 -1.338548501701586e-23,  5.538489534580666e-26,  1.331058503803537e-28,  1.113105504646496e+00, -2.798786927287332e-03, -4.360079474166872e-07,  1.490087029335681e-08,
  6.209182910158554e-13, -1.432410820946764e-13,  3.807125894494718e-17,  1.663413151096442e-18, -1.093866332263436e-21, -2.117728468190357e-23,  2.334112836027138e-26,
  2.835232878005442e-28,  1.184133413070750e+00, -2.784917219855940e-03, -1.301008218933385e-06,  1.483887069561158e-08,  1.332887605006288e-11, -1.448796485056011e-13,
 -1.622312976050586e-16,  1.734270274834738e-18,  2.173881633149550e-21, -2.310411198910400e-23, -3.101261667961683e-26,  3.287482151833536e-28,  1.255389735841415e+00,
 -2.740800478209453e-03, -2.175807063258851e-06,  1.394329812808326e-08,  2.628377623390595e-11, -1.271376260759515e-13, -3.679136844021396e-16,  1.383705082545978e-18,
  5.549802580872007e-21, -1.619907843233697e-23, -8.741318437872726e-26,  1.932438513165932e-28,  1.326475768841274e+00, -2.665073420874549e-03, -3.024859817183126e-06,
  1.216706419376966e-08,  3.805282192818918e-11, -8.904682351121039e-14, -5.342390599997799e-16,  6.015236213079666e-19,  7.808999390119815e-21, -6.555053784523394e-25,
 -1.149785228641849e-25, -1.068992192288060e-28,  1.396951144838512e+00, -2.557069668289610e-03, -3.808058483863874e-06,  9.535296468106181e-09,  4.703628271685741e-11,
 -3.338179076473537e-14, -6.134942468366277e-16, -4.788296920580061e-19,  7.754654799065340e-21,  1.871559874386876e-23, -8.753665436105806e-26, -4.243007431047767e-28,
  1.466332736925571e+00, -2.417005174813541e-03, -4.482536513448878e-06,  6.162662619572908e-09,  5.168977547150246e-11,  3.271340604699682e-14, -5.687116828279199e-16,
 -1.574655934807899e-18,  4.819945685780461e-21,  3.317393622104547e-23, -4.759156606977891e-27, -5.329720054316949e-28,  1.534094760995131e+00, -2.246171203720768e-03,
 -5.005385854148401e-06,  2.263737970801377e-09,  5.082444477971224e-11,  9.807194254646034e-14, -3.897704751485152e-16, -2.314746256756370e-18, -3.728007851638605e-22,
  3.381056140380249e-23,  9.523074403526131e-26, -2.881281930828382e-28,  1.599670510777894e+00, -2.047120403582950e-03, -5.337331355032341e-06, -1.848949101338291e-09,
  4.394516628004753e-11,  1.492225149279345e-13, -1.061472129189032e-16, -2.372466559498668e-18, -5.889860726929268e-21,  1.741206457075390e-23,  1.491086030263222e-25,
  2.019553923243619e-28,  1.662456204945989e+00, -1.823825124456201e-03, -5.447257061147127e-06, -5.784631878326948e-09,  3.154992978430731e-11,  1.735557538978076e-13,
  2.114605999384405e-16, -1.635226864846637e-18, -9.142913349826016e-21, -9.143517844244589e-24,  1.110172822769896e-25,  5.764294903243634e-28,  1.721817434547539e+00,
 -1.581780604855079e-03, -5.317256488724115e-06, -9.115620812239530e-09,  1.528112132049135e-11,  1.634152909663680e-13,  4.672146586372285e-16, -3.260356765104332e-19,
 -8.271221119601514e-21, -3.063587647455076e-23, -1.539618534828601e-27,  4.979683167981020e-28,  1.777098647145271e+00, -1.328020520820391e-03, -4.947599997652274e-06,
 -1.144011380284837e-08, -2.188739552266998e-12,  1.198381884336365e-13,  5.740809044633409e-16,  1.025669309196254e-18, -3.543510942320586e-21, -3.299161330423292e-23,
 -1.058415367571836e-25,  1.516152535397155e-29,  1.827635966553467e+00, -1.071010742493180e-03, -4.360726361508796e-06, -1.245995595426305e-08, -1.761470398016353e-11,
  5.412273504147855e-14,  4.947546868983030e-16,  1.813032321270522e-18,  2.360392624663258e-21, -1.496332460333272e-23, -1.186860006031758e-25, -4.097997797831621e-28,
  1.872773403939450e+00, -8.203915381709216e-04, -3.603163184568182e-06, -1.205885765782051e-08, -2.795682911086769e-11, -1.441462681399237e-14,  2.682756255370611e-16,
  1.697490605386260e-18,  5.884693005701528e-21,  8.888661411443433e-24, -3.871894005555911e-26, -3.732636375298784e-28,  1.911882161919457e+00, -5.865512048462793e-04,
 -2.744284318272371e-06, -1.035966554655639e-08, -3.130372275084809e-11, -6.481643999128873e-14,  5.227927417846243e-19,  8.511263854081596e-19,  5.191878224843730e-21,
  1.990461814541813e-23,  4.730995801081467e-26, -6.711838963340763e-30,  1.944382290259927e+00, -3.800361470836553e-04, -1.871139922084145e-06, -7.737223808268757e-09,
 -2.762660160881674e-11, -8.306982289517861e-14, -1.867481690511433e-16, -1.274545230912086e-19,  1.671630380405950e-21,  1.267125264310777e-23,  5.962410279267246e-26,
  2.104930240880468e-28,  1.969765488912151e+00, -2.108320379089291e-04, -1.079296437362517e-06, -4.769854311576174e-09, -1.900395867841880e-11, -6.890324402707513e-14,
 -2.247805678195050e-16, -6.329269297973130e-19, -1.343592014416814e-21, -6.797306172252468e-25,  1.370343017578417e-26,  1.038842982342153e-28,  1.987617586898113e+00,
 -8.758186845818777e-05, -4.606083718682165e-07, -2.128612584583733e-09, -9.087687729939200e-12, -3.656653552417865e-14, -1.397822225750518e-16, -5.082707838288486e-19,
 -1.750260846414180e-21, -5.641338604070117e-24, -1.658886045147198e-26, -4.181630052272089e-29,  1.997641367355275e+00, -1.681614102834860e-05, -8.977508873960964e-08,
 -4.251216394526208e-10, -1.882341058108562e-12, -7.975912206695591e-15, -3.273498278916552e-17, -1.310436381034219e-19, -5.138402103266057e-22, -1.978717176352343e-24,
 -7.494851406368287e-27, -2.794572626611361e-29,  3.933924506344005e-04, -1.756021164216145e-06,  5.877873579350555e-09, -1.748573636566683e-11,  4.875222803597855e-14,
 -1.304555906620054e-16,  3.392453753372943e-19, -8.639088005000164e-22,  2.164340342851955e-24, -5.353524956176267e-27,  1.309845438965531e-29, -3.177576346348218e-32,
  3.540099844706043e-03, -1.578692989179674e-05,  5.272985579370719e-08, -1.562757446234907e-10,  4.331967643412086e-13, -1.149612574506350e-15,  2.956024869433709e-18,
 -7.417474857522356e-21,  1.823695637165422e-23, -4.406485266718009e-26,  1.047527191984682e-28, -2.454069809300198e-31,  9.831200316561668e-03, -4.375655800346039e-05,
  1.455221549578328e-07, -4.280304198887246e-10,  1.172588887956256e-12, -3.059112365103359e-15,  7.682514972001933e-18, -1.867775201308651e-20,  4.405321847394011e-23,
 -1.008487520428388e-25,  2.235046013201070e-28, -4.778701083673148e-31,  1.926202095171085e-02, -8.547988939886619e-05,  2.824332685081516e-07, -8.211926329597054e-10,
  2.209026703842960e-12, -5.609867577872456e-15,  1.355795495722136e-17, -3.123777275297105e-20,  6.833278549125498e-23, -1.404936423338029e-25,  2.651265623247517e-28,
 -4.357965978678611e-31,  3.182544091456227e-02, -1.406778084762494e-04,  4.607357745939273e-07, -1.318663289298149e-09,  3.458392438981997e-12, -8.449425571392277e-15,
  1.927192827111179e-17, -4.067847048032160e-20,  7.741274005377270e-23, -1.241859413222481e-25,  1.290687119850211e-28,  1.126604332211231e-31,  4.751175555381627e-02,
 -2.089751967451187e-04,  6.768028736146371e-07, -1.898092832830081e-09,  4.813647079425441e-12, -1.114687712951076e-14,  2.331353367425426e-17, -4.232732918167023e-20,
  5.864524569030807e-23, -2.318597908799971e-26, -2.315376117075671e-28,  1.171283934789520e-30,  6.630849160867276e-02, -2.898984071739795e-04,  9.261183768444644e-07,
 -2.532282488544023e-09,  6.149239163566788e-12, -1.322517077951100e-14,  2.415719947760814e-17, -3.215265842760053e-20,  4.107919139965452e-24,  1.677824270787045e-25,
 -7.683850626720401e-28,  2.411406776927337e-30,  8.820017035426107e-02, -3.828721300515451e-04,  1.203291283889686e-06, -3.189705846661045e-09,  7.326631071431834e-12,
 -1.419995399513366e-14,  2.047347119438096e-17, -7.695723677783935e-21, -8.600704424524275e-23,  4.208367519916355e-25, -1.320618698337065e-27,  3.190849886604243e-30,
  1.131680146413819e-01, -4.872156719898200e-04,  1.502076446396612e-06, -3.835163752165990e-09,  8.200933250809692e-12, -1.362370641445654e-14,  1.134971539345724e-17,
  3.107681657069996e-20, -2.010238952407355e-22,  6.722574302614015e-25, -1.634084533578362e-27,  2.729243497626051e-30,  1.411895948421276e-01, -6.021386808870036e-04,
  1.815403217701029e-06, -4.430587508190740e-09,  8.628613496404548e-12, -1.113348562261485e-14, -3.497844273379470e-18,  8.113242632105749e-20, -3.191253686646004e-22,
  8.294462205087539e-25, -1.422711187869851e-27,  4.259115159750063e-31,  1.722384076996343e-01, -7.267363652901056e-04,  2.135414445346961e-06, -4.936006929985214e-09,
  8.476211337383156e-12, -6.500060657424973e-15, -2.354283531031808e-17,  1.360830810998681e-19, -4.089929096502307e-22,  7.887386606240503e-25, -4.669561520990435e-28,
 -3.752153329990700e-30,  2.062833809898864e-01, -8.599842780029590e-04,  2.453518682374725e-06, -5.310700505596858e-09,  7.629932906548946e-12,  3.244432030264411e-16,
 -4.732340627095979e-17,  1.863800642512345e-19, -4.341098098835234e-22,  4.631697945241812e-25,  1.268845205694425e-27, -8.942193025613035e-30,  2.432882957326629e-01,
 -1.000732762648774e-03,  2.760459077801000e-06, -5.514544415287962e-09,  6.005924946570430e-12,  9.164015926353825e-15, -7.240035664594237e-17,  2.201042557393514e-19,
 -3.597314317422228e-22, -1.834434069374229e-25,  3.531837171207098e-27, -1.328496414974575e-29,  2.832111164396987e-01, -1.147701200283177e-03,  3.046403055525827e-06,
 -5.509574861435921e-09,  3.560923102911197e-12,  1.958580234359158e-14, -9.542689377829332e-17,  2.244176951915718e-19, -1.620197479670961e-22, -1.102818841205470e-24,
  5.730705108863253e-27, -1.421352109264078e-29,  3.260032185719673e-01, -1.299472243593482e-03,  3.301057594480160e-06, -5.261773292401422e-09,  3.028347000074736e-13,
  3.088200270179442e-14, -1.123561967562806e-16,  1.876681044919491e-19,  1.618002580168421e-22, -2.138546884342900e-24,  6.985132872818554e-27, -9.222859691652571e-30,
  3.716085010185894e-01, -1.454486291773688e-03,  3.513815658735069e-06, -4.743075653645280e-09, -3.699353961426007e-12,  4.207268369205915e-14, -1.188069644147918e-16,
  1.020303513706247e-19,  5.841263773056196e-22, -3.023985933200921e-24,  6.308966811575244e-27,  2.938119067316527e-30,  4.199623700498227e-01, -1.611036543473927e-03,
  3.673940052542888e-06, -3.933593472401888e-09, -8.307162593103199e-12,  5.193605928588733e-14, -1.105954579290678e-16, -3.357398089088420e-20,  1.041068076072281e-21,
 -3.413052121636003e-24,  2.933004755441813e-27,  2.093232416024767e-29,  4.709905799050849e-01, -1.767265072517205e-03,  3.770791621109082e-06, -2.824014781277129e-09,
 -1.330675154051290e-11,  5.907281894038228e-14, -8.442341386251413e-17, -2.107104798186820e-19,  1.432990044853002e-21, -2.951578080598553e-24, -3.275342744706505e-27,
  3.988669121736546e-29,  5.246079140606575e-01, -1.921160506101066e-03,  3.794109171280003e-06, -1.418124729712841e-09, -1.840692683687343e-11,  6.201026167325603e-14,
 -3.868295146476914e-17, -4.094367526735396e-19,  1.634577052916733e-21, -1.388506491452394e-24, -1.140344171404142e-26,  5.154173843245403e-29,  5.807166904390518e-01,
 -2.070558053006872e-03,  3.734348577656098e-06,  2.646528507019492e-10, -2.324259953796369e-11,  5.934987975737368e-14,  2.569867588322607e-17, -5.978607307390331e-19,
  1.516676670461888e-21,  1.287650839735936e-24, -1.927141926482413e-26,  4.617913073977085e-29,  6.392050736021879e-01, -2.213142834835008e-03,  3.583088021209625e-06,
  2.186842701334879e-09, -2.738550356862698e-11,  4.995806310328720e-14,  1.044991023866083e-16, -7.341210952116310e-19,  9.801592107577901e-22,  4.720086381338766e-24,
 -2.361429690155328e-26,  1.659633977743975e-29,  6.999451776375633e-01, -2.346457720428987e-03,  3.333504829454862e-06,  4.290849022745239e-09, -3.036408485646392e-11,
  3.319314946732142e-14,  1.897028750285285e-16, -7.715803903383565e-19, -1.484890573009666e-24,  8.115165732050669e-24, -2.085977294319559e-26, -3.651269492711714e-29,
  7.627909454493583e-01, -2.467917154079716e-03,  2.980926472089637e-06,  6.497524088914431e-09, -3.169436641246902e-11,  9.152583420160230e-15,  2.694912162723160e-16,
 -6.676691439124427e-19, -1.339097126740347e-21,  1.029953751748511e-23, -8.550160256742774e-27, -9.974902614122392e-29,  8.275757941142711e-01, -2.574828798926239e-03,
  2.523453286981774e-06,  8.705759901462245e-09, -3.092312143505321e-11, -2.108875782740539e-14,  3.289729454950228e-16, -3.960769647751844e-19, -2.798472683149212e-21,
  9.962855084244471e-24,  1.283568201457981e-26, -1.460755111094055e-28,  8.941100226641711e-01, -2.664425177427937e-03,  1.962642684906778e-06,  1.079358449467066e-08,
 -2.768365731062429e-11, -5.529345751345102e-14,  3.518909443480212e-16,  3.922347600702432e-20, -4.003708519746655e-21,  6.107388921583937e-24,  3.832193370418582e-26,
 -1.414415765141294e-28,  9.621779891630132e-01, -2.733907857335079e-03,  1.304232993029335e-06,  1.262133177882587e-08, -2.176270395320210e-11, -8.999038873024931e-14,
  3.234380499437127e-16,  5.912689799400051e-19, -4.493263917038083e-21, -1.357779051532077e-24,  5.820254312453479e-26, -6.077431261583289e-29,  1.031535079571339e+00,
 -2.780507061100243e-03,  5.588687907121246e-07,  1.403750721807894e-08, -1.317409562562089e-11, -1.205914211903305e-13,  2.340960112275642e-16,  1.163640354524673e-18,
 -3.841281020650754e-21, -1.106550398360178e-23,  6.030005347914280e-26,  9.000957245176521e-29,  1.101904513228210e+00, -2.801559797528415e-03, -2.572322309638099e-07,
  1.488795181337668e-08, -2.231017033791758e-12, -1.417731178840605e-13,  8.404358760929961e-17,  1.616415494624932e-18, -1.836500023834205e-21, -2.000124867242094e-23,
  3.526816837259431e-26,  2.571147021640342e-28,  1.172974060640315e+00, -2.794609615868713e-03, -1.121758458887608e-06,  1.502875706079588e-08,  1.039631822882752e-11,
 -1.481834004674877e-13, -1.128244116990390e-16,  1.790315746880379e-18,  1.323343119157063e-21, -2.404972299431042e-23, -1.615201449806585e-26,  3.446532498159999e-28,
  1.244392790540564e+00, -2.757530703517556e-03, -2.006049671257462e-06,  1.434303029499521e-08,  2.365596401289362e-11, -1.354831240470300e-13, -3.267760090507007e-16,
  1.551311073325348e-18,  4.905925747855632e-21, -1.950606104336961e-23, -7.746603360093386e-26,  2.577132167126238e-28,  1.315768016525749e+00, -2.688678069809902e-03,
 -2.875262986613548e-06,  1.276097143905935e-08,  3.614517806495663e-11, -1.016382654138097e-13, -5.139078891470803e-16,  8.501386293685080e-19,  7.701701725983782e-21,
 -5.324603547861666e-24, -1.178669495119091e-25, -2.328027117192480e-29,  1.386662679900607e+00, -2.587063704019554e-03, -3.689144077711354e-06,  1.028173186231238e-08,
  4.622046976651869e-11, -4.823790113073750e-14, -6.233311302958996e-16, -2.206121809621384e-19,  8.360994659724759e-21,  1.485244856419185e-23, -1.052956966365586e-25,
 -3.796641126647965e-28,  1.456593483912733e+00, -2.452555554663314e-03, -4.403603195133206e-06,  6.994176909002041e-09,  5.220407621825988e-11,  1.855377122145174e-14,
 -6.104637077565818e-16, -1.401392933106779e-18,  6.005003282318468e-21,  3.250098131990975e-23, -2.919201537339697e-26, -5.745657249067267e-28,  1.525030181759498e+00,
 -2.286091661224611e-03, -4.973278830945957e-06,  3.092090291403567e-09,  5.268708677139892e-11,  8.793949866123731e-14, -4.545623142309471e-16, -2.306492604480837e-18,
  9.095873538510793e-22,  3.733294388697990e-23,  8.006148252740849e-26, -4.015734928507183e-28,  1.591396508514464e+00, -2.089895625089563e-03, -5.355202032409481e-06,
 -1.122112215662324e-09,  4.689865303263362e-11,  1.458571560684415e-13, -1.751124003761968e-16, -2.549745867590076e-18, -5.153774094065444e-21,  2.352662379958606e-23,
  1.558965614103679e-25,  1.027272847077772e-28,  1.655073321168302e+00, -1.867671996178112e-03, -5.513528454395861e-06, -5.251804502277724e-09,  3.506791467385820e-11,
  1.780480390198724e-13,  1.615351367854612e-16, -1.932159852349847e-18, -9.386000063125738e-21, -4.192046883864031e-24,  1.366014571793447e-25,  5.825463774256415e-28,
  1.715404549437517e+00, -1.624751797767016e-03, -5.425067133022120e-06, -8.844370831640802e-09,  1.866066031393301e-11,  1.744879676504537e-13,  4.542145241378701e-16,
 -6.083281356941409e-19, -9.369649951837436e-21, -3.022728223950718e-23,  2.276364720276465e-26,  6.069437040718265e-28,  1.771706533419243e+00, -1.368150854536153e-03,
 -5.085009938067847e-06, -1.145520140453145e-08,  3.480588671729935e-13,  1.339468151092984e-13,  6.010277916754721e-16,  8.924596403101315e-19, -4.807002363919376e-21,
 -3.718394769978449e-23, -1.030403509455351e-25,  1.160786594418559e-28,  1.823281198354859e+00, -1.106499335926127e-03, -4.511898986177444e-06, -1.273246901330486e-08,
 -1.640935432044801e-11,  6.661403019105271e-14,  5.464893284618639e-16,  1.878994274661106e-18,  1.731882674335069e-21, -2.007456305604980e-23, -1.369270632011159e-25,
 -4.167365057153617e-28,  1.869433259941284e+00, -8.498032926281644e-04, -3.750561667429371e-06, -1.250810688584860e-08, -2.817677440205251e-11, -7.384091743211746e-15,
  3.184874863848570e-16,  1.890588218318032e-18,  6.172635770784268e-21,  6.987879785185951e-24, -5.691854756662185e-26, -4.554061446109808e-28,  1.909491249065932e+00,
 -6.090113564262116e-04, -2.871648215885894e-06, -1.087088661015344e-08, -3.259789584282498e-11, -6.449846553046889e-14,  2.679061389232872e-17,  1.029095492127972e-18,
  5.942327077687664e-21,  2.177890326037293e-23,  4.607749452028382e-26, -5.162938295512042e-29,  1.942831608626742e+00, -3.953842954925873e-04, -1.966694379486637e-06,
 -8.192785224339839e-09, -2.933307360469633e-11, -8.758812064681563e-14, -1.894960396871978e-16, -6.618485899443408e-20,  2.173023318597697e-21,  1.524874888821661e-23,
  6.943162882640783e-26,  2.353151958783826e-28,  1.968904522070552e+00, -2.197006381590879e-04, -1.138405511423402e-06, -5.085241396459359e-09, -2.043743156399693e-11,
 -7.451551813035317e-14, -2.431073215008091e-16, -6.761982065596148e-19, -1.357023597855367e-21, -3.233351959644156e-26,  1.887094143167473e-26,  1.319823065574009e-28,
  1.987259724351301e+00, -9.137143747811892e-05, -4.870488787594309e-07, -2.280053465016575e-09, -9.853752454127483e-12, -4.009860911494657e-14, -1.548293865000206e-16,
 -5.676602675436838e-19, -1.965745655032078e-21, -6.342700910203968e-24, -1.850383196225331e-26, -4.518696292548486e-29,  1.997572633341338e+00, -1.755527198077675e-05,
 -9.506265902030336e-08, -4.565592105805355e-10, -2.050022794767209e-12, -8.807508452122905e-15, -3.664554077354297e-17, -1.486866209917229e-19, -5.907803842297476e-22,
 -2.304624954115655e-24, -8.839989509903592e-27, -3.336573742584963e-29,  3.864611015018356e-04, -1.709824425779545e-06,  5.672640266998687e-09, -1.672613932148175e-11,
  4.622261547212185e-14, -1.225963232871156e-16,  3.159972855310765e-19, -7.976350913130646e-22,  1.980716970101432e-24, -4.856502532636551e-27,  1.177779580909670e-29,
 -2.832465483405471e-32,  3.477784089949823e-03, -1.537247617438261e-05,  5.089538729942422e-08, -1.495247491959517e-10,  4.108974706826291e-13, -1.081095741732768e-15,
  2.756272896465781e-18, -6.858485569492583e-21,  1.672351242474547e-23, -4.008293841167361e-26,  9.452961598321160e-29, -2.197777741491979e-31,  9.658470352939838e-03,
 -4.261261186541069e-05,  1.404963714101551e-07, -4.097486126489544e-10,  1.113208892358474e-12, -2.880851727960856e-15,  7.178740031546539e-18, -1.732445276397877e-20,
  4.057864237423749e-23, -9.231564975732798e-26,  2.034750838049972e-28, -4.332996049205811e-31,  1.892455875293840e-02, -8.325924805551388e-05,  2.727873774304197e-07,
 -7.867283979346916e-10,  2.100013671641752e-12, -5.294730060315828e-15,  1.271316443394209e-17, -2.913003824420945e-20,  6.346135129190518e-23, -1.302647248097695e-25,
  2.465011875999624e-28, -4.108313325479084e-31,  3.127000254593418e-02, -1.370542901163983e-04,  4.452383245341201e-07, -1.264656170046822e-09,  3.293938360858323e-12,
 -8.000291429574897e-15,  1.816694706598406e-17, -3.827178880903479e-20,  7.303601691306418e-23, -1.189407306957054e-25,  1.327999185521970e-28,  5.882065391637653e-32,
  4.668654118410685e-02, -2.036505896478979e-04,  6.544806101859048e-07, -1.822827978203518e-09,  4.596209878999099e-12, -1.060136307545392e-14,  2.215450386880209e-17,
 -4.046572634269376e-20,  5.765577380144592e-23, -3.147019070845286e-26, -1.839496823896397e-28,  9.959388906362214e-31,  6.516352575559778e-02, -2.826093570247395e-04,
  8.963126865333749e-07, -2.435979494020187e-09,  5.890460653318070e-12, -1.265618105696535e-14,  2.325963231308071e-17, -3.193029179758077e-20,  9.619652115469889e-24,
  1.390851728934499e-25, -6.684997945222156e-28,  2.133727704758538e-30,  8.668769486214044e-02, -3.733969342282806e-04,  1.165708884609650e-06, -3.074725123433733e-09,
  7.047526621512663e-12, -1.371147381017296e-14,  2.022166622415779e-17, -1.021547248783583e-20, -7.177466070351232e-23,  3.707399709283971e-25, -1.186177128782727e-27,
  2.922217229165673e-30,  1.112428968260991e-01, -4.753809382353691e-04,  1.456832828035167e-06, -3.706113530094993e-09,  7.931249872969695e-12, -1.334157642030165e-14,
  1.213335722534284e-17,  2.501889099323618e-20, -1.779703775482687e-22,  6.092788613546502e-25, -1.515320844814115e-27,  2.663908867463789e-30,  1.388097531364555e-01,
 -5.878257933116978e-04,  1.763057153684192e-06, -4.294314859167643e-09,  8.405282461509138e-12, -1.119130014821303e-14, -1.364693599144187e-18,  7.138723558700881e-20,
 -2.902841268791338e-22,  7.730225445429275e-25, -1.395920238874057e-27,  7.766018248358510e-31,  1.693652569746683e-01, -7.098876826037077e-04,  2.076991692467029e-06,
 -4.801456988911351e-09,  8.340860947769557e-12, -7.020817607957045e-15, -1.991149670030186e-17,  1.234457100064777e-19, -3.809718352188339e-22,  7.670287503656285e-25,
 -6.121071186892144e-28, -2.868767862756693e-30,  2.028822994936042e-01, -8.406089667255545e-04,  2.390522768885608e-06, -5.188629631604003e-09,  7.625478817040568e-12,
 -7.502488484852469e-16, -4.229667349512735e-17,  1.727643857623824e-19, -4.166133510211201e-22,  5.064480613234483e-25,  9.045708325247775e-28, -7.637447117148292e-30,
  2.393291152458168e-01, -9.789121412204778e-04,  2.694866861712684e-06, -5.417075711738657e-09,  6.172321630859596e-12,  7.499056452790902e-15, -6.639940207919180e-17,
  2.085133319523875e-19, -3.639298476134032e-22, -5.347688667608893e-26,  2.975939452688744e-27, -1.198779136855878e-29,  2.786686367654039e-01, -1.123593437888710e-03,
  2.980642535164008e-06, -5.449588674622263e-09,  3.930242496777786e-12,  1.737034024251783e-14, -8.922144323872915e-17,  2.186408663873320e-19, -1.977444523223895e-22,
 -8.859436880119487e-25,  5.117205941996894e-27, -1.364413896528843e-29,  3.208577468013227e-01, -1.273316219586966e-03,  3.237965299536764e-06, -5.252131533015404e-09,
  8.939376268944096e-13,  2.824902630379616e-14, -1.070401973628604e-16,  1.916670217311768e-19,  8.974113905033123e-23, -1.867573141084055e-24,  6.556511580927842e-27,
 -1.019093273937237e-29,  3.658464150907847e-01, -1.426604377410542e-03,  3.456570881784363e-06, -4.795687603860172e-09, -2.886172058548608e-12,  3.925761210181218e-14,
 -1.157044433402052e-16,  1.190294810757548e-19,  4.798279402878538e-22, -2.769973017008699e-24,  6.369682859555106e-27, -8.266259535107725e-32,  4.135767048766113e-01,
 -1.581836017083956e-03,  3.625973253195598e-06, -4.058342774225180e-09, -7.295041486282438e-12,  4.927413926092344e-14, -1.110874308988408e-16, -2.201363812443360e-21,
  9.205186362866600e-22, -3.278764507580722e-24,  3.746303187084257e-27,  1.611735460608523e-29,  4.639816326635071e-01, -1.737237822628388e-03,  3.735664621782524e-06,
 -3.027583157031304e-09, -1.214600831233896e-11,  5.698094097645480e-14, -8.969746254144685e-17, -1.665768520058770e-19,  1.324783979639500e-21, -3.049025119045185e-24,
 -1.634914906446114e-27,  3.468456463441739e-29,  5.169838630610870e-01, -1.890880615492998e-03,  3.775365362527394e-06, -1.702768151924186e-09, -1.717690377444648e-11,
  6.095016149404079e-14, -4.942300681097799e-17, -3.580137147057176e-19,  1.576919321929364e-21, -1.800129851310787e-24, -9.199977188882552e-27,  4.849049693053191e-29,
  5.724942191119027e-01, -2.040676792634183e-03,  3.735332386467788e-06, -9.770484253907415e-11, -2.205076170238033e-11,  5.977128868851336e-14,  9.643977887048163e-18,
 -5.487301453205848e-19,  1.549653232906600e-21,  5.581628725714000e-25, -1.718783370995654e-26,  4.826216160013842e-29,  6.304099874563883e-01, -2.184380534285497e-03,
  3.606734520070715e-06,  1.756797278042365e-09, -2.636290854876226e-11,  5.222307165809807e-14,  8.440707755426670e-17, -7.002179309770913e-19,  1.133282279414965e-21,
  3.792975361496716e-24, -2.267419962184214e-26,  2.580338673419480e-29,  6.906129973463349e-01, -2.319591928047044e-03,  3.382102754302025e-06,  3.810574599363661e-09,
 -2.965644202488504e-11,  3.748702620027096e-14,  1.681407132005083e-16, -7.671174713212252e-19,  2.752973369723328e-22,  7.253290640753905e-24, -2.212134427532325e-26,
 -2.105282634084033e-29,  7.529674533189659e-01, -2.443766465851235e-03,  3.055861263449371e-06,  5.992223617244403e-09, -3.144817470624845e-11,  1.539153363977141e-14,
  2.502517869165090e-16, -7.046620226217883e-19, -9.754837853080056e-22,  9.874578209106904e-24, -1.257706696349521e-26, -8.318257506003346e-29,  8.173175038956569e-01,
 -2.554231736531443e-03,  2.624941246411422e-06,  8.208040789536299e-09, -3.126689226687289e-11, -1.333627363465384e-14,  3.166836279910251e-16, -4.798028350451372e-19,
 -2.432096895377166e-21,  1.035001614661445e-23,  6.585184302262392e-27, -1.374630210296505e-28,  8.834845338122632e-01, -2.648213554911757e-03,  2.089473060845547e-06,
  1.034225800593536e-08, -2.870505759707679e-11, -4.684915974282184e-14,  3.512306312348074e-16, -8.509385896431323e-20, -3.757779108085162e-21,  7.512743165634812e-24,
  3.188025854075120e-26, -1.504409655351730e-28,  9.512641761490419e-01, -2.722874222939403e-03,  1.453541742016961e-06,  1.225915715274005e-08, -2.348362970149159e-11,
 -8.204548603749796e-14,  3.379764212238155e-16,  4.471459797322486e-19, -4.500968490312038e-21,  9.074731652602136e-25,  5.483683253618114e-26, -9.141130532720149e-29,
  1.020423054780185e+00, -2.775366075043820e-03,  7.259755922896606e-07,  1.380774314528591e-08, -1.552717515704087e-11, -1.145963750960280e-13,  2.649005207267401e-16,
  1.034818120153915e-18, -4.195386500337821e-21, -8.587238543397636e-24,  6.329263382840078e-26,  4.602223328732916e-29,  1.090695288666904e+00, -2.802903855232955e-03,
 -7.888416035602812e-08,  1.482969669519228e-08, -5.042680006727060e-12, -1.392202520090518e-13,  1.283742892378614e-16,  1.546420605002293e-18, -2.528512544805351e-21,
 -1.837393637305761e-23,  4.584422834438551e-26,  2.223757893823244e-28,  1.161778819921161e+00, -2.802859701512023e-03, -9.405135584682102e-07,  1.517125880496367e-08,
  7.409654118795115e-12, -1.502856587596807e-13, -6.223358671992650e-17,  1.818715183442827e-18,  4.495968150186342e-22, -2.439066310331815e-23, -8.725762386894226e-28,
  3.477307501683891e-28,  1.233331669811041e+00, -2.772884409639451e-03, -1.831753093233554e-06,  1.469943738256448e-08,  2.087148251579478e-11, -1.427874375784675e-13,
 -2.812511412038367e-16,  1.696490387940578e-18,  4.150822179883131e-21, -2.236076691145717e-23, -6.486263690588285e-26,  3.134992554926386e-28,  1.304968283543185e+00,
 -2.711057974387086e-03, -2.718730620938338e-06,  1.332237062151877e-08,  3.399114603694165e-11, -1.136587684914783e-13, -4.866889533431536e-16,  1.092615717098115e-18,
  7.425139606735264e-21, -1.003394398319178e-23, -1.169550668483263e-25,  6.521483434024985e-29,  1.376256197836236e+00, -2.616070840154745e-03, -3.561360604647405e-06,
  1.101272694034228e-08,  4.510577016259108e-11, -6.324127639503802e-14, -6.256881440592818e-16,  5.465011935471509e-20,  8.816000555945274e-21,  1.032398429612310e-23,
 -1.206613405210332e-25, -3.156845128348417e-28,  1.446713355677356e+00, -2.487434437258733e-03, -4.314651849500487e-06,  7.831601750372034e-09,  5.242557876954863e-11,
  3.454560123177305e-15, -6.468384687310576e-16, -1.190787573830765e-18,  7.147853521593403e-21,  3.081984791546818e-23, -5.501902051309094e-26, -5.957046821036094e-28,
  1.515806498055255e+00, -2.325715010942321e-03, -4.931059726940062e-06,  3.948539367752269e-09,  5.433157300973230e-11,  7.625957372053457e-14, -5.185303695190495e-16,
 -2.255300512381706e-18,  2.306656492860061e-21,  4.014881409862568e-23,  5.991788143637140e-26, -5.132548561668462e-28,  1.582951175800422e+00, -2.132778126204078e-03,
 -5.364069649366453e-06, -3.486495671576334e-10,  4.976789351878304e-11,  1.407799336009282e-13, -2.486782275196793e-16, -2.699904963212141e-18, -4.193790327250722e-21,
  2.981857716046731e-23,  1.578124573100541e-25, -1.924582759609318e-29,  1.647514031415674e+00, -1.912022500048859e-03, -5.573065446316729e-06, -4.662038545617692e-09,
  3.866308589253926e-11,  1.812416363130928e-13,  1.032148535561054e-16, -2.233821968948495e-18, -9.432415409673427e-21,  1.780732505820737e-24,  1.618888431400198e-25,
  5.620520540069669e-28,  1.708818076520314e+00, -1.668571519892962e-03, -5.529291096270024e-06, -8.517296309694776e-09,  2.225787212489501e-11,  1.851498394533898e-13,
  4.328217079894018e-16, -9.253379612558895e-19, -1.043471504542735e-20, -2.875069503634953e-23,  5.184853056763412e-26,  7.143158417906860e-28,  1.766151699655330e+00,
 -1.409380480304179e-03, -5.222347975204896e-06, -1.142740906462479e-08,  3.173170753158493e-12,  1.486527013864960e-13,  6.236562816422556e-16,  7.164341938924064e-19,
 -6.218266530910716e-21, -4.116834736076699e-23, -9.526758120892835e-26,  2.413092117590416e-28,  1.818782036797974e+00, -1.143210043700141e-03, -4.666217589592815e-06,
 -1.298362982375213e-08, -1.494162532749930e-11,  8.036667219819651e-14,  5.997606642343147e-16,  1.921758713390600e-18,  9.062063765251801e-22, -2.591648716950753e-23,
 -1.550848370265379e-25, -4.050631826071775e-28,  1.865973076336800e+00, -8.804158476153534e-04, -3.903367398460724e-06, -1.295968302049656e-08, -2.824361510593059e-11,
  9.173815582885428e-16,  3.742237483466588e-16,  2.091657432213635e-18,  6.378153427985054e-21,  4.284410305219115e-24, -7.891032989513577e-26, -5.453569965914692e-28,
  1.907008418434891e+00, -6.325153090987110e-04, -3.005270681312397e-06, -1.140272757018820e-08, -3.387898724718150e-11, -6.348749021350967e-14,  5.838782326414044e-17,
  1.232144912656176e-18,  6.758847114126186e-21,  2.355999111216727e-23,  4.253629283478353e-26, -1.121776049799173e-28,  1.941217970241571e+00, -4.115192175571538e-04,
 -2.067882387202388e-06, -8.676376086177736e-09, -3.113042234107401e-11, -9.214987915206336e-14, -1.902892341135956e-16,  1.269186473953375e-20,  2.774530249240224e-21,
  1.824031567908839e-23,  8.032338649987400e-26,  2.595459438013822e-28,  1.968007110551450e+00, -2.290576481744016e-04, -1.201440626540061e-06, -5.424486321981197e-09,
 -2.198764664601221e-11, -8.058219901642707e-14, -2.626478856118917e-16, -7.194839735999036e-19, -1.343113760550133e-21,  8.483264109300117e-25,  2.541415978548248e-26,
  1.666170329392225e-28,  1.986886268669381e+00, -9.538001358414193e-05, -5.153826147364003e-07, -2.444336714023201e-09, -1.069420879275159e-11, -4.401257256526367e-14,
 -1.716398959913757e-16, -6.343643183268152e-19, -2.207893220207711e-21, -7.123535643307141e-24, -2.055969176391241e-26, -4.817285583255362e-29,  1.997500855747111e+00,
 -1.833825940630820e-05, -1.007441434442594e-07, -4.908180173710611e-10, -2.235316489787991e-12, -9.739175571252492e-15, -4.108641211922990e-17, -1.689902819555488e-19,
 -6.804820737920686e-22, -2.689425348637888e-24, -1.044773954462740e-26, -3.992024057280781e-29,  3.797113123635293e-04, -1.665233769486044e-06,  5.476284366983055e-09,
 -1.600578829185937e-11,  4.384475566028176e-14, -1.152733899077447e-16,  2.945252151914251e-19, -7.369609509674517e-22,  1.814071010663160e-24, -4.409391204414611e-27,
  1.059998347781496e-29, -2.527405064433585e-32,  3.417097303215282e-03, -1.497238012007077e-05,  4.913983440974486e-08, -1.431198350254905e-10,  3.899218132624417e-13,
 -1.017190478836563e-15,  2.571515600633626e-18, -6.345709673860331e-21,  1.534632063285386e-23, -3.648825666989673e-26,  8.537040303388465e-29, -1.969901044258040e-31,
  9.490237128300810e-03, -4.150801035360245e-05,  1.356843846285180e-07, -3.923890078983799e-10,  1.057276209052318e-12, -2.714239266498405e-15,  6.711345960534477e-18,
 -1.607757575252109e-20,  3.739729758845094e-23, -8.454578960496826e-26,  1.853114966003640e-28, -3.929857457236443e-31,  1.859582736332562e-02, -8.111414873709669e-05,
  2.635447963983361e-07, -7.539590312759063e-10,  1.997105330795915e-12, -4.999176596461915e-15,  1.192526242057730e-17, -2.717243941582624e-20,  5.894501206805758e-23,
 -1.207589144723434e-25,  2.289690755769775e-28, -3.861566864701999e-31,  3.072881433382366e-02, -1.335522030733758e-04,  4.303734641368439e-07, -1.213209872849153e-09,
  3.138207147387378e-12, -7.576883842474488e-15,  1.712742074225485e-17, -3.600211667069383e-20,  6.885026640991860e-23, -1.135904374354974e-25,  1.343989825379892e-28,
  1.543948906162463e-32,  4.588227372428547e-02, -1.985010062685537e-04,  6.330410062332457e-07, -1.750956330255309e-09,  4.389408995001862e-12, -1.008304407890141e-14,
  2.104711335924441e-17, -3.864020559028883e-20,  5.640053967320471e-23, -3.799804798092790e-26, -1.435488621430051e-28,  8.440824097803139e-31,  6.404724643286210e-02,
 -2.755541993847338e-04,  8.676381611681020e-07, -2.343727085268764e-09,  5.642847124779299e-12, -1.210863922835275e-14,  2.237061072283380e-17, -3.154733159919813e-20,
  1.416733503755427e-23,  1.141475275038587e-25, -5.801972481271184e-28,  1.884521803619995e-30,  8.521252746725931e-02, -3.642169537007107e-04,  1.129479781251086e-06,
 -2.964132266012302e-09,  6.778125886346181e-12, -1.322983374567955e-14,  1.990542053817732e-17, -1.230762577266443e-20, -5.925177702760140e-23,  3.257883137463717e-25,
 -1.063264006665072e-27,  2.667096225101436e-30,  1.093644037527722e-01, -4.639020319358329e-04,  1.413112112096174e-06, -3.581332135599611e-09,  7.667383851730478e-12,
 -1.304259318594403e-14,  1.275737077854579e-17,  1.966331303108581e-20, -1.570993508585619e-22,  5.509847300766363e-25, -1.400060363062848e-27,  2.571401964622292e-30,
  1.364863357149289e-01, -5.739251939776742e-04,  1.712324892280097e-06, -4.161622066320367e-09,  8.181285521220832e-12, -1.120109102055063e-14,  5.082088875002196e-19,
  6.253269997775580e-20, -2.634513687646207e-22,  7.179530194951916e-25, -1.355622495136250e-27,  1.042293512098998e-30,  1.665585763892171e-01, -6.934999611198594e-04,
  2.020170216557412e-06, -4.669151358412303e-09,  8.195938799307462e-12, -7.458568024714728e-15, -1.662157609430743e-17,  1.116914614219029e-19, -3.538278267821015e-22,
  7.402499813721374e-25, -7.213670744072118e-28, -2.118295180551876e-30,  1.995577205813909e-01, -8.217317661572078e-04,  2.328990589876585e-06, -5.066795547377523e-09,
  7.600706754734818e-12, -1.708809572350628e-15, -3.764312649207683e-17,  1.597308200202928e-19, -3.978076680767326e-22,  5.362649640963836e-25,  5.948278684021519e-28,
 -6.462974773320824e-30,  2.354561752374711e-01, -9.576115362436672e-04,  2.630459170321388e-06, -5.317203340076584e-09,  6.306833005894022e-12,  5.974214329493922e-15,
 -6.072420084274124e-17,  1.968587391122229e-19, -3.638360485718029e-22,  5.538518052358531e-26,  2.476326150447336e-27, -1.073010618141621e-29,  2.742215406687560e-01,
 -1.100008783180507e-03,  2.915635867556937e-06, -5.384039816764189e-09,  4.256728217281998e-12,  1.530174580545637e-14, -8.319260831373056e-17,  2.118410828208806e-19,
 -2.260968961783232e-22, -6.930602273616527e-25,  4.532196062704424e-27, -1.292694475688984e-29,  3.158158906045227e-01, -1.247664314312467e-03,  3.175043736370324e-06,
 -5.233446437463594e-09,  1.433664626391746e-12,  2.574472585509588e-14, -1.016430683007070e-16,  1.935127429258980e-19,  2.711928541534263e-23, -1.614478138598152e-24,
  6.093994102540099e-27, -1.077472739692163e-29,  3.601949372121476e-01, -1.399182729702981e-03,  3.398770982477638e-06, -4.835734854241184e-09, -2.128510341624983e-12,
  3.652234404178091e-14, -1.121712957301443e-16,  1.328375910555714e-19,  3.846871797530761e-22, -2.516022568315755e-24,  6.309894437515784e-27, -2.547340976547743e-30,
  4.073070652425398e-01, -1.553024941807145e-03,  3.576604867704689e-06, -4.167324396191906e-09, -6.336207933465652e-12,  4.661052185857048e-14, -1.107542075678990e-16,
  2.539689392189232e-20,  8.053394076119492e-22, -3.116034607956214e-24,  4.358811068865565e-27,  1.180895719387265e-29,  4.570922173597783e-01, -1.707501047516340e-03,
  3.698204831510758e-06, -3.212920805892874e-09, -1.102827035435551e-11,  5.477692067027209e-14, -9.378468564103077e-17, -1.259497302845337e-19,  1.214195944798279e-21,
 -3.085411343552198e-24, -2.215297570814578e-28,  2.958796327237647e-29,  5.094806105602014e-01, -1.860764005372871e-03,  3.753323171218345e-06, -1.967914340570639e-09,
 -1.597054483485430e-11,  5.964935654611414e-14, -5.875115576813352e-17, -3.086560837021879e-19,  1.505995382284619e-21, -2.126505871523552e-24, -7.145763614635646e-27,
  4.479508656881923e-29,  5.643912614863423e-01, -2.010804730273528e-03,  3.732082530990133e-06, -4.409461707445561e-10, -2.085423687212393e-11,  5.982398830101606e-14,
 -5.024122624650885e-18, -4.989482582542833e-19,  1.557886283104325e-21, -8.660833654695381e-26, -1.504654473287344e-26,  4.884009379367890e-29,  6.217302965703195e-01,
 -2.155449422505335e-03,  3.625320053916147e-06,  1.343449908763522e-09, -2.529975581968168e-11,  5.401778621215295e-14,  6.532797908920213e-17, -6.619408298624523e-19,
  1.253798484701221e-21,  2.910981621447268e-24, -2.137289945250049e-26,  3.302521280462443e-29,  6.813890215706856e-01, -2.292360206615495e-03,  3.425008062819141e-06,
  3.342281424628607e-09, -2.886808140590144e-11,  4.126588244955073e-14,  1.468227852241820e-16, -7.543023944413616e-19,  5.203039033664353e-22,  6.354139991331977e-24,
 -2.273439057094731e-26, -7.079573249864744e-30,  7.432417246021463e-01, -2.419040477431816e-03,  3.124760119086926e-06,  5.491835027984523e-09, -3.108189862724294e-11,
  2.115760756162415e-14,  2.301369425197876e-16, -7.302937032452048e-19, -6.298912656696931e-22,  9.303267282987518e-24, -1.586529429904621e-26, -6.627885663243526e-29,
  8.071431877907125e-01, -2.532846742808447e-03,  2.720428637107421e-06,  7.706044943414855e-09, -3.145874584605211e-11, -5.905528966768555e-15,  3.022158783457160e-16,
 -5.516291288331417e-19, -2.056183410057248e-21,  1.049570648135353e-23,  7.847964755799831e-28, -1.257411160922400e-28,  8.729258860603126e-01, -2.631009218056474e-03,
  2.210795031745402e-06,  9.875938172291061e-09, -2.955800756720825e-11, -3.846154587833185e-14,  3.472068563400317e-16, -2.007823754474219e-19, -3.465975566768236e-21,
  8.654133579015177e-24,  2.516334230679602e-26, -1.540065558677935e-28,  9.403968584425985e-01, -2.710663958833070e-03,  1.598344487917530e-06,  1.187073648555175e-08,
 -2.504249488560129e-11, -7.380004126311788e-14,  3.484879563043869e-16,  3.040526863300751e-19, -4.429858736614172e-21,  3.012621971936629e-24,  5.023539770923249e-26,
 -1.168323025164875e-28,  1.009334249288764e+00, -2.768899893920635e-03,  8.901034128032735e-07,  1.354132792808439e-08, -1.775325911811733e-11, -1.079065023205573e-13,
  2.919529235926630e-16,  8.961113143742659e-19, -4.458585139481880e-21, -6.027836433552965e-24,  6.436356142848092e-26,  2.948715117868373e-30,  1.079483535942427e+00,
 -2.802824685138196e-03,  9.849679940498808e-08,  1.472692052456621e-08, -7.792817734420437e-12, -1.356294129215447e-13,  1.704444835250141e-16,  1.455297177201697e-18,
 -3.154714568578208e-21, -1.635622759064021e-23,  5.473997532675016e-26,  1.810480798847325e-28,  1.150553488457422e+00, -2.809653803006612e-03, -7.578465300665333e-07,
  1.526570374589636e-08,  4.393134689507055e-12, -1.511673616297574e-13, -1.124001963409591e-17,  1.819076351224913e-18, -4.254241220370146e-22, -2.412151631180620e-23,
  1.425880485675085e-26,  3.379776633541894e-28,  1.222211949005834e+00, -2.786827403686130e-03, -1.653451565276860e-06,  1.501018477224484e-08,  1.795215548174367e-11,
 -1.489531958511967e-13, -2.320142680260535e-16,  1.815963990935397e-18,  3.302586653897173e-21, -2.466541623720053e-23, -5.004615632534156e-26,  3.579054285778882e-28,
  1.294081577275568e+00, -2.732159276804007e-03, -2.555676064447919e-06,  1.384741979291746e-08,  3.160378059838314e-11, -1.249457010674551e-13, -4.528299513594875e-16,
  1.323544932148467e-18,  6.980641818049091e-21, -1.462837349696816e-23, -1.121149775782907e-25,  1.545884542680475e-28,  1.365735786860399e+00, -2.644020946751947e-03,
 -3.424922106765686e-06,  1.172348585924943e-08,  4.369106951391287e-11, -7.820724128896120e-14, -6.201592910572715e-16,  3.417514205818825e-19,  9.097646048513615e-21,
  5.242563423615550e-24, -1.328145460162467e-25, -2.340146261592031e-28,  1.436695198831838e+00, -2.521561475696726e-03, -4.215640254997178e-06,  8.670109404624442e-09,
  5.233686590339120e-11, -1.244281237861898e-14, -6.768148111107719e-16, -9.447801399570154e-19,  8.211425015838527e-21,  2.809384825482042e-23, -8.126112224206481e-26,
 -5.929419640418805e-28,  1.506425062155332e+00, -2.364959069264693e-03, -4.878413340737725e-06,  4.829348600959246e-09,  5.572725100454263e-11,  6.306675566903635e-14,
 -5.804250836380988e-16, -2.157945282624262e-18,  3.789425708855590e-21,  4.206255543638410e-23,  3.501372438751812e-26, -6.168705693043250e-28,  1.574334231074032e+00,
 -2.175693669961170e-03, -5.363383932913323e-06,  4.698112793136219e-10,  5.251761202563057e-11,  1.338903586845750e-13, -3.259843417660402e-16, -2.815716496260286e-18,
 -3.007267200357546e-21,  3.607361235866326e-23,  1.539024397080544e-25, -1.615390795625247e-28,  1.639776433264211e+00, -1.956820008856564e-03, -5.625178256739759e-06,
 -4.014317795771608e-09,  4.230744802036273e-11,  1.829342261043730e-13,  3.646094066960750e-17, -2.533336131998978e-18, -9.245902305523481e-21,  8.737984816595483e-24,
  1.855939995475001e-25,  5.098412010516498e-28,  1.702054683391307e+00, -1.713208339696683e-03, -5.629237894859912e-06, -8.130991482029919e-09,  2.606244845221633e-11,
  1.951879744638010e-13,  4.020851127025024e-16, -1.275345684896742e-18, -1.142455996279707e-20, -2.601815766125412e-23,  8.549998762337167e-26,  8.132660231286789e-28,
  1.760429753206514e+00, -1.451706685370597e-03, -5.359071496857772e-06, -1.135203425443467e-08,  6.297405049137222e-12,  1.638372936248641e-13,  6.407027415716896e-16,
  4.930244994728514e-19, -7.765978437451104e-21, -4.472435284296870e-23, -8.144092078477234e-26,  3.911890476425770e-28,  1.814133544815855e+00, -1.181166935440969e-03,
 -4.823399918010832e-06, -1.320903673090459e-08, -1.318597765708745e-11,  9.540901016451459e-14,  6.538268931813639e-16,  1.934597788075282e-18, -1.426677515495921e-22,
 -3.246763204004913e-23, -1.722077907554617e-25, -3.686225677239004e-28,  1.862387963292460e+00, -9.122725291859373e-04, -4.061592740153314e-06, -1.341092576425646e-08,
 -2.813059017955760e-11,  1.062473136266061e-14,  4.356661332024528e-16,  2.297568381126572e-18,  6.469541216341534e-21,  6.202791508629237e-25, -1.049919646679315e-25,
 -6.408228381413054e-28,  1.904429393124236e+00, -6.571141165033767e-04, -3.145397416912585e-06, -1.195486104698283e-08, -3.513179979231822e-11, -6.164694659596122e-14,
  9.604563000689457e-17,  1.462316017620072e-18,  7.636246505561441e-21,  2.514081833666829e-23,  3.592634952572606e-26, -1.916930324776571e-28,  1.939538135707785e+00,
 -4.284873518603723e-04, -2.175049042701169e-06, -9.189454652141674e-09, -3.301900604745715e-11, -9.670189412649717e-14, -1.885876033895536e-16,  1.126260934470210e-19,
  3.491828017333739e-21,  2.168834622883274e-23,  9.223818521841810e-26,  2.814815960622226e-28,  1.967071236040179e+00, -2.389356539145194e-04, -1.268699589082498e-06,
 -5.789531249434743e-09, -2.366398286217584e-11, -8.713231598447278e-14, -2.833890754205167e-16, -7.617637410325979e-19, -1.292401854619973e-21,  2.023401558832733e-24,
  3.364882350717989e-26,  2.090974844140610e-28,  1.986496312526972e+00, -9.962337987291808e-05, -5.457710895071918e-07, -2.622716070618211e-09, -1.161713484500684e-11,
 -4.835330295732427e-14, -1.904309414829910e-16, -7.092829696245763e-19, -2.479661073818863e-21, -7.989046351190645e-24, -2.273231120602691e-26, -5.042606059482849e-29,
  1.997425852622694e+00, -1.916839498458328e-05, -1.068551559455166e-07, -5.281965802120955e-10, -2.440357117341784e-12, -1.078458325221084e-14, -4.613814673829438e-17,
 -1.923990408200398e-19, -7.852671631920291e-22, -3.144692129956608e-24, -1.237341638858041e-26, -4.786346302526768e-29,  3.731367980040262e-04, -1.622180019369343e-06,
  5.288349148771526e-09, -1.532233878250164e-11,  4.160833577576730e-14, -1.084459877431519e-16,  2.746797198201876e-19, -6.813707818165765e-22,  1.662704404914118e-24,
 -4.006814569004373e-27,  9.548503524118280e-30, -2.257471244490420e-32,  3.357983290696702e-03, -1.458602666278040e-05,  4.745916823718332e-08, -1.370405426616639e-10,
  3.701810570863078e-13, -9.575519611717324e-16,  2.400518009383253e-18, -5.875002172832184e-21,  1.409217741632065e-23, -3.324065180641549e-26,  7.715749135549657e-29,
 -1.767130174893382e-31,  9.326346616101292e-03, -4.044108643935986e-05,  1.310754515881851e-07, -3.758982659021735e-10,  1.004566369941236e-12, -2.558436562279197e-15,
  6.277480273888626e-18, -1.492816315820807e-20,  3.448300683807476e-23, -7.746815929820333e-26,  1.688355178187152e-28, -3.565269774203354e-31,  1.827553094122904e-02,
 -7.904144468574776e-05,  2.546857603528471e-07, -7.227899185941349e-10,  1.899923319501092e-12, -4.721891047390359e-15,  1.119020034717054e-17, -2.535402132885070e-20,
  5.475851920169789e-23, -1.119328261350631e-25,  2.125108962107979e-28, -3.620563348073761e-31,  3.020140048307421e-02, -1.301666072152772e-04,  4.161112842258830e-07,
 -1.164188864058156e-09,  2.990699669490395e-12, -7.177677234654820e-15,  1.614959904515427e-17, -3.386329800506467e-20,  6.485784247587323e-23, -1.082116672221960e-25,
  1.342874552470998e-28, -1.919310876848163e-32,  4.509826694817893e-02, -1.935195453530207e-04,  6.124443466313045e-07, -1.682311992154209e-09,  4.192712833154775e-12,
 -9.590693824840373e-15,  1.999024190692824e-17, -3.685831317284994e-20,  5.493783825026650e-23, -4.303725711379371e-26, -1.093676714752589e-28,  7.127718461981882e-31,
  6.295873586546788e-02, -2.687240763581589e-04,  8.400472514421371e-07, -2.255350041634290e-09,  5.405972017738926e-12, -1.158228960453389e-14,  2.149421915583256e-17,
 -3.103254890990620e-20,  1.787826976026024e-23,  9.253053277543916e-26, -5.022772427521825e-28,  1.661406719630434e-30,  8.377350863140372e-02, -3.553215700905350e-04,
  1.094552246205124e-06, -2.857773189449022e-09,  6.518277536305551e-12, -1.275644272029190e-14,  1.953596817295637e-17, -1.402401174707701e-20, -4.826132202179066e-23,
  2.855329556919394e-25, -9.512544478703223e-28,  2.426756320224551e-30,  1.075311361558554e-01, -4.527669731689372e-04,  1.370863641581760e-06, -3.460723996064726e-09,
  7.409635493904747e-12, -1.273035953835978e-14,  1.324046917685191e-17,  1.494291196900477e-20, -1.382449640753794e-22,  4.972133666976249e-25, -1.289324335972428e-27,
  2.459391366206579e-30,  1.342177189731932e-01, -5.604241444074209e-04,  1.663163441906892e-06, -4.032512431365328e-09,  7.957522671715259e-12, -1.116881215008880e-14,
  2.144909760326953e-18,  5.450542521845364e-20, -2.385694827506997e-22,  6.647073281794847e-25, -1.305246549771906e-27,  1.236836175875379e-30,  1.638165475448219e-01,
 -6.775605008299052e-04,  1.964922220367354e-06, -4.539230342445118e-09,  8.043025068202315e-12, -7.821212541084966e-15, -1.364876450985218e-17,  1.007896154709778e-19,
 -3.277188916788107e-22,  7.097253551118388e-25, -8.002621216067422e-28, -1.486206526785304e-30,  1.963076752045928e-01, -8.033409831410898e-04,  2.268917428430745e-06,
 -4.945505240482703e-09,  7.557851124451416e-12, -2.559995536083466e-15, -3.334594948863706e-17,  1.473139182834426e-19, -3.781394791871215e-22,  5.546882259024048e-25,
  3.339712732678558e-28, -5.414446292394222e-30,  2.316674147649271e-01, -9.368213646072835e-04,  2.567261877755242e-06, -5.215415471591856e-09,  6.412183170768519e-12,
  4.581664917808539e-15, -5.537472389865504e-17,  1.852661026913069e-19, -3.601697426641107e-22,  1.453536028603742e-25,  2.030835912980376e-27, -9.530177095292219e-30,
  2.698677481872614e-01, -1.076940949757384e-03,  2.851445788885662e-06, -5.313590367385075e-09,  4.543273044311022e-12,  1.337546241305392e-14, -7.736585716953944e-17,
  2.042406694011408e-19, -2.479188325515379e-22, -5.229131680226856e-25,  3.981121036740147e-27, -1.210868846972866e-29,  3.108756369061716e-01, -1.222514741613710e-03,
  3.112396578140071e-06, -5.206519346531427e-09,  1.924603978965734e-12,  2.337035851574678e-14, -9.622096960381290e-17,  1.934967326324609e-19, -2.672944602343346e-23,
 -1.380299046630422e-24,  5.613041467117440e-27, -1.103915291394367e-29,  3.546522183678599e-01, -1.372225201500952e-03,  3.340561461682774e-06, -4.864092427444830e-09,
 -1.424676455902562e-12,  3.387617544617814e-14, -1.082927741955526e-16,  1.437468076727873e-19,  2.986208478733622e-22, -2.266480040876165e-24,  6.152966575355418e-27,
 -4.506836703856154e-30,  4.011518720956638e-01, -1.524613787973990e-03,  3.526018994891301e-06, -4.261390170261491e-09, -5.430506291160478e-12,  4.396376391575919e-14,
 -1.096989210110949e-16,  4.940751562709104e-20,  6.964151600419241e-22, -2.932443579079024e-24,  4.793131969749959e-27,  8.018224192232292e-30,  4.503211361389453e-01,
 -1.678072546291735e-03,  3.658626821418235e-06, -3.380732240850592e-09, -9.955503664146969e-12,  5.248805700521659e-14, -9.678401442610789e-17, -8.887190815278192e-20,
  1.103262108243820e-21, -3.069689758252094e-24,  9.720790787750706e-28,  2.471105491360875e-29,  5.020974521341633e-01, -1.830836133724578e-03,  3.728214139442864e-06,
 -2.213978613744440e-09, -1.479233017632074e-11,  5.814099342863594e-14, -6.673072015064273e-17, -2.617404796028134e-19,  1.424760441991780e-21, -2.374106446279200e-24,
 -5.264331096952379e-27,  4.067001837948886e-29,  5.564077144856135e-01, -1.980974816927505e-03,  3.724828620077034e-06, -7.650533227406916e-10, -1.966006542341939e-11,
  5.954138913013559e-14, -1.829801336628690e-17, -4.492577450520499e-19,  1.544451833805125e-21, -6.456106138317075e-25, -1.290864402498038e-26,  4.814704867443517e-29,
  6.131665964971588e-01, -2.126389175382425e-03,  3.639048586927444e-06,  9.473756302004387e-10, -2.420519884162234e-11,  5.536787033090937e-14,  4.736993242136148e-17,
 -6.203046049965175e-19,  1.343571268653911e-21,  2.086829657316367e-24, -1.979589369272475e-26,  3.835544083922728e-29,  6.722746238854941e-01, -2.264807500790183e-03,
  3.462371940227931e-06,  2.887178975773306e-09, -2.800922644881185e-11,  4.453827018766381e-14,  1.259685492195634e-16, -7.341685774273227e-19,  7.326433835465277e-22,
  5.442273453628716e-24, -2.276960373715558e-26,  5.183777811116033e-30,  7.336159643431511e-01, -2.393787208599590e-03,  3.187693194187475e-06,  4.998202976276397e-09,
 -3.060518039050754e-11,  2.643354276015620e-14,  2.094559720158835e-16, -7.452194300550732e-19, -3.070544779700983e-22,  8.615265726945656e-24, -1.841351989125739e-26,
 -4.963741324323064e-29,  7.970559012482878e-01, -2.510721986775805e-03,  2.809878501076697e-06,  7.202148833943530e-09, -3.150561265393411e-11,  1.155218649201216e-15,
  2.859058770075131e-16, -6.113859979410789e-19, -1.679070168610841e-21,  1.042044171968838e-23, -4.445519743669003e-27, -1.116780455172597e-28,  8.624379610562367e-01,
 -2.612856908078705e-03,  2.326444797310552e-06,  9.397306828437389e-09, -3.024442774001277e-11, -3.020828268387116e-14,  3.400803371475827e-16, -3.065278080403187e-19,
 -3.137942133067342e-21,  9.525221281770964e-24,  1.840163719241167e-26, -1.525613355323367e-28,  9.295806685345677e-01, -2.697314328347500e-03,  1.738342017439366e-06,
  1.145870559688523e-08, -2.643425132013461e-11, -6.535007315723332e-14,  3.550358639549821e-16,  1.644098587021407e-19, -4.286531149130997e-21,  4.913004350754034e-24,
  4.464034138348395e-26, -1.365148128531440e-28,  9.982739134782787e-01, -2.761134073267432e-03,  1.050825072588710e-06,  1.324039968696410e-08, -1.983937219063061e-11,
 -1.006148437489307e-13,  3.150175120381107e-16,  7.504609643899322e-19, -4.629325354732984e-21, -3.462861137686230e-24,  6.358995298818764e-26, -3.756660028030657e-29,
  1.068274929134283e+00, -2.801332142848977e-03,  2.743829770884837e-07,  1.458077063673411e-08, -1.046125991066754e-11, -1.310617015068512e-13,  2.096940717278070e-16,
  1.345362510352661e-18, -3.702326337016388e-21, -1.402056141820805e-23,  6.170858134134382e-26,  1.351205409587914e-28,  1.139303909278408e+00, -2.814982856318492e-03,
 -5.743361148932507e-07,  1.531180974578112e-08,  1.371204178778248e-12, -1.508282485086798e-13,  3.937393427965431e-17,  1.791707632566171e-18, -1.279997981292927e-21,
 -2.325935065745278e-23,  2.868958281643624e-26,  3.160441764461296e-28,  1.211039331532843e+00, -2.799329872640804e-03, -1.471705182490331e-06,  1.527330169420436e-08,
  1.492158493597790e-11, -1.539002657386476e-13, -1.798237797215807e-16,  1.907084556712495e-18,  2.382487749756095e-21, -2.634217248477636e-23, -3.356643834502771e-26,
  3.888050280656415e-28,  1.283113113635932e+00, -2.751931606630671e-03, -2.386557405404817e-06,  1.433251152781192e-08,  2.899931746641212e-11, -1.353441839869030e-13,
 -4.127286206292056e-16,  1.537648849327828e-18,  6.375171533853141e-21, -1.895122767016061e-23, -1.034007164039591e-25,  2.406101507818727e-28,  1.355105811918656e+00,
 -2.670845836424354e-03, -3.280100159794911e-06,  1.240922497234992e-08,  4.197903217230533e-11, -9.294320144702583e-14, -6.064935519054690e-16,  6.348519661754627e-19,
  9.188518583385674e-21, -2.484967744536354e-25, -1.410348888508022e-25, -1.374762140446520e-28,  1.426542181678432e+00, -2.554856221547249e-03, -4.106585697400882e-06,
  9.504617394217771e-09,  5.192358867478426e-11, -2.897321063168740e-14, -6.994426591902526e-16, -6.665104927056238e-19,  9.158064530803434e-21,  2.432820464649415e-23,
 -1.068095161720348e-25, -5.638802305935626e-28,  1.496887559814648e+00, -2.403739318602298e-03, -4.815072224586331e-06,  5.730298144518603e-09,  5.684446666298932e-11,
  4.842659409752513e-14, -6.389206348423670e-16, -2.012240078397193e-18,  5.322094259954069e-21,  4.289282226527510e-23,  5.852432744390288e-27, -7.056185094028031e-28,
  1.565545698388355e+00, -2.218563705074814e-03, -5.352617589807233e-06,  1.331063460051106e-09,  5.511074595793067e-11,  1.251110214980821e-13, -4.059680520057278e-16,
 -2.889999132636982e-18, -1.599933957409801e-21,  4.204192980327783e-23,  1.433594459154504e-25, -3.198826725106311e-28,  1.631858861901425e+00, -2.002002336292061e-03,
 -5.669167732014788e-06, -3.308106320830114e-09,  4.596896619784929e-11,  1.829249975053185e-13, -3.855688255620048e-17, -2.822696599946992e-18, -8.792507458571832e-21,
  1.658718495846024e-23,  2.062243244657911e-25,  4.216933442128715e-28,  1.695111174674201e+00, -1.758625141431868e-03, -5.724177310109361e-06, -7.682250807258498e-09,
  3.005959880134510e-11,  2.043673497026294e-13,  3.611215394433094e-16, -1.655186442439099e-18, -1.229079296585407e-20, -2.185675535318967e-23,  1.231702495336206e-25,
  8.955102617427828e-28,  1.754536321319875e+00, -1.495122187613595e-03, -5.494580506517773e-06, -1.122422216119004e-08,  9.728886236438211e-12,  1.793502245744941e-13,
  6.507819478363814e-16,  2.181598293002937e-19, -9.430097776294914e-21, -4.758836993876391e-23, -6.049805220127272e-26,  5.643901939171987e-28,  1.809330693923485e+00,
 -1.220391604481795e-03, -4.983108430655986e-06, -1.340387594773737e-08, -1.111649875640804e-11,  1.117492362695537e-13,  7.077463440548503e-16,  1.909970894269687e-18,
 -1.439246121792386e-21, -3.966284292743569e-23, -1.870581460986992e-25, -3.005982045897503e-28,  1.858672857685445e+00, -9.454166271135201e-04, -4.225215472627671e-06,
 -1.385872484777150e-08, -2.780820391493467e-11,  2.187608565371208e-14,  5.028936526710742e-16,  2.504083576383872e-18,  6.409220873155236e-21, -4.171979913698546e-24,
 -1.353299414091103e-25, -7.380744495617568e-28,  1.901749688117073e+00, -6.828607778369663e-04, -3.292268644287229e-06, -1.252669368277770e-08, -3.633822495064687e-11,
 -5.882205486523411e-14,  1.405494527619160e-16,  1.721416211002237e-18,  8.564895769956512e-21,  2.638090024396749e-23,  2.533471504003448e-26, -2.937699707764457e-28,
  1.937788674242013e+00, -4.463379677732439e-04, -2.288556939454430e-06, -9.733475661337297e-09, -3.499798110742975e-11, -1.011767802845766e-13, -1.837471377210642e-16,
  2.375937191783483e-19,  4.342055689773950e-21,  2.563108534399897e-23,  1.050244631739600e-25,  2.986857675604404e-28,  1.966094744962070e+00, -2.493697196088255e-04,
 -1.340504430809815e-06, -6.182473020253945e-09, -2.547639407161656e-11, -9.419420268161886e-14, -3.052845451037910e-16, -8.016765010189276e-19, -1.192984033425083e-21,
  3.567880776687900e-24,  4.395238085977328e-26,  2.609196089109296e-28,  1.986088882783673e+00, -1.041186739655853e-04, -5.783916637057363e-07, -2.816581995715676e-09,
 -1.263156047469053e-11, -5.317120321505588e-14, -2.114462659682230e-16, -7.934136745894597e-19, -2.784172653799458e-21, -8.943125147042620e-24, -2.497917478785748e-26,
 -5.145120376649652e-29,  1.997347428258108e+00, -2.004927023788823e-05, -1.134351070344606e-07, -5.690298756524695e-10, -2.667573430367528e-12, -1.195949250282563e-14,
 -5.189484431536009e-17, -2.194387340956749e-19, -9.079168664496523e-22, -3.684452213717894e-24, -1.468480249924801e-26, -5.751010057378772e-29,  3.667315427783496e-04,
 -1.580597543515985e-06,  5.108405052044109e-09, -1.467360496593597e-11,  3.950382432120748e-14, -1.020767334055410e-16,  2.563250591347308e-19, -6.304003506821059e-22,
  1.525101257875857e-24, -3.644015410169866e-27,  8.608863699764109e-30, -2.018383067727439e-32,  3.300388255912009e-03, -1.421283200909896e-05,  4.584959711157325e-08,
 -1.312677788137806e-10,  3.515930764190546e-13, -9.018636571544811e-16,  2.242155505906685e-18, -5.442618333569490e-21,  1.294924353042315e-23, -3.030439286971766e-26,
  6.978693982713015e-29, -1.586562014543421e-31,  9.166651289993579e-03, -3.941025653770239e-05,  1.266594483338368e-07, -3.602265079041379e-10,  9.548710105379774e-13,
 -2.412670739023844e-15,  5.874529952785853e-18, -1.386805527310853e-20,  3.181202505398814e-23, -7.101853692589898e-26,  1.538856861272066e-28, -3.235580485626534e-31,
  1.796338592284375e-02, -7.703814282352963e-05,  2.461916041366685e-07, -6.931322938834736e-10,  1.808114651454601e-12, -4.461650848862009e-15,  1.050422530427792e-17,
 -2.366461218245128e-20,  5.087816922915887e-23, -1.037440742594949e-25,  1.970965402650555e-28, -3.387393307366356e-31,  2.968730449062207e-02, -1.268927953114684e-04,
  4.024234551035930e-07, -1.117465356831639e-09,  2.850946423531720e-12, -6.801233962281499e-15,  1.522990475194360e-17, -3.184914243901393e-20,  6.105862734215799e-23,
 -1.028655899689704e-25,  1.328174442189180e-28, -4.653027905494946e-32,  4.433386161159475e-02, -1.886996155479279e-04,  5.926528567880990e-07, -1.616737377895984e-09,
  4.005614040559552e-12, -9.123115217374676e-15,  1.898258269736809e-17, -3.512587687752753e-20,  5.331699336100160e-23, -4.681931347695973e-26, -8.056060572811268e-29,
  5.993998935454947e-31,  6.189711096236511e-02, -2.621105021486745e-04,  8.134944699323358e-07, -2.170679921454106e-09,  5.179414803101385e-12, -1.107678769062813e-14,
  2.063379119133894e-17, -3.041088492614130e-20,  2.086479469992399e-23,  7.384116241537980e-26, -4.336427842275639e-28,  1.462079914733763e-30,  8.236952047388080e-02,
 -3.467005714874570e-04,  1.060876385470865e-06, -2.755496441330063e-09,  6.267804645259925e-12, -1.229245682451754e-14,  1.912316890882343e-17, -1.541104594870431e-20,
 -3.864192052320232e-23,  2.495509978034247e-25, -8.494813956317587e-28,  2.201869419123528e-30,  1.057417418863517e-01, -4.419641826045426e-04,  1.330037932894344e-06,
 -3.344189286645363e-09,  7.158237391647844e-12, -1.240805116484072e-14,  1.359955813783678e-17,  1.079572395443633e-20, -1.212478442182047e-22,  4.477685611927272e-25,
 -1.183828973295422e-27,  2.334111443372342e-30,  1.320023295730216e-01, -5.473102499786133e-04,  1.615529853932117e-06, -3.906975777948649e-09,  7.734780459497895e-12,
 -1.109986140696493e-14,  3.567708723357418e-18,  4.724410583313318e-20, -2.155662752512994e-22,  6.136296677773887e-25, -1.247650943554374e-27,  1.372314998877513e-30,
  1.611374023882300e-01, -6.620568304197824e-04,  1.911218369582973e-06, -4.411810194852166e-09,  7.883547679703392e-12, -8.116079225593907e-15, -1.096967704513728e-17,
  9.070511666896823e-20, -3.027592358400211e-22,  6.765694010084613e-25, -8.536954094157734e-28, -9.587474228359704e-31,  1.931302409892222e-01, -7.854249763965177e-04,
  2.210295092575783e-06, -4.825031326830014e-09,  7.498975305745582e-12, -3.312149667518752e-15, -2.938754852396518e-17,  1.355350846691428e-19, -3.579850772856634e-22,
  5.635641929197349e-25,  1.165911567452265e-28, -4.485619343649042e-30,  2.279608115958459e-01, -9.165318589103980e-04,  2.505295256439428e-06, -5.112157942743314e-09,
  6.490940010552363e-12,  3.313623956592078e-15, -5.034773528763652e-17,  1.738392727757128e-19, -3.535727830793734e-22,  2.185383625179644e-25,  1.636629074426324e-27,
 -8.400740065314501e-30,  2.656052054585935e-01, -1.054383180328819e-03,  2.788127364974524e-06, -5.238856881737370e-09,  4.792673001689648e-12,  1.158639391051990e-14,
 -7.176080290954403e-17,  1.960357761464916e-19, -2.640033773645330e-22, -3.740681802423249e-25,  3.467544277435431e-27, -1.122828829124745e-29,  3.060349813743631e-01,
 -1.197864923708043e-03,  3.050118130990717e-06, -5.172110057872819e-09,  2.369356278374339e-12,  2.112592910516601e-14, -9.082220262879174e-17,  1.918887192855490e-19,
 -7.249607825749780e-23, -1.165510099011883e-24,  5.126380649247007e-27, -1.104346718929489e-29,  3.492163963938832e-01, -1.345734523174804e-03,  3.282077488244621e-06,
 -4.881606889497673e-09, -7.728119281745415e-13,  3.132645390177962e-14, -1.041460113615731e-16,  1.520442663014018e-19,  2.214055325592456e-22, -2.024802242164420e-24,
  5.919943212811779e-27, -6.015285310688943e-30,  3.951095073836545e-01, -1.496611593942677e-03,  3.474389538351706e-06, -4.341386601657107e-09, -4.577434092098191e-12,
  4.135001276806270e-14, -1.080191194547155e-16,  7.004134563752929e-20,  5.943740845077726e-22, -2.734664063853779e-24,  5.071962160920512e-27,  4.738965654648779e-30,
  4.436671233285057e-01, -1.648968435806967e-03,  3.617136537336413e-06, -3.531749192302313e-09, -8.929152063393106e-12,  5.013926730290862e-14, -9.879471417567346e-17,
 -5.532611327656603e-20,  9.937026913503057e-22, -3.010431078738260e-24,  1.957546409082954e-27,  2.013873763778956e-29,  4.948335851986544e-01, -1.801120627299334e-03,
  3.700264416978606e-06, -2.441442754581174e-09, -1.364609302220471e-11,  5.645658293762571e-14, -7.343427941437918e-17, -2.175528471575553e-19,  1.335921982985976e-21,
 -2.550163722465405e-24, -3.570359676435576e-27,  3.630271316096231e-29,  5.485433469014074e-01, -1.951218167737111e-03,  3.713799822504626e-06, -1.070115784631084e-09,
 -1.847461932165283e-11,  5.895684600850766e-14, -3.018949646402494e-17, -4.003026941888844e-19,  1.512422280161505e-21, -1.120028743429396e-24, -1.082488909223657e-26,
  4.641700493864315e-29,  6.047193273901988e-01, -2.097237811939320e-03,  3.648130122362950e-06,  5.690072613228404e-10, -2.308785411847028e-11,  5.630124875102582e-14,
  3.061354724573187e-17, -5.762577610752749e-19,  1.404861734576698e-21,  1.329922136134756e-24, -1.802341590727240e-26,  4.193721404240030e-29,  6.632710005939932e-01,
 -2.236977490456238e-03,  3.494359110570081e-06,  2.446314799445335e-09, -2.708987925057226e-11,  4.731765872724194e-14,  1.057682571752609e-16, -7.077643804366229e-19,
  9.122555018933591e-22,  4.539255746505926e-24, -2.230533351759207e-26,  1.561080969643263e-29,  7.240921867660618e-01, -2.368054031994090e-03,  3.244751844040723e-06,
  4.513015476612103e-09, -3.002793480066028e-11,  3.120926344646463e-14,  1.884978565663240e-16, -7.502289194825234e-19, -1.064569371344266e-23,  7.839787281808208e-24,
 -2.024472934604341e-26, -3.376191129191268e-29,  7.870585066276885e-01, -2.487905821001002e-03,  2.893281702223306e-06,  6.698610762524994e-09, -3.141530740668804e-11,
  7.805807649869189e-15,  2.680909420263061e-16, -6.591577314254491e-19, -1.308278338652938e-21,  1.014885881156509e-23, -9.019619312565576e-27, -9.603655122161806e-29,
  8.520244590652108e-01, -2.593802548507533e-03,  2.436290504765656e-06,  8.909003005945753e-09, -3.076772659770983e-11, -2.216037313231277e-14,  3.301442481061282e-16,
 -4.013264185578473e-19, -2.783390273936560e-21,  1.012846226228504e-23,  1.180325591616657e-26, -1.466900509271059e-28,  9.188200852771651e-01, -2.682864860773295e-03,
  1.873267168708593e-06,  1.102576581935336e-08, -2.765575066364449e-11, -5.678929535523865e-14,  3.577479508106101e-16,  3.040335079877642e-20, -4.079011046741625e-21,
  6.574012184403259e-24,  3.831012131775250e-26, -1.502360084002997e-28,  9.872471888401991e-01, -2.752097480042476e-03,  1.207740232732203e-06,  1.290728898166929e-08,
 -2.177444975526220e-11, -9.281910594621117e-14,  3.339412182431172e-16,  6.008149565948294e-19, -4.708703467060671e-21, -9.634090884899240e-25,  6.111632202824535e-26,
 -7.411547568454540e-29,  1.057075094551632e+00, -2.798440244879071e-03,  4.482623632056958e-07,  1.439270660818106e-08, -1.302918718666554e-11, -1.255908386694483e-13,
  2.456331601907554e-16,  1.219299399502641e-18, -4.161332092403023e-21, -1.144745409354009e-23,  6.659392265331958e-26,  8.670645299903665e-29,  1.128035952397642e+00,
 -2.818842434243355e-03, -3.905620962872483e-07,  1.530968480045013e-08, -1.631874627075692e-12, -1.492866539105975e-13,  8.884416336834876e-17,  1.737598474659077e-18,
 -2.093406772349347e-21, -2.184258164518345e-23,  4.190931582851097e-26,  2.831819922830673e-28,  1.199819630949952e+00, -2.810366572309447e-03, -1.287095373801519e-06,
  1.548720681958706e-08,  1.180478795637064e-11, -1.575675256402910e-13, -1.255022733022904e-16,  1.967925772001342e-18,  1.414179523069239e-21, -2.733686490262822e-23,
 -1.605177384912873e-26,  4.047779073981394e-28,  1.272068302421993e+00, -2.770328426651689e-03, -2.211874362143875e-06,  1.477432238452634e-08,  2.619698266723056e-11,
 -1.447106266420728e-13, -3.669265042093904e-16,  1.729962321460167e-18,  5.621247950050419e-21, -2.285173699860892e-23, -9.105277396185704e-26,  3.190798906823790e-28,
  1.344370905998757e+00, -2.696479722986737e-03, -3.127223359428130e-06,  1.306523434835245e-08,  3.997622107251178e-11, -1.072525582007486e-13, -5.846104074452321e-16,
  9.276426477462867e-19,  9.076850826703028e-21, -5.979871271454115e-24, -1.447502356033140e-25, -2.996458398616751e-29,  1.416257793645103e+00, -2.587238612269419e-03,
 -3.987567716803328e-06,  1.032984128675778e-08,  5.117492104693694e-11, -4.594988782985586e-14, -7.138766316489575e-16, -3.603116446461410e-19,  9.951127195378023e-21,
  1.957422379550595e-23, -1.304786234087635e-25, -5.074715403752548e-28,  1.487196018805693e+00, -2.441969312291268e-03, -4.740822366770138e-06,  6.646705921658941e-09,
  5.765519934692295e-11,  3.243705776160912e-14, -6.926469590106654e-16, -1.817243665844750e-18,  6.862768131573317e-21,  4.248444864193716e-23, -2.675984435065586e-26,
 -7.726174093900847e-28,  1.556585924256192e+00, -2.261305578031850e-03, -5.331273413594882e-06,  2.232296177893406e-09,  5.750895571403481e-11,  1.143924004957202e-13,
 -4.873695505180490e-16, -2.915904587987055e-18,  1.295668996568639e-23,  4.744576809126351e-23,  1.256064093466018e-25, -4.880924132877406e-28,  1.623759912474552e+00,
 -2.047501686109139e-03, -5.704331494260074e-06, -2.543412576683678e-09,  4.961164885734033e-11,  1.810200220971161e-13, -1.214301098588428e-16, -3.092876284128344e-18,
 -8.042724460464984e-21,  2.517277670907227e-23,  2.221315116584943e-25,  2.948505057407471e-28,  1.687984515376644e+00, -1.804778818124334e-03, -5.813342235482511e-06,
 -7.168144113923823e-09,  3.422962835648413e-11,  2.124329893802465e-13,  3.091589864927226e-16, -2.060052200620341e-18, -1.297928320638596e-20, -1.612316376880166e-23,
  1.639184368030494e-25,  9.515144981472996e-28,  1.748467070342697e+00, -1.539614669938904e-03, -5.628216075168798e-06, -1.103901388284465e-08,  1.347239017808922e-11,
  1.950065953775750e-13,  6.524051586962343e-16, -1.114293729105430e-19, -1.118034949544685e-20, -4.945608450714714e-23, -3.148118769116415e-26,  7.574028711125627e-28,
  1.804368375038968e+00, -1.260902705715498e-03, -5.144945332474096e-06, -1.356291907692095e-08, -8.707355779743538e-12,  1.293703228482543e-13,  7.603556539940890e-16,
  1.839600902167146e-18, -3.004724846497555e-21, -4.738132362735504e-23, -1.980890124579072e-25, -1.938201104234756e-28,  1.854822523837343e+00, -9.798910958864950e-04,
 -4.394173129802127e-06, -1.429947590970550e-08, -2.724418941824020e-11,  3.480990340925198e-14,  5.758489202401311e-16,  2.705665629700740e-18,  6.153509572622918e-21,
 -1.026270593610631e-23, -1.698882209543332e-25, -8.315713777626254e-28,  1.898964602608540e+00, -7.098101804203491e-04, -3.446115620807681e-06, -1.311731657789820e-08,
 -3.747686619938983e-11, -5.483861762659201e-14,  1.927301911168282e-16,  2.010856474154196e-18,  9.529412142673872e-21,  2.710003058044296e-23,  9.687637796913873e-27,
 -4.220865121654497e-28,  1.935965952071809e+00, -4.651233049044809e-04, -2.408785999514987e-06, -1.030986869459180e-08, -3.706499229366777e-11, -1.054902970062401e-13,
 -1.750046266854122e-16,  3.921397180207316e-19,  5.343591829413825e-21,  3.009830922317103e-23,  1.184034492042134e-25,  3.077737017924577e-28,  1.965075338169787e+00,
 -2.603975891392224e-04, -1.417203319615900e-06, -6.605572196803192e-09, -2.743538636320834e-11, -1.017945775104455e-13, -3.282440803199902e-16, -8.374340831633743e-19,
 -1.029968734497262e-21,  5.573221040599619e-24,  5.677209154810777e-26,  3.237577335100478e-28,  1.985662934801582e+00, -1.088845216453253e-04, -6.134392846857970e-07,
 -3.027477820059603e-09, -1.374758442349457e-11, -5.852287264945616e-14, -2.349589588904571e-16, -8.878557042027421e-19, -3.124655160170747e-21, -9.987472970617600e-24,
 -2.723178115609889e-26, -5.055242421171716e-29,  1.997265371920291e+00, -2.098480873686705e-05, -1.205276709142148e-07, -6.136943899483417e-10, -2.919733232507909e-12,
 -1.328210994728599e-14, -5.846665374855263e-17, -2.507328282455804e-19, -1.051769696328699e-21, -4.325741774777092e-24, -1.746512841502744e-26, -6.925043068887779e-29,
  3.604897868587473e-04, -1.540424044112229e-06,  4.936047855498243e-09, -1.405754770998814e-11,  3.752240591452848e-14, -9.613135061869372e-17,  2.393378372296994e-19,
 -5.836313011667772e-22,  1.399906938362213e-24, -3.316780222645409e-27,  7.768330272560849e-30, -1.806414910152515e-32,  3.244260678306233e-03, -1.385224180436373e-05,
  4.430755080242202e-08, -1.257837149894645e-10,  3.340818145258947e-13, -8.498348094244088e-16,  2.095403209730279e-18, -5.045172476129939e-21,  1.190689418658741e-23,
 -2.764766187877561e-26,  6.316678247042857e-29, -1.425648577239836e-31,  9.011009799698889e-03, -3.841401571663389e-05,  1.224268299515065e-07, -3.453270686508810e-10,
  9.079966148277351e-13, -2.276228975012537e-15,  5.500100151295355e-18, -1.288981645533845e-20,  2.936280668430812e-23, -6.513884773580270e-26,  1.403158588030168e-28,
 -2.937474998582727e-31,  1.765912042464711e-02, -7.510139522718019e-05,  2.380446946892025e-07, -6.649028481070655e-10,  1.721349913572904e-12, -4.217320173049834e-15,
  9.863858801361812e-18, -2.209477452187269e-20,  4.728176084083645e-23, -9.615164316011191e-26,  1.826880564379203e-28, -3.163553567978324e-31,  2.918608823858520e-02,
 -1.237262807606776e-04,  3.892831363759824e-07, -1.072918850968368e-09,  2.718505814248204e-12, -6.446200157266934e-15,  1.436493360519555e-17, -2.995349600460540e-20,
  5.745053984704821e-23, -9.760050294827010e-26,  1.302820708204325e-28, -6.780583123752031e-32,  4.358842424314457e-02, -1.840349202687040e-04,  5.736306052222383e-07,
 -1.554082829343885e-09,  3.827628880272852e-12, -8.679144311409912e-15,  1.802268662752446e-17, -3.344727316189005e-20,  5.157957695087048e-23, -4.954409545141135e-26,
 -5.639012139495689e-29,  5.016611574870941e-31,  6.086152186053116e-02, -2.557053468879587e-04,  7.879363103855284e-07, -2.089554952295209e-09,  4.962762587206103e-12,
 -1.059171697265454e-14,  1.979201031490626e-17, -2.970390412577911e-20,  2.322586501468532e-23,  5.772827349398679e-26, -3.732959203749252e-28,  1.284345535951148e-30,
  8.099948517477504e-02, -3.383441379132715e-04,  1.028404104768914e-06, -2.657153572608572e-09,  6.026509429301905e-12, -1.183881054010612e-14,  1.867565293540305e-17,
 -1.651021830112763e-20, -3.024693566403081e-23,  2.174466694643437e-25, -7.572588607941606e-28,  1.992644147237099e-30,  1.039949143285172e-01, -4.314824719311198e-04,
  1.290586720637203e-06, -3.231624947666587e-09,  6.913362543157461e-12, -1.207845826573015e-14,  1.384987869198680e-17,  7.164767037989401e-21, -1.059561348579319e-22,
  4.024305677290354e-25, -1.084043736291280e-27,  2.200576845822363e-30,  1.298386430685633e-01, -5.345714589635997e-04,  1.569381373878036e-06, -3.784990180131566e-09,
  7.513742687954571e-12, -1.099912179532217e-14,  4.797222981353071e-18,  4.068992374095248e-20, -1.943590960351489e-22,  5.649600416006137e-25, -1.185198617326102e-27,
  1.459196724322424e-30,  1.585194222737952e-01, -6.469767184526700e-04,  1.859028067186425e-06, -4.286985465009578e-09,  7.718793528578244e-12, -8.349947064986628e-15,
 -8.561955747450376e-18,  8.139986022602559e-20, -2.790263289557093e-22,  6.417123606280744e-25, -8.859849921015451e-28, -5.230974093588240e-31,  1.900235419753995e-01,
 -7.679721827154428e-04,  2.153112311601388e-06, -4.705614720002914e-09,  7.425980083934042e-12, -3.973186748385609e-15, -2.574988920326316e-17,  1.244047042149020e-19,
 -3.376581118986290e-22,  5.645287258480380e-25, -6.241759772957741e-29, -3.668977240382227e-30,  2.243343828589377e-01, -8.967331102861658e-04,  2.444574470157246e-06,
 -5.007836744142997e-09,  6.545516725554147e-12,  2.162417489789901e-15, -4.563736754120615e-17,  1.626627525663171e-19, -3.446132303412468e-22,  2.769260526983014e-25,
  1.290408927348418e-27, -7.349987993623263e-30,  2.614318864848457e-01, -1.032328305919733e-03,  2.725728527961796e-06, -5.160412017836205e-09,  5.007617913254315e-12,
  9.929036515695969e-15, -6.639191381259105e-17,  1.873980238291607e-19, -2.750898380879143e-22, -2.449805026849978e-25,  2.993475601555839e-27, -1.031757145959789e-29,
  3.012919314404733e-01, -1.173711564126972e-03,  2.988293832958193e-06, -5.130936819332730e-09,  2.770511221213980e-12,  1.901037132784036e-14, -8.548782780946560e-17,
  1.889361386836932e-19, -1.108801554918628e-22, -9.701268186560409e-25,  4.644264813509941e-27, -1.084081061273346e-29,  3.438856003037882e-01, -1.319712383863260e-03,
  3.223444255160166e-06, -4.889093993104451e-09, -1.709291987479044e-13,  2.887877137269040e-14, -9.980021772859601e-17,  1.580081197810943e-19,  1.527079503995604e-22,
 -1.793652251247109e-24,  5.629461105630723e-27, -7.127617192298095e-30,  3.891783196190979e-01, -1.469026047314471e-03,  3.421880302107131e-06, -4.408149697709496e-09,
 -3.776188844857450e-12,  3.878314749314558e-14, -1.058062009216405e-16,  8.752566138137840e-20,  4.996203938244755e-22, -2.528470491821622e-24,  5.217419197699790e-27,
  1.951688291901435e-30,  4.371288520275641e-01, -1.620203220826527e-03,  3.573931021751938e-06, -3.666722634190507e-09, -7.950184780884655e-12,  4.775309826038440e-14,
 -9.991484158856185e-17, -2.524486632057198e-20,  8.869385746291864e-22, -2.915673823884955e-24,  2.749657751898619e-27,  1.592989410128053e-29,  4.876881162427228e-01,
 -1.771639327771089e-03,  3.669694024699685e-06, -2.650844933255592e-09, -1.253505439797379e-11,  5.462580743074891e-14, -7.894124637368904e-17, -1.762967551069698e-19,
  1.241918472147580e-21, -2.662340425612291e-24, -2.070904945558627e-27,  3.185223426720442e-29,  5.407978067223703e-01, -1.921564070471074e-03,  3.699223643455192e-06,
 -1.356319678514749e-09, -1.730360767166033e-11,  5.810322516086975e-14, -4.072704117795191e-17, -3.526299317539284e-19,  1.464793283003268e-21, -1.512873976832357e-24,
 -8.835911152761410e-27,  4.387500270347825e-29,  5.963887807163369e-01, -2.068031652697800e-03,  3.652779048870786e-06,  2.086443212323088e-10, -2.195576242075711e-11,
  5.684747061135547e-14,  1.511393464607025e-17, -5.306716379407774e-19,  1.440213336140167e-21,  6.465896372412378e-25, -1.612858311461397e-26,  4.394854332319478e-29,
  6.543791759912614e-01, -2.208912490122754e-03,  3.521145917911847e-06,  2.020578801944250e-09, -2.611972923725157e-11,  4.962173165713747e-14,  8.638289233265414e-17,
 -6.761282853287021e-19,  1.059798799656982e-21,  3.663432466525016e-24, -2.142356196286545e-26,  2.416079314224991e-29,  7.146722181905512e-01, -2.341887511097568e-03,
  3.296046722838581e-06,  4.037800663570409e-09, -2.936021067822557e-11,  3.548135172024984e-14,  1.675279766922787e-16, -7.462127925409512e-19,  2.566928920970435e-22,
  7.004713013912036e-24, -2.140182140671623e-26, -1.905322702422270e-29,  7.771536729003254e-01, -2.464446564925620e-03,  2.970655428770237e-06,  6.197558007834793e-09,
 -3.119636742358293e-11,  1.401411742906532e-14,  2.491027995741773e-16, -6.952545049118201e-19, -9.503881400806003e-22,  9.708378660305309e-24, -1.288416200142525e-26,
 -7.954000182908270e-29,  8.416888947477683e-01, -2.573892992053230e-03,  2.540231596900934e-06,  8.413600231421263e-09, -3.113266022456671e-11, -1.438148173254808e-14,
  3.177155420398478e-16, -4.844822670904229e-19, -2.411799744131745e-21,  1.047408535308632e-23,  5.547896655944593e-27, -1.370915906523213e-28,  9.081194253371778e-01,
 -2.667357092316997e-03,  2.002885436827896e-06,  1.057465405178361e-08, -2.870568337088385e-11, -4.820764978540108e-14,  3.568094590864553e-16, -9.605571852294627e-20,
 -3.816381959625623e-21,  7.971487371306664e-24,  3.150673864644990e-26, -1.580531935195474e-28,  9.762590951739143e-01, -2.741822069188571e-03,  1.360477518183925e-06,
  1.254448760116514e-08, -2.354941140483433e-11, -8.461968490176250e-14,  3.486526479132113e-16,  4.500463755395596e-19, -4.700257031237623e-21,  1.406360585789029e-24,
  5.714289596342191e-26, -1.055809789697771e-28,  1.045889594363428e+00, -2.794167028755705e-03,  6.196422191893376e-07,  1.416447671696405e-08, -1.547936594593252e-11,
 -1.193013678422939e-13,  2.778510172893409e-16,  1.080063743899681e-18, -4.524704564546964e-21, -8.721798212946292e-24,  6.933330546338849e-26,  3.791927893449268e-29,
  1.116755496278410e+00, -2.821232736094615e-03, -2.071006477093825e-07,  1.525982119114239e-08, -4.592386393501382e-12, -1.465788450747155e-13,  1.364433068320145e-16,
  1.658375349780881e-18, -2.846668254985397e-21, -1.992878282257708e-23,  5.347426862099484e-26,  2.411537696961658e-28,  1.188558752378500e+00, -2.819916978942743e-03,
 -1.100220105625521e-06,  1.565072778279421e-08,  8.627802709697248e-12, -1.599141563663299e-13, -6.991542758482437e-17,  1.997344496659277e-18,  4.228008264969654e-22,
 -2.762147482709017e-23,  1.824315887013365e-27,  4.051982938308648e-28,  1.260952731339920e+00, -2.787307351480636e-03, -2.032164596246263e-06,  1.516985875973898e-08,
  2.321873306287826e-11, -1.529160535386886e-13, -3.160977600258906e-16,  1.896005444590624e-18,  4.736600871554361e-21, -2.619237820114094e-23, -7.549076668263283e-26,
  3.861000422357625e-28,  1.333535959620622e+00, -2.720859673011785e-03, -2.966676060562717e-06,  1.368694056295089e-08,  3.769313594272621e-11, -1.209389370512115e-13,
 -5.546103194663304e-16,  1.213539398150952e-18,  8.757339221066307e-21, -1.176305507996360e-23, -1.435801889901585e-25,  8.373831746579803e-29,  1.405845842731944e+00,
 -2.618629477949722e-03, -3.858730179079120e-06,  1.114035437151864e-08,  5.008396430704664e-11, -6.316739437969839e-14, -7.194087451028717e-16, -3.165047540281298e-20,
  1.055667583036397e-20,  1.393110701815533e-23, -1.510707889048380e-25, -4.242447873696966e-28,  1.477352815745416e+00, -2.479561123774759e-03, -4.655508560011610e-06,
  7.573458993134265e-09,  5.813371793945316e-11,  1.522915679727630e-14, -7.402271979705843e-16, -1.573437983870974e-18,  8.364620017047624e-21,  4.072048422542803e-23,
 -6.172154845478133e-26, -8.114086107569175e-28,  1.547455593531268e+00, -2.303832803078405e-03, -5.298891635177968e-06,  3.170078985478290e-09,  5.967322882235562e-11,
  1.017174460018565e-13, -5.687456425958827e-16, -2.887236544880503e-18,  1.805807737828875e-21,  5.199027551043662e-23,  1.003792166382917e-25, -6.581560981931838e-28,
  1.615478462539012e+00, -2.093244653525002e-03, -5.729970848282999e-06, -1.720851292373470e-09,  5.319574490552507e-11,  1.770383097735721e-13, -2.114851914292688e-16,
 -3.334006420521517e-18, -6.973857888131915e-21,  3.427140939651599e-23,  2.315892081104400e-25,  1.286224459102673e-28,  1.680671855422495e+00, -1.851619991050229e-03,
 -5.895932464499625e-06, -6.586098101086187e-09,  3.854756944106666e-11,  2.191132053892909e-13,  2.455850467281119e-16, -2.483328286016578e-18, -1.343152134160048e-20,
 -8.720367876555270e-24,  2.063638224084635e-25,  9.709050647242598e-28,  1.742217726811827e+00, -1.585166304787595e-03, -5.759259436889058e-06, -1.079140565770469e-08,
  1.752863065626273e-11,  2.105847986569752e-13,  6.440073457554129e-16, -4.978615293814859e-19, -1.297485767122556e-20, -4.998871633067427e-23,  6.355571061794351e-27,
  9.640248617934141e-28,  1.799241411232789e+00, -1.302715453721050e-03, -5.308447624060645e-06, -1.368052871716731e-08, -5.933354791752138e-12,  1.482244682265661e-13,
  8.102509471151907e-16,  1.714614545014850e-18, -4.854761481922960e-21, -5.543408943862647e-23, -2.034387893566425e-25, -4.124990158454521e-29,  1.850831555537845e+00,
 -1.015738208268965e-03, -4.568356804647689e-06, -1.472903629544687e-08, -2.640353778796881e-11,  4.956124216749572e-14,  6.542990156685619e-16,  2.895281978659725e-18,
  5.652682571588814e-21, -1.781530150044796e-23, -2.083400035219496e-25, -9.135746159937413e-28,  1.896069212622029e+00, -7.380190119144453e-04, -3.607156524468893e-06,
 -1.372544952087698e-08, -3.852264076588277e-11, -4.950208372809595e-14,  2.534503244567406e-16,  2.331443136821613e-18,  1.050711359712390e-20,  2.707185023200987e-23,
 -1.224733062854192e-26, -5.801203111014333e-28,  1.934066120279976e+00, -4.848987100837441e-04, -2.536133014860020e-06, -1.092001113089393e-08, -3.921580574058157e-11,
 -1.095382921464729e-13, -1.614612229113642e-16,  5.814118680936112e-19,  6.515647323395051e-21,  3.510533006117176e-23,  1.319219463493026e-25,  3.041561929452711e-28,
  1.964010559793893e+00, -2.720599031351725e-04, -1.499172575931693e-06, -7.061261578141398e-09, -2.955197419519984e-11, -1.099573358868955e-13, -3.521202061053480e-16,
 -8.667155080665062e-19, -7.848317335455713e-22,  8.150289674398130e-24,  7.263228783459753e-26,  3.994331655257609e-28,  1.985217346199220e+00, -1.139411851892807e-04,
 -6.511284277874431e-07, -3.257117876934997e-09, -1.497650551441995e-11, -6.447184577888037e-14, -2.612743401333676e-16, -9.938119865474450e-19, -3.504339663155238e-21,
 -1.112036435743513e-23, -2.938533864217082e-26, -4.676262692827361e-29,  1.997179456453402e+00, -2.197930229860923e-05, -1.281813178305236e-07, -6.626139570682675e-10,
 -3.199996374528192e-12, -1.477350793065344e-14, -6.598277363357789e-17, -2.870221126531526e-19, -1.220841769333842e-21, -5.089295967471402e-24, -2.081680109351091e-26,
 -8.356934301142351e-29,  3.544060132928381e-04, -1.501600361583116e-06,  4.770896983252573e-09, -1.347226360140477e-11,  3.565592200826269e-14, -9.057838880199632e-17,
  2.236057874248506e-19, -5.406862932789028e-22,  1.285909714726546e-24, -3.021373529706236e-27,  7.015700560429671e-30, -1.618321694565051e-32,  3.189551198945701e-03,
 -1.350372942024230e-05,  4.282966590735619e-08, -1.205716943878088e-10,  3.175767913325018e-13, -8.011981575497152e-16,  1.959326446774792e-18, -4.679601275268235e-21,
  1.095558644337280e-23, -2.524210471626579e-26,  5.721556580340195e-29, -1.282152648074465e-31,  8.859286665421460e-03, -3.745093321511060e-05,  1.183685933932677e-07,
 -3.311562681472417e-10,  8.637633649365221e-13, -2.148453502468692e-15,  5.151994875471137e-18, -1.198666816987790e-20,  2.711579507435834e-23, -5.977658040130080e-26,
  1.279937789739041e-28, -2.667952213222957e-31,  1.736247367888783e-02, -7.322849112699121e-05,  2.302283677698331e-07, -6.380233655524721e-10,  1.639321595486270e-12,
 -3.987843583841278e-15,  9.265876870248855e-18, -2.063575801420777e-20,  4.394854051413886e-23, -8.911615231810420e-26,  1.692419782762796e-28, -2.950072993011263e-31,
  2.869733113503148e-02, -1.206627860188599e-04,  3.766648921376624e-07, -1.030435699553144e-09,  2.592962520628443e-12, -6.111301595022266e-15,  1.355145248037526e-17,
 -2.817029699013069e-20,  5.402995861574489e-23, -9.245400714559072e-26,  1.269243880264763e-28, -8.406677884482256e-32,  4.286134599406519e-02, -1.795194433288576e-04,
  5.553434106732017e-07, -1.494206243849713e-09,  3.658296537292092e-12, -8.257653266940213e-15,  1.710899963550520e-17, -3.182565781083635e-20,  4.976047267713263e-23,
 -5.138392664852647e-26, -3.621405539895215e-29,  4.175204952374759e-31,  5.985115053245366e-02, -2.495008211042905e-04,  7.633311684656384e-07, -2.011819898080669e-09,
  4.755611403601114e-12, -1.012660343223124e-14,  1.897099869207564e-17, -2.893019916265565e-20,  2.504849027855421e-23,  4.387874422087378e-26, -3.203326467386881e-28,
  1.126131129700519e-30,  7.966236343577973e-02, -3.302428270736006e-04,  9.970890716398231e-07, -2.562599437429141e-09,  5.794177394720636e-12, -1.139624464760695e-14,
  1.820095231369290e-17, -1.735854900504844e-20, -2.294348322107744e-23,  1.888517118727855e-25, -6.738998171002315e-28,  1.798935203923176e-30,  1.022893908555011e-01,
 -4.213110339705076e-04,  1.252462990958924e-06, -3.122925578572736e-09,  6.675131674043116e-12, -1.174402386089073e-14,  1.400514319418711e-17,  3.997788890557559e-21,
 -9.222617815595278e-23,  3.609649585484262e-25, -9.902407685425612e-28,  2.062770906257373e-30,  1.277251825387257e-01, -5.221960604393610e-04,  1.524675572886093e-06,
 -3.666523526071441e-09,  7.295000316694123e-12, -1.087100096304828e-14,  5.852461034042854e-18,  3.478682654255804e-20, -1.748582491330071e-22,  5.188527030473083e-25,
 -1.119824817769129e-27,  1.506480077565328e-30,  1.559609369853608e-01, -6.323081824663413e-04,  1.808319700728557e-06, -4.164831167827725e-09,  7.549919208025810e-12,
 -8.529071508704160e-15, -6.404339501510491e-18,  7.283376589166773e-20, -2.565671277688451e-22,  6.059227379849495e-25, -9.009071762366868e-28, -1.674626664898955e-31,
  1.869857482581510e-01, -7.509711401142144e-04,  2.097355101162285e-06, -4.587467163788874e-09,  7.340612294871308e-12, -4.550586326699551e-15, -2.241477828955120e-17,
  1.139240286806434e-19, -3.174169351382788e-22,  5.590203529493559e-25, -2.078109586933043e-28, -2.956241380793415e-30,  2.207861855310571e-01, -8.774151074002450e-04,
  2.385110037433964e-06, -4.902820474611447e-09,  6.578174626468205e-12,  1.120538784715464e-15, -4.123563102612458e-17,  1.518039855185355e-19, -3.337900776522135e-22,
  3.223653268342520e-25,  9.886018582426206e-28, -6.382450581177746e-30,  2.573457946684261e-01, -1.010768800862375e-03,  2.664290592623394e-06, -5.078786294400716e-09,
  5.190684430450971e-12,  8.397594250849092e-15, -6.126917553007845e-17,  1.784762780570724e-19, -2.818607836895303e-22, -1.340510761195082e-25,  2.559665999912183e-27,
 -9.402061478722834e-30,  2.966445090351661e-01, -1.150050716671172e-03,  2.927000750844293e-06, -5.083676665450566e-09,  3.130627871785764e-12,  1.702171404892379e-14,
 -8.025229031872541e-17,  1.848641069607676e-19, -1.425749452179527e-22, -7.937995240457417e-25,  4.174746634530717e-27, -1.047806417970214e-29,  3.386579542964545e-01,
 -1.294159509768659e-03,  3.164777360605205e-06, -4.887336882925800e-09,  3.830551450970613e-13,  2.653715094164981e-14, -9.531697824262370e-17,  1.619044611065162e-19,
  9.211178469851934e-23, -1.574995818386843e-24,  5.297757794448366e-27, -7.897691873956122e-30,  3.833566291218376e-01, -1.441863565148210e-03,  3.368645143910103e-06,
 -4.462500522229675e-09, -3.025711889762992e-12,  3.627493125695159e-14, -1.031450486239446e-16,  1.020975179042136e-19,  4.123661104866225e-22, -2.318772858434794e-24,
  5.250536196581924e-27, -3.728615808602026e-31,  4.307049404114446e-01, -1.591789866051945e-03,  3.529198226886785e-06, -3.786415567781248e-09, -7.019143466602239e-12,
  4.534977076167410e-14, -1.002399700511220e-16,  1.480268835139352e-21,  7.841124587773849e-22, -2.792820154483062e-24,  3.365281698994476e-27,  1.212091880712542e-29,
  4.806600678669758e-01, -1.742412343310656e-03,  3.636716235469670e-06, -2.842770212509624e-09, -1.146186115822919e-11,  5.267638352001559e-14, -8.333568311667498e-17,
 -1.381021962616984e-19,  1.144909048777573e-21, -2.718449883325440e-24, -7.666469741643514e-28,  2.744943914043675e-29,  5.331706284098847e-01, -1.892040003293707e-03,
  3.681324828129455e-06, -1.623937255708323e-09, -1.615209027108866e-11,  5.701253653755525e-14, -4.995310426483176e-17, -3.066924517170404e-19,  1.404425192754577e-21,
 -1.828588947767907e-24, -6.972761604024513e-27,  4.073053025686959e-29,  5.881751061103367e-01, -2.038805290835293e-03,  3.653212597127277e-06, -1.335375316981976e-10,
 -2.081636223742263e-11,  5.703712433449052e-14,  9.029779855128879e-19, -4.843330871953439e-19,  1.452346738873104e-21,  4.040195451210841e-26, -1.417616115313008e-26,
  4.458894262477933e-29,  6.456000079997951e-01, -2.180653363438122e-03,  3.542918467334446e-06,  1.610708888212955e-09, -2.510807586762677e-11,  5.147169020293483e-14,
  6.794475022800428e-17, -6.402677686295921e-19,  1.176533005825743e-21,  2.829856433348898e-24, -2.020641750410034e-26,  3.086552886838205e-29,  7.053577005651054e-01,
 -2.315333253544552e-03,  3.341705856542733e-06,  3.573925681154995e-09, -2.861206357582469e-11,  3.925245092565763e-14,  1.467857401635496e-16, -7.341305248356247e-19,
  4.932879436738691e-22,  6.135885872493445e-24, -2.194304868702415e-26, -5.808726040844648e-30,  7.673438761931892e-01, -2.440392300744262e-03,  3.042041556894473e-06,
  5.700976541344973e-09, -3.085789364426002e-11,  1.975586172099269e-14,  2.292616939493871e-16, -7.201809160618505e-19, -6.109617472152751e-22,  9.127936984401216e-24,
 -1.601626497155117e-26, -6.284566556833587e-29,  8.314345939383234e-01, -2.553175773742182e-03,  2.638197901578641e-06,  7.913586167119285e-09, -3.134518052349698e-11,
 -6.927466180338219e-15,  3.031264760537342e-16, -5.555955483945682e-19, -2.032160304248680e-21,  1.057886928892057e-23, -2.171289836410953e-28, -1.245315278982913e-28,
  8.974828356928176e-01, -2.650834303632040e-03,  2.126995226871292e-06,  1.010811401416802e-08, -2.958449011552207e-11, -3.969002400442014e-14,  3.524549565299897e-16,
 -2.133588052901339e-19, -3.508409768424470e-21,  9.091625959133580e-24,  2.448410041357492e-26, -1.602705558797537e-28,  9.653145187097021e-01, -2.730342644726250e-03,
  1.508696260591917e-06,  1.215461649157008e-08, -2.515719534538908e-11, -7.611773958005218e-14,  3.591589326175149e-16,  3.008797846694952e-19, -4.609678173683855e-21,
  3.591186968765599e-24,  5.191199482249105e-26, -1.311702794039681e-28,  1.034723910844012e+00, -2.788534385441598e-03,  7.880523827803025e-07,  1.389809094502150e-08,
 -1.779634519296220e-11, -1.122866742612706e-13,  3.060223629524344e-16,  9.307871137907904e-19, -4.788495568783476e-21, -5.929160428382293e-24,  6.995487408600357e-26,
 -9.243518705222247e-30,  1.105468409414409e+00, -2.822158540554511e-03, -2.451978553705051e-08,  1.516308390990622e-08, -7.487511662302681e-12, -1.427579327986746e-13,
  1.814977140431760e-16,  1.556235733220578e-18, -3.523172485977086e-21, -1.759160167132173e-23,  6.302732035799580e-26,  1.921118558037953e-28,  1.177262673388328e+00,
 -2.827965401659204e-03, -9.116888898423448e-07,  1.576311422188354e-08,  5.417273864040509e-12, -1.609204074665133e-13, -1.394955277804562e-17,  1.995012933655563e-18,
 -5.659901767425107e-22, -2.719523227408797e-23,  1.937894266579227e-26,  3.902666470952712e-28,  1.249772148816010e+00, -2.802830434554302e-03, -1.847999502511700e-06,
  1.551649807546004e-08,  2.008893341725492e-11, -1.598491056588449e-13, -2.610333210841302e-16,  2.031941315509569e-18,  3.743568795426068e-21, -2.885569534672556e-23,
 -5.729435761993188e-26,  4.383336859367025e-28,  1.322606108545044e+00, -2.743926044282480e-03, -2.798896362202910e-06,  1.426996941346379e-08,  3.514416488547173e-11,
 -1.338105996416782e-13, -5.167794409523704e-16,  1.485899527791426e-18,  8.231687673804300e-21, -1.739873917826225e-23, -1.373694491320362e-25,  1.982331055315696e-28,
  1.395310450902191e+00, -2.648951061642188e-03, -3.720282594468170e-06,  1.193065329930792e-08,  4.864808563229196e-11, -8.040524504624298e-14, -7.154986902659900e-16,
  3.129864564496527e-19,  1.094519670393326e-20,  7.545000628216955e-24, -1.674488243881119e-25, -3.164302519033549e-28,  1.467360681042119e+00, -2.516425837046885e-03,
 -4.559039330228818e-06,  8.505055471191970e-09,  5.825723998886728e-11, -3.033388895043994e-15, -7.803195356256801e-16, -1.282861762599273e-18,  9.777471846412849e-21,
  3.753347946366284e-23, -9.766626515689706e-26, -8.165037065438199e-28,  1.538155744090921e+00, -2.346055391594088e-03, -5.255057401023646e-06,  4.140356447073443e-09,
  6.156457171758492e-11,  8.710572455449629e-14, -6.484927102367473e-16, -2.798788944515770e-18,  3.742306777264558e-21,  5.537757128015340e-23,  6.780189558615542e-26,
 -8.205038973202866e-28,  1.607013694386141e+00, -2.139152284783525e-03, -5.745398408092754e-06, -8.417011992144006e-10,  5.667806787214687e-11,  1.708184256885715e-13,
 -3.077633884402083e-16, -3.535633984964248e-18, -5.572496581265257e-21,  4.359080954902411e-23,  2.328968937591147e-25, -7.503731007062132e-29,  1.673170555239250e+00,
 -1.899092763524454e-03, -5.971119489686289e-06, -5.933983152491530e-09,  4.298288974640590e-11,  2.241240487752686e-13,  1.699991799074805e-16, -2.916483405451364e-18,
 -1.358661075136728e-20,  3.841744840733384e-25,  2.486619440295303e-25,  9.430997195736389e-28,  1.735784100454703e+00, -1.631753274448847e-03, -5.886931865013119e-06,
 -1.047641981883584e-08,  2.189350972529449e-11,  2.258251174484060e-13,  6.239847963913206e-16, -9.417147237775021e-19, -1.475908710355409e-20, -4.882400142411095e-23,
  5.341767469199229e-26,  1.174920475229533e-27,  1.793944572563116e+00, -1.345841081719152e-03, -5.473082276290022e-06, -1.375067392855145e-08, -2.770615209367183e-12,
  1.682271464888990e-13,  8.557740101882073e-16,  1.525761336717857e-18, -6.996796738204823e-21, -6.355168347634223e-23, -2.009514775533224e-25,  1.633219598579873e-28,
  1.846694379556650e+00, -1.052999157195988e-03, -4.747604429462226e-06, -1.514268197273524e-08, -2.524861177449756e-11,  6.625702130728987e-14,  7.377909680040819e-16,
  3.064217981265614e-18,  4.851456586757034e-21, -2.697255800094417e-23, -2.499628885056331e-25, -9.737871270315284e-28,  1.893058364046762e+00, -7.675456368284135e-04,
 -3.775591630717952e-06, -1.434937871692583e-08, -3.944636648771032e-11, -4.259702148101777e-14,  3.235834532682554e-16,  2.683116515469264e-18,  1.146624622933567e-20,
  2.601779042143940e-23, -4.184365456577149e-26, -7.707185614126930e-28,  1.932085102110485e+00, -5.057227692729176e-04, -2.671010826889409e-06, -1.156519472068095e-08,
 -4.144387678046523e-11, -1.131932417293062e-13, -1.420652792453455e-16,  8.111775974568978e-19,  7.877605560451268e-21,  4.064487512332982e-23,  1.448929952829706e-25,
  2.817456536127996e-28,  1.962897785192137e+00, -2.844004325948300e-04, -1.586818786249492e-06, -7.552153802269140e-09, -3.183760891381604e-11, -1.187019831585804e-13,
 -3.766915314298504e-16, -8.865389550753374e-19, -4.346604672807666e-22,  1.143255996429159e-23,  9.213952319221840e-26,  4.898470442626585e-28,  1.984750909979633e+00,
 -1.193107281378090e-04, -6.916952682914200e-07, -3.507407856115984e-09, -1.633096932587415e-11, -7.108940057779126e-14, -2.907328434699346e-16, -1.112586952034315e-18,
 -3.926308516102472e-21, -1.233493137539553e-23, -3.128485876873332e-26, -3.874946319025917e-29,  1.997089436725336e+00, -2.303745173884078e-05, -1.364499218558285e-07,
 -7.162665159659316e-10, -3.511976919954613e-12, -1.645812371086465e-14, -7.459506199538723e-17, -3.291886701297498e-19, -1.419974839204421e-21, -6.000405899855792e-24,
 -2.486607428943078e-26, -1.010703193397154e-28,  3.484749358189145e-04, -1.464070291769159e-06,  4.612593937457027e-09, -1.291597487447981e-11,  3.389681695623005e-14,
 -8.538896924931251e-17,  2.090266853195324e-19, -5.012246945735791e-22,  1.182024599025250e-24, -2.754480674618398e-27,  6.341105909110107e-30, -1.451275015779862e-32,
  3.136212512835006e-03, -1.316679435486693e-05,  4.141277231204812e-08, -1.156161463176878e-10,  3.020126544246115e-13, -7.557078775853387e-16,  1.833072189908425e-18,
 -4.343131057960690e-21,  1.008674175755339e-23, -2.306243680749516e-26,  5.186106780453173e-29, -1.154109460375965e-31,  8.711351989612863e-03, -3.651964824776135e-05,
  1.144762429336439e-07, -3.176732010414930e-10,  8.220040863228589e-13, -2.028737048888665e-15,  4.828199446025367e-18, -1.115242844385123e-20,  2.505323185506254e-23,
 -5.488425848132204e-26,  1.167997478264259e-28, -2.424301319886935e-31,  1.707319550009397e-02, -7.141684939489067e-05,  2.227268688886921e-07, -6.124203859254774e-10,
  1.561742541258290e-12, -3.772240153995078e-15,  8.707291465196096e-18, -1.927945409981316e-20,  4.085914014338443e-23, -8.260003900906830e-26,  1.567111474378002e-28,
 -2.747616425909767e-31,  2.822062929971065e-02, -1.176982316852194e-04,  3.645446112028981e-07, -9.899087010895550e-10,  2.473925943878137e-12, -5.795339623493076e-15,
  1.278639616787348e-17, -2.649361943683778e-20,  5.079207297950512e-23, -8.745485420438442e-26,  1.229449647314844e-28, -9.620152721677489e-32,  4.215204154406430e-02,
 -1.751474352946952e-04,  5.377587536117393e-07, -1.436972713405251e-09,  3.497178373910850e-12, -7.857552481208730e-15,  1.623989402705597e-17, -3.026316480388350e-20,
  4.788880199121347e-23, -5.248716219296579e-26, -1.947439469318792e-29,  3.451833161604336e-31,  5.886520945448157e-02, -2.434894608184471e-04,  7.396392642100788e-07,
 -1.937325907758012e-09,  4.557567234936415e-12, -9.680928061678975e-15,  1.817239522848942e-17, -2.810575193954365e-20,  2.640903693775624e-23,  3.201382772835082e-26,
 -2.739372580047511e-28,  9.854964523131599e-31,  7.835715299739360e-02, -3.223875604261469e-04,  9.668866743249701e-07, -2.471692430882754e-09,  5.570580958359149e-12,
 -1.096533112844404e-14,  1.770562011590245e-17, -1.798901279689797e-20, -1.661144394490539e-23,  1.634251354466243e-25, -5.987297632131711e-28,  1.620331549192801e-30,
  1.006239513249956e-01, -4.114394325668920e-04,  1.215621004848613e-06, -3.017984220688857e-09,  6.443619824625302e-12, -1.140687891884863e-14,  1.407766401102361e-17,
  1.246997429190809e-21, -7.992291182288084e-23,  3.231296590711085e-25, -9.025365827717304e-28,  1.923809517070607e-30,  1.256605172299055e-01, -5.101726812181783e-04,
  1.481370461341765e-06, -3.551534929536202e-09,  7.079060588976858e-12, -1.071946885868738e-14,  6.750902830438456e-18,  2.948170676984744e-20, -1.569697870599041e-22,
  4.753920155822448e-25, -1.053098402947915e-27,  1.521844497685527e-30,  1.534603237255508e-01, -6.180394961936148e-04,  1.759060864574399e-06, -4.045404786257515e-09,
  7.377961213249106e-12, -8.659211351634522e-15, -4.476706518588031e-18,  6.496566530120067e-20, -2.354035196018587e-22,  5.698280505743169e-25, -9.017427649507189e-28,
  1.188825164467507e-31,  1.840150755412513e-01, -7.344105081837216e-04,  2.043007098824327e-06, -4.470773625609687e-09,  7.244473548037694e-12, -5.051391779842165e-15,
 -1.936409571060300e-17,  1.040868351557638e-19, -2.974714473676957e-22,  5.482947801690727e-25, -3.239714802627196e-28, -2.338775672700454e-30,  2.173143167755322e-01,
 -8.585677718590985e-04,  2.326908265775816e-06, -4.797442742046464e-09,  6.591026950741020e-12,  1.806937770202062e-16, -3.713286143512055e-17,  1.413154842066607e-19,
 -3.215383794021167e-22,  3.565588114858958e-25,  7.275011980932875e-28, -5.499764153042372e-30,  2.533449641361081e-01, -9.896968337437225e-04,  2.603848751005390e-06,
 -4.994469942731150e-09,  5.344331213712216e-12,  6.986079086633443e-15, -5.639870258405887e-17,  1.693984869918860e-19, -2.849409315535375e-22, -3.967158340056166e-26,
  2.165867507049141e-27, -8.501771686532305e-30,  2.920907530564951e-01, -1.126877850411771e-03,  2.866308071265817e-06, -5.030966043936821e-09,  3.452218102517130e-12,
  1.515723259534313e-14, -7.514404034868449e-17,  1.798758153488964e-19, -1.682558089431999e-22, -6.358958558846953e-25,  3.723952174552885e-27, -9.995954120056087e-30,
  3.335315814568122e-01, -1.269075739326580e-03,  3.106183207429179e-06, -4.877084803127045e-09,  8.912907928050756e-13,  2.430422549351701e-14, -9.075062352728568e-17,
  1.639850496206875e-19,  3.914107728492757e-23, -1.370195952887212e-24,  4.938750662612764e-27, -8.376921181861944e-30,  3.776427329432345e-01, -1.415129372746649e-03,
  3.314828177790087e-06, -4.505241426786496e-09, -2.324729134860593e-12,  3.383517028791772e-14, -1.001138386768292e-16,  1.139980865377171e-19,  3.326613106018542e-22,
 -2.109667753943827e-24,  5.190901604015607e-27, -2.270631509312342e-30,  4.243939577457443e-01, -1.563739869308436e-03,  3.483116909894410e-06, -3.891596548923008e-09,
 -6.136188024198366e-12,  4.294725225457889e-14, -9.986216392408117e-17,  2.499016409248191e-20,  6.861130445386089e-22, -2.648571283328728e-24,  3.822459367930648e-27,
  8.729299521186725e-30,  4.737483856062764e-01, -1.713458104667479e-03,  3.601537065236019e-06, -3.017841680818262e-09, -1.042862625580949e-11,  5.063397419736428e-14,
 -8.670436649604520e-17, -1.030345659239162e-19,  1.046772396776031e-21, -2.726225529274366e-24,  3.468924951001346e-28,  2.319821686259059e-29,  5.256612400860287e-01,
 -1.862671660803773e-03,  3.660324389907656e-06, -1.873316662190742e-09, -1.502449788279254e-11,  5.571562910787860e-14, -5.792157052540255e-17, -2.628544978121846e-19,
  1.333998238399932e-21, -2.072679656639107e-24, -5.257704324116064e-27,  3.717292927581779e-29,  5.800783183204987e-01, -2.009591575228754e-03,  3.649649411917284e-06,
 -4.574767265077193e-10, -1.967647437024309e-11,  5.690130910082600e-14, -1.200823650386834e-17, -4.379403255289135e-19,  1.444066640021726e-21, -4.874825032943159e-25,
 -1.222188211414496e-26,  4.406774946826397e-29,  6.369341941177321e-01, -2.152239452286798e-03,  3.559870840555999e-06,  1.217297727060365e-09, -2.406376508440686e-11,
  5.289157720429340e-14,  5.055855838028244e-17, -6.011419552966435e-19,  1.264201123546771e-21,  2.050341553578575e-24, -1.873329155646104e-26,  3.581528096142904e-29,
  6.961500955561375e-01, -2.288435779868072e-03,  3.381872714240525e-06,  3.122597510418177e-09, -2.779344092510586e-11,  4.253062260168445e-14,  1.264830762949155e-16,
 -7.149807266986577e-19,  6.983516468987236e-22,  5.256586659840694e-24, -2.193754366448045e-26,  5.773328757150248e-30,  7.576314011219042e-01, -2.415790682825164e-03,
  3.107504906050264e-06,  5.210703246136107e-09, -3.040939711931535e-11,  2.501425143283473e-14,  2.088714064004259e-16, -7.346027636419556e-19, -2.945099264332835e-22,
  8.436830389167119e-24, -1.842014457667214e-26, -4.652550831155661e-29,  8.212646913950989e-01, -2.531698872271076e-03,  2.730148491771798e-06,  7.411344744109349e-09,
 -3.141227606835541e-11,  1.538924238062850e-16,  2.867165729165689e-16, -6.145433942931773e-19, -1.652759827337266e-21,  1.046480194489549e-23, -5.378836989281178e-27,
 -1.097976805086136e-28,  8.869142871823495e-01, -2.633341256679536e-03,  2.245427771253359e-06,  9.628869114260017e-09, -3.029424956212577e-11, -3.131517117551977e-14,
  3.449596141027905e-16, -3.202158946596258e-19, -3.165178291309492e-21,  9.930449243816574e-24,  1.747807751727189e-26, -1.573960070749707e-28,  9.544182012127658e-01,
 -2.717696608450215e-03,  1.652087854225000e-06,  1.174039343711576e-08, -2.659275518529754e-11, -6.741336468703619e-14,  3.655406562604794e-16,  1.558277021540173e-19,
 -4.444466432182662e-21,  5.546101193007159e-24,  4.569346203709590e-26, -1.504250875888243e-28,  1.023583431339781e+00, -2.781567866660292e-03,  9.530482318720724e-07,
  1.359579115445004e-08, -1.996661254003442e-11, -1.046468862340532e-13,  3.299109093046070e-16,  7.746785208380030e-19, -4.951796382795598e-21, -3.152280961041051e-24,
  6.857022592032529e-26, -5.300104229575570e-29,  1.094180532170734e+00, -2.821629122796116e-03,  1.566250065859826e-07,  1.502069370592127e-08, -1.029564958384598e-11,
 -1.378923996256166e-13,  2.234022877997150e-16,  1.433863630984802e-18, -4.109194353470138e-21, -1.491699268665311e-23,  7.031204926809010e-26,  1.384567063722719e-28,
  1.165937424513849e+00, -2.834501054419899e-03, -7.221176755001605e-07,  1.582404409247268e-08,  2.200028117518602e-12, -1.605878174576636e-13,  4.151132420114151e-17,
  1.961419550436140e-18, -1.526994972737034e-21, -2.608426704825574e-23,  3.595583927064351e-26,  3.609835569237025e-28,  1.238532445730752e+00, -2.816864419562015e-03,
 -1.659979537598603e-06,  1.581202434096265e-08,  1.683397758203707e-11, -1.654186110600569e-13, -2.026209438675117e-16,  2.134710767983273e-18,  2.668267830640455e-21,
 -3.075013947221929e-23, -3.717352032777632e-26,  4.732272484676830e-28,  1.311586719765571e+00, -2.765622905133297e-03, -2.624373347361015e-06,  1.481020714880133e-08,
  3.234744708816502e-11, -1.456848944083564e-13, -4.715880723638018e-16,  1.738250401281717e-18,  7.508828735829077e-21, -2.268626348032457e-23, -1.262078353927332e-25,
  3.078364380794874e-28,  1.384656047375880e+00, -2.678127547020257e-03, -3.572500618522375e-06,  1.269522851436221e-08,  4.686917633746773e-11, -9.743226820701721e-14,
 -7.018001513702350e-16,  6.662608900526792e-19,  1.109322787300091e-20,  6.050708393136994e-25, -1.786113168770708e-25, -1.879576279713637e-28,  1.457222701805167e+00,
 -2.552474074336435e-03, -4.451391299446207e-06,  9.435656871066268e-09,  5.800657390764570e-11, -2.215552414106557e-14, -8.116620073073365e-16, -9.491872839325373e-19,
  1.104975573704340e-20,  3.291506311044542e-23, -1.330175535364423e-25, -7.839319615528817e-28,  1.528687780081493e+00, -2.387880241353850e-03, -5.199408246393073e-06,
  5.138454498738519e-09,  6.314477812037422e-11,  7.061689760013025e-14, -7.248792341739595e-16, -2.646687501020794e-18,  5.775611829343191e-21,  5.732351858170479e-23,
  2.844557511376245e-26, -9.644763460418646e-28,  1.598365117006395e+00, -2.185140200403247e-03, -5.749946380599011e-06,  9.204350883075642e-11,  6.001245660248256e-11,
  1.622254952523145e-13, -4.090089433372537e-16, -3.687058052981641e-18, -3.836946847235038e-21,  5.277329068454603e-23,  2.245071798035350e-25, -3.110556788321638e-28,
  1.665478212246813e+00, -1.947134517319897e-03, -6.038052368141396e-06, -5.210204037773687e-09,  4.749930234474314e-11,  2.271750448855080e-13,  8.226707303522619e-17,
 -3.349033973645803e-18, -1.338392253901339e-20,  1.114003607535907e-23,  2.885135025305299e-25,  8.581660458977904e-28,  1.729162109105422e+00, -1.679345293993514e-03,
 -6.010395472468561e-06, -1.008918791419021e-08,  2.655734996874115e-11,  2.404293607890816e-13,  5.907440213531650e-16, -1.441610981848820e-18, -1.646527717863262e-20,
 -4.559266681420019e-23,  1.096251604262353e-25,  1.377330755627286e-27,  1.788472593151029e+00, -1.390286262859830e-03, -5.638241659254464e-06, -1.376695745670378e-08,
  8.026339820805404e-13,  1.892509091042768e-13,  8.950058628752018e-16,  1.263725049289491e-18, -9.426956608664453e-21, -7.137338672066784e-23, -1.882327565066231e-25,
  4.243455994565812e-28,  1.842405260858528e+00, -1.091713601881476e-03, -4.931693553362548e-06, -1.553506708350841e-08, -2.373936527095359e-11,  8.501015635297656e-14,
  8.256023017528423e-16,  3.201914194367829e-18,  3.690044578367070e-21, -3.783849175457499e-23, -2.935198958116379e-25, -9.990825154273546e-28,  1.889926666251417e+00,
 -7.984499313404452e-04, -3.951597702108686e-06, -1.498688785116903e-08, -4.021434367406581e-11, -3.388717731187921e-14,  4.039856966077856e-16,  3.064629515731859e-18,
  1.236401135241386e-20,  2.360215315321986e-23, -8.057528355610291e-26, -9.954827100021350e-28,  1.930018579762610e+00, -5.276574311859320e-04, -2.813847060959149e-06,
 -1.224658466836096e-08, -4.373984442977355e-11, -1.163003747459760e-13, -1.155950571424547e-16,  1.087814556089579e-18,  9.448024329269246e-21,  4.667632438361009e-23,
  1.563229326121265e-25,  2.326340121355898e-28,  1.961734207929897e+00, -2.974663297573030e-04, -1.680580999903935e-06, -8.081047530952238e-09, -3.430407162796436e-11,
 -1.280416219334986e-13, -4.016421527661367e-16, -8.931076745529850e-19,  4.871955270968131e-23,  1.557943926474793e-23,  1.159836553376187e-25,  5.968591377136011e-28,
  1.984262326963068e+00, -1.250171984575094e-04, -7.354001122471510e-07, -3.780467637648098e-09, -1.782513171477579e-11, -7.845543459139577e-14, -3.237127612167673e-16,
 -1.245578391448609e-18, -4.393269905222273e-21, -1.361680019057905e-23, -3.270647288536226e-26, -2.469089313083406e-29,  1.996995047900979e+00, -2.416441282843647e-05,
 -1.453934560738793e-07, -7.751919473191131e-10, -3.859816218145811e-12, -1.836435390352223e-14, -8.448238842051695e-17, -3.782851163323555e-19, -1.655018814050530e-21,
 -7.089985260026583e-24, -2.976890625226554e-26, -1.225056620087331e-28,  3.426914873882071e-04, -1.427780415173006e-06,  4.460800846744813e-09, -1.238702016338013e-11,
  3.223808890525334e-14, -8.053655600334272e-17,  1.955073755564733e-19, -4.649387567963070e-22,  1.087279115344165e-24, -2.513157959466662e-27,  5.735840663913514e-30,
 -1.302808629076420e-32,  3.084199267423147e-03, -1.284096073730062e-05,  4.005388063534333e-08, -1.109025074812627e-10,  2.873287692742217e-13, -7.131377164817141e-16,
  1.715861364617466e-18, -4.033248641735772e-21,  9.292641847576973e-24, -2.108609682908682e-26,  4.703917360758291e-29, -1.039793665284958e-31,  8.567081184980348e-03,
 -3.561886607612709e-05,  1.107417580550713e-07, -3.048395421803957e-10,  7.825632800677400e-13, -1.916518679596304e-15,  4.526864573648400e-18, -1.038145712699301e-20,
  2.315898442695990e-23, -5.041896299632845e-26,  1.066253953736779e-28, -2.204080269951381e-31,  1.679104578070868e-02, -6.966401148927174e-05,  2.155252981474705e-07,
 -5.880248902989517e-10,  1.488344514399915e-12, -3.569598013690487e-15,  8.185333103882629e-18, -1.801835273154748e-20,  3.799550930264978e-23, -7.656767660160076e-26,
  1.450461196689526e-28, -2.556571070043644e-31,  2.775559479219638e-02, -1.148287262072206e-04,  3.528994320847434e-07, -9.512367158185131e-10,  2.361028735940080e-12,
 -5.497187182831692e-15,  1.206686308475131e-17, -2.491770641389382e-20,  4.773117257698409e-23, -8.262451366729734e-26,  1.185083136407064e-28, -1.049643506647920e-31,
  4.145994806035864e-02, -1.709134005308403e-04,  5.208456920076920e-07, -1.382254176010141e-09,  3.343857149515179e-12, -7.477792032619290e-15,  1.541369462984596e-17,
 -2.876107752933983e-20,  4.598872889122509e-23, -5.298135133396698e-26, -5.687308474850513e-30,  2.830678858224472e-31,  5.790294033356371e-02, -2.376641132524264e-04,
  7.168225663922907e-07, -1.865930349521301e-09,  4.368246802494580e-12, -9.254137622412542e-15,  1.739742408404309e-17, -2.724425505849855e-20,  2.737440364599581e-23,
  2.188573763136892e-26, -2.333764524164365e-28,  8.606361418084351e-31,  7.708288721116995e-02, -3.147696095883645e-04,  9.377539781259911e-07, -2.384294672668979e-09,
  5.355482597579957e-12, -1.054649534662605e-14,  1.719533812651005e-17, -1.843093183915686e-20, -1.114249350239369e-23,  1.408525068530547e-25, -5.310968101498962e-28,
  1.456226641209208e-30,  9.899741661564579e-02, -4.018575923252555e-04,  1.180016312647693e-06, -2.916693040040807e-09,  6.218862264919305e-12, -1.106887448916473e-14,
  1.407847452363113e-17, -1.131217515621681e-21, -6.892004115270871e-23,  2.886804529105775e-25, -8.209270440993107e-28,  1.786082264867784e-30,  1.236432612127107e-01,
 -4.984902819346281e-04,  1.439424586412971e-06, -3.439976001298961e-09,  6.866355425598297e-12, -1.054809341401327e-14,  7.508583772865046e-18,  2.472450039540471e-20,
 -1.405977766543382e-22,  4.346059898519740e-25, -9.862767246703428e-28,  1.511792759028190e-30,  1.510160060795858e-01, -6.041591950982286e-04,  1.711218559080226e-06,
 -3.928748114888063e-09,  7.203845599089150e-12, -8.745656357460600e-15, -2.760094308882572e-18,  5.775402672205020e-20, -2.155370524704834e-22,  5.339337061619219e-25,
 -8.913242505053483e-28,  3.455921111665513e-31,  1.811097846148562e-01, -7.182790858676775e-04,  1.990049871726536e-06, -4.355694550519639e-09,  7.139028916319949e-12,
 -5.482214412780644e-15, -1.657998311206988e-17,  9.488087411697793e-20, -2.779894070608140e-22,  5.334400440291515e-25, -4.148997662553905e-28, -1.807899817683945e-30,
  2.139169141456281e-01, -8.401809902585199e-04,  2.269971657493094e-06, -4.692004496522412e-09,  6.586043485170669e-12, -6.641635275912253e-16, -3.331811000321336e-17,
  1.312367914639270e-19, -3.082345751149826e-22,  3.810601273953658e-25,  5.033795510930711e-28, -4.701335626857676e-30,  2.494274608670647e-01, -9.691043144858787e-04,
  2.544432544434954e-06, -4.907914820440757e-09,  5.470895974136796e-12,  5.688397030167790e-15, -5.178329814042538e-17,  1.602735306807464e-19, -2.848974771065111e-22,
  3.974021187166642e-26,  1.811058562836863e-27, -7.631976290631104e-30,  2.876287215858042e-01, -1.104187910797600e-03,  2.806277582693512e-06, -4.973401683699163e-09,
  3.737732912639648e-12,  1.341358534220207e-14, -7.018613755918752e-17,  1.741532516444681e-19, -1.885713483284766e-22, -4.955724981226011e-25,  3.296345978143852e-27,
 -9.429336436071257e-30,  3.285046071623821e-01, -1.244460095125259e-03,  3.047759415436417e-06, -4.859052250062709e-09,  1.355967614085097e-12,  2.218140680665216e-14,
 -8.614865480981784e-17,  1.644857319847160e-19, -6.719714499450251e-24, -1.180103265623068e-24,  4.564167086336402e-27, -8.613312259227915e-30,  3.720349094787921e-01,
 -1.388827580652371e-03,  3.260564018018721e-06, -4.537152908125130e-09, -1.671788578541356e-12,  3.147187567141813e-14, -9.678399307505725e-17,  1.234679294559833e-19,
  2.604223026329450e-22, -1.904501246016850e-24,  5.056423205829963e-27, -3.781681373472238e-30,  4.181944301064371e-01, -1.536063335271622e-03,  3.435856601380773e-06,
 -3.983033935786867e-09, -5.301140768638253e-12,  4.056135097084566e-14, -9.886918028368184e-17,  4.545041036969321e-20,  5.936009199962273e-22, -2.488896178359701e-24,
  4.139649469837005e-27,  5.757085783254850e-30,  4.669519445206295e-01, -1.684793424908128e-03,  3.564354866610634e-06, -3.176712241483837e-09, -9.436970324453247e-12,
  4.852214437497211e-14, -8.913510433988382e-17, -7.110355290820505e-20,  9.491130537370243e-22, -2.693137755601785e-24,  1.278205487204198e-27,  1.917750422582098e-29,
  5.182689706025998e-01, -1.833482987362751e-03,  3.636438759188706e-06, -2.104872073872946e-09, -1.392465799940757e-11,  5.424194572284958e-14, -6.469535377378798e-17,
 -2.213978738760428e-19,  1.255980350816611e-21, -2.251382646351081e-24, -3.705169932709171e-27,  3.336858529941921e-29,  5.720983042000543e-01, -1.980421604449379e-03,
  3.642308242634793e-06, -7.632158412026219e-10, -1.854229650772349e-11,  5.647116572490206e-14, -2.362691284651719e-17, -3.921015642594012e-19,  1.418181539404293e-21,
 -9.379497378455899e-25, -1.031223432376794e-26,  4.259434710483646e-29,  6.283822776226754e-01, -2.123708519820100e-03,  3.572203398395810e-06,  8.408004266184188e-10,
 -2.299513898003685e-11,  5.390763336931509e-14,  3.430302929147778e-17, -5.596479936478968e-19,  1.324915381858862e-21,  1.333619580222086e-24, -1.707857717514239e-26,
  3.914470157239404e-29,  6.870506891313628e-01, -2.261238407605069e-03,  3.416704300028220e-06,  2.684865530159668e-09, -2.691408034025728e-11,  4.532867696401364e-14,
  1.068037224711015e-16, -6.897743578832134e-19,  8.718826697040186e-22,  4.387183832159517e-24, -2.146112995252122e-26,  1.558541491506687e-29,  7.480183428576538e-01,
 -2.390688761420529e-03,  3.167131415412342e-06,  4.728420531735737e-09, -2.986065336390309e-11,  2.977954917459215e-14,  1.882152130311812e-16, -7.393133962128340e-19,
 -4.497613727520879e-24,  7.663711468809008e-24, -2.012307671490854e-26, -3.105435413731982e-29,  8.111821294851019e-01, -2.509510481294763e-03,  2.816070346623710e-06,
  6.909140874681108e-09, -3.134180944254935e-11,  6.822973601495767e-15,  2.688252075636481e-16, -6.614546790074376e-19, -1.281021611753769e-21,  1.015769963809717e-23,
 -9.858664940052682e-27, -9.366090359484628e-29,  8.764175691019387e-01, -2.614923933520424e-03,  2.358046732947124e-06,  9.139597271120643e-09, -3.083854666051617e-11,
 -2.315484344532923e-14,  3.346301968129981e-16, -4.156601715079448e-19, -2.796750593126952e-21,  1.049291719388583e-23,  1.069860599647222e-26, -1.500921217265733e-28,
  9.435747301117281e-01, -2.703923699326098e-03,  1.790376725558392e-06,  1.130460107764124e-08, -2.785302153474654e-11, -5.860390524768385e-14,  3.679451651428602e-16,
  1.713887569972109e-20, -4.213541960746125e-21,  7.237234578044049e-24,  3.877009938651727e-26, -1.632114275002707e-28,  1.012473434051649e+00, -2.773296469981472e-03,
  1.114213276893285e-06,  1.326001910747518e-08, -2.197870759120711e-11, -9.648672418123034e-14,  3.493701871210145e-16,  6.149294074383018e-19, -5.016578435947400e-21,
 -4.679510558300929e-25,  6.536305574962118e-26, -9.186809720109763e-29,  1.082897659024976e+00, -2.819658137499351e-03,  3.357949200051478e-07,  1.483420522211506e-08,
 -1.299670785124261e-11, -1.320643019003112e-13,  2.616327538282045e-16,  1.294330972476882e-18, -4.594261895313877e-21, -1.199901508891121e-23,  7.518035279413759e-26,
  8.268657212375369e-29,  1.154589069564260e+00, -2.839518086949349e-03, -5.321237055496319e-07,  1.583362318469200e-08, -9.973491941332830e-13, -1.589388873076595e-13,
  9.560796548722247e-17,  1.897839149118049e-18, -2.436415613295481e-21, -2.433985983405239e-23,  5.095897282476242e-26,  3.190688467751454e-28,  1.227239636224462e+00,
 -2.829380952903875e-03, -1.468729159896150e-06,  1.605465726963593e-08,  1.348186334825609e-11, -1.695556345552687e-13, -1.418218863058872e-16,  2.202137398654502e-18,
  1.539574029125009e-21, -3.181453773012302e-23, -1.593015150207150e-26,  4.891782928860268e-28,  1.300483375871760e+00, -2.785898428815662e-03, -2.443643604303721e-06,
  1.530385879489753e-08,  2.932464741257760e-11, -1.563925928660509e-13, -4.196826679771745e-16,  1.964519621903129e-18,  6.604793720142344e-21, -2.743356376571992e-23,
 -1.104346804698386e-25,  4.069531388528815e-28,  1.373887359810331e+00, -2.706085586592061e-03, -3.415725686054840e-06,  1.342863808970677e-08,  4.475381723165017e-11,
 -1.140115245952311e-13, -6.781817181165487e-16,  1.020200106201405e-18,  1.098479238809013e-20, -6.663391370489240e-24, -1.837648036327978e-25, -4.431443604315249e-29,
  1.446942322578364e+00, -2.587616556008783e-03, -4.332612859934460e-06,  1.035915045870672e-08,  5.736672279126755e-11, -4.191332680612776e-14, -8.331185313705833e-16,
 -5.777293448063088e-19,  1.213077455385207e-20,  2.692285671878277e-23, -1.660668728742203e-25, -7.117334536530752e-28,  1.519053483487902e+00, -2.429211585056381e-03,
 -5.131641416333834e-06,  6.159099613512696e-09,  6.437725841696666e-11,  5.235330615615737e-14, -7.960877012836798e-16, -2.428715196337251e-18,  7.849177972315568e-21,
  5.757638664478274e-23, -1.663741701009717e-26, -1.078983499014946e-27,  1.589532587423304e+00, -2.231118787028989e-03, -5.742975417944483e-06,  1.077630218723651e-09,
  6.315037808116747e-11,  1.511583713780464e-13, -5.136677320554200e-16, -3.777740979545805e-18, -1.779443031759085e-21,  6.140472663503544e-23,  2.051703743902554e-25,
 -5.709444794383247e-28,  1.657592688059808e+00, -1.995675760407375e-03, -6.095864689742983e-06, -4.413792664779079e-09,  5.205470348045520e-11,  2.279762349414078e-13,
 -1.742528905325077e-17, -3.768603908475788e-18, -1.276640031531842e-20,  2.339649859428569e-23,  3.232157194710515e-25,  7.078870287213848e-28,  1.722347805509666e+00,
 -1.727905144809094e-03, -6.128755083280500e-06, -9.625046101163621e-09,  3.150413215699322e-11,  2.540618142290240e-13,  5.427624588656642e-16, -1.993793065430790e-18,
 -1.801257568581083e-20, -3.994089313775337e-23,  1.742600416578188e-25,  1.555033011541565e-27,  1.782820190641367e+00, -1.436052496474342e-03, -5.803239378439548e-06,
 -1.372265669341357e-08,  4.805133267904629e-12,  2.111191484379069e-13,  9.257704920073005e-16,  9.195400199915992e-19, -1.212661693928962e-20, -7.843955966234186e-23,
 -1.627521886979429e-25,  7.433480155733173e-28,  1.837958309752491e+00, -1.131919154273546e-03, -5.120333659554078e-06, -1.590018801207448e-08, -2.183369233355919e-11,
  1.059124561645532e-13,  9.166876043627102e-16,  3.295848806932828e-18,  2.105952588593516e-21, -5.045522602275039e-23, -3.371319950902962e-25, -9.734064508902221e-28,
  1.886668486453619e+00, -8.307930698134451e-04, -4.135321510741952e-06, -1.563518251153067e-08, -4.078794577120812e-11, -2.311633614993180e-14,  4.954571825080220e-16,
  3.473160637818516e-18,  1.314445176642471e-20,  1.942941780267768e-23, -1.299442355441997e-25, -1.253928047374493e-27,  1.927861980714122e+00, -5.507681186772811e-04,
 -2.965082318745468e-06, -1.296516998419446e-08, -4.609094426300592e-11, -1.186733901102409e-13, -8.064220861421889e-17,  1.418262458381518e-18,  1.124319429731097e-20,
  5.311174291307025e-23,  1.648240156991004e-25,  1.467634086347968e-28,  1.960516825721560e+00, -3.113083968136556e-04, -1.780932988367325e-06, -8.650931570130330e-09,
 -3.696332052110528e-11, -1.379803900513185e-13, -4.265363338304822e-16, -8.816260317077766e-19,  6.997374423685951e-22,  2.077951249290052e-23,  1.449319544738160e-25,
  7.220871119626427e-28,  1.983750197446299e+00, -1.310868322927275e-04, -7.825301175939259e-07, -4.078656885664375e-09, -1.947484049763667e-11, -8.665940328700999e-14,
 -3.606326460276304e-16, -1.394260582666671e-18, -4.907232446202790e-21, -1.494085990011039e-23, -3.333244146890721e-26, -2.111249285322670e-30,  1.996896003519884e+00,
 -2.536584820839020e-05, -1.550787892317357e-07, -8.400011805148442e-10, -4.248268980654390e-12, -2.052526389945183e-14, -9.585589277148518e-17, -4.355703420578589e-19,
 -1.933057229813197e-21, -8.395900038793617e-24, -3.571831416282791e-26, -1.488145981919944e-28,  3.370508093476215e-04, -1.392679937387626e-06,  4.315199121089332e-09,
 -1.188384600477710e-11,  3.067324504422193e-14, -7.599674885285343e-17,  1.829628995244591e-19, -4.315502204950490e-22,  1.000800745541313e-24, -2.294789170057603e-27,
  5.192213305368257e-30, -1.170772027249188e-32,  3.033467966896743e-03, -1.252577592877248e-05,  3.875017058084711e-08, -1.064171495251346e-10,  2.734688449952179e-13,
 -6.732793017244570e-16,  1.606981926364366e-18, -3.747675314314092e-21,  8.566336247739751e-24, -1.929294262489187e-26,  4.269288604057576e-29, -9.376909782175747e-32,
  8.426354717710830e-03, -3.474735432774042e-05,  1.071575635764786e-07, -2.926193670026775e-10,  7.452962346125735e-13, -1.811280004705627e-15,  4.246291892265810e-18,
 -9.668606406937229e-21,  2.141838976874338e-23, -4.634190233707644e-26,  9.737254154432566e-29, -2.005096312574009e-31,  1.651579401408744e-02, -6.796763482640293e-05,
  2.086095587146101e-07, -5.647720091714874e-10,  1.418876867843195e-12, -3.379069301405605e-15,  7.697434688789282e-18, -1.684550133960124e-20,  3.534084417457154e-23,
 -7.098544378431580e-26,  1.341962225163369e-28, -2.377118980055933e-31,  2.730185488003648e-02, -1.120505561677450e-04,  3.417076724397000e-07, -9.143243049495069e-10,
  2.253925406521244e-12, -5.215784938171205e-15,  1.139011017638728e-17, -2.343699488126100e-20,  4.484088491224129e-23, -7.797850368073773e-26,  1.137483129719082e-28,
 -1.109967441699295e-31,  4.078452420720852e-02, -1.668120849030889e-04,  5.045747812056482e-07, -1.329929079721516e-09,  3.197936217405023e-12, -7.117362551665676e-15,
  1.462870049770488e-17, -2.731997599345909e-20,  4.408015770885499e-23, -5.297602514198891e-26,  5.565643781702045e-30,  2.297795533640353e-31,  5.696361288995530e-02,
 -2.320179231351135e-04,  6.948447189425916e-07, -1.797496634035701e-09,  4.187278156289395e-12, -8.845653862861754e-15,  1.664695469482412e-17, -2.635739758154078e-20,
  2.800307793926206e-23,  1.327447026714903e-26, -1.979934282219936e-28,  7.498775993232310e-31,  7.583863366562396e-02, -3.073805831022460e-04,  9.096496798484682e-07,
 -2.300272143771012e-09,  5.148637581571637e-12, -1.014003577416070e-14,  1.667501397259660e-17, -1.871033805162041e-20, -6.439164647181959e-24,  1.208448896851608e-25,
 -4.703790224071756e-28,  1.305873438045192e-30,  9.740864720468734e-02, -3.925557882649475e-04,  1.145605760914994e-06, -2.818943920521656e-09,  6.000859795378543e-12,
 -1.073161102470557e-14,  1.401744228809028e-17, -3.176565125176106e-21, -5.910003662523411e-23,  2.573752054730071e-25, -7.453166097559231e-28,  1.651372667756913e-30,
  1.216720720558023e-01, -4.871381524110681e-04,  1.398797115114359e-06, -3.331791991829380e-09,  6.657249125465361e-12, -1.036007418516467e-14,  8.140180534472747e-18,
  2.046822022089500e-20, -1.256461156069136e-22,  3.964777484870007e-25, -9.203544290584261e-28,  1.481784369921841e-30,  1.486264529600056e-01, -5.906560804032062e-04,
  1.664759368556282e-06, -3.814888953461407e-09,  7.028397081956518e-12, -8.793255134319514e-15, -1.236701380529841e-18,  5.115753894537305e-20, -1.969530195704464e-22,
  4.986399973031453e-25, -8.720825399949418e-28,  5.212715588079596e-31,  1.782681807667764e-01, -7.025658268854447e-04,  1.938463198025906e-06, -4.242367977055408e-09,
  7.025615501743146e-12, -5.849241617325575e-15, -1.404499460947464e-17,  8.628912433905865e-20, -2.591021921202688e-22,  5.153917535832749e-25, -4.842180030348610e-28,
 -1.355127066245581e-30,  2.105921556661338e-01, -8.222446430962580e-04,  2.214299287991593e-06, -4.586776284254176e-09,  6.565055807236725e-12, -1.420804377215282e-15,
 -2.977948120750342e-17,  1.215962702522210e-19, -2.942018465311494e-22,  3.972748490197165e-25,  3.125741079345404e-28, -3.984907916723999e-30,  2.455913836399859e-01,
 -9.489829377429199e-04,  2.486066312337035e-06, -4.819536359459085e-09,  5.572594106768430e-12,  4.498421397625037e-15, -4.742296232771070e-17,  1.511930411590154e-19,
 -2.822415414506264e-22,  1.057134739063262e-25,  1.493636319497744e-27, -6.803939249551256e-30,  2.832564938668401e-01, -1.081975376951304e-03,  2.746964145848916e-06,
 -4.911541660696635e-09,  3.989551335319149e-12,  1.178693606453587e-14, -6.539683173245783e-17,  1.678581657060022e-19, -2.041369458049682e-22, -3.718365858731094e-25,
  2.894980727516037e-27, -8.807605912563792e-30,  3.235751622087902e-01, -1.220310852492922e-03,  2.989595241439670e-06, -4.833918516017645e-09,  1.779292839075911e-12,
  2.016904398507874e-14, -8.155220455568463e-17,  1.636254540143899e-19, -4.600881028181941e-23, -1.005140371763142e-24,  4.183708714372083e-27, -8.650862212159274e-30,
  3.665314227769270e-01, -1.362961259551106e-03,  3.205978057290724e-06, -4.558991040042295e-09, -1.065294595191254e-12,  2.919142478476745e-14, -9.322025270979926e-17,
  1.307431381230971e-19,  1.954573985485487e-22, -1.705939070327666e-24,  4.863195293530730e-27, -4.948071973839230e-30,  4.121048458049882e-01, -1.508769049181847e-03,
  3.387577638778692e-06, -4.061490827084587e-09, -4.513528524869211e-12,  3.820582680616951e-14, -9.734387500520987e-17,  6.304444172296053e-20,  5.070350672369192e-22,
 -2.319027472157614e-24,  4.335121220328546e-27,  3.194124238827481e-30,  4.602695555412192e-01, -1.656433562023370e-03,  3.525360016966884e-06, -3.320057072054975e-09,
 -8.488063766568308e-12,  4.636235387771775e-14, -9.071529685527670e-17, -4.227173183048159e-20,  8.532735122107256e-22, -2.626254606074589e-24,  2.038754002416294e-27,
  1.544380843737749e-29,  5.109930564639477e-01, -1.804496216766240e-03,  3.609879047980872e-06, -2.319074280256408e-09, -1.285582494976864e-11,  5.261933332879937e-14,
 -7.034418716407617e-17, -1.825290997136812e-19,  1.172606255195426e-21, -2.371372355075948e-24, -2.322799354890642e-27,  2.945963132326274e-29,  5.642348297023870e-01,
 -1.951324730755483e-03,  3.631406753266745e-06, -1.050891649277034e-09, -1.741940657815228e-11,  5.577746787934611e-14, -3.397603402570901e-17, -3.473359940138682e-19,
  1.377436774147929e-21, -1.313562811901505e-24, -8.484639299221921e-27,  4.037035221663148e-29,  6.199446539768335e-01, -2.095096706686140e-03,  3.580121179758244e-06,
  4.815429142944200e-10, -2.190999793589950e-11,  5.454769497235341e-14,  1.923274482113203e-17, -5.166109732875712e-19,  1.361050311068838e-21,  6.855751013662879e-25,
 -1.531001380172856e-26,  4.101945790886043e-29,  6.780605965764553e-01, -2.233783150517183e-03,  3.446369284941287e-06,  2.261625596964275e-09, -2.598342142426447e-11,
  4.766349489467470e-14,  8.790321462138765e-17, -6.595112816784276e-19,  1.014557434148335e-21,  3.544942590475536e-24, -2.059256671243148e-26,  2.359961544833255e-29,
  7.385066098697320e-01, -2.365132821184881e-03,  3.221026269369040e-06,  4.255653203072605e-09, -2.922156651476587e-11,  3.404853803302664e-14,  1.675527772331798e-16,
 -7.352007860406479e-19,  2.566173467685419e-22,  6.835753866478291e-24, -2.117098788168624e-26, -1.680481040303399e-29,  8.011896577614241e-01, -2.486658792115136e-03,
  2.895976844696662e-06,  6.409107771359454e-09, -3.114235461636495e-11,  1.304823260721023e-14,  2.497849644755393e-16, -6.966804112455418e-19, -9.233910682128593e-22,
  9.685855272137609e-24, -1.361098506474177e-26, -7.684262686451376e-29,  8.659962848401188e-01, -2.595629279453269e-03,  2.464747519762103e-06,  8.642907972843997e-09,
 -3.122232577426047e-11, -1.527314191696267e-14,  3.217960702966093e-16, -4.990424202799180e-19, -2.412867369705501e-21,  1.079176996844474e-23,  4.324005203138656e-27,
 -1.391250408784257e-28,  9.327885296826384e-01, -2.689065726652758e-03,  1.923320923838542e-06,  1.085005580097227e-08, -2.893683161234606e-11, -4.978244770016108e-14,
  3.665786065803942e-16, -1.132407109356868e-19, -3.926839969843906e-21,  8.642058615278102e-24,  3.142395296665442e-26, -1.696917707875524e-28,  1.001399074716185e+00,
 -2.763752404729850e-03,  1.271161359965769e-06,  1.289338301661645e-08, -2.382329232085966e-11, -8.791336108945648e-14,  3.643417995912556e-16,  4.546254385201358e-19,
 -4.987430537217095e-21,  2.055592878159946e-24,  6.057485969238401e-26, -1.247093028150098e-28,  1.071625521340768e+00, -2.816263469854426e-03,  5.124716743522044e-07,
  1.460548079554209e-08, -1.557235396089777e-11, -1.253672116795345e-13,  2.957550273628205e-16,  1.140989683383931e-18, -4.971369443662827e-21, -8.935457978923364e-24,
  7.759347632766957e-26,  2.725006177859667e-29,  1.143223685892170e+00, -2.843015574647960e-03, -3.423204197108519e-07,  1.579237794710347e-08, -4.148925643463281e-12,
 -1.560162271726961e-13,  1.475271797308916e-16,  1.806274086381038e-18, -3.272709461242558e-21, -2.203543445832874e-23,  6.388153098248645e-26,  2.668337992044815e-28,
  1.215899837736101e+00, -2.840356754388909e-03, -1.274891462060082e-06,  1.624307429685811e-08,  1.006173212015298e-11, -1.722149361930227e-13, -7.964512293068590e-17,
  2.232997762947859e-18,  3.879740695560451e-22, -3.202089889773450e-23,  5.586219382169748e-27,  4.856341842674758e-28,  1.289301857894987e+00, -2.804705257301579e-03,
 -2.257287072354872e-06,  1.574750219237053e-08,  2.610064669528774e-11, -1.657819575049235e-13, -3.618715091340561e-16,  2.159255328846533e-18,  5.542225559484094e-21,
 -3.146696226777897e-23, -9.062656264206310e-26,  4.904560539801120e-28,  1.363009403379293e+00, -2.732754823405870e-03, -3.250363746519380e-06,  1.412558339611218e-08,
  4.231334109957844e-11, -1.299056500022870e-13, -6.447411139260993e-16,  1.366455519727469e-18,  1.061253318756196e-20, -1.400858626408355e-23, -1.823866238791305e-25,
  1.077349375447136e-28,  1.436523343779911e+00, -2.621764686708141e-03, -4.202827044034407e-06,  1.126922080471674e-08,  5.632742784597484e-11, -6.205757549697085e-14,
 -8.437241461357850e-16, -1.753785421715380e-19,  1.297315030770265e-20,  1.968386668100020e-23, -1.950709703473884e-25, -6.003413064530323e-28,  1.509255023793735e+00,
 -2.469951496271375e-03, -5.051520875549133e-06,  7.196451592538166e-09,  6.522790995418910e-11,  3.246144394706706e-14, -8.602651529875066e-16, -2.144600370236611e-18,
  9.898272900928009e-21,  5.593624631560857e-23, -6.591215110177745e-26, -1.153324766857340e-27,  1.580516331115363e+00, -2.276993461989206e-03, -5.723883922718481e-06,
  2.111515731566807e-09,  6.604167295196986e-11,  1.375566882647108e-13, -6.198983629570240e-16, -3.797784011126698e-18,  5.720715338067277e-22,  6.902949644057953e-23,
  1.740865940773422e-25, -8.427657825802227e-28,  1.649512136180364e+00, -2.044640034899087e-03, -6.143682659480273e-06, -3.544500630863949e-09,  5.660126396988573e-11,
  2.262464827037267e-13, -1.285207982890291e-16, -4.161099665315762e-18, -1.168443982058631e-20,  3.688827314379835e-23,  3.497642010202448e-25,  4.869790158134304e-28,
  1.715337405957992e+00, -1.777388227891057e-03, -6.241061321100962e-06, -9.079642503380850e-09,  3.671076743810531e-11,  2.663517881648907e-13,  4.786608385909753e-16,
 -2.591719663017028e-18, -1.930809072675665e-20, -3.155882019806958e-23,  2.458193675262008e-25,  1.688656877727123e-27,  1.776982088181688e+00, -1.483135463242521e-03,
 -5.967306694928105e-06, -1.361078036138661e-08,  9.251548818918799e-12,  2.336001034111029e-13,  9.456518167573440e-16,  4.851209104822905e-19, -1.505877880043970e-20,
 -8.418915876739656e-23, -1.220012150171331e-25,  1.117569821776022e-27,  1.833347491220639e+00, -1.173650802429508e-03, -5.313158089840839e-06, -1.623135424472730e-08,
 -1.948793131164793e-11,  1.290262055466897e-13,  1.009622738980513e-15,  3.331491876363636e-18,  3.670098808915203e-23, -6.477476200060533e-23, -3.781520877369074e-25,
 -8.779617234877816e-28,  1.883277945052918e+00, -8.646372557528455e-04, -4.326872415225384e-06, -1.629080825397023e-08, -4.112323739547703e-11, -1.001024378604795e-14,
  5.986917454341870e-16,  3.903858426931849e-18,  1.373630278866340e-20,  1.304525810337580e-23, -1.913656053475223e-25, -1.542384266746588e-27,  1.925610463631874e+00,
 -5.751238231199960e-04, -3.125167715572311e-06, -1.372170373588990e-08, -4.848033179958625e-11, -1.200897990633402e-13, -3.559733295280289e-17,  1.809920048997719e-18,
  1.327512829857678e-20,  5.979813405139171e-23,  1.685130581367147e-25,  1.162763941229117e-29,  1.959242425260662e+00, -3.259813728444031e-04, -1.888385537528960e-06,
 -9.264986102555945e-09, -3.982728040947163e-11, -1.485102253637547e-13, -4.507875726995818e-16, -8.460819802402564e-19,  1.560179767664294e-21,  2.725334255557497e-23,
  1.798120105654760e-25,  8.665915028487696e-28,  1.983213012001388e+00, -1.375482807653962e-04, -8.334023404782286e-07, -4.404603702183667e-09, -2.129783643026935e-11,
 -9.580130908764345e-14, -4.019530755060048e-16, -1.560154935449896e-18, -5.469043600628827e-21, -1.626687340752506e-23, -3.271787664107214e-26,  3.233358498696696e-29,
  1.996791993352817e+00, -2.664798613967408e-05, -1.655806004303152e-07, -9.113867985760487e-10, -4.682804893503604e-12, -2.297943636247356e-14, -1.089653533185710e-16,
 -5.025532968257111e-19, -2.262686317776129e-21, -9.964628714153243e-24, -4.295361485839780e-26, -1.811712872070858e-28,  3.315482412398687e-04, -1.358720539889621e-06,
  4.175488204466441e-09, -1.140499902447874e-11,  2.919626079133172e-14, -7.174709616818227e-17,  1.713157127348847e-19, -4.008072974374371e-22,  9.218058376370258e-25,
 -2.097047668313604e-27,  4.703416425428742e-30, -1.053291072879864e-32,  2.983976881887304e-03, -1.222080921372216e-05,  3.749898012305688e-08, -1.021473123177372e-10,
  2.603805923021006e-13, -6.359406086990491e-16,  1.505782626692790e-18, -3.484343603764612e-21,  7.901560125886045e-24, -1.766498433157032e-26,  3.877145155652851e-29,
 -8.464740105641578e-32,  8.289057864953916e-03, -3.390393954579131e-05,  1.037165018543151e-07, -2.809789855562210e-10,  7.100682099952243e-13, -1.712541717209238e-15,
  3.984920810159482e-18, -9.009176083529508e-21,  1.981811292907955e-23, -4.261802608636156e-26,  8.895213765782025e-29, -1.825388985194784e-31,  1.624721884320681e-02,
 -6.632548655037785e-05,  2.019663086793746e-07, -5.426007510193058e-10,  1.353105311106308e-12, -3.199865489553774e-15,  7.241216445403237e-18, -1.575446610291770e-20,
  3.287951467475045e-23, -6.582175752843609e-26,  1.241103185675376e-28, -2.209298934886531e-31,  2.685905134465250e-02, -1.093601771197465e-04,  3.309487627104056e-07,
 -8.790813915675395e-10,  2.152291006188659e-12, -4.950137542297693e-15,  1.075354722147616e-17, -2.204613367713554e-20,  4.211436869192451e-23, -7.352752282339588e-26,
  1.087727473265435e-28, -1.148461975741520e-31,  4.012524920338427e-02, -1.628384641063556e-04,  4.889179977544145e-07, -1.279882059666895e-09,  3.059038709084835e-12,
 -6.775295617988661e-15,  1.388320279099638e-17, -2.593986324043964e-20,  4.217933660093757e-23, -5.256515467829325e-26,  1.464520937748907e-29,  1.840867163753633e-31,
  5.604652369353801e-02, -2.265443195879471e-04,  6.736709695411423e-07, -1.731894029619733e-09,  4.014301094582522e-12, -8.454881388164686e-15,  1.592155425026756e-17,
 -2.545511876281303e-20,  2.834608272849594e-23,  5.984860032347864e-27, -1.672021600365998e-28,  6.516750639849629e-31,  7.462349286434269e-02, -3.002124135694066e-04,
  8.825340608551031e-07, -2.219494782462609e-09,  4.949796330654023e-12, -9.746141503730406e-15,  1.614886852294062e-17, -1.885030609446880e-20, -2.413952264579216e-24,
  1.031375359212604e-25, -4.159896323669232e-28,  1.168426393781635e-30,  9.585654178703763e-02, -3.835246354454066e-04,  1.112347492663842e-06, -2.724628976792870e-09,
  5.789583487714460e-12, -1.039646508231430e-14,  1.390337435229922e-17, -4.925132223992184e-21, -5.035399928911650e-23,  2.289770180230603e-25, -6.755427053651186e-28,
  1.520959281485911e-30,  1.197456495195186e-01, -4.761059064114133e-04,  1.359447904376717e-06, -3.226922816046291e-09,  6.452045413989401e-12, -1.015827392914196e-14,
  8.659097057245436e-18,  1.666893737481943e-20, -1.120199700070191e-22,  3.609551530528044e-25, -8.561066315100672e-28,  1.436357589156580e-30,  1.462901775380017e-01,
 -5.775192217743743e-04,  1.619649619762722e-06, -3.703842659213332e-09,  6.852347585092228e-12, -8.806442869267624e-15,  1.101256699222935e-19,  4.513557390457272e-20,
 -1.796239653036826e-22,  4.642572530896254e-25, -8.460922389561230e-28,  6.535187582369632e-31,  1.754886131364063e-01, -6.872598530025454e-04,  1.888225323768335e-06,
 -4.130911517524727e-09,  6.905450804577580e-12, -6.158248248113931e-15, -1.174221490159270e-17,  7.829087217619534e-20, -2.409100173746176e-22,  4.949480008642563e-25,
 -5.351825556306091e-28, -9.723406572311464e-31,  2.073382598051822e-01, -8.047486307650343e-04,  2.159887157535879e-06, -4.482000413855320e-09,  6.529762982864644e-12,
 -2.095706120319491e-15, -2.650442274096884e-17,  1.124127232694425e-19, -2.797153844691258e-22,  4.064644060342279e-25,  1.515490811597933e-28, -3.347036095086015e-30,
  2.418348648136419e-01, -9.293242228009758e-04,  2.428769617590044e-06, -4.729715524824831e-09,  5.651518671427240e-12,  3.410054492644158e-15, -4.331535037740174e-17,
  1.422331621044515e-19, -2.774304598187669e-22,  1.597043694465218e-25,  1.211578038531368e-27, -6.025588954151120e-30,  2.789721720631227e-01, -1.060234315256283e-03,
  2.688416150324359e-06, -4.845906622451082e-09,  4.209971654765866e-12,  1.027306269914429e-14, -6.079011381881169e-17,  1.611332081718157e-19, -2.155303407067385e-22,
 -2.635975134087826e-25,  2.521727003991337e-27, -8.155184830824863e-30,  3.187413856676806e-01, -1.196625604708764e-03,  2.931772002700635e-06, -4.802327573325385e-09,
  2.163471294665721e-12,  1.826657056176849e-14, -7.699651764467909e-17,  1.616057662562989e-19, -7.927311375686170e-23, -8.453792786712274e-25,  3.805235836492862e-27,
 -8.529240212204210e-30,  3.611305265527594e-01, -1.337532512835400e-03,  3.151186772537030e-06, -4.571485428132611e-09, -5.035390179510710e-13,  2.699871977315938e-14,
 -8.948084734964067e-17,  1.360522551360536e-19,  1.374900836563529e-22, -1.516040408351867e-24,  4.625448938326249e-27, -5.812192722518430e-30,  4.061236605195129e-01,
 -1.481864550059807e-03,  3.338431256497639e-06, -4.127720655413864e-09, -3.772622381449149e-12,  3.589251423971997e-14, -9.536378950582105e-17,  7.796750562398092e-20,
  4.266991126867568e-22, -2.143478895503875e-24,  4.426482941675303e-27,  1.020980875931782e-30,  4.536999715615830e-01, -1.628392283679976e-03,  3.484734692984406e-06,
 -3.448566756476065e-09, -7.582668655131173e-12,  4.417398212305782e-14, -9.153073249689553e-17, -1.646269575067710e-20,  7.603506121386158e-22, -2.532141904476749e-24,
  2.642044049833420e-27,  1.203400555666804e-29,  5.038326485800566e-01, -1.775731917355122e-03,  3.580850424482244e-06, -2.516441777348127e-09, -1.182071328731426e-11,
  5.087390374264028e-14, -7.494262172189486e-17, -1.463870755865728e-19,  1.085866337163429e-21, -2.439510970486450e-24, -1.112516396009150e-27,  2.556387822187149e-29,
  5.564875468419958e-01, -1.922328573129251e-03,  3.617160451237498e-06, -1.320725282025174e-09, -1.631277367889885e-11,  5.485027302911476e-14, -4.309190628274837e-17,
 -3.040767027091560e-19,  1.324460572947218e-21, -1.618207883721073e-24, -6.767930068513668e-27,  3.758371118119825e-29,  6.116215773822768e-01, -2.066438499656247e-03,
  3.583832404421348e-06,  1.397308286741376e-10, -2.081557433440854e-11,  5.484063978599430e-14,  5.380276313019083e-18, -4.727771176194119e-19,  1.375145330624382e-21,
  1.095352988495098e-25, -1.348759510465550e-26,  4.162408008909594e-29,  6.691807678852754e-01, -2.206110632537295e-03,  3.471046195864802e-06,  1.853625428061462e-09,
 -2.501053108654053e-11,  4.955535718241215e-14,  6.990948463667028e-17, -6.251603802821394e-19,  1.127617096416906e-21,  2.743973829851901e-24, -1.941032343035106e-26,
  2.985481977823376e-29,  7.290979272838434e-01, -2.339168234803659e-03,  3.269311998120911e-06,  3.793767414180570e-09, -2.850204478376327e-11,  3.782392666051799e-14,
  1.471179424194231e-16, -7.232162892015092e-19,  4.873186181802603e-22,  5.977996360607592e-24, -2.162395547764249e-26, -4.048049132691206e-30,  7.912898333847791e-01,
 -2.463191788988659e-03,  2.969906120577282e-06,  5.913236845926830e-09, -3.082303754722829e-11,  1.880596642964524e-14,  2.299158676236982e-16, -7.207612648029455e-19,
 -5.852696786618913e-22,  9.078772337198591e-24, -1.662035357328835e-26, -5.998995583130728e-29,  8.556538485270522e-01, -2.575504952698214e-03,  2.565456337805924e-06,
  8.141321776576131e-09, -3.145173294887653e-11, -7.726079532849526e-15,  3.068004927698525e-16, -5.700164798933374e-19, -2.022690587855460e-21,  1.084618694350618e-23,
 -1.502475281385854e-27, -1.253147836222631e-28,  9.220638533074467e-01, -2.673166299971845e-03,  2.050712346075585e-06,  1.037957799229341e-08, -2.984483066518954e-11,
 -4.103651369421044e-14,  3.616970579548241e-16, -2.336938184941856e-19, -3.594906065762335e-21,  9.749105250213327e-24,  2.392414180810101e-26, -1.702834869883127e-28,
  9.903653742557249e-01, -2.752970841922270e-03,  1.423538447310690e-06,  1.249862330802461e-08, -2.549317927518844e-11, -7.903435347941552e-14,  3.748513372667721e-16,
  2.966680884605917e-19, -4.871213088811801e-21,  4.360663398250183e-24,  5.448883678469530e-26, -1.507668795684597e-28,  1.060369770796881e+00, -2.811467057061623e-03,
  6.861610337209755e-07,  1.433666057806316e-08, -1.800622331143237e-11, -1.179039707332968e-13,  3.254314859369649e-16,  9.773594532801957e-19, -5.237034069646709e-21,
 -5.823550842992461e-24,  7.761681513807357e-26, -2.558785097399407e-29,  1.131847344783420e+00, -2.844997468182301e-03, -1.533124823103691e-07,  1.570124188951311e-08,
 -7.229811238990839e-12, -1.518812156885007e-13,  1.965210686010916e-16,  1.689370086048872e-18, -4.017316246580135e-21, -1.926251444775796e-23,  7.432846470452388e-26,
  2.070182328271430e-28,  1.204519250446664e+00, -2.849773744063864e-03, -1.079122584377363e-06,  1.637642503351052e-08,  6.603385745167503e-12, -1.733757915523676e-13,
 -1.712012214136248e-17,  2.227053525967781e-18, -7.556523244803033e-22, -3.137538277651963e-23,  2.652538356294835e-26,  4.631137589724809e-28,  1.278048126769475e+00,
 -2.822000829350162e-03, -2.065922271596114e-06,  1.613813644887013e-08,  2.270315461778084e-11, -1.737223939083413e-13, -2.991044795302313e-16,  2.317825393663674e-18,
  4.349552021880299e-21, -3.464013832758931e-23, -6.756876123621703e-26,  5.540406102532699e-28,  1.352027467791256e+00, -2.758068398997701e-03, -3.076883088943710e-06,
  1.478098489989828e-08,  3.956378552048366e-11, -1.448824488040734e-13, -6.018117305218719e-16,  1.696591590958066e-18,  9.978459892235215e-21, -2.116404996090047e-23,
 -1.742725895616863e-25,  2.605546433499551e-28,  1.425969917757514e+00, -2.654831160881795e-03, -4.062233485708246e-06,  1.215942940411068e-08,  5.488362980307874e-11,
 -8.231837159527173e-14, -8.427272691077132e-16,  2.495449624558567e-19,  1.353532089441120e-20,  1.139368897567380e-23, -2.183626663962581e-25, -4.528004968023873e-28,
  1.499294965508231e+00, -2.510000449653255e-03, -4.958883840473663e-06,  8.244150448054402e-09,  6.566600404321932e-11,  1.113212670474854e-14, -9.155810165786422e-16,
 -1.796245202546057e-18,  1.185218270913074e-20,  5.227366455193841e-23, -1.173983180906727e-25, -1.178113518632352e-27,  1.571316961228671e+00, -2.322665013625652e-03,
 -5.692117663005986e-06,  3.189347133631767e-09,  6.863543833976540e-11,  1.214074830986237e-13, -7.255973015268928e-16, -3.738450107987244e-18,  3.172810651068618e-21,
  7.517145125129422e-23,  1.310523397527407e-25, -1.111428189856144e-27,  1.641235029922836e+00, -2.093943894055285e-03, -6.180634275934978e-06, -2.602888918376035e-09,
  6.108569846119383e-11,  2.217229276630276e-13, -2.500471080581813e-16, -4.511016751420590e-18, -1.010019610809886e-20,  5.122639237456842e-23,  3.650100846831325e-25,
  1.943676752019637e-28,  1.708127320648116e+00, -1.827742147188993e-03, -6.346315053891458e-06, -8.449055706558814e-09,  4.214643875693467e-11,  2.768980341331985e-13,
  3.972862468340454e-16, -3.225711760258962e-18, -2.024907011388926e-20, -2.021452359186409e-23,  3.218919649008423e-25,  1.756460695850755e-27,  1.770953039033136e+00,
 -1.531524354735470e-03, -6.129589729894863e-06, -1.342414283125736e-08,  1.415131416054554e-11,  2.564014634671280e-13,  9.520271149540011e-16, -4.609145516309658e-20,
 -1.816448306621856e-20, -8.796481521637238e-23, -6.371414894493386e-26,  1.538482680365000e-27,  1.828566636684730e+00, -1.216940268038572e-03, -5.509715673639177e-06,
 -1.652116871521755e-08, -1.665755076326636e-11,  1.543744044006285e-13,  1.102549154531929e-15,  3.292363854997906e-18, -2.576350271256815e-21, -8.062598475287280e-23,
 -4.130558233983237e-25, -6.918125142447644e-28,  1.879748912165070e+00, -9.000453893467057e-04, -4.526313919240548e-06, -1.694956293389444e-08, -4.117064395917627e-11,
  5.720102740003874e-15,  7.142129180184285e-16,  4.349318729630525e-18,  1.405097508406047e-20,  3.943207303472911e-24, -2.659981284939253e-25, -1.852619270326613e-27,
  1.923258903949083e+00, -6.007971760230803e-04, -3.294561632671119e-06, -1.451663171145951e-08, -5.088630954632230e-11, -1.202859634494624e-13,  2.136057902195462e-17,
  2.270466696758453e-18,  1.554883577710421e-20,  6.649539714266379e-23,  1.648986968691814e-25, -1.879332733219255e-28,  1.957907565865591e+00, -3.415442390919788e-04,
 -2.003488732291986e-06, -9.926579993249737e-09, -4.290755965766842e-11, -1.596068109613675e-13, -4.736210700792380e-16, -7.789927942259107e-19,  2.680378145600384e-21,
  3.525526634243314e-23,  2.214774350153005e-25,  1.030399909485642e-27,  1.982649141316261e+00, -1.444328625769808e-04, -8.883671453700745e-07, -4.761236656819253e-09,
 -2.331397431581528e-11, -1.059927210681875e-13, -4.481773623846530e-16, -1.744783060981680e-18, -6.077743684270825e-21, -1.753355016517435e-23, -3.024664065221641e-26,
  8.313589574275992e-29,  1.996682681007814e+00, -2.801768710864268e-05, -1.769824314169319e-07, -9.901354133840028e-10, -5.169728832531449e-12, -2.577198834060896e-14,
 -1.241069153526041e-16, -5.810467345602206e-19, -2.654361032198788e-21, -1.185333776338940e-23, -5.177204078561474e-26, -2.210452343291986e-28,  };
  constexpr double w[17280] = {  6.901552258454437e-02, -1.996053561707994e-04,  6.039422743228609e-07, -1.892140618267644e-09,  6.072292360291149e-12,
 -1.977937368291684e-14,  6.494424364921337e-17, -2.139443814849441e-19,  7.049793404551005e-22, -2.319404775270043e-24,  7.611018045744265e-27, -2.489640538554685e-29,
  6.877254320158645e-02, -2.785600708765082e-04,  1.314108100423761e-06, -6.276527773820511e-09,  2.925710742498228e-11, -1.326114041235556e-13,  5.863740998455337e-16,
 -2.538826802750220e-18,  1.079633741832507e-20, -4.519842872810214e-23,  1.866222681052462e-25, -7.610568901532529e-28,  6.829022365389623e-02, -4.344466635451046e-04,
  2.984034178143987e-06, -1.903042087085973e-08,  1.137539169738836e-10, -6.471832204604083e-13,  3.540519667749962e-15, -1.875187006234994e-17,  9.662015114765548e-20,
 -4.860932448841281e-22,  2.394603310837808e-24, -1.157674298195113e-26,  6.757572398222703e-02, -6.632967350963267e-04,  6.093593516780318e-06, -4.927326097004394e-08,
  3.647905465396229e-10, -2.529362554442689e-12,  1.665099475353536e-14, -1.050289625038080e-16,  6.389593642915301e-19, -3.767678219066829e-21,  2.161569262095207e-23,
 -1.210220481629881e-25,  6.663949444023437e-02, -9.593464689649903e-04,  1.131582125014593e-05, -1.133491372556899e-07,  1.018398795223340e-09, -8.440539421507494e-12,
  6.564294882714734e-14, -4.845622511528317e-16,  3.422997291694564e-18, -2.328127331621532e-20,  1.531763007157210e-22, -9.785015199397814e-25,  6.549494457518204e-02,
 -1.315251184204957e-03,  1.946488467855887e-05, -2.374716880975076e-07,  2.548975766650237e-09, -2.488806926121602e-11,  2.255841618187486e-13, -1.924016928065735e-15,
  1.559107411882823e-17, -1.208979434175133e-19,  9.020462958306824e-22, -6.503923940027280e-24,  6.415802875232159e-02, -1.722352432542456e-03,  3.143312874949705e-05,
 -4.604133936494563e-07,  5.829011849246590e-09, -6.627402241561916e-11,  6.926007574298058e-13, -6.756614913421264e-15,  6.220719606070400e-17, -5.449386784912567e-19,
  4.570486184901221e-21, -3.688088435504635e-23,  6.264676852254034e-02, -2.170983273395793e-03,  4.812192176259562e-05, -8.356774117710393e-07,  1.234350294606333e-08,
 -1.618270118742577e-10,  1.932383870542783e-12, -2.138068711690185e-14,  2.218786058173302e-16, -2.179161856050490e-18,  2.039624829365615e-20, -1.829111786713413e-22,
  6.098073446078066e-02, -2.650795915310466e-03,  7.037134094132288e-05, -1.432617138038484e-06,  2.445126673948985e-08, -3.664806914233048e-10,  4.961197818124181e-12,
 -6.180511504984652e-14,  7.179826323000356e-16, -7.854511777066137e-18,  8.152966607944750e-20, -8.077038866165309e-22,  5.918051082630785e-02, -3.151095578249532e-03,
  9.889362176607050e-05, -2.336070014169136e-06,  4.567223043284726e-08, -7.765911221664691e-10,  1.183516655823167e-11, -1.649297434126131e-13,  2.131747840674530e-15,
 -2.582644836045316e-17,  2.956691064150838e-19, -3.218815324431536e-21,  5.726716565951213e-02, -3.661165164091761e-03,  1.342147830873225e-04, -3.644233323967860e-06,
  8.096627164378791e-08, -1.550871173424389e-09,  2.643803530819639e-11, -4.097109166934250e-13,  5.859546932074460e-15, -7.820815460359744e-17,  9.826159890797474e-19,
 -1.169944742852209e-20,  5.526174689508966e-02, -4.170566989025406e-03,  1.766280039398341e-04, -5.464708795312743e-06,  1.369582577907356e-07, -2.936028879976949e-09,
  5.565731203746740e-11, -9.539645902434288e-13,  1.501977608430688e-14, -2.198023966549559e-16,  3.017042287192931e-18, -3.911726041102314e-20,  5.318482199223517e-02,
 -4.669410229020472e-03,  2.261612662695720e-04, -7.908853682283504e-06,  2.220582024704865e-07, -5.295382021237208e-09,  1.110136687554945e-10, -2.093856235163038e-12,
  3.612191309935589e-14, -5.770181477329166e-16,  8.616374076707795e-18, -1.211628473723072e-19,  5.105607477340089e-02, -5.148575612970294e-03,  2.825606027390567e-04,
 -1.108477230911307e-05,  3.464268385206741e-07, -9.137336099164163e-09,  2.107505934308056e-10, -4.353424483809204e-12,  8.192575188600110e-14, -1.422580453186189e-15,
  2.301874187955064e-17, -3.497420243674121e-19,  4.889396896402311e-02, -5.599892006990483e-03,  3.452891129123263e-04, -1.508944084181263e-05,  5.217461487647317e-07,
 -1.513929501658663e-08,  3.822976892500779e-10, -8.609930463038155e-12,  1.760078643086269e-13, -3.309123119545750e-15,  5.780500461963143e-17, -9.456000244260691e-19,
  4.671548366767669e-02, -6.016262618454836e-03,  4.135408351841662e-04, -2.000056248491087e-05,  7.607709415173356e-07, -2.416160673952741e-08,  6.648971662269493e-10,
 -1.625660176138220e-11,  3.595607719087377e-13, -7.292026607012559e-15,  1.370270004017255e-16, -2.405218932181481e-18,  4.453592198846856e-02, -6.391741393360280e-03,
  4.862676655507578e-04, -2.586879136346867e-05,  1.076659629794992e-06, -3.724580457974699e-08,  1.112044224195640e-09, -2.939696031761409e-11,  7.008102352819558e-13,
 -1.527617360827784e-14,  3.077539654897319e-16, -5.777686481472861e-18,  4.236879046090768e-02, -6.721562617811459e-03,  5.622168508257159e-04, -3.271094025327618e-05,
  1.482107267361228e-06, -5.559189445150654e-08,  1.793262500939228e-09, -5.105453898278411e-11,  1.307081417549680e-12, -3.051840297620589e-14,  6.570027255403126e-16,
 -1.315136327664879e-17,  4.022574403230245e-02, -7.002128652880536e-03,  6.399761778337547e-04, -4.050470674685773e-05,  1.988328429386471e-06, -8.051084688741447e-08,
  2.794645585217532e-09, -8.536943792757816e-11,  2.338935045348104e-12, -5.830232371458072e-14,  1.337042103141448e-15, -2.845132684699486e-17,  3.811658915542271e-02,
 -7.230962078938637e-03,  7.180238292981545e-04, -4.918532688725778e-05,  2.603958543266175e-06, -1.133507190489609e-07,  4.217575022823746e-09, -1.377408408273397e-10,
  4.024942931315802e-12, -1.067703303047951e-13,  2.600447378592075e-15, -5.865479078725360e-17,  3.604933611179336e-02, -7.406629301095160e-03,  7.947799569578767e-04,
 -5.864441087724048e-05,  3.333957111161301e-06, -1.553977457708569e-07,  6.175098145403097e-09, -2.148650737559749e-10,  6.674667665920469e-12, -1.878471900986392e-13,
  4.844703039887370e-15, -1.155058015955007e-16,  3.403029096149993e-02, -7.528642915902919e-03,  8.686572919183712e-04, -6.873104954595800e-05,  4.178603105400750e-06,
 -2.077569653543090e-07,  8.785626663606887e-09, -3.246151610952948e-10,  1.068642887124644e-11, -3.181232219009579e-13,  8.663392617569175e-15, -2.177331042118137e-16,
  3.206417742159371e-02, -7.597349937380836e-03,  9.381085207829243e-04, -7.925511928466721e-05,  5.132670896596252e-06, -2.712200760597903e-07,  1.216389347274605e-08,
 -4.757129244386984e-10,  1.654572549291851e-11, -5.194920338172686e-13,  1.489711261410577e-14, -3.936309621618586e-16,  3.015427940024846e-02, -7.613812423503294e-03,
  1.001668650114982e-03, -8.999257097757206e-05,  6.184864706437528e-06, -3.461308310559680e-07,  1.640945621646547e-08, -6.771602670299775e-10,  2.481002097831830e-11,
 -8.192739886153422e-13,  2.467264891081665e-14, -6.836503018651227e-16,  2.830259573133090e-02, -7.579686235922758e-03,  1.057991110193132e-03, -1.006923751411487e-04,
  7.317572028743787e-06, -4.322600019799959e-07,  2.159342111588522e-08, -9.374225066663958e-10,  3.607623895375973e-11, -1.249523062046360e-12,  3.941459013908755e-14,
 -1.142388745889628e-15,  2.650999973621574e-02, -7.497102706486626e-03,  1.105876867556026e-03, -1.110847169107234e-04,  8.506973708522392e-06, -5.287025083941699e-07,
  2.774442758653507e-08, -1.263391534168591e-09,  5.092891462702844e-11, -1.845233757254313e-12,  6.081078919740020e-14, -1.839115095207839e-15,  2.477639746774152e-02,
 -7.368556964401134e-03,  1.144296289623277e-03, -1.208899924146538e-04,  9.723522786493635e-06, -6.338085976233046e-07,  3.483522802224823e-08, -1.659196200037028e-09,
  6.986948957681399e-11, -2.641253849389190e-12,  9.071349636684120e-14, -2.855797920395555e-15,  2.310087976266627e-02, -7.196805672674408e-03,  1.172403909391205e-03,
 -1.298281506098963e-04,  1.093277826642731e-05, -7.451589968466813e-07,  4.277136785758074e-08, -2.124966057369731e-09,  9.323050627836360e-11, -3.667874599626261e-12,
  1.309629671791966e-13, -4.281626896249713e-15,  2.148186446170045e-02, -6.984775988951984e-03,  1.189546559895003e-03, -1.376279472272215e-04,  1.209655590537512e-05,
 -8.595909227047173e-07,  5.138348195823092e-08, -2.655685977880603e-09,  1.210820275820444e-10, -4.945303050367400e-12,  1.831306134509305e-13, -6.203308829049179e-15,
  1.991722628974421e-02, -6.735486743199435e-03,  1.195265582118544e-03, -1.440357237176004e-04,  1.317433780641081e-05, -9.732780163475697e-07,  6.042455723035754e-08,
 -3.240296999506762e-09,  1.531408883020122e-10, -6.477492709268426e-12,  2.481938983987093e-13, -8.691036151577876e-15,  1.840441288380545e-02, -6.451982135354800e-03,
  1.189293959163962e-03, -1.488233868024314e-04,  1.412486730374764e-05, -1.081863043383255e-06,  6.957317327512687e-08, -3.861198182772821e-09,  1.886957233850775e-10,
 -8.246074009739400e-12,  3.261733428272854e-13, -1.178093823315561e-14,  1.694054629124000e-02, -6.137277708291445e-03,  1.171549302124797e-03, -1.517953362141866e-04,
  1.490784606691979e-05, -1.180637957589822e-06,  7.844325040376565e-08, -4.494282664770680e-09,  2.265615014925710e-10, -1.020532857214854e-11,  4.157800050656105e-13,
 -1.545591470657384e-14,  1.552250993075803e-02, -5.794317942193676e-03,  1.142123621100775e-03, -1.527941629314788e-04,  1.548564663853777e-05, -1.264762057463540e-06,
  8.660025371256984e-08, -5.109598836272897e-09,  2.650760920587929e-10, -1.227923557369760e-11,  5.141354915137506e-13, -1.962780218143413e-14,  1.414702151912246e-02,
 -5.425944534661784e-03,  1.101270771703575e-03, -1.517050122190490e-04,  1.582495539551097e-05, -1.329505794062180e-06,  9.358318254555315e-08, -5.672668047904816e-09,
  3.021480592805373e-10, -1.436154091578221e-11,  6.166316999954955e-13, -2.412456729710575e-14,  1.281069283190240e-02, -5.034874260314107e-03,  1.049392386996161e-03,
 -1.484585709621284e-04,  1.589826745400685e-05, -1.370505563374371e-06,  9.893108153198944e-08, -6.146419661326853e-09,  3.353596068163431e-10, -1.631954093912642e-11,
  7.169907635654985e-13, -2.868637446006242e-14,  1.151007740649862e-02, -4.623685225587776e-03,  9.870229999658301e-04, -1.430326944027518e-04,  1.568516535513841e-05,
 -1.384013685451757e-06,  1.022123053531801e-07, -6.493630792557677e-09,  3.621219429431992e-10, -1.800184512063664e-11,  8.075656493376927e-13, -3.297374403821881e-14,
  1.024170743230213e-02, -4.194810329743554e-03,  9.148149436637474e-04, -1.354527320143098e-04,  1.517332639633420e-05, -1.367127784242147e-06,  1.030544081447441e-07,
 -6.679690862684734e-09,  3.798731401932403e-10, -1.924983411469151e-11,  8.798898335787169e-13, -3.658954104685700e-14,  9.002121130657688e-03, -3.750536794259582e-03,
  8.335234945219022e-04, -1.257906456069510e-04,  1.435921814504604e-05, -1.317984891941884e-06,  1.011723488626311e-07, -6.675458884351365e-09,  3.863018438800711e-10,
 -1.991193820546869e-11,  9.254445313485259e-13, -3.911435449235327e-14,  7.787881935145433e-03, -3.293010716691228e-03,  7.439926070153142e-04, -1.141630355404882e-04,
  1.324845702159293e-05, -1.235907687789133e-06,  9.639272658283790e-08, -6.459951575868948e-09,  3.795749785657743e-10, -1.985932261265577e-11,  9.365706064150220e-13,
 -4.015228067703545e-14,  6.595590788400471e-03, -2.824245740204606e-03,  6.471414828870506e-04, -1.007282048335663e-04,  1.185582009344084e-05, -1.121493166543072e-06,
  8.867198563574783e-08, -6.022597733727671e-09,  3.585448028143380e-10, -1.900117799542643e-11,  9.074173220944647e-13, -3.938169648041713e-14,  5.421893012260412e-03,
 -2.346135148041974e-03,  5.439521415627203e-04, -8.568239966719997e-05,  1.020491498030742e-05, -9.766375196635331e-07,  7.810694317986749e-08, -5.364820577581837e-09,
  3.229108716299865e-10, -1.729765869813441e-11,  8.347990887867382e-13, -3.660384143139723e-14,  4.263482107704889e-03, -1.860467254157661e-03,  4.354581761894127e-04,
 -6.925538049409257e-05,  8.327527827308137e-06, -8.044949871856714e-07,  6.493656637105809e-08, -4.500763945338783e-09,  2.733159132433690e-10, -1.476863849149156e-11,
  7.188300922015479e-13, -3.178139448909248e-14,  3.117108597176502e-03, -1.368946668573175e-03,  3.227354225943365e-04, -5.170557204078394e-05,  6.262692855371142e-06,
 -6.093734932856509e-07,  4.953468313342396e-08, -3.457060061679521e-09,  2.113613416215845e-10, -1.149688397372322e-11,  5.632283134932645e-13, -2.506004554804672e-14,
  1.979654900246240e-03, -8.732475631371800e-04,  2.069007827081692e-04, -3.331593331833392e-05,  4.055646690234051e-06, -3.965844026780312e-07,  3.239490010985216e-08,
 -2.271688183913618e-09,  1.395404738385319e-10, -7.625103324916762e-12,  3.752315563681645e-13, -1.676869228938997e-14,  8.494405200261362e-04, -3.756133811113874e-04,
  8.924148218131326e-05, -1.441043939788748e-05,  1.759130308659159e-06, -1.724920103598602e-07,  1.412812575090025e-08, -9.933646756984103e-10,  6.117714503432493e-11,
 -3.351510413754492e-12,  1.653396262437340e-13, -7.406850427897417e-15,  6.822662272636672e-02, -1.948630185867407e-04,  5.818067414512602e-07, -1.798065944853764e-09,
  5.691819133990713e-12, -1.829012304601439e-14,  5.925748592248166e-17, -1.926643387009146e-19,  6.267067895112703e-22, -2.035773558564009e-24,  6.596646546480311e-27,
 -2.131064080249067e-29,  6.767886260666718e-02, -2.683407181918226e-04,  1.241513338377996e-06, -5.828890733880363e-09,  2.674004663171340e-11, -1.193538855234173e-13,
  5.198889993180287e-16, -2.218000571641991e-18,  9.295870359526412e-21, -3.836209034392845e-23,  1.561633241477308e-25, -6.279624158279024e-28,  6.659877765586222e-02,
 -4.114578638410089e-04,  2.766176844871395e-06, -1.730946310976373e-08,  1.016191873960434e-10, -5.681775306238223e-13,  3.056248645781196e-15, -1.592248030460295e-17,
  8.072888913093648e-20, -3.997647320597040e-22,  1.938891703083045e-24, -9.230811959256400e-27,  6.501642495284515e-02, -6.168175888245072e-04,  5.535732596787929e-06,
 -4.382055719297877e-08,  3.179727584732039e-10, -2.162837544576692e-12,  1.397717896698917e-14, -8.659545356016445e-17,  5.176835513130188e-19, -3.000809310800225e-21,
  1.692984703407742e-23, -9.323874868102465e-26,  6.297492199389614e-02, -8.739959486038065e-04,  1.004809231801513e-05, -9.832404429906759e-08,  8.643041575291343e-10,
 -7.016278152362433e-12,  5.349067752383275e-14, -3.873331660539344e-16,  2.685517432708205e-18, -1.793573996441034e-20,  1.159238480004426e-22, -7.277265100164452e-25,
  6.052826137718495e-02, -1.170273432101890e-03,  1.684440512326741e-05, -2.003933566775929e-07,  2.101266074456001e-09, -2.006792750160840e-11,  1.780887752148058e-13,
 -1.488299514895869e-15,  1.182470505795851e-17, -8.995050827849788e-20,  6.587037060212420e-22, -4.663325323226462e-24,  5.773867021235658e-02, -1.491496926697612e-03,
  2.642677136035140e-05, -3.769103926360756e-07,  4.655521540307693e-09, -5.171382531341883e-11,  5.285694576425276e-13, -5.047531845995544e-15,  4.552326650295468e-17,
 -3.908854657536454e-19,  3.215176644293529e-21, -2.545596521705421e-23,  5.467370975410904e-02, -1.822993543136779e-03,  3.917960233933696e-05, -6.617438435599707e-07,
  9.526101619310040e-09, -1.218986214603659e-10,  1.422370206435036e-12, -1.539281138856859e-14,  1.563608127241827e-16, -1.504210205434274e-18,  1.379840999924156e-20,
 -1.213399671888126e-22,  5.140331780830387e-02, -2.150457827671675e-03,  5.530483362132842e-05, -1.094109192476819e-06,  1.818455207178697e-08, -2.658226157042621e-10,
  3.513916689772277e-12, -4.278798554853112e-14,  4.862551322304646e-16, -5.207534337830151e-18,  5.294956498698686e-20, -5.141320193501346e-22,  4.799698441687623e-02,
 -2.460742537000743e-03,  7.477877852586508e-05, -1.715577549718757e-06,  3.264325638742556e-08, -5.410389737799778e-10,  8.047182070001352e-12, -1.095583490642229e-13,
  1.384634140992736e-15, -1.641501439435723e-17,  1.840115580911071e-19, -1.962697505330075e-21,  4.452122315398910e-02, -2.742498538687551e-03,  9.733503712851291e-05,
 -2.565987255278791e-06,  5.546412898701290e-08, -1.035186388171923e-09,  1.721670296989920e-11, -2.605723084583350e-13,  3.642755734017864e-15, -4.756289166729015e-17,
  5.849863377209013e-19, -6.822427899362100e-21,  4.103746067121265e-02, -2.986628990372710e-03,  1.224741572418904e-04, -3.678754847186281e-06,  8.968429103699745e-08,
 -1.873029186209394e-09,  3.463398189795153e-11, -5.796450621922825e-13,  8.919342918442536e-15, -1.276680234176991e-16,  1.715195047499677e-18, -2.177992096901042e-20,
  3.760042136861427e-02, -3.186543925114154e-03,  1.494972777872700e-04, -5.076229658381601e-06,  1.386464703903471e-07, -3.221023680600257e-09,  6.586542738279168e-11,
 -1.213003823005479e-12,  2.045077738157999e-14, -3.195177147217778e-16,  4.669836110858739e-18, -6.431257108201449e-20,  3.425703770454201e-02, -3.338221077165543e-03,
  1.775582621535260e-04, -6.765761803687990e-06,  2.057378616022063e-07, -5.287470251451850e-09,  1.189698653985637e-10, -2.399827733636664e-12,  4.414030858364261e-14,
 -7.497188478871314e-16,  1.187449076378356e-17, -1.767145317312329e-19,  3.104587443892120e-02, -3.440095107803027e-03,  2.057271584444397e-04, -8.737057277553021e-06,
  2.940587219583188e-07, -8.316571852534052e-09,  2.049266548241042e-10, -4.507988419158170e-12,  9.009037964627190e-14, -1.657136040463933e-15,  2.834077615044132e-17,
 -4.541852207016607e-19,  2.799702056130790e-02, -3.492808981132280e-03,  2.330573041372274e-04, -1.096120181182131e-05,  4.060571746576404e-07, -1.257543106903697e-08,
  3.378207534669129e-10, -8.070652686278741e-12,  1.745676864567006e-13, -3.464816572113656e-15,  6.376394946910882e-17, -1.096820333144632e-18,  2.513237784686085e-02,
 -3.498867571091611e-03,  2.586489294817292e-04, -1.339148921051536e-05,  5.431761199011103e-07, -1.833408970447618e-08,  5.346495944462549e-10, -1.381683450637554e-11,
  3.222681781182537e-13, -6.877964531952002e-15,  1.357582276525895e-16, -2.498635576536735e-18,  2.246626051249549e-02, -3.462234884415398e-03,  2.817034657421522e-04,
 -1.596593807428182e-05,  7.055597275224816e-07, -2.583995162989914e-08,  8.146453075077310e-10, -2.268699144765311e-11,  5.685900892144688e-13, -1.300522263270368e-14,
  2.744489587133090e-16, -5.388471813088286e-18,  2.000621566527586e-02, -3.387913370436612e-03,  3.015646096432396e-04, -1.861116643864001e-05,  8.918603905088169e-07,
 -3.528907685949195e-08,  1.198064789164126e-09, -3.582410741891008e-11,  9.614563813276719e-13, -2.349238872761827e-14,  5.284258835867690e-16, -1.103550862587220e-17,
  1.775397759079913e-02, -3.281537818066717e-03,  3.177441997297457e-04, -2.124714761848938e-05,  1.099173686801095e-06, -4.679764408761807e-08,  1.704481604322682e-09,
 -5.453198356460431e-11,  1.562097722423621e-12, -4.064764128951824e-14,  9.716824524005875e-16, -2.152356945110136e-17,  1.570647834630451e-02, -3.149008592676679e-03,
  3.299328322499335e-04, -2.379230677791058e-05,  1.323111532163712e-06, -6.037717066766028e-08,  2.350703233067399e-09, -8.019588639854813e-11,  2.444162880077583e-12,
 -6.752737944764150e-14,  1.710640467429308e-15, -4.008145971550183e-17,  1.385685037442302e-02, -2.996180642892705e-03,  3.379966713481388e-04, -2.616843444858443e-05,
  1.558005577300523e-06, -7.591678510745983e-08,  3.148516925250270e-09, -1.141659762854224e-10,  3.690606055256651e-12, -1.079447707795970e-13,  2.889766816439409e-15,
 -7.143113115477061e-17,  1.219537185670959e-02, -2.828616795752919e-03,  3.419629725531323e-04, -2.830497549205128e-05,  1.797217090580840e-06, -9.317502261918521e-08,
  4.102520546041092e-09, -1.576102516440372e-10,  5.388027940606619e-12, -1.663621514356479e-13,  4.693772226503524e-15, -1.220844679367433e-16,  1.071032054631107e-02,
 -2.651407055973828e-03,  3.419974113278552e-04, -3.014237716069680e-05,  2.033518375642698e-06, -1.117824176882651e-07,  5.208309558764706e-09, -2.113499344511852e-10,
  7.618503605842019e-12, -2.476359768026133e-13,  7.344124055872919e-15, -2.004895283666055e-16,  9.388715572199665e-03, -2.469050327149729e-03,  3.383764334368203e-04,
 -3.163432301358031e-05,  2.259505390020408e-06, -1.312548188490079e-07,  6.451263809706441e-09, -2.756950439379674e-10,  1.044936539176969e-11, -3.565999305163624e-13,
  1.108778520330048e-14, -3.169077502109200e-16,  8.216938378622009e-03, -2.285391305523600e-03,  3.314576122522661e-04, -3.274881793894881e-05,  2.468001691225157e-06,
 -1.510160793854571e-07,  7.806112656607425e-09, -3.503003221194829e-10,  1.392184618665934e-11, -4.974967214845226e-13,  1.617682641217502e-14, -4.829055421695644e-16,
  7.181233162830882e-03, -2.103603176042766e-03,  3.216505231977347e-04, -3.346820640152636e-05,  2.652419218153515e-06, -1.704277757928096e-07,  9.237365881247924e-09,
 -4.340611074733844e-10,  1.803984123445320e-11, -6.732984324804897e-13,  2.283885183901270e-14, -7.103753264026300e-16,  6.268093853921753e-03, -1.926205941019813e-03,
  3.093900411480188e-04, -3.378829115243001e-05,  2.807050183888423e-06, -1.888229965863348e-07,  1.070059652976861e-08, -5.250652052075912e-10,  2.276023857716820e-11,
 -8.849837543894295e-13,  3.123988590500092e-14, -1.010065433908747e-15,  5.464549031974881e-03, -1.755110436411310e-03,  2.951133315487478e-04, -3.371676965435386e-05,
  2.927274750320562e-06, -2.055410688075693e-07,  1.214446669134108e-08, -6.206108427018122e-10,  2.798625102548769e-11, -1.130862199418735e-12,  4.144321554106713e-14,
 -1.389690181801606e-15,  4.758358564600954e-03, -1.591679025427735e-03,  2.792412152694220e-04, -3.327122255501339e-05,  3.009679528612570e-06, -2.199603141517444e-07,
  1.351331196850965e-08, -7.172934137441252e-10,  3.356494696124367e-11, -1.406045348773785e-12,  5.336930099089779e-14, -1.851797170170097e-15,  4.138136549229036e-03,
 -1.436795313695270e-03,  2.621640892561947e-04, -3.247687860397567e-05,  3.052091007493030e-06, -2.315264607699448e-07,  1.475005386258935e-08, -8.111560837368679e-10,
  3.928975474963918e-11, -1.702160234019094e-12,  6.676288623710033e-14, -2.391667659627333e-15,  3.593414810606341e-03, -1.290936762667551e-03,  2.442322037778415e-04,
 -3.136435124853009e-05,  3.053534928990038e-06, -2.397750601408845e-07,  1.579919459988704e-08, -8.978925773430284e-10,  4.490817045865143e-11, -2.007379668619887e-12,
  8.117356147513439e-14, -2.995594436917753e-15,  3.114660093506300e-03, -1.154245605536201e-03,  2.257498363618315e-04, -2.996750183272547e-05,  3.014137062311315e-06,
 -2.443470462490893e-07,  1.660966380014148e-08, -9.730854740475892e-10,  5.013431391880128e-11, -2.306811158239224e-12,  9.595511206615435e-14, -3.639899189783696e-15,
  2.693256529596340e-03, -1.026594868593056e-03,  2.069727521528595e-04, -2.832154003761926e-05,  2.934982831403200e-06, -2.449973181022501e-07,  1.713732453063163e-08,
 -1.032460594095276e-09,  5.466543856638956e-11, -2.583244661178105e-12,  1.102870810316642e-13, -4.291005530078479e-15,  2.321463194476330e-03, -9.076474990940320e-04,
  1.881082817598637e-04, -2.646142954941114e-05,  2.817953180331989e-06, -2.415968467850482e-07,  1.734699912811905e-08, -1.072137659381598e-09,  5.820107701688032e-11,
 -2.818216017203715e-12,  1.232193149176851e-13, -4.906773733250274e-15,  1.992354787810595e-03, -7.969075681978922e-04,  1.693173585630842e-04, -2.442062972590497e-05,
  2.665552424884690e-06, -2.341292589286221e-07,  1.721393367321952e-08, -1.088859097822774e-09,  6.046324365893972e-11, -2.993303550817887e-12,  1.337372402344906e-13,
 -5.439141337497133e-15,  1.699751787853627e-03, -6.937632549975878e-04,  1.507179159740715e-04, -2.223017432958710e-05,  2.480741197737479e-06, -2.226831156772577e-07,
  1.672467614465999e-08, -1.080182112286674e-09,  6.121603576558462e-11, -3.091545494066416e-12,  1.408426857980067e-13, -5.837923535232167e-15,  1.438144923997443e-03,
 -5.975218454583263e-04,  1.323891318751129e-04, -1.991806685733215e-05,  2.266784467729745e-06, -2.074412015250680e-07,  1.587739101203866e-08, -1.044623321555474e-09,
  6.028306654001740e-11, -3.098849060853004e-12,  1.436426692186894e-13, -6.055439300997997e-15,  1.202617512752168e-03, -5.074373299760709e-04,  1.143761068435243e-04,
 -1.750895823271061e-05,  2.027121427793088e-06, -1.886680896365397e-07,  1.468166868473799e-08, -9.817497671910603e-10,  5.756139696494926e-11, -3.005259753405176e-12,
  1.414370600970164e-13, -6.051475138403992e-15,  9.887681253088251e-04, -4.227313925481183e-04,  9.669466363142433e-05, -1.502406562924873e-05,  1.765261114586959e-06,
 -1.666970976008755e-07,  1.315791053215296e-08, -8.922143312185332e-10,  5.303096576971535e-11, -2.805971278848432e-12,  1.337956347239220e-13, -5.798005229429473e-15,
  7.926352050481487e-04, -3.426086956693891e-04,  7.933605174707535e-05, -1.248128983635087e-05,  1.484705166337376e-06, -1.419175322908503e-07,  1.133637998979634e-08,
 -7.777372578941040e-10,  4.675890293216542e-11, -2.501980174174540e-12,  1.206158022237778e-13, -5.283072287656684e-15,  6.106246950457692e-04, -2.662674472038375e-04,
  6.227143727456573e-05, -9.895492814016274e-06,  1.188897400661910e-06, -1.147628971471300e-07,  9.256010954070974e-09, -6.410384046279436e-10,  3.889851519888237e-11,
 -2.100321928227316e-12,  1.021541202058905e-13, -4.513303457715066e-15,  4.394420087364354e-04, -1.929065657971586e-04,  4.545621176774729e-05, -7.278915128501414e-06,
  8.812000760650303e-07, -8.570064379885311e-08,  6.963068475088713e-09, -4.857276771123219e-10,  2.968315905745643e-11, -1.613865519801626e-12,  7.902750432026160e-14,
 -3.514687388861678e-15,  2.760366005939312e-04, -1.217339482078708e-04,  2.883497989975571e-05, -4.641842998489290e-06,  5.649108751582543e-07, -5.522530490550112e-08,
  4.509864402958084e-09, -3.161707836966941e-10,  1.941606788205719e-11, -1.060710344448723e-12,  5.218459458121087e-14, -2.331504432457189e-15,  1.177197505225296e-04,
 -5.204781607542820e-05,  1.236418504437488e-05, -1.996234953041161e-06,  2.436509120156017e-07, -2.388773618167281e-08,  1.956262508869918e-09, -1.375271833317976e-10,
  8.468510494339066e-12, -4.638709106448465e-13,  2.288089560610941e-14, -1.024873084587509e-15,  6.745634505649779e-02, -1.902933509535802e-04,  5.607645386569936e-07,
 -1.709847780878816e-09,  5.339812937994173e-12, -1.693047837153792e-14,  5.413298420870101e-17, -1.737331785932401e-19,  5.579510823859160e-22, -1.789731174835436e-24,
  5.727563929743700e-27, -1.827608734992062e-29,  6.662493098603418e-02, -2.586813020631784e-04,  1.174057060221109e-06, -5.419489200744315e-09,  2.447288031474576e-11,
 -1.075894181391600e-13,  4.617502098682721e-16, -1.941475709440651e-18,  8.020922027373168e-21, -3.263463386989791e-23,  1.309988173166744e-25, -5.195132388477839e-28,
  6.499592742568339e-02, -3.901325013614485e-04,  2.567856240074206e-06, -1.577062566340393e-08,  9.095447839302049e-11, -4.998983824866092e-13,  2.644524501354932e-15,
 -1.355521145968163e-17,  6.764077461188747e-20, -3.297568496291934e-22,  1.574931657607241e-24, -7.385216047428723e-27,  6.263451386829373e-02, -5.745517992639393e-04,
  5.039040687962438e-06, -3.906161276745597e-08,  2.778833993328745e-10, -1.854704715326000e-12,  1.176907546367146e-14, -7.163496673595620e-17,  4.209163705402979e-19,
 -2.399032683643427e-21,  1.331250729074521e-23, -7.213372378647731e-26,  5.963255343072308e-02, -7.981059026479257e-04,  8.946762515790254e-06, -8.555155048054629e-08,
  7.359856524046244e-10, -5.853501107263924e-12,  4.375742780835256e-14, -3.108917240410216e-16,  2.116117113484528e-18, -1.388094414500896e-20,  8.815244865800790e-23,
 -5.439328482273159e-25,  5.610221672405164e-02, -1.044594589692253e-03,  1.462887685914792e-05, -1.697651760765677e-07,  1.739482281717610e-09, -1.625392716666659e-11,
  1.412611013769285e-13, -1.157011067607337e-15,  9.015147255500341e-18, -6.729063299467243e-20,  4.837397716297444e-22, -3.363310455339944e-24,  5.216855510693598e-02,
 -1.296982506867758e-03,  2.231875375557738e-05, -3.100522546253848e-07,  3.737452530193112e-09, -4.057168325840913e-11,  4.056825555218074e-13, -3.793152754025577e-15,
  3.351958302901909e-17, -2.821761408083324e-19,  2.276714455512205e-21, -1.768999841979706e-23,  4.796174476422396e-02, -1.538903253186116e-03,  3.207835973650292e-05,
 -5.271121990412296e-07,  7.397309967413872e-09, -9.241479143907192e-11,  1.053983333238203e-12, -1.115880128237942e-14,  1.109788602932400e-16, -1.045970774778503e-18,
  9.405630151982896e-21, -8.112075871910034e-23,  4.360969687547990e-02, -1.755966383394001e-03,  4.375959875112903e-05, -8.414836214248529e-07,  1.362279857395890e-08,
 -1.942667140293109e-10,  2.508188854182244e-12, -2.985909478212919e-14,  3.320175003939479e-16, -3.481582565719423e-18,  3.468343330491513e-20, -3.301321989229173e-22,
  3.923162157433150e-02, -1.936740104129633e-03,  5.699985881586272e-05, -1.270317599979805e-06,  2.352905358651616e-08, -3.802105032542860e-10,  5.520253134671235e-12,
 -7.343791310353830e-14,  9.076985000929316e-16, -1.053175555688872e-17,  1.156217146845543e-19, -1.208467123018378e-21,  3.493296806251051e-02, -2.073338429274571e-03,
  7.125099803797796e-05, -1.824002882613554e-06,  3.836333838367870e-08, -6.977997175903646e-10,  1.132430988691309e-11, -1.674129611802144e-13,  2.288087503905962e-15,
 -2.922972639090935e-17,  3.519726333112423e-19, -4.021351779546484e-21,  3.080196988316541e-02, -2.161600638565546e-03,  8.583509484148073e-05, -2.503316193328502e-06,
  5.937147723127522e-08, -1.208137982530636e-09,  2.179339434214003e-11, -3.561949146307650e-13,  5.357347020017593e-15, -7.501174869804767e-17,  9.864861057627131e-19,
 -1.226973592247357e-20,  2.690783290305596e-02, -2.200903195441489e-03,  1.000162996521978e-04, -3.297703219851203e-06,  8.762397681953526e-08, -1.983337242501421e-09,
  3.956218166062320e-11, -7.114675613059203e-13,  1.172362734077432e-14, -1.791628801423292e-16,  2.563065038670808e-18, -3.457282723452853e-20,  2.330043897623930e-02,
 -2.193682671722757e-03,  1.130766046792960e-04, -4.185079270932651e-06,  1.238283086076565e-07, -3.100926611699406e-09,  6.806688647942993e-11, -1.340840406637960e-12,
  2.410549947411220e-14, -4.005011220554632e-16,  6.209399134578043e-18, -9.051373870247925e-20,  2.001131722606836e-02, -2.144769166787929e-03,  1.243842292750168e-04,
 -5.133236153508527e-06,  1.681609136619551e-07, -4.635420861498624e-09,  1.114541149703107e-10, -2.394773842306010e-12,  4.678673844713317e-14, -8.419800855450138e-16,
  1.409799314550929e-17, -2.213392916546484e-19,  1.705556453040244e-02, -2.060633294456262e-03,  1.334460418302904e-04, -6.102633730655270e-06,  2.201518331969458e-07,
 -6.647977586387935e-09,  1.743257508999287e-10, -4.069197664343825e-12,  8.607108858217608e-14, -1.671847577170865e-15,  3.013092700842114e-17, -5.078892697121236e-19,
  1.443437551284831e-02, -1.948639026730219e-03,  1.399391688508073e-04, -7.050113627413211e-06,  2.786464108550238e-07, -9.175673915339390e-09,  2.613161114871602e-10,
 -6.601196523604204e-12,  1.506275190244970e-13, -3.147312568733351e-15,  6.085972576497196e-17, -1.098047906129594e-18,  1.213786192794592e-02, -1.816374236150599e-03,
  1.437208025194582e-04, -7.932945422312363e-06,  3.418544421244204e-07, -1.222223476744678e-08,  3.765348904042292e-10, -1.025582521692964e-11,  2.515885107625359e-13,
 -5.636582906101556e-15,  1.165864676640719e-16, -2.244939573260560e-18,  1.014788981666768e-02, -1.671105852553974e-03,  1.448184921857016e-04, -8.712615145341838e-06,
  4.074810754788846e-07, -1.575194327751901e-08,  5.229454619900324e-10, -1.530354477085772e-11,  4.022639481229792e-13, -9.633169302082622e-15,  2.124994484430020e-16,
 -4.354653424396768e-18,  8.440727257382876e-03, -1.519381774483471e-03,  1.434054483667760e-04, -9.357873485861195e-06,  4.729195630391066e-07, -1.968797220283507e-08,
  7.017728527243571e-10, -2.198969241660466e-11,  6.173710928858534e-13, -1.575523286725526e-14,  3.695936034292207e-16, -8.038429302245212e-18,  6.989364246482351e-03,
 -1.366780462252292e-03,  1.397664544473587e-04, -9.846737537075538e-06,  5.354766266551578e-07, -2.391561216490569e-08,  9.120415508709620e-10, -3.049936940124667e-11,
  9.117566957230900e-13, -2.472318673798903e-14,  6.150425670312189e-16, -1.415947987716564e-17,  5.765430158105570e-03, -1.217793431206698e-03,  1.342599781073432e-04,
 -1.016733875275027e-05,  5.925982159238431e-07, -2.829002403729549e-08,  1.150327810285992e-09, -4.092263080560101e-11,  1.298688141363277e-12, -3.731115035391376e-14,
  9.816618576098770e-16, -2.386011398152775e-17,  4.740687509733929e-03, -1.075816225090171e-03,  1.272812723430653e-04, -1.031768974225867e-05,  6.420665756148806e-07,
 -3.264740273600711e-08,  1.410777472221654e-09, -5.322546038566088e-11,  1.787894227707375e-12, -5.427207379560945e-14,  1.506161537483953e-15, -3.855218424506655e-17,
  3.888120642453706e-03, -9.432193832091604e-04,  1.192299915460879e-04, -1.030457534741544e-05,  6.821472675412488e-07, -3.681795728360247e-08,  1.685396466827882e-09,
 -6.723150605861850e-11,  2.383616465667205e-12, -7.624167956022867e-14,  2.226043328076552e-15, -5.985475080461983e-17,  3.182664168278653e-03, -8.214712688654086e-04,
  1.104844415968616e-04, -1.014184681242003e-05,  7.116748591267355e-07, -4.063895871448924e-08,  1.964577080429028e-09, -8.261802161637537e-11,  3.082966434099648e-12,
 -1.036316350806390e-13,  3.175235459328682e-15, -8.946828954599262e-17,  2.601630136621984e-03, -7.112879838842663e-04,  1.013832838793345e-04, -9.848413772418438e-06,
  7.300761158403569e-07, -4.396627089568778e-08,  2.237788055713312e-09, -9.892724884237133e-11,  3.874862438676824e-12, -1.365262579071711e-13,  4.378834567744118e-15,
 -1.289847045355981e-16,  2.124897280164843e-03, -6.127905813958651e-04,  9.221447767347073e-05, -9.446199204553354e-06,  7.373379178538073e-07, -4.668318124173349e-08,
  2.494336855103760e-09, -1.155920733510515e-10,  4.739742517730210e-12, -1.745985022692762e-13,  5.847575617522411e-15, -1.796453795135610e-16,  1.734923174318925e-03,
 -5.256552697852868e-04,  8.321053896313155e-05, -8.958264103278079e-06,  7.339327168232515e-07, -4.870587506530909e-08,  2.724110026949229e-09, -1.319726985859613e-10,
  5.650136907971304e-12, -2.170594849901404e-13,  7.572814667598117e-15, -2.420728980394034e-16,  1.416633281453231e-03, -4.492474622103886e-04,  7.454880991191372e-05,
 -8.407238278145774e-06,  7.207168882689125e-07, -4.998543313985600e-08,  2.918210650994182e-09, -1.473996891927496e-10,  6.572055856728899e-12, -2.626515972731592e-13,
  9.522838978037559e-15, -3.160127100476332e-16,  1.157231815642637e-03, -3.827348823607273e-04,  6.635531944535911e-05, -7.814125105201357e-06,  6.988171709752312e-07,
 -5.050668449130446e-08,  3.069435564286923e-09, -1.612182259047621e-10,  7.467033951834381e-12, -3.096891732774279e-13,  1.164119876644558e-14, -4.001260866796198e-16,
  9.459697776377099e-04, -3.251782791157191e-04,  5.871089735417201e-05, -7.197490517066403e-06,  6.695182448236591e-07, -5.028455997971658e-08,  3.172563533914466e-09,
 -1.728287683381855e-10,  8.294590667997465e-12, -3.561439915515740e-13,  1.384750429498150e-14, -4.918734939727778e-16,  7.738964581060786e-04, -2.756006242375128e-04,
  5.165840588352620e-05, -6.573004549612888e-06,  6.341612364590382e-07, -4.935874999437523e-08,  3.224453125843276e-09, -1.817203505542839e-10,  9.014830022759352e-12,
 -3.997668684082749e-13,  1.604079955034215e-14, -5.875179768845311e-16,  6.336128140251660e-04, -2.330370886369485e-04,  4.521020819444384e-05, -5.953278073753632e-06,
  5.940593429469966e-07, -4.778748609180556e-08,  3.223971503894944e-09, -1.874941527079524e-10,  9.590911004719529e-12, -4.382323004796708e-13,  1.810527396234121e-14,
 -6.822628819258912e-16,  5.190386576749829e-04, -1.965687961145574e-04,  3.935525318759625e-05, -5.347925997010869e-06,  5.504334252370320e-07, -4.564117589819491e-08,
  3.171790458980690e-09, -1.898765004848618e-10,  9.991166749434846e-12, -4.692911010421253e-13,  1.991777004206809e-14, -7.705200796402510e-16,  4.252005834130505e-04,
 -1.653435344660611e-04,  3.406538927381981e-05, -4.763787905270500e-06,  5.043677155349819e-07, -4.299646493063911e-08,  3.070093137895306e-09, -1.887217902461153e-10,
  1.019072068001911e-11, -4.909163042687158e-13,  2.135633603488574e-14, -8.462870830749682e-16,  3.480438672387974e-04, -1.385864413280309e-04,  2.930070936449834e-05,
 -4.205244152224792e-06,  4.567838622843957e-07, -3.993111789053572e-08,  2.922235156515774e-09, -1.840068549583524e-10,  1.017252669714371e-11, -5.014298909107217e-13,
  2.230898339859239e-14, -9.035971019187675e-16,  2.842690048871826e-04, -1.156033226643698e-04,  2.501387085564188e-05, -3.674576444794166e-06,  4.084303953632786e-07,
 -3.651993692164590e-08,  2.732398828656917e-09, -1.758189017012506e-10,  9.927834356617326e-12, -4.996014422037943e-13,  2.268183839390640e-14, -9.369972145977608e-16,
  2.311918789526649e-04, -9.577881490860158e-05,  2.115343057876555e-05, -3.172334370308505e-06,  3.598842192721426e-07, -3.283178601731894e-08,  2.505271181658117e-09,
 -1.643393754239823e-10,  9.456139000518422e-12, -4.847138866120267e-13,  2.240600358269770e-14, -9.420073443569245e-16,  1.866255468750786e-04, -7.857114229633531e-05,
  1.766629270608987e-05, -2.697681232537605e-06,  3.115607707999443e-07, -2.892767946259332e-08,  2.245767170282876e-09, -1.498260024106034e-10,  8.764715848096778e-12,
 -4.565953697377584e-13,  2.144263409619531e-14, -9.155162434905587e-16,  1.487811296537761e-04, -6.350479485173587e-05,  1.449939618996734e-05, -2.248702936308547e-06,
  2.637298405663049e-07, -2.485981977099210e-08,  1.958810536477272e-09, -1.325949366825367e-10,  7.867855294183342e-12, -4.156194397636966e-13,  1.978594722610198e-14,
 -8.560789519567793e-16,  1.161851021278153e-04, -5.016208460921267e-05,  1.160077630386815e-05, -1.822672046790738e-06,  2.165346089702118e-07, -2.067143346064606e-08,
  1.649177099534856e-09, -1.130044757817605e-10,  6.785916700971054e-12, -3.626779248879119e-13,  1.746408895631973e-14, -7.640914436868697e-16,  8.761032980982407e-05,
 -3.817424157470981e-05,  8.920130933204235e-06, -1.416265699934007e-06,  1.700120929669494e-07, -1.639724639701011e-08,  1.321399566419527e-09, -9.144132963250898e-11,
  5.544305037519629e-12, -2.991320699334108e-13,  1.453795557071695e-14, -6.418306603783573e-16,  6.201845242994654e-05, -2.721252004386114e-05,  6.409020624616694e-06,
 -1.025742300025436e-06,  1.241140213313908e-07, -1.206447200078519e-08,  9.797306048790641e-10, -6.831007419573235e-11,  4.172459587856858e-12, -2.267481209846741e-13,
  1.109821509167787e-14, -4.933609734418947e-16,  3.851242477049105e-05, -1.698005148492241e-05,  4.020921533150951e-06, -6.471020012778482e-07,  7.872978203428157e-08,
 -7.694412269664428e-09,  6.281752242094153e-10, -4.402719095026380e-11,  2.702990021876740e-12, -1.476270351230628e-13,  7.261048622955176e-15, -3.243273151458488e-16,
  1.631935583070450e-05, -7.214391529198223e-06,  1.713555486378912e-06, -2.766165917032833e-07,  3.375735450920066e-08, -3.309097451570882e-09,  2.709545914353003e-10,
 -1.904554782151456e-11,  1.172595582831525e-12, -6.422076163863922e-14,  3.167300110507634e-15, -1.418486303263869e-16,  6.670401595399800e-02, -1.858878801924663e-04,
  5.407480374370944e-07, -1.627050679387950e-09,  5.013811439917451e-12, -1.568770153824602e-14,  4.950903763844217e-17, -1.568669374531583e-19,  4.974580386839064e-22,
 -1.575923418048272e-24,  4.981557286598302e-27, -1.570281987993366e-29,  6.560858799636098e-02, -2.495424841532573e-04,  1.111303478464142e-06, -5.044553274932571e-09,
  2.242765415204207e-11, -9.713179576451789e-14,  4.108126038585286e-16, -1.702635489710909e-18,  6.935137103128887e-21, -2.782447321298969e-23,  1.101541719607419e-25,
 -4.309003983742392e-28,  6.347531850471362e-02, -3.703226399189818e-04,  2.387021257274875e-06, -1.439201407186850e-08,  8.156167246158322e-11, -4.407503060246298e-13,
  2.293580142941050e-15, -1.156909608455489e-17,  5.682934414004882e-20, -2.728047241462044e-22,  1.283277278176793e-24, -5.928120095714267e-27,  6.041406575167183e-02,
 -5.360415696100025e-04,  4.595801948941868e-06, -3.489753982701885e-08,  2.434589553836733e-10, -1.594870494449987e-12,  9.939581654283871e-15, -5.945061236794145e-17,
  3.434179035649172e-19, -1.924954846391369e-21,  1.050851303548307e-23, -5.603252075849047e-26,  5.657704744032706e-02, -7.304466296106718e-04,  7.987112285344325e-06,
 -7.465810823973547e-08,  6.287499821409453e-10, -4.900569094736818e-12,  3.592995008971313e-14, -2.505350510166664e-16,  1.674500768541270e-18, -1.079065280827714e-20,
  6.734673636997620e-23, -4.085370081648973e-25,  5.214563507355779e-02, -9.352627256940724e-04,  1.274852539589041e-05, -1.443603391050090e-07,  1.445841742362261e-09,
 -1.322192934834610e-11,  1.125644386744861e-13, -9.038226412585365e-16,  6.908039270923781e-18, -5.060595814188596e-20,  3.572088988770396e-22, -2.439586716781661e-24,
  4.731551916524410e-02, -1.132356800795434e-03,  1.893176476665056e-05, -2.562495178986165e-07,  3.015368563884287e-09, -3.199738808100371e-11,  3.130809285516240e-13,
 -2.866900417464364e-15,  2.482874207569419e-17, -2.049639121492439e-19,  1.622520023844298e-21, -1.237461159909243e-23,  4.228199098613884e-02, -1.305697733233509e-03,
  2.640633956209272e-05, -4.222666452733266e-07,  5.778597231898424e-09, -7.049960917814877e-11,  7.860745140815797e-13, -8.143796013293158e-15,  7.931555048559431e-17,
 -7.325342339138701e-19,  6.458501425887476e-21, -5.464232089132051e-23,  3.722689915619606e-02, -1.442850770444982e-03,  3.485123476024280e-05, -6.515948935197172e-07,
  1.027745521507941e-08, -1.430091597775374e-10,  1.803791841411351e-12, -2.099822152919795e-14,  2.285062597942975e-16, -2.346641904770679e-18,  2.290808644359798e-20,
 -2.137893784062924e-22,  3.230844292425233e-02, -1.535850974025834e-03,  4.378543806778431e-05, -9.481322831693534e-07,  1.709873197886644e-08, -2.694381436204579e-10,
  3.819450707522166e-12, -4.965986230233344e-14,  6.003968920192923e-16, -6.819097186236868e-18,  7.332859185800710e-20, -7.511484003559460e-22,  2.765445110355491e-02,
 -1.581419819879812e-03,  5.262910821876329e-05, -1.308527002497794e-06,  2.678444769522334e-08, -4.748763943418561e-10,  7.521155029462648e-12, -1.086255143468955e-13,
  1.451661229178064e-15, -1.814665575806286e-17,  2.139685313978030e-19, -2.395205006663042e-21,  2.335926797007309e-02, -1.580597274457531e-03,  6.078115551575099e-05,
 -1.721327971599390e-06,  3.972172541791077e-08, -7.876528069435758e-10,  1.386279784932920e-11, -2.212956398832086e-13,  3.253722414327290e-15, -4.456998218013672e-17,
  5.738316840887253e-19, -6.991623492863048e-21,  1.948391307610695e-02, -1.537939107490972e-03,  6.769704660411656e-05, -2.167544862751400e-06,  5.603470601537476e-08,
 -1.235824921260053e-09,  2.404915769137600e-11, -4.223614133039491e-13,  6.802820105935159e-15, -1.016982323356247e-16,  1.424183610431297e-18, -1.881727521402957e-20,
  1.605885983377381e-02, -1.460466634646480e-03,  7.295263012624489e-05, -2.622567160562208e-06,  7.550442601151739e-08, -1.842461733236605e-09,  3.945644762149144e-11,
 -7.590641185453666e-13,  1.333898756238652e-14, -2.167985831364516e-16,  3.290428122182971e-18, -4.698344772343511e-20,  1.308861149635779e-02, -1.356554463261236e-03,
  7.628456967455520e-05, -3.059071101766179e-06,  9.753842508497661e-08, -2.620526922848856e-09,  6.148198025352163e-11, -1.290334920915374e-12,  2.464489880431357e-14,
 -4.339201756976582e-16,  7.113313061372350e-18, -1.094101377750502e-19,  1.055723395170322e-02, -1.234909949531631e-03,  7.760392686731078e-05, -3.450337726311179e-06,
  1.212011605635453e-07, -3.568441668964783e-09,  9.133515610638098e-11, -2.083016938079518e-12,  4.308438185130845e-14, -8.189722396886512e-16,  1.445419333618254e-17,
 -2.387454799594616e-19,  8.434100436402296e-03, -1.103748860811590e-03,  7.698496921324153e-05, -3.773359464167158e-06,  1.453023531587475e-07, -4.667394088033170e-09,
  1.298013897141869e-10, -3.204912534230500e-12,  7.153809259870589e-14, -1.463306284188365e-15,  2.771918073617513e-17, -4.902285170927369e-19,  6.679270432438436e-03,
 -9.702183082351134e-04,  7.463525090215473e-05, -4.011217899423768e-06,  1.685273931909232e-07, -5.881147673894604e-09,  1.770242857637192e-10, -4.715192683369123e-12,
  1.132050970596688e-13, -2.483988302821506e-15,  5.035292771654217e-17, -9.508020034619578e-19,  5.248119962808628e-03, -8.400708479604801e-04,  7.085493566116141e-05,
 -4.154421700523130e-06,  1.895855080958062e-07, -7.158569629095755e-09,  2.323540703755925e-10, -6.653535341742511e-12,  1.712645438088692e-13, -4.019029001404499e-15,
  8.693203515613783e-17, -1.747849557663792e-18,  4.095027464009711e-03, -7.175590796465552e-04,  6.599330470242650e-05, -4.201133235409376e-06,  2.073493830233273e-07,
 -8.438507703358607e-09,  2.943001365438250e-10, -9.029956684414178e-12,  2.484263744066448e-13, -6.216514312111514e-15,  1.430804648480306e-16, -3.054992640876223e-18,
  3.176074549749844e-03, -6.055001962398248e-04,  6.040893461365694e-05, -4.156422592743718e-06,  2.209640852988684e-07, -9.656158699867636e-09,  3.606050015665917e-10,
 -1.181744234744078e-11,  3.464346563133694e-13, -9.217802069652518e-15,  2.251433700216864e-16, -5.091800656589987e-18,  2.450832894291185e-03, -5.054535033382249e-04,
  5.443782273014619e-05, -4.030827629044538e-06,  2.299115420734906e-07, -1.074981504502854e-08,  4.284317684623795e-10, -1.494909177708167e-11,  4.656106224982686e-13,
 -1.313646182502574e-14,  3.395943401597428e-16, -8.114421992228146e-18,  1.883376106597939e-03, -4.179576549762825e-04,  4.837142097998811e-05, -3.838554369248200e-06,
  2.340267449246167e-07, -1.166689014340275e-08,  4.946343125257111e-10, -1.832064532579829e-11,  6.045263666389866e-13, -1.803601498347436e-14,  4.922086807513608e-16,
 -1.239526955274341e-17,  1.442684801444095e-03, -3.427842748583966e-04,  4.244457755664072e-05, -3.595633097321231e-06,  2.334707491323781e-07, -1.236837021809388e-08,
  5.560646732840456e-10, -2.179819839162695e-11,  7.598816692979934e-13, -2.391034518956673e-14,  6.870983958418147e-16, -1.819193559533064e-17,  1.102613616712217e-03,
 -2.791770862419773e-04,  3.683202177222506e-05, -3.318275579306514e-06,  2.286716679642398e-07, -1.283122609091185e-08,  6.098684329892103e-10, -2.522990481285675e-11,
  9.266198018997065e-13, -3.067059788388241e-14,  9.257551091328981e-16, -2.570807054212883e-17,  8.415709045164175e-04, -2.260578838065688e-04,  3.165130522580250e-05,
 -3.021586056483560e-06,  2.202475804585754e-07, -1.304873127129492e-08,  6.537257525093638e-10, -2.845978009314855e-11,  1.098272944312496e-12, -3.814142866114502e-14,
  1.206269090105215e-15, -3.505138511853540e-17,  6.420342804676810e-04, -1.821909369475807e-04,  2.696993831231037e-05, -2.718687192911639e-06,  2.089248763847586e-07,
 -1.302897797646670e-08,  6.860100845763235e-10, -3.134147149588013e-11,  1.267485681946405e-12, -4.606781777100353e-14,  1.522877218518501e-15, -4.619551463014892e-17,
  4.899950563226151e-04, -1.463049709548821e-04,  2.281467311241252e-05, -2.420248272870743e-06,  1.954629620071661e-07, -1.279210331634690e-08,  7.058539702685131e-10,
 -3.375006929651850e-11,  1.426635849724869e-12, -5.413175907269359e-14,  1.865942183862414e-15, -5.895269367945551e-17,  3.743963673275178e-04, -1.171767017499118e-04,
  1.918130964629910e-05, -2.134353946095059e-06,  1.805925584016784e-07, -1.236681942674744e-08,  7.131274969298351e-10, -3.559058057751678e-11,  1.568461259812850e-12,
 -6.197642395893842e-14,  2.222391537271209e-15, -7.296287457096024e-17,  2.866060211166401e-04, -9.368240513685126e-05,  1.604389750382233e-05, -1.866627725881318e-06,
  1.649710367189375e-07, -1.178680372720651e-08,  7.083469371483599e-10, -3.680240083026136e-11,  1.686608716200148e-12, -6.923427122779062e-14,  2.576566379252207e-15,
 -8.770235415471913e-17,  2.199466431504717e-04, -7.482477328112198e-05,  1.336266823995572e-05, -1.620520628050739e-06,  1.491550472623002e-07, -1.108738814746637e-08,
  6.925374556303645e-10, -3.735982241150316e-11,  1.776043800622290e-12, -7.555521287302059e-14,  2.911363688363828e-15, -1.025117577930704e-16,  1.692924329021543e-04,
 -5.974195092075391e-05,  1.109040986779963e-05, -1.397685206340700e-06,  1.335884590441809e-07, -1.030283300776140e-08,  6.670747633468007e-10, -3.726917724319223e-11,
  1.833289324099446e-12, -8.063133248183112e-14,  3.209516855152368e-15, -1.166401115315064e-16,  1.307330559234051e-04, -4.770466299964274e-05,  9.177264013016656e-06,
 -1.198372287048916e-06,  1.186023844618235e-07, -9.464319467662930e-09,  6.335274676725192e-10, -3.656355257495158e-11,  1.856489950551168e-12, -8.421559714567355e-14,
  3.454851276517865e-15, -1.292993799352105e-16,  1.012999310771729e-04, -3.810612415971484e-05,  7.574094115341881e-06, -1.021806714831576e-06,  1.044236727935805e-07,
 -8.598668908530854e-09,  5.935163171974516e-10, -3.529613503320606e-11,  1.845324730534044e-12, -8.613322657101411e-14,  3.633373211696249e-15, -1.397226726513089e-16,
  7.874747876125706e-05, -3.044820748178468e-05,  6.234657976643826e-06, -8.665159030433867e-07,  9.118847491556032e-08, -7.727709931840445e-09,  5.486002147884167e-10,
 -3.353316851917623e-11,  1.800805008060773e-12, -8.628560325650407e-14,  3.734091859437998e-15, -1.472194200813337e-16,  6.138094574937925e-05, -2.432628374711565e-05,
  5.116842885322687e-06, -7.305990865444519e-07,  7.895805655821098e-08, -6.868164730281484e-09,  5.001930341865609e-10, -3.134731919594195e-11,  1.725001752889386e-12,
 -8.464760757911561e-14,  3.749525442307587e-15, -1.512219869899696e-16,  4.792255776100188e-05, -1.941428157105210e-05,  4.183208207092830e-06, -6.119353264125898e-07,
  6.773475450200243e-08, -6.031910376212460e-09,  4.495106809973297e-10, -2.881199270172154e-11,  1.620745115422003e-12, -8.125991980368411e-14,  3.675891140210960e-15,
 -1.513200407129528e-16,  3.740848887726170e-05, -1.545086929910694e-05,  3.401046362224738e-06, -5.083347665876234e-07,  5.747667686624378e-08, -5.226477865315952e-09,
  3.975447729630073e-10, -2.599690055233242e-11,  1.491332264257081e-12, -7.621812186955623e-14,  3.513017947264079e-15, -1.472810639508232e-16,  2.911014664179719e-05,
 -1.222719889638198e-05,  2.742131220315194e-06, -4.176410740842986e-07,  4.811035517005948e-08, -4.455673082392363e-09,  3.450577087120553e-10, -2.296496194276057e-11,
  1.340269968279977e-12, -6.966040350884460e-14,  3.264046663493269e-15, -1.390572987284521e-16,  2.247434293859779e-05, -9.576345110430108e-06,  2.182281277572942e-06,
 -3.377942241969251e-07,  3.954102380576887e-08, -3.720231262051062e-09,  2.925934734721688e-10, -1.977047248721633e-11,  1.171068211515589e-12, -6.175541988685220e-14,
  2.934991635684274e-15, -1.267808504321948e-16,  1.707793194031733e-05, -7.364382909923689e-06,  1.700828054011281e-06, -2.668625916377107e-07,  3.166053005394526e-08,
 -3.018444334538317e-09,  2.404989436346218e-10, -1.645837631945452e-11,  9.870920266972447e-13, -5.269146357466301e-14,  2.534236639144972e-15, -1.107495424291974e-16,
  1.259338770290880e-05, -5.482939764393901e-06,  1.280050016459188e-06, -2.030523307428383e-07,  2.435308655870188e-08, -2.346725637452259e-09,  1.889513820664097e-10,
 -1.306443706187343e-11,  7.914717169221419e-13, -4.266769787835482e-14,  2.072026302711874e-15, -9.140641167567952e-17,  8.762553133879041e-06, -3.843014016922140e-06,
  9.046103786067018e-07, -1.447009157747669e-07,  1.749921834747150e-08, -1.700099442783703e-09,  1.379891616969327e-10, -9.616116635131772e-12,  5.870677548766683e-13,
 -3.188785956703021e-14,  1.560000764271202e-15, -6.931566966925016e-17,  5.376530374893709e-06, -2.369894878131427e-06,  5.610344596258514e-07, -9.026267339536599e-08,
  1.097858915213843e-08, -1.072646106753975e-09,  8.754618269270884e-11, -6.134156220365826e-12,  3.764938169518525e-13, -2.055705872060112e-14,  1.010830200399547e-15,
 -4.513865399295505e-17,  2.263069793349770e-06, -1.000314381221908e-06,  2.375574142202819e-07, -3.834251908039897e-08,  4.678457950416266e-09, -4.585389432471838e-10,
  3.754016505355258e-11, -2.638316411432688e-12,  1.624112880043571e-13, -8.893624243691025e-15,  4.385597161363184e-16, -1.963820922770430e-17,  6.596899464036041e-02,
 -1.816386540020193e-04,  5.216946064218755e-07, -1.549276630479028e-09,  4.711592882918246e-12, -1.455044419691613e-14,  4.533136225105766e-17, -1.418188653573069e-19,
  4.441511456872520e-22, -1.389810252527501e-24,  4.340018231540784e-27, -1.351640796793341e-29,  6.462782395120976e-02, -2.408882387994180e-04,  1.052859479022646e-06,
 -4.700731965666210e-09,  2.057987746848053e-11, -8.782019738345299e-14,  3.661010203363311e-16, -1.495923331213379e-18,  6.008403837201748e-21, -2.377508071256879e-23,
  9.284387705594045e-26, -3.582996642154317e-28,  6.203115695233102e-02, -3.518957528027567e-04,  2.221865509567122e-06, -1.315466308648041e-08,  7.327191163467730e-11,
 -3.893948365769689e-13,  1.993696364244116e-15, -9.898273999428997e-18,  4.787277875263019e-20, -2.263311209495595e-22,  1.048802659007516e-24, -4.773791267156261e-27,
  5.834087048626036e-02, -5.008863578112156e-04,  4.199391406619807e-06, -3.124495902642114e-08,  2.138183673690409e-10, -1.375115387628966e-12,  8.418949498817305e-15,
 -4.949347376035347e-17,  2.811271571244696e-19, -1.550053828498563e-21,  8.326274617716856e-24, -4.369720365595514e-26,  5.377761269099132e-02, -6.699694564090495e-04,
  7.148486112905762e-06, -6.533762750406414e-08,  5.388234096749623e-10, -4.116716261367967e-12,  2.961025870842402e-14, -2.026797451998864e-16,  1.330487383886477e-18,
 -8.424604733993756e-21,  5.168467250882753e-23, -3.082956883123457e-25,  4.859811904911611e-02, -8.398297345018227e-04,  1.114672865916585e-05, -1.232037715068179e-07,
  1.206491048053025e-09, -1.080067747914338e-11,  9.009683550052382e-14, -7.093538054136563e-16,  5.319491508731078e-18, -3.825402584872151e-20,  2.651871975144892e-22,
 -1.779398996833872e-24,  4.307062219718322e-02, -9.924285921116087e-04,  1.612637924421372e-05, -2.127407061897622e-07,  2.444494712578432e-09, -2.536333871085806e-11,
  2.429052225227483e-13, -2.178906575915492e-15,  1.849793731588833e-17, -1.497756914756896e-19,  1.163506464638798e-21, -8.712031498311313e-24,  3.745169486468151e-02,
 -1.113244902030113e-03,  2.185047572740815e-05, -3.401366502877547e-07,  4.540177785956920e-09, -5.410602555187098e-11,  5.899470969582775e-13, -5.982129744635477e-15,
  5.706783503661201e-17, -5.165856187812682e-19,  4.466514592890174e-21, -3.707685770715354e-23,  3.196727267908750e-02, -1.192725007008445e-03,  2.793145242721941e-05,
 -5.078709094622863e-07,  7.806518819303954e-09, -1.060194426847497e-10,  1.306674158723865e-12, -1.487773406745843e-14,  1.584794380762601e-16, -1.594189275083044e-18,
  1.525316629571598e-20, -1.395940322683381e-22,  2.679961201975551e-02, -1.226806349573724e-03,  3.388642943792786e-05, -7.131185314261424e-07,  1.252433523739619e-08,
 -1.924940893893670e-10,  2.664737461972881e-12, -3.386777623831756e-14,  4.006008574109782e-16, -4.454579143251710e-18,  4.692828466170922e-20, -4.712100244682244e-22,
  2.208079751178061e-02, -1.216573749077492e-03,  3.921382810810773e-05, -9.470953405520664e-07,  1.887040121133905e-08, -3.261669448929730e-10,  5.042456336360807e-12,
 -7.115934367886267e-14,  9.300040737245699e-16, -1.137789862840389e-17,  1.313857762138317e-19, -1.441224838866421e-21,  1.789236726291544e-02, -1.167256911429134e-03,
  4.347192581106229e-05, -1.195640328005500e-06,  2.684888874473245e-08, -5.188734541688031e-10,  8.911382846290591e-12, -1.389583316312743e-13,  1.997534444089726e-15,
 -2.677275167279554e-17,  3.374951590089002e-19, -4.028654992839473e-21,  1.426985100448024e-02, -1.086856462025845e-03,  4.634177081269974e-05, -1.440979527867680e-06,
  3.624617787888046e-08, -7.789860860578490e-10,  1.479021277835321e-11, -2.536942842294956e-13,  3.994430070823559e-15, -5.841950702881104e-17,  8.009219692556096e-19,
 -1.036653093996318e-20,  1.121060286293667e-02, -9.846905278777978e-04,  4.766304764840690e-05, -1.664281695497185e-06,  4.662486951677723e-08, -1.108713207401451e-09,
  2.316528260707722e-11, -4.352535355120017e-13,  7.476825568887849e-15, -1.188835074171096e-16,  1.766411154361816e-18, -2.470784239810047e-20,  8.683249410175415e-03,
 -8.701002553718341e-04,  4.743948503429467e-05, -1.848416066002051e-06,  5.736286107405295e-08, -1.502077154198937e-09,  3.438806650286964e-11, -7.049446570676109e-13,
  1.316296435898809e-14, -2.267506883936390e-16,  3.639365960923684e-18, -5.484080659051376e-20,  6.637288348929318e-03, -7.514664401079146e-04,  4.581768833678674e-05,
 -1.980309597722843e-06,  6.773108444884341e-08, -1.944207652428604e-09,  4.857056433358056e-11, -1.082238370859250e-12,  2.188861436030499e-14, -4.071633994645202e-16,
  7.037110817980466e-18, -1.138971566635512e-19,  5.011752576308825e-03, -6.355974149142633e-04,  4.304809663918582e-05, -2.052456404933349e-06,  7.699324595497557e-08,
 -2.412284717075203e-09,  6.550486376483973e-11, -1.580734279999155e-12,  3.451365833264650e-14, -6.910747234886593e-16,  1.282332624443059e-17, -2.222912067159879e-19,
  3.742286559080238e-03, -5.274711508469916e-04,  3.943847466249777e-05, -2.063383739212921e-06,  8.450593463880321e-08, -2.878041056203080e-09,  8.463061204516988e-11,
 -2.204166609488745e-12,  5.178579071292282e-14, -1.112779547382708e-15,  2.210477887607769e-17, -4.092804766088721e-19,  2.766378447653506e-03, -4.302633903494481e-04,
  3.530932988351141e-05, -2.017137857736469e-06,  8.979887860456302e-08, -3.311331635095025e-09,  1.050637693092221e-10, -2.943421931671362e-12,  7.418210942863360e-14,
 -1.705642827555523e-15,  3.617092796202316e-17, -7.134398892272728e-19,  2.026798256285464e-03, -3.455705206011745e-04,  3.095788917589490e-05, -1.922046972901475e-06,
  9.262172860013833e-08, -3.684027121709064e-09,  1.256850112873036e-10, -3.775416280583720e-12,  1.017608829538450e-13, -2.496458865527986e-15,  5.636622401224618e-17,
 -1.181305248941412e-18,  1.473490116568719e-03, -2.737360800280589e-04,  2.663392215602957e-05, -1.789110863129902e-06,  9.295284777827057e-08, -3.973454911095245e-09,
  1.452714098219725e-10, -4.664284710460854e-12,  1.340591066762462e-13, -3.499384470875537e-15,  8.390106713348926e-17, -1.863658237247960e-18,  1.064261817714644e-03,
 -2.142052447201649e-04,  2.252769430237125e-05, -1.630359296465830e-06,  9.097422730952406e-08, -4.164782495655801e-09,  1.626451609310416e-10, -5.564792022326414e-12,
  1.700644757827985e-13, -4.710708165070575e-15,  1.196263835371314e-16, -2.809406410014152e-18,  7.646298631815543e-04, -1.658540532477085e-04,  1.876821610391371e-05,
 -1.457442620552873e-06,  8.702263706201232e-08, -4.252036174575923e-09,  1.768107579553022e-10, -6.427350728600336e-12,  2.082746432160312e-13, -6.105708546622226e-15,
  1.638124444615812e-16, -4.057660899159988e-18,  5.471407942643669e-04, -1.272628685148198e-04,  1.542887364398940e-05, -1.280606583214631e-06,  8.152954422293933e-08,
 -4.237771176176824e-09,  1.870570091542640e-10, -7.203687746275595e-12,  2.468368150958627e-13, -7.638488195818359e-15,  2.159789747795938e-16, -5.629243388668320e-18,
  3.904253346706863e-04, -9.692249808646590e-05,  1.253733984729533e-05, -1.108094697120024e-06,  7.496149402867756e-08, -4.131668367117139e-09,  1.930102904880431e-10,
 -7.852120205334056e-12,  2.837428680612171e-13, -9.245041255731710e-15,  2.748175891143765e-16, -7.519246682377693e-18,  2.781708628510416e-04, -7.337473535190345e-05,
  1.008708643750692e-05, -9.459381699314062e-07,  6.776962849285077e-08, -3.948477298498359e-09,  1.946369503518124e-10, -8.341576362475618e-12,  3.170442758564806e-13,
 -1.084910820632434e-14,  3.382301242221665e-16, -9.692271567424551e-18,  1.981326288962701e-04, -5.529685108356799e-05,  8.048535965309504e-06, -7.980445991537122e-07,
  6.035313650689023e-08, -3.705748575577333e-09,  1.922026441838593e-10, -8.653847442454056e-12,  3.450495864173750e-13, -1.236979334634178e-14,  4.034823508346906e-16,
 -1.208153253365485e-17,  1.412514801493507e-04, -4.154278954196881e-05,  6.378661715595493e-06, -6.664801630988996e-07,  5.303779322233936e-08, -3.421727109737280e-09,
  1.862025521890783e-10, -8.783962491736840e-12,  3.664742851329701e-13, -1.372961789347708e-14,  4.674487191034337e-16, -1.459227308452517e-17,  1.009074267039807e-04,
 -3.115391090896511e-05,  5.028502603747998e-06, -5.518474257909845e-07,  4.606804049152055e-08, -3.113654353675249e-09,  1.772783756047419e-10, -8.738931693818196e-12,
  3.805255450789336e-13, -1.486170550454605e-14,  5.269066219345583e-16, -1.710906630661560e-17,  7.231303502276888e-05, -2.335041278805506e-05,  3.948539346473093e-06,
 -4.536817667984063e-07,  3.960951503248098e-08, -2.796594105445481e-09,  1.661363885610200e-10, -8.535333639677014e-12,  3.869185694495940e-13, -1.571509867139939e-14,
  5.788320104025990e-16, -1.950583196756181e-17,  5.203584873063177e-05, -1.751210706546978e-05,  3.092170921589033e-06, -3.708147961678477e-07,  3.375843802585517e-08,
 -2.482783468889330e-09,  1.534769887783772e-10, -8.196307286524684e-12,  3.858333851275029e-13, -1.625766767368422e-14,  6.206524906835907e-16, -2.165695840323081e-17,
  3.763191428858240e-05, -1.315472184387563e-05,  2.417667667756940e-06, -3.016766579221641e-07,  2.855454670940076e-08, -2.181433562877276e-09,  1.399415914991932e-10,
 -7.748469438160768e-12,  3.778288159798671e-13, -1.647656272455032e-14,  6.504266839751822e-16, -2.344785293245449e-17,  2.737041737918959e-05, -9.905725114638253e-06,
  1.889004641362629e-06, -2.445275628929649e-07,  2.399493985124570e-08, -1.898865742200058e-09,  1.260784994254239e-10, -7.219156848156033e-12,  3.637333271676875e-13,
 -1.637656201060378e-14,  6.669353581643731e-16, -2.478352410305965e-17,  2.003033674382850e-05, -7.481978664999957e-06,  1.475940217724504e-06, -1.976212891307275e-07,
  2.004703887010648e-08, -1.638861824890024e-09,  1.123262332533939e-10, -6.634236916826824e-12,  3.445311817847501e-13, -1.597691893447707e-14,  6.696862285606006e-16,
 -2.559430633644250e-17,  1.475241038897870e-05, -5.670332322481511e-06,  1.153635564314042e-06, -1.593103164476454e-07,  1.665963940041651e-08, -1.403120682251293e-09,
  9.901093652987001e-11, -6.016582409599473e-12,  3.212583252986398e-13, -1.530739838851987e-14,  6.588470476387328e-16, -2.583842285012980e-17,  1.093261864933827e-05,
 -4.311489097469260e-06,  9.020344556681868e-07, -1.281050017423324e-07,  1.377164127081153e-08, -1.191738109022909e-09,  8.635375237146611e-11, -5.385188719517072e-12,
  2.949172027581182e-13, -1.440414175817727e-14,  6.351289999248757e-16, -2.550161044416691e-17,  8.146254773629531e-06, -3.287013340873699e-06,  7.051537346975659e-07,
 -1.026991723688287e-07,  1.131846788576287e-08, -1.003653928008633e-09,  7.448420713932318e-11, -4.754836780320514e-12,  2.664146386400979e-13, -1.330586211226597e-14,
  5.996444432472140e-16, -2.459440932566369e-17,  6.094191805987517e-06, -2.509121020766714e-06,  5.503787212628639e-07, -8.197294463330668e-08,  9.236434737028140e-09,
 -8.370345218583843e-10,  6.345628360747035e-11, -4.136169024227723e-12,  2.365228150320866e-13, -1.205069618069532e-14,  5.537607939162797e-16, -2.314791733445223e-17,
  4.565058231791774e-06, -1.912803835218329e-06,  4.278162622315139e-07, -6.498137100155922e-08,  7.465439288897400e-09, -6.895778635990276e-10,  5.326472496414049e-11,
 -3.536041254757150e-12,  2.058606302360254e-13, -1.067387014873995e-14,  4.989674765112216e-16, -2.120883312790061e-17,  3.408700280767442e-06, -1.449837181876359e-06,
  3.297294455291627e-07, -5.093526462402021e-08,  5.950363867552226e-09, -5.587410832134504e-10,  4.385996810631202e-11, -2.958029163210269e-12,  1.748912885669638e-13,
 -9.206198662112982e-15,  4.367669794014514e-16, -1.883450985313412e-17,  2.517583142248590e-06, -1.084264612772989e-06,  2.500596808814788e-07, -3.917855914667423e-08,
  4.641547652318450e-09, -4.418983236228393e-10,  3.516083726082196e-11, -2.402994469580575e-12,  1.439316193547786e-13, -7.673342261469007e-15,  3.685954577029066e-16,
 -1.608856381682913e-17,  1.813733167135009e-06, -7.890119511234990e-07,  1.840311534926930e-07, -2.916496611123951e-08,  3.494622874677324e-09, -3.364403519786364e-10,
  2.706469057575099e-11, -1.869644905884104e-12,  1.131690289539173e-13, -6.095698151030637e-15,  2.957738301822781e-16, -1.303738343480898e-17,  1.239517404721332e-06,
 -5.433478422479942e-07,  1.278273162251725e-07, -2.043552792936403e-08,  2.469946430207329e-09, -2.398286982974721e-10,  1.945512783964038e-11, -1.355051339573881e-12,
  8.268293585667071e-14, -4.488790975474944e-15,  2.194875274605716e-16, -9.747712360871292e-18,  7.510709673466309e-07, -3.309727907051496e-07,  7.832881419027600e-08,
 -1.259814529316259e-08,  1.531834848976891e-09, -1.496202768486043e-10,  1.220792288930124e-11, -8.551299628951032e-13,  5.246988262303539e-14, -2.864114733431432e-15,
  1.407949442854156e-16, -6.285494130595030e-18,  3.139339273835563e-07, -1.387448790384994e-07,  3.294433177082802e-08, -5.316462740879418e-09,  6.485968055507177e-10,
 -6.355924137390082e-11,  5.202711531461021e-12, -3.655883318759805e-13,  2.250165041875238e-14, -1.231999446722314e-15,  6.074281464924360e-17, -2.719590753421487e-18,
  6.525067117359948e-02, -1.775382026148586e-04,  5.035461843386880e-07, -1.476161425128892e-09,  4.431149989121762e-12, -1.350858165203911e-14,  4.155212438845042e-17,
 -1.283741832178666e-19,  3.971046871736930e-22, -1.227534397392431e-24,  3.787325071413543e-27, -1.165510774178743e-29,  6.368076722255100e-02, -2.326855308291597e-04,
  9.983699107594611e-07, -4.385041622211256e-09,  1.890805403156008e-11, -7.951544271777226e-14,  3.267831982868858e-16, -1.316661818492714e-18,  5.215718237965886e-21,
 -2.035822513997316e-23,  7.843299101140526e-26, -2.986606860274167e-28,  6.065815141166629e-02, -3.347328980394717e-04,  2.070794826646111e-06, -1.204210710492937e-08,
  6.594091646604628e-11, -3.447060849808853e-13,  1.736822225429028e-15, -8.489008517661642e-18,  4.043200106345350e-20, -1.882946123635441e-22,  8.596996142947187e-25,
 -3.856257683106144e-27,  5.640222013823783e-02, -4.687348471128569e-04,  3.844105202262644e-06, -2.803335882772826e-08,  1.882293992820562e-10, -1.188723203648361e-12,
  7.151125702011623e-15, -4.132953607183867e-17,  2.308841778983836e-19, -1.252482907209723e-21,  6.621303085014080e-24, -3.420836984516159e-26,  5.120734394648607e-02,
 -6.157772294491389e-04,  6.413564599886270e-06, -5.733836218256810e-08,  4.631595937556611e-10, -3.469626005126799e-12,  2.448838840523691e-14, -1.645828070048358e-16,
  1.061362797442770e-18, -6.604967392580311e-21,  3.983956937358041e-23, -2.337203388166848e-25,  4.540822685326913e-02, -7.562572066010058e-04,  9.777341010788463e-06,
 -1.055169594510310e-07,  1.010586190287465e-09, -8.858663931364199e-12,  7.242478514049036e-14, -5.592610231939192e-16,  4.115808957751815e-18, -2.906136737967883e-20,
  1.978956320261464e-22, -1.304879650203533e-24,  3.934365193309813e-02, -8.730008021836979e-04,  1.379239457651124e-05, -1.773897771532954e-07,  1.990909091854645e-09,
 -2.020351606746079e-11,  1.894322732958003e-13, -1.664960743167740e-15,  1.385890260316220e-17, -1.100868511201290e-19,  8.393963928312970e-22, -6.171812652301888e-24,
  3.332411345083787e-02, -9.536102385839784e-04,  1.817132782422508e-05, -2.754349246152919e-07,  3.587074920496454e-09, -4.176695906067178e-11,  4.454466092822069e-13,
 -4.421987445790714e-15,  4.132871293407860e-17, -3.667537217576338e-19,  3.110356176277297e-21, -2.533751697514840e-23,  2.760747607569052e-02, -9.916785610823357e-04,
  2.252161029638211e-05, -3.983577820980827e-07,  5.968740124153514e-09, -7.913421840330272e-11,  9.532433687453158e-13, -1.061794111681865e-14,  1.107353297291218e-16,
 -1.091331226460126e-18,  1.023614216844843e-20, -9.188205516252988e-23,  2.238482267566323e-02, -9.868095008586369e-04,  2.641473086530333e-05, -5.403515420177355e-07,
  9.244080093646021e-09, -1.386075527708653e-10,  1.874166313228453e-12, -2.328912022501499e-14,  2.695577263516040e-16, -2.935151967817229e-18,  3.029803004657552e-20,
 -2.982584123486533e-22,  1.777658710103225e-02, -9.436471388589030e-04,  2.946455643599986e-05, -6.914017177186869e-07,  1.341175911818705e-08, -2.260396999205421e-10,
  3.411630486006861e-12, -4.705092868248076e-14,  6.014666265610539e-16, -7.202820128947089e-18,  8.146796681962717e-20, -8.758364667787476e-22,  1.383737959522523e-02,
 -8.702886103017359e-04,  3.139359547590043e-05, -8.386609034761914e-07,  1.832885837134013e-08, -3.452725202889987e-10,  5.787293484782766e-12, -8.816437150823221e-14,
  1.239262671540825e-15, -1.625380854945812e-17,  2.006393459842323e-19, -2.346708792254716e-21,  1.056688087260403e-02, -7.765001241189077e-04,  3.207196881881430e-05,
 -9.685702051792315e-07,  2.370786952479418e-08, -4.965608622579143e-10,  9.199510491004535e-12, -1.541339176056959e-13,  2.372608264482192e-15, -3.395084777508183e-17,
  4.557261242611827e-19, -5.778818551011496e-21,  7.923870491347884e-03, -6.720974500393674e-04,  3.152350172948897e-05, -1.069173812725884e-06,  2.914768367354465e-08,
 -6.754703768321658e-10,  1.377054654133292e-11, -2.527136211763437e-13,  4.243876119273164e-15, -6.601853580314808e-17,  9.603675215209556e-19, -1.316003354202945e-20,
  5.840747847367207e-03, -5.657276180009292e-04,  2.990274305557119e-05, -1.132042923395082e-06,  3.419293609074704e-08, -8.726715839072703e-10,  1.949535096766720e-11,
 -3.903746348012276e-13,  7.126332328449481e-15, -1.201116624697368e-16,  1.887510347123153e-18, -2.786579199042041e-20,  4.236576833662221e-03, -4.641465615980877e-04,
  2.745307563290090e-05, -1.153384519247830e-06,  3.840729492770442e-08, -1.074816705253958e-09,  2.620743984218481e-11, -5.705073789848771e-13,  1.128285375282083e-14,
 -2.053836852352647e-16,  3.476071309872817e-18, -5.512906547177131e-20,  3.027494704704134e-03, -3.719666204876336e-04,  2.445826422446174e-05, -1.134178012149835e-06,
  4.144256884495409e-08, -1.266364673657278e-09,  3.357471930032659e-11, -7.918066678270600e-13,  1.690979300148280e-14, -3.314260770767564e-16,  6.023829077824752e-18,
 -1.023477427628828e-19,  2.134073775000722e-03, -2.917697665576902e-04,  2.119826186829205e-05, -1.079452112922516e-06,  4.308780934603518e-08, -1.431936230733434e-09,
  4.113036774274818e-11, -1.047330965878861e-12,  2.407730387144735e-14, -5.066200688252565e-16,  9.861082833943978e-18, -1.790168172857074e-19,  1.485790849082645e-03,
 -2.244509693269551e-04,  1.791632312705025e-05, -9.970004953661407e-07,  4.328942128970410e-08, -1.558639018189174e-09,  4.833387523351032e-11, -1.324598321573420e-12,
  3.268157410293886e-14, -7.361584396130085e-16,  1.530392561938510e-17, -2.960898159862078e-19,  1.023102682978592e-03, -1.696623004372340e-04,  1.480013088368749e-05,
 -8.959007544444046e-07,  4.214174875179784e-08, -1.637842526747536e-09,  5.464872242602424e-11, -1.606814267064739e-12,  4.242377123236323e-14, -1.020175991723007e-15,
  2.259239675106060e-17, -4.646791991069706e-19,  6.977655676345850e-04, -1.262573543758117e-04,  1.197603104995079e-05, -7.851580910980559e-07,  3.985472556244323e-08,
 -1.666071897987265e-09,  5.961899674726229e-11, -1.875014258961329e-12,  5.282470618190963e-14, -1.352491276256774e-15,  3.182520609623667e-17, -6.941875374290441e-19,
  4.720259136050625e-04, -9.267266240363476e-05,  9.513242402079942e-06, -6.726850671621489e-07,  3.670910807492706e-08, -1.644945941269281e-09,  6.292859598609048e-11,
 -2.110656572128036e-12,  6.327502125319110e-14, -1.720365816966937e-15,  4.290656563388406e-17, -9.901683936713848e-19,  3.172079073705493e-04, -6.721716420052070e-05,
  7.434116870494907e-06, -5.647009656114773e-07,  3.301016744863660e-08, -1.580317813801980e-09,  6.443251305683316e-11, -2.298102080829922e-12,  7.311128899461525e-14,
 -2.105450153267160e-15,  5.551999343215971e-17, -1.352371829895104e-18,  2.120873854143747e-04, -4.826662464215709e-05,  5.726827018572597e-06, -4.655272377275380e-07,
  2.904834715298486e-08, -1.480922805645672e-09,  6.415756831999532e-11, -2.426485195090232e-12,  8.170195999713293e-14, -2.485785134404843e-15,  6.913848925594217e-17,
 -1.773465743230858e-18,  1.413057360164829e-04, -3.437561264550172e-05,  4.357766811270396e-06, -3.776887582558774e-07,  2.507169944906559e-08, -1.356875644965897e-09,
  6.227716256278742e-11, -2.490674279675265e-12,  8.852552474420377e-14, -2.838462911855850e-15,  8.307180990622158e-17, -2.238812189347325e-18,  9.396495282946302e-05,
 -2.432658872735658e-05,  3.282029897635949e-06, -3.022058386539808e-07,  2.127125164235719e-08, -1.218307278665968e-09,  5.906925462052981e-11, -2.491263184130286e-12,
  9.322656032950777e-14, -3.142407901048368e-15,  9.654251372986098e-17, -2.727444362538096e-18,  6.246257298248642e-05, -1.713634123885940e-05,  2.451279483633838e-06,
 -2.389693480328599e-07,  1.777771044219394e-08, -1.074327262191425e-09,  5.486816415967232e-11, -2.433749852886271e-12,  9.564188767643114e-14, -3.380747880753656e-15,
  1.087758680293586e-16, -3.214107539027647e-18,  4.157202033874570e-05, -1.203714278768395e-05,  1.819004873157442e-06, -1.871168400596386e-07,  1.466642256041925e-08,
 -9.323841808923503e-10,  5.001943520348033e-11, -2.327191235098214e-12,  9.579647818232325e-14, -3.542388336916273e-15,  1.190864347272444e-16, -3.671984539926620e-18,
  2.774429091471529e-05, -8.445711586251919e-06,  1.343553015882703e-06, -1.453585671159777e-07,  1.196715845145427e-08, -7.980033987606174e-10,  4.484399051399348e-11,
 -2.182660562219374e-12,  9.387484887646869e-14, -3.622619155150020e-15,  1.269463771664689e-16, -4.075592912539037e-18,  1.859413725986623e-05, -5.928761519137628e-06,
  9.894807545435295e-07, -1.122300283726580e-07,  9.675721295206631e-09, -6.748233590418459e-10,  3.961438193854759e-11, -2.011789718736164e-12,  9.017718579182042e-14,
 -3.622800856899435e-15,  1.320260303299805e-16, -4.403344687012864e-18,  1.253169672581513e-05, -4.170339468075922e-06,  7.277723523954960e-07, -8.626805598386527e-08,
  7.765204947185611e-09, -5.648289983365892e-10,  3.454302506797659e-11, -1.825589225800217e-12,  8.507011214001168e-14, -3.549341494656488e-15,  1.342040477350192e-16,
 -4.639381882312954e-18,  8.504033367551323e-06, -2.943519234354603e-06,  5.353805924782065e-07, -6.611967754039415e-08,  6.195608633849783e-09, -4.686852146631523e-10,
  2.978037387503244e-11, -1.633636424844107e-12,  7.894047464779423e-14, -3.412257562147923e-15,  1.335505228148006e-16, -4.774491501461574e-18,  5.817024281472820e-06,
 -2.087297769843279e-06,  3.944333010475337e-07, -5.059842792659416e-08,  4.921262685419798e-09, -3.860933815106742e-10,  2.542010498730356e-11, -1.443635163150584e-12,
  7.215775831778728e-14, -3.223614551257970e-15,  1.302905636621923e-16, -4.806102619155383e-18,  4.014422373467951e-06, -1.488538527038304e-06,  2.913345970240484e-07,
 -3.870352012078565e-08,  3.896045648631930e-09, -3.161193828021562e-10,  2.150833555926165e-11, -1.261291211822263e-12,  6.504774217316017e-14, -2.996086911033646e-15,
  1.247574265390721e-16, -4.737526371834071e-18,  2.796729338760050e-06, -1.068316523843002e-06,  2.158980361621728e-07, -2.961536040482875e-08,  3.076678744660986e-09,
 -2.574654574660850e-10,  1.805437900361806e-11, -1.090418795403547e-12,  5.787748477447328e-14, -2.741792608687557e-15,  1.173437830376420e-16, -4.576690871049209e-18,
  1.967297423075522e-06, -7.718533198993826e-07,  1.605817066353450e-07, -2.267787830216399e-08,  2.424513117398177e-09, -2.086766100726090e-10,  1.504124871592135e-11,
 -9.331894399162308e-13,  5.085002618361602e-14, -2.471470921401014e-15,  1.084577432235909e-16, -4.334644743634375e-18,  1.396786802662732e-06, -5.612460038363143e-07,
  1.198511645231667e-07, -1.737504293166351e-08,  1.906236483894089e-09, -1.682844972385964e-10,  1.243482977263858e-11, -7.904461688860939e-13,  4.410634913221912e-14,
 -2.194001470745919e-15,  9.848771816157421e-17, -4.024070039862850e-18,  9.998537478245491e-07, -4.102968000486897e-07,  8.966998638159103e-08, -1.330628134126300e-08,
  1.493871278071662e-09, -1.348982375110683e-10,  1.019122529606115e-11, -6.620254216430483e-13,  3.773199551834120e-14, -1.916215875657661e-15,  8.777776916121683e-17,
 -3.657980544351789e-18,  7.199139176157075e-07, -3.008807201282986e-07,  6.710433856738436e-08, -1.016348807413310e-08,  1.164355417492585e-09, -1.072539477050417e-10,
  8.262200469447473e-12, -5.470495006229476e-13,  3.176604451812479e-14, -1.642930730520869e-15,  7.661318482345959e-17, -3.248707572193443e-18,  5.191994073313055e-07,
 -2.204162627624147e-07,  5.002273806486807e-08, -7.710906310920588e-09,  8.989142084206284e-10, -8.423450235203573e-11,  6.598898923159089e-12, -4.441699901728820e-13,
  2.621069292458531e-14, -1.377127059598158e-15,  6.521481310131758e-17, -2.807208956837966e-18,  3.722674769868349e-07, -1.601142020097580e-07,  3.687166218196091e-08,
 -5.768263249637196e-09,  6.823605235811711e-10, -6.486931175036449e-11,  5.154126448306095e-12, -3.517557738135234e-13,  2.104025939003854e-14, -1.120210342836206e-15,
  5.374011891859399e-17, -2.342687491231326e-18,  2.617502713933695e-07, -1.137677361684872e-07,  2.650951348044902e-08, -4.197024060204058e-09,  5.024049455401437e-10,
 -4.832171863971286e-11,  3.883526961056331e-12, -2.680279319452467e-13,  1.620895441896607e-14, -8.723005219136042e-16,  4.228889670511652e-17, -1.862475391970569e-18,
  1.755536676882873e-07, -7.691467784392994e-08,  1.808422472154037e-08, -2.889370981894896e-09,  3.490182937682857e-10, -3.386950905650963e-11,  2.745955853577166e-12,
 -1.911489111912780e-13,  1.165718213598619e-14, -6.325191556192116e-16,  3.091189934673240e-17, -1.372131099945501e-18,  1.049901702837477e-07, -4.625296119792397e-08,
  1.094289599891130e-08, -1.759455760693299e-09,  2.138677779265574e-10, -2.088272806853372e-11,  1.703350543056499e-12, -1.192784919307604e-13,  7.316615238197866e-15,
 -3.992666232029465e-16,  1.962160253053978e-17, -8.757181314679766e-19,  4.356404783847393e-08, -1.925064464234392e-08,  4.570236164673070e-09, -7.374093896307966e-10,
  8.994739332071104e-11, -8.812940968324829e-12,  7.212752070055572e-13, -5.067497134839535e-14,  3.118504414312363e-15, -1.707159913464692e-16,  8.415718674466026e-18,
 -3.767329113314502e-19,  6.454846458874772e-02, -1.735795038027371e-04,  4.862488942101797e-07, -1.407371411198109e-09,  4.170666964833814e-12, -1.255306827339167e-14,
  3.812910953171490e-17, -1.163456285532037e-19,  3.555211866109363e-22, -1.085812318702340e-24,  3.310336369287773e-27, -1.006758709323904e-29,  6.276567285940018e-02,
 -2.249040287061014e-04,  9.475134511693003e-07, -4.094821307022315e-09,  1.739328163028629e-11, -7.209684045995923e-14,  2.921473030434193e-16, -1.160904453449499e-18,
  4.536266075793834e-21, -1.746857872290672e-23,  6.640684326550007e-26, -2.495432034681024e-28,  5.935146198517426e-02, -3.187271342677651e-04,  1.932399485034101e-06,
 -1.104001886185173e-08,  5.944510888198261e-11, -3.057344904246917e-13,  1.516269936961245e-15, -7.297323336500475e-18,  3.423357922965458e-20, -1.570727626459012e-22,
  7.067174824302677e-25, -3.124566170678330e-27,  5.458672586964528e-02, -4.392781564910095e-04,  3.525019527666672e-06, -2.520293803684159e-08,  1.660816143862998e-10,
 -1.030187939080466e-12,  6.090904442737298e-15, -3.461436011738049e-17,  1.902205283572905e-19, -1.015439844674362e-21,  5.284164950413185e-24, -2.688014687853085e-26,
  4.884266549909342e-02, -5.671000484990746e-04,  5.767776939645171e-06, -5.045251647469366e-08,  3.992899539820578e-10, -2.933575808262889e-12,  2.032189584529235e-14,
 -1.341351360214664e-16,  8.499523724448296e-19, -5.199474037349033e-21,  3.084052960369598e-23, -1.779769401908417e-25,  4.253198724838769e-02, -6.828412900978445e-04,
  8.602599046835974e-06, -9.067559298758643e-08,  8.495994604758512e-10, -7.294412758952868e-12,  5.846235360002527e-14, -4.428723444947914e-16,  3.199255316728200e-18,
 -2.218481024714302e-20,  1.484257413669997e-22, -9.619274142704804e-25,  3.605957136561605e-02, -7.706640072633274e-04,  1.184226912831707e-05, -1.485357681138054e-07,
  1.628770644182123e-09, -1.616989727405389e-11,  1.484696676944592e-13, -1.278901973442925e-15,  1.043995465380316e-17, -8.137404336873099e-20,  6.091300768319039e-22,
 -4.398813646476900e-24,  2.978077893456524e-02, -8.205447185465000e-04,  1.518467441764078e-05, -2.241831338151036e-07,  2.849337400678040e-09, -3.242397585384294e-11,
  3.383206969344721e-13, -3.288730035199587e-15,  3.012002742619235e-17, -2.620833677733416e-19,  2.180570355903095e-21, -1.743517025991452e-23,  2.397297541003906e-02,
 -8.291160371946167e-04,  1.826585406569319e-05, -3.143707031478229e-07,  4.592677740752585e-09, -5.945724772372645e-11,  7.001648465151291e-13, -7.631278915703095e-15,
  7.793670306003886e-17, -7.526634966857936e-19,  6.921839610575439e-21, -6.095107614564696e-23,  1.882244434503998e-02, -7.991099773312552e-04,  2.073381338990399e-05,
 -4.123849052011832e-07,  6.873560937802819e-09, -1.005678516631516e-10,  1.328477597693629e-12, -1.614349167780385e-14,  1.828737667007200e-16, -1.950259135000654e-18,
  1.972907084325754e-20, -1.904385610157948e-22,  1.442561592480648e-02, -7.377867232706346e-04,  2.231935325232506e-05, -5.089428150406402e-07,  9.613344679799901e-09,
 -1.580136210366482e-10,  2.328761940226773e-12, -3.139228686772101e-14,  3.925805874321127e-16, -4.602594716733690e-18,  5.099776693003024e-20, -5.374069294994435e-22,
  1.080118785300601e-02, -6.548897667230538e-04,  2.288368736457876e-05, -5.938612629384997e-07,  1.263345330758700e-08, -2.320094419962331e-10,  3.795888695922102e-12,
 -5.650304153809605e-14,  7.767174461093350e-16, -9.970247139570120e-18,  1.205338336451171e-19, -1.381515717539683e-21,  7.908619241576065e-03, -5.606507419807218e-04,
  2.243254338777701e-05, -6.580241905433593e-07,  1.567492737309648e-08, -3.199971231335354e-10,  5.785414844687292e-12, -9.469201069465386e-14,  1.425186562980957e-15,
 -1.995552407974327e-17,  2.622895557177057e-19, -3.258739683025501e-21,  5.668572201451273e-03, -4.642225734151806e-04,  2.109798447105402e-05, -6.950848129009675e-07,
  1.844092565242946e-08, -4.164997463128147e-10,  8.285474258015098e-12, -1.485250063843952e-13,  2.438509904322851e-15, -3.711569856442352e-17,  5.286408090739254e-19,
 -7.097174560596304e-21,  3.981814862929066e-03, -3.727212825260205e-04,  1.909799440306135e-05, -7.024607036834638e-07,  2.065096365852061e-08, -5.137084869669334e-10,
  1.119887296557686e-11, -2.190497264545113e-13,  3.909565333351183e-15, -6.447442327883095e-17,  9.920512837576489e-19, -1.434943823160998e-20,  2.744427073639896e-03,
 -2.908735820247625e-04,  1.668763630627466e-05, -6.814401110338379e-07,  2.209184841303581e-08, -6.027080896507550e-10,  1.434333488158166e-11, -3.050493285195543e-13,
  5.899136063490139e-15, -1.050827237331759e-16,  1.741610706615763e-18, -2.706552619115307e-20,  1.858456547913644e-03, -2.211425028194194e-04,  1.411440717468506e-05,
 -6.364981779224614e-07,  2.265203802334488e-08, -6.750296412662358e-10,  1.747264054611442e-11, -4.026840678351913e-13,  8.411068993785069e-15, -1.613602412531069e-16,
  2.872610189075436e-18, -4.783557448310597e-20,  1.238190023491714e-03, -1.641493904765780e-04,  1.158602821509581e-05, -5.741190126705117e-07,  2.233227924906480e-08,
 -7.241163519208907e-10,  2.031465534668215e-11, -5.057014355978611e-13,  1.137466390695303e-14, -2.343444604470862e-16,  4.469199557274927e-18, -7.954308004236757e-20,
  8.128243482710000e-04, -1.192162780361557e-04,  9.253615635539805e-06, -5.014852980150912e-07,  2.123299201306324e-08, -7.463344063591674e-10,  2.261673142196199e-11,
 -6.062280317643296e-13,  1.464104374105107e-14, -3.230490743169568e-16,  6.582813650866371e-18, -1.249132895260134e-19,  5.265696940045353e-04, -8.489454789154569e-05,
  7.208799036101490e-06, -4.253429841659264e-07,  1.952503082838999e-08, -7.413246815576373e-10,  2.418686988953066e-11, -6.959731456130853e-13,  1.799665434936493e-14,
 -4.241429499799365e-16,  9.211449089199855e-18, -1.859110071853067e-19,  3.371887791819935e-04, -5.939997624246162e-05,  5.490807502378468e-06, -3.512247206673054e-07,
  1.741338547261614e-08, -7.116972926346641e-10,  2.492093018933873e-11, -7.675476616081306e-13,  2.119196171227040e-14, -5.320928885607384e-16,  1.228587291486814e-17,
 -2.631131284867269e-19,  2.137901257844126e-04, -4.092318676173889e-05,  4.098856118459779e-06, -2.830801980826832e-07,  1.510291249861248e-08, -6.622413245494133e-10,
  2.481096003993811e-11, -8.155784741603650e-13,  2.397881760710238e-14, -6.397859604817042e-16,  1.566775814069489e-17, -3.552226300965293e-19,  1.344517952813006e-04,
 -2.781933234290006e-05,  3.005814133221383e-06, -2.232572490634405e-07,  1.277237116839915e-08, -5.989081366694434e-10,  2.393531795347784e-11, -8.373783053465294e-13,
  2.614758136383950e-14, -7.395074282831468e-16,  1.916174886072154e-17, -4.588792145138040e-19,  8.402366730147232e-05, -1.869990165077721e-05,  2.170428767559094e-06,
 -1.727224951246546e-07,  1.055939794630935e-08, -5.278212979786285e-10,  2.243567153010848e-11, -8.330735954758685e-13,  2.755564066934363e-14, -8.240503295869179e-16,
  2.253958688384892e-17, -5.688547652632491e-19,  5.227626560192747e-05, -1.245580742696665e-05,  1.546735001249400e-06, -1.314011730947535e-07,  8.555891740055239e-09,
 -4.544954664921330e-10,  2.048803574971140e-11, -8.052417913625226e-13,  2.814197709948808e-14, -8.877065063347399e-16,  2.557109371136515e-17, -6.786203748161145e-19,
  3.244159896516283e-05, -8.238917048571461e-06,  1.090353873571511e-06, -9.853723996037720e-08,  6.811302438814984e-09, -3.833499656169250e-10,  1.827470274112997e-11,
 -7.582157853498978e-13,  2.792654241909115e-14, -9.269387426451432e-16,  2.805514990442096e-17, -7.811717567605269e-19,  2.012011484006551e-05, -5.423220278520204e-06,
  7.620494492175256e-07, -7.300933310586998e-08,  5.340614479025986e-09, -3.175154196280042e-10,  1.596194779499574e-11, -6.972547466735574e-13,  2.699696081739151e-14,
 -9.406339127024483e-16,  2.984427404645338e-17, -8.699357457447978e-19,  1.249471501613262e-05, -3.559987637279265e-06,  5.292127988860828e-07, -5.357199091931841e-08,
  4.134088801381818e-09, -2.588738028006173e-10,  1.368581392079552e-11, -6.277615513063084e-13,  2.548740282350377e-14, -9.299484089696772e-16,  3.085858584791088e-17,
 -9.395710118811453e-19,  7.784302686124351e-06, -2.335307022475767e-06,  3.659776699622480e-07, -3.901719869469421e-08,  3.166619341916632e-09, -2.082479724844411e-10,
  1.154596637040386e-11, -5.546696490890987e-13,  2.355505686027488e-14, -8.978444496813469e-16,  3.108791622187331e-17, -9.865182899782878e-19,  4.874411530226451e-06,
 -1.533978843017921e-06,  2.525638332623710e-07, -2.826673987317381e-08,  2.405473077472412e-09, -1.656594704414867e-10,  9.606070017658386e-12, -4.820534115421910e-13,
  2.135875837262978e-14, -8.484598082011185e-16,  3.058358596129615e-17, -1.009229341659463e-18,  3.073366619779950e-06, -1.010913267850680e-06,  1.742825354329223e-07,
 -2.041237245719803e-08,  1.815957541502540e-09, -1.305918119670963e-10,  7.898477510470979e-12, -4.129570720504721e-13,  1.904267148797203e-14, -7.864531023968932e-16,
  2.944319141741089e-17, -1.008082786262852e-18,  1.954473512742355e-06, -6.695997693529895e-07,  1.204815666772349e-07, -1.472131182916432e-08,  1.365088021826531e-09,
 -1.022199974621281e-10,  6.431052082318184e-12, -3.493993416324873e-13,  1.672612470890048e-14, -7.164344612100426e-16,  2.779235367698328e-17, -9.850562134617627e-19,
  1.255552610938501e-06, -4.465194219775633e-07,  8.358233544856411e-08, -1.062169718040094e-08,  1.023608445783171e-09, -7.958826117328309e-11,  5.194401301681952e-12,
 -2.924950019822074e-13,  1.449925800173306e-14, -6.425448105843161e-16,  2.576697032787752e-17, -9.432557014210821e-19,  8.158368817998432e-07, -3.001992122870296e-07,
  5.827456747763608e-08, -7.678781763561829e-09,  7.668120108976683e-10, -6.173359224607023e-11,  4.168397431838916e-12, -2.426363404317093e-13,  1.242325712680403e-14,
 -5.682019148459520e-16,  2.349845982638525e-17, -8.864057311514121e-19,  5.367615626112576e-07, -2.037102954664172e-07,  4.088128257234052e-08, -5.568813061121025e-09,
  5.745814838003700e-10, -4.776174245370731e-11,  3.327418059400464e-12, -1.996889901061518e-13,  1.053362160734917e-14, -4.959975159922169e-16,  2.110325150908860e-17,
 -8.183825073521039e-19,  3.578002877453559e-07, -1.396249166562572e-07,  2.887890696240300e-08, -4.054556011327748e-09,  4.309865148426333e-10, -3.688637729398847e-11,
  2.644162057908353e-12, -1.631719747285291e-13,  8.844993798349539e-15, -4.277108152851090e-16,  1.867669045273312e-17, -7.428431185107592e-19,  2.416622033952143e-07,
 -9.667734764183679e-08,  2.054605690107229e-08, -2.964297601878055e-09,  3.236788837884088e-10, -2.844243451259143e-11,  2.092159329209125e-12, -1.324059765001391e-13,
  7.356387755824376e-15, -3.643976761589173e-16,  1.629077655980809e-17, -6.629719805928303e-19,  1.652581319626318e-07, -6.757879332010136e-08,  1.471272647598630e-08,
 -2.174847747899914e-09,  2.432400645380671e-10, -2.188323215725419e-11,  1.647220478969565e-12, -1.066247403021166e-13,  6.056041685967488e-15, -3.065183470331663e-16,
  1.399477523842957e-17, -5.813413236745502e-19,  1.141973027426627e-07, -4.759973366391651e-08,  1.058451228272722e-08, -1.598323190149821e-09,  1.825685208440308e-10,
 -1.676861341941445e-11,  1.288104339383928e-12, -8.505154583097175e-14,  4.925472132149886e-15, -2.540748196372245e-16,  1.181765973727494e-17, -4.998668840484308e-19,
  7.943432866622719e-08, -3.365548474260184e-08,  7.621147496919252e-09, -1.172170773309740e-09,  1.363477150963861e-10, -1.274916476294046e-11,  9.966566151353706e-13,
 -6.694631713067949e-14,  3.942580170839035e-15, -2.067385824756920e-16,  9.771468435513000e-18, -4.198331520967809e-19,  5.522190302952272e-08, -2.371814559793286e-08,
  5.453388699971743e-09, -8.517942844883868e-10,  1.006067051032829e-10, -9.549658794596698e-12,  7.576228385303719e-13, -5.163012330214837e-14,  3.083838290101554e-15,
 -1.639582189779108e-16,  7.854881541721512e-18, -3.419624449428088e-19,  3.785518899605258e-08, -1.643844124427314e-08,  3.826463462085476e-09, -6.051822559959798e-10,
  7.236889226232894e-11, -6.953464729030215e-12,  5.582835824669364e-13, -3.849350628079269e-14,  2.325683720210584e-15, -1.250429820473346e-16,  6.056563220128718e-18,
 -2.665061647388928e-19,  2.489584773561047e-08, -1.090158452826438e-08,  2.561612303755506e-09, -4.090214814333157e-10,  4.937674743471377e-11, -4.788713006991868e-12,
  3.880109544780136e-13, -2.699404681341974e-14,  1.645283635831968e-15, -8.922307615280389e-17,  4.358035254145342e-18, -1.933428053797628e-19,  1.468645187282783e-08,
 -6.468183749218868e-09,  1.529793850621450e-09, -2.458862939581074e-10,  2.987840330159669e-11, -2.916467410137126e-12,  2.378121461571445e-13, -1.664771603172479e-14,
  1.020863651451784e-15, -5.569138625568606e-17,  2.736084281765093e-18, -1.220765196002986e-19,  6.047451060761795e-09, -2.671934868650251e-09,  6.342299188491096e-10,
 -1.023157590624341e-10,  1.247809215958635e-11, -1.222381395738681e-12,  1.000262294091597e-13, -7.026423091529315e-15,  4.323305819375325e-16, -2.366320394224047e-17,
  1.166329457693342e-18, -5.220299729329032e-20,  6.386182117239697e-02, -1.697559508184193e-04,  4.697526943650279e-07, -1.342600595261031e-09,  3.928499207738838e-12,
 -1.167581143698284e-14,  3.502500631392139e-17, -1.055696640097611e-19,  3.187124329006372e-22, -9.618436099388413e-25,  2.897974852329295e-27, -8.711078431700664e-30,
  6.188091229096553e-02, -2.175158487127019e-04,  8.999989711341282e-07, -3.827694099293015e-09,  1.601890961554295e-11, -6.545952920879334e-14,  2.615832199887035e-16,
 -1.025313896928477e-18,  3.952678851744130e-21, -1.501940330178962e-23,  5.634711315708824e-26, -2.089893986292743e-28,  5.810665502843173e-02, -3.037821424299140e-04,
  1.805430424506099e-06, -1.013590473067792e-08,  5.367839180394020e-11, -2.716771602174188e-13,  1.326468844095981e-15, -6.287124698884017e-18,  2.905633575505813e-20,
 -1.313719213394808e-22,  5.825843087321018e-25, -2.539221579501992e-27,  5.288415990674188e-02, -4.122440829670694e-04,  3.237873038631560e-06, -2.270283730994076e-08,
  1.468645839410078e-10, -8.949811944041459e-13,  5.201703572918864e-15, -2.907360775698947e-17,  1.572006296294479e-19, -8.259506191616666e-22,  4.231632127080651e-24,
 -2.119865604087927e-26,  4.666286300273961e-02, -5.232752398959777e-04,  5.198824896501104e-06, -4.450797339442328e-08,  3.452066541271258e-10, -2.488011093193269e-12,
  1.692036388092970e-14, -1.097079787204005e-16,  6.832109274133619e-19, -4.109282018264340e-21,  2.397352998032513e-23, -1.361182301273912e-25,  3.993168455522544e-02,
 -6.181524474659000e-04,  7.591475072941693e-06, -7.817688983044092e-08,  7.167945347060035e-10, -6.029251821198395e-12,  4.738284400181490e-14, -3.522067134815622e-16,
  2.497999528700539e-18, -1.701515331959506e-20,  1.118690455662869e-22, -7.127314117968353e-25,  3.315569748160707e-02, -6.826359237030197e-04,  1.020612519219326e-05,
 -1.248805459751098e-07,  1.338289068146256e-09, -1.300113305389990e-11,  1.169285708752105e-13, -9.873464737731395e-16,  7.906105025409001e-18, -6.048135186929880e-20,
  4.445548732729852e-22, -3.153658431791489e-24,  2.672554953087711e-02, -7.090996598966607e-04,  1.274796138320926e-05, -1.833698565932087e-07,  2.275123977615956e-09,
 -2.530852964778362e-11,  2.584234882194635e-13, -2.460409211695645e-15,  2.208617030100183e-17, -1.884755160947718e-19,  1.538742139374580e-21, -1.207830138035227e-23,
  2.092652424444742e-02, -6.969145744462210e-04,  1.489783144077542e-05, -2.495558863530650e-07,  3.555621408643022e-09, -4.495883039607606e-11,  5.176838742271180e-13,
 -5.522241451593705e-15,  5.523924239924710e-17, -5.228532112300456e-19,  4.715443550640067e-21, -4.074042822918397e-23,  1.592885540807733e-02, -6.513066627772416e-04,
  1.638390008874445e-05, -3.169090210714744e-07,  5.147585942928875e-09, -7.350713898776872e-11,  9.488302728765717e-13, -1.127758350503473e-14,  1.250568020381554e-16,
 -1.306437940172732e-18,  1.295414230997098e-20, -1.226305577954967e-22,  1.179629705427191e-02, -5.812681604640661e-04,  1.703970915037923e-05, -3.776499198654944e-07,
  6.947512085025541e-09, -1.113916625735715e-10,  1.603304685616810e-12, -2.112914471888488e-14,  2.585374549283312e-16, -2.967907061213714e-18,  3.222032226859328e-20,
 -3.328603418988937e-22,  8.507058108705688e-03, -4.972122838635358e-04,  1.683171456033999e-05, -4.243890032658890e-07,  8.789349109645550e-09, -1.573856318402595e-10,
  2.513817388432913e-12, -3.656767269581846e-14,  4.916677043326579e-16, -6.177678806062879e-18,  7.315224688772027e-20, -8.217372933049357e-22,  5.980361728177960e-03,
 -4.089534838344737e-04,  1.585202847142761e-05, -4.516973039263740e-07,  1.047278294661806e-08, -2.084080030225567e-10,  3.677481562705349e-12, -5.880650219124842e-14,
  8.654930336501439e-16, -1.185958317424858e-17,  1.526502755689922e-19, -1.858418599275682e-21,  4.102750434032480e-03, -3.243561484055525e-04,  1.428389022060528e-05,
 -4.571355117203662e-07,  1.180340807009707e-08, -2.598376489201306e-10,  5.044257225964028e-12, -8.833226688044836e-14,  1.417979849236433e-15, -2.111869543545208e-17,
  2.945333296459137e-19, -3.874323939487926e-21,  2.750119145392873e-03, -2.487337470117275e-04,  1.235407431439850e-05, -4.414913267676860e-07,  1.263258656951279e-08,
 -3.062978951620113e-10,  6.516218908958018e-12, -1.245088871960736e-13,  2.172733652339115e-15, -3.506101556061625e-17,  5.282413253428882e-19, -7.486344557451101e-21,
  1.803558101675174e-03, -1.848802351299424e-04,  1.028687126964595e-05, -4.082608825165849e-07,  1.288522648612432e-08, -3.427001690301363e-10,  7.959909811448376e-12,
 -1.653910589691242e-13,  3.127471768383647e-15, -5.451744948458204e-17,  8.848221893083315e-19, -1.347405717899833e-20,  1.158854465669385e-03, -1.335128475964884e-04,
  8.270016474961641e-06, -3.626340426075089e-07,  1.256859073643249e-08, -3.652396738973383e-10,  9.229413080862789e-12, -2.078554771625914e-13,  4.246204099801139e-15,
 -7.973150859127067e-17,  1.390248141322368e-18, -2.268944285667867e-20,  7.306511992405121e-04, -9.389425772409632e-05,  6.436822494695626e-06, -3.103340757924659e-07,
  1.176203031406431e-08, -3.720620859124870e-10,  1.019383299666071e-11, -2.480558167568283e-13,  5.458605130840651e-15, -1.101055992208839e-16,  2.057260264696215e-18,
 -3.589537607612917e-20,  4.527725497241685e-04, -6.445130590265730e-05,  4.863367402592497e-06, -2.566191978309546e-07,  1.059325615253810e-08, -3.634476925535959e-10,
  1.076138476664136e-11, -2.820936679132640e-13,  6.668013383670189e-15, -1.441034236607261e-16,  2.877959925111217e-18, -5.355697781354318e-20,  2.762412357861015e-04,
 -4.328041138651377e-05,  3.576342697549687e-06, -2.056281711832982e-07,  9.209495826059474e-09, -3.415247296563227e-10,  1.089375729838856e-11, -3.067222107294653e-13,
  7.766635706053712e-15, -1.793679615485941e-16,  3.819699324953008e-18, -7.563715370033767e-20,  1.662367853981861e-04, -2.849788639267805e-05,  2.566260007427619e-06,
 -1.601109506244582e-07,  7.751348189920480e-09, -3.096577310406182e-10,  1.060797114359028e-11, -3.198933696006214e-13,  8.654076029156576e-15, -2.130477642206807e-16,
  4.826166654924741e-18, -1.014606834141132e-19,  9.886171611345054e-05, -1.844164703171285e-05,  1.801516777073037e-06, -1.214784575265485e-07,  6.334403149587086e-09,
 -2.717170913775344e-10,  9.966953286801981e-12, -3.210200409834827e-13,  9.254278584434420e-15, -2.422558586337852e-16,  5.824067371450074e-18, -1.297008955383832e-19,
  5.821860439721402e-05, -1.175626629916090e-05,  1.240415518659071e-06, -9.005365865574696e-08,  5.040290306317584e-09, -2.314192464153693e-10,  9.062950972286602e-12,
 -3.109217426258691e-13,  9.526709413366597e-15, -2.645436648800749e-16,  6.734043133443482e-18, -1.585103010481914e-19,  3.401991857395357e-05, -7.400358085064482e-06,
  8.398539254088010e-07, -6.540397819999683e-08,  3.916043301246406e-09, -1.918592429649231e-10,  7.998929601179032e-12, -2.915137602750482e-13,  9.469645550069821e-15,
 -2.782724379813271e-16,  7.483152887064279e-18, -1.857733105074729e-19,  1.976872960835967e-05, -4.610992372430655e-06,  5.606178760309451e-07, -4.666369399583335e-08,
  2.979139005081641e-09, -1.552757270268752e-10,  6.872366566414175e-12, -2.653555804626130e-13,  9.115873915422768e-15, -2.828032359274155e-16,  8.015863553797355e-18,
 -2.094222462173374e-19,  1.144881161763714e-05, -2.850696450896583e-06,  3.698941635610699e-07, -3.279383540895289e-08,  2.225274721273769e-09, -1.230221224128743e-10,
  5.764085468929406e-12, -2.351837750617558e-13,  8.523011758680119e-15, -2.784846279099206e-16,  8.301128923252973e-18, -2.277411565920074e-19,  6.623081615873333e-06,
 -1.753020993376329e-06,  2.418551710238488e-07, -2.276156549328965e-08,  1.636484163132848e-09, -9.568107409037633e-11,  4.732831416927677e-12, -2.035266213039267e-13,
  7.761528721103740e-15, -2.664721380864669e-16,  8.334433441476837e-18, -2.395901027616069e-19,  3.835940392005286e-06, -1.074904948918354e-06,  1.571142005040455e-07,
 -1.564430692193706e-08,  1.188078148777477e-09, -7.325148600389660e-11,  3.814798311002935e-12, -1.724518919356605e-13,  6.903359784112250e-15, -2.484476110187622e-16,
  8.135101863103725e-18, -2.445100287578210e-19,  2.229422555585198e-06, -6.588127432215073e-07,  1.016624587803530e-07, -1.067542058066192e-08,  8.537511219073021e-10,
 -5.534946536452024e-11,  3.026543135925329e-12, -1.434545242072209e-13,  6.013098516885126e-15, -2.263144752926150e-16,  7.740245242422530e-18, -2.427031074562262e-19,
  1.303196248631768e-06, -4.045852389385943e-07,  6.568600399766008e-08, -7.250909097143733e-09,  6.088198992893686e-10, -4.138498530902257e-11,  2.369602717409607e-12,
 -1.174594457863357e-13,  5.142626595248073e-15, -2.019309492167805e-16,  7.197181101644315e-18, -2.349132712424703e-19,  7.678733325897051e-07, -2.495361281704352e-07,
  4.248161816359835e-08, -4.914119148440880e-09,  4.319116024397502e-10, -3.069631957725049e-11,  1.835437212171037e-12, -9.490035683384568e-14,  4.329059691199160e-15,
 -1.769179067176211e-16,  6.556048235899924e-18, -2.222486206930307e-19,  4.570431409640728e-07, -1.549198835975433e-07,  2.756420203266711e-08, -3.330880615835906e-09,
  3.055419366842203e-10, -2.263951836929063e-11,  1.409807836937111e-12, -7.583501373851827e-14,  3.595276182578409e-15, -1.525519439582033e-16,  5.863833328616971e-18,
 -2.059898768980203e-19,  2.753446034285594e-07, -9.701546266483674e-08,  1.798196213938188e-08, -2.262948192276346e-09,  2.160045588741289e-10, -1.663914655954211e-11,
  1.076163056318923e-12, -6.006590698900565e-14,  2.952066294389539e-15, -1.297343095781740e-16,  5.160391665145453e-18, -1.874203387991264e-19,  1.681985636704328e-07,
 -6.139769654420166e-08,  1.181711239437600e-08, -1.543958664544068e-09,  1.529030949381108e-10, -1.221013278716104e-11,  8.179570713901563e-13, -4.724660311369186e-14,
  2.401001730456408e-15, -1.090155090729053e-16,  4.476484739580834e-18, -1.676985869620649e-19,  1.043381167705201e-07, -3.933046140032920e-08,  7.835597255021322e-09,
 -1.059623600940984e-09,  1.085525484756404e-10, -8.960659563094091e-12,  6.200326904205270e-13, -3.696451632035166e-14,  1.937346766068787e-15, -9.065276112031123e-17,
  3.833484906406325e-18, -1.477808116507712e-19,  6.579779452825564e-08, -2.553181715902163e-08,  5.248583206319822e-09, -7.324007820542077e-10,  7.738531672567619e-11,
 -6.584283716141327e-12,  4.692891800869399e-13, -2.879857206597418e-14,  1.552594585961638e-15, -7.468042404135787e-17,  3.244230284099940e-18, -1.283886540389974e-19,
  4.220384392700958e-08, -1.680619924075545e-08,  3.553788460256428e-09, -5.101517251402001e-10,  5.542948592854928e-11, -4.847171041147516e-12,  3.548635844316361e-13,
 -2.235477303992969e-14,  1.236442156366339e-15, -6.097907883438730e-17,  2.714509992955426e-18, -1.100121523124466e-19,  2.752533096585599e-08, -1.121481235332409e-08,
  2.431808361013845e-09, -3.580244637751380e-10,  3.988339797821211e-11, -3.574187846992689e-12,  2.680190302096742e-13, -1.728462488803620e-14,  9.781801589939464e-16,
 -4.933484757537133e-17,  2.244755180908451e-18, -9.293539335964664e-20,  1.822577965050698e-08, -7.575507983206786e-09,  1.679289662233328e-09, -2.527893066595869e-10,
  2.878575547626009e-11, -2.635925954628386e-12,  2.018836088157987e-13, -1.329158411192120e-14,  7.675691004639450e-16, -3.948539472350205e-17,  1.831644224596364e-18,
 -7.727350846446220e-20,  1.220957355842267e-08, -5.162297547542033e-09,  1.166275235312632e-09, -1.789604398064729e-10,  2.076882975296367e-11, -1.937595199922313e-12,
  1.511351764985116e-13, -1.012995949364112e-14,  5.953124761470544e-16, -3.115240573160529e-17,  1.469458274139005e-18, -6.301227037063435e-20,  8.218988160253922e-09,
 -3.524941385196847e-09,  8.091462317072262e-10, -1.261762735382531e-10,  1.487854309267252e-11, -1.410018499851028e-12,  1.116884500059932e-13, -7.599622637015330e-15,
  4.532414800776670e-16, -2.406222740092229e-17,  1.151123702263762e-18, -5.004457620077356e-20,  5.486965504671921e-09, -2.380405837616793e-09,  5.535035752294787e-10,
 -8.744522019313521e-11,  1.044560496111684e-11, -1.002588681548596e-12,  8.041287901766188e-14, -5.538819953197303e-15,  3.343100026195253e-16, -1.795712654085663e-17,
  8.689450121542144e-19, -3.820080381323611e-20,  3.535326356795312e-09, -1.547192510374088e-09,  3.633194800117766e-10, -5.797464316875179e-11,  6.994126735592456e-12,
 -6.778807595558196e-13,  5.489176312671000e-14, -3.816501269708217e-15,  2.324759487733211e-16, -1.259969056027708e-17,  6.150697867510940e-19, -2.727211302313452e-20,
  2.055881910340412e-09, -9.051756717157722e-10,  2.140106115726941e-10, -3.438634673571887e-11,  4.176949546587538e-12, -4.075782784707453e-13,  3.322326950069045e-14,
 -2.324984112077079e-15,  1.425255384902103e-16, -7.772759560029349e-18,  3.817521994421351e-19, -1.702754598421595e-20,  8.397990258563873e-10, -3.709909783841056e-10,
  8.804596672624420e-11, -1.420132252145222e-11,  1.731641323408157e-12, -1.696057353679771e-13,  1.387626394652332e-14, -9.745827360231601e-16,  5.995523355488319e-17,
 -3.281046580593095e-18,  1.616920957952889e-19, -7.235905371456472e-21,  6.319021286010106e-02, -1.660613229956954e-04,  4.540110623588729e-07, -1.281568049849976e-09,
  3.703155371698901e-12, -1.086956144146452e-14,  3.220678866224064e-17, -9.590324392303842e-20,  2.860834874464619e-22, -8.532354971785275e-25,  2.540884768971170e-27,
 -7.549875020332640e-30,  6.102496399771546e-02, -2.104953264467686e-04,  8.555623328388417e-07, -3.581533475690721e-09,  1.477024539506901e-11, -5.951222899856812e-14,
  2.345669462569833e-16, -9.070617087527982e-19,  3.450429114575590e-21, -1.293908972590170e-23,  4.791288644706690e-26, -1.754240989079126e-28,  5.691966309860873e-02,
 -2.898110239394736e-04,  1.688778830320533e-06, -9.318847109642646e-09,  4.854946695288828e-11, -2.418535285515235e-13,  1.162766449612203e-15, -5.428704293491677e-18,
  2.472082218430010e-20, -1.101573129590380e-22,  4.815644701793881e-25, -2.069502769465871e-27,  5.128531878419922e-02, -3.873922053184325e-04,  2.978968542988981e-06,
 -2.048968483116750e-08,  1.301502552581979e-10, -7.793669534448993e-13,  4.453821151567860e-15, -2.448800709662416e-17,  1.303011210771583e-19, -6.739583546735532e-22,
  3.400150087208301e-24, -1.677725539186318e-26,  4.464968838336247e-02, -4.837307706751256e-04,  4.696295688438600e-06, -3.936168620960046e-08,  2.992707128917341e-10,
 -2.116444103193617e-12,  1.413363419411734e-14, -9.003820687538714e-17,  5.511860067113370e-19, -3.260185728537164e-21,  1.871094139243139e-23, -1.045449943731276e-25,
  3.757486057551213e-02, -5.609869485270627e-04,  6.718376723615737e-06, -6.761426779292078e-08,  6.068269645910730e-10, -5.001908822680954e-12,  3.855389329956058e-14,
 -2.812656298160203e-16,  1.958975185415809e-18, -1.310987088227219e-20,  8.471862240208503e-23, -5.307139695648173e-25,  3.057944991045539e-02, -6.066359895120878e-04,
  8.827923050909328e-06, -1.054045371273348e-07,  1.104229600419785e-09, -1.049990284094130e-11,  9.252046136836345e-14, -7.660105495460059e-16,  6.018015356388781e-18,
 -4.519325424503425e-20,  3.262446383331397e-22, -2.273941407317868e-24,  2.408000771637327e-02, -6.153352785467104e-04,  1.075026224871467e-05, -1.507023160399423e-07,
  1.825782423430995e-09, -1.985906895999036e-11,  1.984856360309539e-13, -1.851301533993442e-15,  1.629177892591848e-17, -1.363771653510064e-19,  1.092741200608294e-21,
 -8.422137983164612e-24,  1.835954548646830e-02, -5.888076751906676e-04,  1.221687887320314e-05, -1.992334856127328e-07,  2.769127468903982e-09, -3.420631795009138e-11,
  3.852191652645323e-13, -4.022585331288543e-15,  3.941973415245436e-17, -3.657661367811218e-19,  3.235558278465405e-21, -2.743297829852117e-23,  1.356352495066808e-02,
 -5.341511458761822e-04,  1.303037831866669e-05, -2.451712638473111e-07,  3.881749746691858e-09, -5.411240197533836e-11,  6.826691333243685e-13, -7.937950082860003e-15,
  8.618254676249375e-17, -8.821045173126429e-19,  8.574736812395125e-21, -7.962046514063146e-23,  9.717618949935794e-03, -4.613446267344753e-04,  1.310761341845109e-05,
 -2.824071955687983e-07,  5.060993911287831e-09, -7.916736396488278e-11,  1.113071288866662e-12, -1.434280755297768e-14,  1.717455408868729e-16, -1.930794712400057e-18,
  2.054067459011969e-20, -2.080615690296530e-22,  6.758347415903893e-03, -3.807580726779585e-04,  1.248868831604186e-05, -3.059816855235918e-07,  6.170401699900608e-09,
 -1.077498089649844e-10,  1.680406583841523e-12, -2.389182908872034e-14,  3.142466176759870e-16, -3.865415710131017e-18,  4.483905897779675e-20, -4.937150426777603e-22,
  4.567491262433142e-03, -3.012583213489052e-04,  1.131362800901032e-05, -3.131908215194674e-07,  7.068487193640207e-09, -1.371338210377566e-10,  2.362013976491535e-12,
 -3.690680086502974e-14,  5.312219518281077e-16, -7.124362504363528e-18,  8.981156356443036e-20, -1.071522203835586e-21,  3.003186732892410e-03, -2.291730517478563e-04,
  9.779111578213980e-06, -3.040342292847910e-07,  7.640728925323749e-09, -1.639564616925154e-10,  3.106377679805581e-12, -5.314404815853871e-14,  8.341973026054517e-16,
 -1.215812039847357e-17,  1.660479653396803e-19, -2.140255577755746e-21,  1.923596090814971e-03, -1.680723985726365e-04,  8.091346214657133e-06, -2.809380520144773e-07,
  7.824273822978236e-09, -1.849220111074385e-10,  3.839325803922135e-12, -7.166680326897809e-14,  1.222832890356489e-15, -1.930930007266979e-17,  2.848770775318042e-19,
 -3.955966020624085e-21,  1.201936743983065e-03, -1.191375382642457e-04,  6.428304361066515e-06, -2.479416612391792e-07,  7.618050261973364e-09, -1.975200014499349e-10,
  4.477729002628237e-12, -9.089719328201602e-14,  1.680742587278574e-15, -2.867144753657254e-17,  4.556990062510839e-19, -6.799930342672816e-21,  7.337452774337067e-04,
 -8.182627547736732e-05,  4.918110594229485e-06, -2.096728754136376e-07,  7.076794827030094e-09, -2.005308180126196e-10,  4.946759650642626e-12, -1.088620635387065e-13,
  2.174993459676689e-15, -3.997254531495545e-17,  6.826502686758155e-19, -1.091891118437769e-20,  4.383449829808521e-04, -5.458604264465306e-05,  3.633776540766132e-06,
 -1.704270233833229e-07,  6.293032064809148e-09, -1.941814903755832e-10,  5.195348686131673e-12, -1.235726443787979e-13,  2.660200988295173e-15, -5.253251450987919e-17,
  9.615878076552558e-19, -1.644720337150496e-20,  2.567180677885016e-04, -3.545375528008560e-05,  2.600056887346421e-06, -1.335520277908938e-07,  5.374080537801623e-09,
 -1.799465935517863e-10,  5.205282699281670e-12, -1.334254776631273e-13,  3.086480262547411e-15, -6.532515481359879e-17,  1.278552230310588e-18, -2.333167803077213e-20,
  1.476661100763321e-04, -2.247434663543972e-05,  1.806614959930537e-06, -1.011966707138688e-07,  4.421058458792302e-09, -1.601030301390932e-10,  4.991893496854625e-12,
 -1.375054427560501e-13,  3.409049787950171e-15, -7.713971150579542e-17,  1.610554139004123e-18, -3.128649895047833e-20,  8.359009840006127e-05, -1.393868668016706e-05,
  1.222351638109028e-06, -7.436341596974711e-08,  3.514478317825345e-09, -1.372009698566935e-10,  4.597239356519552e-12, -1.357115957475441e-13,  3.596688714198113e-15,
 -8.680094390102573e-17,  1.928793114828405e-18, -3.979899860502495e-20,  4.666533105256322e-05, -8.479134243680152e-06,  8.075469680662407e-07, -5.314925927992853e-08,
  2.707877129151287e-09, -1.135999013201864e-10,  4.078805957365044e-12, -1.286913331022763e-13,  3.636748744756386e-15, -9.338563396592082e-17,  2.203569191523017e-18,
 -4.819302229039849e-20,  2.574921332268950e-05, -5.072055240613837e-06,  5.223753380987396e-07, -3.705501566797729e-08,  2.028356175041709e-09, -9.116122351156384e-11,
  3.497420412326150e-12, -1.176284888478238e-13,  3.535714444586450e-15, -9.637656654339168e-17,  2.409556116195831e-18, -5.573680948681940e-20,  1.407584543833517e-05,
 -2.991246445743507e-06,  3.317838699272176e-07, -2.527432542679209e-08,  1.481554428006051e-09, -7.112033404329341e-11,  2.907388346800552e-12, -1.039643241976676e-13,
  3.315771566407185e-15, -9.571903221526222e-17,  2.530020475318691e-18, -6.176741917563535e-20,  7.641516004169808e-06, -1.743871093641992e-06,  2.074980305976342e-07,
 -1.691499105986521e-08,  1.058424582974138e-09, -5.410826643070404e-11,  2.350446211609624e-12, -8.913090122274875e-14,  3.008897235930882e-15, -9.177787756582288e-17,
  2.558990708223982e-18, -6.579903320534143e-20,  4.130198075484666e-06, -1.007749163759404e-06,  1.281447325495574e-07, -1.114055143085212e-08,  7.417925083329313e-10,
 -4.026707485156995e-11,  1.853671336310168e-12, -7.435247106568246e-14,  2.650335824252108e-15, -8.522126492287552e-17,  2.501085329688694e-18, -6.758937734540407e-20,
  2.228294425782541e-06, -5.788534361525701e-07,  7.837343246638095e-08, -7.242224062946683e-09,  5.115589413349030e-10, -2.940209620696236e-11,  1.430487462366083e-12,
 -6.053738486943076e-14,  2.273025092701200e-15, -7.687156603717161e-17,  2.369396455977581e-18, -6.715310146234036e-20,  1.203187315924156e-06, -3.314209283804826e-07,
  4.760783521064008e-08, -4.660751132741697e-09,  3.481816169502407e-10, -2.112831536891429e-11,  1.083492227018167e-12, -4.825422879091337e-14,  1.903870541178044e-15,
 -6.756267353873821e-17,  2.182256075180860e-18, -6.472682997632433e-20,  6.519534233595194e-07, -1.896751704368491e-07,  2.880644318283252e-08, -2.978114082765799e-09,
  2.345897109019897e-10, -1.498691825041833e-11,  8.079080426457125e-13, -3.776871312199102e-14,  1.562056949542381e-15, -5.803103522293843e-17,  1.959803462758304e-18,
 -6.070204074104901e-20,  3.554588522507090e-07, -1.088130508122346e-07,  1.741218008236662e-08, -1.894944110469312e-09,  1.569214455556724e-10, -1.052448422719513e-11,
  5.947998048271031e-13, -2.911301550583273e-14,  1.259063910620496e-15, -4.885190206002640e-17,  1.721083759545416e-18, -5.554620548563029e-20,  1.955269350644139e-07,
 -6.274731734020484e-08,  1.054380410021256e-08, -1.204099841139826e-09,  1.045135147290060e-10, -7.337979557646693e-12,  4.336046918863675e-13, -2.216327927315172e-14,
  9.998006860675444e-16, -4.041860943232506e-17,  1.482079860282009e-18, -4.973024729697194e-20,  1.087910511394190e-07, -3.646886440760532e-08,  6.413741415140595e-09,
 -7.661924853542755e-10,  6.949915421982403e-11, -5.093732155221293e-12,  3.138490943998524e-13, -1.670905642837453e-14,  7.842609444307576e-16, -3.295433270217225e-17,
  1.254753223994128e-18, -4.367397241913704e-20,  6.137908426579277e-08, -2.141778043210092e-08,  3.929378544951124e-09, -4.895042406760880e-10,  4.626325851368247e-11,
 -3.529445009466887e-12,  2.261355266274809e-13, -1.250679194503834e-14,  6.092281003391578e-16, -2.654298054336295e-17,  1.046935117105480e-18, -3.771381694357721e-20,
  3.519462699833149e-08, -1.274024896260867e-08,  2.430376107871148e-09, -3.147455825432972e-10,  3.090154970648493e-11, -2.446904473037510e-12,  1.625757902864317e-13,
 -9.315801903221481e-15,  4.697424783347181e-16, -2.116722642053319e-17,  8.627970140336714e-19, -3.209133376367797e-20,  2.055071282631511e-08, -7.691905386901822e-09,
  1.520798457861774e-09, -2.041074552082415e-10,  2.075473662902809e-11, -1.700840340958154e-12,  1.168597158488641e-13, -6.918984657972171e-15,  3.602058922587741e-16,
 -1.674509078369997e-17,  7.036193682658863e-19, -2.695737930110645e-20,  1.223947130455477e-08, -4.721352683481922e-09,  9.643841494562270e-10, -1.337161469065453e-10,
  1.404007191237298e-11, -1.187290353593857e-12,  8.411869244570644e-14, -5.132075123425563e-15,  2.751159890741991e-16, -1.316025674056394e-17,  5.686321221414389e-19,
 -2.238588091379902e-20,  7.442590716839196e-09, -2.949490452614141e-09,  6.204204698707503e-10, -8.859486366774178e-11,  9.576389318524369e-12, -8.332017654345195e-13,
  6.069839023477420e-14, -3.805342412868069e-15,  2.094876291954515e-16, -1.028439693120375e-17,  4.557784208755322e-19, -1.839168070436899e-20,  4.621563427845059e-09,
 -1.875780831402089e-09,  4.050332931022710e-10, -5.937987040916399e-11,  6.587360333371568e-12, -5.879323663223263e-13,  4.391247179691838e-14, -2.820959977790511e-15,
  1.590423511193146e-16, -7.991829964999217e-18,  3.623268355432274e-19, -1.494841315965740e-20,  2.927459094837663e-09, -1.213199463755394e-09,  2.680572556348925e-10,
 -4.021928712627622e-11,  4.565063204105248e-12, -4.167007860317693e-13,  3.181600308601605e-14, -2.088368598596503e-15,  1.202447494256778e-16, -6.167870728333012e-18,
  2.853128148120231e-19, -1.200399393999994e-20,  1.885841669762478e-09, -7.956038258035250e-10,  1.793075121718467e-10, -2.744670201949855e-11,  3.177564906612980e-12,
 -2.957434681102593e-13,  2.301496274298541e-14, -1.539106722139772e-15,  9.024976678786551e-17, -4.712553157705755e-18,  2.218240028163864e-19, -9.492660549389496e-21,
  1.227567615955002e-09, -5.256672100788324e-10,  1.204591912406102e-10, -1.875156741063560e-11,  2.207374419182548e-12, -2.088382184467712e-13,  1.651500563125179e-14,
 -1.121925844347213e-15,  6.680668350230425e-17, -3.541282321664837e-18,  1.691598234320460e-19, -7.343451254698919e-21,  7.971758361729790e-10, -3.454900772585924e-10,
  8.024433142399882e-11, -1.266291949109064e-11,  1.510916155340603e-12, -1.448595736041726e-13,  1.160586730193731e-14, -7.985594320411191e-16,  4.814906995155312e-17,
 -2.583654097863197e-18,  1.248990440329829e-19, -5.485546662782522e-21,  5.027418661509055e-10, -2.198872714960839e-10,  5.160023370116549e-11, -8.228191199738145e-12,
  9.919863066631141e-13, -9.608068840156291e-14,  7.775103001694906e-15, -5.402396081532300e-16,  3.288721041408347e-17, -1.781323600646663e-18,  8.690547389532138e-20,
 -3.851126819509219e-21,  2.880087217070285e-10, -1.267663443457227e-10,  2.996070098068644e-11, -4.812222101265274e-12,  5.843360941512844e-13, -5.699810749313649e-14,
  4.644513395345235e-15, -3.249144286388844e-16,  1.991111754107262e-17, -1.085512687303657e-18,  5.329674757480754e-20, -2.376478252183529e-21,  1.166654244433324e-10,
 -5.153028597962967e-11,  1.222732879841403e-11, -1.971841769020216e-12,  2.403932958502378e-13, -2.354109606125368e-14,  1.925667393203321e-15, -1.352231271525882e-16,
  8.317329483823404e-18, -4.550873655316291e-19,  2.242320993591745e-20, -1.003297501566234e-21,  6.253313574651156e-02, -1.624897587582920e-04,  4.389807083566684e-07,
 -1.224015590825165e-09,  3.493281491983496e-12, -1.012781522210614e-14,  2.964518170197023e-17, -8.722105168838619e-20,  2.571191774886485e-22, -7.579398125699767e-25,
  2.231149102041718e-27, -6.554104113781192e-30,  6.019640504767347e-02, -2.038188123974590e-04,  8.139635643622242e-07, -3.354434046852935e-09,  1.363430236841892e-11,
 -5.417533581655834e-14,  2.106475365508193e-16, -8.037455823721435e-19,  3.017337716337556e-21, -1.116837390708708e-23,  4.082560926798275e-26, -1.475765114417537e-28,
  5.578674940218026e-02, -2.767352505197767e-04,  1.581458564589116e-06, -8.579286074197585e-09,  4.397959493203447e-11, -2.156853235450231e-13,  1.021266995289978e-15,
 -4.697541893003475e-18,  2.108101861608987e-20, -9.259866595189557e-23,  3.991193371568784e-25, -1.691431675567281e-27,  4.978190470557260e-02, -3.645097090059257e-04,
  2.745090563086680e-06, -1.852639660393138e-08,  1.155786377058912e-10, -6.802535619474254e-13,  3.823063498625293e-15, -2.068170021553874e-17,  1.083187546012830e-19,
 -5.516379761301458e-22,  2.740995777071558e-24, -1.332383827074052e-26,  4.278702536793805e-02, -4.479714658412645e-04,  4.251346031038122e-06, -3.489437824647163e-08,
  2.601395548661083e-10, -1.805600128105866e-12,  1.184283161758421e-14, -7.414221086284337e-17,  4.462519800996331e-19, -2.596225636417714e-21,  1.466105120470901e-23,
 -8.062606713771568e-26,  3.543349151819093e-02, -5.103276517255152e-04,  5.962115469292058e-06, -5.865762306380964e-08,  5.154386525292829e-10, -4.164450767113536e-12,
  3.148953712019275e-14, -2.255187633305298e-16,  1.542780497522732e-18, -1.014582618985849e-20,  6.445532233352678e-23, -3.970887468571007e-25,  2.828654590381266e-02,
 -5.407868831335021e-04,  7.662516494276390e-06, -8.930312061110857e-08,  9.148055407737588e-10, -8.516448048316022e-12,  7.354053461996489e-14, -5.971302136071207e-16,
  4.603686848258528e-18, -3.394502404590923e-20,  2.407114846579761e-22, -1.648773960838370e-24,  2.177988074147106e-02, -5.360988665106965e-04,  9.104795260993204e-06,
 -1.244250428134633e-07,  1.472325098631327e-09, -1.566279179998198e-11,  1.532660294108364e-13, -1.400756993590936e-15,  1.208714950662705e-17, -9.927115047705200e-20,
  7.808132842727935e-22, -5.910138177892795e-24,  1.618564178929228e-02, -4.999315590931375e-04,  1.007086549353280e-05, -1.599340092027062e-07,  2.169018605661075e-09,
 -2.618143385302245e-11,  2.884325764274694e-13, -2.949040970941461e-15,  2.831740345617791e-17, -2.576232767871969e-19,  2.235704103556142e-21, -1.860526891680546e-23,
  1.161816240850204e-02, -4.406973249845904e-04,  1.042794677659652e-05, -1.909013680749128e-07,  2.946833196706974e-09, -4.011099278194629e-11,  4.946773864616808e-13,
 -5.628299848533462e-15,  5.983983785265802e-17, -6.001906777975724e-19,  5.720662619924312e-21, -5.211183680525614e-23,  8.062295184084117e-03, -3.687742140998930e-04,
  1.015668576260861e-05, -2.127727668852843e-07,  3.715210596623310e-09, -5.671077493200699e-11,  7.789998645650697e-13, -9.816848808165350e-15,  1.150556612835204e-16,
 -1.266934174780749e-18,  1.320992156917702e-20, -1.312163672046139e-22,  5.414049682757659e-03, -2.940079326614365e-04,  9.344674192383269e-06, -2.225125171528470e-07,
  4.369885350301484e-09, -7.442856960197503e-11,  1.133540013833577e-12, -1.575473303721548e-14,  2.027422529758260e-16, -2.441767670115834e-18,  2.775124562286588e-20,
 -2.995533739352719e-22,  3.522136241690497e-03, -2.240498744687394e-04,  8.152498755931284e-06, -2.192759736515043e-07,  4.817994770424595e-09, -9.113957544193277e-11,
  1.532509562344129e-12, -2.340084537550770e-14,  3.294474604893262e-16, -4.324859405919740e-18,  5.340303889406928e-20, -6.244610430250766e-22,  2.222489512275360e-03,
 -1.636807285497792e-04,  6.767858678028076e-06, -2.044213086693519e-07,  5.000626243845466e-09, -1.046061210200552e-10,  1.934436928213943e-12, -3.233511102080253e-14,
  4.963550151527408e-16, -7.079946782185108e-18,  9.469668303235639e-20, -1.196117135089510e-21,  1.362087878289049e-03, -1.149500981116861e-04,  5.363699459490530e-06,
 -1.809409427306202e-07,  4.905119544688876e-09, -1.130078353808144e-10,  2.289886707011685e-12, -4.176005225047499e-14,  6.967531021467474e-16, -1.076676644239443e-17,
  1.555550843190082e-19, -2.116706693655514e-21,  8.119684266076837e-04, -7.780637955477958e-05,  4.070762413037354e-06, -1.525841823932050e-07,  4.563928317551315e-09,
 -1.153594733594502e-10,  2.552462286780268e-12, -5.062320595690795e-14,  9.153345891508983e-16, -1.528077048801962e-17,  2.378441294235709e-19, -3.477868463662913e-21,
  4.715575709258455e-04, -5.088832299478363e-05,  2.967428316853694e-06, -1.229887321266443e-07,  4.042123610741089e-09, -1.116836312918848e-10,  2.689431683267046e-12,
 -5.783302821409702e-14,  1.130037594774058e-15, -2.032667976566963e-17,  3.399952224254175e-19, -5.329659770906916e-21,  2.672652452817811e-04, -3.224097172818220e-05,
  2.083726883275219e-06, -9.505618949168257e-08,  3.419186340683589e-09, -1.029076057040484e-10,  2.688486119455736e-12, -6.250063573267714e-14,  1.316172615803911e-15,
 -2.544434699092849e-17,  4.562609175076435e-19, -7.649823767588545e-21,  1.481057669213217e-04, -1.983704505981214e-05,  1.413524933068453e-06, -7.066464226626395e-08,
  2.771408067522750e-09, -9.055427404862975e-11,  2.558784264314994e-12, -6.412870387090327e-14,  1.451636760334434e-15, -3.008681370899924e-17,  5.770404962491126e-19,
 -1.032514234014571e-20,  8.040675748285400e-05, -1.188310498595890e-05,  9.289875613926087e-07, -5.068303600181792e-08,  2.159436918988535e-09, -7.635250166105709e-11,
  2.326644705039368e-12, -6.269152129887247e-14,  1.521563093377259e-15, -3.372974788455690e-17,  6.903544756418466e-19, -1.315468240726677e-20,  4.285820535331004e-05,
 -6.948555200805008e-06,  5.932085099655602e-07, -3.517945729019125e-08,  1.622661660451268e-09, -6.188989104902859e-11,  2.027971938702877e-12, -5.859336382653409e-14,
  1.521002699995942e-15, -3.597879136572879e-17,  7.841098679709584e-19, -1.587780839847150e-20,  2.247948591752099e-05, -3.976740086833621e-06,  3.691108813242091e-07,
 -2.370352941663589e-08,  1.179626053097687e-09, -4.838574724891860e-11,  1.700113481839634e-12, -5.253441817092516e-14,  1.455026175715560e-15, -3.664265639932634e-17,
  8.484897200460603e-19, -1.822077371396318e-20,  1.163052937549743e-05, -2.233665677522592e-06,  2.244600017042897e-07, -1.555163782587887e-08,  8.322900844677034e-10,
 -3.660438399336484e-11,  1.375366519369585e-12, -4.533716137377660e-14,  1.336553480776677e-15, -3.575365346703169e-17,  8.777639698806741e-19, -1.994870938698038e-20,
  5.950879202185640e-06, -1.234792723578636e-06,  1.338006372092545e-07, -9.966338288855736e-09,  5.717586990428926e-10, -2.688352982639684e-11,  1.077263219466219e-12,
 -3.778605275133605e-14,  1.182874197781815e-15, -3.353640482611967e-17,  8.710551216675905e-19, -2.090808005968609e-20,  3.019219061067448e-06, -6.737814969137228e-07,
  7.842329424718562e-08, -6.258449050401689e-09,  3.836755217241944e-10, -1.923105718963459e-11,  8.196492169819334e-13, -3.051578526479486e-14,  1.012003759417304e-15,
 -3.034122087176183e-17,  8.319736333006796e-19, -2.104865586755107e-20,  1.523192588680295e-06, -3.639939230009259e-07,  4.533740522291171e-08, -3.863346094153372e-09,
  2.523174380274569e-10, -1.344367082156382e-11,  6.078276925418518e-13, -2.395971437835391e-14,  8.397825370915178e-16, -2.656556626611295e-17,  7.673898320878624e-19,
 -2.042153056613433e-20,  7.663421689739199e-07, -1.952782955632994e-07,  2.593430256977502e-08, -2.352004922699767e-09,  1.631522525609700e-10, -9.214504508355247e-12,
  4.407839399184012e-13, -1.835059529600383e-14,  6.781688109289699e-16, -2.258474548487324e-17,  6.858033064882311e-19, -1.915725139346150e-20,  3.856543404810109e-07,
 -1.043667417066429e-07,  1.472655083510460e-08, -1.416826416033923e-09,  1.040737588886144e-10, -6.213145706976409e-12,  3.136251410711474e-13, -1.375543017221512e-14,
  5.347284525706454e-16, -1.870474269229970e-17,  5.957732646674210e-19, -1.743289246793656e-20,  1.947200088235575e-07, -5.574465357573572e-08,  8.328219292313445e-09,
 -8.472917387118717e-10,  6.571047830228588e-11, -4.135056838514162e-12,  2.196736458315827e-13, -1.012486903979548e-14,  4.130283640037284e-16, -1.514063792481482e-17,
  5.047348185762989e-19, -1.543783794246753e-20,  9.894782905134241e-08, -2.985193077765821e-08,  4.705958960140378e-09, -5.046846737703306e-10,  4.120125239688251e-11,
 -2.725318005533677e-12,  1.519693740403579e-13, -7.342014642496469e-15,  3.135340862309185e-16, -1.201671251651573e-17,  4.183349107009662e-19, -1.334583755127134e-20,
  5.076139318630613e-08, -1.607908371752363e-08,  2.665631080216105e-09, -3.003979890105445e-10,  2.573876575123205e-11, -1.784564914870569e-12,  1.041716129970101e-13,
 -5.261907476049403e-15,  2.346521464306435e-16, -9.380719128206136e-18,  3.402557703466859e-19, -1.129720019982158e-20,  2.637077192788866e-08, -8.738549203748329e-09,
  1.518420535217262e-09, -1.792468429793434e-10,  1.607129379921752e-11, -1.164669367488212e-12,  7.097757215316200e-14, -3.738705436914357e-15,  1.736719601715847e-16,
 -7.224487725724423e-18,  2.723947585064845e-19, -9.391435312091945e-21,  1.391432448631426e-08, -4.806512682969675e-09,  8.724857674095130e-10, -1.075517963421505e-10,
  1.006067453859773e-11, -7.598780918515660e-13,  4.821389096621211e-14, -2.641390605992534e-15,  1.274864347213396e-16, -5.504794384065548e-18,  2.152407052746948e-19,
 -7.688245461220531e-21,  7.477647784623302e-09, -2.683366970035634e-09,  5.071688271992641e-10, -6.507975520650456e-11,  6.332240510768541e-12, -4.970306420183131e-13,
  3.274254222708695e-14, -1.860662919292844e-15,  9.306713994516513e-17, -4.160874560557991e-18,  1.683081691869099e-19, -6.213772239295099e-21,  4.103262065804431e-09,
 -1.524465793408739e-09,  2.990249481515318e-10, -3.981650696386402e-11,  4.017509080525590e-12, -3.267530345300391e-13,  2.228549138007970e-14, -1.310043966899996e-15,
  6.772727556360364e-17, -3.127162514574605e-18,  1.305356614455068e-19, -4.969117392219688e-21,  2.303991438459990e-09, -8.832784375267751e-10,  1.792172201545951e-10,
 -2.468415625869739e-11,  2.574902731414139e-12, -2.163571837444244e-13,  1.523349586162114e-14, -9.237682005560763e-16,  4.922865796145576e-17, -2.341349392167632e-18,
  1.006001271292277e-19, -3.938905670210001e-21,  1.325853072598362e-09, -5.227841679818028e-10,  1.093634860625717e-10, -1.553119077313635e-11,  1.669736647457910e-12,
 -1.445102489650557e-13,  1.047331403883753e-14, -6.533052349283258e-16,  3.578925031516820e-17, -1.748638594089245e-18,  7.713575309002840e-20, -3.098567968150122e-21,
  7.824947128032772e-10, -3.163194017979824e-10,  6.800143031517010e-11, -9.925330730375532e-12,  1.096289666983778e-12, -9.742937871173041e-14,  7.246748741667096e-15,
 -4.636497026564927e-16,  2.603684186179990e-17, -1.303311168035268e-18,  5.886695803808387e-20, -2.419809014098408e-21,  4.733639811499027e-10, -1.955633840620290e-10,
  4.306205150491380e-11, -6.438816334082007e-12,  7.283570962263554e-13, -6.626407458801019e-14,  5.043002387965000e-15, -3.299702762036224e-16,  1.894053348065361e-17,
 -9.686202647749643e-19,  4.467502582134647e-20, -1.874260754502775e-21,  2.927666522507249e-10, -1.232292451306135e-10,  2.770168708700388e-11, -4.229421750966360e-12,
  4.884083092348838e-13, -4.534437092971589e-14,  3.520160511376638e-15, -2.348497307749624e-16,  1.373921045208019e-17, -7.157991878557173e-19,  3.361918107762452e-20,
 -1.435610251146138e-21,  1.840203374392121e-10, -7.867359047356011e-11,  1.799593402663727e-11, -2.796284915894640e-12,  3.285782009048691e-13, -3.103176095196245e-14,
  2.449771663141646e-15, -1.661417842178537e-16,  9.876884135536383e-18, -5.227129279330728e-19,  2.492984399821460e-20, -1.080589352837223e-21,  1.161021816342965e-10,
 -5.026461114706683e-11,  1.166073526248408e-11, -1.837911787609809e-12,  2.190362676371365e-13, -2.097572369058807e-14,  1.678618600570148e-15, -1.153712066244814e-16,
  6.948723612064592e-18, -3.724684976768171e-19,  1.798718729278056e-20, -7.891961878439127e-22,  7.159827277359203e-11, -3.129573068165081e-11,  7.338880278875362e-12,
 -1.169422990446080e-12,  1.408850351704319e-13, -1.363616621380961e-14,  1.102719963667805e-15, -7.656929536378040e-17,  4.658120655273260e-18, -2.521437943316775e-19,
  1.229364230209407e-20, -5.444476322139311e-22,  4.037878390250762e-11, -1.776680029866898e-11,  4.197552324225619e-12, -6.739474716161899e-13,  8.180508980230201e-14,
 -7.976593887025069e-15,  6.497396657165201e-16, -4.543736635873002e-17,  2.783477568370470e-18, -1.516973098684482e-19,  7.445562123322156e-21, -3.318850905462978e-22,
  1.621354281097190e-11, -7.160255862827319e-12,  1.698705322919023e-12, -2.738906328008278e-13,  3.338459744669219e-14, -3.268660245711736e-15,  2.673280798015226e-16,
 -1.876875584208131e-17,  1.154225545348385e-18, -6.314295468623247e-20,  3.110658495576062e-21, -1.391585887110521e-22,  6.189010869906258e-02, -1.590357308144132e-04,
  4.246213149239780e-07, -1.169705694006239e-09,  3.297646914058664e-12, -9.444732001648497e-15,  2.731419928931833e-17, -7.941313512355821e-20,  2.313726671594826e-22,
 -6.742002689123982e-25,  1.962055673615122e-27, -5.698723643076003e-30,  5.939390340733325e-02, -1.974644887856776e-04,  7.749843624362572e-07, -3.144686038312778e-09,
  1.259958301745157e-11, -4.937930330487534e-14,  1.894361599143090e-16, -7.133208535173573e-19,  2.643171238671184e-21, -9.658091065337716e-24,  3.485710307908598e-26,
 -1.244186573951938e-28,  5.470447617795873e-02, -2.644837446909099e-04,  1.482591015355506e-06, -7.908833862435801e-09,  3.990071979610370e-11, -1.926800343100973e-13,
  8.987001274431274e-16, -4.073344744546066e-18,  1.801776636453385e-20, -7.802778203592306e-23,  3.316460403827728e-25, -1.386230800024851e-27,  4.836642237102615e-02,
 -3.434078166948593e-04,  2.533436012821517e-06, -1.678118376653649e-08,  1.028461446709753e-10, -5.950750292191838e-13,  3.289661707125379e-15, -1.751317825354402e-17,
  9.029979624471613e-20, -4.528785380753946e-22,  2.216672756965163e-24, -1.061683370406987e-26,  4.106060546573925e-02, -4.155675173596645e-04,  3.856443356347221e-06,
 -3.100627620674180e-08,  2.267096646449328e-10, -1.544752784557366e-12,  9.953488308420624e-15, -6.125097974151078e-17,  3.625415746043146e-19, -2.075017470489181e-21,
  1.153172967482773e-23, -6.242889217952095e-26,  3.348330668585613e-02, -4.653121680163444e-04,  5.305084943793002e-06, -5.103790511510199e-08,  4.392231110468021e-10,
 -3.479217997550777e-12,  2.581462732985633e-14, -1.815284525009958e-16,  1.220015895936347e-18, -7.885858436588347e-21,  4.925999749016606e-23, -2.985042798688781e-25,
  2.623954656819036e-02, -4.835368228818476e-04,  6.673375316493750e-06, -7.593836580654885e-08,  7.608534900687924e-10, -6.936530096768061e-12,  5.871210003108187e-14,
 -4.676394322210439e-16,  3.538811495161914e-18, -2.562507974997336e-20,  1.785339302291663e-22, -1.201971752266108e-24,  1.977224123952110e-02, -4.688550061771218e-04,
  7.743313278070371e-06, -1.031866181551648e-07,  1.192888810935277e-09, -1.241445290870679e-11,  1.189628210068570e-13, -1.065594832390424e-15,  9.018068226663333e-18,
 -7.268172440642985e-20,  5.612815588379189e-22, -4.173075763216724e-24,  1.433567776835037e-02, -4.264889789695489e-04,  8.343749258527756e-06, -1.290689614906438e-07,
  1.708420278631651e-09, -2.015552400539966e-11,  2.172657313062400e-13, -2.175498896431390e-15,  2.047308670072498e-17, -1.826587855027624e-19,  1.555368932937566e-21,
 -1.270661251920320e-23,  1.000876792720941e-02, -3.656925066603607e-04,  8.395505048389994e-06, -1.495746659493376e-07,  2.251609908406088e-09, -2.993195353794610e-11,
  3.609356696682895e-13, -4.019098384733685e-15,  4.185300483884830e-17, -4.114362223030232e-19,  3.845842461808486e-21, -3.437478761862214e-23,  6.734855343940183e-03,
 -2.968033195731617e-04,  7.925695714398391e-06, -1.614737828557856e-07,  2.747674208477029e-09, -4.093595670874590e-11,  5.494828853755638e-13, -6.773160156927428e-15,
  7.771186570370063e-17, -8.383030940093884e-19,  8.568089806078495e-21, -8.347349291085165e-23,  4.372161917998573e-03, -2.288467536653240e-04,  7.049318008822148e-06,
 -1.631625517146387e-07,  3.121101974857730e-09, -5.185824033139929e-11,  7.714111707293950e-13, -1.048258572775734e-14,  1.320018740241809e-16, -1.556819920184980e-18,
  1.733785889943778e-20, -1.834921570977004e-22,  2.741394319166125e-03, -1.681712102691106e-04,  5.929474914472130e-06, -1.549750479880760e-07,  3.315528362388137e-09,
 -6.116110033925890e-11,  1.004126868742839e-12, -1.498575938158735e-14,  2.063830049183559e-16, -2.652339427221412e-18,  3.208353333677853e-20, -3.677402741400350e-22,
  1.662245852827701e-03, -1.181339312429829e-04,  4.733224647283715e-06, -1.389040800204264e-07,  3.307796743702573e-09, -6.746112458300099e-11,  1.217774698047478e-12,
 -1.989069914858744e-14,  2.986173370341933e-16, -4.169022352838098e-18,  5.461561790178177e-20, -6.760847551717027e-22,  9.760344966832704e-04, -7.954565154858867e-05,
  3.597400565637765e-06, -1.179106973746190e-07,  3.111467955951495e-09, -6.988180328612081e-11,  1.382090790789254e-12, -2.462614968189102e-14,  4.018020925661144e-16,
 -6.076507738385670e-18,  8.597825190198545e-20, -1.146497337082292e-21,  5.558246632325093e-04, -5.147882604172285e-05,  2.611347220265065e-06, -9.511873836466858e-08,
  2.769682383102374e-09, -6.824930419238166e-11,  1.473920971018801e-12, -2.856109680316262e-14,  5.050081693771453e-16, -8.250778069452654e-18,  1.257693652296807e-19,
 -1.802201890033381e-21,  3.074900417632986e-04, -3.210233457008431e-05,  1.815911785727043e-06, -7.316199148636396e-08,  2.341306641709566e-09, -6.307549791873779e-11,
  1.482706794375733e-12, -3.115487094592390e-14,  5.953551764137241e-16, -1.048137508334028e-17,  1.717093940635625e-19, -2.637946342978625e-21,  1.655489223258849e-04,
 -1.934011825236989e-05,  1.213290615949003e-06, -5.382774083180960e-08,  1.885935573376137e-09, -5.535992177227922e-11,  1.412156243485108e-12, -3.208531054843497e-14,
  6.609244672947848e-16, -1.250771360141176e-17,  2.197077636045078e-19, -3.610802182338822e-21,  8.691024383268136e-05, -1.128557751713731e-05,  7.811809896960164e-07,
 -3.800162124498258e-08,  1.452384456093609e-09, -4.630268981076976e-11,  1.277937184397489e-12, -3.131212174745035e-14,  6.935255727268980e-16, -1.407500663854211e-17,
  2.645084148759085e-19, -4.640466613282251e-21,  4.458408431414738e-05, -6.395573626818784e-06,  4.861117628538511e-07, -2.582503559462134e-08,  1.072884301348342e-09,
 -3.703161249672944e-11,  1.102697069590683e-12, -2.906036257691847e-14,  6.903931421687047e-16, -1.499160932908363e-17,  3.007613715914052e-19, -5.620978897205902e-21,
  2.239944529550618e-05, -3.529443647830584e-06,  2.932338194900535e-07, -1.694707860629634e-08,  7.627246418525719e-10, -2.841604165916875e-11,  9.103860830143672e-13,
 -2.573967826860139e-14,  6.543499467587770e-16, -1.516895578135518e-17,  3.241848359600722e-19, -6.441302105754270e-21,  1.104836028570659e-05, -1.902053633322466e-06,
  1.719907111642552e-07, -1.077333795771340e-08,  5.235520588179284e-10, -2.099171152517898e-11,  7.216287611743368e-13, -2.183419500695623e-14,  5.925711453253302e-16,
 -1.463269978993960e-17,  3.324448560630948e-19, -7.008553006211404e-21,  5.363977467025493e-06, -1.003904072476634e-06,  9.839184804018290e-08, -6.656029309236615e-09,
  3.481587067329695e-10, -1.497967610314813e-11,  5.510860794161958e-13, -1.779993390192121e-14,  5.145363928772247e-16, -1.350497375826634e-17,  3.255000883712161e-19,
 -7.266616399858507e-21,  2.570397795236764e-06, -5.205065444442838e-07,  5.507599340565925e-08, -4.009819164957189e-09,  2.250548860655482e-10, -1.036141005492757e-11,
  4.068648032021836e-13, -1.399477136361860e-14,  4.298966203754473e-16, -1.196730800894745e-17,  3.053685076503829e-19, -7.204856156374799e-21,  1.219277416478020e-06,
 -2.659418707107584e-07,  3.026491766823253e-08, -2.363441849986915e-09,  1.419012964019240e-10, -6.971201164548104e-12,  2.914253750809121e-13, -1.064896634275173e-14,
  3.468292158562313e-16, -1.021798181834984e-17,  2.754679301819701e-19, -6.855482680444551e-21,  5.742803143609928e-07, -1.343341452997021e-07,  1.638157242069822e-08,
 -1.367647313944147e-09,  8.757706349477483e-11, -4.578258264227929e-12,  2.032305444446640e-13, -7.870151603342785e-15,  2.711500741472297e-16, -8.435973275535451e-18,
  2.397851271607501e-19, -6.281962573810040e-21,  2.694364185875359e-07, -6.731107586780848e-08,  8.764250753510127e-09, -7.797276125167607e-10,  5.309408074131354e-11,
 -2.945436671169922e-12,  1.384807471576652e-13, -5.669500440194055e-15,  2.061545902974683e-16, -6.758436044892391e-18,  2.021196891256898e-19, -5.563118431593424e-21,
  1.263415340099051e-07, -3.357318565470761e-08,  4.651114980330405e-09, -4.395527130236811e-10,  3.173384991486527e-11, -1.863062551869239e-12,  9.253317873021284e-14,
 -3.995350916039059e-15,  1.529743936827688e-16, -5.272787587409867e-18,  1.655616725559041e-19, -4.777747220030351e-21,  5.941357469073207e-08, -1.672811631643675e-08,
  2.457264418118418e-09, -2.459015509766627e-10,  1.876755662086276e-11, -1.162836784482656e-12,  6.085434217010886e-14, -2.764276609614540e-15,  1.111839351381700e-16,
 -4.020294104523106e-18,  1.322513849572973e-19, -3.993168085282507e-21,  2.811905667152128e-08, -8.356399707318640e-09,  1.297145343217351e-09, -1.370222523306927e-10,
  1.102295024532582e-11, -7.188099335902755e-13,  3.953222823880129e-14, -1.884473961566523e-15,  7.943505897469627e-17, -3.006284912585190e-18,  1.033812879137607e-19,
 -3.259070084490039e-21,  1.344110774050723e-08, -4.200399138871485e-09,  6.866938037737905e-10, -7.633066078196350e-11,  6.453372691380705e-12, -4.416687056688883e-13,
  2.545924523799259e-14, -1.270376315859933e-15,  5.598366161927154e-17, -2.212422858433497e-18,  7.935488213720328e-20, -2.606258147093421e-21,  6.512233031786105e-09,
 -2.132238567934041e-09,  3.658973187213939e-10, -4.266453917606803e-11,  3.779614610579500e-12, -2.707232389229049e-13,  1.631231850791831e-14, -8.498245576796808e-16,
  3.905601372886638e-17, -1.607854030386414e-18,  6.001299426148412e-20, -2.048865191124700e-21,  3.209210047224507e-09, -1.096977322490346e-09,  1.969357229140122e-10,
 -2.401247443965157e-11,  2.222334062509197e-12, -1.661165079945377e-13,  1.043405730672650e-14, -5.660426359180389e-16,  2.706047940657950e-17, -1.157664614387997e-18,
  4.485872024673635e-20, -1.588342123949486e-21,  1.613950693842010e-09, -5.739235014734433e-10,  1.074330773328691e-10, -1.365458035733898e-11,  1.316213653858259e-12,
 -1.023747010864710e-13,  6.684505701294648e-15, -3.765978544903040e-16,  1.867939627929850e-17, -8.283371581004417e-19,  3.324144723878098e-20, -1.217815961245793e-21,
  8.309033933420637e-10, -3.063193099430677e-10,  5.958919189521308e-11, -7.869497322530880e-12,  7.876552309784804e-13, -6.355949614894129e-14,  4.301839924406442e-15,
 -2.510027845245438e-16,  1.288262798215139e-17, -5.906422624915638e-19,  2.448604680126427e-20, -9.259122598111464e-22,  4.390941548103948e-10, -1.672480543474319e-10,
  3.369854770569264e-11, -4.609212714924690e-12,  4.775320797401552e-13, -3.985807155864800e-14,  2.788185624403364e-15, -1.680105170618147e-16,  8.898479970760533e-18,
 -4.206874735155606e-19,  1.797034535609816e-20, -6.996332328271119e-22,  2.386944276323850e-10, -9.361964359716336e-11,  1.947225193817204e-11, -2.749469305741265e-12,
  2.939242910627909e-13, -2.529794383166138e-14,  1.823599138394280e-15, -1.131567182298348e-16,  6.167303685272045e-18, -2.998330974468196e-19,  1.316220564138834e-20,
 -5.262441496473475e-22,  1.336490444106040e-10, -5.379903468613146e-11,  1.151219014822732e-11, -1.672522937285603e-12,  1.838957563251883e-13, -1.627042130390572e-14,
  1.204928776127178e-15, -7.676533390268434e-17,  4.293068094634146e-18, -2.140318113095176e-19,  9.629368570797659e-21, -3.943224222040321e-22,  7.707799974890553e-11,
 -3.173987494213277e-11,  6.963869563207828e-12, -1.037512848043385e-12,  1.169462881633692e-13, -1.060247544187368e-14,  8.041572193265540e-16, -5.244278518947964e-17,
  3.000534586469773e-18, -1.529647132410446e-19,  7.033455733617754e-21, -2.941965942426941e-22,  4.569345729626504e-11, -1.918647889136810e-11,  4.301527003202951e-12,
 -6.549752621825114e-13,  7.543455315761837e-14, -6.985175917458291e-15,  5.408901312932855e-16, -3.599614771129919e-17,  2.100747529215478e-18, -1.091882261354993e-19,
  5.116466294995437e-21, -2.179946216703425e-22,  2.769216569062506e-11, -1.181901828632857e-11,  2.698381529338117e-12, -4.184850871674757e-13,  4.908143126697790e-14,
 -4.626798901104643e-15,  3.645972375670015e-16, -2.468304314248056e-17,  1.464840829169880e-18, -7.739318855585420e-20,  3.685073163324198e-21, -1.594754565508799e-22,
  1.695286761359608e-11, -7.331317684103421e-12,  1.698652035860992e-12, -2.673968611612380e-13,  3.182782136404356e-14, -3.044226456499506e-15,  2.433282011268028e-16,
 -1.670436803028106e-17,  1.004943713963069e-18, -5.380741366896295e-20,  2.595632999124252e-21, -1.137640724645215e-22,  1.021251567902459e-11, -4.460970215891081e-12,
  1.045326998603148e-12, -1.664439653477661e-13,  2.003726415293356e-14, -1.937975979123107e-15,  1.566066450960574e-16, -1.086663496134777e-17,  6.606224975260198e-19,
 -3.573549425426748e-20,  1.741195578449552e-21, -7.706298816997759e-23,  5.665727643521255e-12, -2.492085968035134e-12,  5.885477985055799e-13, -9.445844300666484e-14,
  1.146107272346551e-14, -1.117107560513183e-15,  9.096038952168753e-17, -6.358644657510087e-18,  3.893863520502876e-19, -2.121365965996744e-20,  1.040837714640155e-21,
 -4.637934064807057e-23,  2.254177203700830e-12, -9.953289191044432e-13,  2.360880601057114e-13, -3.805828452120949e-14,  4.638037584577422e-15, -4.540196702641355e-16,
  3.712506098884895e-17, -2.606014631914321e-18,  1.602329864843066e-19, -8.764096654756950e-21,  4.316748451764746e-22, -1.930802859096911e-23,  6.126067206686713e-02,
 -1.556940233366531e-04,  4.108953005216336e-07, -1.118419624028544e-09,  3.115131803523532e-12, -8.815059285488120e-15,  2.519074290682845e-17, -7.238287891037619e-20,
  2.084557683732453e-22, -6.005082631649788e-25,  1.727903276526365e-27, -4.962699871630739e-30,  5.861621094711573e-02, -1.914122052141137e-04,  7.384258816345849e-07,
 -2.950752996692130e-09,  1.165589188452804e-11, -4.506326547085802e-14,  1.705969054347926e-16, -6.340436851326474e-19,  2.319312252468045e-21, -8.367359259490421e-24,
  2.981999092107191e-26, -1.051167992807219e-28,  5.366967652917456e-02, -2.529920730454176e-04,  1.391392002188507e-06, -7.300116884663704e-09,  3.625389482064194e-11,
 -1.724172296891274e-13,  7.923137333421014e-16, -3.539274565950206e-18,  1.543355532689323e-20, -6.590531302093923e-23,  2.762756626637598e-25, -1.139147396570537e-27,
  4.703208904500043e-02, -3.239187287102969e-04,  2.341555741702887e-06, -1.522672877561707e-08,  9.169606876160247e-11, -5.216955266814515e-13,  2.837412959414831e-15,
 -1.486820335526328e-17,  7.548570442963412e-20, -3.728906327606064e-22,  1.798216213039358e-24, -8.487516673603436e-27,  3.945776607664143e-02, -3.861448732384599e-04,
  3.505153138017450e-06, -2.761366304675019e-08,  1.980710223791386e-10, -1.325204412613863e-12,  8.390254411134856e-15, -5.076094075400031e-17,  2.955220231760582e-19,
 -1.664322436739775e-21,  9.104149186531395e-24, -4.852751057771759e-26,  3.170322244682741e-02, -4.252069172038371e-04,  4.732603720254555e-06, -4.453499995619252e-08,
  3.754442891893983e-10, -2.916498252962253e-12,  2.123828898276114e-14, -1.466741871595194e-16,  9.686400992840197e-19, -6.155043752846756e-21,  3.781224039557102e-23,
 -2.254212887749878e-25,  2.440668083355570e-02, -4.335979770801303e-04,  5.830815118993420e-06, -6.480222636097274e-08,  6.352158736367449e-10, -5.672575762990913e-12,
  4.707415894038011e-14, -3.678764017710392e-16,  2.733052273664096e-18, -1.943924633169617e-20,  1.330922045140286e-22, -8.808764789474551e-25,  1.801330644589937e-02,
 -4.115549020674512e-04,  6.611873775512491e-06, -8.594116941930417e-08,  9.708928677741228e-10, -9.887046947221380e-12,  9.280183759375587e-14, -8.148835353972970e-16,
  6.764986067960289e-18, -5.351515827233155e-20,  4.058316253993492e-22, -2.964321602601420e-24,  1.275403044067707e-02, -3.654984981296824e-04,  6.946491607465695e-06,
 -1.046952590147269e-07,  1.352877840750884e-09, -1.560375566674947e-11,  1.646148211246809e-13, -1.614578624366825e-15,  1.489438653463423e-17, -1.303432810365789e-19,
  1.089243116610887e-21, -8.737201795719659e-24,  8.669766574074046e-03, -3.051382305449323e-04,  6.798434758339977e-06, -1.179030642969669e-07,  1.731207798059980e-09,
 -2.248126749294018e-11,  2.651200589386181e-13, -2.889825955711047e-15,  2.948065378049084e-17, -2.840985051250267e-19,  2.604745689681052e-21, -2.284781743339228e-23,
  5.663159757636347e-03, -2.404589962524970e-04,  6.226925580236288e-06, -1.234039830050422e-07,  2.046811460386130e-09, -2.976883007776174e-11,  3.905454193827713e-13,
 -4.709672579691873e-15,  5.290818549920839e-17, -5.592127195163142e-19,  5.603590614214568e-21, -5.355184976937596e-23,  3.558265884165449e-03, -1.795078242096033e-04,
  5.359771821430434e-06, -1.206081442459863e-07,  2.247564688844406e-09, -3.643656688325401e-11,  5.294800647755465e-13, -7.035756728647090e-15,  8.670987259683965e-17,
 -1.001589740200609e-18,  1.093170776558043e-20, -1.134487754310453e-22,  2.152963482147316e-03, -1.273575048839411e-04,  4.351580377255487e-06, -1.105332755597189e-07,
  2.302821490244363e-09, -4.143108715065206e-11,  6.642287018916339e-13, -9.690115077271956e-15,  1.305635666911247e-16, -1.642864325797314e-18,  1.947004167587316e-20,
 -2.187742555866613e-22,  1.256031950975899e-03, -8.612890007383994e-05,  3.344069484045064e-06, -9.535670510730784e-08,  2.210770746786013e-09, -4.396293632473549e-11,
  7.747523014318482e-13, -1.236675563843436e-14,  1.815988366690926e-16, -2.481749054180301e-18,  3.184642611989801e-20, -3.863944625062774e-22,  7.075172941938986e-04,
 -5.567541857785562e-05,  2.440306218991589e-06, -7.771672709389945e-08,  1.996411878984083e-09, -4.371372747603941e-11,  8.438955598854598e-13, -1.469243091528074e-14,
  2.344440018465086e-16, -3.470146515088949e-18,  4.808929275502397e-20, -6.284488310523742e-22,  3.854029062813489e-04, -3.449287372182119e-05,  1.696322290811977e-06,
 -6.004396590148315e-08,  1.702048784315115e-09, -4.088885195979884e-11,  8.619167216614446e-13, -1.631897243805140e-14,  2.821804589355469e-16, -4.512030811557651e-18,
  6.735999434829161e-20, -9.459213931996251e-22,  2.033618377658272e-04, -2.053462313561580e-05,  1.126640403996747e-06, -4.412161883454073e-08,  1.374789640589167e-09,
 -3.611210469661105e-11,  8.286434320366569e-13, -1.701348981426550e-14,  3.179643390867384e-16, -5.478879690837654e-18,  8.791036938410873e-20, -1.323610881696027e-21,
  1.041368584447926e-04, -1.177809239748101e-05,  7.170933108122467e-07, -3.093615104395361e-08,  1.055669346141512e-09, -3.022125443140150e-11,  7.526706208588923e-13,
 -1.671312639121123e-14,  3.367484561134799e-16, -6.238301885165004e-18,  1.073414940348933e-19, -1.729159031266381e-21,  5.185566111552703e-05, -6.526027780554143e-06,
  4.387110203488427e-07, -2.076379395129978e-08,  7.732307043048671e-10, -2.404928146005814e-11,  6.482513322316532e-13, -1.552727270244993e-14,  3.364789569119026e-16,
 -6.686253905074447e-18,  1.231139967811851e-19, -2.117562128813871e-21,  2.516493855104296e-05, -3.502613729432633e-06,  2.587649038422347e-07, -1.338342531451836e-08,
  5.420441293757779e-10, -1.826097540092482e-11,  5.312819695277467e-13, -1.369249664229731e-14,  3.183783748993035e-16, -6.771402747945179e-18,  1.331448874498755e-19,
 -2.440367796211038e-21,  1.192978895050059e-05, -1.826115056169333e-06,  1.476017456489955e-07, -8.311060973930391e-09,  3.648927098097381e-10, -1.327634651490159e-11,
  4.157983379290570e-13, -1.150218438275613e-14,  2.863168990887693e-16, -6.503693491232389e-18,  1.362841976014619e-19, -2.656673045609620e-21,  5.538806846638680e-06,
 -9.275303643073557e-07,  8.167814701573990e-08, -4.988924378796108e-09,  2.366889004829503e-10, -9.274192102388092e-12,  3.118546893937145e-13, -9.237298598543566e-15,
  2.456080642025341e-16, -5.945892639690483e-18,  1.325178334514312e-19, -2.742213690732389e-21,  2.525442785965519e-06, -4.603827693384480e-07,  4.399051959641706e-08,
 -2.904583430188906e-09,  1.484483364167244e-10, -6.246628071029411e-12,  2.249481524338151e-13, -7.117711148191206e-15,  2.017000770223902e-16, -5.193198113265695e-18,
  1.228582666528351e-19, -2.693675732997103e-21,  1.134150677547288e-06, -2.240207119898984e-07,  2.313713191629876e-08, -1.645855474277472e-09,  9.034257143584813e-11,
 -4.071390206750754e-12,  1.566183376733155e-13, -5.281354896667833e-15,  1.591558633019916e-16, -4.349138217874484e-18,  1.090004257464599e-19, -2.527344839007994e-21,
  5.032369427083954e-07, -1.072226493874035e-07,  1.192525703833050e-08, -9.109171222014900e-10,  5.354286305336952e-11, -2.577237529236548e-12,  1.056400289672960e-13,
 -3.787564030755093e-15,  1.211138392152005e-16, -3.505280538518356e-18,  9.288475672604129e-20, -2.273288179032625e-21,  2.213504537738536e-07, -5.065594432858855e-08,
  6.045036606099560e-09, -4.942430619050318e-10,  3.101812904196979e-11, -1.590387148670672e-12,  6.928921268739434e-14, -2.635173226948284e-15,  8.921563734301554e-17,
 -2.729039321002374e-18,  7.630669200993769e-20, -1.967510892713850e-21,  9.685224659120984e-08, -2.370830564487636e-08,  3.024983340099523e-09, -2.638878686840089e-10,
  1.763147295949853e-11, -9.603862911258985e-13,  4.436193233869285e-14, -1.785435408466979e-15,  6.385686309059577e-17, -2.060144818804977e-18,  6.066038233104783e-20,
 -1.644610039795529e-21,  4.231045520394136e-08, -1.103414392259020e-08,  1.500072063883440e-09, -1.391884951327833e-10,  9.872206757429119e-12, -5.697392144503197e-13,
  2.783230299962591e-14, -1.182609295694164e-15,  4.458180802788372e-17, -1.513689255929897e-18,  4.683891377871077e-20, -1.332633344458840e-21,  1.852446216694949e-08,
 -5.126741267175536e-09,  7.400915146701847e-10, -7.281496044405079e-11,  5.466646698079824e-12, -3.333616161368614e-13,  1.717881345325003e-14, -7.687728035421434e-16,
  3.047700388314011e-17, -1.086649937124423e-18,  3.526235955759900e-20, -1.050713296927792e-21,  8.160314984887160e-09, -2.387538114414499e-09,  3.647537727860048e-10,
 -3.793423505452509e-11,  3.005826404188484e-12, -1.931561305499874e-13,  1.047300975698180e-14, -4.924080640140816e-16,  2.048056227270793e-17, -7.651123148050753e-19,
  2.598151885038042e-20, -8.091068048300418e-22,  3.631380703239831e-09, -1.119019496351865e-09,  1.803169577142894e-10, -1.976125159723084e-11,  1.647828195936479e-12,
 -1.112778031411650e-13,  6.331676574463372e-15, -3.119861336627103e-16,  1.358172919665708e-17, -5.304036318873165e-19,  1.880628884445789e-20, -6.107810137554422e-22,
  1.639065214108732e-09, -5.300135483603678e-10,  8.978067866606942e-11, -1.033593345852454e-11,  9.043372632656925e-13, -6.399730548485884e-14,  3.811165806834236e-15,
 -1.963025545455777e-16,  8.922406872166270e-18, -3.633917619437513e-19,  1.342267500641450e-20, -4.536338134320913e-22,  7.533990973172209e-10, -2.547223436063522e-10,
  4.520706930947675e-11, -5.449954884508221e-12,  4.988348204615085e-13, -3.688776208433805e-14,  2.292856947690377e-15, -1.231279273275457e-16,  5.828433307302885e-18,
 -2.469610804777578e-19,  9.480641236853123e-21, -3.326582376784817e-22,  3.540433995288667e-10, -1.247088595957386e-10,  2.311113744388101e-11, -2.908323870097124e-12,
  2.776308652926162e-13, -2.139050569984397e-14,  1.383877137721380e-15, -7.727112685234928e-17,  3.799458334263773e-18, -1.670667554356787e-19,  6.649478731356683e-21,
 -2.416673500459778e-22,  1.707242636637182e-10, -6.243123637104003e-11,  1.204047601093711e-11, -1.576508769150836e-12,  1.564716699798509e-13, -1.252337830322092e-14,
  8.408752985596063e-16, -4.868402391642374e-17,  2.479905518429074e-18, -1.128670839666845e-19,  4.645793765146632e-21, -1.744613607770423e-22,  8.475985413157051e-11,
 -3.206621899041787e-11,  6.414007278958541e-12, -8.709408607519771e-13,  8.959186939159945e-14, -7.426101287136818e-15,  5.159683530791939e-16, -3.088680948060407e-17,
  1.625416353337143e-18, -7.636521116193231e-20,  3.242292702319877e-21, -1.254879629442583e-22,  4.344577517867405e-11, -1.694563532768255e-11,  3.503396712927580e-12,
 -4.917080777608633e-13,  5.225474236630909e-14, -4.471636971426216e-15,  3.205272799987766e-16, -1.978035421895475e-17,  1.072334101725617e-18, -5.186291350065360e-20,
  2.265209225039430e-21, -9.012229268900466e-23,  2.303587080090428e-11, -9.231783269699706e-12,  1.965907680378635e-12, -2.842290736998357e-13,  3.110240942949779e-14,
 -2.739006721372604e-15,  2.019190978888554e-16, -1.280717760674721e-17,  7.131459843813125e-19, -3.540466290969082e-20,  1.586350876165535e-21, -6.470278790981153e-23,
  1.264252943366573e-11, -5.188223571531417e-12,  1.134030305958469e-12, -1.683147053522407e-13,  1.890142505438557e-14, -1.707377380373922e-15,  1.290372884338267e-16,
 -8.385920894062915e-18,  4.781817070698884e-19, -2.429700719031512e-20,  1.113613522977809e-21, -4.643518000965203e-23,  7.171538527875415e-12, -3.003641511429473e-12,
  6.715081285208772e-13, -1.019581985238388e-13,  1.170990679999683e-14, -1.081362354533738e-15,  8.351055292238931e-17, -5.543131203894422e-18,  3.226771678286681e-19,
 -1.672990319709366e-20,  7.820569536530240e-22, -3.324253691685243e-23,  4.184084596458366e-12, -1.782574398750142e-12,  4.061663019232992e-13, -6.286485890488720e-14,
  7.358406473708993e-15, -6.923133520966745e-16,  5.445151832557735e-17, -3.679506238138821e-18,  2.179692574120310e-19, -1.149584838280064e-20,  5.464331245744688e-22,
 -2.360793959832918e-23,  2.482091417849446e-12, -1.072132590547233e-12,  2.480858489498341e-13, -3.900132215433917e-14,  4.636198325955543e-15, -4.428684030724180e-16,
  3.535451408686807e-17, -2.424095433358608e-18,  1.456603251750317e-19, -7.789938863835528e-21,  3.753530233219841e-22, -1.643311430262817e-23,  1.459043510538796e-12,
 -6.368901585409297e-13,  1.491247020334695e-13, -2.372594655394974e-14,  2.854009001237624e-15, -2.758242971619411e-16,  2.227246322177919e-17, -1.544308765812122e-18,
  9.381678692202071e-20, -5.071334139484934e-21,  2.469290706860825e-22, -1.092145369481124e-23,  7.956620311041386e-13, -3.498489674303601e-13,  8.258927234816150e-14,
 -1.324964513920881e-14,  1.606983823657642e-15, -1.565692695467131e-16,  1.274360147037496e-17, -8.905042652360721e-19,  5.451136557990538e-20, -2.968657747059046e-21,
  1.456025657212633e-22, -6.485683232457828e-24,  3.135293784004259e-13, -1.384147472680368e-13,  3.282501690673822e-14, -5.290460301314253e-15,  6.446023653661405e-16,
 -6.308794819187147e-17,  5.157675409728760e-18, -3.619760972867846e-19,  2.225216911600177e-20, -1.216875516326403e-21,  5.992602874005382e-23, -2.679895588428828e-24,
  6.064438647724740e-02, -1.524597109474238e-04,  3.977676043022723e-07, -1.069955751704020e-09,  2.944716044301546e-12, -8.234067835729465e-15,  2.325425321863354e-17,
 -6.604526305939266e-20,  1.880307115067533e-22, -5.355657564827810e-25,  1.523840647761040e-27, -4.328331898845223e-30,  5.786215707047816e-02, -1.856433309825189e-04,
  7.041067740041710e-07, -2.771252279346463e-09,  1.079417401281145e-11, -4.117386210522076e-14,  1.538390403698343e-16, -5.644238276345493e-19,  2.038488563219394e-21,
 -7.262106290914830e-24,  2.556002873342758e-26, -8.899300829039396e-29,  5.267942928437251e-02, -2.422017371039871e-04,  1.307160435130551e-06, -6.746640864369689e-09,
  3.298795783759403e-11, -1.545372069843649e-13,  6.997862557385146e-16, -3.081323671775247e-18,  1.324837374944248e-20, -5.579466225594226e-23,  2.307168058768404e-25,
 -9.385539858580178e-28,  4.577275598589926e-02, -3.058929940491614e-04,  2.167305109914180e-06, -1.383949976181731e-08,  8.191077604514840e-11, -4.583323006805141e-13,
  2.452997677534079e-15, -1.265426215014273e-17,  6.327117521792303e-20, -3.079074893422644e-22,  1.463169972630161e-24, -6.806914085537167e-27,  3.796724388577292e-02,
 -3.593771741944207e-04,  3.191963529515637e-06, -2.464608320675035e-08,  1.734707659878187e-10, -1.139878324014338e-12,  7.092812535166819e-15, -4.219657395002461e-17,
  2.416776381642426e-19, -1.339517128688721e-21,  7.213684200614616e-24, -3.786505090619948e-26,  3.007487032198072e-02, -3.893859064248784e-04,  4.232387525113440e-06,
 -3.896817216647481e-08,  3.218961260729380e-10, -2.452754007307946e-12,  1.753402543013255e-14, -1.189494473767493e-16,  7.720515936509378e-19, -4.823739540184552e-21,
  2.914885297435182e-23, -1.709889474377307e-25,  2.276089003499154e-02, -3.898974244716528e-04,  5.110614909219591e-06, -5.548833211827810e-08,  5.322762721416679e-10,
 -4.657131387626524e-12,  3.789973059580312e-14, -2.906595496932945e-16,  2.120406714787011e-18, -1.481696963920518e-20,  9.970844086683286e-23, -6.488762414684905e-25,
  1.646669924384008e-02, -3.625352840328122e-04,  5.667631816839741e-06, -7.187513678428707e-08,  7.936954725691164e-10, -7.910815644179667e-12,  7.274713015122083e-14,
 -6.263341496504226e-16,  5.101713717458171e-18, -3.961949612215375e-20,  2.951024437432767e-22, -2.118040507106483e-24,  1.139571337754861e-02, -3.146063505821389e-04,
  5.810381844935742e-06, -8.534561127740142e-08,  1.076909405574447e-09, -1.214569299312229e-11,  1.254297485657370e-13, -1.205325505416987e-15,  1.090167663041876e-17,
 -9.359460183708755e-20,  7.677317342237787e-22, -6.047615802779709e-24,  7.549650378102475e-03, -2.559712656680801e-04,  5.536005362149377e-06, -9.348073335416134e-08,
  1.339170439068817e-09, -1.699154272550564e-11,  1.960074517368262e-13, -2.091791878700407e-15,  2.090902659117009e-17, -1.975606468519514e-19,  1.776968357886491e-21,
 -1.529897243349487e-23,  4.792306110275793e-03, -1.960523994006593e-04,  4.924459207334408e-06, -9.495035920862233e-08,  1.535399320156323e-09, -2.180403593541672e-11,
  2.796346266157857e-13, -3.299682448397580e-15,  3.630086458051366e-17, -3.759973335213266e-19,  3.694456929169640e-21, -3.463931392498640e-23,  2.917620034248937e-03,
 -1.418587118174128e-04,  4.106258380790404e-06, -8.984825618810782e-08,  1.631440781971449e-09, -2.581004165123034e-11,  3.664537712526193e-13, -4.762452083790571e-15,
  5.745172165661422e-17, -6.500596253295746e-19,  6.954332363983727e-21, -7.078110582981394e-23,  1.705566043866282e-03, -9.728186533007384e-05,  3.221480078668558e-06,
 -7.953535795121088e-08,  1.613863695547160e-09, -2.832306560575046e-11,  4.434783540939543e-13, -6.325078775704881e-15,  8.339036545676882e-17, -1.027488142431897e-18,
  1.193187070740779e-20, -1.314499171662004e-22,  9.585427956494804e-04, -6.341293631142620e-05,  2.385984641283148e-06, -6.611506040970655e-08,  1.492477724303317e-09,
 -2.894197155334202e-11,  4.979854412099739e-13, -7.769055834894966e-15,  1.116003316231667e-16, -1.493076203943397e-18,  1.876935677571859e-20, -2.232276414698133e-22,
  5.186412954696442e-04, -3.940028032075094e-05,  1.673726143308708e-06, -5.179387140009568e-08,  1.295285641321694e-09, -2.765252638019137e-11,  5.211211226216113e-13,
 -8.865919266271610e-15,  1.383674213591024e-16, -2.004672250384739e-18,  2.721090045387403e-20, -3.485243385534896e-22,  2.705892115654701e-04, -2.339700028839894e-05,
  1.115461325309699e-06, -3.836821570553062e-08,  1.058818560554960e-09, -2.479899301699290e-11,  5.102666478554171e-13, -9.439989735398124e-15,  1.596382392273336e-16,
 -2.498338949443083e-18,  3.653016664687676e-20, -5.027459641741215e-22,  1.363598533133471e-04, -1.331399250756345e-05,  7.084295730711751e-07, -2.696576957197076e-08,
  8.180841820217579e-10, -2.095197421069995e-11,  4.693114229214042e-13, -9.415549804436247e-15,  1.720960772623046e-16, -2.902430513565477e-18,  4.561307257402022e-20,
 -6.730763175137186e-22,  6.649881336319186e-05, -7.279408150718495e-06,  4.300497404452199e-07, -1.803895452694073e-08,  5.994895350655832e-10, -1.673628490970984e-11,
  4.069486426454127e-13, -8.830969000868570e-15,  1.740395606253225e-16, -3.155981702967659e-18,  5.319387136792522e-20, -8.399056014741728e-22,  3.144772243773478e-05,
 -3.834399840294808e-06,  2.502845235036069e-07, -1.152314488799325e-08,  4.180644843282247e-10, -1.268416725654224e-11,  3.338916952357531e-13, -7.817634888226890e-15,
  1.657385658003325e-16, -3.224501411976775e-18,  5.816983263666834e-20, -9.808694989543669e-22,  1.445410203141597e-05, -1.951290633966862e-06,  1.400799810096396e-07,
 -7.051884845774734e-09,  2.783905487565095e-10, -9.152739478955545e-12,  2.601449271121063e-13, -6.555972765484636e-15,  1.491829947211363e-16, -3.107397083694805e-18,
  5.987922884579253e-20, -1.076245109173218e-21,  6.472683519691378e-06, -9.621152000665058e-07,  7.563292435595827e-08, -4.148107782471535e-09,  1.776238146784953e-10,
 -6.310309459029030e-12,  1.931630976504320e-13, -5.227277933291062e-15,  1.273916074486208e-16, -2.835072895746546e-18,  5.824305121069410e-20, -1.113773239580405e-21,
  2.831544402344993e-06, -4.610284298313686e-07,  3.952279796388008e-08, -2.353290219135816e-09,  1.089671486506063e-10, -4.171612845560179e-12,  1.371828097668862e-13,
 -3.977207905207461e-15,  1.035839705899438e-16, -2.458014336863307e-18,  5.373218667612558e-20, -1.091222770226373e-21,  1.213543545993173e-06, -2.153796815160519e-07,
  2.005617399484073e-08, -1.292096724969439e-09,  6.450390938787179e-11, -2.653897071468645e-12,  9.352612255159097e-14, -2.898343907331143e-15,  8.049891207721342e-17,
 -2.032739016210870e-18,  4.719317592164703e-20, -1.016013399910207e-21,  5.111199218025446e-07, -9.842638602690523e-08,  9.918218852171919e-09, -6.890859246792076e-10,
  3.697985759057406e-11, -1.630804615319117e-12,  6.143940449482747e-14, -2.030586618832731e-15,  6.001632135055267e-17, -1.609515849694414e-18,  3.961133529184719e-20,
 -9.023958604162109e-22,  2.122583495430646e-07, -4.415490091880157e-08,  4.797243391451513e-09, -3.582883519642056e-10,  2.060993047738882e-11, -9.716575957237575e-13,
  3.903948010615127e-14, -1.372959411658268e-15,  4.309183476398288e-17, -1.224863145127259e-18,  3.189438598666942e-20, -7.674694057542595e-22,  8.722017714699550e-08,
 -1.951722067691061e-08,  2.278133072808423e-09, -1.823293788185118e-10,  1.121032663636155e-11, -5.635375926157509e-13,  2.408850624806905e-14, -8.994179030928427e-16,
  2.991331568759252e-17, -8.993921729146221e-19,  2.473122871947776e-20, -6.274287570114631e-22,  3.559670773051021e-08, -8.533376337215357e-09,  1.066408511626668e-09,
 -9.117849890134701e-11,  5.975110158206217e-12, -3.194384252221806e-13,  1.449160642286400e-14, -5.731616914720936e-16,  2.015635089271157e-17, -6.397373330761185e-19,
  1.854054579580532e-20, -4.949963175063985e-22,  1.448653692202432e-08, -3.705604468723712e-09,  4.941095402901986e-10, -4.499352022062106e-11,  3.133801781623200e-12,
 -1.777106265275243e-13,  8.535361486878258e-15, -3.567711432111330e-16,  1.323753438824204e-17, -4.425870548778906e-19,  1.349212404102183e-20, -3.783475779296388e-22,
  5.903181147503211e-09, -1.605010809116639e-09,  2.275840022740410e-10, -2.200381932540341e-11,  1.624276905358176e-12, -9.744432398565941e-14,  4.942725846146559e-15,
 -2.178322465449843e-16,  8.508507240229759e-18, -2.990351173003245e-19,  9.569274319924012e-21, -2.812992445910309e-22,  2.419092410092326e-09, -6.964474547240532e-10,
  1.046647643533197e-10, -1.071165919284569e-11,  8.356454438074049e-13, -5.289466636480977e-14,  2.826352736407406e-15, -1.310172269124725e-16,  5.375024967517301e-18,
 -1.981419374717952e-19,  6.641962192929863e-21, -2.042611688681685e-22,  1.001381719823824e-09, -3.041253899130078e-10,  4.827984549473438e-11, -5.214166434618667e-12,
  4.286486418811747e-13, -2.854981284328488e-14,  1.602881640006606e-15, -7.796181578280388e-17,  3.351456822479858e-18, -1.292935722819764e-19,  4.530203335431899e-21,
 -1.454444587731532e-22,  4.206307599227687e-10, -1.342658850132376e-10,  2.244039477606707e-11, -2.549542138064811e-12,  2.202206682687499e-13, -1.539096257115100e-14,
  9.055214583204987e-16, -4.609556876916479e-17,  2.071366364687948e-18, -8.343235473525207e-20,  3.048733769379536e-21, -1.019635590471360e-22,  1.801106353778253e-10,
 -6.020433966930966e-11,  1.055814246096585e-11, -1.257951570104321e-12,  1.138263354120969e-13, -8.323794784424870e-15,  5.118092359273062e-16, -2.719666820598708e-17,
  1.274295481250015e-18, -5.346038093681205e-20,  2.032578401916728e-21, -7.065407527250202e-23,  7.897142780872468e-11, -2.754287467997606e-11,  5.051211104266284e-12,
 -6.291098113571880e-13,  5.945158831660936e-14, -4.535711328692633e-15,  2.906494283234460e-16, -1.607880967169744e-17,  7.834959441989405e-19, -3.415019676720335e-20,
  1.347672594694765e-21, -4.857545645787889e-23,  3.560998279550550e-11, -1.291224909983127e-11,  2.467920183279166e-12, -3.202584939595181e-13,  3.150933997916692e-14,
 -2.500468311618665e-15,  1.665052407596680e-16, -9.562658431100071e-18,  4.833037683796639e-19, -2.182926780109320e-20,  8.918858555690206e-22, -3.325217315567853e-23,
  1.657986584543978e-11, -6.228073544772172e-12,  1.236301615747786e-12, -1.666050365169225e-13,  1.701130235667217e-14, -1.399840212844195e-15,  9.657665660330275e-17,
 -5.741647048539489e-18,  3.001398423659189e-19, -1.400970983877679e-20,  5.910671345408953e-22, -2.273617908458801e-23,  7.998348629415723e-12, -3.101546542903197e-12,
  6.371904710312515e-13, -8.886938626223494e-14,  9.386106419963893e-15, -7.983703819412326e-16,  5.689158956337775e-17, -3.490839316259779e-18,  1.881937450527175e-19,
 -9.052659270571859e-21,  3.933098377396569e-22, -1.556797839175198e-23,  4.008361253638454e-12, -1.598906954634873e-12,  3.387602334871993e-13, -4.872907568113206e-14,
  5.305685451694837e-15, -4.649620424224106e-16,  3.411391826511983e-17, -2.153728952041254e-18,  1.193857583967812e-19, -5.900963788726719e-21,  2.632695897594375e-22,
 -1.069342751074731e-23,  2.089535719755402e-12, -8.544127054524432e-13,  1.860168134598655e-13, -2.749938122467071e-14,  3.076066732193328e-15, -2.768012517049090e-16,
  2.084161561413948e-17, -1.349539754034045e-18,  7.668096074927422e-20, -3.882819415997780e-21,  1.773649955671310e-22, -7.371592638689400e-24,  1.132171454097916e-12,
 -4.729166049108299e-13,  1.054146374883999e-13, -1.595799004313829e-14,  1.827403802067443e-15, -1.682689696481592e-16,  1.295851638396409e-17, -8.577889524299163e-19,
  4.980065685379024e-20, -2.575321899069123e-21,  1.200816901852850e-22, -5.091714781008360e-24,  6.348670754143526e-13, -2.699676366660393e-13,  6.138430728058914e-14,
 -9.480780996382709e-15,  1.107426117745628e-15, -1.039792395962724e-16,  8.161822354942765e-18, -5.504537782789879e-19,  3.254630754890022e-20, -1.713339402177449e-21,
  8.129345943445588e-23, -3.506023521623081e-24,  3.644372608062418e-13, -1.572239438602512e-13,  3.633071006494909e-14, -5.703576393297025e-15,  6.770693655620680e-16,
 -6.458927497371242e-17,  5.149416134428652e-18, -3.526172881135402e-19,  2.116164279440934e-20, -1.130341520943681e-21,  5.439965553751279e-23, -2.378871195342419e-24,
  2.088063446645035e-13, -9.108029825075352e-14,  2.130859254927036e-14, -3.387425913221599e-15,  4.071423971659742e-16, -3.931646404636784e-17,  3.172256476140266e-18,
 -2.197858900122279e-19,  1.334195446000297e-20, -7.206790545261375e-22,  3.506550526865976e-23, -1.549832262990422e-24,  1.118377998451749e-13, -4.915617649307121e-14,
  1.159945288185465e-14, -1.860080197681315e-15,  2.255037755385209e-16, -2.196172414371229e-17,  1.786787554374388e-18, -1.248075961965893e-19,  7.636948595536214e-21,
 -4.157423220299052e-22,  2.038299066522979e-23, -9.075974646610257e-25,  4.362691020143281e-14, -1.925668882079275e-14,  4.565796609566003e-15, -7.357249852015385e-16,
  8.962403111154330e-17, -8.769812093107004e-18,  7.168202227890846e-19, -5.029787849411368e-20,  3.091411992850957e-21, -1.690233476341884e-22,  8.322107189780764e-24,
 -3.720955100967540e-25,  6.004083171300372e-02, -1.493281393481692e-04,  3.852054900742591e-07, -1.024128039045187e-09,  2.785469357525023e-12, -7.697494451320565e-15,
  2.148640689432027e-17, -6.032536451891338e-20,  1.698031432827517e-22, -4.782540378249757e-25,  1.345732447200157e-27, -3.780695595755696e-30,  5.713064290381920e-02,
 -1.801406221916576e-04,  6.718614480551968e-07, -2.604937950694466e-09,  1.000637512243472e-11, -3.766423506468601e-14,  1.389104772575940e-16, -5.031852508618932e-19,
  1.794550351105281e-21, -6.313872011133995e-24,  2.194994608849866e-26, -7.549466879490772e-29,  5.173103652319083e-02, -2.320595487700819e-04,  1.229268471923828e-06,
 -6.242675466282151e-09,  3.005841389269332e-11, -1.387315496977957e-13,  6.191547496198954e-16, -2.687810008330081e-18,  1.139639384105661e-20, -4.734141760695675e-23,
  1.931339271878537e-25, -7.752578706129150e-28,  4.458283965018794e-02, -2.891972458924489e-04,  2.008802089884081e-06, -1.259917828395392e-08,  7.330528998174062e-11,
 -4.034932523563688e-13,  2.125434692944839e-15, -1.079620417311594e-17,  5.317162045447305e-20, -2.549565355852056e-22,  1.194061918112562e-24, -5.476072474740654e-27,
  3.657899790493827e-02, -3.349789683610626e-04,  2.912140303940058e-06, -2.204406899575182e-08,  1.522841070768583e-10, -9.829976101052023e-13,  6.012709522245945e-15,
 -3.518186350138422e-17,  1.982710601754827e-19, -1.081718750059778e-21,  5.735965389462334e-24, -2.965477791137873e-26,  2.858220218889469e-02, -3.573133078044370e-04,
  3.794123755763256e-06, -3.418849457218189e-08,  2.767932100531053e-10, -2.069265434014989e-12,  1.452473694420821e-14, -9.681117120348471e-17,  6.176895120237590e-19,
 -3.795411033354767e-21,  2.256378659298455e-23, -1.302624006810488e-25,  2.127904851196635e-02, -3.515379369453513e-04,  4.492932585858445e-06, -4.767026672345625e-08,
  4.476079944810914e-10, -3.837998744188077e-12,  3.063619671009005e-14, -2.306239235374986e-16,  1.652399653413928e-18, -1.134613391860936e-20,  7.505857869318540e-23,
 -4.803695039668838e-25,  1.510206737397062e-02, -3.204397873326580e-04,  4.876395557827337e-06, -6.035252438509129e-08,  6.516079761025391e-10, -6.358125744915453e-12,
  5.729616563236702e-14, -4.837925210473919e-16,  3.867189633043426e-18, -2.948866538126656e-20,  2.157715362958296e-22, -1.522000899289958e-24,  1.022415828392312e-02,
 -2.719444188386555e-04,  4.882101741785789e-06, -6.990561464279097e-08,  8.615562584110866e-10, -9.503861571727467e-12,  9.609747326044047e-14, -9.049395283540468e-16,
  8.026385005023588e-18, -6.761625009136282e-20,  5.445163775493892e-22, -4.212969274083012e-24,  6.607719033380249e-03, -2.158303038024710e-04,  4.532359129736955e-06,
 -7.453569264058385e-08,  1.042001736656782e-09, -1.292071084722871e-11,  1.458259977689363e-13, -1.523996629523449e-15,  1.492903058644677e-17, -1.383285073937534e-19,
  1.220812993616092e-21, -1.031827471763077e-23,  4.080220335643776e-03, -1.608276343311362e-04,  3.919163267764512e-06, -7.353717438849697e-08,  1.159576037566746e-09,
 -1.608179098853577e-11,  2.016586943642741e-13, -2.328845170523199e-15,  2.509429314543456e-17, -2.547592098040923e-19,  2.454949719827910e-21, -2.258599788149458e-23,
  2.409635256882908e-03, -1.129139466625847e-04,  3.169095442867824e-06, -6.743881479603900e-08,  1.193376044728968e-09, -1.842743450566570e-11,  2.556755093046040e-13,
 -3.250298836451812e-15,  3.838662782461198e-17, -4.255254855889346e-19,  4.462680375832169e-21, -4.455217585267636e-23,  1.362504933682296e-03, -7.492832321097526e-05,
  2.405014364980812e-06, -5.772213071401429e-08,  1.140916423117988e-09, -1.953441710250421e-11,  2.987707845094236e-13, -4.166549656894658e-15,  5.375809126495806e-17,
 -6.487003936290052e-19,  7.382410743513879e-21, -7.974910795486399e-23,  7.385620712651654e-04, -4.713274077748191e-05,  1.718697663840174e-06, -4.628404910804890e-08,
  1.017426852401088e-09, -1.924210123415474e-11,  3.232997514991084e-13, -4.930225695826244e-15,  6.928731714603456e-17, -9.075905852531563e-19,  1.117810600706714e-20,
 -1.303285269403303e-22,  3.843305230324223e-04, -2.818226144491804e-05,  1.160286980100448e-06, -3.489035106656971e-08,  8.495242556386270e-10, -1.768408636478147e-11,
  3.253547723251377e-13, -5.409540809217759e-15,  8.257956229397457e-17, -1.171168821994195e-18,  1.557232052359645e-20, -1.954996924775382e-22,  1.922944441180131e-04,
 -1.606076429027184e-05,  7.422546593305074e-07, -2.481002634997520e-08,  6.665570067035737e-10, -1.522117773010147e-11,  3.057286400735490e-13, -5.526888913523595e-15,
  9.141160140140400e-17, -1.400260359153413e-18,  2.005407302381909e-20, -2.704990557546283e-22,  9.266602991467150e-05, -8.746668451238710e-06,  4.513100536522913e-07,
 -1.669631989036684e-08,  4.931730299292049e-10, -1.231508283901160e-11,  2.692774095817850e-13, -5.278992530162006e-15,  9.436821768914059e-17, -1.557772130391817e-18,
  2.397841911245656e-20, -3.467847118928888e-22,  4.309156430007109e-05, -4.564186043232941e-06,  2.616011614197614e-07, -1.066822832435468e-08,  3.452580630201118e-10,
 -9.399307320636850e-12,  2.231268645696047e-13, -4.731814714700635e-15,  9.121211214003118e-17, -1.619047867485553e-18,  2.673058854504341e-20, -4.136901054490288e-22,
  1.937719394768036e-05, -2.288302304138188e-06,  1.449996787394129e-07, -6.493057823102240e-09,  2.294792964793864e-10, -6.791256726296123e-12,  1.745682506347495e-13,
 -3.995092555129966e-15,  8.285860267259416e-17, -1.578229109403640e-18,  2.789311321058694e-20, -4.610808380029623e-22,  8.445276331348585e-06, -1.105401838042669e-06,
  7.709113614181804e-08, -3.776730961506308e-09,  1.453044481867196e-10, -4.661498816656192e-12,  1.294206435787726e-13, -3.188935526807114e-15,  7.100836557816234e-17,
 -1.448414039490260e-18,  2.735089351201490e-20, -4.820344445812874e-22,  3.576450852358780e-06, -5.160196565547642e-07,  3.944026296599426e-08, -2.106434529638744e-09,
  8.795352493199858e-11, -3.050438439236164e-12,  9.125090531873266e-14, -2.415355117122546e-15,  5.762198825741486e-17, -1.256230294792489e-18,  2.529844896429356e-20,
 -4.745250448173924e-22,  1.475692459717106e-06, -2.335073989838034e-07,  1.948110149420447e-08, -1.130429777243273e-09,  5.107463489269526e-11, -1.909979228606852e-12,
  6.141265115391624e-14, -1.742382425110434e-15,  4.444277082543415e-17, -1.033574220056269e-18,  2.215743737277205e-20, -4.415583832159506e-22,  5.950286249906903e-07,
 -1.027658167480187e-07,  9.322425108040325e-09, -5.858082651331179e-10,  2.855751227948998e-11, -1.148505447618979e-12,  3.959958578563660e-14, -1.201630810256126e-15,
  3.270364299970567e-17, -8.097784707518929e-19,  1.844640879013371e-20, -3.898833624297711e-22,  2.352225659228040e-07, -4.413875395911906e-08,  4.337717096196915e-09,
 -2.942385077193523e-10,  1.543263572557225e-11, -6.657843160014324e-13,  2.455863424115359e-14, -7.953148039418352e-16,  2.304903525279585e-17, -6.064916772848674e-19,
  1.465392468619978e-20, -3.279309756278090e-22,  9.148094373487180e-08, -1.857015650354764e-08,  1.969994324617547e-09, -1.438011377903651e-10,  8.092262497570816e-12,
 -3.735475479097364e-13,  1.470682596926690e-14, -5.071878780451303e-16,  1.562035114307535e-17, -4.359474341624349e-19,  1.115213946576192e-20, -2.637779923635744e-22,
  3.513312414658468e-08, -7.683014908243990e-09,  8.767573872928088e-10, -6.866054495389565e-11,  4.134140862054363e-12, -2.036805284657899e-13,  8.539122071325101e-15,
 -3.129206035443777e-16,  1.022061278257135e-17, -3.019618823718513e-19,  8.163434673278550e-21, -2.037234770525718e-22,  1.337746961890257e-08, -3.138797199910210e-09,
  3.840006587136240e-10, -3.216457255575823e-11,  2.066497483575699e-12, -1.083905453730236e-13,  4.827554808002897e-15, -1.875707154731381e-16,  6.483789323252089e-18,
 -2.023870266727164e-19,  5.771478790390729e-21, -1.516922848075375e-22,  5.071649287527823e-09, -1.271754890891494e-09,  1.662412092261096e-10, -1.484904596258175e-11,
  1.015178036461647e-12, -5.654408321957530e-14,  2.669095960830264e-15, -1.097107746045433e-16,  4.005132241171416e-18, -1.318186712184193e-19,  3.957600659885589e-21,
 -1.093494453603184e-22,  1.923067613979703e-09, -5.133814526053151e-10,  7.146638400274958e-11, -6.786923327855391e-12,  4.923830297108229e-13, -2.904818398886879e-14,
  1.449734567916323e-15, -6.289708388725511e-17,  2.419701104479518e-18, -8.379763378663401e-20,  2.643501143691051e-21, -7.663851190875866e-23,  7.327536614009257e-10,
 -2.074670090810117e-10,  3.065511598980927e-11, -3.085864077197473e-12,  2.369078885698473e-13, -1.476486895629041e-14,  7.771765458993078e-16, -3.550605367178449e-17,
  1.436248073786321e-18, -5.222569289667909e-20,  1.727575783394642e-21, -5.244841711905939e-23,  2.819482779891890e-10, -8.434912546151167e-11,  1.318534486467174e-11,
 -1.402642703542201e-12,  1.136288959105290e-13, -7.461247285976189e-15,  4.131633993026098e-16, -1.982888139657597e-17,  8.414354550645868e-19, -3.205541679225287e-20,
  1.109526459903797e-21, -3.520229754021203e-23,  1.101084142440283e-10, -3.467700772101632e-11,  5.715660750277210e-12, -6.405666013024510e-13,  5.459917856356536e-14,
 -3.766948943043064e-15,  2.188703465099789e-16, -1.100713676813189e-17,  4.888269287625574e-19, -1.946546220869092e-20,  7.034348643016733e-22, -2.327378530750728e-23,
  4.386685526500127e-11, -1.449000515651468e-11,  2.509866811360610e-12, -2.954114454354804e-13,  2.641434426872306e-14, -1.909404834787148e-15,  1.160942268453835e-16,
 -6.102202733575406e-18,  2.829090936768637e-19, -1.174752714004609e-20,  4.422069518716758e-22, -1.522326210657859e-23,  1.792001914355459e-11, -6.185723240895845e-12,
  1.122160215062944e-12, -1.382667903032902e-13,  1.292994342759243e-14, -9.764360482157206e-16,  6.195245705132556e-17, -3.394351544228709e-18,  1.638599902295330e-19,
 -7.077463363351453e-21,  2.768391837010189e-22, -9.893093120091117e-24,  7.543831710166475e-12, -2.711309537931301e-12,  5.133673052740809e-13, -6.600124177876510e-14,
  6.434778458976602e-15, -5.061291873955204e-16,  3.341331446274446e-17, -1.902947110820837e-18,  9.539525522854857e-20, -4.274674223130734e-21,  1.733107806959653e-22,
 -6.413382582753586e-24,  3.288045710076918e-12, -1.225970545917709e-12,  2.414297587979787e-13, -3.227853201838215e-14,  3.270336375739128e-15, -2.670832734685599e-16,
  1.829117163487022e-17, -1.079678634273965e-18,  5.604747086610603e-20, -2.598478140793483e-21,  1.089092468422816e-22, -4.162624318861594e-24,  1.490033836921645e-12,
 -5.742720482331794e-13,  1.172031803394087e-13, -1.623906520638196e-14,  1.704068192146893e-15, -1.440342892627035e-16,  1.020095195120721e-17, -6.221930401559197e-19,
  3.334828324041830e-20, -1.595093069800619e-21,  6.892117986703134e-23, -2.713487919922805e-24,  7.044149271353467e-13, -2.796133418154092e-13,  5.892656196609036e-14,
 -8.431234088583493e-15,  9.132068915065343e-16, -7.962003056775004e-17,  5.812591480511612e-18, -3.651904868114388e-19,  2.014778681179716e-20, -9.912863805436725e-22,
  4.402827709128457e-23, -1.780570537015871e-24,  3.481197629262504e-13, -1.418072773245630e-13,  3.074502832865634e-14, -4.526194789937627e-15,  5.042233207095724e-16,
 -4.519096379181844e-17,  3.389332882956484e-18, -2.186308912655788e-19,  1.237655523175995e-20, -6.244366596145436e-22,  2.842363188989946e-23, -1.177301188643160e-24,
  1.798354611010314e-13, -7.490707666241290e-14,  1.664508641221434e-14, -2.511908663953759e-15,  2.867615477460909e-16, -2.632568532463521e-17,  2.021396759072368e-18,
 -1.334226406044312e-19,  7.724475881174692e-21, -3.983656508868846e-22,  1.852569009039932e-23, -7.835052545984384e-25,  9.675986743835808e-14, -4.106409210481990e-14,
  9.316433800924302e-15, -1.435726473243768e-15,  1.673365295509701e-16, -1.567799231250842e-17,  1.228062287387199e-18, -8.265438163920681e-20,  4.877315536055138e-21,
 -2.562587310177337e-22,  1.213580507676421e-23, -5.224308151912786e-25,  5.366860340705416e-14, -2.312346967815226e-14,  5.335543160239031e-15, -8.364053297680956e-16,
  9.914601955434396e-17, -9.444680278779713e-18,  7.519401808596952e-19, -5.142112852673756e-20,  3.081870574521833e-21, -1.644053217196328e-22,  7.902370897820520e-24,
 -3.451455988065820e-25,  2.993614368505938e-14, -1.304802643532877e-14,  3.050017975353823e-15, -4.844405104943225e-16,  5.817601558053206e-17, -5.613138379285892e-18,
  4.525232486900770e-19, -3.132721097695152e-20,  1.900197697705882e-21, -1.025620446993994e-22,  4.986527354531077e-24, -2.202342164498642e-25,  1.573450935023764e-14,
 -6.913096797740237e-15,  1.630571942786678e-15, -2.613600399330729e-16,  3.167144389772298e-17, -3.083116271534251e-18,  2.507317118298935e-19, -1.750628150366192e-20,
  1.070762198168365e-21, -5.826683117307730e-23,  2.855569586803004e-24, -1.271012762645112e-25,  6.073275352220429e-15, -2.680220416219494e-15,  6.353526254769198e-16,
 -1.023578590563274e-16,  1.246630378714339e-17, -1.219584479160822e-18,  9.966469232705837e-20, -6.991839787976255e-21,  4.296459295118220e-22, -2.348625866297307e-23,
  1.156152402973506e-24, -5.168355846406157e-26,  5.944960566414160e-02, -1.462949074467498e-04,  3.731783675332558e-07, -9.807646736133170e-10,  2.636542495326482e-12,
 -7.201491545273032e-15,  1.987085241273553e-17, -5.515706584820683e-20,  1.535161582879188e-22, -4.276073891757691e-25,  1.190047489673579e-27, -3.307184894090221e-30,
  5.642063599136013e-02, -1.748881019909214e-04,  6.415385202077640e-07, -2.450685763292315e-09,  9.285320378407131e-12, -3.449316888396181e-14,  1.255922496488806e-16,
 -4.492332627155858e-19,  1.582286298815089e-21, -5.498832107580373e-24,  1.888448621143824e-26, -6.417021391526700e-29,  5.082200345119498e-02, -2.225170792790645e-04,
  1.157152958375474e-06, -5.783155380361554e-09,  2.742649056778192e-11, -1.247352535735018e-13,  5.487556980802072e-16, -2.348967285321573e-18,  9.823317063643418e-21,
 -4.025709323018342e-23,  1.620524090810523e-25, -6.419692906071310e-28,  4.345726132521435e-02, -2.737122464917822e-04,  1.864391657870033e-06, -1.148818042398008e-08,
  6.572200231621777e-11, -3.559262383485248e-13,  1.845645127696357e-15, -9.232800384360200e-18,  4.479786796386504e-20, -2.116841608083496e-22,  9.772505526664778e-25,
 -4.418795210928030e-27,  3.528405749648398e-02, -3.126999847929085e-04,  2.661606484457742e-06, -1.975728480529494e-08,  1.339909708609503e-10, -8.498311996096269e-13,
  5.110890041797944e-15, -2.941840886503314e-17,  1.631629262551382e-19, -8.763898433258972e-22,  4.576650931975790e-24, -2.330855381842313e-26,  2.721115890358319e-02,
 -3.285291043924622e-04,  3.409127181438278e-06, -3.007282843956841e-08,  2.386852999586338e-10, -1.751087024959143e-12,  1.207138818184383e-14, -7.906769213573658e-17,
  4.960083127328080e-19, -2.997847143102618e-21,  1.753703252753916e-23, -9.965497360811296e-26,  1.994132524956774e-02, -3.177664843747456e-04,  3.961450330407557e-06,
 -4.108476168943240e-08,  3.777070025004239e-10, -3.174602264359307e-12,  2.486150022230613e-14, -1.837420061266263e-16,  1.293247635022914e-18, -8.727497971370352e-21,
  5.676772867356501e-23, -3.573537019225674e-25,  1.389398182224221e-02, -2.841575074951416e-04,  4.210753281863447e-06, -5.087374880970591e-08,  5.371676139529420e-10,
 -5.132512743977858e-12,  4.533404173184977e-14, -3.754848724225379e-16,  2.946061334734931e-18, -2.206231619942979e-20,  1.586152083646761e-22, -1.099768621814060e-24,
  9.209494177402603e-03, -2.360224035828034e-04,  4.120054791664504e-06, -5.752414151138303e-08,  6.926309901408953e-10, -7.474665894072144e-12,  7.401704148260920e-14,
 -6.831761375699964e-16,  5.943330706512119e-18, -4.913784128106337e-20,  3.885574061267057e-22, -2.953317452516698e-24,  5.811626560063264e-03, -1.828841918622755e-04,
  3.730013858187092e-06, -5.975441449918072e-08,  8.153899625936319e-10, -9.883251547624194e-12,  1.091560421782048e-13, -1.117342023896539e-15,  1.072872471961344e-17,
 -9.750347521816782e-20,  8.444829077684378e-22, -7.008034104729194e-24,  3.494442660004988e-03, -1.327115475451072e-04,  3.138217426917193e-06, -5.731472171662115e-08,
  8.814918061895204e-10, -1.194157525991523e-11,  1.464391536831719e-13, -1.655404289137688e-15,  1.747451261897918e-17, -1.739085251405536e-19,  1.643807878995701e-21,
 -1.484203299615570e-23,  2.003983527849707e-03, -9.049963563757819e-05,  2.463232724511722e-06, -5.098840219312963e-08,  8.794793011696723e-10, -1.325752829855417e-11,
  1.797864726308201e-13, -2.236079835200187e-15,  2.585821591785967e-17, -2.808710804930501e-19,  2.888083545446612e-21, -2.828498464490507e-23,  1.097286917895563e-03,
 -5.817588605245330e-05,  1.810145539066517e-06, -4.223980345183938e-08,  8.134033063571904e-10, -1.358918842970535e-11,  2.030499938918083e-13, -2.769175809914963e-15,
  3.497010900320541e-17, -4.133292120464630e-19,  4.610303015155375e-21, -4.884133568599546e-23,  5.743680002342939e-04, -3.535477868985807e-05,  1.249509703057468e-06,
 -3.270515938744753e-08,  7.001721486468042e-10, -1.291628169114020e-11,  2.119380883843024e-13, -3.159610277286827e-15,  4.344720641415465e-17, -5.572726621487936e-19,
  6.725193700573541e-21, -7.687669598444580e-23,  2.878083651788816e-04, -2.036799073356809e-05,  8.127311075270568e-07, -2.374974049995051e-08,  5.630511741591798e-10,
 -1.142961249584782e-11,  2.053134352560682e-13, -3.336409898372786e-15,  4.982343836715752e-17, -6.917623923716166e-19,  9.010786172726086e-21, -1.108904205083539e-22,
  1.382703248816348e-04, -1.115308981972639e-05,  4.996385864030012e-07, -1.622904804542778e-08,  4.245024332391896e-10, -9.451750682154817e-12,  1.853319698900653e-13,
 -3.274099900748168e-15,  5.296569160540554e-17, -7.941852499875333e-19,  1.114127975784460e-20, -1.472954749995836e-22,  6.379869237087796e-05, -5.820132614384252e-06,
  2.911844332136517e-07, -1.046954774947375e-08,  3.010907815371178e-10, -7.330801833461245e-12,  1.564766743319626e-13, -2.997635266978061e-15,  5.241017597854198e-17,
 -8.468262283228019e-19,  1.276771646552897e-20, -1.809796703564567e-22,  2.832553087761443e-05, -2.902139871463292e-06,  1.613559699712206e-07, -6.396767726365920e-09,
  2.015909229273573e-10, -5.351603307094534e-12,  1.240244239239343e-13, -2.570309816529585e-15,  4.846105464817579e-17, -8.420142867937180e-19,  1.361725164087229e-20,
 -2.065634342004980e-22,  1.212667389551695e-05, -1.386566104530671e-06,  8.527587189626303e-08, -3.713599834587278e-09,  1.278405271169534e-10, -3.690033890350920e-12,
  9.261700825848705e-14, -2.071679030271723e-15,  4.203172351691057e-17, -7.837663494912399e-19,  1.357032381307113e-20, -2.198987363678609e-22,  5.017768331484040e-06,
 -6.365559491087078e-07,  4.311663402957537e-08, -2.055224523145043e-09,  7.704998510182182e-11, -2.411665674054730e-12,  6.539796556652486e-14, -1.575388646073431e-15,
  3.432400269108312e-17, -6.855745154552917e-19,  1.268535757420337e-20, -2.192058740306436e-22,  2.011839284132862e-06, -2.816472442596422e-07,  2.092389398192723e-08,
 -1.087976454707262e-09,  4.428897736917961e-11, -1.499314424488503e-12,  4.382339610496052e-14, -1.134450344140880e-15,  2.649005108150804e-17, -5.656829979459173e-19,
  1.116598523069493e-20, -2.054146934310269e-22,  7.838002474864622e-07, -1.204817699604368e-07,  9.778714637097973e-09, -5.528333577147321e-10,  2.436659114861890e-11,
 -8.899030556285658e-13,  2.797204170940560e-14, -7.765020886133458e-16,  1.939433700870390e-17, -4.419771310463777e-19,  9.290617084424800e-21, -1.816538908286520e-22,
  2.976296097106013e-07, -4.999702462827319e-08,  4.416703845149125e-09, -2.706238857291003e-10,  1.287904314235818e-11, -5.061769213034488e-13,  1.707142515809230e-14,
 -5.071335954233638e-16,  1.352219925625362e-17, -3.282583467937232e-19,  7.335561893143350e-21, -1.521900175218687e-22,  1.105233769039508e-07, -2.019900954491073e-08,
  1.935134930425620e-09, -1.281128482461905e-10,  6.565132246666091e-12, -2.769924938632681e-13,  1.000112023430075e-14, -3.172753821260156e-16,  9.013948860446927e-18,
 -2.326687827182315e-19,  5.517997426969600e-21, -1.212757732799268e-22,  4.028215420962199e-08, -7.975165323221784e-09,  8.257196407484238e-10, -5.888648987238187e-11,
  3.240655709658977e-12, -1.464221117981204e-13,  5.647171688102992e-15, -1.909213958024453e-16,  5.768271688622018e-18, -1.580266461438518e-19,  3.970520409670092e-21,
 -9.229141302158281e-23,  1.446617174509269e-08, -3.089903589817292e-09,  3.445675880284049e-10, -2.639177572938836e-11,  1.555589822690762e-12, -7.508681781905115e-14,
  3.086450409114770e-15, -1.109719954388912e-16,  3.558501809470524e-18, -1.032786716091298e-19,  2.744345509165576e-21, -6.735102889288263e-23,  5.140551160990831e-09,
 -1.179868749034745e-09,  1.412388621230074e-10, -1.158463548686010e-11,  7.293964755745992e-13, -3.752048370396266e-14,  1.640038356744355e-15, -6.257792575855260e-17,
  2.125562414825692e-18, -6.523159155078141e-20,  1.829861361573089e-21, -4.733351296294480e-23,  1.815701798973776e-09, -4.460792702635818e-10,  5.713440622126832e-11,
 -5.003662643122043e-12,  3.356336275577107e-13, -1.835427042903173e-14,  8.511702708087303e-16, -3.439231558569799e-17,  1.234893359983044e-18, -3.999585833512470e-20,
  1.182242421575512e-21, -3.217610855932402e-23,  6.405448134925210e-10, -1.678042305245366e-10,  2.292125078971001e-11, -2.137058790582570e-12,  1.523071772373870e-13,
 -8.832278124609559e-15,  4.335394873496416e-16, -1.850940964450049e-17,  7.010789989468758e-19, -2.391598064403465e-20,  7.435034604112695e-22, -2.125152887205632e-23,
  2.268488850383825e-10, -6.313071602995308e-11,  9.166682704876860e-12, -9.071810147543390e-13,  6.850729214195349e-14, -4.202043395931485e-15,  2.177955879153038e-16,
 -9.802654608046575e-18,  3.908269051360381e-19, -1.401340032391748e-20,  4.572786817984184e-22, -1.370059150277261e-23,  8.108230587381039e-11, -2.388144437240281e-11,
  3.674077518848004e-12, -3.847975019517613e-13,  3.070451073968706e-14, -1.986820621001175e-15,  1.084683873180822e-16, -5.134584975107168e-18,  2.149987858047026e-19,
 -8.085329129577066e-21,  2.763625651317796e-22, -8.662072371152884e-24,  2.941217616030070e-11, -9.134415725111738e-12,  1.484060108687375e-12, -1.639880599532748e-13,
  1.378690421244680e-14, -9.386035507066451e-16,  5.383537967700698e-17, -2.673707751298203e-18,  1.173049465689585e-19, -4.616394267486985e-21,  1.649252032205365e-22,
 -5.396399446927495e-24,  1.088956981765257e-11, -3.552846431261782e-12,  6.075430305619355e-13, -7.060883008453572e-14,  6.236186923361353e-15, -4.454295261318094e-16,
  2.676992518272468e-17, -1.391324006361147e-18,  6.380247640635855e-20, -2.621343033347890e-21,  9.766107529342729e-23, -3.328556044935509e-24,  4.138764221920144e-12,
 -1.413326186501675e-12,  2.535095767354744e-13, -3.088916645887533e-14,  2.857268124404412e-15, -2.134985861614917e-16,  1.340722228552500e-17, -7.272700957224341e-19,
  3.476928751979845e-20, -1.487664473163538e-21,  5.766006042149037e-23, -2.042293185749215e-24,  1.623944064512870e-12, -5.782842872820727e-13,  1.084266720710782e-13,
 -1.380529718285189e-14,  1.333238579844525e-15, -1.039023749658431e-16,  6.798065939743296e-18, -3.837997925463349e-19,  1.907763043730209e-20, -8.478598799197668e-22,
  3.410122361833690e-23, -1.252154232714196e-24,  6.614142402337972e-13, -2.446991699640472e-13,  4.778898111626236e-14, -6.336634404221157e-15,  6.368254146092272e-16,
 -5.159970786364678e-17,  3.506772788426762e-18, -2.054559099848945e-19,  1.058835703403065e-20, -4.874473386943120e-22,  2.029056494445545e-23, -7.703805031934836e-25,
  2.810197676806866e-13, -1.076146603003271e-13,  2.181166829945044e-14, -3.001353295630712e-15,  3.128295686202704e-16, -2.626776993668899e-17,  1.848459910797518e-18,
 -1.120423518708405e-19,  5.968877396000225e-21, -2.838178460153678e-22,  1.219301202549184e-23, -4.773799765442672e-25,  1.250756662316502e-13, -4.939319289300489e-14,
  1.035120451791991e-14, -1.472799756750363e-15,  1.586492987810725e-16, -1.375826699430477e-17,  9.991791561590403e-19, -6.245763204858038e-20,  3.428825959837595e-21,
 -1.678910018766706e-22,  7.422097531936564e-24, -2.987998501815765e-25,  5.848283685056616e-14, -2.372816636196700e-14,  5.122015698322305e-15, -7.507519023293103e-16,
  8.327506096037471e-17, -7.432154379949746e-18,  5.551292780943925e-19, -3.566602259419830e-20,  2.011186046065002e-21, -1.010869966628072e-22,  4.584425007728268e-24,
 -1.892073215173082e-25,  2.874946987541156e-14, -1.193953119540158e-14,  2.644399401088838e-15, -3.977549862721424e-16,  4.526113207131747e-17, -4.141974537839465e-18,
  3.170560231634818e-19, -2.086435289642286e-20,  1.204396391235995e-21, -6.193567115584223e-23,  2.872265697895994e-24, -1.211485805077292e-25,  1.481611564301943e-14,
 -6.274699968816892e-15,  1.420272562057462e-15, -2.183627709185028e-16,  2.539199460796460e-17, -2.373648904065426e-18,  1.855194725952750e-19, -1.245953537095412e-20,
  7.336813110638788e-22, -3.846974838180534e-23,  1.818219325144742e-24, -7.812105940554984e-26,  7.928229836736308e-15, -3.411265205480208e-15,  7.859199041310086e-16,
 -1.230121413855514e-16,  1.455950143523693e-17, -1.384878065586189e-18,  1.100969487264081e-19, -7.518245523605220e-21,  4.499740372440470e-22, -2.397188368954239e-23,
  1.150725428234404e-24, -5.019502305463625e-26,  4.299954111677910e-15, -1.872680587688334e-15,  4.373502135199214e-16, -6.940187205718174e-17,  8.326890209454576e-18,
 -8.027122438436290e-19,  6.465743733528102e-20, -4.472304061257816e-21,  2.710497396986350e-22, -1.461793537395890e-23,  7.101582436578264e-25, -3.134068373182057e-26,
  2.215853581884917e-15, -9.731558556209378e-16,  2.294291856209118e-16, -3.675732656526658e-17,  4.452154635084994e-18, -4.332045767892136e-19,  3.521411970821613e-20,
 -2.457592191507340e-21,  1.502523417332363e-22, -8.172706122022984e-24,  4.003661955867499e-25, -1.781308296237896e-26,  8.458442275536435e-16, -3.732119319662084e-16,
  8.845167570977339e-17, -1.424677849846221e-17,  1.734752746599679e-18, -1.696746835146433e-19,  1.386286353131109e-20, -9.723236552910227e-22,  5.973642301128409e-23,
 -3.264772035381547e-24,  1.606815452176602e-25, -7.181527744235478e-27,  5.887032334832940e-02, -1.433558508517467e-04,  3.616576290684132e-07, -9.397068360309015e-10,
  2.497159382499292e-12, -6.742582649440845e-15,  1.839297948565644e-17, -5.048194053816880e-20,  1.389452027082647e-22, -3.827908423938431e-25,  1.053765352619287e-27,
 -2.897132606729277e-30,  5.573116544535539e-02, -1.698709525251760e-04,  6.129994353721146e-07, -2.307479948021527e-09,  8.624609091728732e-12, -3.162435355574101e-14,
  1.136938311644644e-16, -4.016269857047030e-19,  1.397271535116104e-21, -4.797000464981459e-24,  1.627640148251156e-26, -5.464976680367714e-29,  4.995002034913073e-02,
 -2.135301721218951e-04,  1.090307969982865e-06, -5.363595334242328e-09,  2.505833746026588e-11, -1.123201444270927e-13,  4.871761982125526e-16, -2.056611382876747e-18,
  8.484241658858604e-21, -3.430623847596022e-23,  1.362842537761435e-25, -5.328904127387100e-28,  4.239139404721201e-02, -2.593311953009677e-04,  1.732615456352844e-06,
 -1.049125493330134e-08,  5.902630064355172e-11, -3.145777679749942e-13,  1.606102191070207e-15, -7.914018660974237e-18,  3.783641150004655e-20, -1.762208013784468e-22,
  8.020490600939867e-25, -3.576201273743897e-27,  3.407439150978747e-02, -2.923202868363702e-04,  2.436842159335141e-06, -1.774300747269004e-08,  1.181571694541031e-10,
 -7.364923638033552e-13,  4.355769307115682e-15, -2.466857607997927e-17,  1.346751040424785e-19, -7.122954549362558e-22,  3.663891025706863e-24, -1.838488155965449e-26,
  2.594939125635198e-02, -3.026372232982392e-04,  3.070060319342476e-06, -2.651901816133554e-08,  2.063902303048370e-10, -1.486241971193988e-12,  1.006439793820454e-14,
 -6.479493222356138e-17,  3.997228147816035e-19, -2.376790746036282e-21,  1.368382973307487e-23, -7.655267197695707e-26,  1.873065900817815e-02, -2.879488371118509e-04,
  3.502698255078197e-06, -3.551863527571468e-08,  3.197879813748883e-10, -2.635262561599303e-12,  2.025182080252268e-14, -1.469758768069140e-16,  1.016405196629164e-18,
 -6.742666354311788e-21,  4.313016040384808e-23, -2.671006749516562e-25,  1.282105388972607e-02, -2.527747459413671e-04,  3.648631094254242e-06, -4.304454537866406e-08,
  4.445980233756593e-10, -4.160698037116416e-12,  3.602911065946631e-14, -2.927830527605737e-16,  2.255246278642091e-18, -1.658956106908621e-20,  1.172092552206352e-22,
 -7.989686593203841e-25,  8.327205348379744e-03, -2.056454936214206e-04,  3.491620153420951e-06, -4.754761110512414e-08,  5.594568228413185e-10, -5.907846244833776e-12,
  5.730478703639012e-14, -5.185302563290039e-16,  4.425401680885175e-18, -3.591491118819297e-20,  2.789142059993595e-22, -2.082943800086923e-24,  5.135523086287818e-03,
 -1.557046547081994e-04,  3.085148979365263e-06, -4.815713435536469e-08,  6.415757884429702e-10, -7.603162764677255e-12,  8.219245148389693e-14, -8.242243468759095e-16,
  7.758961408735555e-18, -6.917444230276555e-20,  5.880640255595272e-22, -4.792356818687855e-24,  3.009768064350362e-03, -1.101341334310942e-04,  2.527760622152828e-06,
 -4.494524069831925e-08,  6.743548124078125e-10, -8.925424498427679e-12,  1.070588001854648e-13, -1.184877299792403e-15,  1.225514083803801e-17, -1.195828447880866e-19,
  1.108887039113639e-21, -9.827501121413728e-24,  1.677834539780020e-03, -7.302072631566992e-05,  1.927756998995631e-06, -3.882321386638674e-08,  6.528523715553210e-10,
 -9.609074620616102e-12,  1.273865324038425e-13, -1.550329790120716e-15,  1.755743042268371e-17, -1.868961271772847e-19,  1.884519876323393e-21, -1.810849660062292e-23,
  8.906226090727214e-04, -4.552004415132987e-05,  1.373176518129027e-06, -3.115909540688283e-08,  5.846705431258729e-10, -9.532553108448741e-12,  1.391740526177789e-13,
 -1.856438112409713e-15,  2.294928660331180e-17, -2.657220965665336e-19,  2.905350109621579e-21, -3.018857508360903e-23,  4.507005229638877e-04, -2.675607772883987e-05,
  9.165589300160767e-07, -2.332011619178063e-08,  4.862852069151452e-10, -8.751124104336150e-12,  1.402524339833014e-13, -2.044340256365097e-15,  2.750910223542670e-17,
 -3.455441464615773e-19,  4.086476659452932e-21, -4.580417916605918e-23,  2.177304397767715e-04, -1.486875857524048e-05,  5.750312528325574e-07, -1.633072432208586e-08,
  3.770089762893273e-10, -7.463703527957238e-12,  1.309166651060958e-13, -2.079500419431277e-15,  3.038070327650712e-17, -4.129890871246599e-19,  5.270550198457117e-21,
 -6.358636545734638e-23,  1.005646475200049e-04, -7.832449143344132e-06,  3.401093773906991e-07, -1.073565047058220e-08,  2.734094183819337e-10, -5.935987074399814e-12,
  1.136344680104411e-13, -1.961907189600812e-15,  3.104511027384351e-17, -4.556899784477146e-19,  6.262255717196471e-21, -8.115284557867060e-23,  4.448386744600992e-05,
 -3.921244884195064e-06,  1.902067140373260e-07, -6.646434819438962e-09,  1.861021100354721e-10, -4.418047708986682e-12,  9.206129439477366e-14, -1.723452955312249e-15,
  2.947233282673386e-17, -4.661333097258620e-19,  6.884107886323684e-21, -9.564386545718096e-23,  1.888038823168698e-05, -1.870697754575066e-06,  1.008793228840717e-07,
 -3.887483310601012e-09,  1.192944339717216e-10, -3.088054480422992e-12,  6.986693258913119e-14, -1.414984450133789e-15,  2.609413815896927e-17, -4.438041889175354e-19,
  7.030489114269611e-21, -1.045321528777216e-22,  7.705166774612356e-06, -8.527513653857367e-07,  5.089318943927959e-08, -2.155072718833330e-09,  7.225648924039330e-11,
 -2.034069967584112e-12,  4.984826211290842e-14, -1.089769403689078e-15,  2.162812726298751e-17, -3.948142699807632e-19,  6.696716345419366e-21, -1.063742059813933e-22,
  3.030584688711439e-06, -3.724940472110722e-07,  2.449910198101984e-08, -1.136038084677750e-09,  4.149526924559499e-11, -1.267050258081034e-12,  3.355601794353362e-14,
 -7.902066976180186e-16,  1.684483071818394e-17, -3.294343911052216e-19,  5.972556131656263e-21, -1.011877480684391e-22,  1.151758495380018e-06, -1.563874193101480e-07,
  1.128964927246396e-08, -5.713879052658997e-10,  2.267252638062018e-11, -7.490633897805549e-13,  2.139006778393979e-14, -5.414711022513045e-16,  1.237414630123873e-17,
 -2.588039950778623e-19,  5.006716097011002e-21, -9.032694924890647e-23,  4.241498544516681e-07, -6.330817573200299e-08,  4.997198574148871e-09, -2.751732905558352e-10,
  1.182899447118033e-11, -4.218273969350817e-13,  1.295961502473837e-14, -3.519442458458765e-16,  8.606303718241738e-18, -1.921612786974293e-19,  3.960234722950841e-21,
 -7.596237703219903e-23,  1.518292390280301e-07, -2.479582816430237e-08,  2.132294979954925e-09, -1.273568315410544e-10,  5.915283568784430e-12, -2.271414389195378e-13,
  7.491682523556742e-15, -2.178298617422744e-16,  5.689334969079982e-18, -1.353793517576914e-19,  2.967359378195237e-21, -6.042046798789838e-23,  5.300976552741609e-08,
 -9.430847637500024e-09,  8.804322248136477e-10, -5.686810272701049e-11,  2.846395109537583e-12, -1.174165243953748e-13,  4.148665741781590e-15, -1.288978621230934e-16,
  3.589159082432962e-18, -9.086054922991910e-20,  2.114687675950208e-21, -4.563728512957755e-23,  1.811945384494961e-08, -3.496924526862427e-09,  3.532090576374604e-10,
 -2.459987019353708e-11,  1.323453639292698e-12, -5.851167194234223e-14,  2.209991839945816e-15, -7.322662998912964e-17,  2.169788752507872e-18, -5.833610113936074e-20,
  1.439284505460987e-21, -3.286981894532452e-23,  6.088243098527002e-09, -1.269468867409722e-09,  1.382705458680500e-10, -1.035400639758945e-11,  5.971974032728367e-13,
 -2.823178735991465e-14,  1.137428016218095e-15, -4.011233911015433e-17,  1.262458262599213e-18, -3.598398860811222e-20,  9.395736267041099e-22, -2.267066362062261e-23,
  2.019829853914169e-09, -4.532406180211939e-10,  5.306243839990973e-11, -4.259946546345214e-12,  2.627433589994230e-13, -1.325011286527534e-14,  5.681987587570752e-16,
 -2.128389247702317e-17,  7.101572446165818e-19, -2.142089109015838e-20,  5.909189152158642e-22, -1.503945167464947e-23,  6.647888311690704e-10, -1.599247912426301e-10,
  2.005997383017913e-11, -1.721664018249252e-12,  1.132587608585820e-13, -6.078475073205464e-15,  2.768287116570367e-16, -1.099157154824177e-17,  3.880430191038783e-19,
 -1.236372547294744e-20,  3.597011401000538e-22, -9.640087006474379e-24,  2.181827673639499e-10, -5.605728904514638e-11,  7.509572546754819e-12, -6.870549544970669e-13,
  4.808107433218035e-14, -2.739553446774272e-15,  1.322053519710527e-16, -5.552270161990427e-18,  2.069815801214159e-19, -6.952717671516429e-21,  2.129379669538985e-22,
 -5.998768585645309e-24,  7.179488514706952e-11, -1.962744794904422e-11,  2.799146157623630e-12, -2.722095166691369e-13,  2.021097318009084e-14, -1.219541802948376e-15,
  6.221648954238009e-17, -2.757670992835159e-18,  1.083265726920142e-19, -3.828630033416180e-21,  1.232016703745411e-22, -3.641622670954431e-24,  2.382364190103179e-11,
 -6.904394922242730e-12,  1.044876792873034e-12, -1.076876260028369e-13,  8.459878933546084e-15, -5.392188074824569e-16,  2.901105193474187e-17, -1.354002613911073e-18,
  5.592342600322794e-20, -2.075290263786887e-21,  7.002516168827245e-23, -2.167505122683109e-24,  8.020272815279318e-12, -2.454962358469570e-12,  3.929544148106608e-13,
 -4.279156226516727e-14,  3.546894797651302e-15, -2.381705245776921e-16,  1.347978856480820e-17, -6.608712546983899e-19,  2.863366437788945e-20, -1.113225250357807e-21,
  3.930436130042241e-23, -1.271410925663001e-24,  2.756476225130606e-12, -8.878438898124729e-13,  1.498117247306100e-13, -1.718434375915497e-14,  1.498476149580229e-15,
 -1.057132002550607e-16,  6.277383622656853e-18, -3.224763978378010e-19,  1.462163417522958e-20, -5.941757857692306e-22,  2.190195173230441e-23, -7.387993919635835e-25,
  9.733653441336489e-13, -3.286751028235344e-13,  5.826520766713964e-14, -7.017473204565473e-15,  6.418160243659205e-16, -4.743271536668172e-17,  2.947030508025495e-18,
 -1.582124351645094e-19,  7.488093429319271e-21, -3.172760896482002e-22,  1.218106883370196e-23, -4.274937768050736e-25,  3.554078157469786e-13, -1.253427527880509e-13,
  2.326261471703137e-14, -2.932101453885763e-15,  2.803842838801971e-16, -2.164211587953140e-17,  1.402834116526305e-18, -7.848539325673558e-20,  3.867094044850013e-21,
 -1.704000089396180e-22,  6.796816930703583e-24, -2.475661659251475e-25,  1.350223982243694e-13, -4.954747684141246e-14,  9.592658043969903e-15, -1.261014230301729e-15,
  1.256645246964137e-16, -1.009870579127088e-17,  6.808488966017415e-19, -3.958075679636270e-20,  2.024471794086251e-21, -9.251686099434387e-23,  3.823723238973642e-24,
 -1.441746827680192e-25,  5.368226822295449e-14, -2.041931266358224e-14,  4.108778615446931e-15, -5.613184050663500e-16,  5.809395051525397e-17, -4.844553443483483e-18,
  3.386321589392040e-19, -2.039239205993304e-20,  1.079505959414169e-21, -5.101465510226166e-23,  2.178527817692051e-24, -8.479893008917433e-26,  2.244863869516254e-14,
 -8.817290218000272e-15,  1.837004124137517e-15, -2.598474618657617e-16,  2.783015463081727e-17, -2.399958216260220e-18,  1.733442146519011e-19, -1.077808378877321e-20,
  5.886465848909155e-22, -2.867816119151530e-23,  1.261609564307829e-24, -5.054939151907086e-26,  9.910925147368981e-15, -4.004282723782007e-15,  8.604093373847799e-16,
 -1.255343045271518e-16,  1.386171461025696e-17, -1.231680117898324e-18,  9.160248379915378e-20, -5.860667728147079e-21,  3.291340950216361e-22, -1.647752551703655e-23,
  7.443963420338047e-25, -3.060759966651928e-26,  4.627117711570847e-15, -1.915616714241153e-15,  4.228150920981120e-16, -6.337763523650197e-17,  7.187312700380727e-18,
 -6.555442150682197e-19,  5.001723895695843e-20, -3.281060457967453e-21,  1.888167958092669e-22, -9.680760786328534e-24,  4.476364520796816e-25, -1.882731427665506e-26,
  2.279828370188515e-15, -9.633919192947506e-16,  2.175300474713075e-16, -3.336242281239131e-17,  3.870104896121160e-18, -3.609205761903676e-19,  2.814353066821785e-20,
 -1.885863302256664e-21,  1.108052723451921e-22, -5.797514666974950e-24,  2.734404136493530e-25, -1.172477831369391e-26,  1.175061294952591e-15, -5.048636189345570e-16,
  1.161284487408866e-16, -1.814698530746516e-17,  2.144412985186189e-18, -2.036539568878662e-19,  1.616559384026369e-20, -1.102260300510232e-21,  6.587530741435372e-23,
 -3.504458715469883e-24,  1.679924692091081e-25, -7.318045028884989e-27,  6.188553592666226e-16, -2.692907910914658e-16,  6.283111356259167e-17, -9.960930623482097e-18,
  1.193987073127510e-18, -1.149932627330907e-19,  9.254127225587193e-21, -6.395314282369756e-22,  3.872597320387313e-23, -2.086754027778409e-24,  1.012934055699666e-25,
 -4.466682450840462e-27,  3.123719326057964e-16, -1.371281722390443e-16,  3.231337598083644e-17, -5.174447913426397e-18,  6.264386656067494e-19, -6.092463002035419e-20,
  4.950079568482468e-21, -3.453065365169875e-22,  2.110182849908235e-23, -1.147288885099315e-24,  5.617932509446626e-26, -2.498475139577662e-27,  1.178592464073870e-16,
 -5.199282783379028e-17,  1.231960833840657e-17, -1.983848048028173e-18,  2.415073799169705e-19, -2.361630254218806e-20,  1.929083760304605e-21, -1.352737875984724e-22,
  8.308987591814948e-24, -4.540140692113974e-25,  2.234042621761781e-26, -9.982814747321095e-28,  5.830261599485846e-02, -1.405070266152270e-04,  3.506165006324325e-07,
 -9.008075863986904e-10,  2.366610095160326e-12, -6.317623096311974e-15,  1.703971752477787e-17, -4.624828928997720e-20,  1.258937154114509e-22, -3.430813581878973e-25,
  9.342981881956415e-28, -2.541496360882968e-30,  5.506131750740990e-02, -1.650754173104547e-04,  5.861172364053885e-07, -2.174401576955275e-09,  8.018523101168787e-12,
 -2.902575092981329e-14,  1.030491611935161e-16, -3.595562691807139e-19,  1.235741604346878e-21, -4.191575877440597e-24,  1.405321221714602e-26, -4.662965499212859e-29,
  4.911294635731272e-02, -2.050585117645610e-04,  1.028278300706041e-06, -4.980016921467424e-09,  2.292434630908091e-11, -1.012893627283506e-13,  4.332135981301831e-16,
 -1.803868112475698e-18,  7.341944845364316e-21, -2.929618631368560e-23,  1.148697409188198e-25, -4.433966746559331e-28,  4.138101583031630e-02, -2.459582616487832e-04,
  1.612185884770273e-06, -9.595145161550907e-09,  5.310294381017985e-11, -2.785592570160556e-13,  1.400549098964286e-15, -6.798859899594973e-18,  3.203394070220005e-20,
 -1.470767020479882e-22,  6.600576416586923e-25, -2.902633083067166e-27,  3.294279530995011e-02, -2.736461588679782e-04,  2.234800850509340e-06, -1.596487799368800e-08,
  1.044191783054602e-10, -6.397782771688795e-13,  3.721721537726814e-15, -2.074247887545135e-17,  1.114865519990497e-19, -5.807204734464923e-22,  2.942752556883724e-24,
 -1.455100148513441e-26,  2.478602426210270e-02, -2.792956922550775e-04,  2.770705530848391e-06, -2.344204103700839e-08,  1.789410392492811e-10, -1.265097561785497e-12,
  8.417069127641192e-15, -5.327344626128937e-17,  3.232497250989851e-19, -1.891297614934300e-21,  1.071820508381361e-23, -5.904150626828803e-26,  1.763232514101549e-02,
 -2.615490039469393e-04,  3.105516878381664e-06, -3.079859705618823e-08,  2.716279102504188e-10, -2.195140364661898e-12,  1.655760158987197e-14, -1.180234193282198e-16,
  8.020850339438048e-19, -5.231451808161242e-21,  3.291443970398745e-23, -2.005635163248999e-25,  1.186522437393355e-02, -2.255369369913737e-04,  3.172176808723186e-06,
 -3.655235407015853e-08,  3.694069341178330e-10, -3.386740624840502e-12,  2.875782659254570e-14, -2.293304522574820e-16,  1.734575145690252e-18, -1.253564248893676e-20,
  8.705316940979126e-23, -5.834968283688270e-25,  7.557079253007422e-03, -1.798511633008893e-04,  2.971086725166679e-06, -3.947149498328290e-08,  4.539549192304048e-10,
 -4.691877176169586e-12,  4.458852057497761e-14, -3.956184995942204e-16,  3.312992496423211e-18, -2.639724667627939e-20,  2.013668660983206e-22, -1.477817096829515e-24,
  4.558638869262874e-03, -1.331713941846120e-04,  2.564163450431512e-06, -3.900861862666300e-08,  5.075051756184344e-10, -5.881575269303225e-12,  6.224593791959243e-14,
 -6.116249141097716e-16,  5.645741247920567e-18, -4.938680878094104e-20,  4.121664497232814e-22, -3.299042209100929e-24,  2.606502005890087e-03, -9.189870807370939e-05,
  2.047688224780691e-06, -3.545455780069290e-08,  5.190663277936461e-10, -6.713508929111336e-12,  7.878181708509015e-14, -8.538119008344263e-16,  8.654230154311179e-18,
 -8.281095015005727e-20,  7.534688081844604e-22, -6.555448777550941e-24,  1.413877896312815e-03, -5.929820421649563e-05,  1.518710610186366e-06, -2.976260754646068e-08,
  4.880310078603628e-10, -7.014953897658435e-12,  9.092688941804952e-14, -1.083023791921526e-15,  1.201357008285742e-17, -1.253461152953106e-19,  1.239580348945328e-21,
 -1.168839178702117e-23,  7.283519608228793e-04, -3.588463064579454e-05,  1.049647203841434e-06, -2.316437835681882e-08,  4.236049459629380e-10, -6.741251464945121e-12,
  9.618299732645832e-14, -1.255052588013116e-15,  1.518997610842200e-17, -1.723203454788582e-19,  1.847157355918312e-21, -1.882741587931519e-23,  3.567394094152455e-04,
 -2.042290561444031e-05,  6.781684304346992e-07, -1.677465290509642e-08,  3.407558738518939e-10, -5.982947875848669e-12,  9.366886673389588e-14, -1.335098514413290e-15,
  1.758274277343890e-17, -2.163157565259207e-19,  2.507224123568084e-21, -2.755905756476705e-23,  1.663458708470429e-04, -1.096016341050168e-05,  4.108326792146080e-07,
 -1.134004098582389e-08,  2.549529494270900e-10, -4.922966987383827e-12,  8.432729316390788e-14, -1.309422864836213e-15,  1.871750156399605e-17, -2.491434118818065e-19,
  3.115445533863508e-21, -3.685063084804739e-23,  7.395489372178742e-05, -5.560663125037380e-06,  2.340445533859547e-07, -7.179514476374586e-09,  1.780339711179788e-10,
 -3.769289752902556e-12,  7.045109424889452e-14, -1.188818875726480e-15,  1.840242825357267e-17, -2.644432817185214e-19,  3.560188588712919e-21, -4.522665246321185e-23,
  3.140056740980227e-05, -2.674010065593159e-06,  1.257476407754774e-07, -4.270312096903572e-09,  1.164183727285798e-10, -2.694876075893530e-12,  5.482147965344505e-14,
 -1.002962949187172e-15,  1.677635606586328e-17, -2.597345681011509e-19,  3.757553198164703e-21, -5.117125209166551e-23,  1.275650982477268e-05, -1.221976800822740e-06,
  6.390569351417710e-08, -2.393699309654712e-09,  7.152363579735775e-11, -1.805350551106596e-12,  3.987603710890416e-14, -7.892180462657730e-16,  1.423564785626512e-17,
 -2.370028052204008e-19,  3.677715500418098e-21, -5.359806522024171e-23,  4.968812388182860e-06, -5.321113728322201e-07,  3.081171915342259e-08, -1.268537206071023e-09,
  4.142159925134809e-11, -1.137155769662555e-12,  2.720889055441875e-14, -5.813468650662873e-16,  1.128597112092790e-17, -2.016827846654043e-19,  3.351165794233461e-21,
 -5.218014880988707e-23,  1.859967601870162e-06, -2.214193159614002e-07,  1.413748486832615e-08, -6.376373916755031e-10,  2.268918973301949e-11, -6.758071256100842e-13,
  1.747808495421442e-14, -4.023287388824879e-16,  8.390665365286237e-18, -1.606646919353824e-19,  2.853862426332443e-21, -4.740215729299706e-23,  6.708234099285453e-07,
 -8.830994505894574e-08,  6.193164037548663e-09, -3.050328340259812e-10,  1.179601021534997e-11, -3.802891740501293e-13,  1.060802676086709e-14, -2.625633605807325e-16,
  5.871835565227981e-18, -1.202694906805916e-19,  2.280124187915633e-21, -4.033829586351621e-23,  2.337765811973872e-07, -3.386741748432035e-08,  2.599071738413075e-09,
 -1.393653260866007e-10,  5.841769600705738e-12, -2.033713858645634e-13,  6.105924821966317e-15, -1.621928596679818e-16,  3.882624694459764e-18, -8.492653688185265e-20,
  1.715759387425115e-21, -3.228208046153889e-23,  7.896878247258448e-08, -1.253239513239767e-08,  1.048725173809072e-09, -6.103992924149216e-11,  2.766247896297951e-12,
 -1.037563477860863e-13,  3.345981894288952e-15, -9.520613004464691e-17,  2.435296561336087e-18, -5.679285474815645e-20,  1.220797984506060e-21, -2.439238027029692e-23,
  2.594686352937632e-08, -4.491427667979183e-09,  4.084329668652870e-10, -2.572983768947872e-11,  1.257502256220249e-12, -5.070316488281399e-14,  1.752692626037237e-15,
 -5.332041270580669e-17,  1.454843252024328e-18, -3.611363748066402e-20,  8.246825421994131e-22, -1.747278543485504e-23,  8.324417949787017e-09, -1.565244585554918e-09,
  1.541672034596296e-10, -1.048205143144110e-11,  5.511039648017306e-13, -2.383379479559636e-14,  8.813361084273952e-16, -2.861274825018934e-17,  8.312987874000120e-19,
 -2.192856187818610e-20,  5.311463818601880e-22, -1.191539601414319e-23,  2.618708813288413e-09, -5.327438443387155e-10,  5.665028837718236e-11, -4.145586083039453e-12,
  2.338921868559160e-13, -1.082526471083586e-14,  4.273416104037565e-16, -1.477744027074925e-17,  4.563529804895521e-19, -1.277102254307153e-20,  3.275892689605488e-22,
 -7.769350848224195e-24,  8.114791240309463e-10, -1.779244869598755e-10,  2.036191331969292e-11, -1.599307945686824e-12,  9.658950786305851e-14, -4.773509425369531e-15,
  2.007526450813288e-16, -7.379931798915978e-18,  2.418081597552396e-19, -7.166776676962532e-21,  1.943663930356542e-22, -4.865871431887914e-24,  2.489373852579598e-10,
 -5.860516515894728e-11,  7.195439012816137e-12, -6.049237680915389e-13,  3.901063109694805e-14, -2.053915586643562e-15,  9.182744179267184e-17, -3.581542833750226e-18,
  1.242783437463613e-19, -3.894116172800674e-21,  1.114726779538246e-22, -2.940973948305454e-24,  7.600940178856875e-11, -1.914187278752598e-11,  2.513549903854855e-12,
 -2.255548057858911e-13,  1.549238433194425e-14, -8.669498474120825e-16,  4.111533328463134e-17, -1.697928044229085e-18,  6.227464935247343e-20, -2.059145524096473e-21,
  6.210787971406032e-23, -1.723933628043913e-24,  2.323406329673304e-11, -6.236064012322249e-12,  8.730364607445740e-13, -8.338579954110709e-14,  6.084383382051657e-15,
 -3.610129526827011e-16,  1.812061414013185e-17, -7.906459862775907e-19,  3.058892096613007e-20, -1.065287041537354e-21,  3.379299663390615e-23, -9.851034999230144e-25,
  7.153971845087475e-12, -2.038927424204221e-12,  3.033638810768700e-13, -3.075152243288036e-14,  2.377338147787517e-15, -1.491916916302100e-16,  7.907058498183920e-18,
 -3.637067156842576e-19,  1.481164647715980e-20, -5.421917204953019e-22,  1.805382812962223e-23, -5.516859334049022e-25,  2.233416187857735e-12, -6.734270683488597e-13,
  1.061427189630521e-13, -1.138543168544747e-14,  9.299819822607979e-16, -6.156696170500506e-17,  3.436928131339820e-18, -1.662716297790226e-19,  7.111636724840266e-21,
 -2.730458817739963e-22,  9.523869985364564e-24, -3.044662119083962e-25,  7.117979174102969e-13, -2.262202812884001e-13,  3.764727276278347e-14, -4.260107000706362e-15,
  3.666052766888862e-16, -2.553355120986153e-17,  1.497489786693411e-18, -7.600650608828932e-20,  3.406229715959168e-21, -1.368574879131253e-22,  4.989482154479500e-24,
 -1.665186721994309e-25,  2.332186237261939e-13, -7.783326842214002e-14,  1.362996259347262e-14, -1.621924773217003e-15,  1.466084540194727e-16, -1.071202299393671e-17,
  6.582185701910371e-19, -3.495918525415143e-20,  1.637438932454320e-21, -6.868101281096081e-23,  2.611060228299199e-24, -9.076579869357138e-26,  7.911888061328140e-14,
 -2.762264640401291e-14,  5.072255558436914e-15, -6.326319901162014e-16,  5.987760418336474e-17, -4.575852694968169e-18,  2.937413983094213e-19, -1.628009494505841e-20,
  7.948423631166921e-22, -3.471431441826461e-23,  1.372768407082703e-24, -4.958479085392997e-26,  2.798704461904043e-14, -1.018267698845652e-14,  1.953584193930236e-15,
 -2.545065617005910e-16,  2.513994932582378e-17, -2.003048199827332e-18,  1.339228502024269e-19, -7.722706792898141e-21,  3.919036089516369e-22, -1.777328721429423e-23,
  7.291323967993847e-25, -2.729473364381419e-26,  1.039184700989725e-14, -3.924951293666046e-15,  7.838116663692136e-16, -1.062751786657173e-16,  1.091803729979946e-17,
 -9.039409239485447e-19,  6.274400754570306e-20, -3.752795501193317e-21,  1.973502100498773e-22, -9.266464095824877e-24,  3.932482441176768e-25, -1.521457725332884e-26,
  4.074532565672796e-15, -1.591304634027586e-15,  3.294988484381201e-16, -4.632277424235547e-17,  4.931453692029110e-18, -4.227758326827994e-19,  3.036201344835436e-20,
 -1.877350944227372e-21,  1.019783775517275e-22, -4.942190516924403e-24,  2.163072346174817e-25, -8.623948436262217e-27,  1.694957066454148e-15, -6.817851039715528e-16,
  1.457905546927303e-16, -2.116838702153869e-17,  2.326378891247064e-18, -2.057538370693985e-19,  1.523335900761546e-20, -9.703456827599136e-22,  5.426191806568877e-23,
 -2.705253279052354e-24,  1.217203571892907e-25, -4.985210025370574e-27,  7.499966549477594e-16, -3.094741850582119e-16,  6.805960448886723e-17, -1.016468105210096e-17,
  1.148600035777372e-18, -1.043960063348391e-19,  7.938150680622589e-21, -5.190036790856191e-22,  2.977090144728873e-23, -1.521576691786108e-24,  7.014224860369415e-26,
 -2.941383934969256e-27,  3.526197180974828e-16, -1.486610062369959e-16,  3.348063792244932e-17, -5.121612187398778e-18,  5.926022967118417e-19, -5.512741864466030e-20,
  4.288213439190397e-21, -2.866664613105799e-22,  1.680439757949978e-23, -8.772568542848948e-25,  4.128534746017187e-26, -1.766501357483813e-27,  1.747621636050221e-16,
 -7.497230694496831e-17,  1.721588826857024e-17, -2.685677276561239e-18,  3.168300404941378e-19, -3.003961570384215e-20,  2.380639015850969e-21, -1.620704107915434e-22,
  9.671130503474292e-24, -5.137214080474248e-25,  2.459038947173241e-26, -1.069689199123983e-27,  8.925161717350044e-17, -3.880263328820980e-17,  9.044410740562050e-18,
 -1.432408655408674e-18,  1.715273274462138e-19, -1.650368797258305e-20,  1.326869907285331e-21, -9.161124483534050e-23,  5.542338503257659e-24, -2.983839645905263e-25,
  1.447132934473137e-26, -6.375962194145766e-28,  4.408259200235523e-17, -1.934309760252469e-17,  4.555760475412995e-18, -7.291532039990300e-19,  8.822902975605238e-20,
 -8.576450976143551e-21,  6.964867374379101e-22, -4.856192186552943e-23,  2.966238351991397e-24, -1.611974274029179e-25,  7.889793045198421e-27, -3.507298985819970e-28,
  1.643047447965036e-17, -7.246719128530127e-18,  1.716699652904018e-18, -2.763778237742884e-19,  3.363742943736490e-20, -3.288538355710111e-21,  2.685604340330811e-22,
 -1.882807812615013e-23,  1.156227684688995e-24, -6.316391047857177e-26,  3.107399752783118e-27, -1.388246064402768e-28,  5.774613018732808e-02, -1.377446991169485e-04,
  3.400299053256984e-07, -8.639308570171183e-10,  2.244244579515700e-12, -5.923765228938654e-15,  1.579935923780997e-17, -4.241030551578533e-20,  1.141893934695192e-22,
 -3.078518727202178e-25,  8.294251409329894e-28, -2.232597952865940e-30,  5.441023148145539e-02, -1.604887129194045e-04,  5.607754648206084e-07, -2.050618295710727e-09,
  7.461946923326458e-12, -2.666904917278334e-14,  9.351326395245132e-17, -3.223222820017019e-19,  1.094487776020976e-21, -3.668405736444600e-24,  1.215457677768919e-26,
 -3.985999091012009e-29,  4.830879488626640e-02, -1.970652411219533e-04,  9.706537680099087e-07, -4.628885475389789e-09,  2.099857232861666e-11, -9.147273130906099e-14,
  3.858420395282622e-16, -1.584950466999481e-18,  6.365495240614986e-21, -2.506887724235243e-23,  9.703148039599250e-26, -3.697889490088556e-28,  4.042226837470757e-02,
 -2.335073093953674e-04,  1.501963920278813e-06, -8.788303927745548e-09,  4.785304917299917e-11, -2.471193770114879e-13,  1.223771181159147e-15, -5.853633940525580e-18,
  2.718518339363929e-20, -1.230610995444067e-22,  5.446527716587399e-25, -2.362567374874486e-27,  3.188279301076457e-02, -2.565066060754090e-04,  2.052839499973322e-06,
 -1.439187299544352e-08,  9.247178633881092e-11, -5.570418326018453e-13,  3.187890242930269e-15, -1.748788141573436e-17,  9.255371335961626e-20, -4.748798490919405e-22,
  2.371076693464728e-24, -1.155511990659304e-26,  2.371145745141608e-02, -2.582084480894949e-04,  2.505778630654492e-06, -2.077091107225122e-08,  1.555441447334672e-10,
 -1.079878984521560e-12,  7.060554570404125e-15, -4.394092340485432e-17,  2.622926509047982e-19, -1.510339045374165e-21,  8.426675280192151e-24, -4.571365807990002e-26,
  1.663357677810650e-02, -2.381125204981584e-04,  2.760628190657757e-06, -2.678325538323731e-08,  2.314455328986659e-10, -1.834678799881891e-12,  1.358568367948698e-14,
 -9.513222221067623e-17,  6.354682326409920e-19, -4.075790005742486e-21,  2.522707808883078e-23, -1.512785434155524e-25,  1.101118883544489e-02, -2.018184714389395e-04,
  2.766892144912062e-06, -3.114829691351854e-08,  3.080846084619361e-10, -2.767729739945796e-12,  2.305033623553835e-14, -1.804197155300709e-16,  1.340239300693763e-18,
 -9.517620020674466e-21,  6.497616797785077e-23, -4.283195983351006e-25,  6.882377524002640e-03, -1.578603972807008e-04,  2.538090365115097e-06, -3.290433467450796e-08,
  3.699797376856743e-10, -3.743526209906171e-12,  3.486294917491117e-14, -3.033718516480229e-16,  2.493259796678817e-18, -1.950748268606098e-20,  1.461976199479740e-22,
 -1.054561442806891e-24,  4.064198978761488e-03, -1.144008990002372e-04,  2.141146541754134e-06, -3.175389451173276e-08,  4.035244591584049e-10, -4.574299424995087e-12,
  4.740359190984329e-14, -4.564898597848573e-16,  4.132621677772974e-18, -3.547652047627376e-20,  2.907097576121238e-22, -2.285792093967073e-24,  2.269162300537308e-03,
 -7.708741028730314e-05,  1.667944830040602e-06, -2.812852511588212e-08,  4.019180956572716e-10, -5.080892242755918e-12,  5.834242322801552e-14, -6.192798927147567e-16,
  6.152504201776455e-18, -5.774228757244121e-20,  5.155863779154240e-22, -4.404411215532595e-24,  1.198896748506266e-03, -4.845432064997754e-05,  1.204138101687910e-06,
 -2.296751443763199e-08,  3.673060719695087e-10, -5.157014211815374e-12,  6.536873996100793e-14, -7.621425625070868e-16,  8.282084010703781e-18, -8.471238128746345e-20,
  8.217509183223474e-22, -7.604698982456597e-24,  5.999974142102692e-04, -2.849361001662409e-05,  8.082673711556501e-07, -1.735090543185630e-08,  3.092786583331575e-10,
 -4.804889917295238e-12,  6.700702822681436e-14, -8.554472770106857e-16,  1.013818162269177e-17, -1.126997808659474e-19,  1.184532356072335e-21, -1.184496804331964e-23,
  2.847433965229371e-04, -1.571841518781185e-05,  5.059999079463298e-07, -1.216933844997532e-08,  2.408498363214442e-10, -4.126467013787618e-12,  6.311784749915757e-14,
 -8.798409601534074e-16,  1.134185990102407e-17, -1.366831038500121e-19,  1.552858288714172e-21, -1.674049983934898e-23,  1.283055632272684e-04, -8.155302518399604e-06,
  2.963033657107577e-07, -7.949852017455054e-09,  1.740799098128530e-10, -3.278895687762749e-12,  5.485522121073977e-14, -8.327704367966919e-16,  1.164847650438293e-17,
 -1.518366725961305e-19,  1.860563144937120e-21, -2.157882037836813e-23,  5.497281106855981e-05, -3.989682301309555e-06,  1.627632257589061e-07, -4.852413155815122e-09,
  1.171700655328314e-10, -2.419265769577882e-12,  4.415277022220797e-14, -7.282509829619606e-16,  1.102860324471500e-17, -1.551649297698231e-19,  2.046664373291089e-21,
 -2.548875798146064e-23,  2.243178191846426e-05, -1.845013213592561e-06,  8.410932290637354e-08, -2.775869165869702e-09,  7.368359333828277e-11, -1.663195087582335e-12,
  3.303244657314052e-14, -5.906206280606769e-16,  9.663658666780139e-18, -1.464646173385269e-19,  2.075716556504585e-21, -2.770905344434525e-23,  8.733403897963299e-06,
 -8.086145565406854e-07,  4.100597431340419e-08, -1.492857945862714e-09,  4.343286832397478e-11, -1.068999089757576e-12,  2.305132395047173e-14, -4.458543661786856e-16,
  7.866306001990719e-18, -1.281988988250621e-19,  1.948718324832510e-21, -2.783787430370004e-23,  3.250832709876249e-06, -3.367634613025280e-07,  1.891662851888718e-08,
 -7.571339938915256e-10,  2.407560864379440e-11, -6.445490234082921e-13,  1.505708874257489e-14, -3.144102397171348e-16,  5.970535642431607e-18, -1.044466305002787e-19,
  1.700105009036346e-21, -2.594876443916608e-23,  1.159553711297797e-06, -1.336507395404015e-07,  8.282506629141320e-09, -3.632938196470091e-10,  1.259200595075597e-11,
 -3.658221182845002e-13,  9.238582135177901e-15, -2.078662927369603e-16,  4.240985580527464e-18, -7.950472421639842e-20,  1.383594353489521e-21, -2.252963712589640e-23,
  3.973590630787276e-07, -5.069688150603323e-08,  3.452993717755992e-09, -1.654733506110538e-10,  6.235458206866713e-12, -1.961331346704023e-13,  5.343801492977259e-15,
 -1.293134340092633e-16,  2.829729048756805e-18, -5.675669243259227e-20,  1.054406991814334e-21, -1.829071730674411e-23,  1.311928817774350e-07, -1.843956585833229e-08,
  1.375382599490568e-09, -7.179781723934478e-11,  2.934007407857961e-12, -9.969870770859069e-14,  2.924749950873536e-15, -7.598143100608288e-17,  1.780315604536959e-18,
 -3.814456275709918e-20,  7.553624938551053e-22, -1.393933947935922e-23,  4.186498127474916e-08, -6.453384734671146e-09,  5.253181169470605e-10, -2.978700480662158e-11,
  1.316801516136166e-12, -4.823387854188783e-14,  1.520554956327622e-15, -4.233203871665902e-17,  1.060296194768770e-18, -2.422996380156262e-20,  5.107069302461076e-22,
 -1.001193282441625e-23,  1.295791836313058e-08, -2.181358606105485e-09,  1.931457200123556e-10, -1.186317345541245e-11,  5.659679582419683e-13, -2.229962634366960e-14,
  7.539752240425968e-16, -2.245435595796379e-17,  6.002203623677137e-19, -1.460679932172475e-20,  3.272175240934753e-22, -6.805160253701247e-24,  3.905324621077216e-09,
 -7.150670897859005e-10,  6.864911761892365e-11, -4.554925724047734e-12,  2.339571188348988e-13, -9.894448900281221e-15,  3.581133636530054e-16, -1.138851234383236e-17,
  3.243467206450389e-19, -8.392611549349865e-21,  1.995273519487494e-22, -4.395929256221487e-24,  1.151027427314312e-09, -2.283393280997114e-10,  2.369409764633834e-11,
 -1.693760921450334e-12,  9.344207493617491e-14, -4.232737680369164e-15,  1.636717162464648e-16, -5.548058115964401e-18,  1.680684057306423e-19, -4.616686493891321e-21,
  1.163079020970439e-22, -2.710708399066482e-24,  3.333310449443954e-10, -7.137268319593564e-11,  7.980439065209282e-12, -6.129799451043324e-13,  3.623601598674258e-14,
 -1.754315145984759e-15,  7.233094194171801e-17, -2.608644027130071e-18,  8.391036594948630e-20, -2.442936236099132e-21,  6.511721633239571e-23, -1.603079293193319e-24,
  9.534043048830174e-11, -2.195249211466709e-11,  2.636876126118866e-12, -2.170483716945451e-13,  1.371550632743898e-14, -7.081337203914030e-16,  3.106822580793171e-17,
 -1.189899325875734e-18,  4.056913865031414e-20, -1.249727006664195e-21,  3.518923189901095e-23, -9.136702072691754e-25,  2.708571863218176e-11, -6.682009487827697e-12,
  8.596089733804566e-13, -7.562118223073627e-14,  5.095629137437832e-15, -2.799373395105845e-16,  1.304184754618146e-17, -5.294019880954495e-19,  1.909649155771013e-20,
 -6.213472532320399e-22,  1.845073611139477e-23, -5.044480514717105e-25,  7.689875608116688e-12, -2.025183271093371e-12,  2.781719979616505e-13, -2.608190780878196e-14,
  1.869401863468554e-15, -1.090224315986840e-16,  5.381804045874865e-18, -2.310675069617870e-19,  8.801326749772473e-21, -3.019183521754384e-22,  9.438166966554833e-24,
 -2.712542899021129e-25,  2.196177208406867e-12, -6.151877814516336e-13,  8.994138127801310e-14, -8.962859994340317e-15,  6.815412654914146e-16, -4.209253524320718e-17,
  2.196663894123798e-18, -9.954179230418122e-20,  3.995473260011251e-21, -1.442189519840728e-22,  4.737251493653317e-24, -1.428624358060162e-25,  6.353694319272353e-13,
 -1.886119410007830e-13,  2.925781618586590e-14, -3.089786883030898e-15,  2.485902864477178e-16, -1.621798819064607e-17,  8.926122756893484e-19, -4.259399369291587e-20,
  1.797722292491792e-21, -6.813763143793259e-23,  2.347089993730682e-24, -7.412871198132377e-26,  1.875877567701451e-13, -5.879500223857819e-14,  9.645250722031041e-15,
 -1.076192391944434e-15,  9.135439921772031e-17, -6.278915553574681e-18,  3.635454318594450e-19, -1.822381621226427e-20,  8.069023899673349e-22, -3.204285427456963e-23,
  1.155003331941035e-24, -3.812468810167903e-26,  5.695623313770773e-14, -1.877753524097724e-14,  3.246718660519360e-15, -3.815437176049228e-16,  3.407056136064385e-17,
 -2.460104324594619e-18,  1.494406504589021e-19, -7.849229030507628e-21,  3.636994254347448e-22, -1.509609304609193e-23,  5.681036701764196e-25, -1.955465220471908e-26,
  1.792474281866755e-14, -6.192328472770919e-15,  1.124530579507844e-15, -1.387276738997118e-16,  1.299077387414668e-17, -9.824982426306140e-19,  6.243757948743785e-20,
 -3.426796554898803e-21,  1.657249754039113e-22, -7.171523134899789e-24,  2.810679593831121e-25, -1.006448983721344e-26,  5.893237291079842e-15, -2.125067004021645e-15,
  4.038488925098528e-16, -5.211953435081991e-17,  5.101220573329186e-18, -4.028255276635539e-19,  2.669971417784076e-20, -1.526711219795954e-21,  7.684367147379845e-23,
 -3.457327552105722e-24,  1.407413447911636e-25, -5.229236586488152e-27,  2.039592654957756e-15, -7.646529632082955e-16,  1.514928854286705e-16, -2.037907889637508e-17,
  2.077505825565842e-18, -1.707141909780003e-19,  1.176316278141115e-20, -6.985845382955785e-22,  3.648394590914372e-23, -1.701624161368374e-24,  7.174375514976043e-26,
 -2.758229507386505e-27,  7.482406945808830e-16, -2.904826005242783e-16,  5.976048003303551e-17, -8.347521856268011e-18,  8.830714417805056e-19, -7.524145058734662e-20,
  5.371253422625403e-21, -3.301875919131662e-22,  1.783464495923535e-23, -8.595792393709504e-25,  3.742091184564368e-26, -1.484213093215554e-27,  2.926459525188135e-16,
 -1.171675473186628e-16,  2.492773300699697e-17, -3.601106564925368e-18,  3.937890335039037e-19, -3.465914548725465e-20,  2.553922181205031e-21, -1.619333977878916e-22,
  9.014844470465527e-24, -4.474845694789656e-25,  2.004900087260849e-26, -8.177631161114072e-28,  1.224687951295348e-16, -5.035926182016409e-17,  1.103274947586604e-17,
 -1.641436413299466e-18,  1.847834505673504e-19, -1.673322509211348e-20,  1.267819245107696e-21, -8.260228915501319e-23,  4.722134382939604e-24, -2.405498831629574e-25,
  1.105338053411550e-26, -4.620754167931220e-28,  5.483550669030926e-17, -2.306141274069414e-17,  5.179671472239999e-18, -7.901862653080460e-19,  9.118401776763043e-20,
 -8.460214134357531e-21,  6.564121481913308e-22, -4.377160891895514e-23,  2.559662769536505e-24, -1.333088637098193e-25,  6.259335877711870e-27, -2.672242268985755e-28,
  2.608649733859520e-17, -1.117306760304983e-17,  2.561089641116936e-18, -3.988114317553668e-19,  4.696447935485667e-20, -4.445115448611011e-21,  3.516783926505375e-22,
 -2.390219834257049e-23,  1.424006059523732e-24, -7.552330361987722e-26,  3.609568532675151e-27, -1.567845515017024e-28,  1.290006012638468e-17, -5.603102388356736e-18,
  1.304638530072299e-18, -2.064025690581283e-19,  2.469024333039871e-20, -2.373153314715782e-21,  1.906057086248545e-22, -1.314708662034534e-23,  7.946162280047178e-25,
 -4.273993446140786e-26,  2.070956311324971e-27, -9.116400628180987e-29,  6.228003608517894e-18, -2.731506533048634e-18,  6.429918656671070e-19, -1.028557865719972e-19,
  1.243909955244168e-20, -1.208527116391303e-21,  9.809287945443607e-23, -6.835984530537979e-24,  4.173463452111087e-25, -2.266933608422842e-26,  1.109024456539133e-27,
 -4.927745907493665e-29,  2.291698334735309e-18, -1.010548218719857e-18,  2.393347043512973e-19, -3.852194457408842e-20,  4.687289095486662e-21, -4.581385784043394e-22,
  3.740523592590365e-23, -2.621768366652322e-24,  1.609649246992596e-25, -8.791400638882253e-27,  4.324032773721732e-28, -1.931358832863663e-29,  5.720052706068526e-02,
 -1.350653269931999e-04,  3.298743384869932e-07, -8.289505402633889e-10,  2.129467025916017e-12, -5.558427577160303e-15,  1.466140600036652e-17, -3.892735163821862e-20,
  1.036809874239524e-22, -2.765577516883435e-25,  7.372372364845131e-28, -1.963906624518823e-30,  5.377709600314701e-02, -1.560989489891314e-04,  5.368671773881049e-07,
 -1.935375250344547e-09,  6.950298044203769e-12, -2.452919221093286e-14,  8.495936681161252e-17, -2.893211656535579e-19,  9.707698928699586e-22, -3.215544742453171e-24,
  1.053015257138076e-26, -3.413468628247605e-29,  4.753572047093937e-02, -1.895166217119827e-04,  9.170642227892578e-07, -4.307055502159125e-09,  1.925824063907464e-11,
 -8.272285596306324e-14,  3.441846574476970e-16, -1.394975898278568e-18,  5.529129010564160e-21, -2.149432006785182e-23,  8.213811979561741e-26, -3.091001929629017e-28,
  3.951162054182679e-02, -2.219007861156182e-04,  1.400940088168302e-06, -8.060652452702001e-09,  4.319158187207537e-11, -2.196213361025453e-13,  1.071411226794064e-15,
 -5.050581679591607e-18,  2.312332011195604e-20, -1.032193537756597e-22,  4.505951160012146e-25, -1.928274726814853e-27,  3.088855266201064e-02, -2.407503681520752e-04,
  1.888659692726387e-06, -1.299745475788201e-08,  8.205804574818713e-11, -4.860888864586879e-13,  2.737248541996735e-15, -1.478233845733574e-17,  7.704943258488611e-20,
 -3.894724024430964e-22,  1.916388490650051e-24, -9.205974676941642e-27,  2.271719516567911e-02, -2.391184983770857e-04,  2.270775936060943e-06, -1.844618030607703e-08,
  1.355461368245739e-10, -9.242893827346443e-13,  5.939983849977303e-15, -3.635619893503101e-17,  2.135323742992143e-19, -1.210303554155220e-21,  6.649188852172483e-24,
 -3.552902202080587e-26,  1.572334655784068e-02, -2.172528159944621e-04,  2.460292016421188e-06, -2.335682572144839e-08,  1.978080857705549e-10, -1.538417888461023e-12,
  1.118592964561459e-14, -7.696245142523311e-17,  5.054060330221551e-19, -3.188250697859599e-21,  1.941661420429256e-23, -1.146043513684877e-25,  1.024593094740298e-02,
 -1.810986733715513e-04,  2.420954875662243e-06, -2.663335658854538e-08,  2.578766678605488e-10, -2.270595921431800e-12,  1.855087566336015e-14, -1.425472640182426e-16,
  1.040175858229592e-18, -7.259794140332565e-21,  4.873193012735159e-23, -3.159805776725929e-25,  6.289179576805273e-03, -1.390398564439423e-04,  2.176425419424446e-06,
 -2.754089560901510e-08,  3.028322544085754e-10, -3.000343427472479e-12,  2.738749324885479e-14, -2.337801071616693e-16,  1.885951573810810e-18, -1.449233780092891e-20,
  1.067241402838439e-22, -7.567730560625441e-25,  3.638586698767031e-03, -9.869272681558231e-05,  1.796008092368982e-06, -2.597166808309231e-08,  3.224525137046014e-10,
 -3.576154719013529e-12,  3.629622066915346e-14, -3.426191584829955e-16,  3.042604361761856e-18, -2.563676667627845e-20,  2.063063279371233e-22, -1.593757934168072e-24,
  1.985506751982156e-03, -6.499195553512989e-05,  1.365864519173664e-06, -2.244021838346694e-08,  3.130052224998579e-10, -3.868291959267155e-12,  4.347273057308870e-14,
 -4.520295319699892e-16,  4.402585416023932e-18, -4.053279248106027e-20,  3.552341553468062e-22, -2.980013970181621e-24,  1.022731511470385e-03, -3.983106808805362e-05,
  9.606431972171763e-07, -1.783724950351397e-08,  2.782693406350103e-10, -3.816902614186180e-12,  4.732235932092205e-14, -5.401678529627255e-16,  5.751405328958121e-18,
 -5.767918084428495e-20,  5.489191278136992e-22, -4.986268241944002e-24,  4.977463860792057e-04, -2.278296437282122e-05,  6.268383046832176e-07, -1.309138141820123e-08,
  2.274970606512449e-10, -3.450937348319894e-12,  4.704620939193903e-14, -5.877270010486521e-16,  6.821505039680629e-18, -7.431733549656600e-20,  7.660044285771644e-22,
 -7.515824162012828e-24,  2.291257077073718e-04, -1.219480928802998e-05,  3.806113431081926e-07, -8.901362632753549e-09,  1.716674165363959e-10, -2.870404260796657e-12,
  4.290151272959274e-14, -5.849500319996418e-16,  7.381825910445496e-18, -8.715239220567312e-20,  9.706485690191584e-22, -1.026397262413071e-23,  9.988183487034841e-05,
 -6.123674434637152e-06,  2.156644807280973e-07, -5.624895715207440e-09,  1.199765120822727e-10, -2.204640047635645e-12,  3.602698815214199e-14, -5.347870105209337e-16,
  7.320643006326196e-18, -9.345657894834444e-20,  1.122328370322188e-21, -1.276454166840540e-23,  4.129008762006583e-05, -2.891957010462217e-06,  1.143550301503111e-07,
 -3.313475846042723e-09,  7.791583691061466e-11, -1.569058659886723e-12,  2.796389628933300e-14, -4.508730204552016e-16,  6.680538428747252e-18, -9.203161401776236e-20,
  1.189428589982809e-21, -1.452296450241804e-23,  1.621179492014050e-05, -1.287612181089153e-06,  5.690036271389057e-08, -1.825019808819343e-09,  4.716978230808459e-11,
 -1.038274208750089e-12,  2.013348529627848e-14, -3.518404123613200e-16,  5.631505126717203e-18, -8.356030465373529e-20,  1.160165856126853e-21, -1.518204684894365e-23,
  6.056342582827732e-06, -5.418589602617666e-07,  2.664258872357265e-08, -9.426955298747020e-10,  2.670469954700446e-11, -6.409103149021166e-13,  1.349249239803976e-14,
 -2.550423274447949e-16,  4.401490656221670e-18, -7.022037588376043e-20,  1.045636732318854e-21, -1.464186016956167e-23,  2.157000376734485e-06, -2.160898745230582e-07,
  1.177314583207255e-08, -4.580627117486920e-10,  1.418362753013600e-11, -3.702863325304980e-13,  8.445175807583825e-15, -1.723419087398863e-16,  3.201239294413679e-18,
 -5.482132181051837e-20,  8.741476364261689e-22, -1.307847853494043e-23,  7.340505748463564e-07, -8.189035578559984e-08,  4.924584681705851e-09, -2.100396051715601e-10,
  7.090665958645196e-12, -2.009097074997130e-13,  4.954216680855210e-15, -1.089492698453462e-16,  2.174486091275518e-18, -3.990885239547956e-20,  6.804154735014637e-22,
 -1.086142007124708e-23,  2.392952046902305e-07, -2.957789787704981e-08,  1.956073769756561e-09, -9.118757853054925e-11,  3.347842051743685e-12, -1.027306294505521e-13,
  2.733596976410910e-15, -6.466714562859827e-17,  1.384562124330157e-18, -2.719220126230577e-20,  4.949883343126439e-22, -8.418864716539380e-24,  7.493830302891827e-08,
 -1.021468540309024e-08,  7.402971463475782e-10, -3.761355641470992e-11,  1.498207051990270e-12, -4.968353729340110e-14,  1.423926420323115e-15, -3.617340568579404e-17,
  8.295151309536713e-19, -1.740727711852777e-20,  3.378465948874973e-22, -6.114292106708716e-24,  2.261579462988572e-08, -3.384632049525586e-09,  2.679203562561832e-10,
 -1.479590975533242e-11,  6.378948054663321e-13, -2.281390401777153e-14,  7.029274205236908e-16, -1.914390090091606e-17,  4.694531927681802e-19, -1.051087267571742e-20,
  2.172037819719989e-22, -4.177272538309305e-24,  6.600776192342513e-09, -1.080111523958386e-09,  9.308553127515116e-11, -5.572598589637816e-12,  2.594456502784337e-13,
 -9.986730697786561e-15,  3.301972989607914e-16, -9.624598583377081e-18,  2.519975133972916e-19, -6.011060252446982e-21,  1.320759834095257e-22, -2.695757276839849e-24,
  1.870533492808234e-09, -3.333433908281101e-10,  3.117994732245611e-11, -2.018162202942193e-12,  1.012369540672536e-13, -4.185660523323507e-15,  1.482374580856762e-16,
 -4.616638101008718e-18,  1.288585116213953e-19, -3.269947926478040e-21,  7.628825082396581e-23, -1.650342418102254e-24,  5.169220185706036e-10, -9.994175824712460e-11,
  1.011542004512027e-11, -7.060733874268054e-13,  3.807538708603313e-14, -1.687471571530527e-15,  6.389582039076144e-17, -2.122560655976658e-18,  6.305694315094452e-20,
 -1.699758652774632e-21,  4.204716680363945e-23, -9.627843658020918e-25,  1.399841324811849e-10, -2.925404872198839e-11,  3.194339866189653e-12, -2.398379336543420e-13,
  1.387192751100902e-14, -6.576659007170015e-16,  2.657467114553197e-17, -9.399839794285242e-19,  2.967381669326962e-20, -8.483793934394707e-22,  2.221992074341335e-23,
 -5.377848749536089e-25,  3.734633422253304e-11, -8.405455877713756e-12,  9.872549681002443e-13, -7.952772973095648e-14,  4.922234889408927e-15, -2.491141187509064e-16,
  1.072137818658512e-17, -4.030785038163867e-19,  1.349872126624728e-20, -4.086787180444443e-22,  1.131571331539428e-23, -2.890639910267772e-25,  9.873698160139310e-12,
 -2.384720628663689e-12,  3.003943569322917e-13, -2.589414626731326e-14,  1.710996359469429e-15, -9.223957280468542e-17,  4.219809115257819e-18, -1.683094103714606e-19,
  5.968960928804298e-21, -1.910460453169099e-22,  5.583375402114359e-24, -1.503120828564757e-25,  2.603480253798724e-12, -6.723562261179001e-13,  9.056086842586203e-14,
 -8.331352466708136e-15,  5.862934685383869e-16, -3.359270529673979e-17,  1.630193933794527e-18, -6.884648522393104e-20,  2.580810117485452e-21, -8.717288068045700e-23,
  2.684535930480822e-24, -7.604127688948152e-26,  6.894211515931024e-13, -1.896942569585097e-13,  2.723700092220216e-14, -2.666921414512473e-15,  1.993747107568296e-16,
 -1.211286933741731e-17,  6.221695982251620e-19, -2.776388027399234e-20,  1.097958218033494e-21, -3.906464260498975e-23,  1.265381759926122e-24, -3.764731968475068e-26,
  1.847185348625607e-13, -5.395425938995317e-14,  8.232610339831010e-15, -8.555228251034380e-16,  6.776575161679247e-17, -4.354778219701846e-18,  2.362044491661702e-19,
 -1.111304523019238e-20,  4.626575893394227e-22, -1.730450305026680e-23,  5.884504009836723e-25, -1.835467789146555e-26,  5.047543148465365e-14, -1.559331616081927e-14,
  2.520317570431204e-15, -2.771441145492155e-16,  2.319541709589205e-17, -1.572554301604779e-18,  8.984951987622722e-20, -4.446445753523562e-21,  1.944390720832569e-22,
 -7.628629303284137e-24,  2.717735675677313e-25, -8.869421741127294e-27,  1.418460404516768e-14, -4.617279506673202e-15,  7.878654466545027e-16, -9.139205721873198e-17,
  8.058476697082068e-18, -5.747788609098016e-19,  3.450267201377899e-20, -1.791454608408739e-21,  8.208579233352678e-23, -3.370400985400236e-24,  1.255089548076342e-25,
 -4.276292010534673e-27,  4.134940001941013e-15, -1.412801047646381e-15,  2.536164588927032e-16, -3.093262645510778e-17,  2.864583027793969e-18, -2.143232612486423e-19,
  1.347827078578230e-20, -7.322566029915824e-22,  3.506560415044249e-23, -1.502967016144680e-24,  5.835997302883498e-26, -2.071021268259122e-27,  1.261325625224853e-15,
 -4.505843654581472e-16,  8.478409704061588e-17, -1.083509871323500e-17,  1.050373226139722e-18, -8.217473303323186e-20,  5.397550383976144e-21, -3.059362949686706e-22,
  1.526785694313938e-23, -6.812621134250315e-25,  2.751077704456804e-26, -1.014223037063360e-27,  4.060784859104826e-16, -1.510604246105575e-16,  2.968015807518460e-17,
 -3.959792522638930e-18,  4.004261933837075e-19, -3.264636975699271e-20,  2.232391632790608e-21, -1.315956472554940e-22,  6.823286499840127e-24, -3.160201079611677e-25,
  1.323370024262097e-26, -5.054330512446795e-28,  1.390891646576073e-16, -5.365882443254954e-17,  1.096451440282089e-17, -1.521246820307233e-18,  1.598689944290215e-19,
 -1.353395682176278e-20,  9.601057368244740e-22, -5.866195952717765e-23,  3.149835131339373e-24, -1.509419120121696e-25,  6.534457679050312e-27, -2.577724189132890e-28,
  5.103337938528226e-17, -2.033231381385934e-17,  4.302707030535900e-18, -6.182692437776559e-19,  6.725606578463539e-20, -5.889349276056080e-21,  4.318150348544048e-22,
 -2.724749938745747e-23,  1.509757588800207e-24, -7.460071793488808e-26,  3.327584945534182e-27, -1.351430627108170e-28,  2.015421668185329e-17, -8.257060836130044e-18,
  1.801691793127942e-18, -2.669740470993844e-19,  2.993550918898829e-20, -2.700362947779642e-21,  2.038272485302677e-22, -1.323133179328277e-23,  7.537027929095276e-25,
 -3.826132801996517e-26,  1.752204407516091e-27, -7.300983267082846e-29,  8.576078479171913e-18, -3.597382474454724e-18,  8.056713756963108e-19, -1.225562173124733e-19,
  1.410245297414371e-20, -1.304833088353831e-21,  1.009666808380077e-22, -6.715103376000449e-24,  3.916808669087733e-25, -2.034830212116960e-26,  9.531172821991468e-28,
 -4.059515272325614e-29,  3.908853480953772e-18, -1.671360105034454e-18,  3.823871420767920e-19, -5.943219888277798e-20,  6.985722753842905e-21, -6.599786028658892e-22,
  5.212147627998723e-23, -3.536330699388186e-24,  2.103248711058962e-25, -1.113635343163396e-26,  5.313975909745980e-28, -2.304571828503338e-29,  1.868814796804158e-18,
 -8.109093618381093e-19,  1.886043406247384e-19, -2.980505970880770e-20,  3.561392594699229e-21, -3.419395927251953e-22,  2.743464553228158e-23, -1.890357610250471e-24,
  1.141389964785009e-25, -6.133151446268704e-27,  2.968963214351618e-28, -1.305729008258920e-29,  8.809294109387641e-19, -3.861700600457303e-19,  9.085287057204196e-20,
 -1.452498384998005e-20,  1.755625960846764e-21, -1.704746134082600e-22,  1.382948065962083e-23, -9.632512591569733e-25,  5.877739900481142e-26, -3.191044496233094e-27,
  1.560344472886949e-28, -6.929764584681620e-30,  3.198113294053279e-19, -1.409932238790242e-19,  3.338402793437369e-20, -5.371937921169967e-21,  6.534834275021737e-22,
 -6.385588303105042e-23,  5.212296991969149e-24, -3.652459526770785e-25,  2.241911025613605e-26, -1.224173373633210e-27,  6.019678107297227e-29, -2.688120130396860e-30,
  5.666548154861770e-02, -1.324655510226169e-04,  3.201277532093043e-07, -7.957496617468195e-10,  2.021730823859711e-12, -5.219267512890246e-15,  1.361643212612797e-17,
 -3.576333054642522e-20,  9.423554671929331e-23, -2.487252692996242e-25,  6.560909848396450e-28, -1.729858525705645e-30,  5.316114561415793e-02, -1.518950556789941e-04,
  5.142940652209954e-07, -1.827987057901658e-09,  6.479465965825962e-12, -2.258397314172308e-14,  7.727643956580024e-17, -2.600302377420542e-19,  8.622436655325400e-22,
 -2.822890991498384e-24,  9.137852205863736e-27, -2.928340357105686e-29,  4.679200690842016e-02, -1.823817312396295e-04,  8.671751691760060e-07, -4.011723421501349e-09,
  1.768332440706829e-11, -7.491183571316714e-14,  3.074904262678224e-16, -1.229816055600294e-18,  4.811337229692613e-21, -1.846534740196636e-23,  6.967559492595647e-26,
 -2.589441490424723e-28,  3.864583598578503e-02, -2.110687535979174e-04,  1.308218098306799e-06, -7.403376056294505e-09,  3.904525712383936e-11, -1.955241612853138e-13,
  9.398194361995475e-16, -4.366770538866219e-18,  1.971240280353478e-20, -8.678387953015570e-23,  3.737275094523663e-25, -1.578039957718913e-27,  2.995481250247541e-02,
 -2.262433649942120e-04,  1.740258178692878e-06, -1.175886675185319e-08,  7.296106811396141e-11, -4.250956218596320e-13,  2.355854448903709e-15, -1.252705537651585e-17,
  6.431591065104406e-20, -3.203419607091542e-22,  1.553582101538004e-24, -7.357737020757448e-27,  2.179570193624657e-02, -2.218021952540494e-04,  2.061848347675828e-06,
 -1.641791539678546e-08,  1.184073155340806e-10, -7.932118173439254e-13,  5.011471621130992e-15, -3.017187419144362e-17,  1.743946965573328e-19, -9.731515489880782e-22,
  5.265251477231961e-24, -2.771583371073411e-26,  1.489199783778083e-02, -1.986400508349642e-04,  2.198029651900084e-06, -2.042415786930720e-08,  1.695588140232884e-10,
 -1.294088341611928e-12,  9.241162275216487e-15, -6.248532860153375e-17,  4.034735129097741e-19, -2.503790253397272e-21,  1.500578580481971e-23, -8.719163852974553e-26,
  9.558342061268009e-03, -1.629425936444998e-04,  2.124686970772727e-06, -2.284772725436967e-08,  2.166121233420524e-10, -1.869738193362379e-12,  1.498879361658336e-14,
 -1.130926710394138e-16,  8.107993403410148e-19, -5.562633403714905e-21,  3.672046839215156e-23, -2.342394345586977e-25,  5.765860403947340e-03, -1.228723847714206e-04,
  1.873136228002656e-06, -2.314202998662980e-08,  2.489014722478346e-10, -2.415228256424349e-12,  2.161364135632786e-14, -1.810143279121053e-16,  1.433666709844112e-18,
 -1.082201825144005e-20,  7.832354853498074e-23, -5.460577642269281e-25,  3.270695097882387e-03, -8.548873874041936e-05,  1.513088111340616e-06, -2.134035652977787e-08,
  2.589168903927561e-10, -2.809962462181161e-12,  2.793783209881109e-14, -2.585576584079565e-16,  2.252738015203553e-18, -1.863405651715261e-20,  1.472857601192599e-22,
 -1.118082026776694e-24,  1.745800186708271e-03, -5.506256420507918e-05,  1.124249851509150e-06, -1.799840635513573e-08,  2.451245274045840e-10, -2.962164829806686e-12,
  3.258705914100007e-14, -3.319887724945297e-16,  3.170426136849835e-18, -2.863827477953259e-20,  2.463919285172649e-22, -2.030088680554279e-24,  8.775215812741351e-04,
 -3.293184609466946e-05,  7.709775928921479e-07, -1.393872751339852e-08,  2.121634138100037e-10, -2.843642427797444e-12,  3.449002546968531e-14, -3.855034497043255e-16,
  4.022426757155929e-18, -3.955858705228232e-20,  3.693964889591508e-22, -3.294196039126729e-24,  4.157299098984924e-04, -1.833963797213785e-05,  4.894882652418783e-07,
 -9.947411251145790e-09,  1.685541504643479e-10, -2.496913683478593e-12,  3.328237012820700e-14, -4.069237883431549e-16,  4.626177149267805e-18, -4.940185090616861e-20,
  4.994167801307646e-22, -4.808678238276114e-24,  1.858203427968965e-04, -9.534515783143033e-06,  2.885476769858239e-07, -6.563128229393921e-09,  1.233555868385095e-10,
 -2.013269974543391e-12,  2.940700886982388e-14, -3.922408413841879e-16,  4.846432852837354e-18, -5.606345014063506e-20,  6.121856031339618e-22, -6.350472320665467e-24,
  7.845228544233489e-05, -4.638789275570593e-06,  1.583677473309002e-07, -4.015686630862718e-09,  8.344195397855984e-11, -1.496033483251771e-12,  2.388275364791799e-14,
 -3.466848181341744e-16,  4.644920172956439e-18, -5.808189734182492e-20,  6.836599642993542e-22, -7.625572586477290e-24,  3.132716558366886e-05, -2.117138233176897e-06,
  8.114501974841939e-08, -2.285300833606779e-09,  5.233637694416578e-11, -1.028023217014083e-12,  1.789312788562090e-14, -2.820441340718552e-16,  4.089142247600666e-18,
 -5.516319160341816e-20,  6.986131797969678e-22, -8.363822405891795e-24,  1.184927921360871e-05, -9.086029114659344e-07,  3.891986504575184e-08, -1.213188949058402e-09,
  3.053287698856844e-11, -6.554143955546366e-13,  1.240964251182449e-14, -2.119693835222885e-16,  3.319144245639430e-18, -4.821854787050567e-20,  6.559130878154894e-22,
 -8.414716450671426e-24,  4.252644087340277e-06, -3.675748201653745e-07,  1.752188014921824e-08, -6.025407460287397e-10,  1.661955714780343e-11, -3.889445610504820e-13,
  7.994127926987772e-15, -1.476823037876756e-16,  2.493108408644313e-18, -3.893770133382452e-20,  5.680109354948137e-22, -7.796790138864731e-24,  1.450984019553024e-06,
 -1.405324332282396e-07,  7.425276785928258e-09, -2.808115986665151e-10,  8.466754644570839e-12, -2.155408579462275e-13,  4.799351729967825e-15, -9.571734986056815e-17,
  1.739121503984587e-18, -2.915506990214652e-20,  4.554141465693561e-22, -6.679034733594795e-24,  4.716869027514324e-07, -5.091495759750923e-08,  2.970612408059842e-09,
 -1.231852634076152e-10,  4.050006463022819e-12, -1.119130806962867e-13,  2.694465519031313e-15, -5.791298151315502e-17,  1.130691581247756e-18, -2.031568855581928e-20,
  3.393244843826133e-22, -5.309882781355390e-24,  1.464560755923132e-07, -1.753141707299894e-08,  1.125472054487298e-09, -5.103032508158042e-11,  1.825109333748342e-12,
 -5.462983184767610e-14,  1.419583257416081e-15, -3.282710731141383e-17,  6.876372855905179e-19, -1.322282646189565e-20,  2.358357100180939e-22, -3.932609420482933e-24,
  4.355477633280047e-08, -5.755215841064524e-09,  4.051603292543002e-10, -2.003180885014719e-11,  7.775840953552668e-13, -2.516140408013690e-14,  7.044154180948206e-16,
 -1.749698555929882e-17,  3.926427806363682e-19, -8.069240526275891e-21,  1.534785261222400e-22, -2.723807307758048e-24,  1.244526523884945e-08, -1.807482123811946e-09,
  1.390861733168115e-10, -7.478861882602872e-12,  3.143831380980996e-13, -1.097599236937131e-14,  3.304763471366610e-16, -8.803291855852159e-18,  2.113236696133403e-19,
 -4.635079133118927e-21,  9.389455000535432e-23, -1.771302073098902e-24,  3.428834008998578e-09, -5.451214171119011e-10,  4.570880780200940e-11, -2.666243585221135e-12,
  1.211069769815401e-13, -4.553168892619125e-15,  1.471841953085669e-16, -4.198075425525802e-18,  1.076435272120349e-19, -2.516394555431284e-21,  5.422160005209119e-23,
 -1.085968201350896e-24,  9.144971365278021e-10, -1.585339124193555e-10,  1.444178978205042e-11, -9.115534029246762e-13,  4.464343434512853e-14, -1.803974060131739e-15,
  6.249972046870001e-17, -1.905743974939925e-18,  5.211954359041594e-20, -1.296815015154592e-21,  2.968387424813657e-23, -6.304100453976351e-25,  2.371562034165098e-10,
 -4.466291335735409e-11,  4.407226754789423e-12, -3.002715631839228e-13,  1.582194271221486e-14, -6.858451519935372e-16,  2.542246229154044e-17, -8.273824509407874e-19,
  2.409877136574156e-20, -6.373140446927998e-22,  1.547650852832769e-23, -3.480869055368300e-25,  6.009603498439761e-11, -1.225057840698158e-11,  1.305695500017098e-12,
 -9.578762406960034e-14,  5.418563828737371e-15, -2.514774132983303e-16,  9.955515403484520e-18, -3.452578148601951e-19,  1.069354622460124e-20, -3.001499959562392e-22,
  7.722266862627467e-24, -1.836994910417620e-25,  1.496221805562298e-11, -3.289728547669797e-12,  3.776314939462136e-13, -2.975637838251477e-14,  1.803139798785584e-15,
 -8.941878486137794e-17,  3.773759018554169e-18, -1.392226606722201e-19,  4.578148678639558e-21, -1.361807789137750e-22,  3.706752388644384e-24, -9.313562050728626e-26,
  3.682271843828221e-12, -8.701681409351743e-13,  1.072720569680828e-13, -9.056348308049817e-15,  5.865422584195720e-16, -3.101641001901070e-17,  1.392817764041754e-18,
 -5.456555567529967e-20,  1.901862177303051e-21, -5.985933588006195e-23,  1.721200718302357e-24, -4.561312899781856e-26,  9.017761172124184e-13, -2.282341732917126e-13,
  3.012843563526066e-14, -2.718204039374004e-15,  1.877217655354554e-16, -1.056260064766352e-17,  5.036953451857073e-19, -2.091567740372301e-20,  7.713465496524355e-22,
 -2.564510856188441e-23,  7.777397456814599e-25, -2.170520030058974e-26,  2.213636387521642e-13, -5.979206240424869e-14,  8.426787101558964e-15, -8.103151091017134e-16,
  5.952773576258632e-17, -3.556016447610880e-18,  1.796977762595258e-19, -7.893450182621178e-21,  3.074304782697140e-22, -1.077774266752252e-23,  3.441475714584723e-25,
 -1.009786799312499e-26,  5.489927593934791e-14, -1.576879431738986e-14,  2.365434051088090e-15, -2.417623728428568e-16,  1.884428916356823e-17, -1.192282642638721e-18,
  6.370421772237337e-20, -2.953877290012100e-21,  1.212548861848961e-22, -4.473720253305849e-24,  1.501306411555891e-25, -4.623110720748886e-27,  1.387270683752411e-14,
 -4.221787845651858e-15,  6.719294919771723e-16, -7.278264446291705e-17,  6.003060720471710e-18, -4.012604534945735e-19,  2.261433518212649e-20, -1.104377336580815e-21,
  4.767651091224048e-23, -1.847374171237510e-24,  6.502275689362561e-26, -2.097324818117403e-27,  3.604096409348356e-15, -1.157724886180492e-15,  1.948532198628664e-16,
 -2.230016295872718e-17,  1.940705572114024e-18, -1.366747096364316e-19,  8.103872059066522e-21, -4.157805705584933e-22,  1.883232613501588e-23, -7.646222438923609e-25,
  2.816528565424610e-26, -9.495696141510736e-28,  9.717481101316213e-16, -3.282182501822924e-16,  5.821416810980277e-17, -7.016405937450566e-18,  6.423031177862593e-19,
 -4.751989592748895e-20,  2.956073294867380e-21, -1.589141984357329e-22,  7.532469737709918e-24, -3.196647537214150e-25,  1.229352639747177e-26, -4.322062059695532e-28,
  2.745435706321328e-16, -9.711769768733075e-17,  1.808576733019337e-17, -2.287743218338534e-18,  2.195723944727460e-19, -1.701194479384616e-20,  1.106924117485796e-21,
 -6.216978456511894e-23,  3.075187489484330e-24, -1.360399551314071e-25,  5.447821760505291e-27, -1.992200536175314e-28,  8.205883848699558e-17, -3.027736864217504e-17,
  5.897268516648902e-18, -7.800197845918803e-19,  7.821475675301440e-20, -6.324599089100696e-21,  4.290444450269959e-22, -2.509620928712316e-23,  1.291496479089497e-24,
 -5.938030353084702e-26,  2.469043079859805e-27, -9.365377723741184e-29,  2.618508613766911e-17, -1.003527467189850e-17,  2.036036271306181e-18, -2.804915039877389e-19,
  2.927335420487419e-20, -2.461496472978180e-21,  1.734767170635981e-22, -1.053192474562777e-23,  5.620147670306950e-25, -2.677045893735391e-26,  1.152169436678380e-27,
 -4.519411581208261e-29,  8.992721231930165e-18, -3.564318027600427e-18,  7.500504169735777e-19, -1.071743064686361e-19,  1.159460566273424e-20, -1.009863597418322e-21,
  7.365920364725866e-23, -4.624375488702775e-24,  2.549723972769276e-25, -1.253860407747753e-26,  5.566913201047717e-28, -2.250711911470401e-29,  3.343843113221126e-18,
 -1.364654379459845e-18,  2.965064277001736e-19, -4.374998744618583e-20,  4.885216061203952e-21, -4.388850364850255e-22,  3.299657726022496e-23, -2.133709739442416e-24,
  1.210887009503794e-25, -6.124643291938069e-27,  2.794905157421769e-28, -1.160571677206474e-29,  1.349320285859828e-18, -5.644467935450251e-19,  1.260319173188978e-19,
 -1.911348588734872e-20,  2.192819164709224e-21, -2.023002398839771e-22,  1.560936112632097e-23, -1.035281237254399e-24,  6.022396511480504e-26, -3.120532006797238e-27,
  1.457946532801508e-28, -6.194375339394394e-30,  5.880812819552723e-19, -2.510036693306589e-19,  5.731237919754792e-20, -8.889904393806622e-21,  1.042869051212886e-21,
 -9.833544681284262e-23,  7.751386211676391e-24, -5.249514572238714e-25,  3.116604094134813e-26, -1.647325889765216e-27,  7.847329995033185e-29, -3.397661781426147e-30,
  2.713895937520668e-19, -1.176371254553913e-19,  2.732844736169257e-20, -4.313603028787594e-21,  5.148297978068212e-22, -4.937386443353227e-23,  3.956967770268940e-24,
 -2.723544560989387e-25,  1.642721240827395e-26, -8.817888768125379e-28,  4.264306412405560e-29, -1.873578041834672e-30,  1.247582785241105e-19, -5.466128920174660e-20,
  1.285240513087038e-20, -2.053538262671849e-21,  2.480636489775313e-22, -2.407350350144153e-23,  1.951816836109194e-24, -1.358725664412091e-25,  8.286421414623019e-27,
 -4.496342471996368e-28,  2.197466193060425e-29, -9.754415292430264e-31,  4.465477503191414e-20, -1.968219105606376e-20,  4.659096268061809e-21, -7.495135903154194e-22,
  9.115260118032388e-23, -8.904767939265231e-24,  7.266740187971156e-25, -5.090804402292534e-26,  3.124004707452202e-27, -1.705416051277037e-28,  8.384102703842249e-30,
 -3.743087476620971e-31,  5.614068167763279e-02, -1.299421828895162e-04,  3.107694553109384e-07, -7.642196299801611e-10,  1.920534032691160e-12, -4.904156961317468e-15,
  1.265596556207467e-17, -3.288613890534487e-20,  8.573604831780967e-23, -2.239417934529373e-25,  5.845692492991947e-28, -1.525706051367213e-30,  5.256165761313571e-02,
 -1.478667178062822e-04,  4.929656636208542e-07, -1.727830690245938e-09,  6.045758824038182e-12, -2.081368231843984e-14,  7.036708931243249e-17, -2.339963252397845e-19,
  7.668998934858287e-22, -2.481885213092433e-24,  7.942418520705498e-27, -2.516505300174799e-29,  4.607605653867382e-02, -1.756321940640277e-04,  8.206839130357825e-07,
 -3.740386559710712e-09,  1.625618354837299e-11, -6.792848141966128e-14,  2.751148310313836e-16, -1.085972917409247e-18,  4.194122853950789e-21, -1.589339818499397e-23,
  5.922429125356575e-26, -2.173966019860135e-28,  3.782194441571846e-02, -2.009480399881103e-04,  1.223000743586000e-06, -6.808750608802567e-09,  3.535078322768390e-11,
 -1.743672365597635e-13,  8.259311529059063e-16, -3.783206462414095e-18,  1.684134016546409e-20, -7.313572590841397e-23,  3.107415242256181e-25, -1.294804265557903e-27,
  2.907681668908249e-02, -2.128665065203239e-04,  1.605885112157412e-06, -1.065654813313387e-08,  6.499730761311247e-11, -3.725418815771505e-13,  2.032258713944935e-15,
 -1.064207508861078e-17,  5.382834146463255e-20, -2.642190354205720e-22,  1.263180156129161e-24, -5.898810907463010e-27,  2.094027889783259e-02, -2.060644262280006e-04,
  1.875697355466363e-06, -1.464405357159068e-08,  1.036805293961299e-10, -6.824746115218567e-13,  4.239797824174345e-15, -2.511340168289850e-17,  1.428756964001165e-19,
 -7.850463901266616e-22,  4.183779545152379e-24, -2.169901966183015e-26,  1.413111648524828e-02, -1.819919447735139e-04,  1.968400775549024e-06, -1.790679014331604e-08,
  1.457604106066495e-10, -1.091915879962738e-12,  7.659563112392220e-15, -5.090762199397847e-17,  3.232764918492086e-19, -1.973801837184559e-21,  1.164332154028454e-23,
 -6.661188286849946e-26,  8.938909836739782e-03, -1.469855904448938e-04,  1.870135473250857e-06, -1.966257217381276e-08,  1.825725781504794e-10, -1.545249811396048e-12,
  1.215724203783393e-14, -9.008668489585544e-17,  6.346744704479329e-19, -4.280993756514790e-21,  2.779615865264066e-23, -1.744668063135551e-25,  5.302673208940636e-03,
 -1.089339074145349e-04,  1.617819161200025e-06, -1.951949315793723e-08,  2.053989804621799e-10, -1.952477013678064e-12,  1.713300737015108e-14, -1.408098757565344e-16,
  1.095119051846436e-18, -8.121770177222645e-21,  5.777881889795718e-23, -3.961222679865656e-25,  2.951421762456751e-03, -7.434199167422277e-05,  1.280116899280825e-06,
 -1.761317181623130e-08,  2.088759216737702e-10, -2.218765416624331e-12,  2.161417824902593e-14, -1.961559368700602e-16,  1.677079940929178e-18, -1.362088994126987e-20,
  1.057634862540445e-22, -7.890812351157600e-25,  1.542258569855999e-03, -4.687005633343336e-05,  9.299753843110691e-07, -1.451083260710559e-08,  1.930046153576334e-10,
 -2.281048082549431e-12,  2.456934655484851e-14, -2.452906357564559e-16,  2.297235471516103e-18, -2.036286284035913e-20,  1.720126645098750e-22, -1.392199743545712e-24,
  7.571466142434678e-04, -2.737942317387281e-05,  6.223399996930562e-07, -1.095754490133737e-08,  1.627637866387872e-10, -2.132086405451224e-12,  2.530268440700843e-14,
 -2.769811407112578e-16,  2.832681533350488e-18, -2.732296152484542e-20,  2.503856358454233e-22, -2.192399282130889e-24,  3.495072210902032e-04, -1.485889228159508e-05,
  3.847832466242035e-07, -7.610243545029744e-09,  1.257606940080760e-10, -1.819649993733405e-12,  2.371893150230793e-14, -2.838652673673487e-16,  3.161503162935104e-18,
 -3.309713238021859e-20,  3.282094677808666e-22, -3.101633123285809e-24,  1.518438713627262e-04, -7.510440173355170e-06,  2.204182386470278e-07, -4.876656464826322e-09,
  8.934149815427055e-11, -1.423478523277003e-12,  2.032282397027457e-14, -2.652190593549040e-16,  3.208921456024039e-18, -3.637617760256299e-20,  3.894904821516548e-22,
 -3.964083493887159e-24,  6.215510003660795e-05, -3.543990918987971e-06,  1.172950929715987e-07, -2.891858884491287e-09,  5.854610799582094e-11, -1.024295875115109e-12,
  1.597630270106218e-14, -2.268182726812398e-16,  2.974737978467311e-18, -3.643875442400250e-20,  4.204367158677054e-22, -4.599667541361324e-24,  2.400146301204117e-05,
 -1.564860351701853e-06,  5.813604332570050e-08, -1.591510653794256e-09,  3.549986733759008e-11, -6.802272090768949e-13,  1.156393114881719e-14, -1.782188858543242e-16,
  2.528536113002037e-18, -3.340558519276393e-20,  4.146028500638190e-22, -4.867316576265996e-24,  8.755915408945557e-06, -6.480724213337408e-07,  2.690756324086239e-08,
 -8.151679608858186e-10,  1.997798442610430e-11, -4.182420233274482e-13,  7.732813996384029e-15, -1.291129112648954e-16,  1.978008056298095e-18, -2.813579423288688e-20,
  3.750017249224340e-22, -4.716698035094085e-24,  3.022581781611610e-06, -2.523310593029504e-07,  1.166044807200997e-08, -3.896935326652986e-10,  1.046592977823454e-11,
 -2.388452756112873e-13,  4.792965106569471e-15, -8.653996005223201e-17,  1.429135054556388e-18, -2.185179494948471e-20,  3.122920339481582e-22, -4.202249682960560e-24,
  9.891825266626808e-07, -9.259728454677246e-08,  4.744119291437614e-09, -1.743810857530525e-10,  5.119496039134682e-12, -1.270858123148625e-13,  2.762689728619726e-15,
 -5.384796616905192e-17,  9.570301842605438e-19, -1.570611037375430e-20,  2.403392534257668e-22, -3.455199009469924e-24,  3.075514607912507e-07, -3.211109551986428e-08,
  1.817362111477594e-09, -7.326326036646724e-11,  2.345640508935932e-12, -6.320841831461314e-14,  1.485825725962523e-15, -3.121136550149258e-17,  5.960837831061767e-19,
 -1.048483601773894e-20,  1.715604968761764e-22, -2.631710789251787e-24,  9.106447267974511e-08, -1.055306477307920e-08,  6.575019522876125e-10, -2.899104581145015e-11,
  1.009957501033754e-12, -2.948550696569960e-14,  7.481731067021582e-16, -1.691093320569138e-17,  3.465510803998438e-19, -6.524429055785044e-21,  1.140096713026018e-22,
 -1.863828784979194e-24,  2.574884963106886e-08, -3.296968704111013e-09,  2.253952376623322e-10, -1.084182111730124e-11,  4.100686832948888e-13, -1.294584666351249e-14,
  3.539903155517712e-16, -8.596316611207036e-18,  1.887577821661886e-19, -3.798659729603323e-21,  7.080046503894903e-23, -1.232064020600052e-24,  6.974128011993201e-09,
 -9.825160061384128e-10,  7.347264578782750e-11, -3.845755839889203e-12,  1.575902003004925e-13, -5.369923392606062e-15,  1.579719758091058e-16, -4.115344191128701e-18,
  9.669239661265615e-20, -2.077351124591775e-21,  4.124744334025171e-23, -7.631814001568268e-25,  1.815794061390449e-09, -2.803367179346996e-10,  2.286235238329336e-11,
 -1.299015098622066e-12,  5.755088548461820e-14, -2.112834599067850e-15,  6.676078892467798e-17, -1.862985563938452e-18,  4.677311469500495e-20, -1.071403306116260e-21,
  2.263607739360715e-23, -4.448059641699568e-25,  4.562515493831507e-10, -7.690168789973226e-11,  6.819823334610271e-12, -4.196281511880263e-13,  2.005863185072233e-14,
 -7.919620308414693e-16,  2.683485237605506e-17, -8.009509013812355e-19,  2.145848293070152e-20, -5.234074657652358e-22,  1.175239793113018e-23, -2.449836424078142e-25,
  1.111309655200175e-10, -2.037523886674903e-11,  1.959335579647788e-12, -1.302484860697004e-13,  6.703785238593237e-15, -2.841353366216258e-16,  1.030737688543629e-17,
 -3.285659741085079e-19,  9.380348113730122e-21, -2.433211243978482e-22,  5.799258483776721e-24, -1.280904895897760e-25,  2.637101454670931e-11, -5.240754141786843e-12,
  5.449549743467652e-13, -3.904583868229670e-14,  2.159431418181243e-15, -9.807280571794906e-17,  3.802550526225123e-18, -1.292559979636778e-19,  3.926726806592840e-21,
 -1.081758186085621e-22,  2.733249969275198e-24, -6.389000365573208e-26,  6.130618804985103e-12, -1.316019217460764e-12,  1.475668936597014e-13, -1.136907188144196e-14,
  6.742159786158697e-16, -3.274875925210548e-17,  1.354808480960419e-18, -4.903029443782036e-20,  1.582645424412496e-21, -4.623972317247438e-23,  1.236932565292502e-24,
 -3.056038373557483e-26,  1.404973463741764e-12, -3.246545579529182e-13,  3.914734027505883e-14, -3.235304466627949e-15,  2.052893975479617e-16, -1.064395177087945e-17,
  4.689909364795657e-19, -1.804008825666659e-20,  6.177586195442022e-22, -1.911358012886793e-23,  5.405622777522453e-25, -1.409724206642340e-26,  3.196032938664542e-13,
 -7.922514681663268e-14,  1.024411822683162e-14, -9.059229423135137e-16,  6.136961238232892e-17, -3.389577998352565e-18,  1.587692650310258e-19, -6.479814267922814e-21,
  2.350079640441309e-22, -7.688007220117301e-24,  2.295295674250348e-25, -6.309232337217566e-27,  7.271612256912698e-14, -1.926944287428836e-14,  2.664146119602738e-15,
 -2.514582374226898e-16,  1.814373083856511e-17, -1.065223507361372e-18,  5.293587343138469e-20, -2.287967244301354e-21,  8.772743875573958e-23, -3.029269555249200e-24,
  9.531900538158280e-26, -2.757328821915955e-27,  1.668521132054798e-14, -4.709971872902081e-15,  6.942057885508848e-16, -6.974656980397179e-17,  5.347032650096737e-18,
 -3.329310945109471e-19,  1.751535988375235e-20, -8.000933372877748e-22,  3.237084297856326e-23, -1.177680719694187e-24,  3.898688117194116e-26, -1.184836245095135e-27,
  3.896014139339910e-15, -1.167292059270393e-15,  1.828431099253676e-16, -1.949896255533673e-17,  1.584134818950228e-18, -1.043504285996484e-19,  5.798386926716179e-21,
 -2.793149983714115e-22,  1.189933432604132e-23, -4.551900798118054e-25,  1.582311830200784e-26, -5.042544940696496e-28,  9.347198298221385e-16, -2.961357470464735e-16,
  4.913594169868920e-17, -5.545303372285386e-18,  4.760762160226398e-19, -3.308933868560470e-20,  1.937119828708931e-21, -9.816720873841329e-23,  4.393505858227109e-24,
 -1.763266430260305e-25,  6.422440529115788e-27, -2.141803564148765e-28,  2.327723679819909e-16, -7.768114374415104e-17,  1.360611525791273e-17, -1.619792180472147e-18,
  1.465100072692847e-19, -1.071374137967014e-20,  6.589839444328333e-22, -3.504027082520325e-23,  1.643359576488250e-24, -6.902708300213003e-26,  2.628232295916843e-27,
 -9.151146823932874e-29,  6.080561060551434e-17, -2.128963691942726e-17,  3.921999527908299e-18, -4.908373269637400e-19,  4.662121486570959e-20, -3.575732209988349e-21,
  2.303908742098334e-22, -1.281715878306458e-23,  6.281644009115036e-25, -2.754083281630769e-26,  1.093344463007129e-27, -3.964677579604147e-29,  1.683946624755560e-17,
 -6.160229937533873e-18,  1.188963962028627e-18, -1.558472447029418e-19,  1.548991516622425e-20, -1.241839867066376e-21,  8.354401740648598e-23, -4.847396786378734e-24,
  2.475055791427320e-25, -1.129343033519386e-26,  4.661228976504163e-28, -1.755435534299271e-29,  4.995182390555891e-18, -1.901098066550359e-18,  3.828378972832568e-19,
 -5.235076499930701e-20,  5.423994201526762e-21, -4.528691322267901e-22,  3.169773703597360e-23, -1.911590141304671e-24,  1.013489414203600e-25, -4.797264546506576e-27,
  2.052105368816822e-28, -8.001893341941325e-30,  1.601985228205071e-18, -6.315023655450537e-19,  1.321054487098119e-19, -1.876551459313171e-20,  2.018442463016210e-21,
 -1.748144618257207e-22,  1.268128072638088e-23, -7.919141055127718e-25,  4.343834933871820e-26, -2.125440659262432e-27,  9.390665215413947e-29, -3.778759580263850e-30,
  5.595500851843218e-19, -2.274253646927844e-19,  4.919339847775190e-20, -7.226157220108651e-21,  8.033518818409692e-22, -7.186407493979313e-23,  5.380451612375678e-24,
 -3.465167483309909e-25,  1.958759946381024e-26, -9.869509913366041e-28,  4.487104184580069e-29, -1.856542740137228e-30,  2.136367634246127e-19, -8.910991805079199e-20,
  1.983337075424584e-20, -2.998232255455062e-21,  3.428949999139377e-22, -3.153694416080814e-23,  2.426095327747183e-24, -1.604411862242481e-25,  9.306719719974994e-27,
 -4.809057524799369e-28,  2.240837403961220e-29, -9.495964644694086e-31,  8.885346941998940e-20, -3.785248155557861e-20,  8.624798546903041e-21, -1.334993447449154e-21,
  1.562814846156643e-22, -1.470630772999764e-23,  1.156940061764940e-24, -7.820080745594447e-26,  4.634009592708527e-27, -2.444895039799027e-28,  1.162598317609344e-29,
 -5.025024222379811e-31,  3.951205362272630e-20, -1.710803823822724e-20,  3.969479526671710e-21, -6.257737712384392e-22,  7.459449819275151e-23, -7.145246905460178e-24,
  5.719683563106212e-25, -3.932295280492941e-26,  2.369138476134304e-27, -1.270336385673297e-28,  6.136806308515471e-30, -2.693512537002160e-31,  1.769134475352844e-20,
 -7.746980900561407e-21,  1.820406273245801e-21, -2.906798321519185e-22,  3.509185108824880e-23, -3.403441591655205e-24,  2.757778868919119e-25, -1.918665711787668e-26,
  1.169465825187281e-27, -6.342181425939826e-29,  3.097889460941248e-30, -1.374407816478827e-31,  6.238623003819883e-21, -2.749106354826923e-21,  6.505837021130816e-22,
 -1.046314390541364e-22,  1.272135545277857e-23, -1.242424176990479e-24,  1.013611604705620e-25, -7.099125298446888e-27,  4.355304187546013e-28, -2.376990509676206e-29,
  1.168277128073615e-30, -5.214511530833878e-32,  5.562582790445816e-02, -1.274921947526401e-04,  3.017800068913065e-07, -7.342595547840589e-10,  1.825415310638526e-12,
 -4.611160799993618e-15,  1.177238287971677e-17, -3.026719098556056e-20,  7.807935200095722e-23, -2.018474111925505e-25,  5.214481839920875e-28, -1.347391893705444e-30,
  5.197794915799454e-02, -1.440043149755548e-04,  4.727986424163912e-07, -1.634339158337569e-09,  5.645856564745415e-12, -1.920080224788624e-14,  6.414575632218724e-17,
 -2.108258798888012e-19,  6.830135528595861e-22, -2.185261668199780e-24,  6.914257555409162e-27, -2.166252592769354e-29,  4.538638054476828e-02, -1.692419406034436e-04,
  7.773161696212537e-07, -3.490807502447236e-09,  1.496125468724469e-11, -6.167595920982821e-14,  2.465036958305465e-16, -9.604764371831769e-19,  3.662394265439110e-21,
 -1.370511716257583e-23,  5.044085081456323e-26, -1.829019171523385e-28,  3.703721603648744e-02, -1.914814968709831e-04,  1.144577721989674e-06, -6.269994771616196e-09,
  3.205338637205055e-11, -1.557574976737974e-13,  7.271669609347904e-16, -3.284117942201075e-18,  1.441911153186743e-20, -6.177439827730933e-23,  2.589964603085072e-25,
 -1.065125621258132e-27,  2.825025916062125e-02, -2.005138102012937e-04,  1.484008714079003e-06, -9.673645766942929e-09,  5.801104572500017e-11, -3.271572188861732e-13,
  1.757032448257958e-15, -9.062492337557517e-18,  4.516670503877180e-20, -2.185231741852412e-22,  1.030019891718208e-24, -4.743490948849129e-27,  2.014495789202425e-02,
 -1.917345634438898e-04,  1.709488887509730e-06, -1.308906245084404e-08,  9.099419475688119e-11, -5.886659318005230e-13,  3.596602115859431e-15, -2.096304597550664e-17,
  1.174096661149253e-19, -6.353345584865409e-22,  3.335647658035319e-24, -1.704830180664507e-26,  1.343333606521785e-02, -1.670662148081438e-04,  1.766822707406471e-06,
 -1.573980646396728e-08,  1.256507037076146e-10, -9.240849377348448e-13,  6.368904470230727e-15, -4.161523179802930e-17,  2.599415296282230e-19, -1.561802450424230e-21,
  9.069507169540306e-24, -5.109594499647670e-26,  8.379462422979348e-03, -1.329209002618078e-04,  1.650740814209233e-06, -1.697361593669034e-08,  1.543922867082308e-10,
 -1.281585232625430e-12,  9.897427433860617e-15, -7.204253089085445e-17,  4.988503521202080e-19, -3.308768300236013e-21,  2.113449919456562e-23, -1.305468914256817e-25,
  4.891414339885885e-03, -9.687525026549605e-05,  1.402083781934145e-06, -1.652443692680492e-08,  1.701613797817791e-10, -1.584892024643270e-12,  1.363998223749634e-14,
 -1.100301465517098e-16,  8.404516620656924e-19, -6.125023402517090e-21,  4.283835885541501e-23, -2.888538815520288e-25,  2.673273046905433e-03, -6.489287273188772e-05,
  1.087432987207433e-06, -1.459973847674275e-08,  1.692726541987706e-10, -1.760294703179280e-12,  1.680487781961455e-14, -1.495819123843115e-16,  1.255189873075763e-18,
 -1.001132701153199e-20,  7.637851329521219e-23, -5.601440027131573e-25,  1.368624918702058e-03, -4.007754602550329e-05,  7.729660865177051e-07, -1.175788197548159e-08,
  1.527641979328684e-10, -1.766127294970329e-12,  1.862898254132702e-14, -1.822914090546153e-16,  1.674548972937614e-18, -1.456829373672818e-20,  1.208488583033571e-22,
 -9.609564844647284e-25,  6.568120716374203e-04, -2.288543236986531e-05,  5.051677005931549e-07, -8.663927013343378e-09,  1.256158273439875e-10, -1.608488829251231e-12,
  1.868114222594676e-14, -2.003145555348939e-16,  2.008264589296005e-18, -1.900195801728054e-20,  1.709136339809386e-22, -1.469619158462684e-24,  2.956946886378035e-04,
 -1.211428863887103e-05,  3.044256526230863e-07, -5.860796935428315e-09,  9.447115140875742e-11, -1.335358923843722e-12,  1.702456338644737e-14, -1.994722852930017e-16,
  2.176728517123823e-18, -2.234303130255914e-20,  2.173733234735299e-22, -2.016425946834062e-24,  1.249898336312325e-04, -5.958876137618609e-06,  1.696150645307800e-07,
 -3.650778725451818e-09,  6.520308817483933e-11, -1.014351290184231e-12,  1.415702988768739e-14, -1.807905107804794e-16,  2.142281981843053e-18, -2.380094514081338e-20,
  2.499236406989668e-22, -2.495920762886579e-24,  4.965666389350999e-05, -2.729946423789693e-06,  8.759919550473331e-08, -2.100155639859969e-09,  4.143092074404017e-11,
 -7.074240554279047e-13,  1.078189978127344e-14, -1.497282986245739e-16,  1.922452343484228e-18, -2.307142898867873e-20,  2.609751891109039e-22, -2.800698274258045e-24,
  1.856362614323887e-05, -1.167452329760146e-06,  4.204153005518651e-08, -1.118815095175365e-09,  2.430938973354303e-11, -4.544375745105406e-13,  7.546397125088825e-15,
 -1.137236347130497e-16,  1.579104610470635e-18, -2.043321465937265e-20,  2.485520297957115e-22, -2.861566470357923e-24,  6.539103020059663e-06, -4.670817997425297e-07,
  1.879698492487559e-08, -5.534668618418494e-10,  1.320953166472838e-11, -2.697255928500079e-13,  4.870032595610110e-15, -7.949066653447031e-17,  1.191553845058462e-18,
 -1.659667209951314e-20,  2.167550114825087e-22, -2.673107770547141e-24,  2.173794853855807e-06, -1.752322127669327e-07,  7.849416545176971e-09, -2.549432888395030e-10,
  6.666973746001759e-12, -1.483726562967147e-13,  2.907133546906229e-15, -5.130427155692635e-17,  8.288496572333558e-19, -1.240783870259057e-20,  1.737315921357101e-22,
 -2.291829333806926e-24,  6.831841972486048e-07, -6.179419794214087e-08,  3.069546642772933e-09, -1.096567971483864e-10,  3.134585943156812e-12, -7.587635916978297e-14,
  1.610377532441647e-15, -3.067615840295768e-17,  5.333139768094310e-19, -8.568291422236355e-21,  1.284468949117996e-22, -1.810183619742293e-24,  2.034051498558266e-07,
 -2.053564167291542e-08,  1.127215642055940e-09, -4.417123823061754e-11,  1.377098528290330e-12, -3.618666335204107e-14,  8.304825489061783e-16, -1.704938794031224e-17,
  3.185106423548577e-19, -5.484551825606427e-21,  8.791554423257852e-23, -1.322010538775411e-24,  5.750476869411795e-08, -6.449106864971846e-09,  3.898740597890538e-10,
 -1.671473524682913e-11,  5.671132912682347e-13, -1.614742476191694e-14,  4.000644407203185e-16, -8.838220353568033e-18,  1.771807274156533e-19, -3.265754944145070e-21,
  5.590875518341494e-23, -8.960275126979719e-25,  1.547817889717019e-08, -1.919715725864255e-09,  1.274137473590944e-10, -5.961456661761418e-12,  2.196678225482323e-13,
 -6.765052936626836e-15,  1.806558068401559e-16, -4.288627993823237e-18,  9.213656431426763e-20, -1.815575414604238e-21,  3.315731841893862e-23, -5.657378279935301e-25,
  3.978578068604323e-09, -5.434622550766594e-10,  3.948172570086393e-11, -2.011177398740331e-12,  8.032192864183767e-14, -2.670869671792885e-15,  7.675640285482984e-17,
 -1.955255492943424e-18,  4.495927743746304e-20, -9.460104894346851e-22,  1.840943669628053e-23, -3.340454198420982e-25,  9.800032580282768e-10, -1.468598044491724e-10,
  1.164456287469965e-11, -6.442929730809141e-13,  2.783442634672299e-14, -9.976329510250745e-16,  3.080714234333618e-17, -8.409344546593618e-19,  2.066939220160723e-20,
 -4.638574948185419e-22,  9.607832183963740e-24, -1.852082899453561e-25,  2.322318205883012e-10, -3.803861588663812e-11,  3.282666517281844e-12, -1.968351863907779e-13,
  9.180658314950708e-15, -3.540743071585846e-16,  1.173097566885424e-17, -3.426629286815159e-19,  8.991455920703484e-21, -2.149574193481169e-22,  4.733751709210569e-24,
 -9.683894850828355e-26,  5.317898411883980e-11, -9.486981824963056e-12,  8.886503915092596e-13, -5.761631561909300e-14,  2.895671445575691e-15, -1.199671056519319e-16,
  4.257909467817159e-18, -1.329062563159514e-19,  3.718310187610453e-21, -9.458249275159421e-23,  2.211992019696814e-24, -4.796989615718054e-26,  1.182668022735120e-11,
 -2.290016432923483e-12,  2.322095624557406e-13, -1.624274628937413e-14,  8.779123783908480e-16, -3.900374383029159e-17,  1.480666690359844e-18, -4.931752480461418e-20,
  1.469139518747306e-21, -3.971293581904837e-23,  9.851807607541114e-25, -2.262333317499767e-26,  2.568894194898525e-12, -5.380715859975241e-13,  5.890668809414226e-14,
 -4.435353433222633e-15,  2.573050824948301e-16, -1.223703783013962e-17,  4.960715461532213e-19, -1.760510785517663e-20,  5.576504539305198e-22, -1.599820907715089e-23,
  4.204682777327635e-25, -1.021220938041669e-26,  5.484613211121346e-13, -1.238510541480660e-13,  1.459975714974880e-14, -1.180579560070700e-15,  7.336002881329443e-17,
 -3.727878561402171e-18,  1.611073908781623e-19, -6.082509589278254e-21,  2.045663919751358e-22, -6.219948923309531e-24,  1.729656647870620e-25, -4.437611295143320e-27,
  1.159151311328873e-13, -2.812493237475516e-14,  3.560229003765990e-15, -3.084507961997851e-16,  2.048679974656367e-17, -1.110229019646995e-18,  5.105976291522638e-20,
 -2.047380762176421e-21,  7.299636261620092e-23, -2.348855647916870e-24,  6.901296190392093e-26, -1.867829365398122e-27,  2.444255544023346e-14, -6.350604847864558e-15,
  8.608520341239458e-16, -7.971229071179947e-17,  5.646376170847748e-18, -3.256531225590698e-19,  1.590771342794373e-20, -6.762473682842722e-22,  2.551690618687340e-23,
 -8.675428006489498e-25,  2.689074746859112e-26, -7.666336145007776e-28,  5.187219216156533e-15, -1.438162924346344e-15,  2.081557476474606e-16, -2.054705104598317e-17,
  1.548539905148258e-18, -9.484234946588083e-20,  4.910773102861738e-21, -2.208947787008251e-22,  8.805024085898976e-24, -3.157482288680164e-25,  1.030770600397804e-26,
 -3.090457639564755e-28,  1.118470379741248e-15, -3.297214795573204e-16,  5.080118957999287e-17, -5.330968241260326e-18,  4.263889707649844e-19, -2.766632741103977e-20,
  1.515043691012033e-21, -7.195815040370551e-23,  3.023935154139729e-24, -1.141543505359758e-25,  3.917576929532306e-27, -1.233036566066827e-28,  2.475549748454698e-16,
 -7.730966103614140e-17,  1.263897294750777e-17, -1.405850789305816e-18,  1.190083333613128e-19, -8.159620748256966e-21,  4.714219149118806e-22, -2.358707674185486e-23,
  1.042672270690876e-24, -4.134752299334525e-26,  1.488621885058475e-27, -4.908795126075171e-29,  5.686263867218801e-17, -1.873939622480596e-17,  3.239681148934447e-18,
 -3.807609583654246e-19,  3.401253579249923e-20, -2.457291298439061e-21,  1.493820075453984e-22, -7.853405691242612e-24,  3.642864369720303e-25, -1.513894711322381e-26,
  5.704858883668659e-28, -1.966538478013553e-29,  1.371085634674678e-17, -4.749162257374961e-18,  8.650664187948682e-19, -1.070630845155508e-19,  1.005936158103174e-20,
 -7.634390134397088e-22,  4.868959064973092e-23, -2.682006906214227e-24,  1.301876487498007e-25, -5.654935842425843e-27,  2.224755510129808e-28, -7.997065166094822e-30,
  3.511260387000932e-18, -1.272982553613168e-18,  2.433586481350871e-19, -3.159894563251189e-20,  3.111831358311260e-21, -2.472513125735026e-22,  1.648956817689381e-23,
 -9.487169210257468e-25,  4.804598800240168e-26, -2.174943837979939e-27,  8.907883271341889e-29, -3.329779902787034e-30,  9.660971872842305e-19, -3.650010972581846e-19,
  7.292845271158562e-20, -9.895131611209425e-21,  1.017441268985497e-21, -8.432252340873863e-23,  5.859658348008785e-24, -3.509164879996204e-25,  1.847918265341267e-26,
 -8.689574344239301e-28,  3.693426447309526e-29, -1.431311459319053e-30,  2.886494979313887e-19, -1.131330454463768e-19,  2.351973822061596e-20, -3.320320909496314e-21,
  3.549761267153405e-22, -3.056268865793987e-23,  2.204349721804309e-24, -1.368896036683124e-25,  7.468118170210443e-27, -3.634969993815504e-28,  1.597822230381440e-29,
 -6.397801514773440e-31,  9.447732915909559e-20, -3.823407675586976e-20,  8.231310307222393e-21, -1.203432958402300e-21,  1.331715838124922e-22, -1.185929183972020e-23,
  8.840158353955864e-25, -5.669093632902816e-26,  3.191329410604919e-27, -1.601543229017046e-28,  7.252905146482864e-30, -2.989552754672742e-31,  3.404980613879612e-20,
 -1.415905277938095e-20,  3.140795067295791e-21, -4.731954006036473e-22,  5.393792581347143e-23, -4.944756303897919e-24,  3.791948952458232e-25, -2.499985870748058e-26,
  1.445848433762963e-27, -7.449500114214909e-29,  3.461418581363278e-30, -1.462841088513564e-31,  1.348532016587285e-20, -5.733377159222209e-21,  1.303464246426389e-21,
 -2.013070216006046e-22,  2.351431969605907e-23, -2.207980847493544e-24,  1.733376997420963e-25, -1.169252277101504e-26,  6.915011562674651e-28, -3.641320745890558e-29,
  1.728280754728261e-30, -7.456471045891520e-32,  5.768148661268903e-21, -2.494588067951994e-21,  5.780489436813439e-22, -9.100739282618089e-23,  1.083433955151094e-23,
 -1.036480515262138e-24,  8.286620510511929e-26, -5.690190655618357e-27,  3.424207596508078e-28, -1.833964038156175e-29,  8.849732159276572e-31, -3.880043001709716e-32,
  2.512144263332758e-21, -1.099422595867889e-21,  2.581770909065377e-22, -4.119821071120662e-23,  4.970349803618370e-24, -4.817496215715824e-25,  3.901133861166515e-26,
 -2.712471906834542e-27,  1.652320240240380e-28, -8.955550212961655e-30,  4.371923080731075e-31, -1.938571484382905e-32,  8.720994205039673e-22, -3.842040581404400e-22,
  9.089759127271484e-23, -1.461463391893663e-23,  1.776381277211949e-24, -1.734407650144615e-25,  1.414598338638449e-26, -9.904866880432364e-28,  6.075003503705658e-29,
 -3.314681029186406e-30,  1.628727494339431e-31, -7.267863267058956e-33,  5.512063249367433e-02, -1.251127095538138e-04,  2.931411376888692e-07, -7.057756275032906e-10,
  1.735950251710652e-12, -4.338517625261247e-15,  1.095881672662752e-17, -2.788100334455074e-20,  7.117443462710889e-23, -1.821277721368470e-25,  4.656692484670696e-28,
 -1.191443584439182e-30,  5.140937459679808e-02, -1.402988670944020e-04,  4.537161677897152e-07, -1.546995899135851e-09,  5.276769810708393e-12, -1.772974264207867e-14,
  5.853716515615151e-17, -1.901765878853810e-19,  6.091010646771465e-22, -1.926841401547811e-24,  6.028480649597154e-27, -1.867841959083754e-29,  4.472159016379790e-02,
 -1.631869922488429e-04,  7.368230707175708e-07, -3.260983051285208e-09,  1.378478458722896e-11, -5.606978971986642e-14,  2.211796238634163e-16, -8.507997699601661e-19,
  3.203469071282923e-21, -1.183960599311487e-23,  4.304364050464328e-26, -1.541992699618781e-28,  3.628913877689053e-02, -1.826173470653481e-04,  1.072315098202399e-06,
 -5.781143915958842e-09,  2.910556910745680e-11, -1.393588003155833e-13,  6.413508390424553e-16, -2.856377129643619e-18,  1.237094716770787e-20, -5.229408156377053e-23,
  2.163785350496982e-25, -8.783801696649766e-28,  2.747123450102417e-02, -1.890907792911422e-04,  1.373285294348125e-06, -8.795606446991747e-09,  5.186984963551854e-11,
 -2.878771091938413e-13,  1.522389112901258e-15, -7.735466224337125e-18,  3.799381232559908e-20, -1.812111925680890e-22,  8.422577084952377e-25, -3.825725276678732e-27,
  1.940441049099757e-02, -1.786630421829705e-04,  1.560781725852194e-06, -1.172284410655032e-08,  8.003862415065528e-11, -5.089867592655312e-13,  3.058973364444047e-15,
 -1.754753654540047e-17,  9.676890445650450e-20, -5.157827619464853e-22,  2.668191406727975e-24, -1.344044413634878e-26,  1.279219060766637e-02, -1.536543194199595e-04,
  1.589423460397894e-06, -1.386932365109046e-08,  1.086078047877492e-10, -7.843235529767387e-13,  5.312154142473145e-15, -3.413085608995667e-17,  2.097389438068232e-19,
 -1.240291818437436e-21,  7.091471246827960e-24, -3.934913690704422e-26,  7.872957500114543e-03, -1.204895800475979e-04,  1.461073244161914e-06, -1.469614148728186e-08,
  1.309814480250649e-10, -1.066553917768603e-12,  8.086915748341243e-15, -5.783261888818841e-17,  3.936619333110979e-19, -2.568011697056309e-21,  1.613912838530275e-23,
 -9.812295363475281e-26,  4.525153127453722e-03, -8.640776755227972e-05,  1.219134881868468e-06, -1.403864634584005e-08,  1.415024695906553e-10, -1.291656013429197e-12,
  1.090473314486115e-14, -8.635634770358363e-17,  6.479584281738111e-19, -4.641125799457233e-21,  3.191743545654063e-23, -2.117034100322917e-25,  2.430052547817137e-03,
 -5.685069414859489e-05,  9.273917863304531e-07, -1.215245603048770e-08,  1.377827959665850e-10, -1.403011461868411e-12,  1.312866831239427e-14, -1.146377711438543e-16,
  9.443098631571645e-19, -7.397793032565429e-21,  5.546293204587161e-23, -3.998920968280606e-25,  1.219843903892864e-03, -3.441917868906847e-05,  6.454454181920324e-07,
 -9.573575351388960e-09,  1.215285236955533e-10, -1.374679641562281e-12,  1.420237879792435e-14, -1.362411016690600e-16,  1.227788108148003e-18, -1.048539748500029e-20,
  8.542816691873308e-23, -6.674972983572484e-25,  5.727397684019968e-04, -1.922808735692079e-05,  4.122720895273384e-07, -6.888855779276091e-09,  9.751022192650465e-11,
 -1.220773081896687e-12,  1.387792054891011e-14, -1.457926763885739e-16,  1.433105894460708e-18, -1.330372290798586e-20,  1.174668683857446e-22, -9.920320624010721e-25,
  2.516966956586599e-04, -9.936399915144560e-06,  2.423510273743696e-07, -4.542482238333728e-09,  7.143519528244688e-11, -9.866082953638970e-13,  1.230462209625876e-14,
 -1.411679196990402e-16,  1.509616795383115e-18, -1.519537366177233e-20,  1.450580953872453e-22, -1.321037405579944e-24,  1.036138574558105e-04, -4.760887647927082e-06,
  1.314511556720468e-07, -2.752956013248195e-09,  4.794062709432154e-11, -7.283093964124452e-13,  9.938431108535790e-15, -1.242136359928588e-16,  1.441715489264276e-18,
 -1.570062203206913e-20,  1.617041016366569e-22, -1.584810340699281e-24,  3.999345229628577e-05, -2.119681661245657e-06,  6.594972531805931e-08, -1.537698671585526e-09,
  2.956342624873477e-11, -4.927165483680019e-13,  7.338981970826294e-15, -9.970302755952246e-17,  1.253418981178064e-18, -1.473915139431170e-20,  1.634692067895111e-22,
 -1.721049565510598e-24,  1.448994991542906e-05, -8.788428580256227e-07,  3.067866890753541e-08, -7.937223645777796e-10,  1.680070591772433e-11, -3.064418734357125e-13,
  4.971363779927148e-15, -7.326507628448455e-17,  9.957453940850238e-19, -1.262103353745573e-20,  1.504826030707649e-22, -1.699196561688466e-24,  4.934043768399835e-06,
 -3.400515261818116e-07,  1.326415432009962e-08, -3.796056859024528e-10,  8.823668692919549e-12, -1.757425054177552e-13,  3.099006020232373e-15, -4.945331493213443e-17,
  7.253845682239299e-19, -9.894350260830292e-21,  1.266320930974136e-22, -1.531322315443118e-24,  1.581372065707477e-06, -1.230638614827518e-07,  5.343264961682054e-09,
 -1.686597776863396e-10,  4.294772793152531e-12, -9.321182097878928e-14,  1.783315856904436e-15, -3.076218269196734e-17,  4.862165859096701e-19, -7.126582209404543e-21,
  9.776804849460848e-23, -1.264463240851001e-24,  4.778534320896588e-07, -4.175175329452051e-08,  2.010587420993618e-09, -6.980437925393627e-11,  1.942850645427218e-12,
 -4.585909986266448e-14,  9.502565951347388e-16, -1.769134435934880e-17,  3.008711185172998e-19, -4.732304258498871e-21,  6.950053112196281e-23, -9.601746636839478e-25,
  1.364052789067011e-07, -1.331226216273961e-08,  7.085887378848014e-10, -2.698828653115571e-11,  8.192712905080233e-13, -2.099266493515553e-14,  4.703603385457903e-16,
 -9.437091997423290e-18,  1.724535374269554e-19, -2.907044758642197e-21,  4.565049147148449e-23, -6.729203626202733e-25,  3.686522908181942e-08, -3.999696926227219e-09,
  2.345677760291243e-10, -9.776693259724540e-12,  3.230359603591787e-13, -8.969753469414727e-15,  2.169779899760197e-16, -4.684896406197503e-18,  9.187278631425850e-20,
 -1.657796902320239e-21,  2.780427342246866e-23, -4.368356357003648e-25,  9.457367452992566e-09, -1.135739173207125e-09,  7.316388395606644e-11, -3.329130780299610e-12,
  1.194929386476979e-13, -3.589446220117315e-15,  9.360211759086368e-17, -2.172005756066706e-18,  4.565236846868742e-20, -8.807909917127584e-22,  1.576050265912927e-23,
 -2.636444911374604e-25,  2.309797500413281e-09, -3.057886373884060e-10,  2.157533946230276e-11, -1.069322719728176e-12,  4.161466193617463e-14, -1.350128295457808e-15,
  3.789888420736393e-17, -9.438962661311649e-19,  2.123835324666460e-20, -4.376343413165057e-22,  8.345860780709556e-24, -1.485013155706817e-25,  5.388860350343803e-10,
 -7.834870350230976e-11,  6.037822292495175e-12, -3.252263202162832e-13,  1.369755841525709e-14, -4.792010701197979e-16,  1.445919431212597e-17, -3.860166348007165e-19,
  9.287195507108377e-21, -2.041645813176299e-22,  4.145302417468621e-24, -7.837939137061840e-26,  1.205642967500958e-10, -1.918114460801631e-11,  1.610168120480357e-12,
 -9.405676011711749e-14,  4.279305400473202e-15, -1.611770816879832e-16,  5.220238836767654e-18, -1.491970973388962e-19,  3.833630431378639e-21, -8.981246071253514e-23,
  1.939468584601104e-24, -3.893062199105416e-26,  2.598095244812580e-11, -4.507439074423554e-12,  4.110941345693267e-13, -2.598638276016127e-14,  1.274866488406174e-15,
 -5.161292495204121e-17,  1.791795049411162e-18, -5.475263541294651e-20,  1.500753283933761e-21, -3.742698491140662e-23,  8.587144776280666e-25, -1.828057123786842e-26,
  5.419834791907977e-12, -1.021935383143960e-12,  1.010031158459857e-13, -6.894469872977357e-15,  3.640493373145311e-16, -1.581672329569058e-17,  5.877043501432137e-19,
 -1.917552342140602e-20,  5.599826661963775e-22, -1.484920561638933e-23,  3.615909878610321e-25, -8.155405938084433e-27,  1.100740851604448e-12, -2.248310003260486e-13,
  2.401922207594653e-14, -1.766670157061756e-15,  1.002179871340427e-16, -4.664921069293393e-18,  1.852454792074369e-19, -6.444805804766420e-21,  2.002652827324739e-22,
 -5.639853585304345e-24,  1.455934592895013e-25, -3.475267023215113e-27,  2.190525747546887e-13, -4.830974787949873e-14,  5.564340183632359e-15, -4.400391577513129e-16,
  2.676564225372391e-17, -1.332506875935430e-18,  5.646129469167621e-20, -2.091494735855152e-21,  6.906110970760268e-23, -2.062892892259515e-24,  5.638801648643768e-26,
 -1.422821073825254e-27,  4.302522162820358e-14, -1.021175919421127e-14,  1.264794482596354e-15, -1.072998279907236e-16,  6.984097415094793e-18, -3.711982446498621e-19,
  1.675484115690372e-20, -6.598066285996341e-22,  2.311763470306708e-23, -7.314279658111754e-25,  2.114225220523333e-26, -5.632331254693031e-28,  8.408774350718274e-15,
 -2.140698860061444e-15,  2.843446637133648e-16, -2.581679198453086e-17,  1.794395457702130e-18, -1.016192495639268e-19,  4.877354460245866e-21, -2.038463490172157e-22,
  7.566475289857963e-24, -2.531956173778201e-25,  7.728313285823517e-27, -2.170691003567852e-28,  1.650043546245422e-15, -4.490369912380294e-16,  6.378546407667344e-17,
 -6.182669630398137e-18,  4.578398406294405e-19, -2.756934303412039e-20,  1.404308628792085e-21, -6.217670432603119e-23,  2.440781104869764e-24, -8.623987908725168e-26,
  2.775227359384481e-27, -8.205892399236215e-29,  3.283468505186387e-16, -9.518143263956734e-17,  1.441640469122160e-17, -1.487834773081120e-18,  1.170991356962957e-19,
 -7.480568000870072e-21,  4.035259074295907e-22, -1.888887234270674e-23,  7.826779931562355e-25, -2.914615337905465e-26,  9.871141398876537e-28, -3.067384765745865e-29,
  6.698262205227359e-17, -2.060730548308644e-17,  3.317612255989577e-18, -3.635170306264634e-19,  3.032720578710784e-20, -2.050215656035546e-21,  1.168461003710716e-22,
 -5.769596716872470e-24,  2.518075621501063e-25, -9.862648027698504e-27,  3.508457327768755e-28, -1.143560337943514e-29,  1.417307257976497e-17, -4.609962265904333e-18,
  7.862131002049551e-19, -9.117895804298967e-20,  8.039884186184992e-21, -5.736025555247750e-22,  3.444845152426312e-23, -1.789838854069985e-24,  8.208121506100339e-26,
 -3.373605829336085e-27,  1.257729606503064e-28, -4.290772678843251e-30,  3.149317263795951e-18, -1.078643070788118e-18,  1.941724698102593e-19, -2.375370436921764e-20,
  2.206728988295768e-21, -1.656481253969149e-22,  1.045271278374290e-23, -5.698714269942384e-25,  2.738728498057041e-26, -1.178152370627618e-27,  4.591739971376369e-29,
 -1.635594066454136e-30,  7.443527880628055e-19, -2.673220897782505e-19,  5.059608270237586e-20, -6.505039353579735e-21,  6.344631567252652e-22, -4.994153762510874e-23,
  3.300559620127115e-24, -1.882304474069622e-25,  9.451516240178207e-27, -4.243218593153052e-28,  1.723980268375708e-29, -6.394310992298886e-31,  1.895419802760205e-19,
 -7.106120367173617e-20,  1.408178982592973e-20, -1.895106932868312e-21,  1.933098540459924e-22, -1.589703360144516e-23,  1.096405177806204e-24, -6.518180219252251e-26,
  3.408192938465062e-27, -1.591661133294580e-28,  6.720177870174066e-30, -2.587474423573326e-31,  5.263217711701847e-20, -2.050385521029298e-20,  4.234808076981104e-21,
 -5.939504745236228e-22,  6.309548260895671e-23, -5.398744804603030e-24,  3.870441313476865e-25, -2.389492819905532e-26,  1.296213916050959e-27, -6.274358519911005e-29,
  2.743280999511865e-30, -1.092745743735454e-31,  1.610287809927588e-20, -6.486987383005501e-21,  1.389630418469625e-21, -2.021593885978549e-22,  2.226217270162624e-23,
 -1.973114802948645e-24,  1.464024155934117e-25, -9.346602534329248e-27,  5.238659653747358e-28, -2.617885395109270e-29,  1.180703105077855e-30, -4.847385706435334e-32,
  5.464902266941771e-21, -2.265134156447674e-21,  5.006694354088275e-22, -7.516263145492796e-23,  8.537557767915272e-24, -7.800083409702776e-25,  5.961720633946124e-26,
 -3.917796474399799e-27,  2.258719069460120e-28, -1.160221147863931e-29,  5.375018157585122e-31, -2.265036624245726e-32,  2.056388690220535e-21, -8.724335719376361e-22,
  1.978787469528973e-22, -3.048829568190154e-23,  3.553020648027264e-24, -3.328703133201049e-25,  2.607430638321590e-26, -1.755068172812522e-27,  1.035787342111852e-28,
 -5.443195625901552e-30,  2.578406394118633e-31, -1.110296073847480e-32,  8.444594992302563e-22, -3.647567975284917e-22,  8.440516786277445e-23, -1.327018376757627e-23,
  1.577638010195168e-24, -1.507244093720775e-25,  1.203460165090254e-26, -8.253299620693718e-28,  4.960461510454430e-29, -2.653557269178815e-30,  1.278961718360249e-31,
 -5.601042600061829e-33,  3.572330383497705e-22, -1.562451469616442e-22,  3.666584505076994e-23, -5.846841623496564e-24,  7.049078918602292e-25, -6.827706343391265e-26,
  5.525336189995392e-27, -3.839318493903162e-28,  2.337280427428072e-29, -1.266027615114617e-30,  6.176809360117689e-32, -2.737293358104486e-33,  1.219859721642955e-22,
 -5.372725213327380e-23,  1.270746611461632e-23, -2.042519226370173e-24,  2.481913307371597e-25, -2.422564484998739e-26,  1.975299569895435e-27, -1.382694384555317e-28,
  8.478205658536837e-30, -4.624674296081117e-31,  2.271809711743643e-32, -1.013483812912602e-33,  5.462481893274028e-02, -1.228009920069574e-04,  2.848356635371422e-07,
 -6.786805568721226e-10,  1.651748085963686e-12, -4.084622606452529e-15,  1.020907415309103e-17, -2.570483209679848e-20,  6.494086294650473e-23, -1.645079637602666e-25,
  4.163154765144458e-28, -1.054885061846178e-30,  5.085532300677992e-02, -1.367419847359666e-04,  4.356473276795125e-07, -1.465329780184132e-09,  4.935803673832593e-12,
 -1.638660997188174e-14,  5.347499263622148e-17, -1.717502349365001e-19,  5.438843593860547e-22, -1.701360294915311e-24,  5.264116494378932e-27, -1.613155878849813e-29,
  4.408038871252792e-02, -1.574452687997859e-04,  6.989785199839468e-07, -3.049117142153713e-09,  1.271460052611221e-11, -5.103614599825209e-14,  1.987306029621990e-16,
 -7.547889000684924e-19,  2.806667137831087e-21, -1.024619550879442e-23,  3.680111419300761e-26, -1.302642568059086e-28,  3.557539796720996e-02, -1.743086109965606e-04,
  1.005646165692790e-06, -5.336942306407265e-09,  2.646606305745115e-11, -1.248830711559069e-13,  5.666429339212903e-16, -2.489030504217573e-18,  1.063527107807219e-20,
 -4.436485075502037e-23,  1.811910010636559e-25, -7.261467648954375e-28,  2.673619483940852e-02, -1.785130024780691e-04,  1.272533758799981e-06, -8.009835239780748e-09,
  4.646082207178326e-11, -2.538073047444605e-13,  1.321881090759675e-15, -6.617855060528747e-18,  3.203815857472382e-20, -1.506602272936711e-22,  6.906122302615653e-25,
 -3.094434633704269e-27,  1.871386964021312e-02, -1.667184629362903e-04,  1.427467852577344e-06, -1.051983607021866e-08,  7.055498296408563e-11, -4.411339026394161e-13,
  2.608343816147717e-15, -1.472852721988019e-17,  7.998738613034123e-20, -4.200049447707460e-22,  2.141135499655740e-24, -1.063166911192062e-26,  1.220199022515633e-02,
 -1.415762666758789e-04,  1.432921854757996e-06, -1.225047528472522e-08,  9.412259333508227e-11, -6.675807856033015e-13,  4.444112307109058e-15, -2.808208685682014e-17,
  1.698029154642689e-19, -9.884542381978425e-22,  5.565362888705769e-24, -3.041975073616431e-26,  7.413307687669952e-03, -1.094723372144925e-04,  1.296622553877606e-06,
 -1.276106761588728e-08,  1.114670749083681e-10, -8.905573864352616e-13,  6.630906573141787e-15, -4.659799719094984e-17,  3.118633492701769e-19, -2.001195024623796e-21,
  1.237659209553449e-23, -7.407575710708888e-26,  4.198013138296625e-03, -7.729192969940092e-05,  1.063446782450359e-06, -1.196783387543312e-08,  1.181021136939281e-10,
 -1.056761136875760e-12,  8.753579600346676e-15, -6.806569616079798e-17,  5.017774264190665e-19, -3.532996511591535e-21,  2.389456448488584e-23, -1.559273949141422e-25,
  2.216614683891796e-03, -4.997942735749616e-05,  7.939160896495878e-07, -1.015632627164321e-08,  1.126301048061677e-10, -1.123258671705250e-12,  1.030468900522022e-14,
 -8.828500887627123e-17,  7.140160595405770e-19, -5.495097320417277e-21,  4.049192080411620e-23, -2.870703401418477e-25,  1.091810780281176e-03, -2.968406652218833e-05,
  5.413785936111233e-07, -7.831769199322347e-09,  9.715605329227098e-11, -1.075486434094891e-12,  1.088531901815440e-14, -1.023854294256910e-16,  9.053431926368120e-19,
 -7.590985450299947e-21,  6.075281722041578e-23, -4.665186734645309e-25,  5.019353569955200e-04, -1.623579746993413e-05,  3.382161319037124e-07, -5.507219192333008e-09,
  7.611981902785791e-11, -9.319193253713394e-13,  1.037175966106216e-14, -1.067684124411989e-16,  1.029183482384128e-18, -9.375086597783360e-21,  8.127340822186466e-23,
 -6.742258382232225e-25,  2.155090613672579e-04, -8.197602164957916e-06,  1.940963834943771e-07, -3.542583024147842e-09,  5.436217387654240e-11, -7.337390788144065e-13,
  8.953361712561407e-15, -1.005975047571782e-16,  1.054377165793411e-18, -1.040911087022059e-20,  9.751558675318603e-23, -8.719770359594469e-25,  8.648134969893503e-05,
 -3.829408784380784e-06,  1.025762604239875e-07, -2.090570766155252e-09,  3.550282494975964e-11, -5.267903815896602e-13,  7.029533871848950e-15, -8.599872970153379e-17,
  9.778564670137699e-19, -1.043982121317756e-20,  1.054743179996923e-22, -1.014592875437191e-24,  3.246349405503512e-05, -1.658543298016119e-06,  5.003882707613033e-08,
 -1.134821960533996e-09,  2.126582110473551e-11, -3.459974147234103e-13,  5.037266785927315e-15, -6.695606881996325e-17,  8.242721822229507e-19, -9.498577980655562e-21,
  1.033030453674745e-22, -1.067114487067851e-24,  1.141100077254279e-05, -6.673692797202177e-07,  2.258385491343491e-08, -5.680968112859095e-10,  1.171579789565338e-11,
 -2.085272400831109e-13,  3.305236262578153e-15, -4.764132968298515e-17,  6.338325344335462e-19, -7.870251586145352e-21,  9.198895896606752e-23, -1.018842293452777e-24,
  3.760280636230938e-06, -2.500023598504294e-07,  9.451877100905708e-09, -2.629321847696743e-10,  5.952696774349050e-12, -1.156568669970413e-13,  1.992010999540620e-15,
 -3.108082222273548e-17,  4.461483780532639e-19, -5.960017123361861e-21,  7.475646869643080e-23, -8.865068194727826e-25,  1.163270512512206e-06, -8.737314190213718e-08,
  3.676928572794700e-09, -1.127958759949169e-10,  2.796934254439764e-12, -5.920271974835078e-14,  1.106040498364123e-15, -1.865037063420465e-17,  2.884151213465171e-19,
 -4.139310334888065e-21,  5.564206770158076e-23, -7.055762980202057e-25,  3.383740464798065e-07, -2.855162715001579e-08,  1.332778293368514e-09, -4.496778106773545e-11,
  1.218624745617835e-12, -2.804938223981514e-14,  5.674721204599455e-16, -1.032583650038177e-17,  1.717899988030427e-19, -2.645371583834448e-21,  3.806308249915012e-23,
 -5.155187201992236e-25,  9.271959659824335e-08, -8.744476602163870e-09,  4.512900436548502e-10, -1.670516953339246e-11,  4.937552729907859e-13, -1.233668820798958e-14,
  2.698604011785689e-16, -5.291461354337906e-18,  9.458672190212863e-20, -1.560900732459628e-21,  2.401275261104842e-23, -3.469867796352655e-25,  2.398463939743801e-08,
 -2.516565395126092e-09,  1.431465092817392e-10, -5.799600125545814e-12,  1.865983931108701e-13, -5.052504826810447e-15,  1.193246691643245e-16, -2.517957116043646e-18,
  4.830118900014757e-20, -8.532355513037755e-22,  1.401921951455084e-23, -2.159169246019405e-25,  5.871597722997983e-09, -6.824790404161341e-10,  4.266188845429164e-11,
 -1.887542097817736e-12,  6.598544010679084e-14, -1.933162293008906e-15,  4.922282259050183e-17, -1.116396990886754e-18,  2.295522800108721e-20, -4.336038577414235e-22,
  7.601497313384708e-24, -1.246632991215479e-25,  1.364210283542787e-09, -1.749649253935570e-10,  1.198588249716892e-11, -5.778588113074637e-13,  2.190967102636470e-14,
 -6.934419487210928e-16,  1.901058149944755e-17, -4.628636710363286e-19,  1.019027992459587e-20, -2.056126637123657e-22,  3.842260266293597e-24, -6.703536922874771e-26,
  3.018133865913394e-10, -4.255320191581137e-11,  3.186118959904443e-12, -1.670303923093907e-13,  6.856683597091004e-15, -2.340943591702783e-16,  6.900632480408651e-18,
 -1.801504318127435e-19,  4.241952204009464e-21, -9.133637275597472e-23,  1.817612149524672e-24, -3.370596482262922e-26,  6.382252795527565e-11, -9.857473571460934e-12,
  8.046191811143046e-13, -4.577356471700354e-14,  2.030919430146919e-15, -7.468421466095920e-17,  2.364125642263801e-18, -6.609870764555131e-20,  1.662844254487533e-21,
 -3.816881638828236e-23,  8.081256694060380e-25, -1.591423043366552e-26,  1.295623483482388e-11, -2.184780579941467e-12,  1.939289172578310e-13, -1.194759017732390e-14,
  5.719752419818436e-16, -2.262191882133261e-17,  7.679689818981336e-19, -2.296812909668977e-20,  6.166497782261085e-22, -1.507422068761298e-23,  3.392384380002480e-25,
 -7.087951115501665e-27,  2.537582014283444e-12, -4.656636497012615e-13,  4.483848358651070e-14, -2.985578289292747e-15,  1.539571081378254e-16, -6.539074237416921e-18,
  2.377501370887722e-19, -7.596849932796721e-21,  2.174273813268842e-22, -5.654531905539182e-24,  1.351266281169674e-25, -2.992678840632158e-27,  4.822526526232508e-13,
 -9.599835561504566e-14,  1.000291133715663e-14, -7.183953708017584e-16,  3.983369669027164e-17, -1.814101696106669e-18,  7.054299577520209e-20, -2.405178945065330e-21,
  7.329718129731063e-23, -2.025726294787600e-24,  5.135128780958865e-26, -1.204333676445412e-27,  8.950835687498823e-14, -1.926697065047307e-14,  2.167171984276873e-15,
 -1.675296199614183e-16,  9.970367290062651e-18, -4.860918477117700e-19,  2.018669983418363e-20, -7.334287101486813e-22,  2.376930887685668e-23, -6.972912013703917e-25,
  1.872973576236114e-26, -4.646703530661866e-28,  1.634508525567880e-14, -3.792402024236581e-15,  4.593289071749309e-16, -3.813764036508813e-17,  2.431564281481646e-18,
 -1.266924259468714e-19,  5.610187822765497e-21, -2.168925853144444e-22,  7.465154025865822e-24, -2.321618666498930e-25,  6.599842212374317e-27, -1.730072941277626e-28,
  2.961128966778902e-15, -7.381671306480159e-16,  9.602173071869595e-17, -8.543923125351655e-18,  5.824136967638671e-19, -3.237149562525787e-20,  1.525948202667833e-21,
 -6.267615171217148e-23,  2.287669749696060e-24, -7.531743647547452e-26,  2.263015905268410e-27, -6.260116152521698e-29,  5.371863192117537e-16, -1.433988230174407e-16,
  1.997973093496191e-17, -1.900646176080167e-18,  1.382239237202106e-19, -8.179412034644628e-21,  4.096863207025850e-22, -1.784682275914964e-23,  6.896707179390950e-25,
 -2.400057838527229e-26,  7.610624827584007e-28, -2.218499566575774e-29,  9.860477156019680e-17, -2.808923219090930e-17,  4.179921107700275e-18, -4.240269758623570e-19,
  3.282223180803865e-20, -2.063352287425818e-21,  1.095906569857342e-22, -5.053564633124701e-24,  2.063850458478523e-25, -7.578462486654753e-27,  2.531990706901042e-28,
 -7.765078433485674e-30,  1.852435691582333e-17, -5.610935419993458e-18,  8.890302107203419e-19, -9.590741633265437e-20,  7.881468173869420e-21, -5.250953890237156e-22,
  2.950716801936515e-23, -1.437258113152915e-24,  6.190493720293852e-26, -2.393858477100690e-27,  8.410877220284053e-29, -2.708791152265895e-30,  3.606319096900265e-18,
 -1.157054122766604e-18,  1.945599272455341e-19, -2.225279517382905e-20,  1.935942046961289e-21, -1.363301214165667e-22,  8.084841801039077e-24, -4.149665408814316e-25,
  1.880652939114073e-26, -7.641618210180986e-28,  2.817455206315236e-29, -9.509055074269853e-31,  7.372979299085544e-19, -2.495656907342345e-19,  4.437600703680868e-20,
 -5.363286085850838e-21,  4.924147766343682e-22, -3.654323145473423e-23,  2.280570647697049e-24, -1.230089882382060e-25,  5.850593179285723e-27, -2.491624389283891e-28,
  9.616601203636753e-30, -3.393265475188372e-31,  1.605202035274832e-19, -5.707929648367302e-20,  1.069091422775512e-20, -1.360376031116802e-21,  1.313531585452728e-22,
 -1.023879878469240e-23,  6.702815612374975e-25, -3.787644233316249e-26,  1.885008180822832e-27, -8.389917512029357e-29,  3.380324059530801e-30, -1.243653042039668e-31,
  3.774466179899163e-20, -1.403657014805969e-20,  2.757593404214480e-21, -3.679460696323934e-22,  3.721948066420370e-23, -3.035989625526645e-24,  2.077437608157528e-25,
 -1.225630641823179e-26,  6.361133731358428e-28, -2.949411500665726e-29,  1.236612292534768e-30, -4.729261342472521e-32,  9.717006890369056e-21, -3.761294767136180e-21,
  7.715085510556978e-22, -1.074681293919554e-22,  1.134005750075698e-23, -9.639972981420956e-25,  6.867384834543934e-26, -4.213723744180259e-27,  2.272198088192477e-28,
 -1.093516492535116e-29,  4.754309444944360e-31, -1.883540203314232e-32,  2.771838627784658e-21, -1.111247120218448e-21,  2.368019864226485e-22, -3.426922715732569e-23,
  3.754467040772911e-24, -3.311014970713711e-25,  2.444815566232904e-26, -1.553466829427964e-27,  8.667203246968559e-29, -4.311998848134698e-30,  1.936398296517337e-31,
 -7.916749688827061e-33,  8.835668895528286e-22, -3.649724572639745e-22,  8.036747816685555e-23, -1.201970204831433e-23,  1.360248736757463e-24, -1.238273930009841e-25,
  9.431150576811123e-27, -6.176661044013433e-28,  3.549242653446327e-29, -1.817262070582654e-30,  8.392678053262835e-32, -3.526000703004966e-33,  3.151522256943419e-22,
 -1.334044760080805e-22,  3.018252889409753e-23, -4.638788567567299e-24,  5.392654168213631e-25, -5.040092708404124e-26,  3.938785119012227e-27, -2.645194074661388e-28,
  1.557671675481021e-29, -8.168235048417159e-31,  3.861189220092530e-32, -1.659327237701633e-33,  1.240013299985118e-22, -5.349107135694057e-23,  1.235981368720348e-23,
 -1.940353775525556e-24,  2.303467520564521e-25, -2.197571333210577e-26,  1.752230148923266e-27, -1.200059757263247e-28,  7.203257219186543e-30, -3.848419126138455e-31,
  1.852565707109552e-32, -8.103325941109891e-34,  5.087626228793812e-23, -2.223772525022278e-23,  5.214725736285139e-24, -8.309481404617345e-25,  1.001086464194048e-25,
 -9.689619351590271e-27,  7.835922022454352e-28, -5.441168446792507e-29,  3.310264005732095e-30, -1.791908502594882e-31,  8.737045825708168e-33, -3.869519607830889e-34,
  1.707384219912835e-23, -7.517962492087902e-24,  1.777596572527964e-24, -2.856319625997324e-25,  3.469719180080935e-26, -3.385725826751533e-27,  2.759816287059246e-28,
 -1.931285009179249e-29,  1.183857263068883e-30, -6.455859024753755e-32,  3.170476762792932e-33, -1.414007587080883e-34,  5.413812138179989e-02, -1.205544402132438e-04,
  2.768474112845236e-07, -6.528930550352189e-10,  1.572448703877099e-12, -3.848012183696120e-15,  9.517564442891657e-18, -2.371835570184325e-20,  5.930747071729396e-23,
 -1.487472624626903e-25,  3.725913147593548e-28, -9.351624169304832e-31,  5.031521592308643e-02, -1.333258238679635e-04,  4.185266138018343e-07, -1.388910647997991e-09,
  4.620525872231435e-12, -1.515900671644590e-14,  4.890072038371188e-17, -1.552866280057425e-19,  4.862605992006651e-22, -1.504325776492888e-24,  4.603461604473800e-27,
 -1.395415962409188e-29,  4.346156434295411e-02, -1.519964158176385e-04,  6.635768523069661e-07, -2.853597179656476e-09,  1.173991213043462e-11, -4.651040263191922e-14,
  1.788004106681940e-16, -6.706040936330804e-19,  2.462976028708121e-21, -8.882635869896687e-24,  3.152246826985010e-26, -1.102625553282811e-28,  3.489385817286909e-02,
 -1.665126012691391e-04,  9.440635076228369e-07, -4.932750708589771e-09,  2.409894348414630e-11, -1.120829250971946e-13,  5.014842009932750e-16, -2.172917347417955e-18,
  9.161247246411521e-21, -3.771777892241345e-23,  1.520681364359760e-25, -6.017311307951237e-28,  2.604191196822022e-02, -1.687049420482403e-04,  1.180713878383497e-06,
 -7.305408502515432e-09,  4.168749627947080e-11, -2.241947352210187e-13,  1.150155394331857e-15, -5.674338016099001e-18,  2.708048804707313e-20, -1.255773127977462e-22,
  5.677866765314888e-25, -2.509986423796490e-27,  1.806906200266089e-02, -1.557851303929181e-04,  1.307722596396924e-06, -9.458271672093482e-09,  6.232634072704332e-11,
 -3.832066037612815e-13,  2.229619091134104e-15, -1.239519735671687e-17,  6.630239809666141e-20, -3.430302340816994e-22,  1.723565374720005e-24, -8.437419475626790e-27,
  1.165771572311222e-02, -1.306762916621936e-04,  1.294529384145127e-06, -1.084578829587830e-08,  8.177691354694376e-11, -5.697750703194588e-13,  3.728827867050676e-15,
 -2.317726591835575e-17,  1.379227793144733e-19, -7.904696402609701e-22,  4.383440270815212e-24, -2.360514865395363e-26,  6.995235545389360e-03, -9.968286857771547e-05,
  1.153629657690555e-06, -1.111186104154167e-08,  9.514721807243000e-11, -7.460081609757711e-13,  5.455692959270979e-15, -3.768154010763577e-17,  2.479981791173629e-19,
 -1.565662197808677e-21,  9.530341883451249e-24, -5.616110113261401e-26,  3.904994335753604e-03, -6.932822289701051e-05,  9.305083965283825e-07, -1.023648395506854e-08,
  9.892227856585500e-11, -8.678421172575861e-13,  7.054657152471019e-15, -5.387198905133586e-17,  3.902590932238377e-19, -2.701561636859512e-21,  1.797185668347624e-23,
 -1.154005556408488e-25,  2.028668855148719e-03, -4.408659095654155e-05,  6.821526511890942e-07, -8.521324925848850e-09,  9.245043301658913e-11, -9.032002117702948e-13,
  8.124941821329467e-15, -6.831221219973356e-17,  5.425386769126111e-19, -4.102528150799657e-21,  2.971717750818204e-23, -2.071931242322966e-25,  9.811766204206084e-04,
 -2.570408337801497e-05,  4.560579746711464e-07, -6.436074608050340e-09,  7.804249657696746e-11, -8.456032421406281e-13,  8.386163188356128e-15, -7.735525331199788e-17,
  6.712750583457889e-19, -5.526896240559064e-21,  4.345813166185188e-23, -3.280155702671005e-25,  4.420125438544553e-04, -1.377504378058997e-05,  2.788631234067269e-07,
 -4.425837670480581e-09,  5.974649141065990e-11, -7.154405306274813e-13,  7.796738598259458e-15, -7.866093820689722e-17,  7.436864129902342e-19, -6.648595865107783e-21,
  5.659801409903433e-23, -4.612847063288647e-25,  1.855744532625594e-04, -6.801132492075447e-06,  1.563552463156036e-07, -2.779404589766122e-09,  4.162637122105285e-11,
 -5.491676130542381e-13,  6.557620194260946e-15, -7.216942823089848e-17,  7.414972510146897e-19, -7.180697146382946e-21,  6.602683827125546e-23, -5.797895872881105e-25,
  7.265869910039534e-05, -3.100234317443158e-06,  8.057760050584453e-08, -1.598404786086541e-09,  2.647596032480787e-11, -3.837613963459652e-13,  5.008484631821707e-15,
 -5.998641037950006e-17,  6.683023680727643e-19, -6.995733169896731e-21,  6.934186181351805e-23, -6.547659084320492e-25,  2.655121846648237e-05, -1.307406032589435e-06,
  3.825378062517165e-08, -8.439473947029968e-10,  1.541712065644802e-11, -2.449092511889627e-13,  3.485559028412313e-15, -4.533668766302160e-17,  5.466143485958377e-19,
 -6.173568690104461e-21,  6.584688776223352e-23, -6.674592992270922e-25,  9.063803666911658e-06, -5.110714449489656e-07,  1.676659628789238e-08, -4.101138057438471e-10,
  8.241279321176380e-12, -1.431555391546764e-13,  2.217238753196100e-15, -3.126116046366236e-17,  4.071786787120105e-19, -4.953530437028628e-21,  5.676283770162753e-23,
 -6.167282848746384e-25,  2.893592041841343e-06, -1.855492358728009e-07,  6.799486733513806e-09, -1.838657679466743e-10,  4.054716581375187e-12, -7.685785169962480e-14,
  1.293077777600902e-15, -1.972852532047540e-17,  2.771635404622478e-19, -3.626545781692153e-21,  4.458384759411563e-23, -5.185112215701573e-25,  8.650025088880787e-07,
 -6.269257799105829e-08,  2.557038338886364e-09, -7.623549832919749e-11,  1.840887597847729e-12, -3.800507676734333e-14,  6.933812902159165e-16, -1.142999994578931e-17,
  1.729517514569505e-19, -2.430654138993382e-21,  3.201747678359587e-23, -3.980954869375006e-25,  2.424916909295869e-07, -1.975466207272776e-08,  8.937933475450742e-10,
 -2.930586049809310e-11,  7.732834138658522e-13, -1.735683339384235e-14,  3.428569182270599e-16, -6.097781642859247e-18,  9.924666674484538e-20, -1.496305000641786e-21,
  2.109394316879346e-23, -2.800880660929266e-25,  6.386021956882980e-08, -5.818395695046591e-09,  2.911020329995287e-10, -1.047188387306248e-11,  3.013562307343708e-13,
 -7.341909870413365e-15,  1.567932784331367e-16, -3.004667772995373e-18,  5.253843112559366e-20, -8.487781868429624e-22,  1.279206794655669e-23, -1.812055215424171e-25,
  1.583062308033747e-08, -1.605795655165271e-09,  8.857547203425687e-11, -3.487984744871548e-12,  1.092704441936668e-13, -2.885017438067529e-15,  6.651882161425779e-17,
 -1.371781584366877e-18,  2.573999191757764e-20, -4.451223217989815e-22,  7.164786105759950e-24, -1.081725953943852e-25,  3.702750432737595e-09, -4.164065889148290e-10,
  2.525220566716923e-11, -1.086195225397315e-12,  3.697832975990511e-14, -1.056481630042562e-15,  2.626439095524618e-17, -5.821954925569403e-19,  1.171031617316718e-20,
 -2.165513754820327e-22,  3.719258969932755e-24, -5.979550225287382e-26,  8.194101768989164e-10, -1.017680915780743e-10,  6.766917958134699e-12, -3.172867190673449e-13,
  1.171845663152948e-14, -3.617685558568002e-16,  9.684994253036647e-18, -2.305008577434192e-19,  4.964805397114145e-21, -9.808504217711732e-23,  1.795903679330867e-24,
 -3.072035687948829e-26,  1.721124671394213e-10, -2.352156775530405e-11,  1.710544169165641e-12, -8.725369311933239e-14,  3.490367658053061e-15, -1.162710051067498e-16,
  3.347895771494842e-18, -8.545567862643213e-20,  1.969095693658110e-21, -4.152165899724195e-23,  8.097757276941117e-25, -1.472595790092064e-26,  3.443984009352653e-11,
 -5.161467470900954e-12,  4.095086845851458e-13, -2.268090139508674e-14,  9.811159339396161e-16, -3.521796012688006e-17,  1.089363307666041e-18, -2.978981053164416e-20,
  7.336036355299941e-22, -1.649607694139348e-23,  3.423814285425648e-25, -6.613835727521258e-27,  6.593305368815624e-12, -1.080077816568870e-12,  9.326765556283055e-14,
 -5.598210753377702e-15,  2.614517906608695e-16, -1.009914137698423e-17,  3.351787291401827e-19, -9.809022851425070e-21,  2.579030321334695e-22, -6.178572825547928e-24,
  1.363590287888783e-25, -2.795742885196783e-27,  1.213613634622818e-12, -2.166213609706251e-13,  2.031173228360027e-14, -1.318754796061071e-15,  6.638888738980047e-17,
 -2.755721795196646e-18,  9.801147456253137e-20, -3.066185388257816e-21,  8.598531514474892e-23, -2.192596044339156e-24,  5.140864856323881e-26, -1.117774567053318e-27,
  2.160026474437501e-13, -4.188000546683174e-14,  4.254147046411556e-15, -2.981950371664126e-16,  1.615527361853619e-17, -7.195862381765412e-19,  2.739184419619466e-20,
 -9.149831111592598e-22,  2.733834269467268e-23, -7.412744392214217e-25,  1.844734966440214e-26, -4.249828106372342e-28,  3.741705868954192e-14, -7.856194763906240e-15,
  8.625053905061748e-16, -6.514404705025757e-17,  3.791759387652208e-18, -1.809638119019271e-19,  7.362834190368946e-21, -2.622860013025538e-22,  8.340173571421804e-24,
 -2.402116195584134e-25,  6.338579158340259e-27, -1.545729841361420e-28,  6.355481473458986e-15, -1.440609706371928e-15,  1.705305300707630e-16, -1.385043539226350e-17,
  8.645989783787605e-19, -4.414306131602408e-20,  1.916935230775542e-21, -7.272805790584053e-23,  2.458151314328375e-24, -7.511689046124961e-26,  2.099437344483986e-27,
 -5.413688162097097e-29,  1.067525104144705e-15, -2.604150322852769e-16,  3.315533488946172e-17, -2.889622374232963e-18,  1.930903001942763e-19, -1.052849313753323e-20,
  4.872202834429911e-22, -1.965874113007495e-23,  7.053099899286782e-25, -2.283825163627649e-26,  6.752530024953427e-28, -1.839065097477529e-29,  1.790293356756202e-16,
 -4.684832014313383e-17,  6.398589321434509e-18, -5.970558060052126e-19,  4.262058340797950e-20, -2.477286709103879e-21,  1.219558899538971e-22, -5.224813934601325e-24,
  1.986803352306730e-25, -6.807176015182085e-27,  2.126241525604139e-28, -6.108137085560338e-30,  3.030148170300853e-17, -8.477102541567615e-18,  1.238624433084155e-18,
 -1.234386065333036e-19,  9.392359312000041e-21, -5.807522170195709e-22,  3.035654176325874e-23, -1.378397207402154e-24,  5.545941050739944e-26, -2.007280934562371e-27,
  6.613276139583659e-29, -2.000887021330852e-30,  5.238406144528793e-18, -1.561177825598535e-18,  2.433069949203185e-19, -2.582773925208779e-20,  2.089594019099618e-21,
 -1.371331217233875e-22,  7.594559731872174e-24, -3.647470869925801e-25,  1.549759548599231e-26, -5.914372225587171e-28,  2.051642253969182e-29, -6.526253477181526e-31,
  9.372307438145872e-19, -2.964384293900833e-19,  4.911839043276295e-20, -5.537557050806090e-21,  4.750691635270175e-22, -3.300530754559238e-23,  1.931896667071777e-24,
 -9.791094379206811e-26,  4.383382302642482e-27, -1.760096996500774e-28,  6.415322961680257e-30, -2.141258503962634e-31,  1.760309645097541e-19, -5.885364108538569e-20,
  1.033136494970968e-20, -1.232984456293205e-21,  1.118223928254287e-22, -8.200520925418752e-24,  5.059174381645912e-25, -2.698574056719115e-26,  1.269731874019287e-27,
 -5.351256001161995e-29,  2.044539304880126e-30, -7.143869620847311e-32,  3.523497573082154e-20, -1.239944228438900e-20,  2.297101185793992e-21, -2.891552149266596e-22,
  2.762753486956488e-23, -2.131653497509357e-24,  1.381746863744970e-25, -7.733543362251386e-27,  3.813208416443258e-28, -1.682006088543124e-29,  6.718001724628677e-31,
 -2.450837315113817e-32,  7.633589619503154e-21, -2.814670631328015e-21,  5.479655820395453e-22, -7.246090405928685e-23,  7.265764727070642e-24, -5.876407195683800e-25,
  3.987969727503558e-26, -2.334026756197055e-27,  1.202015254857642e-28, -5.531502292758320e-30,  2.302356629855973e-31, -8.743098582342976e-33,  1.817422852473991e-21,
 -6.987599484673209e-22,  1.422912251650572e-22, -1.967818692069327e-23,  2.061860423830845e-24, -1.740775072931992e-25,  1.231880335564740e-26, -7.510008269559969e-28,
  4.024413733810569e-29, -1.925067687418174e-30,  8.320541284269151e-32, -3.277664668323147e-33,  4.820944825252768e-22, -1.922902645450980e-22,  4.074962538447273e-23,
 -5.864656840485500e-24,  6.390526360927080e-25, -5.606109524791934e-26,  4.118357310888501e-27, -2.603891604112439e-28,  1.445796550107891e-29, -7.159399802036317e-31,
  3.200537364801904e-32, -1.302771999867580e-33,  1.439644291566378e-22, -5.925110139311748e-23,  1.299526794752380e-23, -1.935832814533212e-24,  2.182202092471068e-25,
 -1.978968272114679e-26,  1.501682703905075e-27, -9.799525224548369e-29,  5.611390030690821e-30, -2.863389559430247e-31,  1.318058946052968e-32, -5.519929641662890e-34,
  4.855437122002562e-23, -2.050416936505320e-23,  4.626812640859118e-24, -7.092224582460663e-25,  8.223415778018775e-26, -7.666324804415548e-27,  5.976398087625731e-28,
 -4.003993256352037e-29,  2.352339708847299e-30, -1.230749840726307e-31,  5.805082870267016e-33, -2.489402673409121e-34,  1.826642035697928e-23, -7.868729789625783e-24,
  1.815360208201687e-24, -2.845480807356360e-25,  3.372805210483117e-26, -3.212932605051584e-27,  2.558089981660617e-28, -1.749486324398774e-29,  1.048664385906245e-30,
 -5.595082321148744e-32,  2.689864817586443e-33, -1.175087365290662e-34,  7.257230244052206e-24, -3.169937057220883e-24,  7.427802705118296e-25, -1.182682856205846e-25,
  1.423756289119170e-26, -1.377041403055173e-27,  1.112791949167946e-28, -7.721599491444447e-30,  4.694362561509497e-31, -2.539430254526889e-32,  1.237368184432523e-33,
 -5.476628603347522e-35,  2.391341623397427e-24, -1.052663927193084e-24,  2.488204086059058e-25, -3.996874046227302e-26,  4.853662776402054e-27, -4.734678026886575e-28,
  3.858197114969546e-29, -2.699097214248196e-30,  1.654024050122734e-31, -9.017148859172719e-33,  4.427054625536031e-34, -1.973875969347391e-35,  5.366028415586440e-02,
 -1.183705778530132e-04,  2.691611496060141e-07, -6.283373688213549e-10,  1.497719970148396e-12, -3.627350395816216e-15,  8.879235260719311e-18, -2.190339721071163e-20,
  5.421121102083389e-23, -1.346346293912553e-25,  3.338054602562643e-28, -8.300814801540422e-31,  4.978850524064251e-02, -1.300430445202319e-04,  4.022934541572655e-07,
 -1.317345355900668e-09,  4.328738600149226e-12, -1.403585621431607e-14,  4.476264472579398e-17, -1.405584081888689e-19,  4.352766198456281e-22, -1.331897176131589e-24,
  4.031543777792566e-27, -1.208951180248674e-29,  4.286398345272449e-02, -1.468216496197792e-04,  6.304307590366865e-07, -2.672973321875127e-09,  1.085114005147724e-11,
 -4.243589663073900e-14,  1.610805180556296e-16, -5.966710829241592e-19,  2.164775333508941e-21, -7.713622670247349e-24,  2.705011966839971e-26, -9.351305017968629e-29,
  3.424254692947020e-02, -1.591904765473478e-04,  8.871120861114837e-07, -4.564467051305557e-09,  2.197287904402615e-11, -1.007454913509432e-13,  4.445507047357634e-16,
 -1.900358784407311e-18,  7.906804793687018e-21, -3.213310041350750e-23,  1.279077191481839e-25, -4.997968232833502e-28,  2.538544398170329e-02, -1.595988829234040e-04,
  1.096907722253699e-06, -6.672832226993371e-09,  3.746725837922690e-11, -1.984036859598380e-13,  1.002756407625848e-15, -4.875918784901317e-18,  2.294323296249027e-20,
 -1.049292317182341e-22,  4.680265357237058e-25, -2.041529166761146e-27,  1.746614940245374e-02, -1.457609580508521e-04,  1.199962854244018e-06, -8.519569684276563e-09,
  5.517039724090557e-11, -3.336317346250757e-13,  1.910491380702967e-15, -1.045849354008917e-17,  5.510974832557337e-20, -2.809759049091166e-22,  1.391665916446702e-24,
 -6.717448296716245e-27,  1.115492904570527e-02, -1.208192466343700e-04,  1.171869625318703e-06, -9.623871298954900e-09,  7.122623496053078e-11, -4.875971668448052e-13,
  3.137605797082973e-15, -1.918713885229993e-17,  1.123867367041231e-19, -6.342669465923395e-22,  3.464674574969727e-24, -1.838437105829813e-26,  6.614152741820764e-03,
 -9.096241003233792e-05,  1.028951194848888e-06, -9.702095871075283e-09,  8.145538222595912e-11, -6.268853306050971e-13,  4.503737490797009e-15, -3.057842030980346e-17,
  1.979396679381725e-19, -1.229642639017188e-21,  7.368130445725455e-24, -4.275661229403065e-26,  3.641827925029745e-03, -6.234986189476526e-05,  8.166228082669030e-07,
 -8.783871540531648e-09,  8.314330139084757e-11, -7.153052965877207e-13,  5.707391173865448e-15, -4.281041130571152e-17,  3.048056114941433e-19, -2.074854228242059e-21,
  1.357869097008203e-23, -8.580882614102480e-26,  1.862623086936691e-03, -3.901455394669692e-05,  5.882085056336414e-07, -7.176651814704872e-09,  7.619107109744026e-11,
 -7.293213765344789e-13,  6.434592191131086e-15, -5.310133188407877e-17,  4.142147325528382e-19, -3.078030478171039e-21,  2.192107989277124e-23, -1.503297278678052e-25,
  8.851964318040423e-04, -2.234454135870502e-05,  3.857925721108687e-07, -5.312450618302271e-09,  6.297947535440261e-11, -6.680718755463842e-13,  6.493273577731585e-15,
 -5.874878072373264e-17,  5.004037523424856e-19, -4.046404334883337e-21,  3.126435820485645e-23, -2.319850414659215e-25,  3.910594028500647e-04, -1.174135290221742e-05,
  2.310475416631448e-07, -3.574900502911131e-09,  4.714350845828465e-11, -5.522661762948574e-13,  5.894321025762943e-15, -5.829246743115260e-17,  5.406261134337658e-19,
 -4.744218082470673e-21,  3.966440683706375e-23, -3.176464634250508e-25,  1.606753225263747e-04, -5.673161972703925e-06,  1.266620041594742e-07, -2.193340035062661e-09,
  3.206607364596340e-11, -4.135742004714543e-13,  4.833569210945314e-15, -5.211392338515412e-17,  5.249612288194696e-19, -4.987586008333102e-21,  4.501960362601080e-23,
 -3.882681177780216e-25,  6.143497257818323e-05, -2.525679035787470e-06,  6.370484673187158e-08, -1.230190576647830e-09,  1.987828673740734e-11, -2.815114932071656e-13,
  3.593916887378763e-15, -4.214667187293177e-17,  4.601351349244566e-19, -4.723350457986125e-21,  4.593891354057825e-23, -4.258669869762784e-25,  2.187497894731013e-05,
 -1.038036545108213e-06,  2.945843927390305e-08, -6.323122822870008e-10,  1.126205176829383e-11, -1.747009151781971e-13,  2.430920152966535e-15, -3.094507203834274e-17,
  3.654535346310526e-19, -4.045864527669883e-21,  4.232618202345197e-23, -4.210584465168832e-25,  7.259514526852696e-06, -3.945826981495402e-07,  1.255052268311507e-08,
 -2.985400265462663e-10,  5.846368757962897e-12, -9.912352930299146e-14,  1.500375200646137e-15, -2.069459224213333e-17,  2.639232174877200e-19, -3.146102344965423e-21,
  3.534859354760104e-23, -3.767960313277157e-25,  2.247628819829329e-06, -1.389827491729805e-07,  4.936613172650876e-09, -1.297726021978157e-10,  2.787863141777391e-12,
 -5.155989582780139e-14,  8.474388812101683e-16, -1.264419649194853e-17,  1.738722131912730e-19, -2.228526041357558e-21,  2.685501393659596e-23, -3.063316670702940e-25,
  6.499884426696885e-07, -4.544724504311760e-08,  1.796510732111902e-09, -5.205645685949802e-11,  1.224193002901651e-12, -2.465180893131139e-14,  4.392506932646720e-16,
 -7.079084466945790e-18,  1.048182258678483e-19, -1.442631669631274e-21,  1.862255984700364e-23, -2.270539702910654e-25,  1.758119849060912e-07, -1.382440524511352e-08,
  6.062065901086293e-10, -1.931551274350119e-11,  4.962655760274663e-13, -1.086274325844524e-14,  2.095182935776250e-16, -3.642334636111563e-18,  5.799850906305732e-20,
 -8.561660897394637e-22,  1.182598494051417e-23, -1.539540384319225e-25,  4.455092905517592e-08, -3.920221601461396e-09,  1.901156049620330e-10, -6.645947564991319e-12,
  1.862075780257490e-13, -4.423515074259987e-15,  9.222911432526028e-17, -1.727336246528138e-18,  2.954558388276225e-20, -4.672953813643175e-22,  6.899665305558422e-24,
 -9.581385286160751e-26,  1.059637766877317e-08, -1.038773903789136e-09,  5.555445219742417e-11, -2.126076590563447e-12,  6.484813298746028e-14, -1.669446118187811e-15,
  3.757766057206661e-17, -7.573299845441110e-19,  1.390009525844047e-20, -2.353127453101024e-22,  3.710531243882557e-24, -5.491607523394253e-26,  2.370941102593588e-09,
 -2.578762638766184e-10,  1.516795264653922e-11, -6.341940150297758e-13,  2.102337215653370e-14, -5.857008587145988e-16,  1.421544019206844e-17, -3.079556243732065e-19,
  6.059059309778210e-21, -1.096885235317542e-22,  1.845570517856148e-24, -2.908713003366437e-26,  5.003610923108295e-10, -6.015264133849119e-11,  3.881290808655343e-12,
 -1.769539168549158e-13,  6.365259925990201e-15, -1.916497752952935e-16,  5.009730573156095e-18, -1.165368728434507e-19,  2.455581900422425e-21, -4.749629181375492e-23,
  8.520274409828863e-25, -1.428876458267023e-26,  9.990227462428514e-11, -1.322795429008462e-11,  9.340286959824167e-13, -4.634667078793442e-14,  1.806289704048147e-15,
 -5.869990156873756e-17,  1.650731115470038e-18, -4.119180828334138e-20,  9.287105277367624e-22, -1.917654258823193e-23,  3.664782689253392e-25, -6.534882597009698e-27,
  1.893864640729838e-11, -2.752755948290673e-12,  2.122089548557680e-13, -1.143946401221809e-14,  4.823253445770168e-16, -1.689656169920614e-17,  5.106117511563357e-19,
 -1.365473831356497e-20,  3.291116923620743e-22, -7.248704922318204e-24,  1.474649751665818e-25, -2.793901348954269e-27,  3.423054703115436e-12, -5.444504634745773e-13,
  4.571901856954163e-14, -2.672680200431277e-15,  1.217325949747447e-16, -4.591211139878885e-18,  1.489344441390700e-19, -4.264013599579327e-21,  1.097692358176601e-22,
 -2.576718061518073e-24,  5.575858675562257e-26, -1.121630690689360e-27,  5.927543690964027e-13, -1.028533660446899e-13,  9.387151119890637e-15, -5.940488586251130e-16,
  2.918541037080557e-17, -1.183577654029488e-18,  4.116751428386282e-20, -1.260588834660283e-21,  3.462905605845932e-23, -8.656238366821206e-25,  1.990890981804498e-26,
 -4.248894851130655e-28,  9.889479621554006e-14, -1.866464801151287e-14,  1.847369613887594e-15, -1.263297389924294e-16,  6.684665032575578e-18, -2.911082311031022e-19,
  1.084426350162881e-20, -3.547815611973806e-22,  1.039006706038221e-23, -2.763276247591441e-25,  6.749244167095292e-27, -1.526970658092007e-28,  1.600052361785803e-14,
 -3.274896777261702e-15,  3.507407544300998e-16, -2.587079842065838e-17,  1.472102678241707e-18, -6.874863510962896e-20,  2.739475177088812e-21, -9.565087808168905e-23,
  2.983272110714493e-24, -8.433405735375838e-26,  2.185533859571524e-27, -5.237319848340738e-29,  2.529368186874673e-15, -5.597565274504259e-16,  6.472281246385921e-17,
 -5.139618603318412e-18,  3.139797279731050e-19, -1.570173103058766e-20,  6.684035030961636e-22, -2.487705839587064e-23,  8.254023517436067e-25, -2.477575004520631e-26,
  6.805762202378577e-28, -1.725815506670425e-29,  3.940411838651417e-16, -9.400098772503590e-17,  1.170679015914185e-17, -9.988356621491527e-19,  6.539512824804815e-20,
 -3.496451679427341e-21,  1.587753629148804e-22, -6.290805897089881e-24,  2.217676492144610e-25, -7.059987789298058e-27,  2.053376787799859e-28, -5.504155653650351e-30,
  6.109192633776929e-17, -1.566075953828445e-17,  2.095500403768084e-18, -1.916889914644386e-19,  1.342458866674359e-20, -7.660675880691687e-22,  3.705051277328299e-23,
 -1.560396720753067e-24,  5.836409532493432e-26, -1.967985021638372e-27,  6.052761211043965e-29, -1.712981113457639e-30,  9.531603470650033e-18, -2.616998917529767e-18,
  3.752282804200994e-19, -3.671534757679803e-20,  2.744675697085680e-21, -1.668408521306919e-22,  8.578695492109840e-24, -3.833961599671429e-25,  1.519095215743815e-26,
 -5.417166227480048e-28,  1.759299873696495e-29, -5.249361310778958e-31,  1.515333540065556e-18, -4.440608333306879e-19,  6.803049911039144e-20, -7.102089012064164e-21,
  5.653940372656409e-22, -3.653110173089996e-23,  1.992906605900218e-24, -9.433248483181507e-26,  3.952099871518834e-27, -1.487865856436400e-28,  5.093716529157911e-30,
 -1.599778600689577e-31,  2.489010774311996e-19, -7.756152092228861e-20,  1.265643704288804e-20, -1.405685298214397e-21,  1.188584657335429e-22, -8.142705568632536e-24,
  4.702014486828387e-25, -2.352021826473132e-26,  1.039716476759132e-27, -4.123952117307540e-29,  1.485367513924916e-30, -4.901056259816788e-32,  4.288440097839695e-20,
 -1.415395965395738e-20,  2.451559364509840e-21, -2.887553193334417e-22,  2.585556178077928e-23, -1.872818062489320e-24,  1.141661019397539e-25, -6.019546838626916e-27,
  2.800752751167554e-28, -1.167631114838142e-29,  4.414476157776312e-31, -1.526858199405659e-32,  7.877232503830586e-21, -2.741935610083127e-21,  5.021753256645413e-22,
 -6.250293140965962e-23,  5.906603875047916e-24, -4.509040920032506e-25,  2.892770865952592e-26, -1.602966662525445e-27,  7.827699058727116e-29, -3.420583718793860e-30,
  1.353840767051251e-31, -4.895809446085945e-33,  1.568880327960555e-21, -5.733065712193050e-22,  1.105534616974667e-22, -1.448202111523074e-23,  1.438850681350634e-24,
 -1.153378943510405e-25,  7.759910539131089e-27, -4.503730482969394e-28,  2.300655488344731e-29, -1.050434243748327e-30,  4.338976283655461e-32, -1.635596772254988e-33,
  3.445662366898868e-22, -1.315373948775598e-22,  2.658146054482921e-23, -3.648304367024897e-24,  3.794434731909128e-25, -3.180553610675866e-26,  2.235086265502164e-27,
 -1.353394960533970e-28,  7.205024167037378e-30, -3.424639143789404e-31,  1.471094226742423e-32, -5.760502492142843e-34,  8.476522397351822e-23, -3.362766539931245e-23,
  7.084677220859556e-24, -1.013694894686097e-24,  1.098307434166877e-25, -9.581605869019056e-27,  7.001003057252646e-28, -4.403405866776354e-29,  2.432602847683015e-30,
 -1.198686144863642e-31,  5.333115735896356e-33, -2.160840738963231e-34,  2.364879119085172e-23, -9.695629976941645e-24,  2.117544573811990e-24, -3.141124158025038e-25,
  3.526293257521521e-26, -3.185039746937967e-27,  2.407443647594869e-28, -1.565073121131981e-29,  8.928955631618046e-31, -4.540032553242235e-32,  2.082609896152593e-33,
 -8.692599623859629e-35,  7.522436845201119e-24, -3.168639758580135e-24,  7.130149555767610e-25, -1.089890953585284e-25,  1.260255816657279e-26, -1.171733935832520e-27,
  9.110630600010362e-29, -6.088378614228554e-30,  3.568121860503098e-31, -1.862395741928106e-32,  8.764022661449413e-34, -3.749860839643495e-35,  2.699851190964036e-24,
 -1.161316287286244e-24,  2.674829192061026e-25, -4.185745308888055e-26,  4.953405524428681e-27, -4.711139931257699e-28,  3.745155280145592e-29, -2.557481228430627e-30,
  1.530750734564457e-31, -8.155645038358449e-33,  3.915466719664462e-34, -1.708216810072075e-35,  1.036947758472344e-24, -4.526102117033711e-25,  1.059702744145020e-25,
 -1.685927552837678e-26,  2.027952523706189e-27, -1.959872031752717e-28,  1.582563788267910e-29, -1.097309830758201e-30,  6.666250121929296e-32, -3.603564972818335e-33,
  1.754664311683067e-34, -7.760969974530916e-36,  3.351607916640830e-25, -1.474943231761612e-25,  3.485209674568878e-26, -5.596523682067913e-27,  6.793964931702511e-28,
 -6.625244148231378e-29,  5.397043459549109e-30, -3.774440610261702e-31,  2.312283123358115e-32, -1.260190215025343e-33,  6.185174358177700e-35, -2.756956996895219e-36,
  5.319106123715478e-02, -1.162470469094054e-04,  2.617625251905359e-07, -6.049428518895717e-10,  1.427255296214330e-12, -3.421416651373499e-15,  8.289516085974257e-18,
 -2.024368077115893e-20,  4.959615900433351e-23, -1.219848408810475e-25,  2.993562197478671e-28, -7.377553270438140e-31,  4.927467127415856e-02, -1.268867730089604e-04,
  3.868917906151275e-07, -1.250274215159203e-09,  4.058453674542627e-12, -1.300724962249395e-14,  4.101502101042123e-17, -1.273666164887461e-19,  3.901073165829525e-22,
 -1.180785632613681e-24,  3.535677979946932e-27, -1.049008065855076e-29,  4.228658468389908e-02, -1.419036179223707e-04,  5.993694461428454e-07, -2.505940318208200e-09,
  1.003976758624001e-11, -3.876286716796832e-14,  1.453032444733811e-16, -5.316402782622089e-19,  1.905609010492419e-21, -6.709593796250376e-24,  2.325363590967685e-26,
 -7.945841477432664e-29,  3.361964015749144e-02, -1.523068471085078e-04,  8.343832154188746e-07, -4.228458161479191e-09,  2.006049472423561e-11, -9.068723859049055e-14,
  3.947158016328093e-16, -1.664903693676348e-18,  6.837044320564133e-21, -2.743077601359686e-23,  1.078178579467883e-25, -4.160781495568921e-28,  2.476410583857017e-02,
 -1.511340193007861e-04,  1.020303758210155e-06, -6.103838057940827e-09,  3.372920202263358e-11, -1.758962435632891e-13,  8.759661506399940e-16, -4.198729995510448e-18,
  1.948218574681317e-20, -8.788791573083938e-23,  3.867796955437982e-25, -1.664970294093220e-27,  1.690167802525969e-02, -1.365556796284030e-04,  1.102811985469037e-06,
 -7.687829220875209e-09,  4.893355220014792e-11, -2.911036945755140e-13,  1.640895463028990e-15, -8.846632473644745e-18,  4.592926641076071e-20, -2.307989075954110e-22,
  1.127026398805035e-24, -5.364790275548992e-27,  1.068969696509675e-02, -1.118875773622350e-04,  1.062911845337730e-06, -8.558351259562562e-09,  6.218581469742390e-11,
 -4.183552956524956e-13,  2.647464425763480e-15, -1.593085914439864e-17,  9.186434163243760e-20, -5.105999721189458e-22,  2.747882114872631e-24, -1.436955534709909e-26,
  6.266059030473247e-03, -8.317526131615080e-05,  9.199502750474771e-07, -8.493517268626545e-09,  6.993275340294258e-11, -5.283931868747016e-13,  3.729949055953493e-15,
 -2.489922878752305e-17,  1.585534780508925e-19, -9.693695412225746e-22,  5.718788402465733e-24, -3.268396246638007e-26,  3.404857420236354e-03, -5.621693114144735e-05,
  7.187490455318117e-07, -7.560973701812075e-09,  7.011529174029697e-11, -5.916754746382550e-13,  4.634730142561732e-15, -3.415388380671140e-17,  2.390411325693371e-19,
 -1.600339856098063e-21,  1.030490683421898e-23, -6.409791747374806e-26,  1.715458643248329e-03, -3.463369767674012e-05,  5.089475351425451e-07, -6.066375220978558e-09,
  6.303583928081470e-11, -5.913320536829458e-13,  5.117800337580157e-15, -4.146231713986602e-17,  3.177146197954915e-19, -2.320510106195936e-21,  1.625080740021807e-23,
 -1.096326041129110e-25,  8.016101126397481e-04, -1.949703110266253e-05,  3.276742410708586e-07, -4.403731660900559e-09,  5.105199154494715e-11, -5.302898800921698e-13,
  5.052201146926712e-15, -4.484387385064681e-17,  3.749822895678065e-19, -2.978509545017590e-21,  2.261717446919504e-23, -1.650067619563345e-25,  3.475361155424496e-04,
 -1.005253688564909e-05,  1.923334785350740e-07, -2.901802453161634e-09,  3.739008600433612e-11, -4.285813413229448e-13,  4.480691118975415e-15, -4.344429196213901e-17,
  3.953157862173260e-19, -3.405721201437434e-21,  2.796902411009049e-23, -2.201200945180014e-25,  1.398541061664792e-04, -4.757014303298551e-06,  1.031664470559256e-07,
 -1.740615736181348e-09,  2.484560104357815e-11, -3.133348190957509e-13,  3.584866066519401e-15, -3.787134430745618e-17,  3.740858095056816e-19, -3.487444900944275e-21,
  3.090580425501052e-23, -2.618253397615575e-25,  5.226514467435149e-05, -2.070081842496755e-06,  5.067923004690456e-08, -9.528665563877197e-10,  1.502298396734215e-11,
 -2.079002109411170e-13,  2.596718747700146e-15, -2.982203425346996e-17,  3.191000543740937e-19, -3.212617153768366e-21,  3.066323735323389e-23, -2.791075949961260e-25,
  1.815011085680604e-05, -8.299030647046673e-07,  2.284606320593493e-08, -4.771741182445890e-10,  8.287569202849513e-12, -1.255586336322148e-13,  1.708420353243217e-15,
 -2.128733161863206e-17,  2.462811755594163e-19, -2.672956201440134e-21,  2.743112552630145e-23, -2.678388820051056e-25,  5.861364314483990e-06, -3.070570949977348e-07,
  9.469710102595780e-09, -2.190824950155955e-10,  4.181574099886069e-12, -6.920920364657913e-14,  1.023910046862134e-15, -1.381776678512539e-17,  1.725648553115764e-19,
 -2.015877481824894e-21,  2.221071811102400e-23, -2.322995308114689e-25,  1.761796495805677e-06, -1.050323762260072e-07,  3.616223253209038e-09, -9.242125771023548e-11,
  1.934333306226396e-12, -3.490841274921405e-14,  5.605735120878432e-16, -8.180391180153448e-18,  1.101172212995575e-19, -1.382663991500630e-21,  1.633388541618897e-23,
 -1.827604176492094e-25,  4.934123417325273e-07, -3.327494691782839e-08,  1.274772007165981e-09, -3.590201684461706e-11,  8.222941059634365e-13, -1.615263551846501e-14,
  2.811092167042582e-16, -4.429612379208603e-18,  6.418619563924732e-20, -8.651974705913843e-22,  1.094592864630731e-23, -1.308772343921133e-25,  1.289165303799153e-07,
 -9.781807232765495e-09,  4.156911299333261e-10, -1.287132756533322e-11,  3.220082201915131e-13, -6.873922211993115e-15,  1.294640625408850e-16, -2.200036508672789e-18,
  3.427553183126215e-20, -4.954350583516399e-22,  6.705506214015127e-24, -8.559045345502766e-26,  3.147033256749200e-08, -2.673670634363755e-09,  1.256695135499682e-10,
 -4.268825954998725e-12,  1.164471823047832e-13, -2.697390376084928e-15,  5.490787168502495e-17, -1.005064997252490e-18,  1.681733628756651e-20, -2.604059518268166e-22,
  3.766956082662293e-24, -5.128298109196104e-26,  7.190488962141984e-09, -6.810029121801515e-10,  3.530612457478725e-11, -1.313013111455235e-12,  3.899015881514125e-14,
 -9.786917899370558e-16,  2.150588814114404e-17, -4.235692785612597e-19,  7.604405947159924e-21, -1.260230910855947e-22,  1.946743814027054e-24, -2.824379592941197e-26,
  1.540959466404718e-09, -1.620385328746047e-10,  9.242197261154988e-12, -3.755749994880830e-13,  1.212203922362951e-14, -3.292889717866332e-16,  7.802201935814415e-18,
 -1.651781770850670e-19,  3.178861588061071e-21, -5.633497231469465e-23,  9.285596639540939e-25, -1.434588328198189e-26,  3.105103212505524e-10, -3.611854042641769e-11,
  2.260894300132463e-12, -1.002088586205385e-13,  3.510247346551240e-15, -1.030652681716736e-16,  2.630358829418719e-18, -5.980049456720133e-20,  1.232611951788914e-21,
 -2.334041381744393e-23,  4.101950386079319e-25, -6.743807756809381e-27,  5.900405506453266e-11, -7.566020103626262e-12,  5.185611589397859e-13, -2.502447037439297e-14,
  9.500210008421684e-16, -3.011371475849317e-17,  8.269565069079863e-19, -2.017114100380665e-20,  4.449348393064128e-22, -8.995494685491066e-24,  1.684419902715962e-25,
 -2.944911914114279e-27,  1.060967341193842e-11, -1.494911002669775e-12,  1.119340539819839e-13, -5.871183936013998e-15,  2.412303070008054e-16, -8.245485767441510e-18,
  2.433967380094738e-19, -6.364067450147868e-21,  1.501055255514969e-22, -3.237815311507358e-24,  6.455404535189456e-26, -1.199420210449441e-27,  1.812552215996684e-12,
 -2.797684965621649e-13,  2.283623729198212e-14, -1.299757767199855e-15,  5.771871143646106e-17, -2.124987514093752e-18,  6.736016469157251e-20, -1.886306494073057e-21,
  4.753614245237334e-23, -1.093171604839527e-24,  2.319050780501600e-26, -4.576194866480936e-28,  2.955991722765077e-13, -4.983390213120069e-14,  4.425019232220092e-15,
 -2.728414518926345e-16,  1.307744306607569e-17, -5.179845119510410e-19,  1.761468292625828e-20, -5.278178534150354e-22,  1.420015669418277e-23, -3.478904491476784e-25,
  7.847170632405598e-27, -1.643492452438626e-28,  4.627471892944430e-14, -8.496284074839952e-15,  8.189895780746054e-16, -5.461478785019942e-17,  2.821508852331150e-18,
 -1.200923279875736e-19,  4.376561323672023e-21, -1.401967919071350e-22,  4.023245863864722e-24, -1.049231518048492e-25,  2.514625863103600e-27, -5.585822007206765e-29,
  6.998657084862904e-15, -1.395487687190481e-15,  1.457216738962663e-16, -1.049195936637553e-17,  5.833989569668397e-19, -2.665023208837058e-20,  1.039683868313034e-21,
 -3.556900947584695e-23,  1.087791359011827e-24, -3.017311960407998e-26,  7.677342192862171e-28, -1.807411717817688e-29,  1.030319952828622e-15, -2.224665856209614e-16,
  2.511200265404376e-17, -1.948718580750190e-18,  1.164504205675008e-19, -5.701677897007226e-21,  2.378320548883415e-22, -8.680354938781821e-24,  2.826274240366359e-25,
 -8.330390890864522e-27,  2.248353349356120e-28, -5.605054073702470e-30,  1.489303506481572e-16, -3.472046860494412e-17,  4.227203378935320e-18, -3.528956427805074e-19,
  2.262647951978856e-20, -1.185709341282720e-21,  5.281360945600341e-23, -2.053942680793890e-24,  7.111867163211422e-26, -2.225134689511275e-27,  6.364043668997169e-29,
 -1.678433190354941e-30,  2.134930026427757e-17, -5.357680227201061e-18,  7.018949272030858e-19, -6.290979102178780e-20,  4.320134770379081e-21, -2.419153374553181e-22,
  1.148932777240989e-23, -4.754693790636094e-25,  1.748573333293462e-26, -5.800375374269421e-28,  1.755956393895801e-29, -4.893977599439912e-31,  3.069941096086776e-18,
 -8.266609856529272e-19,  1.162386812591661e-19, -1.116079046735745e-20,  8.192684342044766e-22, -4.893449974366272e-23,  2.473922711814945e-24, -1.087733522684434e-25,
  4.242395121788861e-27, -1.489964855087483e-28,  4.767976029309218e-30, -1.402488635556982e-31,  4.485811694985402e-19, -1.291719596829501e-19,  1.944108164913668e-20,
 -1.994817768357750e-21,  1.561790934646016e-22, -9.929876450749309e-24,  5.333619311578271e-25, -2.487035293260191e-26,  1.026957813602354e-27, -3.812398748215717e-29,
  1.287577262776834e-30, -3.991114749567416e-32,  6.757969499704380e-20, -2.073438658559663e-20,  3.330044807457890e-21, -3.641519066415106e-22,  3.033157809910590e-23,
 -2.047974614084824e-24,  1.166125312640018e-25, -5.754570157438139e-27,  2.510678993076287e-28, -9.832835693422521e-30,  3.498343620011054e-31, -1.140657911253609e-32,
  1.066640117266995e-20, -3.473222790768013e-21,  5.932362523587543e-22, -6.892326995811398e-23,  6.090003877703748e-24, -4.354858755550891e-25,  2.621893661577045e-26,
 -1.365900026255603e-27,  6.281696315602892e-29, -2.589503888281959e-30,  9.683952016669543e-32, -3.314280086483733e-33,  1.794708442360124e-21, -6.175874718254870e-22,
  1.117598408503706e-22, -1.374686730790025e-23,  1.284270626681833e-24, -9.695571066607071e-26,  6.153594881769122e-27, -3.374549476671615e-28,  1.631348773519009e-29,
 -7.059484467909703e-31,  2.767788171164439e-32, -9.917824571096558e-34,  3.278761476081260e-22, -1.186860951547530e-22,  2.265888995167206e-23, -2.939021399983251e-24,
  2.892061365046849e-25, -2.296714196675448e-26,  1.531304545023801e-27, -8.809909766936440e-29,  4.462364769189357e-30, -2.020748648145259e-31,  8.280783174242271e-33,
 -3.097520774968805e-34,  6.625871709285173e-23, -2.510450690957170e-23,  5.032505657392043e-24, -6.852203945314970e-25,  7.071363752476064e-26, -5.882646165372335e-27,
  4.103723817561147e-28, -2.467294687875935e-29,  1.304489718813900e-30, -6.159161378352072e-32,  2.628682234983251e-33, -1.022917803178433e-34,  1.507498208450862e-23,
 -5.946381274726348e-24,  1.245059900995128e-24, -1.770540785996489e-25,  1.906822848640067e-26, -1.653805350514192e-27,  1.201548144417555e-28, -7.515872152541532e-30,
  4.129951393752228e-31, -2.024572556693106e-32,  8.962550257312023e-34, -3.613826417758718e-35,  3.918232838711098e-24, -1.599859526189728e-24,  3.478551944202463e-25,
 -5.137065848570805e-26,  5.741854000086094e-27, -5.164191200923640e-28,  3.887320956897300e-29, -2.517033856010264e-30,  1.430433577276485e-31, -7.245855207829637e-33,
  3.311705379226267e-34, -1.377394068852542e-35,  1.172327555681857e-24, -4.924880892034115e-25,  1.104928486026016e-25, -1.683952651098347e-26,  1.941515959023240e-27,
 -1.800024983591411e-28,  1.395723842831234e-29, -9.302270097165714e-31,  5.437477755721195e-32, -2.830960398866453e-33,  1.328929193977465e-34, -5.672627756284554e-36,
  4.004707825799162e-25, -1.719893289821319e-25,  3.954496548914928e-26, -6.177445729491811e-27,  7.297829766504173e-28, -6.929265260233072e-29,  5.499479945994624e-30,
 -3.749510121364552e-31,  2.240765285490467e-32, -1.192062891098102e-33,  5.714681041068643e-35, -2.489653272268087e-36,  1.484273920723007e-25, -6.473678713770926e-26,
  1.514400801174851e-26, -2.407257932011073e-27,  2.893167171446183e-28, -2.793721720995088e-29,  2.254057050604229e-30, -1.561672790778520e-31,  9.479999493820545e-33,
 -5.120751630430160e-34,  2.491601352791414e-35, -1.101267592195396e-36,  4.700878630009929e-26, -2.068090430435857e-26,  4.885108745908806e-27, -7.841738774718413e-28,
  9.516274933524775e-29, -9.276780646516251e-30,  7.554496647128572e-31, -5.281522048086674e-32,  3.234499687577788e-33, -1.762237860165586e-34,  8.646600166011027e-36,
 -3.852933024275249e-37,  5.273021581556030e-02, -1.141816008825997e-04,  2.546380038373004e-07, -5.826435738298659e-10,  1.360771444309561e-12, -3.229094778961819e-15,
  7.744268037815417e-18, -1.872461792494394e-20,  4.541264391945639e-23, -1.106351608896796e-25,  2.687189899875455e-28, -6.565601258005471e-31,  4.877322096274238e-02,
 -1.238505673764262e-04,  3.722696967956258e-07, -1.187367820363697e-09,  3.807870546783029e-12, -1.206431199698793e-14,  3.761732291466911e-17, -1.155368968556342e-19,
  3.500373329711477e-22, -1.048170200725992e-24,  3.105097991293270e-27, -9.115949704565693e-30,  4.172837345099429e-02, -1.372262743849012e-04,  5.702369967444933e-07,
 -2.351321560185180e-09,  9.298211949165887e-12, -3.544754668689942e-14,  1.312359585542969e-16, -4.743526163875151e-19,  1.679996967047041e-21, -5.845745030310613e-24,
  2.002482498710625e-26, -6.764158190511149e-29,  3.302344906329516e-02, -1.458294254998365e-04,  7.855092964150625e-07, -3.921500911153191e-09,  1.833782974749809e-11,
 -8.174962780151136e-14,  3.510187719693499e-16, -1.461120566252953e-18,  5.922948484020590e-21, -2.346295201006580e-23,  9.107500735184277e-26, -3.471561761562183e-28,
  2.417544333843581e-02, -1.432556592534690e-04,  9.501832072233614e-07, -5.591210705584427e-09,  3.041233836274333e-11, -1.562162018336438e-13,  7.666745672534244e-16,
 -3.623075120096269e-18,  1.657991218206798e-20, -7.378781380248788e-23,  3.204344302252960e-25, -1.361436721681440e-27,  1.637253424762091e-02, -1.280893186033279e-04,
  1.015070235399474e-06, -6.949410576442327e-09,  4.348605590195138e-11, -2.545359690283036e-13,  1.412576438832184e-15, -7.501576925550790e-18,  3.837813738857399e-20,
 -1.901063923585643e-22,  9.153650412018311e-25, -4.297571896692220e-27,  1.025852587881002e-02, -1.037787831185424e-04,  9.659161363615952e-07, -7.627008673854103e-09,
  5.441961641132582e-11, -3.598529923252547e-13,  2.239936600988716e-15, -1.326526960656200e-17,  7.531778505654646e-20, -4.123595655564293e-22,  2.186682797047520e-24,
 -1.127075951940943e-26,  5.947457515993694e-03, -7.620509892958779e-05,  8.244080042331598e-07, -7.454499394301826e-09,  6.020643773516391e-11, -4.466979546265119e-13,
  3.098855573317747e-15, -2.034239189989150e-17,  1.274491917677740e-19, -7.669874077729188e-22,  4.455603298797121e-24, -2.508342554086325e-26,  3.190940832518210e-03,
 -5.081165579018960e-05,  6.343766479954639e-07, -6.528063670581782e-09,  5.932090771173551e-11, -4.911038037119088e-13,  3.777387549347143e-15, -2.735201569141458e-17,
  1.882155074056799e-19, -1.239484923695827e-21,  7.854220771424034e-24, -4.809441757999906e-26,  1.584629041643497e-03, -3.083701500367219e-05,  4.418327806619308e-07,
 -5.146116307732375e-09,  5.234905926364110e-11, -4.813602551181526e-13,  4.087475631342248e-15, -3.251547046853974e-17,  2.448004339478101e-19, -1.757636382289396e-21,
  1.210575061194516e-23, -8.035343978900141e-26,  7.285486851896072e-04, -1.707389541513916e-05,  2.794006911010311e-07, -3.665561835759838e-09,  4.156362519947528e-11,
 -4.228418271875064e-13,  3.949612226136519e-15, -3.439873395672902e-17,  2.824297694247177e-19, -2.203988703318286e-21,  1.645038229452196e-23, -1.180205886469236e-25,
  3.101963110189645e-04, -8.643600908669649e-06,  1.608362889241740e-07, -2.366680521079129e-09,  2.980222699124890e-11, -3.343185872668635e-13,  3.424356890816943e-15,
 -3.255758390225612e-17,  2.907121938622170e-19, -2.459206873501814e-21,  1.984092113303000e-23, -1.534784721454984e-25,  1.223533742851496e-04, -4.008921872670714e-06,
  8.447164780976497e-08, -1.388882629973985e-09,  1.935990831162123e-11, -2.387781134887531e-13,  2.674763689693249e-15, -2.769162646318740e-17,  2.682662456131820e-19,
 -2.454381446467744e-21,  2.135798736829896e-23, -1.777604016105759e-25,  4.472864540929000e-05, -1.706594683817224e-06,  4.056006364718116e-08, -7.426411617639398e-10,
  1.142609474727185e-11, -1.545442588434410e-13,  1.888829987242371e-15, -2.124668857924784e-17,  2.228508981997533e-19, -2.200782110760785e-21,  2.061698617553925e-23,
 -1.842881189602084e-25,  1.516271826193548e-05, -6.679620180880740e-07,  1.783941060022706e-08, -3.626223141923579e-10,  6.142388787949981e-12, -9.090041194283651e-14,
  1.209628991858966e-15, -1.475528496081723e-17,  1.672583184270040e-19, -1.779869619819538e-21,  1.792049620086025e-23, -1.717633287522424e-25,  4.769478237566887e-06,
 -2.407751195036372e-07,  7.200464035202048e-09, -1.620367243335804e-10,  3.014750912464597e-12, -4.871552462430976e-14,  7.045273365425658e-16, -9.303559593572050e-18,
  1.137920034810954e-19, -1.302843978317164e-21,  1.407798130681634e-23, -1.444860577154316e-25,  1.393180918293063e-06, -8.006134298153070e-08,  2.671995723449502e-09,
 -6.639754417858336e-11,  1.354027513301676e-12, -2.384692181365611e-14,  3.741874956874017e-16, -5.341179491765296e-18,  7.038938187070716e-20, -8.659395007486848e-22,
  1.002926457903490e-23, -1.100853712698786e-25,  3.782665074595231e-07, -2.459876771833753e-08,  9.133087856493843e-10, -2.500150160484931e-11,  5.577487979484716e-13,
 -1.068828292099210e-14,  1.816959494392242e-16, -2.799624849922693e-18,  3.970356287097323e-20, -5.241971864519211e-22,  6.500114799104579e-24, -7.622342316479761e-26,
  9.557327928475171e-08, -6.995962830405712e-09,  2.881057698098787e-10, -8.669111207105730e-12,  2.111882722018728e-13, -4.396853489051790e-15,  8.086753324101963e-17,
 -1.343397116937443e-18,  2.047874030551463e-20, -2.898638599121805e-22,  3.844419741807859e-24, -4.811605139814467e-26,  2.250177454911363e-08, -1.845222808418130e-09,
  8.405045174806599e-11, -2.774229311365009e-12,  7.367876335313103e-14, -1.664214042457727e-15,  3.307517293646290e-17, -5.917341979566089e-19,  9.686182848244837e-21,
 -1.468443339160215e-22,  2.081210436535196e-24, -2.777772797202132e-26,  4.944804524167145e-09, -4.522968173106063e-10,  2.272799244701693e-11, -8.213040963435704e-13,
  2.374318243887780e-14, -5.810815961890553e-16,  1.246521254019276e-17, -2.399269212217618e-19,  4.213381089138949e-21, -6.835600560804844e-23,  1.034446298236946e-24,
 -1.471220378718968e-26,  1.016206415438324e-09, -1.032728224325241e-10,  5.710792313544060e-12, -2.255219330921576e-13,  7.086462298697702e-15, -1.876864687828924e-16,
  4.341197218984924e-18, -8.981280654839107e-20,  1.690626890828625e-21, -2.932887485911378e-23,  4.735669550597078e-25, -7.171975084541968e-27,  1.957609630283573e-10,
 -2.202353093045543e-11,  1.337077153031973e-12, -5.760340341223266e-14,  1.964711348389682e-15, -5.624857307031131e-17,  1.401440579159664e-18, -3.113686060551040e-20,
  6.277699087771141e-22, -1.163686301474872e-23,  2.003475807212004e-25, -3.228882170469135e-27,  3.544734227529594e-11, -4.399914419248312e-12,  2.926250038604136e-13,
 -1.373048181290052e-14,  5.076643884054131e-16, -1.569370861519255e-17,  4.207936708363820e-19, -1.003189169302365e-20,  2.164724599510711e-22, -4.284804802062575e-24,
  7.860814111128379e-26, -1.347372095723128e-27,  6.053145703296571e-12, -8.263772754432781e-13,  6.007931707249499e-14, -3.065430727189101e-15,  1.227077511569668e-16,
 -4.091658562307455e-18,  1.179590066283363e-19, -3.015180665098356e-21,  6.958533626326190e-23, -1.469793546436201e-24,  2.871567531185474e-26, -5.231709246367631e-28,
  9.786053641165518e-13, -1.465048265444740e-13,  1.161965319307485e-14, -6.436936447274835e-16,  2.786181932938875e-17, -1.001072233465892e-18,  3.100266295373918e-20,
 -8.490049299383031e-22,  2.094085831988590e-23, -4.716992643563869e-25,  9.808362609830214e-27, -1.898377002525498e-28,  1.504731150740602e-13, -2.463282983253509e-14,
  2.127100012721071e-15, -1.277407719951054e-16,  5.971341583188394e-18, -2.309433809611432e-19,  7.676305923189449e-21, -2.250348124976742e-22,  5.927966183305188e-24,
 -1.423072154653949e-25,  3.147499847308249e-27, -6.467943763048371e-29,  2.212521860044959e-14, -3.949588971446486e-15,  3.706005179332223e-16, -2.409003925990558e-17,
  1.214637416447727e-18, -5.051220989844563e-20,  1.800344311726036e-21, -5.645258818636277e-23,  1.587050384888356e-24, -4.057589061614956e-26,  9.539830370579364e-28,
 -2.080158363282757e-29,  3.130824379307965e-15, -6.077767359761511e-16,  6.184770309869438e-17, -4.344757175224931e-18,  2.359809600337648e-19, -1.054045737192960e-20,
  4.024457873643202e-22, -1.348614244273512e-23,  4.042975767617930e-25, -1.100061848201210e-26,  2.747431998569430e-28, -6.352665178894019e-30,  4.295480893472281e-16,
 -9.043246663915185e-17,  9.959910597681755e-18, -7.549199582652209e-19,  4.410805652616488e-20, -2.113563025143735e-21,  8.635599138135693e-23, -3.089656625461856e-24,
  9.868477127986149e-26, -2.855301183528064e-27,  7.569510112936421e-29, -1.854615234329797e-30,  5.764037201513591e-17, -1.312339188367471e-17,  1.561057214245614e-18,
 -1.274434256309694e-19,  7.998262385281581e-21, -4.106199802522316e-22,  1.793233760517918e-23, -6.842691296907076e-25,  2.326287662540093e-26, -7.150706260974892e-28,
  2.010439653233050e-29, -5.215190044621007e-31,  7.641740880225463e-18, -1.876073044751900e-18,  2.404908463500102e-19, -2.110755990869433e-20,  1.420586342961140e-21,
 -7.802333328347975e-23,  3.637169775715901e-24, -1.478405539919974e-25,  5.343552617061227e-27, -1.743137732893174e-28,  5.192253364325086e-30, -1.424625354513368e-31,
  1.012678912282170e-18, -2.672565922218649e-19,  3.683071193326742e-20, -3.468128172143940e-21,  2.498505587484061e-22, -1.465641191197930e-23,  7.281893504235090e-25,
 -3.148438691547743e-26,  1.208230015424112e-27, -4.177489393247386e-29,  1.316723429941186e-30, -3.816773207366547e-32,  1.359440315455295e-19, -3.844008725348192e-20,
  5.680071122298116e-21, -5.725086326557940e-22,  4.405725989113772e-23, -2.755008860451250e-24,  1.456272198630222e-25, -6.686307003788721e-27,  2.719999686587563e-28,
 -9.952700942222548e-30,  3.314700547455109e-31, -1.013660580302438e-32,  1.876812970094715e-20, -5.665861601654450e-21,  8.950545154821574e-22, -9.631302387721305e-23,
  7.898225088287450e-24, -5.253208014440769e-25,  2.948063130447461e-26, -1.434535124213761e-27,  6.174474731307849e-29, -2.386661473476421e-30,  8.384167436137972e-32,
 -2.700345483700502e-33,  2.710112134649631e-21, -8.701007953912220e-22,  1.464660743450757e-22, -1.677572136055361e-23,  1.461937288143473e-24, -1.031525467955328e-25,
  6.130710546334314e-27, -3.154220072829754e-28,  1.433197505693903e-29, -5.839444292729520e-31,  2.159209155044977e-32, -7.309370395378905e-34,  4.169675748657502e-22,
 -1.417694001598599e-22,  2.533485660662748e-23, -3.078077670159856e-24,  2.841376912487632e-25, -2.120350243977998e-26,  1.330729238599459e-27, -7.218763201189061e-29,
  3.453290496455373e-30, -1.479260977838573e-31,  5.742878574434779e-33, -2.038351290077730e-34,  6.972144307898618e-23, -2.498808620275260e-23,  4.720726271273912e-24,
 -6.059990821714109e-25,  5.903310783138087e-26, -4.642455388275794e-27,  3.066126320599947e-28, -1.747912438728501e-29,  8.775269813999925e-31, -3.939827653077534e-32,
  1.601116622431946e-33, -5.941166028062718e-35,  1.293113132099404e-23, -4.860654927515582e-24,  9.661489958253667e-25, -1.304497696861988e-25,  1.335240731398688e-26,
 -1.101987530157299e-27,  7.628452707308122e-29, -4.552386228050008e-30,  2.389575680572141e-31, -1.120372386993878e-32,  4.749352099776191e-34, -1.836072443265899e-35,
  2.713267444478529e-24, -1.063799179939827e-24,  2.212888948739326e-25, -3.126480647674584e-26,  3.345839503269165e-27, -2.884041905965888e-28,  2.082866251766697e-29,
 -1.295337124104441e-30,  7.077989275592467e-32, -3.450926067647825e-33,  1.519652784720201e-34, -6.096297961206488e-36,  6.550877900815576e-25, -2.663220851731016e-25,
  5.763271637072405e-26, -8.471045567045749e-27,  9.424722182506485e-28, -8.438540005958735e-29,  6.324425601468290e-30, -4.077769680232687e-31,  2.307918629894794e-32,
 -1.164437683359767e-33,  5.301575499582984e-35, -2.196813816653892e-36,  1.838427922437749e-25, -7.701099005955688e-26,  1.722364799423868e-26, -2.616703090409539e-27,
  3.007637947893108e-28, -2.780082082944428e-29,  2.149364291638961e-30, -1.428460597296043e-31,  8.326882683699144e-33, -4.323747502920290e-34,  2.024439573759497e-35,
 -8.619862828112160e-37,  5.962631269653424e-26, -2.556501259524542e-26,  5.867234010522922e-27, -9.148418801093395e-28,  1.078796850796499e-28, -1.022494758391410e-29,
  8.101105783694471e-31, -5.514005438926043e-32,  3.289879811566382e-33, -1.747408419128386e-34,  8.364093304163453e-36, -3.638468247061702e-37,  2.128562498792103e-26,
 -9.276274393106387e-27,  2.168062121026736e-27, -3.443174262035409e-28,  4.134480889297260e-29, -3.988871004820521e-30,  3.215587916766864e-31, -2.225992468637891e-32,
  1.350173674150489e-33, -7.287390917239841e-35,  3.543097363831276e-36, -1.564852436214605e-37,  6.598314177699523e-27, -2.901923096386313e-27,  6.852279343954998e-28,
 -1.099550581336264e-28,  1.333868184774931e-29, -1.299835943693025e-30,  1.058144023419935e-31, -7.395187529998974e-33,  4.527421736231226e-34, -2.465840617795882e-35,
  1.209498529571351e-36, -5.387833091463298e-38,  5.227751985532639e-02, -1.121720984571001e-04,  2.477748160391756e-07, -5.613779627104366e-10,  1.298006538946299e-12,
 -3.049363212930827e-15,  7.239739312379347e-18, -1.733311985617364e-20,  4.161649238747534e-23, -1.004424775255291e-25,  2.414355213932165e-28, -5.850980378194621e-31,
  4.828368620687137e-02, -1.209283857410800e-04,  3.583790320219217e-07, -1.128324206123093e-09,  3.575356823262731e-12, -1.119908493770551e-14,  3.453360029901618e-17,
 -1.049162395797090e-19,  3.144455202833440e-22, -9.316274075462470e-25,  2.730650284098328e-27, -7.933540052130284e-30,  4.118841694581426e-02, -1.327747655226083e-04,
  5.428909132481799e-07, -2.208055053758643e-09,  8.619712404042901e-12, -3.245138035822462e-14,  1.186761561268200e-16, -4.238109072119081e-19,  1.483278779293910e-21,
 -5.101222804628024e-24,  1.727375402934086e-26, -5.768687766423947e-29,  3.245240835753327e-02, -1.397287166356906e-04,  7.401592079855144e-07, -3.640731381461423e-09,
  1.678387534064406e-11, -7.379545245698940e-14,  3.126387405136018e-16, -1.284426588658547e-18,  5.140336053087703e-21, -2.010791679693662e-23,  7.709072122887371e-26,
 -2.902834508375311e-28,  2.361721007398280e-02, -1.359145306738422e-04,  8.859083072655598e-07, -5.128641584078307e-09,  2.746409883065003e-11, -1.389757813480516e-13,
  6.722739057939246e-16, -3.132658503858233e-18,  1.414052591805219e-20, -6.209250076321315e-23,  2.661167528692337e-25, -1.116098989552435e-27,  1.587590614498003e-02,
 -1.202908754926095e-04,  9.356897535395074e-07, -6.292586434239074e-09,  3.871803255770263e-11, -2.230219689093508e-13,  1.218745153260732e-15, -6.376265035527263e-18,
  3.215021909869649e-20, -1.570107049578684e-22,  7.455657370698904e-25, -3.452906326221064e-27,  9.858305951008863e-03, -9.640327691579805e-05,  8.793879403355134e-07,
 -6.811071968134409e-09,  4.773140717249933e-11, -3.102924317293456e-13,  1.900134693034307e-15, -1.107666257134049e-17,  6.193465695678223e-20, -3.340595141981520e-22,
  1.745783700029134e-24, -8.870381500734119e-27,  5.655283362415972e-03, -6.995192837185902e-05,  7.404515885637882e-07, -6.558812838920762e-09,  5.197234525361533e-11,
 -3.787239429436658e-13,  2.582448182353710e-15, -1.667345331777027e-17,  1.027963974902315e-19, -6.090257425512239e-22,  3.484367794380027e-24, -1.932493552088177e-26,
  2.997369936736090e-03, -4.603457009607722e-05,  5.614258351479076e-07, -5.652828696585714e-09,  5.034672026580195e-11, -4.089953531326316e-13,  3.089553021888333e-15,
 -2.198633794899654e-17,  1.487736859251087e-19, -9.638926749527919e-22,  6.011574055705044e-24, -3.624404251836000e-26,  1.467978380494587e-03, -2.753582591015679e-05,
  3.848036533620822e-07, -4.380513270905971e-09,  4.363344159493594e-11, -3.933561279310367e-13,  3.277829013466568e-15, -2.560730140924187e-17,  1.894517994706474e-19,
 -1.337387206282236e-21,  9.060645933679551e-24, -5.918141556471687e-26,  6.644600851972646e-04, -1.500394236118447e-05,  2.391408121353443e-07, -3.063358229005199e-09,
  3.398166196392452e-11, -3.386568546985605e-13,  3.101898047380232e-15, -2.651298795929919e-17,  2.137770064087755e-19, -1.639234828688633e-21,  1.202825923912692e-23,
 -8.487268965360372e-26,  2.780262291240169e-04, -7.462885675119024e-06,  1.350901471357562e-07, -1.939162533758077e-09,  2.386896493710456e-11, -2.620987916846458e-13,
  2.630694408619841e-15, -2.453042671171681e-17,  2.149752048588735e-19, -1.785896926273994e-21,  1.415755030947938e-23, -1.076566184184409e-25,  1.075706608025498e-04,
 -3.394890684904083e-06,  6.951663162250188e-08, -1.114087865801828e-09,  1.516817193762520e-11, -1.829942260357354e-13,  2.007390813556151e-15, -2.037012234670637e-17,
  1.935701215527085e-19, -1.738286108778522e-21,  1.485556875763022e-23, -1.214866640673387e-25,  3.849888387740097e-05, -1.414872906155179e-06,  3.265073430122277e-08,
 -5.822763482280720e-10,  8.744214788697645e-12, -1.156132834717161e-13,  1.382898330156255e-15, -1.523856570184421e-17,  1.566993494751219e-19, -1.518182695332300e-21,
  1.396118393852362e-23, -1.225663836440600e-25,  1.275093008468744e-05, -5.411104509605328e-07,  1.402236817210541e-08, -2.774411048555972e-10,  4.584117907150209e-12,
 -6.627688809300832e-14,  8.626869249128311e-16, -1.030342724785354e-17,  1.144494199087204e-19, -1.194298916584955e-21,  1.179890411152175e-23, -1.110265648493522e-25,
  3.910337447723636e-06, -1.901976480588737e-07,  5.516037785924814e-09, -1.207581762262605e-10,  2.190382368140165e-12, -3.456113204959573e-14,  4.886637962578066e-16,
 -6.315303953797505e-18,  7.565899219287514e-20, -8.491093297085126e-22,  8.999378512724724e-24, -9.064570200967844e-26,  1.111117128167741e-06, -6.153747608610313e-08,
  1.990924769414302e-09, -4.810728319830310e-11,  9.559828598489439e-13, -1.643278450126553e-14,  2.519840147507541e-16, -3.518656800434249e-18,  4.540294049045553e-20,
 -5.473058281611815e-22,  6.215345814390122e-24, -6.693247693472305e-26,  2.927788086103165e-07, -1.835549125535542e-08,  6.604808079242628e-10, -1.757499095910312e-11,
  3.819146515501273e-13, -7.140478919609505e-15,  1.185797207103380e-16, -1.786772584566913e-18,  2.480232286573089e-20, -3.207656457601597e-22,  3.898886554676408e-24,
 -4.484354457951252e-26,  7.161334440275205e-08, -5.055847390051903e-09,  2.017581834016098e-10, -5.899714843993395e-12,  1.399579346618939e-13, -2.842038223444240e-15,
  5.104793668378825e-17, -8.290631582692712e-19,  1.236689838851827e-20, -1.714231123015790e-22,  2.228059140089234e-24, -2.734506748802510e-26,  1.628012836347380e-08,
 -1.288216579954471e-09,  5.686018833324841e-11, -1.823573835491570e-12,  4.715267439105286e-14, -1.038571693118126e-15,  2.015333849435371e-17, -3.524148514773251e-19,
  5.643672637279821e-21, -8.377147590856407e-23,  1.163303260663997e-24, -1.522263903973011e-26,  3.444919335107419e-09, -3.042252873566393e-10,  1.481518854986399e-11,
 -5.201681400947829e-13,  1.463908518648826e-14, -3.493131567662604e-16,  7.315258965101895e-18, -1.376022614034037e-19,  2.363711801861333e-21, -3.754126229295360e-23,
  5.565709222977989e-25, -7.759853802049234e-27,  6.797348521379885e-10, -6.673636178229244e-11,  3.577197310880734e-12, -1.372638047840523e-13,  4.198810366728128e-15,
 -1.084202446235264e-16,  2.447985992896541e-18, -4.949037626199572e-20,  9.111994581568043e-22, -1.547379002768396e-23,  2.447555346585267e-25, -3.633506133430916e-27,
  1.253372829279551e-10, -1.363242189311914e-11,  8.025227921220432e-13, -3.360036199197568e-14,  1.115737634021927e-15, -3.114394667356296e-17,  7.574710082710866e-19,
 -1.644563340815787e-20,  3.243084035148880e-22, -5.884740901649029e-24,  9.924854323823456e-26, -1.567938248120752e-27,  2.165363490000434e-11, -2.600604973165996e-12,
  1.677839468608970e-13, -7.653183818293622e-15,  2.755396416729223e-16, -8.306010734173958e-18,  2.174263962978514e-19, -5.065812209982702e-21,  1.069263603614007e-22,
 -2.071945662662527e-24,  3.723865553640402e-26, -6.257225681573590e-28,  3.515957716107118e-12, -4.648529608616813e-13,  3.280309875655983e-14, -1.627687420713519e-15,
  6.346489304876384e-17, -2.064077740277627e-18,  5.810630293526893e-20, -1.451801959569097e-21,  3.277928701969457e-23, -6.779080741020442e-25,  1.297709752170560e-26,
 -2.318109589672608e-28,  5.385603683687668e-13, -7.816067550860015e-14,  6.021116489118846e-15, -3.245460672146274e-16,  1.368892683108931e-17, -4.798919437319065e-19,
  1.451699966773002e-20, -3.886972830051637e-22,  9.382014692546912e-24, -2.069692955287779e-25,  4.217775077775208e-27, -8.005729759904139e-29,  7.816787974018573e-14,
 -1.241863914240110e-14,  1.042419437910604e-15, -6.095009653901278e-17,  2.777873038396299e-18, -1.048738436661986e-19,  3.406402893910335e-21, -9.767516579078972e-23,
  2.518818397000269e-24, -5.923868809697377e-26,  1.284495828406363e-27, -2.589423747615902e-29,  1.080721926049771e-14, -1.874553232167932e-15,  1.711388341254305e-16,
 -1.083933896161968e-17,  5.332058732021469e-19, -2.165816883335016e-20,  7.547378009999641e-22, -2.315960781369196e-23,  6.376728852275262e-25, -1.597923338741493e-26,
  3.684703459242908e-28, -7.885118096151356e-30,  1.432200885029269e-15, -2.705134606973111e-16,  2.681162787393490e-17, -1.836868216441904e-18,  9.741298838556161e-20,
 -4.252927495311604e-21,  1.588685651538798e-22, -5.213064866188051e-24,  1.531509142505922e-25, -4.086557337193110e-27,  1.001551678735995e-28, -2.273929529876252e-30,
  1.832750541301106e-16, -3.759658593826597e-17,  4.037854386259109e-18, -2.987851095968853e-19,  1.706111107674569e-20, -7.997661593155850e-22,  3.199528011633597e-23,
 -1.121763470866316e-24,  3.513665832635731e-26, -9.976468552960156e-28,  2.597047534772332e-29, -6.251913514426954e-31,  2.284465575688492e-17, -5.076018549596117e-18,
  5.895807806790175e-19, -4.704531412214750e-20,  2.888627210070133e-21, -1.452194672642659e-22,  6.215413888606611e-24, -2.326151962351895e-25,  7.761679247022904e-27,
 -2.343161863775659e-28,  6.473885990844869e-30, -1.651254190927833e-31,  2.801991795671029e-18, -6.724874081793163e-19,  8.429800824737822e-20, -7.241120385132227e-21,
  4.773765126331871e-22, -2.570394360247506e-23,  1.175577239381930e-24, -4.691364108063800e-26,  1.665852733092764e-27, -5.341976009347205e-29,  1.565072944742331e-30,
 -4.225951645618667e-32,  3.422126675697902e-19, -8.845151035716813e-20,  1.193902247925274e-20, -1.101895688723859e-21,  7.786528349498873e-23, -4.483624950460411e-24,
  2.188187024016764e-25, -9.299382177186460e-27,  3.509849104805721e-28, -1.194202642235056e-29,  3.706033128265426e-31, -1.058243296556549e-32,  4.219094052545838e-20,
 -1.170675867829834e-20,  1.697242897033161e-21, -1.679416977693056e-22,  1.269601814487950e-23, -7.804228616450743e-25,  4.057663213321001e-26, -1.833579841778863e-27,
  7.345146094749997e-29, -2.647975754254237e-30,  8.692982542531384e-32, -2.621650434903660e-33,  5.333853470347653e-21, -1.583293146476732e-21,  2.458630158908384e-22,
 -2.601794049601321e-23,  2.099452344904391e-24, -1.374791251828885e-25,  7.600158227174268e-27, -3.644993145583566e-28,  1.547029889088237e-29, -5.899349399845433e-31,
  2.045399089444026e-32, -6.504750400312519e-34,  7.037969986986791e-22, -2.226477206957726e-22,  3.691402258535264e-23, -4.165713028632527e-24,  3.578443707171826e-25,
 -2.490083531543576e-26,  1.460224438259031e-27, -7.416060305166045e-29,  3.327727010527787e-30, -1.339528075353420e-31,  4.895338353989918e-33, -1.638492636806357e-34,
  9.884804076961812e-23, -3.318695178655725e-23,  5.853312335001670e-24, -7.020490541840776e-25,  6.400094307866342e-26, -4.718578257017292e-27,  2.926941592914599e-28,
 -1.569917584168916e-29,  7.428455656873991e-31, -3.148587176166830e-32,  1.209909354048094e-33, -4.252088942657220e-35,  1.509533671792743e-23, -5.353753650852883e-24,
  1.000333053684598e-24, -1.270249680767568e-25,  1.224401051138005e-26, -9.530809624647831e-28,  6.232610383584494e-29, -3.519150005330156e-30,  1.750458781478234e-31,
 -7.788815457387320e-33,  3.137933446837290e-34, -1.154635098454163e-35,  2.562902474435023e-24, -9.553150127515999e-25,  1.881985415736166e-25, -2.518712366550296e-26,
  2.555970153581109e-27, -2.091923245946480e-28,  1.436456922116056e-29, -8.505399179198854e-31,  4.430826513041882e-32, -2.062241597178386e-33,  8.680111752161034e-35,
 -3.332710603501042e-36,  4.945150770071197e-25, -1.926470346820308e-25,  3.979823325768527e-26, -5.584489252601495e-27,  5.936447413066057e-28, -5.083939495851617e-29,
  3.648580907681881e-30, -2.255251798202143e-31,  1.225054554682313e-32, -5.938754756021740e-34,  2.600735782834182e-35, -1.037744923829579e-36,  1.105728684634501e-25,
 -4.474620310887379e-26,  9.634756742386314e-27, -1.409093163054269e-27,  1.560089507987883e-28, -1.390224611044823e-29,  1.037138870322067e-30, -6.657300707055516e-32,
  3.751594665367611e-33, -1.884907830585701e-34,  8.547002047142454e-36, -3.527734754980345e-37,  2.902071704611369e-26, -1.211978671077789e-26,  2.701574872383126e-27,
 -4.090690840737743e-28,  4.686483114701096e-29, -4.318130485346144e-30,  3.328163810448348e-31, -2.205259317239080e-32,  1.281770294777567e-33, -6.636865921204973e-35,
  3.098988155010081e-36, -1.316033838653532e-37,  8.913315619246161e-27, -3.814861863718001e-27,  8.738037426341602e-28, -1.359789977794233e-28,  1.600391003512900e-29,
 -1.514010562095653e-30,  1.197335898209661e-31, -8.135151593666834e-33,  4.845380671998093e-34, -2.569294323944764e-35,  1.227810653377058e-36, -5.332697883318417e-38,
  3.058589521255752e-27, -1.331795130141002e-27,  3.109716590599662e-28, -4.933901566050537e-29,  5.918900315606250e-30, -5.705157035794886e-31,  4.595000575499315e-32,
 -3.178093846067509e-33,  1.926019811187401e-34, -1.038678962281324e-35,  5.045919666479716e-37, -2.226840672413154e-38,  9.268935599284440e-28, -4.075105151535280e-28,
  9.618898095852549e-29, -1.542909192895053e-29,  1.871001618241696e-30, -1.822587112158947e-31,  1.483152844413545e-32, -1.036178878090895e-33,  6.341383357641451e-35,
 -3.452618998587429e-36,  1.692944174652474e-37, -7.538908508776279e-39,  5.183275368622932e-02, -1.102164975877236e-04,  2.411609066708838e-07, -5.410884779273439e-10,
  1.238718264396508e-12, -2.881286188174790e-15,  6.772525552952488e-18, -1.605743228560623e-20,  3.816836739579718e-23, -9.128083821878711e-26,  2.171046785240593e-28,
 -5.221661255152153e-31,  4.780562232663638e-02, -1.181145572846601e-04,  3.451751275966586e-07, -1.072866297461771e-09,  3.359430986093505e-12, -1.040442360455634e-14,
  3.173192164946343e-17, -9.537018366392337e-20,  2.827917254285874e-22, -8.290719964974943e-25,  2.404539114756019e-27, -6.914555466137269e-30,  4.066583957233125e-02,
 -1.285353286377496e-04,  5.172008175743854e-07, -2.075181062754603e-09,  7.998232887632909e-12, -2.974035457934847e-14,  1.074472745626836e-16, -3.791557457517958e-19,
  1.311483795445526e-21, -4.458460758106195e-24,  1.492551354028067e-26, -4.928485766260079e-29,  3.190506564311937e-02, -1.339777424438144e-04,  6.980342664043291e-07,
 -3.383600869179894e-09,  1.538017980951793e-11, -6.670575075760801e-14,  2.788729452544349e-16, -1.130946957382800e-18,  4.469011339275392e-21, -1.726524489684003e-23,
  6.538525386014111e-26, -2.432464516982479e-28,  2.308734698214809e-02, -1.290661744689701e-04,  8.269121980851504e-07, -4.710604411362008e-09,  2.483907982505346e-11,
 -1.238446430279361e-13,  5.905724878835214e-16, -2.713964845154166e-18,  1.208553084030671e-20, -5.236844348675082e-23,  2.215331842154913e-25, -9.172701415897644e-28,
  1.540924987593453e-02, -1.130971992695644e-04,  8.637534399677975e-07, -5.707250860062918e-09,  3.453621003391671e-11, -1.958032792343589e-13,  1.053802665995363e-15,
 -5.432424884667918e-18,  2.699994639185288e-20, -1.300180271704324e-22,  6.089479074467390e-25, -2.782325279389361e-27,  9.486263135614603e-03, -8.968257795903183e-05,
  8.020402462424750e-07, -6.094640025142036e-09,  4.195758096979217e-11, -2.681976505461953e-13,  1.616018779370904e-15, -9.274422205453324e-18,  5.107679096037044e-20,
 -2.714507907690674e-22,  1.398228230736636e-24, -7.004477809534326e-27,  5.386843629617919e-03, -6.432955674536666e-05,  6.664957119409811e-07, -5.784635927376172e-09,
  4.498167703221305e-11, -3.219950916411705e-13,  2.158530790532126e-15, -1.370944717393817e-17,  8.318798498459023e-20, -4.852807347069615e-22,  2.734745807812696e-24,
 -1.494472627754379e-26,  2.821803399996943e-03, -4.180140138389283e-05,  4.981677397994440e-07, -4.908891677928878e-09,  4.286109094063385e-11, -3.417260022503868e-13,
  2.535683236387091e-15, -1.773732171493179e-17,  1.180432473586262e-19, -7.525407141517972e-22,  4.620128229266180e-24, -2.742986668797997e-26,  1.363675016817680e-03,
 -2.465636431785010e-05,  3.361798973865429e-07, -3.741272899492017e-09,  3.649828105275130e-11, -3.226493337345131e-13,  2.638931720107630e-15, -2.025002447206096e-17,
  1.472471072050469e-19, -1.022155708977436e-21,  6.812802188840333e-24, -4.379557617667200e-26,  6.080501554511929e-04, -1.322910372513437e-05,  2.054316841915899e-07,
 -2.570031022544383e-09,  2.789662415480525e-11, -2.723980277187241e-13,  2.447056955588665e-15, -2.053030812647215e-17,  1.625943561568958e-19, -1.225284812293428e-21,
  8.840174431789121e-24, -6.135839283679987e-26,  2.501974195874606e-04, -6.469129149246596e-06,  1.139491382104441e-07, -1.595984744328153e-09,  1.920649964657209e-11,
 -2.064827150923567e-13,  2.031214747663275e-15, -1.857923941311751e-17,  1.598290200114543e-19, -1.304154047581403e-21,  1.015995329971418e-23, -7.595822150072852e-26,
  9.502417165565681e-05, -2.888370165407338e-06,  5.749092367695542e-08, -8.982405862228730e-10,  1.194724798370433e-11, -1.410152249038938e-13,  1.515100032376168e-15,
 -1.507214656271381e-17,  1.405131541456791e-19, -1.238721917057949e-21,  1.039814286959043e-23, -8.356439603077837e-26,  3.332069101548083e-05, -1.179402567283090e-06,
  2.643202615361787e-08, -4.591992253362238e-10,  6.732010985184173e-12, -8.702415017164902e-14,  1.018914749936998e-15, -1.100061528427302e-17,  1.109192268170050e-19,
 -1.054439814466113e-21,  9.519877407863324e-24, -8.209490119108669e-26,  1.079139677687385e-05, -4.410956891483014e-07,  1.109280033811273e-08, -2.136656982671535e-10,
  3.444238223591155e-12, -4.865719681652979e-14,  6.195987112035800e-16, -7.246646077869104e-18,  7.889020038761283e-20, -8.073861379431753e-22,  7.827698328369083e-24,
 -7.232344738109363e-26,  3.229402558470898e-06, -1.513186268692218e-07,  4.256316979445428e-09, -9.066016027518538e-11,  1.603418448478759e-12, -2.470750142269320e-14,
  3.415886511715784e-16, -4.320949074220325e-18,  5.071143150040663e-20, -5.579379428181772e-22,  5.800803517691023e-24, -5.734852634328411e-26,  8.935025325125609e-07,
 -4.768219828116479e-08,  1.495545574591770e-09, -3.514297705784353e-11,  6.806000718715917e-13, -1.141988250955680e-14,  1.711514987368042e-16, -2.338255637760274e-18,
  2.954513860997666e-20, -3.490165322368244e-22,  3.886702552189937e-24, -4.106846801294711e-26,  2.287223527015879e-07, -1.382129083447243e-08,  4.819900160895470e-10,
 -1.246772853120067e-11,  2.639336658801084e-13, -4.814918272672110e-15,  7.811966876046402e-17, -1.151240470081755e-18,  1.564315398207292e-20, -1.981940932011772e-22,
  2.361615095801197e-24, -2.664391732922404e-26,  5.421825646888950e-08, -3.690823250794988e-09,  1.427176714167633e-10, -4.055703055575767e-12,  9.369734035746142e-14,
 -1.855875181409134e-15,  3.255701475476311e-17, -5.169702793628833e-19,  7.546498068380884e-21, -1.024480321426285e-22,  1.305006060611532e-24, -1.570680080240627e-26,
  1.191465518202218e-08, -9.094642602137339e-10,  3.889527428806738e-11, -1.212043170520591e-12,  3.051348179670199e-14, -6.553906552807511e-16,  1.241787381108936e-17,
 -2.122550148278002e-19,  3.325591270028589e-21, -4.833423572646184e-23,  6.576746624613312e-25, -8.438110409171307e-27,  2.430520630807328e-09, -2.071649300131920e-10,
  9.775634794479164e-12, -3.334645899781737e-13,  9.135786633192164e-15, -2.125443447132223e-16,  4.345317383917315e-18, -7.988071864793661e-20,  1.342263643432531e-21,
 -2.087041854862650e-23,  3.031335711145641e-25, -4.143248538643217e-27,  4.610111165745573e-10, -4.371154832479805e-11,  2.270742582668572e-12, -8.465575879058599e-14,
  2.520745427591721e-15, -6.345663294373633e-17,  1.398580116206436e-18, -2.762969890828031e-20,  4.975635384102965e-22, -8.271143065654857e-24,  1.281593386011986e-25,
 -1.865000962975840e-27,  8.146759195553916e-11, -8.563197351545338e-12,  4.886918448985908e-13, -1.988157555211743e-14,  6.426730259056180e-16, -1.748904312816088e-17,
  4.152034681488680e-19, -8.808634226192259e-21,  1.698948391261477e-22, -3.017640823675638e-24,  4.985389452898234e-26, -7.720185103744456e-28,  1.344533696443984e-11,
 -1.561736501890131e-12,  9.771722131952886e-14, -4.332048947212646e-15,  1.518518179819523e-16, -4.463081431683246e-18,  1.140477180797550e-19, -2.596621738090397e-21,
  5.360765492490099e-23, -1.016846371958259e-24,  1.790285289768001e-26, -2.948842500719365e-28,  2.078471007886671e-12, -2.660007002618977e-13,  1.821343234968572e-14,
 -8.786767878675187e-16,  3.336466576409542e-17, -1.058209670496354e-18,  2.908518009843353e-20, -7.102355509832103e-22,  1.568672375825640e-23, -3.176071557771139e-25,
  5.956597054673959e-27, -1.043147692325007e-28,  3.020200272278503e-13, -4.246918166163494e-14,  3.176478615179683e-15, -1.665437809474613e-16,  6.843466949817898e-18,
 -2.340321199871743e-19,  6.913959266516492e-21, -1.809719187915026e-22,  4.273942702501645e-24, -9.232408722420949e-26,  1.843656261968744e-27, -3.431414529916395e-29,
  4.142778770073710e-14, -6.383885112777977e-15,  5.206709456114739e-16, -2.963014349798805e-17,  1.316248640828158e-18, -4.849538616019137e-20,  1.538897409044171e-21,
 -4.315150310537259e-23,  1.089130229780365e-24, -2.508972516427094e-26,  5.332567406671200e-28, -1.054399036658208e-29,  5.391681914547233e-15, -9.081721633179367e-16,
  8.063252189331777e-17, -4.974096129128763e-18,  2.386374706046420e-19, -9.464732739788439e-21,  3.223860538945577e-22, -9.678461900387463e-24,  2.609330201074032e-25,
 -6.407227280218260e-27,  1.448766808111067e-28, -3.042048117953615e-30,  6.698517838748957e-16, -1.230235314446408e-16,  1.187005101637327e-17, -7.927326153230862e-19,
  4.103190430855895e-20, -1.750357853958605e-21,  6.394954391240958e-23, -2.054170274423137e-24,  5.912260629850043e-26, -1.546672313326460e-27,  3.718867167485948e-29,
 -8.288664066209331e-31,  8.002179651894589e-17, -1.598441664302548e-17,  1.673122347382533e-18, -1.208053061788637e-19,  6.738678220871977e-21, -3.088977619513345e-22,
  1.209546771647855e-23, -4.154187469399950e-25,  1.275628074828948e-26, -3.553222094561246e-28,  9.080014390151385e-30, -2.147069464328452e-31,  9.271658162316367e-18,
 -2.009160794003559e-18,  2.277319626414391e-19, -1.775175434763958e-20,  1.065870139621110e-21, -5.244865175723305e-23,  2.199122495660672e-24, -8.069160276966263e-26,
  2.641615734701683e-27, -7.829393839328085e-29,  2.125051852156064e-30, -5.327854380330774e-32,  1.052573603400169e-18, -2.467861916597421e-19,  3.023202910456089e-20,
 -2.540152209086188e-21,  1.639517357028093e-22, -8.650244901150600e-24,  3.879696149798851e-25, -1.519430559316992e-26,  5.298421264679792e-28, -1.669596110102397e-29,
  4.809457347198885e-31, -1.277560167641231e-32,  1.184940787240929e-19, -2.997406190666132e-20,  3.960142013100233e-21, -3.580245954221019e-22,  2.480260798857373e-23,
 -1.401198646833049e-24,  6.714069318409414e-26, -2.803356709602155e-27,  1.040176458394372e-28, -3.481318561633727e-30,  1.063306300168461e-31, -2.989836503569888e-33,
  1.341411987345513e-20, -3.649735899531699e-21,  5.188264238758004e-22, -5.036858123691805e-23,  3.738496195210601e-24, -2.257803968261201e-25,  1.154095630624430e-26,
 -5.130271397578862e-28,  2.022850928206951e-29, -7.181792757784293e-31,  2.323064479527918e-32, -6.906443899729856e-34,  1.551920371535959e-21, -4.526483868697386e-22,
  6.904907412967488e-23, -7.181532738918630e-24,  5.698893583355233e-25, -3.672170742793744e-26,  1.998761353209442e-27, -9.443313358895459e-29,  3.950383646781251e-30,
 -1.485484317541041e-31,  5.081170984716760e-33, -1.594902351731766e-34,  1.869110400586885e-22, -5.822435290099168e-23,  9.501846523064971e-24, -1.055845098634467e-24,
  8.935467195432170e-26, -6.128772023635532e-27,  3.544326347132051e-28, -1.776029226443441e-29,  7.866560037149608e-31, -3.127060948476046e-32,  1.128994127649017e-33,
 -3.734687174292451e-35,  2.392551921300610e-23, -7.927051023995845e-24,  1.379063360039546e-24, -1.631951660675664e-25,  1.468456429769364e-26, -1.069076377038665e-27,
  6.551186244257655e-29, -3.472719837744841e-30,  1.624609850933721e-31, -6.810615098017363e-33,  2.589392864078987e-34, -9.006934996787465e-36,  3.329873663781955e-24,
 -1.168026808278522e-24,  2.157308340858476e-25, -2.708386475692314e-26,  2.581898867774144e-27, -1.988348204365259e-28,  1.286865032203076e-29, -7.193664830568485e-31,
  3.543700052660644e-32, -1.562090347851997e-33,  6.236471680666555e-35, -2.274746289348612e-36,  5.161995680010250e-25, -1.907145000679306e-25,  3.721916757844237e-26,
 -4.935056146283954e-27,  4.962935183995831e-28, -4.026410817469904e-29,  2.741426528376560e-30, -1.609941962885149e-31,  8.320467100622875e-33, -3.842920235209044e-34,
  1.605509228967528e-35, -6.120118413175336e-37,  9.132370813013930e-26, -3.533593452649864e-26,  7.246840513858801e-27, -1.009545026255332e-27,  1.065620910816593e-28,
 -9.063592042057866e-30,  6.461609064008945e-31, -3.968444973025847e-32,  2.142292728743069e-33, -1.032293472024606e-34,  4.494397598676028e-36, -1.783277229827631e-37,
  1.885216610012499e-26, -7.591794084472782e-27,  1.626000676426517e-27, -2.365497380701067e-28,  2.605473874272501e-29, -2.310148040559585e-30,  1.715045244695145e-31,
 -1.095687614036810e-32,  6.146375031630451e-34, -3.074471868272145e-35,  1.388135876288801e-36, -5.705775120823966e-38,  4.613182072139101e-27, -1.920364194376649e-27,
  4.265447833607637e-28, -6.435841956349770e-29,  7.347652185671088e-30, -6.747309278626377e-31,  5.183414560792151e-32, -3.423660167141999e-33,  1.983825894844752e-34,
 -1.024142192307891e-35,  4.768273573670195e-37, -2.019269796512954e-38,  1.338073940911679e-27, -5.716122914423613e-28,  1.306563252586611e-28, -2.028991909955224e-29,
  2.383106041260400e-30, -2.249973997423912e-31,  1.775907232106597e-32, -1.204343298172121e-33,  7.160071419454169e-35, -3.789936826235595e-36,  1.808012134647014e-37,
 -7.839587121950232e-39,  4.404223006249365e-28, -1.915983862886489e-28,  4.469258528151015e-29, -7.083740623241593e-30,  8.489409939260278e-31, -8.174819821206577e-32,
  6.577806297428737e-33, -4.545254893016075e-34,  2.752069093612406e-35, -1.482852029235849e-36,  7.197559713504004e-38, -3.173758319700836e-39,  1.303123177005098e-28,
 -5.727217138792326e-29,  1.351325282063863e-29, -2.166717149480259e-30,  2.626422827314563e-31, -2.557466821255793e-32,  2.080376481136564e-33, -1.452875281483775e-34,
  8.888295591713548e-36, -4.837570514083714e-37,  2.371202828974321e-38, -1.055566439656927e-39,  5.139570561762592e-02, -1.083128499728562e-04,  2.347848884356094e-07,
 -5.217213105357667e-10,  1.182682229129612e-12, -2.724005832872439e-15,  6.339534559819513e-18, -1.488699016607249e-20,  3.503318969112301e-23, -8.303932868863284e-26,
  1.953744521490852e-28, -4.667304322229488e-31,  4.733860663120495e-02, -1.154037556312618e-04,  3.326165020806007e-07, -1.020739620908806e-09,  3.158747045775428e-12,
 -9.673906220813578e-15,  2.918388924137422e-17, -8.678040973252080e-20,  2.546055392167316e-22, -7.387069963121977e-25,  2.120113844724342e-27, -6.035111713115816e-30,
  4.015981876994767e-02, -1.244951995814474e-04,  4.930472907405330e-07, -1.951831208141628e-09,  7.428377111052219e-12, -2.728441828426392e-14,  9.739512681652838e-17,
 -3.396452223413152e-19,  1.161222945733955e-21, -3.902633295718869e-24,  1.291758159245034e-26, -4.218008999180588e-29,  3.138007184316358e-02, -1.285517968278191e-04,
  6.588646766656939e-07, -3.147837745089076e-09,  1.411051045741330e-11, -6.037719507324124e-14,  2.491185891716441e-16, -9.973988070621165e-19,  3.892070809146406e-21,
 -1.485188505863765e-23,  5.556654187970609e-26, -2.042573408269350e-28,  2.258396416967820e-02, -1.226704130320045e-04,  7.726901851753350e-07, -4.332249242954213e-09,
  2.249798776815104e-11, -1.105407769643278e-13,  5.197241229741306e-16, -2.355757749449662e-18,  1.035050360042958e-20, -4.426432883978466e-23,  1.848483800930390e-25,
 -7.557129230086688e-28,  1.497026026328667e-02, -1.064520148849557e-04,  7.984569897110022e-07, -5.184675879480964e-09,  3.086122316516547e-11, -1.722438407917057e-13,
  9.131192671424282e-16, -4.638845253136362e-18,  2.272976369442228e-20, -1.079425628576124e-22,  4.987110955184894e-25, -2.248348366443508e-27,  9.139917866046732e-03,
 -8.354778064303398e-05,  7.327620758356590e-07, -5.464208146836095e-09,  3.696135564143557e-11, -2.323533700531926e-13,  1.377821872213571e-15, -7.786101327474771e-18,
  4.224119892367550e-20, -2.212309787942862e-22,  1.123351819050520e-24, -5.549064275098912e-27,  5.139766351653976e-03, -5.926349033034604e-05,  6.011945786622263e-07,
 -5.113758886995416e-09,  3.903021832955976e-11, -2.745113373833835e-13,  1.809451535475204e-15, -1.130706316932009e-17,  6.753810218657852e-20, -3.879923025294750e-22,
  2.154007468154922e-24, -1.159998627660762e-26,  2.662211202445149e-03, -3.804052679874100e-05,  4.431604323871890e-07, -4.274645340689880e-09,  3.659701085604226e-11,
 -2.864263136946057e-13,  2.088090100189118e-15, -1.435996744407181e-17,  9.400658052128955e-20, -5.897964086374934e-22,  3.564976581007451e-24, -2.084544556942832e-26,
  1.270157496955059e-03, -2.213704769509444e-05,  2.945861512630707e-07, -3.205666747697022e-09,  3.063532496538125e-11, -2.656187449854537e-13,  2.132720058372210e-15,
 -1.607783467064689e-17,  1.149232313914788e-19, -7.846202726330656e-22,  5.145667296372218e-24, -3.256031737585626e-26,  5.582355165389848e-04, -1.170181810157585e-05,
  1.770994318467164e-07, -2.164263128038749e-09,  2.299226862078940e-11, -2.200173456584486e-13,  1.938876960924513e-15, -1.596975898154275e-17,  1.242478409121008e-19,
 -9.203253882371589e-22,  6.529712317000857e-24, -4.458812476061154e-26,  2.260297765202994e-04, -5.629216626410900e-06,  9.651298709179789e-08, -1.319236286155839e-09,
  1.552501167981828e-11, -1.634389747380040e-13,  1.576064858417107e-15, -1.414357077267707e-17,  1.194546680365299e-19, -9.575254657460234e-22,  7.331790964184924e-24,
 -5.389975467934793e-26,  8.432659997971784e-05, -2.468510856887529e-06,  4.777193103429338e-08, -7.278062105033687e-10,  9.458844828276026e-12, -1.092474731892875e-13,
  1.149859050643530e-15, -1.121563633630237e-17,  1.025966079783907e-19, -8.880362159820835e-22,  7.323027870832817e-24, -5.784207427586013e-26,  2.899351499255084e-05,
 -9.882809504560888e-07,  2.151450675303041e-08, -3.641801833767614e-10,  5.213051179381026e-12, -6.589793122202176e-14,  7.553684134314942e-16, -7.991593761121971e-18,
  7.902364884407101e-20, -7.372152999598594e-22,  6.535468759020982e-24, -5.536766868531435e-26,  9.189491529301639e-06, -3.617414396566322e-07,  8.829785408489849e-09,
 -1.655992611440500e-10,  2.604730316728417e-12, -3.596127495768502e-14,  4.480631323266630e-16, -5.132506517824478e-18,  5.476872652360441e-20, -5.498067361477918e-22,
  5.231725167794332e-24, -4.746847615528606e-26,  2.685908560792353e-06, -1.212185019785461e-07,  3.307354203279961e-09, -6.855129295615695e-11,  1.182324183237651e-12,
 -1.779491259532350e-14,  2.405940274697918e-16, -2.979285758211853e-18,  3.425761249799034e-20, -3.695469505542476e-22,  3.769455000219070e-24, -3.658164352289579e-26,
  7.242717678077564e-07, -3.723558478460817e-08,  1.132296778105841e-09, -2.587785246211873e-11,  4.884821340140962e-13, -8.001683612693836e-15,  1.172227349837219e-16,
 -1.567052224183748e-18,  1.939169801357251e-20, -2.245118340082167e-22,  2.452010433548664e-24, -2.542440869754963e-26,  1.802939556300694e-07, -1.049873911799196e-08,
  3.548393686889505e-10, -8.923329334168934e-12,  1.840395736762672e-13, -3.276290897343824e-15,  5.193824318005270e-17, -7.486595092846036e-19,  9.959132442436847e-21,
 -1.236235471549932e-22,  1.444196276136931e-24, -1.598395116944126e-26,  4.146279324449460e-08, -2.720837638438777e-09,  1.019444684659248e-10, -2.815502258086399e-12,
  6.334881105342051e-14, -1.223999214586509e-15,  2.097291398768731e-17, -3.256314278905173e-19,  4.652085433290913e-21, -6.185708930199558e-23,  7.722946762718385e-25,
 -9.116182574651810e-27,  8.817532282462120e-09, -6.490806803988903e-10,  2.689490380599410e-11, -8.143203180301580e-13,  1.996049751345556e-14, -4.180967994615667e-16,
  7.735396128636066e-18, -1.292470767611263e-19,  1.981342216393352e-21, -2.819821507060778e-23,  3.759771096670034e-25, -4.729942215195607e-27,  1.736052120276472e-09,
 -1.427709212719256e-10,  6.527285067995031e-12, -2.163140814434128e-13,  5.769023197865567e-15, -1.308616504101741e-16,  2.611862655647479e-18, -4.692528982759688e-20,
  7.713345574399718e-22, -1.174164156704071e-23,  1.670847368454615e-25, -2.238881872078529e-27,  3.169172427407347e-10, -2.900923232381843e-11,  1.460243437597906e-12,
 -5.288701524541252e-14,  1.532855880382313e-15, -3.761846590205643e-17,  8.093143126318341e-19, -1.562359204845049e-20,  2.751903832469104e-22, -4.478016226698935e-24,
  6.797070088761709e-26, -9.695911652458442e-28,  5.373858278554164e-11, -5.456612425311942e-12,  3.018155208386176e-13, -1.192959661680733e-14,  3.753573324545935e-16,
 -9.957625081235302e-18,  2.307444378388056e-19, -4.783268900416236e-21,  9.022910701154048e-23, -1.568702836872092e-24,  2.538615188310735e-26, -3.853363670956116e-28,
  8.483080591904041e-12, -9.525609894775153e-13,  5.778650825818184e-14, -2.489416212342431e-15,  8.494695042013197e-17, -2.434002700874960e-18,  6.071075282913261e-20,
 -1.350640471186070e-21,  2.727164426197728e-23, -5.063477167957756e-25,  8.732593248213458e-27, -1.409910982817531e-28,  1.250068969972409e-12, -1.547864561947694e-13,
  1.028047249948192e-14, -4.820902937936369e-16,  1.782376486481361e-17, -5.512003080873458e-19,  1.478954444856099e-20, -3.529242453635428e-22,  7.624366293547150e-24,
 -1.511148200519818e-25,  2.776371874748919e-27, -4.766283990545195e-29,  1.725330787279475e-13, -2.349473197887584e-14,  1.705554581150797e-15, -8.695731037154661e-17,
  3.480212029058222e-18, -1.160760520452490e-19,  3.348383662825306e-21, -8.566445548768782e-23,  1.979194488039593e-24, -4.185943869046614e-26,  8.190143410729070e-28,
 -1.494544817042473e-29,  2.239358619164000e-14, -3.345205152062640e-15,  2.649898367164448e-16, -1.467205566666843e-17,  6.350923859399561e-19, -2.282962142241617e-20,
  7.076064902552177e-22, -1.939941206709238e-23,  4.791405956861341e-25, -1.080964418403431e-26,  2.251615666814367e-28, -4.366101086385646e-30,  2.746706718419284e-15,
 -4.490112574746982e-16,  3.875145690753380e-17, -2.327408833627311e-18,  1.088637791940851e-19, -4.214699556391229e-21,  1.402849920099590e-22, -4.119355398423026e-24,
  1.087197940693553e-25, -2.615410125305137e-27,  5.797784295706461e-29, -1.194284627589122e-30,  3.202596507426786e-16, -5.715585643208014e-17,  5.365776941925023e-18,
 -3.491691307525208e-19,  1.763272638982722e-20, -7.346971826077871e-22,  2.624475194720413e-23, -8.250089825839141e-25,  2.325671472285460e-26, -5.963328717977126e-28,
  1.406346901873642e-29, -3.076352858603401e-31,  3.575012135157417e-17, -6.948947233989358e-18,  7.084956113373296e-19, -4.989247409497746e-20,  2.717541374688885e-21,
 -1.217670760029586e-22,  4.665152212075216e-24, -1.569030594703596e-25,  4.721842452619641e-27, -1.289919639867088e-28,  3.234934311848178e-30, -7.511635484372885e-32,
  3.853311969329458e-18, -8.137798914055249e-19,  8.995950812013987e-20, -6.846672862798894e-21,  4.018124742187798e-22, -1.934462585118442e-23,  7.942724098589533e-25,
 -2.856242118540734e-26,  9.170762691264612e-28, -2.667654438854079e-29,  7.110668882930856e-31, -1.751838868948595e-32,  4.051186158822378e-19, -9.272327830063091e-20,
  1.109368554191099e-20, -9.112280163379663e-22,  5.755197903905121e-23, -2.973988451763928e-24,  1.307475418738839e-25, -5.023087556028827e-27,  1.719465920212445e-28,
 -5.322257918242823e-30,  1.506877753178775e-31, -3.936504601434501e-33,  4.204896806024397e-20, -1.040220902961257e-20,  1.344339492120001e-21, -1.189825524009370e-22,
  8.076269276545589e-24, -4.474130073179686e-25,  2.103866397057690e-26, -8.626568086998915e-28,  3.145400034990054e-29, -1.035103494277575e-30,  3.110382418449697e-32,
 -8.609042323959248e-34,  4.370414129879341e-21, -1.165157637066632e-21,  1.622964446406918e-22, -1.544908951601805e-23,  1.125175553816811e-24, -6.672740727772849e-26,
  3.351589856532505e-27, -1.464932234815143e-28,  5.682872193770050e-30, -1.986120055114993e-31,  6.327454139516967e-33, -1.853695924831353e-34,  4.624779490759830e-22,
 -1.324465468507789e-22,  1.983409250234953e-23, -2.026194198385887e-24,  1.580308481472064e-25, -1.001469729300904e-26,  5.364179249987313e-28, -2.495415685219497e-29,
  1.028413587588525e-30, -3.811767851036344e-32,  1.285756886339743e-33, -3.981708309639760e-35,  5.079044892704074e-23, -1.556862447838141e-23,  2.499193002838247e-24,
 -2.732872158707431e-25,  2.277178768561908e-26, -1.538693482977435e-27,  8.770846709119573e-29, -4.334174555931254e-30,  1.894075067217830e-31, -7.431916999571899e-33,
  2.649682069862132e-34, -8.659203453437659e-36,  5.916328266458461e-24, -1.933185891986421e-24,  3.315234489786620e-25, -3.868463147842951e-26,  3.433874084430234e-27,
 -2.467314641902320e-28,  1.492880220146952e-29, -7.817231199239710e-31,  3.614019993782289e-32, -1.497811400636112e-33,  5.631971832432227e-35, -1.938179038580795e-36,
  7.488838506792744e-25, -2.596553326279813e-25,  4.737854077229291e-26, -5.877555447713167e-27,  5.538514571253001e-28, -4.217725796754064e-29,  2.700312172038221e-30,
 -1.493772720639595e-31,  7.284444655860337e-33, -3.179770538221563e-34,  1.257525897919483e-35, -4.545052145488981e-37,  1.057279883974684e-25, -3.869821646054666e-26,
  7.477717193355617e-27, -9.818549172156377e-28,  9.780519117811925e-29, -7.862100913893715e-30,  5.305484052172195e-31, -3.088974514558340e-32,  1.583182267805723e-33,
 -7.253407923800409e-35,  3.006799095535710e-36, -1.137568974931863e-37,  1.709945439153312e-26, -6.568848797586860e-27,  1.336813356648309e-27, -1.848115201297543e-28,
  1.936291669182502e-29, -1.635046599617783e-30,  1.157529073657089e-31, -7.061085386732261e-33,  3.786913537661287e-34, -1.813248810069754e-35,  7.846245784671704e-37,
 -3.094827252950800e-38,  3.248432756552388e-27, -1.301365591936660e-27,  2.771580771187792e-28, -4.009547366846308e-29,  4.392200394438865e-30, -3.873701552266422e-31,
  2.861041689060798e-32, -1.818731751135101e-33,  1.015321631659061e-34, -5.055044503394658e-36,  2.272066780094508e-37, -9.298340902546860e-39,  7.387577495867474e-28,
 -3.064715490174263e-28,  6.781611534454670e-29, -1.019386768605614e-29,  1.159531034072950e-30, -1.060983231234005e-31,  8.122402719040672e-33, -5.346833203238172e-34,
  3.088110709634071e-35, -1.589196177585923e-36,  7.376486012961264e-38, -3.114575293799086e-39,  2.017778480384555e-28, -8.602472755721748e-29,  1.961949717918830e-29,
 -3.039990324222925e-30,  3.562773705162149e-31, -3.356602127363272e-32,  2.643909058110419e-33, -1.789398645517491e-34,  1.061771551585230e-35, -5.609554215403027e-37,
  2.671193317098497e-38, -1.156194821090908e-39,  6.356024054968522e-29, -2.762420769605848e-29,  6.436750899705734e-30, -1.019118149838644e-30,  1.220049818577964e-31,
 -1.173618863413357e-32,  9.433883808080458e-34, -6.512387361250964e-35,  3.939360906492632e-36, -2.120607994564066e-37,  1.028384152499842e-38, -4.530682251792352e-40,
  1.833651126644280e-29, -8.055950833879225e-30,  1.900004718627286e-30, -3.045202172783758e-31,  3.689769195797804e-32, -3.591435167401257e-33,  2.920295084138774e-34,
 -2.038653470269589e-35,  1.246715553738905e-36, -6.782870505504718e-38,  3.323500218427605e-39, -1.478962694859736e-40,  5.096617157388773e-02, -1.064592958861856e-04,
  2.286359987556908e-07, -5.032261085297668e-10,  1.129690480244808e-12, -2.576735061391953e-15,  5.937954820475888e-18, -1.381228973112009e-20,  3.217963004076224e-23,
 -7.562024999064012e-26,  1.759350102333603e-28, -4.179045866594211e-31,  4.688223709038089e-02, -1.127909743983512e-04,  3.206646026225977e-07, -9.717102472750861e-10,
  2.972080892693669e-12, -9.001754442842555e-15,  2.686421692003940e-17, -7.904266580457855e-20,  2.294766978157850e-22, -6.589815775862461e-25,  1.871691141847772e-27,
 -5.275016799131859e-30,  3.966958118794093e-02, -1.206425292978758e-04,  4.703208354698888e-07, -1.837218837551119e-09,  6.905314423194169e-12, -2.505698339285015e-14,
  8.838485792853051e-17, -3.046377995194521e-19,  1.029598449247764e-21, -3.421204559741405e-24,  1.119767193033310e-26, -3.616128936469666e-29,  3.087617255505276e-02,
 -1.234282272763514e-04,  6.224064107083904e-07, -2.931414326555689e-09,  1.296056360992785e-11, -5.471988032456848e-14,  2.228576514458470e-16, -8.809952271785529e-19,
  3.395336474503755e-21, -1.279900095412869e-23,  4.731342629198259e-26, -1.718685457430802e-28,  2.210532473268802e-02, -1.166908837891406e-04,  7.227921797903618e-07,
 -3.989312014541300e-09,  2.040675052259382e-11, -9.882292814915948e-14,  4.581701826182577e-16, -2.048673423330339e-18,  8.882439119271932e-21, -3.749472666182087e-23,
  1.545895996097436e-25, -6.241054549056186e-28,  1.455684499523287e-02, -1.003050834448738e-04,  7.390936154582716e-07, -4.717307343609030e-09,  2.762538409580175e-11,
 -1.518088971540948e-13,  7.928567171852056e-16, -3.970003115788543e-18,  1.918028089690273e-20, -8.984018824169780e-23,  4.095110161313944e-25, -1.821897423790307e-27,
  8.817049398661543e-03, -7.793825440003757e-05,  6.705921387940911e-07, -4.908277782992823e-09,  3.262806587961332e-11, -2.017560913852835e-13,  1.177596960420617e-15,
 -6.553595621323127e-18,  3.503012896143229e-20, -1.808245625992978e-22,  9.052567230419814e-25, -4.410029506686528e-27,  4.911957314078338e-03, -5.468918035292671e-05,
  5.434025547269154e-07, -4.530941092021713e-09,  3.394982500399309e-11, -2.346517914363450e-13,  1.521124039150575e-15, -9.353647752549796e-18,  5.500567075770302e-20,
 -3.112359077862048e-22,  1.702462986676675e-24, -9.036259397737925e-27,  2.516828289861451e-03, -3.469089026145651e-05,  3.951974207278619e-07, -3.732329340824720e-09,
  3.133873478729856e-11, -2.408158502270610e-13,  1.725120277965692e-15, -1.166565676382781e-17,  7.513401455142575e-20, -4.639843498728663e-22,  2.761554538549173e-24,
 -1.590580952051460e-26,  1.186090307455562e-03, -1.992628408323449e-05,  2.588924408041552e-07, -2.755365385867214e-09,  2.580038023974972e-11, -2.194447993917894e-13,
  1.730047708926459e-15, -1.281515021761599e-17,  9.006063466213157e-20, -6.048350117150064e-22,  3.903539624077989e-24, -2.431708465872135e-26,  5.141057589698063e-04,
 -1.038297210335869e-05,  1.531981136975412e-07, -1.829205633980431e-09,  1.902323106945554e-11, -1.784297594990314e-13,  1.542744273645086e-15, -1.247712847580820e-17,
  9.538011434727129e-20, -6.945449494193009e-22,  4.846720872595166e-24, -3.256482461463243e-26,  2.049625059638200e-04, -4.916448981333320e-06,  8.207099030704867e-08,
 -1.095058411122718e-09,  1.260451435742452e-11, -1.299636465071289e-13,  1.228756619536911e-15, -1.082028941563590e-17,  8.973685260735131e-20, -7.067410932655962e-22,
  5.319643104923446e-24, -3.846056968146463e-26,  7.516501909694241e-05, -2.118854119721303e-06,  3.987878282307962e-08, -5.925453304848942e-10,  7.526223430260202e-12,
 -8.507595561462316e-14,  8.773544137706342e-16, -8.392149698885191e-18,  7.533892782414246e-20, -6.403608497047465e-22,  5.188321070288605e-24, -4.028367578175076e-26,
  2.535882298141724e-05, -8.323217185617950e-07,  1.760429935436232e-08, -2.904012693355767e-10,  4.059634979897086e-12, -5.019134551080265e-14,  5.633504476583185e-16,
 -5.841428939148345e-18,  5.665573519739549e-20, -5.187615762872075e-22,  4.516320057407521e-24, -3.759395319579850e-26,  7.872149445679188e-06, -2.983945283087908e-07,
  7.070681148838681e-09, -1.291386249745361e-10,  1.982350304809666e-12, -2.675117810886804e-14,  3.261796851035421e-16, -3.659968133251728e-18,  3.828786325198926e-20,
 -3.770670964526279e-22,  3.522037449611237e-24, -3.138525394890987e-26,  2.249163079441683e-06, -9.775368046961809e-08,  2.587440980028061e-09, -5.219383936191553e-11,
  8.780030728004922e-13, -1.290914560919372e-14,  1.707120013550997e-16, -2.069683885317661e-18,  2.331985757610624e-20, -2.466762522185951e-22,  2.468863693406735e-24,
 -2.352254049472920e-26,  5.916521685226081e-07, -2.929771904012597e-08,  8.638329497189105e-10, -1.920329544267665e-11,  3.533608455469260e-13, -5.651589030239997e-15,
  8.094095249941588e-17, -1.058899508494312e-18,  1.283447690874115e-20, -1.456517910967613e-22,  1.560254911453247e-24, -1.587714268926212e-26,  1.433628756084217e-07,
 -8.042858078783519e-09,  2.634662289312069e-10, -6.441703570660541e-12,  1.294509895388896e-13, -2.249055646348868e-15,  3.484058663227835e-17, -4.912704029366656e-19,
  6.398558810025094e-21, -7.782502491233637e-23,  8.914427238669116e-25, -9.679684080694895e-27,  3.201865548353529e-08, -2.024892165787923e-09,  7.351288200759311e-11,
 -1.973234243209470e-12,  4.324271878117145e-14, -8.151018962548266e-16,  1.364295223655149e-17, -2.071380397453687e-19,  2.896408108250742e-21, -3.772431806787853e-23,
  4.616732440249796e-25, -5.345067637866107e-27,  6.596542324042700e-09, -4.681551667988163e-10,  1.879292219448823e-11, -5.528734911743632e-13,  1.319531904777938e-14,
 -2.695532541660149e-16,  4.870061667893844e-18, -7.954758075491706e-20,  1.193221013709384e-21, -1.662977019122932e-23,  2.172881584971220e-25, -2.680503628821352e-27,
  1.254943577511354e-09, -9.954535450048757e-11,  4.408896243680733e-12, -1.419428385001304e-13,  3.685121745806138e-15, -8.150351846079287e-17,  1.588154665046477e-18,
 -2.788692283194776e-20,  4.484279184465391e-22, -6.683256187364445e-24,  9.317896186536551e-26, -1.224097416637668e-27,  2.207458405603728e-10, -1.949992014132111e-11,
  9.509766512381181e-13, -3.345750221677450e-14,  9.438605652060552e-16, -2.258143646657246e-17,  4.742110857695686e-19, -8.945652294484479e-21,  1.541161910117611e-22,
 -2.454942038760127e-24,  3.650349347415831e-26, -5.104406308686710e-28,  3.596092694195400e-11, -3.525996788959576e-12,  1.889856745530246e-13, -7.256480794380805e-15,
  2.222229147118476e-16, -5.746585677175241e-18,  1.299715927477361e-19, -2.632541202097175e-21,  4.856658813038798e-23, -8.264766392359122e-25,  1.310101648032946e-26,
 -1.949201887073974e-28,  5.436544866774532e-12, -5.898979877041151e-13,  3.468713235067377e-14, -1.451816746739290e-15,  4.822030201735399e-17, -1.346848569813328e-18,
  3.278851458949049e-20, -7.127206734376546e-22,  1.407407296056749e-23, -2.557670401510869e-25,  4.320625783947299e-27, -6.837474335832257e-29,  7.646512187525429e-13,
 -9.156234247405574e-14,  5.897036304057241e-15, -2.687379508776567e-16,  9.672465934013386e-18, -2.916152083691357e-19,  7.637450548598273e-21, -1.780842814453387e-22,
  3.762700497544414e-24, -7.299805142149184e-26,  1.313742432694688e-27, -2.210725618269625e-29,  1.003694077677612e-13, -1.322927834664114e-14,  9.317473715311377e-16,
 -4.618240210654391e-17,  1.799825738789472e-18, -5.853596066292673e-20,  1.648485321707149e-21, -4.121620308263762e-23,  9.314689341329022e-25, -1.928584451548376e-26,
  3.696750756649346e-28, -6.613244857404600e-30,  1.234221916838532e-14, -1.786310794795328e-15,  1.373768926299285e-16, -7.398170552848614e-18,  3.119555789470155e-19,
 -1.093832295666609e-20,  3.310825637088475e-22, -8.872806636650296e-24,  2.144125342787915e-25, -4.736532232315422e-27,  9.667619898968985e-29, -1.838175720601748e-30,
  1.428449247018827e-15, -2.264915386487126e-16,  1.899206072691895e-17, -1.110127135211004e-18,  5.060907699297004e-20, -1.912056310290699e-21,  6.217418776401459e-23,
 -1.785311420978641e-24,  4.611641203249411e-26, -1.086646841562337e-27,  2.361137112777851e-29, -4.770520882665889e-31,  1.564893766087973e-16, -2.712167890537922e-17,
  2.476142565442333e-18, -1.569355396640785e-19,  7.729126400851908e-21, -3.144540480357769e-22,  1.097949166716593e-23, -3.376708674426073e-25,  9.320564572372854e-27,
 -2.341917199684931e-28,  5.415837582339800e-30, -1.162472905977020e-31,  1.633998215447085e-17, -3.088548090607377e-18,  3.065629785939143e-19, -2.104502213376562e-20,
  1.118815261596485e-21, -4.898451996460365e-23,  1.835565059095553e-24, -6.043599094141837e-26,  1.781907209594891e-27, -4.772698592585517e-29,  1.174320862108210e-30,
 -2.677022326481070e-32,  1.639805403308030e-18, -3.372678569576549e-19,  3.634023434463358e-20, -2.699031593624860e-21,  1.547490114011062e-22, -7.285924389013380e-24,
  2.928296549320200e-25, -1.031635092084999e-26,  3.247538642033887e-28, -9.268319206173692e-30,  2.425411181168125e-31, -5.870025818783556e-33,  1.597632090068712e-19,
 -3.567013753825335e-20,  4.165418013566395e-21, -3.342900925991661e-22,  2.064954809002545e-23, -1.044601620223937e-24,  4.499650769445488e-26, -1.695083404049239e-27,
  5.693801376336987e-29, -1.730541817451929e-30,  4.814036256945912e-32, -1.236357010503490e-33,  1.529472953517522e-20, -3.697509380864161e-21,  4.671158038829172e-22,
 -4.044934249029645e-23,  2.688706247946570e-24, -1.459873323505570e-25,  6.733503755406420e-27, -2.710151463714978e-28,  9.706359113294873e-30, -3.139499378462156e-31,
  9.277670782700528e-33, -2.526808492056264e-34,  1.459562831298129e-21, -3.809968866854443e-22,  5.196549249678504e-23, -4.847245834961724e-24,  3.462120801288407e-25,
 -2.015055507193161e-26,  9.940425970039980e-28, -4.270044096645889e-29,  1.628969072572215e-30, -5.601855090507473e-32,  1.757000005683633e-33, -5.070214910318245e-35,
  1.412153596427943e-22, -3.967959469008996e-23,  5.829306479076906e-24, -5.845473704626910e-25,  4.478275046839730e-26, -2.789516147226605e-27,  1.469582256417351e-28,
 -6.728122651414868e-30,  2.730384109175223e-31, -9.970494667737217e-33,  3.315117348683282e-34, -1.012443374282047e-35,  1.412912907920297e-23, -4.258639239330736e-24,
  6.720074772536526e-25, -7.226814414719676e-26,  5.925538634888281e-27, -3.942198633428864e-28,  2.213741414321118e-29, -1.078255314451270e-30,  4.646866614850970e-32,
 -1.798942362976471e-33,  6.330784452842243e-35, -2.043059701973120e-36,  1.495580389896590e-24, -4.816263068876489e-25,  8.136518955448992e-26, -9.356188760984580e-27,
  8.188160940366940e-28, -5.803386854686163e-29,  3.465337535104511e-30, -1.791582941203278e-31,  8.181403786957158e-33, -3.350640398763731e-34,  1.245475767038318e-35,
 -4.238802937465684e-37,  1.718304226269760e-25, -5.885401470195029e-26,  1.060293734591382e-26, -1.299003987947053e-27,  1.209315970690597e-28, -9.101917053349730e-30,
  5.761696995360821e-31, -3.152615068826877e-32,  1.521225905218467e-33, -6.572902982876999e-35,  2.573881352199557e-36, -9.214410857395515e-38,  2.203709620526472e-26,
 -7.986583571030592e-27,  1.527230389343708e-27, -1.984790748550859e-28,  1.957430165915718e-29, -1.558327393869987e-30,  1.041790906537437e-31, -6.010930049510097e-33,
  3.053946441276084e-34, -1.387399687762420e-35,  5.704442125935989e-37, -2.141203468014256e-38,  3.248367837806352e-27, -1.238392784195491e-27,  2.499752559793976e-28,
 -3.428073725112971e-29,  3.563507647821353e-30, -2.986259492798212e-31,  2.098586565710145e-32, -1.271069952796858e-33,  6.769999010718389e-35, -3.220062054804574e-36,
  1.384416575318081e-37, -5.426702629707321e-39,  5.660253270844248e-28, -2.255073724096579e-28,  4.774100296418787e-29, -6.865617258980258e-30,  7.477362590798663e-31,
 -6.557654533511117e-32,  4.817032265742647e-33, -3.046024623608082e-34,  1.691812768260823e-35, -8.381651146299171e-37,  3.749306971806879e-38, -1.527327937215208e-39,
  1.192346153598910e-28, -4.928303877364713e-29,  1.086168969425969e-29, -1.626170535911884e-30,  1.842511939415964e-31, -1.679519396216604e-32,  1.281031920742597e-33,
 -8.402750011465402e-35,  4.836336493108527e-36, -2.480550236304519e-37,  1.147660148203790e-38, -4.830634180180116e-40,  3.057319795193205e-29, -1.300652156358475e-29,
  2.959366144153716e-30, -4.574625050799113e-31,  5.348899268274838e-32, -5.028003876494294e-33,  3.951758576083511e-34, -2.668873759302849e-35,  1.580365437241388e-36,
 -8.332744230546671e-38,  3.960273501295372e-39, -1.710957656575584e-40,  9.194518755420666e-30, -3.991980997558745e-30,  9.291148334641437e-31, -1.469362330395440e-31,
  1.757081491703187e-32, -1.688352030138795e-33,  1.355691079807000e-34, -9.348839526664858e-36,  5.649413864608100e-37, -3.038160867306586e-38,  1.471942229759870e-39,
 -6.478837056189080e-41,  2.582508083855473e-30, -1.134164017309573e-30,  2.673785993162708e-31, -4.283497402077423e-32,  5.187924936017378e-33, -5.047515676123479e-34,
  4.102561612115710e-35, -2.862821467271990e-36,  1.750026006824031e-37, -9.517451737263860e-39,  4.661617116292353e-40, -2.073652288320315e-41,  };
  int offset = -45;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 45;
    if (std::isnan(t)) {
      fill_n(rr+offset, 45, 0.5);
      fill_n(ww+offset, 45, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 45; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=45; ++j) {
        const int boxof = it*540+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
