//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_48.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot48(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[48] = {1.278457233711677e-02,1.150814835883784e-01,3.197838782794324e-01,6.271095358567564e-01,1.037386722154059e+00,
    1.551056130796248e+00,2.168673514794828e+00,2.890913046694420e+00,3.718571457109681e+00,4.652573014347396e+00,5.693975422442692e+00,6.843976731833512e+00,
    8.103923376645341e+00,9.475319475891899e+00,1.095983756373465e+01,1.255933094744859e+01,1.427584793239958e+01,1.611164820306394e+01,1.806922171040873e+01,
    2.015131049206163e+01,2.236093394696520e+01,2.470141820639561e+01,2.717643039612807e+01,2.979001878075745e+01,3.254666003534945e+01,3.545131522209265e+01,
    3.850949648918792e+01,4.172734709701189e+01,4.511173817233178e+01,4.867038668314932e+01,5.241200064678247e+01,5.634645973424313e+01,6.048504253050875e+01,
    6.484071625728610e+01,6.942851158904251e+01,7.426601568870360e+01,7.937403318479174e+01,8.477749189328024e+01,9.050671591661330e+01,9.659926966194310e+01,
    1.031027264892598e+02,1.100790116733375e+02,1.176115973344115e+02,1.258182891223084e+02,1.348761887561338e+02,1.450773694312892e+02,1.569816231036405e+02,
    1.720328667451659e+02};
  constexpr double aw[48] = {2.232700234975347e-01,2.016130134792332e-01,1.643796305984981e-01,1.209831168625153e-01,8.035395008064218e-02,
    4.813990673108975e-02,2.600034027124422e-02,1.265137511280014e-02,5.541631289439057e-03,2.183131976096716e-03,7.726958216816570e-04,2.454180927305260e-04,
    6.985432444541545e-05,1.779180591822015e-05,4.048233178777142e-06,8.213544547832802e-07,1.482969405004983e-07,2.377366214757480e-08,3.375584731127748e-09,
    4.233593783511151e-10,4.676010385985022e-11,4.533303374583738e-12,3.843681724876702e-13,2.838767395169384e-14,1.818169130493162e-15,1.004905149157448e-16,
    4.766831171187026e-18,1.928879326837149e-19,6.612951176480967e-21,1.906260188687530e-22,4.580601098549571e-24,9.085965647048776e-26,1.471241554974178e-27,
    1.919970706794752e-29,1.989546894269612e-31,1.608873207938431e-33,9.946800059221377e-36,4.587401665857948e-38,1.531798964711274e-40,3.568938561780834e-43,
    5.537064819782368e-46,5.383222506970748e-49,3.022293931502664e-52,8.733732835917374e-56,1.093382473751864e-59,4.468702421681184e-64,3.480841387717738e-69,
    1.315337147701315e-75};
  constexpr double x[18432] = {  5.244387063139485e-04, -2.702591090876076e-06,  1.044268109326164e-08, -3.585441629954200e-11,  1.153597038786709e-13,
 -3.561319791575014e-16,  1.068234524892018e-18, -3.136632785003688e-21,  9.058917438579652e-24, -2.581725946128817e-26,  7.277006020748978e-29, -2.031984233048707e-31,
  4.716715293408959e-03, -2.425621686919572e-05,  9.333506724673027e-08, -3.182350026681900e-10,  1.013196526194819e-12, -3.081828715036118e-15,  9.061085488115897e-18,
 -2.592064299789048e-20,  7.241275291609930e-23, -1.979459377606847e-25,  5.298596630870050e-28, -1.388462131702539e-30,  1.308403886689045e-02, -6.700678810605272e-05,
  2.556849721696970e-07, -8.595784550961030e-10,  2.678469547002190e-12, -7.898897607865563e-15,  2.224930139222785e-17, -6.004760318387473e-20,  1.550882669671870e-22,
 -3.811496681991782e-25,  8.803747884989032e-28, -1.862547040222443e-30,  2.559201453505491e-02, -1.302466950270500e-04,  4.907502913427205e-07, -1.614662326980713e-09,
  4.865152220716481e-12, -1.364806762024233e-14,  3.573248590289244e-17, -8.655870809177279e-20,  1.892076889160589e-22, -3.494946640230134e-25,  4.262203256555560e-28,
  3.575640283845063e-31,  4.218921059562075e-02, -2.129288131325467e-04,  7.887323678661248e-07, -2.519580003211982e-09,  7.239591248867127e-12, -1.884683591695051e-14,
  4.374419315865827e-17, -8.566065412147975e-20,  1.155707043242411e-22,  4.333728275749253e-26, -1.074448880236943e-27,  5.113892110198823e-30,  6.280735090764303e-02,
 -3.136834089021519e-04,  1.137140736303661e-06, -3.496164627814676e-09,  9.418786499412825e-12, -2.195196920996236e-14,  4.115797532105806e-17, -4.416338888319505e-20,
 -8.437604558335544e-23,  7.452661057079934e-25, -3.040281133599957e-27,  9.292601674915119e-30,  8.736157073317366e-02, -4.308402799155623e-04,  1.521258817821030e-06,
 -4.457426372774035e-09,  1.101491260237843e-11, -2.164143472745042e-14,  2.492538771921839e-17,  3.861765272181165e-20, -3.703922482048347e-22,  1.478913903158494e-24,
 -4.204662642332969e-27,  8.392310003330996e-30,  1.157507354808894e-01, -5.624557924705619e-04,  1.924693795448727e-06, -5.313645590226528e-09,  1.168135796915421e-11,
 -1.707078565415267e-14, -4.884891210346180e-18,  1.484243083008691e-19, -6.478569130855596e-22,  1.833191442338742e-24, -3.261655634916722e-27, -2.094806519203579e-31,
  1.478578216333366e-01, -7.063444037961777e-04,  2.329990811604990e-06, -5.978719721041819e-09,  1.115535357993602e-11, -8.062186748415701e-15, -4.470112495084866e-17,
  2.580928595928251e-19, -7.954942569933039e-22,  1.445095248068544e-24,  2.845002140948780e-28, -1.436535646116546e-29,  1.835503589833288e-01, -8.601141853911519e-04,
  2.719289229557534e-06, -6.376342883131038e-09,  9.292566104760004e-12,  4.806194190437384e-15, -8.783799196258745e-17,  3.338339334468304e-19, -7.084366021063065e-22,
  1.970596194549983e-25,  5.538798662419321e-27, -2.686486401436555e-29,  2.226809331424893e-01, -1.021205799862442e-03,  3.074997074048431e-06, -6.445605205007436e-09,
  6.089811161365901e-12,  2.022812438828669e-14, -1.256222048846210e-16,  3.442920263654759e-19, -3.422338364482546e-22, -1.661379924072166e-24,  1.029904843381099e-26,
 -2.861674587838481e-29,  2.650877471151803e-01, -1.186934326843001e-03,  3.380458976750235e-06, -6.145633889915061e-09,  1.693227885438414e-12,  3.631474700122072e-14,
 -1.490566773375470e-16,  2.700368274763494e-19,  2.583000643397811e-22, -3.536078752054423e-24,  1.189333658059497e-26, -1.402840201505575e-29,  3.105952405534702e-01,
 -1.354533285019682e-03,  3.620593035173679e-06, -5.458957692360254e-09, -3.609270744239825e-12,  5.083978929058747e-14, -1.507030210338309e-16,  1.108546440970152e-19,
  9.576669497249434e-22, -4.668048251198312e-24,  8.466184716998910e-27,  1.438583480506266e-29,  3.590147651228868e-01, -1.521200157815775e-03,  3.782472955778506e-06,
 -4.393357376409243e-09, -9.410842761428146e-12,  6.155115832407864e-14, -1.264013127962521e-16, -1.113729766933735e-19,  1.559536965284113e-21, -4.416841513148145e-24,
  1.219653142186909e-28,  4.522889998051042e-29,  4.101453142142005e-01, -1.684142700578811e-03,  3.855833670259864e-06, -2.982061832636642e-09, -1.522183485123418e-11,
  6.650452710552130e-14, -7.646119878227815e-17, -3.553766619232985e-19,  1.861328458702289e-21, -2.543157461023390e-24, -1.068333065046898e-26,  6.255529284502650e-29,
  4.637743050332802e-01, -1.840625287855739e-03,  3.833481235519307e-06, -1.282256789721753e-09, -2.051574106086089e-11,  6.436984716557473e-14, -6.048733627198180e-18,
 -5.685547452606288e-19,  1.718002916178078e-21,  6.258120674415190e-25, -1.982150962662330e-26,  5.376113042712250e-29,  5.196784108893138e-01, -1.988014551015707e-03,
  3.711591171234217e-06,  6.280163369851173e-10, -2.478049208842197e-11,  5.466422949373539e-14,  7.535703882875027e-17, -6.987132377125682e-19,  1.095117595904164e-21,
  4.229955317583432e-24, -2.307870366692212e-26,  1.714568798771935e-29,  5.776244412817522e-01, -2.123823559501378e-03,  3.489883346056683e-06,  2.654387089168717e-09,
 -2.756993168701203e-11,  3.787409779883607e-14,  1.553831320447734e-16, -7.067604792722953e-19,  9.301140317132885e-23,  7.119174423317607e-24, -1.802614415556216e-26,
 -3.514131838894801e-29,  6.373702671588618e-01, -2.245753813609306e-03,  3.171665962349144e-06,  4.691827680557779e-09, -2.855022142221593e-11,  1.544469226890878e-14,
  2.208262804400106e-16, -5.772147943920564e-19, -1.068118643570836e-21,  8.234488555141593e-24, -5.344054087090174e-27, -8.106818106513632e-29,  6.986657884866724e-01,
 -2.351734343021284e-03,  2.763745958067116e-06,  6.631110516475946e-09, -2.753633771470274e-11, -1.036622256544378e-14,  2.599934690732152e-16, -3.237608413133023e-19,
 -2.100789122431828e-21,  6.995971004368235e-24,  1.106742822953228e-26, -9.840152456389197e-29,  7.612539410275735e-01, -2.439957243268403e-03,  2.276208075674662e-06,
  8.365636036374904e-09, -2.451475147587732e-11, -3.675390160653130e-14,  2.648829293489603e-16,  1.180776015244427e-20, -2.727045750384179e-21,  3.552823906395034e-24,
  2.536490763866802e-26, -7.567547564523375e-29,  8.248717389843562e-01, -2.508909031666489e-03,  1.722069764639814e-06,  9.798185866873714e-09, -1.964972412369416e-11,
 -6.071714307560599e-14,  2.327842922430509e-16,  3.673500270051822e-19, -2.757763372194719e-21, -1.207464723185687e-24,  3.198807989610410e-26, -1.889760910599808e-29,
  8.892513499198966e-01, -2.557397264586375e-03,  1.116823804974600e-06,  1.084715580803238e-08, -1.327228323981186e-11, -7.944640808087333e-14,  1.669748001300178e-16,
  6.732765136540091e-19, -2.150741132469553e-21, -5.910295720470662e-24,  2.794043290649998e-26,  4.981020789631574e-29,  9.541211981170465e-01, -2.584571928590942e-03,
  4.778848857930247e-07,  1.145185229065140e-08, -5.852693462010132e-12, -9.069567930600805e-14,  7.635261354274489e-17,  8.676947412116957e-19, -1.029287390561083e-21,
 -9.129336765406022e-24,  1.414691301871131e-26,  1.015431868697708e-28,  1.019207092300008e+00, -2.589941198159180e-03, -1.760398246071832e-07,  1.157649320063439e-08,
  2.041065642120822e-12, -9.308545822818147e-14, -2.595243847041137e-17,  9.102665219901792e-19,  3.457325492019979e-22, -9.858634627384608e-24, -4.737468151367665e-27,
  1.137332149060761e-28,  1.084233373400205e+00, -2.573381241401993e-03, -8.256329759268777e-07,  1.121263602490937e-08,  9.794839739167650e-12, -8.629324967770450e-14,
 -1.247543145176741e-16,  7.914608150034744e-19,  1.643587712145091e-21, -7.855042849142234e-24, -2.204847544151719e-26,  8.074646526193554e-29,  1.148924077819351e+00,
 -2.535139851134817e-03, -1.451676783992971e-06,  1.037985805533809e-08,  1.680480859976231e-11, -7.110334837529537e-14, -2.053820852941159e-16,  5.349325017309755e-19,
  2.552202127100172e-21, -3.726949832297217e-24, -3.168325724903134e-26,  1.669423925523158e-29,  1.213004111423179e+00, -2.475833780500101e-03, -2.035763471868210e-06,
  9.124628376729071e-09,  2.253334726746329e-11, -4.930755506961481e-14, -2.561759648717679e-16,  1.923864755453033e-19,  2.862026537286578e-21,  1.265325434230036e-24,
 -3.046237271996508e-26, -5.103149384229841e-29,  1.276200429294565e+00, -2.396439768445327e-03, -2.560979308710258e-06,  7.517432010116378e-09,  2.655863081103283e-11,
 -2.346975151985842e-14, -2.704464013955768e-16, -1.679025011386527e-19,  2.520913602540130e-21,  5.628501060140239e-24, -1.930319668309214e-26, -9.438411839765784e-29,
  1.338243216087931e+00, -2.298279349021171e-03, -3.012535852215130e-06,  5.648324780723002e-09,  2.861296467663551e-11,  3.413079379330293e-15, -2.475338672503000e-16,
 -4.762045571786196e-19,  1.644234847486150e-21,  8.126697607269458e-24, -2.731307872443140e-27, -9.728828640045792e-29,  1.398867061661598e+00, -2.182997647799969e-03,
 -3.378323734190998e-06,  3.621205121048243e-09,  2.860594323710812e-11,  2.830573088714425e-14, -1.927775125265525e-16, -6.764984175157819e-19,  4.779064275306812e-22,
  8.170751583667299e-24,  1.303178332211066e-26, -6.219616380340432e-29,  1.457812126524635e+00, -2.052536476756336e-03, -3.649367048572968e-06,  1.547178545067575e-09,
  2.663007916432816e-11,  4.852970504792044e-14, -1.164095141578988e-16, -7.381113433937014e-19, -6.739121463063716e-22,  5.973301199211935e-24,  2.256666032238048e-26,
 -7.669277431741272e-30,  1.514825291523524e+00, -1.909102143663340e-03, -3.820160019915959e-06, -4.625445256243866e-10,  2.294834864689270e-11,  6.210235849159532e-14,
 -3.159758984682223e-17, -6.611641031196805e-19, -1.534327298254998e-21,  2.424307208118108e-24,  2.328020805324770e-26,  4.136866050806701e-29,  1.569661286114958e+00,
 -1.755128491377300e-03, -3.888872022599738e-06, -2.303741429278471e-09,  1.796497433594375e-11,  6.797268234404618e-14,  4.798025167014351e-17, -4.747103337277125e-19,
 -1.926920646526785e-21, -1.255719151110717e-24,  1.614424033743050e-26,  6.552006308253343e-29,  1.622083789527841e+00, -1.593235774268570e-03, -3.857412026581915e-06,
 -3.885781198459206e-09,  1.218252013299665e-11,  6.612148884039572e-14,  1.105595315696674e-16, -2.282786097515166e-19, -1.815714504480495e-21, -3.949295263490558e-24,
  4.930463218793331e-27,  5.902330065223366e-29,  1.671866499113142e+00, -1.426186061526905e-03, -3.731348975381382e-06, -5.137290576646828e-09,  6.149810614458396e-12,
  5.751394824270249e-14,  1.482509900295232e-16,  2.086506415959284e-20, -1.301895459336489e-21, -5.002194848406985e-24, -5.615421246196790e-27,  3.049814268147674e-29,
  1.718794160217730e+00, -1.256835928264538e-03, -3.519690244793166e-06, -6.010494476692941e-09,  4.061550608775911e-13,  4.391437832545728e-14,  1.581796522743731e-16,
  2.214290156283960e-19, -5.810116982075592e-22, -4.386786999980946e-24, -1.179067093697131e-26, -3.247667092660031e-30,  1.762663552000557e+00, -1.088087253557204e-03,
 -3.234525961482266e-06, -6.483932413653214e-09, -4.572257383326803e-12,  2.759359822076817e-14,  1.426120158235886e-16,  3.393580516277559e-19,  1.236163370071625e-22,
 -2.626469241740271e-24, -1.226283355331956e-26, -2.645444754695619e-29,  1.803284423739977e+00, -9.228369883111343e-04, -2.890552349250342e-06, -6.563363334255878e-09,
 -8.418166313431781e-12,  1.097489083448448e-14,  1.080889929744324e-16,  3.639890169000068e-19,  6.290252543385816e-22, -5.320296133937554e-25, -8.213215265021484e-27,
 -3.166573737300099e-29,  1.840480376364455e+00, -7.639267838782795e-04, -2.504492192636185e-06, -6.280796306982551e-09, -1.090647601662994e-11, -3.726755389877143e-15,
  6.378202060355672e-17,  3.078765452829239e-19,  8.409746691638218e-22,  1.131952166733005e-24, -2.382222040055085e-27, -2.161157116735006e-29,  1.874089684186062e+00,
 -6.140933836873615e-04, -2.094434752680548e-06, -5.691715027069358e-09, -1.197151069666504e-11, -1.481727479533977e-14,  1.944116853474724e-17,  2.007722709847021e-19,
  7.690615578550240e-22,  1.916136906685202e-24,  2.408498642792447e-27, -5.595648322572334e-30,  1.903966052155370e+00, -4.759206740792736e-04, -1.679120852402868e-06,
 -4.870690800142849e-09, -1.170662300669749e-11, -2.134146971026792e-14, -1.662390414846942e-17,  7.975763833072338e-20,  5.069238359630614e-22,  1.794514481194723e-24,
  4.508221550385005e-27,  6.782255937592613e-30,  1.929979304477732e+00, -3.517942663351822e-04, -1.277201216054639e-06, -3.905692504765200e-09, -1.034641707611429e-11,
 -2.317519550468746e-14, -3.911091858871064e-17, -2.154674584974698e-20,  1.875875719748478e-22,  1.089186189369314e-24,  3.914356344919544e-27,  1.070608278162739e-29,
  1.952016001466207e+00, -2.438594379895384e-04, -9.064973786031499e-07, -2.891494701886960e-09, -8.233748272074845e-12, -2.098092967839282e-14, -4.653028169727249e-17,
 -8.167984494376089e-20, -6.835904278271860e-23,  2.667227686026141e-25,  1.870593539917217e-27,  7.437014127416374e-30,  1.969979984513260e+00, -1.539831908726837e-04,
 -5.832944858071846e-07, -1.922649618915724e-09, -5.775326536359256e-12, -1.603764221588671e-14, -4.111245667860800e-17, -9.567398064071403e-20, -1.929859201613049e-22,
 -2.909930586199146e-25, -6.881805586560800e-29,  1.826688527431641e-30,  1.983792862253785e+00, -8.372104406574360e-05, -3.216938989985853e-07, -1.086519733425700e-09,
 -3.390990999175698e-12, -9.975755497249507e-15, -2.788027309703140e-17, -7.410082312139669e-20, -1.864015752194198e-22, -4.382859463874076e-25, -9.372271342812275e-28,
 -1.702613697706050e-30,  1.993394541930629e+00, -3.428862132921576e-05, -1.330493633635072e-07, -4.568578085456177e-10, -1.462385456141874e-12, -4.462747092222768e-15,
 -1.313065898589692e-17, -3.747118566783925e-20, -1.040217539899714e-22, -2.811841370473842e-25, -7.396240852477049e-28, -1.888682808934338e-30,  1.998745196549800e+00,
 -6.531292314553227e-06, -2.548092007173675e-08, -8.829142141522810e-11, -2.865116077432818e-13, -8.914444877286580e-16, -2.692622373724973e-18, -7.953699501407184e-21,
 -2.308295668263064e-23, -6.602109047364830e-26, -1.864934168563958e-28, -5.210438496750623e-31,  5.137927435079577e-04, -2.620739808689325e-06,  1.002327201416087e-08,
 -3.406427845853952e-11,  1.084864924189051e-13, -3.315163412549976e-16,  9.843313851795527e-19, -2.861073407311841e-21,  8.179806151257196e-24, -2.307759989865110e-26,
  6.439623238825792e-29, -1.780207191216389e-31,  4.621159984134631e-03, -2.352454063071523e-05,  8.961151768521134e-08, -3.025053773245517e-10,  9.536771502244364e-13,
 -2.872816595986521e-15,  8.366705599921610e-18, -2.371347780351730e-20,  6.565392052034392e-23, -1.779247525137478e-25,  4.723656155534486e-28, -1.228323655054631e-30,
  1.282003835899532e-02, -6.500185137144894e-05,  2.456220429556640e-07, -8.179583145960862e-10,  2.525698084575281e-12, -7.384542009437213e-15,  2.063543280602920e-17,
 -5.529768181836154e-20,  1.419814288927055e-22, -3.475265812544891e-25,  8.019266084223807e-28, -1.705059631427854e-30,  2.507875888651548e-02, -1.263968936129780e-04,
  4.718325390192755e-07, -1.538957798984401e-09,  4.600573836789071e-12, -1.281889901675216e-14,  3.339173927328577e-17, -8.070205381813507e-20,  1.769359412643537e-22,
 -3.321974269198441e-25,  4.370980102280655e-28,  1.454728336507842e-31,  4.134992631559210e-02, -2.067379531415601e-04,  7.591801522411679e-07, -2.406705802504166e-09,
  6.872961023379567e-12, -1.782533820162008e-14,  4.139764839940102e-17, -8.194529858695640e-20,  1.164092517764200e-22,  4.617544672700758e-27, -8.673095407515116e-28,
  4.321207755868117e-30,  6.157054938856250e-02, -3.047515700243412e-04,  1.096076648664122e-06, -3.348923114513077e-09,  8.989523392110596e-12, -2.097929783385262e-14,
  3.988747054807852e-17, -4.645683877106818e-20, -5.963973543745184e-23,  6.315254436862758e-25, -2.654185839833754e-27,  8.271921333482499e-30,  8.566221517681734e-02,
 -4.188812024647427e-04,  1.468812955843356e-06, -4.284617553824206e-09,  1.058814686841646e-11, -2.103154117738481e-14,  2.584852288325150e-17,  2.758521218912569e-20,
 -3.200905239269903e-22,  1.318022173490253e-24, -3.842331961650913e-27,  8.062220039536271e-30,  1.135313080260573e-01, -5.473101457480678e-04,  1.862040175139776e-06,
 -5.129480186698327e-09,  1.133909465684915e-11, -1.714043504716563e-14, -1.009508748632738e-18,  1.287236316721115e-19, -5.842089622468801e-22,  1.702939334649033e-24,
 -3.241699670716815e-27,  1.061484907210947e-30,  1.450692737554755e-01, -6.879884342150153e-04,  2.259311585625632e-06, -5.801579898001031e-09,  1.098395226756253e-11,
 -9.051122935085534e-15, -3.782307668998016e-17,  2.334704321569332e-19, -7.434101509557837e-22,  1.444724635296546e-24, -2.817538446448623e-28, -1.144349436360044e-29,
  1.801529298444366e-01, -8.386634018582583e-04,  2.643668010939460e-06, -6.227004243016422e-09,  9.368352799798030e-12,  2.807696905797292e-15, -7.880666318524345e-17,
  3.113179744719981e-19, -6.976305065893818e-22,  3.959443820269185e-25,  4.429232311403457e-27, -2.359886999119332e-29,  2.186448224079324e-01, -9.969135261926020e-04,
  2.998247262294375e-06, -6.345092283163219e-09,  6.464998554252717e-12,  1.732758359224948e-14, -1.161437875934924e-16,  3.324606560469937e-19, -3.949283455549329e-22,
 -1.274231991573563e-24,  9.068184727039214e-27, -2.726834120196596e-29,  2.603936308046598e-01, -1.160185130949297e-03,  3.306897265127299e-06, -6.112923668054917e-09,
  2.384366006255582e-12,  3.282893875990103e-14, -1.413984176250937e-16,  2.763562081231396e-19,  1.394082596718641e-22, -3.073491082593920e-24,  1.121793358553456e-26,
 -1.651767776679896e-29,  3.052346207354909e-01, -1.325831476423959e-03,  3.554771973594516e-06, -5.508767059048251e-09, -2.628375018583894e-12,  4.726347395711518e-14,
 -1.471948471175802e-16,  1.388776691808064e-19,  7.958474626640024e-22, -4.318698156661724e-24,  8.954748351862946e-27,  7.991055994951746e-30,  3.529901466719855e-01,
 -1.491153722590815e-03,  3.728889313544944e-06, -4.534248463266126e-09, -8.210379982340110e-12,  5.848559798810972e-14, -1.288449589591460e-16, -6.400720024655855e-20,
  1.401076843976732e-21, -4.374489859073910e-24,  1.938695007754757e-27,  3.741607434518153e-29,  4.034702044011647e-01, -1.653443210100984e-03,  3.818631193183312e-06,
 -3.215073434529243e-09, -1.391086657589032e-11,  6.455669492754188e-14, -8.559219097311353e-17, -2.973561852468207e-19,  1.762733320224327e-21, -2.916859953475928e-24,
 -8.038275977059421e-27,  5.755120288513302e-29,  4.564730343809654e-01, -1.810024468814554e-03,  3.816167086930364e-06, -1.600222659358666e-09, -1.923105312095989e-11,
  6.403987092407345e-14, -2.119627827810634e-17, -5.133665409141277e-19,  1.726836440689283e-21, -1.191389435515401e-25, -1.741444831454626e-26,  5.535697407067720e-29,
  5.117857764678347e-01, -1.958298333460181e-03,  3.716784818737530e-06,  2.403664271016766e-10, -2.367068545128196e-11,  5.624212509804119e-14,  5.630531251703701e-17,
 -6.614095404904200e-19,  1.230987114006209e-21,  3.324720996909742e-24, -2.211661156260658e-26,  2.626261352789982e-29,  5.691851764013658e-01, -2.095784522322398e-03,
  3.519114912564484e-06,  2.219523938103070e-09, -2.677675798734831e-11,  4.136638954257390e-14,  1.356730282246807e-16, -6.998254133121865e-19,  3.359870871291458e-22,
  6.371240650168552e-24, -1.927230337838826e-26, -2.165801490760681e-29,  6.284383442087150e-01, -2.220163018522852e-03,  3.225238184352247e-06,  4.237777684954739e-09,
 -2.818965719725731e-11,  2.054698877947849e-14,  2.042299805282125e-16, -6.066995592119518e-19, -7.763539881323467e-22,  7.952742329288629e-24, -8.658548942728508e-27,
 -6.944584277730646e-29,  6.893035644223433e-01, -2.329313585505655e-03,  2.840670043605631e-06,  6.189206333050374e-09, -2.768203628459421e-11, -4.242523844031726e-15,
  2.500254345065671e-16, -3.868793961789692e-19, -1.842001847983517e-21,  7.352904179138806e-24,  6.804345269741982e-27, -9.495930134148015e-29,  7.515311576875567e-01,
 -2.421352749767661e-03,  2.374219153143416e-06,  7.967864732423821e-09, -2.518628126152378e-11, -3.040247987423074e-14,  2.640124156301846e-16, -7.322212503798518e-20,
 -2.581706682106193e-21,  4.498356409801403e-24,  2.185589888823179e-26, -8.333893966083121e-29,  8.148643929713837e-01, -2.494667595653999e-03,  1.837722540615517e-06,
  9.474382406054744e-09, -2.080741728072084e-11, -5.501689390695940e-14,  2.418298299526104e-16,  2.786511243914558e-19, -2.778446058021152e-21,  5.051177996354688e-26,
  3.079211962204979e-26, -3.517741253345253e-29,  8.790404491723248e-01, -2.547945740041519e-03,  1.245663823323294e-06,  1.062231185327434e-08, -1.481965145717805e-11,
 -7.522075783695175e-14,  1.848325851158778e-16,  6.012681446864638e-19, -2.342913605249231e-21, -4.754030512547709e-24,  2.974339715782382e-26,  3.204988812173454e-29,
  9.437914244733057e-01, -2.580200889697116e-03,  6.146857404744602e-07,  1.134380564002189e-08, -7.646334998282065e-12, -8.857569261154958e-14,  1.001383659818492e-16,
  8.296168248490374e-19, -1.346707868856949e-21, -8.477095398297583e-24,  1.838614861942212e-26,  9.070259280815196e-29,  1.008845391280662e+00, -2.590793431579219e-03,
 -3.698748620064822e-08,  1.159423141963063e-08,  1.751974422619375e-13, -9.340154603314151e-14, -3.636464309180517e-19,  9.156246504639896e-19, -1.137663383609721e-23,
 -9.947370567481826e-24,  3.112306664033507e-28,  1.151821029182610e-28,  1.073927494054322e+00, -2.579445566668631e-03, -6.901984986825601e-07,  1.135539149938908e-08,
  8.040858328243038e-12, -8.901574637818373e-14, -1.019007679796931e-16,  8.393680981482994e-19,  1.345824723621077e-21, -8.661869303262082e-24, -1.819663331504596e-26,
  9.394821259280754e-29,  1.138761086763875e+00, -2.546250571103300e-03, -1.325553007136471e-06,  1.063709589587528e-08,  1.533471029645605e-11, -7.584368501532274e-14,
 -1.892824928527899e-16,  6.142134178329828e-19,  2.395447090193035e-21, -4.974088163516774e-24, -3.053744319530401e-26,  3.538603068086104e-29,  1.203068906108657e+00,
 -2.491675854150463e-03, -1.924138349629825e-06,  9.476940688906051e-09,  2.148620390023116e-11, -5.538075370487839e-14, -2.495018085490243e-16,  2.844608488612367e-19,
  2.885143673790756e-21,  6.289946409594881e-27, -3.237723675130861e-26, -3.563765088933388e-29,  1.266574276025263e+00, -2.416559580203449e-03, -2.468237132400165e-06,
  7.938260848654899e-09,  2.602399572671055e-11, -3.000758307131599e-14, -2.739889498203904e-16, -8.414831825243571e-20,  2.708652123574857e-21,  4.774637465125680e-24,
 -2.335158236605906e-26, -8.911029691807609e-29,  1.329002338382444e+00, -2.322100730454312e-03, -2.942007915310157e-06,  6.106351101039840e-09,  2.862076997531903e-11,
 -2.681523249740908e-15, -2.600871954005202e-16, -4.189376485262489e-19,  1.933778859762384e-21,  7.929786439499669e-24, -7.160713734202347e-27, -1.036600784128025e-28,
  1.390081304141551e+00, -2.209842597651462e-03, -3.332105252212051e-06,  4.083171342248300e-09,  2.912426705055895e-11,  2.345377047953685e-14, -2.114604609729433e-16,
 -6.564040523217733e-19,  7.807394549138262e-22,  8.633188904654503e-24,  9.989226525578288e-27, -7.603519626640670e-29,  1.449543718652320e+00, -2.081649832449349e-03,
 -3.628212899840454e-06,  1.980865698441632e-09,  2.757104921707757e-11,  4.548563933417398e-14, -1.373449798308879e-16, -7.560625943584007e-19, -4.427430182914833e-22,
  6.865201100686682e-24,  2.192622150352773e-26, -2.168516793903408e-29,  1.507127734171411e+00, -1.939679289912826e-03, -3.823466676101071e-06, -8.548216617554361e-11,
  2.418128456735115e-11,  6.111640422268342e-14, -5.078314165511842e-17, -7.086830162721748e-19, -1.429870884469466e-21,  3.389793891810174e-24,  2.493746083583017e-26,
  3.358675518284573e-29,  1.562578382147990e+00, -1.786345056971665e-03, -3.914747230226912e-06, -2.005368289570351e-09,  1.933483042932272e-11,  6.895770079274311e-14,
  3.381922728954413e-17, -5.369647911090288e-19, -1.959804229487242e-21, -5.519113731571682e-25,  1.905253819780778e-26,  6.639186977025749e-29,  1.615648837330732e+00,
 -1.624278172903227e-03, -3.902827778070543e-06, -3.680139561491143e-09,  1.353093197732337e-11,  6.869152048123691e-14,  1.033332182522207e-16, -2.886129938505577e-19,
 -1.953693391380856e-21, -3.697952553913457e-24,  7.690072923661328e-27,  6.635013395285107e-29,  1.666101665327713e+00, -1.456281681851329e-03, -3.792367494729959e-06,
 -5.029497944011981e-09,  7.335692097545759e-12,  6.107410713585644e-14,  1.482245976546597e-16, -2.371742950072798e-20, -1.485671052672264e-21, -5.197422034012693e-24,
 -4.081307743366190e-27,  3.937015148425805e-29,  1.713710044908843e+00, -1.285281775383329e-03, -3.591747530322413e-06, -5.996761360615094e-09,  1.322896455902925e-12,
  4.778284000942290e-14,  1.640949800708498e-16,  2.002186442420225e-19, -7.474450817497866e-22, -4.859643126732768e-24, -1.180959361821827e-26,  2.595010419464561e-30,
  1.758258956093173e+00, -1.114275890492379e-03, -3.312753264142692e-06, -6.552484352424400e-09, -3.985386944160158e-12,  3.113066709485553e-14,  1.521545188542946e-16,
  3.417039929575992e-19,  1.995537565942158e-23, -3.140064435716007e-24, -1.341048350895052e-26, -2.556689116444075e-29,  1.799546324924124e+00, -9.462787206714856e-04,
 -2.970113143665593e-06, -6.696153558842564e-09, -8.171889939689277e-12,  1.369358149806957e-14,  1.185591413183819e-16,  3.837451920315264e-19,  6.036148899803583e-22,
 -8.893010005886819e-25, -9.671829274487345e-27, -3.461231100421591e-29,  1.837384115818484e+00, -7.842671713131123e-04, -2.580910952119648e-06, -6.455810046185602e-09,
 -1.096498930210810e-11, -2.089462463335626e-15,  7.278530442402924e-17,  3.354194202951027e-19,  8.797701814694509e-22,  1.016497436347428e-24, -3.419654755236122e-27,
 -2.561243588315245e-29,  1.871599362498393e+00, -6.311253426288715e-04, -2.163894289969405e-06, -5.885602648692694e-09, -1.226272031553598e-11, -1.428038195043495e-14,
  2.541783139624278e-17,  2.265040045214609e-19,  8.397106566165749e-22,  2.006819438756971e-24,  2.106586231163994e-27, -8.211140828925934e-30,  1.902035128814630e+00,
 -4.895906508343266e-04, -1.738707131246868e-06, -5.061432287926714e-09, -1.213725151629769e-11, -2.171175085537741e-14, -1.415362499905790e-17,  9.704822280485121e-20,
  5.748432936343300e-22,  1.980709136621078e-24,  4.798520067277490e-27,  6.370578664792206e-30,  1.928551391340418e+00, -3.622021990879047e-04, -1.325078243514744e-06,
 -4.074994402348158e-09, -1.081935281129801e-11, -2.412038160652934e-14, -3.962407269258095e-17, -1.488541391393159e-20,  2.297329026234311e-22,  1.255485873620018e-24,
  4.408216904327476e-27,  1.174778585827401e-29,  1.951025836798287e+00, -2.512524806326800e-04, -9.419998009525135e-07, -3.026653080396503e-09, -8.664720621050199e-12,
 -2.212533864854496e-14, -4.884639194019800e-17, -8.369860087781972e-20, -5.732826641472196e-23,  3.484301148543491e-25,  2.223440623251434e-27,  8.627234581668474e-30,
  1.969354570666316e+00, -1.587434295597613e-04, -6.069314736037089e-07, -2.017675400390828e-09, -6.106167006520411e-12, -1.705719516529040e-14, -4.387936351761640e-17,
 -1.020175074087252e-19, -2.034905108543000e-22, -2.919899054736426e-25,  2.283001060691825e-29,  2.356172053290392e-30,  1.983452747077205e+00, -8.634768595739072e-05,
 -3.350643746576315e-07, -1.142408783923845e-09, -3.597368981624025e-12, -1.067046879772872e-14, -3.004102849573919e-17, -8.032550986265943e-20, -2.028729857506230e-22,
 -4.773016255448906e-25, -1.014245541037269e-27, -1.797109719231605e-30,  1.993255223363663e+00, -3.537535007619555e-05, -1.386750479380853e-07, -4.809875013727087e-10,
 -1.554878725198058e-12, -4.790858930481232e-15, -1.422801736904722e-17, -4.096772033137555e-20, -1.146975549061216e-22, -3.124990955085433e-25, -8.278573701086196e-28,
 -2.126754678590171e-30,  1.998718656863836e+00, -6.739456972701999e-06, -2.656852218063068e-08, -9.302182668627591e-11, -3.050052067426928e-13, -9.588255844344252e-16,
 -2.926034960948969e-18, -8.731868085493768e-21, -2.559970734040859e-23, -7.396046837887544e-26, -2.110170015882891e-28, -5.954207500324440e-31,  5.034676087450608e-04,
 -2.542159705314792e-06,  9.624700659798828e-09, -3.238028034124445e-11,  1.020860658819668e-13, -3.088248807477985e-16,  9.077644445751725e-19, -2.612130087442943e-21,
  7.393551127196141e-24, -2.065175217606591e-26,  5.705526723321698e-29, -1.561670947671565e-31,  4.528472976028901e-03, -2.282191364406246e-05,  8.607114483903345e-08,
 -2.876955049478798e-10,  8.981762477728778e-13, -2.679751776235697e-15,  7.731203648504370e-18, -2.171149347198171e-20,  5.957609910563338e-23, -1.600683090098393e-25,
  4.214813109359131e-28, -1.087586671667667e-30,  1.256389969665142e-02, -6.307546108928228e-05,  2.360442221464855e-07, -7.787022807031014e-10,  2.382836938205635e-12,
 -6.907369580707163e-15,  1.914886788253435e-17, -5.094840462950038e-20,  1.300301802861779e-22, -3.169060147891184e-25,  7.301699666302082e-28, -1.558387019563084e-30,
  2.458060541317819e-02, -1.226948711246912e-04,  4.537983790213314e-07, -1.467356855523581e-09,  4.352030101748965e-12, -1.204398429323396e-14,  3.120957533040621e-17,
 -7.522806565087777e-20,  1.652926112662186e-22, -3.146371230402740e-25,  4.397174808789462e-28, -1.938428871864465e-32,  4.053494107975289e-02, -2.007781911043881e-04,
  7.309478948964853e-07, -2.299537270255273e-09,  6.526206018290882e-12, -1.685890740131702e-14,  3.915531072908314e-17, -7.822387915540877e-20,  1.159949344593024e-22,
 -2.648023437817087e-26, -6.925385620829482e-28,  3.640088756066165e-30,  6.036882922704451e-02, -2.961412915469789e-04,  1.056738886466510e-06, -3.208395860518182e-09,
  8.579404036238868e-12, -2.003780340400928e-14,  3.856323623034168e-17, -4.802134697337165e-20, -3.873068502223853e-23,  5.323565992105679e-25, -2.311044626448948e-27,
  7.339854537872211e-30,  8.400986976729631e-02, -4.073335122323640e-04,  1.418400236332439e-06, -4.118538301705472e-09,  1.017377645400969e-11, -2.040302264499436e-14,
  2.648443390947400e-17,  1.807252047327911e-20, -2.753237507987993e-22,  1.171308743131233e-24, -3.496296494729294e-27,  7.656665120101652e-30,  1.113714745652325e-01,
 -5.326569812182460e-04,  1.801563652293590e-06, -4.950797270036332e-09,  1.099632493843556e-11, -1.712346886205025e-14,  2.342065828800847e-18,  1.109849219909417e-19,
 -5.252231055480587e-22,  1.574509833536279e-24, -3.172753256100111e-27,  2.026442726824429e-30,  1.423530322832220e-01, -6.701894437974011e-04,  2.190740958719442e-06,
 -5.627331987791922e-09,  1.079436809211874e-11, -9.883070925514318e-15, -3.161115447002279e-17,  2.105103552520666e-19, -6.917172255280802e-22,  1.424152687932620e-24,
 -7.285329789357815e-28, -8.928881752512844e-30,  1.768401052751069e-01, -8.178104021678662e-04,  2.569844850081796e-06, -6.076761212061171e-09,  9.406286230779869e-12,
  1.018431540793780e-15, -7.039992322232521e-17,  2.892540801895409e-19, -6.804293081139018e-22,  5.532657990182085e-25,  3.459203634736245e-27, -2.052863029415692e-29,
  2.147046605484087e-01, -9.732303286746679e-04,  2.922737748956418e-06, -6.239028205605157e-09,  6.784422186486385e-12,  1.465037146878043e-14, -1.070182276098462e-16,
  3.191566787874594e-19, -4.345564956635308e-22, -9.350287292728822e-25,  7.904144395190971e-27, -2.559974542063613e-29,  2.558053370347986e-01, -1.134022675901638e-03,
  3.233792157287519e-06, -6.069702926588574e-09,  3.007638119684493e-12,  2.952863734690412e-14, -1.336140135946196e-16,  2.791320891818996e-19,  3.665934845626869e-23,
 -2.639845938238721e-24,  1.045248879249092e-26, -1.814481983044200e-29,  2.999877515989335e-01, -1.297658365771829e-03,  3.488445020759087e-06, -5.543449473518410e-09,
 -1.718103055958160e-12,  4.378019713713002e-14, -1.429726091551216e-16,  1.619269356676604e-19,  6.468912670537130e-22, -3.955133402271820e-24,  9.184253292163273e-27,
  2.603047133450544e-30,  3.470848463707967e-01, -1.461542397428175e-03,  3.673728190311421e-06, -4.656425381189707e-09, -7.071710413021185e-12,  5.537673394702465e-14,
 -1.300330281735849e-16, -2.167439282596608e-20,  1.245367741748660e-21, -4.266214684064568e-24,  3.421606546023513e-27,  3.007823920909548e-29,  3.969172801009395e-01,
 -1.623052170448638e-03,  3.778757107193388e-06, -3.427432558190019e-09, -1.264091668446326e-11,  6.240884558544804e-14, -9.314465988830672e-17, -2.426860287392424e-19,
  1.652534428816216e-21, -3.189361691061379e-24, -5.627664260247627e-27,  5.194632342207680e-29,  4.492938663055322e-01, -1.779577076515988e-03,  3.795160397616720e-06,
 -1.897705544898452e-09, -1.795647488740219e-11,  6.336490467678656e-14, -3.479849433375360e-17, -4.583060662697627e-19,  1.710597108237595e-21, -7.669075445318883e-25,
 -1.497438809066352e-26,  5.530554185644093e-29,  5.040120609826715e-01, -1.928558869814105e-03,  3.717434170686800e-06, -1.292985931544937e-10, -2.253380629920722e-11,
  5.737577478993267e-14,  3.835411747229762e-17, -6.202712561118596e-19,  1.335052341242654e-21,  2.465418482125732e-24, -2.079627214287394e-26,  3.343663243674548e-29,
  5.608585026365274e-01, -2.067532285157670e-03,  3.543206487809481e-06,  1.797884712442741e-09, -2.591844871500382e-11,  4.438882238205856e-14,  1.162618495870072e-16,
 -6.855544128115506e-19,  5.512801996340054e-22,  5.585025328942010e-24, -1.994817878218515e-26, -9.265854032133460e-30,  6.196096072351694e-01, -2.194165334373123e-03,
  3.273399717265092e-06,  3.790291180974918e-09, -2.773109161603619e-11,  2.524211197037655e-14,  1.869371163895891e-16, -6.270347145833561e-19, -4.969933112890926e-22,
  7.548865238199824e-24, -1.144600786959643e-26, -5.719272643400036e-29,  6.800322205449412e-01, -2.306298677115875e-03,  2.912281289815503e-06,  5.745937182072477e-09,
 -2.770779147889531e-11,  1.621680692647989e-15,  2.384077161137776e-16, -4.415437363058690e-19, -1.573391359210834e-21,  7.543055667181784e-24,  2.745255271675349e-27,
 -8.919591961182376e-29,  7.418843300230100e-01, -2.401983433683052e-03,  2.467396694178451e-06,  7.560363244593510e-09, -2.573118153760933e-11, -2.409996449822777e-14,
  2.608310975497816e-16, -1.530842305132911e-19, -2.404928298167643e-21,  5.297651610951690e-24,  1.807445477929370e-26, -8.806437637040650e-29,  8.049158381047743e-01,
 -2.479516786155545e-03,  1.949382334581808e-06,  9.132978844744805e-09, -2.184913590469476e-11, -4.912938797202457e-14,  2.483892669302857e-16,  1.900043683794730e-19,
 -2.754870407552184e-21,  1.246868419746881e-24,  2.892133252407267e-26, -4.950301891365332e-29,  8.688693982895507e-01, -2.537474702173029e-03,  1.371660029324376e-06,
  1.037340870010461e-08, -1.627838754266547e-11, -7.059137153936685e-14,  2.005943905521348e-16,  5.237886478009287e-19, -2.492351875508012e-21, -3.541392780386697e-24,
  3.075733198433664e-26,  1.405210420807818e-29,  9.334813149030111e-01, -2.574741114653557e-03,  7.500193443835320e-07,  1.120743055644160e-08, -9.391960416495526e-12,
 -8.589876698864178e-14,  1.227194900141728e-16,  7.817888918283381e-19, -1.637717365353826e-21, -7.665586788940113e-24,  2.209226918467099e-26,  7.739124179192871e-29,
  9.984825067963020e-01, -2.590532902637150e-03,  1.020984870391561e-07,  1.158209856891833e-08, -1.690845732471697e-12, -9.310299536106296e-14,  2.521498635547115e-17,
  9.095432127655118e-19, -3.680391744984848e-22, -9.833904047549336e-24,  5.347402310658382e-27,  1.131661350115915e-28,  1.063599534529686e+00, -2.584420044879878e-03,
 -5.532210370755728e-07,  1.146967790921963e-08,  6.238014813673217e-12, -9.117476357337421e-14, -7.784336350210992e-17,  8.773130629239030e-19,  1.021922699726789e-21,
 -9.303736479985688e-24, -1.381950448666489e-26,  1.045438102655236e-28,  1.128555689785190e+00, -2.556340360372536e-03, -1.196486564211592e-06,  1.087007544759432e-08,
  1.377384586745371e-11, -8.017160100391939e-14, -1.710399381568837e-16,  6.877702731399196e-19,  2.194817859457078e-21, -6.158999512518174e-24, -2.857447140831820e-26,
  5.372563348867577e-29,  1.193072144863027e+00, -2.506608309825291e-03, -1.808389983130555e-06,  9.811536576036186e-09,  2.031940743496547e-11, -6.126279438295555e-14,
 -2.402461247283756e-16,  3.765363464264984e-19,  2.861725844378856e-21, -1.315165243553605e-24, -3.356861653336670e-26, -1.822167537330260e-29,  1.256869159148306e+00,
 -2.435917410151092e-03, -2.370500662721054e-06,  8.349485662491603e-09,  2.535794713812326e-11, -3.660164502505986e-14, -2.751071152956070e-16,  5.090928283766530e-21,
  2.862801173366700e-21,  3.764417111582853e-24, -2.709776414863602e-26, -8.064352669746990e-29,  1.319667338398868e+00, -2.345335910373162e-03, -2.865986987180937e-06,
  6.563511364096611e-09,  2.850380568272331e-11, -9.057124867358007e-15, -2.709086468348771e-16, -3.525534528011890e-19,  2.212983897232192e-21,  7.550819480854557e-24,
 -1.181527121467375e-26, -1.074479250310676e-28,  1.381188941616357e+00, -2.236295491816660e-03, -3.280296697132722e-06,  4.552630279421563e-09,  2.954111904371722e-11,
  1.816128057355831e-14, -2.294427696053428e-16, -6.263773371309074e-19,  1.097884221086236e-21,  8.961905540858798e-24,  6.350703607653786e-27, -8.919321597436136e-29,
  1.441159229138845e+00, -2.110572886830416e-03, -3.601766270087085e-06,  2.429093866819247e-09,  2.844607717559768e-11,  4.193395619257532e-14, -1.586747321596359e-16,
 -7.661088744606605e-19, -1.800790318701485e-22,  7.718736649082725e-24,  2.063878020278429e-26, -3.702606673968068e-29,  1.499307844455805e+00, -1.970264456723377e-03,
 -3.822130955112818e-06,  3.111239521891658e-10,  2.538979118707834e-11,  5.965444062598387e-14, -7.124711420600245e-17, -7.522911198701877e-19, -1.289552380320375e-21,
  4.414047844837226e-24,  2.620172944319612e-26,  2.349370585200435e-29,  1.555370221119525e+00, -1.817753928341179e-03, -3.936909865320458e-06, -1.684938909886164e-09,
  2.072084654046097e-11,  6.958184246704832e-14,  1.790431561871880e-17, -5.998436341090694e-19, -1.965252308831464e-21,  2.684639814925378e-25,  2.195884976221986e-26,
  6.537325731752252e-29,  1.609089005038684e+00, -1.655673656140857e-03, -3.945644718272342e-06, -3.452522136308903e-09,  1.492887076064055e-11,  7.106735845555900e-14,
  9.435724340892000e-17, -3.531960019541623e-19, -2.080560540610876e-21, -3.329915775357783e-24,  1.076114297279988e-26,  7.312367612517822e-29,  1.660215481419426e+00,
 -1.486859948315351e-03, -3.851976309459787e-06, -4.902162053100391e-09,  8.592665850878600e-12,  6.461798231015759e-14,  1.468665963517678e-16, -7.428057195154072e-20,
 -1.675274043813802e-21, -5.323244051004854e-24, -2.139627302149817e-27,  4.900121545124488e-29,  1.708510994698473e+00, -1.314303166313994e-03, -3.663549433691977e-06,
 -5.967733927711572e-09,  2.318375481125166e-12,  5.178552533115875e-14,  1.693392981965205e-16,  1.734104186885439e-19, -9.308495271840277e-22, -5.327736802298598e-24,
 -1.154302428963340e-26,  9.744944724623499e-30,  1.753748349023807e+00, -1.141093471255868e-03, -3.391744475688917e-06, -6.611067974357407e-09, -3.325481617049219e-12,
  3.489715204112445e-14,  1.617134259085752e-16,  3.404281852540943e-19, -1.030094539808607e-22, -3.698512221325482e-24, -1.449837442813217e-26, -2.370579715502583e-29,
  1.795713176214193e+00, -9.703632421087261e-04, -3.051241939172682e-06, -6.824554531600266e-09, -7.868682636853497e-12,  1.667008961978280e-14,  1.295690634327140e-16,
  4.024709359052719e-19,  5.642617473664091e-22, -1.307459802051881e-24, -1.125610161639166e-26, -3.735458419802287e-29,  1.834205257702487e+00, -8.052273228326352e-04,
 -2.659434374383343e-06, -6.631486026125966e-09, -1.098853276605527e-11, -2.267001700115659e-16,  8.257648516316282e-17,  3.641288892336079e-19,  9.136188474988144e-22,
  8.559040697242627e-25, -4.642114902439104e-27, -3.001956481651969e-29,  1.869039786776219e+00, -6.487223628156002e-04, -2.235708054565972e-06, -6.084055678194391e-09,
 -1.254169798608160e-11, -1.359114493985260e-14,  3.214710640112105e-17,  2.545461773655417e-19,  9.133778206510014e-22,  2.082969752090952e-24,  1.677952110995677e-27,
 -1.136703119559163e-29,  1.900048557523978e+00, -5.037465910835635e-04, -1.800623881771718e-06, -5.259119686498359e-09, -1.257465227090858e-11, -2.201668379501917e-14,
 -1.116775813224288e-17,  1.166216789742413e-19,  6.496696809842034e-22,  2.178072630173346e-24,  5.064543048801784e-27,  5.667583916436308e-30,  1.927081067389204e+00,
 -3.730014046306163e-04, -1.375032921386779e-06, -4.252015104393416e-09, -1.131129950601293e-11, -2.507548713148569e-14, -3.993090067615142e-17, -6.775739974927834e-21,
  2.782317294580681e-22,  1.442465382519846e-24,  4.948527504619886e-27,  1.281407869054977e-29,  1.950005521481189e+00, -2.589361492404800e-04, -9.791662623333696e-07,
 -3.168893160597786e-09, -9.119141376385722e-12, -2.332596986134414e-14, -5.121362333356842e-17, -8.531447932042655e-20, -4.308892698704445e-23,  4.453459372552690e-25,
  2.632215551091774e-27,  9.981977412746110e-30,  1.968709730321744e+00, -1.636974169487940e-04, -6.317412162220842e-07, -2.118161426980862e-09, -6.458077176784352e-12,
 -1.814532329512501e-14, -4.682859524025378e-17, -1.086970002917898e-19, -2.139590994427093e-22, -2.888230547517561e-25,  1.401893750104621e-28,  2.998642803552444e-30,
  1.983101907077214e+00, -8.908403153811411e-05, -3.491257990113125e-07, -1.201713914241693e-09, -3.818174242370234e-12, -1.141919260241670e-14, -3.238366975353091e-17,
 -8.710035735462372e-20, -2.208053955258419e-22, -5.194788833934114e-25, -1.095240625396160e-27, -1.882600311666155e-30,  1.993111466000713e+00, -3.650826819139179e-05,
 -1.445993894621264e-07, -5.066510493492701e-10, -1.654205731192001e-12, -5.146521875809271e-15, -1.542823593576295e-17, -4.482462021861818e-20, -1.265668274359441e-22,
 -3.475617978623322e-25, -9.272386570000118e-28, -2.396052914436928e-30,  1.998691266750856e+00, -6.956554641868054e-06, -2.771471001638310e-08, -9.805922246214552e-11,
 -3.249042597624008e-13, -1.032079419474410e-15, -3.182408128532950e-18, -9.595341688357102e-21, -2.842075074976174e-23, -8.294950261914647e-26, -2.390600595998464e-28,
 -6.813115288950997e-31,  4.934505428247562e-04, -2.466689047927636e-06,  9.245737501196551e-09, -3.079515593834610e-11,  9.612164273453407e-14, -2.878901462449729e-16,
  8.378284099504394e-19, -2.387004484346728e-21,  6.689564859075524e-24, -1.850118459118500e-26,  5.061141158192819e-29, -1.371723066003289e-31,  4.438540934522431e-03,
 -2.214691357438290e-05,  8.270328716430116e-08, -2.737435666628541e-10,  8.463885506364775e-13, -2.501287733759339e-15,  7.149128301393402e-18, -1.989409514056727e-20,
  5.410591808551606e-23, -1.441285451530054e-25,  3.764081974749088e-28, -9.638024488263313e-31,  1.231531627984378e-02, -6.122384722928364e-05,  2.269240678398139e-07,
 -7.416575754036236e-10,  2.249172109895824e-12, -6.464455569654322e-15,  1.777889040215197e-17, -4.696447147755135e-20,  1.191311337564726e-22, -2.890298079689943e-25,
  6.646306415763961e-28, -1.422418742525919e-30,  2.409697683099495e-02, -1.191337515153590e-04,  4.366000725131926e-07, -1.399611419647037e-09,  4.118473141727827e-12,
 -1.131964376209084e-14,  2.917556194630989e-17, -7.011654254991033e-20,  1.542816996210217e-22, -2.971051997366046e-25,  4.359593279754171e-28, -1.457262789976978e-31,
  3.974335118951240e-02, -1.950392359036335e-04,  7.039689999277036e-07, -2.197765077779899e-09,  6.198249896385355e-12, -1.594504479396059e-14,  3.701682817620775e-17,
 -7.453233779635777e-20,  1.145799808012391e-22, -5.115697112223981e-26, -5.455499049389320e-28,  3.056137958726349e-30,  5.920093129969883e-02, -2.878390799916864e-04,
  1.019048695613920e-06, -3.074281617485200e-09,  8.187793581511813e-12, -1.912854387142191e-14,  3.720404466516425e-17, -4.897131645004366e-20, -2.115430187057904e-23,
  4.461187400306541e-25, -2.007010060358898e-27,  6.493786733186292e-30,  8.240292097936334e-02, -3.961812637004260e-04,  1.369941105554916e-06, -3.958987671734134e-09,
  9.772108270349184e-12, -1.976228142138927e-14,  2.687326990765197e-17,  9.910494062330929e-21, -2.355939645396477e-22,  1.038063898563953e-24, -3.169252866090942e-27,
  7.202934959990952e-30,  1.092692995865082e-01, -5.184791452711974e-04,  1.743198443456813e-06, -4.777591748915728e-09,  1.065465977450407e-11, -1.703181605175281e-14,
  5.222691390834190e-18,  9.506039488558954e-20, -4.708015570949737e-22,  1.449608970579605e-24, -3.067119476216205e-27,  2.737055464617819e-30,  1.397069028110471e-01,
 -6.529307072752472e-04,  2.124242583219242e-06, -5.456242650948739e-09,  1.058958470744608e-11, -1.057346124927206e-14, -2.601909067867403e-17,  1.891893630532422e-19,
 -6.410609298108653e-22,  1.387810539301008e-24, -1.072966495532756e-27, -6.785318740820797e-30,  1.736095229635047e-01, -7.975407684304558e-04,  2.497827101228808e-06,
 -5.926186775144489e-09,  9.410402273849164e-12, -5.764183621690627e-16, -6.260246661770820e-17,  2.678240131585873e-19, -6.582309905546966e-22,  6.744229315758626e-25,
  2.619366868137168e-27, -1.768488320381933e-29,  2.108580315050033e-01, -9.501460332971762e-04,  2.848529940452256e-06, -6.128269933231431e-09,  7.052460843377625e-12,
  1.218757031877720e-14, -9.828115984862247e-17,  3.047711432636159e-19, -4.627931066219852e-22, -6.408502550571320e-25,  6.818452017100620e-27, -2.372395378338163e-29,
  2.513205269209848e-01, -1.108442822541496e-03,  3.161263387207129e-06, -6.017027708746004e-09,  3.566776897779118e-12,  2.641573699689821e-14, -1.257956123937142e-16,
  2.788637489251537e-19, -5.104466785309755e-23, -2.238027896869880e-24,  9.631841995768044e-27, -1.904912138667661e-29,  2.948525113804860e-01, -1.270017293162062e-03,
  3.421786984507028e-06, -5.564119145185519e-09, -8.764337490641534e-13,  4.040547210197825e-14, -1.381697464637912e-16,  1.804203423801170e-19,  5.111341112084729e-22,
 -3.586845301493457e-24,  9.197842248033206e-27, -1.834222988870345e-30,  3.412970999378496e-01, -1.432377920758919e-03,  3.617208200549682e-06, -4.760882160564480e-09,
 -5.995410143495439e-12,  5.225302101947726e-14, -1.301048724628514e-16,  1.574891622999620e-20,  1.094547938979050e-21, -4.104913396234169e-24,  4.594306076249331e-27,
  2.333085996827516e-29,  3.904852663179335e-01, -1.592989974621936e-03,  3.736455178831500e-06, -3.619825474721021e-09, -1.141561447598065e-11,  6.009769927155335e-14,
 -9.921707845419568e-17, -1.916810775075943e-19,  1.534200592935361e-21, -3.370487161264460e-24, -3.471877132849457e-27,  4.600928426021411e-29,  4.422361295715083e-01,
 -1.749311671363748e-03,  3.770705771682637e-06, -2.174920387740706e-09, -1.669853602595317e-11,  6.238190596773092e-14, -4.686966389593665e-17, -4.041195579280718e-19,
  1.672790503887539e-21, -1.317543466033611e-24, -1.256782530827929e-26,  5.387957886143752e-29,  4.963572860858264e-01, -1.898831644469241e-03,  3.713757356260139e-06,
 -4.806151733409369e-10, -2.137846731362649e-11,  5.809276635941703e-14,  2.159684114949980e-17, -5.762870657650113e-19,  1.409204307122746e-21,  1.664685170088558e-24,
 -1.920177080613966e-26,  3.874156665227970e-29,  5.526451915764121e-01, -2.039107316183315e-03,  3.562322703253755e-06,  1.390436861746779e-09, -2.500431319029037e-11,
  4.695093417708773e-14,  9.734242414836940e-17, -6.648510662504822e-19,  7.379109302691218e-22,  4.782303004106664e-24, -2.010735227766154e-26,  1.796002023318631e-30,
  6.108855977590877e-01, -2.167803705593250e-03,  3.316238459676625e-06,  3.350870220514353e-09, -2.718281481755763e-11,  2.951636980023926e-14,  1.691976884147380e-16,
 -6.386834206818181e-19, -2.340484568524837e-22,  7.044353071106013e-24, -1.368911188175804e-26, -4.477523058349856e-29,  6.708540483943168e-01, -2.282732153868422e-03,
  2.978574653637033e-06,  5.303178568347160e-09, -2.761916977100533e-11,  7.189669282953612e-15,  2.253805424342420e-16, -4.875338177594030e-19, -1.300791417120704e-21,
  7.576505467950297e-24, -1.016924062695987e-27, -8.153611911865020e-29,  7.323164392966952e-01, -2.381888396005311e-03,  2.555636051106313e-06,  7.145146857910643e-09,
 -2.615097273714039e-11, -1.789996965803866e-14,  2.554969527822169e-16, -2.268585821365688e-19, -2.202140291827177e-21,  5.942379300329236e-24,  1.414828318863835e-26,
 -8.994110987906119e-29,  7.950296466980350e-01, -2.463489360023370e-03,  2.056849191984371e-06,  8.775857498027652e-09, -2.277173058846009e-11, -4.311411636065068e-14,
  2.524835213950289e-16,  1.027854981882622e-19, -2.689718837050530e-21,  2.356445735206995e-24,  2.647001396520829e-26, -6.151555237086123e-29,  8.587422280301932e-01,
 -2.526008031617597e-03,  1.494532478758369e-06,  1.010192627796134e-08, -1.764093141303093e-11, -6.561023481231256e-14,  2.141264313771033e-16,  4.422318876381103e-19,
 -2.597595430436455e-21, -2.303964070900940e-24,  3.098582749784330e-26, -3.550836612121932e-30,  9.231951987413296e-01, -2.568205687334952e-03,  8.835507281141704e-07,
  1.104358274615697e-08, -1.107874164643936e-11, -8.269698887691529e-14,  1.438356487166063e-16,  7.251435120736370e-19, -1.896990946324860e-21, -6.718159747152325e-24,
  2.516792205280397e-26,  6.213835941854419e-29,  9.881228881654954e-01, -2.589160775179622e-03,  2.408600307993133e-07,  1.154019006901860e-08, -3.544799458843541e-12,
 -9.219388539796291e-14,  5.046444403793342e-17,  8.921525758530140e-19, -7.170214274500797e-22, -9.521770265624678e-24,  1.021997001179492e-26,  1.077715654895036e-28,
  1.053253876720998e+00, -2.588293711100219e-03, -4.150465339251638e-07,  1.155480509082416e-08,  4.397844652239786e-12, -9.274484490396614e-14, -5.287183595507644e-17,
  9.045580995088032e-19,  6.781695141104588e-22, -9.762060021386118e-24, -9.041557826778264e-27,  1.121061597524353e-28,  1.118312015811114e+00, -2.565386866055475e-03,
 -1.064776987138420e-06,  1.107741317689244e-08,  1.213096424423622e-11, -8.403774488599903e-14, -1.508339690332414e-16,  7.542412023347738e-19,  1.953137398705538e-21,
 -7.249508159903564e-24, -2.582484148941883e-26,  7.103118125820215e-29,  1.183017530738116e+00, -2.520599044192126e-03, -1.688742319107062e-06,  1.012653553709468e-08,
  1.903739972224356e-11, -6.689189020907253e-14, -2.284300266237400e-16,  4.670936464695907e-19,  2.790066997162385e-21, -2.668464961317820e-24, -3.395847350117831e-26,
  7.016097842711519e-31,  1.247088205719176e+00, -2.454473800743645e-03, -2.267897790399955e-06,  8.748998050056124e-09,  2.455995407979243e-11, -4.319203577927565e-14,
 -2.736631920996582e-16,  9.865292173065830e-20,  2.977983345493644e-21,  2.612735170490435e-24, -3.040170360740247e-26, -6.902686130413468e-29,  1.310240648716844e+00,
 -2.367941020768022e-03, -2.784495616303871e-06,  7.017766641007757e-09,  2.825688792837512e-11, -1.566914052201366e-14, -2.797485657280040e-16, -2.774891893503885e-19,
  2.475162418810522e-21,  6.983192811572606e-24, -1.657181977830936e-26, -1.082330628486989e-28,  1.372191632279538e+00, -2.262311278323924e-03, -3.222818185185573e-06,
  5.027888907786396e-09,  2.984787955472913e-11,  1.244846093464977e-14, -2.464406770746827e-16, -5.860418516718066e-19,  1.424106430784760e-21,  9.133830033356511e-24,
  2.158798463919705e-27, -1.010905433291107e-28,  1.432659504947928e+00, -2.139262620793438e-03, -3.569859334056316e-06,  2.890726321040628e-09,  2.924493457350938e-11,
  3.786796124155875e-14, -1.801635661339147e-16, -7.672695490755027e-19,  1.122197129998926e-22,  8.506963028194694e-24,  1.865379336396642e-26, -5.332225997955636e-29,
  1.491365666047473e+00, -2.000819574356118e-03, -3.815920996515889e-06,  7.268051716928288e-10,  2.656405104633148e-11,  5.768723115442629e-14, -9.286364335410629e-17,
 -7.908102108460363e-19, -1.111563769216141e-21,  5.479300731026806e-24,  2.697034674469556e-26,  1.105977588044464e-29,  1.548036094889361e+00, -1.849324342373942e-03,
 -3.955093947237886e-06, -1.342254761404376e-09,  2.211538331396803e-11,  6.980290735802579e-14,  2.309547485164376e-19, -6.624019677206144e-19, -1.939090839845321e-21,
  1.203563933040353e-24,  2.477255167612370e-26,  6.212856028591906e-29,  1.602402923583037e+00, -1.687400365492200e-03, -3.985594518809652e-06, -3.202169884107380e-09,
  1.637202327940952e-11,  7.320562749550277e-14,  8.351827201082463e-17, -4.216024920562892e-19, -2.191897534668725e-21, -2.833318834513940e-24,  1.411135718665523e-26,
  7.897327982930442e-29,  1.654206040871538e+00, -1.517908625904841e-03, -3.909934092141986e-06, -4.754149826685390e-09,  9.920072951134989e-12,  6.811158700422440e-14,
  1.440073156993717e-16, -1.309676534199868e-19, -1.867904753124084e-21, -5.362735488689577e-24,  2.395214882049989e-28,  5.922159726237066e-29,  1.703194712690351e+00,
 -1.343897302257346e-03, -3.734904778682456e-06, -5.922131829506610e-09,  3.395102554858557e-12,  5.590438805223730e-14,  1.737483058463572e-16,  1.404663262574507e-19,
 -1.130833930036645e-21, -5.778472028743412e-24, -1.093155859413620e-26,  1.828274785808840e-29,  1.749129203580701e+00, -1.168545608425384e-03, -3.471372813583018e-06,
 -6.658478029036537e-09, -2.587957724726468e-12,  3.889215857233421e-14,  1.711784409298757e-16,  3.348876182662208e-19, -2.468389614904986e-22, -4.298506685804512e-24,
 -1.547924653473343e-26, -2.066773218427120e-29,  1.791782381721825e+00, -9.951028700658868e-04, -3.133880426969986e-06, -6.947613413748234e-09, -7.503261116357116e-12,
  1.991697106856489e-14,  1.410833245529173e-16,  4.196840585116135e-19,  5.086859617772808e-22, -1.791309298231830e-24, -1.295375021612861e-26, -3.973743184537889e-29,
  1.830941289249080e+00, -8.268240976654119e-04, -2.740066897045865e-06, -6.807227616378467e-09, -1.097240537904730e-11,  1.880813550485105e-15,  9.318575658852741e-17,
  3.938191900964287e-19,  9.407581973344386e-22,  6.424190933249422e-25, -6.067020537235949e-27, -3.480873945619753e-29,  1.866408658764961e+00, -6.669034936404482e-04,
 -2.309929553311008e-06, -6.286853025743317e-09, -1.280521090377843e-11, -1.273071437077019e-14,  3.969495204475956e-17,  2.849859710330571e-19,  9.894427351898054e-22,
  2.139023095820821e-24,  1.097295806819503e-27, -1.513280623533099e-29,  1.898004356611539e+00, -5.184074737423926e-04, -1.864955059674262e-06, -5.463850201551732e-09,
 -1.301738925718885e-11, -2.224310203945172e-14, -7.599229877708768e-18,  1.387052481228374e-19,  7.317843194139824e-22,  2.385356624309682e-24,  5.291884152030561e-27,
  4.599035154515913e-30,  1.925566733696574e+00, -3.842088798534666e-04, -1.427159706013017e-06, -4.437060090101425e-09, -1.182240262391273e-11, -2.603504993475433e-14,
 -3.998788811083257e-17,  2.997859751501313e-21,  3.338621719897138e-22,  1.651997771743651e-24,  5.535863702875182e-27,  1.388060964480770e-29,  1.948953865839103e+00,
 -2.669241025107090e-04, -1.018084031524649e-06, -3.318599175162614e-09, -9.598146276118555e-12, -2.458390273371247e-14, -5.361917240134997e-17, -8.641559994962700e-20,
 -2.505146113489784e-23,  5.598571413741493e-25,  3.104532677736319e-27,  1.151836549770376e-29,  1.968044669297450e+00, -1.688548030068756e-04, -6.577913053333887e-07,
 -2.224456026862197e-09, -6.832473069415742e-12, -1.930651501118358e-14, -4.996951876164130e-17, -1.157087003590684e-19, -2.242220277714314e-22, -2.803585606188647e-25,
  2.886909280825956e-28,  3.775554200251080e-30,  1.982739892118607e+00, -9.193577637718518e-05, -3.639205864659424e-07, -1.264674845025778e-09, -4.054531919622623e-12,
 -1.222648241516053e-14, -3.492427322351603e-17, -9.447396848082123e-20, -2.403153758190410e-22, -5.649673852013476e-25, -1.179703254574748e-27, -1.953719977549118e-30,
  1.992963080186540e+00, -3.768984045699027e-05, -1.508414688639463e-07, -5.339623380830628e-10, -1.760943022861515e-12, -5.532330098730698e-15, -1.674196049987627e-17,
 -4.908232394188260e-20, -1.397728587584494e-22, -3.868468269092436e-25, -1.039231257254836e-27, -2.700721427925648e-30,  1.998662989517562e+00, -7.183069134819185e-06,
 -2.892330636389821e-08, -1.034270664182487e-10, -3.463319314185658e-13, -1.111786845498446e-15, -3.464272620503747e-18, -1.055449047343729e-20, -3.158653555767969e-23,
 -9.313964736414947e-26, -2.711703463723598e-28, -7.806383671835271e-31,  4.837294143437983e-04, -2.394175600922299e-06,  8.885236778069547e-09, -2.930220184657918e-11,
  9.055962735483641e-14, -2.685607101872881e-16,  7.738917998103696e-19, -2.183215872198720e-21,  6.058553978555655e-24, -1.659240723244623e-26,  4.494782873693183e-29,
 -1.206398378221892e-31,  4.351256048384250e-03, -2.149820049289866e-05,  7.949799650407792e-08, -2.605924193590328e-10,  7.980344581044913e-13, -2.336202115910365e-15,
  6.615573312002662e-18, -1.824289888151336e-20,  4.917838722677407e-23, -1.298872832639017e-25,  3.364482830131728e-28, -8.548413166533052e-31,  1.207399616095074e-02,
 -5.944345215290899e-05,  2.182359048116295e-07, -7.066823903362735e-10,  2.124045602960723e-12, -6.053120918072767e-15,  1.651572760279070e-17, -4.331374556646496e-20,
  1.091898559865792e-22, -2.636586119449642e-25,  6.048436092606397e-28, -1.296858195311279e-30,  2.362732261474232e-02, -1.157070290206588e-04,  4.201927593717411e-07,
 -1.335489605046472e-09,  3.898926218749968e-12, -1.064244131397427e-14,  2.727983293647424e-17, -6.534730953089983e-20,  1.438979806942304e-22, -2.798250958153081e-25,
  4.273542315642075e-28, -2.407826230255096e-31,  3.897429306831567e-02, -1.895113146303275e-04,  6.781804816930745e-07, -2.101096718777787e-09,  5.888066133447972e-12,
 -1.508127130794140e-14,  3.498094913848886e-17, -7.089920270325562e-20,  1.123765399489544e-22, -7.044232431334702e-26, -4.223549032363452e-28,  2.556579055612352e-30,
  5.806564921963232e-02, -2.798320576270737e-04,  9.829308754221015e-07, -2.946289440524626e-09,  7.814040273524433e-12, -1.825216335641744e-14,  3.582567777455089e-17,
 -4.940623887140484e-20, -6.472325126339745e-24,  3.713221907656834e-25, -1.738381594881780e-27,  5.729746797507308e-30,  8.083981781236071e-02, -3.854091380613702e-04,
  1.323358446516858e-06, -3.805760782237160e-09,  9.383330444311976e-12, -1.911481125476261e-14,  2.705066476088157e-17,  2.945556926639914e-21, -2.004304194477961e-22,
  9.174922577260300e-25, -2.862830878006957e-27,  6.722413009848627e-30,  1.072229151408645e-01, -5.047600098997753e-04,  1.686878973270542e-06, -4.609834597746607e-09,
  1.031548389959619e-11, -1.687618620486005e-14,  7.681141233067726e-18,  8.080628715490411e-20, -4.207934422664309e-22,  1.329494143607874e-24, -2.934975053832798e-27,
  3.238380852049317e-30,  1.371287572337805e-01, -6.361958021730186e-04,  2.059777187972791e-06, -5.288533218357664e-09,  1.037228819680099e-11, -1.113662402174757e-14,
 -2.100153525124961e-17,  1.694659586015357e-19, -5.919391373459069e-22,  1.339476420930657e-24, -1.330562953823138e-27, -4.975605675950539e-30,  1.704588783449940e-01,
 -7.778400503504522e-04,  2.427615620540620e-06, -5.775791692160479e-09,  9.384444536171593e-12, -1.991245735675722e-15, -5.539449616908304e-17,  2.471678357818713e-19,
 -6.322461867337462e-22,  7.644182790653321e-25,  1.899340606938189e-27, -1.508450356061369e-29,  2.071025608338843e-01, -9.276500147542534e-04,  2.775675374005905e-06,
 -6.013605836059933e-09,  7.273307259897876e-12,  9.929532641459672e-15, -8.995800379887967e-17,  2.896432653867870e-19, -4.812007264871638e-22, -3.884089566673337e-25,
  5.818119082725639e-27, -2.173343176425436e-29,  2.469368799721613e-01, -1.083440523511199e-03,  3.089418375553896e-06, -5.955894147406091e-09,  4.065531893441995e-12,
  2.349008411351562e-14, -1.180218870441247e-16,  2.760139252834095e-19, -1.248820014603523e-22, -1.869647893989172e-24,  8.784905663527620e-27, -1.936026461736758e-29,
  2.898267676694928e-01, -1.242910253140554e-03,  3.354959505877327e-06, -5.571855633632728e-09, -1.010667978404377e-13,  3.715175090352306e-14, -1.329078958007426e-16,
  1.947813929765607e-19,  3.886004716632061e-22, -3.221654492116205e-24,  9.035777889468945e-27, -5.394434419618775e-30,  3.356250995600689e-01, -1.403670329926416e-03,
  3.559535993257310e-06, -4.848617676850252e-09, -4.981519293703872e-12,  4.913961837145430e-14, -1.291954971699110e-16,  4.844738503698048e-20,  9.503095108570987e-22,
 -3.902450561330848e-24,  5.484519193131421e-27,  1.724679288108147e-29,  3.841728103313414e-01, -1.563275099361932e-03,  3.691960614784842e-06, -3.792990779962943e-09,
 -1.023787912986595e-11,  5.765751923788692e-14, -1.039152365153978e-16, -1.445510086217505e-19,  1.410835006335741e-21, -3.470651491997517e-24, -1.580359224221695e-27,
  3.996835317936434e-29,  4.352990425967034e-01, -1.719254868965940e-03,  3.743044631400458e-06, -2.432180716230397e-09, -1.546303210622650e-11,  6.112725149175256e-14,
 -5.744339698206960e-17, -3.514415922478603e-19,  1.616875442709852e-21, -1.773515844580535e-24, -1.024924457921780e-26,  5.135040842569314e-29,  4.888213350061806e-01,
 -1.869150381633480e-03,  3.705976059000552e-06, -8.133530393784796e-10, -2.021270921246871e-11,  5.842260393384282e-14,  6.100098918984935e-18, -5.303785003086337e-19,
  1.455729384270854e-21,  9.318768744194703e-25, -1.741271045200897e-26,  4.230490785749297e-29,  5.445458556415665e-01, -2.010548722602226e-03,  3.576638913145198e-06,
  9.980006552977662e-10, -2.404342576223100e-11,  4.906658422017145e-14,  7.908195527568593e-17, -6.386382066482714e-19,  8.956424637816218e-22,  3.982519302947077e-24,
 -1.981208238971886e-26,  1.137146204018433e-29,  6.022676870409250e-01, -2.141120303602796e-03,  3.353859530951801e-06,  2.920882343857810e-09, -2.655333190393229e-11,
  3.336190082726951e-14,  1.512470482636146e-16, -6.422247406596309e-19,  9.250239963474814e-24,  6.460999086852224e-24, -1.538990924315184e-26, -3.260528905108452e-29,
  6.617711694258962e-01, -2.258656503667877e-03,  3.039567040469912e-06,  4.862711372600927e-09, -2.742241402315533e-11,  1.243053885010244e-14,  2.111877491652103e-16,
 -5.248097906699523e-19, -1.029610589483149e-21,  7.466667678977748e-24, -4.408581674260990e-27, -7.242885431226955e-29,  7.228303088455207e-01, -2.361107478666544e-03,
  2.638856579017310e-06,  6.724198166609672e-09, -2.644820767808879e-11, -1.185202883352649e-14,  2.481912476673074e-16, -2.938027778295145e-19, -1.978981527675004e-21,
  6.429207775353483e-24,  1.019885995126689e-26, -8.916023390788253e-29,  7.852092569821375e-01, -2.446619582628575e-03,  2.159946009252566e-06,  8.404941593116593e-09,
 -2.357323365969214e-11, -3.702961638682250e-14,  2.541706997373447e-16,  1.827068067630088e-20, -2.586508115605660e-21,  3.358137716388292e-24,  2.354568573743248e-26,
 -7.097347414175644e-29,  8.486628692664893e-01, -2.513571775552798e-03,  1.614019677487884e-06,  9.809456998810169e-09, -1.890079162180087e-11, -6.033207154993256e-14,
  2.253344346388193e-16,  3.580203557070251e-19, -2.658311512592333e-21, -1.072638310737070e-24,  3.045931912538336e-26, -2.017536523098635e-29,  9.129373476975430e-01,
 -2.560610327403037e-03,  1.014956207978360e-06,  1.085328570044244e-08, -1.269655261636560e-11, -7.900836100609365e-14,  1.632548712423375e-16,  6.607694997413015e-19,
 -2.120108524453733e-21, -5.661570709733552e-24,  2.754054012085487e-26,  4.553650741331049e-29,  9.777709743343452e-01, -2.586681069660575e-03,  3.789413991625249e-07,
  1.146879650426765e-08, -5.374557030937113e-12, -9.068588190918166e-14,  7.507257432116188e-17,  8.638113906795305e-19, -1.051324494280940e-21, -9.020429867545688e-24,
  1.478475606631536e-26,  9.922428620826483e-29,  1.042894940799641e+00, -2.591058397890692e-03, -2.760280910504801e-07,  1.161027113653215e-08,  2.532321338645765e-12,
 -9.370771216451978e-14, -2.729366279159001e-17,  9.205765189895670e-19,  3.214282396154968e-22, -1.002357595605242e-23, -4.003460328375757e-27,  1.163293597948477e-28,
  1.108034278286813e+00, -2.573370195476901e-03, -9.307395385642541e-07,  1.125787318240536e-08,  1.041575526445930e-11, -8.739752067280541e-14, -1.288808287328967e-16,
  8.123729141295618e-19,  1.674357827512077e-21, -8.215255733192341e-24, -2.234879463221945e-26,  8.663819110552422e-29,  1.172908891474843e+00, -2.533617834454600e-03,
 -1.565441403240241e-06,  1.042013798447578e-08,  1.764584981005312e-11, -7.220727662932779e-14, -2.141177632674960e-16,  5.545770011703971e-19,  2.669612237046421e-21,
 -4.020395791770959e-24, -3.349364636985769e-26,  2.051970850358244e-29,  1.237234698416958e+00, -2.472190418817848e-03, -2.160581717869763e-06,  9.134690866746626e-09,
  2.363071393326461e-11, -4.971595824396932e-14, -2.695543401707883e-16,  1.952129229174543e-19,  3.049457459546156e-21,  1.340009568463747e-24, -3.312832768020324e-26,
 -5.444415136648932e-29,  1.300724876870419e+00, -2.389872473225743e-03, -2.697581285485360e-06,  7.467002515503720e-09,  2.787578334083366e-11, -2.246716479505203e-14,
 -2.863725631740091e-16, -1.943988971743806e-19,  2.713482055166733e-21,  6.225574721154241e-24, -2.129052222470200e-26, -1.056808364391468e-28,  1.363091215678706e+00,
 -2.287844349708090e-03, -3.159610961848679e-06,  5.507119893192071e-09,  3.003640177246624e-11,  6.342428396180229e-15, -2.621623494556613e-16, -5.352015830687532e-19,
  1.753378109160375e-21,  9.128113456870171e-24, -2.517765999281790e-27, -1.111228490007813e-28,  1.424045567714585e+00, -2.167674729983541e-03, -3.532338892573887e-06,
  3.364461921293225e-09,  2.995731769147089e-11,  3.328692687749547e-14, -2.015498007127608e-16, -7.586393835419413e-19,  4.312909094395936e-22,  9.201269437705559e-24,
  1.593925186623073e-26, -7.010156499704573e-29,  1.483301398566461e+00, -2.031304743397931e-03, -3.804611524977988e-06,  1.160931252808230e-09,  2.769369486516265e-11,
  5.518896179503130e-14, -1.154731670966581e-16, -8.230152576915065e-19, -8.948106823068930e-22,  6.563678847541026e-24,  2.714142295984034e-26, -3.647122810066155e-30,
  1.540575422637504e+00, -1.881023400725573e-03, -3.969031874215009e-06, -9.772462936739520e-10,  2.350995852008943e-11,  6.957891846196129e-14, -1.917710532571746e-17,
 -7.235631172096930e-19, -1.877280877900611e-21,  2.247631549128965e-24,  2.738876354563805e-26,  5.634878238317651e-29,  1.595589315678284e+00, -1.719434260647172e-03,
 -4.022400186001336e-06, -2.928399860830066e-09,  1.785518267276084e-11,  7.506039150221445e-14,  7.071691470777814e-17, -4.932593801701847e-19, -2.282886106314681e-21,
 -2.197928817117942e-24,  1.769102980915881e-26,  8.348127363458225e-29,  1.648071490054390e+00, -1.549413494830864e-03, -3.965986004828819e-06, -4.584344390620207e-09,
  1.131653374862033e-11,  7.151682491556173e-14,  1.394744205618273e-16, -1.938224102952088e-19, -2.060134636890467e-21, -5.297944115492422e-24,  3.077071992722567e-27,
  6.979207223141947e-29,  1.697758916340457e+00, -1.374059792893730e-03, -3.805606796511030e-06, -5.858637657568720e-09,  4.555186527389952e-12,  6.011725979242398e-14,
  1.771428845507576e-16,  1.008685898365103e-19, -1.346510193078441e-21, -6.196815656397080e-24, -9.913012066625882e-27,  2.825210346644815e-29,  1.744398972223662e+00,
 -1.196636841221882e-03, -3.551496593322280e-06, -6.693436220375295e-09, -1.768277437722866e-12,  4.311192352400483e-14,  1.804205849272652e-16,  3.243916226297572e-19,
 -4.129387242233572e-22, -4.934668723456245e-24, -1.629661635753110e-26, -1.623782114792542e-29,  1.787751297296302e+00, -1.020509408323509e-03, -3.217958348870519e-06,
 -7.064290875897325e-09, -7.070100613475103e-12,  2.344576086312929e-14,  1.530519419756985e-16,  4.348267562409152e-19,  4.344453288046572e-22, -2.345015006424393e-24,
 -1.474491657875929e-26, -4.157108343315977e-29,  1.827589630230150e+00, -8.490743605944587e-04, -2.822805334013298e-06, -6.982359847431269e-09, -1.091151367930500e-11,
  4.253016357198411e-15,  1.046372786412742e-16,  4.242435641311735e-19,  9.591344285332203e-22,  3.676206529253371e-25, -7.710225614826242e-27, -3.993210877575261e-29,
  1.863703603174443e+00, -6.856882010301937e-04, -2.386609316896694e-06, -6.493718773936066e-09, -1.304963326088386e-11, -1.167863098878236e-14,  4.812945846025812e-17,
  3.178873103505419e-19,  1.067065798337685e-21,  2.168341266677344e-24,  3.362426941355113e-28, -1.957827855266763e-29,  1.895900467139674e+00, -5.335929536264822e-04,
 -1.931785640283215e-06, -5.675695866277328e-09, -1.346374651200333e-11, -2.237615164457964e-14, -3.374440564221875e-18,  1.635375369492710e-19,  8.215123965730082e-22,
  2.600667466068358e-24,  5.462589258886615e-27,  3.077696709262595e-30,  1.924006721812894e+00, -3.958423919912302e-04, -1.481556729656094e-06, -4.630436233301334e-09,
 -1.235268743854189e-11, -2.699248821300574e-14, -3.974512546874420e-17,  1.467694995303836e-20,  3.974699131588522e-22,  1.885955163071565e-24,  6.169537113878805e-27,
  1.491394118873737e-29,  1.947869624135486e+00, -2.752307160449850e-04, -1.058845097783524e-06, -3.476173683477866e-09, -1.010288930868300e-11, -2.589986959396172e-14,
 -5.604682554851928e-17, -8.686978129678840e-20, -2.534712281801735e-24,  6.946703450760523e-25,  3.648764025521574e-27,  1.325362296208206e-29,  1.967358553702979e+00,
 -1.742257955462800e-04, -6.851536514867422e-07, -2.336930914879504e-09, -7.230862710993230e-12, -2.054548160947199e-14, -5.331131329315240e-17, -1.230427226307416e-19,
 -2.340646683706918e-22, -2.652253085373267e-25,  4.747892298508780e-28,  4.712069784462177e-30,  1.982366228586606e+00, -9.490896717881736e-05, -3.794941391646835e-07,
 -1.331550049448492e-09, -4.307662232421578e-12, -1.309729632919856e-14, -3.768032914263749e-17, -1.024987581944173e-19, -2.615244583912162e-22, -6.138912659820132e-25,
 -1.266854440030467e-27, -2.003508123161765e-30,  1.992809866092602e+00, -3.892268992996902e-05, -1.574217908060285e-07, -5.630449073055820e-10, -1.875721681811223e-12,
 -5.951147391000881e-15, -1.818103600011282e-17, -5.378614032528713e-20, -1.544771199296704e-22, -4.308910957669012e-25, -1.165492214186124e-27, -3.045431234684160e-30,
  1.998633786472406e+00, -7.419516006976449e-06, -3.019842771831717e-08, -1.091508832017913e-10, -3.694236350562889e-13, -1.198593088843592e-15, -3.774468517262990e-18,
 -1.162107059830895e-20, -3.514337840392721e-23, -1.047060555426427e-25, -3.079875509395629e-28, -8.956677711066630e-31,  4.742926830060541e-04, -2.324475981925217e-06,
  8.542130043130722e-09, -2.789522876464319e-11,  8.536930657395357e-14, -2.506994995697486e-16,  7.153886045630895e-19, -1.998562491705032e-21,  5.492350673007444e-24,
 -1.489627251953027e-26,  3.996381621496094e-29, -1.062312245870180e-31,  4.266515711165898e-03, -2.087451138745218e-05,  7.644598436358123e-08, -2.481892041877905e-10,
  7.528576795302567e-13, -2.183384370895460e-15,  6.126119211495474e-18, -1.674147999449224e-20,  4.473588994859796e-23, -1.171524755334027e-25,  3.009910521828804e-28,
 -7.588502191239807e-31,  1.183966122263128e-02, -5.773091699158936e-05,  2.099556980982869e-07, -6.736450288811033e-10,  2.006850727571224e-12, -5.670910649720140e-15,
  1.535046551644408e-17, -3.996697766331266e-20,  1.001201989285785e-22, -2.405713765488327e-25,  5.503598867217988e-28, -1.181281263875130e-30,  2.317111756174728e-02,
 -1.124085458872426e-04,  4.045342705693940e-07, -1.274774616117570e-09,  3.692478994771542e-12, -1.000917087509040e-14,  2.551308354636253e-17, -6.090047631266036e-20,
  1.341292140015573e-22, -2.629650015702924e-25,  4.151430147942095e-28, -3.105358608871983e-31,  3.822694124531462e-02, -1.841851444957911e-04,  6.535227677103193e-07,
 -2.009255716574965e-09,  5.594677425432644e-12, -1.426514676162303e-14,  3.304571290782916e-17, -6.734677666031532e-20,  1.095624337999847e-22, -8.521720007223430e-26,
 -3.194937119737990e-28,  2.130129400204401e-30,  5.696182692952691e-02, -2.721079345399971e-04,  9.483136536160792e-07, -2.824138896216334e-09,  7.457483045462999e-12,
 -1.740895910618464e-14,  3.444132019408783e-17, -4.941241140476843e-20,  5.702497363144875e-24,  3.066215159186541e-25, -1.501654115588872e-27,  5.042892239534387e-30,
  7.931906932262166e-02, -3.750024235661541e-04,  1.278577615385314e-06, -3.658650575476375e-09,  9.007529440316274e-12, -1.846530060630618e-14,  2.704815873339892e-17,
 -2.961272074292850e-21, -1.693919641237492e-22,  8.087505576181100e-25, -2.577830316504434e-27,  6.231600612829519e-30,  1.052305187448208e-01, -4.914834699457005e-04,
  1.632540140751443e-06, -4.447476286478495e-09,  9.979979239004781e-12, -1.666616607062604e-14,  9.762237140123444e-18,  6.808431304920678e-20, -3.750094864284715e-22,
  1.215053487574127e-24, -2.784651162558717e-27,  3.569333213576401e-30,  1.346165324919977e-01, -6.199686300990663e-04,  1.997303094453737e-06, -5.124384277680632e-09,
  1.014488882224627e-11, -1.158581657858831e-14, -1.651450347251960e-17,  1.512847727212847e-19, -5.447244771793209e-22,  1.282340924375662e-24, -1.515198821989483e-27,
 -3.462952279479812e-30,  1.673859246324114e-01, -7.586938143029166e-04,  2.359205485032665e-06, -5.626029101085518e-09,  9.331873813322510e-12, -3.239925532630540e-15,
 -4.875280879562299e-17,  2.273896702616860e-19, -6.035130618021987e-22,  8.278276255775267e-25,  1.288249260341442e-27, -1.273354428988245e-29,  2.034359173587131e-01,
 -9.057312721584349e-04,  2.704216522437582e-06, -5.895758773967055e-09,  7.450955860936887e-12,  7.866109305786316e-15, -8.206536279164723e-17,  2.740641997035487e-19,
 -4.912194303172901e-22, -1.742125403118405e-25,  4.906502680619739e-27, -1.970217995081149e-29,  2.426520975311649e-01, -1.059009918883112e-03,  3.018352948936283e-06,
 -5.887238505438308e-09,  4.507631733395073e-12,  2.074978812151722e-14, -1.103590889353285e-16,  2.710069377386108e-19, -1.860693862203374e-22, -1.535271145013898e-24,
  7.935139073052407e-27, -1.919617533981699e-29,  2.849083825822319e-01, -1.216337998300149e-03,  3.288111499738352e-06, -5.567699855898120e-09,  6.105189058897087e-13,
  3.402870844799810e-14, -1.272968650023045e-16,  2.054301739350847e-19,  2.790614555536203e-22, -2.865839617449703e-24,  8.734817471689678e-27, -8.162242546286312e-30,
  3.300670005055086e-01, -1.375428057001884e-03,  3.500906243114698e-06, -4.920627596143252e-09, -4.029606752770378e-12,  4.605851281751441e-14, -1.274340418128192e-16,
  7.665320376630868e-20,  8.139380414654151e-22, -3.669528686932294e-24,  6.122361005248696e-27,  1.186289265158635e-29,  3.779784892195141e-01, -1.533924175951620e-03,
  3.645499500511211e-06, -3.947708434255590e-09, -9.109970369098021e-12,  5.511997020127774e-14, -1.073494614199454e-16, -1.014122500526145e-19,  1.285161428987245e-21,
 -3.500458752639640e-24,  4.659010028620758e-29,  3.401105962302249e-29,  4.284817211732695e-01, -1.689431370123273e-03,  3.712414104178385e-06, -2.669887017199945e-09,
 -1.425504060532542e-11,  5.963631049610213e-14, -6.656953842575266e-17, -3.007978831524173e-19,  1.546185474820721e-21, -2.139237230719113e-24, -8.061417705441834e-27,
  4.797762730416847e-29,  4.814039596371932e-01, -1.839547023134915e-03,  3.694313973561573e-06, -1.127405769768451e-09, -1.904396868948965e-11,  5.839608933212850e-14,
 -8.094226098325744e-18, -4.833891405193183e-19,  1.477194908603960e-21,  2.732900417024449e-25, -1.550217138590312e-26,  4.429331367775009e-29,  5.365609536882792e-01,
 -1.981894171856169e-03,  3.586339453654964e-06,  6.212535995212431e-10, -2.304454555992011e-11,  5.075333438575600e-14,  6.162180266016727e-17, -6.078355371101785e-19,
  1.024891757061336e-21,  3.202515203504956e-24, -1.912978677526641e-26,  1.938077371906801e-29,  5.937570794380221e-01, -2.114156395547842e-03,  3.386383640239216e-06,
  2.501558053010602e-09, -2.585125009232075e-11,  3.677628652690557e-14,  1.333030042701014e-16, -6.383286056572424e-19,  2.304513244023302e-22,  5.820170461907267e-24,
 -1.656718765497141e-26, -2.103063099913342e-29,  6.527855355468636e-01, -2.234113995436311e-03,  3.095296107601912e-06,  4.426211963267468e-09, -2.712432664727610e-11,
  1.731923267178487e-14,  1.960719411859774e-16, -5.534966233322561e-19, -7.647263189975648e-22,  7.229503682838599e-24, -7.375977382596827e-27, -6.232491238726890e-29,
  7.134286014979474e-01, -2.339681074361704e-03,  2.717001147154038e-06,  6.299451237551756e-09, -2.662638476606285e-11, -6.001096133168759e-15,  2.391134981435453e-16,
 -3.533558584701032e-19, -1.741125613438522e-21,  6.759470336026582e-24,  6.337355048638034e-27, -8.599578126339684e-29,  7.754579674397161e-01, -2.428943043409138e-03,
  2.258518912082293e-06,  8.022176561694248e-09, -2.425283142105675e-11, -3.093261540764276e-14,  2.535429573095735e-16, -6.238776221503412e-20, -2.449435171199710e-21,
  4.235316700883067e-24,  2.026387756661036e-26, -7.775402796105017e-29,  8.386351446214649e-01, -2.500193994991771e-03,  1.729879827019023e-06,  9.497688272556027e-09,
 -2.005259059779008e-11, -5.481339005485239e-14,  2.341639409853903e-16,  2.725696808816438e-19, -2.675251622151930e-21,  1.234016727568609e-25,  2.923239535408703e-26,
 -3.531073875721808e-29,  9.027119655049424e-01, -2.551973292166851e-03,  1.143925328253609e-06,  1.063771855543510e-08, -1.423608043393655e-11, -7.487607249040966e-14,
  1.807775052392940e-16,  5.898811916152481e-19, -2.303659095750997e-21, -4.524945346016396e-24,  2.916447056713308e-26,  2.821142492503445e-29,  9.674311825019101e-01,
 -2.583100635280573e-03,  5.159914864597744e-07,  1.136839989659259e-08, -7.168319031956520e-12, -8.859799685437862e-14,  9.874034363054414e-17,  8.250957323341698e-19,
 -1.364391119238474e-21, -8.344873245396284e-24,  1.891037780690145e-26,  8.787734977145515e-29,  1.032527173923610e+00, -2.592708783436513e-03, -1.365236729550069e-07,
  1.163576823358825e-08,  6.537090725698147e-13, -9.405261835729195e-14, -1.427930196259145e-18,  9.250677809031995e-19, -4.106471353621332e-23, -1.008087662283198e-23,
  1.143642877318089e-27,  1.170451540675027e-28,  1.097726765093827e+00, -2.580273034684511e-03, -7.947033532403614e-07,  1.141038144188679e-08,  8.638746022786282e-12,
 -9.021192803680495e-14, -1.054299214573636e-16,  8.610555499407477e-19,  1.363473857144406e-21, -9.028865687961893e-24, -1.823481051824242e-26,  9.993302750662121e-29,
  1.162750171634110e+00, -2.545636510928274e-03, -1.438754292240954e-06,  1.069064465905693e-08,  1.615162308362359e-11, -7.715025468621340e-14, -1.974172108594659e-16,
  6.374323932364079e-19,  2.501033915047725e-21, -5.336180437822503e-24, -3.214963737089677e-26,  4.054675600929282e-29,  1.227312070642406e+00, -2.489030257686899e-03,
 -2.048730824504673e-06,  9.504478294792961e-09,  2.257220161340587e-11, -5.610860870810996e-14, -2.627168183607413e-16,  2.933072600252564e-19,  3.073312296733569e-21,
 -2.814312735502581e-26, -3.515382972246734e-26, -3.722360192817641e-29,  1.291122803825350e+00, -2.411087161760514e-03, -2.605317222691150e-06,  7.909045201210886e-09,
  2.735732129927968e-11, -2.939541140204931e-14, -2.905676236130740e-16, -1.041549116208347e-19,  2.921166449577238e-21,  5.282490659554328e-24, -2.581916730274259e-26,
 -9.956769348397755e-29,  1.353889714589456e+00, -2.312848718352091e-03, -3.090638963569842e-06,  5.988370273219785e-09,  3.009915159164628e-11, -1.226528043650884e-16,
 -2.763132737451780e-16, -4.738648399503336e-19,  2.078976624709317e-21,  8.927188943885655e-24, -7.583629355779834e-27, -1.186885532932572e-28,  1.415318618639598e+00,
 -2.195763749708628e-03, -3.489068348652151e-06,  3.848834901489872e-09,  3.057297305703169e-11,  2.819669869097826e-14, -2.225478469576635e-16, -7.394214215693468e-19,
  7.732244866974106e-22,  9.772209155208052e-24,  1.248606775269052e-26, -8.679593339480960e-29,  1.475115404782943e+00, -2.061678295342809e-03, -3.787985839823264e-06,
  1.612702137079665e-09,  2.876787817387856e-11,  5.213806283516127e-14, -1.388814562166569e-16, -8.476595871749285e-19, -6.390585515842485e-22,  7.641325052065827e-24,
  2.661850420900401e-26, -2.044540485397192e-29,  1.532987759420909e+00, -1.912816063269876e-03, -3.978456051752155e-06, -5.899863467605682e-10,  2.489525860545322e-11,
  6.886884492147147e-14, -4.026419534853820e-17, -7.821253131533106e-19, -1.776069406365207e-21,  3.390455394906113e-24,  2.968999463699298e-26,  4.777356965647073e-29,
  1.588647004681866e+00, -1.751749054051827e-03, -4.055777061418198e-06, -2.630619905800458e-09,  1.937220089559380e-11,  7.658353933728072e-14,  5.587203951901601e-17,
 -5.674339238456268e-19, -2.348379915710905e-21, -1.415879668243868e-24,  2.143123017607183e-26,  8.619251790225099e-29,  1.641810036379161e+00, -1.581358243425577e-03,
 -4.019863965401246e-06, -4.391657265472229e-09,  1.277986527458948e-11,  7.479146200301307e-14,  1.330959853561350e-16, -2.627683853790134e-19, -2.247876536191023e-21,
 -5.110312985002915e-24,  6.381768291228815e-27,  8.039679998737211e-29,  1.692201344075238e+00, -1.404784529979254e-03, -3.875432722445113e-06, -5.775904047238036e-09,
  5.800248737431865e-12,  6.439750308376809e-14,  1.793299007484162e-16,  5.413699353709593e-20, -1.576403913361678e-21, -6.565222498048062e-24, -8.424333488996025e-27,
  3.964639458898295e-29,  1.739555091621450e+00, -1.225370512804639e-03, -3.631958358266000e-06, -6.714592423974761e-09, -8.620107367047940e-13,  4.754935128338068e-14,
  1.892909427972680e-16,  3.082081035402908e-19, -6.024777067446794e-22, -5.599168895236602e-24, -1.688441795400102e-26, -1.019673593888617e-29,  1.783617232777045e+00,
 -1.046594047189007e-03, -3.303392436970119e-06, -7.173457417468132e-09, -6.563458970262134e-12,  2.726659805162210e-14,  1.654081990361118e-16,  4.472608458891648e-19,
  3.389640941338938e-22, -2.971770279210542e-24, -1.660057886793690e-26, -4.262842762099962e-29,  1.824147633062722e+00, -8.719949170995854e-04, -2.907637897331095e-06,
 -7.156123035340441e-09, -1.080036025271711e-11,  6.910335125860119e-15,  1.169473354885622e-16,  4.550845621344290e-19,  9.663797194748381e-22,  2.250317666426958e-26,
 -9.584843906216413e-27, -4.531185590891160e-29,  1.860922166064694e+00, -7.050963408952198e-04, -2.465794203136579e-06, -6.704315629624070e-09, -1.327091359461022e-11,
 -1.041278316234122e-14,  5.752009201185092e-17,  3.532832042472619e-19,  1.145147267544357e-21,  2.163090205106204e-24, -6.366050821127283e-28, -2.477045067741233e-29,
  1.893734750187091e+00, -5.493233683217688e-04, -2.001201288472375e-06, -5.894698783558612e-09, -1.391169278246268e-11, -2.239913099460494e-14,  1.587024869755433e-18,
  1.913663210555635e-19,  9.190970394322860e-22,  2.821312473208956e-24,  5.554557621931572e-27,  1.002139662051338e-30,  1.922399290626153e+00, -4.079205080631619e-04,
 -1.538325804929629e-06, -4.832449691672942e-09, -1.290203504515544e-11, -2.793993804850707e-14, -3.914555046833528e-17,  2.853122713585184e-20,  4.699671536428284e-22,
  2.146149561151393e-24,  6.847147858486742e-27,  1.586931474732193e-29,  1.946751491628526e+00, -2.838711209966880e-04, -1.101546392274003e-06, -3.642037803471514e-09,
 -1.063453490490918e-11, -2.727416667570718e-14, -5.847634782321360e-17, -8.652141976219961e-20,  2.524612397104636e-23,  8.528420924233181e-25,  4.274029719511769e-27,
  1.520439805596369e-29,  1.966650507637220e+00, -1.798211959234088e-04, -7.139047737278888e-07, -2.455982699971094e-09, -7.654850530396016e-12, -2.186715054217772e-14,
 -5.686277732499309e-17, -1.306814722193201e-19, -2.432181085622961e-22, -2.417706450582583e-25,  7.061377020831152e-28,  5.837615202842760e-30,  1.981980417933063e+00,
 -9.801002661066828e-05, -3.958950814173977e-07, -1.402618340796008e-09, -4.578888880494109e-12, -1.403703025823766e-14, -4.067085043806932e-17, -1.112310953211491e-19,
 -2.845580041716124e-22, -6.663368194747241e-25, -1.355566546608051e-27, -2.023003544739466e-30,  1.992651613060416e+00, -4.020960981062275e-05, -1.643624049528080e-07,
 -5.940328681485554e-10, -1.999233014121620e-12, -6.406137648876216e-15, -1.975865136066119e-17, -5.898686773301640e-20, -1.708616549967982e-22, -4.803020770953097e-25,
 -1.307896702179340e-27, -3.435435598491888e-30,  1.998603616793766e+00, -7.666445008742901e-06, -3.154451030838780e-08, -1.152584711281879e-10, -3.943283977206221e-13,
 -1.293215661334263e-15, -4.116186805778328e-18, -1.280842638138810e-20, -3.914438708682194e-23, -1.178515777054482e-25, -3.502598514684067e-28, -1.029076449663299e-30,
  4.651293654085903e-04, -2.257455067204983e-06,  8.215420260377757e-09, -2.656851758789458e-11,  8.052257768572852e-14, -2.341823144187767e-16,  6.618109570651511e-19,
 -1.831087913775952e-21,  4.983767387837967e-24, -1.338737817570498e-26,  3.557245375819444e-29, -9.365711903455704e-32,  4.184222223772662e-03, -2.027465508467909e-05,
  7.353857266502473e-08, -2.364849908728533e-10,  7.106231108314458e-13, -2.041824697591996e-15,  5.676781617078013e-18, -1.537515144834456e-20,  4.072730280008118e-23,
 -1.057549371633555e-25,  2.695021235028321e-28, -6.742159451843997e-31,  1.161204640824002e-02, -5.608306899638940e-05,  2.020609364367359e-07, -6.424231200101049e-10,
  1.897027818828828e-12, -5.315574200125289e-15,  1.427497173113342e-17, -3.689755137576462e-20,  9.184365382314825e-23, -2.195646105003461e-25,  5.007511143839545e-28,
 -1.075181026261706e-30,  2.272786044177895e-02, -1.092324715506107e-04,  3.895849533105889e-07, -1.217263721637823e-09,  3.498283064943364e-12, -9.416843052145938e-15,
  2.386655962073712e-17, -5.675663210339057e-20,  1.249579371043737e-22, -2.466484185772547e-25,  4.003268766790264e-28, -3.599264308845770e-31,  3.750050644829795e-02,
 -1.790519062824585e-04,  6.299395109977429e-07, -1.921980843691024e-09,  5.317154753975545e-12, -1.349428490946595e-14,  3.120860937984712e-17, -6.389215378923787e-20,
  1.062861468316227e-22, -9.623362916847054e-26, -2.339724954491135e-28,  1.766867429976203e-30,  5.588835640441932e-02, -2.646549817148630e-04,  9.151285595168285e-07,
 -2.707560159372922e-09,  7.117457861211110e-12, -1.659893957600029e-14,  3.306190663659837e-17, -4.906448748740289e-20,  1.571145280362145e-23,  2.508070519920407e-25,
 -1.293547784468522e-27,  4.427878293978644e-30,  7.783924223493474e-02, -3.649469956609752e-04,  1.235526458356072e-06, -3.517449320602963e-09,  8.644705216135154e-12,
 -1.781772610156718e-14,  2.689359365342793e-17, -7.935347785046074e-21, -1.420682168714340e-22,  7.109768280862557e-25, -2.314415876592050e-27,  5.742998414217593e-30,
  1.032903712981132e-01, -4.786339383738331e-04,  1.580117546600122e-06, -4.290449850992317e-09,  9.649146430288294e-12, -1.641031242774427e-14,  1.150701805760242e-17,
  5.676269410329283e-20, -3.332340433586740e-22,  1.106874443598684e-24, -2.622892185932998e-27,  3.763216511667368e-30,  1.321682292401592e-01, -6.042334341223492e-04,
  1.936776679903395e-06, -4.963939916754237e-09,  9.909542123359135e-12, -1.193326047136597e-14, -1.251571138002207e-17,  1.345802459080829e-19, -4.996843211090575e-22,
  1.219071603450895e-24, -1.639159823926578e-27, -2.211977983105611e-30,  1.643884726611879e-01, -7.400876868769617e-04,  2.292586657244123e-06, -5.477298955976798e-09,
  9.255879187941448e-12, -4.335744451746044e-15, -4.265172692950661e-17,  2.085629688453124e-19, -5.729129233597808e-22,  8.687889989877402e-25,  7.751404411193410e-28,
 -1.062983661540271e-29,  1.998558145328422e-01, -8.843784984660387e-04,  2.634187560952570e-06, -5.775389338863057e-09,  7.589194737886360e-12,  5.986845438329239e-15,
 -7.461231393462121e-17,  2.582810497669910e-19, -4.941618928599420e-22,  5.305397980401790e-27,  4.084069640401876e-27, -1.768794148625834e-29,  2.384639058440400e-01,
 -1.035144426046578e-03,  2.948152055239706e-06, -5.811937772608244e-09,  4.896752272083307e-12,  1.819150657137919e-14, -1.028621354335122e-16,  2.642280159045866e-19,
 -2.358282295716981e-22, -1.234624525552041e-24,  7.101093989661757e-27, -1.866187841806990e-29,  2.800952175291243e-01, -1.190300139179226e-03,  3.221379637912893e-06,
 -5.552650982511610e-09,  1.261012562175636e-12,  3.104352437605490e-14, -1.214348340271443e-16,  2.127761070185150e-19,  1.820876877622421e-22, -2.524285501700719e-24,
  8.327854846357401e-27, -1.022779189757397e-29,  3.246209273532705e-01, -1.347658024301467e-03,  3.441501732167775e-06, -4.977897334983686e-09, -3.138832117859935e-12,
  4.302867414072453e-14, -1.249426248919726e-16,  1.006337717404246e-19,  6.863558143118585e-22, -3.415622376290856e-24,  6.538897273988697e-27,  7.186578811631481e-30,
  3.719008170929555e-01, -1.504952064995884e-03,  3.597288365440996e-06, -4.084789631954312e-09, -8.033541315535534e-12,  5.251403939909003e-14, -1.096321775702766e-16,
 -6.230016427191196e-20,  1.159523540394474e-21, -3.470371683200114e-24,  1.416050325060049e-27,  2.828563839828220e-29,  4.217831860518782e-01, -1.659863999168312e-03,
  3.679046047264831e-06, -2.888515427823446e-09, -1.307894470885410e-11,  5.794309120822619e-14, -7.431118572694939e-17, -2.526103207510716e-19,  1.463867208718350e-21,
 -2.420607845420638e-24, -6.036098139951839e-27,  4.400141096606198e-29,  4.741047876894201e-01, -1.810051718111830e-03,  3.678995378216701e-06, -1.422780955067039e-09,
 -1.787905821456405e-11,  5.804475559807966e-14, -2.096669073705283e-17, -4.360773349820862e-19,  1.476344116410407e-21, -3.075469580512888e-25, -1.353529080809588e-26,
  4.489904709748397e-29,  5.286907969006137e-01, -1.953179826531870e-03,  3.591615962319017e-06,  2.607360402887320e-10, -2.201604862442288e-11,  5.203183220979299e-14,
  4.507784850183048e-17, -5.733402438048536e-19,  1.126632843762363e-21,  2.456385299911774e-24, -1.812987737525420e-26,  2.581138280066928e-29,  5.853548162606922e-01,
 -2.086952226180211e-03,  3.413945435724685e-06,  2.093990025033427e-09, -2.508517425859635e-11,  3.976210251812867e-14,  1.155636228820741e-16, -6.277312596381719e-19,
  4.278555290039460e-22,  5.142197058399396e-24, -1.725351921189079e-26, -1.032958799434286e-29,  6.438989303159759e-01, -2.209146518258104e-03,  3.145818960193788e-06,
  3.995244175970705e-09, -2.673215333684736e-11,  2.183645746142966e-14,  1.802701282863984e-16, -5.738657921656187e-19, -5.104074926481822e-22,  6.882731678628966e-24,
 -9.884881327611587e-27, -5.165739615858563e-29,  7.041138177431221e-01, -2.317649941014773e-03,  2.790035468901235e-06,  5.872777235591847e-09, -2.668985243849028e-11,
 -3.871692419916858e-16,  2.284763984205796e-16, -4.051368189707043e-19, -1.494121204681628e-21,  6.938686116955832e-24,  2.661438344136011e-27, -8.078381854506129e-29,
  7.657789318817168e-01, -2.410496469280814e-03,  2.352437412443099e-06,  7.629511909084330e-09, -2.481082007227351e-11, -2.487725756866907e-14,  2.507227506756298e-16,
 -1.381804873689759e-19, -2.283211355865750e-21,  4.976050146445777e-24,  1.674298488113463e-26, -8.184844807133069e-29,  8.286627607355118e-01, -2.485904602963518e-03,
  1.841891856534748e-06,  9.168384451315004e-09, -2.109209081356910e-11, -4.911153367487615e-14,  2.405996373155612e-16,  1.872550985819507e-19, -2.650173354013681e-21,
  1.257580267931180e-24,  2.738016135820276e-26, -4.853771197946418e-29,  8.925231779933932e-01, -2.542315263516857e-03,  1.270162647572682e-06,  1.039820229471442e-08,
 -1.568892109195584e-11, -7.034768472929503e-14,  1.962392680873335e-16,  5.137850018538638e-19, -2.445306384324615e-21, -3.338681848636088e-24,  3.002175807184258e-26,
  1.079134774021120e-29,  9.571078968938792e-01, -2.578429103770437e-03,  6.516660902341689e-07,  1.123966763264001e-08, -8.914736625522177e-12, -8.595620226085017e-14,
  1.211876979712240e-16,  7.767818917620387e-19, -1.650294245859531e-21, -7.515002043134383e-24,  2.248344207735519e-26,  7.419174543567475e-29,  1.022155038792064e+00,
 -2.593242421064454e-03,  3.106245206395685e-09,  1.163118609747561e-08, -1.225590132537896e-12, -9.377654916332669e-14,  2.440113412501037e-17,  9.179659979564153e-19,
 -4.019164793792671e-22, -9.932705461560844e-24,  6.244410541473076e-27,  1.142318843647629e-28,  1.087393828025846e+00, -2.586080751436595e-03, -6.570094189252076e-07,
  1.153403827120490e-08,  6.811181343375987e-12, -9.244830631796068e-14, -8.075934682555451e-17,  8.993541162409519e-19,  1.026395739581556e-21, -9.667018541446141e-24,
 -1.359665993870972e-26,  1.103847334591504e-28,  1.152545424056260e+00, -2.556629119991214e-03, -1.308967736607197e-06,  1.093647538430619e-08,  1.456272951002915e-11,
 -8.166523300749205e-14, -1.784792676539190e-16,  7.141474814779351e-19,  2.286266588882102e-21, -6.580680340799584e-24, -2.993319688330740e-26,  6.005361098062077e-29,
  1.217323900811314e+00, -2.504957837182095e-03, -1.932548286899264e-06,  9.856316552597698e-09,  2.138770001821596e-11, -6.230415872427150e-14, -2.531294752829835e-16,
  3.913627824065053e-19,  3.046644113819199e-21, -1.461484684071839e-24, -3.637195277804845e-26, -1.783328429634391e-29,  1.281437381633377e+00, -2.431542671327849e-03,
 -2.507803008008089e-06,  8.341679376657201e-09,  2.669949592801681e-11, -3.639329910014755e-14, -2.921481597130694e-16, -7.842612733577524e-21,  3.091713779872189e-21,
  4.164713124066968e-24, -2.999859701096399e-26, -8.980498014217654e-29,  1.344589336163624e+00, -2.337278203867495e-03, -3.015890261828859e-06,  6.469572389565505e-09,
  3.002934872800122e-11, -6.905577774910580e-15, -2.886022708459954e-16, -4.022643861256670e-19,  2.393621911737308e-21,  8.517825767231625e-24, -1.291759352295066e-26,
 -1.232202375810884e-28,  1.406480042852748e+00, -2.223483195635075e-03, -3.439929673745354e-06,  4.342216755006756e-09,  3.108183438116208e-11,  2.261022906483711e-14,
 -2.428517124407479e-16, -7.089608101674548e-19,  1.133050006201656e-21,  1.019049728878314e-23,  8.312021188047018e-27, -1.027549600778892e-28,  1.466808217543315e+00,
 -2.091896869462921e-03, -3.765837895529569e-06,  2.081141068529530e-09,  2.977537455163826e-11,  4.851804490748308e-14, -1.628594147066962e-16, -8.635046404349687e-19,
 -3.450708573706434e-22,  8.682720249288034e-24,  2.531586720229510e-26, -3.902718297057037e-29,  1.525272804729356e+00, -1.944665155216101e-03, -3.983100680344947e-06,
 -1.807032582479960e-10,  2.626116555434932e-11,  6.763340893410237e-14, -6.293937702439621e-17, -8.367734996765278e-19, -1.632158198612555e-21,  4.616914952579002e-24,
  3.154881308305011e-26,  3.621557101911791e-29,  1.581574923698525e+00, -1.784316154207121e-03, -4.085434002991431e-06, -2.308344023328250e-09,  2.091594996743663e-11,
  7.772527774702977e-14,  3.892537536040050e-17, -6.432247387278099e-19, -2.383003976467293e-21, -4.824710971072770e-25,  2.524243189831705e-26,  8.662877371453361e-29,
  1.635419956874815e+00, -1.613724363776584e-03, -4.071287068150068e-06, -4.175041879944615e-09,  1.430699886974593e-11,  7.788917909920784e-14,  1.247041570951333e-16,
 -3.375876046778936e-19, -2.426372510762085e-21, -4.781237024562916e-24,  1.014667994959309e-26,  9.063862295493706e-29,  1.686519762421319e+00, -1.436063558079806e-03,
 -3.944143486136454e-06, -5.672562210744419e-09,  7.131330363246975e-12,  6.871368983274240e-14,  1.801035337820853e-16, -1.509064799250720e-22, -1.818363896785547e-21,
 -6.863649179230344e-24, -6.404138392238257e-27,  5.239395473797624e-29,  1.734594987693790e+00, -1.254748640680951e-03, -3.712584030330173e-06, -6.720526971652089e-09,
  1.350930647178812e-13,  5.219352234353272e-14,  1.976196232041578e-16,  2.855725979601069e-19, -8.162931259360313e-22, -6.281342854705086e-24, -1.716700969860835e-26,
 -2.330387503717730e-30,  1.779377454662599e+00, -1.073367255033855e-03, -3.390085311717556e-06, -7.273890134349302e-09, -5.977408755764752e-12,  3.138779664102961e-14,
  1.780663404330524e-16,  4.562641250178415e-19,  2.195749503050033e-22, -3.673396351229391e-24, -1.848086948025905e-26, -4.264344942038215e-29,  1.820612583190401e+00,
 -8.956024403656676e-04, -2.994543141543744e-06, -7.327666251181634e-09, -1.063303600496605e-11,  9.873472024234659e-15,  1.301222125176109e-16,  4.859436834714075e-19,
  9.597935247631181e-22, -4.023845996371237e-25, -1.169977601283979e-26, -5.083304835441076e-29,  1.858061813349612e+00, -7.251481266821489e-04, -2.547526618498220e-06,
 -6.918237847569699e-09, -1.346454148443704e-11, -8.909385222225322e-15,  6.793670647013066e-17,  3.911667094117835e-19,  1.222282072332325e-21,  2.114122707332534e-24,
 -1.855455414565811e-27, -3.076923733313101e-29,  1.891504984109131e+00, -5.656197421755375e-04, -2.073287967980647e-06, -6.120865776739626e-09, -1.435884291765125e-11,
 -2.229332447639370e-14,  7.372612282432170e-18,  2.224454255125091e-19,  1.024667410355446e-21,  3.043621275942366e-24,  5.540895251945180e-27, -1.744210739350728e-30,
  1.920742623104056e+00, -4.204626242402025e-04, -1.597572401486168e-06, -5.043403385156451e-09, -1.347015493673424e-11, -2.886807205271200e-14, -3.812413100893399e-17,
  4.486059933353110e-20,  5.523290885700769e-22,  2.434253684500460e-24,  7.564029864302995e-27,  1.668800883721124e-29,  1.945598101468442e+00, -2.928612444991672e-04,
 -1.146290011466456e-06, -3.816631303442087e-09, -1.119424819589494e-11, -2.870654934883200e-14, -6.088277872822043e-17, -8.518796561650794e-20,  5.919262740376563e-23,
  1.037808012903819e-24,  4.990152807549449e-27,  1.738580958491474e-29,  1.965919610738563e+00, -1.856524371282262e-04, -7.441261077237862e-07, -2.582034461617202e-09,
 -8.106141572012871e-12, -2.327665348383228e-14, -6.063208683716451e-17, -1.385977354041796e-19, -2.513481051032650e-22, -2.080084984858780e-25,  9.917892728560192e-28,
  7.186482390898250e-30,  1.981581935119459e+00, -1.012457800863240e-04, -4.131755140116543e-07, -1.478180600234003e-09, -4.869648175142108e-12, -1.505155582200684e-14,
 -4.391648492609200e-17, -1.207314004241647e-19, -3.095435674700065e-22, -7.223366517071540e-25, -1.444264611286157e-27, -2.000742582957482e-30,  1.992488098895439e+00,
 -4.155357632685454e-05, -1.716870388129164e-07, -6.270719165584641e-10, -2.132234887840533e-12, -6.900799050051198e-15, -2.148950280916417e-17, -6.474149478240531e-20,
 -1.891317845205918e-22, -5.357670572370132e-25, -1.468564880881607e-27, -3.876626197833184e-30,  1.998572437387864e+00, -7.924442756324375e-06, -3.296633873663141e-08,
 -1.217801320390941e-10, -4.212103938167753e-13, -1.396453341170860e-15, -4.493017046607699e-18, -1.413172444698919e-20, -4.365054034055182e-23, -1.328114848413218e-25,
 -3.988636548813693e-28, -1.184030595405466e-30,  4.562290031149271e-04, -2.192985442260552e-06,  7.904176405080804e-09, -2.531677962708307e-11,  7.599370440172173e-14,
 -2.188965113806679e-16,  6.127026829966120e-19, -1.679051726252322e-21,  4.526471419070552e-24, -1.204355685903023e-26,  3.169861188572429e-29, -8.266979400985860e-32,
  4.104282516584447e-03, -1.969750754963057e-05,  7.076764857395837e-08, -2.254344542941551e-10,  6.711149200744594e-13, -1.910604164600691e-15,  5.263965366523919e-18,
 -1.413076870231774e-20,  3.710722475387590e-23, -9.554550237000679e-26,  2.415134132212528e-28, -5.995332939989330e-31,  1.139089900103685e-02, -5.449690978354447e-05,
  1.945305247401336e-07, -6.129028975996302e-10,  1.794060330272683e-12, -4.985047516832599e-15,  1.328182499991682e-17, -3.408124864308595e-20,  8.428873470830336e-23,
 -2.004514942471411e-25,  4.556124215406388e-28, -9.780015314899549e-31,  2.229707272750745e-02, -1.061732831638248e-04,  3.753075080640918e-07, -1.162767297791195e-09,
  3.315547754965737e-12, -8.862672096533504e-15,  2.233204206769116e-17, -5.289698872593537e-20,  1.163629124383264e-22, -2.309628805882149e-25,  3.837093388337803e-28,
 -3.930253046106814e-31,  3.679423379987425e-02, -1.741032192587863e-04,  6.073774116815499e-07, -1.839025358566652e-09,  5.054616187100784e-12, -1.276636497935082e-14,
  2.946671242575429e-17, -6.054808759725046e-20,  1.026711441638182e-22, -1.041322487036179e-25, -1.632064551280802e-28,  1.458100604074573e-30,  5.484417546012958e-02,
 -2.574620051304422e-04,  8.833102966388245e-07, -2.596294017167835e-09,  6.793302976774400e-12, -1.582187467683828e-14,  3.169642804646282e-17, -4.842687127717467e-20,
  2.385458452721647e-23,  2.027955417905520e-25, -1.111023761546146e-27,  3.879134255656640e-30,  7.639895863362277e-02, -3.552292970572094e-04,  1.194135311880883e-06,
 -3.381949888565127e-09,  8.294784602312184e-12, -1.717543682619552e-14,  2.661148059642579e-17, -1.208938958757559e-20, -1.180798222025222e-22,  6.233125049247868e-25,
 -2.072276220256476e-27,  5.265857456981657e-30,  1.014007950236867e-01, -4.661963398696417e-04,  1.529547685670303e-06, -4.138673633778137e-09,  9.323824530011047e-12,
 -1.611624060025295e-14,  1.295293256775531e-17,  4.671684160461945e-20, -2.952348357296513e-22,  1.005302458223758e-24, -2.455090227787023e-27,  3.848287779400036e-30,
  1.297819104523386e-01, -5.889748126420272e-04,  1.878152791551482e-06, -4.807311635732224e-09,  9.668169203515184e-12, -1.219018534594574e-14, -8.964816681916353e-18,
  1.192797074366513e-19, -4.569984846925245e-22,  1.151875144069031e-24, -1.713218832654768e-27, -1.189385364135189e-30,  1.614643905706008e-01, -7.220073933117261e-04,
  2.227744597758440e-06, -5.329952277313860e-09,  9.159390322002897e-12, -5.291351302329001e-15, -3.706388937194130e-17,  1.907352811930511e-19, -5.411859549553430e-22,
  8.910061627533427e-25,  3.492972631152668e-28, -8.765171655514593e-30,  1.963600115358304e-01, -8.635801439257486e-04,  2.565615094377670e-06, -5.653099195543682e-09,
  7.691601242566692e-12,  4.281146713881280e-15, -6.760158421472748e-17,  2.425009666812145e-19, -4.912126351530599e-22,  1.536834127277637e-25,  3.349062899763004e-27,
 -1.573442062924056e-29,  2.343700587811928e-01, -1.011836823909062e-03,  2.878890468926261e-06, -5.730810727826447e-09,  5.236490185724887e-12,  1.581070403131631e-14,
 -9.557570221817587e-17,  2.560235960907861e-19, -2.753578273928376e-22, -9.667813623849556e-25,  6.296992765073446e-27, -1.784913444432387e-29,  2.753851375902957e-01,
 -1.164795240160204e-03,  3.154888864675019e-06, -5.527664132218722e-09,  1.853224320576963e-12,  2.820115786882613e-14, -1.154087360559642e-16,  2.172123064672700e-19,
  9.709666109107541e-23, -2.200641154603255e-24,  7.843778778495259e-27, -1.168235645028526e-29,  3.192849798431724e-01, -1.320365738928536e-03,  3.381493510153976e-06,
 -5.021395984941942e-09, -2.308004276525121e-12,  4.006623415471032e-14, -1.218355141089130e-16,  1.206807840054221e-19,  5.681664062740275e-22, -3.148964338622167e-24,
  6.764988007879617e-27,  3.202067944008549e-30,  3.659382520219920e-01, -1.476371934208034e-03,  3.547533864628759e-06, -4.205067526196254e-09, -7.009692366018657e-12,
  4.986601213020917e-14, -1.108758057136809e-16, -2.718107579610277e-20,  1.035894930093966e-21, -3.390450383875403e-24,  2.540807864340785e-27,  2.290380399273681e-29,
  4.152023703577847e-01, -1.630573749571312e-03,  3.643166205644720e-06, -3.088606861021694e-09, -1.193846348017386e-11,  5.607995693410684e-14, -8.074187319006998e-17,
 -2.072037270850923e-19,  1.372834466465196e-21, -2.624593655488776e-24, -4.194999804693580e-27,  3.963724375863313e-29,  4.669233298621865e-01, -1.780692823645596e-03,
  3.660243827030297e-06, -1.699590121747214e-09, -1.672415659856592e-11,  5.740035762569356e-14, -3.251784101460412e-17, -3.891121023888626e-19,  1.456002450396667e-21,
 -8.095372589387557e-25, -1.156840869862957e-26,  4.432785811220052e-29,  5.209355549163799e-01, -1.924440292425122e-03,  3.592665770817527e-06, -8.314224694117617e-11,
 -2.096587224905320e-11,  5.292520891826478e-14,  2.954136261352917e-17, -5.360107612184989e-19,  1.202297213536664e-21,  1.755454114024897e-24, -1.688103381871471e-26,
  3.070729809946531e-29,  5.770617800743584e-01, -2.059546912952708e-03,  3.436691854167812e-06,  1.699133922239671e-09, -2.426361192902748e-11,  4.232642515883839e-14,
  9.820570254443095e-17, -6.112118872899413e-19,  6.004692474078063e-22,  4.445881721126570e-24, -1.749216877298180e-26, -7.099866960822464e-31,  6.351129707653679e-01,
 -2.183795431310399e-03,  3.191210762107058e-06,  3.571253134519258e-09, -2.625346946168369e-11,  2.596850211296207e-14,  1.640099040167155e-16, -5.863149447993338e-19,
 -2.702650104190525e-22,  6.445066808581171e-24, -1.191943053428024e-26, -4.082573909164769e-29,  6.948882946303706e-01, -2.295055022268496e-03,  2.857947268680902e-06,
  5.445971631578500e-09, -2.664370727858785e-11,  4.954966979595321e-15,  2.165008601264540e-16, -4.489383079485956e-19, -1.243251634928048e-21,  6.975971834744781e-24,
 -7.469757180399429e-28, -7.390089785504633e-29,  7.561751552715558e-01, -2.391317537649127e-03,  2.441594352740872e-06,  7.228883907332790e-09, -2.524854710681878e-11,
 -1.891442631914932e-14,  2.458586292535659e-16, -2.082548752104376e-19, -2.092892543480270e-21,  5.573117580488822e-24,  1.309945888612769e-26, -8.335181672734265e-29,
  8.187493011953759e-01, -2.470735195309297e-03,  1.949856236370227e-06,  8.823368505704916e-09, -2.201620220129389e-11, -4.328375841102088e-14,  2.446637902241724e-16,
  1.033809077559912e-19, -2.585732774871699e-21,  2.306665076676204e-24,  2.499391411078816e-26, -5.954108355471194e-29,  8.823750236416620e-01, -2.531659221254976e-03,
  1.393389351105856e-06,  1.013618455450261e-08, -1.704765823674159e-11, -6.547425551672191e-14,  2.095133382227569e-16,  4.338445112282666e-19, -2.543814764826486e-21,
 -2.133349625624734e-24,  3.012160146916860e-26, -6.122311037010859e-30,  9.468054577568037e-01, -2.572678825401017e-03,  7.856300878534828e-07,  1.108344416749090e-08,
 -1.060304576028647e-11, -8.279290987806866e-14,  1.421588611050487e-16,  7.198235282675272e-19, -1.903899787337531e-21, -6.554821504134245e-24,  2.541276918488786e-26,
  5.871176028041789e-29,  1.011783002119631e+00, -2.592659749821002e-03,  1.425010560773137e-07,  1.159661293524450e-08, -3.093191802750784e-12, -9.288426713521207e-14,
  4.987076787862359e-17,  8.994413798601773e-19, -7.538006337529448e-22, -9.583995004976612e-24,  1.114580410387737e-26,  1.080153366401714e-28,  1.077039871885723e+00,
 -2.590781481472508e-03, -5.180084197257528e-07,  1.162812875797106e-08,  4.944890512738678e-12, -9.408096129024443e-14, -5.517061679502559e-17,  9.265352573839139e-19,
  6.697859593807926e-22, -1.011138215024241e-23, -8.569131582617296e-27,  1.175731296848025e-28,  1.142298800691207e+00, -2.566572075612081e-03, -1.176386643984599e-06,
  1.115618682675639e-08,  1.288825127931914e-11, -8.570074176488297e-14, -1.574961213435471e-16,  7.832919551335522e-19,  2.028497160057280e-21, -7.719673837384759e-24,
 -2.688348496885428e-26,  7.830215079418791e-29,  1.207273905855395e+00, -2.519939399655894e-03, -1.812261448374305e-06,  1.018822492991226e-08,  2.008181007317685e-11,
 -6.823681025617260e-14, -2.408163393931894e-16,  4.877316145410453e-19,  2.967708932254478e-21, -2.925977067084320e-24, -3.669988866064016e-26,  3.131870495709573e-30,
  1.271671730244127e+00, -2.451197490311384e-03, -2.405164957206455e-06,  8.762667550613425e-09,  2.590155493569867e-11, -4.339618034639533e-14, -2.909618205072330e-16,
  9.325199980910274e-20,  3.219125168702882e-21,  2.889414901429464e-24, -3.366907366187528e-26, -7.645753837213385e-29,  1.335192472305795e+00, -2.361086631464457e-03,
 -2.935378362494505e-06,  6.948557069162370e-09,  2.982110621238775e-11, -1.395825826386853e-14, -2.987480051729283e-16, -3.208725849227278e-19,  2.689650722702316e-21,
  7.892122919096632e-24, -1.837486652201131e-26, -1.242185812625102e-28,  1.397531413182004e+00, -2.250785720084931e-03, -3.384825337893659e-06,  4.842820391889397e-09,
  3.147416924887935e-11,  1.654801528985354e-14, -2.621394527878480e-16, -6.667784240168171e-19,  1.504762655850560e-21,  1.042815238413393e-23,  3.464952981819553e-27,
 -1.172666953112106e-28,  1.458380546355043e+00, -2.121915506627197e-03, -3.737974455266100e-06,  2.565089340617794e-09,  3.070468556382879e-11,  4.431832933898951e-14,
 -1.871437732610745e-16, -8.693539259350162e-19, -1.473186836203952e-23,  9.655226419870923e-24,  2.316426512196233e-26, -5.895065815971420e-29,  1.517430410983263e+00,
 -1.976531389148640e-03, -3.982703697374032e-06,  2.502065928908883e-10,  2.759680066212981e-11,  6.583596846314331e-14, -8.707350181943142e-17, -8.860967853789697e-19,
 -1.442886860257711e-21,  5.906654726184922e-24,  3.283162061344170e-26,  2.158612101545668e-29,  1.574372124891366e+00, -1.817104619164614e-03, -4.111074754075465e-06,
 -1.961208299384159e-09,  2.247829420304157e-11,  7.843473740348211e-14,  1.984631817472100e-17, -7.195564660204686e-19, -2.381283648753780e-21,  6.029926420198893e-25,
  2.901390781073789e-26,  8.430827603277984e-29,  1.628899607174723e+00, -1.646491051396888e-03, -4.119962174375048e-06, -3.933508388843801e-09,  1.589389979262673e-11,
  8.075971962515038e-14,  1.141394177247848e-16, -4.178992127290052e-19, -2.590204260747971e-21, -4.292762217894922e-24,  1.434558315981339e-26,  1.000378830379577e-28,
  1.680711973656548e+00, -1.467886943263007e-03, -4.011483513453009e-06, -5.547232002223642e-09,  8.548793709258948e-12,  7.302931877112192e-14,  1.792472101130901e-16,
 -6.233670446875780e-20, -2.069474154572083e-21, -7.069682604485238e-24, -3.795912577390700e-27,  6.634246853976860e-29,  1.729516081185128e+00, -1.284771780451259e-03,
 -3.793182095291207e-06, -6.709754160229004e-09,  1.227023741010888e-12,  5.702918029458611e-14,  2.052150167583318e-16,  2.557005967177544e-19, -1.054781587046932e-21,
 -6.967316452449448e-24, -1.705967374032911e-26,  7.557318734069733e-30,  1.775029189231329e+00, -1.100838660869580e-03, -3.477924344573084e-06, -7.364270072167575e-09,
 -5.305878528178948e-12,  3.581536015711033e-14,  1.909191867171756e-16,  4.610283196797216e-19,  7.357665565792267e-23, -4.449874166905794e-24, -2.033335881627413e-26,
 -4.131135760181346e-29,  1.816981699774156e+00, -9.199133895305742e-04, -3.083488829096400e-06, -7.496040703951886e-09, -1.040321724549548e-11,  1.316313609140939e-14,
  1.441557756743385e-16,  5.163305080510101e-19,  9.363299779008565e-22, -9.167361788225883e-25, -1.405790584442202e-26, -5.633579089686511e-29,  1.855119929443421e+00,
 -7.458640903499934e-04, -2.631843651512759e-06, -7.135003619172100e-09, -1.362551407488583e-11, -7.142982736245018e-15,  7.944828030497499e-17,  4.314803824348720e-19,
  1.296710607020536e-21,  2.010873817539486e-24, -3.356895382620396e-27, -3.762180927479779e-29,  1.889208861788763e+00, -5.825037868945433e-04, -2.148131482724275e-06,
 -6.354162395799077e-09, -1.480241588984164e-11, -2.203783215370767e-14,  1.407691109499369e-17,  2.570304765244910e-19,  1.138199896761867e-21,  3.262740563100576e-24,
  5.389234748687866e-27, -5.293615382342339e-30,  1.919034822919219e+00, -4.334889948969095e-04, -1.659405589690139e-06, -5.263594005476470e-09, -1.405655375213722e-11,
 -2.976589771703005e-14, -3.660699191222725e-17,  6.399710295226318e-20,  6.455871055902057e-22,  2.751697155557764e-24,  8.312570287261264e-27,  1.729425386982306e-29,
  1.944408021429509e+00, -3.022178518827364e-04, -1.193183440631641e-06, -4.000412520298350e-09, -1.178318299825005e-11, -3.019610921743919e-14, -6.323562332454151e-17,
 -8.265596256118981e-20,  1.003372869414351e-22,  1.253409235760180e-24,  5.807564599859169e-27,  1.981013669842338e-29,  1.965164895577648e+00, -1.917316244154874e-04,
 -7.759043332000951e-07, -2.715537391456000e-09, -8.586545407701655e-12, -2.477930791141534e-14, -6.462649482007302e-17, -1.467523857703708e-19, -2.580420201740999e-22,
 -1.615589280985006e-25,  1.342424633290835e-27,  8.798478842699999e-30,  1.981170226948580e+00, -1.046234846677465e-04, -4.313912901589725e-07, -1.558561656876403e-09,
 -5.181498954958469e-12, -1.614726095099598e-14, -4.743962942689839e-17, -1.310641813891517e-19, -3.366086130473596e-22, -7.818494126495683e-25, -1.530803069453304e-27,
 -1.922139185627003e-30,  1.992319089107204e+00, -4.295776273162651e-05, -1.794212433740652e-07, -6.623204537990545e-10, -2.275558794850714e-12, -7.439002395758166e-15,
 -2.338997807744369e-17, -7.111399311226784e-20, -2.095191621764269e-22, -5.980635138053067e-25, -1.649891205260301e-27, -4.375588155965959e-30,  1.998540202735537e+00,
 -8.194135643135995e-06, -3.446907753117226e-08, -1.287489272004038e-10, -4.502506703800878e-13, -1.509196380566921e-15, -4.909002107412612e-18, -1.560822530308034e-20,
 -4.873195272825391e-23, -1.498590551097995e-25, -4.548271716603981e-28, -1.364281456238840e-30,  4.475816328424718e-04, -2.130946893764469e-06,  7.607528518559355e-09,
 -2.413512052932214e-11,  7.175909765069543e-14, -2.047398326888146e-16,  5.676536184813850e-19, -1.540903954448241e-21,  4.114876521450431e-24, -1.084543922454924e-26,
  2.827726306693643e-29, -7.305684651167939e-32,  4.026607889679235e-03, -1.914200753176699e-05,  6.812562302915094e-08, -2.149955801793903e-10,  6.341348200987083e-13,
 -1.788885867184529e-15,  4.884423787293603e-18, -1.299655762503968e-20,  3.383530212731213e-23, -8.639254712336625e-26,  2.166146035151140e-28, -5.335775199167692e-31,
  1.117597794874723e-02, -5.296960440663580e-05,  1.873446848582069e-07, -5.849785394723338e-10,  1.697471269008385e-12, -4.677436772434080e-15,  1.236425114490519e-17,
 -3.149603442447204e-20,  7.739039559542236e-23, -1.830609052437539e-25,  4.145640010241349e-28, -8.891630433558692e-31,  2.187829740031140e-02, -1.032257473851509e-04,
  3.616668366840904e-07, -1.111107936370917e-09,  3.143536175132176e-12, -8.344063284517339e-15,  2.090182791837995e-17, -4.930348215828676e-20,  1.083202886378524e-22,
 -2.159671400750223e-25,  3.659312160741040e-28, -4.131791816209643e-31,  3.610740111119859e-02, -1.693311174850097e-04,  5.857860476402234e-07, -1.760156263159931e-09,
  4.806225479298420e-12, -1.207914028559263e-14,  2.781679080183899e-17, -5.732373048806173e-20,  9.881959991050713e-23, -1.094576200350528e-25, -1.049685808998611e-28,
  1.196237836723481e-30,  5.382826566326552e-02, -2.505183208747455e-04,  8.527966157112448e-07, -2.490091796734052e-09,  6.484363267154360e-12, -1.507733912705434e-14,
  3.035220077293972e-17, -4.755496652247158e-20,  3.039506730046222e-23,  1.616203601302099e-25, -9.512894477927889e-28,  3.391066324116449e-30,  7.499689373325347e-02,
 -3.458363178572149e-04,  1.154336988826119e-06, -3.251946825962412e-09,  7.957633081657072e-12, -1.654123013044757e-14,  2.622333982136756e-17, -1.552446887092423e-20,
 -9.707801814999413e-23,  5.449188062556084e-25, -1.850752605123450e-27,  4.806813508387784e-30,  9.956017143617525e-02, -4.541561030232455e-04,  1.480768108384121e-06,
 -3.992053723210727e-09,  9.004708997733463e-12, -1.579070815804753e-14,  1.413404641558007e-17,  3.782975941502405e-20, -2.607707452700019e-22,  9.104908001464670e-25,
 -2.285494722135607e-27,  3.848321498299586e-30,  1.274556999788099e-01, -5.741777301256202e-04,  1.821385115808715e-06, -4.654581941953926e-09,  9.422476087446034e-12,
 -1.236687763026540e-14, -5.823581058002845e-18,  1.053059231918903e-19, -4.167747526256705e-22,  1.082555905911805e-24, -1.746737519256386e-27, -3.643772122532707e-31,
  1.586116033407622e-01, -7.044387912327880e-04,  2.164660827929340e-06, -5.184295198709073e-09,  9.045090562505103e-12, -6.118724804469900e-15, -3.196091567645682e-17,
  1.739325225156771e-19, -5.089466211023243e-22,  8.977627956730219e-25,  4.632410951350825e-31, -7.127097777822784e-30,  1.929463141275452e-01, -8.433244738706209e-04,
  2.498518843989339e-06, -5.529434467927053e-09,  7.761540633997078e-12,  2.738418796224454e-15, -6.103061202014617e-17,  2.268952179802614e-19, -4.834304852551318e-22,
  2.743549703228429e-25,  2.698071789170565e-27, -1.387341891020037e-29,  2.303683402329356e-01, -9.890793315126772e-04,  2.810633481218765e-06, -5.644619383889660e-09,
  5.530341483188811e-12,  1.360188495374052e-14, -8.853529628335305e-17,  2.467023730338228e-19, -3.058148129657986e-22, -7.303229666317950e-25,  5.533308861700417e-27,
 -1.683666289412862e-29,  2.707760155159498e-01, -1.139820911145829e-03,  3.088752935564191e-06, -5.493648777560836e-09,  2.390043530523128e-12,  2.550461157754509e-14,
 -1.092947762377571e-16,  2.191113596497684e-19,  2.339433964581169e-23, -1.897479917201955e-24,  7.307500092841474e-27, -1.261500645605988e-29,  3.140572383502519e-01,
 -1.293555385757410e-03,  3.321041122230694e-06, -5.052071144891371e-09, -1.535636232581567e-12,  3.718468217495472e-14, -1.182185821678843e-16,  1.371007445683120e-19,
  4.596990173437038e-22, -2.876572316898811e-24,  6.830394091619022e-27, -1.239284985369525e-31,  3.600892026488871e-01, -1.448195338312603e-03,  3.496432566527927e-06,
 -4.309388816972102e-09, -6.039025080537214e-12,  4.719949371616469e-14, -1.111909932045706e-16,  4.036158830046903e-21,  9.158973236769356e-22, -3.270155147989224e-24,
  3.437827290216590e-27,  1.794441521938218e-29,  4.087381268118094e-01, -1.601579835769495e-03,  3.604993497359019e-06, -3.270756655394806e-09, -1.083668704800596e-11,
  5.407740731533636e-14, -8.594296353426827e-17, -1.648138438495952e-19,  1.275736873526921e-21, -2.758847584236437e-24, -2.550959373932995e-27,  3.507279867349343e-29,
  4.598589869925726e-01, -1.751496915370748e-03,  3.638280963522164e-06, -1.958038583369824e-09, -1.558480914996640e-11,  5.649442265244654e-14, -4.276568673502357e-17,
 -3.430718325973483e-19,  1.418996473319911e-21, -1.233654926582612e-24, -9.648709129377567e-27,  4.278861979675653e-29,  5.132952621356536e-01, -1.895708579132109e-03,
  3.589690381786043e-06, -4.100946714654499e-10, -1.990147111649813e-11,  5.345850331279399e-14,  1.508027748425141e-17, -4.966537188002664e-19,  1.253675186457059e-21,
  1.108351859077352e-24, -1.544896228114378e-26,  3.415778682463164e-29,  5.688786993950006e-01, -2.031978354254101e-03,  3.454780488950226e-06,  1.317810641810276e-09,
 -2.339488845424785e-11,  4.448030918377238e-14,  8.138387867728163e-17, -5.895709889343983e-19,  7.479426067533457e-22,  3.748134146200931e-24, -1.733403222410360e-26,
  7.688497891744295e-30,  6.264291097999833e-01, -2.158101425172938e-03,  3.231563283354572e-06,  3.155560855797229e-09, -2.569607095795941e-11,  2.970697172497665e-14,
  1.475062120743480e-16, -5.913464089081328e-19, -4.722872690595548e-23,  5.935519961569264e-24, -1.348036680160806e-26, -3.018360102856221e-29,  6.857542053724699e-01,
 -2.271937275224904e-03,  2.920745305272932e-06,  5.020743075154274e-09, -2.649368817508518e-11,  9.995880440842773e-15,  2.034112874527421e-16, -4.847161899547385e-19,
 -9.934171189726040e-22,  6.883382183407283e-24, -3.823045116607768e-27, -6.574315116645981e-29,  7.466494902950446e-01, -2.371444690681863e-03,  2.525905648352450e-06,
  6.822199328731781e-09, -2.556834019693939e-11, -1.309117193243479e-14,  2.391207180546960e-16, -2.719233639680557e-19, -1.883711960716651e-21,  6.023845406558396e-24,
  9.443540031880230e-27, -8.244870970695429e-29,  8.088982201515810e-01, -2.454718875851375e-03,  2.053595571493137e-06,  8.464503727739056e-09, -2.282297156383009e-11,
 -3.738635797288561e-14,  2.464138761976595e-16,  2.215376137436403e-20, -2.485353534286141e-21,  3.251320748793462e-24,  2.217640554681614e-26, -6.811587191398743e-29,
  8.722714446610349e-01, -2.520030304276594e-03,  1.513344673429823e-06,  9.853223311107125e-09, -1.830592399627579e-11, -6.030942474608547e-14,  2.205114632642130e-16,
  3.514453545223540e-19, -2.599036232991312e-21, -9.386347430841824e-25,  2.949858181476240e-26, -2.198123059101930e-29,  9.365281506424334e-01, -2.565864788013941e-03,
  9.175595010488262e-07,  1.090074067103805e-08, -1.222318975081959e-11, -7.914633191333341e-14,  1.614269246673261e-16,  6.553241089858850e-19, -2.120997552866873e-21,
 -5.491486774379765e-24,  2.763244388688195e-26,  4.203659825726335e-29,  1.001415523106485e+00, -2.590964086018945e-03,  2.813023951943700e-07,  1.153233392473208e-08,
 -4.936883656041742e-12, -9.138819764377057e-14,  7.466622183796233e-17,  8.698945726582000e-19, -1.089676793455325e-21, -9.045646588775951e-24,  1.570344357348107e-26,
  9.866143984509777e-29,  1.066669343272667e+00, -2.594366197066225e-03, -3.780584674195287e-07,  1.169213096974471e-08,  3.052142802742712e-12, -9.509165675881909e-14,
 -2.898270089205985e-17,  9.420883020477195e-19,  3.008657965262338e-22, -1.034934786206345e-23, -3.302640005543877e-27,  1.212112828070635e-28,  1.132014542848363e+00,
 -2.575444297753814e-03, -1.041332337008541e-06,  1.134848893914614e-08,  1.113825067346044e-11, -8.921039156933740e-14, -1.346983979048767e-16,  8.435568303998194e-19,
  1.732108532287650e-21, -8.721149792254515e-24, -2.307166751239849e-26,  9.458177419139637e-29,  1.197165933950820e+00, -2.533943099930229e-03, -1.688120935802599e-06,
  1.049830681186196e-08,  1.866043913257739e-11, -7.384190078907731e-14, -2.258481724988161e-16,  5.807302655795127e-19,  2.836041153619656e-21, -4.384826319018361e-24,
 -3.608341835397369e-26,  2.497147938355605e-29,  1.261829133462433e+00, -2.470011225125624e-03, -2.297556264894714e-06,  9.169770724836081e-09,  2.496407251989962e-11,
 -5.033620434733771e-14, -2.868948488321292e-16,  1.976620785121805e-19,  3.298133846573538e-21,  1.480053213486265e-24, -3.667731615871435e-26, -5.975523986511322e-29,
  1.325701699236601e+00, -2.384228040046193e-03, -2.849143333748279e-06,  7.423069003420677e-09,  2.946956514573759e-11, -2.122604061180878e-14, -3.064858349987351e-16,
 -2.304104154153720e-19,  2.959224670758409e-21,  7.048382745281746e-24, -2.379082037324474e-26, -1.212868996101884e-28,  1.388474493267016e+00, -2.277623283534197e-03,
 -3.323680175628923e-06,  5.348706707084424e-09,  3.174073342820779e-11,  1.003841967845687e-14, -2.800785467154251e-16, -6.126029777301043e-19,  1.881392400488164e-21,
  1.045974526965263e-23, -1.975118647207993e-27, -1.295856707067447e-28,  1.449833283561405e+00, -2.151687760569203e-03, -3.704217296369334e-06,  3.063202933820046e-09,
  3.154416706076646e-11,  3.953505002385271e-14, -2.114387851797754e-16, -8.640905424088733e-19,  3.488543685751594e-22,  1.052386434386234e-23,  2.011686816334230e-26,
 -7.963913878299573e-29,  1.509460591911338e+00, -2.008373403190661e-03, -3.977008864724508e-06,  7.021670876883820e-10,  2.889058662567174e-11,  6.344346400206203e-14,
 -1.124968419352762e-16, -9.286119079702925e-19, -1.206424612546254e-21,  7.233932016077643e-24,  3.340356038963632e-26,  3.920790227653613e-30,  1.567037788955830e+00,
 -1.850081121745264e-03, -4.132399505756358e-06, -1.588987159309471e-09,  2.405007572683496e-11,  7.866069558969715e-14, -1.363175978454219e-18, -7.951790537591003e-19,
 -2.337804042346446e-21,  1.836358557397011e-24,  3.261410313524511e-26,  7.877061230660820e-29,  1.622247430894002e+00, -1.679635110352488e-03, -4.165584688401179e-06,
 -3.666139747918005e-09,  1.753549085339800e-11,  8.334914671749187e-14,  1.012554360200145e-16, -5.031388721148722e-19, -2.733331325506389e-21, -3.628429287398473e-24,
  1.892938885285807e-26,  1.080359392885871e-28,  1.674775823988645e+00, -1.500242640715205e-03, -4.077180658745189e-06, -5.398533604608089e-09,  1.005221835985532e-11,
  7.730258739509304e-14,  1.765362222530246e-16, -1.326553515271022e-19, -2.325972997369491e-21, -7.158810377332175e-24, -5.519067783838004e-28,  8.124330863181458e-29,
  1.724315793796150e+00, -1.315438883228090e-03, -3.873542838368067e-06, -6.680727148508186e-09,  2.417418167555292e-12,  6.203620555741073e-14,  2.118634499793261e-16,
  2.178035611827609e-19, -1.317777227133619e-21, -7.639663008849048e-24, -1.646974923708337e-26,  1.962839695533132e-29,  1.770569626150192e+00, -1.129016927709971e-03,
 -3.566780493197910e-06, -7.443180320549054e-09, -4.542704381841983e-12,  4.055243848686901e-14,  2.038357197563873e-16,  4.606591588190410e-19, -1.016902639406123e-22,
 -5.298808313037161e-24, -2.209139391349164e-26, -3.829106995793139e-29,  1.813252136728786e+00, -9.449439185383215e-04, -3.174430716239079e-06, -7.660193123022975e-09,
 -1.010416874570426e-11,  1.679971303128627e-14,  1.590267420580172e-16,  5.456515569842412e-19,  8.925940015285273e-22, -1.530204643001267e-24, -1.665394040347336e-26,
 -6.160690700674366e-29,  1.852093816077683e+00, -7.672650360391529e-04, -2.718776111644490e-06, -7.354046928151624e-09, -1.374830303169510e-11, -5.086491814279197e-15,
  9.212133605414334e-17,  4.741041009056299e-19,  1.366266131919638e-21,  1.841278892212184e-24, -5.179176644229725e-27, -4.535531004852494e-29,  1.886843987892993e+00,
 -5.999978981742492e-04, -2.225816942040448e-06, -6.594506224507767e-09, -1.523918939252015e-11, -2.160939830983979e-14,  2.180162956899869e-17,  2.953732876497033e-19,
  1.259471417711809e-21,  3.472401315523317e-24,  5.061044475501858e-27, -9.793922834159773e-30,  1.917273910959297e+00, -4.470207610604135e-04, -1.723937945268087e-06,
 -5.493308492216067e-09, -1.466049977748194e-11, -3.062053418957502e-14, -3.451049164019634e-17,  8.630653663198701e-20,  7.508177218131763e-22,  3.099532616064780e-24,
  9.081382943963220e-27,  1.759167873260869e-29,  1.943179750469642e+00, -3.119585906722358e-04, -1.242339775115546e-06, -4.193858064805148e-09, -1.240246713791415e-11,
 -3.174113042162419e-14, -6.549792597366896e-17, -7.867662064487772e-20,  1.498585021492310e-22,  1.503913738729681e-24,  6.737142735402285e-27,  2.248505324412763e-29,
  1.964385344882223e+00, -1.980715786352972e-04, -8.093317214401193e-07, -2.856972494129227e-09, -9.097979602780477e-12, -2.638059065290147e-14, -6.885196037430000e-17,
 -1.550916356607339e-19, -2.627934098115507e-22, -9.957796123878054e-26,  1.770609816860888e-27,  1.071960824361364e-29,  1.980744710276012e+00, -1.081508602682940e-04,
 -4.506023149810801e-07, -1.644112333151335e-09, -5.516133341060575e-12, -1.733109323294186e-14, -5.126454373623299e-17, -1.422979832737521e-19, -3.658774078306123e-22,
 -8.447340109458934e-25, -1.612312131083957e-27, -1.768720528639481e-30,  1.992144336091053e+00, -4.442555452125451e-05, -1.875925528880029e-07, -6.999508263264143e-10,
 -2.430117725644220e-12, -8.025034151460692e-15, -2.547836422690020e-17, -7.817621417090475e-20, -2.322852266266053e-22, -6.680707130947732e-25, -1.854576075045034e-27,
 -4.939650707042477e-30,  1.998506864726832e+00, -8.476193016391710e-06, -3.605830594094450e-08, -1.362009625118307e-10, -4.816490902751765e-13, -1.632438123007127e-15,
 -5.368701098902884e-18, -1.725759880412516e-20, -5.446935869487601e-23, -1.693121932250132e-25, -5.193586179620184e-28, -1.574280742133939e-30,  4.391777586057160e-04,
 -2.071225939393983e-06,  7.324663175613765e-09, -2.301900752607571e-11,  6.779711849103071e-14, -1.916193632912076e-16,  5.262945976476237e-19, -1.415262711072687e-21,
  3.744049094304399e-24, -9.776079305706386e-27,  2.525204731895973e-29, -6.463589956710631e-32,  3.951113769830770e-03, -1.860715252904247e-05,  6.560539264401473e-08,
 -2.051293970702061e-10,  5.995005086047100e-13, -1.675907006290571e-15,  4.535222494437688e-18, -1.196196265267680e-20,  3.087563682383586e-23, -7.817983004036878e-26,
  1.944457396047616e-28, -4.752804851670366e-31,  1.096705323029496e-02, -5.149847119190205e-05,  1.804848639373679e-07, -5.585515609527097e-10,  1.606819941670669e-12,
 -4.391003545635033e-15,  1.151606473424958e-17, -2.912185946620101e-20,  7.108948362045361e-23, -1.672364003800349e-25,  3.772517254190433e-28, -8.080806390921028e-31,
  2.147109782657123e-02, -1.003849033389823e-04,  3.486299008622882e-07, -1.062119614124002e-09,  2.981561522014187e-12, -7.858600782133501e-15,  1.956870902685262e-17,
 -4.595884079323962e-20,  1.008045268498221e-22, -2.016970765813743e-25,  3.474997250465720e-28, -4.231323814657065e-31,  3.543931726782237e-02, -1.647280274385020e-04,
  5.651177139181214e-07, -1.685153584181645e-09,  4.571190524350820e-12, -1.143044441561697e-14,  2.625539994280180e-17, -5.422526240392499e-20,  9.481560964934479e-23,
 -1.126716070805336e-25, -5.734386744949786e-29,  9.746689725620883e-31,  5.283965033874306e-02, -2.438137312711412e-04,  8.235281889558607e-07, -2.388715230129674e-09,
  6.189993748038023e-12, -1.436474974803646e-14,  2.903510268217573e-17, -4.649629107637778e-20,  3.556322896792379e-23,  1.264216903112427e-25, -8.117961239816563e-28,
  2.958202741514558e-30,  7.363177372854847e-02, -3.367555758393182e-04,  1.116066752827381e-06, -3.127237252122894e-09,  7.633065132006609e-12, -1.591741960493379e-14,
  2.574801333357859e-17, -1.833097416248550e-20, -7.874370020521484e-23,  4.749884906487192e-25, -1.648941919307627e-27,  4.370418325745105e-30,  9.776693934405006e-02,
 -4.424991513344516e-04,  1.433717554548226e-06, -3.850486118199405e-09,  8.692368056573157e-12, -1.543969352798750e-14,  1.508125808228711e-17,  2.999222463187092e-20,
 -2.295979544958881e-22,  8.224424847266790e-25, -2.117397576087185e-27,  3.783154654119564e-30,  1.251877810653241e-01, -5.598275250609912e-04,  1.766426506146564e-06,
 -4.505807643070210e-09,  9.173972071585644e-12, -1.247273231548899e-14, -3.055967765799669e-18,  9.257917959096098e-20, -3.790623736609351e-22,  1.012570093021420e-24,
 -1.747781825494680e-27,  2.911232393820064e-31,  1.558280922033645e-01, -6.873679000774053e-04,  2.103313445323015e-06, -5.040592799601835e-09,  8.915430541097529e-12,
 -6.829155955511789e-15, -2.731395783754265e-17,  1.581627585067766e-19, -4.766984180000129e-22,  8.919441901602215e-25, -2.810041810936749e-28, -5.700374424912996e-30,
  1.896125752818280e-01, -8.235996211781723e-04,  2.432912293664737e-06, -5.404889125977401e-09,  7.802167268387605e-12,  1.348182658198770e-15, -5.489249622381402e-17,
  2.116031374952181e-19, -4.717534312658759e-22,  3.705921809586672e-25,  2.126511335219844e-27, -1.212682640284366e-29,  2.264565662014899e-01, -9.668636812040979e-04,
  2.743437571034134e-06, -5.554070740177296e-09,  5.781684419428501e-12,  1.155880121217092e-14, -8.176829112590177e-17,  2.365369206732371e-19, -3.282980067686087e-22,
 -5.234772769018344e-25,  4.817327778393813e-27, -1.569078457234057e-29,  2.662657353687626e-01, -1.115373894859375e-03,  3.023074971496362e-06, -5.451467776934925e-09,
  2.874402136951677e-12,  2.295518183067865e-14, -1.031590508031719e-16,  2.188223472569324e-19, -3.978895066212869e-23, -1.616455864015110e-24,  6.740105123953163e-27,
 -1.311017917959456e-29,  3.089357689913511e-01, -1.267229918361808e-03,  3.260292893584235e-06, -5.070844598597482e-09, -8.199959126420083e-13,  3.439507052247282e-14,
 -1.141890085391391e-16,  1.502068762582239e-19,  3.610512464768057e-22, -2.604306922992947e-24,  6.763120505673273e-27, -2.837162187954869e-30,  3.543520344775671e-01,
 -1.420432300256767e-03,  3.444170836557032e-06, -4.398606195695879e-09, -5.121695232313148e-12,  4.453547012049430e-14, -1.106851590762276e-16,  3.148926637514789e-20,
  8.008248466178122e-22, -3.118207045004780e-24,  4.126896323325402e-27,  1.345765201893775e-29,  4.023892347333404e-01, -1.572899750226865e-03,  3.564739419513498e-06,
 -3.435604819831951e-09, -9.776115561530310e-12,  5.196391940236413e-14, -9.000127524705572e-17, -1.255961162652568e-19,  1.174941220249823e-21, -2.831379398067498e-24,
 -1.109194509260506e-27,  3.046663972068734e-29,  4.529110571437460e-01, -1.722488807089291e-03,  3.613325455817062e-06, -2.198415362880975e-09, -1.446593621398897e-11,
  5.535786151739633e-14, -5.174317408302442e-17, -2.984453728537002e-19,  1.368085915623352e-21, -1.582578604110210e-24, -7.814276009874387e-27,  4.048486658001028e-29,
  5.057698241631373e-01, -1.867016072460651e-03,  3.582894038090879e-06, -7.199498302709667e-10, -1.882978462444019e-11,  5.365812029018407e-14,  1.740785179821602e-18,
 -4.560139836607118e-19,  1.282821508255720e-21,  5.211698636481257e-25, -1.389465337435697e-26,  3.628609997463494e-29,  5.608061537257523e-01, -2.004283150569460e-03,
  3.468377992914510e-06,  9.507098380817287e-10, -2.248707279743389e-11,  4.623825089266252e-14,  6.523030459866580e-17, -5.636109246313811e-19,  8.704965309118414e-22,
  3.063724287088944e-24, -1.683474132961079e-26,  1.478924581266434e-29,  6.178486391282318e-01, -2.132104394940007e-03,  3.266983405095697e-06,  2.749363553847610e-09,
 -2.506787126474149e-11,  3.304845129978966e-14,  1.309587210812484e-16, -5.895453524928764e-19,  1.564517504673454e-22,  5.372776548683775e-24, -1.458282892689510e-26,
 -2.003070279183308e-29,  6.767135596215265e-01, -2.248337506504420e-03,  2.978458271842706e-06,  4.598703977337281e-09, -2.624606879123288e-11,  1.471152227997095e-14,
  1.894311936982275e-16, -5.125757265334476e-19, -7.490414323493732e-22,  6.675215511719769e-24, -6.519431658441804e-27, -5.670709760159901e-29,  7.372046346678981e-01,
 -2.350916952401889e-03,  2.605309842148138e-06,  6.411320402821075e-09, -2.577342572902286e-11, -7.450249643123911e-15,  2.306960408337082e-16, -3.286665613212396e-19,
 -1.660921875757300e-21,  6.329784639997357e-24,  5.875692367468300e-27, -7.939590922890060e-29,  7.991128366432896e-01, -2.437890077688014e-03,  2.152954977002008e-06,
  8.093675739797314e-09, -2.351155511379553e-11, -3.147385419332365e-14,  2.459395253157437e-16, -5.533957260991249e-20, -2.353079496879342e-21,  4.076469753745627e-24,
  1.903697128857099e-26, -7.416731613272258e-29,  8.622162786557128e-01, -2.507455661167779e-03,  1.629787120413609e-06,  9.550969742511982e-09, -1.945844133574620e-11,
 -5.490848523624875e-14,  2.291840964199903e-16,  2.679611164314404e-19, -2.611860955559100e-21,  2.176218531988557e-25,  2.820982766248126e-26, -3.631202471293947e-29,
  9.262801960481312e-01, -2.558004520065363e-03,  1.047143424882644e-06,  1.069272282106665e-08, -1.376592803639699e-11, -7.505974130588239e-14,  1.787976132487496e-16,
  5.845057291082179e-19, -2.298395951671405e-21, -4.354252831283307e-24,  2.910356949951650e-26,  2.479012951336854e-29,  9.910570419800523e-01, -2.588161595898032e-03,
  4.191564830885759e-07,  1.143882724606275e-08, -6.744776419060562e-12, -8.930816036802967e-14,  9.848705215654324e-17,  8.299441460700004e-19, -1.402997807166740e-21,
 -8.334064549727146e-24,  1.978747173892518e-26,  8.656135223416925e-29,  1.056286719132081e+00, -2.596828757076460e-03, -2.375227484468354e-07,  1.172572177990326e-08,
  1.145494634842357e-12, -9.546995689356009e-14, -2.525572477839755e-18,  9.457397391073649e-19, -7.280050982923286e-23, -1.037453322823119e-23,  2.043002018752380e-27,
  1.211608029199300e-28,  1.121696970922037e+00, -2.583227336077266e-03, -9.041406232929727e-07,  1.151225978012852e-08,  9.323659529541162e-12, -9.215375098154302e-14,
 -1.103512423425287e-16,  8.937912051696243e-19,  1.402577378676306e-21, -9.556552801492345e-24, -1.859889905432097e-26,  1.082458427077174e-28,  1.187003956502697e+00,
 -2.546939187175121e-03, -1.560399525994900e-06,  1.078477033892838e-08,  1.713076699655225e-11, -7.905703219080007e-14, -2.083428809827834e-16,  6.686818956057343e-19,
  2.652531142656772e-21, -5.799710888752692e-24, -3.450093835469843e-26,  4.690876084028318e-29,  1.251913034046548e+00, -2.487944814953652e-03, -2.185156893314208e-06,
  9.560770078412553e-09,  2.388900377401030e-11, -5.714330122095093e-14, -2.798767835089981e-16,  3.037669111977664e-19,  3.324424977709471e-21, -3.403529987736960e-26,
 -3.888385902146141e-26, -4.009590060102479e-29,  1.316119776206814e+00, -2.406656898552523e-03, -2.757252736759790e-06,  7.890784223670021e-09,  2.897102143444974e-11,
 -2.864819036065014e-14, -3.115748175471761e-16, -1.318493600433317e-19,  3.194566653795967e-21,  5.991804187961652e-24, -2.898624063551540e-26, -1.141640114831290e-28,
  1.379311239957314e+00, -2.303947340680665e-03, -3.256443158060274e-06,  5.857793661523189e-09,  3.187293022004363e-11,  3.117850179926702e-15, -2.963321323706989e-16,
 -5.464001921547202e-19,  2.255119299395916e-21,  1.026370591292373e-23, -7.895262014227413e-27, -1.389674711722833e-28,  1.441167510035692e+00, -2.181165826924660e-03,
 -3.664405443522271e-06,  3.573951299709646e-09,  3.228217102000218e-11,  3.417180165643477e-14, -2.354190127265193e-16, -8.467173757005339e-19,  7.412973036388116e-22,
  1.125232752686626e-23,  1.615507422871012e-26, -1.003881419456585e-28,  1.501363530741310e+00, -2.040147816411891e-03, -3.965767990193683e-06,  1.174411816359249e-09,
  3.013032908087669e-11,  6.042741361430712e-14, -1.389974647527007e-16, -9.627928835916923e-19, -9.219637549677149e-22,  8.567683059125093e-24,  3.313451323699110e-26,
 -1.659702149577415e-29,  1.559571234706536e+00, -1.883209928039853e-03, -4.149106655145690e-06, -1.191609735288028e-09,  2.562111561394838e-11,  7.835241595644359e-14,
 -2.466375365652165e-17, -8.686726201233887e-19, -2.247399264281258e-21,  3.207819059671979e-24,  3.589221551546418e-26,  6.960661631569163e-29,  1.615461969372667e+00,
 -1.713130865390054e-03, -4.207839533633450e-06, -3.372108962894510e-09,  1.922558240053631e-11,  8.560022355589752e-14,  8.592447442069387e-17, -5.925398984759155e-19,
 -2.849162174551328e-21, -2.774255505026586e-24,  2.382285115455232e-26,  1.140045878781587e-28,  1.668709212263532e+00, -1.533116362406142e-03, -4.140946287462810e-06,
 -5.225100910880560e-09,  1.164029346048576e-11,  8.148623570781545e-14,  1.717411044756618e-16, -2.112069602016731e-19, -2.583184832961798e-21, -7.104860580122780e-24,
  3.362297365986301e-27,  9.673688794189254e-29,  1.718991554897443e+00, -1.346747147200547e-03, -3.953437647747259e-06, -6.631844410537521e-09,  3.709457763762369e-12,
  6.718908664571234e-14,  2.173293441016143e-16,  1.711090265677222e-19, -1.604418516027057e-21, -8.277121083530502e-24, -1.529854904899958e-26,  3.399125342238784e-29,
  1.765995922608827e+00, -1.157909616538192e-03, -3.656507119091982e-06, -7.509105022180228e-09, -3.681692935202231e-12,  4.559872708922233e-14,  2.166587071900679e-16,
  4.541791924631585e-19, -3.087473528544548e-22, -6.214827545298701e-24, -2.367261227864051e-26, -3.321082609918328e-29,  1.809420984143891e+00, -9.707097749631766e-04,
 -3.267311260043623e-06, -7.818959246024224e-09, -9.728754081622476e-12,  2.080286575347749e-14,  1.746956385245716e-16,  5.731992089792398e-19,  8.248492375973356e-22,
 -2.252026201831509e-24, -1.947187958743673e-26, -6.637151351760744e-29,  1.848980691319642e+00, -7.893719856515287e-04, -2.808347467289381e-06, -7.574708886002400e-09,
 -1.382682269206314e-11, -2.711280633286892e-15,  1.060179947179832e-16,  5.188411603261659e-19,  1.428319821423712e-21,  1.591727192020090e-24, -7.361140022017477e-27,
 -5.396769965632137e-29,  1.884407876151846e+00, -6.181251477161474e-04, -2.306428141145275e-06, -6.841759433810054e-09, -1.566545102883663e-11, -2.098224264659834e-14,
  3.065539068165675e-17,  3.377146124473865e-19,  1.388003856783844e-21,  3.664658743645224e-24,  4.510961375362584e-27, -1.540753865851331e-29,  1.915457821725127e+00,
 -4.610799779174267e-04, -1.791285408112679e-06, -5.732819903978475e-09, -1.528098275799336e-11, -3.141696638885982e-14, -3.174025899308155e-17,  1.121896572767670e-19,
  8.691260668199588e-22,  3.478265512968770e-24,  9.854314957219793e-27,  1.745928442599547e-29,  1.941911715110478e+00, -3.221020363364257e-04, -1.293877936569396e-06,
 -4.397462267767628e-09, -1.305318466738457e-11, -3.333892216665506e-14, -6.762521329514829e-17, -7.296089824645058e-20,  2.090962165271338e-22,  1.794029505715755e-24,
  7.789959370947281e-27,  2.541128628585600e-29,  1.963579888582995e+00, -2.046858824261997e-04, -8.445065035075302e-07, -3.006852338840602e-09, -9.642472557441848e-12,
 -2.808610155255463e-14, -7.331269355240900e-17, -1.635437519966279e-19, -2.649838937577555e-22, -1.867652378388044e-26,  2.291084012543091e-27,  1.300275933377842e-29,
  1.980304770091880e+00, -1.118361233528012e-04, -4.708728706021531e-07, -1.735211669334184e-09, -5.875388386431084e-12, -1.861060596564152e-14, -5.541746165190237e-17,
 -1.545052225848657e-19, -3.974668651980877e-22, -9.107169616797467e-25, -1.685006773571548e-27, -1.517186416066040e-30,  1.991963578246335e+00, -4.596056599370549e-05,
 -1.962306603192609e-07, -7.401506988267224e-10, -2.596914956888844e-12, -8.663644789553908e-15, -2.777508219494684e-17, -8.600890339269953e-20, -2.577250942043530e-22,
 -7.467826157897557e-25, -2.085659534426142e-27, -5.576928802313892e-30,  1.998472372482315e+00, -8.771330646292280e-06, -3.774005634790281e-08, -1.441757067516083e-10,
 -5.156265235890371e-13, -1.767288242558046e-15, -5.877261846032443e-18, -1.910229114443290e-20, -6.095585650822059e-23, -1.915412862548700e-25, -5.938800103481850e-28,
 -1.819320223223257e-30,  4.310083256700024e-04, -2.013715392402675e-06,  7.054819326728185e-09, -2.196423967401589e-11,  6.408790072659743e-14, -1.794506010940176e-16,
  4.882930259126192e-19, -1.300894643056483e-21,  3.409626874728791e-24, -8.820632865654016e-27,  2.257405205106281e-29, -5.725013710381925e-32,  3.877719483060126e-03,
 -1.809199504432495e-05,  6.320030467976315e-08, -1.957997320254291e-10,  5.670442583068611e-13, -1.570971787473201e-15,  4.213707186253422e-18, -1.101751269487778e-20,
  2.819626721612254e-23, -7.080460938626603e-26,  1.746908038612712e-28, -4.237100218103456e-31,  1.076390526177225e-02, -5.008097227842387e-05,  1.739336497553150e-07,
 -5.335302581904058e-10,  1.521698983204505e-12, -4.124151337745215e-15,  1.073161604219233e-17, -2.694047997857139e-20,  6.533222908901551e-23, -1.528351885148956e-25,
  3.433470630651008e-28, -7.341776566330114e-31,  2.107505669991563e-02, -9.764604667026087e-05,  3.361655902007441e-07, -1.015646919355559e-09,  2.828983617597685e-12,
 -7.404036041068516e-15,  1.832594924316911e-17, -4.284662724462659e-20,  9.378913406769661e-23, -1.881705419453827e-25,  3.288126757384902e-28, -4.251290021477823e-31,
  3.478932070252631e-02, -1.602867468897529e-04,  5.453272706120108e-07, -1.613809679961317e-09,  4.348761705088321e-12, -1.081819541363627e-14,  2.477895752235686e-17,
 -5.125642403135250e-20,  9.072795298064680e-23, -1.141650269059384e-25, -1.868864977721396e-29,  7.876527992696093e-31,  5.187739267080213e-02, -2.373385020028633e-04,
  7.954484862997774e-07, -2.291936268626239e-09,  5.909562405787570e-12, -1.368339745342729e-14,  2.774977981154828e-17, -4.529146834674281e-20,  3.956022155845118e-23,
  9.643690870771913e-26, -6.902312325864428e-28,  2.575294050154374e-30,  7.230237372267748e-02, -3.279750969883123e-04,  1.079262282828524e-06, -3.007621601173865e-09,
  7.320853282315887e-12, -1.530589587539378e-14,  2.520195090146821e-17, -2.058954028393890e-20, -6.278613076513003e-23,  4.127539339902960e-25, -1.465778363258184e-27,
  3.959581103985486e-30,  9.601959288973085e-02, -4.312118932468356e-04,  1.388336062713724e-06, -3.713858643364232e-09,  8.387257533582209e-12, -1.506846939140172e-14,
  1.582251688275516e-17,  2.310279447939826e-20, -2.014747067623046e-22,  7.410452636110030e-25, -1.953295008609526e-27,  3.669199270572851e-30,  1.229763948455802e-01,
 -5.459099154384488e-04,  1.713229273186595e-06, -4.361022854957151e-09,  8.923987019849751e-12, -1.251630642653647e-14, -6.281866558043054e-19,  8.101896596270899e-20,
 -3.438636904286783e-22,  9.430751583511392e-25, -1.723243720050707e-27,  8.023995768112931e-31,  1.531118939426844e-01, -6.707809265764650e-04,  2.043677594482952e-06,
 -4.899072718221694e-09,  8.772642002285448e-12, -7.433242417886599e-15, -2.309415248431903e-17,  1.434195318158645e-19, -4.448477471537210e-22,  8.760639038436137e-25,
 -5.040373044082977e-28, -4.468125531695553e-30,  1.863566956204006e-01, -8.043936337233388e-04,  2.368803295576120e-06, -5.279908336338052e-09,  7.816427876612785e-12,
  1.001684316302067e-16, -4.917683712392090e-17,  1.967358910461447e-19, -4.570051755473273e-22,  4.454670021197317e-25,  1.629017868517398e-27, -1.050843027611951e-29,
  2.226325866109053e-01, -9.451811865254622e-04,  2.677351053376733e-06, -5.459818776860601e-09,  5.993766315148474e-12,  9.674635388530070e-15, -7.529491048459224e-17,
  2.257657221448394e-19, -3.438378612179841e-22, -3.442357223884507e-25,  4.153673090332799e-27, -1.446634420517858e-29,  2.618521958260023e-01, -1.091450149675073e-03,
  2.957948021138777e-06, -5.401936953123369e-09,  3.309242925392615e-12,  2.055269310574957e-14, -9.705823437034869e-17,  2.166689232844567e-19, -9.326812802109306e-23,
 -1.358452166274722e-24,  6.159098591963406e-27, -1.324602130643831e-29,  3.039186283728512e-01, -1.241391147472467e-03,  3.199386261166964e-06, -5.078608772016442e-09,
 -1.591528085578653e-13,  3.170622461946366e-14, -1.098351889292504e-16,  1.603123614529820e-19,  2.721293640761833e-22, -2.336951514690263e-24,  6.588965813097717e-27,
 -4.991519089250196e-30,  3.487250758371930e-01, -1.393091393004923e-03,  3.390924806284185e-06, -4.473571627081723e-09, -4.257464320527525e-12,  4.189239992115135e-14,
 -1.094613323307344e-16,  5.535251891353362e-20,  6.916723765598251e-22, -2.942498948762831e-24,  4.629460041707889e-27,  9.469393916298416e-30,  3.961544068063188e-01,
 -1.544549324788505e-03,  3.522607567517388e-06, -3.583826923821699e-09, -8.758700774808801e-12,  4.976584266311043e-14, -9.300696251956954e-17, -8.963489303467531e-20,
  1.072523791962383e-21, -2.850276604708015e-24,  1.314145412807053e-28,  2.594840014343795e-29,  4.460787425985630e-01, -1.693691578422989e-03,  3.585592051660962e-06,
 -2.421083310453447e-09, -1.337184888370699e-11,  5.402063997849488e-14, -5.949571709932794e-17, -2.556350785956270e-19,  1.305908787112979e-21, -1.860334267807351e-24,
 -6.094478873138405e-27,  3.760824646179314e-29,  4.983590243386034e-01, -1.838392517895317e-03,  3.572482390855623e-06, -1.012643072644612e-09, -1.775721463669019e-11,
  5.355133069748910e-14, -1.045082831383148e-17, -4.147676222121430e-19,  1.291967676774967e-21, -2.324104197634678e-27, -1.227312495418171e-26,  3.723878493637694e-29,
  5.528445788835983e-01, -1.976496538229349e-03,  3.477658530239769e-06,  5.983945460976200e-10, -2.154791409256659e-11,  4.761764994656306e-14,  4.985484335874283e-17,
 -5.341189124246375e-19,  9.688429508568229e-22,  2.405146439596064e-24, -1.605203948360703e-26,  2.057159738809764e-29,  6.093726926761137e-01, -2.105843325394327e-03,
  3.297591601942112e-06,  2.353730535947340e-09, -2.437680556716266e-11,  3.599411375236853e-14,  1.145498072789866e-16, -5.815583098503612e-19,  3.391855650598588e-22,
  4.774669650289154e-24, -1.525386925534278e-26, -1.060841263334389e-29,  6.677682043823439e-01, -2.224296217527517e-03,  3.031133593284605e-06,  4.181362812893415e-09,
 -2.590755044366698e-11,  1.908315707796419e-14,  1.747792427784615e-16, -5.327551726740375e-19, -5.140036997301075e-22,  6.367318440354743e-24, -8.805941009826240e-27,
 -4.717297613848050e-29,  7.278431291666323e-01, -2.329773750043054e-03,  2.679767486603843e-06,  5.998051144603537e-09, -2.586783922830207e-11, -2.029770513329590e-15,
  2.207838251045639e-16, -3.781315017132533e-19, -1.429649267106225e-21,  6.496261801557804e-24,  2.483838878777771e-27, -7.450349649244148e-29,  7.893963296426357e-01,
 -2.420284382339368e-03,  2.247802240889327e-06,  7.712775068318895e-09, -2.408217560204584e-11, -2.559826772305174e-14,  2.433589099656613e-16, -1.281495642308435e-19,
 -2.193417878501191e-21,  4.771460001309343e-24,  1.568678516097178e-26, -7.770528040165400e-29,  8.522132508990512e-01, -2.493964291860148e-03,  1.742495481990410e-06,
  9.231150560805086e-09, -2.050104787316248e-11, -4.932746153281368e-14,  2.355196051727847e-16,  1.847213401745812e-19, -2.584135454914324e-21,  1.310255042055130e-24,
  2.633133555676200e-26, -4.873267143824276e-29,  9.160657394750072e-01, -2.549117978852337e-03,  1.174085800296133e-06,  1.046069697915746e-08, -1.522292931398508e-11,
 -7.058065242254265e-14,  1.941121397806181e-16,  5.086755173467715e-19, -2.433977953655879e-21, -3.173380991709278e-24,  2.981468520863573e-26,  7.590690216563385e-30,
  9.807119686831910e-01, -2.584261249779876e-03,  5.557164054897137e-07,  1.131675775111450e-08, -8.505447795734765e-12, -8.667095470605289e-14,  1.210529723408942e-16,
  7.804077628917642e-19, -1.687896131982989e-21, -7.470471000917015e-24,  2.328761333478704e-26,  7.220999629092220e-29,  1.045896495143231e+00, -2.598165937935125e-03,
 -9.676711586306858e-08,  1.172878020190548e-08, -7.623685247355671e-13, -9.521340960450896e-14,  2.386655124419639e-17,  9.374605464385273e-19, -4.435350705448187e-22,
 -1.018702451034160e-23,  7.305306208920247e-27,  1.174389217673893e-28,  1.111350473653982e+00, -2.589905477524768e-03, -7.651596987559212e-07,  1.164655843044283e-08,
  7.456152174661383e-12, -9.449711802115889e-14, -8.474942271109768e-17,  9.330350437627563e-19,  1.046328915711580e-21, -1.020191618489583e-23, -1.359274712106844e-26,
  1.187456907925027e-28,  1.176792059421726e+00, -2.558900176737662e-03, -1.429390768174084e-06,  1.104594834245727e-08,  1.550118934933980e-11, -8.382319500198056e-14,
 -1.884647156688593e-16,  7.499603285754870e-19,  2.419456017657581e-21, -7.132143483609048e-24, -3.196606483239513e-26,  6.812584783371257e-29,  1.241927027950860e+00,
 -2.504960744541074e-03, -2.068173196367321e-06,  9.933489359289958e-09,  2.267971834761223e-11, -6.374626916521276e-14, -2.698843101130001e-16,  4.098256483804594e-19,
  3.294835601242307e-21, -1.618333728563749e-24, -4.017032921360972e-26, -1.803850037509400e-29,  1.306449643332546e+00, -2.428328328876325e-03, -2.659802334839672e-06,
  8.349329517693307e-09,  2.832304115260611e-11, -3.615854474287416e-14, -3.138046575746652e-16, -2.640537065168593e-20,  3.388218116144899e-21,  4.734938160636530e-24,
 -3.377394005934088e-26, -1.027529604860162e-28,  1.370043804938641e+00, -2.329709040208982e-03, -3.183089040596978e-06,  6.367867933299857e-09,  3.186297185979332e-11,
 -4.169218015858557e-15, -3.105660015705291e-16, -4.683975151608344e-19,  2.617436018669170e-21,  9.823627636374654e-24, -1.415053833020481e-26, -1.447085499953635e-28,
  1.432384500323469e+00, -2.210300690153072e-03, -3.618397402426825e-06,  4.095618530214065e-09,  3.290720159229652e-11,  2.824030737960322e-14, -2.587332630881444e-16,
 -8.163988026844648e-19,  1.156893745116007e-21,  1.180421966056336e-23,  1.129380779276387e-26, -1.203817077455586e-28,  1.493139588132721e+00, -2.071809302490399e-03,
 -3.948743267018323e-06,  1.665974993109295e-09,  3.130331836025530e-11,  5.676493632863456e-14, -1.663205234280544e-16, -9.871067605820424e-19, -5.899061885412140e-22,
  9.871848739611593e-24,  3.190605018011625e-26, -3.961658215815863e-29,  1.551971928720768e+00, -1.916452890759790e-03, -4.160894759400063e-06, -7.691760749517989e-10,
  2.718023297264844e-11,  7.746060202856251e-14, -4.997405198233440e-17, -9.384588219988885e-19, -2.105369210693280e-21,  4.701196931698393e-24,  3.868118740835830e-26,
  5.649249939950326e-29,  1.608541871753336e+00, -1.746950082719398e-03, -4.246402342047000e-06, -3.050697390652612e-09,  2.095681125301352e-11,  8.745292950250324e-14,
  6.804328674907771e-17, -6.851172604385762e-19, -2.930662895723362e-21, -1.719837884839071e-24,  2.892184100053004e-26,  1.172625022262130e-28,  1.662510099200630e+00,
 -1.566491446086352e-03, -4.202475529776224e-06, -5.025596649157127e-09,  1.331070774893738e-11,  8.552748068342253e-14,  1.646318259159977e-16, -2.979267164099659e-19,
 -2.835471233642216e-21, -6.880636486700838e-24,  7.962624108947612e-27,  1.123404147543789e-28,  1.713540808847509e+00, -1.378691863965442e-03, -4.032618405740208e-06,
 -6.561457913975320e-09,  5.105755447664983e-12,  7.245640248463660e-14,  2.213559978579380e-16,  1.148851136268299e-19, -1.913006493184775e-21, -8.854407092567773e-24,
 -1.344420965562339e-26,  5.067783816050343e-29,  1.761305208016736e+00, -1.187523040785497e-03, -3.746938799793817e-06, -7.560429488867179e-09, -2.716696896431893e-12,
  5.094981050753913e-14,  2.292024521963788e-16,  4.405340433278269e-19, -5.498594818341023e-22, -7.188931914275868e-24, -2.497778699516197e-26, -2.567777758517586e-29,
  1.805485270130720e+00, -9.972261881807615e-04, -3.362058248544941e-06, -7.971057540192388e-09, -9.269454720638390e-12,  2.519105823850311e-14,  1.911014556824550e-16,
  5.981411075922391e-19,  7.290414402239869e-22, -3.090535200149024e-24, -2.248212248157581e-26, -7.028502812061989e-29,  1.845777688825913e+00, -8.122061155102039e-04,
 -2.900572676803835e-06, -7.796228573565805e-09, -1.385440034490088e-11,  1.269747178457347e-17,  1.211936160620612e-16,  5.654025949600765e-19,  1.479725018253912e-21,
  1.247067149579207e-24, -9.940691865574689e-27, -6.341650425099053e-29,  1.881897946679772e+00, -6.369092699177748e-04, -2.390046847436104e-06, -7.095720527551263e-09,
 -1.607694619053675e-11, -2.012789902715814e-14,  4.075329873759230e-17,  3.842749641398656e-19,  1.522998666433886e-21,  3.829606798703034e-24,  3.686196324199784e-27,
 -2.230909056040342e-29,  1.913584399621426e+00, -4.756896409821842e-04, -1.861567087516181e-06, -5.982382605930173e-09, -1.591666855855523e-11, -3.213777566204669e-14,
 -2.819020469602764e-17,  1.420827414748570e-19,  1.001622478824462e-21,  3.887640472375989e-24,  1.060926626018048e-26,  1.674697183444168e-29,  1.940602265631055e+00,
 -3.326677397355362e-04, -1.347922880711609e-06, -4.611736313469569e-09, -1.373635446838976e-11, -3.498562417378744e-14, -6.956429235982705e-17, -6.517407837117433e-20,
  2.795678165397786e-22,  2.128905350770036e-24,  8.976911060712919e-27,  2.857955380145696e-29,  1.962747400668670e+00, -2.115889294388392e-04, -8.815332597345771e-07,
 -3.165722849937307e-09, -1.022216550443568e-11, -2.990151504060543e-14, -7.801059966649408e-17, -1.720151429568282e-19, -2.638618923170791e-22,  8.517274302707579e-26,
  2.921077231591111e-27,  1.570836672279063e-29,  1.979849757462407e+00, -1.156880233484143e-04, -4.922719690846483e-07, -1.832269341981458e-09, -6.261258672503010e-12,
 -1.999400680255112e-14, -5.992669531057696e-17, -1.677618682063329e-19, -4.314810657432605e-22, -9.793512060359761e-25, -1.743949783244507e-27, -1.138254316851398e-30,
  1.991776539025463e+00, -4.756665827885646e-05, -2.053676101468825e-07, -7.831245759056555e-10, -2.777053864514455e-12, -9.360103116457214e-15, -3.030295155403091e-17,
 -9.470284663779955e-20, -2.861719408721900e-22, -8.353221632029617e-25, -2.346556484377589e-27, -6.296348954586168e-30,  1.998436672159868e+00, -9.080314518403534e-06,
 -3.952085671759714e-08, -1.527163470998824e-10, -5.524273220695239e-13, -1.914987852374393e-15, -6.440504460742159e-18, -2.116795245595910e-20, -6.829896089583565e-23,
 -2.169785423268878e-25, -6.800677315098781e-28, -2.105700883869034e-30,  4.230646961826762e-04, -1.958313958072897e-06,  6.797284480949792e-09, -2.096692079085727e-11,
  6.061319109821228e-14, -1.681566271601065e-16,  4.533489660068565e-19, -1.196697803975904e-21,  3.107748377001865e-24, -7.966080839439718e-27,  2.020077260877141e-29,
 -5.076453495454412e-32,  3.806348041619178e-03, -1.759563911067778e-05,  6.090412481933821e-08, -1.869729877864251e-10,  5.366116416733877e-13, -1.473445049482232e-15,
  3.917474971857440e-18, -1.015470261573331e-20,  2.576871240158344e-23, -6.417599979667891e-26,  1.570721354549239e-28, -3.780520695828976e-31,  1.056632433893562e-02,
 -4.871470480969912e-05,  1.676746924591966e-07, -5.098291969331594e-10,  1.441731642986387e-12, -3.875413303350090e-15,  1.000574283525376e-17, -2.493529304130572e-20,
  6.006977231869005e-23, -1.397271169579247e-25,  3.125464935687841e-28, -6.668951688705007e-31,  2.068977504519708e-02, -9.500471461811794e-05,  3.242445992407778e-07,
 -9.715443320803758e-10,  2.685205674941627e-12, -6.978276753933093e-15,  1.716726071953610e-17, -3.995125929943192e-20,  8.724723841919994e-23, -1.753913226481676e-25,
  3.101785450313695e-28, -4.209984081688294e-31,  3.415677795026776e-02, -1.560004249624397e-04,  5.263719989143274e-07, -1.545928574292907e-09,  4.138230176446629e-12,
 -1.024039832041590e-14,  2.338380526082969e-17, -4.841896801122989e-20,  8.661246478057549e-23, -1.142677695854641e-25,  1.240533631412258e-29,  6.302143354743601e-31,
  5.094059389355905e-02, -2.310833402181828e-04,  7.685036540681286e-07, -2.199536856575206e-09,  5.642452435061179e-12, -1.303247459881249e-14,  2.649982685649461e-17,
 -4.397510674177674e-20,  4.256135275688923e-23,  7.099135546796385e-26, -5.845070416231766e-28,  2.237378816773898e-30,  7.100751573281018e-02, -3.194833963428876e-04,
  1.043863629546271e-06, -2.892904228578009e-09,  7.020736019415893e-12, -1.470818084035262e-14,  2.459947067449427e-17, -2.237193215124333e-20, -4.894141215896660e-23,
  3.574923038957687e-25, -1.300097454499088e-27,  3.575932491467155e-30,  9.431667963116983e-02, -4.202812113949435e-04,  1.344565057931165e-06, -3.582052638225607e-09,
  8.089734284449190e-12, -1.468167086103145e-14,  1.638303930415033e-17,  1.706767982648604e-20, -1.761649178804822e-22,  6.661005803693970e-25, -1.795027705718246e-27,
  3.519914558816401e-30,  1.208198388161866e-01, -5.324110020518926e-04,  1.661745440319794e-06, -4.220241741495946e-09,  8.673687582806214e-12, -1.250537304814395e-14,
  1.491302970358731e-18,  7.054531228570430e-20, -3.111440788142924e-22,  8.749743082682185e-25, -1.678963664117478e-27,  1.191976764689948e-30,  1.504611001019237e-01,
 -6.546642866399712e-04,  1.985725895668589e-06, -4.759928542961137e-09,  8.618751642640341e-12, -7.940892691160857e-15, -1.927298599935386e-17,  1.296847605661294e-19,
 -4.137167716896914e-22,  8.522933280866369e-25, -6.768067785008823e-28, -3.412735294956264e-30,  1.831766236663983e-01, -7.856945171456833e-04,  2.306194636050770e-06,
 -5.154891746570033e-09,  7.807066525270957e-12, -1.015609684925929e-15, -4.387047507040012e-17,  1.823800129540656e-19, -4.399028194284651e-22,  5.018267333668744e-25,
  1.199769450392462e-27, -9.025521751354993e-30,  2.188942868556340e-01, -9.240228050171733e-04,  2.612414702652787e-06, -5.362466631934004e-09,  6.169693810904850e-12,
  7.942161167203626e-15, -6.912915111461328e-17,  2.145954742072328e-19, -3.533897440471664e-22, -1.904499129156349e-25,  3.544787842503867e-27, -1.320780079025762e-29,
  2.575333131593454e-01, -1.068044927937607e-03,  2.893455625445758e-06, -5.345825143299523e-09,  3.697492287728520e-12,  1.829571546573304e-14, -9.104030818350445e-17,
  2.129482841745211e-19, -1.378781110702177e-22, -1.123718479107817e-24,  5.578704873081441e-27, -1.309337082485041e-29,  2.990038679901351e-01, -1.216039826623168e-03,
  3.138448143608082e-06, -5.076223903201064e-09,  4.489795891902154e-13,  2.912495312941155e-14, -1.052368164240033e-16,  1.677248223978060e-19,  1.926854284947541e-22,
 -2.078306496889954e-24,  6.331246208515934e-27, -6.645411549763776e-30,  3.432066235185515e-01, -1.366179821271158e-03,  3.336860418349155e-06, -4.535130439087528e-09,
 -3.445748987013920e-12,  3.928633089635233e-14, -1.076172581717606e-16,  7.582764571590173e-20,  5.891663057013640e-22, -2.750049341090896e-24,  4.967647594684770e-27,
  5.985557100118100e-30,  3.900322955927911e-01, -1.516542795455152e-03,  3.478793259585629e-06, -3.716125667235175e-09, -7.785889243191646e-12,  4.750734176314519e-14,
 -9.505165477657681e-17, -5.695272082957026e-20,  9.702718291824120e-22, -2.823476100513939e-24,  1.177077347561550e-27,  2.162009498508381e-29,  4.393611567281842e-01,
 -1.665126609555914e-03,  3.555290750308335e-06, -2.626469522108432e-09, -1.230627070024407e-11,  5.251150806271034e-14, -6.607883725938753e-17, -2.149614184180592e-19,
  1.234939007215361e-21, -2.071958630741281e-24, -4.510606221850241e-27,  3.433379352017305e-29,  4.910625303128137e-01, -1.809866014308119e-03,  3.558661270526056e-06,
 -1.288207786371311e-09, -1.668961278262003e-11,  5.316581726667064e-14, -2.148618972180776e-17, -3.735175345345355e-19,  1.283442814336790e-21, -4.604293612612622e-25,
 -1.063261445610402e-26,  3.717599556386323e-29,  5.449942725666785e-01, -1.948652335305638e-03,  3.482802289536253e-06,  2.613067345221978e-10, -2.058478888367427e-11,
  4.863828118845682e-14,  3.534569928254044e-17, -5.018526385208646e-19,  1.044101932344387e-21,  1.782581626715924e-24, -1.504350026747449e-26,  2.506248021517038e-29,
  6.010022504363162e-01, -2.079356188350050e-03,  3.323520419942475e-06,  1.969604565645270e-09, -2.363074331533958e-11,  3.854928662465491e-14,  9.844312615355037e-17,
 -5.680726794047951e-19,  5.000019734069703e-22,  4.157755359120846e-24, -1.552985192274809e-26, -2.098707386163893e-30,  6.589198255248778e-01, -2.199853459758120e-03,
  3.078836141415272e-06,  3.770118120479372e-09, -2.548515728865485e-11,  2.309720380384271e-14,  1.596657768579293e-16, -5.456075868699054e-19, -2.915947890715115e-22,
  5.976418672917071e-24, -1.066849531797817e-26, -3.749114240547381e-29,  7.185673563631487e-01, -2.308054740980562e-03,  2.749260370661706e-06,  5.584125165730241e-09,
 -2.585632992109779e-11,  3.137036113217868e-15,  2.095909180387659e-16, -4.201255634540853e-19, -1.194769448351715e-21,  6.531836059213660e-24, -6.585587487289401e-28,
 -6.811557248005220e-29,  7.797517338237724e-01, -2.401938338414998e-03,  2.338027782270282e-06,  7.323680515264056e-09, -2.453606576316692e-11, -1.980848065521625e-14,
  2.388147185974456e-16, -1.954761943515163e-19, -2.011179692043969e-21,  5.330049027199231e-24,  1.223446729753058e-26, -7.883394240125786e-29,  8.422659672580337e-01,
 -2.479586882036697e-03,  1.851269631236084e-06,  8.895550109616697e-09, -2.143070153182760e-11, -4.362221812763590e-14,  2.395426251444606e-16,  1.029826029673187e-19,
 -2.518553696132072e-21,  2.317446323141455e-24,  2.395369761821842e-26, -5.896297956080674e-29,  9.058888419604247e-01, -2.539227425246422e-03,  1.298107012378660e-06,
  1.020609501095145e-08, -1.658684767693117e-11, -6.575994467782775e-14,  2.072491011287146e-16,  4.291908811561948e-19, -2.526717700485456e-21, -1.979054879088563e-24,
  2.978088944982771e-26, -8.977247849614354e-30,  9.703846717817042e-01, -2.579274758323567e-03,  6.906443040411593e-07,  1.116696840326171e-08, -1.020807678570271e-11,
 -8.350981171529853e-14,  1.421090984456739e-16,  7.222778161484325e-19, -1.939342141733942e-21, -6.480038738749286e-24,  2.611717241989269e-26,  5.617953658740596e-29,
  1.035503174021684e+00, -2.598377445254586e-03,  4.384234344973150e-08,  1.170138817340769e-08, -2.658792302606925e-12, -9.432756605040645e-14,  4.986207075734483e-17,
  9.174660945003243e-19, -8.037794936338747e-22, -9.793346593651359e-24,  1.232595238227172e-26,  1.102168833327650e-28,  1.100979497000083e+00, -2.595465836546019e-03,
 -6.247479086368795e-07,  1.175063575928958e-08,  5.548004177159570e-12, -9.621416371867306e-14, -5.821158714416283e-17,  9.605466922815797e-19,  6.705538137645746e-22,
 -1.063882325122235e-23, -8.202215900692879e-27,  1.256599228796512e-28,  1.166534433737067e+00, -2.569801010010968e-03, -1.295407373390649e-06,  1.128031719675590e-08,
  1.378123900396881e-11, -8.808585866938505e-14, -1.664222330263037e-16,  8.230342491442086e-19,  2.140459926899123e-21, -8.344904585975445e-24, -2.852858126279412e-26,
  8.780340880223384e-29,  1.231874857725154e+00, -2.521023252899927e-03, -1.946837272448788e-06,  1.028581763573541e-08,  2.134101151942054e-11, -7.007394201499665e-14,
 -2.569440819823501e-16,  5.140169706357863e-19,  3.207524262735510e-21, -3.234126169523340e-24, -4.044620182283735e-26,  5.713741206297326e-30,  1.296694418528963e+00,
 -2.449198333490887e-03, -2.556916558979126e-06,  8.796303578671316e-09,  2.752456120529349e-11, -4.368632896576657e-14, -3.130023696611279e-16,  8.447560671385374e-20,
  3.533307653257434e-21,  3.297854880288201e-24, -3.796649865938123e-26, -8.714309192112542e-29,  1.360674535534804e+00, -2.354859437134372e-03, -3.103619855378514e-06,
  6.876599145387608e-09,  3.170403961962254e-11, -1.177039641189925e-14, -3.224562064284880e-16, -3.791029012997372e-19,  2.959356209980274e-21,  9.129498907801782e-24,
 -2.056674070280397e-26, -1.461893443556834e-28,  1.423485727161577e+00, -2.239042288229188e-03, -3.566073364041783e-06,  4.626307124899884e-09,  3.340808346103765e-11,
  2.176097790557298e-14, -2.810096967742033e-16, -7.725024795239620e-19,  1.588649885074620e-21,  1.214448680880294e-23,  5.585885526953878e-27, -1.387185595008994e-28,
  1.484789309776986e+00, -2.103310682497443e-03, -3.925709711977995e-06,  2.175684163381258e-09,  3.239645180415299e-11,  5.243977988517916e-14, -1.941686300029389e-16,
 -1.000055099127090e-18, -2.120330162040049e-22,  1.110599384695093e-23,  2.961911048495873e-26, -6.460674595344488e-29,  1.544239494976049e+00, -1.949769458991389e-03,
 -4.167464681763491e-06, -3.219728862150752e-10,  2.871528417385329e-11,  7.593845677392573e-14, -7.716650572289523e-17, -1.002819546636042e-18, -1.907719574265097e-21,
  6.293380999136759e-24,  4.080226987890386e-26,  3.922687537480577e-29,  1.601485905355341e+00, -1.781061901206107e-03, -4.280940868787899e-06, -2.701313927063895e-09,
  2.272059140482151e-11,  8.884512273218687e-14,  4.753940912527164e-17, -7.796557125014362e-19, -2.970507366329260e-21, -4.595486866726283e-25,  3.409151471744656e-26,
  1.170995965958010e-28,  1.656176517146910e+00, -1.600348727069522e-03, -4.261447726280205e-06, -4.798729271998187e-09,  1.506003935129319e-11,  8.936806162937015e-14,
  1.549828443322497e-16, -3.925536319645702e-19, -3.076208691064873e-21, -6.458767506996114e-24,  1.324088495609698e-26,  1.274397371214757e-28,  1.707961022934535e+00,
 -1.411266260411782e-03, -4.110816989271065e-06, -6.467883188747714e-09,  6.608232483014268e-12,  7.780033227011601e-14,  2.236671209456869e-16,  4.846966068564572e-20,
 -2.240858561186949e-21, -9.342162921644580e-24, -1.080561207334749e-26,  6.961791485287055e-29,  1.756494589301519e+00, -1.217862111334689e-03, -3.837890150169950e-06,
 -7.595441634549367e-09, -1.641704282353769e-12,  5.659645442852697e-14,  2.412507750935041e-16,  4.186028422906656e-19, -8.268918832193244e-22, -8.207803502810128e-24,
 -2.589019762920757e-26, -1.529244468815823e-29,  1.801441963138733e+00, -1.024507746284856e-03, -3.458583357699423e-06, -8.115083309753052e-09, -8.718399457478259e-12,
  2.998099564126273e-14,  2.081580185595068e-16,  6.195106194167989e-19,  6.008414939947256e-22, -4.052556629938583e-24, -2.563824487742752e-26, -7.292636075959756e-29,
  1.842481857368934e+00, -8.357886832198912e-04, -2.995456906877478e-06, -8.017733431612473e-09, -1.382374977582995e-11,  3.116708815203486e-15,  1.376939750476232e-16,
  6.133897306207145e-19,  1.516762899608237e-21,  7.906831383229643e-25, -1.295273618152990e-26, -7.360530854730538e-29,  1.879311523362355e+00, -6.563746424425240e-04,
 -2.476751982634581e-06, -7.356115229123775e-09, -1.646882283784835e-11, -1.901506795094862e-14,  5.221621805740553e-17,  4.352431738110264e-19,  1.663260795704271e-21,
  3.955071435630668e-24,  2.526079207000959e-27, -3.068132835907471e-29,  1.911651395146322e+00, -4.908737104625067e-04, -1.934905005119935e-06, -6.242226687525493e-09,
 -1.656584819940258e-11, -3.276284662470961e-14, -2.374152897426997e-17,  1.764572654419035e-19,  1.149390511842535e-21,  4.326376401400612e-24,  1.131680377454467e-26,
  1.527069815095811e-29,  1.939249672068444e+00, -3.436762761831917e-04, -1.404605792503231e-06, -4.837206998006781e-09, -1.445290466254756e-11, -3.667598140794380e-14,
 -7.125188991414057e-17, -5.492983883883030e-20,  3.629837591030862e-22,  2.514113993057594e-24,  1.030819492529510e-26,  3.196660938845096e-29,  1.961886695837746e+00,
 -2.187959767619383e-04, -9.205233308546355e-07, -3.334165120942229e-09, -1.083931339549342e-11, -3.183251697135762e-14, -8.294460397473309e-17, -1.803857080541609e-19,
 -2.585177730617383e-22,  2.167419343758288e-25,  3.680655473755233e-27,  1.890498927699413e-29,  1.979378987319997e+00, -1.197158819984993e-04, -5.148737356281520e-07,
 -1.935728291825964e-09, -6.675909902865501e-12, -2.149020877400899e-14, -6.482272789936311e-17, -1.821469213381657e-19, -4.680041120312752e-22, -1.049964363338830e-24,
 -1.782758440870699e-27, -5.952445223579323e-31,  1.991582925907643e+00, -4.924795898696239e-05, -2.150380104054849e-07, -8.290954898359622e-10, -2.971748889567428e-12,
 -1.012025735545738e-14, -3.308748941334993e-17, -1.043601653570203e-19, -3.180019240528957e-22, -9.349569881307684e-25, -2.641092518129073e-27, -7.107649893197971e-30,
  1.998399706745605e+00, -9.403964983401052e-06, -4.140777756391027e-08, -1.618701867836681e-10, -5.923221168009242e-13, -2.076926770368518e-15, -7.065017859883451e-18,
 -2.348393579790252e-20, -7.662302296756576e-23, -2.461291109369507e-25, -7.799013079718207e-28, -2.440938250009531e-30,  4.153386263593493e-04, -1.904925859448334e-06,
  6.551391198727937e-09, -2.002343482030489e-11,  5.735620516933690e-14, -1.576673643343229e-16,  4.211916734004114e-19, -1.101686632828870e-21,  2.834991577991796e-24,
 -7.200991216748297e-27,  1.809522546021624e-29, -4.506267456505516e-32,  3.736925944373821e-03, -1.711723706409115e-05,  5.871100749701602e-08, -1.786179393634840e-10,
  5.080603764736598e-13, -1.382746542761680e-15,  3.644348821713083e-18, -9.365888393618881e-21,  2.356757178072564e-23, -5.821353722686293e-26,  1.413455818729146e-28,
 -3.375952136019227e-31,  1.037411011372119e-02, -4.739739272749388e-05,  1.616926321858652e-07, -4.873687428200346e-10,  1.366569305125466e-12, -3.643441084487224e-15,
  9.333726560541520e-18, -2.309118657148344e-20,  5.525772645549844e-23, -1.277936887115940e-25,  2.845705764196998e-28, -6.056984125353528e-31,  2.031487128025867e-02,
 -9.245667203959308e-05,  3.128393128267495e-07, -9.296755541878762e-10,  2.549671279007325e-12, -6.579376383274689e-15,  1.608677986713189e-17, -3.725801459514056e-20,
  8.115203539546797e-23, -1.633523701376246e-25,  2.918331066930826e-28, -4.122266660455683e-31,  3.354108228063440e-02, -1.518625433136467e-04,  5.082114649840372e-07,
 -1.481325318081517e-09,  3.938926111582284e-12, -9.695146373017005e-15,  2.206625910835237e-17, -4.571303982908787e-20,  8.251406695204198e-23, -1.132575680784123e-25,
  3.714258295653346e-29,  4.980515974985122e-31,  5.002839156721525e-02, -2.250393735946130e-04,  7.426423965878732e-07, -2.111308673621266e-09,  5.388063970823332e-12,
 -1.241109828347590e-14,  2.528794447606886e-17, -4.257657773196102e-20,  4.471909390374198e-23,  4.948960823422584e-26, -4.927470208138916e-28,  1.939823110007927e-30,
  6.974606677153866e-02, -3.112694592183899e-04,  1.009813165380730e-06, -2.782893899507950e-09,  6.732424670591019e-12, -1.412547594522592e-14,  2.395299576346825e-17,
 -2.374187719503772e-20, -3.697081580517767e-23,  3.085284740240716e-25, -1.150685509271230e-27,  3.220122485225135e-30,  9.265679866772812e-02, -4.096944512269851e-04,
  1.302347420479940e-06, -3.454944442226252e-09,  7.800068306233157e-12, -1.428335852047863e-14,  1.678552033426335e-17,  1.180051876898448e-20, -1.534408413542196e-22,
  5.973473225507802e-25, -1.643901167341187e-27,  3.346234763378498e-30,  1.187164653023069e-01, -5.193172698821829e-04,  1.611926967969945e-06, -4.083461003481882e-09,
  8.424092338492610e-12, -1.244697500453356e-14,  3.331822739756863e-18,  6.107983355983723e-20, -2.808403727578656e-22,  8.089561630382132e-25, -1.619849800558312e-27,
  1.479730804851892e-30,  1.478738561086140e-01, -6.390046239716542e-04,  1.929428834221837e-06, -4.623322983437870e-09,  8.455594785278677e-12, -8.361338118523572e-15,
 -1.582258407618454e-17,  1.169312428253018e-19, -3.835551800840759e-22,  8.224925908126340e-25, -8.067047017764413e-28, -2.516526849284394e-30,  1.800703559356401e-01,
 -7.674902732459105e-04,  2.245084562542726e-06, -5.030196678958492e-09,  7.776630906502253e-12, -2.008795085727322e-15, -3.895813362759983e-17,  1.686006848664382e-19,
 -4.210652158771121e-22,  5.422809748576199e-25,  8.327401373397098e-28, -7.680296666212274e-30,  2.152395891076968e-01, -9.033791961410955e-04,  2.548662349026817e-06,
 -5.262568909698782e-09,  6.312426112959972e-12,  6.353882378000625e-15, -6.327963852643268e-17,  2.032035545274436e-19, -3.578303677594143e-22, -5.991006184612554e-26,
  2.991365934669485e-27, -1.195039771202354e-29,  2.533070239104335e-01, -1.045152849774796e-03,  2.829672379120335e-06, -5.283854650949160e-09,  4.042037160020012e-12,
  1.618176425815485e-14, -8.514530663289334e-17,  2.079308690229348e-19, -1.744532949514007e-22, -9.119955420345510e-25,  5.010202320135917e-27, -1.271525301812920e-29,
  2.941895382905847e-01, -1.191175734712872e-03,  3.077595341150121e-06, -5.064515857674596e-09,  1.006605529590988e-12,  2.665625442615285e-14, -1.004651010779783e-16,
  1.727419331023567e-19,  1.223508453807352e-22, -1.831291692712143e-24,  6.010662928686962e-27, -7.858862685487122e-30,  3.377949480846653e-01, -1.339703502621941e-03,
  3.282133537642612e-06, -4.584116183790965e-09, -2.685667906762088e-12,  3.673103511974686e-14, -1.052447447242694e-16,  9.313574900192424e-20,  4.937963110048869e-22,
 -2.546991284306516e-24,  5.163485426455569e-27,  2.996210272934827e-30,  3.840214997819790e-01, -1.488892869768926e-03,  3.433483258226714e-06, -3.833223148069120e-09,
 -6.858666238628932e-12,  4.521038088673373e-14, -9.622685463003618e-17, -2.751947002254871e-20,  8.696923265984275e-22, -2.758584304268923e-24,  2.037922510225105e-27,
  1.755825002797340e-29,  4.327573307091897e-01, -1.636813622148304e-03,  3.522626087133998e-06, -2.815056145812906e-09, -1.127236421065993e-11,  5.085778437679461e-14,
 -7.155594918820340e-17, -1.766687462571474e-19,  1.157455651145109e-21, -2.223191540140111e-24, -3.076669836681253e-27,  3.081685183985424e-29,  4.838799006296005e-01,
 -1.781463017079638e-03,  3.541635563428774e-06, -1.546766550737563e-09, -1.563227635103449e-11,  5.252926957956878e-14, -3.137275689501996e-17, -3.327914676733233e-19,
  1.259604255232951e-21, -8.532316961159948e-25, -9.014170439913513e-27,  3.626306991133452e-29,  5.372554001146612e-01, -1.920782899122472e-03,  3.483994068294405e-06,
 -6.022638082755019e-11, -1.960465874500863e-11,  4.932178615556143e-14,  2.177041521864189e-17, -4.675285241717213e-19,  1.097719001140234e-21,  1.203943644663735e-24,
 -1.386463036755058e-26,  2.832741208671922e-29,  5.927381427036473e-01, -2.052679852131327e-03,  3.344912967030261e-06,  1.597803554501608e-09, -2.283740970609508e-11,
  4.072299125449160e-14,  8.278273865642990e-17, -5.497976824237335e-19,  6.384982961297727e-22,  3.536992224091208e-24, -1.545387046122256e-26,  5.374000208294631e-30,
  6.501699498547440e-01, -2.175048700485215e-03,  3.121646888111552e-06,  3.366254150004747e-09, -2.498613548082743e-11,  2.674499967072338e-14,  1.442898692882004e-16,
 -5.515816210469064e-19, -8.449684941992858e-23,  5.519509902156531e-24, -1.210758015554152e-26, -2.797180141057558e-29,  7.093795400383378e-01, -2.285799646405266e-03,
  2.813790609624567e-06,  5.171195044785272e-09, -2.574426163024849e-11,  8.021952620905873e-15,  1.973274262667915e-16, -4.546066676740725e-19, -9.608004151177974e-22,
  6.447696383984446e-24, -3.493584570324854e-27, -6.059171398913589e-29,  7.701819360553391e-01, -2.382889281397405e-03,  2.423544415901651e-06,  6.928243531071350e-09,
 -2.487540000461719e-11, -1.414969932827463e-14,  2.324698569980782e-16, -2.566761638287252e-19, -1.811323804755716e-21,  5.750222729420082e-24,  8.782230026030873e-27,
 -7.773785102598044e-29,  8.323779077915483e-01, -2.464355632004524e-03,  1.955931108655155e-06,  8.545992511388701e-09, -2.224546881574700e-11, -3.784761648928326e-14,
  2.413116562575575e-16,  2.390342931117995e-20, -2.418527196142778e-21,  3.221216300464366e-24,  2.117750261867573e-26, -6.682897997696053e-29,  8.957534711359612e-01,
 -2.528357286389121e-03,  1.418945299756539e-06,  9.930458030556446e-09, -1.785138085009519e-11, -6.065095236169563e-14,  2.181253989162871e-16,  3.474248356499962e-19,
 -2.576659014946937e-21, -8.003554736690836e-25,  2.904178758343339e-26, -2.438795152170130e-29,  9.600794676611757e-01, -2.573216491702117e-03,  8.236134517802662e-07,
  1.099046966231054e-08, -1.184256584079421e-11, -7.986372889676680e-14,  1.614304460860862e-16,  6.566925283340560e-19, -2.153268633311343e-21, -5.390888691127003e-24,
  2.821578419218236e-26,  3.908959956778753e-29,  1.025111253814238e+00, -2.597465905978503e-03,  1.839417356235830e-07,  1.164382878398801e-08, -4.531312303813829e-12,
 -9.282583634310263e-14,  7.513875914897154e-17,  8.862086590807519e-19, -1.146322061173396e-21, -9.206163117064993e-24,  1.695737177479454e-26,  9.980979807123477e-29,
  1.090588532672734e+00, -2.599898426934669e-03, -4.832713932773728e-07,  1.182394283549533e-08,  3.611939663967670e-12, -9.728642928339013e-14, -3.107383739183007e-17,
  9.758240222447101e-19,  2.829943791026119e-22, -1.085514557376646e-23, -2.591622057054048e-27,  1.287169936514540e-28,  1.156235365596899e+00, -2.579619200536622e-03,
 -1.158779385983363e-06,  1.148651423974553e-08,  1.198148593125687e-11, -9.179599811716616e-14, -1.424650354898496e-16,  8.865099387776226e-19,  1.820482463470905e-21,
 -9.403478259649810e-24, -2.427359129515019e-26,  1.051621845154827e-28,  1.221760405091144e+00, -2.536098535741954e-03, -1.821406043977925e-06,  1.061573203486391e-08,
  1.987909133503720e-11, -7.605641059602799e-14, -2.411343602194084e-16,  6.144835684417005e-19,  3.062100662022785e-21, -4.839731389042894e-24, -3.965459172141670e-26,
  3.034014952273353e-29,  1.286857393527678e+00, -2.469224025760341e-03, -2.448748710504910e-06,  9.229299625602662e-09,  2.657597210515591e-11, -5.115712655231062e-14,
 -3.090384143909339e-16,  1.991407372366700e-19,  3.623819855670791e-21,  1.707984646791282e-24, -4.138478605599812e-26, -6.762318131242117e-29,  1.351205974637416e+00,
 -2.379349716359620e-03, -3.018066217736422e-06,  7.381556620277709e-09,  3.139043896791799e-11, -1.962572521294352e-14, -3.316970919646265e-16, -2.793162387156546e-19,
  3.271664800268196e-21,  8.178787200190355e-24, -2.694505736954362e-26, -1.429181658915708e-28,  1.414472865303447e+00, -2.267339694740927e-03, -3.507337347104489e-06,
  5.163944534410696e-09,  3.377414006390257e-11,  1.476333412273446e-14, -3.018620882429090e-16, -7.146395688919839e-19,  2.028357723005171e-21,  1.224099828076176e-23,
 -8.749865558175445e-28, -1.544480796744237e-28,  1.476313433586798e+00, -2.134603037502371e-03, -3.896457678593944e-06,  2.702155031627515e-09,  3.339637644020074e-11,
  4.744332499920019e-14, -2.222034621451801e-16, -1.000220461169733e-18,  2.083537952739364e-22,  1.222624254921301e-23,  2.620207037973539e-26, -9.085165990877759e-29,
  1.536373724413204e+00, -1.983116705861932e-03, -4.168521922065263e-06,  1.495115203684201e-10,  3.021322423137652e-11,  7.374283563680846e-14, -1.060637880421944e-16,
 -1.059923570152975e-18, -1.651418484711032e-21,  7.953977374015200e-24,  4.207124436285506e-26,  1.776872435318816e-29,  1.594292966299972e+00, -1.815432775814342e-03,
 -4.311116641296183e-06, -2.323514869233226e-09,  2.450707951585987e-11,  8.971335724892397e-14,  2.437770932721784e-17, -8.747034339025672e-19, -2.961271500275959e-21,
  1.006219729707398e-24,  3.916573956695260e-26,  1.128098454680739e-28,  1.649706580335366e+00, -1.634666414421024e-03, -4.317527086897041e-06, -4.543271594837568e-09,
  1.688364776919958e-11,  9.294441738879145e-14,  1.425790398448354e-16, -4.945991193800446e-19, -3.297801122448621e-21, -5.812790427007203e-24,  1.915892644318752e-26,
  1.412872185261387e-28,  1.702249695957799e+00, -1.444461337126677e-03, -4.187744903327336e-06, -6.349411442288502e-09,  8.217985960402209e-12,  8.317621244905938e-14,
  2.239692487453029e-16, -2.869596807193057e-20, -2.584163495491001e-21, -9.707083694166451e-24, -7.287483549611096e-27,  9.061129785000799e-29,  1.751561156845816e+00,
 -1.248930172188030e-03, -3.929154669941025e-06, -7.612334951609874e-09, -4.509422541688038e-13,  6.252385334589711e-14,  2.525553549396157e-16,  3.872136392696515e-19,
 -1.141142087741048e-21, -9.253106348221638e-24, -2.627576032224262e-26, -1.668904261562604e-30,  1.797287974788013e+00, -1.052568261185910e-03, -3.556780640842888e-06,
 -8.249503368681557e-09, -8.067405939904493e-12,  3.518697426112847e-14,  2.257501128396379e-16,  6.361990442033584e-19,  4.357126892589334e-22, -5.142664312056794e-24,
 -2.887352109420228e-26, -7.379328590236730e-29,  1.839090160677235e+00, -8.601409438062336e-04, -3.092994133194446e-06, -8.238229263226628e-09, -1.372694943426611e-11,
  6.632970346408256e-15,  1.555519259347829e-16,  6.622750601624160e-19,  1.535092545304006e-21,  2.046675254024767e-25, -1.642646139709142e-26, -8.436792972182691e-29,
  1.876645831334555e+00, -6.765462597939213e-04, -2.566618690174327e-06, -7.622586462041877e-09, -1.683557352939584e-11, -1.760949046985861e-14,  6.516969553253096e-17,
  4.907623344892396e-19,  1.807111297078919e-21,  4.026289926929564e-24,  9.618332996022882e-28, -4.070870073656858e-29,  1.909656460987976e+00, -5.066571332871925e-04,
 -2.011423765786279e-06, -6.512551516607798e-09, -1.722638079179015e-11, -3.326905041483075e-14, -1.826175393504323e-17,  2.158183974917661e-19,  1.313444356619722e-21,
  4.791841814288550e-24,  1.193855676863562e-26,  1.280740447737673e-29,  1.937852120019122e+00, -3.551492960028243e-04, -1.464064263812223e-06, -5.074415040315563e-09,
 -1.520364217625296e-11, -3.840308409856590e-14, -7.261311869104091e-17, -4.178383654352373e-20,  4.612621679062959e-22,  2.955610391484559e-24,  1.179258750064914e-26,
  3.553019288179692e-29,  1.960996525933871e+00, -2.263232007245504e-04, -9.615952509435748e-07, -3.512797231736565e-09, -1.149628435141316e-11, -3.388472359789047e-14,
 -8.810983444041896e-17, -1.885033288783481e-19, -2.478549109802678e-22,  3.816686084977443e-25,  4.593088131809786e-27,  2.266972710443721e-29,  1.978891736089565e+00,
 -1.239296359120555e-04, -5.387578246420169e-07, -2.046067577450125e-09, -7.121693538324221e-12, -2.310888333115343e-14, -7.013828830766987e-17, -1.977416345898085e-19,
 -5.070908934441582e-22, -1.121593917304448e-24, -1.793242262365053e-27,  1.576485080751805e-31,  1.991382429290479e+00, -5.100888363754266e-05, -2.252792660736270e-07,
 -8.783068739343869e-10, -3.182337800490007e-12, -1.095060385669808e-14, -3.615724787716231e-17, -1.150957785809103e-19, -3.536396957689902e-22, -1.047116549530271e-24,
 -2.973538998356811e-27, -8.021344913015050e-30,  1.998361415827406e+00, -9.743161302407805e-06, -4.340848396592814e-08, -1.716890903778937e-10, -6.356109855357757e-13,
 -2.254663278104826e-15, -7.758271401949684e-18, -2.608388038408677e-20, -8.607208787823503e-23, -2.795843474542917e-25, -8.957221649897974e-28, -2.834012066331926e-30,
  4.078222451129390e-04, -1.853460489979468e-06,  6.316513867014015e-09, -1.913042338858975e-11,  5.430149724072770e-14, -1.479189141854630e-16,  3.915765260960999e-19,
 -1.014978764303630e-21,  2.588320568689998e-24, -6.515313743299559e-27,  1.622519052062746e-29, -4.004404524180266e-32,  3.669382989636538e-03, -1.665598654411842e-05,
  5.661546856181891e-08, -1.707055482103509e-10,  4.812592798541503e-13, -1.298345787311092e-15,  3.392354781800380e-18, -8.644194304078732e-21,  2.157017296459393e-23,
 -5.284592486598693e-26,  1.272962840497946e-28, -3.017172961558657e-31,  1.018707110246119e-02, -4.612687912284342e-05,  1.559730320877507e-07, -4.660746296190387e-10,
  1.295889221898600e-12, -3.426994647440914e-15,  8.711252544363997e-18, -2.139440272297700e-20,  5.085577493761239e-23, -1.169271218972813e-25,  2.591627900398856e-28,
 -5.500809001897047e-31,  1.994998033182166e-02, -8.999789831909687e-05,  3.019236992248281e-07, -8.899128862698126e-10,  2.421861571134442e-12, -6.205524267687309e-15,
  1.507904336527440e-17, -3.475302275596518e-20,  7.547712903795370e-23, -1.520384251861155e-25,  2.739531857632150e-28, -4.000161565846875e-31,  3.294165240344682e-02,
 -1.478668983729561e-04,  4.908073913087729e-07, -1.419825379182249e-09,  3.750216935210157e-12, -9.180621121058110e-15,  2.082264962758807e-17, -4.313749850447864e-20,
  7.846850626928535e-23, -1.113675822383409e-25,  5.655154273811877e-29,  3.874516818066058e-31,  4.913995793613516e-02, -2.191981303374741e-04,  7.178158610365723e-07,
 -2.027052852733847e-09,  5.145815390363705e-12, -1.181833012765974e-14,  2.411607611389042e-17, -4.112070257411414e-20,  4.616578401917130e-23,  3.140732934256746e-26,
 -4.132709344368377e-28,  1.678340318535797e-30,  6.851693700257269e-02, -3.033227228519351e-04,  9.770555290952585e-07, -2.677404174522730e-09,  6.455609375597412e-12,
 -1.355870505206525e-14,  2.327326827481910e-17, -2.475584299282062e-20, -2.665903907858907e-23,  2.652362041015567e-25, -1.016317283002394e-27,  2.892062344530644e-30,
  9.103859881255240e-02, -3.994394091457731e-04,  1.261627537899509e-06, -3.332406695762519e-09,  7.518453639467441e-12, -1.387707647673005e-14,  1.705033737825782e-17,
  7.222077712609309e-21, -1.330849607766639e-22,  5.344811230111603e-25, -1.500788227621212e-27,  3.156951621321129e-30,  1.166646799211761e-01, -5.066155878018354e-04,
  1.563725949408344e-06, -3.950662133819958e-09,  8.176085869148230e-12, -1.234747748823627e-14,  4.920531264204866e-18,  5.254652651906780e-20, -2.528679457786275e-22,
  7.455297625157552e-25, -1.549991142733626e-27,  1.683048146375611e-30,  1.453483603315582e-01, -6.237888257171593e-04,  1.874755113184524e-06, -4.489390825040990e-09,
  8.284828750181794e-12, -8.703151042658820e-15, -1.271593625395157e-17,  1.051248025126548e-19, -3.545508319088082e-22,  7.882415936093419e-25, -9.003534976966617e-28,
 -1.762261062114726e-30,  1.770359368825040e-01, -7.497689343181157e-04,  2.185467272918542e-06, -4.906141215155581e-09,  7.727479647535353e-12, -2.888644782175551e-15,
 -3.442297472910456e-17,  1.554447416312055e-19, -4.010216229002125e-22,  5.691975838070967e-25,  5.218970796132966e-28, -6.471054861913658e-30,  2.116664534015208e-01,
 -8.832407745453380e-04,  2.486121446516105e-06, -5.160634076158369e-09,  6.424770820270785e-12,  4.902152340808095e-15, -5.775041244232266e-17,  1.917405612814645e-19,
 -3.579567441979576e-22,  4.959280865146146e-26,  2.492731524299116e-27, -1.072134607450101e-29,  2.491712872801205e-01, -1.022767972446260e-03,  2.766664484567498e-06,
 -5.216702035809893e-09,  4.345705774834766e-12,  1.420748186714329e-14, -7.940606362996217e-17,  2.018606473993921e-19, -2.038112680813239e-22, -7.226260886786660e-25,
  4.462270570051393e-27, -1.216677640595626e-29,  2.894736924128799e-01, -1.166797755273574e-03,  3.016934958263055e-06, -5.044274523285880e-09,  1.516012806541444e-12,
  2.430351643630480e-14, -9.558309789636491e-17,  1.756480453868030e-19,  6.066617535485452e-23, -1.598051644987665e-24,  5.645283668117193e-27, -8.691229618835407e-30,
  3.324882988591448e-01, -1.313667147455224e-03,  3.226890119745089e-06, -4.621346226121358e-09, -1.976085837471522e-12,  3.423815713304690e-14, -1.024292218616964e-16,
  1.075102369661999e-19,  4.058469977164238e-22, -2.338589337099017e-24,  5.238284366463258e-27,  4.793456648894506e-31,  3.781205701659212e-01, -1.461610796067966e-03,
  3.386855580297939e-06, -3.935853833339740e-09, -5.977599614578603e-12,  4.289474347823294e-14, -9.662258650109409e-17, -1.261084092860293e-21,  7.720264884824174e-22,
 -2.662742072734898e-24,  2.726933243772137e-27,  1.381656462502953e-29,  4.262662200662812e-01, -1.608770725539733e-03,  3.487796525889056e-06, -2.987371644182853e-09,
 -1.027276132181584e-11,  4.908519152023961e-14, -7.599632015493221e-17, -1.409318869651895e-19,  1.075522662074141e-21, -2.320202814885561e-24, -1.800312019577103e-27,
  2.719143440930669e-29,  4.768105912781598e-01, -1.753208349782509e-03,  3.521608194629472e-06, -1.788522285913626e-09, -1.458995178191443e-11,  5.166902941688434e-14,
 -4.013171115703960e-17, -2.930420860516055e-19,  1.222778443775948e-21, -1.182313420311855e-24, -7.451583961152559e-27,  3.466352031071574e-29,  5.296280004169167e-01,
 -1.892919094777827e-03,  3.481421936833654e-06, -3.659854253239026e-10, -1.861403780656103e-11,  4.969119217101562e-14,  9.177161625989302e-18, -4.318125977589816e-19,
  1.131385395823012e-21,  6.749930190411782e-25, -1.256737159788249e-26,  3.046144079589132e-29,  5.845810546485602e-01, -2.025850003025439e-03,  3.361921431002872e-06,
  1.239023435425210e-09, -2.200431654883852e-11,  4.252746717356249e-14,  6.769274566981998e-17, -5.274471522101422e-19,  7.547781621739924e-22,  2.925521666063616e-24,
 -1.507329822720468e-26,  1.173875093967289e-29,  6.415199476987573e-01, -2.149920699561234e-03,  3.159661515729730e-06,  2.970938082012366e-09, -2.441785771821929e-11,
  3.002249977096050e-14,  1.288369213565654e-16, -5.512019971819481e-19,  1.052162259057409e-22,  5.013306877468411e-24, -1.313631405524319e-26, -1.887810686274631e-29,
  7.002817452456530e-01, -2.263048092761888e-03,  2.873379617075540e-06,  4.760823298459430e-09, -2.553751209267586e-11,  1.260180214208883e-14,  1.842026741282352e-16,
 -4.816704504184319e-19, -7.318194823306168e-22,  6.257031221233645e-24, -5.979170173117705e-27, -5.229007426861376e-29,  7.606896726088683e-01, -2.363175156040162e-03,
  2.504286936070247e-06,  6.528273760876000e-09, -2.510321639708708e-11, -8.663022163750356e-15,  2.245030163854221e-16, -3.112652454233752e-19, -1.598810140666080e-21,
  6.033873015559734e-24,  5.422695310327991e-27, -7.466554295870930e-29,  8.225524210411688e-01, -2.448304081745743e-03,  2.056323493905184e-06,  8.184324133747647e-09,
 -2.294449685697260e-11, -3.205673772996248e-14,  2.409160170705199e-16, -5.147639131675918e-20, -2.288040745423934e-21,  4.007731080147607e-24,  1.810867276572514e-26,
 -7.226153570894783e-29,  8.856634928558834e-01, -2.516534007906944e-03,  1.536357963927837e-06,  9.635419359691847e-09, -1.901131007862892e-11, -5.530854390585286e-14,
  2.266962046065396e-16,  2.647325926804583e-19, -2.584858741798550e-21,  3.356611624016069e-25,  2.765844479944435e-26, -3.819459466710973e-29,  9.498006100794578e-01,
 -2.566103382716761e-03,  9.543101899682194e-07,  1.078842702694644e-08, -1.339964870564079e-11, -7.577670717767488e-14,  1.788255680124434e-16,  5.849036625661669e-19,
 -2.326657580674081e-21, -4.233004027381374e-24,  2.955082058435088e-26,  2.157618862989879e-29,  1.014725216263887e+00, -2.595436841245956e-03,  3.231717502484784e-07,
  1.155658199251111e-08, -6.367808511493947e-12, -9.072918645937251e-14,  9.939020758894548e-17,  8.443628869133474e-19, -1.464509500141048e-21, -8.443724563162727e-24,
  2.106870897987503e-26,  8.665871543903066e-29,  1.080182106434105e+00, -2.603196214469645e-03, -3.411016479255525e-07,  1.186613682477555e-08,  1.660970280817451e-12,
 -9.770366272804670e-14, -3.682809774882043e-18,  9.786183558823161e-19, -1.082912142939810e-22, -1.084551876805507e-23,  3.066345661962016e-27,  1.278095162049036e-28,
  1.145899225715122e+00, -2.588334964671321e-03, -1.019852156251956e-06,  1.166335343447869e-08,  1.011341763509295e-11, -9.491102803275917e-14, -1.168793549419809e-16,
  9.391709042296049e-19,  1.465636441625423e-21, -1.027741753936212e-23, -1.931885045159720e-26,  1.195037814823028e-28,  1.211587682725724e+00, -2.550154939462051e-03,
 -1.692160066115145e-06,  1.092132007824639e-08,  1.830154102714821e-11, -8.162626806740847e-14, -2.225853571551775e-16,  7.093800179180802e-19,  2.859707027932687e-21,
 -6.391941887059833e-24, -3.777666781553604e-26,  5.493818113028782e-29,  1.276942028971409e+00, -2.488363860764572e-03, -2.335480885008442e-06,  9.645929185129825e-09,
  2.547917992684203e-11, -5.849398822253179e-14, -3.018320684761318e-16,  3.157618473137343e-19,  3.654852173466521e-21, -3.907539258316828e-28, -4.386682897654244e-26,
 -4.468373060105790e-29,  1.341640859721841e+00, -2.403131425837904e-03, -2.926488416965079e-06,  7.880228551881984e-09,  3.091774593965459e-11, -2.766821101671236e-14,
 -3.380095309515872e-16, -1.701321822409059e-19,  3.545203480874286e-21,  6.977298119849265e-24, -3.306862900319585e-26, -1.345728838952929e-28,  1.405347794582308e+00,
 -2.295141317764344e-03, -3.442119244770542e-06,  5.706292614527506e-09,  3.399537867452338e-11,  7.286266260794178e-15, -3.208971699495721e-16, -6.427015911759774e-19,
  2.466730152311064e-21,  1.206621299678149e-23, -7.953001159200818e-27, -1.666152712167773e-28,  1.467712896394569e+00, -2.165635841491067e-03, -3.860795418042677e-06,
  3.243788730089626e-09,  3.428965125447655e-11,  4.177553496353483e-14, -2.500487295636898e-16, -9.863168321904474e-19,  6.663292576162044e-22,  1.318653730951619e-23,
  2.161876643717165e-26, -1.174574534044429e-28,  1.528374584350344e+00, -2.016449375548469e-03, -4.163779119858282e-06,  6.445734601883051e-10,  3.166019203175767e-11,
  7.083547509812172e-14, -1.364361141932192e-16, -1.107861578130626e-18, -1.334660824378046e-21,  9.645242704830328e-24,  4.230628947363053e-26, -7.726266419059514e-30,
  1.586962090334037e+00, -1.850026435204098e-03, -4.336586849521622e-06, -1.917024190575177e-09,  2.630515832561802e-11,  8.999385848023154e-14, -1.432979511990657e-18,
 -9.685726018909620e-19, -2.895672352677517e-21,  2.669818461592511e-24,  4.394815034112609e-26,  1.037325466989430e-28,  1.643098495626724e+00, -1.669419973341372e-03,
 -4.370363583667177e-06, -4.258081126227495e-09,  1.877557090615834e-11,  9.618801642864592e-14,  1.272225168037833e-16, -6.033166349034579e-19, -3.491735517428879e-21,
 -4.918464367286907e-24,  2.564285571853650e-26,  1.530077539287111e-28,  1.696404367460349e+00, -1.478265704487088e-03, -4.263093072796479e-06, -6.204323862484196e-09,
  9.935148076883844e-12,  8.853216353093459e-14,  2.219551676401253e-16, -1.170285500189050e-19, -2.937845024550031e-21, -9.912274356655832e-24, -2.806741789771804e-27,
  1.132994040335868e-28,  1.746501991099742e+00, -1.280728827087637e-03, -4.020503637394973e-06, -7.609213270935705e-09,  8.610036402648342e-13,  6.871084423140675e-14,
  2.628345817008055e-16,  3.451645925166907e-19, -1.493146983098939e-21, -1.030081119242633e-23, -2.598418630303965e-26,  1.553854427630228e-29,  1.793020163265836e+00,
 -1.081420621381834e-03, -3.656524958653704e-06, -8.372651487000742e-09, -7.308036141017141e-12,  4.082013619323071e-14,  2.437294273304041e-16,  6.469504322725323e-19,
  2.290072480968742e-22, -6.362296792220767e-24, -3.209731296742479e-26, -7.230126514757669e-29,  1.835599477634297e+00, -8.852840541750118e-04, -3.193165619219487e-06,
 -8.456589934441262e-09, -1.355542682567915e-11,  1.059429397455643e-14,  1.747835096185660e-16,  7.113816426031634e-19,  1.529709327271546e-21, -5.298841517549536e-25,
 -2.038188122507091e-26, -9.545037234425993e-29,  1.873897994580340e+00, -6.974496989321229e-04, -2.659717276712103e-06, -7.894683384366462e-09, -1.717097522258290e-11,
 -1.587385301264135e-14,  7.974244871775654e-17,  5.509127627939784e-19,  1.952288301740345e-21,  4.025587630654713e-24, -1.083304704974147e-27, -5.256795073687821e-29,
  1.907597148038876e+00, -5.230658621749708e-04, -2.091250145428422e-06, -6.793518328557479e-09, -1.789562991077478e-11, -3.362990539571215e-14, -1.160381908372233e-17,
  2.607019281389942e-19,  1.494673363964537e-21,  5.279661490505749e-24,  1.242538814212877e-26,  9.089951562580891e-30,  1.936407706235411e+00, -3.671095764156439e-04,
 -1.526442447710079e-06, -5.323912862580753e-09, -1.598921672308058e-11, -4.015806874505690e-14, -7.355975780885792e-17, -2.522685465423601e-20,  5.765413536509138e-22,
  3.459656417721451e-24,  1.343647316730748e-26,  3.920265675702218e-29,  1.960075576150939e+00, -2.341877562487866e-04, -1.004875202057448e-06, -3.702276042859659e-09,
 -1.219555728244777e-11, -3.606357897310297e-14, -9.349663659295445e-17, -1.961773613568901e-19, -2.305561341448259e-22,  5.865915054240195e-25,  5.685228206159382e-27,
  2.708836512275242e-29,  1.978387239137786e+00, -1.283398825827476e-04, -5.640098715023484e-07, -2.163805471696571e-09, -7.601162508803330e-12, -2.486051488344657e-14,
 -7.590839940473460e-17, -2.146283952640560e-19, -5.487552376165030e-22, -1.192906284629474e-24, -1.764956629056959e-27,  1.177461967368477e-30,  1.991174721291994e+00,
 -5.285415904873923e-05, -2.361318361666913e-07, -9.310246435829937e-10, -3.410295414010730e-12, -1.185836441791225e-14, -3.954419500331887e-17, -1.270390514655345e-19,
 -3.935645573521320e-22, -1.173410622065530e-24, -3.348645313464965e-27, -9.048627826810660e-30,  1.998321735349404e+00, -1.009884663073368e-05, -4.553129324601465e-08,
 -1.822299830964970e-10, -6.826270433754859e-13, -2.449946765731459e-15, -8.528744209557327e-18, -2.900639437187478e-20, -9.681327510082422e-23, -3.180376627610298e-25,
 -1.030304524826459e-27, -3.295670443712017e-30,  4.005080340221825e-04, -1.803832090925370e-06,  6.092065731619686e-09, -1.828476534016202e-11,  5.143484281834225e-14,
 -1.388529633877298e-16,  3.642823009056731e-19, -9.357834335710989e-22,  2.365039078418453e-24, -5.900202681195099e-27,  1.456256289399346e-29, -3.562175663828180e-32,
  3.603652099572780e-03, -1.621112770456235e-05,  5.461236007372450e-08, -1.632087923396518e-10,  4.560873199926702e-13, -1.219757447452820e-15,  3.159701635489442e-18,
 -7.983430678737809e-21,  1.975626193154990e-23, -4.800993641115840e-26,  1.147350102009615e-28, -2.698738206904341e-31,  1.000502422365688e-02, -4.490111910272282e-05,
  1.505023163288338e-07, -4.458775621542923e-10,  1.229392441199594e-12, -3.224933030296922e-15,  8.134373840347916e-18, -1.983241363456139e-20,  4.682730194532290e-23,
 -1.070294586870989e-25,  2.360882301492007e-28, -4.995667858435326e-31,  1.959475280207143e-02, -8.762457510376192e-05,  2.914732104559666e-07, -8.521366479445125e-10,
  2.301292625660848e-12, -5.855036299908943e-15,  1.413896453015185e-17, -3.242324802148404e-20,  7.019678794748402e-23, -1.414281414817175e-25,  2.566680147849183e-28,
 -3.853352564401673e-31,  3.235793124339222e-02, -1.440075845818332e-04,  4.741235352193911e-07, -1.361264060474563e-09,  3.571505563611663e-12, -8.695091675503765e-15,
  1.964935413614813e-17, -4.069018583068235e-20,  7.450383829994084e-23, -1.087929447105438e-25,  7.150886668318577e-29,  2.952157583081489e-31,  4.827449836510923e-02,
 -2.135515200858083e-04,  6.939775257872875e-07, -1.946579680398640e-09,  4.915144251099785e-12, -1.125319298735057e-14,  2.298552675892730e-17, -3.962835708619505e-20,
  4.701605122706293e-23,  1.628372215645360e-26, -3.445793969934850e-28,  1.448996507087403e-30,  6.731907796894251e-02, -2.956330585070372e-04,  9.455375664141110e-07,
 -2.576253706279342e-09,  6.189964250923674e-12, -1.300855242743312e-14,  2.256954235651033e-17, -2.546375871182599e-20, -1.781244436526390e-23,  2.270380127589016e-25,
 -8.957840315824515e-28,  2.591119475441535e-30,  8.946077681312568e-02, -3.895043202929826e-04,  1.222351342417406e-06, -3.214309475807496e-09,  7.245018157442241e-12,
 -1.346590562534424e-14,  1.719574505694849e-17,  3.259902257371380e-21, -1.148912572588022e-22,  4.771698837798501e-25, -1.366215731951773e-27,  2.959052323470341e-30,
  1.146629400497653e-01, -4.942932068176968e-04,  1.517094780823049e-06, -3.821813455833156e-09,  7.930431800502540e-12, -1.221261910034717e-14,  6.282499515057817e-18,
  4.487235903920330e-20, -2.271266120056163e-22,  6.850551946879515e-25, -1.472763023916321e-27,  1.817015257231705e-30,  1.428828630806012e-01, -6.090040354295079e-04,
  1.821671971731955e-06, -4.358241672729998e-09,  8.107945812182354e-12, -8.974267666890875e-15, -9.927064968680977e-18,  9.422611241081795e-20, -3.268392975041526e-22,
  7.508703002681150e-25, -9.636333993989503e-28, -1.133488716524416e-30,  1.740714587160707e-01, -7.325185937137604e-04,  2.127333368455794e-06, -4.783007157530347e-09,
  7.661790373165694e-12, -3.663997772262306e-15, -3.024707355642294e-17,  1.429433993547534e-19, -3.802203728004719e-22,  5.847055161665577e-25,  2.613490622064139e-28,
 -5.393210341150141e-30,  2.081728785146244e-01, -8.635977589002237e-04,  2.424813612015309e-06, -5.057126903086720e-09,  6.509381955631688e-12,  3.579275214408128e-15,
 -5.254164099207800e-17,  1.803328532058572e-19, -3.544871178218791e-22,  1.402188044914210e-25,  2.047166988564038e-27, -9.540972970290173e-30,  2.451240872491208e-01,
 -1.000883855303338e-03,  2.704490294637216e-06, -5.144999183662500e-09,  4.611251870429299e-12,  1.236880170447169e-14, -7.384894420975684e-17,  1.949558670313850e-19,
 -2.267402713849523e-22, -5.546518675425294e-25,  3.941335503991216e-27, -1.149532811692278e-29,  2.848543896160973e-01, -1.142903952289224e-03,  2.956564842367898e-06,
 -5.016252720660594e-09,  1.979542475308639e-12,  2.206870758076378e-14, -9.064611650347692e-17,  1.767117081619115e-19,  7.107160009967159e-24, -1.380059830731771e-24,
  5.250611360324244e-27, -9.199496933626436e-30,  3.272849085976361e-01, -1.288074337432061e-03,  3.171266428171879e-06, -4.647618013166725e-09, -1.315654615210477e-12,
  3.181737044599950e-14, -9.924948385554236e-17,  1.191907552390882e-19,  3.254285315238511e-22, -2.129277788037649e-24,  5.212183590156973e-27, -1.595770506071060e-30,
  3.723280153355746e-01, -1.434706433935114e-03,  3.339079387217395e-06, -4.024758226976556e-09, -5.142882971311301e-12,  4.057808153323545e-14, -9.632628307556632e-17,
  2.193220336801492e-20,  6.782683099601053e-22, -2.542529747247110e-24,  3.259007374142676e-27,  1.042886808946670e-29,  4.198867110210991e-01, -1.581014467403351e-03,
  3.450993952790264e-06, -3.143982566585345e-09, -9.309596471537349e-12,  4.721773819308194e-14, -7.947322162482930e-17, -1.078632208772395e-19,  9.909777299293629e-22,
 -2.369356447446540e-24, -6.837578704350179e-28,  2.356977674838072e-29,  4.698539621830086e-01, -1.725125223578681e-03,  3.498779216438259e-06, -2.013749512203766e-09,
 -1.356684474656688e-11,  5.061178646311490e-14, -4.779587653054647e-17, -2.546487661821332e-19,  1.175212249477135e-21, -1.450466415728688e-24, -5.971596428758205e-27,
  3.253347451066784e-29,  5.221119919257664e-01, -1.865090274013605e-03,  3.475275987996935e-06, -6.558515094612690e-10, -1.761896956913479e-11,  4.977046515644727e-14,
 -2.403753789756645e-18, -3.953138423620571e-19,  1.146963406205297e-21,  1.995029927525749e-25, -1.119899443987366e-26,  3.158047343976137e-29,  5.765315311813953e-01,
 -1.998901078436099e-03,  3.374705638302665e-06,  8.938420657435129e-10, -2.113870269336422e-11,  4.397769328538247e-14,  5.327737565208657e-17, -5.017244074354183e-19,
  8.493835631486389e-22,  2.334542221776867e-24, -1.443755877760070e-26,  1.697225158617195e-29,  6.329710359611092e-01, -2.124507397365070e-03,  3.192989003113134e-06,
  2.585218723331366e-09, -2.378773432719090e-11,  3.292992557385485e-14,  1.134768026420803e-16, -5.450502971851748e-19,  2.760601729111353e-22,  4.473782804845492e-24,
 -1.377828563997285e-26, -1.042245535021360e-29,  6.912758789918365e-01, -2.239839461817893e-03,  2.928066978119628e-06,  4.354474963142907e-09, -2.524237263601092e-11,
  1.685838516554149e-14,  1.704215550301004e-16, -5.015351311166880e-19, -5.114026571833803e-22,  5.974400318895727e-24, -8.088701992300118e-27, -4.355280755085803e-29,
  7.512775270698723e-01, -2.342834342766867e-03,  2.580211534791371e-06,  6.125525902236317e-09, -2.522333108791050e-11, -3.385114140721179e-15,  2.151042395025460e-16,
 -3.589161469943249e-19, -1.378466601158748e-21,  6.186363016598286e-24,  2.236464685202185e-27, -6.991191532375851e-29,  8.127927190263614e-01, -2.431466933827459e-03,
  2.152312570300734e-06,  7.812396623334664e-09, -2.352797069141756e-11, -2.630018478703661e-14,  2.384722860476376e-16, -1.222517291687124e-19, -2.131500427754742e-21,
  4.667424933015852e-24,  1.485397765094406e-26, -7.528980846744840e-29,  8.756226634348022e-01, -2.503785897279183e-03,  1.650122370884258e-06,  9.322686995570636e-09,
 -2.006252168505170e-11, -4.978821297947255e-14,  2.329540192767070e-16,  1.824204690763660e-19, -2.553299280136821e-21,  1.404748114991549e-24,  2.570957143887295e-26,
 -5.004387617430572e-29,  9.395522801367040e-01, -2.557954815042730e-03,  1.082435705594665e-06,  1.056214697824542e-08, -1.487098219961933e-11, -7.129691171865426e-14,
  1.941392546699610e-16,  5.082420912609856e-19, -2.457587114181939e-21, -3.037115347235411e-24,  3.011743543986001e-26,  4.261245285085209e-30,  1.004349515321188e+00,
 -2.592298620379064e-03,  4.611799848291633e-07,  1.144031793084545e-08, -8.156652114709089e-12, -8.806568609060169e-14,  1.223317722775419e-16,  7.928048468875134e-19,
 -1.752434800585406e-21, -7.529095667421183e-24,  2.455084671337454e-26,  7.130620386584935e-29,  1.069764766218290e+00, -2.605355149796104e-03, -1.986130274260773e-07,
  1.187708426564022e-08, -2.917708923580146e-13, -9.746398562384830e-14,  2.361152595863747e-17,  9.689406274539663e-19, -4.951766963419098e-22, -1.061153073509997e-23,
  8.597995340913781e-27,  1.229993249883883e-28,  1.135530458328956e+00, -2.595931335317089e-03, -8.789841372725527e-07,  1.180983897330306e-08,  8.189301989369810e-12,
 -9.739561832774093e-14, -8.998258857653203e-17,  9.800128324634656e-19,  1.083038865698535e-21, -1.094156801429889e-23, -1.381036935904280e-26,  1.302480037657118e-28,
  1.201360825289023e+00, -2.563163144531454e-03, -1.559402071880956e-06,  1.120080121699876e-08,  1.661725655633436e-11, -8.671984717579763e-14, -2.014782108499835e-16,
  7.969224007763450e-19,  2.603044906206780e-21, -7.847606002864867e-24, -3.483433988142652e-26,  7.856599950650380e-29,  1.266951948588390e+00, -2.506577864358908e-03,
 -2.217323605699057e-06,  1.004384668052951e-08,  2.423764487127085e-11, -6.561865814755011e-14, -2.913557996455584e-16,  4.323748328038066e-19,  3.622847093948328e-21,
 -1.786999876836240e-24, -4.527651718519066e-26, -1.900718481575441e-29,  1.331982120914539e+00, -2.426156717502630e-03, -2.828977263367788e-06,  8.370043422584278e-09,
  3.028294077559929e-11, -3.582456203434195e-14, -3.411491059199657e-16, -5.293341011359563e-20,  3.771181974031601e-21,  5.539736926667034e-24, -3.871083208110463e-26,
 -1.210371547980081e-28,  1.396112602146939e+00, -2.322395114607235e-03, -3.370376739897846e-06,  6.250960073084264e-09,  3.406267882406679e-11, -6.218950391130125e-16,
 -3.377229386480519e-16, -5.568919877418275e-19,  2.893596410638547e-21,  1.159885247074634e-23, -1.547118387417517e-26, -1.743129890292835e-28,  1.458988840078079e+00,
 -2.196357114857244e-03, -3.818551656653277e-06,  3.798771831498546e-09,  3.506292762669641e-11,  3.544581679004738e-14, -2.772945907493472e-16, -9.572425257486501e-19,
  1.155294197260509e-21,  1.394020920466842e-23,  1.587594929276424e-26, -1.433716873646173e-28,  1.520242227667763e+00, -2.049719950947678e-03, -4.152958713811071e-06,
  1.162281666572625e-09,  3.304162069804377e-11,  6.718427322437875e-14, -1.679996441104720e-16, -1.144689618959914e-18, -9.571289074294052e-22,  1.132236292944246e-23,
  4.133735498150090e-26, -3.687408485137713e-29,  1.579492463791246e+00, -1.884803855426369e-03, -4.357006480360843e-06, -1.481753916547607e-09,  2.810244116489179e-11,
  8.962365698237900e-14, -2.983335498946542e-17, -1.059348316686290e-18, -2.766850516573239e-21,  4.515186546514068e-24,  4.821519534354171e-26,  8.930129600968985e-29,
  1.636350573705756e+00, -1.704582015695312e-03, -4.419594097140896e-06, -3.942121983694350e-09,  2.072843039564817e-11,  9.902586012609029e-14,  1.087402232909447e-16,
 -7.176739035520423e-19, -3.648688991319437e-21, -3.755308551572281e-24,  3.257774931697574e-26,  1.616150619413507e-28,  1.690422627619498e+00, -1.512665417811611e-03,
 -4.336531819677814e-06, -6.030908227015016e-09,  1.175873886333869e-11,  9.380881246639722e-14,  2.173084724715505e-16, -2.167605628739563e-19, -3.295443114931561e-21,
 -9.917884863873638e-24,  2.699928212180450e-27,  1.371380404973288e-28,  1.741314169904131e+00, -1.313257757547690e-03, -4.111685072191406e-06, -7.584097556949406e-09,
  2.299054273850803e-12,  7.512910049729311e-14,  2.717730917337968e-16,  2.912517096210097e-19, -1.882466698870302e-21, -1.132059206860313e-23, -2.485146611039286e-26,
  3.660172970720793e-29,  1.788635337337614e+00, -1.111076631966159e-03, -3.757670360306016e-06, -8.482724849224979e-09, -6.431667722159241e-12,  4.688762523706089e-14,
  2.619103995455105e-16,  6.503600279030841e-19, -2.390272163908961e-23, -7.708729110910147e-24, -3.519151096788214e-26, -6.778727354474087e-29,  1.832006602884708e+00,
 -9.112389649035987e-04, -3.295938270145062e-06, -8.671546887332246e-09, -1.329995099905627e-11,  1.503363040759302e-14,  1.953834672959411e-16,  7.598613690261166e-19,
  1.494916612745977e-21, -1.432423175179403e-24, -2.482553835201553e-26, -1.064908990184122e-28,  1.871065033687664e+00, -7.191110758796483e-04, -2.756112016216932e-06,
 -8.171849446848064e-09, -1.746802757386005e-11, -1.376773458875685e-14,  9.606433074902531e-17,  6.156916074062565e-19,  2.095836554000128e-21,  3.932068876825615e-24,
 -3.693471617534699e-27, -6.641497766550465e-29,  1.905470901341032e+00, -5.401268710325438e-04, -2.174512583574206e-06, -7.085241741970499e-09, -1.857039297303638e-11,
 -3.381521739696367e-14, -3.605289882564581e-18,  3.116691838335959e-19,  1.693771038054609e-21,  5.783245605793515e-24,  1.271534948509036e-26,  3.802428284068647e-30,
  1.934914434012085e+00, -3.795810745461746e-04, -1.591891182470871e-06, -5.586261744214722e-09, -1.681007837782714e-11, -4.192977550677005e-14, -7.398833614715933e-17,
 -4.677600631451213e-21,  7.111888513762609e-22,  4.032700611767020e-24,  1.524255833742078e-26,  4.288301178702576e-29,  1.959122460993356e+00, -2.424078399249600e-04,
 -1.050497490101290e-06, -3.903298933970415e-09, -1.293971720487444e-11, -3.837422639486945e-14, -9.908939038433415e-17, -2.031709731622357e-19, -2.050450092362452e-22,
  8.393014873501279e-25,  6.987890051210984e-27,  3.225508729394046e-29,  1.977864688030806e+00, -1.329579301749798e-04, -5.907219830104265e-07, -2.289502818246681e-09,
 -8.117088024818512e-12, -2.675645607397787e-14, -8.217038927728621e-17, -2.328891792357158e-19, -5.929548034777943e-22, -1.262096048692263e-24, -1.684654131119582e-27,
  2.535021301476168e-30,  1.990959454454801e+00, -5.478884888715981e-05, -2.476395171719125e-07, -9.875395096689236e-10, -3.657248957736120e-12, -1.285157332494978e-14,
 -4.328414478017371e-17, -1.403356516785919e-19, -4.383173018082266e-22, -1.315648971318777e-24, -3.771665314361473e-27, -1.020119774321423e-29,  1.998280597345580e+00,
 -1.047203348801785e-05, -4.778523899959507e-08, -1.935554113329626e-10, -7.337405190010257e-13, -2.664743722839120e-15, -9.386075214216616e-18, -3.229585552382995e-20,
 -1.090407837273381e-22, -3.623034951935071e-25, -1.186941111330198e-27, -3.838801024643219e-30,  3.933888085445738e-04, -1.755959451545411e-06,  5.877496164244284e-09,
 -1.748355806236313e-11,  4.874313232537657e-14, -1.304162517379075e-16,  3.391087544953198e-19, -8.633912710266230e-22,  2.162749936203323e-24, -5.347863592476086e-27,
  1.308279745918658e-29, -3.172059626378523e-32,  3.539669155373895e-03, -1.578194061788832e-05,  5.269684705041734e-08, -1.561025108975714e-10,  4.324327555569912e-13,
 -1.146537168166235e-15,  2.944762735093906e-18, -7.378020974816118e-21,  1.810773014518038e-23, -4.364945625588988e-26,  1.034949649925728e-28, -2.415879043142166e-31,
  9.827794363322141e-03, -4.371817313424048e-05,  1.452677126524871e-07, -4.267128509596025e-10,  1.166801910635916e-12, -3.036205917700762e-15,  7.599478395800176e-18,
 -1.839380850059644e-20,  4.313905397100115e-23, -9.801172797127512e-26,  2.151322340865658e-28, -4.537119295652164e-31,  1.924885418275036e-02, -8.533307480900534e-05,
  2.814646893391939e-07, -8.162346386943353e-10,  2.187513007352907e-12, -5.526346165374564e-15,  1.326181027375177e-17, -3.025646482262784e-20,  6.528613251718675e-23,
 -1.314957961313509e-25,  2.400685926086665e-28, -3.689596913099675e-31,  3.178938477980035e-02, -1.402789785774412e-04,  4.581255742193032e-07, -1.305485945936858e-09,
  3.402228666797582e-12, -8.236913271345049e-15,  1.854282194096541e-17, -3.836815171853203e-20,  7.064169235364343e-23, -1.056964008128791e-25,  8.276052797555557e-29,
  2.185924199232895e-31,  4.743124985022991e-02, -2.080918156969133e-04,  6.710830924306664e-07, -1.869708284329382e-09,  4.695507921258932e-12, -1.071468501350166e-14,
  2.189706581740834e-17, -3.811700316220107e-20,  4.736897375309850e-23,  3.714606565870415e-27, -2.853384348695090e-28,  1.248205377526346e-30,  6.615148089181183e-02,
 -2.881907540663479e-04,  9.152082675310458e-07, -2.479266459449175e-09,  5.935151839021710e-12, -1.247549633322469e-14,  2.184975783032091e-17, -2.590968047549415e-20,
 -1.025732094368742e-23,  1.934040873421709e-25, -7.879138869198990e-28,  2.316273093797784e-30,  8.792207562119723e-02, -3.798778460859130e-04,  1.184466335655185e-06,
 -3.100521283177396e-09,  6.979832336121725e-12, -1.305251236187219e-14,  1.723805974144485e-17, -1.520641747792310e-22, -9.866597693794149e-23,  4.250661176070501e-25,
 -1.240437284053521e-27,  2.758015175169993e-30,  1.127097533020463e-01, -4.823377570474365e-04,  1.471986308146850e-06, -3.696871961005020e-09,  7.687784839579182e-12,
 -1.204756090409264e-14,  7.440800217814011e-18,  3.798768755732622e-20, -2.035054984428388e-22,  6.277701785101496e-25, -1.390923822047169e-27,  1.894623526527338e-30,
  1.404756655594299e-01, -5.946376636153030e-04,  1.770145471909099e-06, -4.229962491367528e-09,  7.926285665116160e-12, -9.182014394524348e-15, -7.431147671765031e-18,
  8.419222911400401e-20, -3.005123304508941e-22,  7.114876525737208e-25, -1.001722747195903e-27, -6.147851885686257e-31,  1.711750611010372e-01, -7.157274329215673e-04,
  2.070670272098329e-06, -4.661042857051926e-09,  7.581568292899635e-12, -4.343253921691251e-15, -2.641182089281279e-17,  1.311147087434102e-19, -3.590373424170635e-22,
  5.907027732253158e-25,  4.545447126090267e-29, -4.440128294819501e-30,  2.047569026613962e-01, -8.444402165397622e-04,  2.364755134867203e-06, -4.952470928289791e-09,
  6.568759858123682e-12,  2.377591053169636e-15, -4.765026444803087e-17,  1.690850345342596e-19, -3.480634051362382e-22,  2.140432226883895e-25,  1.652191767088247e-27,
 -8.423801524282291e-30,  2.411634344474145e-01, -9.794936204624636e-04,  2.643200841119200e-06, -5.069334603482921e-09,  4.841342006083788e-12,  1.066109493557987e-14,
 -6.849455008612404e-17,  1.874101495507366e-19, -2.439899046122298e-22, -4.068971048859548e-25,  3.451900628535291e-27, -1.074098278701224e-29,  2.803296984126243e-01,
 -1.119491642460485e-03,  2.896574032851891e-06, -4.981165568194663e-09,  2.399562284346514e-12,  1.995255714130302e-14, -8.570218917119497e-17,  1.761839601823002e-19,
 -3.889293757722514e-23, -1.178218773680901e-24,  4.839716894640851e-27, -9.437064218641585e-30,  3.221829978492880e-01, -1.262927602002095e-03,  3.115389292554896e-06,
 -4.663705974091591e-09, -7.028509715082620e-13,  2.947653828311529e-14, -9.577758845124544e-17,  1.284180733139095e-19,  2.525056002805621e-22, -1.922714315301596e-24,
  5.103832013623476e-27, -3.265704781190970e-30,  3.666423070938292e-01, -1.408188325232619e-03,  3.290314947054400e-06, -4.100677219099467e-09, -4.354377586418078e-12,
  3.827598892396365e-14, -9.542189304752941e-17,  4.219829394494277e-20,  5.891859315523639e-22, -2.403907157323919e-24,  3.650150196856789e-27,  7.412173777632997e-30,
  4.136176266309405e-01, -1.553559888061640e-03,  3.412403266089542e-06, -3.285485868499672e-09, -8.384541730236564e-12,  4.527764325341242e-14, -8.206228293776169e-17,
 -7.751999580836894e-20,  9.054289712856226e-22, -2.377012992489513e-24,  2.752345737560544e-28,  2.004284054853850e-29,  4.630092836024272e-01, -1.697235263492271e-03,
  3.473345000644171e-06, -2.222785816572915e-09, -1.256663581923069e-11,  4.938332318046498e-14, -5.440770948761366e-17, -2.179207860667497e-19,  1.119034407744468e-21,
 -1.661417968616394e-24, -4.594320837044849e-27,  3.001752242893390e-29,  5.147071787348129e-01, -1.837324263729445e-03,  3.465747177055155e-06, -9.297985713530883e-10,
 -1.662501228713659e-11,  4.958410064686358e-14, -1.295822266517676e-17, -3.585798290801919e-19,  1.146418393752608e-21, -2.205376640949142e-25, -9.801358079518110e-27,
  3.181333495275868e-29,  5.685899820612702e-01, -1.971866211363681e-03,  3.383431665038484e-06,  5.627240070700237e-10, -2.024748398003328e-11,  4.509091598006654e-14,
  3.962146482938239e-17, -4.733093554769470e-19,  9.232239210338529e-22,  1.773267517675869e-24, -1.359617693047662e-26,  2.109199745043421e-29,  6.245242816050030e-01,
 -2.098845814116001e-03,  3.221750204244062e-06,  2.210026566887651e-09, -2.310313178055386e-11,  3.547137516437049e-14,  9.836251852732179e-17, -5.337465983210849e-19,
  4.271066654971725e-22,  3.915795650784879e-24, -1.406529218980067e-26, -2.765647676350146e-30,  6.823636914988149e-01, -2.216212750075336e-03,  2.977909243178631e-06,
  3.953511766939178e-09, -2.486544996336203e-11,  2.077833386017605e-14,  1.561813302778421e-16, -5.145247985747250e-19, -3.025861961366913e-22,  5.615134300022269e-24,
 -9.810046929168304e-27, -3.469425650341525e-29,  7.419479289330616e-01, -2.321905489331614e-03,  2.651295070712497e-06,  5.721687978576584e-09, -2.524024726083381e-11,
  1.652013500042892e-15,  2.044706036842206e-16, -3.994523838221133e-19, -1.154873199400963e-21,  6.216010723620361e-24, -7.095286546549175e-28, -6.380047539293891e-29,
  8.031018729494107e-01, -2.413879875797439e-03,  2.243786290269947e-06,  7.432050730091008e-09, -2.399705746566075e-11, -2.062547481234664e-14,  2.341203654449931e-16,
 -1.876631388991029e-19, -1.953580372637076e-21,  5.194950585969978e-24,  1.151693267238565e-26, -7.603048104858156e-29,  8.656346225265431e-01, -2.490142960038768e-03,
  1.760036740873251e-06,  8.994025877776881e-09, -2.100201074266946e-11, -4.414520225587911e-14,  2.369269060358015e-16,  1.017180149577621e-19, -2.484775769259772e-21,
  2.386088136359345e-24,  2.328719555774194e-26, -5.968467740007258e-29,  9.293385767197572e-01, -2.548792497953365e-03,  1.207707631957781e-06,  1.031306159213638e-08,
 -1.624922064561641e-11, -6.647577960928426e-14,  2.072542556555494e-16,  4.280825013635098e-19, -2.545238651763176e-21, -1.833610251709125e-24,  2.993731808530075e-26,
 -1.227534398203597e-29,  9.939885658763041e-01, -2.588062396635576e-03,  5.976231751140140e-07,  1.129588793822271e-08, -9.886841916907874e-12, -8.486992145663358e-14,
  1.437058551298767e-16,  7.325855526842695e-19, -2.005093875934829e-21, -6.489204869732060e-24,  2.732024406437408e-26,  5.436714755394791e-29,  1.059341070162021e+00,
 -2.606374181232016e-03, -5.618022762276687e-08,  1.185686167069793e-08, -2.233197023524812e-12, -9.657388585802358e-14,  5.046312868056734e-17,  9.470595646023643e-19,
 -8.697169155183335e-22, -1.016161350558051e-23,  1.383601327331968e-26,  1.145129854257385e-28,  1.125133569737861e+00, -2.602394257411493e-03, -7.365445321450242e-07,
  1.192517656438906e-08,  6.222035153042861e-12, -9.922236736518787e-14, -6.211693811229214e-17,  1.008272468858498e-18,  6.806013973536462e-22, -1.137708428419270e-23,
 -7.916497997645694e-27,  1.369641700371180e-28,  1.191084079743776e+00, -2.575096336237052e-03, -1.423455265660942e-06,  1.145254717137388e-08,  1.483635976573121e-11,
 -9.127841618171907e-14, -1.780425669231255e-16,  8.754378532066825e-19,  2.296343522833200e-21, -9.165278498117271e-24, -3.089096259391787e-26,  1.002895739711579e-28,
  1.256890932458283e+00, -2.523827858111766e-03, -2.094515158813944e-06,  1.042077443621563e-08,  2.285639434842958e-11, -7.245289115129085e-14, -2.776384392248239e-16,
  5.469259344013589e-19,  3.525787162526380e-21, -3.606779391241120e-24, -4.551160365991764e-26,  8.554360216009879e-30,  1.322232878084829e+00, -2.448378593910445e-03,
 -2.725654665988457e-06,  8.848393430299223e-09,  2.948452491460613e-11, -4.401611627135468e-14, -3.409139603387511e-16,  7.062633633752547e-20,  3.941503186711862e-21,
  3.889909171000187e-24, -4.364497619533452e-26, -1.024279390523743e-28,  1.386769583808824e+00, -2.349048821226278e-03, -3.292097052868164e-06,  6.795417931881396e-09,
  3.396798008300550e-11, -8.903516848775804e-15, -3.519577489256163e-16, -4.577504779556483e-19,  3.298156516255198e-21,  1.082548887200044e-23, -2.321473904967056e-26,
 -1.767388289293423e-28,  1.450142617030986e+00, -2.226713598462760e-03, -3.769578155382223e-06,  4.365079380254808e-09,  3.570314580750182e-11,  2.847375844260974e-14,
 -3.035035650664672e-16, -9.121337651325173e-19,  1.666985746925501e-21,  1.444182525010853e-23,  9.029579219979684e-27, -1.674166587150531e-28,  1.511977001678718e+00,
 -2.082878743174877e-03, -4.135795736150165e-06,  1.701467055143808e-09,  3.434237384455310e-11,  6.276459302342512e-14, -2.004162164407713e-16, -1.168480663396861e-18,
 -5.202360585492863e-22,  1.293413265517774e-23,  3.901675937890393e-26, -6.903899172188723e-29,  1.571883434623120e+00, -1.919723251668835e-03, -4.372030695394683e-06,
 -1.017824238427674e-09,  2.988530067686482e-11,  8.854187418212781e-14, -6.070752399148605e-17, -1.144907200862331e-18, -2.568691387861824e-21,  6.516862327094009e-24,
  5.172147903148471e-26,  6.909906082582407e-29,  1.629461240695433e+00, -1.740122200788924e-03, -4.464843834483714e-06, -3.594488233626046e-09,  2.273334888442488e-11,
  1.013811778156110e-13,  8.699229175678363e-17, -8.363294948509138e-19, -3.758694803601546e-21, -2.308333916356249e-24,  3.980334153956283e-26,  1.660402175553170e-28,
  1.684302127795766e+00, -1.547643813167658e-03, -4.407711053907567e-06, -5.827477907123110e-09,  1.368651455157175e-11,  9.893913907108595e-14,  2.097093616644003e-16,
 -3.278943712653942e-19, -3.649023859088189e-21, -9.682071478597236e-24,  9.267372688140762e-27,  1.613739663817088e-28,  1.735994776557683e+00, -1.346514532953247e-03,
 -4.202422793218070e-06, -7.534934995015329e-09,  3.867485582475957e-12,  8.174232493205420e-14,  2.790221799478625e-16,  2.243038295618237e-19, -2.307448933089526e-21,
 -1.227535396426161e-23, -2.270399089145218e-26,  6.167787052780499e-29,  1.784130261023931e+00, -1.141546841536174e-03, -3.860048429549799e-06, -8.577781795088551e-09,
 -5.429583275644746e-12,  5.339164308473794e-14,  2.800660821278109e-16,  6.448775225458120e-19, -3.274547509498741e-22, -9.173907453992859e-24, -3.800728682029593e-26,
 -5.952045349909570e-29,  1.828308247900284e+00, -9.380262983593093e-04, -3.401262860594965e-06, -8.881678611956356e-09, -1.295063528405787e-11,  1.998349793054712e-14,
  2.173201355831116e-16,  8.066726170982279e-19,  1.424316976441626e-21, -2.522307824454521e-24, -2.974530120356211e-26, -1.169988770113561e-28,  1.868143863797076e+00,
 -7.415569921697725e-04, -2.855859804808066e-06, -8.453409458281986e-09, -1.771889071984419e-11, -1.124761009526825e-14,  1.142636731775736e-16,  6.849887505305671e-19,
  2.233986409924276e-21,  3.721345219098729e-24, -6.958889351363518e-27, -8.236713763007001e-29,  1.903275055978376e+00, -5.578681658661282e-04, -2.261340567097647e-06,
 -7.387780085841834e-09, -1.924682324250408e-11, -3.379070294288308e-14,  5.912256800947874e-18,  3.692993810827919e-19,  1.911145558291915e-21,  6.293233158272546e-24,
  1.273144734233682e-26, -3.423634247402455e-30,  1.933370208359201e+00, -3.925889812710977e-04, -1.660568077110748e-06, -5.862028239635064e-09, -1.766642782187928e-11,
 -4.370435714584504e-14, -7.377801074400614e-17,  2.052470504768704e-20,  8.678051140985245e-22,  4.681198979130839e-24,  1.720819582609890e-26,  4.642711594251060e-29,
  1.958135719976273e+00, -2.510027569756456e-04, -1.098605041019784e-06, -4.116605445186684e-09, -1.373144768438883e-11, -4.082134873600362e-14, -1.048650943114528e-16,
 -2.091921524324289e-19, -1.694414257994631e-22,  1.148907165935037e-24,  8.536201301235090e-27,  3.827154789099076e-29,  1.977323227584691e+00, -1.377958513994084e-04,
 -6.189932697804596e-07, -2.423766666025657e-09, -8.672477493349408e-12, -2.880898274683912e-14, -8.896385183103044e-17, -2.526034589016618e-19, -6.395719232012913e-22,
 -1.326760846162250e-24, -1.535611973219643e-27,  4.318031944982944e-30,  1.990736260343366e+00, -5.681838160056107e-05, -2.598497557788033e-07, -1.048169552330923e-09,
 -3.924995281088332e-12, -1.393917536090008e-14, -4.741724225552730e-17, -1.551496362613463e-19, -4.885077813889559e-22, -1.475861901262897e-24, -4.248373655129068e-27,
 -1.149096892553863e-29,  1.998237929650394e+00, -1.086380976866484e-05, -5.018014226055340e-08, -2.057341727826382e-10, -7.893633886250646e-13, -2.901267614555443e-15,
 -1.034123752158848e-17, -3.600335166178385e-20, -1.229806466105464e-22, -4.133400603561076e-25, -1.369546940155106e-27, -4.478884749956576e-30,  3.864577003861858e-04,
 -1.709765630286474e-06,  5.672288143743664e-09, -1.672410042864761e-11,  4.621427489581885e-14, -1.225600949401188e-16,  3.158744728166749e-19, -7.971653101411470e-22,
  1.979319667822265e-24, -4.851420719003504e-27,  1.176443235208706e-29, -2.827537760919039e-32,  3.477372842451845e-03, -1.536774285843102e-05,  5.086438599920547e-08,
 -1.493632618640210e-10,  4.101923542367958e-13, -1.078277823915685e-15,  2.746059758250551e-18, -6.822937047811707e-21,  1.660837403082566e-23, -3.971463887804284e-26,
  9.342901065572732e-29, -2.164415683381966e-31,  9.655213966058377e-03, -4.257620083125527e-05,  1.402571991568902e-07, -4.085200759602121e-10,  1.107860742500087e-12,
 -2.859845966875351e-15,  7.103259232929420e-18, -1.706819099985995e-20,  3.976083053405736e-23, -8.979316368633342e-26,  1.960989803926971e-28, -4.121040074678959e-31,
  1.891196411378123e-02, -8.311994984251621e-05,  2.718762827760574e-07, -7.821016364122151e-10,  2.080101498593522e-12, -5.217997124925733e-15,  1.244317882178059e-17,
 -2.824122828264179e-20,  6.072126690681542e-23, -1.222126600590986e-25,  2.242153816041666e-28, -3.515069143192588e-31,  3.123550094789093e-02, -1.366757242677027e-04,
  4.427809977951272e-07, -1.252344374265638e-09,  3.241854964985308e-12, -7.804525295978508e-15,  1.749959380034470e-17, -3.616784215297559e-20,  6.689834791844883e-23,
 -1.022131598001880e-25,  9.094018527716255e-29,  1.552187508028134e-31,  4.660947960092585e-02, -2.028116358795596e-04,  6.490903815961725e-07, -1.796266313208978e-09,
  4.486383952899198e-12, -1.020179141333026e-14,  2.085101603381647e-17, -3.660115500503328e-20,  4.731000268135557e-23, -6.653894747105269e-27, -2.343644389980765e-28,
  1.072715989953143e-30,  6.501317503790512e-02, -2.809864971337232e-04,  8.860187023846055e-07, -2.386271864601098e-09,  5.690826925916154e-12, -1.195983866763444e-14,
  2.112069596559511e-17, -2.613240188260017e-20, -3.838199224521689e-24,  1.638505056693984e-25, -6.915861205920929e-28,  2.066237403627103e-30,  8.642128271288885e-02,
 -3.705490616016792e-04,  1.147921602297710e-06, -2.990909897036146e-09,  6.722917093243393e-12, -1.263919299497211e-14,  1.719183312845727e-17, -3.073879700721627e-21,
 -8.422800354106693e-23,  3.778166280068875e-25, -1.123493860370945e-27,  2.558065962324401e-30,  1.108036760205654e-01, -4.707372436064251e-04,  1.428353952955973e-06,
 -3.575784961845699e-09,  7.448701853742654e-12, -1.185693320943428e-14,  8.416606890332465e-18,  3.182653316150123e-20, -1.818870277022143e-22,  5.738129600324901e-25,
 -1.306702538960019e-27,  1.926978538099844e-30,  1.381251187805883e-01, -5.806773961056326e-04,  1.720140756061473e-06, -4.104619950985096e-09,  7.741047333205680e-12,
 -9.333136612971481e-15, -5.204599611394085e-18,  7.497787318308957e-20, -2.756253303105674e-22,  6.710086965850675e-25, -1.019146493189433e-27, -1.918926131763239e-31,
  1.683449307567912e-01, -6.993837454347474e-04,  2.015462613613581e-06, -4.540465900901264e-09,  7.488655119318390e-12, -4.934361707504915e-15, -2.289826052966585e-17,
  1.199657427387851e-19, -3.377840679988154e-22,  5.888679772308828e-25, -1.311040935257492e-28, -3.603807278375611e-30,  2.014166040162741e-01, -8.257581041445556e-04,
  2.305957456953421e-06, -4.847050904794709e-09,  6.605252627786407e-12,  1.289546239096735e-15, -4.307057065438260e-17,  1.580823432336195e-19, -3.392547383133209e-22,
  2.730308427389323e-25,  1.304795588294022e-27, -7.379541721346591e-30,  2.372873677893126e-01, -9.585900093160804e-04,  2.582840346548009e-06, -4.990254904981747e-09,
  5.038545645271449e-12,  9.079300671361727e-15, -6.335839079611983e-17,  1.793938380835747e-19, -2.562646034922103e-22, -2.780391187243166e-25,  2.996857104923246e-27,
 -9.937053591504270e-30,  2.758976994192372e-01, -1.096557463853869e-03,  2.837043215270255e-06, -4.939690243905073e-09,  2.778443598649322e-12,  1.795472389834514e-14,
 -8.079257717570703e-17,  1.742972811523912e-19, -7.792448914953618e-23, -9.929539093372574e-25,  4.423415742023090e-27, -9.452949947852624e-30,  3.171807790164680e-01,
 -1.238228492724833e-03,  3.059376400501461e-06, -4.670358999324007e-09, -1.360111223553907e-13,  2.722187513727438e-14, -9.207888645577985e-17,  1.354298646224782e-19,
  1.869242440169861e-22, -1.721843981371843e-24,  4.930186773190304e-27, -4.570426604352369e-30,  3.610618855841913e-01, -1.382063765180168e-03,  3.240713660455242e-06,
 -4.164347093359072e-09, -3.611652681441391e-12,  3.600209367271197e-14, -9.398919110620016e-17,  5.969636162247562e-20,  5.053446047890202e-22, -2.252183228811363e-24,
  3.916800989421181e-27,  4.769678522256483e-30,  4.074577327042178e-01, -1.526420577726605e-03,  3.372202054398047e-06, -3.412501802578166e-09, -7.498843042885884e-12,
  4.328529682407721e-14, -8.384005019255527e-17, -4.991163874801482e-20,  8.202580466057321e-22, -2.349369290825446e-24,  1.082462919976623e-27,  1.668153280580537e-29,
  4.562757424095296e-01, -1.669558540739553e-03,  3.445497531486909e-06, -2.416023608150598e-09, -1.159250077666000e-11,  4.800830672667590e-14, -6.001739381909676e-17,
 -1.831015941596586e-19,  1.056226486807807e-21, -1.819576716248826e-24, -3.333816705961262e-27,  2.724586088954486e-29,  5.074132566852397e-01, -1.809647363406365e-03,
  3.453026254642150e-06, -1.187885548584681e-09, -1.563723212318874e-11,  4.915675595572974e-14, -2.248657962147343e-17, -3.220944038378634e-19,  1.131758564148091e-21,
 -5.846989649257670e-25, -8.410499398064112e-27,  3.129478668817206e-29,  5.607566872052048e-01, -1.944777185754935e-03,  3.388270509861291e-06,  2.460260312115632e-10,
 -1.933721248449395e-11,  4.588619284961034e-14,  2.679126659247663e-17, -4.428478753548456e-19,  9.775049713691042e-22,  1.248955949356943e-24, -1.259714645378680e-26,
  2.414884036519795e-29,  6.161806055143271e-01, -2.072971960533974e-03,  3.246076435173302e-06,  1.846175091297467e-09, -2.237129928974816e-11,  3.765440753899819e-14,
  8.362937492680944e-17, -5.179323845194352e-19,  5.579378012066049e-22,  3.352804891410109e-24, -1.403509653729595e-26,  3.981517370044461e-30,  6.735467780082427e-01,
 -2.192206438085638e-03,  3.022978661169664e-06,  3.559187845801463e-09, -2.441357158134685e-11,  2.435289530594131e-14,  1.416689099308478e-16, -5.210518041498893e-19,
 -1.078489583670553e-22,  5.194782738885976e-24, -1.114412321724147e-26, -2.599211056905415e-29,  7.327031528583674e-01, -2.300427348866037e-03,  2.717534206165472e-06,
  5.318371098957365e-09, -2.515906070994318e-11,  6.421122405813087e-15,  1.928021245296680e-16, -4.328387518637848e-19, -9.322657837048200e-22,  6.133522141628580e-24,
 -3.362902341237730e-27, -5.666644574968815e-29,  7.934828096090043e-01, -2.395579403616498e-03,  2.330654552442833e-06,  7.045101116224769e-09, -2.435383945835605e-11,
 -1.507652918117868e-14,  2.280193046713895e-16, -2.471030396213662e-19, -1.759074126681019e-21,  5.588975950809391e-24,  8.194245632226147e-27, -7.467380268917758e-29,
  8.557028866695032e-01, -2.475636730505879e-03,  1.865920725580136e-06,  8.651240234003179e-09, -2.182786770956866e-11, -3.843367853872746e-14,  2.386759956921731e-16,
  2.375407547459470e-20, -2.382764127337987e-21,  3.262735212224494e-24,  2.049208614099046e-26, -6.697077476171671e-29,  9.191635074720536e-01, -2.538640328997065e-03,
  1.329861458044008e-06,  1.004271210568054e-08, -1.752807211958293e-11, -6.136709809762194e-14,  2.180920155454305e-16,  3.458084874977832e-19, -2.589865959350144e-21,
 -6.515163361504240e-25,  2.905629759114433e-26, -2.751977347560240e-29,  9.836467327829955e-01, -2.582742025585349e-03,  7.321693051501537e-07,  1.112431351363579e-08,
 -1.154812779614158e-11, -8.118229081345325e-14,  1.632863782510865e-16,  6.649000468548362e-19, -2.218505558824889e-21, -5.353766908862837e-24,  2.932142068484303e-26,
  3.649674236307059e-29,  1.048915574624449e+00, -2.606255247442661e-03,  8.582422439227993e-08,  1.180575345564135e-08, -4.150433331667785e-12, -9.504803760885026e-14,
  7.653698634806596e-17,  9.134920135679098e-19, -1.224387918062538e-21, -9.510646530973376e-24,  1.862644335250986e-26,  1.027281306497541e-28,  1.114713116498934e+00,
 -2.607712664096436e-03, -5.929108208189162e-07,  1.200878218573736e-08,  4.224977608673224e-12, -1.003723136148678e-13, -3.364233944799549e-17,  1.023449253121517e-18,
  2.667888014324688e-22, -1.157218449532015e-23, -1.820805135925178e-27,  1.393942446041144e-28,  1.180761795020554e+00, -2.585930360817857e-03, -1.284661381750600e-06,
  1.167510069310214e-08,  1.297008830907603e-11, -9.524930027074824e-14, -1.525527961349073e-16,  9.434121503200584e-19,  1.945268725594611e-21, -1.030685716541161e-23,
 -2.604992131198017e-26,  1.192313482967155e-28,  1.246762909390882e+00, -2.540077677723848e-03, -1.967320628599632e-06,  1.077452767713045e-08,  2.134200906313823e-11,
 -7.891982984239321e-14, -2.607669785469702e-16,  6.573235041352465e-19,  3.363341392924438e-21, -5.411368642018588e-24, -4.451045629968361e-26,  3.701344906333084e-29,
  1.312396436942649e+00, -2.469751158351256e-03, -2.616673918632594e-06,  9.312659628843524e-09,  2.852261758256947e-11, -5.215995125859643e-14, -3.371520286986999e-16,
  1.986496564567271e-19,  4.049088342694183e-21,  2.060512464377329e-24, -4.765496482288806e-26, -7.911132543868441e-29,  1.377321244444916e+00, -2.375050194833790e-03,
 -3.207298485968827e-06,  7.337017958935170e-09,  3.370446484768781e-11, -1.749202753423256e-14, -3.632399663650556e-16, -3.461683902871125e-19,  3.669289856128090e-21,
  9.741948555678979e-24, -3.093693949854106e-26, -1.732532415330361e-28,  1.441175794896460e+00, -2.256650947973724e-03, -3.713752213592022e-06,  4.940481176984599e-09,
  3.619774460044470e-11,  2.088970627750133e-14, -3.282179301038345e-16, -8.504168197326062e-19,  2.191558482717193e-21,  1.464925409000676e-23,  1.189346610147095e-27,
 -1.883367188030336e-28,  1.503579456596782e+00, -2.115874003870836e-03, -4.112040715989822e-06,  2.260714876628204e-09,  3.554690784120398e-11,  5.756055400420892e-14,
 -2.332946310940136e-16, -1.177383483674183e-18, -2.733788448782636e-23,  1.442407580660593e-23,  3.523056923037666e-26, -1.033219882445480e-28,  1.564134523423355e+00,
 -1.954740089979100e-03, -4.381317446359718e-06, -5.255829540478668e-10,  3.163892467384957e-11,  8.669114759067660e-14, -9.387755099047760e-17, -1.222946802598019e-18,
 -2.296177578613424e-21,  8.639258238701321e-24,  5.420761606203213e-26,  4.291674510384844e-29,  1.622429050143473e+00, -1.776007148633247e-03, -4.505728035106691e-06,
 -3.214428432331424e-09,  2.477988326829221e-11,  1.031743292229439e-13,  6.188095156682155e-17, -9.576157391642309e-19, -3.811373480238867e-21, -5.699181119977758e-25,
  4.711126693918912e-26,  1.651739640369984e-28,  1.678040591734026e+00, -1.583181345658829e-03, -4.476260706861564e-06, -5.592393314080962e-09,  1.571481436616478e-11,
  1.038484772171607e-13,  1.988417498061080e-16, -4.501541525026327e-19, -3.989130467662936e-21, -9.162324966622531e-24,  1.689237619117877e-26,  1.850283793202128e-28,
  1.730540908658035e+00, -1.380494413600490e-03, -4.292415600556502e-06, -7.459610628814595e-09,  5.569761248672000e-12,  8.850546514876571e-14,  2.842012993544592e-16,
  1.432253829330627e-19, -2.764979692364126e-21, -1.312096319030252e-23, -1.936461462907733e-26,  9.076222768004979e-29,  1.779501658996560e+00, -1.172840355786991e-03,
 -3.963466612887223e-06, -8.655741144515153e-09, -4.293079425047793e-12,  6.032840805258042e-14,  2.979241832148555e-16,  6.288164584993907e-19, -6.856813786988610e-22,
 -1.074316574066228e-23, -4.036250235092775e-26, -4.672164034662491e-29,  1.824501042562872e+00, -9.656662121356881e-04, -3.509072136653108e-06, -9.085400260349018e-09,
 -1.249695272852722e-11,  2.547528114954950e-14,  2.405297157820817e-16,  8.505580349152042e-19,  1.310830418347677e-21, -3.817936675169360e-24, -3.510422216468343e-26,
 -1.263334918450065e-28,  1.865131292787067e+00, -7.648144698958649e-04, -2.959008654418256e-06, -8.738555659592780e-09, -1.791482381924946e-11, -8.266925939013045e-15,
  1.344638984458659e-16,  7.585586923461598e-19,  2.362024182210805e-21,  3.365332332267072e-24, -1.097368150816597e-26, -1.004801178229313e-28,  1.901006832936140e+00,
 -5.763187902767626e-04, -2.351863890138162e-06, -7.701124417832959e-09, -1.992034417215145e-11, -3.351760064330263e-14,  1.714358993807363e-17,  4.341787791395470e-19,
  2.146808619818807e-21,  6.796843137825669e-24,  1.237927613556818e-26, -1.301139357707522e-29,  1.931772830958459e+00, -4.061597755663174e-04, -1.732637548897061e-06,
 -6.151779734561745e-09, -1.855815824140279e-11, -4.546483455447889e-14, -7.278823708990144e-17,  5.112774132353568e-20,  1.049219439147576e-21,  5.411359519846099e-24,
  1.932323149186021e-26,  4.963572444392944e-29,  1.957113813049888e+00, -2.599929922657404e-04, -1.149349915846975e-06, -4.342978770036894e-09, -1.457351972504200e-11,
 -4.340897160587658e-14, -1.107916769691270e-16, -2.138831971642098e-19, -1.215109766161608e-22,  1.526013539039882e-24,  1.036989464184967e-26,  4.524501108156031e-29,
  1.976761952691582e+00, -1.428665418269650e-04, -6.489304239961771e-07, -2.567254198983733e-09, -9.270593518482744e-12, -3.103134719237656e-14, -9.633053951620385e-17,
 -2.738454205388931e-19, -6.883894214081081e-22, -1.383746450893281e-24, -1.296809845356921e-27,  6.634801098016951e-30,  1.990504748024338e+00, -5.894858098074955e-05,
 -2.728139942135807e-07, -1.113263086415308e-09, -4.215520147733547e-12, -1.513113618754663e-14, -5.198851059992082e-17, -1.716657925868358e-19, -5.448232231714764e-22,
 -1.656321156551132e-24, -4.785066024914266e-27, -1.292961999057697e-29,  1.998193655584203e+00, -1.127534535315706e-05, -5.272669069343681e-08, -2.188420257251043e-10,
 -8.499546515387674e-13, -3.162013276375453e-15, -1.140674136837987e-17, -4.018778719932065e-20, -1.388963832962165e-22, -4.722766803223340e-25, -1.582785240157207e-27,
 -5.234551612168895e-30,  3.797081409477041e-04, -1.665177695326746e-06,  5.475955933150670e-09, -1.600387720747480e-11,  4.383711121592239e-14, -1.152399561066085e-16,
  2.944149571497857e-19, -7.365330553587863e-22,  1.812847540909583e-24, -4.404802044590816e-27,  1.058867958611681e-29, -2.522953343191385e-32,  3.416704504968120e-03,
 -1.496788725072232e-05,  4.911070508392293e-08, -1.429691916766892e-10,  3.892706825430232e-13, -1.014606136419486e-15,  2.562248173309957e-18, -6.313641657466993e-21,
  1.524368280246606e-23, -3.616117207151472e-26,  8.440724526614624e-29, -1.940681851356964e-31,  9.487122650156322e-03, -4.147345515110767e-05,  1.354594549446432e-07,
 -3.912427767250961e-10,  1.052330625291179e-12, -2.694961815918180e-15,  6.642687367653943e-18, -1.584608618206651e-20,  3.666520202864596e-23, -8.230047903754225e-26,
  1.788100995060732e-28, -3.743619352840977e-31,  1.858377568364451e-02, -8.098192249850386e-05,  2.626873608396469e-07, -7.496389310271947e-10,  1.978664985637461e-12,
 -4.928634321944761e-15,  1.167897830967127e-17, -2.636684122764607e-20,  5.647936687664607e-23, -1.135480889756971e-25,  2.091446243581453e-28, -3.334646506622498e-31,
  3.069578859802913e-02, -1.331927187470697e-04,  4.280590053817514e-07, -1.201700939411926e-09,  3.089883568772568e-12, -7.396448909913311e-15,  1.651631658019972e-17,
 -3.408525536118000e-20,  6.328564906783038e-23, -9.845506133290610e-26,  9.658511051520332e-29,  1.030684401121645e-31,  4.580848368982082e-02, -1.977039286451796e-04,
  6.279592326448344e-07, -1.726089612232464e-09,  4.287270240022879e-12, -9.713494227418607e-15,  1.984733018540849e-17, -3.509278735285035e-20,  4.691266810574861e-23,
 -1.513108052668185e-26, -1.906097714091462e-28,  9.195956669832405e-31,  6.390322615348058e-02, -2.740113586604795e-04,  8.579219544343709e-07, -2.297104915547925e-09,
  5.456639802026734e-12, -1.146173106665442e-14,  2.038811890332746e-17, -2.616601170633831e-20,  1.583761953387332e-24,  1.379369873853422e-25, -6.057405948296422e-28,
  1.839558050878315e-30,  8.495722845942122e-02, -3.615074428909970e-04,  1.112667814232351e-06, -2.885343110857972e-09,  6.474250779901812e-12, -1.222791412894337e-14,
  1.707001451576997e-17, -5.560010129786453e-21, -7.140892348940201e-23,  3.350699795159888e-25, -1.015263946028303e-27,  2.362398467040236e-30,  1.089433117863618e-01,
 -4.594800415638176e-04,  1.386151819567527e-06, -3.458491574847252e-09,  7.213652038376967e-12, -1.164487990165318e-14,  9.229298946495543e-18,  2.632674276307335e-20,
 -1.621501373179593e-22,  5.232418889711954e-25, -1.221877224592183e-27,  1.923505858015915e-30,  1.358296224509537e-01, -5.671112004769026e-04,  1.671622277247024e-06,
 -3.982262586168417e-09,  7.553300489661211e-12, -9.433829060598289e-15, -3.225123968880205e-18,  6.653648573242486e-20, -2.522038650437086e-22,  6.301796660483325e-25,
 -1.019829320374352e-27,  1.482093561517429e-31,  1.655793009669791e-01, -6.834759576635317e-04,  1.961692583361437e-06, -4.421465655847667e-09,  7.384738155403488e-12,
 -5.444813353358505e-15, -1.968736898814002e-17,  1.094945316645208e-19, -3.167153964888636e-22,  5.806743725528894e-25, -2.732721647956895e-28, -2.875425549062521e-30,
  1.981501010816890e-01, -8.075413047010448e-04,  2.248427623577748e-06, -4.741215216382929e-09,  6.621058846174996e-12,  3.077508924139207e-16, -3.879470530024698e-17,
  1.473929127533439e-19, -3.285617766442796e-22,  3.190187042050238e-25,  1.001630287311397e-27, -6.413980548160528e-30,  2.334939558905508e-01, -9.381654350225444e-04,
  2.523446717408791e-06, -4.908266414844285e-09,  5.205327684757585e-12,  7.618040526599349e-15, -5.845151455504651e-17,  1.710555152419262e-19, -2.642194418804375e-22,
 -1.666670451613464e-25,  2.577767489619682e-27, -9.110727702131862e-30,  2.715564879408589e-01, -1.074097440911834e-03,  2.778045176299509e-06, -4.892466090194096e-09,
  3.118541572295068e-12,  1.607395232881128e-14, -7.595229857921711e-17,  1.712650931900274e-19, -1.105859020737639e-22, -8.242997901202001e-25,  4.010471839410463e-27,
 -9.291336569912303e-30,  3.122764601220424e-01, -1.213977655144208e-03,  3.003336616488703e-06, -4.668298447395039e-09,  3.866378576887448e-13,  2.505810629017323e-14,
 -8.821215781955360e-17,  1.404573069554329e-19,  1.284362605973198e-22, -1.528969283643357e-24,  4.706408692198324e-27, -5.551325487589393e-30,  3.555851641359330e-01,
 -1.356338872996679e-03,  3.190418142678886e-06, -4.216495162943383e-09, -2.914023692566051e-12,  3.376816456358615e-14, -9.210326966307119e-17,  7.460073746997476e-20,
  4.271302984527445e-22, -2.092009934245224e-24,  4.075288169696870e-27,  2.493595353908743e-30,  4.014057434823354e-01, -1.499608735982039e-03,  3.330560356818504e-06,
 -3.525667393991656e-09, -6.653356919492873e-12,  4.125925354577982e-14, -8.488274764435359e-17, -2.500688240486954e-20,  7.366284056285185e-22, -2.292333414999930e-24,
  1.746434405126234e-27,  1.353842641733057e-29,  4.496524482333186e-01, -1.642113610325279e-03,  3.415423795484377e-06, -2.593902229379455e-09, -1.064713461230903e-11,
  4.651012506492143e-14, -6.468106669983903e-17, -1.503738657174592e-19,  9.886025595376598e-22, -1.929803753852459e-24, -2.198764785091401e-27,  2.433258711971348e-29,
  5.002298194659417e-01, -1.782084350689860e-03,  3.437302794049260e-06, -1.430248497084996e-09, -1.466020323376118e-11,  4.851292505968766e-14, -3.100180687862910e-17,
 -2.862771688802428e-19,  1.104983089421260e-21, -8.938734057574518e-25, -7.056505433383710e-27,  3.015963715017229e-29,  5.530318021550482e-01, -1.917664402195024e-03,
  3.389396836525729e-06, -5.599679369364306e-11, -1.841404467108488e-11,  4.638395914029114e-14,  1.483552655776609e-17, -4.109434473535898e-19,  1.013659810772414e-21,
  7.669990552727384e-25, -1.148562833081906e-26,  2.621946371080641e-29,  6.079407866902042e-01, -2.046920759722732e-03,  3.266108083314473e-06,  1.494363167543885e-09,
 -2.159930387369862e-11,  3.948961242351420e-14,  6.939459969786735e-17, -4.982550601522206e-19,  6.685919824782521e-22,  2.796675975879961e-24, -1.372929857375675e-26,
  9.754711407186079e-30,  6.648265810882287e-01, -2.167858370079180e-03,  3.063361870202128e-06,  3.172646934760375e-09, -2.389369617591549e-11,  2.757765542700966e-14,
  1.270586316504653e-16, -5.215988964035665e-19,  7.088648622696685e-23,  4.728626302018295e-24, -1.210314797748662e-26, -1.768153658210465e-29,  7.235453185602263e-01,
 -2.278438625295646e-03,  2.778944430462448e-06,  4.917100742482018e-09, -2.498536399039075e-11,  1.089977147984050e-14,  1.802979663480669e-16, -4.591690520424076e-19,
 -7.144606274481270e-22,  5.951403577308620e-24, -5.685997658837553e-27, -4.884151497178234e-29,  7.839383085153931e-01, -2.376602647584390e-03,  2.412848803195921e-06,
  6.653322312937964e-09, -2.460123791548553e-11, -9.693265287338815e-15,  2.203430159047906e-16, -3.001172821220855e-19, -1.552755746861396e-21,  5.851851679959166e-24,
  4.972926320326855e-27, -7.146759717402530e-29,  8.458308435169722e-01, -2.460300098746653e-03,  1.967615775275501e-06,  8.296156268152275e-09, -2.253924921554189e-11,
 -3.270597530482317e-14,  2.382923834054266e-16, -5.046270581487024e-20, -2.251276502421551e-21,  4.021872343288248e-24,  1.742918103821173e-26, -7.185800673626207e-29,
  9.090309803341012e-01, -2.527524246201911e-03,  1.448651735913752e-06,  9.752731731471036e-09, -1.870233616653033e-11, -5.602607674357445e-14,  2.266124515525061e-16,
  2.627792005009470e-19, -2.592729565814530e-21,  4.824002811174007e-25,  2.754099904456376e-26, -4.104322768766594e-29,  9.733283202419734e-01, -2.576353967169142e-03,
  8.644995733982069e-07,  1.092677341112529e-08, -1.313111907376504e-11, -7.704820335866564e-14,  1.808823449591510e-16,  5.910532820173359e-19, -2.389791364639352e-21,
 -4.154134574031327e-24,  3.052800957329448e-26,  1.835778076130319e-29,  1.038492822276158e+00, -2.605003250181276e-03,  2.270324394088129e-07,  1.172424725333828e-08,
 -6.030977611665047e-12, -9.290895501327412e-14,  1.015158405431530e-16,  8.689858629272399e-19, -1.552307888229947e-21, -8.679295314474029e-24,  2.283488132451090e-26,
  8.815165611416303e-29,  1.104273693357807e+00, -2.611878532726671e-03, -4.484661979188837e-07,  1.206028814334788e-08,  2.211781709206714e-12, -1.008352712470322e-13,
 -4.928898408958708e-18,  1.025318847649506e-18, -1.496444246026000e-22, -1.152260248580385e-23,  4.285849269408929e-27,  1.374661807671184e-28,  1.170398411090888e+00,
 -2.595643865200848e-03, -1.143378529041932e-06,  1.186719239253369e-08,  1.103066416430196e-11, -9.858689658151021e-14, -1.253229291537502e-16,  9.995334491293100e-19,
  1.556774540190167e-21, -1.123912028745125e-23, -2.045110081511090e-26,  1.346172628352353e-28,  1.236571948448465e+00, -2.555293382533090e-03, -1.836030634551667e-06,
  1.110303908332598e-08,  1.970258124696250e-11, -8.494540698851375e-14, -2.408868587515141e-16,  7.614935471508589e-19,  3.136953405255764e-21, -7.150840869164960e-24,
 -4.225706249731911e-26,  6.529206479734629e-29,  1.302476284133248e+00, -2.490229866015166e-03, -2.502219675693498e-06,  9.760238427027421e-09,  2.739902851972607e-11,
 -6.017015693173091e-14, -3.297673553515967e-16,  3.290330948843726e-19,  4.088186810957659e-21,  9.249189281604992e-26, -5.054634971428074e-26, -5.170426719057225e-29,
  1.367770297406736e+00, -2.400347267925702e-03, -3.116031729321027e-06,  7.873013954426130e-09,  3.326673150970945e-11, -2.631251600344642e-14, -3.712379044873442e-16,
 -2.233933606052524e-19,  3.995909448513430e-21,  8.354429391237231e-24, -3.836752615848040e-26, -1.634347948186901e-28,  1.432090160483963e+00, -2.286113947867336e-03,
 -3.650979076937164e-06,  5.522551500261749e-09,  3.653488070098281e-11,  1.273514779280991e-14, -3.509685310912127e-16, -7.718563246030638e-19,  2.717742642939599e-21,
  1.452586691940242e-23, -7.479181882821466e-27, -2.048586113890483e-28,  1.495050353506980e+00, -2.148652061065807e-03, -4.081462660405188e-06,  2.838359670298240e-09,
  3.663945946391026e-11,  5.156627244843127e-14, -2.661936683629278e-16, -1.169687559219735e-18,  5.161050745696745e-22,  1.573202731229348e-23,  2.991015972980860e-26,
 -1.385646585877674e-28,  1.556245434361995e+00, -1.989807120827442e-03, -4.384530317583530e-06, -5.623779984070288e-12,  3.334740173334942e-11,  8.401917568282954e-14,
 -1.290989909774418e-16, -1.291026628182540e-18, -1.945761159272858e-21,  1.083630154896961e-23,  5.541067379386415e-26,  1.081159474228879e-29,  1.615252695326658e+00,
 -1.812200368047635e-03, -4.541853976565144e-06, -2.801371079169128e-09,  2.685597814972152e-11,  1.043239256414465e-13,  3.335980607107505e-17, -1.079530137332896e-18,
 -3.796232933981698e-21,  1.458250696955368e-24,  5.424448425858672e-26,  1.579236145089487e-28,  1.671635827402884e+00, -1.619255432251361e-03, -4.541791436891429e-06,
 -5.324085787064437e-09,  1.783840915692832e-11,  1.084547030100327e-13,  1.844017405361365e-16, -5.829370944555551e-19, -4.304789133449342e-21, -8.317194199600252e-24,
  2.552356134780682e-26,  2.068910128467386e-28,  1.724949687742810e+00, -1.415190147797986e-03, -4.381336613668858e-06, -7.355961797930961e-09,  7.408350155805376e-12,
  9.536398029854114e-14,  2.869008706730456e-16,  4.704723281296015e-20, -3.250229207776428e-21, -1.380626359849076e-23, -1.466092329345100e-26,  1.236354244071539e-28,
  1.774746222746849e+00, -1.204964637729912e-03, -4.067706550825964e-06, -8.714383439854314e-09, -3.013597675650626e-12,  6.768702276055444e-14,  3.151634733398660e-16,
  6.003712581646147e-19, -1.101947687059968e-21, -1.239385883767931e-23, -4.204021233095444e-26, -2.859392288341645e-29,  1.820581537324562e+00, -9.941782468118156e-04,
 -3.619278795229900e-06, -9.280953627405987e-09, -1.192776698641305e-11,  3.153838483006541e-14,  2.649099342956222e-16,  8.900234562669772e-19,  1.146748428061171e-21,
 -5.335617797025228e-24, -4.083348521909431e-26, -1.336839648489466e-28,  1.862024019744403e+00, -7.889108740250180e-04, -3.065596013511024e-06, -9.026332831382688e-09,
 -1.804612598648273e-11, -4.776266881111373e-15,  1.567792860757008e-16,  8.359881884593403e-19,  2.474157006813269e-21,  2.832156382446497e-24, -1.583253752695777e-26,
 -1.207185476743788e-28,  1.898663334950962e+00, -5.955088244839528e-04, -2.446211773758133e-06, -8.025186109475515e-09, -2.058555591464297e-11, -3.295227807946955e-14,
  3.029982441598735e-17,  5.068858834444717e-19,  2.400239195497354e-21,  7.277129840289891e-24,  1.154461193355332e-26, -2.543815078985406e-29,  1.930119994901934e+00,
 -4.203212789243031e-04, -1.808270801651907e-06, -6.456078998461508e-09, -1.948478776025067e-11, -4.719059390252265e-14, -7.085623520587144e-17,  8.797320378628714e-20,
  1.258475014165931e-21,  6.228789417548654e-24,  2.156727308284320e-26,  5.224013558994526e-29,  1.956055115731367e+00, -2.694002855012458e-04, -1.202893842467408e-06,
 -4.583247036835367e-09, -1.546877629137279e-11, -4.614022226868438e-14, -1.168259906467181e-16, -2.168084798116335e-19, -5.860771999332437e-23,  1.982910305277268e-24,
  1.253349035125199e-26,  5.328517353612386e-29,  1.976179904903032e+00, -1.481837830188098e-04, -6.806483461834698e-07, -2.720676978238905e-09, -9.914973934429000e-12,
 -3.343782779006268e-14, -1.043141664205853e-16, -2.966803119659800e-19, -7.390602241100913e-22, -1.428955489212377e-24, -9.419282752060431e-28,  9.618693690886909e-30,
  1.990264502418866e+00, -6.118569963212004e-05, -2.865880518863600e-07, -1.183201854008020e-09, -4.531019872402284e-12, -1.643856667366604e-14, -5.704846755503433e-17,
 -1.900922574158266e-19, -6.080372919665487e-22, -1.859560377038149e-24, -5.388534910121052e-27, -1.452792069051724e-29,  1.998147693610903e+00, -1.170789938843952e-05,
 -5.543652682708864e-08, -2.329624884940353e-10, -9.160263448841014e-13, -3.449796573138506e-15, -1.259687074978579e-17, -4.491718733172653e-20, -1.570957336802697e-22,
 -5.404466739440805e-25, -1.832220505444123e-27, -6.128262549706161e-30,  3.731338457722697e-04, -1.622126482978037e-06,  5.288042935696620e-09, -1.532054479959923e-11,
  4.160133449374042e-14, -1.084150606365298e-16,  2.745809189773463e-19, -6.809794773900171e-22,  1.661638467405404e-24, -4.002639557903963e-27,  9.539072885536018e-30,
 -2.253391615957647e-32,  3.357608009061663e-03, -1.458175977041415e-05,  4.743178579033671e-08, -1.368999156955647e-10,  3.695794598900599e-13, -9.551796226749024e-16,
  2.392104223364329e-18, -5.846037356960237e-21,  1.400065114692820e-23, -3.294963070477019e-26,  7.631489084500279e-29, -1.741459245123216e-31,  9.323366845144220e-03,
 -4.040827697170775e-05,  1.308638143413610e-07, -3.748281670506875e-10,  9.999903687768841e-13, -2.540731711757480e-15,  6.214987213034593e-18, -1.471885597587809e-20,
  3.382725270660622e-23, -7.546719563185841e-26,  1.631033210313621e-28, -3.401348121302285e-31,  1.826399476891867e-02, -7.891587547741121e-05,  2.538784412621801e-07,
 -7.187538907466078e-10,  1.882836493663356e-12, -4.656997591817245e-15,  1.096540633607444e-17, -2.462331896851092e-20,  5.253873260556825e-23, -1.054703853008404e-25,
  1.948735148133112e-28, -3.152145687617101e-31,  3.016977650972269e-02, -1.298250990050473e-04,  4.139304101632455e-07, -1.153425017276529e-09,  2.945842370076829e-12,
 -7.011284365029018e-15,  1.558975392554009e-17, -3.211607100088425e-20,  5.981177981021194e-23, -9.451414857055397e-26,  1.001499762438964e-28,  6.040626588277479e-32,
  4.502758576720763e-02, -1.927619555459137e-04,  6.076514072645179e-07, -1.659021897588255e-09,  4.097684998659967e-12, -9.248780397327496e-15,  1.888565708055659e-17,
 -3.360169229614160e-20,  4.624008938235819e-23, -2.198683546050666e-26, -1.531491952476512e-28,  7.862099211170879e-31,  6.282073496273248e-02, -2.672567771052639e-04,
  8.308730535654433e-07, -2.211606218519360e-09,  5.232239033187409e-12, -1.098119784102698e-14,  1.965689417452084e-17, -2.604040134716963e-20,  6.132301231760436e-24,
  1.152643454010104e-25, -5.293834662737315e-28,  1.634686736916314e-30,  8.352878454859791e-02, -3.527428542923408e-04,  1.078657226501838e-06, -2.783689362778092e-09,
  6.233775402506424e-12, -1.182034928811708e-14,  1.688410171402240e-17, -7.659733266515101e-21, -6.005285592246028e-23,  2.964821468160023e-25, -9.155046904473914e-28,
  2.173362748900926e-30,  1.071273099506659e-01, -4.485548901103402e-04,  1.345334785288765e-06, -3.344924047710284e-09,  6.983026223525569e-12, -1.141510020430339e-14,
  9.896569972176974e-18,  2.143005793915574e-20, -1.441728486079811e-22,  4.760520371072773e-25, -1.137844526421473e-27,  1.892147925106337e-30,  1.335876238350568e-01,
 -5.539273307289936e-04,  1.624554004801737e-06, -3.862922779259523e-09,  7.363996158190330e-12, -9.489767064594784e-15, -1.471735199795832e-18,  5.882109033217741e-20,
 -2.302493292643070e-22,  5.896008957903713e-25, -1.007150632604669e-27,  4.172866482069498e-31,  1.628764510108931e-01, -6.679926471371581e-04,  1.909340256417034e-06,
 -4.304205665796625e-09,  7.271359416271517e-12, -5.881646055092858e-15, -1.676028440632250e-17,  9.969176191964629e-20, -2.960366039214074e-22,  5.674052880402588e-25,
 -3.855971490177788e-28, -2.245770276430715e-30,  1.949555529152033e-01, -7.897796609688104e-04,  2.192168705659971e-06, -4.635278241052930e-09,  6.618231327709932e-12,
 -5.749752205661022e-16, -3.481312087833248e-17,  1.370698872939481e-19, -3.164215090479443e-22,  3.537058044698606e-25,  7.391647615834310e-28, -5.529767198026679e-30,
  2.297812982831900e-01, -9.182120311298212e-04,  2.465052017303923e-06, -4.823836894983610e-09,  5.344043126975355e-12,  6.271718561224329e-15, -5.378109502961806e-17,
  1.625236237550947e-19, -2.684578506360222e-22, -7.132978871272698e-26,  2.195120510546467e-27, -8.283740864248947e-30,  2.673041763015410e-01, -1.052107045833456e-03,
  2.719645255631033e-06, -4.840095011553143e-09,  3.422178317427215e-12,  1.430821602329725e-14, -7.121066343735242e-17,  1.672817134181502e-19, -1.374709726904180e-22,
 -6.719778195794060e-25,  3.607815275166671e-27, -8.991387171076498e-30,  3.074682482943994e-01, -1.190174898024618e-03,  2.947370321768591e-06, -4.658216628448959e-09,
  8.669498118733556e-13,  2.298862301044316e-14, -8.422983235671880e-17,  1.437224228705581e-19,  7.672103417455337e-23, -1.345822766349355e-24,  4.445835724870121e-27,
 -6.249643183115525e-30,  3.502105338283045e-01, -1.331018661686567e-03,  3.139562354398964e-06, -4.257836001251613e-09, -2.260588300517966e-12,  3.158422798346248e-14,
 -8.983419122812035e-17,  8.709554924482049e-20,  3.547731597592930e-22, -1.927395611209522e-24,  4.141403963075575e-27,  5.677430458132844e-31,  3.954603270802818e-01,
 -1.473135232881537e-03,  3.287640497851708e-06, -3.625630502354147e-09, -5.848586979240555e-12,  3.921625319587285e-14, -8.526523432017975e-17, -2.740562244622649e-21,
  6.554974448104980e-22, -2.211431836220441e-24,  2.277603129070634e-27,  1.064979510728674e-29,  4.431384394401837e-01, -1.614917553148466e-03,  3.383305263520251e-06,
 -2.756900475349313e-09, -9.732778414390698e-12,  4.491076388312269e-14, -6.845919423782995e-17, -1.198650831459356e-19,  9.177966142889555e-22, -1.997211931133609e-24,
 -1.193194719677821e-27,  2.137496830683966e-29,  4.931563646763562e-01, -1.754658494376847e-03,  3.418764312878245e-06, -1.657092761044068e-09, -1.369801392597646e-11,
  4.767665656704533e-14, -3.852774630968089e-17, -2.514844877534587e-19,  1.068038769332029e-21, -1.150039410718967e-24, -5.763619932375828e-27,  2.853799247546370e-29,
  5.454153636619915e-01, -1.890556853358916e-03,  3.386987792261215e-06, -3.431845753828256e-10, -1.748371794146666e-11,  4.660562257293116e-14,  3.786761654358654e-18,
 -3.781509288149678e-19,  1.033283983858876e-21,  3.310553967350410e-25, -1.030297511398625e-26,  2.739913962538226e-29,  5.998054667379636e-01, -2.020725980046074e-03,
  3.281993251566734e-06,  1.155178435372578e-09, -2.079397408809156e-11,  4.099017600635224e-14,  5.575737247754059e-17, -4.753542921396087e-19,  7.595042494271386e-22,
  2.257566365160130e-24, -1.319139535488379e-26,  1.453111938788289e-29,  6.562043934004145e-01, -2.143205644180205e-03,  3.099158562982207e-06,  2.794920946241135e-09,
 -2.331283000215552e-11,  3.045221560033395e-14,  1.125105367402096e-16, -5.167016582334110e-19,  2.322365023988903e-22,  4.231263309987470e-24, -1.270868905001263e-26,
 -9.952111506590363e-30,  7.144763912989485e-01, -2.255977826962058e-03,  2.835558987806646e-06,  4.519309575370414e-09, -2.472515096208752e-11,  1.507025467774286e-14,
  1.671530269248795e-16, -4.786517399944931e-19, -5.048001449448170e-22,  5.683379813414776e-24, -7.655428600409956e-27, -4.064081085824392e-29,  7.744709996944356e-01,
 -2.356987202106117e-03,  2.490321477240740e-06,  6.258435955509525e-09, -2.474292975077429e-11, -4.511291199552127e-15,  2.112760061067944e-16, -3.464024834625449e-19,
 -1.339254769977633e-21,  5.989177526556935e-24,  1.928123788654455e-27, -6.670035779965379e-29,  8.360217467641914e-01, -2.444167135416607e-03,  2.064985301510590e-06,
  7.930605432818116e-09, -2.313633448615845e-11, -2.701191574815174e-14,  2.358935453362064e-16, -1.200586444783450e-19, -2.094710691551566e-21,  4.654890420066564e-24,
  1.420324890785769e-26, -7.439660959957863e-29,  8.989447956931392e-01, -2.515472071454968e-03,  1.563853078849730e-06,  9.444828016429191e-09, -1.976792308724812e-11,
 -5.050843584840640e-14,  2.328128314105748e-16,  1.802985865856661e-19, -2.556001317702447e-21,  1.544387721505661e-24,  2.547479440334457e-26, -5.251495452795570e-29,
  9.630375616064598e-01, -2.568917172676146e-03,  9.943101941299601e-07,  1.070458913365580e-08, -1.462737608531085e-11, -7.251720438635258e-14,  1.963404160031683e-16,
  5.124241163351598e-19, -2.517213505025006e-21, -2.922136887878495e-24,  3.094239236241307e-26,  5.892571109420430e-31,  1.028077330336302e+00, -2.602626007544676e-03,
  3.670835638437691e-07,  1.161302672353001e-08, -7.862852261383856e-12, -9.018649095846233e-14,  1.251063378044669e-16,  8.144963240094126e-19, -1.847430069613206e-21,
 -7.693123521520967e-24,  2.635155875529120e-26,  7.139135794198459e-29,  1.093819920996889e+00, -2.614886920137483e-03, -3.035969546168416e-07,  1.207954632641760e-08,
  1.962143540024291e-13, -1.006099806037734e-13,  2.365093230549493e-17,  1.013938039763252e-18, -5.599278772821285e-22, -1.123171418975063e-23,  1.021359564686969e-26,
  1.312965832231606e-28,  1.159998447517170e+00, -2.604218418723872e-03, -9.999788470544401e-07,  1.202775530660484e-08,  9.031143158449754e-12, -1.012535535572877e-13,
 -9.670044112594837e-17,  1.042730426990303e-18,  1.138902408407351e-21, -1.193508266997580e-23, -1.426538071213873e-26,  1.458189126875001e-28,  1.226322249652184e+00,
 -2.569443453752407e-03, -1.700959778934386e-06,  1.140438245203201e-08,  1.794764490045558e-11, -9.045973592393097e-14, -2.182006755494294e-16,  8.574370521068935e-19,
  2.849864135822379e-21, -8.775592603761961e-24, -3.878387442788330e-26,  9.227450961697022e-29,  1.292476081329644e+00, -2.509771773676256e-03, -2.382507603873299e-06,
  1.018856903986035e-08,  2.611730382482104e-11, -6.795924643187487e-14, -3.187252257134322e-16,  4.595142041861585e-19,  4.054654792382574e-21, -1.966043753716658e-24,
 -5.215712186123374e-26, -2.106070613796419e-29,  1.358119662894146e+00, -2.424888611689129e-03, -3.018380895190017e-06,  8.400585698498860e-09,  3.265095325157938e-11,
 -3.528256970348556e-14, -3.756597289793311e-16, -9.102211998904844e-20,  4.267349811599384e-21,  6.680235293057016e-24, -4.522339518166213e-26, -1.471281395297236e-28,
  1.422887722792303e+00, -2.315046744174992e-03, -3.581194207318711e-06,  6.108682387057300e-09,  3.670365346988370e-11,  4.062867362254328e-15, -3.712848603831185e-16,
 -6.765972581199286e-19,  3.233082454465509e-21,  1.404276778481282e-23, -1.675531887152599e-26, -2.157625409335949e-28,  1.486390671745468e+00, -2.181157479081482e-03,
 -4.043852077245614e-06,  3.432483413699654e-09,  3.760425747581019e-11,  4.478700688264410e-14, -2.986269890778028e-16, -1.143892187558529e-18,  1.102429870106456e-21,
  1.679616862044055e-23,  2.304321181607290e-26, -1.733713640917322e-28,  1.548216065938521e+00, -2.024874436262374e-03, -4.381341578911654e-06,  5.411969583841223e-10,
  3.499383866374239e-11,  8.048035484389211e-14, -1.660577394097510e-16, -1.346621207617887e-18, -1.515740705182517e-21,  1.305154314948836e-23,  5.507709755407473e-26,
 -2.683919358025427e-29,  1.607931021808694e+00, -1.848662202042932e-03, -4.572823289583657e-06, -2.354950622807625e-09,  2.894794395909544e-11,  1.047481754945721e-13,
  1.443205227816904e-18, -1.199737493083817e-18, -3.703038333788753e-21,  3.763261344361268e-24,  6.089952274984941e-26,  1.432842945309778e-28,  1.665085739449594e+00,
 -1.655840301432282e-03, -4.603895635885308e-06, -5.021083861286244e-09,  2.005035593870194e-11,  1.126686426306194e-13,  1.661074533818659e-16, -7.252658521232270e-19,
 -4.583584243801880e-21, -7.108414947468986e-24,  3.505133641802522e-26,  2.255288979217520e-28,  1.719218269751682e+00, -1.450591764417177e-03, -4.468832800830929e-06,
 -7.221795609331239e-09,  9.384529970886223e-12,  1.022531932128967e-13,  2.866866287414163e-16, -6.501443145778766e-20, -3.756404957393552e-21, -1.427347102476057e-23,
 -8.435899313026990e-27,  1.598077193442015e-28,  1.769860617579796e+00, -1.237925294657795e-03, -4.172522437363015e-06, -8.751354467401871e-09, -1.582878729924804e-12,
  7.544826229405490e-14,  3.314107941990863e-16,  5.576434481408175e-19, -1.578638912425809e-21, -1.409396650395582e-23, -4.278879396545977e-26, -4.366354803391765e-30,
  1.816546206009934e+00, -1.023581157075368e-03, -3.731773346750225e-06, -9.466397769821188e-09, -1.123138169707079e-11,  3.819922873571520e-14,  2.903131434081631e-16,
  9.233192533984859e-19,  9.238340373392224e-22, -7.088139376877472e-24, -4.682455717279326e-26, -1.380535746732186e-28,  1.858818633773230e+00, -8.138738205468025e-04,
 -3.175646903547016e-06, -9.315622488950524e-09, -1.810208165417738e-11, -7.236358575469300e-16,  1.813097718573436e-16,  9.166595375582962e-19,  2.563377070539289e-21,
  2.086221701004338e-24, -2.162593254463255e-26, -1.429196389953292e-28,  1.896241542379965e+00, -6.154693766846415e-04, -2.544511827388879e-06, -8.359782872797028e-09,
 -2.123613400689194e-11, -3.204584417778759e-14,  4.560794161459178e-17,  5.879718420451589e-19,  2.670218772093417e-21,  7.712143487208311e-24,  1.009111325514319e-26,
 -4.123077692783584e-29,  1.928409279213927e+00, -4.351027093172121e-04, -1.887645731855785e-06, -6.775477572091587e-09, -2.044538119187225e-11, -4.885682064615684e-14,
 -6.779426520554518e-17,  1.320032177962164e-19,  1.498799136398445e-21,  7.138019593169026e-24,  2.390627055005660e-26,  5.388521977869088e-29,  1.954957913927373e+00,
 -2.792477107390518e-04, -1.259408761099973e-06, -4.838284301102034e-09, -1.642011149852249e-11, -4.901703608366107e-14, -1.229114356635413e-16, -2.174402707018730e-19,
  2.238993056809630e-23,  2.533764188588945e-24,  1.507630098602744e-26,  6.249916202781206e-29,  1.975576068750477e+00, -1.537623108796107e-04, -7.142708248437466e-07,
 -2.884805512397180e-09, -1.060945277525934e-11, -3.604377258187130e-14, -1.129600943891800e-16, -3.211596993802359e-19, -7.910693107907953e-22, -1.457111927611237e-24,
 -4.381327455200409e-28,  1.343343280653815e-29,  1.990015082514692e+00, -6.353645565269253e-05, -3.012325475106006e-07, -1.258404583877723e-09, -4.873925598335558e-12,
 -1.787386293153504e-14, -6.265381938484089e-17, -2.106634374977327e-19, -6.790198642550835e-22, -2.088393907321049e-24, -6.066009361304117e-27, -1.629475317929371e-29,
  1.998099956964966e+00, -1.216282831424652e-05, -5.832234648654725e-08, -2.481877418502852e-10, -9.881504114848121e-13, -3.767800200758355e-15, -1.392795976770708e-17,
 -5.027023789059805e-20, -1.779386935379900e-22, -6.194270128893557e-25, -2.124504867156241e-27, -7.187147626153298e-30,  3.667287999264642e-04, -1.580546372576258e-06,
  5.108119714645528e-09, -1.467191818038760e-11,  3.949741873724909e-14, -1.020480497589291e-16,  2.562367593719967e-19, -6.300408207966635e-22,  1.524179255208111e-24,
 -3.640182600089810e-27,  8.601164340002853e-30, -2.014577353097397e-32,  3.300029614188587e-03, -1.420877758631153e-05,  4.582384596593192e-08, -1.311364085303263e-10,
  3.510369707061080e-13, -8.996838388496349e-16,  2.234513260844890e-18, -5.416421019723120e-21,  1.286761371929539e-23, -3.004490945166433e-26,  6.905045035118728e-29,
 -1.563920643032192e-31,  9.163799450316319e-03, -3.937909002156066e-05,  1.264602244036931e-07, -3.592268718353686e-10,  9.506345707802073e-13, -2.396397700944107e-15,
  5.817614236896584e-18, -1.367862254538697e-20,  3.122434684982265e-23, -6.923302568590894e-26,  1.488311750574396e-28, -3.091005426098117e-31,  1.795233941056574e-02,
 -7.691884298943082e-05,  2.454311189437074e-07, -6.893595586132671e-10,  1.792273360810046e-12, -4.401914750113818e-15,  1.029893052172793e-17, -2.300135285106010e-20,
  4.887881396367088e-23, -9.794747281975434e-26,  1.814044200195427e-28, -2.970518847999186e-31,  2.965701245728119e-02, -1.265682293820241e-04,  4.003675484007706e-07,
 -1.107393317708457e-09,  2.809286488991700e-12, -6.647708107436425e-15,  1.471679364344001e-17, -3.025575649304367e-20,  5.648192026720411e-23, -9.046572809645675e-26,
  1.020187683374630e-28,  2.574829330262886e-32,  4.426613583705210e-02, -1.879792766682850e-04,  5.881304969644566e-07, -1.594914432466119e-09,  3.917166600657177e-12,
 -8.806648363847181e-15,  1.796539821559124e-17, -3.213579063848972e-20,  4.534630901144793e-23, -2.745627011852342e-26, -1.211672274431775e-28,  6.702007833223383e-31,
  6.176483572847762e-02, -2.607145431323287e-04,  8.048289086542447e-07, -2.129622000510905e-09,  5.017273801688103e-12, -1.051815608982959e-14,  1.893110567940083e-17,
 -2.578172496250582e-20,  9.917485527448067e-24,  9.547176935042972e-26, -4.615900104033502e-28,  1.450038103220167e-30,  8.213486245692250e-02, -3.442455358070962e-04,
  1.045843666266678e-06, -2.685818272059056e-09,  6.001402147557343e-12, -1.141791205441797e-14,  1.664428074256154e-17, -9.417534822335971e-21, -5.001610706874124e-23,
  2.617206746332943e-25, -8.238854214011450e-28,  1.992624792789122e-30,  1.053543641912745e-01, -4.379508860653205e-04,  1.305858575605973e-06, -3.235008944204730e-09,
  6.757145371368822e-12, -1.117088782916610e-14,  1.043453686415754e-17,  1.708211062357172e-20, -1.278342852917388e-22,  4.321892045192229e-25, -1.055680838878867e-27,
  1.839548532056928e-30,  1.313976166028311e-01, -5.411143304112235e-04,  1.578899607113475e-06, -3.746618577355385e-09,  7.173976786000290e-12, -9.506138069146602e-15,
  7.523934423120103e-20,  5.178498661944164e-20, -2.097438172679260e-22,  5.497475332089349e-25, -9.839993724788398e-28,  6.258733663814561e-31,  1.602347055270585e-01,
 -6.529225582254794e-04,  1.858383888796945e-06, -4.188825903868712e-09,  7.149924675186305e-12, -6.251448154057746e-15, -1.409849096709806e-17,  9.054225595717746e-20,
 -2.759099425388848e-22,  5.501703025138931e-25, -4.722187043906435e-28, -1.705567347641988e-30,  1.918311592293571e-01, -7.724630056826837e-04,  2.137180193956768e-06,
 -4.529522647681687e-09,  6.598681686140561e-12, -1.365566861520123e-15, -3.111496861523555e-17,  1.271533785918583e-19, -3.032123239378988e-22,  3.786483345409463e-25,
  5.138076748741294e-28, -4.727094363477052e-30,  2.261475264434600e-01, -8.987216964976293e-04,  2.407682919052681e-06, -4.737397330794599e-09,  5.456933614112909e-12,
  5.034607690277621e-15, -4.935097195732580e-17,  1.539081343861447e-19, -2.695308864609501e-22,  9.425621247990834e-27,  1.848555951601565e-27, -7.473056670660745e-30,
  2.631388959371161e-01, -1.030581256363399e-03,  2.661901791568799e-06, -4.783142119313739e-09,  3.691628813248186e-12,  1.265484828554772e-14, -6.659180507694874e-17,
  1.625226681666669e-19, -1.591588800245499e-22, -5.354651836794673e-25,  3.220763227560184e-27, -8.587271307737712e-30,  3.027543529810728e-01, -1.166819259802363e-03,
  2.891569769862814e-06, -4.640775714811458e-09,  1.306834322988941e-12,  2.101563163737081e-14, -8.017827554859074e-17,  1.454360767102885e-19,  3.140474608552845e-23,
 -1.173639428143025e-24,  4.160017011105696e-27, -6.705279019775662e-30,  3.449363677779679e-01, -1.306107106608294e-03,  3.088271774357261e-06, -4.289068229947999e-09,
 -1.650260051935212e-12,  2.945869138910532e-14, -8.724678046074384e-17,  9.737010101641178e-20,  2.883702165480411e-22, -1.761733097957766e-24,  4.130086761040630e-27,
 -1.030153808139061e-30,  3.896201106806252e-01, -1.447009671092116e-03,  3.243596990069537e-06, -3.713044463758045e-09, -5.084719847015747e-12,  3.717126411141481e-14,
 -8.506014504355875e-17,  1.698002327244911e-20,  5.776314796788537e-22, -2.111745254593149e-24,  2.687700797784248e-27,  8.037805593960020e-30,  4.367326889392471e-01,
 -1.587986021899901e-03,  3.349317460044745e-06, -2.905529560808656e-09, -8.851248328544659e-12,  4.323072058603832e-14, -7.141510786714916e-17, -9.165340926004485e-20,
  8.452566616784034e-22, -2.026994651092402e-24, -3.172267094571661e-28,  1.845350610898156e-29,  4.861922998238863e-01, -1.727391574055634e-03,  3.397595487885505e-06,
 -1.868685284145202e-09, -1.275427802899398e-11,  4.667131411040746e-14, -4.509735777804373e-17, -2.180117420765586e-19,  1.022785084670521e-21, -1.356032886382630e-24,
 -4.550534082450833e-27,  2.655162601958617e-29,  5.379072953508732e-01, -1.863482108596696e-03,  3.381221906466031e-06, -6.154657575593705e-10, -1.655153496694380e-11,
  4.657319072256611e-14, -6.337314817416944e-18, -3.449723231175364e-19,  1.038076016828342e-21, -5.678276063477776e-26, -9.086062359437434e-27,  2.779505312346424e-29,
  5.917751546011917e-01, -1.994420178674414e-03,  3.293886448070110e-06,  8.291015107015194e-10, -1.996185240297631e-11,  4.217145175809091e-14,  4.279920969707894e-17,
 -4.498503125183635e-19,  8.314438513077771e-22,  1.743884495798960e-24, -1.246508151481807e-26,  1.832355230899353e-29,  6.476813608847639e-01, -2.118284513344485e-03,
  3.130480142963488e-06,  2.426929832319128e-09, -2.267795011622430e-11,  3.297983371432946e-14,  9.816912804239691e-17, -5.069317222362335e-19,  3.753255793806828e-22,
  3.716276163495607e-24, -1.298963817446636e-26, -2.947256480416293e-30,  7.054981829399318e-01, -2.233083129140889e-03,  2.887427728116699e-06,  4.126331781067426e-09,
 -2.438472336364534e-11,  1.891946183705701e-14,  1.535549452967983e-16, -4.915941692983517e-19, -3.061190969327353e-22,  5.343841043429889e-24, -9.261113623382302e-27,
 -3.235245514152655e-29,  7.650833621626882e-01, -2.336770960523169e-03,  2.563045293213655e-06,  5.862099394494470e-09, -2.478325915523147e-11,  4.382985831844130e-16,
  2.010092372244933e-16, -3.857996256174212e-19, -1.122948170603700e-21,  6.009297107154622e-24, -8.782916855483395e-28, -6.068446257761834e-29,  8.262787117773875e-01,
 -2.427272916092570e-03,  2.157914643697067e-06,  7.556408502491413e-09, -2.362026911836888e-11, -2.139822623690003e-14,  2.316194097375495e-16, -1.843049414793164e-19,
 -1.917699751280695e-21,  5.157301538644470e-24,  1.091497764964411e-26, -7.471966554692100e-29,  8.889086391739029e-01, -2.502513346747045e-03,  1.675260946555455e-06,
  9.120765036114991e-09, -2.072185533079917e-11, -4.486953178164081e-14,  2.367258365596735e-16,  9.958808206497707e-20, -2.482644872211015e-21,  2.514289432103241e-24,
  2.295331235752887e-26, -6.170922811306620e-29,  9.527786096675226e-01, -2.560452958030191e-03,  1.121314016549075e-06,  1.045920910484822e-08, -1.602948371837344e-11,
 -6.764205080918728e-14,  2.095464668772219e-16,  4.304287562975417e-19, -2.600171664412836e-21, -1.688958702970899e-24,  3.059401627085418e-26, -1.622188608655559e-29,
  1.017673579034489e+00, -2.599134188432580e-03,  5.056260769645248e-07,  1.147296201807291e-08, -9.634744865559017e-12, -8.691719687790240e-14,  1.470444354524069e-16,
  7.511565859689267e-19, -2.104700376635063e-21, -6.581528186857187e-24,  2.909507101785791e-26,  5.312301418530509e-29,  1.083356433684621e+00, -2.616735976859486e-03,
 -1.586898385310217e-07,  1.206662861150939e-08, -1.808021461041685e-12, -9.970407026204236e-14,  5.173019053493457e-17,  9.896408726519736e-19, -9.555476624421559e-22,
 -1.071033363081006e-23,  1.578171508077569e-26,  1.211825796826534e-28,  1.149566491554200e+00, -2.611638615449732e-03, -8.548460021492861e-07,  1.215593692696122e-08,
  6.985248479811324e-12, -1.032202890822425e-13, -6.705906532582665e-17,  1.072203260591624e-18,  7.005360007028541e-22, -1.237509649151219e-23, -7.687437817068460e-27,
  1.523878960205744e-28,  1.216018133922114e+00, -2.582498979172901e-03, -1.562444817963325e-06,  1.167679502337016e-08,  1.608807866828495e-11, -9.539845058989696e-14,
 -1.929652789181575e-16,  9.432869426850101e-19,  2.507065056621333e-21, -1.023829865145534e-23, -3.417220759810424e-26,  1.168651558394616e-28,  1.282399658334005e+00,
 -2.528335785262197e-03, -2.257783701040030e-06,  1.059516144130975e-08,  2.468274246355487e-11, -7.543967327332924e-14, -3.040558613133143e-16,  5.877268193759059e-19,
  3.946187411412466e-21, -4.061320450838108e-24, -5.236753858664973e-26,  1.175833222287341e-29,  1.348372465260826e+00, -2.448623606493097e-03, -2.914464250271986e-06,
  8.916865292891903e-09,  3.185501772912568e-11, -4.431334647195471e-14, -3.762629828509359e-16,  4.901946589781635e-20,  4.473773099984794e-21,  4.748044202186334e-24,
 -5.122115262858631e-26, -1.244802198760045e-28,  1.413570715066492e+00, -2.343393094686290e-03, -3.504365371836070e-06,  6.696100520954132e-09,  3.669433031179102e-11,
 -5.063153107482462e-15, -3.887061935541781e-16, -5.651980206407978e-19,  3.724253429965135e-21,  1.318092872365945e-23, -2.636731071161801e-26, -2.199603533543143e-28,
  1.477601615591181e+00, -2.213333242645022e-03, -3.999023999105938e-06,  4.040917233900744e-09,  3.842575578363315e-11,  3.724016244359317e-14, -3.300700019265155e-16,
 -1.098777459317194e-18,  1.721754578074282e-21,  1.755547767572523e-23,  1.468328951961508e-26, -2.061518181422774e-28,  1.540046521456244e+00, -2.059889552256278e-03,
 -4.371435426546272e-06,  1.113745781753573e-09,  3.656051133754491e-11,  7.603747273167501e-14, -2.043685355864604e-16, -1.387185058796834e-18, -1.006624574860471e-21,
  1.521882793697378e-23,  5.297779033767024e-26, -6.929510127922539e-29,  1.600463040177512e+00, -1.885349792976962e-03, -4.598234586329011e-06, -1.875033590078593e-09,
  3.104046422461504e-11,  1.043664527245359e-13, -3.378461737168587e-17, -1.315584959143311e-18, -3.522248415095890e-21,  6.319223632819740e-24,  6.673215146422928e-26,
  1.204228886546858e-28,  1.658388342238172e+00, -1.692906852219792e-03, -4.662148764698459e-06, -4.682041784976833e-09,  2.234186305255257e-11,  1.163947316507224e-13,
  1.437101360469601e-16, -8.757447137271500e-19, -4.811817327252791e-21, -5.503427819661735e-24,  4.529862728190867e-26,  2.393139276598571e-28,  1.713343856324363e+00,
 -1.486686362571344e-03, -4.554524737486607e-06, -7.054909648933763e-09,  1.149817895148291e-11,  1.090977675251608e-13,  2.831057258481782e-16, -1.934916115587460e-19,
 -4.274527160107570e-21, -1.445904351778767e-23, -5.610432824668704e-28,  1.984637246969035e-28,  1.764841490486169e+00, -1.271725852199160e-03, -4.277639437352744e-06,
 -8.764171445492282e-09,  6.858307838151850e-15,  8.358330056330338e-14,  3.462389491694335e-16,  4.986786788850132e-19, -2.116798393926659e-21, -1.580074527202121e-23,
 -4.232432337790728e-26,  2.664736027593510e-29,  1.812391449328707e+00, -1.053892725311909e-03, -3.846421870702105e-06, -9.639600585086131e-09, -1.039561166381243e-11,
  4.548007103189925e-14,  3.165389529427892e-16,  9.484257766395609e-19,  6.334791350717036e-22, -9.083014101703228e-24, -5.292077437540448e-26, -1.382505501646821e-28,
  1.855511613202615e+00, -8.397310689407231e-04, -3.289171860753003e-06, -9.605126255022547e-09, -1.807091286611963e-11,  3.945128558140558e-15,  2.081346589150662e-16,
  9.997096034920994e-19,  2.621332121805786e-21,  1.088503821554793e-24, -2.843358540674477e-26, -1.667494228094683e-28,  1.893738309122116e+00, -6.362325654048823e-04,
 -2.646888832616592e-06, -8.704623104702209e-09, -2.186472046481539e-11, -3.074378030084858e-14,  6.330968260232995e-17,  6.779350688248430e-19,  2.954634775791821e-21,
  8.074004460482655e-24,  7.858343003384328e-27, -6.095536679757059e-29,  1.926638143159002e+00, -4.505347340692776e-04, -1.970946747504746e-06, -7.110507808903756e-09,
 -2.143845980361288e-11, -5.043386611973159e-14, -6.338673940165458e-17,  1.842654968558336e-19,  1.773553666515433e-21,  8.141876738007978e-24,  2.628828985495872e-26,
  5.410972625803498e-29,  1.953820398429755e+00, -2.895597603020999e-04, -1.319077379488885e-06, -5.109011154817348e-09, -1.743044332761662e-11, -5.203980092779880e-14,
 -1.289751580000564e-16, -2.151423995753973e-19,  1.251501846367246e-22,  3.194806370129568e-24,  1.805216396940559e-26,  7.298404409502866e-29,  1.974949367781057e+00,
 -1.596178896730333e-04, -7.499312729715310e-07, -3.060474169903337e-09, -1.135818202927572e-11, -3.886563357305993e-14, -1.223148679456400e-16, -3.473153611473988e-19,
 -8.436862539284870e-22, -1.461471987539643e-24,  2.553960244130799e-28,  1.827935504534943e-29,  1.989756019424485e+00, -6.600807286978040e-05, -3.168133663619339e-07,
 -1.339330962697229e-09, -5.246930548818620e-12, -1.945086402553655e-14, -6.886824108027200e-17, -2.336432532159421e-19, -7.587474245040650e-22, -2.345932222162503e-24,
 -6.825042987552090e-27, -1.823571627776407e-29,  1.998050353244745e+00, -1.264159472213754e-05, -6.139800874417156e-08, -2.646196489441017e-10, -1.066966553683920e-12,
 -4.119626668130475e-15, -1.541871592012414e-17, -5.633810669136972e-20, -2.018471212333683e-22, -7.110862242113755e-25, -2.467605459854386e-27, -8.444038171901484e-30,
  3.604872442510150e-04, -1.540375076605434e-06,  4.935782163157622e-09, -1.405595893617818e-11,  3.751655361027620e-14, -9.610466857285773e-17,  2.392592115847457e-19,
 -5.832991238686654e-22,  1.399117771348297e-24, -3.313222490274849e-27,  7.762262775576621e-30, -1.802787271542073e-32,  3.243917852030517e-03, -1.384838723297879e-05,
  4.428332412110183e-08, -1.256609033477797e-10,  3.335675289661428e-13, -8.478298894440748e-16,  2.088459284193712e-18, -5.021443349410310e-21,  1.183409879128391e-23,
 -2.741572446381692e-26,  6.252409816878217e-29, -1.405580485076595e-31,  9.008279512880876e-03, -3.838439613745200e-05,  1.222392054606016e-07, -3.443926843843221e-10,
  9.040723949576950e-13, -2.261260331733618e-15,  5.448234663987723e-18, -1.271819878313779e-20,  2.883591626328155e-23, -6.354330490177931e-26,  1.358597589133654e-28,
 -2.809642573984989e-31,  1.764853922470479e-02, -7.498800240307270e-05,  2.373280001311870e-07, -6.613742772291822e-10,  1.706655541866445e-12, -4.162295335041844e-15,
  9.676270096814419e-18, -2.149227335518583e-20,  4.548021433854286e-23, -9.094741867888468e-26,  1.687283161018053e-28, -2.792015776647137e-31,  2.915706232423470e-02,
 -1.234176897293938e-04,  3.873441939893470e-07, -1.063489460881444e-09,  2.679796780128714e-12, -6.304469736600773e-15,  1.389445238673679e-17, -2.849965403065369e-20,
  5.329880086375767e-23, -8.637098681748618e-26,  1.025150616348198e-28, -2.172834020288591e-33,  4.352350909156686e-02, -1.833497363514220e-04,  5.693618344376074e-07,
 -1.533625706709237e-09,  3.745273288417715e-12, -8.386113405428895e-15,  1.708575628669584e-17, -3.070140314995693e-20,  4.427746835570111e-23, -3.174387430437085e-26,
 -9.394646088682029e-29,  5.694645478004880e-31,  6.073469487297004e-02, -2.543767848490739e-04,  7.797482402460522e-07, -2.051004083253847e-09,  4.811395870662536e-12,
 -1.007243330007937e-14,  1.821415240916446e-17, -2.541281539287493e-20,  1.303704156025810e-23,  7.823404169389459e-26, -4.015052688073116e-28,  1.284032324466307e-30,
  8.077441197199971e-02, -3.360060905873114e-04,  1.014182515839058e-06, -2.591601092284242e-09,  5.777016276306002e-12, -1.102178598387298e-14,  1.635955461535542e-17,
 -1.087349111645219e-20, -4.116669736737748e-23,  2.304676299128334e-25, -7.400147005702719e-28,  1.821300983407688e-30,  1.036232110960129e-01, -4.276574768368274e-04,
  1.267679825945400e-06, -3.128668199192837e-09,  6.536268316850167e-12, -1.091516751516759e-14,  1.085784801657318e-17,  1.323236181317274e-20, -1.130162299926608e-22,
  3.915616380308461e-25, -9.761956487289888e-28,  1.771222831364924e-30,  1.292581396676487e-01, -5.286610343706424e-04,  1.534622613538041e-06, -3.633355353178823e-09,
  6.983985687332679e-12, -9.487672986423369e-15,  1.434175140804527e-18,  4.538229948156914e-20, -1.906542895924616e-22,  5.109880858953046e-25, -9.528271939169076e-28,
  7.833222792740023e-31,  1.576524338185065e-01, -6.382546155964142e-04,  1.808800187524015e-06, -4.075444880956857e-09,  7.021712345078469e-12, -6.560369262565896e-15,
 -1.168396473186450e-17,  8.202625211374334e-20, -2.564606022857299e-22,  5.299215305037256e-25, -5.368717456372160e-28, -1.245728068333818e-30,  1.887751603768408e-01,
 -7.555811887100371e-04,  2.083458366183084e-06, -4.424201614383354e-09,  6.564185527806462e-12, -2.070686261498147e-15, -2.768843790242085e-17,  1.176722586147101e-19,
 -2.892591692075857e-22,  3.952592531141653e-25,  3.220023891462573e-28, -4.004280321346285e-30,  2.225908046470111e-01, -8.796861366894375e-04,  2.351361135053938e-06,
 -4.649343761726042e-09,  5.546125564442383e-12,  3.900923680853206e-15, -4.516214493212741e-17,  1.453022168301001e-19, -2.679377268197172e-22,  7.702407613917159e-26,
  1.537060022738568e-27, -6.691525388529044e-30,  2.590587992637710e-01, -1.009514610050696e-03,  2.604866557621323e-06, -4.722136581647864e-09,  3.929109300385788e-12,
  1.111066012078605e-14, -6.211519845428965e-17,  1.571452893715538e-19, -1.762065026760064e-22, -4.140550165160546e-25,  2.853236177803091e-27, -8.108345695014118e-30,
  2.981329889023193e-01, -1.143909072147465e-03,  2.836019452810861e-06, -4.616607030947265e-09,  1.708234443987632e-12,  1.914029519940429e-14, -7.609812221352543e-17,
  1.457965450207845e-19, -7.922984651529970e-24, -1.013226815692872e-24,  3.858792145126899e-27, -6.955921424764307e-30,  3.397610251551489e-01, -1.281607212516476e-03,
  3.036663607415152e-06, -4.310871824974179e-09, -1.081799471548009e-12,  2.739847029368821e-14, -8.440053558926919e-17,  1.056149607944965e-19,  2.279068614539699e-22,
 -1.597838641362282e-24,  4.055197877421993e-27, -2.326475914649319e-30,  3.838836854777708e-01, -1.421240448568975e-03,  3.198576497669585e-06, -3.788563299145582e-09,
 -4.361659989458989e-12,  3.513754514669065e-14, -8.433720252662884e-17,  3.426926355416708e-20,  5.036225688483734e-22, -1.997869253313189e-24,  2.989165003329633e-27,
  5.712740540307592e-30,  4.304341097977494e-01, -1.561333290076452e-03,  3.313629613840072e-06, -3.040326562487756e-09, -8.003965902805074e-12,  4.148895142468933e-14,
 -7.361370694654313e-17, -6.577365622332997e-20,  7.722444730855457e-22, -2.024284084163439e-24,  4.322038779902538e-28,  1.563261840727044e-29,  4.793369482307814e-01,
 -1.700303905661516e-03,  3.373977460849023e-06, -2.065347138829019e-09, -1.183215064528206e-11,  4.551937766207901e-14, -5.075105510194024e-17, -1.860965775611047e-19,
  9.709672296548397e-22, -1.515333285328337e-24, -3.430813612668837e-27,  2.431139483827053e-29,  5.305074134290484e-01, -1.836466306997312e-03,  3.372278072744600e-06,
 -8.728500870251670e-10, -1.562235512267064e-11,  4.630893381182530e-14, -1.553227536426751e-17, -3.118543509734488e-19,  1.029784364082631e-21, -3.958016842344051e-25,
 -7.866897558817068e-27,  2.752039004951831e-29,  5.838502315009694e-01, -1.968034655399031e-03,  3.301947330740123e-06,  5.165108869295072e-10, -1.910915604621461e-11,
  4.305054419497552e-14,  3.058464902498842e-17, -4.223342297570732e-19,  8.854515003268650e-22,  1.262311374575446e-24, -1.159282078784388e-26,  2.117408120821666e-29,
  6.392584863191179e-01, -2.093130297034076e-03,  3.157448385972663e-06,  2.069482616371883e-09, -2.199593504676572e-11,  3.516704093476737e-14,  8.416258230800041e-17,
 -4.928811484788596e-19,  4.997449713697140e-22,  3.195978688223095e-24, -1.298020726206004e-26,  3.234216877584811e-30,  6.966123535440246e-01, -2.209792246000028e-03,
  2.934615898677128e-06,  3.739398859151174e-09, -2.397060085157100e-11,  2.243867309175779e-14,  1.396815629213153e-16, -4.983860635176572e-19, -1.207299057912053e-22,
  4.947336927634165e-24, -1.050490775719399e-26, -2.422985219639758e-29,  7.557777230510705e-01, -2.315991956102373e-03,  2.631012421203067e-06,  5.465895748519035e-09,
 -2.472714609888506e-11,  5.129030545469157e-15,  1.897362112292025e-16, -4.182844973003027e-19, -9.078713526387731e-22,  5.922750475913103e-24, -3.398427333566796e-27,
 -5.374039495358439e-29,  8.166047119237579e-01, -2.409653346620309e-03,  2.246310850333056e-06,  7.175360634994316e-09, -2.399309808790637e-11, -1.590804685964086e-14,
  2.256282168067790e-16, -2.426228760608615e-19, -1.724967414252833e-21,  5.528506926912781e-24,  7.657636953806596e-27, -7.302874267668051e-29,  8.789260750956227e-01,
 -2.488679164989610e-03,  1.782692217120180e-06,  8.782345703927839e-09, -2.156225191800617e-11, -3.916353751587000e-14,  2.384169172176145e-16,  2.176343185113099e-20,
 -2.376278561570857e-21,  3.375941317592988e-24,  2.007977422301609e-26, -6.850635091322108e-29,  9.425555274709425e-01, -2.550984864901322e-03,  1.245241947528733e-06,
  1.019219181370567e-08, -1.733110616987547e-11, -6.247776153984006e-14,  2.204261289334879e-16,  3.464849326530666e-19, -2.639160942044827e-21, -4.841112161059817e-25,
  2.953656500916834e-26, -3.156438515140910e-29,  1.007286000370791e+00, -2.594541229124041e-03,  6.423199606435761e-07,  1.130509810603061e-08, -1.133613474754115e-11,
 -8.314356320113921e-14,  1.670999210975393e-16,  6.802440665046354e-19, -2.320174346440265e-21, -5.376555619588277e-24,  3.101459751914526e-26,  3.405514846582194e-29,
  1.072887866910062e+00, -2.617426940241642e-03, -1.412942584819239e-08,  1.202182442775844e-08, -3.787462467473521e-12, -9.813383327479675e-14,  7.895501324337728e-17,
  9.530262386494571e-19, -1.328505705010544e-21, -9.976192709547912e-24,  2.082621560590456e-26,  1.075835790043324e-28,  1.139107185882401e+00, -2.617892155918966e-03,
 -7.083725558316573e-07,  1.225110845902293e-08,  4.907191617603100e-12, -1.044673266574587e-13, -3.679085478349148e-17,  1.087446183211257e-18,  2.511219189749254e-22,
 -1.254763687926140e-23, -9.272546591149183e-28,  1.540799345882996e-28,  1.205664032309397e+00, -2.594433822193304e-03, -1.420842575273750e-06,  1.191869804198386e-08,
  1.413598273764099e-11, -9.970395706613711e-14, -1.654873096853163e-16,  1.017362407988690e-18,  2.115181346947434e-21, -1.149583158615941e-23, -2.855005975052514e-26,
  1.380472990689528e-28,  1.272251005209791e+00, -2.545882890630834e-03, -2.128323279082237e-06,  1.097762433417047e-08,  2.310238167634275e-11, -8.252541783348956e-14,
 -2.858564718130121e-16,  7.112628232373359e-19,  3.762490146250993e-21, -6.135759600534934e-24, -5.110829523346924e-26,  4.552983342843459e-29,  1.338532029228123e+00,
 -2.471502716936873e-03, -2.804434619218945e-06,  9.418965553785684e-09,  3.087864308372056e-11, -5.331086681146316e-14, -3.728633700031832e-16,  1.945094083752062e-19,
  4.606575504543821e-21,  2.597646396551156e-24, -5.609092810950298e-26, -9.596067499557920e-29,  1.404141595821734e+00, -2.371096634992950e-03, -3.420494507557281e-06,
  7.281887695708983e-09,  3.649856732547871e-11, -1.456811068305552e-14, -4.027934982549060e-16, -4.386521679124798e-19,  4.177452771609057e-21,  1.193309286904514e-23,
 -3.599990139157762e-26, -2.165759848672432e-28,  1.468684620172860e+00, -2.245120965047827e-03, -3.946820963747739e-06,  4.661247000311265e-09,  3.908888487229072e-11,
  2.895610660441380e-14, -3.599687117334218e-16, -1.033474282290095e-18,  2.362056318649211e-21,  1.795251832410045e-23,  4.957080552849847e-27, -2.351847033682423e-28,
  1.531737119114428e+00, -2.094797517632299e-03, -4.354511382824184e-06,  1.710600197357739e-09,  3.802904959708806e-11,  7.066341444246213e-14, -2.435754432907820e-16,
 -1.410228770548374e-18, -4.214587758107292e-22,  1.726360223076429e-23,  4.892476726693008e-26, -1.154250712720804e-28,  1.592847938877921e+00, -1.922217069985965e-03,
 -4.617686400458182e-06, -1.361744335827290e-09,  3.311663636034626e-11,  1.031010777797179e-13, -7.216103338542350e-17, -1.424132005571534e-18, -3.245510006667378e-21,
  9.085816015278557e-24,  7.136696416461996e-26,  8.877138122512692e-29,  1.651541773427894e+00, -1.730422525261474e-03, -4.716111043248934e-06, -4.305770073399381e-09,
  2.470217127631005e-11,  1.195319551105201e-13,  1.170064187194190e-16, -1.032522372228983e-18, -4.974762968855179e-21, -3.478236267215299e-24,  5.601330728203603e-26,
  2.464730459840789e-28,  1.707323706942086e+00, -1.523457900412928e-03, -4.638006633445286e-06, -6.853116099320921e-09,  1.374755891470654e-11,  1.158113543891845e-13,
  2.756947917009123e-16, -3.385914405225059e-19, -4.793245621694134e-21, -1.429512392721143e-23,  9.048168084524627e-27,  2.384124083351365e-28,  1.759685478943202e+00,
 -1.306367516058966e-03, -4.382752196184205e-06, -8.750232286021720e-09,  1.762710838722416e-12,  9.205239982701093e-14,  3.591657997102568e-16,  4.215160828574734e-19,
 -2.715719365738452e-21, -1.745953173328291e-23, -4.033588718911619e-26,  6.497401641452269e-29,  1.808113599170543e+00, -1.085129556855577e-03, -3.963063677774526e-06,
 -9.798231727337473e-09, -9.407879362612829e-12,  5.339765058649487e-14,  3.433265346731801e-16,  9.630449049183299e-19,  2.669311131038464e-22, -1.132038185556776e-23,
 -5.890875008994484e-26, -1.328897399467808e-28,  1.852099325258440e+00, -8.665103973674313e-04, -3.406164674086954e-06, -9.893348544563341e-09, -1.793974152408251e-11,
  9.285769532570193e-15,  2.373051253481654e-16,  1.083984916885197e-18,  2.638211724997550e-21, -2.028551016275837e-25, -3.631582791021976e-26, -1.916516282466215e-28,
  1.891150358630871e+00, -6.578314913401591e-04, -2.753463328407826e-06, -9.059288431542959e-09, -2.246280782690341e-11, -2.898560717048914e-14,  8.365963760369059e-17,
  7.771890288530050e-19,  3.250249375105553e-21,  8.327909687553235e-24,  4.660411988066945e-27, -8.519893128736539e-29,  1.924803920342068e+00, -4.666495208725085e-04,
 -2.058364482371383e-06, -7.461673367520475e-09, -2.246189770907578e-11, -5.188654328620664e-14, -5.738721581601901e-17,  2.459165194267379e-19,  2.086159616710904e-21,
  9.240668177275775e-24,  2.863836140995316e-26,  5.232394805710079e-29,  1.952640659066661e+00, -3.003624331573328e-04, -1.382093732539437e-06, -5.396394838416405e-09,
 -1.850267851862428e-11, -5.520692860919263e-14, -1.349247566582533e-16, -2.091515406233391e-19,  2.539653205083506e-22,  3.984501719411930e-24,  2.151877467488111e-26,
  8.481599987183875e-29,  1.974298660285206e+00, -1.657673921711281e-04, -7.877735256291937e-07, -3.248586444281904e-09, -1.216565395299968e-11, -4.192098763772688e-14,
 -1.324255553288731e-16, -3.751514844403207e-19, -8.959062241666859e-22, -1.433470462735024e-24,  1.189229924034609e-27,  2.440072140705245e-29,  1.989486814275441e+00,
 -6.860832501200658e-05, -3.334021779152676e-07, -1.426486068571799e-09, -5.653020627688860e-12, -2.118502953361467e-14, -7.576325212007939e-17, -2.593287228064824e-19,
 -8.483139199693281e-22, -2.635591489134077e-24, -7.673328705202446e-27, -2.035116356255786e-29,  1.997998783968484e+00, -1.314577714531990e-05, -6.467865890066403e-08,
 -2.823709098554023e-10, -1.153191228726159e-12, -4.509359686353450e-15, -1.709059896430387e-17, -6.322660173546966e-20, -2.293162441747234e-22, -8.176423630372587e-25,
 -2.871082315930263e-27, -9.938740050961225e-30,  3.544036624226077e-04, -1.501553444905824e-06,  4.770649811663020e-09, -1.347076429475086e-11,  3.565058521389885e-14,
 -9.055348489694830e-17,  2.235361281358975e-19, -5.403773638102999e-22,  1.285244639205683e-24, -3.018026884033465e-27,  7.011207818043762e-30, -1.614775041879796e-32,
  3.189223412468767e-03, -1.350006290424504e-05,  4.280686488884459e-08, -1.204567993614994e-10,  3.171009901195937e-13, -7.993521744818488e-16,  1.953015545301642e-18,
 -4.658072798096323e-21,  1.089069873116019e-23, -2.503417527185421e-26,  5.665627346625801e-29, -1.264251923182467e-31,  8.856671924464078e-03, -3.742277082647805e-05,
  1.181918144530617e-07, -3.302823424480835e-10,  8.601264498182863e-13, -2.134673820712097e-15,  5.104707032131097e-18, -1.183102528609079e-20,  2.664326731377179e-23,
 -5.834847324428130e-26,  1.240675761448954e-28, -2.554566227347987e-31,  1.735233484576606e-02, -7.312066640273829e-05,  2.295526409420817e-07, -6.347213396426921e-10,
  1.625684032777052e-12, -3.937124779404430e-15,  9.094378520614347e-18, -2.008801334700875e-20,  4.232467797965899e-23, -8.443883134354561e-26,  1.568275747380635e-28,
 -2.618317817662461e-31,  2.866950926377639e-02, -1.203692642332904e-04,  3.748354779567370e-07, -1.021603577077144e-09,  2.556978400713392e-12, -5.980388879371484e-15,
  1.311987813614551e-17, -2.684305128439934e-20,  5.026316935287785e-23, -8.227922701259818e-26,  1.019108697275972e-28, -2.443808865985127e-32,  4.279910480151822e-02,
 -1.788674495990900e-04,  5.513124087364709e-07, -1.475021121823836e-09,  3.581582793921478e-12, -7.986211899355581e-15,  1.624577661158186e-17, -2.930348650158140e-20,
  4.307284200974924e-23, -3.502722287985973e-26, -7.085686480752358e-29,  4.821296644123382e-31,  5.972950965669113e-02, -2.482359535804107e-04,  7.555915137222655e-07,
 -1.975609828446122e-09,  4.614261219258350e-12, -9.643782712044741e-15,  1.750883610323888e-17, -2.495355908426877e-20,  1.557758711340534e-23,  6.325876185689188e-26,
 -3.483430833672698e-28,  1.135126265028801e-30,  7.944641976468142e-02, -3.280154725796424e-04,  9.836306907291035e-07, -2.500911090859120e-09,  5.560481451135508e-12,
 -1.063295155904444e-14,  1.603786163768422e-17, -1.206363514186973e-20, -3.338380042680481e-23,  2.024215834251369e-25, -6.634619560514745e-28,  1.660070646285272e-30,
  1.019326287752672e-01, -4.176644529363141e-04,  1.230756131493354e-06, -3.025820055507957e-09,  6.320598803322169e-12, -1.065052899667000e-14,  1.117978915439441e-17,
  9.833996818441079e-21, -9.960429552334075e-23,  3.540497609398740e-25, -8.999777383490203e-28,  1.691711880550173e-30,  1.271677760198309e-01, -5.165565692822011e-04,
  1.491686557270760e-06, -3.523127319843547e-09,  6.794675864922617e-12, -9.438677000098458e-15,  2.622179830040278e-18,  3.956840518721488e-20, -1.729361095567482e-22,
  4.736008928812930e-25, -9.156989724873290e-28,  8.978739992249076e-31,  1.551280491083808e-01, -6.239779356116881e-04,  1.760564556234872e-06, -3.964161613977731e-09,
  6.887882125349342e-12, -6.814133480349773e-15, -9.499286221911419e-18,  7.412050300885335e-20, -2.377820906006489e-22,  5.074695918504146e-25, -5.828987475921070e-28,
 -8.575274073704143e-31,  1.857858372327457e-01, -7.391241013761330e-04,  2.030996628028219e-06, -4.319540959872272e-09,  6.516388108577141e-12, -2.696703624952704e-15,
 -2.452104784076867e-17,  1.086457875762319e-19, -2.748386651175196e-22,  4.048111733614811e-25,  1.602983398251104e-28, -3.358258917087785e-30,  2.191093306653444e-01,
 -8.610969020098282e-04,  2.296103825549860e-06, -4.560039130460005e-09,  5.613629673855510e-12,  2.864887856873491e-15, -4.121322077839574e-17,  1.367838789731478e-19,
 -2.641271094451501e-22,  1.328396789718705e-25,  1.259132524067185e-27, -5.948504903993767e-30,  2.550620613364998e-01, -9.889012550585714e-04,  2.548585187855166e-06,
 -4.657572641050078e-09,  4.136767912108195e-12,  9.672046009676495e-15, -5.779615868595471e-17,  1.512895238294715e-19, -1.891427482432026e-22, -3.069081116104034e-25,
  2.507963626381852e-27, -7.579443725527903e-30,  2.936023787563555e-01, -1.121442020567262e-03,  2.780796473892778e-06, -4.586310677516550e-09,  2.073107177951768e-12,
  1.736286660210714e-14, -7.202464312469629e-17,  1.449885797745476e-19, -4.169491870856213e-23, -8.650312675152343e-25,  3.550402372583190e-27, -7.036457138919594e-30,
  3.346828549351439e-01, -1.257521078818527e-03,  2.984847022030209e-06, -4.323905899958961e-09, -5.538426218464215e-13,  2.540911614102489e-14, -8.134963997385883e-17,
  1.120187116822024e-19,  1.732767949034545e-22, -1.437998077115124e-24,  3.929378892492038e-27, -3.350034191897714e-30,  3.782496113712872e-01, -1.395834821301180e-03,
  3.152717854228746e-06, -3.852837469301392e-09, -3.679063159712593e-12,  3.312672223720287e-14, -8.316268551836096e-17,  4.925794354782068e-20,  4.339063663102618e-22,
 -1.873895878889785e-24,  3.194664155724532e-27,  3.675155146664253e-30,  4.242415606552781e-01, -1.534972303482813e-03,  3.276404384535348e-06, -3.161848353765532e-09,
 -7.191989192126717e-12,  3.970284776142674e-14, -7.512032787761084e-17, -4.222318671311875e-20,  6.998399102877633e-22, -1.994037622563334e-24,  1.060662396915738e-27,
  1.296177260355388e-29,  4.725895548282493e-01, -1.673414372231413e-03,  3.348087232447819e-06, -2.247446337230050e-09, -1.093434748404963e-11,  4.424228360513836e-14,
 -5.553514385575176e-17, -1.559228932689943e-19,  9.141965137432462e-22, -1.631868742139042e-24, -2.413418472793558e-27,  2.191559514865024e-29,  5.232154324072518e-01,
 -1.809534158256604e-03,  3.360334615945413e-06, -1.115421495714316e-09, -1.470059229716863e-11,  4.583508456257828e-14, -2.380541520759580e-17, -2.791876087569722e-19,
  1.010161335470796e-21, -6.864677184411258e-25, -6.672470116930234e-27,  2.668930569163262e-29,  5.760309560401522e-01, -1.941599416244767e-03,  3.306339514105588e-06,
  2.176883971323565e-10, -1.824174598658730e-11,  4.364591209867991e-14,  1.916217717526636e-17, -3.933603250345198e-19,  9.227783633407163e-22,  8.178736580594049e-25,
 -1.061470088161692e-26,  2.314758205569580e-29,  6.309366332107417e-01, -2.067777303531273e-03,  3.180194120614741e-06,  1.723279471789779e-09, -2.127350328541577e-11,
  3.702324465920260e-14,  7.060238020184652e-17, -4.751482559991631e-19,  6.055036638732162e-22,  2.681241742362343e-24, -1.271803119306867e-26,  8.534884735443952e-30,
  6.878204134504349e-01, -2.186142312402218e-03,  2.977202893865969e-06,  3.359636827567946e-09, -2.348943572279936e-11,  2.562329794490347e-14,  1.256988515485804e-16,
 -4.994827985801061e-19,  4.957487458377164e-23,  4.508131347092635e-24, -1.139895531538823e-26, -1.648668231570555e-29,  7.465562573505321e-01, -2.294688210136987e-03,
  2.694233539748609e-06,  5.071325433225690e-09, -2.457999360056668e-11,  9.539069125324331e-15,  1.776493596664673e-16, -4.439556068988103e-19, -6.976491880395735e-22,
  5.741712177329309e-24, -5.598407676584031e-27, -4.618266950814977e-29,  8.070025755954543e-01, -2.391344990910468e-03,  2.330102287703139e-06,  6.789217577670395e-09,
 -2.425768997035881e-11, -1.058054256567715e-14,  2.180922964776837e-16, -2.945845301276280e-19, -1.521194105729631e-21,  5.771444586716457e-24,  4.514413814764042e-27,
 -6.957785001810911e-29,  8.690005406135681e-01, -2.474001997099684e-03,  1.885985548718696e-06,  8.431394456985340e-09, -2.228829716037842e-11, -3.344269392102894e-14,
  2.379810616988046e-16, -5.218391095132403e-20, -2.241027314356319e-21,  4.117383076145829e-24,  1.696040790431180e-26, -7.288821562807179e-29,  9.323722797110968e-01,
 -2.540538511257981e-03,  1.365844167457409e-06,  9.905188235529965e-09, -1.852702266141588e-11, -5.708066673705881e-14,  2.289443516680053e-16,  2.619779914033304e-19,
 -2.635695005430943e-21,  6.654651752377862e-25,  2.784421227047235e-26, -4.502059120944818e-29,  9.969189672432474e-01, -2.588863233089470e-03,  7.768387173848563e-07,
  1.111064120103130e-08, -1.295740332391751e-11, -7.891316305804174e-14,  1.850799412875747e-16,  6.031436162509271e-19, -2.491090240307949e-21, -4.111659678686968e-24,
  3.209056279003213e-26,  1.489376948274155e-29,  1.062418845086790e+00, -2.616964106715528e-03,  1.297044606369523e-07,  1.194563555448305e-08, -5.729054679937437e-12,
 -9.592382589306457e-14,  1.049917847682828e-16,  9.049375309953174e-19, -1.671555094337018e-21, -9.053136680917801e-24,  2.520640785340795e-26,  9.109431276025960e-29,
  1.128625216056754e+00, -2.622969907454050e-03, -5.609572394539447e-07,  1.231287114084419e-08,  2.811484529166028e-12, -1.049844345104940e-13, -6.297741207685739e-18,
  1.088260719398284e-18, -1.996315426281589e-22, -1.244973001034992e-23,  5.799175946670346e-27,  1.508670891758495e-28,  1.195264474587174e+00, -2.605224773205571e-03,
 -1.276527621273144e-06,  1.212871515512684e-08,  1.210453189800537e-11, -1.033265602109193e-13, -1.361172774394082e-16,  1.078218410679975e-18,  1.682288153057032e-21,
 -1.251104277538404e-23, -2.208738983305993e-26,  1.549390892190702e-28,  1.262034263477177e+00, -2.562376394873445e-03, -1.994429613580147e-06,  1.133369263054250e-08,
  2.138495030680800e-11, -8.913360178223360e-14, -2.642915112927393e-16,  8.277382667125198e-19,  3.505377906960318e-21, -8.130121835566444e-24, -4.836641542512943e-26,
  7.892694462103897e-29,  1.328601874994448e+00, -2.493477768734126e-03, -2.688479437201339e-06,  9.904010042968888e-09,  2.972346608337389e-11, -6.217750442085196e-14,
 -3.653424345903596e-16,  3.429753532994237e-19,  4.658774118136800e-21,  2.791177063563450e-25, -5.959067715020948e-26, -6.236321220092621e-29,  1.394603048775039e+00,
 -2.398101158409308e-03, -3.329619319843421e-06,  7.863004733267665e-09,  3.610961952411866e-11, -2.436704955297777e-14, -4.131417668587332e-16, -2.983966206615258e-19,
  4.578851992114230e-21,  1.030530480090496e-23, -4.530538054018658e-26, -2.050223614044285e-28,  1.459641356496280e+00, -2.276461119809677e-03, -3.887115902769850e-06,
  5.290823058772469e-09,  3.957931727344862e-11,  1.997874939080931e-14, -3.877504779979646e-16, -9.475302521165832e-19,  3.009354178148646e-21,  1.793645733752316e-23,
 -5.931608955155236e-27, -2.587012575059371e-28,  1.523288401609472e+00, -2.129541050705848e-03, -4.330287819436272e-06,  2.330040069532392e-09,  3.938065598967685e-11,
  6.434283044023121e-14, -2.831546006374783e-16, -1.413404693757494e-18,  2.339044619146742e-22,  1.910490524079608e-23,  4.278854284736863e-26, -1.637023607987857e-28,
  1.585085097045550e+00, -1.959214761158524e-03, -4.630780431038341e-06, -8.154898444157555e-10,  3.515805003927811e-11,  1.008792909658579e-13, -1.134375765496085e-16,
 -1.522196967353904e-18, -2.866196933906823e-21,  1.200730049677532e-23,  7.441118641657045e-26,  4.812442262090636e-29,  1.644544308037994e+00, -1.768351188950672e-03,
 -4.765329518001695e-06, -3.891267798367667e-09,  2.711845675692736e-11,  1.219750931857889e-13,  8.585148027005375e-17, -1.193264586033757e-18, -5.057032465232941e-21,
 -1.020515865093231e-24,  6.686338999172700e-26,  2.451640360091096e-28,  1.701155151911545e+00, -1.560886985365579e-03, -4.718846670523962e-06, -6.614269375255961e-09,
  1.612909324386461e-11,  1.222964577952648e-13,  2.639901124357603e-16, -5.001182165468608e-19, -5.298720148495636e-21, -1.371164191786255e-23,  2.041485229986511e-26,
  2.780486074865931e-28,  1.754389220691384e+00, -1.341848922339142e-03, -4.487523481153002e-06, -8.706828347813620e-09,  3.690861369729097e-12,  1.008035966282756e-13,
  3.696549328157528e-16,  3.242513368838814e-19, -3.372498329793967e-21, -1.900282899149199e-23, -3.649454827854085e-26,  1.108897487232148e-28,  1.803708923756768e+00,
 -1.117306856225210e-03, -4.081508897179039e-06, -9.939757294675598e-09, -8.255340466366545e-12,  6.196164262909177e-14,  3.703468035087743e-16,  9.646001229346450e-19,
 -1.843988536179146e-22, -1.379057437847702e-23, -6.451017821721094e-26, -1.204098090356328e-28,  1.848578026272039e+00, -8.942394589232118e-04, -3.526599912213898e-06,
 -1.017857874896020e-08, -1.769456518913388e-11,  1.535483405875680e-14,  2.688354274826676e-16,  1.167993551004059e-18,  2.602661724677385e-21, -1.831558635894021e-24,
 -4.530257562757507e-26, -2.167899924602316e-28,  1.888474280063468e+00, -6.803001970076189e-04, -2.864349975527126e-06, -9.423214347906658e-09, -2.302061707230233e-11,
 -2.670460933714214e-14,  1.069223244380900e-16,  8.860220443813033e-19,  3.552431757330700e-21,  8.431103796634844e-24,  2.856512646990769e-28, -1.145404606814917e-28,
  1.922903812609738e+00, -4.834807860308395e-04, -2.150095385751629e-06, -7.829437929863433e-09, -2.351280344825972e-11, -5.317334956569503e-14, -4.951534122959587e-17,
  3.182217813117344e-19,  2.439988441423982e-21,  1.043114030953941e-23,  3.085229388732865e-26,  4.778512219954975e-29,  1.951416678491188e+00, -3.116833277658755e-04,
 -1.448663739630128e-06, -5.701448718018077e-09, -1.963966805733501e-11, -5.851434068334288e-14, -1.406444314340017e-16, -1.985559279382308e-19,  4.138346172793175e-22,
  4.923680606004140e-24,  2.553645020316527e-26,  9.803507305881248e-29,  1.973622734690486e+00, -1.722288864431429e-04, -8.279527028575230e-07, -3.450120578809300e-09,
 -1.303672362626871e-11, -4.522853876172362e-14, -1.433388425906782e-16, -4.046347560253502e-19, -9.463769095522815e-22, -1.362289560666105e-24,  2.425807635257182e-27,
  3.209415799620896e-29,  1.989206935913567e+00, -7.134558424382709e-05, -3.510770097428609e-07, -1.520425323762219e-09, -6.095508789588441e-12, -2.309363937080139e-14,
 -8.341919749329057e-17, -2.880538978272723e-19, -9.489418036953412e-22, -2.961093785923094e-24, -8.618411155962982e-27, -2.263347615543676e-29,  1.997945144089123e+00,
 -1.367708089028093e-05, -6.818086622630890e-08, -3.015663703978000e-10, -1.247627967970317e-12, -4.941635419438490e-15, -1.896826569426146e-17, -7.105873327116760e-20,
 -2.609284666259774e-22, -9.417333051239680e-25, -3.346428649598344e-27, -1.171960717177551e-29,  3.484727687725950e-04, -1.464025281912194e-06,  4.612364261365333e-09,
 -1.291455705984748e-11,  3.389196221042905e-14, -8.536563566165270e-17,  2.089653959842987e-19, -5.009351514876183e-22,  1.181477143797922e-24, -2.751282542192087e-27,
  6.338174533419230e-30, -1.447707004527373e-32,  3.135899036158713e-03, -1.316330485872100e-05,  4.139130554917740e-08, -1.155085767820928e-10,  3.015723058994723e-13,
 -7.540063504525176e-16,  1.827336111507378e-18, -4.323563387270110e-21,  1.002895528641086e-23, -2.287535934343310e-26,  5.137644992017256e-29, -1.138009472470577e-31,
  8.708847134795864e-03, -3.649285911090607e-05,  1.143096108567984e-07, -3.168553214469158e-10,  8.186317601225310e-13, -2.016041641579031e-15,  4.785065429351120e-18,
 -1.101111321609066e-20,  2.462940584275664e-23, -5.360360065440358e-26,  1.133444510459310e-28, -2.323321060889047e-31,  1.706347740005695e-02, -7.131427562176805e-05,
  2.220894899298377e-07, -6.093286645333363e-10,  1.549079407620035e-12, -3.725458987398763e-15,  8.550427122421703e-18, -1.878107194483832e-20,  3.939506488717275e-23,
 -7.839115815967103e-26,  1.456782135612086e-28, -2.450648328589462e-31,  2.819395290265217e-02, -1.174189308635062e-04,  3.628178126295389e-07, -9.816319288760427e-10,
  2.440459441644481e-12, -5.674352026581458e-15,  1.239035090021890e-17, -2.528123838510713e-20,  4.737418344133019e-23, -7.822977275204113e-26,  1.004342556366726e-28,
 -4.196827177257295e-32,  4.209234525955151e-02, -1.745267891553073e-04,  5.339507841895785e-07, -1.418972682714437e-09,  3.425691881946739e-12, -7.606004664446514e-15,
  1.544438238891783e-17, -2.794583815389614e-20,  4.176574623074945e-23, -3.746027289585303e-26, -5.134604489269669e-29,  4.065352906640495e-31,  5.874850691297766e-02,
 -2.422848101747365e-04,  7.323208732720990e-07, -1.903302059168080e-09,  4.425531390711038e-12, -9.231896702396501e-15,  1.681743894536393e-17, -2.442123319908675e-20,
  1.761576336269946e-23,  5.028363359123937e-26, -3.013839670461887e-28,  1.001835555700610e-30,  7.814990801025849e-02, -3.202649743620085e-04,  9.541466135351587e-07,
 -2.413623863451984e-09,  5.351643550464060e-12, -1.025221042325194e-14,  1.568618371391738e-17, -1.302030369436498e-20, -2.655712508066342e-23,  1.772988193223083e-25,
 -5.937745904509353e-28,  1.509269629096243e-30,  1.002814355051877e-01, -4.079619401378070e-04,  1.195046086427196e-06, -2.926379893561004e-09,  6.110291863968658e-12,
 -1.037925847087847e-14,  1.141238575937685e-17,  6.843788293625045e-21, -8.748877757010572e-23,  3.195141859988108e-25, -8.274349339559760e-28,  1.604721527437553e-30,
  1.251251515602128e-01, -5.047903531063010e-04,  1.450055100867543e-06, -3.415918909362328e-09,  6.606618223330205e-12, -9.363059533943983e-15,  3.655132981546087e-18,
  3.430025345183982e-20, -1.565360224322990e-22,  4.377886401934100e-25, -8.743399962268905e-28,  9.767376512886229e-31,  1.526600077537452e-01, -6.100818358498617e-04,
  1.713651317989343e-06, -3.855057458025605e-09,  6.749483359719092e-12, -7.018054962835179e-15, -7.527724569099736e-18,  6.679921088002663e-20, -2.199410478934847e-22,
  4.834989495349320e-25, -6.132686258540141e-28, -5.327266947717417e-31,  1.828615109848100e-01, -7.230816981620844e-04,  1.979785829150306e-06, -4.215741181560592e-09,
  6.456810314337722e-12, -3.249684102197783e-15, -2.159989547196387e-17,  1.000850805118966e-19, -2.601840668326875e-22,  4.084416987942342e-25,  2.540272318776270e-29,
 -2.784985960976747e-30,  2.157013363164829e-01, -8.429454223645536e-04,  2.241923984691160e-06, -4.469815130601735e-09,  5.661341567812890e-12,  1.920779611765219e-15,
 -3.750081578451557e-17,  1.284175482450371e-19, -2.584994754771366e-22,  1.781791890996449e-25,  1.012927737214850e-27, -5.250432590048724e-30,  2.511468813110440e-01,
 -9.687349976226674e-04,  2.493097589206969e-06, -4.589910765438402e-09,  4.316677303305030e-12,  8.335078008296390e-15, -5.364631464881085e-17,  1.450788956868808e-19,
 -1.984645995248730e-22, -2.130966826682217e-25,  2.186675388564760e-27, -7.021235807964495e-30,  2.891607556881653e-01, -1.099415202015283e-03,  2.725970923075656e-06,
 -4.550455446927845e-09,  2.403406531964484e-12,  1.568281275164124e-14, -6.798813185593825e-17,  1.431828881856614e-19, -7.035431292447750e-23, -7.291992611867630e-25,
  3.241622547031446e-27, -6.978610789876588e-30,  3.297001993927565e-01, -1.233849962832676e-03,  2.932923411674430e-06, -4.328806926167634e-09, -6.492711504087673e-14,
  2.349494288121986e-14, -7.814305595963741e-17,  1.167653136425796e-19,  1.243002198501311e-22, -1.284017332260765e-24,  3.763975990216246e-27, -4.130696867608833e-30,
  3.727164214088436e-01, -1.370798965720553e-03,  3.106152128238816e-06, -3.906510152066486e-09, -3.036368194911704e-12,  3.114887601492296e-14, -8.159903706554944e-17,
  6.208852981058126e-20,  3.687803173325505e-22, -1.743412362286559e-24,  3.316714506332033e-27,  1.917896954841761e-30,  4.181538509280613e-01, -1.508914733638476e-03,
  3.237797658908419e-06, -3.270666039387608e-09, -6.416044079485663e-12,  3.788823751261805e-14, -7.599977593848757e-17, -2.096761631275470e-20,  6.289488631201463e-22,
 -1.940950602340734e-24,  1.575587857269186e-27,  1.047692250460432e-29,  4.659492918183919e-01, -1.646740459167887e-03,  3.320097140455096e-06, -2.415390975038936e-09,
 -1.006316702771562e-11,  4.286030089235563e-14, -5.950037862532114e-17, -1.276253499090421e-19,  8.539373892195618e-22, -1.709843195616967e-24, -1.503276568052303e-27,
  1.944912733034820e-29,  5.160309708026031e-01, -1.782708950667221e-03,  3.345568444633348e-06, -1.343330993659480e-09, -1.379021832859254e-11,  4.517357568463249e-14,
 -3.117418518508051e-17, -2.473070861090914e-19,  9.809242250872385e-22, -9.302269834209402e-25, -5.524802348380779e-27,  2.541282175961953e-29,  5.683174694345351e-01,
 -1.915143146357987e-03,  3.307229444412614e-06, -6.717488967619545e-11, -1.736510361348858e-11,  4.397699637404368e-14,  8.565346543450414e-18, -3.634402504026881e-19,
  9.448284408461553e-22,  4.140569034845582e-25, -9.567568366221395e-27,  2.432550900989915e-29,  6.227165299776818e-01, -2.042258762693421e-03,  3.198855939264441e-06,
  1.388914720960532e-09, -2.051715977582314e-11,  3.856032716955170e-14,  5.758331021758900e-17, -4.543251094891772e-19,  6.929743901073407e-22,  2.181391483779253e-24,
 -1.224244096940082e-26,  1.293426273964185e-29,  6.791237258122452e-01, -2.162169775821338e-03,  3.015280979315334e-06,  2.988064745014974e-09, -2.294793331527615e-11,
  2.847257020404931e-14,  1.117593057634193e-16, -4.953890075516694e-19,  2.035052922304488e-22,  4.039826694278513e-24, -1.196387876422203e-26, -9.294421244729217e-30,
  7.374209882496219e-01, -2.272897587973192e-03,  2.752736800086056e-06,  4.679799172028073e-09, -2.434759549618479e-11,  1.365115132516826e-14,  1.649367995019247e-16,
 -4.630202114630423e-19, -4.954471706326538e-22,  5.479439474322735e-24, -7.457842027468494e-27, -3.830795820063846e-29,  7.974749839151052e-01, -2.372384902505850e-03,
  2.409238090566220e-06,  6.399683142750924e-09, -2.441765439756906e-11, -5.450615409703495e-15,  2.091938839090669e-16, -3.399094472871231e-19, -1.310897390851548e-21,
  5.892144728863767e-24,  1.556471026756249e-27, -6.465679132421989e-29,  8.591353405567383e-01, -2.458515517012599e-03,  1.985001537024688e-06,  8.069740557911999e-09,
 -2.290019521968100e-11, -2.775664430352588e-14,  2.355391121548981e-16, -1.214005601403830e-19, -2.081370210461850e-21,  4.730891428304753e-24,  1.370016230163034e-26,
 -7.492924048374257e-29,  9.222327247407412e-01, -2.529141433044490e-03,  1.482891132331737e-06,  9.599923832624816e-09, -1.961314431993765e-11, -5.150747864366767e-14,
  2.351040546222443e-16,  1.782299302825070e-19, -2.592199817768193e-21,  1.736134196193664e-24,  2.560722308554032e-26, -5.627811731653433e-29,  9.865767830073232e-01,
 -2.582118855338613e-03,  9.088712154633899e-07,  1.089094356420523e-08, -1.448992657098573e-11, -7.427772388178906e-14,  2.008314738670112e-16,  5.213091012518472e-19,
 -2.615897336788295e-21, -2.820464152981276e-24,  3.233378580822713e-26, -3.690747120238170e-30,  1.051953969408584e+00, -2.615354783699099e-03,  2.724392550708645e-07,
  1.183876827922227e-08, -7.620313261114354e-12, -9.310630238953265e-14,  1.295336145860685e-16,  8.464352762633268e-19, -1.978402037893558e-21, -7.970082471060568e-24,
  2.881013836788043e-26,  7.241114597736073e-29,  1.118125297758530e+00, -2.626865942409459e-03, -4.130021713124143e-07,  1.234105951350412e-08,  7.127470751687514e-13,
 -1.047710587731588e-13,  2.401713990702436e-17,  1.074759106004700e-18, -6.420642600352561e-22, -1.208700235766874e-23,  1.227940566411288e-26,  1.429372795874520e-28,
  1.184824077274447e+00, -2.614851681573804e-03, -1.129889746540203e-06,  1.230568828762670e-08,  1.000780759802380e-11, -1.062254322584748e-13, -1.052423438800338e-16,
  1.124688330715850e-18,  1.217666707770309e-21, -1.325430708912020e-23, -1.498907324177825e-26,  1.668425986960134e-28,  1.251753716414931e+00, -2.577782135511453e-03,
 -1.856432269256426e-06,  1.166125392755662e-08,  1.954078993168357e-11, -9.518608616026065e-14, -2.395910506756000e-16,  9.348613846830720e-19,  3.178793341306458e-21,
 -9.985832122388060e-24, -4.418835484922917e-26,  1.105868412624344e-28,  1.318585712238609e+00, -2.514502224554446e-03, -2.566820434650062e-06,  1.036916426122385e-08,
  2.839309872103199e-11, -7.081364428911469e-14, -3.536537911155187e-16,  4.917521319208082e-19,  4.625353780061950e-21, -2.148574484338719e-24, -6.152008632216988e-26,
 -2.478597159428389e-29,  1.384957981633481e+00, -2.424350907475279e-03, -3.231814573968904e-06,  8.436318642270934e-09,  3.552253472278637e-11, -3.436582623371837e-14,
 -4.193923685668304e-16, -1.463046006002086e-19,  4.915095879914579e-21,  8.317933757419397e-24, -5.391782004390345e-26, -1.850683620220854e-28,  1.450473735499453e+00,
 -2.307293294912002e-03, -3.819814887648984e-06,  5.926774291335860e-09,  3.988374191082618e-11,  1.036584402247785e-14, -4.128365193584656e-16, -8.409679083255727e-19,
  3.648002685250143e-21,  1.746616240445006e-23, -1.770192424700311e-26, -2.749857605569526e-28,  1.514701145132595e+00, -2.164060704464068e-03, -4.298505562114678e-06,
  2.970042752494400e-09,  4.059635700230258e-11,  5.707370879720480e-14, -3.225194778574049e-16, -1.394599945535083e-18,  9.506223088766707e-22,  2.065805284879449e-23,
  3.451515986575740e-26, -2.122267655782181e-28,  1.577174097238345e+00, -1.996290432826957e-03, -4.637125075228530e-06, -2.369829522935638e-10,  3.714490670400034e-11,
  9.763538681594198e-14, -1.572740487916684e-16, -1.606421289332235e-18, -2.379973411380943e-21,  1.501217541864258e-23,  7.547274219816428e-26, -1.265935995577391e-30,
  1.637394372932322e+00, -1.806653043657029e-03, -4.809340525367031e-06, -3.437756214135423e-09,  2.957576207083933e-11,  1.236162906103326e-13,  5.017279998188590e-17,
 -1.355140297717016e-18, -5.043051999232564e-21,  1.867158742000990e-24,  7.743615091143953e-26,  2.335784098253981e-28,  1.694835606180323e+00, -1.598950668444338e-03,
 -4.796587693170767e-06, -6.336297318620289e-09,  1.863714482314312e-11,  1.284445707365511e-13,  2.475400339017330e-16, -6.773929583851177e-19, -5.774589546435841e-21,
 -1.263914202363879e-23,  3.348198717278670e-26,  3.153335602670515e-28,  1.748949364530638e+00, -1.378165877667179e-03, -4.591582998950657e-06, -8.631161101125680e-09,
  5.796320144715325e-12,  1.097714265810103e-13,  3.771182987063905e-16,  2.051144654576282e-19, -4.081563004451304e-21, -2.034983651078965e-23, -3.046665832736825e-26,
  1.643140032838840e-28,  1.799173633726086e+00, -1.150438183840597e-03, -4.201536013321762e-06, -1.006143678213970e-08, -6.925042126187368e-12,  7.117292798257143e-14,
  3.971947525712631e-16,  9.502479275126242e-19, -7.285341874389378e-22, -1.647137297559596e-23, -6.937483517881725e-26, -9.911146296390337e-29,  1.844943862504762e+00,
 -9.229456172497945e-04, -3.650430234920765e-06, -1.045887316942886e-08, -1.732025066303237e-11,  2.220866747740486e-14,  3.026927233087527e-16,  1.249854919576443e-18,
  2.501742832761631e-21, -3.841674914228079e-24, -5.537964774921910e-26, -2.409858681495185e-28,  1.885706524619299e+00, -7.036736123507113e-04, -2.979655676731831e-06,
 -9.795668862219089e-09, -2.352697082576811e-11, -2.382764427417675e-14,  1.333680160158656e-16,  1.004547941255809e-18,  3.854853471786914e-21,  8.331866439979907e-24,
 -5.502151545536083e-27, -1.495082159485396e-28,  1.920934883766174e+00, -5.010638388473084e-04, -2.246341164934963e-06, -8.214211896235755e-09, -2.458738529221221e-11,
 -5.424561664190719e-14, -3.945384185742121e-17,  4.025519194951375e-19,  2.838211112260668e-21,  1.170516744807721e-23,  3.278936994504499e-26,  3.957139015994744e-29,
  1.950146325589780e+00, -3.235517393536982e-04, -1.519005751022085e-06, -6.025230962944999e-09, -2.084415140428656e-11, -6.195485436049364e-14, -1.459904969311856e-16,
 -1.822713521641274e-19,  6.105509660561084e-22,  6.035606251709962e-24,  3.016610060280071e-26,  1.126241466665616e-28,  1.972920304594010e+00, -1.790217298237346e-04,
 -8.706361422450320e-07, -3.666135551145788e-09, -1.397663131087150e-11, -4.880809493521054e-14, -1.550998150411161e-16, -4.356818490487203e-19, -9.933082982522070e-22,
 -1.234335408798548e-24,  4.041945611391869e-27,  4.171824916055128e-29,  1.988915818404249e+00, -7.422887453863039e-05, -3.699228842807536e-07, -1.621760030621126e-09,
 -6.578073651264583e-12, -2.519601851945302e-14, -9.192634384597500e-17, -3.201941496572477e-19, -1.061992846834718e-21, -3.326453132998741e-24, -9.667257561401811e-27,
 -2.506330502686438e-29,  1.997889321463459e+00, -1.423735003609166e-05, -7.192277844747623e-08, -3.223445080354524e-10, -1.351179233941433e-12, -5.421725322895136e-15,
 -2.108009304179211e-17, -7.997776096143908e-20, -2.973699706787810e-22, -1.086502139703104e-24, -3.907488312373101e-27, -1.384548944466208e-29,  3.426894968124338e-04,
 -1.427737175955202e-06,  4.460587733521840e-09, -1.238567636850569e-11,  3.223368676866669e-14, -8.051459794719982e-17,  1.954539653325204e-19, -4.646649096960122e-22,
  1.086845063294470e-24, -2.510045376196804e-27,  5.734504296043281e-30, -1.299106995963778e-32,  3.083899413272772e-03, -1.283763792915611e-05,  4.003366353272016e-08,
 -1.108017185749716e-10,  2.869211179584170e-13, -7.115674833564800e-16,  1.710648279235444e-18, -4.015425986954876e-21,  9.241257894773779e-24, -2.091703271351281e-26,
  4.662205884609596e-29, -1.025156514946236e-31,  8.564680881486406e-03, -3.559337163600061e-05,  1.105846249904270e-07, -3.040736434683272e-10,  7.794348226094465e-13,
 -1.904812497657919e-15,  4.487504254975368e-18, -1.025299249816491e-20,  2.277887839043373e-23, -4.926795465385149e-26,  1.035905195309665e-28, -2.113672473314781e-31,
  1.678172800790110e-02, -6.956639171976389e-05,  2.149238344102060e-07, -5.851284939583554e-10,  1.476580460204630e-12, -3.526419291991530e-15,  8.041789741471304e-18,
 -1.756447934362848e-20,  3.667531649715938e-23, -7.277490201953525e-26,  1.352517047498669e-28, -2.289863643822551e-31,  2.773000858606943e-02, -1.145628514113143e-04,
  3.512688202036603e-07, -9.434765547448791e-10,  2.329889621867040e-12, -5.385309370635061e-15,  1.170328198578343e-17, -2.380955338370896e-20,  4.462973999572647e-23,
 -7.425359389322627e-26,  9.827586777768559e-29, -5.554672700721655e-32,  4.140267477393990e-02, -1.703223732139612e-04,  5.172470229712434e-07, -1.365358697218323e-09,
  3.277215834451852e-12, -7.244579523200320e-15,  1.468040461053795e-17, -2.663127400145482e-20,  4.038433545999566e-23, -3.917628972712266e-26, -3.493042604734871e-29,
  3.412108465773605e-31,  5.779094183637599e-02, -2.365164118340166e-04,  7.099000769281876e-07, -1.833948961772211e-09,  4.244874590658131e-12, -8.836418411917356e-15,
  1.614179231329836e-17, -2.383080803682415e-20,  1.921927129732466e-23,  3.907385470149186e-26, -2.599721668428811e-28,  8.827495242837979e-31,  7.688393305786574e-02,
 -3.127462152032158e-04,  9.256901844114586e-07, -2.329617591135763e-09,  5.150334024182184e-12, -9.880207129772737e-15,  1.531064521816816e-17, -1.377246415485869e-20,
 -2.058626527080184e-23,  1.548339377472026e-25, -5.304913386211651e-28,  1.368967610138075e-30,  9.866848840282162e-02, -3.985403913613797e-04,  1.160509313783343e-06,
 -2.830260963746724e-09,  5.905459598135452e-12, -1.010336765587492e-14,  1.156650132009919e-17,  4.221936301268995e-21, -7.656524609770882e-23,  2.878022561405105e-25,
 -7.588280816552215e-28,  1.513245990849058e-30,  1.231289339377831e-01, -4.933520936061571e-04,  1.409692145992730e-06, -3.311706024482117e-09,  6.420309193120907e-12,
 -9.264363168106981e-15,  4.547733620566906e-18,  2.953660217343953e-20, -1.413946451572450e-22,  4.036910618698858e-25, -8.301794583661634e-28,  1.026177510709799e-30,
  1.502468084247277e-01, -5.965558429325770e-04,  1.668033916885768e-06, -3.748197807392689e-09,  6.607463064546714e-12, -7.177055211666583e-15, -5.753297552579160e-18,
  6.003481750177429e-20, -2.029815256282524e-22,  4.585823981193237e-25, -6.306000026702901e-28, -2.636519588091768e-31,  1.800005428417762e-01, -7.074440159710433e-04,
  1.929814555295335e-06, -4.112979396193784e-09,  6.386854845684168e-12, -3.735380244405299e-15, -1.891186513745675e-17,  9.199441849224922e-20, -2.454900017565820e-22,
  4.071604915734082e-25, -8.578402661178554e-29, -2.279771200057478e-30,  2.123650878822413e-01, -8.252230391205071e-04,  2.188830804525632e-06, -4.378974036045950e-09,
  5.691043410554976e-12,  1.062979790600865e-15, -3.401991470086198e-17,  1.202555758946283e-19, -2.514096130677989e-22,  2.142706153574620e-25,  7.963713569851180e-28,
 -4.601341824692609e-30,  2.473114837225058e-01, -9.490093462678949e-04,  2.438438339334803e-06, -4.519578902743693e-09,  4.470829050054730e-12,  7.095588817998237e-15,
 -4.967405408549505e-17,  1.386215716894269e-19, -2.046346023269236e-22, -1.316408034421451e-25,  1.890276051398581e-27, -6.450629947014230e-30,  2.848063655338785e-01,
 -1.077825179496927e-03,  2.671606251926932e-06, -4.509578990677938e-09,  2.701068959640730e-12,  1.409892926013456e-14, -6.401430119353274e-17,  1.405359585079818e-19,
 -9.434514698317542e-23, -6.056332229624868e-25,  2.937904698783405e-27, -6.810770490359035e-30,  3.248113973480109e-01, -1.210594340876076e-03,  2.880986675199000e-06,
 -4.326187348536866e-09,  3.864843783148877e-13,  2.165915047149159e-14, -7.482468472593917e-17,  1.200320179361860e-19,  8.074017772870987e-23, -1.137274830523451e-24,
  3.569018435980841e-27, -4.698297296900659e-30,  3.672826259808314e-01, -1.346138040416076e-03,  3.059002730322342e-06, -3.950214013826520e-09, -2.432826977704286e-12,
  2.921263730713627e-14, -7.970459662523349e-17,  7.291103679958316e-20,  3.084216456111894e-22, -1.609513433121631e-24,  3.367382129890535e-27,  4.279417639692478e-31,
  4.121697457967859e-01, -1.483171032555665e-03,  3.197958410969135e-06, -3.367359889882398e-09, -5.676555348539328e-12,  3.605940794275724e-14, -7.631551278986976e-17,
 -1.946216340114614e-21,  5.603138934564271e-22, -1.869392783167843e-24,  1.985733387420195e-27,  8.202121808519278e-30,  4.594152641872474e-01, -1.620298293354718e-03,
  3.290174418001303e-06, -2.569622748005061e-09, -9.220514839384789e-12,  4.139244027487854e-14, -6.270065140351944e-17, -1.012941981617036e-19,  7.915002823434624e-22,
 -1.753586987624311e-24, -7.018789716707736e-28,  1.698333149400530e-29,  5.089535567966301e-01, -1.756012565548938e-03,  3.328154288349858e-06, -1.556789656904176e-09,
 -1.289477131699130e-11,  4.434581466695995e-14, -3.766465548022523e-17, -2.164938127775312e-19,  9.437235731754065e-22, -1.129310451498856e-24, -4.441160655691266e-27,
  2.379564303855533e-29,  5.607098008349229e-01, -1.888693191604900e-03,  3.304785347481729e-06, -3.379724571938234e-10, -1.648431457937430e-11,  4.406387645112702e-14,
 -1.185970862648739e-18, -3.330389994397221e-19,  9.531055809503253e-22,  5.294806795027240e-26, -8.484427934556500e-27,  2.480013800465274e-29,  6.145987743787293e-01,
 -2.016606768861903e-03,  3.213578949917905e-06,  1.066880626334438e-09, -1.973315040131997e-11,  3.979224838498265e-14,  4.518379832307154e-17, -4.309867791195314e-19,
  7.628371787140450e-22,  1.704172532314469e-24, -1.159295159166398e-26,  1.644356256074149e-29,  6.705235095437665e-01, -2.137910298515139e-03,  3.048954005774392e-06,
  2.625594456162211e-09, -2.235277885881187e-11,  3.098920977203647e-14,  9.800078492563674e-17, -4.866429401948868e-19,  3.402445290982544e-22,  3.555062109462427e-24,
 -1.222690886366563e-26, -2.782096252838228e-30,  7.283737880308812e-01, -2.250657663633133e-03,  2.806566715319054e-06,  4.292632468016872e-09, -2.403604626085362e-11,
  1.745244831579328e-14,  1.517794990874098e-16, -4.757790953465667e-19, -3.039419309257779e-22,  5.149751606128463e-24, -8.968823670186359e-27, -3.038570852243568e-29,
  7.880244691053599e-01, -2.352810461121512e-03,  2.483687470644323e-06,  6.008398044042397e-09, -2.447725475346419e-11, -5.487156851662662e-16,  1.991210795752111e-16,
 -3.784577358299146e-19, -1.098329647888748e-21,  5.899222152357826e-24, -1.158266847268034e-27, -5.857489342066711e-29,  8.493336429667696e-01, -2.442254426223614e-03,
  2.079622677031152e-06,  7.699202225223053e-09, -2.339911227090115e-11, -2.215186144484507e-14,  2.312337628569841e-16, -1.851801063656597e-19, -1.901989818812973e-21,
  5.212851040494426e-24,  1.039890394738163e-26, -7.478369353401065e-29,  9.121406072287420e-01, -2.516822918708950e-03,  1.596174358844053e-06,  9.278180431528851e-09,
 -2.058651286683948e-11, -4.581440477523283e-14,  2.389439636376153e-16,  9.647222350724140e-20, -2.511884238992652e-21,  2.708112717636840e-24,  2.292718425632905e-26,
 -6.513506732935828e-29,  9.762636715263151e-01, -2.574329172760603e-03,  1.038123343445598e-06,  1.064748697905912e-08, -1.592614841740706e-11, -6.929215264495756e-14,
  2.142427186056943e-16,  4.362247835674578e-19, -2.694240624764459e-21, -1.535587252028125e-24,  3.178325447986919e-26, -2.109275389479503e-29,  1.041497805936903e+00,
 -2.612609221891036e-03,  4.137120430392666e-07,  1.170212309653644e-08, -9.449469594161610e-12, -8.972050430550988e-14,  1.523059642187467e-16,  7.787639416917804e-19,
 -2.243866917244515e-21, -6.759798767592079e-24,  3.155743601514936e-26,  5.229405231927553e-29,  1.107612163938726e+00, -2.629577554054032e-03, -2.649100530366241e-07,
  1.233574160047671e-08, -1.374486124799684e-12, -1.038362484318699e-13,  5.375808140166506e-17,  1.047357842754508e-18, -1.066869074145885e-21, -1.147335190096885e-23,
  1.831378620481783e-26,  1.306812698341339e-28,  1.174347531173581e+00, -2.623297566685464e-03, -9.813312614545332e-07,  1.244869068458262e-08,  7.860612454374136e-12,
 -1.083693948197377e-13, -7.327802935046677e-17,  1.155917973603951e-18,  7.315104078454552e-22, -1.370474545861917e-23, -7.485914722880563e-27,  1.732825157651342e-28,
  1.241413778522284e+00, -2.592068685049777e-03, -1.714685116335852e-06,  1.195837346825602e-08,  1.758174457403597e-11, -1.006110075541730e-13, -2.120472502289941e-16,
  1.030499840280552e-18,  2.788739939976360e-21, -1.164736736546380e-23, -3.867998322582444e-26,  1.391839815239304e-28,  1.308487433027215e+00, -2.534531455832690e-03,
 -2.439712943363512e-06,  1.081166747443547e-08,  2.689315029257164e-11, -7.911946977049171e-14, -3.378275960136654e-16,  6.380495025423067e-19,  4.503553990781252e-21,
 -4.619497827602783e-24, -6.173314141984989e-26,  1.540953698723986e-29,  1.375209523697915e+00, -2.449790874437508e-03, -3.127193042915443e-06,  8.998632708320451e-09,
  3.473432518281495e-11, -4.446236701858818e-14, -4.212449754628172e-16,  1.533787440502089e-20,  5.173827378381174e-21,  6.006072813893429e-24, -6.146991984808241e-26,
 -1.568894243335540e-28,  1.441183911048125e+00, -2.337556468249636e-03, -3.744859680581735e-06,  6.566026596829356e-09,  3.999014133104914e-11,  1.889690374008504e-16,
 -4.346559010366248e-16, -7.143318241273243e-19,  4.261095662773712e-21,  1.651320499829517e-23, -3.000073405481184e-26, -2.824877712593239e-28,  1.505976367648849e+00,
 -2.198295060745741e-03, -4.258931528595064e-06,  3.628282486682044e-09,  4.165728426531472e-11,  4.886878942538055e-14, -3.610288063514344e-16, -1.352033638572187e-18,
  1.716785519167465e-21,  2.183797398822542e-23,  2.414156181802166e-26, -2.587781996347720e-28,  1.569114737952663e+00, -2.033388558199041e-03, -4.636339226727337e-06,
  3.727366901387071e-10,  3.905618302304533e-11,  9.331296628348775e-14, -2.032346784394059e-16, -1.673351852215689e-18, -1.785355946206529e-21,  1.801363154828399e-23,
  7.418226830542772e-26, -5.860709765271246e-29,  1.630090561645091e+00, -1.845284547294514e-03, -4.847672564133670e-06, -2.944713217180439e-09,  3.205696199527590e-11,
  1.243469589675895e-13,  9.984066274000487e-18, -1.514824910511036e-18, -4.917656453668398e-21,  5.164150222796394e-24,  8.724236512757777e-26,  2.100707388834874e-28,
  1.688362583961526e+00, -1.637622245658260e-03, -4.870748294601649e-06, -6.017235907668749e-09,  2.126379985501461e-11,  1.341366360964888e-13,  2.259196149384005e-16,
 -8.691737435314408e-19, -6.202056058109370e-21, -1.101237073811359e-23,  4.809339302977975e-26,  3.478029213682816e-28,  1.743362582173547e+00, -1.415311090736459e-03,
 -4.694526438663884e-06, -8.520363109884900e-09,  8.082643089439650e-12,  1.188757403215464e-13,  3.809212402495665e-16,  6.256290836822046e-20, -4.834194091063152e-21,
 -2.140660944378548e-23, -2.193210196332639e-26,  2.246921973387613e-28,  1.794503889233023e+00, -1.184535192931593e-03, -4.322889382280390e-06, -1.016032285396580e-08,
 -5.404117673889071e-12,  8.102168371437484e-14,  4.233823027797843e-16,  9.169037156347705e-19, -1.372428000214867e-21, -1.932502745081717e-23, -7.307583614478466e-26,
 -6.722270672239298e-29,  1.841192871674476e+00, -9.526557597681582e-04, -3.777583487823827e-06, -1.073203702234832e-08, -1.680055023598177e-11,  2.990214679619799e-14,
  3.387854805044842e-16,  1.327249213574109e-18,  2.320953055529351e-21, -6.275552665678983e-24, -6.647229643821049e-26, -2.626544715861820e-28,  1.882843402127610e+00,
 -7.279874842456327e-04, -3.099477428434742e-06, -1.017572908901276e-08, -2.396916386367633e-11, -2.027506933002731e-14,  1.632670440577034e-16,  1.132646376515199e-18,
  4.149148703236396e-21,  7.968591483787795e-24, -1.296026908934665e-26, -1.905196949185113e-28,  1.918894053121381e+00, -5.194356208744034e-04, -2.347308054511127e-06,
 -8.616336785370804e-09, -2.568079883337775e-11, -5.504658993861453e-14, -2.684569768150613e-17,  5.003731925133159e-19,  3.283594454652284e-21,  1.304812545252070e-23,
  3.426389015749536e-26,  2.655579216638264e-29,  1.948827348492916e+00, -3.359987614739326e-04, -1.593351072619819e-06, -6.368842226567682e-09, -2.211868730913736e-11,
 -6.551745236936550e-14, -1.507861854384447e-16, -1.590143643854916e-19,  8.507882036697469e-22,  7.345940372064574e-24,  3.546611795163589e-26,  1.284804765965960e-28,
  1.972190003403619e+00, -1.861666706350326e-04, -9.160044054385414e-07, -3.897777410294192e-09, -1.499102402443872e-11, -5.268051125110885e-14, -1.677503449303235e-16,
 -4.681437011073011e-19, -1.034361702862163e-21, -1.032605351423635e-24,  6.131795488536618e-27,  5.370421553870720e-29,  1.988612858308710e+00, -7.726793042254678e-05,
 -3.900325258861809e-07, -1.731163562737853e-09, -7.104802870471214e-12, -2.751378954577870e-14, -1.013861003927127e-16, -3.561707902860339e-19, -1.188978095920459e-21,
 -3.735940675716309e-24, -1.082563428172334e-26, -2.760443043884338e-29,  1.997831196270730e+00, -1.482858074428212e-05, -7.592429525937014e-08, -3.448591214791676e-10,
 -1.464860066932648e-12, -5.955632623579245e-15, -2.345879442156982e-17, -9.015082486727223e-20, -3.394507137632575e-22, -1.255701104895904e-24, -4.570968869691737e-27,
 -1.638814843167277e-29,  3.370489884193893e-04, -1.392638339737896e-06,  4.315001725073511e-09, -1.188256919786589e-11,  3.066926986371633e-14, -7.597598209574421e-17,
  1.829169793543804e-19, -4.312884773051204e-22,  1.000478182754973e-24, -2.291696796980278e-27,  5.192558180303611e-30, -1.166808938682693e-32,  3.033181088011815e-03,
 -1.252261012811920e-05,  3.873112482536263e-08, -1.063226384340600e-10,  2.730913866863990e-13, -6.718283745290583e-16,  1.602245748041136e-18, -3.731402661439448e-21,
  8.520753470517601e-24, -1.913931095790298e-26,  4.233754584083953e-29, -9.241970101316826e-32,  8.424053934878382e-03, -3.472308102246743e-05,  1.070093285275684e-07,
 -2.919017007479497e-10,  7.423927387304050e-13, -1.800476643295087e-15,  4.210364362337882e-18, -9.551664858234735e-21,  2.107762827770620e-23, -4.530460680320418e-26,
  9.471529528202393e-29, -1.923589708906074e-31,  1.650685731263184e-02, -6.787469087515493e-05,  2.080417502874620e-07, -5.620571120465106e-10,  1.407942942913699e-12,
 -3.339187769247907e-15,  7.566028335330848e-18, -1.643176284909533e-20,  3.415041477719625e-23, -6.756177319051772e-26,  1.255164200569737e-28, -2.136527866993715e-31,
  2.727730666133827e-02, -1.117973620819694e-04,  3.401672654684863e-07, -9.070449330094811e-10,  2.224939045721488e-12, -5.112271674742057e-15,  1.105621213454041e-17,
 -2.242341806347386e-20,  4.202675025833118e-23, -7.037468769480954e-26,  9.559454538333259e-29, -6.583899212795512e-32,  4.072955871027849e-02, -1.662490537335874e-04,
  5.011726112258299e-07, -1.314063484262457e-09,  3.135787890504606e-12, -6.901053202948257e-15,  1.395260734108470e-17, -2.536178214778962e-20,  3.895229963842080e-23,
 -4.029043816273928e-26, -2.118730852907282e-29,  2.848567876093553e-31,  5.685609682264423e-02, -2.309240994585915e-04,  6.882944328775610e-07, -1.767423971973419e-09,
  4.071966568732231e-12, -8.456951821170104e-15,  1.548333751110515e-17, -2.319521776896047e-20,  2.044781642770928e-23,  2.941963564927790e-26, -2.235121974706824e-28,
  7.765405567076739e-31,  7.564758414715746e-02, -3.054511293703032e-04,  8.982227487582785e-07, -2.248773247196821e-09,  4.956372837106022e-12, -9.517448625577891e-15,
  1.491660300885751e-17, -1.434602021766904e-20, -1.538003707312192e-23,  1.347799869160836e-25, -4.731525372857978e-28,  1.239031530039503e-30,  9.709268213413638e-02,
 -3.893905783513099e-04,  1.127106487072146e-06, -2.737375030951397e-09,  5.706176389707532e-12, -9.824620546319127e-15,  1.165193087244741e-17,  1.931892967330136e-21,
 -6.673492447994445e-23,  2.587533305603032e-25, -6.942999097476937e-28,  1.419676866027618e-30,  1.211778313949196e-01, -4.822317860452342e-04,  1.370561928857953e-06,
 -3.210457173094816e-09,  6.236177788614300e-12, -9.145791344479032e-15,  5.313553277726884e-18,  2.523817948495807e-20, -1.274485292019922e-22,  3.713959783057343e-25,
 -7.843900850611017e-28,  1.051601462292193e-30,  1.478869912554591e-01, -5.833896988173735e-04,  1.623685100023144e-06, -3.643633670973876e-09,  6.462673598644299e-12,
 -7.295681555695067e-15, -4.160811357260210e-18,  5.379866536557612e-20, -1.869287603041475e-22,  4.331945635018373e-25, -6.371871219491646e-28, -4.323744932123784e-32,
  1.772013336692126e-01, -6.922011911488954e-04,  1.881069397726407e-06, -4.011411180584635e-09,  6.307812506158765e-12, -4.159229059534918e-15, -1.644380320572954e-17,
  8.437241255940460e-20, -2.309169302009477e-22,  4.018574876114487e-25, -1.761459004283697e-28, -1.837545128042674e-30,  2.090988864037397e-01, -8.079210341410944e-04,
  2.136830017215954e-06, -4.287790498108605e-09,  5.704406299157156e-12,  2.860059518176117e-16, -3.076418885794918e-17,  1.123396509589956e-19, -2.431696327658485e-22,
  2.422560488838804e-25,  6.072559655362994e-28, -4.003320657597048e-30,  2.435541195933627e-01, -9.297175529040926e-04,  2.384637068929764e-06, -4.446973812384876e-09,
  4.601129606221791e-12,  5.949244538583197e-15, -4.588493794526396e-17,  1.320114871440676e-19, -2.080795438035001e-22, -6.153822815658622e-26,  1.619001370352679e-27,
 -5.881188649978887e-30,  2.805374688527080e-01, -1.056668033687647e-03,  2.617759645196125e-06, -4.464188201776367e-09,  2.968001002406634e-12,  1.260944561215818e-14,
 -6.012468034126144e-17,  1.371901675538640e-19, -1.141042544398733e-22, -4.940414868557091e-25,  2.643525931152343e-27, -6.557959300408868e-30,  3.200147871720946e-01,
 -1.187753967049776e-03,  2.829123511630599e-06, -4.316634558314715e-09,  8.019830479213458e-13,  1.990394389718881e-14, -7.143357749707609e-17,  1.219877740469444e-19,
  4.231699320095839e-23, -9.987738740348680e-25,  3.353239435614055e-27, -5.081794804874792e-30,  3.619467167700775e-01, -1.321856246843623e-03,  3.011385556378356e-06,
 -3.984568444793421e-09, -1.867532432542350e-12,  2.732528774021559e-14, -7.753343994490272e-17,  8.187945951155870e-20,  2.529047014541104e-22, -1.474823999791350e-24,
  3.358061104840093e-27, -8.119818446922257e-31,  4.062879709734386e-01, -1.457750488401873e-03,  3.157028619865000e-06, -3.452514768483909e-09, -4.973677117452031e-12,
  3.422914618353054e-14, -7.612899017794720e-17,  1.492305633995015e-20,  4.945267804273056e-22, -1.783365761770415e-24,  2.300679609967224e-27,  6.151209398798497e-30,
  4.529865150547857e-01, -1.594102685501920e-03,  3.258480827251148e-06, -2.710610870218240e-09, -8.407929382028781e-12,  3.985639336599027e-14, -6.519181761478271e-17,
 -7.698025495096097e-20,  7.280393741786524e-22, -1.767431248727832e-24, -7.870181227317446e-30,  1.457635469813151e-29,  5.019826338238967e-01, -1.729465497446910e-03,
  3.308264018078036e-06, -1.756061782459009e-09, -1.201736807634012e-11,  4.337249477773070e-14, -4.331003864030124e-17, -1.869774106884419e-19,  9.001182618568708e-22,
 -1.286550011616246e-24, -3.434387431663173e-27,  2.193384182496250e-29,  5.532078727064520e-01, -1.862275548285002e-03,  3.299176252430957e-06, -5.946759252636911e-10,
 -1.560405920505670e-11,  4.392695794876015e-14, -1.008423960678699e-17, -3.025724872235525e-19,  9.491659964073970e-22, -2.646028502195778e-25, -7.394081372418830e-27,
  2.466944931226129e-29,  6.065838381520795e-01, -1.990852233562556e-03,  3.224513577645849e-06,  7.575718466557746e-10, -1.892742431511998e-11,  4.073465993004151e-14,
  3.346651292118503e-17, -4.056824168423776e-19,  8.160226070750233e-22,  1.255766857306010e-24, -1.080799085265282e-26,  1.910004504637446e-29,  6.620208426386301e-01,
 -2.113398669979942e-03,  3.078336126709624e-06,  2.273031451783737e-09, -2.171057133317311e-11,  3.317906178345811e-14,  8.454577831073243e-17, -4.738019248986517e-19,
  4.594099130940219e-22,  3.065286146604815e-24, -1.222004670125565e-26,  2.962084239102330e-30,  7.194163794905865e-01, -2.228005593565661e-03,  2.855782991807879e-06,
  3.911041493019311e-09, -2.365165424411014e-11,  2.093436422749878e-14,  1.383488807757588e-16, -4.826106967806030e-19, -1.253096844919557e-22,  4.766556573072464e-24,
 -1.013457324504793e-26, -2.265135519569098e-29,  7.786534135003930e-01, -2.332659215228800e-03,  2.553438899640613e-06,  5.616930155503487e-09, -2.444131804464831e-11,
  4.099252654773494e-15,  1.880640455092489e-16, -4.102201976320982e-19, -8.873947200105848e-22,  5.803334083746565e-24, -3.585635143345737e-27, -5.164592667197580e-29,
  8.395984753368817e-01, -2.425254279380156e-03,  2.169753140348812e-06,  7.321571775481357e-09, -2.378710818381325e-11, -1.667117313564024e-14,  2.252253755945740e-16,
 -2.429673084528986e-19, -1.707628778264782e-21,  5.563485284363321e-24,  7.148230294095465e-27, -7.267052754388573e-29,  9.020995514908823e-01, -2.503613838318646e-03,
  1.705506992698029e-06,  8.941778260041061e-09, -2.144528214930218e-11, -4.005632168466041e-14,  2.405357468804363e-16,  1.782306636959154e-20, -2.398594334764936e-21,
  3.565826230652335e-24,  1.991214107250891e-26, -7.149914935794985e-29,  9.659837677655865e-01, -2.565517542039517e-03,  1.164319460010619e-06,  1.038186520947747e-08,
 -1.725963439496968e-11, -6.401354060286177e-14,  2.252434195671592e-16,  3.493678491999333e-19, -2.726905075356328e-21, -2.875791951818262e-25,  3.050273632351907e-26,
 -3.679493224023963e-29,  1.031054873996656e+00, -2.608740528942443e-03,  5.531718188239052e-07,  1.153678217438071e-08, -1.120560286774966e-11, -8.581182634574284e-14,
  1.730712793764030e-16,  7.033143162227945e-19, -2.463999211804876e-21, -5.457574418065686e-24,  3.340243750054240e-26,  3.152685007953562e-29,  1.097090551942766e+00,
 -2.631105250068184e-03, -1.170813822824841e-07,  1.229721601987355e-08, -3.435955284202769e-12, -1.021983763627779e-13,  8.254512172340271e-17,  1.006761748881440e-18,
 -1.465378255169851e-21, -1.063026404622929e-23,  2.372389487456582e-26,  1.146682058901016e-28,  1.163839588507736e+00, -2.630548706825138e-03, -8.312641576013769e-07,
  1.255703687220385e-08,  5.678271182526407e-12, -1.097374915140246e-13, -4.065910492002230e-17,  1.171389541432973e-18,  2.345937268917585e-22, -1.385105759981317e-23,
  1.757604466006657e-28,  1.740316935711500e-28,  1.231018984204170e+00, -2.605207536495235e-03, -1.569564058959178e-06,  1.222331709733619e-08,  1.552102069051068e-11,
 -1.053442073386538e-13, -1.820089920782117e-16,  1.112744459784247e-18,  2.343129982974188e-21, -1.306457833226021e-23, -3.200331541878490e-26,  1.635037624024323e-28,
  1.298311103648366e+00, -2.553523007496275e-03, -2.307444819778409e-06,  1.122886460184777e-08,  2.523121281882803e-11, -8.699683324634059e-14, -3.179730050268875e-16,
  7.790278706072565e-19,  4.293077911287696e-21, -7.063142121550459e-24, -6.014843874919540e-26,  5.665958692970324e-29,  1.365361022251949e+00, -2.474367107823868e-03,
 -3.015906078484582e-06,  9.546719114069029e-09,  3.374411130807519e-11, -5.454820184782427e-14, -4.184685940766027e-16,  1.838723871821706e-19,  5.344214225101082e-21,
  3.419225839126178e-24, -6.761161149131265e-26, -1.210959559293936e-28,  1.431774281790174e+00, -2.367189302526984e-03, -3.662230037017662e-06,  7.205325785596604e-09,
  3.988806512116752e-11, -1.046683954604985e-14, -4.526606439383084e-16, -5.687210899231942e-19,  4.830973537973294e-21,  1.506457165141314e-23, -4.241247217390451e-26,
 -2.799390016465143e-28,  1.497115336341277e+00, -2.232180953475313e-03, -4.211362345929876e-06,  4.302134509362548e-09,  4.254498191630317e-11,  3.975675518264921e-14,
 -3.979972452593298e-16, -1.284354501403659e-18,  2.517473134433657e-21,  2.256310502898610e-23,  1.180787794451313e-26, -3.009035642935821e-28,  1.560907045802536e+00,
 -2.070450617335580e-03, -4.628056308570673e-06,  1.012284636508059e-09,  4.086984011599623e-11,  8.786725146684702e-14, -2.507868315712635e-16, -1.719540840006282e-18,
 -1.084242139840282e-21,  2.091095631093851e-23,  7.021834979826196e-26, -1.225043732868026e-28,  1.622631649455765e+00, -1.884198365529270e-03, -4.879849583391160e-06,
 -2.411908031215179e-09,  3.454277064453166e-11,  1.240600094397008e-13, -3.460128916642667e-17, -1.668524344796598e-18, -4.666792627363828e-21,  8.828885375163231e-24,
  9.572675876331944e-26,  1.733109251776941e-28,  1.681733714132718e+00, -1.676871069826138e-03, -4.940824339833519e-06, -5.655267331605207e-09,  2.399866459075141e-11,
  1.392438855514284e-13,  1.987474529033804e-16, -1.073580960095177e-18, -6.560112452523254e-21, -8.774607207622152e-24,  6.397583504720493e-26,  3.726111104888892e-28,
  1.737625581186015e+00, -1.453273897276186e-03, -4.795914794395687e-06, -8.371523708774289e-09,  1.055162750267345e-11,  1.280206731557602e-13,  3.803903405968372e-16,
 -1.046103510493251e-19, -5.618067175943638e-21, -2.206705302674947e-23, -1.060784309073982e-26,  2.908733340708342e-28,  1.789695808138400e+00, -1.219607346624035e-03,
 -4.445276765529377e-06, -1.023326454562373e-08, -3.680021158965454e-12,  9.148531280226322e-14,  4.483321198591689e-16,  8.612855770757407e-19, -2.121348227662538e-21,
 -2.229515203123655e-23, -7.510846953841998e-26, -2.299720909275030e-29,  1.837320985276990e+00, -9.833960868126975e-04, -3.907959583586226e-06, -1.099560692282361e-08,
 -1.611814616402089e-11,  3.848711896751548e-14,  3.769504909533707e-16,  1.397368888633259e-18,  2.044337672889171e-21, -9.171023011100294e-24, -7.842599391980729e-26,
 -2.797450376135139e-28,  1.879881077953381e+00, -7.532782876622198e-04, -3.223899879020053e-06, -1.056225576562222e-08, -2.433283366799386e-11, -1.596082669896829e-14,
  1.968822750292337e-16,  1.269891796758653e-18,  4.424544594200097e-21,  7.269064293619440e-24, -2.236045879845851e-26, -2.378004721207587e-28,  1.916778088895419e+00,
 -5.386347385271896e-04, -2.453205883226903e-06, -9.036067045062727e-09, -2.678697551295001e-11, -5.551044427163302e-14, -1.129168385470193e-17,  6.132304393173234e-19,
  3.778232575327947e-21,  1.443690473366490e-23,  3.503561519049645e-26,  7.382676476442458e-30,  1.947457367171358e+00, -3.490573916359824e-04, -1.671944455755733e-06,
 -6.733422096318980e-09, -2.346556871260651e-11, -6.918641877270292e-14, -1.548156607614160e-16, -1.272727317480561e-19,  1.142184644143886e-21,  8.882556706333931e-24,
  4.148781289363255e-26,  1.453777723494879e-28,  1.971430378555566e+00, -1.936859582707289e-04, -9.642523627235686e-07, -4.146285947376985e-09, -1.608597555152286e-11,
 -5.686758860217408e-14, -1.813269856068273e-16, -5.017858528929608e-19, -1.066513762265891e-21, -7.359272750936711e-25,  8.810291609490833e-27,  6.856746251770688e-29,
  1.988297411713690e+00, -8.047326168408540e-05, -4.115071465250401e-07, -1.849378292185029e-09, -7.680241878880399e-12, -3.007115600549320e-14, -1.119123734455758e-16,
 -3.964559863962583e-19, -1.331566068763882e-21, -4.194019899037071e-24, -1.209721843075884e-26, -3.019677136360476e-29,  1.997770640375038e+00, -1.545293604178326e-05,
 -8.020726349038180e-08, -3.692812549045447e-10, -1.589813817750837e-12, -6.550204887748999e-15, -2.614214729465267e-17, -1.017732803965340e-19, -3.881285643298763e-22,
 -1.453818334697655e-24, -5.357073359949387e-27, -1.943525798777773e-29,  3.315465836394511e-04, -1.358680461171346e-06,  4.175305762035078e-09, -1.140378255518225e-11,
  2.919269051317011e-14, -7.172734461278467e-17,  1.712769936409638e-19, -4.005540889132957e-22,  9.215952785919500e-25, -2.093905531216576e-27,  4.705589717098858e-30,
 -1.048916057521873e-32,  2.983702368513658e-03, -1.221779134308299e-05,  3.748103320269026e-08, -1.020586144352141e-10,  2.600310519302560e-13, -6.345980419841926e-16,
  1.501482474127022e-18, -3.469443736655443e-21,  7.861266305434711e-24, -1.752440552286475e-26,  3.847354367973231e-29, -8.338108561299372e-32,  8.286851857030741e-03,
 -3.388081844655809e-05,  1.035766070463070e-07, -2.803060924557315e-10,  7.073724177331702e-13, -1.702562522561866e-15,  3.952120454030577e-18, -8.902561246587882e-21,
  1.951286520102389e-23, -4.168007504678384e-26,  8.663680878520839e-29, -1.751229638106936e-31,  1.623864503483347e-02, -6.623695766598672e-05,  2.014300551382626e-07,
 -5.400545831391595e-10,  1.342938395881997e-12, -3.163002886799185e-15,  7.120879520266718e-18, -1.537691429769254e-20,  3.180633682100982e-23, -6.272478951176129e-26,
  1.164387771355935e-28, -1.990974270697426e-31,  2.683549179809129e-02, -1.091189646096190e-04,  3.294929924461353e-07, -8.722496652118420e-10,  2.125297022384499e-12,
 -4.854307197955293e-15,  1.044680877304296e-17, -2.111836569951177e-20,  3.956136915973177e-23, -6.661125269412583e-26,  9.252211936601346e-29, -7.340977912918446e-32,
  4.007248257875925e-02, -1.623019053293020e-04,  4.857003886392204e-07, -1.264977091254184e-09,  3.001058653919538e-12, -6.574572679527012e-15,  1.325970899075475e-17,
 -2.413865579904619e-20,  3.748947376206135e-23, -4.090207227410861e-26, -9.747740950298139e-30,  2.363267144429352e-31,  5.594328035836538e-02, -2.255014854958018e-04,
  6.674707372177685e-07, -1.703605648369256e-09,  3.906491312619709e-12, -8.093070456223400e-15,  1.484317933085482e-17, -2.252560234499643e-20,  2.135396674575172e-23,
  2.113386370134639e-26, -1.914650617260062e-28,  6.819691659400504e-31,  7.443998217122216e-02, -2.983719547035212e-04,  8.717070627004625e-07, -2.170974759851415e-09,
  4.769571043678383e-12, -9.164321675044670e-15,  1.450872818007948e-17, -1.476409640155297e-20, -1.085581772304576e-23,  1.169082366297628e-25, -4.213078696378374e-28,
  1.119177259879084e-30,  9.555294765562958e-02, -3.805035832108744e-04,  1.094799344642375e-06, -2.647632939727145e-09,  5.512483612417851e-12, -9.544557984297042e-15,
  1.167748948766457e-17, -5.982216478232371e-23, -5.790489799357170e-23,  2.322030081489443e-25, -6.338993980253839e-28,  1.325898519670769e-30,  1.192705916232775e-01,
 -4.714197101737473e-04,  1.332629102707561e-06, -3.112134494086346e-09,  6.054592124587865e-12, -9.010234751525339e-15,  5.965092709677513e-18,  2.136778585476829e-20,
 -1.146318536495953e-22,  3.409488271634090e-25, -7.379238883073377e-28,  1.057648248364946e-30,  1.455791369726358e-01, -5.705733657083685e-04,  1.580577081282369e-06,
 -3.541403127957218e-09,  6.315879955360429e-12, -7.378126377218029e-15, -2.735883438375223e-18,  4.806154566502859e-20, -1.717924804880930e-22,  4.077243361875932e-25,
 -6.350270635910900e-28,  1.349576174999723e-31,  1.744623235614252e-01, -6.773434744361633e-04,  1.833535201169083e-06, -3.911172311481481e-09,  6.220868509990087e-12,
 -4.526352886486516e-15, -1.418266216215930e-17,  7.721302980453200e-20, -2.165952969008840e-22,  3.933117875396571e-25, -2.483394487764003e-28, -1.453069605350492e-30,
  2.059010678661161e-01, -7.910306561694220e-04,  2.085924215943690e-06, -4.196513299113457e-09,  5.702993289621238e-12, -4.154595417776362e-16, -2.772627606017393e-17,
  1.047021155905443e-19, -2.340521368863397e-22,  2.631879283234823e-25,  4.433175966583570e-28, -3.456912918686465e-30,  2.398730673831134e-01, -9.108526509280972e-04,
  2.331718827708008e-06, -4.372462450327626e-09,  4.709397618250006e-12,  4.891607859446931e-15, -4.228208275878887e-17,  1.253294981691633e-19, -2.091900961563008e-22,
 -1.788323555335550e-27,  1.372556305078016e-27, -5.323544052655337e-30,  2.763523427583252e-01, -1.035939411600056e-03,  2.564482386688770e-06, -4.414759778599261e-09,
  3.206068939163209e-12,  1.121212086124150e-14, -5.633700585187026e-17,  1.332741123856938e-19, -1.300551458086986e-22, -3.939823476758187e-25,  2.361735022061156e-27,
 -6.241917193230985e-30,  3.153087095629489e-01, -1.165327929621557e-03,  2.777413725349826e-06, -4.300710184249375e-09,  1.183195188709927e-12,  1.823064663897266e-14,
 -6.800418516987982e-17,  1.227920688971540e-19,  8.720856456235764e-24, -8.691935199058273e-25,  3.124128916836656e-27, -5.308657572876827e-30,  3.567071704612080e-01,
 -1.297956888765259e-03,  2.963409161284072e-06, -4.010177225955120e-09, -1.339444479238925e-12,  2.549286304955559e-14, -7.513531119096947e-17,  8.914874662408017e-20,
  2.022173504037082e-22, -1.341529338069622e-24,  3.299318283135365e-27, -1.821991049187432e-30,  4.005072172445183e-01, -1.432661281607845e-03,  3.115143239771524e-06,
 -3.526716037690918e-09, -4.307322313595586e-12,  3.240879410064406e-14, -7.549911864728982e-17,  2.973895186855467e-20,  4.320422662849053e-22, -1.686478365242431e-24,
  2.530422188255952e-27,  4.329483508443400e-30,  4.466620308501152e-01, -1.568167175136509e-03,  3.225172363547202e-06, -2.838846413763715e-09, -7.626608785948514e-12,
  3.826849820424294e-14, -6.703066182189191e-17, -5.469988289323926e-20,  6.645544836193617e-22, -1.755605444028653e-24,  5.823870401288837e-28,  1.227391813762110e-29,
  4.951175660694793e-01, -1.703086879441293e-03,  3.286066047534244e-06, -1.941458270830268e-09, -1.116072001832433e-11,  4.227344057038785e-14, -4.814929423330337e-17,
 -1.589393397550878e-19,  8.515569711940935e-22, -1.405209609652051e-24, -2.513317228094112e-27,  1.991332770688295e-29,  5.458115062339267e-01, -1.835914860344578e-03,
  3.290571093118371e-06, -8.373285279947209e-10, -1.472860880458789e-11,  4.358669323657680e-14, -1.813286962757041e-17, -2.724065542955849e-19,  9.345768083469204e-22,
 -5.388110195555951e-25, -6.320975659619919e-27,  2.403275069500533e-29,  5.986720718243673e-01, -1.965024847570909e-03,  3.231814422885865e-06,  4.612904350320656e-10,
 -1.810560382478099e-11,  4.140453651597296e-14,  2.247919442108413e-17, -3.789281283842838e-19,  8.536565895435827e-22,  8.408585022327391e-25, -9.923879163613482e-27,
  2.096130703551866e-29,  6.536166658176347e-01, -2.088668729605804e-03,  3.103550532335384e-06,  1.931076728599044e-09, -2.102776468759735e-11,  3.505072284125534e-14,
  7.150105871985841e-17, -4.574291951464115e-19,  5.610070478849912e-22,  2.580601060582358e-24, -1.197833132152933e-26,  7.887627893426034e-30,  7.105503378445122e-01,
 -2.204977999919999e-03,  2.900459319413820e-06,  3.536140329727224e-09, -2.320085946852927e-11,  2.409228276386813e-14,  1.248048706834493e-16, -4.839551263564771e-19,
  3.876932576039968e-23,  4.343437405228402e-24, -1.096783961805963e-26, -1.530206276793489e-29,  7.693640491732957e-01, -2.311968731618191e-03,  2.618499184059402e-06,
  5.226766222164236e-09, -2.431514376844788e-11,  8.471938886047198e-15,  1.762115123217600e-16, -4.353061049573559e-19, -6.815843049893982e-22,  5.616629922711001e-24,
 -5.695125400451587e-27, -4.417484604980559e-29,  8.299327215437922e-01, -2.407551312349568e-03,  2.255318381064374e-06,  6.938601928976338e-09, -2.406705972639667e-11,
 -1.135338903973680e-14,  2.176877403444442e-16, -2.943578736658318e-19, -1.502958200274688e-21,  5.786473352469841e-24,  4.028984093040711e-27, -6.885686148870787e-29,
  8.921130555119446e-01, -2.489546468984900e-03,  1.810724163674267e-06,  8.592558408001033e-09, -2.218868388310245e-11, -3.428602457070720e-14,  2.399805806421687e-16,
 -5.673055067193238e-20, -2.256658365299751e-21,  4.298072232373997e-24,  1.667189587292099e-26, -7.538134153160238e-29,  9.557411089769848e-01, -2.555709446826461e-03,
  1.287203628774438e-06,  1.009576575862050e-08, -1.848510539064933e-11, -5.850017265480252e-14,  2.338041687770859e-16,  2.621733031805056e-19, -2.715724340833120e-21,
  8.959857109467883e-25,  2.857649060782590e-26, -5.038541519168526e-29,  1.020629634952401e+00, -2.603764565706595e-03,  6.904815801927055e-07,  1.134399485425014e-08,
 -1.287875395455876e-11, -8.143088411260605e-14,  1.916325245757155e-16,  6.215829924269455e-19, -2.636143519958612e-21, -4.099844734562373e-24,  3.433357270597336e-26,
  1.087828067943424e-29,  1.086565190705520e+00, -2.631452723932356e-03,  3.008828193955676e-08,  1.222600611852488e-08, -5.457857507495216e-12, -9.988466712020034e-14,
  1.100217915988233e-16,  9.539393096972968e-19, -1.829819560401026e-21, -9.585815021278563e-24,  2.835966563846053e-26,  9.561161092275558e-29,  1.153305049748892e+00,
 -2.636594704916367e-03, -6.801071690958133e-07,  1.263028935400224e-08,  3.476422308841563e-12, -1.103193351784124e-13, -7.829965526904147e-18,  1.170934611767113e-18,
 -2.620811234679346e-22, -1.369192020167402e-23,  7.745315567703460e-27,  1.691217759445439e-28,  1.220573975752430e+00, -2.617173269640591e-03, -1.421464502488334e-06,
  1.245457175559700e-08,  1.337302000331593e-11, -1.093305113100499e-13, -1.498748086127873e-16,  1.179966795894716e-18,  1.851552022551424e-21, -1.419481704751399e-23,
 -2.437008895981499e-26,  1.825113502510981e-28,  1.288060955406071e+00, -2.571436852554838e-03, -2.170334988224034e-06,  1.161823756929601e-08,  2.341680863990715e-11,
 -9.435115964843303e-14, -2.942784302398187e-16,  9.118792477726243e-19,  3.996208699396926e-21, -9.407159778509837e-24, -5.675641800539341e-26,  9.727635180070777e-29,
  1.355416037718021e+00, -2.498027021984419e-03, -2.898143778232099e-06,  1.007735359906565e-08,  3.255323211767756e-11, -6.451024747413781e-14, -4.109112326321575e-16,
  3.563250446312879e-19,  5.417450694513971e-21,  6.202329163132833e-25, -7.202933596485553e-26, -7.873494961655874e-29,  1.422247491795412e+00, -2.396130457401822e-03,
 -3.571945707514771e-06,  7.841264770085130e-09,  3.956889227941143e-11, -2.150382767822642e-14, -4.663415019440518e-16, -4.058040872094098e-19,  5.339819936989624e-21,
  1.312487923787750e-23, -5.447406598813072e-26, -2.664661308157643e-28,  1.488119574104689e+00, -2.265653720552791e-03, -4.155627888228845e-06,  4.988684258805399e-09,
  4.324173500630763e-11,  2.978313451139837e-14, -4.327087351821975e-16, -1.190734418197971e-18,  3.334955221012339e-21,  2.275968939163592e-23, -2.234837398597608e-27,
 -3.360361149375457e-28,  1.552551287233217e+00, -2.107415230193053e-03, -4.611928500097726e-06,  1.679917381101203e-09,  4.256307914619964e-11,  8.126739584729716e-14,
 -2.993027475408294e-16, -1.741661520635181e-18, -2.823701931560418e-22,  2.359199290770903e-23,  6.333479487930947e-26, -1.909315543270915e-28,  1.615016608607876e+00,
 -1.923343349950290e-03, -4.905394684457257e-06, -1.839435403404683e-09,  3.701179644131252e-11,  1.226523996575786e-13, -8.335756077153749e-17, -1.812023158340768e-18,
 -4.278316696379361e-21,  1.279653934396754e-23,  1.022855448675889e-25,  1.224525083241606e-28,  1.674946756360248e+00, -1.716662376457948e-03, -5.006290964499514e-06,
 -5.248761160610074e-09,  2.682868304177353e-11,  1.436291064312214e-13,  1.657044760140803e-16, -1.288032453637182e-18, -6.825937322266920e-21, -5.882658217823112e-24,
  8.072403193558646e-26,  3.866203520478634e-28,  1.731735119036828e+00, -1.492039980919063e-03, -4.895274025869163e-06, -8.181719702826223e-09,  1.320298927731874e-11,
  1.370938409972307e-13,  3.748244969014435e-16, -2.971547635953341e-19, -6.416848678547278e-21, -2.221496603171312e-23,  3.723200290902902e-27,  3.609920253538952e-28,
  1.784745475370592e+00, -1.255661615516156e-03, -4.568366925996397e-06, -1.027691455730380e-08, -1.740804664922294e-12,  1.025262424493100e-13,  4.713729498129281e-16,
  7.799795505657092e-19, -2.978151320303973e-21, -2.530367222246279e-23, -7.489418998592023e-26,  3.514878898262088e-29,  1.833324031802139e+00, -1.015191874988923e-03,
 -4.041427178294907e-06, -1.124683434714882e-08, -1.525472960493159e-11,  4.801051171053587e-14,  4.169385924108639e-16,  1.456875436898169e-18,  1.654714396890384e-21,
 -1.255778283540483e-23, -9.098480807037461e-26, -2.896925323149668e-28,  1.876815570299611e+00, -7.795831160331579e-04, -3.352992569022566e-06, -1.095386572185034e-08,
 -2.460183465356760e-11, -1.079273419824677e-14,  2.344594277874110e-16,  1.415470208709408e-18,  4.667471208329031e-21,  6.150080519872263e-24, -3.397828214725642e-26,
 -2.912781651665674e-28,  1.914583601508557e+00, -5.587014873100420e-04, -2.564246905449526e-06, -9.473548958713519e-09, -2.789843091515937e-11, -5.556124726026230e-14,
  7.651479132051144e-18,  7.427202235705689e-19,  4.323199638959444e-21,  1.583752164779964e-23,  3.479928680947793e-26, -1.954986473047241e-29,  1.946033865602355e+00,
 -3.627626406579963e-04, -1.755044535608965e-06, -7.120144035777506e-09, -2.488671885950801e-11, -7.294032089338099e-14, -1.578171686704606e-16, -8.527336616661417e-20,
  1.493416179770721e-21,  1.067513534499039e-23,  4.826893193985228e-26,  1.629164597032767e-28,  1.970639885274006e+00, -2.016034622822776e-04, -1.015590359498815e-06,
 -4.413001667439805e-09, -1.726800387597317e-11, -6.139191471360486e-14, -1.958582499183998e-16, -5.362639691283046e-19, -1.085890452937047e-21, -3.180507027779975e-25,
  1.221711820886440e-26,  8.691955505851506e-29,  1.987968790989166e+00, -8.385622471547665e-05, -4.344573194575753e-07, -1.977223343650269e-09, -8.309448619482000e-12,
 -3.289522003651745e-14, -1.236330618059856e-16, -4.415778908988099e-19, -1.491587898253020e-21, -4.705239479590993e-24, -1.348235017636096e-26, -3.274692701656402e-29,
  1.997707516625379e+00, -1.611276226200282e-05, -8.479569694488865e-08, -3.958013928965702e-10, -1.727330316739859e-12, -7.213265598859562e-15, -2.917385364562283e-17,
 -1.150738837483209e-19, -4.445384889427932e-22, -1.686232720637197e-24, -6.290279601127428e-27, -2.309413757892110e-29,  3.261778110675407e-04, -1.325817563819091e-06,
  4.041216242811928e-09, -1.094795629110892e-11,  2.779835857457891e-14, -6.774801882563844e-17,  1.604632754812023e-19, -3.722336859536981e-22,  8.494943901987998e-25,
 -1.914594185738485e-27,  4.267634316842219e-30, -9.437657607026386e-33,  2.935423241813888e-03, -1.192277211453863e-05,  3.628088022897513e-08, -9.799772788294562e-11,
  2.476917226617467e-13, -5.997003418494658e-16,  1.407767131471198e-18, -3.227687285027540e-21,  7.257226891696501e-24, -1.605639106716385e-26,  3.498614648810136e-29,
 -7.528324215154637e-32,  8.152964773954966e-03, -3.306547043215623e-05,  1.002797344628767e-07, -2.692554737110166e-10,  6.742498440409255e-13, -1.610633696624906e-15,
  3.711369612764944e-18, -8.301503234815584e-21,  1.807294709990349e-23, -3.836399909213069e-26,  7.928081595994278e-29, -1.594921366360424e-31,  1.597687955032822e-02,
 -6.465107931378238e-05,  1.950762643282263e-07, -5.190645079854806e-10,  1.281353060047783e-12, -2.997155464561936e-15,  6.704242003026754e-18, -1.439435897892949e-20,
  2.963000659942477e-23, -5.823833579967552e-26,  1.079841408290810e-28, -1.853355626254450e-31,  2.640422234305371e-02, -1.065243178642194e-04,  3.192268647191150e-07,
 -8.390081778679868e-10,  2.030670946090300e-12, -4.610538694744693e-15,  9.872862582041885e-18, -1.989006212078129e-20,  3.722918565497224e-23, -6.297668478491978e-26,
  8.916751835653345e-29, -7.873763114095263e-32,  3.943095116477254e-02, -1.584762147147598e-04,  4.708044813439271e-07, -1.217995021138206e-09,  2.872695478836922e-12,
 -6.264316052927951e-15,  1.260040012809462e-17, -2.296260791730271e-20,  3.601236994769627e-23, -4.109675554050348e-26, -2.901500633411339e-31,  1.946108669614638e-31,
  5.505182595817965e-02, -2.202424422803190e-04,  6.473972132918641e-07, -1.642377536180524e-09,  3.748141580326768e-12, -7.744324887151344e-15,  1.422213321289443e-17,
 -2.183152325966237e-20,  2.198392935997952e-23,  1.404992169559982e-26, -1.633443229747451e-28,  5.978857961504026e-31,  7.326027848463350e-02, -2.915012214746179e-04,
  8.461072568493636e-07, -2.096109136450776e-09,  4.589733033182925e-12, -8.821108414851305e-15,  1.409108014114678e-17, -1.504730159554639e-20, -6.938897850750098e-24,
  1.010076844243359e-25, -3.745220609687395e-28,  1.009011351322053e-30,  9.404825098998795e-02, -3.718707898481139e-04,  1.063550697699475e-06, -2.560945107999000e-09,
  5.324393864554213e-12, -9.264520169116847e-15,  1.165109551847078e-17, -1.783811199424029e-21, -4.998818683740747e-23,  2.079864563357438e-25, -5.776022291189940e-28,
  1.233370970620523e-30,  1.174060006329760e-01, -4.609064266027855e-04,  1.295858808602281e-06, -3.016694683065197e-09,  5.875865419098388e-12, -8.860296319327337e-15,
  6.513840769715909e-18,  1.789034722983232e-20, -1.028777999878425e-22,  3.123608400868394e-25, -6.915441473822325e-28,  1.048271360474209e-30,  1.433218660069508e-01,
 -5.580970297246075e-04,  1.538681688326465e-06, -3.441532669942054e-09,  6.167766665834032e-12, -7.428246714397529e-15, -1.464951458221238e-18,  4.279414740636873e-20,
 -1.575697859627221e-22,  3.824862076093637e-25, -6.258472303633815e-28,  2.767524188343258e-31,  1.717819913573993e-01, -6.628612440181461e-04,  1.787195291482703e-06,
 -3.812380404830862e-09,  6.127108740019171e-12, -4.841563397360587e-15, -1.211561777991967e-17,  7.050649179241537e-20, -2.026293560110568e-22,  3.822008515917564e-25,
 -3.047901035636580e-28, -1.121100714033176e-30,  2.027700032827097e-01, -7.745431447275635e-04,  2.036113155078148e-06, -4.105367053419277e-09,  5.688262920536001e-12,
 -1.046547719067543e-15, -2.489802508647119e-17,  9.736717737059679e-20, -2.242934723097134e-22,  2.780280311133935e-25,  3.022958784570462e-28, -2.961464049321432e-30,
  2.362666337912655e-01, -8.924074904649983e-04,  2.279704433564413e-06, -4.296383387483411e-09,  4.797362414625396e-12,  3.918192461415924e-15, -3.886651071245420e-17,
  1.186445325914386e-19, -2.083212268726097e-22,  4.858915876586213e-26,  1.150235078788014e-27, -4.785798091184318e-30,  2.722492825613747e-01, -1.015634572353766e-03,
  2.511820217441999e-06, -4.361740939543340e-09,  3.417090256918435e-12,  9.904330076391210e-15, -5.266560073430834e-17,  1.289031154172037e-19, -1.426033131126653e-22,
 -3.049023477574919e-25,  2.094893554590874e-27, -5.881263183279437e-30,  3.106915101002568e-01, -1.143314704938255e-03,  2.725930538048695e-06, -4.278949666039302e-09,
  1.531765652848148e-12,  1.663980780273507e-14, -6.456663507850096e-17,  1.225941398482672e-19, -2.037738203260994e-23, -7.489368607375794e-25,  2.888009166634441e-27,
 -5.404435586476677e-30,  3.515624522152028e-01, -1.274442430193860e-03,  2.915174958170039e-06, -4.027626594691872e-09, -8.474139106002371e-13,  2.372025705961652e-14,
 -7.255563265842890e-17,  9.487227960237773e-20,  1.562761775647270e-22, -1.211410321506042e-24,  3.200794808982193e-27, -2.623869818625244e-30,  3.948261447896360e-01,
 -1.407910541027896e-03,  3.072430216112635e-06, -3.590545927992810e-09, -3.677190933594170e-12,  3.060831441385337e-14, -7.448185899280487e-17,  4.261277094579238e-20,
  3.731924087394059e-22, -1.581937087028975e-24,  2.685031607909548e-27,  2.735302233365641e-30,  4.404407463024125e-01, -1.542504077695761e-03,  3.190399024889478e-06,
 -2.954837080864964e-09, -6.877438067987786e-12,  3.664372797659656e-14, -6.827400148992331e-17, -3.443985476482702e-20,  6.018962410575580e-22, -1.722156746772621e-24,
  1.074287157083322e-27,  1.011036483562232e-29,  4.883576438561229e-01, -1.676894512933444e-03,  3.261724812248391e-06, -2.113330285620597e-09, -1.032715179880386e-11,
  4.106748572580813e-14, -5.222583180497040e-17, -1.325166431612100e-19,  7.993654002510090e-22, -1.488834173019566e-24, -1.683244819533351e-27,  1.780900113064403e-29,
  5.385204267244231e-01, -1.809634423465047e-03,  3.279137888021477e-06, -1.066038575969095e-09, -1.386182726350684e-11,  4.306333557627857e-14, -2.534481478914792e-17,
 -2.428571974632705e-19,  9.108808395519541e-22, -7.707825297883014e-25, -5.285226465314095e-27,  2.298708472525260e-29,  5.908637096535641e-01, -1.939153051863525e-03,
  3.235639182363028e-06,  1.782512610190225e-10, -1.727296143479933e-11,  4.181982942953706e-14,  1.225566006233347e-17, -3.512015673480232e-19,  8.770081700695973e-22,
  4.627341321785883e-25, -8.974057066476953e-27,  2.209977588227178e-29,  6.453117864658771e-01, -2.063753299354756e-03,  3.124728211357654e-06,  1.600329529470614e-09,
 -2.031061658970933e-11,  3.661516319568352e-14,  5.895768364979866e-17, -4.380822604354618e-19,  6.453795482712353e-22,  2.109673315728295e-24, -1.153826879687372e-26,
  1.197758910561846e-29,  7.017770930810627e-01, -2.181610863607877e-03,  2.940682136365375e-06,  3.168939486114060e-09, -2.269015692801431e-11,  2.692527235026305e-14,
  1.112943917964078e-16, -4.802985533008312e-19,  1.870926830542904e-22,  3.893305437274950e-24, -1.148916572938960e-26, -8.494804595143096e-30,  7.601584581498185e-01,
 -2.290776452736692e-03,  2.678892449295960e-06,  4.839305025824160e-09, -2.410441345266298e-11,  1.255247288969406e-14,  1.637476540004797e-16, -4.539292567720772e-19,
 -4.839339445624901e-22,  5.352216165886541e-24, -7.469246540342075e-27, -3.644678014163155e-29,  8.203391194600401e-01, -2.389182274075910e-03,  2.336264584867793e-06,
  6.551993398332440e-09, -2.424257732007193e-11, -6.233028765780642e-15,  2.088038988470597e-16, -3.390942651514143e-19, -1.292461468330052e-21,  5.888482642688543e-24,
  1.109504497084340e-27, -6.364117912344619e-29,  8.821844856704562e-01, -2.474654318278851e-03,  1.911683133994257e-06,  8.232365951608107e-09, -2.281697924954543e-11,
 -2.855356476571844e-14,  2.374052832882608e-16, -1.263457490982828e-19, -2.090729197280322e-21,  4.898002529888702e-24,  1.331368821129357e-26, -7.688505385132342e-29,
  9.455396265129317e-01, -2.544932335916316e-03,  1.406540631630573e-06,  9.790951245055361e-09, -1.959845183080230e-11, -5.281056485339503e-14,  2.399347725268059e-16,
  1.760022747995575e-19, -2.663460018724310e-21,  1.991232439653986e-24,  2.610437906403531e-26, -6.156796832039967e-29,  1.010226481431918e+00, -2.597699826455882e-03,
  8.253202388884910e-07,  1.112516148265101e-08, -1.446001988908605e-11, -7.663251081658980e-14,  2.078355611003523e-16,  5.351305251254841e-19, -2.758956399579094e-21,
 -2.722843852100812e-24,  3.437210006977349e-26, -8.933705151964411e-30,  1.076040788104009e+00, -2.630626804768392e-03,  1.762109664114352e-07,  1.212285127853832e-08,
 -7.427017605180310e-12, -9.693054797931003e-14,  1.358620614657201e-16,  8.900904553417208e-19, -2.153531661401080e-21, -8.373422215142543e-24,  3.210485983103887e-26,
  7.432837943505692e-29,  1.142748750230362e+00, -2.641428530489744e-03, -5.282827737365043e-07,  1.266826193147873e-08,  1.270805271716406e-12, -1.101152209594442e-13,
  2.476520045810163e-17,  1.154735667516649e-18, -7.476437255935761e-22, -1.323593197283472e-23,  1.497913705899525e-26,  1.588382672909937e-28,  1.210083490703892e+00,
 -2.627943696150667e-03, -1.270798591739568e-06,  1.265086310471857e-08,  1.115314856263224e-11, -1.125248211700772e-13, -1.160843144152031e-16,  1.230868080441620e-18,
  1.324967111428073e-21, -1.500474926580226e-23, -1.603251214757801e-26,  1.954106766052085e-28,  1.277741374421983e+00, -2.588235633548102e-03, -2.028731614223920e-06,
  1.197743551982601e-08,  2.146130006273963e-11, -1.010933286211665e-13, -2.670094933317447e-16,  1.033910306365106e-18,  3.617822846845787e-21, -1.158032287850402e-23,
 -5.162286963287801e-26,  1.355382248588174e-28,  1.345378337575305e+00, -2.520719706276928e-03, -2.774134727095070e-06,  1.058735158982518e-08,  3.116531787353146e-11,
 -7.423280174271196e-14, -3.985077565349888e-16,  5.294786894550306e-19,  5.387206836319198e-21, -2.316568197793294e-24, -7.446474834443952e-26, -3.126203444223958e-29,
  1.412606429916970e+00, -2.424318916268690e-03, -3.474068088675319e-06,  8.470314814380206e-09,  3.902607498835371e-11, -3.281264411970595e-14, -4.752438744824506e-16,
 -2.278130202278025e-19,  5.770326113646456e-21,  1.071789716129924e-23, -6.569456272975078e-26, -2.416898914872933e-28,  1.478990864976096e+00, -2.298647483513186e-03,
 -4.091594671885462e-06,  5.684741959088485e-09,  4.373091254615981e-11,  1.901085303639975e-14, -4.644323565594620e-16, -1.070952955439302e-18,  4.149054619067741e-21,
  2.236627290478292e-23, -1.762276471660467e-26, -3.616432977127825e-28,  1.544047979633952e+00, -2.144218324093622e-03, -4.587631109026070e-06,  2.373522551224058e-09,
  4.411264243091109e-11,  7.349871240005845e-14, -3.480647073961717e-16, -1.736637101902515e-18,  6.103299612541732e-22,  2.593670460908726e-23,  5.338831173755356e-26,
 -2.612436158279308e-28,  1.607244623553363e+00, -1.962664547477992e-03, -4.923834226150216e-06, -1.227748497717916e-09,  3.944065090808310e-11,  1.200279621618270e-13,
 -1.359359545925939e-16, -1.940759369156752e-18, -3.742860608634171e-21,  1.697757187324643e-23,  1.062915289471500e-25,  5.730636429403063e-29,  1.667999617884875e+00,
 -1.756957127650465e-03, -5.066605084287185e-06, -4.796318204693842e-09,  2.973798467735080e-11,  1.471483797872009e-13,  1.265543466755657e-16, -1.509194307824718e-18,
 -6.975479916464494e-21, -2.312359754057129e-24,  9.779069319862350e-26,  3.865411030604716e-28,  1.725688018266706e+00, -1.531591092916290e-03, -4.992095118893862e-06,
 -7.948051344500700e-09,  1.603402698196059e-11,  1.459658444589773e-13,  3.635095789698154e-16, -5.152286721010858e-19, -7.209887369799423e-21, -2.172733898480038e-23,
  2.117841852946918e-26,  4.323678610844609e-28,  1.779648953534273e+00, -1.292702156452347e-03, -4.691787339734027e-06, -1.028774134214697e-08,  4.245593832042920e-13,
  1.140896351028012e-13,  4.917371231872914e-16,  6.695298371162757e-19, -3.942450459241180e-21, -2.824806413280358e-23, -7.179155768721881e-26,  1.084572032455667e-28,
  1.829197740950852e+00, -1.048067213172841e-03, -4.177820158273220e-06, -1.148267067952734e-08, -1.419112085780575e-11,  5.851208806921814e-14,  4.583993014394063e-16,
  1.501865617890722e-18,  1.134044760778707e-21, -1.645287630736155e-23, -1.037680941181896e-25, -2.893913708812345e-28,  1.873642747994432e+00, -8.069395481894859e-04,
 -3.486806829103764e-06, -1.134890239723910e-08, -2.475812073081639e-11, -4.673037806662876e-15,  2.762148846461997e-16,  1.568083341086107e-18,  4.861166657604133e-21,
  4.517593484960848e-24, -4.807715071525932e-26, -3.504483304654925e-28,  1.912307036794893e+00, -5.796778656288680e-04, -2.680644360413687e-06, -9.928796316601636e-09,
 -2.900605195357473e-11, -5.511188870419567e-14,  3.047205425488775e-17,  8.904514087164708e-19,  4.918108949256111e-21,  1.720229814474261e-23,  3.317360130036657e-26,
 -5.609630332961326e-29,  1.944554183491846e+00, -3.771516452540495e-04, -1.842924198254374e-06, -7.530208492426088e-09, -2.638356533237487e-11, -7.675081582636386e-14,
 -1.594752591811987e-16, -3.094820203224472e-20,  1.914249546358314e-21,  1.275444991470192e-23,  5.582467739167694e-26,  1.804594335828829e-28,  1.969816879834934e+00,
 -2.099448011360143e-04, -1.070245467968728e-06, -4.699373010944993e-09, -1.854408472202605e-11, -6.627663100073732e-14, -2.113611236928594e-16, -5.710934926778562e-19,
 -1.087565396476793e-21,  2.534313020420671e-25,  1.652119912938019e-26,  1.094798272517220e-28,  1.987626261246123e+00, -8.742910123108266e-05, -4.590039514444939e-07,
 -2.115603277180207e-09, -8.998055006449385e-12, -3.601633757994980e-14, -1.366916974904479e-16, -4.921258668535686e-19, -1.671037612110193e-21, -5.274067007007087e-24,
 -1.497630002228322e-26, -3.511543545937882e-29,  1.997641678086206e+00, -1.681060735515058e-05, -8.971602442023056e-08, -4.246319683244279e-10, -1.878866893202916e-12,
 -7.953768240033591e-15, -3.260455961092495e-17, -1.303210068971729e-19, -5.100279173816712e-22, -1.959403486440009e-24, -7.400303220279709e-27, -2.749640434367471e-29,
  3.209383787679652e-04, -1.294005876259952e-06,  3.912465364294969e-09, -1.051381648202072e-11,  2.648108076750256e-14, -6.401896148980864e-17,  1.504111742482108e-19,
 -3.461205206737234e-22,  7.835442192314136e-25, -1.751909940811283e-27,  3.873413050459995e-30, -8.498993719381088e-33,  2.888305293538740e-03, -1.163716249126522e-05,
  3.512829596110126e-08, -9.412880690891743e-11,  2.360283929328066e-13, -5.669727160907960e-16,  1.320558116712604e-18, -3.004440759405116e-21,  6.703608619793456e-24,
 -1.472100003203237e-26,  3.183627216640160e-29, -6.802318350504421e-32,  8.022287160285111e-03, -3.227597584034191e-05,  9.711234920881431e-08, -2.587204158425347e-10,
  6.429094034166932e-13, -1.524286033821763e-15,  3.486820861910214e-18, -7.744668011986020e-21,  1.674727315707709e-23, -3.532884611686616e-26,  7.258007247656935e-29,
 -1.453151781061038e-31,  1.572135749050374e-02, -6.311504026705809e-05,  1.889685499524374e-07, -4.990337966986818e-10,  1.222986868043265e-12, -2.840984926828507e-15,
  6.314164860908222e-18, -1.347892612933461e-20,  2.760924517086178e-23, -5.407819134926995e-26,  1.001175237331054e-28, -1.723685406724308e-31,  2.598316970745317e-02,
 -1.040102299218130e-04,  3.093507092313489e-07, -8.072424416668915e-10,  1.940785235492778e-12, -4.380140503327561e-15,  9.332283556194060e-18, -1.873432122460744e-20,
  3.502538000744283e-23, -5.948042133764699e-26,  8.562027520085998e-29, -8.222756541414250e-32,  3.880448770068793e-02, -1.547674706679385e-04,  4.564602380400304e-07,
 -1.173017969402229e-09,  2.750381841813474e-12, -5.969493032104304e-15,  1.197335831027841e-17, -2.183386996359897e-20,  3.453464118920691e-23, -4.094804028354863e-26,
  7.465333626370409e-30,  1.588209974067054e-31,  5.418109114769556e-02, -2.151410908531208e-04,  6.280434527048478e-07, -1.583628023615893e-09,  3.596619293318822e-12,
 -7.410249164447547e-15,  1.362076670097935e-17, -2.112115569376390e-20,  2.237825144609303e-23,  8.019664722515684e-27, -1.387121546831745e-28,  5.232301820375226e-31,
  7.210765375547974e-02, -2.848317415404057e-04,  8.213887987799034e-07, -2.024066554157418e-09,  4.416658481053832e-12, -8.488000217189666e-15,  1.366717360408543e-17,
 -1.521397220132119e-20, -3.561855176585405e-24,  8.688436807997862e-26, -3.323789257097292e-28,  9.080644664479571e-31,  9.257759203605585e-02, -3.634838753800307e-04,
  1.033324432791361e-06, -2.477221956511492e-09,  5.141894773019585e-12, -8.985667232882839e-15,  1.157984853557489e-17, -3.267987524087893e-21, -4.290371319054096e-23,
  1.859409913838736e-25, -5.253278473115508e-28,  1.143201406162075e-30,  1.155828816373534e-01, -4.506827726550067e-04,  1.260216735654163e-06, -2.924089825967854e-09,
  5.700261510627411e-12, -8.698314788582249e-15,  6.970334193038297e-18,  1.477292865554824e-20, -9.211965468862663e-23,  2.856160126535246e-25, -6.458538005441501e-28,
  1.026818128044054e-30,  1.411138375921056e-01, -5.459511034549843e-04,  1.497970494145130e-06, -3.344038435749043e-09,  6.018944309021402e-12, -7.449583937300802e-15,
 -3.352708778241232e-19,  3.796742070436031e-20, -1.442476384785926e-22,  3.577305145961808e-25, -6.111323471870069e-28,  3.873625166704712e-31,  1.691588541080616e-01,
 -6.487450168306795e-04,  1.742031684258198e-06, -3.715136455698199e-09,  6.027525899426916e-12, -5.109368123474303e-15, -1.023016279870555e-17,  6.424005589751591e-20,
 -1.891006640515196e-22,  3.691097106262777e-25, -3.476947578584541e-28, -8.365115693289868e-31,  1.997040986883202e-01, -7.584497516951336e-04,  1.987394030284585e-06,
 -4.014553848887362e-09,  5.661573116825064e-12, -1.612186669141803e-15, -2.227070770575989e-17,  9.035201738786357e-20, -2.140969798173232e-22,  2.876485816478191e-25,
  1.819801109355074e-28, -2.515415271500736e-30,  2.327331544248363e-01, -8.743747708845772e-04,  2.228610804594908e-06, -4.219048244018406e-09,  4.866663501958062e-12,
  3.024509401426437e-15, -3.563746777651317e-17,  1.120147177952606e-19, -2.057932025094503e-22,  9.053976678835554e-26,  9.510241323888440e-28, -4.273898640031068e-30,
  2.682266032345836e-01, -9.957484301163254e-04,  2.459813684560919e-06, -4.305550260807633e-09,  3.602826760592051e-12,  8.683141875494432e-15, -4.912173751409486e-17,
  1.241798587905086e-19, -1.521328130262248e-22, -2.261690789385386e-25,  1.844608625715075e-27, -5.491712212978748e-30,  3.061615415898001e-01, -1.121712208826290e-03,
  2.674740904287627e-06, -4.251862075778208e-09,  1.849343376329637e-12,  1.513130238017992e-14, -6.114702521606914e-17,  1.215325059419819e-19, -4.531709631407346e-23,
 -6.381759527843566e-25,  2.650125655139015e-27, -5.392492358059524e-30,  3.465110189154965e-01, -1.251314551657006e-03,  2.866777438684168e-06, -4.037483675833551e-09,
 -3.902041982256417e-13,  2.201132463769807e-14, -6.983557844950772e-17,  9.919981738930788e-20,  1.149403646523798e-22, -1.085881617186867e-24,  3.071154780638900e-27,
 -3.240102842910085e-30,  3.892433872759971e-01, -1.383504399803734e-03,  3.029010542688669e-06, -3.644580347682828e-09, -3.082796892074653e-12,  2.883636527770544e-14,
 -7.312992362853960e-17,  5.366467067678818e-20,  3.182010493278458e-22, -1.472548755258869e-24,  2.774380917189805e-27,  1.361566132888534e-30,  4.343215492401770e-01,
 -1.517124533221103e-03,  3.154304641532471e-06, -3.059102412215473e-09, -6.161016372112517e-12,  3.499569963800940e-14, -6.897792422946230e-17, -1.616200992650592e-20,
  5.407737986140697e-22, -1.670889411366628e-24,  1.474507680296175e-27,  8.109883599016881e-30,  4.817020889043916e-01, -1.650904901300389e-03,  3.235400322863695e-06,
 -2.272063229363439e-09, -9.518622104856604e-12,  3.977238072376472e-14, -5.558632363721587e-17, -1.078060182265788e-19,  7.447385825110271e-22, -1.541117825867316e-24,
 -9.464174971200582e-28,  1.568447984643779e-29,  5.313342689809126e-01, -1.783456195399228e-03,  3.265042998262239e-06, -1.280972981216031e-09, -1.300717719907004e-11,
  4.237672669860779e-14, -3.174119272698580e-17, -2.141918273289930e-19,  8.795676276758841e-22, -9.623440162530302e-25, -4.302782469126495e-27,  2.162441627988843e-29,
  5.831588746712242e-01, -1.913264016935998e-03,  3.236147637055120e-06, -9.141225405941551e-11, -1.643440356697030e-11,  4.199914576875167e-14,  2.816937299266739e-18,
 -3.229381365389437e-19,  8.874414333181565e-22,  1.234097455765494e-25, -7.988546468629332e-27,  2.259762022074798e-29,  6.371068828195882e-01, -2.038684126200186e-03,
  3.142006750271229e-06,  1.281290843276411e-09, -1.956514470515299e-11,  3.788535267441995e-14,  4.699129915864345e-17, -4.163029254567741e-19,  7.131566386076693e-22,
  1.659703035551923e-24, -1.093646104088846e-26,  1.524372033873692e-29,  6.930979327223121e-01, -2.157939427297651e-03,  2.976549383460247e-06,  2.810345588085335e-09,
 -2.212602610974647e-11,  2.943576028639953e-14,  9.795028435020743e-17, -4.721583586384894e-19,  3.189064313271282e-22,  3.428124014189768e-24, -1.172511610902059e-26,
 -2.346487446309757e-30,  7.510385731760241e-01, -2.269119562456089e-03,  2.734659050338131e-06,  4.455851982554594e-09, -2.381510236547443e-11,  1.632832234969020e-14,
  1.508493699945562e-16, -4.663929290874109e-19, -2.969977063525395e-22,  5.023655853976772e-24, -8.902455596573086e-27, -2.871849878374183e-29,  8.108202592291603e-01,
 -2.370184263416456e-03,  2.412557977396287e-06,  6.163383847143521e-09, -2.431791734709889e-11, -1.340148360174970e-15,  1.987621350137374e-16, -3.770580723754070e-19,
 -1.080335953658422e-21,  5.878645841072974e-24, -1.555393935269561e-27, -5.733718598668081e-29,  8.723170721708813e-01, -2.458971947256213e-03,  2.008263249243463e-06,
  7.863033953037590e-09, -2.333139819633938e-11, -2.290568377729906e-14,  2.329581580796848e-16, -1.903316691600183e-19, -1.905630338191199e-21,  5.362943369505396e-24,
  9.938430614409752e-27, -7.619190601090532e-29,  9.353831383025991e-01, -2.533215454214120e-03,  1.522116757870201e-06,  9.469240703514900e-09, -2.059672907716258e-11,
 -4.700255131278126e-14,  2.436817879542169e-16,  9.211456454614991e-20, -2.573658484261217e-21,  2.978506131086386e-24,  2.319668147977248e-26, -7.016526928774580e-29,
  9.998497270582183e-01, -2.590567304615090e-03,  9.573843286966188e-07,  1.088181589415560e-08, -1.594162780397419e-11, -7.147471099098763e-14,  2.215703530536545e-16,
  4.455398130580927e-19, -2.832376114184115e-21, -1.361345700966410e-24,  3.356917834867509e-26, -2.727247427505290e-29,  1.065522018552372e+00, -2.628637386466441e-03,
  3.209088105916447e-07,  1.198869560338900e-08, -9.331044339259490e-12, -9.337884480279592e-14,  1.597762972418848e-16,  8.166082042823877e-19, -2.431131092597838e-21,
 -7.030413189990953e-24,  3.488063226290046e-26,  5.169371606623799e-29,  1.132175546639579e+00, -2.645046537558856e-03, -3.762141747826226e-07,  1.267101961314366e-08,
 -9.229523830309588e-13, -1.091360042554531e-13,  5.669212435144766e-17,  1.123316240245812e-18, -1.211704941959385e-21, -1.250111413947448e-23,  2.165141799899708e-26,
  1.437006061473762e-28,  1.199552348663559e+00, -2.637499981761839e-03, -1.117992256732240e-06,  1.281116993401651e-08,  8.877606140786514e-12, -1.148929850837602e-13,
 -8.110841287510780e-17,  1.264517488685453e-18,  7.753470340794610e-22, -1.547174883979816e-23, -7.271714073946389e-27,  2.016892625073877e-28,  1.267356890502822e+00,
 -2.603884887957484e-03, -1.883009925175364e-06,  1.230430328098761e-08,  1.937776204480614e-11, -1.071414797064386e-13, -2.365046634797883e-16,  1.142624138203548e-18,
  3.165295516521723e-21, -1.351553875386742e-23, -4.488830920449024e-26,  1.697862789503468e-28,  1.335251889047784e+00, -2.542396230434487e-03, -2.644145299833305e-06,
  1.107360516332651e-08,  2.958632110888100e-11, -8.359970058156213e-14, -3.812855316354911e-16,  6.999582870569218e-19,  5.249998436438741e-21, -5.307895314535600e-24,
 -7.473152921843611e-26,  1.951649774730008e-29,  1.402854227821575e+00, -2.451694324685318e-03, -3.368701476491715e-06,  9.088860484120562e-09,  3.825535617723850e-11,
 -4.427383889960047e-14, -4.789832612154660e-16, -3.751646879812026e-20,  6.106395050851534e-21,  7.887203524445419e-24, -7.557863269539881e-26, -2.058006322009448e-28,
  1.469731258393433e+00, -2.331095453553683e-03, -4.019169042558405e-06,  6.386862760442806e-09,  4.399731759446216e-11,  7.520377618487271e-15, -4.924403683749540e-16,
 -9.254677222508826e-19,  4.937670218411508e-21,  2.133813583382585e-23, -3.388447891120298e-26, -3.753955499505881e-28,  1.535397901710279e+00, -2.180793336557272e-03,
 -4.554867030866579e-06,  3.090614265833761e-09,  4.549515757496390e-11,  6.456473322411637e-14, -3.962739467699460e-16, -1.701778558892432e-18,  1.579533504545479e-21,
  2.782182062412463e-23,  4.036454312617294e-26, -3.302398085220788e-28,  1.599315106091129e+00, -2.002103244159875e-03, -4.934702312426928e-06, -5.776895817309344e-10,
  4.180411643704294e-11,  1.161004640969120e-13, -1.918562634383569e-16, -2.049927637413276e-18, -3.054731267013117e-21,  2.125741915720954e-23,  1.071267184845880e-25,
 -2.149455711158296e-29,  1.660890370888274e+00, -1.797711878202226e-03, -5.121208444069446e-06, -4.296816504262411e-09,  3.270777188037774e-11,  1.496533223775384e-13,
  8.116495069683749e-17, -1.732953572508119e-18, -6.984248568022212e-21,  1.935662567325547e-24,  1.144839394060885e-25,  3.691274748667542e-28,  1.719481182774665e+00,
 -1.571904774155190e-03, -5.085834610067123e-06, -7.667683744399313e-09,  1.903927985046892e-11,  1.544901706192215e-13,  3.457369455371391e-16, -7.582580663071914e-19,
 -7.972049908093264e-21, -2.047908181217572e-23,  4.173802183421905e-26,  5.014385107525829e-28,  1.774402294839638e+00, -1.330729973661687e-03, -4.815122085110486e-06,
 -1.026204671997283e-08,  2.825809753256484e-12,  1.261010729832980e-13,  5.085609721932487e-16,  5.265571199437025e-19, -5.009694281519252e-21, -3.099920192972275e-23,
 -6.511602128462716e-26,  1.976055707859499e-28,  1.824937748965503e+00, -1.082044709723326e-03, -4.316933960544866e-06, -1.169975456222997e-08, -1.290743826853479e-11,
  7.002182231402133e-14,  5.008646929374964e-16,  1.527852358135892e-18,  4.639851505930949e-22, -2.085523030658352e-23, -1.162467566375213e-25, -2.752046542454642e-28,
  1.870358328862382e+00, -8.353854890337427e-04, -3.625372313379864e-06, -1.174540458458202e-08, -2.478164206924119e-11,  2.500709642556509e-15,  3.223206438168160e-16,
  1.725840390667186e-18,  4.985300523826333e-21,  2.267626486687046e-24, -6.488581577412210e-26, -4.142103902530998e-28,  1.909944669185700e+00, -6.016075758500058e-04,
 -2.802610718384228e-06, -1.040166251002582e-08, -3.009886252009514e-11, -5.406300260711415e-14,  5.770289945997128e-17,  1.057989913729443e-18,  5.560562534484334e-21,
  1.846659965156509e-23,  2.969028260807288e-26, -1.043514384695352e-28,  1.943015507541011e+00, -3.922637831907434e-04, -1.935870852090404e-06, -7.964833788519988e-09,
 -2.795688827039507e-11, -8.058125865403032e-14, -1.594120339334797e-16,  3.810114484136055e-20,  2.415562735839154e-21,  1.515123410804344e-23,  6.413552767554853e-26,
  1.970503760289788e-28,  1.968959612294517e+00, -2.187374813337434e-04, -1.128462826624506e-06, -5.006963749770893e-09, -1.992165952303428e-11, -7.154510478761454e-14,
 -2.278366330883022e-16, -6.056121878777987e-19, -1.065316003218060e-21,  1.018349661032716e-24,  2.192566750910974e-26,  1.370853210113675e-28,  1.987269036463209e+00,
 -9.120518519749949e-05, -4.852793652876707e-07, -2.265517813306925e-09, -9.752335895026520e-12, -3.946851472866618e-14, -1.512492318494399e-16, -5.487556100228718e-19,
 -1.872065033231016e-21, -5.904640990258218e-24, -1.656688409683337e-26, -3.709967725349401e-29,  1.997572967190586e+00, -1.754924130903772e-05, -9.499736994221690e-08,
 -4.560102325714087e-10, -2.046072735969373e-12, -8.781977070308833e-15, -3.649306605172236e-17, -1.478301013093494e-19, -5.861996780291288e-22, -2.281102698222231e-24,
 -8.723289793128914e-27, -3.280377841441751e-29,  3.158241657007280e-04, -1.263203709733453e-06,  3.788800124204431e-09, -1.010016933223690e-11,  2.523602961760287e-14,
 -6.052261373116796e-17,  1.410615551745369e-19, -3.220270191742767e-22,  7.231765177472588e-25, -1.604198838522123e-27,  3.518248809563542e-30, -7.660360250761570e-33,
  2.842311632032343e-03, -1.136059095733617e-05,  3.402104030284548e-08, -9.044137442113493e-11,  2.249991817179810e-13, -5.362650541711194e-16,  1.239359041004541e-18,
 -2.798164539097572e-21,  6.195871432073023e-24, -1.350544114073602e-26,  2.898910173544594e-29, -6.150986780844340e-32,  7.894717635618793e-03, -3.151132304301020e-05,
  9.406843202211689e-08, -2.486732769934599e-10,  6.132432628981998e-13, -1.443145138899602e-15,  3.277285659756214e-18, -7.228556640779749e-21,  1.552618688576299e-23,
 -3.254964426019754e-26,  6.647366947428826e-29, -1.324552103606168e-31,  1.547188336366644e-02, -6.162691710268536e-05,  1.830957024060264e-07, -4.799124572733020e-10,
  1.167652507296430e-12, -2.693875825902613e-15,  5.948836625576851e-18, -1.262582103045579e-20,  2.573272036462840e-23, -5.022153280730519e-26,  9.280412250096837e-29,
 -1.601871491668540e-31,  2.557201778527031e-02, -1.015736505712050e-04,  2.998472633589003e-07, -7.768787071790171e-10,  1.855380330282957e-12, -4.162335733237157e-15,
  8.823096695445922e-18, -1.764711591831416e-20,  3.294485307991789e-23, -5.612865565485792e-26,  8.195351637775074e-29, -8.422197642054860e-32,  3.819263307676944e-02,
 -1.511713544955025e-04,  4.426441692115098e-07, -1.129951571188291e-09,  2.633816707560654e-12, -5.689345095410060e-15,  1.137726034701818e-17, -2.075227678318781e-20,
  3.306748498307529e-23, -4.051903304034904e-26,  1.376191427858207e-29,  1.281765800352083e-31,  5.333045649019238e-02, -2.101917902453438e-04,  6.093803580973936e-07,
 -1.527250192923839e-09,  3.451635810457873e-12, -7.090366322606929e-15,  1.303943582075394e-17, -2.040145935963419e-20,  2.257245119031114e-23,  2.911553690842612e-27,
 -1.171754597437386e-28,  4.570289113383770e-31,  7.098131686017235e-02, -2.783565978003511e-04,  7.975184545979687e-07, -1.954740421533535e-09,  4.250144038458404e-12,
 -8.165110024733110e-15,  1.324003903980026e-17, -1.528039565828648e-20, -6.639555351884283e-25,  7.436054352875475e-26, -2.944841010275301e-28,  8.158178586585909e-31,
  9.114000341319539e-02, -3.553348015365094e-04,  1.004085509492784e-06, -2.396374280602528e-09,  4.964952404156562e-12, -8.708998009110113e-15,  1.147010198221407e-17,
 -4.537763030114830e-21, -3.657618693218054e-23,  1.659080361780963e-25, -4.769535995090306e-28,  1.056205481811930e-30,  1.138000939552212e-01, -4.407398577720005e-04,
  1.225669171772609e-06, -2.834268148082917e-09,  5.527999918206404e-12, -8.526386843943056e-15,  7.344217305591288e-18,  1.198471641527545e-20, -8.229168048715813e-23,
  2.606770066262517e-25, -6.013204799920570e-28,  9.961030962915944e-31,  1.389537488556151e-01, -5.341262275183383e-04,  1.458414934393572e-06, -3.248927345211479e-09,
  5.869955629559243e-12, -7.445383252746507e-15,  6.650965617921084e-19,  3.355286606823968e-20, -1.318050029237366e-22,  3.336526229946530e-25, -5.921504300243372e-28,
  4.714280496298623e-31,  1.665914665015416e-01, -6.349854582693655e-04,  1.698025275522734e-06, -3.619526280919929e-09,  5.923025512166354e-12, -5.333978979463097e-15,
 -8.514180241237849e-18,  5.839869014145286e-20, -1.760712443225446e-22,  3.545399761037602e-25, -3.790289973747790e-28, -5.943820281677951e-31,  1.967017950505124e-01,
 -7.427417607247026e-04,  1.939761739319457e-06, -3.924254823542169e-09,  5.624185371693296e-12, -2.117089937571559e-15, -1.983520111350289e-17,  8.366779530773893e-20,
 -2.036361733462834e-22,  2.928349579180399e-25,  8.024345619589777e-29, -2.116550531162494e-30,  2.292709943409909e-01, -8.567470707304847e-04,  2.178451273888003e-06,
 -4.140743124707723e-09,  4.918850914944144e-12,  2.206106237006843e-15, -3.259271077515324e-17,  1.054884689679884e-19, -2.018930376235621e-22,  1.249638281130658e-25,
  7.736891683377603e-28, -3.791985853984001e-30,  2.642826407116208e-01, -9.762755942954330e-04,  2.408498479389803e-06, -4.246578612480137e-09,  3.764979147852038e-12,
  7.545387469724033e-15, -4.571398217070831e-17,  1.191951102037793e-19, -1.590039377445563e-22, -1.570988784138209e-25,  1.611855196571167e-27, -5.086326046174190e-30,
  3.017171662072712e-01, -1.100517845462955e-03,  2.623905827870580e-06, -4.219930155320452e-09,  2.137568839263545e-12,  1.370442432207288e-14, -5.776772773602547e-17,
  1.197347656707639e-19, -6.644031930774212e-23, -5.368929152061089e-25,  2.414746715300524e-27, -5.293866019861609e-30,  3.415513221926608e-01, -1.228574204629231e-03,
  2.818304410057307e-06, -4.040295245251925e-09,  3.348873867750222e-14,  2.036898223773829e-14, -6.701219969315352e-17,  1.022758628433417e-19,  7.802416473141196e-23,
 -9.660311442006077e-25,  2.918072017406164e-27, -3.693106561365561e-30,  3.837575557305756e-01, -1.359448050625332e-03,  2.984998354559526e-06, -3.689386109963217e-09,
 -2.523493315239201e-12,  2.710038084035056e-14, -7.149257493966430e-17,  6.302042989189588e-20,  2.671980050425244e-22, -1.360732828291173e-24,  2.807935557644633e-27,
  1.970543600181746e-31,  4.283032851933379e-01, -1.492038556192624e-03,  3.117026760475910e-06, -3.152169428829812e-09, -5.477683864945168e-12,  3.333669930240140e-14,
 -6.919715166288865e-17,  1.923673470352872e-22,  4.817643948097931e-22, -1.605322004711092e-24,  1.790591076229994e-27,  6.287821632477130e-30,  4.751500594515042e-01,
 -1.625133286839511e-03,  3.207247788674859e-06, -2.418071065213766e-09, -8.736746012812636e-12,  3.840472761683680e-14, -5.827963424745649e-17, -8.486806108642508e-20,
  6.887375895174999e-22, -1.565791893147226e-24, -3.025288644845216e-28,  1.359228588186790e-29,  5.242525826231574e-01, -1.757400811934606e-03,  3.248450462606631e-06,
 -1.482350912950991e-09, -1.216773004107569e-11,  4.154611698229202e-14, -3.734995197883760e-17, -1.866313567569538e-19,  8.420504258702839e-22, -1.115881110514279e-24,
 -3.385696962147703e-27,  2.002955950697289e-29,  5.755575837917088e-01, -1.887383629937984e-03,  3.233500710337714e-06, -3.476421911280647e-10, -1.559446041628640e-11,
  4.196145598667739e-14, -5.827517282685870e-18, -2.945286514191015e-19,  8.863723127670638e-22, -1.762253852057069e-25, -6.993623870517562e-27,  2.254222212363002e-29,
  6.290025083642803e-01, -2.013491833992538e-03,  3.155529178607162e-06,  9.743675449449023e-10, -1.879709036403920e-11,  3.887589706887104e-14,  3.566269962619804e-17,
 -3.926089935617192e-19,  7.652005861109466e-22,  1.236443912155646e-24, -1.020845640970400e-26,  1.772129318158466e-29,  6.845140049531351e-01, -2.133998108370879e-03,
  3.008169261125809e-06,  2.461162146373792e-09, -2.151486725910496e-11,  3.162918586169813e-14,  8.489062736803133e-17, -4.600693735532950e-19,  4.338670332541736e-22,
  2.958702461173268e-24, -1.170654849116209e-26,  3.064229838296692e-30,  7.420061790050614e-01, -2.247034860791134e-03,  2.785854426008486e-06,  4.077615126594744e-09,
 -2.345339469915777e-11,  1.979108985269736e-14,  1.376839973856248e-16, -4.730742944968221e-19, -1.228400321382197e-22,  4.644517551597459e-24, -9.999768796674470e-27,
 -2.121241113910879e-29,  8.013785821816385e-01, -2.350594572017352e-03,  2.484184008598260e-06,  5.774338274300319e-09, -2.429789193107006e-11,  3.299739871042380e-15,
  1.877522201146953e-16, -4.082595441749134e-19, -8.704141231756775e-22,  5.768011000080085e-24, -3.924760888195667e-27, -5.025909283964916e-29,  8.625139051817394e-01,
 -2.442534794625338e-03,  2.100365703472725e-06,  7.486368516310013e-09, -2.373406843211114e-11, -1.738534920921413e-14,  2.268046824065189e-16, -2.481525812021012e-19,
 -1.706210998623435e-21,  5.694078243420007e-24,  6.637622634179978e-27, -7.354531628901579e-29,  9.252753420154300e-01, -2.520589668283426e-03,  1.633740369944900e-06,
  9.132491101950975e-09, -2.147813521174353e-11, -4.113243892954371e-14,  2.451253576107011e-16,  1.164603225118990e-20, -2.450492720726457e-21,  3.842684653136729e-24,
  1.996891053807918e-26, -7.611577650287431e-29,  9.895035967445940e-01, -2.582390345689469e-03,  1.086389496905947e-06,  1.061560688006033e-08, -1.731698774483174e-11,
 -6.601759909467212e-14,  2.327710282897494e-16,  3.543761487505893e-19, -2.857549469255178e-21, -4.754710045688890e-26,  3.200173733730495e-26, -4.360658111723812e-29,
  1.055013510919841e+00, -2.625497337181081e-03,  4.638164432877877e-07,  1.182467424013483e-08, -1.115846924653784e-11, -8.927884841205476e-14,  1.815160752370793e-16,
  7.350358123266762e-19, -2.658625599565388e-21, -5.596492210140853e-24,  3.664708225819288e-26,  2.859511107185943e-29,  1.121590303487584e+00, -2.647448458412411e-03,
 -2.243223041305049e-07,  1.263887515074197e-08, -3.089543063278361e-12, -1.074027501000563e-13,  8.753574100516205e-17,  1.077520238924892e-18, -1.644680903731621e-21,
 -1.151400121237686e-23,  2.756376405997648e-26,  1.244289270293605e-28,  1.188985437687281e+00, -2.645826744214533e-03, -9.634821063069803e-07,  1.293473507132551e-08,
  6.563160645517875e-12, -1.164124216905651e-13, -4.543860036516496e-17,  1.280378116596290e-18,  2.152710874614737e-22, -1.558479558290031e-23,  1.615403521194931e-27,
  2.011456054807874e-28,  1.256912165143131e+00, -2.618353254854019e-03, -1.733569702814672e-06,  1.259690751269724e-08,  1.718082000430419e-11, -1.124226858094649e-13,
 -2.031686646616652e-16,  1.235797260395223e-18,  2.648298795584995e-21, -1.515275536521165e-23, -3.676309790502045e-26,  1.985199960147071e-28,  1.325040850584827e+00,
 -2.563009942573307e-03, -2.508478518375240e-06,  1.153312015532587e-08,  2.782450336284480e-11, -9.249658049187802e-14, -3.593675256286658e-16,  8.643265562387313e-19,
  5.005453649191109e-21, -8.264688038975174e-24, -7.272901892951394e-26,  7.152956834438845e-29,  1.392994256648827e+00, -2.478197337091463e-03, -3.255993880460877e-06,
  9.693237817812432e-09,  3.725495348149609e-11, -5.575972090284700e-14, -4.772596305431388e-16,  1.618307806244627e-19,  6.333851540997296e-21,  4.695843633145573e-24,
 -8.365271262929157e-26, -1.596014126741598e-28,  1.460343072180841e+00, -2.362930261994650e-03, -3.938300086843258e-06,  7.091372479897030e-09,  4.402753574817179e-11,
 -4.590594123975782e-15, -5.160279589077115e-16, -7.554654876508013e-19,  5.677454245786875e-21,  1.965136611711707e-23, -5.045380327311835e-26, -3.753452014194296e-28,
  1.526602102973442e+00, -2.217071453935397e-03, -4.513371229679821e-06,  3.828334316904460e-09,  4.668752034223313e-11,  5.448900837963689e-14, -4.430634924101233e-16,
 -1.634926091714110e-18,  2.606502758094914e-21,  2.912645172627363e-23,  2.440011465822770e-26, -3.942822806983600e-28,  1.591227710256362e+00, -2.041597046289906e-03,
 -4.937545630105061e-06,  1.094824702554319e-10,  4.407537700112273e-11,  1.107968287805369e-13, -2.505018337334504e-16, -2.134611133133405e-18, -2.212795636349713e-21,
  2.549762860290363e-23,  1.042216662359937e-25, -1.123569958778020e-28,  1.653617270342759e+00, -1.838878668356103e-03, -5.169531228155499e-06, -3.749458734444547e-09,
  3.571625744657176e-11,  1.509938505143112e-13,  2.953026569029819e-17, -1.954419541604489e-18, -6.828306134208191e-21,  6.830317990916311e-24,  1.299745215539814e-25,
  3.314265783559748e-28,  1.713111615204644e+00, -1.612954083455171e-03, -5.175915641219893e-06, -7.337893744364601e-09,  2.221018857353372e-11,  1.625035870630893e-13,
  3.208259614074512e-16, -1.024793092368938e-18, -8.673754145582762e-21, -1.834929576672816e-23,  6.520570075983812e-26,  5.637458562913421e-28,  1.769001554419352e+00,
 -1.369742563959200e-03, -4.937909980261056e-06, -1.019598975520111e-08,  5.470982016902689e-12,  1.384642957771053e-13,  5.208889839636559e-16,  3.479074324364686e-19,
 -6.170184828450729e-21, -3.340020456733691e-23, -5.417038818739202e-26,  3.024448466834907e-28,  1.820539605191195e+00, -1.117145169701082e-03, -4.458521759515090e-06,
 -1.189440238926115e-08, -1.138332351840465e-11,  8.255688471541699e-14,  5.437330225926531e-16,  1.529766613039446e-18, -3.733485706874651e-22, -2.573926248974391e-23,
 -1.277209985878345e-25, -2.430254945472649e-28,  1.866957878790887e+00, -8.649589809528149e-04, -3.768693148407694e-06, -1.214107368292026e-08, -2.465026329861205e-11,
  1.083437092933886e-14,  3.728860782913537e-16,  1.886138431761001e-18,  5.015648150898868e-21, -7.117612726218290e-25, -8.456798208867475e-26, -4.806740553423632e-28,
  1.907492594918829e+00, -6.245360099235696e-04, -2.930355568742551e-06, -1.089180870442630e-08, -3.116376780370415e-11, -5.230191918806912e-14,  8.991926749402517e-17,
  1.246783893757674e-18,  6.245475626487186e-21,  1.954515418982123e-23,  2.378427707765367e-26, -1.666098006577692e-28,  1.941414862248619e+00, -4.081407901345150e-04,
 -2.034186574429918e-06, -8.425244349021872e-09, -2.960663857166276e-11, -8.438508869143457e-14, -1.571774017231061e-16,  1.246386171966063e-19,  3.009314916061767e-21,
  1.789448335329452e-23,  7.313102543244932e-26,  2.113116788909468e-28,  1.968066218638951e+00, -2.280110476058134e-04, -1.190507069006016e-06, -5.337460452112620e-09,
 -2.140863568103876e-11, -7.722048163118097e-14, -2.452642467708158e-16, -6.389341111964648e-19, -1.011330309373894e-21,  2.025433424849164e-24,  2.867320001971692e-26,
  1.706970032255851e-28,  1.986896275247583e+00, -9.519887891016883e-05, -5.134285059627453e-07, -2.428072727485638e-09, -1.057928641850335e-11, -4.328984862933343e-14,
 -1.674859604547751e-16, -6.121938814176710e-19, -2.096957839778126e-21, -6.600410850476915e-24, -1.823120628347639e-26, -3.841101887070357e-29,  1.997501214806963e+00,
 -1.833167895644285e-05, -1.006718699066339e-07, -4.902015461106252e-10, -2.230817177788164e-12, -9.709679625773363e-15, -4.090776867283269e-17, -1.679726792439777e-19,
 -6.749642271502895e-22, -2.660700971571148e-24, -1.030329309248151e-26, -3.921533710077717e-29,  3.108312136217473e-04, -1.233371343482040e-06,  3.669981393715041e-09,
 -9.705895551608524e-12,  2.405871505070708e-14, -5.724277488620927e-17,  1.323602896868609e-19, -2.997828738441461e-22,  6.678793442657777e-25, -1.469983205962962e-27,
  3.197993145949300e-30, -6.910501389078406e-33,  2.797406816641466e-03, -1.109270342586186e-05,  3.295699495952569e-08, -8.692560003924873e-11,  2.145650944780197e-13,
 -5.074386575739205e-16,  1.163714658288203e-18, -2.607457178643959e-21,  5.729911623329523e-24, -1.239823895306824e-26,  2.641358571726660e-29, -5.566277750022793e-32,
  7.770158771817967e-03, -3.077054726811448e-05,  9.114228523326895e-08, -2.390880822482882e-10,  5.851507999368124e-13, -1.366864000067411e-15,  3.081669240593979e-18,
 -6.749965266337956e-21,  1.440088834694222e-23, -3.000374153277637e-26,  6.090642616596848e-29, -1.207885484035918e-31,  1.522826919619024e-02, -6.018487372478701e-05,
  1.774470944048489e-07, -4.616533985506378e-10,  1.115174550102625e-12, -2.555254618530109e-15,  5.606575125612309e-18, -1.183059871478873e-20,  2.398989671291830e-23,
 -4.664691836969437e-26,  8.600971978731334e-29, -1.487743742868225e-31,  2.517046240063536e-02, -9.921166423165501e-05,  2.907001250577067e-07, -7.478472561746902e-10,
  1.774211742998536e-12, -3.956393559529910e-15,  8.343437444266288e-18, -1.662458531290222e-20,  3.098233194615808e-23, -5.292494098730049e-26,  7.822650544669173e-29,
 -8.501004174439849e-32,  3.759494508927980e-02, -1.476837309714716e-04,  4.293338893162937e-07, -1.088706158562752e-09,  2.522713894232334e-12, -5.423145383817657e-15,
  1.081079236031024e-17, -1.971733943869314e-20,  3.161999408533630e-23, -3.986377015668444e-26,  1.881059052716572e-29,  1.019922878325107e-31,  5.249932465528294e-02,
 -2.053891272127295e-04,  5.913800877297697e-07, -1.473141667896309e-09,  3.312912100223133e-12, -6.784193065807598e-15,  1.247831694733324e-17, -1.967833020174166e-20,
  2.259758430550619e-23, -1.391058437115463e-27, -9.838212705878559e-29,  3.983916963759041e-31,  6.988050381980533e-02, -2.720691339641424e-04,  7.744642499230569e-07,
 -1.888027414992918e-09,  4.089984789193880e-12, -7.852483307622921e-15,  1.281227713929192e-17, -1.526101529391887e-20,  1.809414801351899e-24,  6.327377494181639e-26,
 -2.604667463486695e-28,  7.317240717746229e-31,  8.973454933996694e-02, -3.474158060997083e-04,  9.757999539437645e-07, -2.318313570314098e-09,  4.793514316214409e-12,
 -8.435367120061892e-15,  1.132753064755796e-17, -5.616230652813143e-21, -3.093593043788587e-23,  1.477345635577927e-25, -4.323263833499050e-28,  9.729595108225030e-31,
  1.120565319322465e-01, -4.310690585502925e-04,  1.192183045893517e-06, -2.747174685576910e-09,  5.359260473149271e-12, -8.346387823308113e-15,  7.644300873097903e-18,
  9.496975501560145e-21, -7.332979244355749e-23,  2.374901135757186e-25, -5.582984536321083e-28,  9.584751931299245e-31,  1.368403339051652e-01, -5.226132712376249e-04,
  1.419986411700336e-06, -3.156198138183936e-09,  5.721281268912634e-12, -7.418612842945429e-15,  1.547301547385673e-18,  2.952276026208410e-20, -1.202146762611410e-22,
  3.104010995330254e-25, -5.699773564519802e-28,  5.330485822501629e-31,  1.640784202525401e-01, -6.215733904407944e-04,  1.655156015702659e-06, -3.525621867201980e-09,
  5.814431736789592e-12, -5.519322331377964e-15, -6.955999203654850e-18,  5.296565189591708e-20, -1.635864330413812e-22,  3.389184902161983e-25, -4.005576650669858e-28,
 -3.900614321512797e-31,  1.937615681073137e-01, -7.274105046453753e-04,  1.893209124314133e-06, -3.834631673692753e-09,  5.577269119083467e-12, -2.565748974855205e-15,
 -1.758214363422179e-17,  7.732055450793717e-20, -1.930577996894623e-22,  2.942895612799681e-25, -4.932786825699283e-30, -1.762201078464651e-30,  2.258785484748917e-01,
 -8.395168751998291e-04,  2.129235887150320e-06, -4.061730042794408e-09,  4.955386282360287e-12,  1.458599621162851e-15, -2.972876468712539e-17,  9.910552556280764e-20,
 -1.968762633343005e-22,  1.527091165180780e-25,  6.168476726330157e-28, -3.342705577546567e-30,  2.604157530305267e-01, -9.572104070720939e-04,  2.357905763973569e-06,
 -4.185190170821451e-09,  3.905182883980159e-12,  6.487721704858837e-15, -4.244851685163316e-17,  1.140285082408449e-19, -1.635517975303936e-22, -9.697985757724987e-26,
  1.397086965818566e-27, -4.675781653833296e-30,  2.973567574516540e-01, -1.079728553721764e-03,  2.573480676628124e-06, -4.183610539787306e-09,  2.398063314465649e-12,
  1.235797228552828e-14, -5.444769494335236e-17,  1.173176139555376e-19, -8.408558377989696e-23, -4.449169519402556e-25,  2.185266985234283e-27, -5.127233033487575e-30,
  3.366818112352361e-01, -1.206221664013628e-03,  2.769837245173679e-06, -4.036586793844978e-09,  4.250187418248873e-13,  1.879530493376189e-14, -6.411859012948730e-17,
  1.042384056009036e-19,  4.530795458480769e-23, -8.526594384722788e-25,  2.748246681590795e-27, -4.004637636505117e-30,  3.783672421929313e-01, -1.335745800122375e-03,
  2.940501051828306e-06, -3.725518551625045e-09, -1.998496181939094e-12,  2.540665560590681e-14, -6.961550792509923e-17,  7.080866000646171e-20,  2.202326797401580e-22,
 -1.248540968186331e-24,  2.794598456011195e-27, -7.724012245995484e-31,  4.223847617944963e-01, -1.467255086085733e-03,  3.078696579690658e-06, -3.234568699372229e-09,
 -4.827547980553458e-12,  3.167772146560383e-14, -6.898452138980265e-17,  1.469849712801026e-20,  4.253241719008497e-22, -1.528660196210253e-24,  2.030585051407158e-27,
  4.652014978811474e-30,  4.687006552167899e-01, -1.599593690458549e-03,  3.177417307120933e-06, -2.551791005448184e-09, -7.982818403563410e-12,  3.697993906179302e-14,
 -6.035586963666357e-17, -6.373155613391837e-20,  6.322899138452074e-22, -1.566532380586856e-24,  2.508037311937065e-28,  1.157438527816934e-29,  5.172748373345923e-01,
 -1.731487607875077e-03,  3.229521407514448e-06, -1.670437641662705e-09, -1.134617939436425e-11,  4.059001684224942e-14, -4.220460703812224e-17, -1.603529345304149e-19,
  7.996488035175547e-22, -1.234189375806812e-24, -2.542475586621643e-27,  1.827877731829597e-29,  5.680597529582548e-01, -1.861536489055334e-03,  3.227859598267064e-06,
 -5.904500702558829e-10, -1.475728135890717e-11,  4.172583132296065e-14, -1.367855218256889e-17, -2.663183006484374e-19,  8.752307696168521e-22, -4.362555004667843e-25,
 -6.011678766651410e-27,  2.202229799017998e-29,  6.209990964072840e-01, -1.988205884354957e-03,  3.165442867111247e-06,  6.798770594542434e-10, -1.801188934748684e-11,
  3.960269055325157e-14,  2.501859643586476e-17, -3.674876324696454e-19,  8.025556232533919e-22,  8.442645049656833e-25, -9.387829861263244e-27,  1.946388741686995e-29,
  6.760263220787081e-01, -2.109820421768811e-03,  3.035659001569408e-06,  2.122091286938037e-09, -2.086294471463789e-11,  3.351364166751570e-14,  7.221842746079059e-17,
 -4.445714406042675e-19,  5.319971325158452e-22,  2.494557173819080e-24, -1.146699576053848e-26,  7.693803303328038e-30,  7.330629141664624e-01, -2.224558647953817e-03,
  2.832547913012428e-06,  3.705702416009602e-09, -2.302560332545470e-11,  2.293626032982193e-14,  1.244074606021060e-16, -4.744088294506469e-19,  3.695723417491201e-23,
  4.227984438361880e-24, -1.077516263522148e-26, -1.411299446761503e-29,  7.920163803656176e-01, -2.330450534151280e-03,  2.551146430407552e-06,  5.386340849866776e-09,
 -2.418777798986085e-11,  7.665661208647196e-15,  1.759619833975771e-16, -4.328249154081316e-19, -6.661045380834866e-22,  5.568990428194677e-24, -5.971244635734691e-27,
 -4.270889567509825e-29,  8.527779316721840e-01, -2.425379003491800e-03,  2.187913132074640e-06,  7.104135047859213e-09, -2.402793617831910e-11, -1.203139467336120e-14,
  2.191231729583242e-16, -2.994265640725243e-19, -1.497214617782237e-21,  5.896022081091950e-24,  3.491013387994352e-27, -6.923307878372712e-29,  9.152198089301218e-01,
 -2.507087288248447e-03,  1.741242250110650e-06,  8.782579344941449e-09, -2.224197272415056e-11, -3.525424509068120e-14,  2.443754831643156e-16, -6.440881296191233e-20,
 -2.298596582050136e-21,  4.573288219071859e-24,  1.653689030890701e-26, -7.946504213040521e-29,  9.791922176003905e-01, -2.573194489163366e-03,  1.212071769023235e-06,
  1.032827898153466e-08, -1.858072433157163e-11, -6.032234977524399e-14,  2.414148593244444e-16,  2.631502191553729e-19, -2.836721646394300e-21,  1.189865147882539e-24,
  2.976746221980173e-26, -5.752608942062842e-29,  1.044519836847663e+00, -2.621222390506902e-03,  6.045831825040755e-07,  1.163209763570343e-08, -1.289886573286114e-11,
 -8.468528015695537e-14,  2.008777548189651e-16,  6.470211857996949e-19, -2.833471650500560e-21, -4.112184844720686e-24,  3.740281367265296e-26,  5.888333896004983e-30,
  1.110997879650956e+00, -2.648637373654034e-03, -7.302288675943577e-08,  1.257238231448787e-08, -5.214178004062426e-12, -1.049461678175498e-13,  1.169087541452584e-16,
  1.018481505858025e-18, -2.038077734121183e-21, -1.030838012678819e-23,  3.255309111335887e-26,  1.019001487067008e-28,  1.178387700323140e+00, -2.652912125873157e-03,
 -8.077122128356332e-07,  1.302107259882142e-08,  4.226912671286267e-12, -1.170724801716162e-13, -9.575727818873525e-18,  1.278319641474154e-18, -3.424997550882606e-22,
 -1.534482870936065e-23,  1.033009823501081e-26,  1.938972326096151e-28,  1.246411978743484e+00, -2.631612660277527e-03, -1.580832478552944e-06,  1.285356000162423e-08,
  1.488645591372024e-11, -1.168744433905292e-13, -1.674638325868182e-16,  1.311548537546820e-18,  2.078499868024540e-21, -1.644158904552817e-23, -2.751849736813138e-26,
  2.204851894641549e-28,  1.314749562170834e+00, -2.582516756285141e-03, -2.367472466641371e-06,  1.196305269130635e-08,  2.589037614222629e-11, -1.008131824847961e-13,
 -3.329726301841557e-16,  1.019186210957612e-18,  4.656456806049282e-21, -1.109573654443451e-23, -6.845154168660284e-26,  1.225503666284036e-28,  1.383030122273526e+00,
 -2.503769968161339e-03, -3.136137363268002e-06,  1.027977512606893e-08,  3.602570272904922e-11, -6.713654089585033e-14, -4.698700685672440e-16,  3.665602248889447e-19,
  6.441120793508025e-21,  1.224916046382191e-24, -8.949219685060417e-26, -1.045115776900756e-28,  1.450828894167607e+00, -2.394084312704306e-03, -3.848982201890941e-06,
  7.794398841898991e-09,  4.381027258071747e-11, -1.720793290641342e-14, -5.345341030936756e-16, -5.628893930817580e-19,  6.344625034673305e-21,  1.730626099038956e-23,
 -6.669051029113975e-26, -3.601018056870133e-28,  1.517661912203816e+00, -2.252981885726973e-03, -4.462915166771073e-06,  4.583459746466282e-09,  4.766731010273248e-11,
  4.331654924646345e-14, -4.875149360383412e-16, -1.534587764790658e-18,  3.668285837455695e-21,  2.973846674929662e-23,  5.798219854328683e-27, -4.494709260804731e-28,
  1.582982346805973e+00, -2.081080001482138e-03, -4.931928592330414e-06,  8.320688861757750e-10,  4.622631418890599e-11,  1.040604306092120e-13, -3.111186128279111e-16,
 -2.189940758763071e-18, -1.221295313620565e-21,  2.953867686055555e-23,  9.709995445463572e-26, -2.126352658457179e-28,  1.646178772228656e+00, -1.880404947711909e-03,
 -5.210996243477438e-06, -3.153820138779562e-09,  3.873866258673550e-11,  1.510214645370265e-13, -2.820828245676285e-17, -2.167960076098821e-18, -6.485461780332124e-21,
  1.230489780383668e-23,  1.433150765509290e-25,  2.710744802462412e-28,  1.706576435398371e+00, -1.654707336640632e-03, -5.261729608544868e-06, -6.956122124144747e-09,
  2.553476969903697e-11,  1.698271242085519e-13,  2.881504812963080e-16, -1.312369544505133e-18, -9.281256513718350e-21, -1.522911089052670e-23,  9.117022831375815e-26,
  6.139961791578389e-28,  1.763442805092526e+00, -1.409733548308965e-03, -5.059643048327436e-06, -1.008561762006995e-08,  8.365950267332020e-12,  1.510590916070295e-13,
  5.276825665033356e-16,  1.308328576644048e-19, -7.408078785421892e-21, -3.526674180442209e-23, -3.828753678170229e-26,  4.217073964760721e-28,  1.815998779989795e+00,
 -1.153387241190748e-03, -4.602290563262607e-06, -1.206260290836514e-08, -9.598231128395585e-12,  9.611823686535586e-14,  5.862527798002755e-16,  1.501987543851613e-18,
 -1.394371134076122e-21, -3.104767279581874e-23, -1.373022629796237e-25, -1.884095900323816e-28,  1.863436811615202e+00, -8.956979828306694e-04, -3.916743682277212e-06,
 -1.253323987110802e-08, -2.433971191567998e-11,  2.043546784157999e-14,  4.279362126854483e-16,  2.045533787126749e-18,  4.923859714034373e-21, -4.537115056587386e-24,
 -1.071828245421883e-25, -5.469404970416270e-28,  1.904946725341907e+00, -6.485102165126789e-04, -3.064083100924771e-06, -1.139866775755480e-08, -3.218527836033592e-11,
 -4.970169740396894e-14,  1.277341877222175e-16,  1.458065112346797e-18,  6.964262097650173e-21,  2.032802607888855e-23,  1.478658723463697e-26, -2.452839211266182e-28,
  1.939749100244593e+00, -4.248268770546275e-04, -2.138188098266516e-06, -8.912655749532513e-09, -3.133172140255698e-11, -8.810397019365806e-14, -1.522383709265593e-16,
  2.318268811725499e-19,  3.708442395827206e-21,  2.100901157045082e-23,  8.266857588067988e-26,  2.213193336010331e-28,  1.967134712310109e+00, -2.377972448919415e-04,
 -1.256663841747093e-06, -5.692679872150364e-09, -2.301337641926021e-11, -8.332508672128712e-14, -2.635948496594490e-16, -6.698933099606764e-19, -9.158568538318452e-22,
  3.334001016077529e-24,  3.705148798080435e-26,  2.113991490678887e-28,  1.986507076191297e+00, -9.942579926370563e-05, -5.436102852085665e-07, -2.604492055022087e-09,
 -1.148670861554832e-11, -4.752301609405897e-14, -1.856035703215214e-16, -6.832424311626184e-19, -2.348108058247447e-21, -7.363624399740916e-24, -1.993123513386270e-26,
 -3.864436092723149e-29,  1.997426239209363e+00, -1.916120548558667e-05, -1.067750325695384e-07, -5.275031575981444e-10, -2.435222596759958e-12, -1.075043700006133e-14,
 -4.592837464818379e-17, -1.911871430245602e-19, -7.786033094456686e-22, -3.109519198307773e-24, -1.219411107823871e-26, -4.697659041515539e-29,  3.059557194272842e-04,
 -1.204470917249959e-06,  3.555783054904339e-09, -9.329945168062315e-12,  2.294495839194994e-14, -5.416448795697630e-17,  1.242577962495165e-19, -2.792333391421792e-22,
  6.171910822208530e-25, -1.347941816030849e-27,  2.908962326383056e-30, -6.239519803712442e-33,  2.753556789900128e-03, -1.083316229485136e-05,  3.193415594720210e-08,
 -8.357225568433605e-11,  2.046898044883258e-13, -4.803652972681003e-16,  1.093207184953177e-18, -2.431042174238946e-21,  5.302017076582680e-24, -1.138909197001107e-26,
  2.408200890781393e-29, -5.041068215080126e-32,  7.648516910606205e-03, -3.005272810501932e-05,  8.832851343646189e-08, -2.299404125280439e-10,  5.585380765809802e-13,
 -1.295120834498017e-15,  2.898962723893900e-18, -6.305958999874094e-21,  1.336335462142679e-23, -2.767058796184623e-26,  5.582833469545555e-29, -1.102035657432824e-31,
  1.499033419230874e-02, -5.878715684224203e-05,  1.720126472891528e-07, -4.442122466002509e-10,  1.065388645788428e-12, -2.424586677454274e-15,  5.285818042963556e-18,
 -1.108913926190389e-20,  2.237098621327955e-23, -4.333425817372501e-26,  7.970097618218015e-29, -1.381076608765693e-31,  2.477821078277499e-02, -9.692148325770588e-05,
  2.818937059062333e-07, -7.200821676866122e-10,  1.697049163840269e-12, -3.761626628505635e-15,  7.891546973636658e-18, -1.566303886621944e-20,  2.913245549307188e-23,
 -4.987070069720147e-26,  7.448680157503057e-29, -8.483584604360386e-32,  3.701099772392333e-02, -1.443006397268886e-04,  4.165080618282482e-07, -1.049196527912138e-09,
  2.416801443103634e-12, -5.170198375949919e-15,  1.027265795478675e-17, -1.872830757801393e-20,  3.019946082867440e-23, -3.902842565446743e-26,  2.279409054480764e-29,
  7.966664798372072e-32,  5.168711952776370e-02, -2.007279064060404e-04,  5.740160019092873e-07, -1.421204459326416e-09,  3.180178826532533e-12, -6.491243737749616e-15,
  1.193743466999613e-17, -1.895673492734941e-20,  2.248075150484343e-23, -4.991494244932195e-27, -8.201747325681490e-29,  3.465067428024458e-31,  6.880447677681763e-02,
 -2.659629446327647e-04,  7.521954305663513e-07, -1.823827493626537e-09,  3.935975500061109e-12, -7.550107780193244e-15,  1.238610778837581e-17, -1.516861754397251e-20,
  3.907283025729027e-24,  5.347597357307803e-26, -2.299804409368269e-28,  6.552228412926843e-31,  8.836032454692544e-02, -3.397193944097038e-04,  9.484348488287430e-07,
 -2.242952284311218e-09,  4.627512285852445e-12, -8.165500505380176e-15,  1.115719311467620e-17, -6.524340559277259e-21, -2.591865927145829e-23,  1.312741172037229e-25,
 -3.912721801968370e-28,  8.938445807253937e-31,  1.103511238828155e-01, -4.216620134705205e-04,  1.159725962581349e-06, -2.662751886149575e-09,  5.194187550614423e-12,
 -8.159991031309254e-15,  7.878619482090678e-18,  7.282988148714278e-21, -6.517207041697906e-23,  2.159893980584911e-25, -5.170477522678936e-28,  9.158784842637791e-31,
  1.347723629138667e-01, -5.114033325279687e-04,  1.382656388044675e-06, -3.065842324888300e-09,  5.573345118719245e-12, -7.371982485613708e-15,  2.321731448895250e-18,
  2.585032815957114e-20, -1.094448395880732e-22,  2.880849328463288e-25, -5.455198089886971e-28,  5.758218145803686e-31,  1.616183434613761e-01, -6.084997990852071e-04,
  1.613403067960524e-06, -3.433482627875313e-09,  5.702492966783628e-12, -5.669050219314908e-15, -5.544435671087488e-18,  4.792298040513382e-20, -1.516774222843120e-22,
  3.226055049425933e-25, -4.138476929118842e-28, -2.192097390738853e-31,  1.908819281390604e-01, -7.124473809992896e-04,  1.847727196385255e-06, -3.745828091081258e-09,
  5.521906221791604e-12, -2.962429028527848e-15, -1.550206642877895e-17,  7.131203170319594e-20, -1.824847434713219e-22,  2.926364885407752e-25, -7.544306900604184e-29,
 -1.449412682786751e-30,  2.225542419622832e-01, -8.226766013097701e-04,  2.080971683368587e-06, -3.982248321903118e-09,  4.977644485520320e-12,  7.777020636794401e-16,
 -2.704115175358050e-17,  9.289792747698247e-20, -1.909689109070620e-22,  1.745661535929015e-25,  4.790283947845547e-28, -2.927488710530640e-30,  2.566243213321541e-01,
 -9.385469783717011e-04,  2.308062485014777e-06, -4.121723487197199e-09,  4.025005221916991e-12,  5.506676625726951e-15, -3.932944008082290e-17,  1.087493806273799e-19,
 -1.660856553378452e-22, -4.509073431066899e-26,  1.200335289841228e-27, -4.268644332663626e-30,  2.930787019182393e-01, -1.059340851013068e-03,  2.523515493541605e-06,
 -4.143334139774663e-09,  2.632419757705795e-12,  1.109032806427909e-14, -5.120276224584330e-17,  1.143870356877373e-19, -9.858302147230120e-23, -3.619572287879309e-25,
  1.964310630553606e-27, -4.908950843395281e-30,  3.319009353947027e-01, -1.184256578582658e-03,  2.721451142228853e-06, -4.026861860886584e-09,  7.857735206648341e-13,
  1.729161909556519e-14, -6.118408215449658e-17,  1.052179961167224e-19,  1.654788775376679e-23, -7.463178796451785e-25,  2.567444419108612e-27, -4.195357263915657e-30,
  3.730710231526148e-01, -1.312401122157451e-03,  2.895619449787353e-06, -3.753519516359880e-09, -1.506906255409799e-12,  2.376043072477795e-14, -6.754080495204365e-17,
  7.715843907358193e-20,  1.772868713754258e-22, -1.137681826415965e-24,  2.742603101729475e-27, -1.562909133922650e-30,  4.165647529771758e-01, -1.442782038272324e-03,
  3.039438927045144e-06, -3.306830820488530e-09, -4.210508765433237e-12,  3.002851934001462e-14, -6.839057739885920e-17,  2.744441226114553e-20,  3.717997278247140e-22,
 -1.443782773059667e-24,  2.202740732887614e-27,  3.204081927256722e-30,  4.623529222038112e-01, -1.574298953601124e-03,  3.146053614745181e-06, -2.673678579965952e-09,
 -7.257837978771476e-12,  3.551221873210085e-14, -6.186554599549801e-17, -4.439770355032456e-20,  5.761928455204495e-22, -1.546885995408469e-24,  7.175914403873833e-28,
  9.662981671644944e-30,  5.104004280163016e-01, -1.705734642450657e-03,  3.208413529684463e-06, -1.845538619155685e-09, -1.054485707647225e-11,  3.952607749994809e-14,
 -4.634305695762330e-17, -1.354931527185130e-19,  7.535763497123600e-22, -1.320340204735933e-24, -1.778472419669658e-27,  1.643896970130949e-29,  5.606652022980619e-01,
 -1.835745904558077e-03,  3.219384972893166e-06, -8.199107544317443e-10, -1.392663530603758e-11,  4.131121183182773e-14, -2.074604220336441e-17, -2.386067278786391e-19,
  8.554285500253232e-22, -6.575826886938555e-25, -5.061227689149977e-27,  2.112470548872571e-29,  6.130969647894389e-01, -1.962854546162224e-03,  3.171898484468989e-06,
  3.980524386960731e-10, -1.721464942719693e-11,  4.008258859873684e-14,  1.509254991373617e-17, -3.413903324956401e-19,  8.263996843304357e-22,  4.862417934900332e-25,
 -8.505488566268717e-27,  2.053838899408950e-29,  6.676357642711316e-01, -2.085438912563743e-03,  3.059143666895577e-06,  1.793736330321280e-09, -2.017633746411004e-11,
  3.509951145586654e-14,  6.002163543030940e-17, -4.261984583581448e-19,  6.136374442873781e-22,  2.043834371187252e-24, -1.104120766615552e-26,  1.152973611624981e-29,
  7.242102731800719e-01, -2.201726618003164e-03,  2.874821535183567e-06,  3.341120279587656e-09, -2.253809501099845e-11,  2.576290929270476e-14,  1.111628525552729e-16,
 -4.708751589786517e-19,  1.812749288233753e-22,  3.786529829419429e-24, -1.124986745054731e-26, -7.565435174917671e-30,  7.827357966629115e-01, -2.309789384300909e-03,
  2.613466285160927e-06,  5.000788200776950e-09, -2.399322720493403e-11,  1.174109451488407e-14,  1.635742610305680e-16, -4.509821598932496e-19, -4.703523724015485e-22,
  5.294830723570557e-24, -7.680317725417415e-27, -3.496601851742586e-29,  8.431119529340760e-01, -2.407541251997393e-03,  2.270849047613969e-06,  6.718045837052231e-09,
 -2.421668075437274e-11, -6.878262832959099e-15,  2.101005443752327e-16, -3.439202381540195e-19, -1.283164215705273e-21,  5.976317327672384e-24,  5.650328476801934e-28,
 -6.357000997902866e-29,  9.052199785201964e-01, -2.492741887775333e-03,  1.844475735277669e-06,  8.421385007052866e-09, -2.288859588374277e-11, -2.941903006087017e-14,
  2.415678861990787e-16, -1.352088931512145e-19, -2.122898547692288e-21,  5.164401183696464e-24,  1.301231903899193e-26, -8.035258517982794e-29,  9.689196104879506e-01,
 -2.563007301210099e-03,  1.334188580653412e-06,  1.002165294247290e-08, -1.972868775132343e-11, -5.445018459412920e-14,  2.475202623837238e-16,  1.732851289655905e-19,
 -2.773096216181581e-21,  2.326434485519765e-24,  2.697923235838613e-26, -6.875104724308550e-29,  1.034045499535283e+00, -2.615831019841799e-03,  7.428750356278471e-07,
  1.141243405740179e-08, -1.454294672555526e-11, -7.965718721522943e-14,  2.177047572548643e-16,  5.542703431479562e-19, -2.954576726263753e-21, -2.617337700007646e-24,
  3.718265238182856e-26, -1.564191489986567e-29,  1.100403115079957e+00, -2.648619659133571e-03,  7.727639544200573e-08,  1.247232608764073e-08, -7.282772852650559e-12,
 -1.018058513249242e-13,  1.444592289558900e-16,  9.475850447597392e-19, -2.384725682616618e-21, -8.923754539578158e-24,  3.649741627612485e-26,  7.709672548958624e-29,
  1.167764119414252e+00, -2.658747840341842e-03, -6.511308331343114e-07,  1.306997125880113e-08,  1.886055567178534e-12, -1.168745278885337e-13,  2.598140027070730e-17,
  1.258617260131893e-18, -8.854513404246684e-22, -1.476454173267554e-23,  1.858563846687217e-26,  1.803690572216498e-28,  1.235861217133749e+00, -2.643638479115259e-03,
 -1.425238468839522e-06,  1.307283762654962e-08,  1.251178681421704e-11, -1.204459332413807e-13, -1.298996907105828e-16,  1.368397008321872e-18,  1.469171927517640e-21,
 -1.734352086335095e-23, -1.747415108909820e-26,  2.347474865168346e-28,  1.304382534514613e+00, -2.600875423314376e-03, -2.221498274183247e-06,  1.236074440474773e-08,
  2.379659596132823e-11, -1.084456289990924e-13, -3.024130759768871e-16,  1.161284651522458e-18,  4.209156081064232e-21, -1.371158201781415e-23, -6.199254741593233e-26,
  1.703215184281119e-28,  1.372965659160315e+00, -2.528355944879543e-03, -3.009367878597005e-06,  1.084483572158554e-08,  3.457115490721731e-11, -7.826695137132121e-14,
 -4.567191034674314e-16,  5.726828256259060e-19,  6.419836639737120e-21, -2.428919483747179e-24, -9.274783270248142e-26, -4.252659969656689e-29,  1.441191582358796e+00,
 -2.424490153490415e-03, -3.751257258360721e-06,  8.491907962689638e-09,  4.333667004645271e-11, -3.020238354339993e-14, -5.473628005333586e-16, -3.504383716271552e-19,
  6.915885528247469e-21,  1.432975073740863e-23, -8.190837578012452e-26, -3.289884135263133e-28,  1.508578944746944e+00, -2.288452173845553e-03, -4.403311097699751e-06,
  5.352417278557929e-09,  4.841322981134805e-11,  3.111482366156437e-14, -5.286789658358059e-16, -1.400068012039301e-18,  4.738154083653729e-21,  2.956132293868369e-23,
 -1.496464709154909e-26, -4.918696143471300e-28,  1.574579197135797e+00, -2.120482761924511e-03, -4.917438730943005e-06,  1.587912968578787e-09,  4.822786899041134e-11,
  9.585435649031992e-14, -3.728190017257281e-16, -2.211278464506218e-18, -9.052680529094270e-23,  3.320463024876994e-23,  8.542534881801802e-26, -3.186052311255283e-28,
  1.638573551985447e+00, -1.922233534900681e-03, -5.245023675916077e-06, -2.509895941929663e-09,  4.174728563868420e-11,  1.495930291619961e-13, -9.174204075021027e-17,
 -2.367278857357927e-18, -5.936631162918635e-21,  1.825296387922797e-23,  1.534731720863516e-25,  1.866239154258952e-28,  1.699872899861472e+00, -1.697127861399654e-03,
 -5.342638468698403e-06, -6.520030824648757e-09,  2.899731634268755e-11,  1.762677384730626e-13,  2.471690386664107e-16, -1.617384357058594e-18, -9.757248327332035e-21,
 -1.103097996364178e-23,  1.189717245349832e-25,  6.462151748234178e-28,  1.757722153624462e+00, -1.450692292718356e-03, -5.179765398400913e-06, -9.926904114599952e-09,
  1.151392918859511e-11,  1.637394626898936e-13,  5.278343175157097e-16, -1.267963432565883e-19, -8.700433636787189e-21, -3.638931078538105e-23, -1.688632011813451e-26,
  5.527030935237562e-28,  1.811310674131442e+00, -1.190787030218289e-03, -4.747897275161533e-06, -1.220001702028834e-08, -7.531789796002617e-12,  1.106868583046081e-13,
  6.275080779185988e-16,  1.438409290955372e-18, -2.612747063287410e-21, -3.668365481270148e-23, -1.439029534051629e-25, -1.067996636594468e-28,  1.859790389957922e+00,
 -9.276401134189811e-04, -4.069463824088356e-06, -1.291882776650726e-08, -2.382356733208143e-11,  3.141085928289098e-14,  4.873863154760080e-16,  2.199608268246139e-18,
  4.677381035559818e-21, -9.324447581466154e-24, -1.326354892696779e-25, -6.088681199519559e-28,  1.902302780390192e+00, -6.735788461617855e-04, -3.203989125272278e-06,
 -1.192140357498165e-08, -3.314521618104012e-11, -4.612030452854717e-14,  1.717906993044895e-16,  1.692721881117379e-18,  7.703870797568322e-21,  2.067639046470202e-23,
  1.921895333205114e-27, -3.427654232326166e-28,  1.938014892155414e+00, -4.423688467407881e-04, -2.248206597559714e-06, -9.428255988614156e-09, -3.312973987854274e-11,
 -9.166566540155712e-14, -1.439674743721012e-16,  3.632555798443217e-19,  4.526649975821343e-21,  2.451204255589708e-23,  9.250619938317646e-26,  2.244530664796824e-28,
  1.966162975058431e+00, -2.481301928173734e-04, -1.327241409896413e-06, -6.074576071859828e-09, -2.474467684181103e-11, -8.987963740953708e-14, -2.827419739273226e-16,
 -6.969753009702587e-19, -7.667897639193963e-22,  5.015866803576374e-24,  4.739844976982483e-26,  2.603872907695195e-28,  1.986100472780130e+00, -1.039028953891008e-04,
 -5.759990812232182e-07, -2.796131762919636e-09, -1.248330832930323e-11, -5.221581252428678e-14, -2.058272789538600e-16, -7.627805179994482e-19, -2.627956573596872e-21,
 -8.194608855992616e-24, -2.160783115534714e-26, -3.723770657814685e-29,  1.997347844939489e+00, -2.004140501727014e-05, -1.133461462179343e-07, -5.682485517797842e-10,
 -2.661702761171389e-12, -1.191987920491800e-14, -5.164795299510444e-17, -2.179918690350945e-19, -8.998477046462507e-22, -3.641262335651636e-24, -1.446156969463423e-26,
 -5.639084690199462e-29,  3.011940279149586e-04, -1.176466330440455e-06,  3.445991198028101e-09, -8.971332738413773e-12,  2.189086854937584e-14, -5.127393553411925e-17,
  1.167086263503222e-19, -2.602377078390249e-22,  5.706951285702920e-25, -1.236892443141236e-27,  2.647881337443791e-30, -5.638709023329092e-33,  2.710728813374207e-03,
 -1.058164556092688e-05,  3.095062661441551e-08, -8.037267452129736e-11,  1.953394521640237e-13, -4.549263552117782e-16,  1.027452970728220e-18, -2.267756084138596e-21,
  4.908827306394172e-24, -1.046874710785075e-26,  2.196960595410715e-29, -4.569056300602468e-32,  7.529701990843537e-03, -2.935698715929035e-05,  8.562200544498169e-08,
 -2.212073015638775e-10,  5.333173549136158e-13, -1.227617114715191e-15,  2.728235920263277e-18, -5.893848225884916e-21,  1.240626773674196e-23, -2.553153897535759e-26,
  5.119405255089086e-29, -1.005996672666035e-31,  1.475790441147180e-02, -5.743209170716254e-05,  1.667827994550467e-07, -4.275471735607863e-10,  1.018140770433084e-12,
 -2.301373521492648e-15,  4.985114139229426e-18, -1.039762465105370e-20,  2.086690034432576e-23, -4.026477487820279e-26,  7.384563178021453e-29, -1.281607746014611e-31,
  2.439498106700582e-02, -9.470044160868038e-05,  2.734131868711317e-07, -6.935210979864086e-10,  1.623675616233752e-12, -3.577388577758940e-15,  7.465767382736374e-18,
 -1.475895806473101e-20,  2.738984312805747e-23, -4.696565889550004e-26,  7.077208525010253e-29, -8.390541497440204e-32,  3.644038047286814e-02, -1.410182870681587e-04,
  4.041463470101521e-07, -1.011341717362054e-09,  2.315820996574065e-12, -4.929839386917869e-15,  9.761584771774169e-18, -1.778422273039075e-20,  2.881164067221181e-23,
 -3.805237135504933e-26,  2.587033203090996e-29,  6.067177429700431e-32,  5.089328535493771e-02, -1.962031409626195e-04,  5.572626112779875e-07, -1.371344809693077e-09,
  3.053176361559119e-12, -6.211033666159585e-15,  1.141668610907784e-17, -1.824083017389631e-20,  2.224555205285547e-23, -7.981181404037525e-27, -6.780090255598932e-29,
  3.006355057133126e-31,  6.775252301070160e-02, -2.600318656945365e-04,  7.306824231447174e-07, -1.762043895514713e-09,  3.787911688242878e-12, -7.257922003310345e-15,
  1.196341403417951e-17, -1.501450264707873e-20,  5.673588607133440e-24,  4.483241346783472e-26, -2.027034720215323e-28,  5.857530180374564e-31,  8.701645322321401e-02,
 -3.322383309627311e-04,  9.219583203204501e-07, -2.170204082581627e-09,  4.466864738662958e-12, -7.900009510339852e-15,  1.096358937851883e-17, -7.281068800244719e-21,
 -2.146523254065555e-23,  1.163874878654841e-25, -3.536038069766614e-28,  8.190835470210364e-31,  1.086828310534912e-01, -4.125106173775025e-04,  1.128266229817058e-06,
 -2.580940145000111e-09,  5.032893928520117e-12, -7.968685698028595e-15,  8.054486991668447e-18,  5.317978210146709e-21, -5.775913552988060e-23,  1.961001272813550e-25,
 -4.777507647293205e-28,  8.699065269712404e-31,  1.327486412073642e-01, -5.004877370898840e-04,  1.346396466231509e-06, -2.977845053552345e-09,  5.426519307914354e-12,
 -7.307961539591591e-15,  2.998038729285792e-18,  2.250986891839997e-20, -9.946036634119189e-23,  2.667798714668491e-25, -5.195364713329040e-28,  6.028839704099709e-31,
  1.592098999477830e-01, -5.957558392912772e-04,  1.572744951981107e-06, -3.343156571890429e-09,  5.587887197728502e-12, -5.786552403057490e-15, -4.268820638303826e-18,
  4.325191254303867e-20, -1.403635181088109e-22,  3.059023169505774e-25, -4.202823541327280e-28, -7.782166111415692e-32,  1.880614196815844e-01, -6.978438658489900e-04,
  1.803305343432346e-06, -3.657971127728531e-09,  5.459095511913040e-12, -3.311167934556507e-15, -1.358550380750517e-17,  6.564037641247769e-20, -1.720187540094022e-22,
  2.884267113302866e-25, -1.330481039047065e-28, -1.175080407921060e-30,  2.192965303657963e-01, -8.062186208856177e-04,  2.033662958824615e-06, -3.902515967426279e-09,
  4.986915799148415e-12,  1.592435145175184e-16, -2.452459416385013e-17,  8.689092548491964e-20, -1.843696245237797e-22,  1.912656537020501e-25,  3.587192794175510e-28,
 -2.546796937750663e-30,  2.529067507236663e-01, -9.202792183755026e-04,  2.258991674751476e-06, -4.056492596503068e-09,  4.125943223411493e-12,  4.598708112386342e-15,
 -3.635904385451292e-17,  1.034175736719255e-19, -1.668888710658815e-22, -7.159479932569467e-28,  1.021296161622992e-27, -3.871636047760145e-30,  2.888814009012234e-01,
 -1.039350874656382e-03,  2.474055302456775e-06, -4.099506657160845e-09,  2.842195194378428e-12,  9.899527829802875e-15, -4.804594366288129e-17,  1.110386379541020e-19,
 -1.102505721101237e-22, -2.876316777386365e-25,  1.753831334225132e-27, -4.653159056950691e-30,  3.272071465928889e-01, -1.162678019313866e-03,  2.673215390922080e-06,
 -4.011601607102969e-09,  1.117160563725806e-12,  1.585859008185146e-14, -5.823446467156105e-17,  1.053371069199589e-19, -8.515796164568558e-24, -6.473450098920696e-25,
  2.380551648347931e-27, -4.284529231306321e-30,  3.678674627759459e-01, -1.289416709827098e-03,  2.850447951216200e-06, -3.773915675135464e-09, -1.047729283470991e-12,
  2.216598062036338e-14, -6.530695115892509e-17,  8.219734065005362e-20,  1.382866201968953e-22, -1.029549269211576e-24,  2.659447288933637e-27, -2.191675806188841e-30,
  4.108420029703905e-01, -1.418626354928393e-03,  2.999372279069546e-06, -3.369483294104411e-09, -3.626283126652020e-12,  2.839766382115701e-14, -6.746325860870087e-17,
  3.852764228686569e-20,  3.214399678209904e-22, -1.353238610415064e-24,  2.315266178847991e-27,  1.940639067079139e-30,  4.561058573311647e-01, -1.549260781934432e-03,
  3.113295895017854e-06, -2.784203091139343e-09, -6.562531478834445e-12,  3.401456027558687e-14, -6.285887489250992e-17, -2.684419956265097e-20,  5.211191982347303e-22,
 -1.510213324138124e-24,  1.103065026474809e-27,  7.881476346311363e-30,  5.036286798315218e-01, -1.680158728587213e-03,  3.185280648025662e-06, -2.007993832762683e-09,
 -9.765751263829228e-12,  3.837099898948714e-14, -4.980649856469701e-17, -1.121515734070783e-19,  7.049329120434733e-22, -1.377563121631469e-24, -1.096310505883852e-27,
  1.456735852863656e-29,  5.533736612609034e-01, -1.810033905929719e-03,  3.208236258545823e-06, -1.036156394453067e-09, -1.310591539110521e-11,  4.073620496190661e-14,
 -2.704762556629084e-17, -2.116490560238512e-19,  8.283325041369248e-22, -8.417743914071895e-25, -4.157053656763101e-27,  1.993193286181635e-29,  6.052963207025687e-01,
 -1.937464873116577e-03,  3.175049016897318e-06,  1.290477466325394e-10, -1.641013421253180e-11,  4.033310477696077e-14,  5.906021357355514e-18, -3.147293503855698e-19,
  8.379999577702615e-22,  1.642782076558066e-25, -7.589189565417025e-27,  2.102037879202282e-29,  6.593430835667501e-01, -2.060885098008731e-03,  3.078754982683493e-06,
  1.476605104293489e-09, -1.946089691545325e-11,  3.639911190148351e-14,  4.837344772985420e-17, -4.054689991247437e-19,  6.793968698527499e-22,  1.613287405940586e-24,
 -1.046388545578047e-26,  1.458593332614601e-29,  7.154496091759232e-01, -2.178573762230927e-03,  2.912768782273029e-06,  2.984773311902216e-09, -2.199722177458886e-11,
  2.827338202670706e-14,  9.807942953828330e-17, -4.629807124251536e-19,  3.094262068491955e-22,  3.331661562530961e-24, -1.145064443921229e-26, -1.676180016924371e-30,
  7.735388254580231e-01, -2.288648123132951e-03,  2.671180822018905e-06,  4.618984119741577e-09, -2.372017837002864e-11,  1.551381991514004e-14,  1.507642588303065e-16,
 -4.630457783760155e-19, -2.856183496753673e-22,  4.959122154859840e-24, -9.049102417082986e-27, -2.727949102113639e-29,  8.335186227715644e-01, -2.389058589045041e-03,
  2.349137134975956e-06,  6.329749038987043e-09, -2.430462502752426e-11, -1.955848071001670e-15,  1.999282639313770e-16, -3.815401305551861e-19, -1.068266834113202e-21,
  5.944882313196299e-24, -2.088032177722517e-27, -5.688158986748017e-29,  8.952791537605131e-01, -2.477588123788160e-03,  1.943316650135729e-06,  8.050774009564835e-09,
 -2.341934577725505e-11, -2.367433217223686e-14,  2.368596045781935e-16, -2.000734002939627e-19, -1.928461338919156e-21,  5.614428931959997e-24,  9.498984117186783e-27,
 -7.899558904819697e-29,  9.586896822637407e-01, -2.551858200086529e-03,  1.452519574418228e-06,  9.697606145669684e-09, -2.075794503815477e-11, -4.846141732607796e-14,
  2.511439394074982e-16,  8.608827484213094e-20, -2.670673296139674e-21,  3.342427185698104e-24,  2.375935601139322e-26, -7.713237259340511e-29,  1.023594923059704e+00,
 -2.609344297612647e-03,  8.783764812250871e-07,  1.116729073026812e-08, -1.608263979031397e-11, -7.425679879564903e-14,  2.318885484272197e-16,  4.585016465171835e-19,
 -3.022249644740055e-21, -1.149742217494304e-24,  3.605377491850856e-26, -3.531457785220817e-29,  1.089810817763524e+00, -2.647404910708936e-03,  2.261786049007693e-07,
  1.233971002278843e-08, -9.282116329521046e-12, -9.802935103328609e-14,  1.698770027615007e-16,  8.664216813115958e-19, -2.678954360490556e-21, -7.403623923070088e-24,
  3.931930072339740e-26,  5.105178743057945e-29,  1.157119703767748e+00, -2.663329192749316e-03, -4.941871115503562e-07,  1.308149402135585e-08, -4.423635220951476e-13,
 -1.158317662938415e-13,  6.074720701982208e-17,  1.221937138920822e-18, -1.401727649995707e-21, -1.386763913663870e-23,  2.612022833081893e-26,  1.612632242368263e-28,
  1.225264857499292e+00, -2.654409671567177e-03, -1.267243292990380e-06,  1.325359859234804e-08,  1.007482073983199e-11, -1.230990131326432e-13, -9.102109257842997e-17,
  1.405306098748202e-18,  8.347357640891700e-22, -1.783353311026395e-23, -6.982755116652839e-27,  2.407458058900853e-28,  1.293944437182952e+00, -2.618047788445734e-03,
 -2.070957688768516e-06,  1.272375561609265e-08,  2.155781470083512e-11, -1.152986037062679e-13, -2.680889342039774e-16,  1.287616633406723e-18,  3.672829112319694e-21,
 -1.602846980793938e-23, -5.354305217698359e-26,  2.126874989984216e-28,  1.362804922815891e+00, -2.551901055245880e-03, -2.875964588537027e-06,  1.138486179447345e-08,
  3.289762167719743e-11, -8.901268075997773e-14, -4.378261632361511e-16,  7.760000183257349e-19,  6.265341564555861e-21, -6.156941410088306e-24, -9.316936853735116e-26,
  2.386642592328292e-29,  1.431434263588602e+00, -2.454080862960435e-03, -3.645216296137249e-06,  9.179745660597644e-09,  4.260059169147486e-11, -4.343137683719989e-14,
 -5.540038742503371e-16, -1.215360085533329e-19,  7.369407262628887e-21,  1.077657191346734e-23, -9.540939620835337e-26, -2.821628676732187e-28,  1.499355108505024e+00,
 -2.323408535448585e-03, -4.334416153300653e-06,  6.131304922095971e-09,  4.890556067945883e-11,  1.797421693339588e-14, -5.655992628852592e-16, -1.231578178250907e-18,
  5.786287716694148e-21,  2.852095363873597e-23, -3.724285190874770e-26, -5.177727722254328e-28,  1.566018726457278e+00, -2.159732791533587e-03, -4.893692268311786e-06,
  2.374388370596321e-09,  5.005046745909438e-11,  8.616451092292965e-14, -4.345911175832571e-16, -2.194419283249235e-18,  1.162679984979885e-21,  3.630969066550619e-23,
  6.904830554285162e-26, -4.255224077705092e-28,  1.630800523044563e+00, -1.964302617560790e-03, -5.271036406406619e-06, -1.818147033179553e-09,  4.471165093190574e-11,
  1.465749975212047e-13, -1.605781429794632e-16, -2.545538250888755e-18, -5.167317313608054e-21,  2.452585190378280e-23,  1.593790597702584e-25,  7.788062896966955e-29,
  1.692998422168783e+00, -1.740173773416838e-03, -5.417977759084928e-06, -6.027564653216127e-09,  3.257813967720506e-11,  1.816207393325816e-13,  1.974582015722029e-16,
 -1.934995776804743e-18, -1.006180902720491e-20, -5.699153444755256e-24,  1.476771627445969e-25,  6.540155058610264e-28,  1.751835758517607e+00, -1.492603522166875e-03,
 -5.297672617651164e-06, -9.715796426256582e-09,  1.491494336116656e-11,  1.763322080783217e-13,  5.201886445973615e-16, -4.262508487073882e-19, -1.001637923450273e-20,
 -3.653801396385513e-23,  1.045938270329919e-26,  6.910309686238908e-28,  1.806470629789260e+00, -1.229357684255868e-03, -4.894944790332976e-06, -1.230198398149923e-08,
 -5.164242529362328e-12,  1.262196498448308e-13,  6.664065305715753e-16,  1.332553277228594e-18, -4.037824746215181e-21, -4.250292502824364e-23, -1.462384230809470e-25,
  6.138208128267370e-30,  1.856013727172177e+00, -9.608223557759684e-04, -4.226753971924088e-06, -1.329432231435954e-08, -2.307330276202096e-11,  4.386376454949240e-14,
  5.510127411351750e-16,  2.342836242995036e-18,  4.239597467342575e-21, -1.518191498803705e-23, -1.606172566624784e-25, -6.608405383833449e-28,  1.899556282334614e+00,
 -6.997920705997451e-04, -3.350257577425721e-06, -1.245886564282831e-08, -3.402240652254346e-11, -4.140002845286738e-14,  2.227500720378771e-16,  1.951138723182324e-18,
  8.445669723373238e-21,  2.041835604094484e-23, -1.568609364751652e-26, -4.612096027388555e-28,  1.936208716008402e+00, -4.608162076310681e-04, -2.364587221727985e-06,
 -9.973182303346220e-09, -3.499669336818587e-11, -9.498162116693519e-14, -1.316305166105518e-16,  5.229607229408548e-19,  5.478058315063999e-21,  2.840857224209128e-23,
  1.022681428596714e-25,  2.172218418619211e-28,  1.965148747071689e+00, -2.590465733456704e-04, -1.402572344843209e-06, -6.485247021667757e-09, -2.661172197598984e-11,
 -9.690222069381894e-14, -3.025709149244412e-16, -7.182341347420342e-19, -5.491816217092746e-22,  7.157440810513390e-24,  6.010654366815842e-26,  3.189380772435092e-28,
  1.985675427806787e+00, -1.086485789719348e-04, -6.107864120893030e-07, -3.004495061149083e-09, -1.357880340289658e-11, -5.742174279204100e-14, -2.284080148365080e-16,
 -8.517651891795715e-19, -2.938906994531304e-21, -9.090773775997504e-24, -2.317272039692960e-26, -3.341866869640416e-29,  1.997265821547645e+00, -2.097619266697437e-05,
 -1.204287434003869e-07, -6.128124609764453e-10, -2.913007604821459e-12, -1.323605443218721e-14, -5.817538861024362e-17, -2.490010481259114e-19, -1.041972362580104e-21,
 -4.272555349399880e-24, -1.718636773151114e-26, -6.783345934325050e-29,  };
  constexpr double w[18432] = {  6.474992797897361e-02, -1.751545278250026e-04,  4.945268529876320e-07, -1.443868713638180e-09,  4.316517857950237e-12,
 -1.310024536429339e-14,  4.009575951707571e-17, -1.231946480987671e-19,  3.788221065685845e-22, -1.163618204970220e-24,  3.566376954403747e-27, -1.089977844460235e-29,
  6.454907364267129e-02, -2.405338079209657e-04,  1.043461349378794e-06, -4.603302349408848e-09,  1.987656688031714e-11, -8.358647628604560e-14,  3.432329417211307e-16,
 -1.381024928369615e-18,  5.460577437674060e-21, -2.126606352708637e-23,  8.171751664449290e-26, -3.102607371335908e-28,  6.415001911986308e-02, -3.698155737187582e-04,
  2.324857920157026e-06, -1.364683781248296e-08,  7.525839079302003e-11, -3.955976875211483e-13,  2.001838963737741e-15, -9.816567049617218e-18,  4.686978998715212e-20,
 -2.186582637037204e-22,  9.994827346091570e-25, -4.486115933504196e-27,  6.355799646150596e-02, -5.600960482713194e-04,  4.693268421431535e-06, -3.478299280803126e-08,
  2.366178042708067e-10, -1.510359428852174e-12,  9.166973469409060e-15, -5.337606097748344e-17,  3.000645442542221e-19, -1.636480742122259e-21,  8.690554983168326e-24,
 -4.507082507131188e-26,  6.278066664136109e-02, -8.071415866700847e-04,  8.650128553974991e-06, -7.910234999495891e-08,  6.507897523677708e-10, -4.950258423182705e-12,
  3.539581926946895e-14, -2.405755191272637e-16,  1.566682765945082e-18, -9.833715083891373e-21,  5.976523056283794e-23, -3.529672773271172e-25,  6.182790465444075e-02,
 -1.105528249465975e-03,  1.480964016658315e-05, -1.643895945066747e-07,  1.611026237346965e-09, -1.439834452007039e-11,  1.196977289464122e-13, -9.379041595019418e-16,
  6.992072013166806e-18, -4.994103101666707e-20,  3.435926649242082e-22, -2.286598922312454e-24,  6.071152834391633e-02, -1.448816988930254e-03,  2.385699236956281e-05,
 -3.170472792996098e-07,  3.655550402529400e-09, -3.795698749138566e-11,  3.630592229963558e-13, -3.247574663901106e-15,  2.745860914625922e-17, -2.211971762621199e-19,
  1.708080318964027e-21, -1.270377042921006e-23,  5.944498283770006e-02, -1.829756061615125e-03,  3.650170512283297e-05, -5.737899515719597e-07,  7.702135567366160e-09,
 -9.203768282509320e-11,  1.004092295188920e-12, -1.016993752687289e-14,  9.677352486243533e-17, -8.727943435826994e-19,  7.511392290661917e-21, -6.201167300176508e-23,
  5.804299396864181e-02, -2.240501290000511e-03,  5.342912556267755e-05, -9.827702072859812e-07,  1.521663865075789e-08, -2.075388640726919e-10,  2.562960957016095e-12,
 -2.918689359877578e-14,  3.104991809412184e-16, -3.115511730391246e-18,  2.970276332800186e-20, -2.706194424518999e-22,  5.652120474708322e-02, -2.672844396927169e-03,
  7.525312185360004e-05, -1.603842678027976e-06,  2.840620050067394e-08, -4.389397541810975e-10,  6.094699428299634e-12, -7.755009409455532e-14,  9.169341145291606e-16,
 -1.017896461710218e-17,  1.069360601460816e-19, -1.069751901337796e-21,  5.489580885255672e-02, -3.118439822746569e-03,  1.024728121099952e-04, -2.507752156047287e-06,
  5.041983887791213e-08, -8.767406259250518e-10,  1.360381473954574e-11, -1.923153605597379e-13,  2.513907300957026e-15, -3.072091946570923e-17,  3.539448537972697e-19,
 -3.869961305400619e-21,  5.318319427222944e-02, -3.569021155879436e-03,  1.354357663974243e-04, -3.774138180203043e-06,  8.553184495124046e-08, -1.663278690659015e-09,
  2.867755636126403e-11, -4.480798851850669e-13,  6.444014741660139e-15, -8.629144915808990e-17,  1.085566396927127e-18, -1.291900652149387e-20,  5.139960874597128e-02,
 -4.016599475040898e-03,  1.743095724529685e-04, -5.488367900864813e-06,  1.392782089430802e-07, -3.011346671016707e-09,  5.739033752292406e-11, -9.862950417573184e-13,
  1.553497847631760e-14, -2.269865064719446e-16,  3.105438134645100e-18, -4.007039522547539e-20,  4.956085672651214e-02, -4.453637401641755e-03,  2.190630145366636e-04,
 -7.737328379575260e-06,  2.185144582435309e-07, -5.224287497084001e-09,  1.095114723963326e-10, -2.060663907670097e-12,  3.539756866102562e-14, -5.620957171463168e-16,
  8.331584180752428e-18, -1.161428587041249e-19,  4.768203529380636e-02, -4.873194365433229e-03,  2.694574372278918e-04, -1.060441582616240e-05,  3.313655445967890e-07,
 -8.715430041733011e-09,  2.000091454285617e-10, -4.103094191974346e-12,  7.656012126325563e-14, -1.316296121760120e-15,  2.106293961796051e-17, -3.161362926247798e-19,
  4.577731404652313e-02, -5.269040364960560e-03,  3.250482071984829e-04, -1.416404198226176e-05,  4.870449235954229e-07, -1.402399972264368e-08,  3.507849405476586e-10,
 -7.813512880506727e-12,  1.577656597788033e-13, -2.926353400886805e-15,  5.038164060562586e-17, -8.115583034790625e-19,  4.385976159257750e-02, -5.635737235581458e-03,
  3.851955939571577e-04, -1.847602953942548e-05,  6.955302594560772e-07, -2.182413162560420e-08,  5.924992371903821e-10, -1.427415529042709e-11,  3.107550818487878e-13,
 -6.197494992237642e-15,  1.144303293147724e-16, -1.972178841911430e-18,  4.194121901602880e-02, -5.968688018481630e-03,  4.490839022985183e-04, -2.358028558288365e-05,
  9.670962318126064e-07, -3.292346889674860e-08,  9.662670356231622e-10, -2.508450185320824e-11,  5.867720201635756e-13, -1.254104718458947e-14,  2.475688226077870e-16,
 -4.551765578278662e-18,  4.003221872150193e-02, -6.264156375213391e-03,  5.157473287587904e-04, -2.949212491341178e-05,  1.311719285241881e-06, -4.824814409258577e-08,
  1.524929251956190e-09, -4.250696387560948e-11,  1.064817883093640e-12, -2.431333857031683e-14,  5.116268275425082e-16, -1.000657917593980e-17,  3.814194542768607e-02,
 -6.519259061911811e-03,  5.841007923664465e-04, -3.619856751358165e-05,  1.738383216740779e-06, -6.881175514938606e-08,  2.333551743380271e-09, -6.960626380360704e-11,
  1.861338363243865e-12, -4.526764359140399e-14,  1.012508463951783e-15, -2.100835576137736e-17,  3.627823484176505e-02, -6.731935240948219e-03,  6.529739044169258e-04,
 -4.365586286020078e-05,  2.254326642651131e-06, -9.566722816597621e-08,  3.468788821815564e-09, -1.103582299849657e-10,  3.140540344614795e-12, -8.111369031406125e-14,
  1.923110067941363e-15, -4.221919486858494e-17,  3.444760470752987e-02, -6.900896865808762e-03,  7.211462804044887e-04, -5.178840639035621e-05,  2.864282265463095e-06,
 -1.298421017326812e-07,  5.016782332708409e-09, -1.696978311085505e-10,  5.123962315850035e-12, -1.401517453198493e-13,  3.512713692748696e-15, -8.138554650330453e-17,
  3.265531246409113e-02, -7.025564548743341e-03,  7.873825393091457e-04, -6.048911897645736e-05,  3.569762514108664e-06, -1.722596069817679e-07,  7.069358199143018e-09,
 -2.534733065798842e-10,  8.097335499158237e-12, -2.339114341941241e-13,  6.181583820897787e-15, -1.507721953813968e-16,  3.090543364036979e-02, -7.105993247147534e-03,
  8.504655560690325e-04, -6.962126717544680e-05,  4.368446095857875e-06, -2.236497496294735e-07,  9.718428359973035e-09, -3.682747114157700e-10,  1.241229772531423e-11,
 -3.776831868262628e-13,  1.049740268541278e-14, -2.688857948044126e-16,  2.920095528872231e-02, -7.142791830642896e-03,  9.092268053277163e-04, -7.902161756202348e-05,
  5.253715328418482e-06, -2.844562091207534e-07,  1.304869708013785e-08, -5.211121742972608e-10,  1.848030040816682e-11, -5.907897898869858e-13,  1.722759023913779e-14,
 -4.623273734880431e-16,  2.754387916675382e-02, -7.137040167925335e-03,  9.625729322244669e-04, -8.850474821530672e-05,  6.214385344340823e-06, -3.547460569922586e-07,
  1.712898818861258e-08, -7.189320252114803e-10,  2.675621993228091e-11, -8.964171298582526e-13,  2.735885942283667e-14, -7.674705606556246e-16,  2.593532994505691e-02,
 -7.090206852043572e-03,  1.009507985644499e-03, -9.786828801063892e-05,  7.234654277496158e-06, -4.341299063813807e-07,  2.200272912496378e-08, -9.679771013826768e-10,
  3.770985181674468e-11, -1.320818372519981e-12,  4.209317943823891e-14, -1.231507198610050e-15,  2.437566438861948e-02, -7.004070112368313e-03,  1.049151031651404e-03,
 -1.068988213811341e-04,  8.294289497079807e-06, -5.217000442369657e-07,  2.767832085114084e-08, -1.273019391679314e-09,  5.178466479903052e-11, -1.891735156708738e-12,
  6.280844543216202e-14, -1.912269904905435e-15,  2.286457817586913e-02, -6.880643882139802e-03,  1.080749115333434e-03, -1.153781824455039e-04,  9.369050091566565e-06,
 -6.159933466628249e-07,  3.412026249997420e-08, -1.636516233436902e-09,  6.934486563856235e-11, -2.635949664459511e-12,  9.097338465005304e-14, -2.876179467229925e-15,
  2.140120773559323e-02, -6.722110435135623e-03,  1.103685748565967e-03, -1.230898661467919e-04,  1.043133133040690e-05, -7.149843881031859e-07,  4.124196339460397e-08,
 -2.057762419223877e-09,  9.061381438870981e-11, -3.575992833556225e-12,  1.280101773866717e-13, -4.193724750589127e-15,  1.998422516219024e-02, -6.530760498113165e-03,
  1.117485264471647e-03, -1.298253025285120e-04,  1.145100380315232e-05, -8.161122429981519e-07,  4.890114787372650e-08, -2.532126500675270e-09,  1.156088807906597e-10,
 -4.726178087101401e-12,  1.751051262911934e-13, -5.932105374116356e-15,  1.861192488794370e-02, -6.308941303369113e-03,  1.121813495937559e-03, -1.353897700628959e-04,
  1.239640918301077e-05, -9.163422088554965e-07,  5.689863527730256e-08, -3.050467292935498e-09,  1.440796274383504e-10, -6.088289309848423e-12,  2.329770487635586e-13,
 -8.145068598008538e-15,  1.728230133083218e-02, -6.059012676659031e-03,  1.116475307919643e-03, -1.396077613757098e-04,  1.323546663992741e-05, -1.012261245908673e-06,
  6.498106442567912e-08, -3.598823878609889e-09,  1.754574083520446e-10, -7.647401379755281e-12,  3.016237722700582e-13, -1.086052790819966e-14,  1.599311718964705e-02,
 -5.783310962191456e-03,  1.101409546220522e-03, -1.423276562267849e-04,  1.393683910946901e-05, -1.100203531842506e-06,  7.284784521391450e-08, -4.158458263901119e-09,
  2.088247845127976e-10, -9.368422230477030e-12,  3.800774210680472e-13, -1.406719081051053e-14,  1.474196242351100e-02, -5.484120365901057e-03,  1.076681965182201e-03,
 -1.434255990195392e-04,  1.447110691706902e-05, -1.176400359611875e-06,  8.016228428903930e-08, -4.706304657481048e-09,  2.429123772230964e-10, -1.119398892678912e-11,
  4.662069323890043e-13, -1.770203249352866e-14,  1.352630423407700e-02, -5.163651144637632e-03,  1.042476670151935e-03, -1.428085187860148e-04,  1.481189744966014e-05,
 -1.237146822969327e-06,  8.656647763972794e-08, -5.215844997605047e-09,  2.761288431256174e-10, -1.304430490938820e-11,  5.566092536084461e-13, -2.164088754350129e-14,
  1.234352857319362e-02, -4.824023973963861e-03,  9.990865645376674e-04, -1.404162665205761e-04,  1.493692327800978e-05, -1.278976458878859e-06,  9.169922313876499e-08,
 -5.658390019987308e-09,  3.066266661488030e-10, -1.481936158888771e-11,  6.466272331911647e-13, -2.569455096100485e-14,  1.119097383641129e-02, -4.467259781491937e-03,
  9.469032321983645e-04, -1.362228765615011e-04,  1.482888687467951e-05, -1.298834323242491e-06,  9.521591239489691e-08, -6.004702966394865e-09,  3.324026951540866e-10,
 -1.640375057270980e-11,  7.305215357101006e-13, -2.961247411973722e-14,  1.006595748440216e-02, -4.095274326469677e-03,  8.864066194903957e-04, -1.302369847052343e-04,
  1.447621730523543e-05, -1.294238893556705e-06,  9.680914121163232e-08, -6.226863581306511e-09,  3.514282279162535e-10, -1.767396546413993e-11,  8.018064591279160e-13,
 -3.309537120702267e-14,  8.965796371882721e-03, -3.709876830616775e-03,  8.181548122960884e-04, -1.225014556838390e-04,  1.387361245482883e-05, -1.263423702133131e-06,
  9.622865225760238e-08, -6.300237853034879e-09,  3.617994607434765e-10, -1.850775176793748e-11,  8.537371712777816e-13, -3.581686948665625e-14,  7.887821569688619e-03,
 -3.312772012468694e-03,  7.427741357315308e-04, -1.130922868001953e-04,  1.302236899075652e-05, -1.205450651358677e-06,  9.329920448514984e-08, -6.205397928350778e-09,
  3.618958214447199e-10, -1.879473751184590e-11,  8.799117011177339e-13, -3.745289290388342e-14,  6.829388457022186e-03, -2.905564943450375e-03,  6.609497414548231e-04,
 -1.021168635634376e-04,  1.193049093272770e-05, -1.120288464267987e-06,  8.793505442219143e-08, -5.929829583811812e-09,  3.505315640252843e-10, -1.844731639744630e-11,
  8.749289001301627e-13, -3.771599517041072e-14,  5.787882871682271e-03, -2.489768233709421e-03,  5.734167941323161e-04, -8.971164829803474e-05,  1.061257610555500e-05,
 -1.008851578697474e-06,  8.014992883454783e-08, -5.469272984678790e-09,  3.270853886505632e-10, -1.741060523207634e-11,  8.350275532802357e-13, -3.639063109738532e-14,
  4.760724249777398e-03, -2.066811211428986e-03,  4.809523369778579e-04, -7.603938661038018e-05,  9.089487838587168e-06, -8.729969056413944e-07,  7.006165356839333e-08,
 -4.828566111587826e-09,  2.915939503695905e-10, -1.567029093420125e-11,  7.586252922288282e-13, -3.336463973377115e-14,  3.745367506011679e-03, -1.638051214800975e-03,
  3.843679634536838e-04, -6.128592936722206e-05,  7.387827988796195e-06, -7.154782310688695e-07,  5.789096721471091e-08, -4.021898013387843e-09,  2.447979460088796e-10,
 -1.325733483727898e-11,  6.466811392581124e-13, -2.865221180781136e-14,  2.739310498753930e-03, -1.204789458955724e-03,  2.845039267994957e-04, -4.565685159765207e-05,
  5.539244076485067e-06, -5.398612629761514e-07,  4.395452459004958e-08, -3.072431983028477e-09,  1.881340395277616e-10, -1.024881818449458e-11,  5.028233638371591e-13,
 -2.240443913279532e-14,  1.740160446537413e-03, -7.683146180664972e-04,  1.822301946509583e-04, -2.937483825897610e-05,  3.579705366990583e-06, -3.504139020467109e-07,
  2.865327822482124e-08, -2.011366449255072e-09,  1.236744758779873e-10, -6.764809130599461e-12,  3.332204540918966e-13, -1.490545932681349e-14,  7.467826809556218e-04,
 -3.304267863099125e-04,  7.856211175763420e-05, -1.269532480664329e-05,  1.550906719453537e-06, -1.521864908314451e-07,  1.247407817147700e-08, -8.777003280589822e-10,
  5.409249360337495e-11, -2.965480779606781e-12,  1.463978446408722e-13, -6.562812912952647e-15,  6.405711419501005e-02, -1.712664641849048e-04,  4.776063341946096e-07,
 -1.376849330953470e-09,  4.063863446173987e-12, -1.217800846187494e-14,  3.680991516719009e-17, -1.117159630949744e-19,  3.393881986980325e-22, -1.030103904064653e-24,
  3.120076392077105e-27, -9.424791551712159e-30,  6.360329141027839e-02, -2.324017934199507e-04,  9.900761192606112e-07, -4.298216340730556e-09,  1.828418022157453e-11,
 -7.579385009575441e-14,  3.068998382609648e-16, -1.217930592855266e-18,  4.750689908410093e-21, -1.825470347881273e-23,  6.922081858245316e-26, -2.593822697739749e-28,
  6.270694551929340e-02, -3.518518730910125e-04,  2.168067785011061e-06, -1.250347928686034e-08,  6.780546043229135e-11, -3.506894446028561e-13,  1.746842228609072e-15,
 -8.435334903632665e-18,  3.967258373419309e-20, -1.823621758684550e-22,  8.215172154028691e-25, -3.634742047404184e-27,  6.139014898503230e-02, -5.241573450414582e-04,
  4.297628358117151e-06, -3.122730100834135e-08,  2.084950174636394e-10, -1.307253518512822e-12,  7.798472820160392e-15, -4.465321124759492e-17,  2.469584476261441e-19,
 -1.325488847194230e-21,  6.929485846422259e-24, -3.538784096059590e-26,  5.968473092024814e-02, -7.415676917155061e-04,  7.760252490322255e-06, -6.943779154625242e-08,
  5.597619030728524e-10, -4.176238344967354e-12,  2.931148016057717e-14, -1.956732463189441e-16,  1.252203583097392e-18, -7.727013135004060e-21,  4.618532996904425e-23,
 -2.683450745587584e-25,  5.763084329533195e-02, -9.945245434904006e-04,  1.298260290074201e-05, -1.407693183461025e-07,  1.349783583950168e-09, -1.181702254682157e-11,
  9.631640985958834e-14, -7.404563336911965e-16,  5.419114210603960e-18, -3.801699764758168e-20,  2.570098121272148e-22, -1.681307227722019e-24,  5.527520803411548e-02,
 -1.272239775005913e-03,  2.037975943465394e-05, -2.641873820013930e-07,  2.976662923778244e-09, -3.024237306860777e-11,  2.833195100508967e-13, -2.484143064418653e-15,
  2.060154915579940e-17, -1.628725579909890e-19,  1.234908322360616e-21, -9.022025183467844e-24,  5.266916117200943e-02, -1.563321204376179e-03,  3.029887697646672e-05,
 -4.640633499544400e-07,  6.080991092927509e-09, -7.103371796114271e-11,  7.583494674991622e-13, -7.522873537920606e-15,  7.016215238379963e-17, -6.205903873711128e-19,
  5.240730720816803e-21, -4.247453358460813e-23,  4.986661732568093e-02, -1.856397377229888e-03,  4.296981735740700e-05, -7.694270164861634e-07,  1.162016706107171e-08,
 -1.548078103445342e-10,  1.869479580176172e-12, -2.083758092331776e-14,  2.171362467531734e-16, -2.135494246550573e-18,  1.996694794070380e-20, -1.785011780532733e-22,
  4.692207425643324e-02, -2.140696375521241e-03,  5.846816619315863e-05, -1.212309030986201e-06,  2.093004909599595e-08, -3.157193733155409e-10,  4.284386884255277e-12,
 -5.332981703536205e-14,  6.173401601444082e-16, -6.714104130607414e-18,  6.914634574151888e-20, -6.784586315258291e-22,  4.388876445893350e-02, -2.406541095486831e-03,
  7.669426891866903e-05, -1.825253346612309e-06,  3.575674505476517e-08, -6.067086125195664e-10,  9.196660905966366e-12, -1.271349032303184e-13,  1.626444499335821e-15,
 -1.946585668501574e-17,  2.197846176973930e-19, -2.356328427624521e-21,  4.081704053866161e-02, -2.645733817564171e-03,  9.736981446694360e-05, -2.638238239127365e-06,
  5.824189339937275e-08, -1.104866807898003e-09,  1.860509807188673e-11, -2.841940206718167e-13,  3.998981183168621e-15, -5.243375725340986e-17,  6.462943521284993e-19,
 -7.540266892278035e-21,  3.775305628866227e-02, -2.851814741368423e-03,  1.200513758371353e-04, -3.675362820652405e-06,  9.084918373324098e-08, -1.915970901485358e-09,
  3.565810945639163e-11, -5.990197831811210e-13,  9.230495549209441e-15, -1.320428079660094e-16,  1.769793336106450e-18, -2.238547285122835e-20,  3.473777866029797e-02,
 -3.020191061075297e-03,  1.441584697727085e-04, -4.951713473248130e-06,  1.362276843665162e-07, -3.177021157408073e-09,  6.503539377408876e-11, -1.196222596423255e-12,
  2.010277253496314e-14, -3.125293139722443e-16,  4.538287615468488e-18, -6.201568533275166e-20,  3.180633989564311e-02, -3.148143862398788e-03,  1.690123367321093e-04,
 -6.470813331128748e-06,  1.970174625364434e-07, -5.055590473797288e-09,  1.133161707095434e-10, -2.272586560495686e-12,  4.148927671712613e-14, -6.984389100768024e-16,
  1.095015140615442e-17, -1.611249583053205e-19,  2.898771614696018e-02, -3.234728694054602e-03,  1.938808851756977e-04, -8.222983273643635e-06,  2.756131030158346e-07,
 -7.745012597197906e-09,  1.892625187844437e-10, -4.122291165533769e-12,  8.145586875095125e-14, -1.479673556341778e-15,  2.496443997889745e-17, -3.943109785187357e-19,
  2.630470050748536e-02, -3.280591551518110e-03,  2.180251080798224e-04, -1.018482125000252e-05,  3.739090410484344e-07, -1.145489914595330e-08,  3.039337213877470e-10,
 -7.162395970849214e-12,  1.526444509944935e-13, -2.982206188144541e-15,  5.397551605151483e-17, -9.124134972605530e-19,  2.377412536195610e-02, -3.287725049756793e-03,
  2.407426934536031e-04, -1.231986120379481e-05,  4.930554710198220e-07, -1.639712268699528e-08,  4.705484684450539e-10, -1.195420687975894e-11,  2.738533346526334e-13,
 -5.736010007562005e-15,  1.110369493423982e-16, -2.003074809232397e-18,  2.140728149871049e-02, -3.259189940715523e-03,  2.614053799520155e-04, -1.458032807599782e-05,
  6.332540348003383e-07, -2.276812684711242e-08,  7.040295587049249e-10, -1.921499528235584e-11,  4.716344213462159e-13, -1.055862994853752e-14,  2.179757240769984e-16,
 -4.184810055949273e-18,  1.921047910114958e-02, -3.198825295986061e-03,  2.794876860792747e-04, -1.690978298317657e-05,  7.936184788957584e-07, -3.072909099597163e-08,
  1.020200194429099e-09, -2.981413959350981e-11,  7.816292477827195e-13, -1.864812820752415e-14,  4.094177950636315e-16, -8.342884247355414e-18,  1.718569773633709e-02,
 -3.110967225012533e-03,  2.945857968509081e-04, -1.924636794887932e-05,  9.721177804490256e-07, -4.038595802156512e-08,  1.434647954028730e-09, -4.474841424363880e-11,
  1.249286434763074e-12, -3.167331198827627e-14,  7.375351307651460e-16, -1.591087625296785e-17,  1.533127772704240e-02, -3.000191584803370e-03,  3.064264769142346e-04,
 -2.152631975713275e-05,  1.165609274673169e-06, -5.177153478512545e-08,  1.961324674442462e-09, -6.509299091984134e-11,  1.929568001321612e-12, -5.184319306027148e-14,
  1.277028626462218e-15, -2.909284616777291e-17,  1.364261270258617e-02, -2.871091371764454e-03,  3.148667838913147e-04, -2.368742694563235e-05,  1.369958750779343e-06,
 -6.483175551992163e-08,  2.610998592093633e-09, -9.192761783436041e-11,  2.885283773383450e-12, -8.193298249458815e-14,  2.129516413521973e-15, -5.110721340431317e-17,
  1.211281160741401e-02, -2.728094883134300e-03,  3.198860150520060e-04, -2.567214560017866e-05,  1.580234939812206e-06, -7.941777856744707e-08,  3.389710211963659e-09,
 -1.262410274827935e-10,  4.183803798087678e-12, -1.252422216048335e-13,  3.426170727225505e-15, -8.641591160369275e-17,  1.073330709500884e-02, -2.575326672381085e-03,
  3.215717131147752e-04, -2.743015728157239e-05,  1.790958571299705e-06, -9.528493923705170e-08,  4.297398708626899e-09, -1.688203214636728e-10,  5.892084760663773e-12,
 -1.854633037917490e-13,  5.327230242192702e-15, -1.408839967124797e-16,  9.494395348501845e-03, -2.416510032653520e-03,  3.201016982935662e-04, -2.892023335778303e-05,
  1.996381982690487e-06, -1.120988140358675e-07,  5.326858020200436e-09, -2.201352437383716e-10,  8.070187056316001e-12, -2.664464060707813e-13,  8.017005949075398e-15,
 -2.218001938213997e-16,  8.385699472778575e-03, -2.254907323674944e-03,  3.157240247494891e-04, -3.011135213013168e-05,  2.190774315331418e-06, -1.294478835701433e-07,
  6.463152144021542e-09, -2.802292914451877e-10,  1.076371880675198e-11, -3.718594773603044e-13,  1.169327455913790e-14, -3.376833722964778e-16,  7.396554431616166e-03,
 -2.093292899180230e-03,  3.087365356599878e-04, -3.098308862192781e-05,  2.368689308036242e-06, -1.468616215554301e-07,  7.683572234761500e-09, -3.486301193274915e-10,
  1.399587788341175e-11, -5.047580457416485e-13,  1.655054490615422e-14, -4.978088006882659e-16,  6.516315971260144e-03, -1.933952603865776e-03,  2.994673711752296e-04,
 -3.152535510769589e-05,  2.525196924243169e-06, -1.638323655474634e-07,  8.958161345413600e-09, -4.242905304825514e-10,  1.775992967255363e-11, -6.670968454248495e-13,
  2.275755480699067e-14, -7.114145003783350e-16,  5.734599128527327e-03, -1.778703652900381e-03,  2.882574221106545e-04, -3.173761012984846e-05,  2.656065650628597e-06,
 -1.798390831341815e-07,  1.025077453303870e-08, -5.055686608545590e-10,  2.201302328909753e-11, -8.592306831637979e-13,  3.043040216704747e-14, -9.865919672718091e-16,
  5.041453908447645e-03, -1.628929025499069e-03,  2.754453640668299e-04, -3.162767460448397e-05,  2.757888390869873e-06, -1.943711382401875e-07,  1.152059056175062e-08,
 -5.902521543121796e-10,  2.667219519755485e-11, -1.079462618795546e-12,  3.960376987648027e-14, -1.328922624823578e-15,  4.427486726691942e-03, -1.485621141014580e-03,
  2.613555842086329e-04, -3.121029767520578e-05,  2.828150667489375e-06, -2.069503556256546e-07,  1.272395276120995e-08, -6.756267474869545e-10,  3.161323958595449e-11,
 -1.323701088376378e-12,  5.020357422326575e-14, -1.739983181387251e-15,  3.883936457346304e-03, -1.349430402509538e-03,  2.462890460795918e-04, -3.050560569255534e-05,
  2.865244754930736e-06, -2.171500247440215e-07,  1.381639434505317e-08, -7.585853485678876e-10,  3.667286116130789e-11, -1.585282814230729e-12,  6.202486470085079e-14,
 -2.215898294352528e-15,  3.402713613142312e-03, -1.220715075313162e-03,  2.305169353480454e-04, -2.953754916360515e-05,  2.868437048544011e-06, -2.246099134782881e-07,
  1.475469848484649e-08, -8.357699556599825e-10,  4.165420438301554e-11, -1.855005349812783e-12,  7.471879095009760e-14, -2.746155550507352e-15,  2.976410497662547e-03,
 -1.099589831605668e-03,  2.142767912547979e-04, -2.833243877514190e-05,  2.837798301375711e-06, -2.290468152133937e-07,  1.549885402642919e-08, -9.037360320031818e-10,
  4.633551686491314e-11, -2.121393367410615e-12,  8.779187112322620e-14, -3.312905527383496e-15,  2.598289261788245e-03, -9.859710791432928e-04,  1.977707485910558e-04,
 -2.691763617382253e-05,  2.774107393061295e-06, -2.302605758013205e-07,  1.601379047653980e-08, -9.591274641299511e-10,  5.048139663322275e-11, -2.371198844062638e-12,
  1.006196806385123e-13, -3.890942576146283e-15,  2.262253791158237e-03, -8.796178694641872e-04,  1.811654835081659e-04, -2.532044083670374e-05,  2.678739222583254e-06,
 -2.281359012583676e-07,  1.627080634756845e-08, -9.988500067835266e-10,  5.385582877208206e-11, -2.590110263732366e-12,  1.124755573012516e-13, -4.448499769011380e-15,
  1.962810337140098e-03, -7.801677342643685e-04,  1.645934621007557e-04, -2.356719296762809e-05,  2.553546401811773e-06, -2.226405097568504e-07,  1.624863852373685e-08,
 -1.020232027856838e-09,  5.623606049940059e-11, -2.763623021088520e-12,  1.225731838319856e-13, -4.948900301035633e-15,  1.695020841929172e-03, -6.871672283351871e-04,
  1.481551223942357e-04, -2.168259497104382e-05,  2.400742953779797e-06, -2.138203551486938e-07,  1.593415288630452e-08, -1.021163149762643e-09,  5.742630483798961e-11,
 -2.878005139258820e-12,  1.301201938823341e-13, -5.352999163469108e-15,  1.454452036612235e-03, -6.000972732994267e-04,  1.319216681766974e-04, -1.968924105832761e-05,
  2.222796455112806e-06, -2.017927188193183e-07,  1.532266481826024e-08, -1.000203719905017e-09,  5.727029849965403e-11, -2.921281155400941e-12,  1.343784826942716e-13,
 -5.622238385329975e-15,  1.237122628964443e-03, -5.183936137815760e-04,  1.159382088912836e-04, -1.760733578971637e-05,  2.022333229624442e-06, -1.867379557447024e-07,
  1.441792034354271e-08, -9.566606051318015e-10,  5.566185549123147e-11, -2.884153549404510e-12,  1.347258817921028e-13, -5.722042921541374e-15,  1.039450252238998e-03,
 -4.414628347243211e-04,  1.002270374156225e-04, -1.545457737090401e-05,  1.802059469093716e-06, -1.688906077829408e-07,  1.323178362699465e-08, -8.906273052417035e-10,
  5.255273357581585e-11, -2.760785362886633e-12,  1.307134085964775e-13, -5.625217076644018e-15,  8.581993174756404e-04, -3.686944647569161e-04,  8.479089300973400e-05,
 -1.324617968408034e-05,  1.564699644463551e-06, -1.485304830066120e-07,  1.178368447795949e-08, -8.029886021103493e-10,  4.795734274712441e-11, -2.549378802904094e-12,
  1.221124802378831e-13, -5.314973970572637e-15,  6.904305055367789e-04, -2.994697289375499e-04,  6.961610882919593e-05, -1.099500783920669e-05,  1.312952363766719e-06,
 -1.259741659743738e-07,  1.009988140487577e-08, -6.953917822137438e-10,  4.195405157459240e-11, -2.252501200726246e-12,  1.089472639240437e-13, -4.787248290069267e-15,
  5.334524132821211e-04, -2.331675622042694e-04,  5.467559857303868e-05, -8.711806019285688e-06,  1.049463100900812e-06, -1.015673013734281e-07,  8.212594184098743e-09,
 -5.701879214221147e-10,  3.468307473681840e-11, -1.877130151756172e-12,  9.150864537129876e-14, -4.052005061382361e-15,  3.847763141436516e-04, -1.691687843194820e-04,
  3.993174689921771e-05, -6.405511367873541e-06,  7.768139786645113e-07, -7.567799634562102e-08,  6.159064672992813e-09, -4.303484008714629e-10,  2.634117512215505e-11,
 -1.434414056478961e-12,  7.034808588819275e-14, -3.133361911982352e-15,  2.420812262178475e-04, -1.068621498188276e-04,  2.533997397862124e-05, -4.083760496064087e-06,
  4.975436891378039e-07, -4.869287305655771e-08,  3.980703318373550e-09, -2.793698559159072e-10,  1.717405129499187e-11, -9.391913129541172e-13,  4.625274597280891e-14,
 -2.068522998683087e-15,  1.033303587244154e-04, -4.571528016799430e-05,  1.086788100578194e-05, -1.755980625622589e-06,  2.144892852301567e-07, -2.104458298429542e-08,
  1.724715384943874e-09, -1.213390346286359e-10,  7.477168395414860e-12, -4.098658774527997e-13,  2.023151654996545e-14, -9.068420742607326e-16,  6.337958693557373e-02,
 -1.675106151122875e-04,  4.614663882597519e-07, -1.313729038926464e-09,  3.828890484926485e-12, -1.133091325759656e-14,  3.382850633739421e-17, -1.014255813666036e-19,
  3.044545101038291e-22, -9.132090036412191e-25,  2.733854684393109e-27, -8.163029394017309e-30,  6.268920566250570e-02, -2.246826382161328e-04,  9.402040459235539e-07,
 -4.017407569043165e-09,  1.683928318623224e-11, -6.882088881905813e-14,  2.748309807853859e-16, -1.075910376877100e-18,  4.140728094390571e-21, -1.570117288995303e-23,
  5.876167742346680e-26, -2.173474755054536e-28,  6.133330219974723e-02, -3.350895733686327e-04,  2.024311068026323e-06, -1.147250214778263e-08,  6.119249879680309e-11,
 -3.114618944371971e-13,  1.527482692784252e-15, -7.264810667159484e-18,  3.366244086934903e-20, -1.524885642634444e-22,  6.771200029413498e-25, -2.953632485395355e-27,
  5.935998590679780e-02, -4.912204409840012e-04,  3.942085297081365e-06, -2.809078166223051e-08,  1.841247418762368e-10, -1.134242899272247e-12,  6.652011210767581e-15,
 -3.746342924172371e-17,  2.038764508201402e-19, -1.077103760901297e-21,  5.544348089242726e-24, -2.788598296558215e-26,  5.683755380237947e-02, -6.826725390334437e-04,
  6.978098728159823e-06, -6.111336157903467e-08,  4.828504596055465e-10, -3.534225896587929e-12,  2.435421220065396e-14, -1.597188116261400e-16,  1.004623571284475e-18,
 -6.095742958996288e-21,  3.583965378532586e-23, -2.048979891042326e-25,  5.385026392202894e-02, -8.970706859311849e-04,  1.141553946421812e-05, -1.209446201364593e-07,
  1.134975869764122e-09, -9.735823605222749e-12,  7.781899771549593e-14, -5.870945045813389e-16,  4.219008892519389e-18, -2.907676925033190e-20,  1.931916918399710e-22,
 -1.242564456902987e-24,  5.049333216349722e-02, -1.121116721872057e-03,  1.747644573059693e-05, -2.210524812417762e-07,  2.434541301822861e-09, -2.420797692089015e-11,
  2.221752552945947e-13, -1.909900319815360e-15,  1.553923942330889e-17, -1.205903892269401e-19,  8.979288778842866e-22, -6.445214063192292e-24,  4.686759000115000e-02,
 -1.341653084199337e-03,  2.527002768959747e-05, -3.772113037774571e-07,  4.826487309711605e-09, -5.512659234254301e-11,  5.760515952634518e-13, -5.598079317243986e-15,
  5.118329372340149e-17, -4.440812043938884e-19,  3.680519907698317e-21, -2.928924283538599e-23,  4.307423916553619e-02, -1.546631049860645e-03,  3.475744282086469e-05,
 -6.060208980236945e-07,  8.929201635606309e-09, -1.162224447873339e-10,  1.372763035534330e-12, -1.497927818671168e-14,  1.529228542930833e-16, -1.474402247225207e-18,
  1.352234662871802e-20, -1.186376523516654e-22,  3.921009119709357e-02, -1.725894869091424e-03,  4.573816857903691e-05, -9.228267265276610e-07,  1.553361669516292e-08,
 -2.287862099747383e-10,  3.034875994079279e-12, -3.696185730744347e-14,  4.189705323092591e-16, -4.464969102473291e-18,  4.508483765947013e-20, -4.339575670366522e-22,
  3.536359517126098e-02, -1.871723159356016e-03,  5.785922601055551e-05, -1.339338606541585e-06,  2.556928251350214e-08, -4.234163745934926e-10,  6.271196840243796e-12,
 -8.478835463323531e-14,  1.061736953761616e-15, -1.244700754899465e-17,  1.377440687684008e-19, -1.448232033076670e-21,  3.161185027609043e-02, -1.979103165569922e-03,
  7.064474158274905e-05, -1.861351660116270e-06,  4.003316180578178e-08, -7.409539571659101e-10,  1.218757173151717e-11, -1.820234730689883e-13,  2.506403062924774e-15,
 -3.218226810262114e-17,  3.887034947159978e-19, -4.446393924971734e-21,  2.801868695548047e-02, -2.045746407273816e-03,  8.354037280347817e-05, -2.486987026114692e-06,
  5.988463264057119e-08, -1.232017071748073e-09,  2.239347593114178e-11, -3.677586186097652e-13,  5.544591678121710e-15, -7.766068377738461e-17,  1.019844802382062e-18,
 -1.264617648502676e-20,  2.463379533043615e-02, -2.071881366092430e-03,  9.596540586200182e-05, -3.205789797889972e-06,  8.591845795384829e-08, -1.954674894877316e-09,
  3.907770400072674e-11, -7.026426868305318e-13,  1.155273479143270e-14, -1.758513597599812e-16,  2.501833091498659e-18, -3.351496640701851e-20,  2.149279360098847e-02,
 -2.059877340660911e-03,  1.073649997658992e-04, -3.998870386123423e-06,  1.186340649998976e-07, -2.970088213359034e-09,  6.502178784480774e-11, -1.274872946235919e-12,
  2.277299578358769e-14, -3.753774480291067e-16,  5.766336687470056e-18, -8.318467719186024e-20,  1.861806875039997e-02, -2.013762346460495e-03,  1.172559572232788e-04,
 -4.840091127202917e-06,  1.581225128645642e-07, -4.336344141848431e-09,  1.035220046864328e-10, -2.204810911570603e-12,  4.263541427082624e-14, -7.584767087225062e-16,
  1.254030691868569e-17, -1.942202820641873e-19,  1.602018919956686e-02, -1.938697564883490e-03,  1.252611966510370e-04, -5.698124646624952e-06,  2.039910921111130e-07,
 -6.101135064919633e-09,  1.582014338527705e-10, -3.646581356505753e-12,  7.607560480873839e-14, -1.455943736423331e-15,  2.582991877270228e-17, -4.282462507539543e-19,
  1.369968221142231e-02, -1.840463191619136e-03,  1.311303309663615e-04, -6.539079623669178e-06,  2.553398637016043e-07, -8.294268769947876e-09,  2.327115781823694e-10,
 -5.785023933214863e-12,  1.297782472624207e-13, -2.663728422603415e-15,  5.056077204609279e-17, -8.948722554043854e-19,  1.164898308632547e-02, -1.724998124355214e-03,
  1.347459834123382e-04, -7.329324297248059e-06,  3.107959268089265e-07, -1.092115616074838e-08,  3.303452335211910e-10, -8.826795478420102e-12,  2.122603926681225e-13,
 -4.658625339726324e-15,  9.434234344724944e-17, -1.777738672308252e-18,  9.854392235726983e-03, -1.598021415166825e-03,  1.361173356533745e-04, -8.038142495171045e-06,
  3.686017563554322e-07, -1.395835646411862e-08,  4.536035323574085e-10, -1.298526115990626e-11,  3.337081050721400e-13, -7.809313511523690e-15,  1.682704493974279e-16,
 -3.367120611378882e-18,  8.297913476833146e-03, -1.464749122711104e-03,  1.353636931682070e-04, -8.639920385491870e-06,  4.267455872787757e-07, -1.735197629667724e-08,
  6.037750842516473e-10, -1.845993466350020e-11,  5.055004634236033e-13, -1.257827778529595e-14,  2.876203943378272e-16, -6.096344266708464e-18,  6.958886421553700e-03,
 -1.329707857547966e-03,  1.326914973243670e-04, -9.115663915498771e-06,  4.831161188644540e-07, -2.101928030163366e-08,  7.805898400159399e-10, -2.541240083782982e-11,
  7.393967870261268e-13, -1.951024038706630e-14,  4.722308827669189e-16, -1.057651171650930e-17,  5.815362985269379e-03, -1.196636932925167e-03,  1.283682649353069e-04,
 -9.453762871897090e-06,  5.356615846670074e-07, -2.485337312860762e-08,  9.820031278049108e-10, -3.394160523583220e-11,  1.046420366115514e-12, -2.920389783774260e-14,
  7.463536273255718e-16, -1.762125336573982e-17,  4.845209701893445e-03, -1.068464954215153e-03,  1.226965293402286e-04, -9.650025704741018e-06,  5.825344635203939e-07,
 -2.873035811643462e-08,  1.204147533879511e-09, -4.406188416025079e-11,  1.435533935524033e-12, -4.226598905638267e-14,  1.137763121236502e-15, -2.825124734464684e-17,
  4.026942091314740e-03, -9.473437111356828e-04,  1.159901639868140e-04, -9.707093834929353e-06,  6.222070869022648e-07, -3.251805121501776e-08,  1.441465662180265e-09,
 -5.568699839031336e-11,  1.912254928723955e-12, -5.924971191529035e-14,  1.675994528909787e-15, -4.366795563721742e-17,  3.340314436643593e-03, -8.347218367945875e-04,
  1.085546597736372e-04, -9.633396966066083e-06,  6.535490091059169e-07, -3.608517740680008e-08,  1.687010403219907e-09, -6.862272580857781e-11,  2.477389498781093e-12,
 -8.058269893721232e-14,  2.389701492955000e-15, -6.518812279011623e-17,  2.766698565514443e-03, -7.314421585451382e-04,  1.006721409202412e-04, -9.441831144164079e-06,
  6.758630357566522e-07, -3.931000736588119e-08,  1.932876290766937e-09, -8.256940140897819e-11,  3.126065199638478e-12, -1.064924727396712e-13,  3.303281913754024e-15,
 -9.413528227990178e-17,  2.289289726904255e-03, -6.378492638744363e-04,  9.259123712924121e-05, -9.148333728863574e-06,  6.888822099429988e-07, -4.208757419622685e-08,
  2.170709765383980e-09, -9.713440256329944e-11,  3.847211612900346e-12, -1.369388934284743e-13,  4.433079035960255e-15, -1.316913771841941e-16,  1.893177791147194e-03,
 -5.538969049300484e-04,  8.452143291746430e-05, -8.770502044968572e-06,  6.927341258500426e-07, -4.433489024044220e-08,  2.392239726765832e-09, -1.118532313778263e-10,
  4.623581623358342e-12, -1.715631692433100e-13,  5.783593395607206e-15, -1.787195270931478e-16,  1.565319155744062e-03, -4.792479776699219e-04,  7.663119968093080e-05,
 -8.326364180109131e-06,  6.878813581301084e-07, -4.599390063061824e-08,  2.589772601074620e-09, -1.262167817941718e-10,  5.432334442441057e-12, -2.096614442679578e-13,
  7.344208227498449e-15, -2.355764113095463e-16,  1.294440134750509e-03, -4.133626067072030e-04,  6.904906547722719e-05, -7.833369236981552e-06,  6.750475907220129e-07,
 -4.703220781071680e-08,  2.756606514493277e-09, -1.397017541976267e-10,  6.246128329303316e-12, -2.501880667287809e-13,  9.086918531804029e-15, -3.019380482902581e-16,
  1.070897225518458e-03, -3.555721634785242e-04,  6.186675833791230e-05, -7.307626471368875e-06,  6.551384814764338e-07, -4.744183919717858e-08,  2.887334239655900e-09,
 -1.518010495944045e-10,  7.034609034285856e-12, -2.917899160803754e-13,  1.096546043665977e-14, -3.766646152622890e-16,  8.865141998073934e-04, -3.051387811183200e-04,
  5.514363174145130e-05, -6.763391980309573e-06,  6.291648215886778e-07, -4.723648696490522e-08,  2.978021265075777e-09, -1.620512959264098e-10,  7.766138677943243e-12,
 -3.328693008186328e-13,  1.291607788960540e-14, -4.577277158683395e-16,  7.344109267399337e-04, -2.613011261508938e-04,  4.891170782903759e-05, -6.212779613669539e-06,
  5.981735796292782e-07, -4.644772120807613e-08,  3.026260883257808e-09, -1.700553154052075e-10,  8.409593575374888e-12, -3.716695845116495e-13,  1.485996602136751e-14,
 -5.422173447275154e-16,  6.088344666922039e-04, -2.233079173284664e-04,  4.318082341234920e-05, -5.665659523273419e-06,  5.631903434541553e-07, -4.512067587004201e-08,
  3.031120631755526e-09, -1.754981818758400e-10,  8.936067845286888e-12, -4.063753519399521e-13,  1.670722869981637e-14, -6.264366777669221e-16,  5.049993850952347e-04,
 -1.904410414391615e-04,  3.794351244684755e-05, -5.129702062340510e-06,  5.251747760443025e-07, -4.330964961091318e-08,  2.993002721222873e-09, -1.781563882239813e-10,
  9.320347814089243e-12, -4.352178510256918e-13,  1.836201416161787e-14, -7.060822466721002e-16,  4.189414217471646e-04, -1.620302038153688e-04,  3.317939139845721e-05,
 -4.610524854199140e-06,  4.849891588526138e-07, -4.107397281258612e-08,  2.913445089431727e-09, -1.779004193862002e-10,  9.542063055438860e-12, -4.565766467714942e-13,
  1.972837152542904e-14, -7.764967463516313e-16,  3.473865459682677e-04, -1.374609574609783e-04,  2.885892297128695e-05, -4.111904882372203e-06,  4.433789826884530e-07,
 -3.847438744973481e-08,  2.794889942872668e-09, -1.746916225232612e-10,  9.586465510038413e-12, -4.690696944368240e-13,  2.071631507308020e-14, -8.329732283379708e-16,
  2.876359275280409e-04, -1.161777533201822e-04,  2.494651662595081e-05, -3.636023704822955e-06,  4.009638572225377e-07, -3.557008475842474e-08,  2.640444001551992e-09,
 -1.685746441715679e-10,  9.444831442498885e-12, -4.716260361781189e-13,  2.124759263406524e-14, -8.710838609015299e-16,  2.374663430992566e-04, -9.768340166008711e-05,
  2.140298253542129e-05, -3.183720990267498e-06,  3.582366902205810e-07, -3.241645749280356e-08,  2.453650204881934e-09, -1.596668666977322e-10,  9.114516766050879e-12,
 -4.635376528672334e-13,  2.126071897889829e-14, -8.870043061079083e-16,  1.950449070801812e-04, -8.153607050459390e-05,  1.818739255992849e-05, -2.754738531668986e-06,
  3.155690550567060e-07, -2.906355494659872e-08,  2.238285364949959e-09, -1.481462541752755e-10,  8.598721495745395e-12, -4.444892920878004e-13,  2.071493780796628e-14,
 -8.778059947267505e-16,  1.588566652817757e-04, -6.734469699473437e-05,  1.525842185222251e-05, -2.347943100012610e-06,  2.732208325491530e-07, -2.555518145835797e-08,
  1.998192978826227e-09, -1.342388581315010e-10,  7.906032926678656e-12, -4.145670576458454e-13,  1.959289718815538e-14, -8.416926077823482e-16,  1.276434378539716e-04,
 -5.476346593278556e-05,  1.257525230936631e-05, -1.961521661260844e-06,  2.313525015195958e-07, -2.192855145589895e-08,  1.737155704974377e-09, -1.182069885868218e-10,
  7.049820471080388e-12, -3.742480087165974e-13,  1.790194495276779e-14, -7.781630386577129e-16,  1.003522797621515e-04, -4.348582368083736e-05,  1.009811846739942e-05,
 -1.593146545655170e-06,  1.900388005147946e-07, -1.821440333920410e-08,  1.458808220893716e-09, -1.003387750554582e-10,  6.047550065186738e-12, -3.243739181146966e-13,
  1.567405874987059e-14, -6.880900697610661e-16,  7.609200260048468e-05, -3.323835037153876e-05,  7.788571971287974e-06, -1.240111376219161e-06,  1.492828640399449e-07,
 -1.443747864435962e-08,  1.166588588434458e-09, -8.093957547564761e-11,  4.920075950563263e-12, -2.661127460873029e-13,  1.296451321380972e-14, -5.737111630617285e-16,
  5.409640158371208e-05, -2.377473697096117e-05,  5.609542221101298e-06, -8.994422554684449e-07,  1.090304614545158e-07, -1.061730184760251e-08,  8.637259602718450e-10,
 -6.032554540665674e-11,  3.690960018172367e-12, -2.009116656447886e-13,  9.849464286167555e-15, -4.385350598345411e-16,  3.369383853870830e-05, -1.487041595145610e-05,
  3.525354735557781e-06, -5.680051408884881e-07,  6.918609320850355e-08, -6.769391057439416e-09,  5.532762017667088e-10, -3.882050678840284e-11,  2.385917663086920e-12,
 -1.304485889723598e-13,  6.422839130634162e-15, -2.871811523163229e-16,  1.430146875763160e-05, -6.326525505992579e-06,  1.503809771511987e-06, -2.429463970806791e-07,
  2.967145958276467e-08, -2.910827649651066e-09,  2.385266691634024e-10, -1.677891786721046e-11,  1.033820385410978e-12, -5.666238382118976e-14,  2.796580368203276e-15,
 -1.253363721463545e-16,  6.271682954187184e-02, -1.638809184829738e-04,  4.460618751766115e-07, -1.254236571063288e-09,  3.610166591511056e-12, -1.055203683277226e-14,
  3.112018989348172e-17, -9.218862260306791e-20,  2.734638304980599e-22, -8.107079254190705e-25,  2.399071364289069e-27, -7.081752017358046e-30,  6.180521938264065e-02,
 -2.173493634561953e-04,  8.935674380279641e-07, -3.758641980496193e-09,  1.552645990372705e-11, -6.257198481023836e-14,  2.464786907846018e-16, -9.520153679014621e-19,
  3.615588021915324e-21, -1.353124917168105e-23,  4.998790936489785e-26, -1.825348765409138e-28,  6.002448386284075e-02, -3.194295813837790e-04,  1.892316225535384e-06,
 -1.054133126694000e-08,  5.531398838367729e-11, -2.771264543995346e-13,  1.338359346846482e-15, -6.270462483031033e-18,  2.863061881669137e-20, -1.278333624464315e-22,
  5.596177506359604e-25, -2.407059711579135e-27,  5.745611110798048e-02, -4.609837036090673e-04,  3.621950446594585e-06, -2.531793426621466e-08,  1.629550629150920e-10,
 -9.864794810406314e-13,  5.688834366538858e-15, -3.151928092511518e-17,  1.688137421185061e-19, -8.780459649504935e-22,  4.450987269845348e-24, -2.205210794392660e-26,
  5.421404719341354e-02, -6.296550282256640e-04,  6.288858313682930e-06, -5.392293014539979e-08,  4.176666589612236e-10, -2.999950901884780e-12,  2.030104170170140e-14,
 -1.308220371537886e-16,  8.089474590707142e-19, -4.827419571629400e-21,  2.792407771111586e-23, -1.571144857784114e-25,  5.043585513667392e-02, -8.112571643919176e-04,
  1.006705013315868e-05, -1.042465885752900e-07,  9.576793532575698e-10, -8.051091896442232e-12,  6.312314874434021e-14, -4.674437197953593e-16,  3.299104294668542e-18,
 -2.234111756961763e-20,  1.459154292488716e-22, -9.228804238761515e-25,  4.627257703587379e-02, -9.912884800840063e-04,  1.504244577002293e-05, -1.857006005600193e-07,
  1.999646406297227e-09, -1.946508396290650e-11,  1.750533761807057e-13, -1.475691747399386e-15,  1.178151829030920e-17, -8.976477563654429e-20,  6.565396994809415e-22,
 -4.630870944176850e-24,  4.187837878610810e-02, -1.156365364518862e-03,  2.117274652183604e-05, -3.081067339288625e-07,  3.850408738814567e-09, -4.301104506572113e-11,
  4.400209800744524e-13, -4.189933823009221e-15,  3.756253180213146e-17, -3.197463709085640e-19,  2.601318098690447e-21, -2.032977157003529e-23,  3.740098619917674e-02,
 -1.295397465272194e-03,  2.827112014664294e-05, -4.800924275580201e-07,  6.902905388359724e-09, -8.780175066922330e-11,  1.014562255525671e-12, -1.084003299957988e-14,
  1.084407320265597e-16, -1.025164877888263e-18,  9.224215068609763e-21, -7.943550480330744e-23,  3.297372439058446e-02, -1.400383745679510e-03,  3.601639572567229e-05,
 -7.072635818805153e-07,  1.160967521782431e-08, -1.669903177278507e-10,  2.165759056400391e-12, -2.581278526579657e-14,  2.865608241528682e-16, -2.992932751550085e-18,
  2.963538367550355e-20, -2.798708335895051e-22,  2.870969284751654e-02, -1.466776967099847e-03,  4.398679848096336e-05, -9.905421305583108e-07,  1.843195618456810e-08,
 -2.979361894251743e-10,  4.312333503666571e-12, -5.703220121049263e-14,  6.991578404555460e-16, -8.029756075988264e-18,  8.710782771010787e-20, -8.982747883164888e-22,
  2.469829892729178e-02, -1.493432075007988e-03,  5.170978568637864e-05, -1.325063644447540e-06,  2.776892983990210e-08, -5.015209666220283e-10,  8.058976266313399e-12,
 -1.177000444624231e-13,  1.586158511948641e-15, -1.994672923928943e-17,  2.361070824895465e-19, -2.648393652118369e-21,  2.100408242190081e-02, -1.482209154230279e-03,
  5.871814718664996e-05, -1.699925414828706e-06,  3.987824856914810e-08, -8.004179193801107e-10,  1.421030841749334e-11, -2.281652063129313e-13,  3.366076650026768e-15,
 -4.616801404255312e-17,  5.940749529793568e-19, -7.222510895198569e-21,  1.766753175009011e-02, -1.437336646682960e-03,  6.460246034641336e-05, -2.098891369636481e-06,
  5.480339308939209e-08, -1.216347558391433e-09,  2.375023264921987e-11, -4.174919681753318e-13,  6.716392906312451e-15, -1.001045761063032e-16,  1.395429079458653e-18,
 -1.832685169207572e-20,  1.470744051493373e-02, -1.364653074756781e-03,  6.905190370458543e-05, -2.501951900494291e-06,  7.232398564982398e-08, -1.766631536198134e-09,
  3.777628849943946e-11, -7.241402473842718e-13,  1.265699270866857e-14, -2.042918021812618e-16,  3.074961066690778e-18, -4.349103623469131e-20,  1.212428669641710e-02,
 -1.270837913954016e-03,  7.187859795417304e-05, -2.887461538857672e-06,  9.194149731267236e-08, -2.460605206569353e-09,  5.738710309765514e-11, -1.195136095270822e-12,
  2.261691564278418e-14, -3.940359125663982e-16,  6.384319948113005e-18, -9.695570345701805e-20,  9.904126323959466e-03, -1.162720050729242e-03,  7.302417374053705e-05,
 -3.234477229338540e-06,  1.129057749106926e-07, -3.296582191394445e-09,  8.353249137533323e-11, -1.883259904156475e-12,  3.845850467970351e-14, -7.209774025434233e-16,
  1.253741842437798e-17, -2.038654352554131e-19,  8.022560234934546e-03, -1.046722373539483e-03,  7.255037694312373e-05, -3.524910930396428e-06,  1.342794197871533e-07,
 -4.260030315303522e-09,  1.168471465663047e-10, -2.842123228879458e-12,  6.243229170575348e-14, -1.255642691910655e-15,  2.336847347560605e-17, -4.057616250565595e-19,
  6.448433581964143e-03, -9.284700978440207e-04,  7.061768838256535e-05, -3.745182548985937e-06,  1.550295300269583e-07, -5.323416406109730e-09,  1.574966568465657e-10,
 -4.119483805545236e-12,  9.704298704972296e-14, -2.087841661130327e-15,  4.147200075715592e-17, -7.669585164164543e-19,  5.147041043301175e-03, -8.125635320679768e-04,
  6.745695199900691e-05, -3.887184156921572e-06,  1.741315022120349e-07, -6.447858464194404e-09,  2.050660662491717e-10, -5.749643005747971e-12,  1.448219711567449e-13,
 -3.323807061191458e-15,  7.028147369554775e-17, -1.380834998226823e-18,  4.082718383201401e-03, -7.024961908214399e-04,  6.333895632825375e-05, -3.948507922830852e-06,
  1.906683877120812e-07, -7.586371779347425e-09,  2.585154486503153e-10, -7.746136562484690e-12,  2.080221465844351e-13, -5.079342182879432e-15,  1.140377778548786e-16,
 -2.374505691436257e-18,  3.220791166419015e-03, -6.006874394786623e-04,  5.854607482009271e-05, -3.932015491665710e-06,  2.039115670456256e-07, -8.688199941846300e-09,
  3.162152158455522e-10, -1.009604801741959e-11,  2.882719593434805e-13, -7.468931764162535e-15,  1.776047453533395e-16, -3.909936376818235e-18,  2.528918143127159e-03,
 -5.085945698967892e-04,  5.334879789151754e-05, -3.844913694797951e-06,  2.133732546775781e-07, -9.703549285794625e-09,  3.760590948684087e-10, -1.275709185479861e-11,
  3.862409601083762e-13, -1.059165262334364e-14,  2.661090523728730e-16, -6.179547869161922e-18,  1.977909246992276e-03, -4.268707111802698e-04,  4.798862230127271e-05,
 -3.697541976899102e-06,  2.188271609100566e-07, -1.058802397262565e-08,  4.356385798124671e-10, -1.565816276312960e-11,  5.013745584980645e-13, -1.451558286210399e-14,
  3.844136064855043e-16, -9.394857900472985e-18,  1.542119006864655e-03, -3.555402286546357e-04,  4.266755788907789e-05, -3.502074256152675e-06,  2.202991277085617e-07,
 -1.130617519458851e-08,  4.924524653397807e-10, -1.870343719400010e-11,  6.317484107508381e-13, -1.926301420861858e-14,  5.364709576629918e-16, -1.376775899436192e-17,
  1.199520137945077e-03, -2.941703060300375e-04,  3.754361627398715e-05, -3.271303491911118e-06,  2.180336975135176e-07, -1.183378742391690e-08,  5.441207687309333e-10,
 -2.177949130194137e-11,  7.740744048235488e-13, -2.479893463690853e-14,  7.246371221884659e-16, -1.948546719925056e-17,  9.315544227721226e-04, -2.420246785239669e-04,
  3.273110693819501e-05, -3.017625565004067e-06,  2.124448694046636e-07, -1.215876908919070e-08,  5.885742299847977e-10, -2.476440744031340e-11,  9.238647480853283e-13,
 -3.102489445247030e-14,  9.490472339990681e-16, -2.668169614897009e-17,  7.228436115282617e-04, -1.981919393145296e-04,  2.830435266001931e-05, -2.752283821469945e-06,
  2.040597538945902e-07, -1.228073994614633e-08,  6.241974313349505e-10, -2.753757676916345e-11,  1.075734180715480e-12, -3.777956309251604e-14,  1.207156127201583e-15,
 -3.540783471475540e-17,  5.608259312237988e-04, -1.616859260360505e-04,  2.430347339209447e-05, -2.484886976264785e-06,  1.934628330662645e-07, -1.220957405898791e-08,
  6.499132578101107e-10, -2.998889999838792e-11,  1.223798683213640e-12, -4.484620761559386e-14,  1.493527681006516e-15, -4.560849536090205e-17,  4.353667309649541e-04,
 -1.315192558562535e-04,  2.074108527155302e-05, -2.223176813720120e-06,  1.812466251101312e-07, -1.196324810398001e-08,  6.652065688660403e-10, -3.202630980714245e-11,
  1.362116395160486e-12, -5.196621976983256e-14,  1.799920303628975e-15, -5.710556013511240e-17,  3.383765615148367e-04, -1.067532357216912e-04,  1.760903583690558e-05,
 -1.972999993040687e-06,  1.679723093808538e-07, -1.156536160282695e-08,  6.700935944023221e-10, -3.358091003877272e-11,  1.485114440595361e-12, -5.885692003235736e-14,
  2.115670296955687e-15, -6.959379408056680e-17,  2.634574565067060e-04, -8.652839447493661e-05,  1.488458261202569e-05, -1.738429018673474e-06,  1.541417480847378e-07,
 -1.104265443034863e-08,  6.650494811388575e-10, -3.460945345160864e-11,  1.587953009999828e-12, -6.523133873061454e-14,  2.428329873377475e-15, -8.264943609554640e-17,
  2.055885665799768e-04, -7.008008035232373e-05,  1.253567738499086e-05, -1.521978119056580e-06,  1.401806368132496e-07, -1.042276976947377e-08,  6.509092027494668e-10,
 -3.509427448927146e-11,  1.666792515510837e-12, -7.081757973367994e-14,  2.724481276777297e-15, -9.575126713098908e-17,  1.608554000171495e-04, -5.674323838075638e-05,
  1.052522089493548e-05, -1.324866895639900e-06,  1.264313553734637e-07, -9.732419880519886e-09,  6.287570083684110e-10, -3.504109452263173e-11,  1.718947167791615e-12,
 -7.537567343084040e-14,  2.990628772708067e-15, -1.083118856844201e-16,  1.262223291978911e-04, -4.594987219368510e-05,  8.814296414201178e-06, -1.147294925232248e-06,
  1.131534672314041e-07, -8.996025519496390e-09,  5.998174550485338e-10, -3.447529504350313e-11,  1.742925313846865e-12, -7.871040989966960e-14,  3.214068155527197e-15,
 -1.197156193574198e-16,  9.934523942702419e-05, -3.722198353854344e-05,  7.364480526368327e-06, -9.887015029915466e-07,  1.005296403614288e-07, -8.234829136127346e-09,
  5.653577477209412e-10, -3.343731009939572e-11,  1.738370605401213e-12, -8.067936195533191e-14,  3.383646941633835e-15, -1.293588639439598e-16,  7.841974747769523e-05,
 -3.016208787039225e-05,  6.139375382120732e-06, -8.479947316592769e-07,  8.867490637939635e-08, -7.466432315313918e-09,  5.266074310929887e-10, -3.197774514025344e-11,
  1.705927053420536e-12, -8.119601677435902e-14,  3.490352885076559e-15, -1.366887033806038e-16,  6.205988700825356e-05, -2.444279227022015e-05,  5.105520691736741e-06,
 -7.237423072200551e-07,  7.764750844706448e-08, -6.704679429912143e-09,  4.846980799170054e-10, -3.015271865622155e-11,  1.647054994357009e-12, -8.022852263491681e-14,
  3.527697952156258e-15, -1.412363179369132e-16,  4.920221537937458e-05, -1.979642109669752e-05,  4.232836785752958e-06, -6.143223396589050e-07,  6.746000166292532e-08,
 -5.959798992750362e-09,  4.406229077694710e-10, -2.801978017484047e-11,  1.563824607847449e-12, -7.779495988467966e-14,  3.491893772394195e-15, -1.426427332777752e-16,
  3.903069337976954e-05, -1.600528898575765e-05,  3.494731363183021e-06, -5.180364986204697e-07,  5.808968255497404e-08, -5.238717018297067e-09,  3.952143190226282e-10,
 -2.563461268270174e-11,  1.458710082951973e-12, -7.395624573994896e-14,  3.381838515419406e-15, -1.406756643291250e-16,  3.091825167789329e-05, -1.289293937814860e-05,
  2.867978788833359e-06, -4.331900242343938e-07,  4.948778751210691e-08, -4.545467907505162e-09,  3.491363458944501e-10, -2.304859992583570e-11,  1.334402188557204e-12,
 -6.880780159404858e-14,  3.198951626648034e-15, -1.352373497557531e-16,  2.438157063402101e-05, -1.031647230827973e-05,  2.332456491003572e-06, -3.581441088725003e-07,
  4.158719001922560e-08, -3.881643682397129e-09,  3.028885136404745e-10, -2.030724061230774e-11,  1.193651092006715e-12, -6.247099277018199e-14,  2.946901204851552e-15,
 -1.263641961943866e-16,  1.904619346232299e-05, -8.159958721792082e-06,  1.870800798597315e-06, -2.913462407534299e-07,  3.430853880282500e-08, -3.246838612295760e-09,
  2.568177845564097e-10, -1.744932566627623e-11,  1.039145722502664e-12, -5.508514624371276e-14,  2.631269785332648e-15, -1.142196692986206e-16,  1.461962862285859e-05,
 -6.328862468219035e-06,  1.468025747238574e-06, -2.313436524333597e-07,  2.756492110392657e-08, -2.639061346029636e-09,  2.111356677983121e-10, -1.450675929056412e-11,
  8.734313881433708e-13, -4.680071168445533e-14,  2.259199604781614e-15, -9.908216509943644e-17,  1.087056004454730e-05, -4.745350889678710e-06,  1.111133483999803e-06,
 -1.767843238971558e-07,  2.126522327858099e-08, -2.055099758029165e-09,  1.659382131061141e-10, -1.150489564094775e-11,  6.988640788086998e-13, -3.777389950083913e-14,
  1.839050349069131e-15, -8.132961800661189e-17,  7.612678824081907e-06, -3.344362817053432e-06,  7.887347149286014e-07, -1.264093983054960e-07,  1.531642935338085e-08,
 -1.490836382317617e-09,  1.212274708756701e-10, -8.463284571052247e-12,  5.175986044352953e-13, -2.816296982984399e-14,  1.380094720624430e-15, -6.142250352015873e-17,
  4.692078821251294e-06, -2.070353145869430e-06,  4.907020161118356e-07, -7.904216658322749e-08,  9.625364955021975e-09, -9.415446683044983e-10,  7.693565876689978e-11,
 -5.396880842113695e-12,  3.316153808328823e-13, -1.812666239247157e-14,  8.922907948268032e-16, -3.988762228514619e-17,  1.979955875387638e-06, -8.757698453690881e-07,
  2.081422676178850e-07, -3.362165096202977e-08,  4.105712490844750e-09, -4.027239688945212e-10,  3.299664594919183e-11, -2.320808256621320e-12,  1.429761176979540e-13,
 -7.835324789036703e-15,  3.866641300907402e-16, -1.732722256198381e-17,  6.206834890144795e-02, -1.603716606513909e-04,  4.313507770680850e-07, -1.198122510948936e-09,
  3.406390615053616e-12, -9.835165127310354e-15,  2.865716130482153e-17, -8.388681927600735e-20,  2.459331814102039e-22, -7.206935357097089e-25,  2.108405990441102e-27,
 -6.153533228497317e-30,  6.094983919037682e-02, -2.103771086352514e-04,  8.499139938188766e-07, -3.519917564995893e-09,  1.433208162957210e-11, -5.696373611408928e-14,
  2.213714758070663e-16, -8.437398135635289e-19,  3.162600458877064e-21, -1.168346727007682e-23,  4.261154892983528e-26, -1.536352819512845e-28,  5.877626215487845e-02,
 -3.047824002580860e-04,  1.770952984247567e-06, -9.698960350106284e-09,  5.007896168102973e-11, -2.470132799168725e-13,  1.174950722880262e-15, -5.423793307629416e-18,
  2.440727279726696e-20, -1.074304539134629e-22,  4.637292946813798e-25, -1.967133051752061e-27,  5.566826399447121e-02, -4.331804898033692e-04,  3.333151080384119e-06,
 -2.286136118008124e-08,  1.445223429903199e-10, -8.599555283334994e-13,  4.877405490766975e-15, -2.659044517561746e-17,  1.401880560965309e-19, -7.179902581353493e-22,
  3.584927989319407e-24, -1.749874520518575e-26,  5.179210525229412e-02, -5.818232509432397e-04,  5.679981654607918e-06, -4.769497797022936e-08,  3.622576497710370e-10,
 -2.553910145381342e-12,  1.697576918835762e-14, -1.075135649222211e-16,  6.537045283370885e-19, -3.837346643334146e-21,  2.184247685172848e-23, -1.209708100754242e-25,
  4.734432880270082e-02, -7.354758349280067e-04,  8.902969537215615e-06, -9.013382561525304e-08,  8.108055493353914e-10, -6.681972618188754e-12,  5.139940683202428e-14,
 -3.736892778996397e-16,  2.590782371697325e-18, -1.724243185185046e-20,  1.107213100208335e-22, -6.887610755737591e-25,  4.253471964509042e-02, -8.793468095654017e-04,
  1.299386046773276e-05, -1.566057205535281e-07,  1.649218800154509e-09, -1.571984751410095e-11,  1.385602728499134e-13, -1.145692522864543e-15,  8.977385755106839e-18,
 -6.716795138656774e-20,  4.826422049252934e-22, -3.345896515596711e-24,  3.756966198915089e-02, -1.000787041887367e-03,  1.781847292286197e-05, -2.528457479532711e-07,
  3.086949419202820e-09, -3.373249230165144e-11,  3.379340244408494e-13, -3.153652680412648e-15,  2.772731356315683e-17, -2.316109291879137e-19,  1.849985712236881e-21,
 -1.420118969443529e-23,  3.263773223202227e-02, -1.090520698781175e-03,  2.311876039542942e-05, -3.824677876649810e-07,  5.367670708909039e-09, -6.673410063271117e-11,
  7.545452606321645e-13, -7.895531747879384e-15,  7.741179363683437e-17, -7.177050954359588e-19,  6.336624124721436e-21, -5.357120664764046e-23,  2.789884488456468e-02,
 -1.143280025613976e-03,  2.854206692715896e-05, -5.456313737975184e-07,  8.736068395040040e-09, -1.227409287869980e-10,  1.556684031466308e-12, -1.816008537991054e-14,
  1.974828453274417e-16, -2.021755666226276e-18,  1.963426818769266e-20, -1.819533757729787e-22,  2.347761630121545e-02, -1.157833960395248e-03,  3.368995707572542e-05,
 -7.381780001015799e-07,  1.339085759057020e-08, -2.113196943866094e-10,  2.989578390479689e-12, -3.868223617314633e-14,  4.643121120036382e-16, -5.224953232489960e-18,
  5.557092077529690e-20, -5.621435625030698e-22,  1.946096027116992e-02, -1.136502903316778e-03,  3.817504595401270e-05, -9.515204313814741e-07,  1.943276799814624e-08,
 -3.425207746900554e-10,  5.377806253204790e-12, -7.681558188859994e-14,  1.013268522630249e-15, -1.248146805764113e-17,  1.448081323391656e-19, -1.592951991329538e-21,
  1.589939052579993e-02, -1.084319716878357e-03,  4.167365481862337e-05, -1.173381383551888e-06,  2.681982497623251e-08, -5.252482412678025e-10,  9.109239989869994e-12,
 -1.430147704607010e-13,  2.064764034707665e-15, -2.773439916069150e-17,  3.497276262085570e-19, -4.169086260416601e-21,  1.281114708134228e-02, -1.008022958172381e-03,
  4.396452729912591e-05, -1.389259118735521e-06,  3.534229804391936e-08, -7.653133015484335e-10,  1.459617048872306e-11, -2.508581537336910e-13,  3.949006742464146e-15,
 -5.763627133226917e-17,  7.872690970973652e-19, -1.013757142511623e-20,  1.018810748255380e-02, -9.150558117463797e-04,  4.494814519635927e-05, -1.584318671873347e-06,
  4.462582770785301e-08, -1.063575259552620e-09,  2.221482761020534e-11, -4.163522934091145e-13,  7.121036836266200e-15, -1.125527030349869e-16,  1.660049456786890e-18,
 -2.302060900694996e-20,  8.002470060199121e-03, -8.127041787921496e-04,  4.464596674552552e-05, -1.745320025655632e-06,  5.416458346086634e-08, -1.414629642536490e-09,
  3.223141720730822e-11, -6.563723406004313e-13,  1.215592772806268e-14, -2.074086995349623e-16,  3.293251040275512e-18, -4.904128687016571e-20,  6.213355982503222e-03,
 -7.074541354426405e-04,  4.318292621855005e-05, -1.862214598955765e-06,  6.337897023160093e-08, -1.806424268506124e-09,  4.472875083810623e-11, -9.862980335258096e-13,
  1.971526088509922e-14, -3.620370677501159e-16,  6.170775012478154e-18, -9.840854464144944e-20,  4.772710604712851e-03, -6.045959136965261e-04,  4.075900908537913e-05,
 -1.929149609234978e-06,  7.168666361597040e-08, -2.220986541416783e-09,  5.955024261707860e-11, -1.417153636372892e-12,  3.048084835001092e-14, -6.006603929891244e-16,
  1.096003240095489e-17, -1.866916378162060e-19,  3.630136208875080e-03, -5.080584435079471e-04,  3.761644889248961e-05, -1.944774050857105e-06,  7.857320582985720e-08,
 -2.636187823992136e-09,  7.627613123270687e-11, -1.952771968077810e-12,  4.505957944995063e-14, -9.502258389155679e-16,  1.851214738538227e-17, -3.359656809344927e-19,
  2.736514652445227e-03, -4.204302931778394e-04,  3.400835371742704e-05, -1.911892824902329e-06,  8.364945844618275e-08, -3.028231793294168e-09,  9.424047395152683e-11,
 -2.587598356967092e-12,  6.387219821512027e-14, -1.437526573242599e-15,  2.982505321480202e-17, -5.752871062912493e-19,  2.046453966700775e-03, -3.431100825029686e-04,
  3.017290900084933e-05, -1.836629771799047e-06,  8.668716175169590e-08, -3.374401851165295e-09,  1.125885138677220e-10, -3.305683494340329e-12,  8.704593219159931e-14,
 -2.085347402925899e-15,  4.596206567255604e-17, -9.400227350751377e-19,  1.519708377573317e-03, -2.765294836718813e-04,  2.631532356909021e-05, -1.727317415961235e-06,
  8.762924563343122e-08, -3.655573718697257e-09,  1.303650742357942e-10, -4.081191982336065e-12,  1.143335603060723e-13, -2.908183772823896e-15,  6.792770665030982e-17,
 -1.469660075026766e-18,  1.121780110406566e-03, -2.204005649632379e-04,  2.259788088958427e-05, -1.593331669641688e-06,  8.657678514192423e-08, -3.858088192010532e-09,
  1.466182119391722e-10, -4.880435634982851e-12,  1.450783711858208e-13, -3.908302579932234e-15,  9.651384303566582e-17, -2.203983735781899e-18,  8.239249459756964e-04,
 -1.739521031785634e-04,  1.913712872404756e-05, -1.444047887648532e-06,  8.375837075359439e-08, -3.974747372180759e-09,  1.605000346573035e-10, -5.665117530320195e-12,
  1.782360353282020e-13, -5.072958573946614e-15,  1.321394185703667e-16, -3.177873432100023e-18,  6.027660685596406e-04, -1.361329996945566e-04,  1.600648843377901e-05,
 -1.288030886274214e-06,  7.948957534648288e-08, -4.004891596237688e-09,  1.713485564772478e-10, -6.396232585285114e-12,  2.124529270817376e-13, -6.373420605944970e-15,
  1.747128522473999e-16, -4.415371930566467e-18,  4.396859904332447e-04, -1.057726907985533e-04,  1.324233758686821e-05, -1.132505219296777e-06,  7.413018934260082e-08,
 -3.953683385831537e-09,  1.787397011257894e-10, -7.037970118480422e-12,  2.461890341849160e-13, -7.766131167271892e-15,  2.235453051277538e-16, -5.923970714160508e-18,
  3.201253233153044e-04, -8.169726313142068e-05,  1.085177655025978e-05, -9.830970543348104e-07,  6.804545610362578e-08, -3.830835743116183e-09,  1.825053108260939e-10,
 -7.561014841484509e-12,  2.778652535317597e-13, -9.195907210497331e-15,  2.773351958875074e-16, -7.690166410678039e-18,  2.328775581787344e-04, -6.280564797660729e-05,
  8.820667186129981e-06, -8.438023458475600e-07,  6.157535792965652e-08, -3.649063965816228e-09,  1.827194634680857e-10, -7.944813605044791e-12,  3.060114523684887e-13,
 -1.060069961067572e-14,  3.342314105700368e-16, -9.677203798481383e-18,  1.694352081271751e-04, -4.811316859183574e-05,  7.120984855660054e-06, -7.171184157312522e-07,
  5.501372710735531e-08, -3.422521021462041e-09,  1.796601787833730e-10, -8.178608309478702e-12,  3.293934866640446e-13, -1.191715871669738e-14,  3.919679293349986e-16,
 -1.182556428809463e-17,  1.234164552205816e-04, -3.677053879019152e-05,  5.716950544101773e-06, -6.042741626037127e-07,  4.859705167899469e-08, -3.165416370834876e-09,
  1.737560585359946e-10, -8.261268005439469e-12,  3.471033116899125e-13, -1.308615866239651e-14,  4.480497748432239e-16, -1.405626910294614e-17,  9.008282913649101e-05,
 -2.806589138352668e-05,  4.569750524917929e-06, -5.055027036870715e-07,  4.250154684074090e-08, -2.890940218830554e-09,  1.655276086841902e-10, -8.200135866655289e-12,
  3.586044344300558e-13, -1.405751566336458e-14,  4.999621823303738e-16, -1.627656572186384e-17,  6.594642457894704e-05, -2.141618410270389e-05,  3.640887128692591e-06,
 -4.203140484646260e-07,  3.684640196355226e-08, -2.610539440730256e-09,  1.555314777976982e-10, -8.009212928394087e-12,  3.637331282140531e-13, -1.479335286522755e-14,
  5.453730641566800e-16, -1.838717221988716e-17,  4.845830357331784e-05, -1.635285634583985e-05,  2.894342224385449e-06, -3.477402117668980e-07,  3.170098560247654e-08,
 -2.333530985093295e-09,  1.443133758132869e-10, -7.707027549386500e-12,  3.626623750787631e-13, -1.526984871025699e-14,  5.823028417681351e-16, -2.029004697204355e-17,
  3.576656758347446e-05, -1.250519188333486e-05,  2.297794893377428e-06, -2.865382693847078e-07,  2.709402888545473e-08, -2.066999065859255e-09,  1.323727409568033e-10,
 -7.314502636923559e-12,  3.558394931562957e-13, -1.547738716644852e-14,  6.092438581307535e-16, -2.189565554069857e-17,  2.653185160535713e-05, -9.583638637043063e-06,
  1.823140499394426e-06, -2.353469103242247e-07,  2.302323950377153e-08, -1.815903590528136e-09,  1.201398455665738e-10, -6.853056004036274e-12,  3.439097015453283e-13,
 -1.541935223664776e-14,  6.252215287771089e-16, -2.312889369580373e-17,  1.978869415494501e-05, -7.364403462905342e-06,  1.446532016997539e-06, -1.927987737735636e-07,
  1.946428408524051e-08, -1.583324967421192e-09,  1.079642772465274e-10, -6.343077794054969e-12,  3.276369306216760e-13, -1.510994675169079e-14,  6.297988767325977e-16,
 -2.393312991444183e-17,  1.484266163686422e-05, -5.675970897772476e-06,  1.148123337033628e-06, -1.575946578507785e-07,  1.637852194689005e-08, -1.370779143812470e-09,
  9.611268325137741e-11, -5.802842738484685e-12,  3.078307786870732e-13, -1.457146267358179e-14,  6.230334625952352e-16, -2.427217359684862e-17,  1.119478447417463e-05,
 -4.387750904209648e-06,  9.116500863491831e-07, -1.285472348114357e-07,  1.371922863853059e-08, -1.178551080417095e-09,  8.477324903497465e-11, -5.247846608921360e-12,
  2.852854744634604e-13, -1.383140219305978e-14,  6.054001375635149e-16, -2.413028623111971e-17,  8.486515329382269e-06, -3.400791205570058e-06,  7.239431881849972e-07,
 -1.046019373532103e-07,  1.143629863307751e-08, -1.006010628040526e-09,  7.406443870500861e-11, -4.690510634979736e-12,  2.607337172256980e-13, -1.291977111728827e-14,
  5.776944815834195e-16, -2.351058395459295e-17,  6.459899993798993e-06, -2.640345605254594e-06,  5.744371750001359e-07, -8.484183155753544e-08,  9.479570773195025e-09,
 -8.518891499511805e-10,  6.404587677617487e-11, -4.140174189275425e-12,  2.348157872177394e-13, -1.186676538229936e-14,  5.409307843198617e-16, -2.243231079028140e-17,
  4.928899628645035e-06, -2.050029054830556e-06,  4.547099296658207e-07, -6.848204673034174e-08,  7.800996767042941e-09, -7.145067837446017e-10,  5.472973846325732e-11,
 -3.603290515104690e-12,  2.080625621011123e-13, -1.070097062448904e-14,  4.962458167093614e-16, -2.092749584409499e-17,  3.758811792512702e-06, -1.587281079044441e-06,
  3.580724547215917e-07, -5.485801341291234e-08,  6.355894429859050e-09, -5.919485400938114e-10,  4.609152175039697e-11, -3.083747148953663e-12,  1.808900594146526e-13,
 -9.448108940484867e-15,  4.448162904226529e-16, -1.903746491235629e-17,  2.851527586996716e-06, -1.219878552427019e-06,  2.792151896913826e-07, -4.341055521117461e-08,
  5.103513975322319e-09, -4.821927312855453e-10,  3.807952507942737e-11, -2.583246589759559e-12,  1.536027435644595e-13, -8.130303956855729e-15,  3.877945308318765e-16,
 -1.680958472481381e-17,  2.134965695738740e-06, -9.232714679392730e-07,  2.139098944134705e-07, -3.366987540453536e-08,  4.007113837844277e-09, -3.831980876497210e-10,
  3.062271496810918e-11, -2.101699374290854e-12,  1.264029247681045e-13, -6.765796617155514e-15,  3.262639883005736e-16, -1.429450392425539e-17,  1.555476101140224e-06,
 -6.785518210927360e-07,  1.587618995916926e-07, -2.523970026012786e-08,  3.033704229914615e-09, -2.929570635039797e-10,  2.363693397694781e-11, -1.637598243918344e-12,
  9.940397627055318e-14, -5.369027542463646e-15,  2.612140653341032e-16, -1.154404250522555e-17,  1.072340421187048e-06, -4.709012074766328e-07,  1.110056478064938e-07,
 -1.778229376250609e-08,  2.153581977636050e-09, -2.095231474026301e-10,  1.702960282538242e-11, -1.188358332196588e-12,  7.264574942255931e-14, -3.951007548176741e-15,
  1.935326461376300e-16, -8.609796853437699e-18,  6.537531602229891e-07, -2.884004552205952e-07,  6.833750533701910e-08, -1.100494004725205e-08,  1.339781368384086e-09,
 -1.310227498168946e-10,  1.070345592971876e-11, -7.506394924348358e-13,  4.611234469987418e-14, -2.519974192521771e-15,  1.240172540301790e-16, -5.542597343314602e-18,
  2.741926686763982e-07, -1.212659277843835e-07,  2.881709417508233e-08, -4.654237574536175e-09,  5.682736529150535e-10, -5.573349422732495e-11,  4.565821464879554e-12,
 -3.210918954463497e-13,  1.977858425111996e-14, -1.083754735010116e-15,  5.347501144785613e-17, -2.396016563994904e-18,  6.143367410261003e-02, -1.569774524876929e-04,
  4.172939481304006e-07, -1.145157301494601e-09,  3.216379272261447e-12, -9.174713336939577e-15,  2.641472108897709e-17, -7.641631489490130e-20,  2.214432488298739e-22,
 -6.415287401448316e-25,  1.855644966841973e-27, -5.355352793729318e-30,  6.012166725768082e-02, -2.037429391500965e-04,  8.090141804199380e-07, -3.299437619817658e-09,
  1.324407995487543e-11, -5.192325850559605e-14,  1.991026460800233e-16, -7.489500881915213e-19,  2.771114749858406e-21, -1.010680612519608e-23,  3.639654740391248e-26,
 -1.295888393122840e-28,  5.758474942814813e-02, -2.910670707593928e-04,  1.659214837236038e-06, -8.935737043467771e-09,  4.540882450462179e-11, -2.205520500617142e-13,
  1.033462131009329e-15, -4.701223132957924e-18,  2.085381409232317e-20, -9.050231828338793e-23,  3.852620087392232e-25, -1.612007529720670e-27,  5.398718881288520e-02,
 -4.075745834514343e-04,  3.072141252297764e-06, -2.068048075740990e-08,  1.284360245846591e-10, -7.513481959083870e-13,  4.191980438709386e-15, -2.249175226231110e-17,
  1.167462479795236e-19, -5.888790643437809e-22,  2.896582720340823e-24, -1.393214962002814e-26,  4.955220130073942e-02, -5.385779656072163e-04,  5.140802080576915e-06,
 -4.228632737336660e-08,  3.150214866233550e-10, -2.180374311858087e-12,  1.423862579496881e-14, -8.864659156237856e-17,  5.300834333909595e-19, -3.061473076824576e-21,
  1.715091790545669e-23, -9.351555415115426e-26,  4.453832129128049e-02, -6.683677012951424e-04,  7.894998641620930e-06, -7.816642365073383e-08,  6.887005167479325e-10,
 -5.565122580209644e-12,  4.200922881141899e-14, -2.999170496670421e-16,  2.042974319171823e-18, -1.336513926028816e-20,  8.439634586327777e-23, -5.164549178129016e-25,
  3.921393535239714e-02, -7.824871850556140e-04,  1.126309854940547e-05, -1.325630630774743e-07,  1.365636636100219e-09, -1.274899928329077e-11,  1.101642235833800e-13,
 -8.936489530013296e-16,  6.874062008779288e-18, -5.051471249061708e-20,  3.566732697978481e-22, -2.430645253891525e-24,  3.383351433321163e-02, -8.695847566316453e-04,
  1.505975718392520e-05, -2.084394028743689e-07,  2.486738496194819e-09, -2.658866344597106e-11,  2.608952653025973e-13, -2.386643361120291e-15,  2.058328301611449e-17,
 -1.687522364621562e-19,  1.323610146969009e-21, -9.981834732750450e-24,  2.861841712243300e-02, -9.225644600510493e-04,  1.900339213477059e-05, -3.063490041973968e-07,
  4.197523876635493e-09, -5.102022450553527e-11,  5.645904027325815e-13, -5.787100526680954e-15,  5.562037832763395e-17, -5.058131102335557e-19,  4.382828968411932e-21,
 -3.638224353403587e-23,  2.374405417114629e-02, -9.389317724970001e-04,  2.275827619733322e-05, -4.236237596511165e-07,  6.617090646433971e-09, -9.083039918168119e-11,
  1.126728474229951e-12, -1.286798040871704e-14,  1.370972995641304e-16, -1.376009764017342e-18,  1.310844297637252e-20, -1.192238070963043e-22,  1.933396666252379e-02,
 -9.204021256507580e-04,  2.598956232594462e-05, -5.541771523369822e-07,  9.802222969568411e-09, -1.510476749712827e-10,  2.089009598401167e-12, -2.644895637333695e-14,
  3.108995202747701e-16, -3.428503577001444e-18,  3.575561949069069e-20, -3.548567576900023e-22,  1.546026287515278e-02, -8.719682545265550e-04,  2.841714834652582e-05,
 -6.890571231248740e-07,  1.371611773048063e-08, -2.359778478678557e-10,  3.620605011937805e-12, -5.058655194243781e-14,  6.532444672383570e-16, -7.882986386706530e-18,
  8.965275934343124e-20, -9.673039287554349e-22,  1.214904894200151e-02, -8.006852484205565e-04,  2.985617426544408e-05, -8.176635618911487e-07,  1.821171661088615e-08,
 -3.480474870480126e-10,  5.897093687461209e-12, -9.053988510881507e-14,  1.279361921959229e-15, -1.683140245833266e-17,  2.080119567546103e-19, -2.431683503205750e-21,
  9.389084209736208e-03, -7.144285822437201e-04,  3.023686947379660e-05, -9.293529139429045e-07,  2.303655696018147e-08, -4.867336814089168e-10,  9.068118330093173e-12,
 -1.523885749175294e-13,  2.347578916135871e-15, -3.355474637926281e-17,  4.491477815170475e-19, -5.671053408200043e-21,  7.141866394590042e-03, -6.208261024343043e-04,
  2.960246516437191e-05, -1.015053551285534e-06,  2.786030790784117e-08, -6.478945952928627e-10,  1.321908776107870e-11, -2.422459113807973e-13,  4.054487397172072e-15,
 -6.275721158846030e-17,  9.070419852782312e-19, -1.233332718256544e-20,  5.351618413552639e-03, -5.264843045731214e-04,  2.808907028347693e-05, -1.068535707947460e-06,
  3.231977374889757e-08, -8.237458701633283e-10,  1.833575428380089e-11, -3.651274045758661e-13,  6.617781213648466e-15, -1.105851156033224e-16,  1.720769749097367e-18,
 -2.512737034306305e-20,  3.954081534198926e-03, -4.365466655612859e-04,  2.589455265090789e-05, -1.087098655709452e-06,  3.607138487275386e-08, -1.003568402044956e-09,
  2.428159749951175e-11, -5.236683491468773e-13,  1.024604362774428e-14, -1.842988664810641e-16,  3.078967582386848e-18, -4.815615010577459e-20,  2.883495039008545e-03,
 -3.545553724296428e-04,  2.324422917904865e-05, -1.071604713585792e-06,  3.883958465186703e-08, -1.175036674401211e-09,  3.079584300505085e-11, -7.169834789163661e-13,
  1.509875077659072e-14, -2.915199282272420e-16,  5.214964023694880e-18, -8.714035664670178e-20,  2.077566148123326e-03, -2.825465462320215e-04,  2.035996368667034e-05,
 -1.025947494026941e-06,  4.045131422862899e-08, -1.325891356547024e-09,  3.751507887983965e-11, -9.399814044223626e-13,  2.124378457465182e-14, -4.390797937464894e-16,
  8.389066575729245e-18, -1.493971020856662e-19,  1.480550568539936e-03, -2.212935018652601e-04,  1.743693089766947e-05, -9.561479729793314e-07,  4.085104640701351e-08,
 -1.445599008329498e-09,  4.401536464165488e-11, -1.183367461232287e-12,  2.862225956150766e-14, -6.316286947222965e-16,  1.285705291732513e-17, -2.434463651957996e-19,
  1.044757086176367e-03, -1.706173577337854e-04,  1.462971815400175e-05, -8.693093140789942e-07,  4.009591026439427e-08, -1.526665081791614e-09,  4.986648017134959e-11,
 -1.434409636619321e-12,  3.703025987376547e-14, -8.702743734885440e-16,  1.882772415071727e-17, -3.781761724276847e-19,  7.308709179493978e-04, -1.297014819284943e-04,
  1.204727687868974e-05, -7.726369716217427e-07,  3.833479285807113e-08, -1.565375984619440e-09,  5.468719190952670e-11, -1.678353365391688e-12,  4.612389039901132e-14,
 -1.151570493038927e-15,  2.641634646198930e-17, -5.616018693278415e-19,  5.074877457892849e-04, -9.736810883389542e-05,  9.754851487055976e-06, -6.726668990149743e-07,
  3.577787519085862e-08, -1.561898214391486e-09,  5.819079915293958e-11, -1.900212951704991e-12,  5.544872222677769e-14, -1.467133389615239e-15,  3.560352424833428e-17,
 -7.993799720809518e-19,  3.501955383286622e-04, -7.229616094052387e-05,  7.780445167567827e-06, -5.747682425354721e-07,  3.266358799273911e-08, -1.519808070332870e-09,
  6.021332520059917e-11, -2.086587645780764e-12,  6.448890561921206e-14, -1.804039644305511e-15,  4.620935545155167e-17, -1.093343068771172e-18,  2.404629974013179e-04,
 -5.317552292739693e-05,  6.123463891808135e-06, -4.829193694607773e-07,  2.922883569892643e-08, -1.445226673590795e-09,  6.072129658584702e-11, -2.227166599180689e-12,
  7.272672350952812e-14, -2.145981231150632e-15,  5.789023109645918e-17, -1.440369159036913e-18,  1.645128013309493e-04, -3.880362165275965e-05,  4.763658871128063e-06,
 -3.997098086517712e-07,  2.568625969379076e-08, -1.345775698331366e-09,  5.980063021645289e-11, -2.315684039880545e-12,  7.970142083960797e-14, -2.474982948394669e-15,
  7.016094443328644e-17, -1.831863403498090e-18,  1.122875031332129e-04, -2.813559914319930e-05,  3.669118874967165e-06, -3.264985963163097e-07,  2.221005102944422e-08,
 -1.229553954048803e-09,  5.763153774202911e-11, -2.350226456194866e-12,  8.505709432226195e-14, -2.773368538148628e-15,  8.243922907156630e-17, -2.254016456834723e-18,
  7.656164189805198e-05, -2.030086097339057e-05,  2.802666502940365e-06, -2.636577865206872e-07,  1.892994278706954e-08, -1.104282125458998e-09,  5.445597270010899e-11,
 -2.332933593168247e-12,  8.857266504572401e-14, -3.025626785953949e-15,  9.410506228079051e-17, -2.688842019467197e-18,  5.221600577643881e-05, -1.459777385116445e-05,
  2.126485335511067e-06, -2.108414436416033e-07,  1.593179659561927e-08, -9.766952949881514e-10,  5.054402785187876e-11, -2.269239830091936e-12,  9.017130541402164e-14,
 -3.219878003580029e-15,  1.045643316857734e-16, -3.115832936295150e-18,  3.566683246905798e-05, -1.047602979600655e-05,  1.605115339000536e-06, -1.672379979077051e-07,
  1.326267442559357e-08, -8.521997287216788e-10,  4.616431823306575e-11, -2.166854668480888e-12,  8.991087700122080e-14, -3.348750978914916e-15,  1.133063214474988e-16,
 -3.513954662190521e-18,  2.443064726627238e-05, -7.513601625623416e-06,  1.207115521037433e-06, -1.317817384760053e-07,  1.093831545838907e-08, -7.347637528248925e-10,
  4.156141634252767e-11, -2.034681337255486e-12,  8.795999238684778e-14, -3.409614058784373e-15,  1.199466613746198e-16, -3.863645575719839e-18,  1.680094952322222e-05,
 -5.392837122713482e-06,  9.057418921756836e-07, -1.033140174115305e-07,  8.951309558521190e-09, -6.269864106781682e-10,  3.694143853764467e-11, -1.881834489464099e-12,
  8.456579571053853e-14, -3.404225510204453e-15,  1.242510283453927e-16, -4.148520408699761e-18,  1.161312377542873e-05, -3.878335157163835e-06,  6.789664207391792e-07,
 -8.069507811660044e-08,  7.278772991700606e-09, -5.302799641633078e-10,  3.246531992288289e-11, -1.716860529292292e-12,  8.001952554688911e-14, -3.337952657301251e-15,
  1.261388918087498e-16, -4.356559411740494e-18,  8.076570834090146e-06, -2.797874043499059e-06,  5.091042861977758e-07, -6.287339408579284e-08,  5.888839137393909e-09,
 -4.451079257218290e-10,  2.824833361587328e-11, -1.547204864873313e-12,  7.462478943067670e-14, -3.218746743436665e-15,  1.256699869776617e-16, -4.480682389977196e-18,
  5.656647932976127e-06, -2.026765366840908e-06,  3.822477500435177e-07, -4.892188449182153e-08,  4.745690684519862e-09, -3.712331798628120e-10,  2.436399585001784e-11,
 -1.378921605180571e-12,  6.867178719130529e-14, -3.056055021754614e-15,  1.230183846922550e-16, -4.518722117139728e-18,  3.992685447722770e-06, -1.475482630285056e-06,
  2.876406847083763e-07, -3.805048575665243e-08,  3.813148325479295e-09, -3.079457908380340e-10,  2.085052366537285e-11, -1.216588727353605e-12,  6.241897027752357e-14,
 -2.859815980066214e-15,  1.184398440601195e-16, -4.472901663401020e-18,  2.841647620753992e-06, -1.080154222076666e-06,  2.170754840753759e-07, -2.960333587740892e-08,
  3.056999552077615e-09, -2.542538626759437e-10,  1.771830933410561e-11, -1.063375881602525e-12,  5.608216519482461e-14, -2.639633473571903e-15,  1.122377759755175e-16,
 -4.348972355757942e-18,  2.039741138784501e-06, -7.954201897195253e-07,  1.643555569032400e-07, -2.304705657489252e-08,  2.446324423205047e-09, -2.090315556498969e-10,
  1.495729030726196e-11, -9.212096393570341e-13,  4.983018999933430e-14, -2.404174663336901e-15,  1.047320072891876e-16, -4.155182664711247e-18,  1.476426086311868e-06,
 -5.891605251240939e-07,  1.248406554495813e-07, -1.795480699672683e-08,  1.954083374231830e-09, -1.711256093637821e-10,  1.254351087939434e-11, -7.909875569352724e-13,
  4.378547030737180e-14, -2.160794427703703e-15,  9.623305585981492e-17, -3.901231060576399e-18,  1.076908841909479e-06, -4.386597543161327e-07,  9.507637810520253e-08,
 -1.398920653247382e-08,  1.557202780529390e-09, -1.394258307081034e-10,  1.044452424109671e-11, -6.728034627044557e-13,  3.802803414862823e-14, -1.915359774557386e-15,
  8.702317401246919e-17, -3.597319701722935e-18,  7.903877968886226e-07, -3.278475501525645e-07,  7.250053947074300e-08, -1.088598981104913e-08,  1.236348055538725e-09,
 -1.129067059889699e-10,  8.623543383388632e-12, -5.661583999629810e-13,  3.260140921755194e-14, -1.672232100491310e-15,  7.734423218117430e-17, -3.253382699105072e-18,
  5.821755592138118e-07, -2.453302327754028e-07,  5.521528991912907e-08, -8.439367395978622e-09,  9.755253835948959e-10, -9.064738958491222e-11,  7.042416351159062e-12,
 -4.701424453273328e-13,  2.751923739438979e-14, -1.434360681924387e-15,  6.739170262662281e-17, -2.878522089486495e-18,  4.284202226597248e-07, -1.829947396227467e-07,
  4.181299879511311e-08, -6.489471971736722e-09,  7.616094931627386e-10, -7.183649848040494e-11,  5.663590823578199e-12, -3.835810904634284e-13,  2.277175989666801e-14,
 -1.203444177667617e-15,  5.731356635356016e-17, -2.480652345012768e-18,  3.125624657363031e-07, -1.350217644469842e-07,  3.124465149463471e-08, -4.911904663993371e-09,
  5.838594890769694e-10, -5.576691887189048e-11,  4.451265812289609e-12, -3.051457886665884e-13,  1.833164557477665e-14, -9.801248013253967e-16,  4.721284112435168e-17,
 -2.066332576249215e-18,  2.229480967913435e-07, -9.718814768790639e-08,  2.272097631963948e-08, -3.609194062285615e-09,  4.334582625795752e-10, -4.182454907112965e-11,
  3.371925098118517e-12, -2.334319306644347e-13,  1.415890102360547e-14, -7.641895251095947e-16,  3.715252783812226e-17, -1.640754410356557e-18,  1.512069484055737e-07,
 -6.637162272904045e-08,  1.563820118592389e-08, -2.503889191822109e-09,  3.030927932996431e-10, -2.947378759810989e-11,  2.394427475574203e-12, -1.670096481551502e-13,
  1.020481592404932e-14, -5.547630211942934e-16,  2.716204014414274e-17, -1.207852479068598e-18,  9.113908925112238e-08, -4.019630699510347e-08,  9.522148726835751e-09,
 -1.533016741218873e-09,  1.865850696004630e-10, -1.824209218419900e-11,  1.489836269272592e-12, -1.044562097471918e-13,  6.415200196687482e-15, -3.504944081170452e-16,
  1.724491018625906e-17, -7.705274389583280e-19,  3.798263152850063e-08, -1.679635529441597e-08,  3.990854729265111e-09, -6.444693075942415e-10,  7.867722704316915e-11,
 -7.715178560921449e-12,  6.319567769717312e-13, -4.443622754181551e-14,  2.736800375940759e-15, -1.499407649362425e-16,  7.397434312368942e-18, -3.314075990350696e-19,
  6.081235518085552e-02, -1.536932073232923e-04,  4.038548872339342e-07, -1.095129455821485e-09,  3.039055275986847e-12, -8.565656012636718e-15,  2.437089842166569e-17,
 -6.968577410736364e-20,  1.996294141127930e-22, -5.718058571074570e-25,  1.635504604247721e-27, -4.667851292857529e-30,  5.931939395446306e-02, -1.974256735939767e-04,
  7.706589132598452e-07, -3.095587385986271e-09,  1.225175119669523e-11, -4.738674829463272e-14,  1.793207454994335e-16, -6.658257338111085e-19,  2.432157710974817e-21,
 -8.758815934818860e-24,  3.114893784694250e-26, -1.095353243390009e-28,  5.644636647225793e-02, -2.782102429397700e-04,  1.556203921753444e-06, -8.243179981299912e-09,
  4.123552935838900e-11, -1.972560699665877e-13,  9.107010214610126e-16, -4.083189514679859e-18,  1.785684417598258e-20, -7.642138111287151e-23,  3.208771739019984e-25,
 -1.324518056141171e-27,  5.240452087978670e-02, -3.839562894785718e-04,  2.835826591380909e-06, -1.874046050258823e-08,  1.143662261266119e-10, -6.578945573971962e-13,
  3.611479427263865e-15, -1.907385081234481e-17,  9.749245334552436e-20, -4.844019455571724e-22,  2.347671593078915e-24, -1.112876286037519e-26,  4.747704525650775e-02,
 -4.993988044256035e-04,  4.662227086106700e-06, -3.757708699893863e-08,  2.746397107811839e-10, -1.866613060691838e-12,  1.197832927410514e-14, -7.332257162887326e-17,
  4.312880519679215e-19, -2.451154663688268e-21,  1.351734286291237e-23, -7.257394464066329e-26,  4.198548355631998e-02, -6.087804906955769e-04,  7.019613780023331e-06,
 -6.798558273707203e-08,  5.868364421483790e-10, -4.650708160731386e-12,  3.445887172136690e-14, -2.416306320778510e-16,  1.617490249832001e-18, -1.040346915234450e-20,
  6.461385092053462e-23, -3.890297697136317e-25,  3.625462137789534e-02, -6.983924561837461e-04,  9.795471689543590e-06, -1.126171435689007e-07,  1.135190942825491e-09,
 -1.038205417425456e-11,  8.796673017217717e-14, -7.002182965770455e-16,  5.288493455068935e-18, -3.817791818360844e-20,  2.649321777080357e-22, -1.775116462135714e-24,
  3.058119430383840e-02, -7.584737096940105e-04,  1.278070574097690e-05, -1.725870159024727e-07,  2.012529288927588e-09, -2.105992833563792e-11,  2.024454366002594e-13,
 -1.815762656010508e-15,  1.536404325599573e-17, -1.236535051578850e-19,  9.525707173292281e-22, -7.058580810728742e-24,  2.521044634516573e-02, -7.841733757506439e-04,
  1.569873558738651e-05, -2.466673111500749e-07,  3.300468142672817e-09, -3.922908623257096e-11,  4.249562898586625e-13, -4.267662926615852e-15,  4.021546180475306e-17,
 -3.587944406330258e-19,  3.051677552674382e-21, -2.487757184589462e-23,  2.032263435700084e-02, -7.755287451903475e-04,  1.825452855860398e-05, -3.309280559881956e-07,
  5.044093162238528e-09, -6.765920568834450e-11,  8.210637578882282e-13, -9.181695108629840e-15,  9.585747520399321e-17, -9.433789778910347e-19,  8.817196569158197e-21,
 -7.871856294930051e-23,  1.602955590948323e-02, -7.366329928153377e-04,  2.018894011045070e-05, -4.190180818024944e-07,  7.228005326836816e-09, -1.087789650420548e-10,
  1.470970894238041e-12, -1.822686705743153e-14,  2.098490419445957e-16, -2.268147029188892e-18,  2.319797969833382e-20, -2.259072339085817e-22,  1.237952589527325e-02,
 -6.743052674935136e-04,  2.132353780535559e-05, -5.030766432368313e-07,  9.761954680843892e-09, -1.639576680369943e-10,  2.458663015496734e-12, -3.360673716236209e-14,
  4.249069493926584e-16, -5.023909903587577e-18,  5.601664100308018e-20, -5.928711420255116e-22,  9.368218208996330e-03, -5.966131548891664e-04,  2.158556495090869e-05,
 -5.750592383549255e-07,  1.248245130539877e-08, -2.328197238084804e-10,  3.854379917932179e-12, -5.787777631462844e-14,  8.005344955303229e-16, -1.031655209265573e-17,
  1.249702616853563e-19, -1.432777038177758e-21,  6.952488271590275e-03, -5.115462613284810e-04,  2.100957828576062e-05, -6.281317468562485e-07,  1.517216496537070e-08,
 -3.128158589584545e-10,  5.693508230192585e-12, -9.356221517599564e-14,  1.410636804059972e-15, -1.974751832141009e-17,  2.590552380748978e-19, -3.207493321062120e-21,
  5.064585623208101e-03, -4.260342196352355e-04,  1.971891901468957e-05, -6.577809515662707e-07,  1.759332880216008e-08, -3.992312988979834e-10,  7.957347116787304e-12,
 -1.425888486415741e-13,  2.335543242346215e-15, -3.540429605037739e-17,  5.014679318871189e-19, -6.686163634915230e-21,  3.624834154501242e-03, -3.453828903586826e-04,
  1.789456257923747e-05, -6.623971675579390e-07,  1.952696346802662e-08, -4.856928386353400e-10,  1.056195551223603e-11, -2.056719936656454e-13,  3.648252036255134e-15,
 -5.970718441901840e-17,  9.105274469586386e-19, -1.303816221400948e-20,  2.551660362073286e-03, -2.731015661800971e-04,  1.574025908186550e-05, -6.432539084712588e-07,
  2.080817749025832e-08, -5.650861853798992e-10,  1.335980031705638e-11, -2.817938888881605e-13,  5.396769062967563e-15, -9.508551905020735e-17,  1.557010255681006e-18,
 -2.388310315495976e-20,  1.768590508176395e-03, -2.110296416466552e-04,  1.345159953081550e-05, -6.039742637967064e-07,  2.134945112114902e-08, -6.306699442815005e-10,
  1.615551913956415e-11, -3.679600379699867e-13,  7.586406553842345e-15, -1.435067858583372e-16,  2.516754845111502e-18, -4.125246508228239e-20,  1.208395775141425e-03,
 -1.596464869886398e-04,  1.119380478634414e-05, -5.496826104140192e-07,  2.114776309191131e-08, -6.771191583694740e-10,  1.873298996756089e-11, -4.593399624109407e-13,
  1.016694821136774e-14, -2.059412775953860e-16,  3.858559262705487e-18, -6.742436192998738e-20,  8.148995852017918e-04, -1.184552917095744e-04,  9.089857986905747e-06,
 -4.860725843588610e-07,  2.027604023615584e-08, -7.012641097134054e-10,  2.088759641191008e-11, -5.498033421433719e-13,  1.302905132230356e-14, -2.818900357303964e-16,
  5.628999075229160e-18, -1.046191116944426e-19,  5.430928423184469e-04, -8.635759370691193e-05,  7.218021175902788e-06, -4.185872525849764e-07,  1.886311820017416e-08,
 -7.023895313053283e-10,  2.245625903058993e-11, -6.327496216404962e-13,  1.601213431326426e-14, -3.691130115788238e-16,  7.837287358201534e-18, -1.545846239024204e-19,
  3.581841943043172e-04, -6.196748711752870e-05,  5.616247686491239e-06, -3.518330683134269e-07,  1.706825498572359e-08, -6.820842629593756e-10,  2.333879683756592e-11,
 -7.020480329919019e-13,  1.892295273500519e-14, -4.636582059051217e-16,  1.044404667992573e-17, -2.181447687356255e-19,  2.341056147229080e-04, -4.384388927696376e-05,
  4.290533148892319e-06, -2.892670382803067e-07,  1.505612418731856e-08, -6.437386455746800e-10,  2.350692730119211e-11, -7.528814650924128e-13,  2.156115778653512e-14,
 -5.602196417323858e-16,  1.335744072073659e-17, -2.948138260523281e-19,  1.518526493435900e-04, -3.064087354314203e-05,  3.224566150946983e-06, -2.331304293596305e-07,
  1.297666753792388e-08, -5.918481004876009e-10,  2.300060641488785e-11, -7.823251092786684e-13,  2.374635398275556e-14, -6.527662773058795e-16,  1.643853045400700e-17,
 -3.825816609303303e-19,  9.790140479389800e-05, -2.118881614220531e-05,  2.388774275170685e-06, -1.845636109602147e-07,  1.095202483615585e-08, -5.312892916193877e-10,
  2.191432186564677e-11, -7.895707084556879e-13,  2.534104879092546e-14, -7.353143795721089e-16,  1.951544935564525e-17, -4.779429763899772e-19,  6.283160762126421e-05,
 -1.452425285615001e-05,  1.747685718125331e-06, -1.438251243998291e-07,  9.070730379331364e-09, -4.667012127899952e-10,  2.037763809064661e-11, -7.757992654715868e-13,
  2.626530514238988e-14, -8.026844772892899e-16,  2.240377876340111e-17, -5.761879076425198e-19,  4.020398290694854e-05, -9.886234440901510e-06,  1.265226845551436e-06,
 -1.105465351352560e-07,  7.387933972717228e-09, -4.020480511961710e-10,  1.853456380761273e-11, -7.437804988954010e-13,  2.650124746162799e-14, -8.510977225107006e-16,
  2.492905641054131e-17, -6.719079706770803e-19,  2.568908922814860e-05, -6.693983470582091e-06,  9.080576014675005e-07, -8.397352804566965e-08,  5.929713216787867e-09,
 -3.403842394340682e-10,  1.652545559262670e-11, -6.973187044764171e-13,  2.608801444655280e-14, -8.785162689150111e-16,  2.694706632949869e-17, -7.596209773293704e-19,
  1.641751096360054e-05, -4.516651504804170e-06,  6.473061983774276e-07, -6.316477951824042e-08,  4.699488316054325e-09, -2.837988410239169e-10,  1.447371638615923e-11,
 -6.406689350248922e-13,  2.510960493191146e-14, -8.846987832944193e-16,  2.835840786620059e-17, -8.343955646381536e-19,  1.051072351152333e-05, -3.042138037797672e-06,
  4.591490322641703e-07, -4.713803410246975e-08,  3.684905800984806e-09, -2.334920862967034e-10,  1.247803141973495e-11, -5.780230372455601e-13,  2.367896464380635e-14,
 -8.710043859379399e-16,  2.911543874975923e-17, -8.923647390199763e-19,  6.751542100306070e-06, -2.048843280514207e-06,  3.246542545831135e-07, -3.496520527677241e-08,
  2.864086742294191e-09, -1.899303094156020e-10,  1.060968458971648e-11, -5.131260991538339e-13,  2.192161308497162e-14, -8.400207736933731e-16,  2.922148116956491e-17,
 -9.310520837639635e-19,  4.357921918714922e-06, -1.382041147736730e-06,  2.292246590920137e-07, -2.582513876463780e-08,  2.210657532620020e-09, -1.530315993744675e-10,
  8.913782565324237e-12, -4.490438755029915e-13,  1.996137522646748e-14, -7.951088599092223e-16,  2.872367008548143e-17, -9.494810906780077e-19,  2.830714474564391e-06,
 -9.351891916319722e-07,  1.618783122445394e-07, -1.902508920991382e-08,  1.697394348244682e-09, -1.223470299510009e-10,  7.412968172793470e-12, -3.880701754691591e-13,
  1.790973110918067e-14, -7.399495010425253e-16,  2.770170633644528e-17, -9.480832998532022e-19,  1.852884206805628e-06, -6.357494144246676e-07,  1.145174753123119e-07,
 -1.400151745173061e-08,  1.298582082986367e-09, -9.721623502417890e-11,  6.112307542909599e-12, -3.317440796819842e-13,  1.585926203265079e-14, -6.781557418748645e-16,
  2.625498985523258e-17, -9.284538784154627e-19,  1.223709947608756e-06, -4.347764665465200e-07,  8.126810311540821e-08, -1.030891550307817e-08,  9.913266901134961e-10,
 -7.688806087542056e-11,  5.004332671457292e-12, -2.809398093795983e-13,  1.388087332465800e-14, -6.129859559878741e-16,  2.449027848733746e-17, -8.930190788757617e-19,
  8.163151008144764e-07, -2.994685257386162e-07,  5.792506068452675e-08, -7.603024011643128e-09,  7.561000592084365e-10, -6.060560386135858e-11,  4.073577182353076e-12,
 -2.359940712316913e-13,  1.202399677758344e-14, -5.471671421002553e-16,  2.251137186645983e-17, -8.446794930748799e-19,  5.505064172474615e-07, -2.079482799937538e-07,
  4.150913112977537e-08, -5.622626662388456e-09,  5.767763055137597e-10, -4.766002408754035e-11,  3.300266722909653e-12, -1.968428967671873e-13,  1.031880165332479e-14,
 -4.828181955428536e-16,  2.041158937119399e-17, -7.864807561873586e-19,  3.755269391277447e-07, -1.456675291741080e-07,  2.992627009177698e-08, -4.172363374152119e-09,
  4.403690751266056e-10, -3.741975699138966e-11,  2.663071057729974e-12, -1.631489813436699e-13,  8.779493195924176e-15, -4.214517513847487e-16,  1.826917137680421e-17,
 -7.213453411230418e-19,  2.591615708820308e-07, -1.029634298297152e-07,  2.171289628205801e-08, -3.107758839654696e-09,  3.366228918328902e-10, -2.934202531549276e-11,
  2.140982679487137e-12, -1.344089486336603e-13,  7.407956651683576e-15, -3.640293752184820e-16,  1.614527814229203e-17, -6.518806926240894e-19,  1.808792112573856e-07,
 -7.341491438549948e-08,  1.584968074371282e-08, -2.322858430045628e-09,  2.575601345732988e-10, -2.297272790783050e-11,  1.714468180955865e-12, -1.100365862101914e-13,
  6.197229906191437e-15, -3.110464045683697e-16,  1.408401141165120e-17, -5.802638298168866e-19,  1.275235855813377e-07, -5.274604161656133e-08,  1.162775027578045e-08,
 -1.740398278275477e-09,  1.970443393575235e-10, -1.793949210204611e-11,  1.366064275480798e-12, -8.942256596559570e-14,  5.134501521196405e-15, -2.626272972861490e-16,
  1.211381069508560e-17, -5.081923719351953e-19,  9.060611375938037e-08, -3.809837285467231e-08,  8.553820394028240e-09, -1.304206229651894e-09,  1.503910889789483e-10,
 -1.394133725054214e-11,  1.080581282425589e-12, -7.197368466386571e-14,  4.203502406786869e-15, -2.186179585860505e-16,  1.024962621243740e-17, -4.368867771666216e-19,
  6.460287027109705e-08, -2.754982402297857e-08,  6.283584475449459e-09, -9.734481655200844e-10,  1.140383700266382e-10, -1.073722879920872e-11,  8.450503061005600e-13,
 -5.713569536051900e-14,  3.386278981363484e-15, -1.786668529776216e-16,  8.495388246936758e-18, -3.671274950535928e-19,  4.587989367981405e-08, -1.979684048724165e-08,
  4.575241020803993e-09, -7.183357166561274e-10,  8.527664926949569e-11, -8.134889006949726e-12,  6.485181837602745e-13, -4.440385578836171e-14,  2.664407345890066e-15,
 -1.422910462921220e-16,  6.846433145443742e-18, -2.993123925701663e-19,  3.201144803259794e-08, -1.394410201896741e-08,  3.257158401696333e-09, -5.169536241003571e-10,
  6.203274385502814e-11, -5.980574412966821e-12,  4.817637119465381e-13, -3.332483302300227e-14,  2.019742352196318e-15, -1.089264524213495e-16,  5.291679970390184e-18,
 -2.335229645906972e-19,  2.134388891890028e-08, -9.364609706647407e-09,  2.205332321121882e-09, -3.529220464823498e-10,  4.269894273144676e-11, -4.150097811468467e-12,
  3.369835006876240e-13, -2.349292225969179e-14,  1.434806199394607e-15, -7.796366230645509e-17,  3.815467937241281e-18, -1.695916900333242e-19,  1.271297187862288e-08,
 -5.605624625638005e-09,  1.327559782452724e-09, -2.136707103604875e-10,  2.599886348643684e-11, -2.541164747222922e-12,  2.074813719452794e-13, -1.454316978758787e-14,
  8.929377493218400e-16, -4.877307695488504e-17,  2.399109208665128e-18, -1.071690648097728e-19,  5.263161804928418e-09, -2.327138742663002e-09,  5.528545972586101e-10,
 -8.926546709970622e-11,  1.089598280059441e-11, -1.068316272402898e-12,  8.749400906272631e-14, -6.151285446061123e-15,  3.788002879470392e-16, -2.075038348708573e-17,
  1.023593456167049e-18, -4.585109972938244e-20,  6.020396195000723e-02, -1.505141206328338e-04,  3.909995308983521e-07, -1.047843947376889e-09,  2.873436775592856e-12,
 -8.003465589536986e-15,  2.250612385624683e-17, -6.361475771386569e-20,  1.801741275730052e-22, -5.103124538745244e-25,  1.443483961077693e-27, -4.074717160563433e-30,
  5.854179114964348e-02, -1.914057285455915e-04,  7.346574979933074e-07, -2.906913596397351e-09,  1.134558736333790e-11, -4.329825615043319e-14,  1.617214902744046e-16,
 -5.928104096635806e-19,  2.138153359415564e-21, -7.604098301975038e-24,  2.670895064621283e-26, -9.277477218474277e-29,  5.535781373019961e-02, -2.661453604430068e-04,
  1.461117927106450e-06, -7.613822670605501e-09,  3.750003876544690e-11, -1.767090830369271e-13,  8.039750112480146e-16, -3.553421645376922e-18,  1.532332487258053e-20,
 -6.467964796414494e-23,  2.679080636330349e-25, -1.091134282827724e-27,  5.091268730801880e-02, -3.621390815178607e-04,  2.621500786220459e-06, -1.701133008533976e-08,
  1.020335863960541e-10, -5.772908204084545e-13,  3.118590516084320e-15, -1.621589959933130e-17,  8.163263925706074e-20, -3.995995524453723e-22,  1.908536213174766e-24,
 -8.917796778908688e-27,  4.555129165826626e-02, -4.638327250378945e-04,  4.236484244266487e-06, -3.346656095653329e-08,  2.400236800227153e-10, -1.602287957826803e-12,
  1.010595800367443e-14, -6.083480384256586e-17,  3.520557753468850e-19, -1.969295100435438e-21,  1.069230542214805e-23, -5.653631570584187e-26,  3.965772488921615e-02,
 -5.557340570632826e-04,  6.257193131197917e-06, -5.929757795899083e-08,  5.015732113978131e-10, -3.899363308976162e-12,  2.836491755889849e-14, -1.953961737359604e-16,
  1.285638149920227e-18, -8.131353058893515e-21,  4.968051998123468e-23, -2.943524429815807e-25,  3.360963620499505e-02, -6.251406008426371e-04,  8.546546292983487e-06,
 -9.600684614008920e-08,  9.471674764344844e-10, -8.488203242968407e-12,  7.053698665989045e-14, -5.510752674229648e-16,  4.087404638160418e-18, -2.899253887611383e-20,
  1.977687981206799e-22, -1.303068919319782e-24,  2.773940681134389e-02, -6.639952104723925e-04,  1.088977500325294e-05, -1.435084837105905e-07,  1.636070057361167e-09,
 -1.675964231301678e-11,  1.578670707227925e-13, -1.388551156738034e-15,  1.152956556215604e-17, -9.110903797965479e-20,  6.894626973367097e-22, -5.020836306071942e-24,
  2.230737896183881e-02, -6.695820142212355e-04,  1.303137158370927e-05, -1.996204885343047e-07,  2.608900673835972e-09, -3.032979368418083e-11,  3.216927878182939e-13,
 -3.165861435342593e-15,  2.925548649383046e-17, -2.561151767597877e-19,  2.138613641824221e-21, -1.712413486837263e-23,  1.748925090550220e-02, -6.441013659720657e-04,
  1.472621327443679e-05, -2.600589240451914e-07,  3.868806838440500e-09, -5.072120917665456e-11,  6.022635656579639e-13, -6.595817833006763e-15,  6.748915691129720e-17,
 -6.513825239552096e-19,  5.974016109964356e-21, -5.236198547538668e-23,  1.337677387685532e-02, -5.934220135736562e-04,  1.578858766241761e-05, -3.190172597458323e-07,
  5.367743860484208e-09, -7.891057212327011e-11,  1.043528148220963e-12, -1.265685870702623e-14,  1.427497266965080e-16, -1.512471396473926e-18,  1.517297112600741e-20,
 -1.450054643043580e-22,  9.988692052292299e-03, -5.254392612322606e-04,  1.612512705064147e-05, -3.702067898665099e-07,  7.003944363463647e-09, -1.148579861362556e-10,
  1.683654010611593e-12, -2.251741078581796e-14,  2.787887519670501e-16, -3.230102588041887e-18,  3.531438060771529e-20, -3.666858529403520e-22,  7.287794850631343e-03,
 -4.484600219548549e-04,  1.574440020148635e-05, -4.080680576037689e-07,  8.633461806686151e-09, -1.571783091048131e-10,  2.542832586197207e-12, -3.734947608111593e-14,
  5.057313777232901e-16, -6.384879675245816e-18,  7.581893997439300e-20, -8.526084510928777e-22,  5.199973475415501e-03, -3.699244513500307e-04,  1.474388621016207e-05,
 -4.288100129791848e-07,  1.009390513459728e-08, -2.030993737294609e-10,  3.611661259008532e-12, -5.804363289182720e-14,  8.565588360899442e-16, -1.174513298205454e-17,
  1.510152839667569e-19, -1.833708242074593e-21,  3.631993256511681e-03, -2.956165554427693e-04,  1.328125270942358e-05, -4.310076507730214e-07,  1.123418545474261e-08,
 -2.487718113732659e-10,  4.844162676575357e-12, -8.488412067027003e-14,  1.360755093117706e-15, -2.020302110087918e-17,  2.804491974300745e-19, -3.666867692942895e-21,
  2.485900351609296e-03, -2.293677302550746e-04,  1.153961197697775e-05, -4.156476441176930e-07,  1.194209558458677e-08, -2.898796674510113e-10,  6.158702292663814e-12,
 -1.172786351074526e-13,  2.036033728328861e-15, -3.263617578981619e-17,  4.877767182792864e-19, -6.849486297470588e-21,  1.669196735577133e-03, -1.731536252479440e-04,
  9.695706697844332e-06, -3.856839218638499e-07,  1.216254578302457e-08, -3.223981724446897e-10,  7.447807255904359e-12, -1.536424007601294e-13,  2.880156550924594e-15,
 -4.970638548520552e-17,  7.977851762379268e-19, -1.200162462013472e-20,  1.100883182539403e-03, -1.274378881909147e-04,  7.896950273329483e-06, -3.452878284561623e-07,
  1.190263438563825e-08, -3.432974993045522e-10,  8.595015451103481e-12, -1.915014341571197e-13,  3.865419743240240e-15, -7.163569463285976e-17,  1.231606548251429e-18,
 -1.980210070760391e-20,  7.140749410788012e-04, -9.161843727689957e-05,  6.249499768492089e-06, -2.990194519114467e-07,  1.122390590341146e-08, -3.510155256546279e-10,
  9.494564832368351e-12, -2.278154589139467e-13,  4.938032657659705e-15, -9.802144494077211e-17,  1.800899292929195e-18, -3.087595828579709e-20,  4.561501817551068e-04,
 -6.446470898151985e-05,  4.816386375959717e-06, -2.511137093185390e-07,  1.022553837556010e-08, -3.456033178209118e-10,  1.006889079664319e-11, -2.594513175953718e-13,
  6.023351430591937e-15, -1.277535608028324e-16,  2.502405336965459e-18, -4.564766726077099e-20,  2.873816762239772e-04, -4.447839031016744e-05,  3.622855419598630e-06,
 -2.049971639619099e-07,  9.023818895449940e-09, -3.285481790931677e-10,  1.027977793309638e-11, -2.836905767169897e-13,  7.036185560590172e-15, -1.590754119356041e-16,
  3.314531631303267e-18, -6.419143261627469e-20,  1.788360595211520e-04, -3.015075987950276e-05,  2.665532414703853e-06, -1.630656303091351e-07,  7.732993223770286e-09,
 -3.023625655051160e-10,  1.013113210534978e-11, -2.986477544383607e-13,  7.893839298876061e-15, -1.897900006052697e-16,  4.197278657239486e-18, -8.611954773215320e-20,
  1.100991949689997e-04, -2.011912615543516e-05,  1.922478863099713e-06, -1.266858250802737e-07,  6.450982603530795e-09, -2.700689264250277e-10,  9.663799184555781e-12,
 -3.035081470328333e-13,  8.528770179005781e-15, -2.175703961818335e-16,  5.095995749808050e-18, -1.105462249166000e-19,  6.716813228071639e-05, -1.324124654451489e-05,
  1.362137091972130e-06, -9.634877765072598e-08,  5.251397249924764e-09, -2.347068445217968e-10,  8.944783001887370e-12, -2.985509554846601e-13,  8.897989429047095e-15,
 -2.403032841797331e-16,  5.948370016366427e-18, -1.361472280968174e-19,  4.067579587255205e-05, -8.612194892769491e-06,  9.501604087343234e-07, -7.189678688107960e-08,
  4.181478417548899e-09, -1.989524618123567e-10,  8.054101765350869e-12, -2.849819280802001e-13,  8.987418328452131e-15, -2.563875783613416e-16,  6.693142213471637e-18,
 -1.613102032126773e-19,  2.449456873338745e-05, -5.546634270789191e-06,  6.539200542441979e-07, -5.275979795723216e-08,  3.264478033588811e-09, -1.648909151925881e-10,
  7.072339933296403e-12, -2.646410900954469e-13,  8.810882375133809e-15, -2.649269237530393e-16,  7.278608957107138e-18, -1.843457785199985e-19,  1.469440583683391e-05,
 -3.544455690088864e-06,  4.449777847970013e-07, -3.815977605132108e-08,  2.504598520819087e-09, -1.339381155392320e-10,  6.071032928478798e-12, -2.396663566896363e-13,
  8.404745086294159e-15, -2.657873798273914e-16,  7.669133056800105e-18, -2.037139086991663e-19,  8.798048582441353e-06, -2.251923002282816e-06,  3.000341442449516e-07,
 -2.726396341622867e-08,  1.892791939638593e-09, -1.068790523768894e-10,  5.106834933439328e-12, -2.121847797116087e-13,  7.819984188812633e-15, -2.595271237083943e-16,
  7.848529705526082e-18, -2.182182599206582e-19,  5.267291819507921e-06, -1.425357337131565e-06,  2.008863246434268e-07, -1.928478726614960e-08,  1.412194889079623e-09,
 -8.397812865269049e-11,  4.219369500122586e-12, -1.840789228666431e-13,  7.113679420854539e-15, -2.472324256446006e-16,  7.820059528577754e-18, -2.271329261557993e-19,
  3.159182194462192e-06, -9.006177350989652e-07,  1.338437733870949e-07, -1.353421401337823e-08,  1.042518247759719e-09, -6.511930262382263e-11,  3.431976978819165e-12,
 -1.568473997541124e-13,  6.341527740524124e-15, -2.303072776234790e-16,  7.603547518566171e-18, -2.302452410155292e-19,  1.901803085662866e-06, -5.692145815492482e-07,
  8.892453682658063e-08, -9.444429557625089e-09,  7.631665605704953e-10, -4.994410093379463e-11,  2.754295303295662e-12, -1.315546562469577e-13,  5.552368170316395e-15,
 -2.102627278641340e-16,  7.230651615829575e-18, -2.278189433488571e-19,  1.151241434650047e-06, -3.605677501128889e-07,  5.903478104404467e-08, -6.566758405073077e-09,
  5.551671823485447e-10, -3.796825682698268e-11,  2.185657275627080e-12, -1.088500895465418e-13,  4.785032475676723e-15, -1.885404021344499e-16,  6.739454433615796e-18,
 -2.204975631361933e-19,  7.020408182968566e-07, -2.293529434418437e-07,  3.923874879458427e-08, -4.558630075711654e-09,  4.021458648612028e-10, -2.866897925077611e-11,
  1.718521956743711e-12, -8.903097801009355e-14,  4.067314526503067e-15, -1.663887960010645e-16,  6.169398578880205e-18, -2.091755362150926e-19,  4.320206920453805e-07,
 -1.467649056797217e-07,  2.616135918450937e-08, -3.165608540911277e-09,  2.906290196252432e-10, -2.154286473900946e-11,  1.341452069471672e-12, -7.212524775677915e-14,
  3.416545909316090e-15, -1.447959310628991e-16,  5.557253512488301e-18, -1.948642550584436e-19,  2.687166490079363e-07, -9.464158863966999e-08,  1.752689707706057e-08,
 -2.202890947362655e-09,  2.099276574028396e-10, -1.613899674693141e-11,  1.041415141726177e-12, -5.797568846147624e-14,  2.841169151244936e-15, -1.244710971431418e-16,
  4.934424120009372e-18, -1.785742565540300e-19,  1.691861930009345e-07, -6.159613426241762e-08,  1.181779970112709e-08, -1.538645015467376e-09,  1.518017469641857e-10,
 -1.207350439572289e-11,  8.053805103664201e-13, -4.631402753234056e-14,  2.342755008484750e-15, -1.058626574929521e-16,  4.325589884250150e-18, -1.612261325091462e-19,
  1.079576947363614e-07, -4.051440616364329e-08,  8.030512598693683e-09, -1.080162615749850e-09,  1.100420391770335e-10, -9.031742410268673e-12,  6.212998811122658e-13,
 -3.681937419410628e-14,  1.918045642294365e-15, -8.919763857142541e-17,  3.748450702761755e-18, -1.435942956127350e-19,  6.988281683960514e-08, -2.695830556595892e-08,
  5.505296605429582e-09, -7.629684619137142e-10,  8.005306565621170e-11, -6.763196583375130e-12,  4.786091932035038e-13, -2.916004005805815e-14,  1.560761012452040e-15,
 -7.453060585875238e-17,  3.214257521118466e-18, -1.262812271773071e-19,  4.591449837925388e-08, -1.815799617630576e-08,  3.810005618296382e-09, -5.425898343032464e-10,
  5.848113092890601e-11, -5.072860819472178e-12,  3.683949581851100e-13, -2.302047822049048e-14,  1.263042566462696e-15, -6.179258396420169e-17,  2.728800214633704e-18,
 -1.097159523170091e-19,  3.061841234555166e-08, -1.238096937281351e-08,  2.661994252832018e-09, -3.885228502995572e-10,  4.290455534960236e-11, -3.811555682615105e-12,
  2.833489952752850e-13, -1.811634573783731e-14,  1.016508535913204e-15, -5.083428171886587e-17,  2.293577045752973e-18, -9.416905513877763e-20,  2.070666714523559e-08,
 -8.539262011772111e-09,  1.876296215383701e-09, -2.799107679822546e-10,  3.158767467519059e-11, -2.866637659490386e-12,  2.176066429425740e-13, -1.420093455752228e-14,
  8.129566761003775e-16, -4.146087757769739e-17,  1.906946721801929e-18, -7.977691190149653e-20,  1.417264344112547e-08, -5.945759196567478e-09,  1.331552301940076e-09,
 -2.025031795541588e-10,  2.329204425016122e-11, -2.153820306317165e-12,  1.665345125968082e-13, -1.106586805076322e-14,  6.447796479923810e-16, -3.345779010456837e-17,
  1.565141437175321e-18, -6.656921430981424e-20,  9.778965717664826e-09, -4.163181319219427e-09,  9.477497302948944e-10, -1.465446990176047e-10,  1.713514708878516e-11,
 -1.610358797276771e-12,  1.265093894620739e-13, -8.538358382342446e-15,  5.051651162797616e-16, -2.660819067203591e-17,  1.263083490211665e-18, -5.449561782329058e-20,
  6.753026662435839e-09, -2.910417684337536e-09,  6.717288480592681e-10, -1.053224659262856e-10,  1.248655529658881e-11, -1.189577174499289e-12,  9.471149602167631e-14,
 -6.476679969089267e-15,  3.881462745791475e-16, -2.070366350718869e-17,  9.949939895621859e-19, -4.344903064084129e-20,  4.604705444363985e-09, -2.004231183669263e-09,
  4.677503591424343e-10, -7.417192197140050e-11,  8.892518563801335e-12, -8.565810354838398e-13,  6.894271995828136e-14, -4.764951796702869e-15,  2.885561017183929e-16,
 -1.554959055556834e-17,  7.548105168599087e-19, -3.328442436070357e-20,  3.016184770187463e-09, -1.322729198289872e-09,  3.113333948300569e-10, -4.979631621870185e-11,
  6.021488081786283e-12, -5.849470614548823e-13,  4.747252216250166e-14, -3.307884508659820e-15,  2.019251697951314e-16, -1.096674271730145e-17,  5.364456167659641e-19,
 -2.383305562805156e-20,  1.774396303544254e-09, -7.822020047929902e-10,  1.851934743514156e-10, -2.979826072551134e-11,  3.624725109294701e-12, -3.541846480440730e-13,
  2.891039395589025e-14, -2.025880915571306e-15,  1.243534906846003e-16, -6.790487380676746e-18,  3.339310721146721e-19, -1.491298630484035e-20,  7.295323928174933e-10,
 -3.225255522217044e-10,  7.661058749734009e-11, -1.236789504188629e-11,  1.509430271491708e-12, -1.479725737026523e-13,  1.211699838527412e-14, -8.517628071313211e-16,
  5.244449486621100e-17, -2.872455604955450e-18,  1.416749523154095e-19, -6.345336768265201e-21,  5.960808291142762e-02, -1.474356512978737e-04,  3.786960646118674e-07,
 -1.003120759580855e-09,  2.718627951741080e-12, -7.484058251061636e-15,  2.080294430325840e-17, -5.813232313446555e-20,  1.628004122131339e-22, -4.560025630143145e-25,
  1.275742206129901e-27, -3.562181396849106e-30,  5.778770610162391e-02, -1.856649788852188e-04,  7.008358023936764e-07, -2.732106542368595e-09,  1.051712981465693e-11,
 -3.960863888263078e-14,  1.460409632342908e-16, -5.285709925775874e-19,  1.882692075051662e-21, -6.613069644429297e-24,  2.294467590645867e-26, -7.873621170142260e-29,
  5.431604557900815e-02, -2.548119424543238e-04,  1.373238736685760e-06, -7.041079978774968e-09,  3.415102944149501e-11, -1.585543031148958e-13,  7.110082278551622e-16,
 -3.098352811097618e-18,  1.317672108740867e-20, -5.486477167529187e-23,  2.242184338538582e-25, -9.011580792979638e-28,  4.950482018981887e-02, -3.419567177434769e-04,
  2.426791801090269e-06, -1.546724182211061e-08,  9.120092505538203e-11, -5.076107905585349e-13,  2.699054881351841e-15, -1.381982489646420e-17,  6.853165069276352e-20,
 -3.305611151595333e-22,  1.556116279348404e-24, -7.168293677013837e-27,  4.376129010995068e-02, -4.314843122138337e-04,  3.856911434510409e-06, -2.986992703504850e-08,
  2.102716890650593e-10, -1.378975097698152e-12,  8.550208147026694e-15, -5.062541815305616e-17,  2.882957192362270e-19, -1.587490416883036e-21,  8.487631494891370e-24,
 -4.420607564268415e-26,  3.753058221676709e-02, -5.083920634740266e-04,  5.591314569010878e-06, -5.186109672079667e-08,  4.299732931192433e-10, -3.279866905303827e-12,
  2.342837813922941e-14, -1.585798469804220e-16,  1.025763916477723e-18, -6.380862183165788e-21,  3.835799582202743e-23, -2.236847708702356e-25,  3.123886944620726e-02,
 -5.611312590468535e-04,  7.480074230768855e-06, -8.212329096783977e-08,  7.931549328285914e-10, -6.966609272323727e-12,  5.679139743176013e-14, -4.355567322568002e-16,
  3.173252649582069e-18, -2.211989297173545e-20,  1.483480492129270e-22, -9.613560975249484e-25,  2.524735199753454e-02, -5.833446065268507e-04,  9.314306996354434e-06,
 -1.198195528676860e-07,  1.335819338099200e-09, -1.339854542280743e-11,  1.236953860829914e-13, -1.067165201305047e-15,  8.697045859989936e-18, -6.749143400807669e-20,
  5.018038518820739e-22, -3.591856098645509e-24,  1.982332598955391e-02, -5.742467221864886e-04,  1.086764335680704e-05, -1.623396966889642e-07,  2.072843507722965e-09,
 -2.357507205536380e-11,  2.448787215460680e-13, -2.362067319107104e-15,  2.140928246287286e-17, -1.839432385911112e-19,  1.508203971188122e-21, -1.186357331274202e-23,
  1.513009041969835e-02, -5.377944613612852e-04,  1.194581803004245e-05, -2.055467201612946e-07,  2.985141551242028e-09, -3.825916139671932e-11,  4.445949550438709e-13,
 -4.769401243732423e-15,  4.783756065506870e-17, -4.528843083902179e-19,  4.076380418953608e-21, -3.508292632907755e-23,  1.123337143981720e-02, -4.810777803267360e-04,
  1.242770263934320e-05, -2.445101008966313e-07,  4.013741943876855e-09, -5.764883059395021e-11,  7.456704773088592e-13, -8.854356784331221e-15,  9.784353934796500e-17,
 -1.016389457551011e-18,  1.000261983546187e-20, -9.382622184215885e-23,  8.119277416076114e-03, -4.124644132013230e-04,  1.228578483150390e-05, -2.745229880379812e-07,
  5.064579307521150e-09, -8.110646714976694e-11,  1.162357514890603e-12, -1.521281262345700e-14,  1.844671779426135e-16, -2.094663410276707e-18,  2.245785039437034e-20,
 -2.288053993849527e-22,  5.717877391026794e-03, -3.399627941685820e-04,  1.158250120448378e-05, -2.920905386259514e-07,  6.024087425874707e-09, -1.070641705040134e-10,
  1.692843085993859e-12, -2.432475922421755e-14,  3.224817024905904e-16, -3.989038973402904e-18,  4.644043788612001e-20, -5.122905538906862e-22,  3.927092785856590e-03,
 -2.700913464145281e-04,  1.044700518230647e-05, -2.955952985538714e-07,  6.781562985972900e-09, -1.331774577943657e-10,  2.314091842800026e-12, -3.637467510508840e-14,
  5.254515399167981e-16, -7.057951121125054e-18,  8.895392893967609e-20, -1.059373843324109e-21,  2.633133085699219e-03, -2.073399761277282e-04,  9.041902792464159e-06,
 -2.854748607936640e-07,  7.251667746358999e-09, -1.567142687295390e-10,  2.981467429913229e-12, -5.109273904572425e-14,  8.016683426195159e-16, -1.165815257711160e-17,
  1.586163101762725e-19, -2.033876293630082e-21,  1.725538402239584e-03, -1.541471615782427e-04,  7.530215531415953e-06, -2.639206383253416e-07,  7.390492551730688e-09,
 -1.750784102791458e-10,  3.634192805011115e-12, -6.767891546048245e-14,  1.149988602173163e-15, -1.805503245211108e-17,  2.644801900080639e-19, -3.642175194621365e-21,
  1.106497350784888e-03, -1.112261030899205e-04,  6.050193080643062e-06, -2.342494599211961e-07,  7.201129768963583e-09, -1.863163885938219e-10,  4.205685745067638e-12,
 -8.485405354638023e-14,  1.556983759408341e-15, -2.632087920151084e-17,  4.140721192784430e-19, -6.109279338706736e-21,  6.952053949228734e-04, -7.805570690848867e-05,
  4.701441802935614e-06, -2.001644882097840e-07,  6.728402517718861e-09, -1.894651662864493e-10,  4.636025042920984e-12, -1.010423762612873e-13,  1.996671398909670e-15,
 -3.625156903866613e-17,  6.109917593428557e-19, -9.636014812822675e-21,  4.285638507830548e-04, -5.338517026329796e-05,  3.541961322817182e-06, -1.651034349146867e-07,
  6.045669955638027e-09, -1.846583608763388e-10,  4.883051235564566e-12, -1.146440902544309e-13,  2.433387682794020e-15, -4.733360908725022e-17,  8.527132920802552e-19,
 -1.434343065996915e-20,  2.595971016280111e-04, -3.565658446719311e-05,  2.593194396286423e-06, -1.317982532696386e-07,  5.238335529153603e-09, -1.729904094022448e-10,
  4.929164367091518e-12, -1.243250686274450e-13,  2.827337364471111e-15, -5.878181593821403e-17,  1.129342844940508e-18, -2.021782513671127e-20,  1.547560760228619e-04,
 -2.330499494944080e-05,  1.849346991793526e-06, -1.020816874660940e-07,  4.388568167317821e-09, -1.562079608812385e-10,  4.782423970582627e-12, -1.292458572696296e-13,
  3.141443215033939e-15, -6.964650680027764e-17,  1.423910521242530e-18, -2.707358021443583e-20,  9.094518407140587e-05, -1.493631609006241e-05,  1.287658652593439e-06,
 -7.690511516834399e-08,  3.564305490650398e-09, -1.363323221737927e-10,  4.472375329032522e-12, -1.291750316852554e-13,  3.347693445731813e-15, -7.896632171996401e-17,
  1.714346170158279e-18, -3.454868705148739e-20,  5.277817872747195e-05, -9.406556551431952e-06,  8.773809414486968e-07, -5.649462274482625e-08,  2.813687563400860e-09,
 -1.153120395263170e-10,  4.042413973539658e-12, -1.244707775870145e-13,  3.431404275717036e-15, -8.592800706232599e-17,  1.976762141460579e-18, -4.213943382801545e-20,
  3.030170266184778e-05, -5.833556950239868e-06,  5.863949812202884e-07, -4.056713916821066e-08,  2.164421187638434e-09, -9.477222906086072e-11,  3.541058852208607e-12,
 -1.159530810496530e-13,  3.392540201317729e-15, -8.999331412005602e-17,  2.189253296963347e-18, -4.926908085141310e-20,  1.724438306713709e-05, -3.570193998377520e-06,
  3.853210275003019e-07, -2.854479654921856e-08,  1.626605590418323e-09, -7.588529635702056e-11,  3.014239326851941e-12, -1.047137338305157e-13,  3.244141611333190e-15,
 -9.096512662108285e-17,  2.335283228909487e-18, -5.537495042002183e-20,  9.746724235575987e-06, -2.161042728209862e-06,  2.495222625565565e-07, -1.973040012557057e-08,
  1.197299930606088e-09, -5.935202050489602e-11,  2.499913470547267e-12, -9.191712219871074e-14,  3.008654654339394e-15, -8.898429671354699e-17,  2.405892738209809e-18,
 -5.999316295016938e-20,  5.482663701948419e-06, -1.296648981331804e-06,  1.596180125286724e-07, -1.342994472363837e-08,  8.653795676141141e-10, -4.546101217882540e-11,
  2.025419374003073e-12, -7.863429905499478e-14,  2.713326720186120e-15, -8.446770183516026e-17,  2.400352318590597e-18, -6.282188654152682e-20,  3.075835216426916e-06,
 -7.729621144690979e-07,  1.011066047057010e-07, -9.024359314077309e-09,  6.157337754822631e-10, -3.418896567485955e-11,  1.607228602675766e-12, -6.573380447132233e-14,
  2.385792411871584e-15, -7.801055894409249e-17,  2.325323984657024e-18, -6.375123464156494e-20,  1.724684805846956e-06, -4.588507250306812e-07,  6.356907736302961e-08,
 -6.001174313702334e-09,  4.323713631461728e-10, -2.530960690984759e-11,  1.252367303831322e-12, -5.383328747691002e-14,  2.050647197019076e-15, -7.027954060747859e-17,
  2.192945835971630e-18, -6.285769081352468e-20,  9.686841944662152e-07, -2.718752036023949e-07,  3.976724925645094e-08, -3.959165849390882e-09,  3.003900356139432e-10,
 -1.848994227740590e-11,  9.606867498897511e-13, -4.330180929051078e-14,  1.727368088714815e-15, -6.191892076078546e-17,  2.018417646958060e-18, -6.036965141123995e-20,
  5.461821002613886e-07, -1.611613138839957e-07,  2.481179373415130e-08, -2.597643034439240e-09,  2.069917793263223e-10, -1.336345635727976e-11,  7.273008608857650e-13,
 -3.429580429840441e-14,  1.429550045522610e-15, -5.348325046266131e-17,  1.817642614808723e-18, -5.661591860699436e-20,  3.098344425864993e-07, -9.579558379325442e-08,
  1.547644377106465e-08, -1.699057620735025e-09,  1.418124941279502e-10, -9.578449945711351e-12,  5.447410598194745e-13, -2.681116152427271e-14,  1.165172696367913e-15,
 -4.540067760635381e-17,  1.605326175541571e-18, -5.197002985623313e-20,  1.772144945090109e-07, -5.722769691077589e-08,  9.673197720093306e-09, -1.110474714159439e-09,
  9.682692024416590e-11, -6.824863450387452e-12,  4.046113783559576e-13, -2.073741436831335e-14,  9.375114482454890e-16, -3.796368992179560e-17,  1.393728044416515e-18,
 -4.680097359906389e-20,  1.024139175453032e-07, -3.443459460837715e-08,  6.071919232032013e-09, -7.268801229793194e-10,  6.603653242217844e-11, -4.845088342079595e-12,
  2.987045875728231e-13, -1.590509893129439e-14,  7.463271869155121e-16, -3.133993804284311e-17,  1.192077938289814e-18, -4.143671069651665e-20,  5.992079560362409e-08,
 -2.091300520710558e-08,  3.835835858861600e-09, -4.775284728790091e-10,  4.508271275857732e-11, -3.434376757872962e-12,  2.196475664851271e-13, -1.212212774337446e-14,
  5.890571915594945e-16, -2.559471774601077e-17,  1.006538970709889e-18, -3.614261277082736e-20,  3.555972846629246e-08, -1.284422484724910e-08,  2.443559740067626e-09,
 -3.154817736996004e-10,  3.086952096201994e-11, -2.435486532983708e-12,  1.611901585909657e-13, -9.198577720084078e-15,  4.618381762627001e-16, -2.071774016707646e-17,
  8.405447477461120e-19, -3.111356243689569e-20,  2.143940730145444e-08, -7.991204305075265e-09,  1.572421790319186e-09, -2.099642498864445e-10,  2.123732895109578e-11,
 -1.730877486558715e-12,  1.182557109936071e-13, -6.961395976119615e-15,  3.602881099592523e-16, -1.664890480159883e-17,  6.953343872154700e-19, -2.647650171325629e-20,
  1.314994315083588e-08, -5.043621690276837e-09,  1.023577563787571e-09, -1.409732182369410e-10,  1.470080975547848e-11, -1.234539248238348e-12,  8.685283599881813e-14,
 -5.261413668636921e-15,  2.800417542168878e-16, -1.330002685066719e-17,  5.705423951800564e-19, -2.229958940358272e-20,  8.212927939984925e-09, -3.232458084939937e-09,
  6.747145211246396e-10, -9.558512106801212e-11,  1.024925286158005e-11, -8.845711199176942e-13,  6.392141795944821e-14, -3.975122610183828e-15,  2.170740493806874e-16,
 -1.057132432035612e-17,  4.647465042528057e-19, -1.860445910751074e-20,  5.225088348311104e-09, -2.104592179156686e-09,  4.505654649293378e-10, -6.547816937450465e-11,
  7.200091995285209e-12, -6.369827528431101e-13,  4.716041390624341e-14, -3.003294269509528e-15,  1.678612447753359e-16, -8.362736086365344e-18,  3.759210479727215e-19,
 -1.537890517366017e-20,  3.384646791519214e-09, -1.391471829159045e-09,  3.046957079387899e-10, -4.529870163628124e-11,  5.094526749020700e-12, -4.607940920574086e-13,
  3.486464620356284e-14, -2.267990292136538e-15,  1.294300238845261e-16, -6.580839677085412e-18,  3.017781492589057e-19, -1.258828758434875e-20,  2.228578454620735e-09,
 -9.327069503354129e-10,  2.083255814944650e-10, -3.159752469968058e-11,  3.624758659504998e-12, -3.343120833333001e-13,  2.578348000737319e-14, -1.708999510005479e-15,
  9.933712232675188e-17, -5.142398313710002e-18,  2.400016578653263e-19, -1.018479746310235e-20,  1.486163485861647e-09, -6.315817181554257e-10,  1.434958803204962e-10,
 -2.214362614527254e-11,  2.584095084723852e-12, -2.423819522334597e-13,  1.900528897563599e-14, -1.280318670034949e-15,  7.561136788328855e-17, -3.975548558110897e-18,
  1.883906796413405e-19, -8.114353433669049e-21,  9.968240789029590e-10, -4.290760594828828e-10,  9.889322010211968e-11, -1.548388545143437e-11,  1.833132496979170e-12,
 -1.743999034927651e-13,  1.386661518213661e-14, -9.469928578661590e-16,  5.667985047513744e-17, -3.019478432281513e-18,  1.449335491638845e-19, -6.321291856918050e-21,
  6.636346913373751e-10, -2.886156947702846e-10,  6.729559632389257e-11, -1.066122347892506e-11,  1.276999424919018e-12, -1.228963807041303e-13,  9.882599534438957e-15,
 -6.824350194901948e-16,  4.129153803192344e-17, -2.223236873708379e-18,  1.078322300744245e-19, -4.751211015263681e-21,  4.267228229935148e-10, -1.870452456942105e-10,
  4.400091545629950e-11, -7.033796002286984e-12,  8.500698056532156e-13, -8.253325609697348e-14,  6.694536734892801e-15, -4.662284844772465e-16,  2.844550810888535e-17,
 -1.544116999867251e-18,  7.549393378867363e-20, -3.352393100531769e-21,  2.478137645685486e-10, -1.092146246682204e-10,  2.584993148456855e-11, -4.158091820628039e-12,
  5.056478859663432e-13, -4.939401300702240e-14,  4.030620795225607e-15, -2.823626563911023e-16,  1.732721917285305e-17, -9.459137132291251e-19,  4.650388428480282e-20,
 -2.076257895687453e-21,  1.011538732189672e-10, -4.471409314925904e-11,  1.061948034483233e-11, -1.714126353773325e-12,  2.091667133398718e-13, -2.050187807770331e-14,
  1.678576017130407e-15, -1.179774279731366e-16,  7.262986490486444e-18, -3.977448309842141e-19,  1.961466985617533e-20, -8.783757148487489e-22,  5.902432423526598e-02,
 -1.444535043128670e-04,  3.669147506863961e-07, -9.607935776532280e-10,  2.573810628548729e-12, -7.003746185859415e-15,  1.924577443582621e-17, -5.317581708173842e-20,
  1.472663204738758e-22, -4.079723867852147e-25,  1.128996216085927e-27, -3.118600169770510e-30,  5.705605587955492e-02, -1.801866319131601e-04,  6.690346300624573e-07,
 -2.569984322410976e-09,  9.758842341979751e-12, -3.627466161191481e-14,  1.320498562683779e-16, -4.719633982498465e-19,  1.660340029481601e-21, -5.760952580299663e-24,
  1.974695592263118e-26, -6.695276696959759e-29,  5.331824731056530e-02, -2.441549504417281e-04,  1.291922554644960e-06, -6.519133703353965e-09,  3.114379701113440e-11,
 -1.424852701693277e-13,  6.298724982039544e-16, -2.706643522197532e-18,  1.135391120449289e-20, -4.664113171552291e-23,  1.880920885062256e-25, -7.461052338818938e-28,
  4.817468050921601e-02, -3.232607536281590e-04,  2.249616216668592e-06, -1.408585242320658e-08,  8.166637462809904e-11, -4.472397051925389e-13,  2.341095172407197e-15,
 -1.180579266920363e-17,  5.767981806933123e-20, -2.741925238796894e-22,  1.272419570933746e-24, -5.779474134374186e-27,  4.209487139887370e-02, -4.020076092596592e-04,
  3.517783111604998e-06, -2.671553040682508e-08,  1.846345904427877e-10, -1.189788319789137e-12,  7.253707445298584e-15, -4.225244772833613e-17,  2.368158582129324e-19,
 -1.283906681815046e-21,  6.760787705232112e-24, -3.468992309358459e-26,  3.558269233071646e-02, -4.660387209745109e-04,  5.008189123746943e-06, -4.547719769664473e-08,
  3.696574125301594e-10, -2.767361619727271e-12,  1.941515620700191e-14, -1.291528838530128e-16,  8.214528000400946e-19, -5.026682816850145e-21,  2.973633163157207e-23,
 -1.707027191874054e-25,  2.910807541994606e-02, -5.050269729140690e-04,  6.566368684921142e-06, -7.047736264158194e-08,  6.665211622702300e-10, -5.739185123601182e-12,
  4.590542305823587e-14, -3.456863576678920e-16,  2.474282099994284e-18, -1.695304245254377e-20,  1.118023552338221e-22, -7.127227356844268e-25,  2.305438356249228e-02,
 -5.142375123118779e-04,  7.996364010544317e-06, -1.004385330097431e-07,  1.095268476034001e-09, -1.075908896398948e-11,  9.737170020382056e-14, -8.241502005767522e-16,
  6.593546320343371e-18, -5.025789181465787e-20,  3.671997166533584e-22, -2.583929802599521e-24,  1.768863478868187e-02, -4.945679330802385e-04,  9.103976541086723e-06,
 -1.326480587842736e-07,  1.655131361583017e-09, -1.841994775156546e-11,  1.874141452001878e-13, -1.772228005906070e-15,  1.575815153146785e-17, -1.328980453499964e-19,
  1.070160109109034e-21, -8.270943653037768e-24,  1.315549821915724e-02, -4.513368019229759e-04,  9.742340929850204e-06, -1.633686443693601e-07,  2.316678040738455e-09,
 -2.903243078369064e-11,  3.302399467449959e-13, -3.470781736846557e-15,  3.413105875032989e-17, -3.169993024470940e-19,  2.800747644577623e-21, -2.367198629334124e-23,
  9.490754018351141e-03, -3.923826092140919e-04,  9.843786249566764e-06, -1.886200239328539e-07,  3.021339042691021e-09, -4.240523670913587e-11,  5.365887446011261e-13,
 -6.238997897594689e-15,  6.755967057061516e-17, -6.881774166712940e-19,  6.644926105688029e-21, -6.118720869484810e-23,  6.646922417146903e-03, -3.260917799431557e-04,
  9.428719460234263e-06, -2.050847000576849e-07,  3.690085856520852e-09, -5.771829186573131e-11,  8.088343767198288e-13, -1.036097118805832e-14,  1.230629168531044e-16,
 -1.369740388067892e-18,  1.440357333382974e-20, -1.440060791977832e-22,  4.523262804798629e-03, -2.598340444001096e-04,  8.591629648026956e-06, -2.108401136588398e-07,
  4.239424658137582e-09, -7.356384847576907e-11,  1.136954379427821e-12, -1.598443086254463e-14,  2.075057930760835e-16, -2.515227233809165e-18,  2.871175215572689e-20,
 -3.107257134886979e-22,  2.993774226559249e-03, -1.990437090368834e-04,  7.471899252899585e-06, -2.056959937590924e-07,  4.599804127641757e-09, -8.817341917955980e-11,
  1.497219416354310e-12, -2.302082737972566e-14,  3.255595007065295e-16, -4.284155490294724e-18,  5.293188742588302e-20, -6.183249343697163e-22,  1.929247228600871e-03,
 -1.469502592338706e-04,  6.220313359135261e-06, -1.910734443702820e-07,  4.730538704411964e-09, -9.977537332241012e-11,  1.854734680101965e-12, -3.108606701763293e-14,
  4.774376436626734e-16, -6.801159536450502e-18,  9.070119838354030e-20, -1.140659235049365e-21,  1.211897544490540e-03, -1.048016639080847e-04,  4.970858421969751e-06,
 -1.695228370367071e-07,  4.626820093943432e-09, -1.069742051831571e-10,  2.169585075762253e-12, -3.951461534858748e-14,  6.571924307949985e-16, -1.010667662066738e-17,
  1.451097663354469e-19, -1.959813469058029e-21,  7.430253652919141e-04, -7.236103050690833e-05,  3.823318245305009e-06, -1.440744966973885e-07,  4.317476984225887e-09,
 -1.090338961020540e-10,  2.404917312145110e-12, -4.745637361480165e-14,  8.523530394010905e-16, -1.411444594539048e-17,  2.176453329627244e-19, -3.149424877659739e-21,
  4.452413765992699e-04, -4.847495019060508e-05,  2.837583881379221e-06, -1.176250624293153e-07,  3.855331728212015e-09, -1.059865789417829e-10,  2.534514084971441e-12,
 -5.403503213253508e-14,  1.045321040180981e-15, -1.859309210527611e-17,  3.072001815885835e-19, -4.752280918284457e-21,  2.611443675868760e-04, -3.157417301360838e-05,
  2.037215113155085e-06, -9.250173397195732e-08,  3.303984019738579e-09, -9.855293486317680e-11,  2.547630076143478e-12, -5.852268407788288e-14,  1.216328829834864e-15,
 -2.318360360844137e-17,  4.095071286645528e-19, -6.757926535009502e-21,  1.501562913977616e-04, -2.003891128670152e-05,  1.418302465929239e-06, -7.025764951227777e-08,
  2.725107791019239e-09, -8.792197308309871e-11,  2.449915434425917e-12, -6.047940518534816e-14,  1.347183122556642e-15, -2.745294760949221e-17,  5.172953083399259e-19,
 -9.087930225322144e-21,  8.478407862125949e-05, -1.241873993720980e-05,  9.598452755195816e-07, -5.167386335755761e-08,  2.169202534054397e-09, -7.547162603917431e-11,
  2.260621924569082e-12, -5.982029803821476e-14,  1.424722944735493e-15, -3.097115294657279e-17,  6.212410950166209e-19, -1.159547368206428e-20,  4.709436848451234e-05,
 -7.531661380465953e-06,  6.329817184745979e-07, -3.689889698106051e-08,  1.670987829806702e-09, -6.251104182566361e-11,  2.007379467783083e-12, -5.679876401762591e-14,
  1.443041994545169e-15, -3.339067698031818e-17,  7.115182532078430e-19, -1.408194868542788e-20,  2.578274169129918e-05, -4.480043750291663e-06,  4.077580529762095e-07,
 -2.564785107662548e-08,  1.249054882644322e-09, -5.009930085982788e-11,  1.720284033686175e-12, -5.192147070097017e-14,  1.403981152670084e-15, -3.450637750325709e-17,
  7.795409286416937e-19, -1.632770140253776e-20,  1.393994376606438e-05, -2.619652271188749e-06,  2.572235366826698e-07, -1.739872563502184e-08,  9.084497752613050e-10,
 -3.895978099913959e-11,  1.426831729925048e-12, -4.582742443124261e-14,  1.315970585217013e-15, -3.428170067423235e-17,  8.194325278454180e-19, -1.812926541329652e-20,
  7.458897254010675e-06, -1.509357884227149e-06,  1.592963346733277e-07, -1.154925624176021e-08,  6.446286992376624e-10, -2.947926652249149e-11,  1.148611815755076e-12,
 -3.916662460006900e-14,  1.191757831089519e-15, -3.283813703295683e-17,  8.288603400068438e-19, -1.933336792721122e-20,  3.958415127405944e-06, -8.589576945823195e-07,
  9.709452614547693e-08, -7.521631333708264e-09,  4.474975607629258e-10, -2.176396774519994e-11,  8.999623175379675e-13, -3.250527978247466e-14,  1.045756546902873e-15,
 -3.041572915288219e-17,  8.090933429723885e-19, -1.985938119608817e-20,  2.088292808927866e-06, -4.840077033444414e-07,  5.839854993968121e-08, -4.818968194147933e-09,
  3.047427226148126e-10, -1.572131273039549e-11,  6.882512909944859e-13, -2.627052325859727e-14,  8.916812908030068e-16, -2.731874369380743e-17,  7.643740924510802e-19,
 -1.970589905276385e-20,  1.097766900947757e-06, -2.707249568416623e-07,  3.475113420584086e-08, -3.045464687926620e-09,  2.041424412329518e-10, -1.114241743053279e-11,
  5.151830328337803e-13, -2.073415808393016e-14,  7.408900589579895e-16, -2.386135574357955e-17,  7.008602169013487e-19, -1.894196109996370e-20,  5.764122572358762e-07,
 -1.507009326016281e-07,  2.051404627585794e-08, -1.903677024657113e-09,  1.348935168783327e-10, -7.770011779059187e-12,  3.785175065134696e-13, -1.602609608362252e-14,
  6.015665271836836e-16, -2.032450657624148e-17,  6.254461017781338e-19, -1.768731397435711e-20,  3.030682793837035e-07, -8.370439429812001e-08,  1.204524580482877e-08,
 -1.180216446819257e-09,  8.816758479086604e-11, -5.345959001897080e-12,  2.737370862743244e-13, -1.216482820014045e-14,  4.786410154854526e-16, -1.692939156692731e-17,
  5.447299226719009e-19, -1.608791560579808e-20,  1.599662631129808e-07, -4.651241216348415e-08,  7.053970396821206e-09, -7.276923714823267e-10,  5.715918152056104e-11,
 -3.639107778240915e-12,  1.953928401114679e-13, -9.093320409269628e-15,  3.742215362343176e-16, -1.382765235828650e-17,  4.642868823268857e-19, -1.429256971521048e-20,
  8.497682476420435e-08, -2.592528535867310e-08,  4.131180819220059e-09, -4.474392363994979e-10,  3.685624933013872e-11, -2.457649909784381e-12,  1.380381800266327e-13,
 -6.712130613306739e-15,  2.882809995976026e-16, -1.110473005032898e-17,  3.882949505254405e-19, -1.243479372606853e-20,  4.554657659250082e-08, -1.453280626768551e-08,
  2.426015133774198e-09, -2.750972055849679e-10,  2.370028461630795e-11, -1.651083232631579e-12,  9.677624566821978e-14, -4.905415018062897e-15,  2.193907425597655e-16,
 -8.791352112271639e-18,  3.194704327447576e-19, -1.062172506896385e-20,  2.469301195068374e-08, -8.214129781517142e-09,  1.432259395969042e-09, -1.695667499007476e-10,
  1.523878694221793e-11, -1.106305957069557e-12,  6.750624078656751e-14, -3.558655055812831e-15,  1.653642831354963e-16, -6.878359216981286e-18,  2.592225328468701e-19,
 -8.929862820762240e-21,  1.357370833821192e-08, -4.692832478076420e-09,  8.522089549716910e-10, -1.050481720884783e-10,  9.821789275707292e-12, -7.411771350891292e-13,
  4.696767376005392e-14, -2.568940930701075e-15,  1.237475902881021e-16, -5.331284312075498e-18,  2.079261241939647e-19, -7.406159508839311e-21,  7.582505473838764e-09,
 -2.716336819983908e-09,  5.122592339308414e-10, -6.556222393475342e-11,  6.360543260832869e-12, -4.976471776903180e-13,  3.266901231894638e-14, -1.849565662642421e-15,
  9.214644425832012e-17, -4.102573853119473e-18,  1.652277502086431e-19, -6.072484735949310e-21,  4.313325785124994e-09, -1.596360284081327e-09,  3.117335505566866e-10,
 -4.131102132109536e-11,  4.147486618729014e-12, -3.355740476689577e-13,  2.276446813411962e-14, -1.330827606090878e-15,  6.841337178587790e-17, -3.140624246451569e-18,
  1.303271040562230e-19, -4.931595913579432e-21,  2.503034076907089e-09, -9.542738462907073e-10,  1.924104531266318e-10, -2.632836057693727e-11,  2.728061402858055e-12,
 -2.276686003769399e-13,  1.591957186406511e-14, -9.586575089772226e-16,  5.072957779353588e-17, -2.395691009675433e-18,  1.022037348507577e-19, -3.973201169782099e-21,
  1.483776782451584e-09, -5.810682392601027e-10,  1.206274196574460e-10, -1.699589809422394e-11,  1.812633331005318e-12, -1.556190488019648e-13,  1.118770439074588e-14,
 -6.922500171760997e-16,  3.761760390490204e-17, -1.823204243464359e-18,  7.978025764106250e-20, -3.179243099854780e-21,  8.992061816191638e-10, -3.607099979444490e-10,
  7.687817493874819e-11, -1.112215999804888e-11,  1.217602503657286e-12, -1.072527290708325e-13,  7.907032526362986e-15, -5.014551942194057e-16,  2.791425127548557e-17,
 -1.385184203778655e-18,  6.202699569338883e-20, -2.528010544563745e-21,  5.570817345171255e-10, -2.282800190844518e-10,  4.980844982334890e-11, -7.378302055668402e-12,
  8.268539273182032e-13, -7.452735959555616e-14,  5.619671211949915e-15, -3.643490194276555e-16,  2.072507961868607e-17, -1.050414736318771e-18,  4.801959554467002e-20,
 -1.997027753251384e-21,  3.523603144201218e-10, -1.471010765976295e-10,  3.276470744706668e-11, -4.955646576849507e-12,  5.669234515397685e-13, -5.214559541382267e-14,
  4.010996503378136e-15, -2.651696294943426e-16,  1.537412960972916e-17, -7.939032011641604e-19,  3.696274865705016e-20, -1.564869358247689e-21,  2.268035187612641e-10,
 -9.620696810735016e-11,  2.181311470737595e-11, -3.359074071728505e-12,  3.911846613602930e-13, -3.661777943494487e-14,  2.865515390293621e-15, -1.926645566796788e-16,
  1.135652395214228e-17, -5.960036400034787e-19,  2.819184056348284e-20, -1.212133607588194e-21,  1.475838795784738e-10, -6.344358584873686e-11,  1.460107936554334e-11,
 -2.282738552842583e-12,  2.698573246316218e-13, -2.563666367587142e-14,  2.035509333094269e-15, -1.388192794637871e-16,  8.297465577683101e-18, -4.414439175570727e-19,
  2.116178752009135e-20, -9.218141248473799e-22,  9.583511563014910e-11, -4.164316157427000e-11,  9.700456644192615e-12, -1.535284539408103e-12,  1.837183455397828e-13,
 -1.766394212492921e-14,  1.419104363133127e-15, -9.790556337590696e-17,  5.918593507744114e-18, -3.183926343861218e-19,  1.542957683213223e-20, -6.792773555708797e-22,
  6.044487105641435e-11, -2.648124974496727e-11,  6.225913400484310e-12, -9.946651168912895e-13,  1.201404559732594e-13, -1.165775453172905e-14,  9.450659176674639e-16,
 -6.578103705322904e-17,  4.011259337528921e-18, -2.176292054836185e-19,  1.063466226926500e-20, -4.720049807631751e-22,  3.463236590539864e-11, -1.525878895317471e-11,
  3.610483878884887e-12, -5.805830878832561e-13,  7.058027915750684e-14, -6.892486994187610e-15,  5.622663040722597e-16, -3.937748965096433e-17,  2.415697400901922e-18,
 -1.318379197157199e-19,  6.479708299714162e-21, -2.892194604318670e-22,  1.403022364594552e-11, -6.201077584168956e-12,  1.472509991830289e-12, -2.376448619907488e-13,
  2.899403788687088e-14, -2.841454869942602e-15,  2.326053998495686e-16, -1.634594915082590e-17,  1.006143031641498e-18, -5.509131604988985e-20,  2.716405342117945e-21,
 -1.216269766934980e-22,  5.845230880822373e-02, -1.415636148077312e-04,  3.556277710360471e-07, -9.207086073203312e-10,  2.438236783582084e-12, -6.559195424619892e-15,
  1.782067954290815e-17, -4.868983237943128e-20,  1.333601961172687e-22, -3.654397525365159e-25,  1.000434904557203e-27, -2.734109321607550e-30,  5.634582226325836e-02,
 -1.749551137556550e-04,  6.391082715383452e-07, -2.419478985262866e-09,  9.064000896900065e-12, -3.325822729499749e-14,  1.195485895833635e-16, -4.220039572170712e-19,
  1.466481497402176e-21, -5.026951267761784e-24,  1.702525849256611e-26, -5.704177637015994e-29,  5.236181449575834e-02, -2.341242286758676e-04,  1.216591306351447e-06,
 -6.042834288643268e-09,  2.843932812210256e-11, -1.282382077943213e-13,  5.589306024268929e-16, -2.368793415194218e-18,  9.802705264697663e-21, -3.973483090281448e-23,
  1.581464247657643e-25, -6.192275226276752e-28,  4.691659131732689e-02, -3.059183920709632e-04,  2.088140371827696e-06, -1.284780474606397e-08,  7.325770828486780e-11,
 -3.948203786379803e-13,  2.034956862673127e-15, -1.010862676964304e-17,  4.866690752195914e-20, -2.280378831301677e-22,  1.043360643106437e-24, -4.673508951424474e-27,
  4.054116370170569e-02, -3.750992181788765e-04,  3.214165983633629e-06, -2.394267162260016e-08,  1.624881362314962e-10, -1.029080750537850e-12,  6.170139427578504e-15,
 -3.536452201791811e-17,  1.951163833238860e-19, -1.041695972003531e-21,  5.403380560099670e-24, -2.731821017268060e-26,  3.379534880843270e-02, -4.280596144566621e-04,
  4.496202178546194e-06, -3.998131775021996e-08,  3.186915694090761e-10, -2.341982215959665e-12,  1.614123730153228e-14, -1.055461219653202e-16,  6.602081577245545e-19,
 -3.974883897967987e-21,  2.314379950005770e-23, -1.308074986348763e-25,  2.718791806121812e-02, -4.557059934449606e-04,  5.781023787452544e-06, -6.067456989122474e-08,
  5.620146987165188e-10, -4.745193102828889e-12,  3.724874936276854e-14, -2.754689750715204e-16,  1.937445069653869e-18, -1.305049880972975e-20,  8.464689854311603e-23,
 -5.309105097941960e-25,  2.111814202443122e-02, -4.548053029506279e-04,  6.889537237483093e-06, -8.451615634724051e-08,  9.017032102741443e-10, -8.676816035796024e-12,
  7.699639968115774e-14, -6.394788420992882e-16,  5.023357602181641e-18, -3.761548680849673e-20,  2.701179209038291e-22, -1.868952368039162e-24,  1.584654598810604e-02,
 -4.276795221779280e-04,  7.659683168922145e-06, -1.088846608903723e-07,  1.327969138877031e-09, -1.446463745955240e-11,  1.441871895811695e-13, -1.336917733162977e-15,
  1.166398741952662e-17, -9.657602013082314e-20,  7.638842474068671e-22, -5.801709569407656e-24,  1.149444720726114e-02, -3.806511199606879e-04,  7.986466601648733e-06,
 -1.305473009973411e-07,  1.808011035281346e-09, -2.215925605649497e-11,  2.467762774799927e-13, -2.541443234442261e-15,  2.450741301230341e-17, -2.233419485412171e-19,
  1.937247700109879e-21, -1.608250102498411e-23,  8.065469640810738e-03, -3.219244641221756e-04,  7.844521291352217e-06, -1.464190016356324e-07,  2.289037257379568e-09,
 -3.140029429064261e-11,  3.887764574675676e-13, -4.427022058011354e-15,  4.698443062693791e-17, -4.693759183732403e-19,  4.447468706118341e-21, -4.020748894195055e-23,
  5.479137768294236e-03, -2.595837249693012e-04,  7.287022309559992e-06, -1.543147102647380e-07,  2.708461588472086e-09, -4.138443190486523e-11,  5.671726524448190e-13,
 -7.112052746207151e-15,  8.275685882169895e-17, -9.030120302613663e-19,  9.314588040831930e-21, -9.139961486990225e-23,  3.606860643616290e-03, -2.001710980958536e-04,
  6.424397925899480e-06, -1.534366172768590e-07,  3.008313743923130e-09, -5.097372847319341e-11,  7.701782532474372e-13, -1.059561755199242e-14,  1.347077285241203e-16,
 -1.600213541737793e-18,  1.791296238350135e-20, -1.902097676516993e-22,  2.303121255283074e-03, -1.480131231116144e-04,  5.392706777588570e-06, -1.444541707337340e-07,
  3.148985743018885e-09, -5.892704459570222e-11,  9.779325182481256e-13, -1.470988373123530e-14,  2.036767025340321e-16, -2.626094897567963e-18,  3.181061011303512e-20,
 -3.645261534126969e-22,  1.428084342101404e-03, -1.052098688851795e-04,  4.322806693882213e-06, -1.291978594401281e-07,  3.117710608508989e-09, -6.418367890195105e-11,
  1.165884432171569e-12, -1.911306339346962e-14,  2.873638311936892e-16, -4.010186189982207e-18,  5.242523131797789e-20, -6.466689275149172e-22,  8.609242776905139e-04,
 -7.205932552725155e-05,  3.318386864992215e-06, -1.101178171589246e-07,  2.929405718444950e-09, -6.610462009915125e-11,  1.310005520521084e-12, -2.333526192724546e-14,
  3.798966335240418e-16, -5.722892561698603e-18,  8.054156850963651e-20, -1.066867888863133e-21,  5.052672566198027e-04, -4.766310069960084e-05,  2.445985099635964e-06,
 -8.970608218419086e-08,  2.620483553517389e-09, -6.459464159540475e-11,  1.392176951465790e-12, -2.686929631860803e-14,  4.723945577961128e-16, -7.662809171977994e-18,
  1.158229013610805e-19, -1.643822709894901e-21,  2.890956970617142e-04, -3.051356199550067e-05,  1.735692023903030e-06, -7.004617198811838e-08,  2.238521567038064e-09,
 -6.007696517536763e-11,  1.404009839631208e-12, -2.927978950118003e-14,  5.545104749285605e-16, -9.662534254478668e-18,  1.565022745136064e-19, -2.374753764517574e-21,
  1.615083769973606e-04, -1.894854446864196e-05,  1.188741706187938e-06, -5.257122677223259e-08,  1.831454928320765e-09, -5.334626235492639e-11,  1.348001208559487e-12,
 -3.029596007803719e-14,  6.165390622256567e-16, -1.151452927119398e-17,  1.994156655440761e-19, -3.228490942452089e-21,  8.824719085866155e-05, -1.143905440699228e-05,
  7.877557905901788e-07, -3.802730491135332e-08,  1.439245521973994e-09, -4.536134866087946e-11,  1.235950323105734e-12, -2.986017158066222e-14,  6.514469706969534e-16,
 -1.301093595366716e-17,  2.404346279114276e-19, -4.144907437065461e-21,  4.724223607097260e-05, -6.728357051894429e-06,  5.063812969354902e-07, -2.658272147450866e-08,
  1.089453472965617e-09, -3.704515925150596e-11,  1.085470976645320e-12, -2.812157551124261e-14,  6.562112959265365e-16, -1.398568430725056e-17,  2.752103694540828e-19,
 -5.042189709829942e-21,  2.482605310241207e-05, -3.864803631334592e-06,  3.165526536606046e-07, -1.800659104877215e-08,  7.966019074467599e-10, -2.914099563251904e-11,
  9.158794713807896e-13, -2.538345479418362e-14,  6.321243252844086e-16, -1.434634688089695e-17,  3.000212468701525e-19, -5.830697009950618e-21,  1.283245207262412e-05,
 -2.173038287712270e-06,  1.929350574707560e-07, -1.185139906052210e-08,  5.642303949720518e-10, -2.214435575551446e-11,  7.446413436686326e-13, -2.202591303372258e-14,
  5.840943559759324e-16, -1.408723121597483e-17,  3.124769263647963e-19, -6.429714311181800e-21,  6.538325058299362e-06, -1.198898197565718e-06,  1.149496101867862e-07,
 -7.599825983046948e-09,  3.882252574780128e-10, -1.630297249836595e-11,  5.850955835893664e-13, -1.842847735218666e-14,  5.192783814586924e-16, -1.328201917240387e-17,
  3.118895022479889e-19, -6.782352273223535e-21,  3.291250363477617e-06, -6.506687597854325e-07,  6.712632666948622e-08, -4.761456030197105e-09,  2.602338240284399e-10,
 -1.166221382915141e-11,  4.456164390457101e-13, -1.491128839066057e-14,  4.455155094326780e-16, -1.206073614729343e-17,  2.992432330395656e-19, -6.864611392999602e-21,
  1.640691025918295e-06, -3.482763471584136e-07,  3.852577170979398e-08, -2.922830404469603e-09,  1.704319237515537e-10, -8.129815210086166e-12,  3.299436160068950e-13,
 -1.170336268603178e-14,  3.699793236078917e-16, -1.057952918358690e-17,  2.768238436164073e-19, -6.686754227352742e-21,  8.119834920149335e-07, -1.843462374174940e-07,
  2.179186496387429e-08, -1.762957512954244e-09,  1.093744935685079e-10, -5.539271231918047e-12,  2.382098939946836e-13, -8.936756124533036e-15,  2.982989630066549e-16,
 -8.991886321125528e-18,  2.476551120615568e-19, -6.287622040135903e-21,  3.999918530922117e-07, -9.675778362421702e-08,  1.218318317310389e-08, -1.047906277177538e-09,
  6.898366545564807e-11, -3.699952610733203e-12,  1.682006379832871e-13, -6.659357304053514e-15,  2.342046593762187e-16, -7.427376237738820e-18,  2.149120751613907e-19,
 -5.724400587367829e-21,  1.966569534802792e-07, -5.050176190669805e-08,  6.751723558157832e-09, -6.156491706577478e-10,  4.288883011278233e-11, -2.430088676919052e-12,
  1.165084971432464e-13, -4.857157792381333e-15,  1.796058583412375e-16, -5.980359595482548e-18,  1.814450628014702e-19, -5.061045198084501e-21,  9.676720006337649e-08,
 -2.628766912355376e-08,  3.719992980899715e-09, -3.585742507635544e-10,  2.636483315462022e-11, -1.574165048449269e-12,  7.940898407826609e-14, -3.478135448522410e-15,
  1.349391709838001e-16, -4.707935312783511e-18,  1.494843291579054e-19, -4.358155833130523e-21,  4.779060546048108e-08, -1.368675784624787e-08,  2.043834097451518e-09,
 -2.076711624938710e-10,  1.607354338227596e-11, -1.008798914854389e-12,  5.341766275505043e-14, -2.452676993642030e-15,  9.962197586985783e-17, -3.634478213522475e-18,
  1.205308530334163e-19, -3.665991638484287e-21,  2.375778002748679e-08, -7.148973210711085e-09,  1.123146035425308e-09, -1.199624104511362e-10,  9.748267838594028e-12,
 -6.415145590608045e-13,  3.557287062402063e-14, -1.708326233667071e-15,  7.248833460998840e-17, -2.759599213323936e-18,  9.539449064574813e-20, -3.021082185886647e-21,
  1.192279935848326e-08, -3.757296323462817e-09,  6.191885862124338e-10, -6.932674615505179e-11,  5.899113265827923e-12, -4.060365895053002e-13,  2.352190241046979e-14,
 -1.178765747400651e-15,  5.213790625823224e-17, -2.066828481105203e-18,  7.432199366460834e-20, -2.445942104760882e-21,  6.057748487933786e-09, -1.992866397977730e-09,
  3.434781616626190e-10, -4.020116629863115e-11,  3.572575846711109e-12, -2.565457349023091e-13,  1.548883696714740e-14, -8.081100326720388e-16,  3.717547173412017e-17,
 -1.531248945219017e-18,  5.715988477607572e-20, -1.950901007484349e-21,  3.124848510403390e-09, -1.069803515442090e-09,  1.922758263512342e-10, -2.345944492476621e-11,
  2.171522726512745e-12, -1.622736469884939e-13,  1.018562180151001e-14, -5.519682072452946e-16,  2.634960866595372e-17, -1.125250575936865e-18,  4.351162043452674e-20,
 -1.536986602018328e-21,  1.640983363593907e-09, -5.828430307651193e-10,  1.089188887110302e-10, -1.381459472240451e-11,  1.328394165434663e-12, -1.030371851739516e-13,
  6.707226352809025e-15, -3.766218954647965e-16,  1.861381993804161e-17, -8.222880693234670e-19,  3.286607204906104e-20, -1.198998243082327e-21,  8.794835565826928e-10,
 -3.230992588978535e-10,  6.259682241706644e-11, -8.230226832978617e-12,  8.199181552818218e-13, -6.584004263186656e-14,  4.433594344062164e-15, -2.573342507617933e-16,
  1.313630970343703e-17, -5.989383639846612e-19,  2.468934175849929e-20, -9.282165575490968e-22,  4.821349357458525e-10, -1.826622386442081e-10,  3.658173830766879e-11,
 -4.971913906098298e-12,  5.117616592380442e-13, -4.243202634477504e-14,  2.948263817373643e-15, -1.764455300533923e-16,  9.280848608536808e-18, -4.357144994510233e-19,
  1.848189286815212e-20, -7.144896955675959e-22,  2.708444320808830e-10, -1.055126544183133e-10,  2.177975891067738e-11, -3.051254249572205e-12,  3.236012896620829e-13,
 -2.762996223913903e-14,  1.975745758516016e-15, -1.216134923593606e-16,  6.574978290776450e-18, -3.170863417568494e-19,  1.380797228596924e-20, -5.476550324726909e-22,
  1.561070455181085e-10, -6.235399678343501e-11,  1.322749475159957e-11, -1.904695435537094e-12,  2.075550554695690e-13, -1.819986658401571e-14,  1.335826095432624e-15,
 -8.435106384905861e-17,  4.675754967602835e-18, -2.310708533254736e-19,  1.030561223937297e-20, -4.183829294795443e-22,  9.235297854444542e-11, -3.771563786945409e-11,
  8.198392487289311e-12, -1.209888976485121e-12,  1.350837616371143e-13, -1.213128578726626e-14,  9.114935910302108e-16, -5.889084957455734e-17,  3.338487910222211e-18,
 -1.686448879297229e-19,  7.684653886400713e-21, -3.185816147843507e-22,  5.603133048213684e-11, -2.333025110293017e-11,  5.181394360797918e-12, -7.813906215097724e-13,
  8.913236703012757e-14, -8.175143483019234e-15,  6.270804065122533e-16, -4.134427000237379e-17,  2.390728098564447e-18, -1.231352791453654e-19,  5.718487789621916e-21,
 -2.415049119184934e-22,  3.476349233132868e-11, -1.471753401358222e-11,  3.329699094197975e-12, -5.116311867293298e-13,  5.945386104744619e-14, -5.553515764355619e-15,
  4.336863526176034e-16, -2.909992689087431e-17,  1.711877761991643e-18, -8.966718252746813e-20,  4.233358197971890e-21, -1.816814309794286e-22,  2.191891408481532e-11,
 -9.409650648023315e-12,  2.162248361601552e-12, -3.375237455854742e-13,  3.983976641956062e-14, -3.779113884262891e-15,  2.996130281689708e-16, -2.040376729353077e-17,
  1.217847816313021e-18, -6.470293853003376e-20,  3.097529391811865e-21, -1.347522805258843e-22,  1.386846478933533e-11, -6.020850541224975e-12,  1.401097760229595e-12,
 -2.215244482028684e-13,  2.648169943077271e-14, -2.543599095066260e-15,  2.041509638506409e-16, -1.407114273929050e-17,  8.498345157352477e-19, -4.567532455762813e-20,
  2.211486183737330e-21, -9.727442733624606e-23,  8.572787449433070e-12, -3.753782916116274e-12,  8.820069023041758e-13, -1.408251243426855e-13,  1.699921455453214e-14,
 -1.648521922973461e-15,  1.335632063743885e-16, -9.291275537535968e-18,  5.662527504996760e-19, -3.070483650132072e-20,  1.499610113538694e-21, -6.652301086001319e-23,
  4.843196445595740e-12, -2.133279354609268e-12,  5.046083580058119e-13, -8.111707263149380e-14,  9.858044282815760e-15, -9.623754935313075e-16,  7.848270976062681e-17,
 -5.494720322939136e-18,  3.369830856819405e-19, -1.838553625155842e-20,  9.033669036643392e-22, -4.030989861817080e-23,  1.946682196490713e-12, -8.602734273954579e-13,
  2.042480072218806e-13, -3.295767558732333e-14,  4.020363768338102e-15, -3.939366588771554e-16,  3.224297634505544e-17, -2.265457866742442e-18,  1.394238107088448e-19,
 -7.632953864004781e-21,  3.763026047102344e-22, -1.684638839614522e-23,  5.789167534280094e-02, -1.387621332734559e-04,  3.448090834390281e-07, -8.827235068891682e-10,
  2.311221851278678e-12, -6.147388554372568e-15,  1.651518557557865e-17, -4.462530519991522e-20,  1.208966175287902e-22, -3.277267091134300e-25,  8.876474137709662e-28,
 -2.400337822946595e-30,  5.565604707535629e-02, -1.699559667256521e-04,  6.109232115924345e-07, -2.279624320089390e-09,  8.426597620277639e-12, -3.052571431359652e-14,
  1.083631660345849e-16, -3.778453920819514e-19,  1.297188083985110e-21, -4.393575551834726e-24,  1.470433439906872e-26, -4.868887653603996e-29,  5.144433445609459e-02,
 -2.246740090699036e-04,  1.146725133975202e-06, -5.607616236128380e-09,  2.600351262630261e-11, -1.155856207143535e-13,  4.967893592010268e-16, -2.076824559388090e-18,
  8.479845772021045e-21, -3.392176341328921e-23,  1.332645425624786e-25, -5.151420921333184e-28,  4.572537892272096e-02, -2.898106209795645e-04,  1.940747213547743e-06,
 -1.173629225278543e-08,  6.582764230949688e-11, -3.492092401153822e-13,  1.772539126120980e-15, -8.674966315136051e-18,  4.116173049730746e-20, -1.901417250288406e-22,
  8.578761334998281e-25, -3.790085706349876e-27,  3.909043423872083e-02, -3.504924553253699e-04,  2.941798764329313e-06, -2.149979290749504e-08,  1.433106524906297e-10,
 -8.922075586094294e-13,  5.261991616885613e-15, -2.968134232599451e-17,  1.612325850255415e-19, -8.478091779144434e-22,  4.332658326238153e-24, -2.158691689821734e-26,
  3.215212885592184e-02, -3.939258440576175e-04,  4.045540582885877e-06, -3.523688510208852e-08,  2.754982427266778e-10, -1.987794805600348e-12,  1.346141856858282e-14,
 -8.654100137119858e-17,  5.324763392757873e-19, -3.154751027426084e-21,  1.808228655428046e-23, -1.006392824105353e-25,  2.545318588723433e-02, -4.122242241506687e-04,
  5.103900997337967e-06, -5.239549500003910e-08,  4.754602192723043e-10, -3.937186723935318e-12,  3.033737129423215e-14, -2.203774458003854e-16,  1.523333879828037e-18,
 -1.008951296902307e-20,  6.437391009744875e-23, -3.973133765602745e-25,  1.940305983260981e-02, -4.035130826796805e-04,  5.956489522734089e-06, -7.138256860496890e-08,
  7.452845135596711e-10, -7.026783356346010e-12,  6.115186637530653e-14, -4.984634723295937e-16,  3.845370502715140e-18, -2.829282870457351e-20,  1.997224137657440e-22,
 -1.358971515585050e-24,  1.425059001411394e-02, -3.712881378816563e-04,  6.471581626517927e-06, -8.977548437627544e-08,  1.070454259949432e-09, -1.141418568832236e-11,
  1.114956092994103e-13, -1.013866304599961e-15,  8.680804354256534e-18, -7.057776973787538e-20,  5.484384498804237e-22, -4.094012902081136e-24,  1.009035696173157e-02,
 -3.225655839329751e-04,  6.579822855564029e-06, -1.048654994743822e-07,  1.418716538430705e-09, -1.700885844212453e-11,  1.854855732538822e-13, -1.872178126352564e-15,
  1.770662962669236e-17, -1.583604713441268e-19,  1.348750303639746e-21, -1.099956763705613e-23,  6.892976252878028e-03, -2.656184199531616e-04,  6.288050635117338e-06,
 -1.143507652814359e-07,  1.745113234714120e-09, -2.340170935510616e-11,  2.835547063626134e-13, -3.162732902806842e-15,  3.290384545409357e-17, -3.224309106611495e-19,
  2.998455002160468e-21, -2.661821196832234e-23,  4.546630089791349e-03, -2.080163658245693e-04,  5.670167281411890e-06, -1.169239246288706e-07,  2.002192118267909e-09,
 -2.989033825893027e-11,  4.006935862309178e-13, -4.919255705279811e-15,  5.608626756734073e-17, -6.000504439216017e-19,  6.072348535406585e-21, -5.848786506785881e-23,
  2.898366124741946e-03, -1.553940335237148e-04,  4.841311297748845e-06, -1.125478243948922e-07,  2.151959415454715e-09, -3.561113735683969e-11,  5.260882122987598e-13,
 -7.083279014825132e-15,  8.820468009807655e-17, -1.027001830920086e-18,  1.127512338703832e-20, -1.174859864439585e-22,  1.787474323601502e-03, -1.110306740989354e-04,
  3.926445283070180e-06, -1.023513279635004e-07,  2.175251902773281e-09, -3.974198366713762e-11,  6.446749049825336e-13, -9.487586113793144e-15,  1.286349461672772e-16,
 -1.625208773244551e-18,  1.930302770334695e-20, -2.170115918397741e-22,  1.067670737873692e-03, -7.606941008209298e-05,  3.033840440332582e-06, -8.822840311489592e-08,
  2.075353638558979e-09, -4.170552792293026e-11,  7.403465456071894e-13, -1.187241100859599e-14,  1.747549237247038e-16, -2.389267943442873e-18,  3.062119837002950e-20,
 -3.705074756683068e-22,  6.184173753224598e-04, -5.009147852151785e-05,  2.239548008235788e-06, -7.231549124490046e-08,  1.875156154753647e-09, -4.130164668813466e-11,
  7.997915498191294e-13, -1.393479138621890e-14,  2.220737159128807e-16, -3.277233469144682e-18,  4.521195484490228e-20, -5.874090672693595e-22,  3.478232163691483e-04,
 -3.177588523927504e-05,  1.583695143740181e-06, -5.652612898120684e-08,  1.609626147851320e-09, -3.872841500729840e-11,  8.156369164208091e-13, -1.539707477796372e-14,
  2.649864261245070e-16, -4.210747888454372e-18,  6.238789230364071e-20, -8.684661257390077e-22,  1.902416656918683e-04, -1.946203688194819e-05,  1.075632788466786e-06,
 -4.225771088016122e-08,  1.316679259369208e-09, -3.449642447381867e-11,  7.878602884698665e-13, -1.607170014372875e-14,  2.979688241863496e-16, -5.086655856410496e-18,
  8.076501350975394e-20, -1.202098983644498e-21,  1.013478416111298e-04, -1.153482454936060e-05,  7.034908691415791e-07, -3.029827894915348e-08,  1.029415599881890e-09,
 -2.927843400115282e-11,  7.231569514708264e-13, -1.590070829343759e-14,  3.168305752823685e-16, -5.797701296429488e-18,  9.844423329540543e-20, -1.563537895235357e-21,
  5.267841052843221e-05, -6.630578840449255e-06,  4.441922623834190e-07, -2.089235619668303e-08,  7.714774252721301e-10, -2.375024935280121e-11,  6.327144090681317e-13,
 -1.495897001811850e-14,  3.196151602509281e-16, -6.256014819452037e-18,  1.133707078331805e-19, -1.917728043920989e-21,  2.676488147991905e-05, -3.705232879615660e-06,
  2.714710225310822e-07, -1.389355328100477e-08,  5.558182829385150e-10, -1.846863898825707e-11,  5.293117046392282e-13, -1.342413925840243e-14,  3.068806669331714e-16,
 -6.411838726297087e-18,  1.237668589759678e-19, -2.225609986804372e-21,  1.331916467308339e-05, -2.017609731005709e-06,  1.610098177056194e-07, -8.935127087355263e-09,
  3.860773398252794e-10, -1.380832792771649e-11,  4.246861808402535e-13, -1.152713551729652e-14,  2.813373529963177e-16, -6.261884430742390e-18,  1.285034668969660e-19,
 -2.452034657299366e-21,  6.505680151053670e-06, -1.073210366222754e-06,  9.292143986712569e-08, -5.572736674123524e-09,  2.593044670164053e-10, -9.955931343072772e-12,
  3.277922224540945e-13, -9.500552432406290e-15,  2.470366610242229e-16, -5.845766463066691e-18,  1.272983831200192e-19, -2.572902477850028e-21,  3.126071689363113e-06,
 -5.590704359123020e-07,  5.232393011389858e-08, -3.380304521643499e-09,  1.688948994817145e-10, -6.943230400608081e-12,  2.441340862832295e-13, -7.538949737493966e-15,
  2.084141154118871e-16, -5.233096608644694e-18,  1.206994267580167e-19, -2.579434766528662e-21,  1.481302661870679e-06, -2.859784448674272e-07,  2.882865152423073e-08,
 -1.999986623916481e-09,  1.070015957976591e-10, -4.697851159895272e-12,  1.759921002971750e-13, -5.777705883491366e-15,  1.694657639171287e-16, -4.506315049712062e-18,
  1.098834074443784e-19, -2.478592554886678e-21,  6.939636557786927e-07, -1.440396164641010e-07,  1.558627833708589e-08, -1.157646118452937e-09,  6.613801896434561e-11,
 -3.093378734709215e-12,  1.231809243063175e-13, -4.289843841982986e-15,  1.332263907814654e-16, -3.744532086305952e-18,  9.635476723962853e-20, -2.290000041017332e-21,
  3.222901928567188e-07, -7.164007678899188e-08,  8.293676845939413e-09, -6.575472110335175e-10,  4.000788802135450e-11, -1.988488765603447e-12,  8.397454539598754e-14,
 -3.095579181227326e-15,  1.015843193958923e-16, -3.012043416856539e-18,  8.163967677873779e-20, -2.040730769978034e-21,  1.487996437010103e-07, -3.528950491905282e-08,
  4.356815812850302e-09, -3.676526276902551e-10,  2.376004604635077e-11, -1.251850793058489e-12,  5.593626428521945e-14, -2.177936969940147e-15,  7.536645254167036e-17,
 -2.352858525548096e-18,  6.704935212455896e-20, -1.759657333893842e-21,  6.849865548582924e-08, -1.726971145544784e-08,  2.266609698959104e-09, -2.030003386363728e-10,
  1.389813932081211e-11, -7.743321925826590e-13,  3.652477869543841e-14, -1.498841934791780e-15,  5.458126722486357e-17, -1.790579639501775e-18,  5.354726773431451e-20,
 -1.472779734399898e-21,  3.153676384700554e-08, -8.422673493414706e-09,  1.171580079545707e-09, -1.110508319684114e-10,  8.033387518219562e-12, -4.721433163134475e-13,
  2.345599175765213e-14, -1.012258359349132e-15,  3.871087493767314e-17, -1.331847551423260e-18,  4.171748784468752e-20, -1.200304768810851e-21,  1.456726986782105e-08,
 -4.107244675438074e-09,  6.036513591410326e-10, -6.038854083570627e-11,  4.603819312077987e-12, -2.847310335736710e-13,  1.486375796721533e-14, -6.730997861846321e-16,
  2.697506849122005e-17, -9.713640655418419e-19,  3.180729538250689e-20, -9.555739063153676e-22,  6.772799161384460e-09, -2.009203581957342e-09,  3.110799329659997e-10,
 -3.275317666002580e-11,  2.624659762674568e-12, -1.703971040329929e-13,  9.325128057908580e-15, -4.421308695019313e-16,  1.852887678218072e-17, -6.969112664999266e-19,
  2.380936571029271e-20, -7.454586552209147e-22,  3.179874605825560e-09, -9.892875536201893e-10,  1.608765729476550e-10, -1.777802788269310e-11,  1.493563098668114e-12,
 -1.015331263569195e-13,  5.811279768085734e-15, -2.878261374809266e-16,  1.258637569926820e-17, -4.934361637016382e-19,  1.755304658193044e-20, -5.716377767208841e-22,
  1.512622092178093e-09, -4.919257204795317e-10,  8.377386721679171e-11, -9.689534504274978e-12,  8.511773835577986e-13, -6.043794023308761e-14,  3.609132137326768e-15,
 -1.863045949055268e-16,  8.482117578582205e-18, -3.458670311866449e-19,  1.278457348113286e-20, -4.321954228932365e-22,  7.313759508988201e-10, -2.478503946928721e-10,
  4.407144039419669e-11, -5.320396954392985e-12,  4.873986948701001e-13, -3.605580062352437e-14,  2.240978130319437e-15, -1.202821322650589e-16,  5.688647517601805e-18,
 -2.407348120055027e-19,  9.226834658503461e-21, -3.231331229584889e-22,  3.605876843186372e-10, -1.269358971062683e-10,  2.349799292725606e-11, -2.952505019002869e-12,
  2.813110315405600e-13, -2.162507475262400e-14,  1.395436665786891e-15, -7.769180710772982e-17,  3.808064384787206e-18, -1.668727904828861e-19,  6.617478896538150e-21,
 -2.395743891780370e-22,  1.818184505252197e-10, -6.628278903840384e-11,  1.273631069175902e-11, -1.660911982952960e-12,  1.641404494440752e-13, -1.307755420466617e-14,
  8.739135277869371e-16, -5.034669000578220e-17,  2.551471228552688e-18, -1.155112477330874e-19,  4.728842570286363e-21, -1.765955574022773e-22,  9.401630053253570e-11,
 -3.538656665086389e-11,  7.037064889781921e-12, -9.497189205382279e-13,  9.708157048075960e-14, -7.995163261791961e-15,  5.518682652223595e-16, -3.281608197621980e-17,
  1.715304407482339e-18, -8.003901846785507e-20,  3.374887000588293e-21, -1.297155907321599e-22,  4.997069504598306e-11, -1.936082295443537e-11,  3.972786555951834e-12,
 -5.532772519972806e-13,  5.833625333457785e-14, -4.952526668187061e-15,  3.521715335673808e-16, -2.155960646771534e-17,  1.159439022991011e-18, -5.562667221372206e-20,
  2.410145988351367e-21, -9.512348876673148e-23,  2.734837349348742e-11, -1.087502750657901e-11,  2.295733143039605e-12, -3.289588850812390e-13,  3.567413240157246e-14,
 -3.113404528613837e-15,  2.274634243383857e-16, -1.429863377074931e-17,  7.891250225861979e-19, -3.883079271456686e-20,  1.724597395658295e-21, -6.973000078965138e-23,
  1.542547570744080e-11, -6.277125519246857e-12,  1.359144037279637e-12, -1.997890151115765e-13,  2.221989946014352e-14, -1.987888931666036e-15,  1.488065927982973e-16,
 -9.579384098434964e-18,  5.411263447210508e-19, -2.724071396596970e-20,  1.237093685657450e-21, -5.111769355908799e-23,  8.963290406693395e-12, -3.721865960193694e-12,
  8.240726303492598e-13, -1.238955047587401e-13,  1.408990873180484e-14, -1.288482767769571e-15,  9.854736345147462e-17, -6.478950443369116e-18,  3.736079782569704e-19,
 -1.919083215308522e-20,  8.888859321568634e-22, -3.744336057974961e-23,  5.352693587764936e-12, -2.261506584878567e-12,  5.104835325167000e-13, -7.825986438517044e-14,
  9.073587574617199e-15, -8.456719302990876e-16,  6.589690606906817e-17, -4.412226239150011e-18,  2.590219722741219e-19, -1.353993350175785e-20,  6.379813504991461e-22,
 -2.732726224490840e-23,  3.266039298891845e-12, -1.400079096341524e-12,  3.212089170756950e-13, -5.005897418184236e-14,  5.899258575876273e-15, -5.587093074605097e-16,
  4.422684287055117e-17, -3.007319801441815e-18,  1.792342957311596e-19, -9.508798934927524e-21,  4.545745987167235e-22, -1.974830439783630e-23,  2.011324839522211e-12,
 -8.723752575751687e-13,  2.027940546519948e-13, -3.202905032054010e-14,  3.824795520818686e-15, -3.669937278210455e-16,  2.942509771902775e-17, -2.026103876618959e-18,
  1.222480812985899e-19, -6.564083829422776e-21,  3.175198023065486e-22, -1.395370904174155e-23,  1.217470262965325e-12, -5.327982552756494e-13,  1.251099553882648e-13,
 -1.996283928888213e-14,  2.408216118528568e-15, -2.333941387407518e-16,  1.889799077566547e-17, -1.313841531499253e-18,  8.002435663808695e-20, -4.336788465385632e-21,
  2.116872485807166e-22, -9.385319081378578e-24,  6.777773756525568e-13, -2.984526173097981e-13,  7.057287113312412e-14, -1.134093187578604e-14,  1.377783821158018e-15,
 -1.344592024501839e-16,  1.096169912151367e-17, -7.672021789331737e-19,  4.703652077646378e-20, -2.565480733506816e-21,  1.260156548943040e-22, -5.621377555494267e-24,
  2.701956451397261e-13, -1.193869379498286e-13,  2.834041867211783e-14, -4.572265479936343e-15,  5.576562785583287e-16, -5.463293583615720e-17,  4.470858364394859e-18,
 -3.140799970087094e-19,  1.932638579623496e-20, -1.057880637226810e-21,  5.214498217272047e-23, -2.334073415269385e-24,  5.734207754341916e-02, -1.360454118881225e-04,
  3.344342899956189e-07, -8.467064207405196e-10,  2.192138728468643e-12, -5.765591702456277e-15,  1.531811274363794e-17, -4.093873262210714e-20,  1.097129187480843e-22,
 -2.942447583792238e-25,  7.885628145433362e-28, -2.110169653882729e-30,  5.498582790416587e-02, -1.651757564642794e-04,  5.843569742481047e-07, -2.149545081417502e-09,
  7.841257176629764e-12, -2.804740593909810e-14,  9.834164299016940e-17, -3.387566146656512e-19,  1.149110036130216e-21, -3.846085783534709e-24,  1.272150344887916e-26,
 -4.163522785637423e-29,  5.056356960202456e-02, -2.157624721993134e-04,  1.081855835557195e-06, -5.209425153900447e-09,  2.380647323372835e-11, -1.043309186825695e-13,
  4.422607438735272e-16, -1.824022358649761e-18,  7.349392862472335e-21, -2.901809808087950e-23,  1.125417717088422e-25, -4.295431575846370e-28,  4.459632103243682e-02,
 -2.748305963611139e-04,  1.806007949903653e-06, -1.073669204983131e-08,  5.924993530167287e-11, -3.094403448743539e-13,  1.547096871822709e-15, -7.461002582785438e-18,
  3.489613041695030e-20, -1.589422501900908e-22,  7.072483724307433e-25, -3.082309105051939e-27,  3.773395251118902e-02, -3.279523877101915e-04,  2.696991694156432e-06,
 -1.934298646696597e-08,  1.266649596749134e-10, -7.753367238893928e-13,  4.498786016436816e-15, -2.497856222210701e-17,  1.336149259941418e-19, -6.921026240055925e-22,
  3.485205273241166e-24, -1.711518848038600e-26,  3.063857807236938e-02, -3.631808657144814e-04,  3.647888538871237e-06, -3.113019722366595e-08,  2.387863351951607e-10,
 -1.691973257013120e-12,  1.126069367576554e-14, -7.118752115576671e-17,  4.309237709687333e-19, -2.512822006408618e-21,  1.418079575706971e-23, -7.773223185225763e-26,
  2.388214434709363e-02, -3.737844122857751e-04,  4.518323337273894e-06, -4.538052445678283e-08,  4.035247438105250e-10, -3.277946920210851e-12,  2.479800648709544e-14,
 -1.769776375586134e-16,  1.202535651088772e-18, -7.832988112892810e-21,  4.916963399646653e-23, -2.986790283879784e-25,  1.787915899166928e-02, -3.590949976188772e-04,
  5.167054252175068e-06, -6.050706643270369e-08,  6.183628396103542e-10, -5.713606200408158e-12,  4.877484503226968e-14, -3.902762373440225e-16,  2.957295181894954e-18,
 -2.138335089738364e-20,  1.484103435333113e-22, -9.932484491974855e-25,  1.286254914627279e-02, -3.235499952581336e-04,  5.489951941907771e-06, -7.433821156768010e-08,
  8.667828324966145e-10, -9.049764966562586e-12,  8.664264757817895e-14, -7.728283220490039e-16,  6.494995079470894e-18, -5.186192602653371e-20,  3.959892321213229e-22,
 -2.905813866784740e-24,  8.897914592044281e-03, -2.745990202276923e-04,  5.447145227764849e-06, -8.466231421990065e-08,  1.119119639125293e-09, -1.312714696129650e-11,
  1.402091992541472e-13, -1.387247672358382e-15,  1.287037563836604e-17, -1.129831434160689e-19,  9.450152636433361e-22, -7.572271736172068e-24,  5.923046805170283e-03,
 -2.203614903717063e-04,  5.069047528998252e-06, -8.983156996790130e-08,  1.338531333998158e-09, -1.755004547904201e-11,  2.081467622375647e-13, -2.274494521409242e-15,
  2.319974900589276e-17, -2.230313078148458e-19,  2.035926015824839e-21, -1.774984141890897e-23,  3.797114035624258e-03, -1.677650368622891e-04,  4.441135833122173e-06,
 -8.919222308904476e-08,  1.490364106820593e-09, -2.174215495233876e-11,  2.851407603809598e-13, -3.427857701633109e-15,  3.829961881922329e-17, -4.018195908856276e-19,
  3.989882032147678e-21, -3.772734404722460e-23,  2.346457556727171e-03, -1.215304905714576e-04,  3.675873021459119e-06, -8.319034008757359e-08,  1.551446941177774e-09,
 -2.507733734927477e-11,  3.622804925686799e-13, -4.774440926812523e-15,  5.824112671048415e-17, -6.647529194556152e-19,  7.158557427224505e-21, -7.320521460553141e-23,
  1.399158075628557e-03, -8.399566987662629e-05,  2.883318870001327e-06, -7.314795564451025e-08,  1.515808895638566e-09, -2.704163275647783e-11,  4.288185046465689e-13,
 -6.175249695309262e-15,  8.199340121855716e-17, -1.015216361152776e-18,  1.182432174688608e-20, -1.304305643051657e-22,  8.059498117504313e-04, -5.552679216816187e-05,
  2.149651605555679e-06, -6.083281466117332e-08,  1.394956600584061e-09, -2.736617999027982e-11,  4.747954928086022e-13, -7.448691399017361e-15,  1.073492435490240e-16,
 -1.438057447211140e-18,  1.806977151485510e-20, -2.144849292320480e-22,  4.490333403901447e-04, -3.519280266904179e-05,  1.527565826461097e-06, -4.799782285151883e-08,
  1.213198317846686e-09, -2.608340354640413e-11,  4.935931591477309e-13, -8.412114801748381e-15,  1.312424296566271e-16, -1.897460200046794e-18,  2.566181972235102e-20,
 -3.270379222963238e-22,  2.423111903602546e-04, -2.143438054813933e-05,  1.037427593542384e-06, -3.603604595934143e-08,  1.000305065876080e-09, -2.349288900069010e-11,
  4.834882712919763e-13, -8.927336589783192e-15,  1.504042977807875e-16, -2.341341729514840e-18,  3.400610689964218e-20, -4.643200702684810e-22,  1.268360982121832e-04,
 -1.257365554489352e-05,  6.751260328484111e-07, -2.581848549811500e-08,  7.843106899039237e-10, -2.005964549073050e-11,  4.477232151376056e-13, -8.933840695459974e-15,
  1.621501547080652e-16, -2.711834205818428e-18,  4.221044157999813e-20, -6.162550548301241e-22,  6.450524137912233e-05, -7.120266226374735e-06,  4.220973791136918e-07,
 -1.770217237259233e-08,  5.865335249419354e-10, -1.628832981601391e-11,  3.932263130236313e-13, -8.458679477292471e-15,  1.650202001123924e-16, -2.958693248856406e-18,
  4.925471570375921e-20, -7.674259059752151e-22,  3.192998505286161e-05, -3.901402974719314e-06,  2.541989311816070e-07, -1.164770155588719e-08,  4.195889011951481e-10,
 -1.261605517947986e-11,  3.285903441593092e-13, -7.601917925750338e-15,  1.590606614177823e-16, -3.051065460598350e-18,  5.421861176649588e-20, -8.998771106455418e-22,
  1.541296101599315e-05, -2.073322638942895e-06,  1.478469714799812e-07, -7.375484010146535e-09,  2.879749554486883e-10, -9.349328194380374e-12,  2.620585429049971e-13,
 -6.505542318986871e-15,  1.456821317514346e-16, -2.983706401724334e-18,  5.649169362532271e-20, -9.969819267857993e-22,  7.270341679317702e-06, -1.071273759687607e-06,
  8.327112120626285e-08, -4.507223627895606e-09,  1.901797805168614e-10, -6.649103994101302e-12,  2.000871599111224e-13, -5.318083807164015e-15,  1.271925823226128e-16,
 -2.776056127075216e-18,  5.589719355597907e-20, -1.047128767183484e-21,  3.358694317034873e-06, -5.395468191075874e-07,  4.554225509900398e-08, -2.665931456882949e-09,
  1.212124500541312e-10, -4.551947504665471e-12,  1.467126585981742e-13, -4.165897164822320e-15,  1.061981473955830e-16, -2.465306454991327e-18,  5.269644595019084e-20,
 -1.046046539310133e-21,  1.523239540929106e-06, -2.655877114282748e-07,  2.425513369078237e-08, -1.530705370531884e-09,  7.478599273611406e-11, -3.009023040334179e-12,
  1.036348456076174e-13, -3.137049910168014e-15,  8.506719755194165e-17, -2.096452373239988e-18,  4.748632566185920e-20, -9.971444379190131e-22,  6.799140915152340e-07,
 -1.281280477886186e-07,  1.261636494726719e-08, -8.557615488353403e-10,  4.480525525802454e-11, -1.926701042656782e-12,  7.074817810832027e-14, -2.278170215090888e-15,
  6.558399056245926e-17, -1.712683804658430e-18,  4.103582801061610e-20, -9.099897879380298e-22,  2.995060016520424e-07, -6.075760090013081e-08,  6.428718720793674e-09,
 -4.672907162193167e-10,  2.614882986620880e-11, -1.198833237780118e-12,  4.682756790475612e-14, -1.600719177461096e-15,  4.882480202226616e-17, -1.348546789215735e-18,
  3.411807599906024e-20, -7.976372697930399e-22,  1.305784227058833e-07, -2.840518677210753e-08,  3.219148905175514e-09, -2.500296813183945e-10,  1.491440665537457e-11,
 -7.272540976595301e-13,  3.015077725177886e-14, -1.091804174104815e-15,  3.521491069861185e-17, -1.026800986029606e-18,  2.738194714685586e-20, -6.737404817574752e-22,
  5.651585276434352e-08, -1.313451603347070e-08,  1.589282438483247e-09, -1.315245028384798e-10,  8.341510315122194e-12, -4.315769036841702e-13,  1.894828531831182e-14,
 -7.253335043484078e-16,  2.468966987578795e-17, -7.585631299883893e-19,  2.128382718834933e-20, -5.502217685752530e-22,  2.436058746287658e-08, -6.026788892663194e-09,
  7.761955812751339e-10, -6.825225282983813e-11,  4.590520666644377e-12, -2.514034124089126e-13,  1.166300530333492e-14, -4.709598459178767e-16,  1.688453558067035e-17,
 -5.455769932742355e-19,  1.607697427911065e-20, -4.359066907475806e-22,  1.049233239802845e-08, -2.753618932399140e-09,  3.763271163045224e-10, -3.506299604019099e-11,
  2.494529023398889e-12, -1.442628605793716e-13,  7.055765424418331e-15, -2.999153082205932e-16,  1.130193710381166e-17, -3.833290820488827e-19,  1.184151515074273e-20,
 -3.361437299587451e-22,  4.531347505006095e-09, -1.257208588513458e-09,  1.817779912246882e-10, -1.789645490714624e-11,  1.343348275998531e-12, -8.184026587651497e-14,
  4.210371855695666e-15, -1.879834432843636e-16,  7.430708006477319e-18, -2.640262098862030e-19,  8.533952703161470e-21, -2.531667597894908e-22,  1.969268489900572e-09,
 -5.756751819669942e-10,  8.779937661028478e-11, -9.108902894979900e-12,  7.195365290874735e-13, -4.606702719741443e-14,  2.487186200706452e-15, -1.163859054300514e-16,
  4.815678732104695e-18, -1.788956574885555e-19,  6.038535502193881e-21, -1.868602508649742e-22,  8.643521832283960e-10, -2.653539990370222e-10,  4.256318063231006e-11,
 -4.640471492087128e-12,  3.847589783878019e-13, -2.582371798098824e-14,  1.459776750067840e-15, -7.143341236764662e-17,  3.087273351814759e-18, -1.196599758919081e-19,
  4.209669800292384e-21, -1.356218233404673e-22,  3.845826642768505e-10, -1.235885784574409e-10,  2.078730973574483e-11, -2.375077847414574e-12,  2.061612616912402e-13,
 -1.446929526045788e-14,  8.543393487183862e-16, -4.361911789359327e-17,  1.964781689101248e-18, -7.928694810568557e-20,  2.901228370158019e-21, -9.711847996113662e-23,
  1.741025637036977e-10, -5.837915425077697e-11,  1.026608583058865e-11, -1.225812777303783e-12,  1.110972361063219e-13, -8.133030527794179e-15,  5.003739848359088e-16,
 -2.659239569900565e-17,  1.245605209349508e-18, -5.222001483659327e-20,  1.983284092147630e-21, -6.884272418686262e-23,  8.048453226706310e-11, -2.807088271211177e-11,
  5.145662658416609e-12, -6.402878873428712e-13,  6.042732560484134e-14, -4.602227658101985e-15,  2.942993571084787e-16, -1.624152859448753e-17,  7.892773347681536e-19,
 -3.429908086907684e-20,  1.349135644438997e-21, -4.845820523938430e-23,  3.812630009735889e-11, -1.378800720689254e-11,  2.626809676166188e-12, -3.396538468240338e-13,
  3.328756039887349e-14, -2.630601046070369e-15,  1.744007397760830e-16, -9.969909897346055e-18,  5.014627369212639e-19, -2.253640810699506e-20,  9.160300759677178e-22,
 -3.397149289694774e-23,  1.856728179058014e-11, -6.940880551903242e-12,  1.370180725534750e-12, -1.835697203328524e-13,  1.863028545306647e-14, -1.523553654701979e-15,
  1.044451906669649e-16, -6.169324376863577e-18,  3.203789642102394e-19, -1.485486348520164e-20,  6.225014300418733e-22, -2.378269850355539e-23,  9.322305741188489e-12,
 -3.591272655160618e-12,  7.323711015617379e-13, -1.013658039119675e-13,  1.062293612046771e-14, -8.964951265221027e-16,  6.337998967523295e-17, -3.858140111754667e-18,
  2.063412590909495e-19, -9.846517275365453e-21,  4.243880150737177e-22, -1.666440978027786e-23,  4.836596916484028e-12, -1.914280823232373e-12,  4.020493781360624e-13,
 -5.731629237332017e-14,  6.184470558256287e-15, -5.370852438673814e-16,  3.905059005880713e-17, -2.443259805464328e-18,  1.342240613583513e-19, -6.575362626179761e-21,
  2.907624405251118e-22, -1.170654610818744e-23,  2.596668832032642e-12, -1.052729787240283e-12,  2.270076524476913e-13, -3.323212584458782e-14,  3.680997244192476e-15,
 -3.280107061052281e-16,  2.445849401793232e-17, -1.568544659317628e-18,  8.827744538596503e-20, -4.427929869357101e-21,  2.003800732219741e-22, -8.251524904708916e-24,
  1.442810563880117e-12, -5.973783482044977e-13,  1.318467188135905e-13, -1.975903754396239e-14,  2.239974268948317e-15, -2.042042660171764e-16,  1.557084975267276e-17,
 -1.020666310422358e-18,  5.868644843977885e-20, -3.005996065751895e-21,  1.388491725536320e-22, -5.833200002381120e-24,  8.281061548025400e-13, -3.491257376589243e-13,
  7.861987325626561e-14, -1.202396681790211e-14,  1.390779501465875e-15, -1.293215677147072e-16,  1.005415455235511e-17, -6.716952982619041e-19,  3.934665081792135e-20,
 -2.052422280772212e-21,  9.650708326430597e-23, -4.125458733821505e-24,  4.883283814359837e-13, -2.090206336141423e-13,  4.787330356706107e-14, -7.448170039411909e-15,
  8.762639700946044e-16, -8.285264341697617e-17,  6.547933482762106e-18, -4.445405395994363e-19,  2.645343197483285e-20, -1.401300628729163e-21,  6.689149468593302e-23,
 -2.901832970774293e-24,  2.923684529279225e-13, -1.266844772917670e-13,  2.941673895601162e-14, -4.640842866419607e-15,  5.535785349568408e-16, -5.305862959664094e-17,
  4.249629960055199e-18, -2.923079687216861e-19,  1.761881923644970e-20, -9.450932679395372e-22,  4.567168450894953e-23, -2.005175573220637e-24,  1.731388306440870e-13,
 -7.572597348515443e-14,  1.777000266902083e-14, -2.833527593049726e-15,  3.415957476453806e-16, -3.308439996944543e-17,  2.677136678053004e-18, -1.860051992898790e-19,
  1.132236534920545e-20, -6.132277019408420e-22,  2.991523295054004e-23, -1.325553151533186e-24,  9.492041855322399e-14, -4.178450827265233e-14,  9.877052772646606e-15,
 -1.586665578779326e-15,  1.926928530595561e-16, -1.879857211505953e-17,  1.532019893615176e-18, -1.071892243677637e-19,  6.569524116893945e-21, -3.582016294536732e-22,
  1.758919720359093e-23, -7.843862912786171e-25,  3.751622242777425e-14, -1.657420235300604e-14,  3.933761359476532e-15, -6.345376291357429e-16,  7.737785764388137e-17,
 -7.579304494999199e-18,  6.201421175434206e-19, -4.355790599028448e-20,  2.679814349402967e-21, -1.466624888074041e-22,  7.228100805933778e-24, -3.234868778545442e-25,
  5.680318332520680e-02, -1.334099918504496e-04,  3.244805166298645e-07, -8.125351036608940e-10,  2.080412401991444e-12, -5.411325263374272e-15,  1.421942953874450e-17,
 -3.759149345553467e-20,  9.966620116089445e-23, -2.644823014906467e-25,  7.013993784730146e-28, -1.857545550285744e-30,  5.433431418033662e-02, -1.606019878268701e-04,
  5.592970894319466e-07, -2.028447465850341e-09,  7.303163696341471e-12, -2.579699805959729e-14,  8.935112404375191e-17, -3.041057013156870e-19,  1.019385714493038e-21,
 -3.372035732221880e-24,  1.102444561222660e-26, -3.566723577326701e-29,  4.971744242750804e-02, -2.073513574819976e-04,  1.021561118522007e-06, -4.844654719774580e-09,
  2.182199391552206e-11, -9.430389202389294e-14,  3.943295865918285e-16, -1.604723035394219e-18,  6.381416447894704e-21, -2.487266675614289e-23,  9.524343097641798e-26,
 -3.589770450490780e-28,  4.352510093354309e-02, -2.608822355838400e-04,  1.682657754649625e-06, -9.836254950249128e-09,  5.341614049314636e-11, -2.746958306282678e-13,
  1.352999513982661e-15, -6.430671725582373e-18,  2.965236624156709e-20, -1.331883306033177e-22,  5.845864364458793e-25, -2.513596427889931e-27,  3.646387189266540e-02,
 -3.072716061827070e-04,  2.476542343873884e-06, -1.743476396015622e-08,  1.121836851526984e-10, -6.752976002179308e-13,  3.855683725016675e-15, -2.107603628063335e-17,
  1.110371526621722e-19, -5.666631305019461e-22,  2.812243508635444e-24, -1.361412957117661e-26,  2.924194335058569e-02, -3.354295366401810e-04,  3.296178736681719e-06,
 -2.756629834144289e-08,  2.074956953817447e-10, -1.444157227446936e-12,  9.447640959705774e-15, -5.874222504304139e-17,  3.498986453242627e-19, -2.008510479092284e-21,
  1.116181986507787e-23, -6.026857782428883e-26,  2.245599959079461e-02, -3.397111124799353e-04,  4.010432298772106e-06, -3.941787326601982e-08,  3.435373564461285e-10,
 -2.738158477205087e-12,  2.034154088837416e-14, -1.426529981239678e-16,  9.529964653641127e-19, -6.105920253173973e-21,  3.771581519416708e-23, -2.255205707835109e-25,
  1.652107983237167e-02, -3.205029972539086e-04,  4.496757624609887e-06, -5.146736735634183e-08,  5.149639220915781e-10, -4.664121509862634e-12,  3.906395078968408e-14,
 -3.068942106171942e-16,  2.284592826167946e-18, -1.623712845974859e-20,  1.108176681207767e-22, -7.295979022982650e-25,  1.165085428317993e-02, -2.829759054383690e-04,
  4.675478556898930e-06, -6.181162248432240e-08,  7.049434307894445e-10, -7.208147563756659e-12,  6.765296346125587e-14, -5.920376204906488e-16,  4.884729837771215e-18,
 -3.831313886607421e-20,  2.874946038112890e-22, -2.074182069243220e-24,  7.880643354263630e-03, -2.348000766833082e-04,  4.530527099558575e-06, -6.868632570666601e-08,
  8.873061038032101e-10, -1.018521482971142e-11,  1.065691960135933e-13, -1.033783890738176e-15,  9.410050014499014e-18, -8.109593614649643e-20,  6.662463564516155e-22,
 -5.246056123194765e-24,  5.116359327765019e-03, -1.837819593109534e-04,  4.108808151710329e-06, -7.097188620706319e-08,  1.032731099544466e-09, -1.324175566742550e-11,
  1.537511470787612e-13, -1.646261882947143e-15,  1.646584507570214e-17, -1.553204030320400e-19,  1.391959320327598e-21, -1.191994028070060e-23,  3.190865037952342e-03,
 -1.361425826895612e-04,  3.500675202306288e-06, -6.848362117296599e-08,  1.116843199322357e-09, -1.592438573757175e-11,  2.043464500433957e-13, -2.405895563295201e-15,
  2.634692158102028e-17, -2.711041608326273e-19,  2.641720071755064e-21, -2.452614196419920e-23,  1.913376205920337e-03, -9.572990866685265e-05,  2.811391424093792e-06,
 -6.194907793789573e-08,  1.127020380494982e-09, -1.779649983437183e-11,  2.514508079569799e-13, -3.244102048327110e-15,  3.877141110523285e-17, -4.338610180653460e-19,
  4.583386549970095e-21, -4.600530725512894e-23,  1.104281377208768e-03, -6.406566271230222e-05,  2.134876235109067e-06, -5.271635194921487e-08,  1.065287252874919e-09,
 -1.855914895383484e-11,  2.877412709898850e-13, -4.055105846134771e-15,  5.273502817641549e-17, -6.399678473999134e-19,  7.310129874879821e-21, -7.912613174659261e-23,
  6.140992655504686e-04, -4.090802603733500e-05,  1.537339332458909e-06, -4.233745939143618e-08,  9.465102330516058e-10, -1.812894377150945e-11,  3.074387282673848e-13,
 -4.718935226239062e-15,  6.659371992021375e-17, -8.741640820884007e-19,  1.077029996455348e-20, -1.254235469980260e-22,  3.294737664749295e-04, -2.498201218702996e-05,
  1.052728986106713e-06, -3.218863799949313e-08,  7.931224663008293e-10, -1.664573988172717e-11,  3.078459400852019e-13, -5.132308140926738e-15,  7.839439664924215e-17,
 -1.110457649828927e-18,  1.472364204933955e-20, -1.840677842725327e-22,  1.707754964273430e-04, -1.462460551185456e-05,  6.873506081307845e-07, -2.323567450739853e-08,
  6.287487800087908e-10, -1.441429352988806e-11,  2.898955670639101e-13, -5.235887010344252e-15,  8.635757740187552e-17, -1.317022160538441e-18,  1.875232673250286e-20,
 -2.511551277756163e-22,  8.564657335956997e-05, -8.225682724411246e-06,  4.290405482976007e-07, -1.597077844084823e-08,  4.729954258814131e-10, -1.180947194758973e-11,
  2.575905221877398e-13, -5.027811245894350e-15,  8.933762804722295e-17, -1.463765310205822e-18,  2.233579894823528e-20, -3.198697118345936e-22,  4.162871275095258e-05,
 -4.455441389518173e-06,  2.566925316845446e-07, -1.048193152434336e-08,  3.386679299687465e-10, -9.182600390016018e-12,  2.166704474852111e-13, -4.559592606473755e-15,
  8.709178106422598e-17, -1.529918623103346e-18,  2.497036532803506e-20, -3.816627595204806e-22,  1.964528413574459e-05, -2.329486979956260e-06,  1.475930188705252e-07,
 -6.587555260495908e-09,  2.314790839065817e-10, -6.797213348012904e-12,  1.730712667897245e-13, -3.917809803202605e-15,  8.027412900596340e-17, -1.508911096617609e-18,
  2.629280228910199e-20, -4.281578717330911e-22,  9.018994468352834e-06, -1.178504706403433e-06,  8.177423650433841e-08, -3.975641414398468e-09,  1.514798325188984e-10,
 -4.804549542891147e-12,  1.316944466017900e-13, -3.199805355409827e-15,  7.018600814443781e-17, -1.408978800521700e-18,  2.616430916067812e-20, -4.531490580912436e-22,
  4.036604346245904e-06, -5.783555601003723e-07,  4.377773593388563e-08, -2.310690725167771e-09,  9.519207476675885e-11, -3.252849717071717e-12,  9.576111355108883e-14,
 -2.492032074907364e-15,  5.839976206771716e-17, -1.249741082352749e-18,  2.468824525926255e-20, -4.540013531868427e-22,  1.765351032607568e-06, -2.760518054917914e-07,
  2.270913592067603e-08, -1.297204337413564e-09,  5.761950160823592e-11, -2.115993851782347e-12,  6.675183426001005e-14, -1.856633026107121e-15,  4.639449619255620e-17,
 -1.056414885240439e-18,  2.216242760867928e-20, -4.320183747992448e-22,  7.562736996481028e-07, -1.285029741402323e-07,  1.144792620863807e-08, -7.055433494793927e-10,
  3.369855414904546e-11, -1.326717840802568e-12,  4.474892577287327e-14, -1.327542615726025e-15,  3.530498852664038e-17, -8.538413303267490e-19,  1.899015672463324e-20,
 -3.917616450883858e-22,  3.182117155495403e-07, -5.850843940468380e-08,  5.625365874422605e-09, -3.729475875639848e-10,  1.910354464583592e-11, -8.043843312772489e-13,
  2.894463838211798e-14, -9.140108452597061e-16,  2.582008331664956e-17, -6.620505496889144e-19,  1.558371963924436e-20, -3.396774170301716e-22,  1.318804962302491e-07,
 -2.613532904118608e-08,  2.703006169428679e-09, -1.922160094015970e-10,  1.053194723038385e-11, -4.731675358853942e-13,  1.812484092897058e-14, -6.079873542986320e-16,
  1.820932576889403e-17, -4.941289088077743e-19,  1.228877981217483e-20, -2.825525254793293e-22,  5.399989373129248e-08, -1.149030937354892e-08,  1.274236004963731e-09,
 -9.691943748182755e-11,  5.665968735744440e-12, -2.709698062897857e-13,  1.102538449071782e-14, -3.920776594184636e-16,  1.242617607507252e-17, -3.562167064177533e-19,
  9.343876154414692e-21, -2.262559949323668e-22,  2.191575018162384e-08, -4.988736244298335e-09,  5.913651562782619e-10, -4.797660617716026e-11,  2.984968608722199e-12,
 -1.516057618696993e-13,  6.538245732570899e-15, -2.459888944587004e-16,  8.234073928593767e-18, -2.489043662406308e-19,  6.874439953811738e-21, -1.750136132460500e-22,
  8.846163027213449e-09, -2.146525057019469e-09,  2.711590097906947e-10, -2.340022760807336e-11,  1.545562343145022e-12, -8.317269830216689e-14,  3.793623063133446e-15,
 -1.506937498571098e-16,  5.317248350453076e-18, -1.691786458242021e-19,  4.911094756912746e-21, -1.312322914771364e-22,  3.564102911134553e-09, -9.186887534950178e-10,
  1.233036568323343e-10, -1.128789845946114e-11,  7.894897268570306e-13, -4.491010873393181e-14,  2.161685205330280e-15, -9.047327044581051e-17,  3.358536451874751e-18,
 -1.122625692965658e-19,  3.419134928503394e-21, -9.573194638003301e-23,  1.438717849230278e-09, -3.926023796989499e-10,  5.582011746361148e-11, -5.406194628819548e-12,
  3.993920900332997e-13, -2.395946342548565e-14,  1.214326367400976e-15, -5.343616612865750e-17,  2.082725982508948e-18, -7.299797968517660e-20,  2.328317542168117e-21,
 -6.818549647678941e-23,  5.841549191783293e-10, -1.681946407135831e-10,  2.525801649958612e-11, -2.580984077263315e-12,  2.008940506669448e-13, -1.267911093033708e-14,
  6.751126200843009e-16, -3.116843295348932e-17,  1.272880697792739e-18, -4.668810616696366e-20,  1.556564303033982e-21, -4.759202332108214e-23,  2.395279342003834e-10,
 -7.252965640041458e-11,  1.147027535169920e-11, -1.233275929376728e-12,  1.008795944880140e-13, -6.682157708941548e-15,  3.729346026233324e-16, -1.802416808919896e-17,
  7.696426407891566e-19, -2.948281062240186e-20,  1.025446434620263e-21, -3.267229974485633e-23,  9.959664418727910e-11, -3.161294554642102e-11,  5.249455477716035e-12,
 -5.922506417622707e-13,  5.077863440333728e-14, -3.521384084435759e-15,  2.055105900574378e-16, -1.037433498337781e-17,  4.621828895637132e-19, -1.845221086407919e-20,
  6.681918417116346e-22, -2.214221720594386e-23,  4.216900481695733e-11, -1.398536625589618e-11,  2.431241115253838e-12, -2.870212659932132e-13,  2.572604707231318e-14,
 -1.863065244248309e-15,  1.134236701836228e-16, -5.966569629306456e-18,  2.767113181018832e-19, -1.148892110717120e-20,  4.322498428264315e-22, -1.486723592153412e-23,
  1.825531997637653e-11, -6.305816510082071e-12,  1.144206862634934e-12, -1.409473941163703e-13,  1.317126132039165e-14, -9.935320722948076e-16,  6.294092420905714e-17,
 -3.441989673496347e-18,  1.657895221935133e-19, -7.142612866387414e-21,  2.785967944581677e-22, -9.925115001513285e-24,  8.112827864465129e-12, -2.909489643886594e-12,
  5.493897653747152e-13, -7.041254277727161e-14,  6.841217496474737e-15, -5.360866340887410e-16,  3.524933448467247e-17, -1.998987191768388e-18,  9.976199766142251e-20,
 -4.449463609781021e-21,  1.795209062385690e-22, -6.609849255141987e-24,  3.715232767427647e-12, -1.378966173537051e-12,  2.701434400515947e-13, -3.591763546837638e-14,
  3.618074529667808e-15, -2.937258871427502e-16,  1.999302132571128e-17, -1.172768547648919e-18,  6.049246267807130e-20, -2.786405477108144e-21,  1.160186715817559e-22,
 -4.404915468353818e-24,  1.759207571173162e-12, -6.736688277491756e-13,  1.364973462975937e-13, -1.877080344502031e-14,  1.954710039330759e-15, -1.639431634226319e-16,
  1.152047514625043e-17, -6.971639558035512e-19,  3.707206093034334e-20, -1.759181159156019e-21,  7.540846027823136e-23, -2.945378829658561e-24,  8.637872973643439e-13,
 -3.402081465909366e-13,  7.107249696524876e-14, -1.007814410535085e-14,  1.081737917226269e-15, -9.346060864604100e-17,  6.761321002860886e-18, -4.209647683117045e-19,
  2.301610100437751e-20, -1.122272862298787e-21,  4.940207772786191e-23, -1.980240031851277e-24,  4.406818533697741e-13, -1.779615105081164e-13,  3.821079473248496e-14,
 -5.569721870719980e-15,  6.143247980719423e-16, -5.451495302456482e-17,  4.048497602549691e-18, -2.586068697563483e-19,  1.449820367089302e-20, -7.244826975377854e-22,
  3.266519731277182e-23, -1.340330584914875e-24,  2.337622855153280e-13, -9.649402049314966e-14,  2.122606737234225e-14, -3.170348494186221e-15,  3.582159445120235e-16,
 -3.255036319424444e-17,  2.474138859103078e-18, -1.616772042305757e-19,  9.268055347646566e-21, -4.733223989393124e-22,  2.180023727481092e-23, -9.132883500534441e-25,
  1.287532185043958e-13, -5.415996460537585e-14,  1.216593330181319e-14, -1.855961927404846e-15,  2.141417182513878e-16, -1.986351835506186e-17,  1.540621744147559e-18,
 -1.026861564927619e-19,  6.001508828557990e-21, -3.123605531660824e-22,  1.465577178878121e-23, -6.251827840443502e-25,  7.327574129244411e-14, -3.131489432881943e-14,
  7.159599317819195e-15, -1.111913580615033e-15,  1.305843878805508e-16, -1.232569601224810e-17,  9.724650012456803e-19, -6.591166218654137e-20,  3.915892331033782e-21,
 -2.071068075619894e-22,  9.871076880628312e-24, -4.275770069292727e-25,  4.260103372587402e-14, -1.844011865970233e-14,  4.276916072950565e-15, -6.739429529491188e-16,
  8.029725734951758e-17, -7.687433908765844e-18,  6.150216794293759e-19, -4.225756336421079e-20,  2.544343513012522e-21, -1.363387669309751e-22,  6.581848950738543e-24,
 -2.886828313662591e-25,  2.465801029879661e-14, -1.077810229247877e-14,  2.527464328201180e-15, -4.027364866622768e-16,  4.851818395520613e-17, -4.695898001327611e-18,
  3.797299534500572e-19, -2.636600013737594e-20,  1.603899735533880e-21, -8.681378987719875e-23,  4.232453340510151e-24, -1.874288221361524e-25,  1.330341248350687e-14,
 -5.854372798895594e-15,  1.383361841578920e-15, -2.221439499676451e-16,  2.696846648699333e-17, -2.630020486200455e-18,  2.142618421907869e-19, -1.498581785623955e-20,
  9.181527181258525e-22, -5.004527393148807e-23,  2.456624731528773e-24, -1.095174312371197e-25,  5.211013405557040e-15, -2.301806156161195e-15,  5.462201753194045e-16,
 -8.809250545266891e-17,  1.074039173773504e-17, -1.051853364136598e-18,  8.604791071575140e-20, -6.042828880869402e-21,  3.717091121604844e-22, -2.033966345384460e-23,
  1.002250190200345e-24, -4.484738073433985e-26,  5.627467408158688e-02, -1.308525916367113e-04,  3.149263026022580e-07, -7.800961266329853e-10,  1.975515128227316e-12,
 -5.082337911292732e-15,  1.321012450095605e-17, -3.454925783448601e-20,  9.063076261019503e-23, -2.379939499604319e-25,  6.246218270479350e-28, -1.637297632411923e-30,
  5.370070357410667e-02, -1.562230285978131e-04,  5.356401672031906e-07, -1.915610682708983e-09,  6.807996878328590e-12, -2.375117369826958e-14,  8.127518921916174e-17,
 -2.733455180318485e-19,  9.055660335971107e-22, -2.960895425066438e-24,  9.569399061003835e-27, -3.060825999467481e-29,  4.890402197649614e-02, -1.994056164533769e-04,
  9.654595576147509e-07, -4.510092106226595e-09,  2.002703150229976e-11, -8.535689550483835e-14,  3.521266739397061e-16, -1.414138889321389e-18,  5.550934209746580e-21,
 -2.136085965155984e-23,  8.077136393376815e-26, -3.006661334918458e-28,  4.250776693529114e-02, -2.478789909653884e-04,  1.569574897804168e-06, -9.023843070019057e-09,
  4.823289491439043e-11, -2.442815992578988e-13,  1.185535115848299e-15, -5.554207161605247e-18,  2.525314104218731e-20, -1.118747733585385e-22,  4.844266324185122e-25,
 -2.055318161038835e-27,  3.527312686858153e-02, -2.882666168940571e-04,  2.277664868766159e-06, -1.574303845640417e-08,  9.955729460271094e-11, -5.894593299825324e-13,
  3.312380830556119e-15, -1.782865423009558e-17,  9.252562876046283e-20, -4.652961376791724e-22,  2.276118555552963e-24, -1.086377622687868e-26,  2.795094590694052e-02,
 -3.103289680033688e-04,  2.984388031392380e-06, -2.446564993725624e-08,  1.807530235093527e-10, -1.235949852526305e-12,  7.949328763047521e-15, -4.862113195086776e-17,
  2.850283501580421e-19, -1.610880525379893e-21,  8.816912745683723e-24, -4.690248308678715e-26,  2.115845293951579e-02, -3.094302660122088e-04,  3.568672576952148e-06,
 -3.433415411091718e-08,  2.933496038472027e-10, -2.294640026436722e-12,  1.674312278711013e-14, -1.154013110730605e-16,  7.581061339608057e-19, -4.778537750371682e-21,
  2.904974127823181e-23, -1.710130756084559e-25,  1.530729324457324e-02, -2.868660721427848e-04,  3.925664799127399e-06, -4.392604428761863e-08,  4.304013131048672e-10,
 -3.821953068558367e-12,  3.141228927596656e-14, -2.423433827837562e-16,  1.772669216712316e-18, -1.238576887945139e-20,  8.313935907440816e-23, -5.385573353241038e-25,
  1.058931757752424e-02, -2.483577002234733e-04,  3.996927375962410e-06, -5.160294573063574e-08,  5.757606025017284e-10, -5.766937200513506e-12,  5.307176509127996e-14,
 -4.557421787066267e-16,  3.692190920371080e-18, -2.845139474020025e-20,  2.098478807751300e-22, -1.488756269243916e-24,  7.009032715298695e-03, -2.016260814220045e-04,
  3.785174994530633e-06, -5.598935845551585e-08,  7.069988356436207e-10, -7.943403047358250e-12,  8.143426957023662e-14, -7.746501019490266e-16,  6.919405866246888e-18,
 -5.855089194062415e-20,  4.725521070233312e-22, -3.657005424878787e-24,  4.441950140742760e-03, -1.540561403422064e-04,  3.348157207852850e-06, -5.638104182263079e-08,
  8.013496504459749e-10, -1.005013797445845e-11,  1.142629735936911e-13, -1.199022059737334e-15,  1.176173654768454e-17, -1.088797891584837e-19,  9.581064237421279e-22,
 -8.060096700232209e-24,  2.697499760517834e-03, -1.111431945116760e-04,  2.776383065823102e-06, -5.291686275595174e-08,  8.423986611926263e-10, -1.174151930894265e-11,
  1.474516022180894e-13, -1.700495768846545e-15,  1.825481521161208e-17, -1.842544544865012e-19,  1.762188192015205e-21, -1.606573195487960e-23,  1.571130323767647e-03,
 -7.593084755133664e-05,  2.165434190331345e-06, -4.646483464686613e-08,  8.247485825934627e-10, -1.272475978996659e-11,  1.758685315073614e-13, -2.221552409745254e-15,
  2.601622531621173e-17, -2.854633117753313e-19,  2.958781805917930e-21, -2.915367311207192e-23,  8.785450337690316e-04, -4.925323037148403e-05,  1.593416188740808e-06,
 -3.830143306995297e-08,  7.548672154182058e-10, -1.284461111171403e-11,  1.947261444743332e-13, -2.685949106124628e-15,  3.421528670701679e-17, -4.070140745344719e-19,
  4.560104712344283e-21, -4.844049571172764e-23,  4.721771018970152e-04, -3.040921666903739e-05,  1.109375243023168e-06, -2.973396369825074e-08,  6.481452414635329e-10,
 -1.212152627814927e-11,  2.009471496008495e-13, -3.018031753898387e-15,  4.170872074769155e-17, -5.365513790924289e-19,  6.482544475222328e-21, -7.407016698022574e-23,
  2.442172584051896e-04, -1.791242245464862e-05,  7.327970580207325e-07, -2.180476141536259e-08,  5.237725349741684e-10, -1.073165387689547e-11,  1.939791594318317e-13,
 -3.163813347188446e-15,  4.731724948876918e-17, -6.567310470250707e-19,  8.537503900344595e-21, -1.047070280780491e-22,  1.217241432052076e-04, -1.008977354215873e-05,
  4.604696811030802e-07, -1.514869890909086e-08,  3.996080581887004e-10, -8.942912071599606e-12,  1.757702011811034e-13, -3.105472065555729e-15,  5.014541967295496e-17,
 -7.492619047226622e-19,  1.045892537712042e-20, -1.374108445717362e-22,  5.855516115108767e-05, -5.447285062557906e-06,  2.759745381420025e-07, -9.999089936657743e-09,
  2.887079958763698e-10, -7.036744781023247e-12,  1.499993858438761e-13, -2.863959141615904e-15,  4.982046341729287e-17, -7.997348319187594e-19,  1.196353591805970e-20,
 -1.680630661411154e-22,  2.723112195939046e-05, -2.825232659739783e-06,  1.581699124653941e-07, -6.288253922962672e-09,  1.981099967404269e-10, -5.244343250531246e-12,
  1.209437709158400e-13, -2.489832074350131e-15,  4.656223670456356e-17, -8.014027067853348e-19,  1.282373153028789e-20, -1.922800738098720e-22,  1.226508076991614e-05,
 -1.411014670096985e-06,  8.691862991307517e-08, -3.778412512016530e-09,  1.294972615384456e-10, -3.713370875508004e-12,  9.242732757466576e-14, -2.047142838047205e-15,
  4.107290263814197e-17, -7.565318254292513e-19,  1.292595683252844e-20, -2.065136761271730e-22,  5.360995519633800e-06, -6.802608665256161e-07,  4.592045637917516e-08,
 -2.175394868749182e-09,  8.087459401785207e-11, -2.505733612457662e-12,  6.715930411943832e-14, -1.596973895761091e-15,  3.430814885390953e-17, -6.750350851051830e-19,
  1.229364159613512e-20, -2.089373013215283e-22,  2.278943196444176e-06, -3.173916437318025e-07,  2.338878361466380e-08, -1.203598301688898e-09,  4.840280613553460e-11,
 -1.616347589910218e-12,  4.654501408952369e-14, -1.185812042123935e-15,  2.722564805941009e-17, -5.711985874667847e-19,  1.106944266573562e-20, -1.998073644331030e-22,
  9.444062243856559e-07, -1.436997025253618e-07,  1.151765741361754e-08, -6.418603768401649e-10,  2.784675547063778e-11, -9.998507773378334e-13,  3.086677843130597e-14,
 -8.408357062773137e-16,  2.059318301617008e-17, -4.598852125102425e-19,  9.467856236327017e-21, -1.812179315786516e-22,  3.824996728404752e-07, -6.331167610004881e-08,
  5.500148685601084e-09, -3.309483321985254e-10,  1.544903340282521e-11, -5.950264521948773e-13,  1.965070509577933e-14, -5.712352218082818e-16,  1.489620403819267e-17,
 -3.534804908260497e-19,  7.718248899323564e-21, -1.564058699919829e-22,  1.518269003397232e-07, -2.722552009914390e-08,  2.555031994532420e-09, -1.655150909355066e-10,
  8.292279354544967e-12, -3.418055511740686e-13,  1.205000560735049e-14, -3.730695888326869e-16,  1.033959714523635e-17, -2.602609233547797e-19,  6.017341336134611e-21,
 -1.288983895336710e-22,  5.923826776695021e-08, -1.146318527812128e-08,  1.158386289150141e-09, -8.056169350444331e-11,  4.320845215370955e-12, -1.901747108100777e-13,
  7.141927038468039e-15, -2.350373149912428e-16,  6.910516405700371e-18, -1.841973339166543e-19,  4.502065749200752e-21, -1.017854041083350e-22,  2.279170121880157e-08,
 -4.741584854955032e-09,  5.143277537030410e-10, -3.829596970817812e-11,  2.193413329068769e-12, -1.028489552981091e-13,  4.105899752947847e-15, -1.433512268566153e-16,
  4.463128132740587e-18, -1.257556972926718e-19,  3.243951725827399e-21, -7.728502284147081e-23,  8.676651801912902e-09, -1.933598734005958e-09,  2.244527477222188e-10,
 -1.784427973126824e-11,  1.088746246966090e-12, -5.426513438106519e-14,  2.298079092170665e-15, -8.495285755937907e-17,  2.795617908877108e-18, -8.312303583515321e-20,
  2.259240837743760e-21, -5.662879710642174e-23,  3.280228885300461e-09, -7.802863504755065e-10,  9.663933257837829e-11, -8.181346552126529e-12,  5.304564685024716e-13,
 -2.803989541626775e-14,  1.257013528063403e-15, -4.910348587420414e-17,  1.704750181725368e-18, -5.339333846265600e-20,  1.526460490329114e-21, -4.018897321483128e-23,
  1.236236071026188e-09, -3.128173997534168e-10,  4.121442961221877e-11, -3.705607045955263e-12,  2.546933341451579e-13, -1.424582802678235e-14,  6.745966241966479e-16,
 -2.779087171051745e-17,  1.015946599766851e-18, -3.345731578775712e-20,  1.004367494625191e-21, -2.772907866856822e-23,  4.663387814006799e-10, -1.251015312897558e-10,
  1.748266685559226e-11, -1.664946143848553e-12,  1.210100260891740e-13, -7.145535360492688e-15,  3.566504674486466e-16, -1.546305928198596e-17,  5.940692046105199e-19,
 -2.053250663475087e-20,  6.460574996568053e-22, -1.867191029625261e-23,  1.768249950626013e-10, -5.012217850402145e-11,  7.407890193365687e-12, -7.452602473984784e-13,
  5.713609508449733e-14, -3.553459056441281e-15,  1.865307799868678e-16, -8.493473770842413e-18,  3.422389758650368e-19, -1.239041334355298e-20,  4.078893151127526e-22,
 -1.231864045674378e-23,  6.769203431380955e-11, -2.020779782503785e-11,  3.149451366039522e-12, -3.338087344188941e-13,  2.692676914730231e-14, -1.759609180764183e-15,
  9.692214078067387e-17, -4.624899816233690e-18,  1.950525752012749e-19, -7.382410811814709e-21,  2.537775619594070e-22, -7.994214989850294e-24,  2.628138790834593e-11,
 -8.235821768232969e-12,  1.349583149079870e-12, -1.502883636106122e-13,  1.272265959318394e-14, -8.714462517203459e-16,  5.025094870607779e-17, -2.507270806764315e-18,
  1.104404319903644e-19, -4.360860441575838e-21,  1.562301393569007e-22, -5.123381599113355e-24,  1.039621128270816e-11, -3.408803037410593e-12,  5.855796154036024e-13,
 -6.832328590861220e-14,  6.054031934827420e-15, -4.335601833666877e-16,  2.611009217142332e-17, -1.359075427601144e-18,  6.238587557279340e-20, -2.564487589588139e-21,
  9.555090013898049e-23, -3.255575907400423e-24,  4.209430840925226e-12, -1.439513506030469e-12,  2.584584640866627e-13, -3.150659260391854e-14,  2.914270209012735e-15,
 -2.176486368582639e-16,  1.365509207851015e-17, -7.397290529863576e-19,  3.530471164310355e-20, -1.507482272805354e-21,  5.828996239927777e-23, -2.059120833947780e-24,
  1.752538592647228e-12, -6.230568135832289e-13,  1.165668471366667e-13, -1.480326821327945e-14,  1.425396656012929e-15, -1.107204692328834e-16,  7.218276509891234e-18,
 -4.059575054506692e-19,  2.009646480062333e-20, -8.892813446468613e-22,  3.560519650938542e-23, -1.301217616197372e-24,  7.535325993423117e-13, -2.776103359222278e-13,
  5.395304643473961e-14, -7.116800767002542e-15,  7.113374249551710e-16, -5.731141042908067e-17,  3.872232514384832e-18, -2.255084522700028e-19,  1.155050887985504e-20,
 -5.284125140880284e-22,  2.185559754825804e-23, -8.244398397642656e-25,  3.359501933036620e-13, -1.278471273390124e-13,  2.573013356243494e-14, -3.514632055035553e-15,
  3.635884330311957e-16, -3.029819243847003e-17,  2.115721311964005e-18, -1.272498006578052e-19,  6.726226773939055e-21, -3.173253506243974e-22,  1.352535371415547e-23,
 -5.253786766897517e-25,  1.558464786691455e-13, -6.106712544773259e-14,  1.268653758889776e-14, -1.788955913273267e-15,  1.909669516213989e-16, -1.641095059741962e-17,
  1.181031462834191e-18, -7.315719449291879e-20,  3.979976276187609e-21, -1.931254577486406e-22,  8.461202465816769e-24, -3.376037241691947e-25,  7.542414686441334e-14,
 -3.033403675903517e-14,  6.483953174463946e-15, -9.408737321802092e-16,  1.033164342721049e-16, -9.128530584883008e-18,  6.750516005385438e-19, -4.294235974482513e-20,
  2.397769770674200e-21, -1.193473075615961e-22,  5.360484814935460e-24, -2.191344475192506e-25,  3.813171194649602e-14, -1.569038193553461e-14,  3.439399227337299e-15,
 -5.119083294280296e-16,  5.763993414426260e-17, -5.219851197693001e-18,  3.954427378271245e-19, -2.575728227110495e-20,  1.471858290302911e-21, -7.493668622539836e-23,
  3.441057151915369e-24, -1.437366449713410e-25,  2.012274418453975e-14, -8.444681528035924e-15,  1.891969324146689e-15, -2.878679233733915e-16,  3.312803323309917e-17,
 -3.065085387006785e-18,  2.371367911411648e-19, -1.576727535981478e-20,  9.193321130723700e-22, -4.773758863582372e-23,  2.234754926345933e-24, -9.511998095212387e-26,
  1.103670585267336e-14, -4.708789711224444e-15,  1.074590060871201e-15, -1.665764117974261e-16,  1.952682063033721e-17, -1.839773730355455e-18,  1.448960304113711e-19,
 -9.803741933353206e-21,  5.814670530665434e-22, -3.070230657564429e-23,  1.460967713233764e-24, -6.318421686428095e-26,  6.223012251706571e-15, -2.690744943108520e-15,
  6.233194750419233e-16, -9.809985487911510e-17,  1.167392138245777e-17, -1.116291360870619e-18,  8.920257682935808e-20, -6.122001507445528e-21,  3.681951340402363e-22,
 -1.970816618186971e-23,  9.504086558778509e-25, -4.164196199204143e-26,  3.517047628498523e-15, -1.536326795193672e-15,  3.600080309969671e-16, -5.732311621495686e-17,
  6.900773974729201e-18, -6.674234478575018e-19,  5.393282465352726e-20, -3.742177371464272e-21,  2.274916913093335e-22, -1.230528337515147e-23,  5.995369505070471e-25,
 -2.653310026408543e-26,  1.865998560710351e-15, -8.208887334638356e-16,  1.938993436920667e-16, -3.112497001308186e-17,  3.777161772043852e-18, -3.682184598893818e-19,
  2.998686385343665e-20, -2.096569889544662e-21,  1.284072260124237e-22, -6.996586800336745e-24,  3.433314097480385e-25, -1.530075502880525e-26,  7.240902575962962e-16,
 -3.197938736741746e-16,  7.587353653835735e-17, -1.223435145779608e-17,  1.491356667578069e-18, -1.460281657285925e-19,  1.194380401925274e-20, -8.386186883113367e-22,
  5.157632496409422e-23, -2.821726778534864e-24,  1.390184446465733e-25, -6.219560979696757e-27,  5.575624399712787e-02, -1.283700961047035e-04,  3.057514991067968e-07,
 -7.492841557573855e-10,  1.876962102895161e-12, -4.776583500718164e-15,  1.228209342045171e-17, -3.178147324008869e-20,  8.249588220508871e-23, -2.143914096035590e-25,
  5.569052405388175e-28, -1.445011209375879e-30,  5.308423868350413e-02, -1.520280402237117e-04,  5.132910672716147e-07, -1.810379482173452e-09,  6.351876016824123e-12,
 -2.188923463803134e-14,  7.401169576675057e-17, -2.460015594917010e-19,  8.055512656905990e-22, -2.603739262262383e-24,  8.319686791219288e-27, -2.631191111778685e-29,
  4.812151161960738e-02, -1.918931038856553e-04,  9.132061632616032e-07, -4.202870642654223e-09,  1.840129752676872e-11, -7.736162269701927e-14,  3.149062988305419e-16,
 -1.248214267988878e-18,  4.837047023998194e-21, -1.837971617098311e-23,  6.863735340774345e-26, -2.523706626072988e-28,  4.154069640195215e-02, -2.357427784230799e-04,
  1.465762780097922e-06, -8.289707149042640e-09,  4.361965102731183e-11, -2.176072466727187e-13,  1.040750929009340e-15, -4.806976652846159e-18,  2.155369681637142e-20,
 -9.419166523649648e-23,  4.024238964456745e-25, -1.684998704299072e-27,  3.415534365105811e-02, -2.707747529402709e-04,  2.097930406220833e-06, -1.424027979262259e-08,
  8.852430966981677e-11, -5.156329169648712e-13,  2.852231876699866e-15, -1.511916685420369e-17,  7.730479270457301e-20, -3.831360351122759e-22,  1.847660145468365e-24,
 -8.696033794275456e-27,  2.675558786847181e-02, -2.875808636489178e-04,  2.707369151918193e-06, -2.176143260628626e-08,  1.578367004105040e-10, -1.060523247111924e-12,
  6.707374558485412e-15, -4.036386538159062e-17,  2.329171454198937e-19, -1.296259179752562e-21,  6.988862687371188e-24, -3.663330032509397e-26,  1.997532946103762e-02,
 -2.824524849676322e-04,  3.183377662741229e-06, -2.998692108233421e-08,  2.512269436516314e-10, -1.928989893352878e-12,  1.382717372262547e-14, -9.368401939707105e-17,
  6.052998820163330e-19, -3.754175203217471e-21,  2.246506359172330e-23, -1.302229695170170e-25,  1.421945915013538e-02, -2.574576889655636e-04,  3.437474952919815e-06,
 -3.761237098973351e-08,  3.609830257064469e-10, -3.143465680881860e-12,  2.535811951008660e-14, -1.921539781157211e-16,  1.381338951861971e-18, -9.489973246510487e-21,
  6.266200601076852e-23, -3.994379436550302e-25,  9.656125867131261e-03, -2.187109524525952e-04,  3.429371739730019e-06, -4.324839050315381e-08,  4.721906435933048e-10,
 -4.633884756063825e-12,  4.182195484744369e-14, -3.524800416874675e-16,  2.804469061510297e-18, -2.123520535935153e-20,  1.539741246604683e-22, -1.074328423349598e-24,
  6.259092393757095e-03, -1.738512859175440e-04,  3.176256795102973e-06, -4.584907952658881e-08,  5.660395890945295e-10, -6.226067037583203e-12,  6.255137656532867e-14,
 -5.835994344187162e-16,  5.116286072296303e-18, -4.251571650001642e-20,  3.371441245523016e-22, -2.564696973206141e-24,  3.875299867145629e-03, -1.297735674722043e-04,
  2.742334384949672e-06, -4.502916400850508e-08,  6.252559674533356e-10, -7.671541126553534e-12,  8.541932768892172e-14, -8.786069324803963e-16,  8.454160219741430e-18,
 -7.681516622003834e-20,  6.638170674299768e-22, -5.486782484991428e-24,  2.293628862079696e-03, -9.125968066865050e-05,  2.215082880451111e-06, -4.113992548617142e-08,
  6.394167396044375e-10, -8.713712854836515e-12,  1.071082217186655e-13, -1.210140627578155e-15,  1.273661980264089e-17, -1.261228877126853e-19,  1.184061291828326e-21,
 -1.060200529128290e-23,  1.298815512769002e-03, -6.063130467864318e-05,  1.679322602943495e-06, -3.509505704911315e-08,  6.078720356416638e-10, -9.165019079691824e-12,
  1.239247884642912e-13, -1.532912910441432e-15,  1.759289732165486e-17, -1.893082541174397e-19,  1.925377304188834e-21, -1.862557484808749e-23,  7.043819242251337e-04,
 -3.815703833036461e-05,  1.198546461036418e-06, -2.804827863563135e-08,  5.392037702950204e-10, -8.962316426448158e-12,  1.328739915072056e-13, -1.794083940477210e-15,
  2.238951163404556e-17, -2.611056645918861e-19,  2.869659496389577e-21, -2.991929229570245e-23,  3.662570369299082e-04, -2.280200413996831e-05,  8.075657765111992e-07,
 -2.106727939296760e-08,  4.478068928885176e-10, -8.178239385082282e-12,  1.325469171976617e-13, -1.948114109754793e-15,  2.636795878139330e-17, -3.324525276557551e-19,
  3.939178146325020e-21, -4.416627871956893e-23,  1.828166837041739e-04, -1.296901506944354e-05,  5.150831069437225e-07, -1.491581616680466e-08,  3.493184049148582e-10,
 -6.987790757021116e-12,  1.234586469815231e-13, -1.970104817189185e-15,  2.885157779878985e-17, -3.923947990783585e-19,  5.001845725931874e-21, -6.018523431351668e-23,
  8.771850213545832e-05, -7.036698906150881e-06,  3.118142292900502e-07, -9.983226400241540e-09,  2.567324511881560e-10, -5.608844952024038e-12,  1.077407789853954e-13,
 -1.862172343923099e-15,  2.944022748303650e-17, -4.310001374013331e-19,  5.898557840801471e-21, -7.602383604433603e-23,  4.051989504486680e-05, -3.650464847097495e-06,
  1.796233942601338e-07, -6.334376631346460e-09,  1.783066165157617e-10, -4.242525557738012e-12,  8.838305204731670e-14, -1.650765835044905e-15,  2.811409298258325e-17,
 -4.421568002320793e-19,  6.484646008706059e-21, -8.936197216438866e-23,  1.804972779023159e-05, -1.814876860135603e-06,  9.872087091412245e-08, -3.820861901147681e-09,
  1.173714137519805e-10, -3.033396726071509e-12,  6.837133877234673e-14, -1.376949845121275e-15,  2.521122199105138e-17, -4.251452275386184e-19,  6.669746618845412e-21,
 -9.810604889188073e-23,  7.767726300059761e-06, -8.667543808972613e-07,  5.190154846801921e-08, -2.197177640911349e-09,  7.344196848678966e-11, -2.056429107107567e-12,
  5.003372626559778e-14, -1.084234128585278e-15,  2.130057024195954e-17, -3.844453843905347e-19,  6.440530139875425e-21, -1.009524244502777e-22,  3.236018119258920e-06,
 -3.986253416208350e-07,  2.617284168275691e-08, -1.207971714318197e-09,  4.381314441710287e-11, -1.325894771562068e-12,  3.474565681656657e-14, -8.085301044847475e-16,
  1.701140485681469e-17, -3.280341126590561e-19,  5.858671454458535e-21, -9.770483179058635e-23,  1.307907265621736e-06, -1.770006637567016e-07,  1.269503220480356e-08,
 -6.368084483318837e-10,  2.499529511419497e-11, -8.155756883547508e-13,  2.297016447381636e-14, -5.728471758163405e-16,  1.288439335634379e-17, -2.649927062268609e-19,
  5.037378800464757e-21, -8.924308549594113e-23,  5.140847127662273e-07, -7.608660357285807e-08,  5.940073392301901e-09, -3.228761912016529e-10,  1.367908694679246e-11,
 -4.801293425579073e-13,  1.450288988399911e-14, -3.868747242660400e-16,  9.285352488505273e-18, -2.033432767578559e-19,  4.107730903550647e-21, -7.719141581052219e-23,
  1.970242014043726e-07, -3.175535762857588e-08,  2.689345996408207e-09, -1.579446151613925e-10,  7.204401515487598e-12, -2.714000885972969e-13,  8.774200888344547e-15,
 -2.498848475808677e-16,  6.388566307981926e-18, -1.487223000724403e-19,  3.187638140985671e-21, -6.344313191049953e-23,  7.383539229456421e-08, -1.290718682880033e-08,
  1.181919511884838e-09, -7.478977477688071e-11,  3.663804713627114e-12, -1.478045583356834e-13,  5.103911393318089e-15, -1.548943880607251e-16,  4.210883691619733e-18,
 -1.040330886967078e-19,  2.362152421752127e-21, -4.971945150822173e-23,  2.713967923157264e-08, -5.125867929618755e-09,  5.059182252732191e-10, -3.439882496489825e-11,
  1.805404892249740e-12, -7.782471706277850e-14,  2.864663661903824e-15, -9.246843605859915e-17,  2.668363921979010e-18, -6.984783821107986e-20,  1.677468835791360e-21,
 -3.728447347334341e-23,  9.817043770828784e-09, -1.995864693952302e-09,  2.116755544676893e-10, -1.542337580404572e-11,  8.651840265196334e-13, -3.976392183706005e-14,
  1.557080200061710e-15, -5.335854993681985e-17,  1.631571510535525e-18, -4.517550646635213e-20,  1.145738334648967e-21, -2.685097776555302e-23,  3.507050364470006e-09,
 -7.647600471742932e-10,  8.689463293984016e-11, -6.767069908948068e-12,  4.047552411262371e-13, -1.979076699559428e-14,  8.227577545111408e-16, -2.987570298239940e-17,
  9.662721236573731e-19, -2.825240912989658e-20,  7.554827439632621e-22, -1.863955546093713e-23,  1.242075266951464e-09, -2.895017914198187e-10,  3.513757072536525e-11,
 -2.917040399985955e-12,  1.855939245495034e-13, -9.633213492369965e-15,  4.243090318996387e-16, -1.629487318580761e-17,  5.564521418005339e-19, -1.715139420116705e-20,
  4.827767743228943e-22, -1.252027644663692e-23,  4.378924442113134e-10, -1.087203787655652e-10,  1.405478039710800e-11, -1.240583313455532e-12,  8.376063011511596e-14,
 -4.604936815373320e-15,  2.144559601700145e-16, -8.693281639498037e-18,  3.128639617371383e-19, -1.014801583093313e-20,  3.001776576340152e-22, -8.169649010249782e-24,
  1.543392684451445e-10, -4.068222073769540e-11,  5.585452765817120e-12, -5.228264136053380e-13,  3.736959608214626e-14, -2.171218949149781e-15,  1.066855929792420e-16,
 -4.555783084530945e-18,  1.724677649321171e-19, -5.876294233107336e-21,  1.823477305622169e-22, -5.199485314490687e-24,  5.463257665877030e-11, -1.523795883547048e-11,
  2.215493353412970e-12, -2.193435848085250e-13,  1.655665228208385e-14, -1.014297996117027e-15,  5.247081678568239e-17, -2.355576793786860e-18,  9.361980663343975e-20,
 -3.344434292365971e-21,  1.086778638941943e-22, -3.241051537177387e-24,  1.951467321005102e-11, -5.740601407944643e-12,  8.813234431174591e-13, -9.204273356218061e-14,
  7.318870222283982e-15, -4.716584001075771e-16,  2.563101197675786e-17, -1.207116886403350e-18,  5.026525104569364e-20, -1.879059566404257e-21,  6.382210505809019e-23,
 -1.987097183733538e-24,  7.068870628748432e-12, -2.185991688485094e-12,  3.533413003640728e-13, -3.882160807003327e-14,  3.243625163143026e-15, -2.193607744729028e-16,
  1.249360764035640e-17, -6.159204530924297e-19,  2.681510810781974e-20, -1.046871768299896e-21,  3.709294846348750e-23, -1.203442397944627e-24,  2.609869348500373e-12,
 -8.456771428578359e-13,  1.434948707918412e-13, -1.654022995474805e-14,  1.448330419639727e-15, -1.025326616719253e-16,  6.105923579012009e-18, -3.143789267642319e-19,
  1.427890814851029e-20, -5.809448011552421e-22,  2.142969554170340e-23, -7.230688544738617e-25,  9.871791699378087e-13, -3.340835294433740e-13,  5.932946209843898e-14,
 -7.154414599824767e-15,  6.547898687895715e-16, -4.840022588031701e-17,  3.006264091837868e-18, -1.612745712397794e-19,  7.624347011734792e-21, -3.225602377332772e-22,
  1.236085722625343e-23, -4.328558280757921e-25,  3.845029062390457e-13, -1.354618209810413e-13,  2.510090949878129e-14, -3.157414310781651e-15,  3.012010766043538e-16,
 -2.318445445286661e-17,  1.498148893627397e-18, -8.353295261681101e-20,  4.100656607375933e-21, -1.799810739264448e-22,  7.149060402761226e-24, -2.592571162826069e-25,
  1.549836440034037e-13, -5.665577665383814e-14,  1.091994692831117e-14, -1.428581753055703e-15,  1.416386935451235e-16, -1.132185803093048e-17,  7.590954694160451e-19,
 -4.387770965637313e-20,  2.231076176827228e-21, -1.013449415762769e-22,  4.162825565480480e-24, -1.559787106028758e-25,  6.495012051906711e-14, -2.455610988744573e-14,
  4.907462237666732e-15, -6.656557208294156e-16,  6.838960289611151e-17, -5.660775671881869e-18,  3.927080436389699e-19, -2.346895852554267e-20,  1.232837108402211e-21,
 -5.781050424447748e-23,  2.449551922804021e-24, -9.460588654828990e-26,  2.841717173670545e-14, -1.107539758417754e-14,  2.287517369810680e-15, -3.206940738502370e-16,
  3.403784686380094e-17, -2.908742889215677e-18,  2.081900142768476e-19, -1.282750254123502e-20,  6.942427252152288e-22, -3.351768630406484e-23,  1.461256826868869e-24,
 -5.802581266690444e-26,  1.302339631817417e-14, -5.215270956462798e-15,  1.109545339994401e-15, -1.602472187024295e-16,  1.751516914351450e-17, -1.540545495130804e-18,
  1.134190480263678e-19, -7.183859657991784e-21,  3.994381472018290e-22, -1.980027167397190e-23,  8.857767327534459e-25, -3.606954771033225e-26,  6.264321394430442e-15,
 -2.569060443421759e-15,  5.610870285978502e-16, -8.320308922726048e-17,  9.334547612486496e-18, -8.423310752453120e-19,  6.359146255672593e-20, -4.128024670294342e-21,
  2.351103343890209e-22, -1.193162366026687e-23,  5.461744301755822e-25, -2.274463761673584e-26,  3.162109791521871e-15, -1.323723637940873e-15,  2.957577019374205e-16,
 -4.487611004524921e-17,  5.150309623895989e-18, -4.752469765744346e-19,  3.667252841978397e-20, -2.432151205720835e-21,  1.414572680633921e-22, -7.327550093288989e-24,
  3.422155498435608e-25, -1.453252967952095e-26,  1.668887351783309e-15, -7.107869268594248e-16,  1.618932385619066e-16, -2.504654335611016e-17,  2.930383549778591e-18,
 -2.755699534381345e-19,  2.166289040863218e-20, -1.463062557259906e-21,  8.662155769574607e-23, -4.565835734845190e-24,  2.168984829346799e-25, -9.365067611213145e-27,
  9.114324361754990e-16, -3.936415256348293e-16,  9.107181130174914e-17, -1.431464587979333e-17,  1.701273018066965e-18, -1.624761989502367e-19,  1.296748952649088e-20,
 -8.888943773854121e-22,  5.339800150233583e-23, -2.854929081039073e-24,  1.375223770529108e-25, -6.018952125668714e-27,  5.024422010745376e-16, -2.193304640764501e-16,
  5.135683707694534e-17, -8.171134124112679e-18,  9.829238219464200e-19, -9.499450120502305e-20,  7.670637756710803e-21, -5.318518497152062e-22,  3.230923194614002e-23,
 -1.746442387095704e-24,  8.503286597916660e-26, -3.760749914286482e-27,  2.619504792107350e-16, -1.151970910054789e-16,  2.719963493038511e-17, -4.364378633142200e-18,
  5.294279774969068e-19, -5.159136807841441e-20,  4.199867466326999e-21, -2.935283153103422e-22,  1.797088152104688e-23, -9.788328735598092e-25,  4.801549106782879e-26,
 -2.139093336620087e-27,  1.006551462759688e-16, -4.444695865173071e-17,  1.054340519405035e-17, -1.699762919328313e-18,  2.071599405600572e-19, -2.028048849233559e-20,
  1.658451977200026e-21, -1.164244680188845e-22,  7.158972764288488e-24, -3.915948613640495e-25,  1.928933602633532e-26, -8.628369938864763e-28,  5.524759940240937e-02,
 -1.259595463754671e-04,  2.969371761200617e-07, -7.200012969039764e-10,  1.784307566890858e-12, -4.492200509353464e-15,  1.142803998564663e-17, -2.926091642480718e-20,
  7.516390872379150e-23, -1.933356934473396e-25,  4.971045371150458e-28, -1.276909086524992e-30,  5.248420398687527e-02, -1.480069148464341e-04,  4.921621530384773e-07,
 -1.712157522811059e-09,  5.931310894305203e-12, -2.019278195953639e-14,  6.747089276518310e-17, -2.216616415286164e-19,  7.175380790759239e-22, -2.292987562930494e-24,
  7.244509218365127e-27, -2.265661799921675e-29,  4.736823799886390e-02, -1.847843021970071e-04,  8.644884798777991e-07, -3.920428680012606e-09,  1.692689950221771e-11,
 -7.020637371938861e-14,  2.820274810661834e-16, -1.103506570013995e-18,  4.222233355243647e-21, -1.584396674794689e-23,  5.844194259822473e-26, -2.122799510354184e-28,
  4.062056379969564e-02, -2.244030397477823e-04,  1.370334434408135e-06, -7.625297152145207e-09,  3.950677398679352e-11, -1.941694559691341e-13,  9.153232109857818e-16,
 -4.168545408083692e-18,  1.843552855910910e-20, -7.948461096601614e-23,  3.351126387161725e-25, -1.384939533434267e-27,  3.310476225413025e-02, -2.546515248009641e-04,
  1.935216731020327e-06, -1.290281185793252e-08,  7.886328909985169e-11, -4.519921104505727e-13,  2.461551740774998e-15, -1.285255179732770e-17,  6.475491103017032e-20,
 -3.163484297763435e-22,  1.504192702414313e-24, -6.981985150429706e-27,  2.564698700475919e-02, -2.669250846346989e-04,  2.460711655852980e-06, -1.939735234804026e-08,
  1.381486366784110e-10, -9.123075531062575e-13,  5.674885008718876e-15, -3.360620936743507e-17,  1.909181944186719e-19, -1.046461695529728e-21,  5.558626434204898e-24,
 -2.871396081090220e-26,  1.889426730556809e-02, -2.583593213431276e-04,  2.846435323510627e-06, -2.625875176631417e-08,  2.157639957618842e-10, -1.626545734988252e-12,
  1.145605241550948e-14, -7.631401445742857e-17,  4.850326521782477e-19, -2.960510157305646e-21,  1.744116600934903e-23, -9.956710858090851e-26,  1.324190203126809e-02,
 -2.316696677310972e-04,  3.018808506385242e-06, -3.230827342044105e-08,  3.037883907979554e-10, -2.594738821175061e-12,  2.054854782895190e-14, -1.529660046893198e-16,
  1.080879038639293e-18, -7.302725572319016e-21,  4.744065881617622e-23, -2.976348024679457e-25,  8.833037589237943e-03, -1.932301705618944e-04,  2.952830899033483e-06,
 -3.638340774634706e-08,  3.888003530567326e-10, -3.739116224802671e-12,  3.310195870224017e-14, -2.738665108442383e-16,  2.140341257835360e-18, -1.592754014329134e-20,
  1.135535626636134e-22, -7.793422792835623e-25,  5.611228346383047e-03, -1.504969845840564e-04,  2.676548237007901e-06, -3.771229009310376e-08,  4.552969091128071e-10,
 -4.903749294030074e-12,  4.828994541127873e-14, -4.419703775732358e-16,  3.803514559871277e-18, -3.104428968609988e-20,  2.419172215116161e-22, -1.809248319171580e-24,
  3.396886318968175e-03, -1.098371991129807e-04,  2.257284985532917e-06, -3.614897366313777e-08,  4.904808829548468e-10, -5.888501956438837e-12,  6.422404580080605e-14,
 -6.476324439916875e-16,  6.113758904975824e-18, -5.453241179862060e-20,  4.628683723012587e-22, -3.759528944513834e-24,  1.961133982020559e-03, -7.535220412602143e-05,
  1.777459561638098e-06, -3.217452522323824e-08,  4.883251970788218e-10, -6.507556960802972e-12,  7.830795335323111e-14, -8.669155273235146e-16,  8.947043176543526e-18,
 -8.693278210463212e-20,  8.012580083696653e-22, -7.047123145108302e-24,  1.080708526936810e-03, -4.872889440618965e-05,  1.310974894512028e-06, -2.668743414035961e-08,
  4.511408257817690e-10, -6.648069871407627e-12,  8.795766553663349e-14, -1.065586079987907e-15,  1.198678790423382e-17, -1.265088724328597e-19,  1.262723950987634e-21,
 -1.199419044660334e-23,  5.689892601245995e-04, -2.978089684736917e-05,  9.083334209604971e-07, -2.069744829220879e-08,  3.881624678110578e-10, -6.303145141419708e-12,
  9.140121953022596e-14, -1.208206172122753e-15,  1.477330087355395e-17, -1.689214727513756e-19,  1.821372835559827e-21, -1.864044227149020e-23,  2.865258382403814e-04,
 -1.724229742029904e-05,  5.928632919181046e-07, -1.505500853104144e-08,  3.120845557694827e-10, -5.566391895621926e-12,  8.820994181330501e-14, -1.268858239506389e-15,
  1.682213485019513e-17, -2.078970495591958e-19,  2.416072457253259e-21, -2.658426691010099e-23,  1.381696982977637e-04, -9.478956317845034e-06,  3.654903600010857e-07,
 -1.030081111903417e-08,  2.352129005469977e-10, -4.594201515399460e-12,  7.934550746397409e-14, -1.238910487340081e-15,  1.776761163523463e-17, -2.368125956044106e-19,
  2.960130890726828e-21, -3.494776654683571e-23,  6.389040516815463e-05, -4.959242204083395e-06,  2.133708882196140e-07, -6.648409831270601e-09,  1.666847194295394e-10,
 -3.555157674629233e-12,  6.674689284470907e-14, -1.128637607482050e-15,  1.747109397545925e-17, -2.506205365321685e-19,  3.362993385574895e-21, -4.252310820476124e-23,
  2.837142128534058e-05, -2.474799427267737e-06,  1.182626579189932e-07, -4.059081840498629e-09,  1.113930378066613e-10, -2.587420900668416e-12,  5.268054235012640e-14,
 -9.625421745206732e-16,  1.604985286225909e-17, -2.473163042814745e-19,  3.556105449400732e-21, -4.807396890525366e-23,  1.211901803348217e-05, -1.180676757591466e-06,
  6.239271189232854e-08, -2.350739517263607e-09,  7.040690163715335e-11, -1.776466740524787e-12,  3.913380318145385e-14, -7.709997646252295e-16,  1.382116248324879e-17,
 -2.283589860310947e-19,  3.512390814600999e-21, -5.068276317455530e-23,  4.988706249299752e-06, -5.397783281364993e-07,  3.141475257389716e-08, -1.294974886095109e-09,
  4.221207888141316e-11, -1.154104029214537e-12,  2.744694180924806e-14, -5.819067735824785e-16,  1.119365385558741e-17, -1.979602982000262e-19,  3.251688376539516e-21,
 -5.000415676110896e-23,  1.982972567559822e-06, -2.370632307278502e-07,  1.513627492185560e-08, -6.805121145523035e-10,  2.407734725968472e-11, -7.116331746657804e-13,
  1.823205021481030e-14, -4.151524175765845e-16,  8.554050225820211e-18, -1.616510615376965e-19,  2.831161092694988e-21, -4.632805461227905e-23,  7.628072252755468e-07,
 -1.002775881402700e-07,  6.998520658450900e-09, -3.421386437638984e-10,  1.310529363769484e-11, -4.177721567280284e-13,  1.150675960141462e-14, -2.808777718097314e-16,
  6.188239564765903e-18, -1.247564186355863e-19,  2.326123631626225e-21, -4.044416055902234e-23,  2.846665555462635e-07, -4.096639211154624e-08,  3.114348238977955e-09,
 -1.650753749350568e-10,  6.828238132724184e-12, -2.342498517082418e-13,  6.922336861967290e-15, -1.808037529122445e-16,  4.252054043928571e-18, -9.130338969161388e-20,
  1.809602455592420e-21, -3.338289922037633e-23,  1.033321371382022e-07, -1.621084599990703e-08,  1.337949157978763e-09, -7.667561516622919e-11,  3.416682354913458e-12,
 -1.258656363868905e-13,  3.982743079343149e-15, -1.111062550907101e-16,  2.784443463234366e-18, -6.358163468243754e-20,  1.337535653108314e-21, -2.614244151100892e-23,
  3.659074181954632e-08, -6.232952426748581e-09,  5.567204982896265e-10, -3.440144548862673e-11,  1.647432575546099e-12, -6.502971996586131e-14,  2.199082540706957e-15,
 -6.540609631076630e-17,  1.743811116830155e-18, -4.227806573207647e-20,  9.425853531323199e-22, -1.949154264442392e-23,  1.267987847730014e-08, -2.336376146092651e-09,
  2.251429925498181e-10, -1.496125421351865e-11,  7.681796886020737e-13, -3.242268093756011e-14,  1.169477246291274e-15, -3.701781461092379e-17,  1.048206652856285e-18,
 -2.694025471031563e-20,  6.356123045346351e-22, -1.388626336130797e-23,  4.314747804704267e-09, -8.568511352843942e-10,  8.881668908929345e-11, -6.330595801624322e-12,
  3.476924632617776e-13, -1.565844404321638e-14,  6.012625475694065e-16, -2.021832632265793e-17,  6.070240132998830e-19, -1.651243937502613e-20,  4.116554415699819e-22,
 -9.487912401667826e-24,  1.447112380283616e-09, -3.086335290257937e-10,  3.431125876973128e-11, -2.616451562089026e-12,  1.533618177450917e-13, -7.353989590472145e-15,
  3.000312671299256e-16, -1.069848799006555e-17,  3.399917845776234e-19, -9.772953058941347e-21,  2.570494414521845e-22, -6.241112010142900e-24,  4.802757719239582e-10,
 -1.096303839843833e-10,  1.303408945082394e-11, -1.060661732371760e-12,  6.619625698733735e-14, -3.372650711576834e-15,  1.459112608103208e-16, -5.507068314417072e-18,
  1.849264581963014e-19, -5.607834261717037e-21,  1.553727937563970e-22, -3.968054894626519e-24,  1.584098748713618e-10, -3.857095289236284e-11,  4.890251590702718e-12,
 -4.235878817249738e-13,  2.808306337059076e-14, -1.516992620323475e-15,  6.945546985813790e-17, -2.769478577880671e-18,  9.809298882685178e-20, -3.132853092835285e-21,
  9.128709015416006e-23, -2.448486994788272e-24,  5.216319737934702e-11, -1.350329895457171e-11,  1.820547331253893e-12, -1.674255340042303e-13,  1.176380922906780e-14,
 -6.722652373266646e-16,  3.250732776574891e-17, -1.366768976464911e-18,  5.096851457216455e-20, -1.711405640865879e-21,  5.235854390789418e-23, -1.472532813894748e-24,
  1.723238591196313e-11, -4.727071440984580e-12,  6.757931689236948e-13, -6.581442522785546e-14,  4.889182878274001e-15, -2.949263947716200e-16,  1.503001162088498e-17,
 -6.650144767121230e-19,  2.606047310292996e-20, -9.183245058117218e-22,  2.944708220689905e-23, -8.669263939443692e-25,  5.740481517372183e-12, -1.663210458167991e-12,
  2.514131537868850e-13, -2.586102643923749e-14,  2.026237753393181e-15, -1.287230772191291e-16,  6.898660908314467e-18, -3.205520109783948e-19,  1.317463304130716e-20,
 -4.862902486104716e-22,  1.631417922140077e-23, -5.018882884010471e-25,  1.938633424778395e-12, -5.913303182092417e-13,  9.423989308646835e-14, -1.021133853619921e-14,
  8.417221090583738e-16, -5.618173022548550e-17,  3.159286858344232e-18, -1.538339353975239e-19,  6.617406836505682e-21, -2.553465217413112e-22,  8.945334538689884e-24,
 -2.870390682683629e-25,  6.674069945800795e-13, -2.136202821773925e-13,  3.578780365048813e-14, -4.073651823120134e-15,  3.523623164928844e-16, -2.464964179374086e-17,
  1.451019846854622e-18, -7.387407951278280e-20,  3.318853381271166e-21, -1.336024420041517e-22,  4.877624660478731e-24, -1.629345794722274e-25,  2.355531806301714e-13,
 -7.885602445354901e-14,  1.384566309264827e-14, -1.650974947976278e-15,  1.494530467815461e-16, -1.092982241213995e-17,  6.718675871296882e-19, -3.568114096251648e-20,
  1.670371944175744e-21, -6.999643802030310e-23,  2.657544432493189e-24, -9.222676456777432e-26,  8.571546015783433e-14, -2.991363234295992e-14,  5.487856297272453e-15,
 -6.835112893053682e-16,  6.457504347314176e-17, -4.923867123574648e-18,  3.152648384062295e-19, -1.742200035814801e-20,  8.478495696644184e-22, -3.689941725720892e-23,
  1.453674722225539e-24, -5.229690957409891e-26,  3.233928988313086e-14, -1.172643957162895e-14,  2.240728626387548e-15, -2.906326885553232e-16,  2.857374209318386e-17,
 -2.265364995903185e-18,  1.506763265364808e-19, -8.641977624247609e-21,  4.361084862079370e-22, -1.966440744370161e-23,  8.019557754908464e-25, -2.984001905933627e-26,
  1.271804378970530e-14, -4.775671701695206e-15,  9.474268030019602e-16, -1.275744487635004e-16,  1.301334274724393e-17, -1.069627893936911e-18,  7.369900863034123e-20,
 -4.375201096882653e-21,  2.283485222237689e-22, -1.064048768913704e-23,  4.481004726153181e-25, -1.720346855709933e-26,  5.238832815271027e-15, -2.030350949854868e-15,
  4.168032595388745e-16, -5.807846713549334e-17,  6.127588572280569e-18, -5.205888055735134e-19,  3.704878362835400e-20, -2.270094545055729e-21,  1.221977947245871e-22,
 -5.868637085540478e-24,  2.545424773693799e-25, -1.005745335416235e-26,  2.269471831434856e-15, -9.047311381377611e-16,  1.915360007422056e-16, -2.752677128802008e-17,
  2.994144867978605e-18, -2.621032802529723e-19,  1.920758952962559e-20, -1.211111063614892e-21,  6.704476189302337e-23, -3.309211971920035e-24,  1.474224196568924e-25,
 -5.978834103640828e-27,  1.036746793802007e-15, -4.236956815786618e-16,  9.218063619995144e-17, -1.361670878233223e-17,  1.521857421523765e-18, -1.368188757808457e-19,
  1.029158681470607e-20, -6.657096881470242e-22,  3.778435050468382e-23, -1.911064663974250e-24,  8.719264847663414e-26, -3.619427466676214e-27,  4.997308751067055e-16,
 -2.086538256804448e-16,  4.648512413984469e-17, -7.032898855906207e-18,  8.048423775036274e-19, -7.405938713362144e-20,  5.699182282339228e-21, -3.769656170551743e-22,
  2.186776752686885e-23, -1.129884722874986e-24,  5.263792986780925e-26, -2.229942659044939e-27,  2.533987439900320e-16, -1.077260424347094e-16,  2.448631120219575e-17,
 -3.780493959273366e-18,  4.414102397087968e-19, -4.142704518527223e-20,  3.250287407134106e-21, -2.190994771928989e-22,  1.294784264674233e-23, -6.812466178519887e-25,
  3.230520869166951e-26, -1.392450777583862e-27,  1.338588449544914e-16, -5.774346206896309e-17,  1.334144739661129e-17, -2.094163892841418e-18,  2.485545491474306e-19,
 -2.370640585960600e-20,  1.889610353045728e-21, -1.293658240088337e-22,  7.761759957512796e-24, -4.144851574390318e-25,  1.994242299461298e-26, -8.718262197221665e-28,
  7.189760616291536e-17, -3.136319744147940e-17,  7.337942736849835e-18, -1.166564451257872e-18,  1.402167590655105e-19, -1.354060327694646e-20,  1.092539811680497e-21,
 -7.569546193364466e-23,  4.595009231199672e-24, -2.481999996639211e-25,  1.207616843978294e-26, -5.337273218049125e-28,  3.680462649320147e-17, -1.617958294043386e-17,
  3.818658956270771e-18, -6.124764267946767e-19,  7.426671170555607e-20, -7.234145318727828e-21,  5.886697168246586e-22, -4.112588848711744e-23,  2.516907082725168e-24,
 -1.370383711751993e-25,  6.719766036842612e-27, -2.992577178837391e-28,  1.399773070603987e-17, -6.180021218645931e-18,  1.465699067438378e-18, -2.362470507247872e-19,
  2.878710609660948e-20, -2.817640217920024e-21,  2.303699882747103e-22, -1.616903995772662e-23,  9.940513210494251e-25, -5.436437227288970e-26,  2.677411624519971e-27,
 -1.197425493307907e-28,  5.474845816791889e-02, -1.236181304297897e-04,  2.884655367537995e-07, -6.921564995061742e-10,  1.697141300405595e-12, -4.227493721507332e-15,
  1.064138816154512e-17, -2.696330224869465e-20,  6.854860855082521e-23, -1.745304594153637e-25,  4.442286191439844e-28, -1.129754541517806e-30,  5.189992303583096e-02,
 -1.441502179983635e-04,  4.721726207159724e-07, -1.620401476067763e-09,  5.543158633587563e-12, -1.864543854863650e-14,  6.157380194192525e-17, -1.999671483865704e-19,
  6.399750661521206e-22, -2.022191942931670e-24,  6.317952565431516e-27, -1.954121485488380e-29,  4.664264101535758e-02, -1.780520751933754e-04,  8.190231450896914e-07,
 -3.660473781232520e-09,  1.558803259633324e-11, -6.379373612957106e-14,  2.529382240026603e-16, -9.770877023386299e-19,  3.691771983410976e-21, -1.368283327050279e-23,
  4.985751794181571e-26, -1.789265252700627e-28,  3.974431226009087e-02, -2.137959202685166e-04,  1.282499127752269e-06, -7.023100818030161e-09,  3.583394180808591e-11,
 -1.735382216396508e-13,  8.064506625226186e-16, -3.621919166654821e-18,  1.580137123694838e-20, -6.722342665829475e-23,  2.797208138175005e-25, -1.141162124844510e-27,
  3.211616841218119e-02, -2.397683418718981e-04,  1.787665622814838e-06, -1.171022638093771e-08,  7.038623667192915e-11, -3.970092945614400e-13,  2.129057850585527e-15,
 -1.095157409558999e-17,  5.437924290799499e-20, -2.619018439357302e-22,  1.228029993437462e-24, -5.622413399516504e-27,  2.461723513343171e-02, -2.481342280406826e-04,
  2.240626699318062e-06, -1.732585126157070e-08,  1.211916646971706e-10, -7.867449733384223e-13,  4.814071258878168e-15, -2.805903064502647e-17,  1.569609754919546e-19,
 -8.474668313170871e-22,  4.435711563317496e-24, -2.258446350025454e-26,  1.790445703202292e-02, -2.367919498098106e-04,  2.551016604308070e-06, -2.305253263004698e-08,
  1.858181167260296e-10, -1.375581976186361e-12,  9.521444889343190e-15, -6.237170143327997e-17,  3.900232947853566e-19, -2.343200183102793e-21,  1.359261976803951e-23,
 -7.643118148961091e-26,  1.236118053335797e-02, -2.089911432322329e-04,  2.658643364084107e-06, -2.783741097864238e-08,  2.564975533218632e-10, -2.149292223272707e-12,
  1.671268110908943e-14, -1.222421668362031e-16,  8.492009794731824e-19, -5.643315184767532e-21,  3.607417543017838e-23, -2.227844090628275e-25,  8.104739206660935e-03,
 -1.712535886634579e-04,  2.551220043104014e-06, -3.072017019647271e-08,  3.213792288511607e-10, -3.029448945255474e-12,  2.631225137421597e-14, -2.137361640620911e-16,
  1.641066183379879e-18, -1.200395636650833e-20,  8.416026359213407e-23, -5.682506142153501e-25,  5.049364543716084e-03, -1.307780123680349e-04,  2.264665832893796e-06,
 -3.115314206065617e-08,  3.678760506276518e-10, -3.880508690182150e-12,  3.746320226456295e-14, -3.364171633702926e-16,  2.842475760083943e-18, -2.279118451304226e-20,
  1.745579126619975e-22, -1.283653509474992e-24,  2.991083954296724e-03, -9.338909465260038e-05,  1.866952400383145e-06, -2.916548145444162e-08,  3.867627815203454e-10,
 -4.544315793851662e-12,  4.855788925412466e-14, -4.801298176628880e-16,  4.447483790459722e-18, -3.894930582934495e-20,  3.247656804043081e-22, -2.592485155133615e-24,
  1.685894518730836e-03, -6.255334718386308e-05,  1.434259037397235e-06, -2.530812356477015e-08,  3.751574931180069e-10, -4.889781908691194e-12,  5.761293407604267e-14,
 -6.250574294583186e-16,  6.326670727205727e-18, -6.032661248229606e-20,  5.459702486247573e-22, -4.717308821169909e-24,  9.049010988123497e-04, -3.940878904708668e-05,
  1.029993059294718e-06, -2.042759054130822e-08,  3.370798620879836e-10, -4.855662224507137e-12,  6.287061513573219e-14, -7.460766623845795e-16,  8.227255228347673e-18,
 -8.517644064290093e-20,  8.344610300364231e-22, -7.783823209668161e-24,  4.629633344611489e-04, -2.341098667293219e-05,  6.934243794305201e-07, -1.538677319243228e-08,
  2.815495959023288e-10, -4.467206241199652e-12,  6.336734294014548e-14, -8.201607625431437e-16,  9.827121328210400e-18, -1.101852482449829e-19,  1.165707304449706e-21,
 -1.171206249173163e-23,  2.260078392071059e-04, -1.314491391172977e-05,  4.388315351130503e-07, -1.084832016636921e-08,  2.193366175434053e-10, -3.821162049045748e-12,
  5.921388924826439e-14, -8.337187384322787e-16,  1.082783833949527e-17, -1.311806728571316e-19,  1.495416921755590e-21, -1.614916253040537e-23,  1.054007526974880e-04,
 -6.991859622549407e-06,  2.617343984340035e-07, -7.179742361989783e-09,  1.598633088864916e-10, -3.049064683275594e-12,  5.148127953544455e-14, -7.866045877808358e-16,
  1.104825515012635e-17, -1.443210796686591e-19,  1.769180116739550e-21, -2.049581302899251e-23,  4.701962618339134e-05, -3.530947959145328e-06,  1.475004002302646e-07,
 -4.472947950678273e-09,  1.093353034245657e-10, -2.276770699379504e-12,  4.178157494879489e-14, -6.912271612897782e-16,  1.047754814317902e-17, -1.472804791814910e-19,
  1.937864826461927e-21, -2.404056094394505e-23,  2.009403700523331e-05, -1.696763347731655e-06,  7.873949625454721e-08, -2.630300887747413e-09,  7.037320419424071e-11,
 -1.595804623566962e-12,  3.175531250555608e-14, -5.676175294196876e-16,  9.266965356846474e-18, -1.399158049168876e-19,  1.972507017187805e-21, -2.616015355494847e-23,
  8.239791587071101e-06, -7.776216696547310e-07,  3.991764803906132e-08, -1.463962611116822e-09,  4.275031938057490e-11, -1.053058891231856e-12,  2.267246991663279e-14,
 -4.369815629015077e-16,  7.669616544039323e-18, -1.241606394588048e-19,  1.872356201264357e-21, -2.650477057561009e-23,  3.247970085469525e-06, -3.406839380888877e-07,
  1.926808945811027e-08, -7.733352895832193e-10,  2.458169898339401e-11, -6.562055740935013e-13,  1.525370799405878e-14, -3.163912222365748e-16,  5.959172964873675e-18,
 -1.032641241868664e-19,  1.663104886845471e-21, -2.509082308823806e-23,  1.233173793732606e-06, -1.430333742640048e-07,  8.879293693966620e-09, -3.888189376426253e-10,
  1.341840759596394e-11, -3.873081248766907e-13,  9.700528862985144e-15, -2.161324690607002e-16,  4.360977379319910e-18, -8.076072127970728e-20,  1.386996587853340e-21,
 -2.226905575112903e-23,  4.519742474298614e-07, -5.769677374455011e-08,  3.917398541351957e-09, -1.866115138437791e-10,  6.974565512437601e-12, -2.171929628766148e-13,
  5.849642941975041e-15, -1.397477906219229e-16,  3.015676449792507e-18, -5.959019267062512e-20,  1.089719038571759e-21, -1.859357286554211e-23,  1.603020875821298e-07,
 -2.242290073413887e-08,  1.659476529911586e-09, -8.575594492991829e-11,  3.462726905641714e-12, -1.160891281199011e-13,  3.355699316782422e-15, -8.580716384093403e-17,
  1.977104403619130e-18, -4.162261694522548e-20,  8.092961865404486e-22, -1.465487183655207e-23,  5.516524218426720e-08, -8.420518366050698e-09,  6.770884867547793e-10,
 -3.785414716744507e-11,  1.647484250881832e-12, -5.933783621940318e-14,  1.837427060517985e-15, -5.020216357653513e-17,  1.233093701430401e-18, -2.761540282256991e-20,
  5.700993422499087e-22, -1.094117054286649e-23,  1.847442737052880e-08, -3.065256888453493e-09,  2.669630294802340e-10, -1.610464683691937e-11,  7.537264464817643e-13,
 -2.910508244024957e-14,  9.636598126683443e-16, -2.808422621966558e-17,  7.341939456775872e-19, -1.746513471556620e-20,  3.822773014373943e-22, -7.765081716744739e-24,
  6.040248175949156e-09, -1.085310029987629e-09,  1.020733776915422e-10, -6.627189740691306e-12,  3.327853109204434e-13, -1.374931438837862e-14,  4.858557773211263e-16,
 -1.507750706975206e-17,  4.188517467400544e-19, -1.056761728039291e-20,  2.448928434045589e-22, -5.257890373801639e-24,  1.934836700232287e-09, -3.751374394144431e-10,
  3.798895172366564e-11, -2.647869249449934e-12,  1.423414903542164e-13, -6.279594179441153e-15,  2.363873843697320e-16, -7.798020353906012e-18,  2.298269647765799e-19,
 -6.140695376419498e-21,  1.504484651400018e-22, -3.409556962599476e-24,  6.095391848584335e-10, -1.270833293269829e-10,  1.381737341780591e-11, -1.031350355229061e-12,
  5.922077130711965e-14, -2.784052068350982e-15,  1.114361860588994e-16, -3.900954633385071e-18,  1.217775624101765e-19, -3.440466733907823e-21,  8.898694197486208e-23,
 -2.125721651674472e-24,  1.896394920568262e-10, -4.237291722434451e-11,  4.932604829462697e-12, -3.933005130686763e-13,  2.406890836046436e-14, -1.203305935889759e-15,
  5.111641257252028e-17, -1.895498140318523e-18,  6.257183535612654e-20, -1.866296400302091e-21,  5.088380498941499e-23, -1.279405514140631e-24,  5.852906345104690e-11,
 -1.396892523163758e-11,  1.736176626735401e-12, -1.475147127477412e-13,  9.599637791609583e-15, -5.093208316193359e-16,  2.291788083989250e-17, -8.986101326153166e-19,
  3.131451425938232e-20, -9.844564485946444e-22,  2.824981587978969e-23, -7.465344848455288e-25,  1.800615285467779e-11, -4.575321329502791e-12,  6.054665858836944e-13,
 -5.468189403493982e-14,  3.775378243093648e-15, -2.121271040198406e-16,  1.009066253521573e-17, -4.175825331547253e-19,  1.533452204429157e-20, -5.072730802630809e-22,
  1.529624670510227e-23, -4.241850154259434e-25,  5.550232089351731e-12, -1.496610004646689e-12,  2.102832649273557e-13, -2.013607272697126e-14,  1.471562914118382e-15,
 -8.737185587999923e-17,  4.384804779456209e-18, -1.911444014735451e-19,  7.383248295135499e-21, -2.565549329470946e-22,  8.115582899776651e-24, -2.357899961602853e-25,
  1.723510317682902e-12, -4.915855309054990e-13,  7.313078861925708e-14, -7.405784992780415e-15,  5.715125260450035e-16, -3.577694950575026e-17,  1.890249396184288e-18,
 -8.662584199598749e-20,  3.512853985025231e-21, -1.279848555014074e-22,  4.239649166284809e-24, -1.288348059919125e-25,  5.422840083647009e-13, -1.630752707652882e-13,
  2.561255515371955e-14, -2.735781604877457e-15,  2.223912441153239e-16, -1.464441008319833e-17,  8.127711985482586e-19, -3.907527879534439e-20,  1.660233731478896e-21,
 -6.329888054918460e-23,  2.191761512089392e-24, -6.953685190940803e-26,  1.739221870741812e-13, -5.496341106180202e-14,  9.087307504281556e-15, -1.021044966640462e-15,
  8.720780478276783e-17, -6.026099852427000e-18,  3.505201634346020e-19, -1.763986492795866e-20,  7.836073593181728e-22, -3.120108491661603e-23,  1.127041908800428e-24,
 -3.726100576693293e-26,  5.721152864232119e-14, -1.893782793118358e-14,  3.286173031483646e-15, -3.873159399604211e-16,  3.466559558066593e-17, -2.507317992436323e-18,
  1.524813928889936e-19, -8.013831316446517e-21,  3.713726929945178e-22, -1.540955607445530e-23,  5.794677179602323e-25, -1.992323159158825e-26,  1.942398963908106e-14,
 -6.712282576515424e-15,  1.218694957253185e-15, -1.502362977587969e-16,  1.405174788351621e-17, -1.061015596232002e-18,  6.729091933426507e-20, -3.684329002737823e-21,
  1.776926097176415e-22, -7.665969773514510e-24,  2.994433801202022e-25, -1.068388541083283e-26,  6.849078151521504e-15, -2.462586312423525e-15,  4.663438426997273e-16,
 -5.994894133118020e-17,  5.842581912183749e-18, -4.592733706608068e-19,  3.029503744519989e-20, -1.723575404193156e-21,  8.629733036437134e-23, -3.861547709729457e-24,
  1.563138838542368e-25, -5.774375155083563e-27,  2.523415328682130e-15, -9.408110187983972e-16,  1.852205334228172e-16, -2.475127222817095e-17,  2.505975714367866e-18,
 -2.044808442554213e-19,  1.398926775299230e-20, -8.247575604819603e-22,  4.275643015271707e-23, -1.979326860822818e-24,  8.282462836207408e-26, -3.160144725163728e-27,
  9.768772239716700e-16, -3.763736562573366e-16,  7.677400300219536e-17, -1.063011718452974e-17,  1.114555303875212e-18, -9.411489728040770e-20,  6.658176975546203e-21,
 -4.056112296401286e-22,  2.171100442104957e-23, -1.036975812216502e-24,  4.473721262905499e-26, -1.758489273123770e-27,  3.992789034447958e-16, -1.584227857222102e-16,
  3.336648942869332e-17, -4.770627551678726e-18,  5.162857766526141e-19, -4.497132361131388e-20,  3.279702542065057e-21, -2.058245748544056e-22,  1.134181502218967e-23,
 -5.573120632934622e-25,  2.471973950492059e-26, -9.982900645473806e-28,  1.729113703367062e-16, -7.040602224423827e-17,  1.525611513660761e-17, -2.244497685805532e-18,
  2.498564101896610e-19, -2.237530091778929e-20,  1.676686057829857e-21, -1.080542649942052e-22,  6.110791890736679e-24, -3.079849997843987e-25,  1.400367120758169e-26,
 -5.793641638457211e-28,  7.944733500965518e-17, -3.308122151795469e-17,  7.347772086889128e-18, -1.108294681955777e-18,  1.264530793186049e-19, -1.160173684370180e-20,
  8.902443625318985e-22, -5.871952292848700e-23,  3.397031666302057e-24, -1.750545820124069e-25,  8.134138020592838e-27, -3.437250636308098e-28,  3.864184491928561e-17,
 -1.639595885452761e-17,  3.718843884816018e-18, -5.729205789061891e-19,  6.675158596399818e-20, -6.251649255095484e-21,  4.894904556532272e-22, -3.293037612876889e-23,
  1.942257382829354e-24, -1.019972877995345e-25,  4.827832408543457e-27, -2.077193777597215e-28,  1.971637853782677e-17, -8.494452640463673e-18,  1.959850899322735e-18,
 -3.071936658718301e-19,  3.640926688346275e-20, -3.467815036706043e-21,  2.760421414069665e-22, -1.887335346202271e-23,  1.130914229107658e-24, -6.031590175903454e-26,
  2.898460251144197e-27, -1.265611246000818e-28,  1.030618700384976e-17, -4.492433143498487e-18,  1.050202947054156e-18, -1.668172240972930e-19,  2.003405808823078e-20,
 -1.933081201571538e-21,  1.558474313232011e-22, -1.078922108107588e-23,  6.544435231237624e-25, -3.532325515464046e-26,  1.717389351249004e-27, -7.584866888206878e-29,
  5.175800971091719e-18, -2.274458024776339e-18,  5.365812335770704e-19, -8.602508390197554e-20,  1.042659143026637e-20, -1.015197470747941e-21,  8.257591146427885e-23,
 -5.766586590025817e-24,  3.527736021647662e-25, -1.919994505104919e-26,  9.411185680250442e-28, -4.189593243782331e-29,  1.947437538095158e-18, -8.596460146136793e-19,
  2.038391966791605e-19, -3.284888105905608e-20,  4.001875503888886e-21, -3.916185370627521e-22,  3.201229239088445e-23, -2.246412141968305e-24,  1.380796096185433e-25,
 -7.550085901730096e-27,  3.717668525450962e-28, -1.662353926153737e-29,  5.425854913423622e-02, -1.213431743621950e-04,  2.803198384371377e-07, -6.656650136292674e-10,
  1.615085463204005e-12, -3.980917888751390e-15,  9.916204815235030e-18, -2.486694173569060e-20,  6.257373582790481e-23, -1.577163015538188e-25,  3.974184368243770e-28,
 -1.000769817025675e-30,  5.133075586711002e-02, -1.404491363930371e-04,  4.532478952271146e-07, -1.534615778758104e-09,  5.184585730217181e-12, -1.723260767716377e-14,
  5.625082475624137e-17, -1.806055867461411e-19,  5.715253283496621e-22, -1.785856728202693e-24,  5.518172729293863e-27, -1.688134860887551e-29,  4.594326474950419e-02,
 -1.716714476981026e-04,  7.765528505390636e-07, -3.420951493427569e-09,  1.437071412193088e-11, -5.803861253034117e-14,  2.271622882201534e-16, -8.664622908349464e-19,
  3.233268593936452e-21, -1.183743621426951e-23,  4.261476060256086e-26, -1.511181477113821e-28,  3.890912823026429e-02, -2.038635463665475e-04,  1.201550755771056e-06,
 -6.476505733493662e-09,  3.254879710220745e-11, -1.553453940979853e-13,  7.117669724047869e-16, -3.152931015540136e-18,  1.357119043433931e-20, -5.697741653969356e-23,
  2.340249188663776e-25, -9.425937401593079e-28,  3.118483397226877e-02, -2.260105486196640e-04,  1.653646675376970e-06, -1.064489261950375e-08,  6.293316696199556e-11,
 -3.494033842580784e-13,  1.845423153252385e-15, -9.353276793105769e-18,  4.577843324619749e-20, -2.173920379492344e-22,  1.005331970428497e-24, -4.540698189922296e-27,
  2.365927649453121e-02, -2.310090475273717e-04,  2.043851260890242e-06, -1.550664353331814e-08,  1.065513224213787e-10, -6.800945388149922e-13,  4.094383759899304e-15,
 -2.349202949746235e-17,  1.294201109165510e-19, -6.884240496321120e-22,  3.551067525897313e-24, -1.782337890766869e-26,  1.699642220160046e-02, -2.174418090810039e-04,
  2.291355522993700e-06, -2.028768928234557e-08,  1.604571361123854e-10, -1.166688215420452e-12,  7.937797990595671e-15, -5.114194519748077e-17,  3.146951475131725e-19,
 -1.861241565855199e-21,  1.063284068453581e-23, -5.889919722951495e-26,  1.156573297046957e-02, -1.889915556077164e-04,  2.347867207129175e-06, -2.405665435478652e-08,
  2.172606151589653e-10, -1.786368751211361e-12,  1.364168062237727e-14, -9.805789487531571e-17,  6.698141247382723e-19, -4.378908950275374e-21,  2.754821577325955e-23,
 -1.674957601473418e-25,  7.458327247353115e-03, -1.522353728683280e-04,  2.211536799943657e-06, -2.603043609223740e-08,  2.666494913286327e-10, -2.464213394334821e-12,
  2.100223461516269e-14, -1.675325479486529e-16,  1.263940169150025e-18, -9.089279836033411e-21,  6.267753766733059e-23, -4.164056896494456e-25,  4.560253377913704e-03,
 -1.140615704047063e-04,  1.923733011854457e-06, -2.584218165338212e-08,  2.985441213641837e-10, -3.084862157020854e-12,  2.920260859878659e-14, -2.573413068391320e-16,
  2.135153258223406e-18, -1.682068541350641e-20,  1.266403390608426e-22, -9.158465818315444e-25,  2.645322139475845e-03, -7.975473663315169e-05,  1.551289882916360e-06,
 -2.364534524406553e-08,  3.065193508052342e-10, -3.525379170506898e-12,  3.691259435589661e-14, -3.579453004433723e-16,  3.254020263252066e-18, -2.798423211900668e-20,
  2.292542796068065e-22, -1.798859590567632e-24,  1.456840699271273e-03, -5.219899430543651e-05,  1.163577453502793e-06, -2.001840476854262e-08,  2.898815643431219e-10,
 -3.696079033461540e-12,  4.264703839943523e-14, -4.535123757457616e-16,  4.502620033828339e-18, -4.213996026574332e-20,  3.745313794014086e-22, -3.179506480487919e-24,
  7.623136730185812e-04, -3.206456437120299e-05,  8.142642746158735e-07, -1.573583698774484e-08,  2.535059794905552e-10, -3.570318021808047e-12,  4.524762296094082e-14,
 -5.260395015622141e-16,  5.687356678092934e-18, -5.776731596129920e-20,  5.555540993434701e-22, -5.089718659447388e-24,  3.793445777427157e-04, -1.853186488748058e-05,
  5.331112784305679e-07, -1.152131422549787e-08,  2.057227008845153e-10, -3.189795927150229e-12,  4.426782665340930e-14, -5.610806661920798e-16,  6.588713389474778e-18,
 -7.245070604037918e-20,  7.521660429693332e-22, -7.419847523976935e-24,  1.797021705175165e-04, -1.010066467149729e-05,  3.274160556832359e-07, -7.880389975654478e-09,
  1.554190690003811e-10, -2.644987578711108e-12,  4.008558415410079e-14, -5.525043303033318e-16,  7.030104165925708e-18, -8.350236881586831e-20,  9.338312765408334e-22,
 -9.898598434774306e-24,  8.113118866515249e-05, -5.203362136092593e-06,  1.891105859478530e-07, -5.049474911819261e-09,  1.096412483709171e-10, -2.042215415155135e-12,
  3.371292787400024e-14, -5.041211309742753e-16,  6.935235840301739e-18, -8.879685659777190e-20,  1.067615184382870e-21, -1.213751320901983e-23,  3.495372792979458e-05,
 -2.539043879109531e-06,  1.029785642806781e-07, -3.039339958082632e-09,  7.243657398440539e-11, -1.472789828821147e-12,  2.641982928503604e-14, -4.276709286221145e-16,
  6.348236749420170e-18, -8.744970973508649e-20,  1.128328633312545e-21, -1.373434171109312e-23,  1.439104687586774e-05, -1.176141472007112e-06,  5.299918293462113e-08,
 -1.723104949204212e-09,  4.494627826072070e-11, -9.950480248996932e-13,  1.935317011859446e-14, -3.384394862589918e-16,  5.410203824824421e-18, -8.004071976950675e-20,
  1.106402185814381e-21, -1.439596984729122e-23,  5.671250902567142e-06, -5.183499685696731e-07,  2.584460539111293e-08, -9.225913650230926e-10,  2.626697891621906e-11,
 -6.316767914942789e-13,  1.329219652305773e-14, -2.506283732951942e-16,  4.306948168456332e-18, -6.831659004639932e-20,  1.010090650819242e-21, -1.402761341660658e-23,
  2.143020883019736e-06, -2.178548167674015e-07,  1.197186070468093e-08, -4.677944003777071e-10,  1.449920519165036e-11, -3.779000013622200e-13,  8.585966601965845e-15,
 -1.742294429249033e-16,  3.213085906505190e-18, -5.455576769239473e-20,  8.614870055613544e-22, -1.275090516970601e-23,  7.780275718579724e-07, -8.752822433332851e-08,
  5.281978016808882e-09, -2.252490894303701e-10,  7.581536967170901e-12, -2.136929433736249e-13,  5.231954886395336e-15, -1.140567543312768e-16,  2.253550777744680e-18,
 -4.089576779544602e-20,  6.886988086834497e-22, -1.084901143693316e-23,  2.719812610779411e-07, -3.370431957840521e-08,  2.225767375089239e-09, -1.032983346930272e-10,
  3.766598066922748e-12, -1.145689691869448e-13,  3.017039898562818e-15, -7.053641763497023e-17,  1.490776307380898e-18, -2.887146483735896e-20,  5.177886604026642e-22,
 -8.669652220094537e-24,  9.177312558432196e-08, -1.247312683708545e-08,  8.984255405318667e-10, -4.525476695420884e-11,  1.783497497365608e-12, -5.842325149620931e-14,
  1.651734923850118e-15, -4.134447716858690e-17,  9.332403991064704e-19, -1.926032483013663e-20,  3.673540632977074e-22, -6.529144489481546e-24,  2.997045106281602e-08,
 -4.449404202384383e-09,  3.484599096268925e-10, -1.900053815408921e-11,  8.075034731045510e-13, -2.843047440282850e-14,  8.613815317670809e-16, -2.304624343446353e-17,
  5.547389873508156e-19, -1.218291244982012e-20,  2.467880112714843e-22, -4.650081095013410e-24,  9.500829142542596e-09, -1.534794096096699e-09,  1.302962344826684e-10,
 -7.671344231998335e-12,  3.508003829202115e-13, -1.324865895186993e-14,  4.294047416933503e-16, -1.225996421496231e-17,  3.142185498779809e-19, -7.332803973175632e-21,
  1.575480274366635e-22, -3.143118413526506e-24,  2.933183278003354e-09, -5.137090827646319e-10,  4.713696145611634e-11, -2.989165394646015e-12,  1.467587690868690e-13,
 -5.933935725123433e-15,  2.053774987118854e-16, -6.247204704870959e-18,  1.702255287692665e-19, -4.215235603676784e-21,  9.592943646378151e-23, -2.023744316863226e-24,
  8.850831881882883e-10, -1.674647966603080e-10,  1.656143933351587e-11, -1.128436040201390e-12,  5.935559498653888e-14, -2.564399053308682e-15,  9.461107354045155e-17,
 -3.061083480527934e-18,  8.854176975811426e-20, -2.323174241425108e-21,  5.592550747948741e-23, -1.245970208257371e-24,  2.620602809329610e-10, -5.338542151656675e-11,
  5.674422900729657e-12, -4.144243506535166e-13,  2.330392891454468e-14, -1.073728062574171e-15,  4.215240420404842e-17, -1.448229601062988e-18,  4.439892229931890e-20,
 -1.232563094052572e-21,  3.134259836220427e-23, -7.364663754564110e-25,  7.646284914684841e-11, -1.671517574689859e-11,  1.904348429212446e-12, -1.487216325566727e-13,
  8.921193769881098e-15, -4.374992741851653e-16,  1.824277554885016e-17, -6.644398052170443e-19,  2.155585962970434e-20, -6.322019578740177e-22,  1.695751843726025e-23,
 -4.196717150107173e-25,  2.208782491094166e-11, -5.164575537806672e-12,  6.289665099197178e-13, -5.239826987902700e-14,  3.345702201066515e-15, -1.742869198470183e-16,
  7.704784415983184e-18, -2.969773309925320e-19,  1.017887291497181e-20, -3.149002484385745e-22,  8.896537487031363e-24, -2.315714055350119e-25,  6.348845093467107e-12,
 -1.582687849472017e-12,  2.054788432694541e-13, -1.821656699854519e-14,  1.235375916872778e-15, -6.822028021050014e-17,  3.191278494044131e-18, -1.299417980020653e-19,
  4.697400121226438e-21, -1.530437575729188e-22,  4.547142756727033e-24, -1.243020890179196e-25,  1.825693461243907e-12, -4.836727798751850e-13,  6.676000092417014e-14,
 -6.282862085210539e-15,  4.515133778220712e-16, -2.637600317258519e-17,  1.303046171064704e-18, -5.594451686100388e-20,  2.129275724224046e-21, -7.293631372331543e-23,
  2.275317493975035e-24, -6.522048323569978e-26,  5.282833736706173e-13, -1.482578080522669e-13,  2.169568920488559e-14, -2.162043230090508e-15,  1.642657079598474e-16,
 -1.012892594131489e-17,  5.273785018815320e-19, -2.382806486366513e-20,  9.530685051068956e-22, -3.426259794726402e-23,  1.120353599130176e-24, -3.361915407352510e-26,
  1.547676149666978e-13, -4.586209913262323e-14,  7.095390025849092e-15, -7.467820998524337e-16,  5.984098450330970e-17, -3.886046228876461e-18,  2.127854953797323e-19,
 -1.009691824068161e-20,  4.235808645886502e-22, -1.595154177806977e-23,  5.457464101578747e-25, -1.711414995519933e-26,  4.620323980196332e-14, -1.440964491225198e-14,
  2.350104857794863e-15, -2.605377113413976e-16,  2.196381646480624e-17, -1.498574999620892e-18,  8.610064388974529e-20, -4.281502782429873e-21,  1.879996426646763e-22,
 -7.401659034463481e-24,  2.644460775187506e-25, -8.650227587097745e-27,  1.415011417140882e-14, -4.629294905401554e-15,  7.935402349077533e-16, -9.240862115449621e-17,
  8.174156981999461e-18, -5.845095927613198e-19,  3.515428002816661e-20, -1.827756840448860e-21,  8.381811393136600e-23, -3.442668735878854e-24,  1.281839630264966e-25,
 -4.365037093218963e-27,  4.476419348733904e-15, -1.531111847061271e-15,  2.750092380616275e-16, -3.354245134090241e-17,  3.104732870301028e-18, -2.320648993239663e-19,
  1.457336174775742e-20, -7.903091089820554e-22,  3.776237625776874e-23, -1.614433967011802e-24,  6.250844267709219e-26, -2.211232096061240e-27,  1.472956846671902e-15,
 -5.249437445141711e-16,  9.848230106257904e-17, -1.254288448886031e-17,  1.211353597167776e-18, -9.438174829034094e-20,  6.172232622967668e-21, -3.482230623240045e-22,
  1.729341946520635e-23, -7.677110443697440e-25,  3.083755758334389e-26, -1.130654245264661e-27,  5.075544235533779e-16, -1.878254619933463e-16,  3.668364828489655e-17,
 -4.863296190396980e-18,  4.885717467977948e-19, -3.956443648207984e-20,  2.686794122360479e-21, -1.572674216643647e-22,  8.096013241324733e-24, -3.722429217810554e-25,
  1.547343630197440e-26, -5.865906490983862e-28,  1.843252826575263e-16, -7.058063242517200e-17,  1.430177330037176e-17, -1.967118515222573e-18,  2.049103585926897e-19,
 -1.719320614321429e-20,  1.208816274518631e-21, -7.319678896010085e-23,  3.895010269809606e-24, -1.849744500207343e-25,  7.935828099565806e-27, -3.102504040770763e-28,
  7.094955947765324e-17, -2.801152759308546e-17,  5.867941979755276e-18, -8.344623122966373e-19,  8.982912678393868e-20, -7.784136510481615e-21,  5.648234613020981e-22,
 -3.527243479420007e-23,  1.934356618310681e-24, -9.460690150789211e-26,  4.177262844229206e-27, -1.679517079706480e-28,  2.907195448671803e-17, -1.179193120836440e-17,
  2.544379367771534e-18, -3.727477690589730e-19,  4.132123473788616e-20, -3.685342743323697e-21,  2.750614352765543e-22, -1.765762973213841e-23,  9.948184557824943e-25,
 -4.995445872141752e-26,  2.263218131291965e-27, -9.330826758389675e-29,  1.270944643093185e-17, -5.276909750955496e-18,  1.168353580486014e-18, -1.756659148288401e-19,
  1.997999273250280e-20, -1.827473327629897e-21,  1.398075936137213e-22, -9.194534408950526e-24,  5.304013797338129e-25, -2.725636822730088e-26,  1.263067103669524e-27,
 -5.323284057835043e-29,  5.919405175572558e-18, -2.506548357297543e-18,  5.672415872683258e-19, -8.719033748560777e-20,  1.013590146745966e-20, -9.471999534234936e-22,
  7.400469288432872e-23, -4.968234762614079e-24,  2.924320974106816e-25, -1.532646114380888e-26,  7.240393650166640e-28, -3.109332662334099e-29,  2.912908762741413e-18,
 -1.253311792147374e-18,  2.887372847485091e-19, -4.518998519169696e-20,  5.348102514976957e-21, -5.086437674806635e-22,  4.043123340549124e-23, -2.760506768734351e-24,
  1.651893229231946e-25, -8.798547184474721e-27,  4.222671992389813e-28, -1.841519951853883e-29,  1.480041190279237e-18, -6.446422695041266e-19,  1.505670317995044e-19,
 -2.389530653977222e-20,  2.867210934452597e-21, -2.764181036056630e-22,  2.226636890564252e-23, -1.540214750455335e-24,  9.334970441072775e-26, -5.034532804655028e-27,
  2.445867218187186e-28, -1.079410111351681e-29,  7.285548731432443e-19, -3.200298532461594e-19,  7.546638976520535e-20, -1.209332694974236e-20,  1.465099387919220e-21,
 -1.425877431441644e-22,  1.159298938114311e-23, -8.092355465885086e-25,  4.948459636023841e-26, -2.692126722144471e-27,  1.319061714459775e-28, -5.869782863073087e-30,
  2.710565305022729e-19, -1.196291911196102e-19,  2.836060363173582e-20, -4.569373645198347e-21,  5.565550134518433e-22, -5.445239778915033e-23,  4.450213825977713e-24,
 -3.122231472419333e-25,  1.918748441103702e-26, -1.048949321640067e-27,  5.164029296777124e-29, -2.308652045188589e-30,  5.377761157598087e-02, -1.191321342402502e-04,
  2.724843203211128e-07, -6.404478950777397e-10,  1.537791743868876e-12, -3.751063137658653e-15,  9.247131304961205e-18, -2.295244275941182e-20,  5.717179315429503e-23,
 -1.426658509607131e-25,  3.559283453563796e-28, -8.875675338530608e-31,  5.077609661399918e-02, -1.368954303066763e-04,  4.353190855844973e-07, -1.454347956157628e-09,
  4.853034595158859e-12, -1.594126264144394e-14,  5.144054213083449e-17, -1.633042401705031e-19,  5.110349387800386e-22, -1.579290056899526e-24,  4.826722160928345e-27,
 -1.460654757493195e-29,  4.526874921642709e-02, -1.656194080655210e-04,  7.368436531800353e-07, -3.200018069164946e-09,  1.326255447824198e-11, -5.286653975598646e-14,
  2.042880565278517e-16, -7.694996455455608e-19,  2.836266636695062e-21, -1.025868827673446e-23,  3.649176788081279e-26, -1.278838682114619e-28,  3.811241883729907e-02,
 -1.945533895632010e-04,  1.126857770094125e-06, -5.979681255451666e-09,  2.960580825072016e-11, -1.392751308129388e-13,  6.292688614130107e-16, -2.749743318056159e-18,
  1.167896673421106e-20, -4.839579137666201e-23,  1.962365644846908e-25, -7.804382795973687e-28,  3.030646459805817e-02, -2.132757281299811e-04,  1.531726500480146e-06,
 -9.691546212793997e-09,  5.636761340329108e-11, -3.080973579892518e-13,  1.602916766126680e-15, -8.006198036751992e-18,  3.863047729052220e-20, -1.809063643339328e-22,
  8.252335690995955e-25, -3.677471530340359e-27,  2.276680301486678e-02, -2.153745745033522e-04,  1.867568306296652e-06, -1.390551393286781e-08,  9.388112870341694e-11,
 -5.892766236463767e-13,  3.491048308356682e-15, -1.972116717855647e-17,  1.070152942816341e-19, -5.609065286666506e-22,  2.851809531038700e-24, -1.411233924485024e-26,
  1.616183414861675e-02, -2.000428380953401e-04,  2.062569369014303e-06, -1.789716149398452e-08,  1.389180819852218e-10, -9.922859179097839e-13,  6.637291049394357e-15,
 -4.206650306670038e-17,  2.547601732227761e-19, -1.483568578727802e-21,  8.347837057903204e-24, -4.556080568572084e-26,  1.084558430595144e-02, -1.713068466444624e-04,
  2.078920543300842e-06, -2.084940649013156e-08,  1.845967741404254e-10, -1.489632219702317e-12,  1.117387432486686e-14, -7.894704379440607e-17,  5.303516706139361e-19,
 -3.411412903933149e-21,  2.112494131225297e-23, -1.264717612286081e-25,  6.882889701520413e-03, -1.357235860102427e-04,  1.923228082569250e-06, -2.213244785205404e-08,
  2.220481936998138e-10, -2.012166185717881e-12,  1.683163008177664e-14, -1.318717137034334e-16,  9.777609090313833e-19, -6.913716189307399e-21,  4.689885242661677e-23,
 -3.066229981624042e-25,  4.132931575021225e-03, -9.983538023691424e-05,  1.640368035906170e-06, -2.152329127704894e-08,  2.433095028962231e-10, -2.463271941656209e-12,
  2.286910606681069e-14, -1.978011861118556e-16,  1.611844133001673e-18, -1.247822138788986e-20,  9.236436485319986e-23, -6.569957337453362e-25,  2.349437797682432e-03,
 -6.840108282870108e-05,  1.294791940125066e-06, -1.926016955022145e-08,  2.441160497729939e-10, -2.748851213066397e-12,  2.820825115605038e-14, -2.683097759015502e-16,
  2.394195583216625e-18, -2.022223482337260e-20,  1.627918502431273e-22, -1.255767842960278e-24,  1.265244900461738e-03, -4.377768735975346e-05,  9.489148265414044e-07,
 -1.592010214955247e-08,  2.252452592464116e-10, -2.809953558824770e-12,  3.175693479151462e-14, -3.310629687637632e-16,  3.224600890877234e-18, -2.962548170050777e-20,
  2.586166186770182e-22, -2.157418928637094e-24,  6.459783659565285e-04, -2.624188370993030e-05,  6.475926773821873e-07, -1.219665038341307e-08,  1.918646475162096e-10,
 -2.642337285278217e-12,  3.278203041296350e-14, -3.734321710435579e-16,  3.959024943817644e-18, -3.945739685518837e-20,  3.725538307608932e-22, -3.352690601591928e-24,
  3.129443259778165e-04, -1.476853950036735e-05,  4.126729825434551e-07, -8.687334910557680e-09,  1.513921409475629e-10, -2.294283587062402e-12,  3.115517996142499e-14,
 -3.867506892232766e-16,  4.451561578522837e-18, -4.801258594647774e-20,  4.891983108254153e-22, -4.738656218897230e-24,  1.439940374794851e-04, -7.821026106494565e-06,
  2.461818927087553e-07, -5.769446972168297e-09,  1.110072445304136e-10, -1.845693669655024e-12,  2.735988437084969e-14, -3.692033979262642e-16,  4.603059467114431e-18,
 -5.360950792864401e-20,  5.882150330535090e-22, -6.120750188818275e-24,  6.299809181155313e-05, -3.905870493682017e-06,  1.378248839166077e-07, -3.582390927450478e-09,
  7.586276293280690e-11, -1.380095059971326e-12,  2.227716830135911e-14, -3.260417899798123e-16,  4.393710389632556e-18, -5.514544138139517e-20,  6.503420733752972e-22,
 -7.256336672619771e-24,  2.623934293986898e-05, -1.843434403255598e-06,  7.258974602373730e-08, -2.085242538481965e-09,  4.845891719407997e-11, -9.620806065290982e-13,
  1.687163842179218e-14, -2.672478366541474e-16,  3.885039588564826e-18, -5.245093148901219e-20,  6.636839220047300e-22, -7.927120651222158e-24,  1.041896583902738e-05,
 -8.239948477817573e-07,  3.605375735205844e-08, -1.140836950059347e-09,  2.901332630270699e-11, -6.271095352500188e-13,  1.192184974536654e-14, -2.039784932096102e-16,
  3.192940118001501e-18, -4.628915199429419e-20,  6.274139286650970e-22, -8.009588333876302e-24,  3.950197066385183e-06, -3.495912309924808e-07,  1.692847529327069e-08,
 -5.881873389298131e-10,  1.632691682237433e-11, -3.833222290940888e-13,  7.883684176916700e-15, -1.454260087877397e-16,  2.446932175645493e-18, -3.803093111732344e-20,
  5.513320325957270e-22, -7.511674845052658e-24,  1.432491908338768e-06, -1.410994061996269e-07,  7.533029473105357e-09, -2.865457554375750e-10,  8.659815915881906e-12,
 -2.203609777679964e-13,  4.893478050792580e-15, -9.714726128160585e-17,  1.754162918944277e-18, -2.918393231798071e-20,  4.518468201408267e-22, -6.561185161527462e-24,
  4.978403679096600e-07, -5.430751721665247e-08,  3.185230433425451e-09, -1.322678362564070e-10,  4.341632718108827e-12, -1.194913643345103e-13,  2.859727766195317e-15,
 -6.099548185481106e-17,  1.180084082417589e-18, -2.098490733042350e-20,  3.465162230006275e-22, -5.355615836951177e-24,  1.661709210302880e-07, -1.998354918824890e-08,
  1.283283640285742e-09, -5.801513301975323e-11,  2.063582517627214e-12, -6.130361878644103e-14,  1.578319708280459e-15, -3.610883028766611e-17,  7.473856102125757e-19,
 -1.418544422946066e-20,  2.494871320989696e-22, -4.098990956032684e-24,  5.339935544252052e-08, -7.049383113521438e-09,  4.940562919689413e-10, -2.425286085299361e-11,
  9.327301827167749e-13, -2.985043024950317e-14,  8.253107160373887e-16, -2.022022927118991e-17,  4.470860647286619e-19, -9.044692942159950e-21,  1.692088339551362e-22,
 -2.951603580224420e-24,  1.656527859629654e-08, -2.390985374839311e-09,  1.823254337630573e-10, -9.694020102374118e-12,  4.022234508388450e-13, -1.384082154175953e-14,
  4.102420380393106e-16, -1.074674904831405e-17,  2.534693950624161e-19, -5.458130466415541e-21,  1.084782095138967e-22, -2.006579703411029e-24,  4.975490934880502e-09,
 -7.822371946183232e-10,  6.471088780681509e-11, -3.717397262122973e-12,  1.660549664675591e-13, -6.132398210373711e-15,  1.945287898222797e-16, -5.440206273026481e-18,
  1.366731367122832e-19, -3.128483073595658e-21,  6.597082059614061e-23, -1.292473343185066e-24,  1.451704343659013e-09, -2.477103877934609e-10,  2.216763961133714e-11,
 -1.372607955391650e-12,  6.587231139964164e-14, -2.605902986940675e-15,  8.831933682643922e-17, -2.632755422860803e-18,  7.035171409383251e-20, -1.709519966545814e-21,
  3.819981083763435e-23, -7.917034478060098e-25,  4.129569647656561e-10, -7.621414263479113e-11,  7.357829683613638e-12, -4.899156448459351e-13,  2.520717685624460e-14,
 -1.066233495456747e-15,  3.854446654041988e-17, -1.222829017204564e-18,  3.470554324322820e-20, -8.940430222218583e-22,  2.114257936456357e-23, -4.629780530014444e-25,
  1.149885523172791e-10, -2.287700279527406e-11,  2.376185597989385e-12, -1.697410685262911e-13,  9.344197400254780e-15, -4.218285469795826e-16,  1.623751920057952e-17,
 -5.473808136810105e-19,  1.647609424678199e-20, -4.493392459365883e-22,  1.123100647023803e-23, -2.595255307548324e-25,  3.148008957887997e-11, -6.729428982665570e-12,
  7.500169686433864e-13, -5.734653712611300e-14,  3.370670243846541e-15, -1.620915015813884e-16,  6.632352579112885e-18, -2.371956095832154e-19,  7.560490772106772e-21,
 -2.179789935787233e-22,  5.750679687565699e-24, -1.400491117602670e-25,  8.514038199892261e-12, -1.949319226113590e-12,  2.325088478752916e-13, -1.898437231770194e-14,
  1.188914355552467e-15, -6.078739167322099e-17,  2.639221944362356e-18, -9.996934297111456e-20,  3.369104242513571e-21, -1.025381743264477e-22,  2.851302146870412e-24,
 -7.308399962523755e-26,  2.286785939461526e-12, -5.589826585788042e-13,  7.116542918063390e-14, -6.190511266066283e-15,  4.121922792008175e-16, -2.236294033045836e-17,
  1.028378899041349e-18, -4.118625489574034e-20,  1.465218176796886e-21, -4.700171176904707e-23,  1.375589818531250e-24, -3.705745059049131e-26,  6.134326589461248e-13,
 -1.595839092386018e-13,  2.162790769650907e-14, -1.999557182746017e-15,  1.412456958851901e-16, -8.115007900607575e-18,  3.945033328839013e-19, -1.667560368663511e-20,
  6.251701705772828e-22, -2.110324787527407e-23,  6.490410317100669e-25, -1.834938112157884e-26,  1.653521303142066e-13, -4.563527189509678e-14,  6.566025164648419e-15,
 -6.436032473427377e-16,  4.812211281588722e-17, -2.921635433656364e-18,  1.498521219175721e-19, -6.672822941911962e-21,  2.631582341240272e-22, -9.331820761188427e-24,
  3.011105336568811e-25, -8.919744801471977e-27,  4.508032865567454e-14, -1.315691150301470e-14,  2.004136579716953e-15, -2.077491689236783e-16,  1.640319021879053e-17,
 -1.050068011180930e-18,  5.670511088010706e-20, -2.654743525502043e-21,  1.099252961655649e-22, -4.087491658313477e-24,  1.381322324069596e-25, -4.280222550727746e-27,
  1.251700853734677e-14, -3.850639867555851e-15,  6.192100379837969e-16, -6.770237505200074e-17,  5.631006597695473e-18, -3.792041614832514e-19,  2.151228898343967e-20,
 -1.056636084223698e-21,  4.584496056502784e-23, -1.784096139979830e-24,  6.302649828791470e-26, -2.039171579030094e-27,  3.565306696751885e-15, -1.152288670522814e-15,
  1.950366889828398e-16, -2.243076246680107e-17,  1.960178216452534e-18, -1.385203825797741e-19,  8.236031683140494e-21, -4.234676661202613e-22,  1.921058704691964e-23,
 -7.807859671965258e-25,  2.877609264263716e-26, -9.702345596644534e-28,  1.049615135670353e-15, -3.551946962820353e-16,  6.308715361832312e-17, -7.609945265077098e-18,
  6.968150708704044e-19, -5.153900092184965e-20,  3.203669785313692e-21, -1.720173073137103e-22,  8.140353893982584e-24, -3.447705449642366e-25,  1.322777718140573e-26,
 -4.638055100507010e-28,  3.218148571252507e-16, -1.136384364542428e-16,  2.111223088097823e-17, -2.663026885587443e-18,  2.547672434883998e-19, -1.966806315009264e-20,
  1.274752572312266e-21, -7.129498304692085e-23,  3.510791427745380e-24, -1.545774057122560e-25,  6.159563273546400e-27, -2.240898668694322e-28,  1.035389612470993e-16,
 -3.801771274320102e-17,  7.363512212526770e-18, -9.681590261483797e-19,  9.647645602511667e-20, -7.751088050477479e-21,  5.223335379306874e-22, -3.034581846695451e-23,
  1.550838616381544e-24, -7.080162852589318e-26,  2.922861118821928e-27, -1.100646003407914e-28,  3.520974025623052e-17, -1.339545629743553e-17,  2.695502565975970e-18,
 -3.681870481636438e-19,  3.809316913585527e-20, -3.175089106457783e-21,  2.217939292050875e-22, -1.334585400849106e-23,  7.058319869429827e-25, -3.332071738763850e-26,
  1.421261568392539e-27, -5.525172865105486e-29,  1.273861162225486e-17, -5.003211155435265e-18,  1.042180062293170e-18, -1.473703803950312e-19,  1.577648341799494e-20,
 -1.359716618944832e-21,  9.814197828336432e-23, -6.097354344097759e-24,  3.327097410909575e-25, -1.619319278286774e-26,  7.116038235281483e-28, -2.847914269130844e-29,
  4.929229250027047e-18, -1.991265187757509e-18,  4.277582722634536e-19, -6.238788691002304e-20,  6.885864085302177e-21, -6.115119353144906e-22,  4.545107099095652e-23,
 -2.905898552577197e-24,  1.630689992757969e-25, -8.156923043990902e-27,  3.681687487091686e-28, -1.512361655833797e-29,  2.046465516120946e-18, -8.471170176141538e-19,
  1.869341664439235e-19, -2.801213638615911e-20,  3.175558250654023e-21, -2.895157928459144e-22,  2.207912422669005e-23, -1.447587853798398e-24,  8.325648138178658e-26,
 -4.265924493613384e-27,  1.971224769735081e-28, -8.284932806813525e-30,  9.110894571585659e-19, -3.849742683341149e-19,  8.691485604826222e-20, -1.332778003694404e-20,
  1.545715219362410e-21, -1.441143415967818e-22,  1.123430896423334e-23, -7.525487574032378e-25,  4.420046895976059e-26, -2.311727166177274e-27,  1.089865168901196e-28,
 -4.671093180665596e-30,  4.317299245921136e-19, -1.854974944228512e-19,  4.266822082014560e-20, -6.667463174936861e-21,  7.878496066967933e-22, -7.481618051696574e-23,
  5.938157580432002e-24, -4.048477633079982e-25,  2.419181470120455e-26, -1.286755894367001e-27,  6.167173498421805e-29, -2.685993963336794e-30,  2.129516404039540e-19,
 -9.267657041197701e-20,  2.162625337749720e-20, -3.428938851652201e-21,  4.110615067259362e-22, -3.959322062402965e-23,  3.186538305763647e-24, -2.202292579834570e-25,
  1.333642278361046e-26, -7.186656085395249e-28,  3.488593062144345e-29, -1.538377602464007e-30,  1.026538398431563e-19, -4.507370212360188e-20,  1.062387229365443e-20,
 -1.701643608272598e-21,  2.060558916980030e-22, -2.004464574410638e-23,  1.628971754500399e-24, -1.136577109606773e-25,  6.947104064091454e-27, -3.777835654297195e-28,
  1.850249905238098e-29, -8.230181362177189e-31,  3.774445415217501e-20, -1.665516218374300e-20,  3.947610860625607e-21, -6.358881441639190e-22,  7.743503352172847e-23,
 -7.574476112704185e-24,  6.189047676431914e-25, -4.341268938941572e-26,  2.667347629566786e-27, -1.457898985063039e-28,  7.175866207066588e-30, -3.207439209302600e-31,
  5.330539469719726e-02, -1.169825885216349e-04,  2.649441363575870e-07, -6.164315538663542e-10,  1.464938785128830e-12, -3.536641923158031e-15,  8.629322920311566e-18,
 -2.120244770288795e-20,  5.228295592773809e-23, -1.291795653860573e-25,  3.191102357656702e-28, -7.880928821974426e-31,  5.023537129985587e-02, -1.334813901009867e-04,
  4.183224933139675e-07, -1.379184448261197e-09,  4.546194030472836e-12, -1.475976318441016e-14,  4.708867850046403e-17, -1.478247519357473e-19,  4.575063101229910e-22,
 -1.398479492341071e-24,  4.227993555686919e-27, -1.265782456379365e-29,  4.461782287025570e-02, -1.598747309546296e-04,  6.996825929950943e-07, -2.996016597642213e-09,
  1.225255918339155e-11, -4.821225377883384e-14,  1.839591404336361e-16, -6.843770447205116e-19,  2.491926721941239e-21, -8.905579116487959e-24,  3.130529639019005e-26,
 -1.084310931474233e-28,  3.735179164367605e-02, -1.858177058168466e-04,  1.057854419324860e-06, -5.527477215642174e-09,  2.696530536056335e-11, -1.250559180417071e-13,
  5.572567317113214e-16, -2.402442087620199e-18,  1.007010962842218e-20, -4.119211481875810e-23,  1.649134786125835e-25, -6.476886259578483e-28,  2.947715379642698e-02,
 -2.014722334500406e-04,  1.420642460906309e-06, -8.836943552907945e-09,  5.057290540555682e-11, -2.721835478285849e-13,  1.395114261893997e-15, -6.868157462713690e-18,
  3.267499406652755e-20, -1.509186804612259e-22,  6.791784567182831e-25, -2.986582799073693e-27,  2.193416389629096e-02, -2.010768240836886e-04,  1.709340054340347e-06,
 -1.249332882137682e-08,  8.289064371658840e-11, -5.117487090305658e-13,  2.983913054976916e-15, -1.659890325470743e-17,  8.873465956593016e-20, -4.583469580593607e-22,
  2.297287102390464e-24, -1.120993021355711e-26,  1.539335514635514e-02, -1.843650151431491e-04,  1.860511638497211e-06, -1.582496741111383e-08,  1.205744662825240e-10,
 -8.462512037725314e-13,  5.565970167579945e-15, -3.470799348251496e-17,  2.069085034467223e-19, -1.186550809834036e-21,  6.577160749724227e-24, -3.537341746429342e-26,
  1.019210310797051e-02, -1.556282166590290e-04,  1.845511023343727e-06, -1.812034699829586e-08,  1.573162577583459e-10, -1.246175596057368e-12,  9.183594675209849e-15,
 -6.378797349964335e-17,  4.214987418565912e-19, -2.668058723662908e-21,  1.626513253672878e-23, -9.589772444106614e-26,  6.369166347212653e-03, -1.213426436172303e-04,
  1.677695118760182e-06, -1.888086952958692e-08,  1.855627177641196e-10, -1.649198033926015e-12,  1.354227810595031e-14, -1.042284419398222e-16,  7.596169135420064e-19,
 -5.282262002637336e-21,  3.525384970302599e-23, -2.268569250840803e-25,  3.758288900109361e-03, -8.768293311318437e-05,  1.403912188589308e-06, -1.799642471030238e-08,
  1.991124857268666e-10, -1.975437081328424e-12,  1.799002092763533e-14, -1.527495246192636e-16,  1.222705084648701e-18, -9.303284960986352e-21,  6.771402092682645e-23,
 -4.738148829327461e-25,  2.095174882684596e-03, -5.890478723154612e-05,  1.085403333880346e-06, -1.575975213453527e-08,  1.953425228763406e-10, -2.153978136996774e-12,
  2.166710505913578e-14, -2.021874474553272e-16,  1.771202459543748e-18, -1.469543375200041e-20,  1.162655088632912e-22, -8.818352182621514e-25,  1.104188044313023e-03,
 -3.689328386189643e-05,  7.777685847721286e-07, -1.272731342226027e-08,  1.759733270309677e-10, -2.148282548181243e-12,  2.378468623763090e-14, -2.431155223252787e-16,
  2.323462356185809e-18, -2.095806767304681e-20,  1.797223299713371e-22, -1.473489459729925e-24,  5.505140788159774e-04, -2.159814960776528e-05,  5.180372791801272e-07,
 -9.510155590154703e-09,  1.461074142747546e-10, -1.967942332483141e-12,  2.390497613733997e-14, -2.668605438462552e-16,  2.774657988468129e-18, -2.713811760096177e-20,
  2.516030606912978e-22, -2.224406743595899e-24,  2.598665466029533e-04, -1.184620958816198e-05,  3.215665763459295e-07, -6.594931143874010e-09,  1.121834364449885e-10,
 -1.661882175355870e-12,  2.208534971955420e-14, -2.685528733456514e-16,  3.030231629244629e-18, -3.206090574300304e-20,  3.206407869080676e-22, -3.050213611696106e-24,
  1.162495654466972e-04, -6.100900418958718e-06,  1.864937051954924e-07, -4.256201458442212e-09,  7.990139660140060e-11, -1.298097193996705e-12,  1.882378409099427e-14,
 -2.487230732004058e-16,  3.038812576683731e-18, -3.470625050830551e-20,  3.736587890607918e-22, -3.817276663379206e-24,  4.933413210406216e-05, -2.956514853346683e-06,
  1.012944132086265e-07, -2.563192427962666e-09,  5.294285208387976e-11, -9.407746062804369e-13,  1.485040714634381e-14, -2.127510844342089e-16,  2.808704650541072e-18,
 -3.455963410440827e-20,  3.998140766074386e-22, -4.378590503790960e-24,  1.988540883476595e-05, -1.350958354607013e-06,  5.164879561871979e-08, -1.444144268970797e-09,
  3.272619657349101e-11, -6.344853907841862e-13,  1.087825382633038e-14, -1.686277267485868e-16,  2.400951918883251e-18, -3.177081658288019e-20,  3.942766226613382e-22,
 -4.621358486055125e-24,  7.623143751584653e-06, -5.832944032538008e-07,  2.478061318483521e-08, -7.631674630317180e-10,  1.892347176752692e-11, -3.993585064691042e-13,
  7.421281167097982e-15, -1.242385403813614e-16,  1.904416268632353e-18, -2.705619257902329e-20,  3.596162508634952e-22, -4.504509720885959e-24,  2.783563330136089e-06,
 -2.384776376835127e-07,  1.121448707402865e-08, -3.792479949506127e-10,  1.026359692776318e-11, -2.352563488426108e-13,  4.729125386556785e-15, -8.534660140813506e-17,
  1.406115119957159e-18, -2.141456690050138e-20,  3.043985978180365e-22, -4.068937304939267e-24,  9.697761734144440e-07, -9.253155570043447e-08,  4.798777407641468e-09,
 -1.776873950699527e-10,  5.235776328984391e-12, -1.300746905139913e-13,  2.823213811507165e-15, -5.483246485559427e-17,  9.694338933710280e-19, -1.580342827861934e-20,
  2.399067245781335e-22, -3.417722246287439e-24,  3.229766984212220e-07, -3.415360455467820e-08,  1.946608752585636e-09, -7.870323506825422e-11,  2.519208406411911e-12,
 -6.769790199419553e-14,  1.583656073472774e-15, -3.304737237628706e-17,  6.260528831079996e-19, -1.090887348372457e-20,  1.766261069690817e-22, -2.678300787560960e-24,
  1.030446512174564e-07, -1.202205025741520e-08,  7.505782394391055e-10, -3.304882713218947e-11,  1.146602094905276e-12, -3.326481103952170e-14,  8.372537237749941e-16,
 -1.874281283372880e-17,  3.799049014555500e-19, -7.066332285657029e-21,  1.218713568811152e-22, -1.964681682918177e-24,  3.156962321926477e-08, -4.046597779591442e-09,
  2.758853668100359e-10, -1.319589233874046e-11,  4.951669192436205e-13, -1.548007756504569e-14,  4.185096403630175e-16, -1.003515810603163e-17,  2.173307395380337e-19,
 -4.309455868277532e-21,  7.907295276806297e-23, -1.353619392754462e-24,  9.312345286763253e-09, -1.306300795640324e-09,  9.696417543120730e-11, -5.025901886332184e-12,
  2.035545636574961e-13, -6.844783623111329e-15,  1.984461667480334e-16, -5.089276792224166e-18,  1.176015871347614e-19, -2.482790348356903e-21,  4.840829360226519e-23,
 -8.789593699824525e-25,  2.652670580656486e-09, -4.057165590762313e-10,  3.269501259787963e-11, -1.832108901437355e-12,  7.992647444837190e-14, -2.885689240300538e-15,
  8.957447870231549e-17, -2.453320169417762e-18,  6.040625090581867e-20, -1.356075524696507e-21,  2.806206064121771e-23, -5.398291542485800e-25,  7.321098721900126e-10,
 -1.216580079749490e-10,  1.061438218280199e-11, -6.415507505539233e-13,  3.008681191021380e-14, -1.164250564118098e-15,  3.863128085362511e-17, -1.128315319660152e-18,
  2.956245739745485e-20, -7.048031062047043e-22,  1.546113074217283e-23, -3.147550813738447e-25,  1.964853266890710e-10, -3.535502328822689e-11,  3.330726790172428e-12,
 -2.166502315193936e-13,  1.090063573454109e-14, -4.513024680721375e-16,  1.598173273942934e-17, -4.970485229447065e-19,  1.383881815677291e-20, -3.499425981262634e-22,
  8.128013762886123e-24, -1.749088850046876e-25,  5.148825726040626e-11, -9.999183489332827e-12,  1.014494284214989e-12, -7.085680231649956e-14,  3.817381296372412e-15,
 -1.687944040277262e-16,  6.369081765381196e-18, -2.106148043847217e-19,  6.222677233312695e-21, -1.666787862654418e-22,  4.093997472986866e-24, -9.301670092489679e-26,
  1.323297410449045e-11, -2.764788379163397e-12,  3.013164744778971e-13, -2.254746315409838e-14,  1.298112092308144e-15, -6.119315757432082e-17,  2.456240149511982e-18,
 -8.623015154406806e-20,  2.699715571678734e-21, -7.649704406207501e-23,  1.984450335643109e-24, -4.754584462522395e-26,  3.352126242585616e-12, -7.511168310465532e-13,
  8.770599189624779e-14, -7.015738232379144e-15,  4.307705419871553e-16, -2.160927939208454e-17,  9.211387110195496e-19, -3.427740685971663e-20,  1.135527807484671e-21,
 -3.398943060606157e-23,  9.300232085416128e-25, -2.346795763104847e-26,  8.414820050112596e-13, -2.015858615896076e-13,  2.515500442348337e-14, -2.146108262917257e-15,
  1.402461765084081e-16, -7.472593620453126e-18,  3.376873798310821e-19, -1.329790954764370e-20,  4.654106259875491e-22, -1.469497773404602e-23,  4.235162625862845e-25,
 -1.124040491487925e-26,  2.105676440053232e-13, -5.376270972098813e-14,  7.150847168684811e-15, -6.491735097733178e-16,  4.505563208496679e-17, -2.544881602433775e-18,
  1.216967441587142e-19, -5.062789855300003e-21,  1.868972783484248e-22, -6.215179382999268e-24,  1.883941517551898e-25, -5.251644594283530e-27,  5.286128106950921e-14,
 -1.433967608827559e-14,  2.027569420438950e-15, -1.953973809606135e-16,  1.437154780342388e-17, -8.587651214554544e-19,  4.337333014874923e-20, -1.902792497922874e-21,
  7.396385209315325e-23, -2.586290489764789e-24,  8.232324611510638e-26, -2.406633286083747e-27,  1.340520640386414e-14, -3.851313412311017e-15,  5.773284073715950e-16,
 -5.891575304414754e-17,  4.581605662846507e-18, -2.890076492339861e-19,  1.538565617468283e-20, -7.104095549009643e-22,  2.902399746571143e-23, -1.065274246043107e-24,
  3.554735644692257e-26, -1.088049329934700e-27,  3.459336364720562e-15, -1.049204523468267e-15,  1.662763292830104e-16, -1.792188948248354e-17,  1.470027866343880e-18,
 -9.766806783535897e-20,  5.468690483486997e-21, -2.652222958892059e-22,  1.136650901098256e-23, -4.370790291251989e-25,  1.526226489862216e-26, -4.882611991280949e-28,
  9.155269855407159e-16, -2.921728158331419e-16,  4.880872367446934e-17, -5.541408889245931e-18,  4.782030459483076e-19, -3.338316952855057e-20,  1.961483774519079e-21,
 -9.969901806177551e-23,  4.472602807180168e-24, -1.798206912290399e-25,  6.557830473970851e-27, -2.188568760062877e-28,  2.505131461548842e-16, -8.383709234799191e-17,
  1.471828968410672e-17, -1.755137310192622e-18,  1.589210201685295e-19, -1.162700747962643e-20,  7.151263917046644e-22, -3.800513446744970e-23,  1.780639348445029e-24,
 -7.468749650620668e-26,  2.838619466584758e-27, -9.862310817221605e-29,  7.146354547390640e-17, -2.499345052620234e-17,  4.596477189303822e-18, -5.739858483524450e-19,
  5.437542967894860e-20, -4.157831808143659e-21,  2.669884991842011e-22, -1.479791089659930e-23,  7.223229927339161e-25, -3.153288698814979e-26,  1.246124050841275e-27,
 -4.497099392158977e-29,  2.143178769906223e-17, -7.805419823356862e-18,  1.498716845344266e-18, -1.953585987971332e-19,  1.930355733755177e-20, -1.538161605252842e-21,
  1.028269328648683e-22, -5.927522578317535e-24,  3.006421177062536e-25, -1.362466622695222e-26,  5.584414402707160e-28, -2.088308251069727e-29,  6.811974019387482e-18,
 -2.574115337229138e-18,  5.142218488468562e-19, -6.973213378912408e-20,  7.163523087503581e-21, -5.929605141541507e-22,  4.114231409968918e-23, -2.459425067516416e-24,
  1.292451396709507e-25, -6.063568066384210e-27,  2.570762435953707e-28, -9.935371039433230e-30,  2.311944927279278e-18, -9.030919621931382e-19,  1.870053042630740e-19,
 -2.628773032144457e-20,  2.797893801813922e-21, -2.397765017925060e-22,  1.721127594851335e-23, -1.063562715631661e-24,  5.773153279998509e-26, -2.795548042700513e-27,
  1.222415622536306e-28, -4.868733961176176e-30,  8.431387921917883e-19, -3.391552745642756e-19,  7.251785307294939e-20, -1.052740600574367e-20,  1.156612590119289e-21,
 -1.022557189347179e-22,  7.567080634122242e-24, -4.817429643106439e-25,  2.692189945915391e-26, -1.341243664861421e-27,  6.030060714791910e-29, -2.467590484330133e-30,
  3.317763863566242e-19, -1.368994127210193e-19,  3.010395904815264e-20, -4.495233308690443e-21,  5.078326955310640e-22, -4.614237598598345e-23,  3.507294766833311e-24,
 -2.292104929459844e-25,  1.314144108037097e-26, -6.712883013408742e-28,  3.092699972259471e-29, -1.296084954946227e-30,  1.409314732209182e-19, -5.941581011357301e-20,
  1.338076894886186e-20, -2.046703965651249e-21,  2.367839157142259e-22, -2.202306093581264e-23,  1.712731537680033e-24, -1.144657189320304e-25,  6.707967280673954e-27,
 -3.500651837845076e-28,  1.646864564345109e-29, -7.043730538023513e-31,  6.420262407808819e-20, -2.754482535435673e-20,  6.325484189071711e-21, -9.868046629966858e-22,
  1.164137720516871e-22, -1.103725347889191e-23,  8.746561676676507e-25, -5.954068633292051e-26,  3.552575595196459e-27, -1.886861326810895e-28,  9.030561496174193e-30,
 -3.927674949741693e-31,  3.070161579188967e-20, -1.334982774486661e-20,  3.112194280930005e-21, -4.929698230938616e-22,  5.904012511958284e-23, -5.681314391607729e-24,
  4.568182506146989e-25, -3.154313066457672e-26,  1.908463469933385e-27, -1.027531719417295e-28,  4.983696329087101e-30, -2.195871573620339e-31,  1.447892114473473e-20,
 -6.354706067185920e-21,  1.497069777315071e-21, -2.396689315616048e-22,  2.900773725761181e-23, -2.820435759140477e-24,  2.290995962380040e-25, -1.597742481407314e-26,
  9.761420489023834e-28, -5.305885029361364e-29,  2.597495993447906e-30, -1.154910313149271e-31,  5.258358609669813e-21, -2.319858245931030e-21,  5.497317553374254e-22,
 -8.853176315016674e-23,  1.077849076683559e-23, -1.054086048723020e-24,  8.610958986339801e-26, -6.038790580587699e-27,  3.709538626881490e-28, -2.027104525854059e-29,
  9.975459405521998e-31, -4.457881864710598e-32,  5.284165715603430e-02, -1.148922309855869e-04,  2.576852935577053e-07, -5.935473418750711e-10,  1.396229856160009e-12,
 -3.336477350931813e-15,  8.058395207976463e-18, -1.960140323190003e-20,  4.785413742155074e-23, -1.170821054958890e-25,  2.864000053191791e-28, -7.005748202003630e-31,
  4.970803579798098e-02, -1.301997964859879e-04,  4.021991682457891e-07, -1.308746880358986e-09,  4.261973139726259e-12, -1.367769505269351e-14,  4.314720625384592e-17,
 -1.339584925384432e-19,  4.100756640889701e-22, -1.239987913103526e-24,  3.708759155278383e-27, -1.098571283174289e-29,  4.398929578095359e-02, -1.544178180670826e-04,
  6.648755790410367e-07, -2.807456085458856e-09,  1.133095747717231e-11, -4.401846210851655e-14,  1.658664398517114e-16, -6.095323542666907e-19,  2.192761891058524e-21,
 -7.743775291216372e-24,  2.690369578666202e-26, -9.211133391928431e-29,  3.662503651272635e-02, -1.776130402804047e-04,  9.940331180456165e-07, -5.115336847220947e-09,
  2.459266241381504e-11, -1.124538895449614e-13,  4.942855947118963e-16, -2.102705804634132e-18,  8.699372139987133e-21, -3.513191448508145e-23,  1.388894760506303e-25,
 -5.387475084104817e-28,  2.869334242333402e-02, -1.905179134388451e-04,  1.319280215337388e-06, -8.069570526728787e-09,  4.544907488070104e-11, -2.408951925418949e-13,
  1.216663423337455e-15, -5.904490117674813e-18,  2.770084320269649e-20, -1.262076690790891e-22,  5.604077818410367e-25, -2.432041484133288e-27,  2.115628738321289e-02,
 -1.879799905173721e-04,  1.567052041893377e-06, -1.124521973078412e-08,  7.333575816611199e-11, -4.454057981410944e-13,  2.556537386369505e-15, -1.400658839151584e-17,
  7.377588772555683e-20, -3.756097874386461e-22,  1.856143182863017e-24, -8.932417933430301e-27,  1.468450523664584e-02, -1.702089649504786e-04,  1.681651291701401e-06,
 -1.402423556578349e-08,  1.049102629120724e-10, -7.236193510821224e-13,  4.680764860148897e-15, -2.872249371352397e-17,  1.685757103739762e-19, -9.521434973339034e-22,
  5.200023912486038e-24, -2.756308862631777e-26,  9.597799277902504e-03, -1.416929343969031e-04,  1.642383940082286e-06, -1.579128049664282e-08,  1.344596535067365e-10,
 -1.045762400618492e-12,  7.572772933330316e-15, -5.171906048787702e-17,  3.362092232261092e-19, -2.094626461102602e-21,  1.257292355040441e-23, -7.301359156029777e-26,
  5.909272038397117e-03, -1.087792881292507e-04,  1.467904840237555e-06, -1.615902359567091e-08,  1.556059977640797e-10, -1.356623782230107e-12,  1.093743539747096e-14,
 -8.270951573374448e-17,  5.926033122775539e-19, -4.053270345525392e-21,  2.661920749648863e-23, -1.686196216688845e-25,  3.428724718370455e-03, -7.726416255707130e-05,
  1.205838301941419e-06, -1.510461430295837e-08,  1.635965148518892e-10, -1.590870854595504e-12,  1.421396017264293e-14, -1.184971261429496e-16,  9.319012001981198e-19,
 -6.970096981128012e-21,  4.989283829848873e-23, -3.434822870185944e-25,  1.875795361007035e-03, -5.092799508881710e-05,  9.137040917744397e-07, -1.295246992203946e-08,
  1.570356411983454e-10, -1.695956452040339e-12,  1.672580856126014e-14, -1.531467463825131e-16,  1.317296959159324e-18, -1.073768201091380e-20,  8.350437215108857e-23,
 -6.228282031082759e-25,  9.681554395168072e-04, -3.123725627494656e-05,  6.406108845377786e-07, -1.022662193608515e-08,  1.382052483103514e-10, -1.651385766704916e-12,
  1.791414057093304e-14, -1.795667547893768e-16,  1.684126921718216e-18, -1.491701876166886e-20,  1.256768997647274e-22, -1.012809435191132e-24,  4.717397070805132e-04,
 -1.787339829330992e-05,  4.167373255834700e-07, -7.458506565049029e-09,  1.119287827378406e-10, -1.474692624836996e-12,  1.754186914605812e-14, -1.919372765360275e-16,
  1.957480716452046e-18, -1.879142438928715e-20,  1.710924771072812e-22, -1.486209738940018e-24,  2.171655278514168e-04, -9.562070668573194e-06,  2.521869196146978e-07,
 -5.039470339237603e-09,  8.368960489282459e-11, -1.212094297032584e-12,  1.576613479859586e-14, -1.878179815167185e-16,  2.077817335818110e-18, -2.156858939171586e-20,
  2.117545812816698e-22, -1.978510433999678e-24,  9.453465994538005e-05, -4.793339901328911e-06,  1.423065650632408e-07, -3.163112433211038e-09,  5.794529829481769e-11,
 -9.199679084519564e-13,  1.305190307923378e-14, -1.688867671205241e-16,  2.022290799246143e-18, -2.265203815300034e-20,  2.393301805060221e-22, -2.400674971991126e-24,
  3.895257247034315e-05, -2.256105854583263e-06,  7.505531046161707e-08, -1.849122176415265e-09,  3.725692276587730e-11, -6.467408287833604e-13,  9.984638574234377e-15,
 -1.400337797336484e-16,  1.811294345954149e-18, -2.185150730236141e-20,  2.480104606369336e-22, -2.666172611528883e-24,  1.520960361101420e-05, -9.990650259239831e-07,
  3.708393079236531e-08, -1.009319221957188e-09,  2.230557312498184e-11, -4.223414758465766e-13,  7.079954725386682e-15, -1.074115111560434e-16,  1.498013746352017e-18,
 -1.943051528624820e-20,  2.365140402602004e-22, -2.720659337228782e-24,  5.634994116482155e-06, -4.170839096001412e-07,  1.720407102726437e-08, -5.156814046823966e-10,
  1.246773951942321e-11, -2.569151059757385e-13,  4.667104153939120e-15, -7.645203192045797e-17,  1.147681516200938e-18, -1.597974952746324e-20,  2.082893987326428e-22,
 -2.560080310172946e-24,  1.983777451074672e-06, -1.644951626298544e-07,  7.511504882582143e-09, -2.472340653333811e-10,  6.523428850135194e-12, -1.459855346235042e-13,
  2.868385411538565e-15, -5.064673534505953e-17,  8.170675471932183e-19, -1.219374813727639e-20,  1.699593551175919e-22, -2.229026473518305e-24,  6.647032645633430e-07,
 -6.142235250952827e-08,  3.093951191048318e-09, -1.115105265139682e-10,  3.203599452686800e-12, -7.770188916153406e-14,  1.648357204422485e-15, -3.132060523441029e-17,
  5.421970852944421e-19, -8.660761707688403e-21,  1.289133767348566e-22, -1.801784135710240e-24,  2.123734596488170e-07, -2.176416053923051e-08,  1.205251848275294e-09,
 -4.744056998158290e-11,  1.480696961061303e-12, -3.884955163814514e-14,  8.882924745118182e-16, -1.813534344836302e-17,  3.363968127227405e-19, -5.743682585448043e-21,
  9.118426051596923e-23, -1.356561454611950e-24,  6.483558702692019e-08, -7.336156587650886e-09,  4.452138967217693e-10, -1.909021136191422e-11,  6.459505299130231e-13,
 -1.829975277646844e-14,  4.502489008179765e-16, -9.862033576615811e-18,  1.957472185610711e-19, -3.567945624199395e-21,  6.034098355819720e-23, -9.544428323944079e-25,
  1.895758176622417e-08, -2.358639038393096e-09,  1.563910040897884e-10, -7.287335860816740e-12,  2.667722043685497e-13, -8.145894658031514e-15,  2.153246727196283e-16,
 -5.052721211069462e-18,  1.071718585841014e-19, -2.082812667655997e-21,  3.748037008480220e-23, -6.296214261606285e-25,  5.322906005776152e-09, -7.253994540183338e-10,
  5.239923632957738e-11, -2.647159597183578e-12,  1.046340096654507e-13, -3.437715436517354e-15,  9.747641457641447e-17, -2.447018948847144e-18,  5.539311482524257e-20,
 -1.146429550193300e-21,  2.192639702274825e-23, -3.907622080864556e-25,  1.439424561570157e-09, -2.140868474986971e-10,  1.680097647100091e-11, -9.181261378577900e-13,
  3.910878733928589e-14, -1.380166625470689e-15,  4.191543881070047e-17, -1.124127782563399e-18,  2.712324787978533e-20, -5.970871118490191e-22,  1.212375060805438e-23,
 -2.289757256724534e-25,  3.761257343663573e-10, -6.084259619200826e-11,  5.173580498870194e-12, -3.051481130110973e-13,  1.398088890205554e-14, -5.290810421972672e-16,
  1.718388359377040e-17, -4.916634780376478e-19,  1.262839732765469e-20, -2.953468539907869e-22,  6.359531361938964e-24, -1.271518774112935e-25,  9.531860672567699e-11,
 -1.671432351121859e-11,  1.535984400288904e-12, -9.756955714383619e-14,  4.799230904161748e-15, -1.944295824924820e-16,  6.743129828276156e-18, -2.055473596002552e-19,
  5.612930825020609e-21, -1.392968745111894e-22,  3.177144916752026e-24, -6.717582048715235e-26,  2.352346169762091e-11, -4.457163592853451e-12,  4.415407460298433e-13,
 -3.014205445397302e-14,  1.588715935765217e-15, -6.878757505618484e-17,  2.543585383130876e-18, -8.248804700658461e-20,  2.391663997449918e-21, -6.290553402190530e-23,
  1.518051231149193e-24, -3.390495147832812e-26,  5.679097879234297e-12, -1.159113646151173e-12,  1.234715187465162e-13, -9.038832068974448e-15,  5.095415287304527e-16,
 -2.353837001944506e-17,  9.265615606869798e-19, -3.192195142571771e-20,  9.814050759729457e-22, -2.732293460554539e-23,  6.968021843007642e-25, -1.642074564698843e-26,
  1.348030647862896e-12, -2.954605753466676e-13,  3.375890584153751e-14, -2.644482862122402e-15,  1.591355935977615e-16, -7.829617425118249e-18,  3.275707405055330e-19,
 -1.197142513763697e-20,  3.897183509312166e-22, -1.146967573402046e-23,  3.087293239263821e-25, -7.667453113771828e-27,  3.163557603207841e-13, -7.423375458312556e-14,
  9.075139835158665e-15, -7.590355658555082e-16,  4.866239012486432e-17, -2.545437760407630e-18,  1.129984219824140e-19, -4.373870639831437e-21,  1.505513599567276e-22,
 -4.677436251157089e-24,  1.327119003294894e-25, -3.469180731169255e-27,  7.385115241858144e-14, -1.849608904885905e-14,  2.413213438932089e-15, -2.150244882428598e-16,
  1.465687235947713e-17, -8.135681019636536e-19,  3.825549759703208e-20, -1.565784902191950e-21,  5.689788823720750e-23, -1.863406275371985e-24,  5.565178308576888e-26,
 -1.529176784687466e-27,  1.726387956840409e-14, -4.600631039982093e-15,  6.389606168798543e-16, -6.051249603000696e-17,  4.376241108439799e-18, -2.572676955648810e-19,
  1.279022045357393e-20, -5.525985303699162e-22,  2.116444519857714e-23, -7.295043475249246e-25,  2.289915355820892e-26, -6.604407524581680e-28,  4.070604572302278e-15,
 -1.150623391590345e-15,  1.696578725103580e-16, -1.703641922547892e-17,  1.304285028526988e-18, -8.103773975619600e-20,  4.251335888153201e-21, -1.935298691527460e-22,
  7.798558175088505e-24, -2.824323508441444e-25,  9.303039664797080e-27, -2.811889816998785e-28,  9.756589827371986e-16, -2.915936780553299e-16,  4.552008663801380e-17,
 -4.834426266225973e-18,  3.908928662259393e-19, -2.561211247711867e-20,  1.414888974220107e-21, -6.772881209204428e-23,  2.866057050817597e-24, -1.088613171126371e-25,
  3.756142948479140e-27, -1.187787465130413e-28,  2.396938600745271e-16, -7.549498605752430e-17,  1.244155679418522e-17, -1.393794205238434e-18,  1.187262651702433e-19,
 -8.184327560733910e-21,  4.750338777633892e-22, -2.386015992547156e-23,  1.058125243678604e-24, -4.206835989113136e-26,  1.517586870038064e-27, -5.011533659059106e-29,
  6.088718306135307e-17, -2.014201880554758e-17,  3.493634115729980e-18, -4.116792902385402e-19,  3.684565579472871e-20, -2.665455492648553e-21,  1.621536958941973e-22,
 -8.526393966902929e-24,  3.953772934359881e-25, -1.641815896686348e-26,  6.179413793595799e-28, -2.126705094430359e-29,  1.613732746665469e-17, -5.587463818880827e-18,
  1.016772544499949e-18, -1.256496117463193e-19,  1.178228934256763e-20, -8.920318241431234e-22,  5.673014449341812e-23, -3.114935304926669e-24,  1.506687196309204e-25,
 -6.519435133978448e-27,  2.554284656014722e-28, -9.141390826252151e-30,  4.503565918817491e-18, -1.626254062223710e-18,  3.094374104993163e-19, -3.997410162219694e-20,
  3.915265158686742e-21, -3.093159615815680e-22,  2.050622476967087e-23, -1.172550327969916e-24,  5.900461357645816e-26, -2.653598012699827e-27,  1.079572607514880e-28,
 -4.008009668185240e-30,  1.335427578450858e-18, -5.010664189621547e-19,  9.933770740348700e-20, -1.336933397871325e-20,  1.363272943885423e-21, -1.120317921670759e-22,
  7.718754412498694e-24, -4.582670165272368e-25,  2.392255369957317e-26, -1.115088564266341e-27,  4.697942743548241e-29, -1.804573870214361e-30,  4.243327597119932e-19,
 -1.648051934169825e-19,  3.391548601650095e-20, -4.738146279586449e-21,  5.012425494986251e-22, -4.270194396374607e-23,  3.047510293743324e-24, -1.872636406877697e-25,
  1.010945687530862e-26, -4.869345055447707e-28,  2.118233818636327e-29, -8.394371084190775e-31,  1.455467983605358e-19, -5.828495220461906e-20,  1.240164479722528e-20,
 -1.791559180279407e-21,  1.958888362641139e-22, -1.723730086704679e-23,  1.269759252372622e-24, -8.047703020651875e-26,  4.477931140747465e-27, -2.221493500139611e-28,
  9.946581140520109e-30, -4.054076943608778e-31,  5.417379027992939e-20, -2.227868140442012e-20,  4.881013827035872e-21, -7.261599071905731e-22,  8.173719900533345e-23,
 -7.400361695203356e-24,  5.605535734101699e-25, -3.650984253520634e-26,  2.086351919422009e-27, -1.062332703407864e-28,  4.879024767596832e-30, -2.038504756968729e-31,
  2.191421577153173e-20, -9.217027324089980e-21,  2.070283192353505e-21, -3.158328415215657e-22,  3.644388614097325e-23, -3.380992815492159e-24,  2.622867223597414e-25,
 -1.748678522594938e-26,  1.022350992458952e-27, -5.323033083515411e-29,  2.498591756185472e-30, -1.066338836938285e-31,  9.581263723191194e-21, -4.104279914173086e-21,
  9.408930082585359e-22, -1.465282334333699e-22,  1.725631587320298e-23, -1.633327692663397e-24,  1.292215828982606e-25, -8.782421730410711e-27,  5.231954370844741e-28,
 -2.774584529984983e-29,  1.325949345038806e-30, -5.758642508392643e-32,  4.435665660619881e-21, -1.926987738811667e-21,  4.487741585876401e-22, -7.101249591770036e-23,
  8.496109895322719e-24, -8.167484438367902e-25,  6.560832680600174e-26, -4.525912099937625e-27,  2.735777818221954e-28, -1.471626557876858e-29,  7.131303846419883e-31,
 -3.139422362324581e-32,  2.044402301615266e-21, -8.968663568373021e-22,  2.111791796656824e-22, -3.379049131101078e-23,  4.087636391625159e-24, -3.972407782067478e-25,
  3.225116015504186e-26, -2.248100095388892e-27,  1.372821994648044e-28, -7.458575193731799e-30,  3.649674860501861e-31, -1.622010694093385e-32,  7.329228072908984e-22,
 -3.232823255619875e-22,  7.658995468920918e-23, -1.233157439251550e-23,  1.500983834628343e-24, -1.467552889164041e-25,  1.198588625577133e-26, -8.403708309650561e-28,
  5.161129535770869e-29, -2.819722529990391e-30,  1.387298806053362e-31, -6.198324444135727e-33,  5.238616661674174e-02, -1.128588641391032e-04,  2.506945949825210e-07,
 -5.717311759465815e-10,  1.331390746063192e-12, -3.149492713902543e-15,  7.530376343899758e-18, -1.813535799896884e-20,  4.383817507113452e-23, -1.062192116912095e-25,
  2.573060044690862e-28, -6.234848134950877e-31,  4.919357394360651e-02, -1.270438841643630e-04,  3.868945066565194e-07, -1.242688726500175e-09,  3.998478242428573e-12,
 -1.268572956872093e-14,  3.957357033069256e-17, -1.215225916072650e-19,  3.679939369626683e-22, -1.100866211403949e-24,  3.257788474258475e-27, -9.548653366469566e-30,
  4.338205341589777e-02, -1.492305548375053e-04,  6.322455108493826e-07, -2.632993093247059e-09,  1.048905367286585e-11, -4.023479175096204e-14,  1.497414180715880e-16,
 -5.436243638315050e-19,  1.932418545371467e-21, -6.744474840553219e-24,  2.316119290986479e-26, -7.839281115460186e-29,  3.593010933927437e-02, -1.698997891399890e-04,
  9.349377864008322e-07, -4.739221788923225e-09,  2.245760197967190e-11, -1.012672189028171e-13,  4.391244011933256e-16, -1.843534339045730e-18,  7.529164803458649e-21,
 -3.002278679450573e-23,  1.172191943093175e-25, -4.491318587731902e-28,  2.795178294800726e-02, -1.803390050781145e-04,  1.226654479200643e-06, -7.379396491266006e-09,
  4.091027927334765e-11, -2.135830613331689e-13,  1.063094316008376e-15, -5.086633292159740e-18,  2.353634440163629e-20, -1.057931495103660e-22,  4.635665606167749e-25,
 -1.985692748968492e-27,  2.042861291195083e-02, -1.759640534039651e-04,  1.438866115770247e-06, -1.013990750136102e-08,  6.501077174408385e-11, -3.885003413320802e-13,
  2.195469586734764e-15, -1.184851648677935e-17,  6.150078463848780e-20, -3.086657332790785e-22,  1.504105831459346e-24, -7.139465543211128e-27,  1.402954883936522e-02,
 -1.574014438928527e-04,  1.522973311343786e-06, -1.245560960123785e-08,  9.149913782732143e-11, -6.203524760048798e-13,  3.947176991870535e-15, -2.383861863568210e-17,
  1.377676405022408e-19, -7.665147669937582e-22,  4.125136867980129e-24, -2.155295470470524e-26,  9.056155160775915e-03, -1.292767990752617e-04,  1.465137190523658e-06,
 -1.379784448119004e-08,  1.152505717331427e-10, -8.802440768288320e-13,  6.264582110326461e-15, -4.207575955021515e-17,  2.691309398062751e-19, -1.650542245951029e-21,
  9.756395611624231e-24, -5.581319191079757e-26,  5.496470423697189e-03, -9.777133087313709e-05,  1.288083498644244e-06, -1.387287552033743e-08,  1.309214495056742e-10,
 -1.119900701119125e-12,  8.866504112715931e-15, -6.588907578151695e-17,  4.641883858157835e-19, -3.123351962425501e-21,  2.018736714272136e-23, -1.258994943167541e-25,
  3.137873308386722e-03, -6.830028244340870e-05,  1.039295318113556e-06, -1.272414470450926e-08,  1.349381761116467e-10, -1.286399870472599e-12,  1.127839412332423e-14,
 -9.233362843829330e-17,  7.135329664659351e-19, -5.246940390215543e-21,  3.694270250083297e-23, -2.502616809184293e-25,  1.685775331464186e-03, -4.419981027472873e-05,
  7.722974059228314e-07, -1.069081885782865e-08,  1.268065512059013e-10, -1.341566398647057e-12,  1.297403960036427e-14, -1.165835391895469e-16,  9.847946554595014e-19,
 -7.887743595378878e-21,  6.030405520318737e-23, -4.423748525950316e-25,  8.527289080771974e-04, -2.656802162494535e-05,  5.301404595115861e-07, -8.257805589849688e-09,
  1.090991563674860e-10, -1.276154573647306e-12,  1.356647254817985e-14, -1.333776273456578e-16,  1.227795572046487e-18, -1.068046794371893e-20,  8.841970509276925e-23,
 -7.005012198273452e-25,  4.063872667165350e-04, -1.486916487391057e-05,  3.370765069732628e-07, -5.882429726254411e-09,  8.624375628338235e-11, -1.111681279459394e-12,
  1.295160200719451e-14, -1.389190761130742e-16,  1.389881756197354e-18, -1.309767171143718e-20,  1.171277885754019e-22, -9.998095899420041e-25,  1.825991019669473e-04,
 -7.765423486327321e-06,  1.990095124579880e-07, -3.875474207477631e-09,  6.284160586945944e-11, -8.899634839910592e-13,  1.133210177937633e-14, -1.322730006889858e-16,
  1.434913151479753e-18, -1.461544799751657e-20,  1.408791698199324e-22, -1.293003373707144e-24,  7.741834637107301e-05, -3.792250911560374e-06,  1.093558207209215e-07,
 -2.367648123621867e-09,  4.233018185451831e-11, -6.568478043925291e-13,  9.118532093059471e-15, -1.155620848783556e-16,  1.356368463841512e-18, -1.490230764774158e-20,
  1.545313946458588e-22, -1.522153563310863e-24,  3.100161034378998e-05, -1.735191978945823e-06,  5.605445716153657e-08, -1.344693941124210e-09,  2.643181999424927e-11,
 -4.482749118301105e-13,  6.769318934239674e-15, -9.295246092406241e-17,  1.178111048558820e-18, -1.393649727093457e-20,  1.551979774364840e-22, -1.637905505194322e-24,
  1.173776691372682e-05, -7.453604718243796e-07,  2.686201926341260e-08, -7.117052094776848e-10,  1.533979591234333e-11, -2.836824351949659e-13,  4.650160266747006e-15,
 -6.905234730841028e-17,  9.433937152939482e-19, -1.199563487166587e-20,  1.432296077346210e-22, -1.617090492556698e-24,  4.207050318463061e-06, -3.011671271360368e-07,
  1.206112431487447e-08, -3.518775285756368e-10,  8.295534483600208e-12, -1.669215575968550e-13,  2.964428199807721e-15, -4.751998390553133e-17,  6.986590994700313e-19,
 -9.534264405817896e-21,  1.218815040166543e-22, -1.470044014314456e-24,  1.429431461416919e-06, -1.146957777260830e-07,  5.085510938247997e-09, -1.629102854189810e-10,
  4.190968705220529e-12, -9.157012615008727e-14,  1.758679048060396e-15, -3.038280448665250e-17,  4.799830179658708e-19, -7.019656728055927e-21,  9.594403491791594e-23,
 -1.234636657996195e-24,  4.611326841194701e-07, -4.125736009718951e-08,  2.018312634746729e-09, -7.080204702466032e-11,  1.983160539103485e-12, -4.696046431889409e-14,
  9.736996230351953e-16, -1.810070488970218e-17,  3.068157212865871e-19, -4.802326623901241e-21,  7.008968932905326e-23, -9.611231733596286e-25,  1.414946282614854e-07,
 -1.404884531281877e-08,  7.557994246447806e-10, -2.895999812256747e-11,  8.813241319874689e-13, -2.257610672100384e-14,  5.045378764170867e-16, -1.007746737356082e-17,
  1.830315503588791e-19, -3.062190441591451e-21,  4.766669715006431e-23, -6.957435382185929e-25,  4.137919188652664e-08, -4.539497350820063e-09,  2.677377349365189e-10,
 -1.117836198577343e-11,  3.688572986205700e-13, -1.020346254422274e-14,  2.453954671785581e-16, -5.258926154936522e-18,  1.022112960694603e-19, -1.825622099014472e-21,
  3.027464298991338e-23, -4.698420772526006e-25,  1.155959749219967e-08, -1.395511910291406e-09,  8.996994905922457e-11, -4.083465500148092e-12,  1.458152510562399e-13,
 -4.348422814632736e-15,  1.123752547322365e-16, -2.580367208056221e-18,  5.360011906042841e-20, -1.020884303818223e-21,  1.801580155351910e-23, -2.969702495381471e-25,
  3.092716994139103e-09, -4.093108321912456e-10,  2.876510011983472e-11, -1.416067578755429e-12,  5.461718916907664e-14, -1.753002458565458e-15,  4.860766909520337e-17,
 -1.194315288569100e-18,  2.648227382147258e-20, -5.372439198622650e-22,  1.007846044390868e-23, -1.762788887245297e-25,  7.947572689530011e-10, -1.149010029997606e-10,
  8.778558703072654e-12, -4.677166273329259e-13,  1.944901577223417e-14, -6.707721184413628e-16,  1.992764074818300e-17, -5.232466990849288e-19,  1.237010010445477e-20,
 -2.669989871141338e-22,  5.318903881202013e-24, -9.861485819959962e-26,  1.968083309424184e-10, -3.097717221230086e-11,  2.566304801595873e-12, -1.476686662771528e-13,
  6.608233303602557e-15, -2.445096440644290e-16,  7.771714849594290e-18, -2.177916198416910e-19,  5.483019776721925e-21, -1.257747509121110e-22,  2.657920660953299e-24,
 -5.218495044865794e-26,  4.713671286367488e-11, -8.051215985730969e-12,  7.214536145893271e-13, -4.474095285381561e-14,  2.150827024212221e-15, -8.524356947392418e-17,
  2.894703169003930e-18, -8.646447532876247e-20,  2.315299034467425e-21, -5.638086786808896e-23,  1.262579688503661e-24, -2.622467220256174e-26,  1.096392730754386e-11,
 -2.025882076487731e-12,  1.958748544676106e-13, -1.306466173767095e-14,  6.734795443751331e-16, -2.854534148703112e-17,  1.034129203935670e-18, -3.288106178771584e-20,
  9.353540908208629e-22, -2.415217306138945e-23,  5.725252588811027e-25, -1.256750620729232e-26,  2.488045262225529e-12, -4.958234244769645e-13,  5.160127782759319e-14,
 -3.694116806373557e-15,  2.038357198071281e-16, -9.224550944372873e-18,  3.559959744176621e-19, -1.203281886779341e-20,  3.631729653474118e-22, -9.932032382991383e-24,
  2.489459823900021e-25, -5.769020474354384e-27,  5.536788853799015e-13, -1.186430402720531e-13,  1.325868114436538e-14, -1.016677157542815e-15,  5.993780580286579e-17,
 -2.891361748820879e-18,  1.186878660730615e-19, -4.258659096204691e-21,  1.361972229214109e-22, -3.940071536325457e-24,  1.043024501647575e-25, -2.548889258046103e-27,
  1.215157896155944e-13, -2.791482761550686e-14,  3.341703376359067e-15, -2.738863084812067e-16,  1.721948385518015e-17, -8.839269817046136e-19,  3.853374536933365e-20,
 -1.465604640367348e-21,  4.959818979430711e-23, -1.515829786804786e-24,  4.232819953859109e-26, -1.089515822024101e-27,  2.646735555519418e-14, -6.498740816585832e-15,
  8.313264645316594e-16, -7.267029493840511e-17,  4.862878279726205e-18, -2.651609927566891e-19,  1.225568217941534e-20, -4.933451858971896e-22,  1.764091944814509e-23,
 -5.687942867153105e-25,  1.673217069474617e-26, -4.530587794042053e-28,  5.760920806719138e-15, -1.507338872386648e-15,  2.055281033297862e-16, -1.911917371155796e-17,
  1.358965778673083e-18, -7.856489890097468e-20,  3.843245566354675e-21, -1.634683368029862e-22,  6.166632744474834e-24, -2.094532648584540e-25,  6.481654014595375e-27,
 -1.843713580342566e-28,  1.262571954073016e-15, -3.509416503373863e-16,  5.087273122557524e-17, -5.024371114008912e-18,  3.785230299956697e-19, -2.315523400322671e-20,
  1.196593716850716e-21, -5.368281604388921e-23,  2.132862987552879e-24, -7.619194681022263e-26,  2.476510057455277e-27, -7.389365932092744e-29,  2.809054049606647e-16,
 -8.268462509357043e-17,  1.270835995967472e-17, -1.329282244031531e-18,  1.059032424590890e-19, -6.840304495049417e-21,  3.726706317860091e-22, -1.760090673310648e-23,
  7.351604881663957e-25, -2.757240710380250e-26,  9.397373904133923e-28, -2.936471440374920e-29,  6.400667483972995e-17, -1.988661111574363e-17,  3.231524199064652e-18,
 -3.570541389928721e-19,  3.000886263507150e-20, -2.041864325021278e-21,  1.170256741892039e-22, -5.806416139354606e-24,  2.544535649626630e-25, -1.000034093279262e-26,
  3.567340417500780e-28, -1.165301779541948e-29,  1.507679870710589e-17, -4.927796526279690e-18,  8.440750629420052e-19, -9.824259969492878e-20,  8.687644629787179e-21,
 -6.211716814091137e-22,  3.736293257958174e-23, -1.943116084682742e-24,  8.914648190833281e-26, -3.663617290331900e-27,  1.365067990721371e-28, -4.652279099019998e-30,
  3.707276285588956e-18, -1.270255713490334e-18,  2.286252161720825e-19, -2.794752956405652e-20,  2.593027024711954e-21, -1.943029157035259e-22,  1.223383416261028e-23,
 -6.652319083625651e-25,  3.187454860571163e-26, -1.366610622220135e-27,  5.306770253598651e-29, -1.882843961676834e-30,  9.611961981930544e-19, -3.440083150751499e-19,
  6.484023373079803e-20, -8.298104358131968e-21,  8.053426003889780e-22, -6.305886586495693e-23,  4.144399992308127e-24, -2.349882199252421e-25,  1.172851071472361e-26,
 -5.232804224412436e-28,  2.112467996652385e-29, -7.784047414659715e-31,  2.654088678613192e-19, -9.884688066168374e-20,  1.944139990363213e-20, -2.595910412362329e-21,
  2.626639249266405e-22, -2.142307325791306e-23,  1.465207904655883e-24, -8.637150246582162e-26,  4.477603540850009e-27, -2.073086804569723e-28,  8.676945152241459e-30,
 -3.311837262821240e-31,  7.879648757959110e-20, -3.041982862313532e-20,  6.219566228104959e-21, -8.632873719033613e-22,  9.074731006913041e-23, -7.683154854209925e-24,
  5.450221682669667e-25, -3.329436108767837e-26,  1.787159357853260e-27, -8.560367347339865e-29,  3.703805847403703e-30, -1.460105221866639e-31,  2.536678135768378e-20,
 -1.011050414726239e-20,  2.140257641812874e-21, -3.076018284153304e-22,  3.346400814303402e-23, -2.930213423118768e-24,  2.148166361850761e-25, -1.355159529626435e-26,
  7.506242747709456e-28, -3.707408699408380e-29,  1.652842555479018e-30, -6.708675311395963e-32,  8.912143430133551e-21, -3.652154378076577e-21,  7.970496772714363e-22,
 -1.181188722867744e-22,  1.324481939618177e-23, -1.194691582282767e-24,  9.016480434311587e-26, -5.851782543222688e-27,  3.332460522404755e-28, -1.691131415867012e-29,
  7.741556671731198e-31, -3.224237609065711e-32,  3.426319093361961e-21, -1.437500040001689e-21,  3.219927899247880e-22, -4.898546187502366e-23,  5.636976379124121e-24,
 -5.215584413517355e-25,  4.035528249264756e-26, -2.683664919887114e-27,  1.565097301810739e-28, -8.129274645773945e-30,  3.806859916907500e-31, -1.620971490127971e-32,
  1.435161334681023e-21, -6.137692836200799e-22,  1.404487093859383e-22, -2.183244647997669e-23,  2.566513613850620e-24, -2.424930552697153e-25,  1.915179514796607e-26,
 -1.299438453277821e-27,  7.728423825632637e-29, -4.091935781269666e-30,  1.952448447649820e-31, -8.466694362664170e-33,  6.422746676336559e-22, -2.787568764564804e-22,
  6.484985930130702e-23, -1.025052169721492e-23,  1.225086859592740e-24, -1.176466283625050e-25,  9.440708289287551e-27, -6.506038402576213e-28,  3.928861557327573e-29,
 -2.111394117240323e-30,  1.022201758302835e-31, -4.495981599391037e-33,  2.889935132555905e-22, -1.267190332440149e-22,  2.982161603206184e-23, -4.769110864094949e-24,
  5.766072814067261e-25, -5.600547402240816e-26,  4.544595873884334e-27, -3.166238150434964e-28,  1.932524293145107e-29, -1.049431692517993e-30,  5.132686638209401e-32,
 -2.280036320146564e-33,  1.022079911803421e-22, -4.507314204466104e-23,  1.067590101749036e-23, -1.718486089299229e-24,  2.091214305799377e-25, -2.044148197226137e-26,
  1.669114911257281e-27, -1.170000480638916e-28,  7.183901830793482e-30, -3.923956226012750e-31,  1.930152075864312e-32, -8.621868831920589e-34,  5.193869932715747e-02,
 -1.108803930616828e-04,  2.439595870609337e-07, -5.509231930742767e-10,  1.270167855624503e-12, -2.974702106658414e-15,  7.041664821461342e-18, -1.679178467297906e-20,
  4.019312129649742e-23, -9.645500868231510e-26,  2.313991560960827e-28, -5.555018997019468e-31,  4.869149578512123e-02, -1.240073085365906e-04,  3.723578873226153e-07,
 -1.180692320831760e-09,  3.753992419582990e-12, -1.177550054545019e-14,  3.633001582312414e-17, -1.103565333692252e-19,  3.306105690562716e-22, -9.785799516406777e-25,
  2.865530485613683e-27, -8.311667969023855e-30,  4.279505096597965e-02, -1.442961813100543e-04,  6.016306065839364e-07, -2.471415590752398e-09,  9.719098021896385e-12,
 -3.681688599662978e-14,  1.353503950703736e-16, -4.854995152759013e-19,  1.705494769505100e-21, -5.883468085012758e-24,  1.997325732960503e-26, -6.683848821955788e-29,
  3.526511743180293e-02, -1.626418113180099e-04,  8.801580264186239e-07, -4.395547367162811e-09,  2.053360290397669e-11, -9.132140260808651e-14,  3.907222569025801e-16,
 -1.619026528346903e-18,  6.528189030283577e-21, -2.570647237377038e-23,  9.913436008994699e-26, -3.752416016579102e-28,  2.724950785781489e-02, -1.708691685541946e-04,
  1.141892505082195e-06, -6.757665975130595e-09,  3.688264956479937e-11, -1.896961943741820e-13,  9.306648720119477e-16, -4.390992495316398e-18,  2.004152935244516e-20,
 -8.888626154607090e-23,  3.843996464409870e-25, -1.625444204064845e-27,  1.974703213156491e-02, -1.649227295726577e-04,  1.323180824428543e-06, -9.159141240142620e-09,
  5.774191240388238e-11, -3.395776529783029e-13,  1.889672337559479e-15, -1.004725871506174e-17,  5.140012757917699e-20, -2.543432075243923e-22,  1.222323843969008e-24,
 -5.723506928174504e-27,  1.342339794372071e-02, -1.457915494841613e-04,  1.381896554396434e-06, -1.108595097011182e-08,  7.998781520515886e-11, -5.331562393265027e-13,
  3.337483937366599e-15, -1.984148680197638e-17,  1.129280519054650e-19, -6.190226473597205e-22,  3.283238369569353e-24, -1.691133198404356e-26,  8.561484080065815e-03,
 -1.181879367480383e-04,  1.310071558330405e-06, -1.208688910093355e-08,  9.905856805300386e-11, -7.431107089846314e-13,  5.198609175033097e-15, -3.434351606035064e-17,
  2.161818741664713e-19, -1.305315917154955e-21,  7.599345651777778e-24, -4.283178132729636e-26,  5.124988218165999e-03, -8.809858040273048e-05,  1.133474125195080e-06,
 -1.194635286271878e-08,  1.105102133804254e-10, -9.276634068800146e-13,  7.213714180575862e-15, -5.268847668632164e-17,  3.650395962501267e-19, -2.416684671460270e-21,
  1.537494149839050e-23, -9.441743747068189e-26,  2.880383222277251e-03, -6.056183962065925e-05,  8.987559678673005e-07, -1.075708557575594e-08,  1.117202099775678e-10,
 -1.044327222062322e-12,  8.986233909744080e-15, -7.225784279223508e-17,  5.487852984767732e-19, -3.968129882582875e-21,  2.748508025239977e-23, -1.832420907068812e-25,
  1.520566483880425e-03, -3.850203347665138e-05,  6.553474917034903e-07, -8.860695527097237e-09,  1.028419294269222e-10, -1.066047129605548e-12,  1.011131098566181e-14,
 -8.918348649006888e-17,  7.399385539766996e-19, -5.824387009803937e-21,  4.378279757260312e-23, -3.159324784094046e-25,  7.543509498304917e-04, -2.269542846108684e-05,
  4.407320676023450e-07, -6.699907340674506e-09,  8.655103958036849e-11, -9.912666906952474e-13,  1.032868708686169e-14, -9.961357817331841e-17,  9.001687525099201e-19,
 -7.691488516463878e-21,  6.257734606451025e-23, -4.874439395701933e-25,  3.518877870956332e-04, -1.243303738994246e-05,  2.740843413205765e-07, -4.664747109163865e-09,
  6.682768323305945e-11, -8.428991908444859e-13,  9.619630639122938e-15, -1.011624822599941e-16,  9.930661096871430e-19, -9.187782234235795e-21,  8.071066502775345e-23,
 -6.771016112662919e-25,  1.544494856117035e-04, -6.343539863893695e-06,  1.579938782069224e-07, -2.998797364684260e-09,  4.748693127368552e-11, -6.576979962959989e-13,
  8.199353722047519e-15, -9.378905475423342e-17,  9.978180392645605e-19, -9.973973482809347e-21,  9.440225688424690e-23, -8.512092468075942e-25,  6.383412412120957e-05,
 -3.020463927109512e-06,  8.460993118564412e-08, -1.784588161877793e-09,  3.114296842322369e-11, -4.723833585987727e-13,  6.417597650951201e-15, -7.966885735222544e-17,
  9.166854218013899e-19, -9.880102013892059e-21,  1.005654413918382e-22, -9.728491282046875e-25,  2.486483571220293e-05, -1.344740305421316e-06,  4.218607121358366e-08,
 -9.854954218954178e-10,  1.890033690369679e-11, -3.132072323852138e-13,  4.626808658996917e-15, -6.221036257615149e-17,  7.726906673321879e-19, -8.963859598060851e-21,
  9.795274224435766e-23, -1.014956666082173e-24,  9.137395645044539e-06, -5.608485754915309e-07,  1.962493016264439e-08, -5.061946080816275e-10,  1.064164544625414e-11,
 -1.922315497153710e-13,  3.081558511913936e-15, -4.479325116408243e-17,  5.995390019759414e-19, -7.473932356739373e-21,  8.754557136770946e-23, -9.701906714944770e-25,
  3.171497183371383e-06, -2.195425492905450e-07,  8.536183883357897e-09, -2.424015044750928e-10,  5.572614635060673e-12, -1.095020407035803e-13,  1.901308381206524e-15,
 -2.982728306588721e-17,  4.295278971356198e-19, -5.745370250936686e-21,  7.203652626505002e-23, -8.526702274564097e-25,  1.041078326620338e-06, -8.081704633462653e-08,
  3.479191699301450e-09, -1.084734571435660e-10,  2.720808611189908e-12, -5.804426744666018e-14,  1.089725084073016e-15, -1.842073504712227e-17,  2.849827766895153e-19,
 -4.084525488007591e-21,  5.474695167650267e-23, -6.912792776172517e-25,  3.236921521799149e-07, -2.803384934536699e-08,  1.331763587237770e-09, -4.546967778173070e-11,
  1.241707037966166e-12, -2.870633332682496e-14,  5.817689127621142e-16, -1.058089841364620e-17,  1.756188354057513e-19, -2.693595829102346e-21,  3.854852406080934e-23,
 -5.186387746676970e-25,  9.548912024821930e-08, -9.183283006776008e-09,  4.798814236941966e-10, -1.789828804057132e-11,  5.310671779467999e-13, -1.328143484989310e-14,
  2.901071672005062e-16, -5.668933281170236e-18,  1.008147371882304e-19, -1.652718818380695e-21,  2.522534412158719e-23, -3.612334094367599e-25,  2.677898923716879e-08,
 -2.847481956874989e-09,  1.631876233126940e-10, -6.633322000269287e-12,  2.134356349767539e-13, -5.764649658774799e-15,  1.355137349355708e-16, -2.841284900160583e-18,
  5.407250266800071e-20, -9.463831955752606e-22,  1.538862233865831e-23, -2.343146032132264e-25,  7.155070285856522e-09, -8.378636435841521e-10,  5.251175557460515e-11,
 -2.321100543147975e-12,  8.083841956298706e-14, -2.354156093162900e-15,  5.947347656520435e-17, -1.336237830571728e-18,  2.718133724680165e-20, -5.073405750057286e-22,
  8.779680450120066e-24, -1.420043854588763e-25,  1.826011514498276e-09, -2.346083291731414e-10,  1.603650781176232e-11, -7.691398542200794e-13,  2.894237900442426e-14,
 -9.073725908463648e-16,  2.460088178972953e-17, -5.915578406911062e-19,  1.284729264063447e-20, -2.554560030803496e-22,  4.700106843007453e-24, -8.067568259994854e-26,
  4.463739147620398e-10, -6.270536339059094e-11,  4.662634005720551e-12, -2.421476623012168e-13,  9.827707391937015e-15, -3.311889692115111e-16,  9.623428722433686e-18,
 -2.473606412613515e-19,  5.729071329785152e-21, -1.212302912639156e-22,  2.369136773431477e-24, -4.311552570435449e-26,  1.048571825944095e-10, -1.605221430301527e-11,
  1.295212147124036e-12, -7.268800235719437e-14,  3.176365975844682e-15, -1.148879371483093e-16,  3.573026827603731e-18, -9.805383805111058e-20,  2.419209785121140e-21,
 -5.442182935623274e-23,  1.128541458175178e-24, -2.175551094542560e-26,  2.375643452526425e-11, -3.950723139462068e-12,  3.450752598716670e-13, -2.088550877300586e-14,
  9.810025148620086e-16, -3.802647220181913e-17,  1.264083091753478e-18, -3.699168651703880e-20,  9.711420699757536e-22, -2.320080685624194e-23,  5.100213305302885e-25,
 -1.040507198365621e-26,  5.212292196293101e-12, -9.387668179256097e-13,  8.855268590735160e-14, -5.768842305059738e-15,  2.907597450123446e-16, -1.206066726842351e-17,
  4.279600301299575e-19, -1.333821323965381e-20,  3.721796375168922e-22, -9.432642727572714e-24,  2.195970228824908e-25, -4.736703775134140e-27,  1.112610921253187e-12,
 -2.163784482713046e-13,  2.199147058538493e-14, -1.539022959471788e-15,  8.309393628087410e-17, -3.682707201506016e-18,  1.392976918660958e-19, -4.618028391850048e-21,
  1.367981421802380e-22, -3.674061937196724e-24,  9.048975772900323e-26, -2.061651843123010e-27,  2.322580894425699e-13, -4.863072446118579e-14,  5.313012134045521e-15,
 -3.986367295960898e-16,  2.301576203198901e-17, -1.088195386984287e-18,  4.381389749250470e-20, -1.543030759226750e-21,  4.846608291378146e-23, -1.377822132472190e-24,
  3.586215870229757e-26, -8.621243576397652e-28,  4.768936401167281e-14, -1.071925748977895e-14,  1.255948682020701e-15, -1.008278485111023e-16,  6.214073587855064e-18,
 -3.129245893859897e-19,  1.339150823844382e-20, -5.003176846207374e-22,  1.664145331238847e-23, -5.001611062691545e-25,  1.374184269476199e-26, -3.481919142046030e-28,
  9.693699631995656e-15, -2.332192827120662e-15,  2.923608692924442e-16, -2.506117797243752e-17,  1.645656286818166e-18, -8.811481861493721e-20,  4.001701964582614e-21,
 -1.583733150465420e-22,  5.570765463887619e-24, -1.767805228523229e-25,  5.120658855135710e-27, -1.365921728075658e-28,  1.964581356981370e-15, -5.044148817490229e-16,
  6.748898683031401e-17, -6.163895072698958e-18,  4.304163915737405e-19, -2.446060417190014e-20,  1.176916656304184e-21, -4.926355654415196e-23,  1.829809122223497e-24,
 -6.122347038570241e-26,  1.867174543300811e-27, -5.236633952704890e-29,  4.001021141151562e-16, -1.092986807583021e-16,  1.556874648335601e-17, -1.511599373437675e-18,
  1.120134663669569e-19, -6.743517385215108e-21,  3.431391372601890e-22, -1.516561342963268e-23,  5.938703719574949e-25, -2.091862560087657e-26,  6.707184404429283e-28,
 -1.974976784699598e-29,  8.258802296288473e-17, -2.392944065986866e-17,  3.619243562294798e-18, -3.726706026762286e-19,  2.924163561146740e-20, -1.861065589842201e-21,
  9.995591568223786e-23, -4.655963178934227e-24,  1.918810445511505e-25, -7.103537365976745e-27,  2.390683782670350e-28, -7.379415680243383e-30,  1.743988529064835e-17,
 -5.342305246464432e-18,  8.555613103930619e-19, -9.319177051051347e-20,  7.724451788129799e-21, -5.185645172250816e-22,  2.933558939249675e-23, -1.437251536089388e-24,
  6.221706599584651e-26, -2.416293403961980e-27,  8.520462994544929e-29, -2.752271895683177e-30,  3.805150700274454e-18, -1.228202434209279e-18,  2.076570619424931e-19,
 -2.386198884124210e-20,  2.083995837600214e-21, -1.472151192870780e-22,  8.751548143786576e-24, -4.499853105128864e-25,  2.041765821685845e-26, -8.301452075571708e-28,
  3.061077607884259e-29, -1.032755183877807e-30,  8.668886965038532e-19, -2.938033762881893e-19,  5.227821374855462e-20, -6.318830373880867e-21,  5.798530850622546e-22,
 -4.298747361975986e-23,  2.678625527389965e-24, -1.441920909523293e-25,  6.841620914851222e-27, -2.905554286139252e-28,  1.117895764050217e-29, -3.930901436565373e-31,
  2.084693669893150e-19, -7.391756465148602e-20,  1.379550861520024e-20, -1.748354835231248e-21,  1.680685342322444e-22, -1.303822520693281e-23,  8.492089514920318e-25,
 -4.773005443817819e-26,  2.362059244096797e-27, -1.045176878673857e-28,  4.185565614934525e-30, -1.530320572385148e-31,  5.350251949951085e-20, -1.977150517286821e-20,
  3.856493412590734e-21, -5.107027226525657e-22,  5.125885383130104e-23, -4.147925228372224e-24,  2.815289645736360e-25, -1.647260856708047e-26,  8.478066476669282e-28,
 -3.897770868105575e-29,  1.620311829882118e-30, -6.143588320056493e-32,  1.481094582425945e-20, -5.681818086486229e-21,  1.153802104071649e-21, -1.590665773259600e-22,
  1.660993516746808e-23, -1.397192045297767e-24,  9.848915445663562e-26, -5.979682574997689e-27,  3.190641595756660e-28, -1.519450332372004e-29,  6.537195368751165e-31,
 -2.563005057942263e-32,  4.465502503123781e-21, -1.771026245992556e-21,  3.728865734366952e-22, -5.330409165647646e-23,  5.768372566895284e-24, -5.024965255169712e-25,
  3.665376266995239e-26, -2.301001035810738e-27,  1.268477702053199e-28, -6.236217532235356e-30,  2.767756729725309e-31, -1.118502153458845e-32,  1.477672331305173e-21,
 -6.032948161445604e-22,  1.311275260148042e-22, -1.935319948742214e-23,  2.161396488986208e-24, -1.941954661199438e-25,  1.460018706715576e-26, -9.440425339646418e-28,
  5.356658103259397e-29, -2.708784365635615e-30,  1.235762598292224e-31, -5.129646961696027e-33,  5.388066246176421e-22, -2.254595911667380e-22,  5.035495257427410e-23,
 -7.638235540548333e-24,  8.764385996293242e-25, -8.086398690861393e-26,  6.239640219434881e-27, -4.138331071029356e-28,  2.407169827782135e-29, -1.247141571860204e-30,
  5.825843760848324e-32, -2.474723553403793e-33,  2.158091721949791e-22, -9.213516903574333e-23,  2.104285054578314e-23, -3.264751636651725e-24,  3.830575445556082e-25,
 -3.612515673913497e-26,  2.847928815912554e-27, -1.928876271464983e-28,  1.145218623734786e-29, -6.053333614276519e-31,  2.883585266714101e-32, -1.248461241269811e-33,
  9.321747106430592e-23, -4.041701769692145e-23,  9.391985787199620e-24, -1.482857813363491e-24,  1.770237990915408e-25, -1.698106787623084e-26,  1.361198855081404e-27,
 -9.370791260534132e-29,  5.653016095264440e-30, -3.034923455913628e-31,  1.467881069347247e-32, -6.450099063267367e-34,  4.090018437914404e-23, -1.792507734048172e-23,
  4.216040531387269e-24, -6.738485171035153e-25,  8.142514928163506e-26, -7.904358361240475e-27,  6.410529686515068e-28, -4.463851859903357e-29,  2.723101425373409e-30,
 -1.477987526788287e-31,  7.225103670850599e-33, -3.207963074780976e-34,  1.426060875164830e-23, -6.287484085424998e-24,  1.488869505914532e-24, -2.396012202796835e-25,
  2.914961117951908e-26, -2.848649104491415e-27,  2.325447994132911e-28, -1.629678200265782e-29,  1.000399092281255e-30, -5.463058058184094e-32,  2.686603798917516e-33,
 -1.199819426798769e-34,  5.149903971999839e-02, -1.089548196554796e-04,  2.374685108682023e-07, -5.310674346738812e-10,  1.212326467023543e-12, -2.811201998041617e-15,
  6.588991819179390e-18, -1.555942318328929e-20,  3.688162460143424e-23, -8.766967618160728e-26,  2.083044916511207e-28, -4.954830678997714e-31,  4.820133596287209e-02,
 -1.210841151795744e-04,  3.585423415528288e-07, -1.122466177360315e-09,  3.526957366996171e-12, -1.093949625101035e-14,  3.338300402177187e-17, -1.003192309524294e-19,
  2.973597190373630e-22, -8.709476458521382e-25,  2.523848893602762e-27, -7.245265309540561e-30,  4.222730816262948e-02, -1.395991756485597e-04,  5.728829131132388e-07,
 -2.321628740702403e-09,  9.014174345307534e-12, -3.372562761695604e-14,  1.224896958751072e-16, -4.341639377892337e-19,  1.507389349766377e-21, -5.140365813578118e-24,
  1.725283499811232e-26, -5.708841539565307e-29,  3.462830635932761e-02, -1.558060838134619e-04,  8.293240210614234e-07, -4.081126642416680e-09,  1.879739470861473e-11,
 -8.246528394103323e-14,  3.481802943120485e-16, -1.424197241992254e-18,  5.670326579263907e-21, -2.205249294976126e-23,  8.400908573005840e-26, -3.141783194544458e-28,
  2.658380167353674e-02, -1.620486450556532e-04,  1.064219868218562e-06, -6.196721921478061e-09,  3.330248884042801e-11, -1.687659947310730e-13,  8.162350090709598e-16,
 -3.798028876938158e-18,  1.710198571630030e-20, -7.485038107151190e-23,  3.195161474895993e-25, -1.333908709700467e-27,  1.910783752371495e-02, -1.547617165669700e-04,
  1.218597960333013e-06, -8.287231344577087e-09,  5.138201937662099e-11, -2.974236678459439e-13,  1.630064373984862e-15, -8.539991294635356e-18,  4.306636672150606e-20,
 -2.101378223331797e-22,  9.961077568328807e-25, -4.601811439237521e-27,  1.286152923976528e-02, -1.352475290409790e-04,  1.256205688439589e-06, -9.887280645457975e-09,
  7.008271228014742e-11, -4.593347362873837e-13,  2.829336542500987e-15, -1.656038635578891e-17,  9.283820954550714e-20, -5.014496955421625e-22,  2.621582281013396e-24,
 -1.331392127887925e-26,  8.108811477297731e-03, -1.082616780813531e-04,  1.174069156848467e-06, -1.061438416167533e-08,  8.536999208968735e-11, -6.291432068207248e-13,
  4.327173687369532e-15, -2.812238826617970e-17,  1.742363721885599e-19, -1.035940704366163e-21,  5.940967144384281e-24, -3.299523394408680e-26,  4.789862210684250e-03,
 -7.957550489160331e-05,  1.000143768676972e-06, -1.031768774610627e-08,  9.357523474274599e-11, -7.709939493095801e-13,  5.889696878511378e-15, -4.228820011990762e-17,
  2.881757341788102e-19, -1.877405940046409e-21,  1.175847992863317e-23, -7.111263395116353e-26,  2.651739320408541e-03, -5.385925861009447e-05,  7.797429858302039e-07,
 -9.125590334434427e-09,  9.283620288303654e-11, -8.510766183897768e-13,  7.188820716664903e-15, -5.678499722006297e-17,  4.239210840115931e-19, -3.014583470850130e-21,
  2.054432642434114e-23, -1.348171324752104e-25,  1.376407954914862e-03, -3.365813268006287e-05,  5.582288805296175e-07, -7.373410304489675e-09,  8.375848108565222e-11,
 -8.508479981352947e-13,  7.916405241639767e-15, -6.854773587610811e-17,  5.586976967825183e-19, -4.322606571299070e-21,  3.195380918603715e-23, -2.268411684276754e-25,
  6.701431099681231e-04, -1.946904929176699e-05,  3.680290146741082e-07, -5.461117644695766e-09,  6.899446344058988e-11, -7.738329150508349e-13,  7.904371788580536e-15,
 -7.479443280933500e-17,  6.635977948556674e-19, -5.570301574787835e-21,  4.454468070763028e-23, -3.412016113793314e-25,  3.062105360050320e-04, -1.044729763195191e-05,
  2.240046694172858e-07, -3.718726217719704e-09,  5.206631248615394e-11, -6.427124304030784e-13,  7.186376602483507e-15, -7.410741232886629e-17,  7.138847157310184e-19,
 -6.485437098093682e-21,  5.597237385579167e-23, -4.615510125009155e-25,  1.313923189584788e-04, -5.211549085685239e-06,  1.261653164684994e-07, -2.334378150961654e-09,
  3.610543136813854e-11, -4.891259434854998e-13,  5.971103759310782e-15, -6.694258260844778e-17,  6.985660296523016e-19, -6.853513632342813e-21,  6.370349927041195e-23,
 -5.643810651486539e-25,  5.298147502452133e-05, -2.421441011895253e-06,  6.589799567642277e-08, -1.354216220736988e-09,  2.307066689597638e-11, -3.421178526085228e-13,
  4.549158675649572e-15, -5.532619079453948e-17,  6.241483622591944e-19, -6.600062635641784e-21,  6.594947734361161e-23, -6.266324608196043e-25,  2.009263006049387e-05,
 -1.049854249645617e-06,  3.198588032488382e-08, -7.277153739442981e-10,  1.361879989544240e-11, -2.205456113552368e-13,  3.187495644411849e-15, -4.197079595223930e-17,
  5.109253122884888e-19, -5.813220870218704e-21,  6.234101454110734e-23, -6.342748361589212e-25,  7.173261076686199e-06, -4.255200018851808e-07,  1.445725874043379e-08,
 -3.630573667884160e-10,  7.445228371692228e-12, -1.313831129791948e-13,  2.059866264990606e-15, -2.931271358293941e-17,  3.844090115001746e-19, -4.698594431926430e-21,
  5.399683936978967e-23, -5.874232054542408e-25,  2.413422553555672e-06, -1.615242386852467e-07,  6.097383041476000e-09, -1.685389688565820e-10,  3.778522542363216e-12,
 -7.251234327919190e-14,  1.231055546720875e-15, -1.890160503834939e-17,  2.666238327561054e-19, -3.495938145591841e-21,  4.299471692446350e-23, -4.994713944683257e-25,
  7.661723465376150e-07, -5.752997483740826e-08,  2.404563574272851e-09, -7.296502873211945e-11,  1.784478893627146e-12, -3.717184551368338e-14,  6.822115269805226e-16,
 -1.128448558055955e-17,  1.709745963807389e-19, -2.401663042077279e-21,  3.156972122974060e-23, -3.911651527547763e-25,  2.298342144716688e-07, -1.926370313019364e-08,
  8.885925055206989e-10, -2.952710807336346e-11,  7.861446466135034e-13, -1.774399408573110e-14,  3.514914460385888e-16, -6.254623085312474e-18,  1.016553428948636e-19,
 -1.527894912689940e-21,  2.144156643806146e-23, -2.830483332737344e-25,  6.525393330428532e-08, -6.076872715569280e-09,  3.084110007802022e-10, -1.119599399862923e-11,
  3.238808761914727e-13, -7.907791963872887e-15,  1.688242672501734e-16, -3.227481225573659e-18,  5.620012239039510e-20, -9.027861644873868e-22,  1.351085827198279e-23,
 -1.898258210375425e-25,  1.756763580020523e-08, -1.810061415422150e-09,  1.007790795847338e-10, -3.987882261919145e-12,  1.251128235191671e-13, -3.299150199466939e-15,
  7.580320471518389e-17, -1.554918869871561e-18,  2.897475936661338e-20, -4.969141671140192e-22,  7.922684350437644e-24, -1.183567601068830e-25,  4.494289825052991e-09,
 -5.103254911687512e-10,  3.108558104482693e-11, -1.337944595070566e-12,  4.544263544650183e-14, -1.292205813987567e-15,  3.191082878013041e-17, -7.014912261546495e-19,
  1.397300262310072e-20, -2.555740041490466e-22,  4.336904080982480e-24, -6.882555560445631e-26,  1.095235281329438e-09, -1.365583476911041e-10,  9.076756395568470e-12,
 -4.240550191584765e-13,  1.556574107852648e-14, -4.766128978960418e-16,  1.263361759489829e-17, -2.972805405672191e-19,  6.322998676901039e-21, -1.232205370123826e-22,
  2.223377976184156e-24, -3.744970393903115e-26,  2.549515783054886e-10, -3.478645939802518e-11,  2.516748479359086e-12, -1.273736738928951e-13,  5.044605144379981e-15,
 -1.660838250457470e-16,  4.719469686307613e-18, -1.187378872245483e-19,  2.693890517893126e-21, -5.587933671091916e-23,  1.071157956933875e-24, -1.913284132221578e-26,
  5.687007756566453e-11, -8.463995994570157e-12,  6.649369170591979e-13, -3.638553429833024e-14,  1.552276882698548e-15, -5.487322287443781e-17,  1.669500535948190e-18,
 -4.485895814695847e-20,  1.084486574668895e-21, -2.392158140964882e-23,  4.867139285798407e-25, -9.211290152516181e-27,  1.219957548626631e-11, -1.974406048895211e-12,
  1.680381923156398e-13, -9.922980674898296e-15,  4.552789375311667e-16, -1.725644741223509e-17,  5.614304116904854e-19, -1.609291137930187e-20,  4.141368729132379e-22,
 -9.704790801682784e-24,  2.093919544073574e-25, -4.195230318690228e-27,  2.527019155819482e-12, -4.434140649525232e-13,  4.079080515175064e-14, -2.594594930190027e-15,
  1.278216294233665e-16, -5.187405720929267e-18,  1.802465638877453e-19, -5.505356688890372e-21,  1.506510940577077e-22, -3.746849361648927e-24,  8.565071784830443e-26,
 -1.815084755696801e-27,  5.077807184103036e-13, -9.632271448857001e-14,  9.556339641052297e-15, -6.535237524020397e-16,  3.451398150967006e-17, -1.497592173922879e-18,
  5.550411077466715e-20, -1.804324175648869e-21,  5.244558578750791e-23, -1.382980403668339e-24,  3.346255274503243e-26, -7.493801873435997e-28,  9.949612053033147e-14,
 -2.034567028753095e-14,  2.172089129406756e-15, -1.594016839763516e-16,  9.009741680600575e-18, -4.173761873212101e-19,  1.647775572108677e-20, -5.694161731688341e-22,
  1.756067801362618e-23, -4.904585373197403e-25,  1.254845359839731e-26, -2.966860085912850e-28,  1.912226386781390e-14, -4.203259852416548e-15,  4.817933546267209e-16,
 -3.786944057633541e-17,  2.286965942627141e-18, -1.129357448198628e-19,  4.742834728097719e-21, -1.740025834692304e-22,  5.686769310092961e-24, -1.680323735934156e-25,
  4.541131095952612e-27, -1.132382010834678e-28,  3.628470370967444e-15, -8.548942030777332e-16,  1.049698023907431e-16, -8.819564218390816e-18,  5.680732909202498e-19,
 -2.985646662825742e-20,  1.331812510202490e-21, -5.180289360033527e-23,  1.791871677405613e-24, -5.594691912123766e-26,  1.595262371678993e-27, -4.190879461788047e-29,
  6.847563743457747e-16, -1.724281425595598e-16,  2.262647454981350e-17, -2.027962491254806e-18,  1.390586194019744e-19, -7.765272016522913e-21,  3.673468308412813e-22,
 -1.512661749847578e-23,  5.530139554910342e-25, -1.822119491933381e-26,  5.474868754403423e-28, -1.513448962819206e-29,  1.295690036118319e-16, -3.476695560849974e-17,
  4.863737418369908e-18, -4.640142614746355e-19,  3.380590744130669e-20, -2.002092904628138e-21,  1.002720768753528e-22, -4.364206502669424e-24,  1.683771081600735e-25,
 -5.846135139983333e-27,  1.848447691539693e-28, -5.369629681323028e-30,  2.480281156489261e-17, -7.070135986507200e-18,  1.051744172492273e-18, -1.065583503751695e-19,
  8.230967816099667e-21, -5.159619901573352e-22,  2.730762298789047e-23, -1.254026500987012e-24,  5.097330515681485e-26, -1.862003001931756e-27,  6.185781646276350e-29,
 -1.885522714168805e-30,  4.850372647677865e-18, -1.464126024230230e-18,  2.309709309451673e-19, -2.478997863296521e-20,  2.025556621091666e-21, -1.341067195360180e-22,
  7.485181380543961e-24, -3.619771980332290e-25,  1.547289285888890e-26, -5.935937751285998e-28,  2.068409443750073e-29, -6.604720680135368e-31,  9.792727177552068e-19,
 -3.119873130813299e-19,  5.204160405721019e-20, -5.901337278071837e-21,  5.087881222283021e-22, -3.549406027232010e-23,  2.084570677491101e-24, -1.059298824081668e-25,
  4.751905714426624e-27, -1.910751056722106e-28,  6.970312201553519e-30, -2.327255722989521e-31,  2.064267996942431e-19, -6.916927831953499e-20,  1.216210120381557e-20,
 -1.452880554250883e-21,  1.318092517747986e-22, -9.663767953300721e-24,  5.957111545853843e-25, -3.173389023039451e-26,  1.490503591483920e-27, -6.267923825518566e-29,
  2.388580120182117e-30, -8.321463108814913e-32,  4.596925652150923e-20, -1.614124686617785e-20,  2.981657541478619e-21, -3.740501131168010e-22,  3.560175376501526e-23,
 -2.735310718202574e-24,  1.764926010994782e-25, -9.829832895318362e-27,  4.821721932372649e-28, -2.115285790279173e-29,  8.400549305332001e-31, -3.046627474440504e-32,
  1.094505661012377e-20, -4.011799972728224e-21,  7.757394902259472e-22, -1.018462731090025e-22,  1.013635755412188e-23, -8.135356315398410e-25,  5.477735187694895e-26,
 -3.180324176116325e-27,  1.624550375102716e-28, -7.414351828245391e-30,  3.060312943129299e-31, -1.152371701918109e-32,  2.819328588792710e-21, -1.074402194342609e-21,
  2.166253393185230e-22, -2.965310644192463e-23,  3.074931580167445e-24, -2.569072874965977e-25,  1.799043446946013e-26, -1.085286334813992e-27,  5.754871496862273e-29,
 -2.724028947431437e-30,  1.165085995392350e-31, -4.541863782631613e-33,  7.943437073856263e-22, -3.133990867007346e-22,  6.561300809052166e-23, -9.326501667847363e-24,
  1.003697460788083e-24, -8.696258727577755e-26,  6.310009487431569e-27, -3.940968188361634e-28,  2.161749105140622e-29, -1.057645608999446e-30,  4.671987045982042e-32,
 -1.879431922629539e-33,  2.470237152307041e-22, -1.004586444476613e-22,  2.174136042957896e-23, -3.195059392990929e-24,  3.553254898958136e-25, -3.179359206636670e-26,
  2.380749230214617e-27, -1.533374716882046e-28,  8.667592205659869e-30, -4.366888330216177e-31,  1.985042828544204e-32, -8.211190269188498e-34,  8.524468946066245e-23,
 -3.557096163403382e-23,  7.920197948019374e-24, -1.197702652928276e-24,  1.370127342615865e-25, -1.260397476565941e-26,  9.697438803090515e-28, -6.413583115881181e-29,
  3.720428005568907e-30, -1.922404113311227e-31,  8.956984213468597e-33, -3.795220769939656e-34,  3.258507815319663e-23, -1.388620743680779e-23,  3.165072747477983e-24,
 -4.900549482716928e-25,  5.738349304890875e-26, -5.401067526682588e-27,  4.249780363821104e-28, -2.872965321886608e-29,  1.702645401580701e-30, -8.983819606909876e-32,
  4.272186095822267e-33, -1.846567617153071e-34,  1.356256222066340e-23, -5.874173942002287e-24,  1.363399586639925e-24, -2.150026899521348e-25,  2.563665349418137e-26,
 -2.456349666124289e-27,  1.966771000755624e-28, -1.352469405731445e-29,  8.150088901833794e-31, -4.370917729699652e-32,  2.111884285679035e-33, -9.270700446806613e-35,
  5.795665242397409e-24, -2.538692001764219e-24,  5.967547178835801e-25, -9.532180847787006e-26,  1.151144993991363e-26, -1.116822073355805e-27,  9.052370495313283e-29,
 -6.299913806911948e-30,  3.841055044704403e-31, -2.083650011153647e-32,  1.018053736552144e-33, -4.517877595082917e-35,  1.990794067215855e-24, -8.775410200380639e-25,
  2.077476670255668e-25, -3.342376566686569e-26,  4.065241168287526e-27, -3.971740958495552e-28,  3.241444245425289e-29, -2.271043462426568e-30,  1.393767396668111e-31,
 -7.609358100290568e-33,  3.741216059624403e-34, -1.670413766918566e-35,  5.106698003639448e-02, -1.070802372705301e-04,  2.312102570324966e-07, -5.121115572389878e-10,
  1.157649173402272e-12, -2.658163656404590e-15,  6.169387692464693e-18, -1.442814248986235e-20,  3.387038873528115e-23, -7.975743345765187e-26,  1.876938893736384e-28,
 -4.424381132157168e-31,  4.772265220496861e-02, -1.182687118411389e-04,  3.454042537102888e-07, -1.067742583509643e-09,  3.315957275532484e-12, -1.017096445306801e-14,
  3.070270452543306e-17, -9.128650823012379e-20,  2.677485207963636e-22, -7.760887144011075e-25,  2.225801214493244e-27, -6.324537292234499e-30,  4.167790453800022e-02,
 -1.351251489131364e-04,  5.458669763821180e-07, -2.182642362352730e-09,  8.368102097625139e-12, -3.092646962518027e-14,  1.109815182803413e-16, -3.887598974736287e-19,
  1.334176043407244e-21, -4.497963654839475e-24,  1.492728045206132e-26, -4.884550512874134e-29,  3.401804809936051e-02, -1.493623952957409e-04,  7.821020586923595e-07,
 -3.793121944046507e-09,  1.722852515764582e-11, -7.456769426882179e-14,  3.107282016694201e-16, -1.254826570656820e-18,  4.933734923654198e-21, -1.895302891777668e-23,
  7.133225725319165e-26, -2.636026361420145e-28,  2.595217611878549e-02, -1.538235202694395e-04,  9.929482101257603e-07, -5.689855364426894e-09,  3.011476076708088e-11,
 -1.503930558294792e-13,  7.171637430832218e-16, -3.291522837297341e-18,  1.462395200779687e-20, -6.317036375850919e-23,  2.662063140335493e-25, -1.097362247010444e-27,
  1.850767754680571e-02, -1.453971827462030e-04,  1.123894228241604e-06, -7.510659803349474e-09,  4.580616890186088e-11, -2.610225565462211e-13,  1.409153699403671e-15,
 -7.275596156087973e-18,  3.617235633295621e-20, -1.740659004503909e-22,  8.139741065351120e-25, -3.710536318408946e-27,  1.233991300181072e-02, -1.256540854842653e-04,
  1.143994634582755e-06, -8.835913173857535e-09,  6.153916609288306e-11, -3.966752301402885e-13,  2.404661315506289e-15, -1.385925254700288e-17,  7.654043538075127e-20,
 -4.074281269104471e-22,  2.099851862043224e-24, -1.051616775044368e-26,  7.693774744171583e-03, -9.935631555096135e-05,  1.054494404449726e-06, -9.343741382609419e-09,
  7.376498371488844e-11, -5.341430094711887e-13,  3.612509453250720e-15, -2.310035794747620e-17,  1.408918015887532e-19, -8.249868123669000e-22,  4.661159619411101e-24,
 -2.551249849464200e-26,  4.486812795471549e-03, -7.204527522869329e-05,  8.848297037787167e-07, -8.936547462557837e-09,  7.947810514019969e-11, -6.428673658982914e-13,
  4.825182878720851e-15, -3.406297215647861e-17,  2.283516682410875e-19, -1.464172885207099e-21,  9.029192197946671e-24, -5.378522981356795e-26,  2.448118645995329e-03,
 -4.803532692126699e-05,  6.786154189079554e-07, -7.767523370330007e-09,  7.741871558716248e-11, -6.961866628324368e-13,  5.773509458916055e-15, -4.480823848547594e-17,
  3.288615802595161e-19, -2.300282887630221e-21,  1.542636363828860e-23, -9.965601960555555e-26,  1.250177245959360e-03, -2.952467234312152e-05,  4.772589508588059e-07,
 -6.159705280712032e-09,  6.849585352692758e-11, -6.820014886551851e-13,  6.225623051043940e-15, -5.293083195406982e-17,  4.238716534074024e-19, -3.223916693682869e-21,
  2.343948437334329e-23, -1.637257477639098e-25,  5.977653554522409e-04, -1.676929695509470e-05,  3.086398831969310e-07, -4.471383324977976e-09,  5.525687817232597e-11,
 -6.070330375046417e-13,  6.079564556519568e-15, -5.645128050613773e-17,  4.918214452681492e-19, -4.056331114015723e-21,  3.188769771635572e-23, -2.402181791091511e-25,
  2.677415750997129e-04, -8.820516461124433e-06,  1.839826642345557e-07, -2.979789850352389e-09,  4.078119752355364e-11, -4.927592876078108e-13,  5.398955183613239e-15,
 -5.460344077208857e-17,  5.162490919571128e-19, -4.605868186649666e-21,  3.905890986859211e-23, -3.166260902755152e-25,  1.124002992912098e-04, -4.305151901133441e-06,
  1.013196609379256e-07, -1.827759684233173e-09,  2.761629937733986e-11, -3.659976709331425e-13,  4.375821408036871e-15, -4.808910595674664e-17,  4.922876309082242e-19,
 -4.741029650069107e-21,  4.328278227661931e-23, -3.768199854915518e-25,  4.425537755258638e-05, -1.953468141620871e-06,  5.165425572042737e-08, -1.034381047585454e-09,
  1.720542280634615e-11, -2.494733176772830e-13,  3.247263869963495e-15, -3.869542193890063e-17,  4.280540660487662e-19, -4.441528981214213e-21,  4.357367934313129e-23,
 -4.067063821413726e-25,  1.635450017384058e-05, -8.255033131162548e-07,  2.442758769345495e-08, -5.413140199424408e-10,  9.886483033271106e-12, -1.564778233337565e-13,
  2.212885636942631e-15, -2.853811881727960e-17,  3.405286266101295e-19, -3.800424778598296e-21,  4.000110591537504e-23, -3.996629161788447e-25,  5.677520931924586e-06,
 -3.254471249949021e-07,  1.073659391171586e-08, -2.625248588356534e-10,  5.252023886392272e-12, -9.054792503478679e-14,  1.388599325125513e-15, -1.934699852175489e-17,
  2.486151952869226e-19, -2.979801658747863e-21,  3.360039050485146e-23, -3.588613133561457e-25,  1.853392530490663e-06, -1.199079037438410e-07,  4.394542468156085e-09,
 -1.182432651313814e-10,  2.585389384807844e-12, -4.845924405524141e-14,  8.044766496916067e-16, -1.209011783656377e-17,  1.670664590734045e-19, -2.147470931551819e-21,
  2.590773359675633e-23, -2.954099543165286e-25,  5.695975498489970e-07, -4.136162235731335e-08,  1.678372618795171e-09, -4.956850698561531e-11,  1.182064943543818e-12,
 -2.404405448360788e-14,  4.314048903291273e-16, -6.983077900728281e-18,  1.036243143161642e-19, -1.426679076054556e-21,  1.839295253962710e-23, -2.236464611595207e-25,
  1.650225625885538e-07, -1.338269682015239e-08,  5.993626716117587e-10, -1.938301587685210e-11,  5.031410491754892e-13, -1.108762519136567e-14,  2.146870975737326e-16,
 -3.737853712226346e-18,  5.949063841245498e-20, -8.762560617561801e-22,  1.205865764056328e-23, -1.561948647168674e-25,  4.514027787826408e-08, -4.069625314362191e-09,
  2.005696850018239e-10, -7.086420254029947e-12,  1.998581514463233e-13, -4.763893232353165e-15,  9.940509443294042e-17, -1.859205237316916e-18,  3.169986943017686e-20,
 -4.989816916480153e-22,  7.322340805524090e-24, -1.009372048980955e-25,  1.167893587196880e-08, -1.165655453711289e-09,  6.304174608390417e-11, -2.428203639964132e-12,
  7.427459151116704e-14, -1.912124398753893e-15,  4.294019550236796e-17, -8.617159527657685e-19,  1.572246059929012e-20, -2.642096238061701e-22,  4.130423218760275e-24,
 -6.053877424668127e-26,  2.863837875301987e-09, -3.152253994160316e-10,  1.865839959110598e-11, -7.818709929471035e-13,  2.589511732456238e-14, -7.189570915228614e-16,
  1.735404667185853e-17, -3.732385432842571e-19,  7.279735764369546e-21, -1.304740901441417e-22,  2.170984342946992e-24, -3.380335239640571e-26,  6.671434122633547e-10,
 -8.069502100922320e-11,  5.214361073095746e-12, -2.372527932155704e-13,  8.494092310425335e-15, -2.539849639042078e-16,  6.581503048068970e-18, -1.515374006081063e-19,
  3.156359716001032e-21, -6.027994802944675e-23,  1.066632416566846e-24, -1.762888072126777e-26,  1.480418967186498e-10, -1.961171426017827e-11,  1.380152826556665e-12,
 -6.805554088304596e-14,  2.629718129379117e-15, -8.457077578946991e-17,  2.349854608051545e-18, -5.786043053945721e-20,  1.285769813805030e-21, -2.614186102672908e-23,
  4.914988420285489e-25, -8.615755775078548e-27,  3.138942760769112e-11, -4.539915711759876e-12,  3.471478524182556e-13, -1.851730797807929e-14,  7.710753361253275e-16,
 -2.663506133829051e-17,  7.926316187574972e-19, -2.084983360648596e-20,  4.938366512245090e-22, -1.067969966465229e-23,  2.131717977671423e-25, -3.960237985428248e-27,
  6.381840429565360e-12, -1.004705069053413e-12,  8.328967900856780e-14, -4.797336766529173e-15,  2.149489438408002e-16, -7.964694570810431e-18,  2.535597596510938e-19,
 -7.117843111978449e-21,  1.795202807814948e-22, -4.125796034777556e-24,  8.735827859673397e-26, -1.718604805130818e-27,  1.249162453225816e-12, -2.134438162750375e-13,
  1.914153689785843e-14, -1.188393870617034e-15,  5.720810708515707e-17, -2.270902213415720e-18,  7.724962074275287e-20, -2.311761819553402e-21,  6.202582052956688e-23,
 -1.513546235739381e-24,  3.396664809271885e-26, -7.070642033842274e-28,  2.364784252564186e-13, -4.373266672158382e-14,  4.233590574962312e-15, -2.828123842739471e-16,
  1.460492574139773e-17, -6.202536834944299e-19,  2.251837344192614e-20, -7.176171327963258e-22,  2.046230239442473e-23, -5.296692430038843e-25,  1.258766462089546e-26,
 -2.770300604476380e-28,  4.352347147493820e-14, -8.687307708696604e-15,  9.058806107695819e-16, -6.499677011013303e-17,  3.595224168081125e-18, -1.631291303302976e-19,
  6.312977709650017e-21, -2.139984849871190e-22,  6.478184153458382e-24, -1.777089341399800e-25,  4.468238189045618e-27, -1.038760816433446e-28,  7.833835865538356e-15,
 -1.683009651038979e-15,  1.886348057273791e-16, -1.451054317641100e-17,  8.583407137239080e-19, -4.155115047085603e-20,  1.711828273312714e-21, -6.165125945418276e-23,
  1.979186313071232e-24, -5.747772170212585e-26,  1.527527944228597e-27, -3.747664586444910e-29,  1.388139012744021e-15, -3.201038940731704e-16,  3.847903815025815e-17,
 -3.167459779590436e-18,  2.000354418763740e-19, -1.031565475875296e-20,  4.518065417224133e-22, -1.726586143033894e-23,  5.871108065788570e-25, -1.803037586721681e-26,
  5.059375599744052e-28, -1.308639286845845e-29,  2.439746500454236e-16, -6.021752133033825e-17,  7.745911554307067e-18, -6.809756102595610e-19,  4.583358619706034e-20,
 -2.513882679731744e-21,  1.168794416979815e-22, -4.732934776764692e-24,  1.702504530087672e-25, -5.522221755845724e-27,  1.634191563356096e-28, -4.451349218156066e-30,
  4.288812109889793e-17, -1.129732748428425e-17,  1.551376213583920e-18, -1.453604211645933e-19,  1.040730999388412e-20, -6.060667304863016e-22,  2.986436373613223e-23,
 -1.279522670425473e-24,  4.861984196286049e-26, -1.663383524414085e-27,  5.184620330204570e-29, -1.485354993337557e-30,  7.610914609947342e-18, -2.133192733480660e-18,
  3.119479019646396e-19, -3.108255628267694e-20,  2.362473015661353e-21, -1.457978913380287e-22,  7.600764285553952e-24, -3.439782117300745e-25,  1.378533569822492e-26,
 -4.966994364292775e-28,  1.628263509314553e-29, -4.899537264882410e-31,  1.377456684808842e-18, -4.095074403709519e-19,  6.360227209350216e-20, -6.723141129953435e-21,
  5.412755410562679e-22, -3.532690447305282e-23,  1.944626912500773e-24, -9.278622191384552e-26,  3.914913930706464e-27, -1.483062279650827e-28,  5.104910321895649e-30,
 -1.610829408614113e-31,  2.570937560739895e-19, -8.080410585946898e-20,  1.329127636099988e-20, -1.486619078593675e-21,  1.264696095588444e-22, -8.709254922638235e-24,
  5.051168668066078e-25, -2.535778804559997e-26,  1.124187497671445e-27, -4.468955903154936e-29,  1.612244636826258e-30, -5.325326360211397e-32,  5.008094092477693e-20,
 -1.658295921396705e-20,  2.879933704979423e-21, -3.398691564164993e-22,  3.047010707633240e-23, -2.208366375890536e-24,  1.346192524271670e-25, -7.093943475162134e-27,
  3.297091767632895e-28, -1.372429434974836e-29,  5.178491271732567e-31, -1.786861752986278e-32,  1.031123614983992e-20, -3.583869513358570e-21,  6.549564978190133e-22,
 -8.129815129693030e-23,  7.658269421761385e-24, -5.825055393185164e-25,  3.722043947133865e-26, -2.053466944671752e-27,  9.980476725080230e-29, -4.339523985340021e-30,
  1.708505299926178e-31, -6.144377054609839e-33,  2.273385432342884e-21, -8.261901318044926e-22,  1.583100689216476e-22, -2.059799044718105e-23,  2.032063935546734e-24,
 -1.617002105778808e-25,  1.079740190682647e-26, -6.218395156644874e-28,  3.151595423359639e-29, -1.427443895719731e-30,  5.848370465327353e-32, -2.186464149271516e-33,
  5.437681902953878e-22, -2.057814888924537e-22,  4.118107269615622e-23, -5.595336881850810e-24,  5.760060702394941e-25, -4.778430755793880e-26,  3.323173158516807e-27,
 -1.991328841262746e-28,  1.049070469145942e-29, -4.934369931417325e-31,  2.097523225209005e-32, -8.128167404777415e-34,  1.428494458946006e-22, -5.605099151809208e-23,
  1.166518157076652e-23, -1.648326509642855e-24,  1.763600831861241e-25, -1.519377152153944e-26,  1.096390083817219e-27, -6.810931796645562e-29,  3.716574775748078e-30,
 -1.809153852270292e-31,  7.952368547108519e-33, -3.183799706122155e-34,  4.165174453645268e-23, -1.686888515474355e-23,  3.634314635396933e-24, -5.316808806905077e-25,
  5.886673812066660e-26, -5.244458243527631e-27,  3.910581870770127e-28, -2.508375690249858e-29,  1.412240256470757e-30, -7.087550957383168e-32,  3.209628662364252e-33,
 -1.322821428943180e-34,  1.357263500060042e-23, -5.646996853279726e-24,  1.253292303775261e-24, -1.889102770262738e-25,  2.154174882236247e-26, -1.975480063618386e-27,
  1.515310789141262e-28, -9.992175227631709e-30,  5.779652385970715e-31, -2.978085601873277e-32,  1.383793475813079e-33, -5.847885937774121e-35,  4.941300383009607e-24,
 -2.101700700854000e-24,  4.780168291890443e-25, -7.385355039918171e-26,  8.629679409081511e-27, -8.105659391598901e-28,  6.364999091271410e-29, -4.294454460897518e-30,
  2.540213163856162e-31, -1.337819486522184e-32,  6.350368002777670e-34, -2.739992738715896e-35,  1.978385604656757e-24, -8.559105962661878e-25,  1.984082027102668e-25,
 -3.124861141733938e-26,  3.721395099083084e-27, -3.561256535674549e-28,  2.848051477128933e-29, -1.956208900552617e-30,  1.177488482173228e-31, -6.307919252833916e-33,
  3.044494221292480e-34, -1.335065250859883e-35,  8.223359427869055e-25, -3.600104626434932e-25,  8.457264974276649e-26, -1.350056970685836e-26,  1.629365088026863e-27,
 -1.579813032188141e-28,  1.279743261896387e-29, -8.901019050379265e-31,  5.423829928388325e-32, -2.940603603046839e-33,  1.435966370214116e-34, -6.369071345994911e-36,
  2.780728696326126e-25, -1.225457217809511e-25,  2.900357979736551e-26, -4.665018281991495e-27,  5.672405019405576e-28, -5.540463272821066e-29,  4.520532762157215e-30,
 -3.166388599630492e-31,  1.942757663575703e-32, -1.060395282533632e-33,  5.212257364153928e-35, -2.326658122740564e-36,  5.064231997022187e-02, -1.052548256772573e-04,
  2.251743239676822e-07, -4.940065669539451e-10,  1.105934452190468e-12, -2.514826334509510e-15,  5.780152104035899e-18, -1.338881855328961e-20,  3.112969943825584e-23,
 -7.262479339043952e-26,  1.692798335243779e-28, -3.955082674884594e-31,  4.725502393049454e-02, -1.155558427190837e-04,  3.329030891249865e-07, -1.016275437040511e-09,
  3.119704494086090e-12, -9.463828847252765e-15,  2.826255286808304e-17, -8.314892910098837e-20,  2.413470638073862e-22, -6.923795363459434e-25,  1.965454077662224e-27,
 -5.528411196043672e-30,  4.114597508568720e-02, -1.308607498977286e-04,  5.204586532436564e-07, -2.053559860105477e-09,  7.775350874905270e-12, -2.838885773332616e-14,
  1.006704069279975e-16, -3.485459267006787e-19,  1.182498664723643e-21, -3.941717492956285e-24,  1.293585244679305e-26, -4.186404493693066e-29,  3.343283034341418e-02,
 -1.432830732891113e-04,  7.381905997315167e-07, -3.529002815897151e-09,  1.580898969024829e-11, -6.751461008344784e-14,  2.777045957438983e-16, -1.107335214690958e-18,
  4.300108570714238e-21, -1.631878530645145e-23,  6.068550715856219e-26, -2.216217457344305e-28,  2.535234805021088e-02, -1.461450791044288e-04,  9.274646492829087e-07,
 -5.231177309694217e-09,  2.727181841082874e-11, -1.342362275534334e-13,  6.312248789818459e-16, -2.857978213681883e-18,  1.253039821908123e-20, -5.342827143357339e-23,
  2.222987758679243e-25, -9.049411864035634e-28,  1.794351739443765e-02, -1.367544664633927e-04,  1.037997196448475e-06, -6.817754155997023e-09,  4.090806581872314e-11,
 -2.295222419501648e-13,  1.220743195932897e-15, -6.212364729660683e-18,  3.045473022961744e-20, -1.445514471672119e-22,  6.669173726661103e-25, -3.000252873251206e-27,
  1.185495190561563e-02, -1.169100967962365e-04,  1.043619439191224e-06, -7.911746003554739e-09,  5.415272233858927e-11, -3.433562919581941e-13,  2.048797897497634e-15,
 -1.162928982547087e-17,  6.327968360715298e-20, -3.320063849612439e-22,  1.687120069989743e-24, -8.332965652664581e-27,  7.312538560689393e-03, -9.134957817412486e-05,
  9.491130915847039e-07, -8.244464901140947e-09,  6.389925523277912e-11, -4.547212462775964e-13,  3.024598503698598e-15, -1.903311465988651e-17,  1.142943143931713e-19,
 -6.591977403211152e-22,  3.669860677117458e-24, -1.979855866207334e-26,  4.212139073096964e-03, -6.537491166322655e-05,  7.848162698346087e-07, -7.761774544380833e-09,
  6.770561637196542e-11, -5.377287378948132e-13,  3.966268493580078e-15, -2.753375609475242e-17,  1.816098038270900e-19, -1.146253534474583e-21,  6.960878482883372e-24,
 -4.084677029326064e-26,  2.266273245997590e-03, -4.295919812590035e-05,  5.924011231600192e-07, -6.633091250404456e-09,  6.478483543186314e-11, -5.715613023399497e-13,
  4.654561497127243e-15, -3.549861721905725e-17,  2.561768098094009e-19, -1.762787707389958e-21,  1.163492788701919e-23, -7.400340833541329e-26,  1.139271561393498e-03,
 -2.598462201066179e-05,  4.094929521488664e-07, -5.165251288660533e-09,  5.623741488288645e-11, -5.489396783960904e-13,  4.917219273973265e-15, -4.105617250816549e-17,
  3.230835487655814e-19, -2.416076996528811e-21,  1.727927638906097e-23, -1.187749807306517e-25,  5.353066445531592e-04, -1.450064814631515e-05,  2.599115868859840e-07,
 -3.676977873765641e-09,  4.445593047530273e-11, -4.784393066094489e-13,  4.698954056980398e-15, -4.282255758851840e-17,  3.664137394719166e-19, -2.969712798526644e-21,
  2.295296664105627e-23, -1.700781734455991e-25,  2.351914949702298e-04, -7.481298279387830e-06,  1.518364214753449e-07, -2.399580039449388e-09,  3.210695512390795e-11,
 -3.798074298331806e-13,  4.078413113284531e-15, -4.046021429893914e-17,  3.754961149692221e-19, -3.290493920100537e-21,  2.742229120381032e-23, -2.185588801545018e-25,
  9.667181179975679e-05, -3.575336839029244e-06,  8.181345649400141e-08, -1.439180140897542e-09,  2.124604870731020e-11, -2.755023004905873e-13,  3.226419573941090e-15,
 -3.476254531642630e-17,  3.491505656228730e-19, -3.301214056476000e-21,  2.960503604580760e-23, -2.533078485474246e-25,  3.719549960798871e-05, -1.585557921791778e-06,
  4.074152437975249e-08, -7.951178948836544e-10,  1.291495225479447e-11, -1.831293327166096e-13,  2.333732403812439e-15, -2.725177943583835e-17,  2.956468040994214e-19,
 -3.010480749975440e-21,  2.900073822610280e-23, -2.659328558746689e-25,  1.340569335904815e-05, -6.535969240270019e-07,  1.878630136022815e-08, -4.055321866951135e-10,
  7.229159640831981e-12, -1.118421970241012e-13,  1.547824433399965e-15, -1.955286116922127e-17,  2.287222889981759e-19, -2.504125796070420e-21,  2.587182308971553e-23,
 -2.538712366636259e-25,  4.529415141904562e-06, -2.508537379355729e-07,  8.036126795411924e-09, -1.913386047033017e-10,  3.734707202265803e-12, -6.291369781302661e-14,
  9.438208445515052e-16, -1.287633318485398e-17,  1.621541500062266e-19, -1.905973958990817e-21,  2.108982486945549e-23, -2.211544767697576e-25,  1.435990721741753e-06,
 -8.979138759852047e-08,  3.194945487908740e-09, -8.368655501301037e-11,  1.784701672533622e-12, -3.267483747214878e-14,  5.304680073473306e-16, -7.803877261586542e-18,
  1.056489664466956e-19, -1.331414653747244e-21,  1.575803208815800e-23, -1.763731031430462e-25,  4.276477762499931e-07, -3.002560481558721e-08,  1.182815299923920e-09,
 -3.400026359804152e-11,  7.906356162545952e-13, -1.570476548985838e-14,  2.754919356839375e-16, -4.364138894497586e-18,  6.343183618446830e-20, -8.560216109594711e-22,
  1.082441560404492e-23, -1.291705212466518e-25,  1.197815484398023e-07, -9.396522356182932e-09,  4.085683617740344e-10, -1.285888435087299e-11,  3.254351986724135e-13,
 -7.002060305570429e-15,  1.325298329687714e-16, -2.257762860364558e-18,  3.519015781924663e-20, -5.079750185043800e-22,  6.855429697679794e-24, -8.713350426183091e-26,
  3.160048520658441e-08, -2.757333727014307e-09,  1.319509180263054e-10, -4.537120174168103e-12,  1.247495275911449e-13, -2.903010546455910e-15,  5.920608028736771e-17,
 -1.083382463002340e-18,  1.808744375773899e-20, -2.789930681512151e-22,  4.014542100607304e-24, -5.429705827771452e-26,  7.865541184981098e-09, -7.602521439785578e-10,
  3.993286294152470e-11, -1.497039062901673e-12,  4.464367654434150e-14, -1.122009555161071e-15,  2.462621868643798e-17, -4.834732473239333e-19,  8.637144771640354e-21,
 -1.422209424081205e-22,  2.180037907250167e-24, -3.134884450432144e-26,  1.850717186181083e-09, -1.974062235856563e-10,  1.135199171087590e-11, -4.630824365542387e-13,
  1.495403902006903e-14, -4.053504782841589e-16,  9.563058138839803e-18, -2.012174307434588e-19,  3.842740506194782e-21, -6.748672565966610e-23,  1.101053694719183e-24,
 -1.682031562411359e-26,  4.125770411065556e-10, -4.839458145866355e-11,  3.039432403508228e-12, -1.346629869969918e-13,  4.701706613138821e-15, -1.372765136028796e-16,
  3.477208383899073e-18, -7.833378445288428e-20,  1.597707881055847e-21, -2.990092016179771e-23,  5.188176188588426e-25, -8.413516350396071e-27,  8.736770229378411e-11,
 -1.123294386147391e-11,  7.687227790500043e-13, -3.692428545407097e-14,  1.391819396633747e-15, -4.371632133706771e-17,  1.187588956025483e-18, -2.861571289955801e-20,
  6.227803177865317e-22, -1.240999023372850e-23,  2.288258942276353e-25, -3.936288825540324e-27,  1.762692732452877e-11, -2.476470473579181e-12,  1.842584392706341e-13,
 -9.578516454459813e-15,  3.892295096322066e-16, -1.313562247968021e-17,  3.822886613656126e-19, -9.843045799005605e-21,  2.283807694565242e-22, -4.841645206305262e-24,
  9.479849801868342e-26, -1.728587242143521e-27,  3.399982429633849e-12, -5.204463057513024e-13,  4.201063178518343e-14, -2.359492793311144e-15,  1.032159243430374e-16,
 -3.738062554655474e-18,  1.164233654613153e-19, -3.200079654743772e-21,  7.908803096115152e-23, -1.782340615296710e-24,  3.702943565397236e-26, -7.152136090793250e-28,
  6.294592290696909e-13, -1.046859970462354e-13,  9.148634172956383e-15, -5.542112154066620e-16,  2.606223490354403e-17, -1.011666576487135e-18,  3.368344319743004e-20,
 -9.874144195239030e-22,  2.597083514910612e-23, -6.216672518696205e-25,  1.369402885938846e-26, -2.799659366193562e-28,  1.123613551125039e-13, -2.024760869885501e-14,
  1.911771414480219e-15, -1.247064034049627e-16,  6.295319989825020e-18, -2.615974292343590e-19,  9.300832727542175e-21, -2.904939015502089e-22,  8.123926672131770e-24,
 -2.063788170869895e-25,  4.816298936038332e-27, -1.041473690297015e-28,  1.943903817489067e-14, -3.785312567933915e-15,  3.853659603963784e-16, -2.702268537837032e-17,
  1.462255704855696e-18, -6.496482128852901e-20,  2.463673607444292e-21, -8.189981721567513e-23,  2.433002522106549e-24, -6.553685490643377e-26,  1.619008735597336e-27,
 -3.700008047073959e-29,  3.278738684549903e-15, -6.880886321012925e-16,  7.537614292999831e-17, -5.672114685209608e-18,  3.285173670934002e-19, -1.558398531047353e-20,
  6.296254604974374e-22, -2.225323441574943e-23,  7.015285749470474e-25, -2.001810583087604e-26,  5.230172952020134e-28, -1.262176234213256e-29,  5.427864544325581e-16,
 -1.224360608854687e-16,  1.440148578169137e-17, -1.160920025373876e-18,  7.185493487356640e-20, -3.634419540314991e-21,  1.562375424692019e-22, -5.864063731044833e-24,
  1.959611798419879e-25, -5.917491256151481e-27,  1.633576196699350e-28, -4.159020520119749e-30,  8.886719962010123e-17, -2.148693445973635e-17,  2.707949902431659e-18,
 -2.334050379679190e-19,  1.541297622105728e-20, -8.299890387483300e-22,  3.791158231778047e-23, -1.509153009682147e-24,  5.339549585771137e-26, -1.704402367651025e-27,
  4.966116306983835e-29, -1.332505807864879e-30,  1.451310068732334e-17, -3.750761140150508e-18,  5.053232502972253e-19, -4.647870484629980e-20,  3.268733156295190e-21,
 -1.870965959058676e-22,  9.066930445964470e-24, -3.822593021632918e-25,  1.430056061649949e-26, -4.819186533785300e-28,  1.480265825364160e-29, -4.181095099999200e-31,
  2.386947442075905e-18, -6.574338647628131e-19,  9.445878606968235e-20, -9.251636563603611e-21,  6.915966146569013e-22, -4.200139363274947e-23,  2.155899181362351e-24,
 -9.611269114902321e-26,  3.796235730656773e-27, -1.348686621937835e-28,  4.361221591002395e-30, -1.295050958172487e-31,  3.995810696527276e-19, -1.169297403952856e-19,
  1.787056837633546e-20, -1.859529127502043e-21,  1.474427427424718e-22, -9.481970052087939e-24,  5.145465658509430e-25, -2.421392623964852e-26,  1.008057014542072e-27,
 -3.769479238196737e-29,  1.281261491069783e-30, -3.993877481221167e-32,  6.888414480262803e-20, -2.134695269746182e-20,  3.460710109917715e-21, -3.816099922189226e-22,
  3.201881202513097e-23, -2.175629788140086e-24,  1.245556764424000e-25, -6.174850786864303e-27,  2.704363742942569e-28, -1.062437545919429e-29,  3.789232239657238e-31,
 -1.237775695103678e-32,  1.238486465817442e-20, -4.050455881620614e-21,  6.944425648725450e-22, -8.092265422707379e-23,  7.166129057091297e-24, -5.132077226521711e-25,
  3.092424090155426e-26, -1.611398934318063e-27,  7.408280450224062e-29, -3.051325557449647e-30,  1.139590111563527e-31, -3.893315748322568e-33,  2.353949746668225e-21,
 -8.094870122297778e-22,  1.462888915920297e-22, -1.795912017637315e-23,  1.673635235656927e-24, -1.259765072757100e-25,  7.968289241479099e-27, -4.353085496099808e-28,
  2.095626862169276e-29, -9.027765038373036e-31,  3.522469086013682e-32, -1.255801531387188e-33,  4.797008692296920e-22, -1.727765567829995e-22,  3.279335268567979e-23,
 -4.226837854288699e-24,  4.131777705647931e-25, -3.258580852352572e-26,  2.157086486836256e-27, -1.231877334446644e-28,  6.192525309601238e-30, -2.782582879701514e-31,
  1.131293462522450e-32, -4.197943152428882e-34,  1.063193212618261e-22, -3.994136747779674e-23,  7.930607954555450e-24, -1.069178103572175e-24,  1.092293049303402e-25,
 -8.994415430028286e-27,  6.210216127246752e-28, -3.695326836896919e-29,  1.933564233234717e-30, -9.034724628885056e-32,  3.815939680638647e-33, -1.469549201471332e-34,
  2.598289724224269e-23, -1.013635340744076e-23,  2.096402320985351e-24, -2.943883972709616e-25,  3.130590541370181e-26, -2.681063960649811e-27,  1.923503333680828e-28,
 -1.188205159432338e-29,  6.448435421803840e-31, -3.122347083207709e-32,  1.365406112011342e-33, -5.439251715384030e-35,  7.086627725972384e-24, -2.857583067551776e-24,
  6.127276910277480e-25, -8.921331418655466e-26,  9.831515029829414e-27, -8.719111276358176e-28,  6.472718615575922e-29, -4.133946422736630e-30,  2.317716025035377e-31,
 -1.158453004817866e-32,  5.225373461881142e-34, -2.145341529422591e-35,  2.175525060742307e-24, -9.023411138596440e-25,  1.995826558046333e-25, -2.998056875370285e-26,
  3.407252732018335e-27, -3.114362543659948e-28,  2.381267748693354e-29, -1.565359387571831e-30,  9.026937473896975e-32, -4.637639807624089e-33,  2.148758992186820e-34,
 -9.055439265958004e-36,  7.527263807316394e-25, -3.195095215077563e-25,  7.250642466293325e-26, -1.117686997950589e-26,  1.303089451132252e-27, -1.221293849533191e-28,
  9.569870651319664e-30, -6.443411313727900e-31,  3.803665161494549e-32, -1.999298361625683e-33,  9.472183604583743e-35, -4.079401719410976e-36,  2.893780275146047e-25,
 -1.250454504465823e-25,  2.894834206912673e-26, -4.553181302170584e-27,  5.415244551082129e-28, -5.175537737969454e-29,  4.133835902315553e-30, -2.835877635794479e-31,
  1.704941470552149e-32, -9.122901389688025e-34,  4.398142211362095e-35, -1.926540325445822e-36,  1.168401535761818e-25, -5.112160195540438e-26,  1.200146330984651e-26,
 -1.914555882825964e-27,  2.309133983254989e-28, -2.237465420830232e-29,  1.811337195007635e-30, -1.259065037700259e-31,  7.667480726741560e-33, -4.154583292820728e-34,
  2.027615775270739e-35, -8.988237555786655e-37,  3.886372049005446e-26, -1.712293950870203e-26,  4.051463887464655e-27, -6.514658910904726e-28,  7.919249296740264e-29,
 -7.732905610287927e-30,  6.307653910226997e-31, -4.416985429976492e-32,  2.709354742759658e-33, -1.478435890239494e-34,  7.265240556424293e-36, -3.242264376228906e-37,
  5.022486633189727e-02, -1.034768463607499e-04,  2.193507791581654e-07, -4.767065760809403e-10,  1.056995367832651e-12, -2.380491131950639e-15,  5.418827368271900e-18,
 -1.243322648969923e-20,  2.863300976507410e-23, -6.618904833110369e-26,  1.528100416781589e-28, -3.539480239056872e-31,  4.679805095140890e-02, -1.129405648168861e-04,
  3.210011466402105e-07, -9.678382995482042e-10,  2.937026762556984e-12, -8.812615407990920e-15,  2.603886466529102e-17, -7.580992344680649e-20,  2.177798302603126e-22,
 -6.184162690962966e-25,  1.737728530320653e-27, -4.839029580292399e-30,  4.063070628389692e-02, -1.267935789639774e-04,  4.965440483072934e-07, -1.933568432007092e-09,
  7.230965670599344e-12, -2.608573111731629e-14,  9.142023947053800e-17, -3.128800269390467e-19,  1.049483368589015e-21, -3.459309629623013e-24,  1.122766508717869e-26,
 -3.594039995334603e-29,  3.287124683389336e-02, -1.375427409019450e-04,  6.973168141871532e-07, -3.286509460548079e-09,  1.452291327174038e-11, -6.120674176368271e-14,
  2.485405739817075e-16, -9.786812899640381e-19,  3.754074471877304e-21, -1.407564720662881e-23,  5.172559719105046e-26, -1.867004760062031e-28,  2.478221980865061e-02,
 -1.389692393095978e-04,  8.672226140898677e-07, -4.815509309235297e-09,  2.473233277988992e-11, -1.200035189730748e-13,  5.565377523861890e-16, -2.486138941890957e-18,
  1.075788548937401e-20, -4.528415985836211e-23,  1.860489067347544e-25, -7.480220461797117e-28,  1.741260459582519e-02, -1.287669529148444e-04,  9.599648356772678e-07,
 -6.198414032752317e-09,  3.659705908760193e-11, -2.022062659709967e-13,  1.059693654805585e-15, -5.316173870642303e-18,  2.570086628296012e-20, -1.203386539512849e-22,
  5.478534750338007e-25, -2.432569360024274e-27,  1.140342826453478e-02, -1.089266806279539e-04,  9.536588945720172e-07, -7.097674551507969e-09,  4.775207011198746e-11,
 -2.978743598171812e-13,  1.749819128099027e-15, -9.783235694688060e-18,  5.245873035782717e-20, -2.713211333462234e-22,  1.359579366266974e-24, -6.623696991542378e-27,
  6.961723135394894e-03, -8.413569358150272e-05,  8.560260233715205e-07, -7.291062171290276e-09,  5.548961328408263e-11, -3.881336757436361e-13,  2.539500102568520e-15,
 -1.572868321014324e-17,  9.300821405283019e-20, -5.284524271391974e-22,  2.899265604969201e-24, -1.541899996479868e-26,  3.962631554040813e-03, -5.945131575549260e-05,
  6.978358782294699e-07, -6.759600043035464e-09,  5.784373834399468e-11, -4.511692263204705e-13,  3.270844681645257e-15, -2.233207474084821e-17,  1.449515909923523e-19,
 -9.007051745248348e-22,  5.387104278092674e-24, -3.114503845317592e-26,  2.103434536202835e-03, -3.852158699777186e-05,  5.186649179166321e-07, -5.682236145297604e-09,
  5.439474309196197e-11, -4.709086033733492e-13,  3.766432522449596e-15, -2.823250723315878e-17,  2.003639067841572e-19, -1.356554986603947e-21,  8.813440346804892e-24,
 -5.520039903016804e-26,  1.041512946787624e-03, -2.294210846665932e-05,  3.525661791490920e-07, -4.347241765736045e-09,  4.635135187111612e-11, -4.436288601904529e-13,
  3.900207024611127e-15, -3.198535608125062e-17,  2.473811707633775e-19, -1.819174859461986e-21,  1.279978050144116e-23, -8.659499366415768e-26,  4.811993471143265e-04,
 -1.258644772564984e-05,  2.197586410083172e-07, -3.036490878115241e-09,  3.592422206079036e-11, -3.788206302221936e-13,  3.649187045497844e-15, -3.264434771951146e-17,
  2.743720193561792e-19, -2.185564363710797e-21,  1.661056091026393e-23, -1.210822324493029e-25,  2.075249257557556e-04, -6.373598230412563e-06,  1.258892864458547e-07,
 -1.941681779471779e-09,  2.540444084377437e-11, -2.942646803257762e-13,  3.097348163850900e-15, -3.014544711580416e-17,  2.746642090610145e-19, -2.364413980425945e-21,
  1.936689717425362e-23, -1.517820461561824e-25,  8.357774096630924e-05, -2.984523893277961e-06,  6.641385987856822e-08, -1.139426033792677e-09,  1.643758899176464e-11,
 -2.085880669596934e-13,  2.393132904480027e-15, -2.528283723945104e-17,  2.491827393493862e-19, -2.313372518308509e-21,  2.038186985691879e-23, -1.714139872387356e-25,
  3.144931912449890e-05, -1.294538318038824e-06,  3.232827216272407e-08, -6.149775764684344e-10,  9.755781867941349e-12, -1.352999626324810e-13,  1.688312349647500e-15,
 -1.932228816745640e-17,  2.056051833962875e-19, -2.054855066664444e-21,  1.943969271761306e-23, -1.751499329022104e-25,  1.106363336345389e-05, -5.209634808713859e-07,
  1.454616162219849e-08, -3.059142850893931e-10,  5.323392930485071e-12, -8.051377471238881e-14,  1.090566236413007e-15, -1.349638418795685e-17,  1.547883413703619e-19,
 -1.662669525317015e-21,  1.686385627852832e-23, -1.625380773145696e-25,  3.641353911737871e-06, -1.948213374079072e-07,  6.060747881209382e-09, -1.405315306415468e-10,
  2.676527797793150e-12, -4.406011444904335e-14,  6.466725188720668e-16, -8.639742772497813e-18,  1.066362912371898e-19, -1.229329397089544e-21,  1.334955912542050e-23,
 -1.374586604123112e-25,  1.122209208527297e-06, -6.780885388445250e-08,  2.342525886517077e-09, -5.973551905574829e-11,  1.242619191015311e-12, -2.222396876900129e-14,
  3.528711848146779e-16, -5.082079910392575e-18,  6.741114874321719e-20, -8.329678553269871e-22,  9.672542454144428e-24, -1.062775688422439e-25,  3.241612205914269e-07,
 -2.200177014669112e-08,  8.414073620522656e-10, -2.354137208536950e-11,  5.338351415533784e-13, -1.035568132895365e-14,  1.776177048824093e-16, -2.753814923189412e-18,
  3.920743703205238e-20, -5.186678874719417e-22,  6.433296818776533e-24, -7.534767898550587e-26,  8.786750707417567e-08, -6.666301987452805e-09,  2.813883196051863e-10,
 -8.618835680767374e-12,  2.126728134647202e-13, -4.467880702245428e-15,  8.266638605593604e-17, -1.378043446250806e-18,  2.103507724452696e-20, -2.975951861392563e-22,
  3.938803462666209e-24, -4.912681818560949e-26,  2.238020469291349e-08, -1.889534069693734e-09,  8.778994276069763e-11, -2.937650618191129e-12,  7.874399297823361e-14,
 -1.788955047753494e-15,  3.566116069676858e-17, -6.384365060528229e-19,  1.043733978038573e-20, -1.577638016930873e-22,  2.226074877919046e-24, -2.954142121313235e-26,
  5.364815550140044e-09, -5.020216191901730e-10,  2.560633728680252e-11, -9.342451122841901e-13,  2.716059020217402e-14, -6.663852566234202e-16,  1.429467480927487e-17,
 -2.745500767170059e-19,  4.802428713056702e-21, -7.748562906069648e-23,  1.164605149743981e-24, -1.643075117956248e-26,  1.212551484954590e-09, -1.252944492275904e-10,
  6.998763779095087e-12, -2.778952841806753e-13,  8.749090651237833e-15, -2.315241708208318e-16,  5.338404404850965e-18, -1.098875456932211e-19,  2.054747181598313e-21,
 -3.535855615172727e-23,  5.656320086984316e-25, -8.477632323007608e-27,  2.589586496096218e-10, -2.944660333369609e-11,  1.797113010500961e-12, -7.751890254680108e-14,
  2.639151680490253e-15, -7.523389277648586e-17,  1.862651718282347e-18, -4.105302636004949e-20,  8.198799948155525e-22, -1.503544234200753e-23,  2.558082496441084e-25,
 -4.070159945936893e-27,  5.238729797140423e-11, -6.534544589546387e-12,  4.347523986350444e-13, -2.033780354981455e-14,  7.477062738766395e-16, -2.293423424269514e-17,
  6.090596345209237e-19, -1.435995806615671e-20,  3.060510457473928e-22, -5.976662280461701e-24,  1.080706434724374e-25, -1.824189008240822e-27,  1.006793035206348e-11,
 -1.373440051276391e-12,  9.940324706713627e-14, -5.034719802252551e-15,  1.996115013811766e-16, -6.580290767930032e-18,  1.872597914633325e-19, -4.718803225847949e-21,
  1.072404648863163e-22, -2.228441872134675e-24,  4.279590508191884e-26, -7.658564265887297e-28,  1.844269858280255e-12, -2.743704034456076e-13,  2.155776814099436e-14,
 -1.180301352123814e-15,  5.039774941678988e-17, -1.783557903992277e-18,  5.433541289438879e-20, -1.462121095334691e-21,  3.540390202357304e-23, -7.822657503762917e-25,
  1.594454125179319e-26, -3.023163011171535e-28,  3.232636281037078e-13, -5.230312660155491e-14,  4.452524553107485e-15, -2.631014771887855e-16,  1.208312522487764e-17,
 -4.585467997528248e-19,  1.493990351781201e-20, -4.289225439186169e-22,  1.105708215337619e-23, -2.595881525971273e-25,  5.611797263301078e-27, -1.126612952583168e-28,
  5.445949411291503e-14, -9.557702402661892e-15,  8.798251419251537e-16, -5.602200822382645e-17,  2.763630634365728e-18, -1.123360001956387e-19,  3.910355013195940e-21,
 -1.196705757059185e-22,  3.281611035934708e-24, -8.179829512700408e-26,  1.874193365696605e-27, -3.981257125352171e-29,  8.863473783887595e-15, -1.682927688178875e-15,
  1.671975808776623e-16, -1.145382367842780e-17,  6.061142273709519e-19, -2.635851193241913e-20,  9.792665671530806e-22, -3.191580149026209e-23,  9.301895979223513e-25,
 -2.459782970767906e-26,  5.968942212659489e-28, -1.340694746044864e-29,  1.401869388114318e-15, -2.872299703098996e-16,  3.073744820311073e-17, -2.261752625869780e-18,
  1.282123157388142e-19, -5.957915248940694e-21,  2.359843402917884e-22, -8.182589430278919e-24,  2.532361874205678e-25, -7.098228362064192e-27,  1.822778829653901e-28,
 -4.325762000924188e-30,  2.169271558094875e-16, -4.783742292480945e-17,  5.503177848688484e-18, -4.342313329804966e-19,  2.633024420486646e-20, -1.305738557636296e-21,
  5.507398265087979e-23, -2.029513260026418e-24,  6.662931138164789e-26, -1.977812777281032e-27,  5.369971571990380e-29, -1.345342596074104e-30,  3.309503785723926e-17,
 -7.834229405678399e-18,  9.668368174424485e-19, -8.166340378267914e-20,  5.288562059739999e-21, -2.794930033051391e-22,  1.253749171247669e-23, -4.904379722293751e-25,
  1.706161911717340e-26, -5.357818638120203e-28,  1.536572336942689e-29, -4.060120189222101e-31,  5.021616839875834e-18, -1.272525369933784e-18,  1.681097115069919e-19,
 -1.517118531046363e-20,  1.047560748105877e-21, -5.890927899299247e-23,  2.806493252627762e-24, -1.163853919215709e-25,  4.285137191696252e-27, -1.421923693272880e-28,
  4.302681740113668e-30, -1.197809943882057e-31,  7.652955152672704e-19, -2.070134700736243e-19,  2.920735523460195e-20, -2.810551090791632e-21,  2.065405230362286e-22,
 -1.233814240877925e-23,  6.232909538007334e-25, -2.736203828434449e-26,  1.064735527527072e-27, -3.728406928191740e-29,  1.188872250687871e-30, -3.482706512977039e-32,
  1.184411495063780e-19, -3.409637856674343e-20,  5.124953459844499e-21, -5.246864840654391e-22,  4.095316971072779e-23, -2.593909563657314e-24,  1.387044365900661e-25,
 -6.434978111802330e-27,  2.642280512892831e-28, -9.749274226273377e-30,  3.271153824718333e-31, -1.006941097253487e-32,  1.884372643568252e-20, -5.754622620778713e-21,
  9.189944624135368e-22, -9.985552335622596e-23,  8.259450820773578e-24, -5.535040442679847e-25,  3.126663571797722e-26, -1.530065827067799e-27,  6.617443325250246e-29,
 -2.568246721073869e-30,  9.052137487239543e-32, -2.923256630513406e-33,  3.123416862206155e-21, -1.008412650282353e-21,  1.705935954930804e-22, -1.961966270575126e-23,
  1.715374305286315e-24, -1.213357449630506e-25,  7.224085532898965e-27, -3.720802859199850e-28,  1.691435854024642e-29, -6.890947862254184e-31,  2.546433336937409e-32,
 -8.610704157873792e-34,  5.472095862405076e-22, -1.860923512258422e-22,  3.324032833493335e-23, -4.034103272539817e-24,  3.717574822952942e-25, -2.768007214257902e-26,
  1.732462914771902e-27, -9.368201235862158e-29,  4.465469054592858e-30, -1.905267563726521e-31,  7.364928118119089e-33, -2.602034496964371e-34,  1.028835307912475e-22,
 -3.670969146395956e-23,  6.898695424506914e-24, -8.804999929061500e-25,  8.524834385373736e-26, -6.660845075466447e-27,  4.369573132061853e-28, -2.473582406204133e-29,
  1.232898901717479e-30, -5.494367339516677e-32,  2.215948363971034e-33, -8.159118683010694e-35,  2.108495853259968e-23, -7.860325038062116e-24,  1.547931643730314e-24,
 -2.069905195998833e-25,  2.097846895015316e-26, -1.714095234246278e-27,  1.174606513511970e-28, -6.938374406250243e-30,  3.604755273394985e-31, -1.672763363944329e-32,
  7.017951432446025e-34, -2.685171799217988e-35,  4.782452884121166e-24, -1.854389434703021e-24,  3.810132335773981e-25, -5.315510970273118e-26,  5.616531392664495e-27,
 -4.780116853751603e-28,  3.408701971922345e-29, -2.093281258023501e-30,  1.129547250597083e-31, -5.438972319764354e-33,  2.365660993093110e-34, -9.374694446954363e-36,
  1.217150878083410e-24, -4.885456000386335e-25,  1.042307370147490e-25, -1.510020999877752e-26,  1.655923404550720e-27, -1.461542252650765e-28,  1.079944689620482e-29,
 -6.866128998858165e-31,  3.832618019749133e-32, -1.907464268959160e-33,  8.568224811377674e-35, -3.503652170273881e-36,  3.511685973341666e-25, -1.451774013240433e-25,
  3.199529976609324e-26, -4.788901806780508e-27,  5.423261779005244e-28, -4.939945125528699e-29,  3.764414383014286e-30, -2.466491311148965e-31,  1.417822931564712e-32,
 -7.261618988105839e-34,  3.354415215790151e-35, -1.409520123697295e-36,  1.152159029261476e-25, -4.880060019623854e-26,  1.104797816942005e-26, -1.698975060963699e-27,
  1.976141915641929e-28, -1.847839861538254e-29,  1.444693991061212e-30, -9.705931887651139e-32,  5.717432645259153e-33, -2.999018323003733e-34,  1.418009227771630e-35,
 -6.095077054416555e-37,  4.244927360829238e-26, -1.832010734972479e-26,  4.235220212274097e-27, -6.652043625623623e-28,  7.900502721199008e-29, -7.540522200953480e-30,
  6.014820859697658e-31, -4.120929061401846e-32,  2.474400350114455e-33, -1.322393648405246e-34,  6.367639079282328e-36, -2.786017585773616e-37,  1.662504032898960e-26,
 -7.269557862852874e-27,  1.705444797635244e-27, -2.718743125387622e-28,  3.276795346039909e-29, -3.172941866305029e-30,  2.566947683340006e-31, -1.783135759038852e-32,
  1.085210826894897e-33, -5.876525912552661e-35,  2.866269792392759e-36, -1.269846492065105e-37,  5.434925925373918e-27, -2.393964539519654e-27,  5.662741938670534e-28,
 -9.102896750558894e-29,  1.106230531580049e-29, -1.079890017333660e-30,  8.806062021011100e-32, -6.164799359021588e-33,  3.780419860087240e-34, -2.062338466281912e-35,
  1.013194462609785e-36, -4.520422070097270e-38,  4.981443273039386e-02, -1.017446381134148e-04,  2.137302232464961e-07, -4.601685791551973e-10,  1.010658391106261e-12,
 -2.254515462526809e-15,  5.083174637359402e-18, -1.155394516312724e-20,  2.635657623438584e-23, -6.037695570527435e-26,  1.380628305251899e-28, -3.171096710569484e-31,
  4.635135226520821e-02, -1.104182261889639e-04,  3.096633333384054e-07, -9.222226429344509e-10,  2.766855829300898e-12, -8.212387399915110e-15,  2.401049859066129e-17,
 -6.918416682887800e-20,  1.967183655824014e-22, -5.529833425978917e-25,  1.538270242079462e-27, -4.241235189410338e-30,  4.013133244698604e-02, -1.229121099299078e-04,
  4.740185614267063e-07, -1.821930398050506e-09,  6.730501429312095e-12, -2.399309017361869e-14,  8.311164599761943e-17, -2.812054436685573e-19,  9.326651705488217e-22,
 -3.040289263907930e-24,  9.760008027912595e-27, -3.090547091141482e-29,  3.233198862133114e-02, -1.321180995840408e-04,  6.592335288381351e-07, -3.063620908653907e-09,
  1.335627674508063e-11, -5.555748449167165e-14,  2.227459024154978e-16, -8.662746828113459e-19,  3.282696043188768e-21, -1.216196737652480e-23,  4.417029268758630e-26,
 -1.575907779829239e-28,  2.423986169705829e-02, -1.322560534542949e-04,  8.117338917930755e-07, -4.438289809540596e-09,  2.246038773112568e-11, -1.074445116168991e-13,
  4.915101959909270e-16, -2.166595953189331e-18,  9.254043210048817e-21, -3.846082991659481e-23,  1.560512743711669e-25, -6.197408031355854e-28,  1.691243880113006e-02,
 -1.213751023233728e-04,  8.889680705987948e-07, -5.643881237179577e-09,  3.279566700873150e-11, -1.784707751005990e-13,  9.217324854562740e-16, -4.559032544010679e-18,
  2.173863353938798e-20, -1.004239487916284e-22,  4.511929835512102e-25, -1.977572937754371e-27,  1.098245841905122e-02, -1.016255476802636e-04,  8.728815463321019e-07,
 -6.379109398799828e-09,  4.219329450054170e-11, -2.589848407784379e-13,  1.497993305463537e-15, -8.250885876408768e-18,  4.360368439876651e-20, -2.223481237232607e-22,
  1.098839838396994e-24, -5.281159386933107e-27,  6.638343213132909e-03, -7.762293237206598e-05,  7.736144437691491e-07, -6.462162142568646e-09,  4.830241349557158e-11,
 -3.321510030162311e-13,  2.138056876215133e-15, -1.303568917439046e-17,  7.591762589068667e-20, -4.249947365535834e-22,  2.298129016122927e-24, -1.204995007538810e-26,
  3.735499276983200e-03, -5.417801512001454e-05,  6.219891619423934e-07, -5.902225665269658e-09,  4.955729432001868e-11, -3.796769240403634e-13,  2.705891962030473e-15,
 -1.817338132086424e-17,  1.160958817512341e-19, -7.103281301169013e-22,  4.184878766484083e-24, -2.384052165564710e-26,  1.957234959460987e-03, -3.463090477453088e-05,
  4.554043850225552e-07, -4.882610497859700e-09,  4.582004491322957e-11, -3.893186338644453e-13,  3.058802578285525e-15, -2.253868037443701e-17,  1.573287354171328e-19,
 -1.048210789737550e-21,  6.704454710852332e-24, -4.135509248677799e-26,  9.550721311545586e-04, -2.031828179280933e-05,  3.045718922814663e-07, -3.671804032118595e-09,
  3.834666013400436e-11, -3.599335972092777e-13,  3.106262016437702e-15, -2.502518952773890e-17,  1.902565844362984e-19, -1.376018464670440e-21,  9.526380124998460e-24,
 -6.344083838305932e-26,  4.341519940513766e-04, -1.096490513628764e-05,  1.865340602181856e-07, -2.517849898714312e-09,  2.915441182806142e-11, -3.012848740791587e-13,
  2.847092940084955e-15, -2.500483839562088e-17,  2.064692711239349e-19, -1.616680833826854e-21,  1.208377755259256e-23, -8.666509878855158e-26,  1.839063906009782e-04,
 -5.453197053499378e-06,  1.048460566971361e-07, -1.578524206129325e-09,  2.019895857119924e-11, -2.291376197780864e-13,  2.364523787142856e-15, -2.258073863028282e-17,
  2.020163763026046e-19, -1.708583096100584e-21,  1.375708058011599e-23, -1.060326700370909e-25,  7.262158895341094e-05, -2.503732351296848e-06,  5.419057580779630e-08,
 -9.069034701326564e-10,  1.278718762622753e-11, -1.588185370838843e-13,  1.785369139992875e-15, -1.849780478348824e-17,  1.789227296686438e-19, -1.631246087443072e-21,
  1.412153072752501e-23, -1.167503613223719e-25,  2.674517195567361e-05, -1.062969706111805e-06,  2.580245753909053e-08, -4.785028991306420e-10,  7.414725327594265e-12,
 -1.005926249018983e-13,  1.229267067708495e-15, -1.379033098283254e-17,  1.439480522753151e-19, -1.412191359133484e-21,  1.312171879923551e-23, -1.161771733692892e-25,
  9.191162280230688e-06, -4.179438516844642e-07,  1.133737509758100e-08, -2.323191846477729e-10,  3.946917422318442e-12, -5.836623236663023e-14,  7.738672630669417e-16,
 -9.383483567695403e-18,  1.055264111900076e-19, -1.112245312120501e-21,  1.107595994296933e-23, -1.048670901153530e-25,  2.949306056998950e-06, -1.524147269205787e-07,
  4.604758940331163e-09, -1.039892459535561e-10,  1.932763801546282e-12, -3.109481176053951e-14,  4.465511048992125e-16, -5.843195951572196e-18,  7.069208851278537e-20,
 -7.993825310135528e-22,  8.520020116874910e-24, -8.615316120595660e-26,  8.843504294720734e-07, -5.162897374022628e-08,  1.731691446029514e-09, -4.299362919854364e-11,
  8.724539844744097e-13, -1.524412890877110e-14,  2.367487959262826e-16, -3.338326276498222e-18,  4.339057011089579e-20, -5.257510782451514e-22,  5.990388185555892e-24,
 -6.461952746182471e-26,  2.480135017541704e-07, -1.626965032481722e-08,  6.040086368043720e-10, -1.644917569551277e-11,  3.637695924599187e-13, -6.891989871525250e-15,
  1.155885284966440e-16, -1.754103237883442e-18,  2.446509259582209e-20, -3.172807466260935e-22,  3.860505047977401e-24, -4.438011073514709e-26,  6.512300238916631e-08,
 -4.777203350965464e-09,  1.957464550719790e-10, -5.835002001423212e-12,  1.403844723001980e-13, -2.879755562073610e-15,  5.208881669960021e-17, -8.497109556052147e-19,
  1.270324965180100e-20, -1.761494958101359e-22,  2.286597267646944e-24, -2.798794104219461e-26,  1.603044549112114e-08, -1.309248115142969e-09,  5.905237326100601e-11,
 -1.922937926832002e-12,  5.025043075978225e-14, -1.114551497183496e-15,  2.171625374951352e-17, -3.803879316051950e-19,  6.089613625421489e-21, -9.020350443710818e-23,
  1.248132187318483e-24, -1.625242792411933e-26,  3.704660189148791e-09, -3.355306200294647e-10,  1.661692338116036e-11, -5.899884535454264e-13,  1.672080471907141e-14,
 -4.004842275002679e-16,  8.396144339289181e-18, -1.577614786158672e-19,  2.701999269655201e-21, -4.271858877783093e-23,  6.295594284581207e-25, -8.714492704274615e-27,
  8.051807719628487e-10, -8.057494858310518e-11,  4.371109904000385e-12, -1.689185392459204e-13,  5.184522755434718e-15, -1.339311227681807e-16,  3.018075527431950e-18,
 -6.077486007558101e-20,  1.112653259076721e-21, -1.876066378371713e-23,  2.942602631630113e-25, -4.326956281492829e-27,  1.649150197931544e-10, -1.817307645468191e-11,
  1.077506042180524e-12, -4.524426219681902e-14,  1.501833276755870e-15, -4.179672621210554e-17,  1.011379721159338e-18, -2.180711254958687e-20,  4.264213805566717e-22,
 -7.662403951556621e-24,  1.278247027216431e-25, -1.995401286281852e-27,  3.190640310144515e-11, -3.859669818940161e-12,  2.495840115729038e-13, -1.136884449752062e-14,
  4.076006621259217e-16, -1.220752734277611e-17,  3.168922319607477e-19, -7.310061501726741e-21,  1.525589072867465e-22, -2.919438758055634e-24,  5.176482658137298e-26,
 -8.573338165051635e-28,  5.847204043689977e-12, -7.741995441900340e-13,  5.448949619064116e-14, -2.688386973881956e-15,  1.039736316978116e-16, -3.347558898485648e-18,
  9.313784209910598e-20, -2.296725873328059e-21,  5.111921754328392e-23, -1.041097213207414e-24,  1.960843233489489e-26, -3.443529652062791e-28,  1.018293641826944e-12,
 -1.471660033965993e-13,  1.125156343525997e-14, -6.003640442181629e-16,  2.501637805845731e-17, -8.649500847277197e-19,  2.576991054448613e-20, -6.787725073050662e-22,
  1.610077331211529e-23, -3.487502528884611e-25,  6.972981487791384e-27, -1.297706926198187e-28,  1.691545908620863e-13, -2.661330478934225e-14,  2.206112712173694e-15,
 -1.271184231707304e-16,  5.699915664564052e-18, -2.114215139610611e-19,  6.739167168363827e-21, -1.894528677310616e-22,  4.785861332229265e-24, -1.101802649712519e-25,
  2.337200819904448e-27, -4.606829706186454e-29,  2.692006817517642e-14, -4.598968552480172e-15,  4.125792801950653e-16, -2.563471693149038e-17,  1.235405956376142e-18,
 -4.910810840721416e-20,  1.673212792192930e-21, -5.016244206955206e-23,  1.348516486175880e-24, -3.297495119279919e-26,  7.416406701973798e-28, -1.547360627122369e-29,
  4.125225598266997e-15, -7.633308066386861e-16,  7.397396178408871e-17, -4.948780053141482e-18,  2.560134247680876e-19, -1.089446458597595e-20,  3.964032830263623e-22,
 -1.266287126871877e-23,  3.619898304149142e-25, -9.395121954555335e-27,  2.238946052430563e-28, -4.941549538529098e-30,  6.122651038112862e-16, -1.224065373409956e-16,
  1.279046123341925e-17, -9.199163374142945e-19,  5.102000742726914e-20, -2.321664786662235e-21,  9.012280102715011e-23, -3.064850940013572e-24,  9.309047266138004e-26,
 -2.562480991769027e-27,  6.465853337408236e-29, -1.508600329078596e-30,  8.860961285307033e-17, -1.909226879994619e-17,  2.147010382024076e-18, -1.657523441899416e-19,
  9.842268199053594e-21, -4.783606290325816e-22,  1.978940986499373e-23, -7.157593820672869e-25,  2.307848173976376e-26, -6.732106087437182e-28,  1.797216474303071e-29,
 -4.429485698845915e-31,  1.260189719778784e-17, -2.918855259478313e-18,  3.525601908037872e-19, -2.916796936360959e-20,  1.851656484320237e-21, -9.599859025467957e-23,
  4.227460392882207e-24, -1.624461377520245e-25,  5.554729679790383e-27, -1.715499977073203e-28,  4.841077595490297e-30, -1.259311567716881e-31,  1.776850564357897e-18,
 -4.412417864923735e-19,  5.712750038420197e-20, -5.055904620822517e-21,  3.426046594366527e-22, -1.892035100519310e-23,  8.857675481676660e-25, -3.611809590491789e-26,
  1.308291797986732e-27, -4.273234105750279e-29,  1.273423172501962e-30, -3.492864947954529e-32,  2.508983410119303e-19, -6.661415372020437e-20,  9.224122013848944e-21,
 -8.716182679879322e-22,  6.293801771490715e-23, -3.696553850485872e-24,  1.837091982536452e-25, -7.938158766491603e-27,  3.042062960750551e-28, -1.049579002797376e-29,
  3.299059717338388e-31, -9.530797894317373e-33,  3.588484009110723e-20, -1.015652627067656e-20,  1.500569869200343e-21, -1.510734194090351e-22,  1.160199892641778e-23,
 -7.234254591533324e-25,  3.810224137295131e-26, -1.741984833970735e-27,  7.052081326551071e-29, -2.566517936514905e-30,  8.497447339115349e-32, -2.582183463448692e-33,
  5.265134244898041e-21, -1.583595597448802e-21,  2.489842289514459e-22, -2.664489093128163e-23,  2.171585477486263e-24, -1.434622014396917e-25,  7.992643594073482e-27,
 -3.859268005857687e-28,  1.647608282150956e-29, -6.314563613472199e-31,  2.198698095920149e-32, -7.017039076358316e-34,  8.037003974292360e-22, -2.560133459442222e-22,
  4.271222979742156e-23, -4.845745125158095e-24,  4.180959592712171e-25, -2.919659010303308e-26,  1.716834643776137e-27, -8.736835624634926e-29,  3.925610812838636e-30,
 -1.581319270962564e-31,  5.779750741941586e-33, -1.933747940409028e-34,  1.296009650403724e-22, -4.356396031291633e-23,  7.687514687756923e-24, -9.218734376723463e-25,
  8.397032752684540e-26, -6.181953214802524e-27,  3.827060990175478e-28, -2.047609154348915e-29,  9.660247958022145e-31, -4.080773189700505e-32,  1.562245583670839e-33,
 -5.467880702426618e-35,  2.244082255603279e-23, -7.928637458863648e-24,  1.474601811125389e-24, -1.862865653454394e-25,  1.785635835767879e-26, -1.381704578655751e-27,
  8.979036797363823e-29, -5.036693870430341e-30,  2.488253653515420e-31, -1.099380237511256e-32,  4.397069228438210e-34, -1.605954582479803e-35,  4.243595397588141e-24,
 -1.569238768312495e-24,  3.063765571112736e-25, -4.062018702020322e-26,  4.082614379772786e-27, -3.308812285568584e-28,  2.249596408591089e-29, -1.318700791934155e-30,
  6.800475197549341e-32, -3.133056305335650e-33,  1.305287002141024e-34, -4.960486955874016e-36,  8.912335023262103e-25, -3.433655677319302e-25,  7.006418966652299e-26,
 -9.707723587780253e-27,  1.018873964874079e-27, -8.614847679929943e-29,  6.104291757540334e-30, -3.725556298794426e-31,  1.998313734192890e-32, -9.566386799756621e-34,
  4.137413547155752e-35, -1.630629530283156e-36,  2.111266589842994e-25, -8.433231754947457e-26,  1.789739260481290e-26, -2.579211734083338e-27,  2.813839612429516e-28,
 -2.471054519851454e-29,  1.816956373033071e-30, -1.149707792227951e-31,  6.387973468773258e-33, -3.165002064982225e-34,  1.415515530522022e-35, -5.763812192533570e-37,
  5.710522635126033e-26, -2.352633001327169e-26,  5.165222921444908e-27, -7.701675047523886e-28,  8.689326397987102e-29, -7.886118804985040e-30,  5.988204178272411e-31,
 -3.910025934350880e-32,  2.240089237598711e-33, -1.143566704249691e-34,  5.265866730353157e-36, -2.205930552069596e-37,  1.772473753997581e-26, -7.490383549557122e-27,
  1.691482357458357e-27, -2.594618026968639e-28,  3.010401625782453e-29, -2.808118901777706e-30,  2.190277432374018e-31, -1.468116126811538e-32,  8.628826893801169e-34,
 -4.516317195343967e-35,  2.130911370909963e-36, -9.140598008100255e-38,  6.245887257582457e-27, -2.692003995480667e-27,  6.214142054809694e-28, -9.745711591817526e-29,
  1.155782075993397e-29, -1.101537296359713e-30,  8.774297036689301e-32, -6.003331957491718e-33,  3.599900327702786e-34, -1.921409808252285e-35,  9.240416075467541e-37,
 -4.038006150340177e-38,  2.369158080273079e-27, -1.035279913290823e-27,  2.427008578485845e-28, -3.866183072684121e-29,  4.656374259025638e-30, -4.505582840815171e-31,
  3.642528724571682e-32, -2.528567543938968e-33,  1.537855621302760e-34, -8.322243813274653e-36,  4.056599012444560e-37, -1.796093701792361e-38,  7.605311608632687e-28,
 -3.349089019720559e-28,  7.919651537255724e-29, -1.272702617058513e-29,  1.546185551332076e-30, -1.508918412673437e-31,  1.230099472098828e-32, -8.608983143562001e-34,
  5.277759315959672e-35, -2.878381427683725e-36,  1.413716315983464e-37, -6.305681502949882e-39,  4.941083927232849e-02, -1.000566129044979e-04,  2.083037566968354e-07,
 -4.443522472160306e-10,  9.667623235868247e-13, -2.136308062362610e-15,  4.771152602714992e-18, -1.074427269850184e-20,  2.427913911739474e-23, -5.512359608000320e-26,
  1.248431100987945e-28, -2.844301336736890e-31,  4.591456493113224e-02, -1.079844459069625e-04,  2.988569592581502e-07, -8.792362680264919e-10,  2.608217291007556e-12,
 -7.658687958907393e-15,  2.215856160078292e-17, -6.319617753970120e-20,  1.778749949335663e-22, -4.950267187183716e-25,  1.363340411012332e-27, -3.722142316873281e-30,
  3.964713237484042e-02, -1.192056191796358e-04,  4.527860332399650e-07, -1.717975509692497e-09,  6.269965657027433e-12, -2.208962168421715e-14,  7.563979570304899e-17,
 -2.530385979132437e-19,  8.299262761352312e-22, -2.675773964705573e-24,  8.496966376748943e-27, -2.661856273170455e-29,  3.181383614406864e-02, -1.269877348500435e-04,
  6.237165314102323e-07, -2.858527256034352e-09,  1.229668103447793e-11, -5.049117358995928e-14,  1.998973933721879e-16, -7.679058172442569e-19,  2.875065367634563e-21,
 -1.052636133558756e-23,  3.778700854739414e-26, -1.332756799596422e-28,  2.372349633007775e-02, -1.259692702569412e-04,  7.605617191190174e-07, -4.095493838339824e-09,
  2.042471376950130e-11, -9.634401810677762e-14,  4.347914605207862e-16, -1.891466657149014e-18,  7.975536838784954e-21, -3.273169136334685e-23,  1.311707835705746e-25,
 -5.146192516022465e-28,  1.644074519145349e-02, -1.145256073130805e-04,  8.242758671958613e-07, -5.146545979246707e-09,  2.943751993389718e-11, -1.578056435406780e-13,
  8.032988696156268e-16, -3.917920548753917e-18,  1.842830357793974e-20, -8.400306062212550e-23,  3.725127394247708e-25, -1.611885499084639e-27,  1.058945321950108e-02,
 -9.493759732937282e-05,  8.002179793531349e-07, -5.743576681626992e-09,  3.735518761838757e-11, -2.256547319584525e-13,  1.285357550353296e-15, -6.975591873787931e-18,
  3.633735030138617e-20, -1.827122978038128e-22,  8.906486651046532e-25, -4.223340975088706e-27,  6.339756095007565e-03, -7.173154970086226e-05,  7.004950136661916e-07,
 -5.739798996836981e-09,  4.214432313058325e-11, -2.849566388895343e-13,  1.804889332299003e-15, -1.083436790430280e-17,  6.215219567201260e-20, -3.428591264022289e-22,
  1.827574126653440e-24, -9.449005963880183e-27,  3.528308770937415e-03, -4.947248408625051e-05,  5.556803419489649e-07, -5.166694530382800e-09,  4.257402606277424e-11,
 -3.204444924855007e-13,  2.245422921170285e-15, -1.483710041778118e-17,  9.330040287184322e-20, -5.621752390404127e-22,  3.262930003070391e-24, -1.831887781297361e-26,
  1.825643578220483e-03, -3.121013882137560e-05,  4.009671908672996e-07, -4.207996844206938e-09,  3.871946579201493e-11, -3.229445695120351e-13,  2.492879263965008e-15,
 -1.805953271446721e-17,  1.240117253718524e-19, -8.131866946488753e-22,  5.121222094417471e-24, -3.111482693867543e-26,  8.784071327293432e-04, -1.804804487383999e-05,
  2.639664655568384e-07, -3.112022703730422e-09,  3.184010438388823e-11, -2.931470763040155e-13,  2.483838971141374e-15, -1.966115527923487e-17,  1.469553765445079e-19,
 -1.045469006828427e-21,  7.122822936331415e-24, -4.669854226884639e-26,  3.930961824020904e-04, -9.585994411672052e-06,  1.589312435420697e-07, -2.096097551486082e-09,
  2.375894754985613e-11, -2.406602941476555e-13,  2.231330475575849e-15, -1.924272444203558e-17,  1.561219627802412e-19, -1.201826050071960e-21,  8.835657346982076e-24,
 -6.235689657395879e-26,  1.636584926563660e-04, -4.685032918320224e-06,  8.770106591656536e-08, -1.289122067680645e-09,  1.613602600939559e-11, -1.792989373820181e-13,
  1.814227014729182e-15, -1.700265554042728e-17,  1.493819704447720e-19, -1.241474915143906e-21,  9.827462955257646e-24, -7.450153143854965e-26,  6.340939414614369e-05,
 -2.110488104203120e-06,  4.443757075601756e-08, -7.255564303165653e-10,  1.000047933820418e-11, -1.215885547450322e-13,  1.339482364683799e-15, -1.361217277265148e-17,
  1.292374311051009e-19, -1.157253319385222e-21,  9.844915180467359e-24, -8.002355052172019e-26,  2.287242426538388e-05, -8.776444818461414e-07,  2.071070025726387e-08,
 -3.744816367846277e-10,  5.669123651892591e-12, -7.524683681294667e-14,  9.006518991019744e-16, -9.905339250410826e-18,  1.014413283068414e-19, -9.770119236496159e-22,
  8.917443609472789e-24, -7.759472125741388e-26,  7.684535016693869e-06, -3.374051878755002e-07,  8.892967522746028e-09, -1.775808912761144e-10,  2.945864709258915e-12,
 -4.259883523336457e-14,  5.529471184667670e-16, -6.570067093863623e-18,  7.245986628874800e-20, -7.494817714056280e-22,  7.328619045911562e-24, -6.816918414358098e-26,
  2.406104426747055e-06, -1.200861669934048e-07,  3.523655348476037e-09, -7.750923947350112e-11,  1.406003727651667e-12, -2.210968698670278e-14,  3.107146281241846e-16,
 -3.982485577490248e-18,  4.723235866303668e-20, -5.239518690486246e-22,  5.481637608207773e-24, -5.443901511514902e-26,  7.025809019123154e-07, -3.962314127918189e-08,
  1.290381880778173e-09, -3.119387245531078e-11,  6.175620696093200e-13, -1.054289835118093e-14,  1.601693275885115e-16, -2.211461293037874e-18,  2.816856193077970e-20,
 -3.347179911785621e-22,  3.742451614111362e-24, -3.963796566596357e-26,  1.914759169194013e-07, -1.213776977450043e-08,  4.374378704617889e-10, -1.159608601886427e-11,
  2.501087498044599e-13, -4.628354131418411e-15,  7.590909539511293e-17, -1.127616120404958e-18,  1.540798680073420e-20, -1.959083486677675e-22,  2.338529542787790e-24,
 -2.638926507093959e-26,  4.875131935579423e-08, -3.457100209248886e-09,  1.375024595362986e-10, -3.989019627853238e-12,  9.357818649393040e-14, -1.874475153403026e-15,
  3.314778828249965e-17, -5.291757708792243e-19,  7.748762252732982e-21, -1.053197779921820e-22,  1.340953954256816e-24, -1.610820355345229e-26,  1.160942192896759e-08,
 -9.169886640708935e-10,  4.014826646981344e-11, -1.272201706145719e-12,  3.241080331669160e-14, -7.018394938374569e-16,  1.336671421052181e-17, -2.290876630180734e-19,
  3.591471393315523e-21, -5.213621468943077e-23,  7.074548844581481e-25, -9.039396221811507e-27,  2.589268872633096e-09, -2.269110246570256e-10,  1.090968784690397e-11,
 -3.769272185665143e-13,  1.041343454795986e-14, -2.434783555293317e-16,  4.988863529105735e-18, -9.170665138587393e-20,  1.537928913971463e-21, -2.382575819752746e-23,
  3.442998056968374e-25, -4.676025037612143e-27,  5.417324124066002e-10, -5.248457920735644e-11,  2.764732841793408e-12, -1.039730381866165e-13,  3.110814722368707e-15,
 -7.844551019812475e-17,  1.727580290393083e-18, -3.403149987253752e-20,  6.100110579538427e-22, -1.007801070654585e-23,  1.549886269972561e-25, -2.235935130004254e-27,
  1.065268487397867e-10, -1.137214505510284e-11,  6.549301699730971e-13, -2.676637795128973e-14,  8.661747341535992e-16, -2.353230052886266e-17,  5.564989225686968e-19,
 -1.173809607804414e-20,  2.247276841583346e-22, -3.956649776961312e-24,  6.471653586971769e-26, -9.911440844493920e-28,  1.973209457513234e-11, -2.314014734678833e-12,
  1.454004122968304e-13, -6.447994339914563e-15,  2.254106571258432e-16, -6.591104682673700e-18,  1.672283037101713e-19, -3.773986927509414e-21,  7.711910947071745e-23,
 -1.446082416946178e-24,  2.514139494500873e-26, -4.085392476196601e-28,  3.452013815464546e-12, -4.434409859794772e-13,  3.034173904775020e-14, -1.457901414067051e-15,
  5.499250060364152e-17, -1.728976599549765e-18,  4.702508033643649e-20, -1.134641529953834e-21,  2.473074881056311e-23, -4.935917196098154e-25,  9.116582168282727e-27,
 -1.570987844216555e-28,  5.721403244361323e-13, -8.029120784805141e-14,  5.971327659256448e-15, -3.104361587118671e-16,  1.262057301293880e-17, -4.262405797475602e-19,
  1.241740625366474e-20, -3.201020885923506e-22,  7.437150553178164e-24, -1.579007492234710e-25,  3.096585692355340e-27, -5.655891746058800e-29,  9.016559066436376e-14,
 -1.378781223127658e-14,  1.112542054491696e-15, -6.249288502366849e-17,  2.735159690887449e-18, -9.913832480542396e-20,  3.091032016136705e-21, -8.507111559582722e-23,
  2.105543884633451e-24, -4.752677007941088e-26,  9.891008788091405e-28, -1.913895453530825e-29,  1.356854625404669e-14, -2.255297044495064e-15,  1.970972660925660e-16,
 -1.194573773074796e-17,  5.622443948205476e-19, -2.185034198786786e-20,  7.285387364608997e-22, -2.139146638457934e-23,  5.636465918543048e-25, -1.351829564737043e-26,
  2.983949908919009e-28, -6.113731879969852e-30,  1.959455269664026e-15, -3.531612682087156e-16,  3.336960343531242e-17, -2.179240283194885e-18,  1.101754497776806e-19,
 -4.586414652780259e-21,  1.633938177753628e-22, -5.114571092394035e-24,  1.433730950775931e-25, -3.651373968801157e-27,  8.543682621085820e-29, -1.852519527597403e-30,
  2.731223110748755e-16, -5.325037933349297e-17,  5.430550132633728e-18, -3.816026051021941e-19,  2.069901773633037e-20, -9.220531111409318e-22,  3.506723349719850e-23,
 -1.169274954244023e-24,  3.484612457135602e-26, -9.417350355157346e-28,  2.334362496320365e-29, -5.353455864674514e-31,  3.699250928062499e-17, -7.783251006993441e-18,
  8.551683080142052e-19, -6.456563751858937e-20,  3.752863282251883e-21, -1.786980737846243e-22,  7.248262303648491e-24, -2.572266152684005e-25,  8.143102817851578e-27,
 -2.333627298534230e-28,  6.123836137140916e-30, -1.484409106540253e-31,  4.906572594738918e-18, -1.111317597206918e-18,  1.313091276761375e-19, -1.063556262484668e-20,
  6.615607567818276e-22, -3.363333814672041e-23,  1.453435626886421e-24, -5.484384928610271e-26,  1.842693310359660e-27, -5.595028664616744e-29,  1.553129840697973e-30,
 -3.976284999302213e-32,  6.430379573340792e-19, -1.563869611711878e-19,  1.983239164635408e-20, -1.720440289408580e-21,  1.143585714230769e-22, -6.199397492660525e-24,
  2.850854654211988e-25, -1.142576416000278e-26,  4.070254058114597e-28, -1.308171047155317e-29,  3.837874642054490e-31, -1.036867112283733e-32,  8.412828565627517e-20,
 -2.191008568944504e-20,  2.975951194069881e-21, -2.759979410123565e-22,  1.957299937651564e-23, -1.129758232288341e-24,  5.521129686832700e-26, -2.347326476412331e-27,
  8.855456840606065e-29, -3.009295264435698e-30,  9.320759860998166e-32, -2.654619103386954e-33,  1.111636364521367e-20, -3.091449729098965e-21,  4.487031481057780e-22,
 -4.440029468320918e-23,  3.353318116691366e-24, -2.057446484659975e-25,  1.066881826859903e-26, -4.804703011930278e-28,  1.916938924889140e-29, -6.878665131532557e-31,
  2.246497689725988e-32, -6.736719920267739e-34,  1.503202093984557e-21, -4.450214501684126e-22,  6.884922505787384e-23, -7.252662957821338e-24,  5.821441643895520e-25,
 -3.789479188152358e-26,  2.081290311673177e-27, -9.911727048642539e-29,  4.175342644463784e-30, -1.579634675965395e-31,  5.431576169893515e-33, -1.712505814725249e-34,
  2.110994227455157e-22, -6.630887233290878e-23,  1.090417527961564e-23, -1.219717257299136e-24,  1.038036158452973e-25, -7.153114225037852e-27,  4.152439580467756e-28,
 -2.086983903199095e-29,  9.264721404143785e-31, -3.688643950693302e-32,  1.333006444164027e-33, -4.411165708132003e-35,  3.128882697293183e-23, -1.039024828060043e-23,
  1.810444185163944e-24, -2.144187863128947e-25,  1.929557855958568e-26, -1.403970149554397e-27,  8.593238618518988e-29, -4.547285747705546e-30,  2.122537481992457e-31,
 -8.873872199148713e-33,  3.363248225096710e-34, -1.165747243966667e-35,  4.980724587258931e-24, -1.741696296527895e-24,  3.204314158724315e-25, -4.004888803312582e-26,
  3.798998535669393e-27, -2.909986296422116e-28,  1.872572101653519e-29, -1.040442422560712e-30,  5.092804952797569e-32, -2.230085088130711e-33,  8.842276498147735e-35,
 -3.202431270556449e-36,  8.672430138206500e-25, -3.179834803603601e-25,  6.152412891693820e-26, -8.084337092481914e-27,  8.054629747425377e-28, -6.472772753243676e-29,
  4.364583153656535e-30, -2.538118139320064e-31,  1.298783166569623e-32, -5.938792642518760e-34,  2.456209721233339e-35, -9.268572971868550e-37,  1.682449436548429e-25,
 -6.438326659038876e-26,  1.304243634641465e-26, -1.794098646291812e-27,  1.869754125072454e-28, -1.570106693141235e-29,  1.105147088030034e-30, -6.701383154919126e-32,
  3.571978496070332e-33, -1.699595912708208e-34,  7.307303874016127e-36, -2.863484375511796e-37,  3.700329401797767e-26, -1.470494660860682e-26,  3.103417404906279e-27,
 -4.447600980670096e-28,  4.825868385762372e-29, -4.215574378196484e-30,  3.083767300668399e-31, -1.941564469385779e-32,  1.073539716580704e-33, -5.293968875819278e-35,
  2.356861888925231e-36, -9.554409380013834e-38,  9.358589444943195e-27, -3.841461638173001e-27,  8.400131006337255e-28, -1.247489133463193e-28,  1.401925257935523e-29,
 -1.267452273628932e-30,  9.588261123557046e-32, -6.237976585940486e-33,  3.561193588020333e-34, -1.811766249740494e-35,  8.315031146612306e-37, -3.472037675216475e-38,
  2.741315997152272e-27, -1.155676893476259e-27,  2.602809364439162e-28, -3.981872759418714e-29,  4.607838264657706e-30, -4.287203050196267e-31,  3.335590607559403e-32,
 -2.230380178780494e-33,  1.307810134559406e-34, -6.829372661851100e-36,  3.215092031354200e-37, -1.376145033908552e-38,  9.219576281135522e-28, -3.968098324325067e-28,
  9.145516315784199e-29, -1.432045753951700e-29,  1.695688016943452e-30, -1.613655253374964e-31,  1.283458683518552e-32, -8.768732482338378e-34,  5.250814534684755e-35,
 -2.798752527833424e-36,  1.344189427292613e-37, -5.866481018822929e-39,  3.381593664106594e-28, -1.476685735265880e-28,  3.459140829247514e-29, -5.506082768189123e-30,
  6.626370087368700e-31, -6.406970637166152e-32,  5.175901454810772e-33, -3.590429687418406e-34,  2.182146517889910e-35, -1.180083626288448e-36,  5.748384593995924e-38,
 -2.543502273033651e-39,  1.064941627879912e-28, -4.688309254879010e-29,  1.108308234027921e-29, -1.780508328273780e-30,  2.162429636824472e-31, -2.109653684036584e-32,
  1.719304548260916e-33, -1.202912127138913e-34,  7.372307569755336e-36, -4.019540276428158e-37,  1.973634935121252e-38, -8.800670446437567e-40,  4.901391227705274e-02,
 -9.841125200670613e-05,  2.030629488276065e-07, -4.292197384747469e-10,  9.251573170248376e-13, -2.025324481926978e-15,  4.480898424778992e-18, -9.998151597467050e-21,
  2.238164108592388e-23, -5.037138048427565e-26,  1.129789125038050e-28, -2.554197865568956e-31,  4.548734302333646e-02, -1.056350955950785e-04,  2.885515501490252e-07,
 -8.387018769424921e-10,  2.460221513280175e-12, -7.147489298213799e-15,  2.046615076664493e-17, -5.777910013086323e-20,  1.609974281593330e-22, -4.436311591824660e-25,
  1.209723910908227e-27, -3.270779501440549e-30,  3.917742627270710e-02, -1.156641212546715e-04,  4.327579777244062e-07, -1.621094120409000e-09,  5.845768023094527e-12,
 -2.035637326000890e-14,  6.891249538296990e-17, -2.279588294325488e-19,  7.394442252814342e-22, -2.358201303662504e-24,  7.408284499593575e-27, -2.296238918084465e-29,
  3.131565204393071e-02, -1.221319422984130e-04,  5.905621863750584e-07, -2.669605408863307e-09,  1.133314360714617e-11, -4.594159626358011e-14,  1.796291063404602e-16,
 -6.816862847059015e-19,  2.521967160823386e-21, -9.125910848112208e-24,  3.238366093143568e-26, -1.129246264974409e-28,  2.323148463357439e-02, -1.200759475327767e-04,
  7.133147671064632e-07, -3.783563994363164e-09,  1.859803806647780e-11, -8.651676995921952e-14,  3.852332618164166e-16, -1.654132964952408e-18,  6.886426765932072e-21,
 -2.791107785985990e-23,  1.104883696262555e-25, -4.282737278659125e-28,  1.599545103469970e-02, -1.081706608165543e-04,  7.652424596652031e-07, -4.699783196079188e-09,
  2.646564584227348e-11, -1.397789500213687e-13,  7.014180767508157e-16, -3.373857964511862e-18,  1.565615038999896e-20, -7.042965347884485e-23,  3.083023891867040e-25,
 -1.317181178201926e-27,  1.022208371153186e-02, -8.880171699023352e-05,  7.347374784886719e-07, -5.180386449763769e-09,  3.313541229754632e-11, -1.970243943811731e-13,
  1.105378266299096e-15, -5.911510750231059e-18,  3.035858705474571e-20, -1.505425353906898e-22,  7.239231368890055e-25, -3.387287537912344e-27,  6.063617222722371e-03,
 -6.639205502670441e-05,  6.354825607964545e-07, -5.108828554350276e-09,  3.685490632404655e-11, -2.450658200506505e-13,  1.527611730731260e-15, -9.029650368859092e-18,
  5.103073183056709e-20, -2.774408739937349e-22,  1.457998341788256e-24, -7.434046877358138e-27,  3.338932780671042e-03, -4.526393128284825e-05,  4.975647335513320e-07,
 -4.533988611075955e-09,  3.667205457243347e-11, -2.712200709998701e-13,  1.868911055723705e-15, -1.215160671520757e-17,  7.522929915959643e-20, -4.464613667526574e-22,
  2.553244418996810e-24, -1.412862427988973e-26,  1.706912936923545e-03, -2.819432402629795e-05,  3.539852328866716e-07, -3.637070000188212e-09,  3.282011409212761e-11,
 -2.687607436748677e-13,  2.038635724179255e-15, -1.452254793256899e-17,  9.811652743839306e-20, -6.333156501073048e-22,  3.927653548317186e-24, -2.350791102908645e-26,
  8.102135675097050e-04, -1.607745516317065e-05,  2.294953684523374e-07, -2.646423680475210e-09,  2.653129829074213e-11, -2.396426041461786e-13,  1.993874487675527e-15,
 -1.550956736738715e-17,  1.139874263668404e-19, -7.977881157093267e-22,  5.349671884708533e-24, -3.453404306022032e-26,  3.571444651417151e-04, -8.409042481834306e-06,
  1.359090440720795e-07, -1.751723905923953e-09,  1.944037491626897e-11, -1.930470465178254e-13,  1.756429454181825e-15, -1.487589039840543e-17,  1.186076290323129e-19,
 -8.977641833418870e-22,  6.492905469570874e-24, -4.509695385293150e-26,  1.462294601060307e-04, -4.041171181318339e-06,  7.366956561613371e-08, -1.057420380013527e-09,
  1.294952552183864e-11, -1.409689507383986e-13,  1.398862824185756e-15, -1.286763419813892e-17,  1.110395967783061e-19, -9.069218648077434e-22,  7.059047697059678e-24,
 -5.264261202735441e-26,  5.562691064255718e-05, -1.787268193792060e-06,  3.661601427133474e-08, -5.833778924771333e-10,  7.861572812599836e-12, -9.358328437511680e-14,
  1.010481263558572e-15, -1.007354314279496e-17,  9.389038536233665e-20, -8.258615918539740e-22,  6.905093182329726e-24, -5.518994767560077e-26,  1.966679215775610e-05,
 -7.284991843280468e-07,  1.671505529466804e-08, -2.947287949196788e-10,  4.359644345468004e-12, -5.662276722559856e-14,  6.639151900469530e-16, -7.159301347219435e-18,
  7.194323256531450e-20, -6.803446480492615e-22,  6.100528902825538e-24, -5.217633331096863e-26,  6.464756985783539e-06, -2.740444133692307e-07,  7.018860045318826e-09,
 -1.365999601241530e-10,  2.212949661795559e-12, -3.129667641311574e-14,  3.977628098072375e-16, -4.631867215980871e-18,  5.010367494632336e-20, -5.086397665000629e-22,
  4.884304262590822e-24, -4.464016963086988e-26,  1.976746240204053e-06, -9.526608551716921e-08,  2.715144243587450e-09, -5.818060760630093e-11,  1.030163099268902e-12,
 -1.583588306544404e-14,  2.178060729710327e-16, -2.734810490076375e-18,  3.180004138741477e-20, -3.460952562473746e-22,  3.554627452683376e-24, -3.467433669554567e-26,
  5.625813186434295e-07, -3.064418102474336e-08,  9.690062072983686e-10, -2.281023593095945e-11,  4.406118204971147e-13, -7.350207707700700e-15,  1.092442021475595e-16,
 -1.477073790640741e-18,  1.843954123358534e-20, -2.149001055936027e-22,  2.358073252711765e-24, -2.452440524238957e-26,  1.491300573954288e-07, -9.133290852457371e-09,
  3.195341158312386e-10, -8.245707284162349e-12,  1.734648890993805e-13, -3.135622939906782e-15,  5.029501189042766e-17, -7.314025500081560e-19,  9.791983607572205e-21,
 -1.220741809020906e-22,  1.429677715235274e-24, -1.583785866854776e-26,  3.685229547887839e-08, -2.525691691588762e-09,  9.750795009464342e-11, -2.753035089137695e-12,
  6.297516944151392e-14, -1.231876680352793e-15,  2.129880021458043e-17, -3.327724925115402e-19,  4.773062077169658e-21, -6.359368284561929e-23,  7.942208060800435e-25,
 -9.363825849515412e-27,  8.498321961622522e-09, -6.490159792854976e-10,  2.758108860216055e-11, -8.504606795845253e-13,  2.112286580495626e-14, -4.465817285831799e-16,
  8.313926361544254e-18, -1.394237497974830e-19,  2.140594943731246e-21, -3.045472290373210e-23,  4.052803550892457e-25, -5.081575066926140e-27,  1.831092540824434e-09,
 -1.552253563074055e-10,  7.244463157180144e-12, -2.435456104283815e-13,  6.558898179330810e-15, -1.497045281134063e-16,  2.997971182747127e-18, -5.391532411256027e-20,
  8.853356602608024e-22, -1.344024888627136e-23,  1.904487297435073e-25, -2.537834424231983e-27,  3.691818694857062e-10, -3.461734283187183e-11,  1.770419576404449e-12,
 -6.478672264275929e-14,  1.889459380587880e-15, -4.650915394168049e-17,  1.000971751125471e-18, -1.928897586831014e-20,  3.385201461572937e-22, -5.479866152835815e-24,
  8.262987609737496e-26, -1.169515339341708e-27,  6.977368577469976e-11, -7.213445521098992e-12,  4.034322511316601e-13, -1.604572801992825e-14,  5.061665140049797e-16,
 -1.342337191684913e-17,  3.102183651316909e-19, -6.400780363868593e-21,  1.199764103727138e-22, -2.069664770391872e-24,  3.319061092142263e-26, -4.986932136602890e-28,
  1.238733291990165e-11, -1.407765133413293e-12,  8.593283616656926e-14, -3.709400369958559e-15,  1.264237591904320e-16, -3.608767857893777e-18,  8.948322918014773e-20,
 -1.975524468260380e-21,  3.952410767881718e-23, -7.261698609419253e-25,  1.237865515920508e-26, -1.973451822918896e-28,  2.071012905487384e-12, -2.580057842374024e-13,
  1.715765663365086e-14, -8.027178376040936e-16,  2.952630611464937e-17, -9.063894461630570e-19,  2.409605491553901e-20, -5.688211659962764e-22,  1.213995690836514e-23,
 -2.374291647290916e-25,  4.300078368056519e-27, -7.270503001411520e-29,  3.270318651254692e-13, -4.454478643072454e-14,  3.221507817511977e-15, -1.631364646045052e-16,
  6.469408383680404e-18, -2.133891051346818e-19,  6.077639311539861e-21, -1.533127502519948e-22,  3.488484343862293e-24, -7.258941397912525e-26,  1.396109623482971e-27,
 -2.502374332726949e-29,  4.894585679094575e-14, -7.271201292635270e-15,  5.709055347694083e-16, -3.125251180175372e-17,  1.334816312725500e-18, -4.726770085268989e-20,
  1.441276775495346e-21, -3.882697592106970e-23,  9.413886126652131e-25, -2.083090050703642e-26,  4.252644737885314e-28, -8.076998001008106e-30,  6.971850634349648e-15,
 -1.126904100401180e-15,  9.590072199091627e-17, -5.667888321271227e-18,  2.604589737419792e-19, -9.893522829814848e-21,  3.227315796678448e-22, -9.278928368000270e-24,
  2.395894115379795e-25, -5.634949057040656e-27,  1.220518685166188e-28, -2.455298952267380e-30,  9.497062739620634e-16, -1.666359558573765e-16,  1.534513777359341e-17,
 -9.779091076107111e-19,  4.830044516611027e-20, -1.966332937766306e-21,  6.856990765294768e-23, -2.102703176364504e-24,  5.778699055588177e-26, -1.443798968703235e-27,
  3.316297726250960e-29, -7.062913569971116e-31,  1.244248054599415e-16, -2.364448161514686e-17,  2.352272432996956e-18, -1.614296035803815e-19,  8.560697510752484e-21,
 -3.731799527318111e-22,  1.390085418317635e-23, -4.543323287179149e-25,  1.328121203835031e-26, -3.523072202152754e-28,  8.576928134275864e-30, -1.932930270691915e-31,
  1.578293644221180e-17, -3.240796833981988e-18,  3.477281005446403e-19, -2.566384070244996e-20,  1.459602617737056e-21, -6.806579359464205e-23,  2.706022913761104e-24,
 -9.419391219675889e-26,  2.926849387398619e-27, -8.237898514673531e-29,  2.124387438139775e-30, -5.063240969209851e-32,  1.953429702620733e-18, -4.323930438455156e-19,
  4.995086090071518e-20, -3.959091294492304e-21,  2.411969108816876e-22, -1.201970645625523e-23,  5.095286626079076e-25, -1.887342388996819e-26,  6.228787441981350e-28,
 -1.858821208997746e-29,  5.074192447315602e-31, -1.278175611336519e-32,  2.380375366263503e-19, -5.666035426724136e-20,  7.034313863349810e-21, -5.978335430350348e-22,
  3.896225196561491e-23, -2.072446819182559e-24,  9.357705802568965e-26, -3.684851640245884e-27,  1.290496210322990e-28, -4.079831496016550e-30,  1.177977169407246e-31,
 -3.133693651259121e-33,  2.885666393882684e-20, -7.367338228452783e-21,  9.810041065199601e-22, -8.924920064231028e-23,  6.213141139456874e-24, -3.522794924960628e-25,
  1.692207582675967e-26, -7.075889587955969e-28,  2.626887541699259e-29, -8.789088366740549e-31,  2.681577418787505e-32, -7.526754116411160e-34,  3.521944865182986e-21,
 -9.617846198292794e-22,  1.370606787681246e-22, -1.332306696161263e-23,  9.890577830460395e-25, -5.968502116027230e-26,  3.045736107671430e-27, -1.350568894911088e-28,
  5.308279416389187e-30, -1.877382857674118e-31,  6.045797154750412e-33, -1.788494582871432e-34,  4.386869970751961e-22, -1.277566953723969e-22,  1.943773982065019e-23,
 -2.014509483404335e-24,  1.591676012680814e-25, -1.020436879430050e-26,  5.522606041983363e-28, -2.592847210397616e-29,  1.077298253411038e-30, -4.021664245877915e-32,
  1.365083212074168e-33, -4.250370320135576e-35,  5.662501547998344e-23, -1.752898633546780e-23,  2.839677669639702e-24, -3.130156374314547e-25,  2.626285458820840e-26,
 -1.785034781342707e-27,  1.022520608439556e-28, -5.073319924998711e-30,  2.224273322974729e-31, -8.749323208816445e-33,  3.125018941413526e-34, -1.022462167314538e-35,
  7.704157649193133e-24, -2.526058693359398e-24,  4.343844258367271e-25, -5.078390000034738e-26,  4.512879522880974e-27, -3.243815091859419e-28,  1.962119705569883e-29,
 -1.026488129441860e-30,  4.738555283614553e-32, -1.959933786347518e-33,  7.351341614304875e-35, -2.522519702577647e-36,  1.125520932115915e-24, -3.893492365474662e-25,
  7.082335413275600e-26, -8.753404029999117e-27,  8.213502399005503e-28, -6.225349361104247e-29,  3.965212083551567e-30, -2.181419240865160e-31,  1.057558760556477e-32,
 -4.587995437828480e-34,  1.802776691604570e-35, -6.472294595867279e-37,  1.800712778339407e-25, -6.543784136650978e-26,  1.254165469997739e-26, -1.632612621334343e-27,
  1.611807486868910e-28, -1.283808764747883e-29,  8.582444226298039e-31, -4.949397173232060e-32,  2.512233197168236e-33, -1.139753179063631e-34,  4.678102970054358e-36,
 -1.752321707826698e-37,  3.219161759487716e-26, -1.223155481304202e-26,  2.458960539808126e-27, -3.356970864448444e-28,  3.472711603908130e-29, -2.895240550563194e-30,
  2.023663497197589e-31, -1.218810426664195e-32,  6.453905193844845e-34, -3.051315585380734e-35,  1.303793775973094e-36, -5.078579285869776e-38,  6.556178300091360e-27,
 -2.591315614287124e-27,  5.436841066435104e-28, -7.746257300714360e-29,  8.357076595582264e-30, -7.259621948283835e-31,  5.281850229811221e-32, -3.308053141285789e-33,
  1.819795443209344e-34, -8.929668334621954e-36,  3.956408251187554e-37, -1.596430621923733e-38,  1.546301995232408e-27, -6.322591031863823e-28,  1.376702913394056e-28,
 -2.035859987083685e-29,  2.278392050132689e-30, -2.051508535420756e-31,  1.545853746346530e-32, -1.001862836670900e-33,  5.698289762537418e-35, -2.888569187635823e-36,
  1.321058277730260e-37, -5.497536748096176e-39,  4.263612250301139e-28, -1.792856461185846e-28,  4.026487184094677e-29, -6.142475205064144e-30,  7.088379183006607e-31,
 -6.577282882837746e-32,  5.103868179883656e-33, -3.404017962912065e-34,  1.991019822315769e-35, -1.037195581651372e-36,  4.871384287603955e-38, -2.080339705559144e-39,
  1.365524782842759e-28, -5.868465335606369e-29,  1.350301714568929e-29, -2.110843956821873e-30,  2.495359873294221e-31, -2.370839175224537e-32,  1.882760389633359e-33,
 -1.284369412235376e-34,  7.679586826734278e-36, -4.087440687538050e-37,  1.960381238806492e-38, -8.544158730257382e-40,  4.834846120755706e-29, -2.109772045516094e-29,
  4.938145426172954e-30, -7.853862912577042e-31,  9.444211970878198e-32, -9.124292760453321e-33,  7.365407630017314e-34, -5.105398894095938e-35,  3.100614697494777e-36,
 -1.675580841047115e-37,  8.156334433294015e-39, -3.606504699401273e-40,  1.492217001166218e-29, -6.567469535385425e-30,  1.552035189530764e-30, -2.492538230339673e-31,
  3.026198614033390e-32, -2.951386608993366e-33,  2.404526218114799e-34, -1.681801843831331e-35,  1.030412419092501e-36, -5.616338110204237e-38,  2.756864264251795e-39,
 -1.228963064604931e-40,  4.862348400675594e-02, -9.680710236173959e-05,  1.979998090248878e-07, -4.147355239754114e-10,  8.857039784701463e-13, -1.921063011560940e-15,
  4.210710638707331e-18, -9.310102311551666e-21,  2.064697921149415e-23, -4.606918725476505e-26,  1.023183745577453e-28, -2.296529674901234e-31,  4.506935665503251e-02,
 -1.033662823972114e-04,  2.787186765189318e-07, -8.004557829260715e-10,  2.322055507793485e-12, -6.675147720647252e-15,  1.891812686743251e-17, -5.287364916822247e-20,
  1.458641205860657e-22, -3.980008713608046e-25,  1.074651822113364e-27, -2.877791191119339e-30,  3.872157291688213e-02, -1.122783102701966e-04,  4.138528920737293e-07,
 -1.530731112914782e-09,  5.454676039312823e-12, -1.877647015350946e-14,  6.284855317742162e-17, -2.055996645906309e-19,  6.596482102473617e-22, -2.081121824174993e-24,
  6.468428737994723e-27, -1.983899453799811e-29,  3.083637464144667e-02, -1.175325715929514e-04,  5.595853232094218e-07, -2.495397859582560e-09,  1.045592247704181e-11,
 -4.185071973070096e-14,  1.616240699023672e-16, -6.059992590833424e-19,  2.215601272299180e-21, -7.924696836182589e-24,  2.780127872091418e-26, -9.585780176700942e-29,
  2.276231330113843e-02, -1.145461101194963e-04,  6.696418950114167e-07, -3.499351035259817e-09,  1.695653193848703e-11, -7.780295785897285e-14,  3.418574776050938e-16,
 -1.449026645825464e-18,  5.956839644142717e-21, -2.384649785387252e-23,  9.325805017276534e-26, -3.571873972945430e-28,  1.557466497725212e-02, -1.022673187539925e-04,
  7.112963866233047e-07, -4.297813975224732e-09,  2.383103821207939e-11, -1.240241802171070e-13,  6.135991783730653e-16, -2.911157411216673e-18,  1.332937164246596e-20,
 -5.918290437577959e-23,  2.557681306122470e-25, -1.079052245537970e-27,  9.878251274483215e-03, -8.316375326367987e-05,  6.756283245376504e-07, -4.680356707643939e-09,
  2.944735468386120e-11, -1.723766217740098e-13,  9.526800944006544e-16, -5.021438734703893e-18,  2.542626004604023e-20, -1.243601730787320e-22,  5.900178783937288e-25,
 -2.724513002467603e-27,  5.807842129588180e-03, -6.154375374823419e-05,  5.775591712044380e-07, -4.556451335453740e-09,  3.230065340741217e-11, -2.112614155702142e-13,
  1.296218468401877e-15, -7.545827071088650e-18,  4.201829955471934e-20, -2.251732418078122e-22,  1.166779326312793e-24, -5.867731362973552e-27,  3.165507065953610e-03,
 -4.149146704511559e-05,  4.465059717831798e-07, -3.988304861943710e-09,  3.166997729907968e-11, -2.301912917141966e-13,  1.560086335417917e-15, -9.982874537865519e-18,
  6.085445085041292e-20, -3.557621863727053e-22,  2.004934995631698e-24, -1.093658135702567e-26,  1.599535072501008e-03, -2.552848635856414e-05,  3.133219899810061e-07,
 -3.152423643837972e-09,  2.790298265174243e-11, -2.243783036353648e-13,  1.672738084012132e-15, -1.171920094421523e-17,  7.791232737514268e-20, -4.951054146979631e-22,
  3.024131537757996e-24, -1.783310032063120e-26,  7.493842727466564e-04, -1.436165210779758e-05,  2.001351606326094e-07, -2.257806273592978e-09,  2.218382312033427e-11,
 -1.966137839842513e-13,  1.606633424825342e-15, -1.228299567215424e-17,  8.877864127953631e-20, -6.113744709846686e-22,  4.035582306491366e-24, -2.565393731820714e-26,
  3.255568050635094e-04, -7.400844318837542e-06,  1.166342721229784e-07, -1.469409318621456e-09,  1.596933458029054e-11, -1.554903163349490e-13,  1.388518124422484e-15,
 -1.155107324536333e-17,  9.052112549351681e-20, -6.738054805216212e-22,  4.794587578820883e-24, -3.277780876219809e-26,  1.311678288182902e-04, -3.499251565450250e-06,
  6.213622666576204e-08, -8.710745308166207e-10,  1.043864363180028e-11, -1.113465749256793e-13,  1.083770321511280e-15, -9.786488391023807e-18,  8.295992556798597e-20,
 -6.660002344664469e-22,  5.097798916327444e-24, -3.740231861669190e-26,  4.902219891045009e-05, -1.520338008925922e-06,  3.031244579603970e-08, -4.713385114013213e-10,
  6.211220461165658e-12, -7.240261384204230e-14,  7.663695930717097e-16, -7.495854042683806e-18,  6.859627276960962e-20, -5.927787242953820e-22,  4.871818708719954e-24,
 -3.829317754197453e-26,  1.699940424237102e-05, -6.078206631085877e-07,  1.356209340258383e-08, -2.332321330848083e-10,  3.371545584033603e-12, -4.285523324716039e-14,
  4.923147319113077e-16, -5.206053432437334e-18,  5.134063668081005e-20, -4.767729037294852e-22,  4.200519807165448e-24, -3.531637795853199e-26,  5.471290543108688e-06,
 -2.238928162827017e-07,  5.573014950014482e-09, -1.057225910492048e-10,  1.672843293002855e-12, -2.314116214261695e-14,  2.880123157505413e-16, -3.287354663050178e-18,
  3.488201294898732e-20, -3.475946514738413e-22,  3.278297758180713e-24, -2.944274387238717e-26,  1.635068503630897e-06, -7.607974299994162e-08,  2.106274478744358e-09,
 -4.397182515977637e-11,  7.600651199539005e-13, -1.142304525019645e-14,  1.537843453329571e-16, -1.891850017837836e-18,  2.157014731813729e-20, -2.303490611968948e-22,
  2.322799897833782e-24, -2.225797172320146e-26,  4.539306672333185e-07, -2.387748831460851e-08,  7.331566998155305e-10, -1.680697328422432e-11,  3.167927475717121e-13,
 -5.164512568279427e-15,  7.510251358810022e-17, -9.945081179174903e-19,  1.216925482180436e-20, -1.391125888630020e-22,  1.498210899103786e-24, -1.530174434599979e-26,
  1.171435902936254e-07, -6.930001624427508e-09,  2.353635948737496e-10, -5.912758339079975e-12,  1.213315087503677e-13, -2.142583492850901e-15,  3.361332026157125e-17,
 -4.785705185625803e-19,  6.278098066388297e-21, -7.674760020536509e-23,  8.819417961403279e-25, -9.591957165344582e-27,  2.812234855295792e-08, -1.862351093107090e-09,
  6.978610917543205e-11, -1.917641575921410e-12,  4.277558074254643e-14, -8.171722438952376e-16,  1.381478085623180e-17, -2.112582102860115e-19,  2.968322615553330e-21,
 -3.877015008966237e-23,  4.749825289718690e-25, -5.496637681759212e-27,  6.286217996583119e-09, -4.640583983042238e-10,  1.914041194292490e-11, -5.743065543051853e-13,
  1.390644012190947e-14, -2.870646269193147e-16,  5.224230667292987e-18, -8.572892984976031e-20,  1.289062328424247e-21, -1.797500780752254e-23,  2.346028934283232e-25,
 -2.886685347041917e-27,  1.309840812847050e-09, -1.073803048704068e-10,  4.864153174758064e-12, -1.591075363622096e-13,  4.176864090434480e-15, -9.306685425503122e-17,
  1.821572441997749e-18, -3.204993465573004e-20,  5.153415103656275e-22, -7.666481367982772e-24,  1.065272174968708e-25, -1.392848268410440e-27,  2.547574369841172e-10,
 -2.311285934356442e-11,  1.147445660994097e-12, -4.085530706454360e-14,  1.161390559326701e-15, -2.790458332220072e-17,  5.869043735676782e-19, -1.106363942672041e-20,
  1.901048566230408e-22, -3.015292879123822e-24,  4.458021388628750e-26, -6.190476690343017e-28,  4.632578810167845e-11, -4.636554156310742e-12,  2.517769719318390e-13,
 -9.744208281052935e-15,  2.996147214426725e-16, -7.755605258235432e-18,  1.751496571620030e-19, -3.535029882042358e-21,  6.487082091464898e-23, -1.096422805139918e-24,
  1.723906423793245e-26, -2.541102460319899e-28,  7.891450487781838e-12, -8.687775332815741e-13,  5.150709220711499e-14, -2.163851517145791e-15,  7.189122207088253e-17,
 -2.003144712778984e-18,  4.853931310749107e-20, -1.048231961798992e-21,  2.053202405718987e-23, -3.696003823533274e-25,  6.177147099240699e-27, -9.661227884160547e-29,
  1.262255232815462e-12, -1.524413982887840e-13,  9.850038360300915e-15, -4.486140067522939e-16,  1.608871199001626e-17, -4.821596040987434e-19,  1.252751635687770e-20,
 -2.893037326691506e-22,  6.045348986836073e-24, -1.158486979015063e-25,  2.057219791317294e-27, -3.412612958649036e-29,  1.901121030284852e-13, -2.512287815924143e-14,
  1.766266359609721e-15, -8.710305896434180e-17,  3.368741645564799e-18, -1.085011936052312e-19,  3.020789027420999e-21, -7.455779807385228e-23,  1.661272544484497e-24,
 -3.387577438074098e-26,  6.389088317284171e-28, -1.123685825066842e-29,  2.705160167187036e-14, -3.902257982435545e-15,  2.980292166713723e-16, -1.589509234490904e-17,
  6.623393080702976e-19, -2.290961429555398e-20,  6.830334971252752e-22, -1.800792861018981e-23,  4.276478905797015e-25, -9.275327352188653e-27,  1.857255091703015e-28,
 -3.461952322694800e-30,  3.651051992854943e-15, -5.735987818185146e-16,  4.751513281416273e-17, -2.737521986056109e-18,  1.227892362920673e-19, -4.557675942429469e-21,
  1.454232219776841e-22, -4.093272275106917e-24,  1.035529744163334e-25, -2.387900778671651e-27,  5.074391077089558e-29, -1.002122491770793e-30,  4.695969602824926e-16,
 -8.017067663883197e-17,  7.192103991409292e-18, -4.470942556560592e-19,  2.156681047198221e-20, -8.583908286101397e-22,  2.929292972480191e-23, -8.797797327267170e-25,
  2.369860905526302e-26, -5.807598007519355e-28,  1.309228045835345e-29, -2.738270565357638e-31,  5.787985002953334e-17, -1.071430162797699e-17,  1.039338303669698e-18,
 -6.963147360041025e-20,  3.608804534904744e-21, -1.538985025557207e-22,  5.613138064832416e-24, -1.797772790895322e-25,  5.153624124861624e-27, -1.341529572067802e-28,
  3.206865013493048e-30, -7.100479308672953e-32,  6.881276494942542e-18, -1.378144098495646e-18,  1.443324737012344e-19, -1.040847757949717e-20,  5.790018299558344e-22,
 -2.643346694503909e-23,  1.029674186969278e-24, -3.514511131805222e-26,  1.071564998955396e-27, -2.961341714223866e-29,  7.502680176211712e-31, -1.757788276635020e-32,
  7.952304752730076e-19, -1.719214903243228e-19,  1.940765802349424e-20, -1.504553501940081e-21,  8.973544013849908e-23, -4.381630366901804e-24,  1.821373987115982e-25,
 -6.620348855471398e-27,  2.145456017624805e-28, -6.290774812325605e-30,  1.688220828172425e-31, -4.182963910561242e-33,  9.013891495583824e-20, -2.098670773261974e-20,
  2.549265628524100e-21, -2.121535625684213e-22,  1.355029908975574e-23, -7.069052337458019e-25,  3.132808997491636e-26, -1.211606146991455e-27,  4.170075439355610e-29,
 -1.296357466967207e-30,  3.682539612712078e-32, -9.643172585389785e-34,  1.012709156693644e-20, -2.533005256597169e-21,  3.304663899380531e-22, -2.947727104882245e-23,
  2.013441548380238e-24, -1.120899070635796e-25,  5.290195499890166e-27, -2.174734597412825e-28,  7.941889104481392e-30, -2.615270996237704e-31,  7.857279278529173e-33,
 -2.172757590545839e-34,  1.141528446183764e-21, -3.059161324624866e-22,  4.277831247588659e-23, -4.082688150963025e-24,  2.977654347250845e-25, -1.766457204673255e-26,
  8.866983210433042e-28, -3.869825056130301e-29,  1.497784368395577e-30, -5.218973744152255e-32,  1.656629732426492e-33, -4.832793057249306e-35,  1.309119225302159e-22,
 -3.748027162470421e-23,  5.604756473915740e-24, -5.711757232276186e-25,  4.440030055435458e-26, -2.802146236805386e-27,  1.493672418054017e-28, -6.910604370951251e-30,
  2.830816144571927e-31, -1.042353642115708e-32,  3.491306063407333e-34, -1.073146521967607e-35,  1.551864517224857e-23, -4.731571367555065e-24,  7.546775776865794e-25,
 -8.193244453966546e-26,  6.773825359948008e-27, -4.538913286525785e-28,  2.564459563389557e-29, -1.255541561772370e-30,  5.434113795969394e-32, -2.111026864218339e-33,
  7.449351650887572e-35, -2.408945327440480e-36,  1.935723564860576e-24, -6.263225463724482e-25,  1.062340072123728e-25, -1.225361636348505e-26,  1.074758067983357e-27,
 -7.628018244231807e-29,  4.557822382858075e-30, -2.356315363072888e-31,  1.075317777127199e-32, -4.398450882579582e-34,  1.632078369161294e-35, -5.542101365951766e-37,
  2.591021230710681e-25, -8.862138812734659e-26,  1.593050798197152e-26, -1.946094352858543e-27,  1.805453506493037e-28, -1.353450987685599e-29,  8.529354581157636e-31,
 -4.644145793061153e-32,  2.229095361791458e-33, -9.577211080703947e-35,  3.728022377651834e-36, -1.326312109165634e-37,  3.801035867129433e-26, -1.368389159405542e-26,
  2.596701706461327e-27, -3.347251003571351e-28,  3.273132394017388e-29, -2.582957778723075e-30,  1.711266920165947e-31, -9.782949639303531e-33,  4.923855339495458e-34,
 -2.215626717336808e-35,  9.022025580341786e-37, -3.353568112114595e-38,  6.246588640610303e-27, -2.355714682603982e-27,  4.697922880760199e-28, -6.362741252245658e-29,
  6.531132968679701e-30, -5.404085638246525e-31,  3.749654343996966e-32, -2.242338092774452e-33,  1.179216637887578e-34, -5.538027872537363e-36,  2.351047691202264e-37,
 -9.100590477403022e-39,  1.174893478642123e-27, -4.617224486807864e-28,  9.627590993550977e-29, -1.363284017564810e-29,  1.461941551240978e-30, -1.262528768717793e-31,
  9.133532314592798e-33, -5.688846437774889e-34,  3.112758682939914e-35, -1.519495136735012e-36,  6.698441602046094e-38, -2.689686597467000e-39,  2.576988042182028e-28,
 -1.049369405775497e-28,  2.274697032644553e-29, -3.348762371325562e-30,  3.731269959880090e-31, -3.345357591466823e-32,  2.510330663768793e-33, -1.620379522306669e-34,
  9.180171093749118e-36, -4.635934144879828e-37,  2.112387588961104e-38, -8.759274944800844e-40,  6.670695931690801e-29, -2.797450053538846e-29,  6.263911822607741e-30,
 -9.527154426029936e-31,  1.096202598445828e-31, -1.014252075864296e-32,  7.848528026972594e-34, -5.220406854977520e-35,  3.045410413747851e-36, -1.582420385328793e-37,
  7.413731625373668e-39, -3.158465071771001e-40,  2.029758453834428e-29, -8.709308564220327e-30,  2.000449774476463e-30, -3.121670798128291e-31,  3.683924663965978e-32,
 -3.494166930157163e-33,  2.770254718989069e-34, -1.886762442291259e-35,  1.126385754001400e-36, -5.986070443329119e-38,  2.866754595959663e-39, -1.247666940691724e-40,
  6.924975849780095e-30, -3.019530500177542e-30,  7.061486292461661e-31, -1.122123684346166e-31,  1.348196719944872e-32, -1.301440852999303e-33,  1.049707195639597e-34,
 -7.270361346289983e-36,  4.412023554801977e-37, -2.382471763893159e-38,  1.158879336792351e-39, -5.120585925228957e-41,  2.092417270729122e-30, -9.206287791738575e-31,
  2.174909176014556e-31, -3.491660958735918e-32,  4.237788288661877e-33, -4.131631041973487e-34,  3.364968360750964e-35, -2.352799607943975e-36,  1.441061475693827e-37,
 -7.852150930490630e-39,  3.853162984403972e-40, -1.717158578088405e-41,  };
  int offset = -48;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 48;
    if (std::isnan(t)) {
      fill_n(rr+offset, 48, 0.5);
      fill_n(ww+offset, 48, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 48; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=48; ++j) {
        const int boxof = it*576+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
