/*
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co., Ltd.
 *
 * Author:     max-lv<lvwujun@uniontech.com>
 *
 * Maintainer: dengkeyun<dengkeyun@uniontech.com>
 *             xushitong<xushitong@uniontech.com>
 *             zhangsheng<zhangsheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef DFMREGULAREXPRESSION_H
#define DFMREGULAREXPRESSION_H

#include <QString>

// Backport some static function.
// This class should be removed after dropping support for old Qt version.

class DFMRegularExpression
{
public:
    static QString checkWildcardAndToRegularExpression(const QString &pattern);
    static QString wildcardToRegularExpression(const QString &pattern);
    static inline QString anchoredPattern(const QString &expression) {
        return QLatin1String("\\A(?:")
               + expression
               + QLatin1String(")\\z");
    }
};

#endif // DFMREGULAREXPRESSION_H
