# opencv-mobile

![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)
![release](https://github.com/nihui/opencv-mobile/workflows/release/badge.svg)
![download](https://img.shields.io/github/downloads/nihui/opencv-mobile/total.svg)

✔️ This project provides the minimal build of opencv library for the **Android**, **iOS** and **ARM Linux** platforms.

✔️ Packages for **Windows**, **Linux**, **MacOS** and **WebAssembly** are available now.

✔️ We provide prebuild binary packages for opencv **2.4.13.7**, **3.4.16** and **4.5.4**.

✔️ We also provide prebuild binary package for **iOS with bitcode enabled**, that the official package lacks.

✔️ All the binaries are compiled from source on github action, **no virus**, **no backdoor**, **no secret code**.

|opencv 4.5.4 android|package size|
|---|---|
|The official opencv|235MB|
|opencv-mobile|16.1MB|

|opencv 4.5.4 ios|package size|
|---|---|
|The official opencv|183MB|
|opencv-mobile|15.4MB|

|opencv 4.5.4 ios with bitcode|package size|
|---|---|
|The official opencv|missing :(|
|opencv-mobile|53.7MB|

# Download

## Android

(armeabi-v7a, arm64-v8a, x86, x86_64) build with ndk r21d and android api 24.

* [opencv-mobile-2.4.13.7-android.zip (7.87MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-android.zip)
* [opencv-mobile-3.4.16-android.zip (15.3MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-android.zip)
* [opencv-mobile-4.5.4-android.zip (16.1MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-android.zip)

## iOS

(armv7, arm64, arm64e, i386, x86_64) build with Xcode 12.4.

* [opencv-mobile-2.4.13.7-ios.zip (9.88MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-ios.zip)
* [opencv-mobile-3.4.16-ios.zip (14.7MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-ios.zip)
* [opencv-mobile-4.5.4-ios.zip (15.4MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-ios.zip)

## iOS with bitcode

(armv7, arm64, arm64e, i386, x86_64) build with Xcode 12.4.

* [opencv-mobile-2.4.13.7-ios-bitcode.zip (35.5MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-ios-bitcode.zip)
* [opencv-mobile-3.4.16-ios-bitcode.zip (51.3MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-ios-bitcode.zip)
* [opencv-mobile-4.5.4-ios-bitcode.zip (53.7MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-ios-bitcode.zip)

## ARM Linux

(arm-linux-gnueabi, arm-linux-gnueabihf, aarch64-linux-gnu) build with ubuntu cross compiler.

* [opencv-mobile-2.4.13.7-armlinux.zip (8.01MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-armlinux.zip)
* [opencv-mobile-3.4.16-armlinux.zip (14.3MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-armlinux.zip)
* [opencv-mobile-4.5.4-armlinux.zip (15.3MB)](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-armlinux.zip)

## Windows

(x86, x64) build with VS2015, VS2017 and VS2019.

* [opencv-mobile-2.4.13.7-windows-vs2015.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-windows-vs2015.zip)
* [opencv-mobile-2.4.13.7-windows-vs2017.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-windows-vs2017.zip)
* [opencv-mobile-2.4.13.7-windows-vs2019.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-windows-vs2019.zip)
* [opencv-mobile-3.4.16-windows-vs2015.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-windows-vs2015.zip)
* [opencv-mobile-3.4.16-windows-vs2017.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-windows-vs2017.zip)
* [opencv-mobile-3.4.16-windows-vs2019.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-windows-vs2019.zip)
* [opencv-mobile-4.5.4-windows-vs2015.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-windows-vs2015.zip)
* [opencv-mobile-4.5.4-windows-vs2017.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-windows-vs2017.zip)
* [opencv-mobile-4.5.4-windows-vs2019.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-windows-vs2019.zip)

## Linux

(x86_64) build on Ubuntu-18.04 and 20.04.

* [opencv-mobile-2.4.13.7-ubuntu-1804.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-ubuntu-1804.zip)
* [opencv-mobile-2.4.13.7-ubuntu-2004.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-ubuntu-2004.zip)
* [opencv-mobile-3.4.16-ubuntu-1804.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-ubuntu-1804.zip)
* [opencv-mobile-3.4.16-ubuntu-2004.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-ubuntu-2004.zip)
* [opencv-mobile-4.5.4-ubuntu-1804.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-ubuntu-1804.zip)
* [opencv-mobile-4.5.4-ubuntu-2004.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-ubuntu-2004.zip)

## MacOS

(x86_64, arm64) build with Xcode 12.4.

* [opencv-mobile-2.4.13.7-macos.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-macos.zip)
* [opencv-mobile-3.4.16-macos.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-macos.zip)
* [opencv-mobile-4.5.4-macos.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-macos.zip)

## WebAssembly

(basic, simd, threads, simd+threads) build with Emscripten 2.0.8.

* [opencv-mobile-2.4.13.7-webassembly.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-2.4.13.7-webassembly.zip)
* [opencv-mobile-3.4.16-webassembly.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-3.4.16-webassembly.zip)
* [opencv-mobile-4.5.4-webassembly.zip](https://github.com/nihui/opencv-mobile/releases/download/v14/opencv-mobile-4.5.4-webassembly.zip)

# Usage Android

1. Extract archive to ```<project dir>/app/src/main/jni/```
2. Modify ```<project dir>/app/src/main/jni/CMakeListst.txt``` to find and link opencv

```cmake
set(OpenCV_DIR ${CMAKE_SOURCE_DIR}/opencv-mobile-4.5.4-android/sdk/native/jni)
find_package(OpenCV REQUIRED)

target_link_libraries(your_jni_target ${OpenCV_LIBS})
```

# Usage iOS and MacOS

1. Extract archive, and drag ```opencv2.framework``` into your project

# Usage ARM Linux, Windows, Linux, WebAssembly

1. Extract archive to ```<project dir>/```
2. Modify ```<project dir>/CMakeListst.txt``` to find and link opencv

```cmake
set(OpenCV_DIR ${CMAKE_SOURCE_DIR}/opencv-mobile-4.5.4-armlinux/arm-linux-gnueabihf/lib/cmake/opencv4)
find_package(OpenCV REQUIRED)

target_link_libraries(your_target ${OpenCV_LIBS})
```

# How-to-build your custom package

**step 1. download opencv source**
  ```shell
  wget -q https://github.com/opencv/opencv/archive/4.5.4.zip -O opencv-4.5.4.zip
  unzip -q opencv-4.5.4.zip
  cd opencv-4.5.4
  ```

**step 2. strip zlib dependency and use stb-based highgui implementation (optional)**
  ```shell
  patch -p1 -i ../opencv-4.5.4-no-zlib.patch
  truncate -s 0 cmake/OpenCVFindLibsGrfmt.cmake
  rm -rf modules/gapi
  rm -rf modules/highgui
  cp -r ../highgui modules/
  ```

**step 3. patch opencv source for no-rtti build (optional)**
  ```shell
  patch -p1 -i ../opencv-4.5.4-no-rtti.patch
  ```

**step 4. apply your opencv options to opencv4_cmake_options.txt**

**step 5. build your opencv package with cmake**
  ```shell
  mkdir -p build
  cd build
  cmake -DCMAKE_INSTALL_PREFIX=install \
    -DCMAKE_BUILD_TYPE=Release \
    `cat ../../opencv4_cmake_options.txt` \
    -DBUILD_opencv_world=OFF ..
  ```

**step 6. make a package**
  ```shell
  zip -r -9 opencv-mobile-4.5.4.zip install
  ```

# Some notes

* The minimal opencv build contains most basic opencv operators and common image processing functions, with some handy additions like keypoint feature extraction and matching, image inpainting and opticalflow estimation.

* Many computer vision algorithms that reside in dedicated modules are discarded, such as face detection etc. [You could try deep-learning based algorithms with nerual network inference library optimized for mobile.](https://github.com/Tencent/ncnn)

* Image IO functions in highgui module, like ```cv::imread``` and ```cv::imwrite```, are re-implemented using [stb](https://github.com/nothings/stb) for smaller code size. GUI functions, like ```cv::imshow```, are discarded.

* cuda and opencl are disabled because there is no cuda on mobile, no opencl on ios, and opencl on android is slow. opencv on gpu is not suitable for real productions. Write metal on ios and opengles/vulkan on android if you need good gpu acceleration.

* C++ RTTI and exceptions are disabled for minimal build on mobile platforms and webassembly build. Be careful when you write ```cv::Mat roi = image(roirect);```  :P

# opencv modules included

|module|comment|
|---|---|
|opencv_core|Mat, matrix operations, etc|
|opencv_imgproc|resize, cvtColor, warpAffine, etc|
|opencv_highgui|imread, imwrite|
|opencv_features2d|keypoint feature and matcher, etc (not included in opencv 2.x package)|
|opencv_photo|inpaint, etc|
|opencv_video|opticalflow, etc|

# opencv modules discarded

|module|comment|
|---|---|
|opencv_androidcamera|use android Camera api instead|
|opencv_calib3d|camera calibration, rare uses on mobile|
|opencv_contrib|experimental functions, build part of the source externally if you need|
|opencv_dnn|very slow on mobile, try ncnn for nerual network inference on mobile|
|opencv_dynamicuda|no cuda on mobile|
|opencv_flann|feature matching, rare uses on mobile, build the source externally if you need|
|opencv_gapi|graph based image processing, little gain on mobile|
|opencv_gpu|no cuda/opencl on mobile|
|opencv_imgcodecs|link with opencv_highgui instead|
|opencv_java|wrap your c++ code with jni|
|opencv_js|write native code on mobile|
|opencv_lagacy|various good-old cv routines, build part of the source externally if you need|
|opencv_ml|train your ML algorithm on powerful pc or server|
|opencv_nonfree|the SIFT and SURF, use ORB which is faster and better|
|opencv_objdetect|HOG, cascade detector, use deep learning detector which is faster and better|
|opencv_ocl|no opencl on mobile|
|opencv_python|no python on mobile|
|opencv_shape|shape matching, rare uses on mobile, build the source externally if you need|
|opencv_stitching|image stitching, rare uses on mobile, build the source externally if you need|
|opencv_superres|do video super-resolution on powerful pc or server|
|opencv_ts|test modules, useless in production anyway|
|opencv_videoio|use android MediaCodec or ios AVFoundation api instead|
|opencv_videostab|do video stablization on powerful pc or server|
|opencv_viz|vtk is not available on mobile, write your own data visualization routines|


