@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-association-delete: Delete Association
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;

my %opt = ( gateway => undef, version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  gateway=s
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

my $associationName = $ARGV[0];

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 0, -msg => "No association-name specified!\n" ) if not($associationName);

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

# If no Gateway is specified then use the default Gateway
$opt{gateway} = $controlChannel->getGatewayName()->result if ( not $opt{gateway} );

# Delete the association
$controlChannel->deleteAssociation( $token, $opt{gateway}, $associationName );

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-association-delete - Delete Association

=head1 SYNOPSIS

B<ecaccess-association-delete -version|-help|-manual>

B<ecaccess-association-delete [-debug] [-gateway> I<name>B<]> I<association-name>

=head1 DESCRIPTION

Allow deleting an ECtrans Association. Once deleted the Association can not be retrieved. The History
associated with this Association will also be removed from the ECaccess Gateway Database.

=head1 ARGUMENTS

=over 8

=item I<association-name>

The name of the Association to delete.

=back

=head1 OPTIONS

=over 8

=item B<-gateway> I<name>

This is the name of the ECaccess Gateway where the Association is installed.
It is by default the Gateway you are connected to. In order to get the name
of your current Gateway you can use the B<ecaccess-gateway-name> command. When
using the commands at ECMWF the default Gateway is always "ecaccess.ecmwf.int".

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-association-delete -gateway> I<ecaccess.ecmwf.int> I<test>

Remove the I<test> Association on the I<ecaccess.ecmwf.int> Gateway.

B<ecaccess-association-delete> I<test2>

Remove the I<test2> Association on the default Gateway.

=head1 SEE ALSO

B<ecaccess-association-get>, B<ecaccess-association-list>, B<ecaccess-association-protocol>,
B<ecaccess-association-put> and B<ecaccess>.

=cut

__END__
:endofperl
