/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.LazyFileOutputStream;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionEventSupport;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractWagon
implements Wagon {
    protected static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Repository repository;
    protected SessionEventSupport sessionEventSupport = new SessionEventSupport();
    protected TransferEventSupport transferEventSupport = new TransferEventSupport();
    protected ProxyInfo proxyInfo;
    protected AuthenticationInfo authenticationInfo;
    protected boolean interactive = true;

    public Repository getRepository() {
        return this.repository;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public void connect(Repository repository) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, null);
    }

    public void connect(Repository repository, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfo);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, authenticationInfo, null);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        if (repository == null) {
            throw new IllegalStateException("The repository specified cannot be null.");
        }
        this.repository = repository;
        if (authenticationInfo == null) {
            authenticationInfo = new AuthenticationInfo();
        }
        if (authenticationInfo.getUserName() == null && repository.getUsername() != null) {
            authenticationInfo.setUserName(repository.getUsername());
            if (repository.getPassword() != null && authenticationInfo.getPassword() == null) {
                authenticationInfo.setPassword(repository.getPassword());
            }
        }
        this.authenticationInfo = authenticationInfo;
        this.proxyInfo = proxyInfo;
        this.fireSessionOpening();
        this.openConnection();
        this.fireSessionOpened();
    }

    public void disconnect() throws ConnectionException {
        this.fireSessionDisconnecting();
        this.closeConnection();
        this.fireSessionDisconnected();
    }

    protected abstract void closeConnection() throws ConnectionException;

    protected void createParentDirectories(File destination) throws TransferFailedException {
        File destinationDirectory = destination.getParentFile();
        if (destinationDirectory != null && !destinationDirectory.exists() && !destinationDirectory.mkdirs()) {
            throw new TransferFailedException("Specified destination directory cannot be created: " + destinationDirectory);
        }
    }

    protected void getTransfer(Resource resource, File destination, InputStream input) throws TransferFailedException {
        this.getTransfer(resource, destination, input, true, Integer.MAX_VALUE);
    }

    protected void getTransfer(Resource resource, File destination, InputStream input, boolean closeInput, int maxSize) throws TransferFailedException {
        this.fireTransferDebug("attempting to create parent directories for destination: " + destination.getName());
        this.createParentDirectories(destination);
        this.fireGetStarted(resource, destination);
        LazyFileOutputStream output = new LazyFileOutputStream(destination);
        try {
            this.transfer(resource, input, output, 5, maxSize);
        }
        catch (IOException e) {
            boolean deleted;
            this.fireTransferError(resource, e, 5);
            if (destination.exists() && !(deleted = destination.delete())) {
                destination.deleteOnExit();
            }
            String msg = "GET request of: " + resource.getName() + " from " + this.repository.getName() + " failed";
            throw new TransferFailedException(msg, e);
        }
        finally {
            if (closeInput) {
                IOUtil.close(input);
            }
            IOUtil.close(output);
        }
        this.fireGetCompleted(resource, destination);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void putTransfer(Resource resource, File source, OutputStream output, boolean closeOutput) throws TransferFailedException {
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.firePutStarted(resource, source);
        FileInputStream input = null;
        try {
            input = new FileInputStream(source);
            this.transfer(resource, input, output, 6);
        }
        catch (FileNotFoundException e) {
            try {
                throw new TransferFailedException("Specified source file does not exist: " + source, e);
                catch (IOException e2) {
                    this.fireTransferError(resource, e2, 6);
                    String msg = "PUT request for: " + resource + " to " + source.getName() + "failed";
                    throw new TransferFailedException(msg, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(input);
                if (closeOutput) {
                    IOUtil.close(output);
                }
                throw throwable;
            }
        }
        IOUtil.close(input);
        if (closeOutput) {
            IOUtil.close(output);
        }
        this.firePutCompleted(resource, source);
    }

    protected void transfer(Resource resource, InputStream input, OutputStream output, int requestType) throws IOException {
        this.transfer(resource, input, output, requestType, Integer.MAX_VALUE);
    }

    protected void transfer(Resource resource, InputStream input, OutputStream output, int requestType, int maxSize) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 3, requestType);
        for (int remaining = maxSize; remaining > 0 && (n = input.read(buffer, 0, Math.min(buffer.length, remaining))) != -1; remaining -= n) {
            this.fireTransferProgress(transferEvent, buffer, n);
            output.write(buffer, 0, n);
        }
    }

    protected void fireTransferProgress(TransferEvent transferEvent, byte[] buffer, int n) {
        this.transferEventSupport.fireTransferProgress(transferEvent, buffer, n);
    }

    protected void fireGetCompleted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 2, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferCompleted(transferEvent);
    }

    protected void fireGetStarted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 1, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferStarted(transferEvent);
    }

    protected void fireGetInitiated(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 0, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferInitiated(transferEvent);
    }

    protected void firePutInitiated(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 0, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferInitiated(transferEvent);
    }

    protected void firePutCompleted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 2, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferCompleted(transferEvent);
    }

    protected void firePutStarted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 1, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.transferEventSupport.fireTransferStarted(transferEvent);
    }

    protected void fireSessionDisconnected() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 3);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionDisconnected(sessionEvent);
    }

    protected void fireSessionDisconnecting() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 2);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionDisconnecting(sessionEvent);
    }

    protected void fireSessionLoggedIn() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 7);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionLoggedIn(sessionEvent);
    }

    protected void fireSessionLoggedOff() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 8);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionLoggedOff(sessionEvent);
    }

    protected void fireSessionOpened() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 6);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionOpened(sessionEvent);
    }

    protected void fireSessionOpening() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 5);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionOpening(sessionEvent);
    }

    protected void fireSessionConnectionRefused() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 4);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionConnectionRefused(sessionEvent);
    }

    protected void fireSessionError(Exception exception) {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, exception);
        sessionEvent.setTimestamp(timestamp);
        this.sessionEventSupport.fireSessionError(sessionEvent);
    }

    protected void fireTransferDebug(String message) {
        this.transferEventSupport.fireDebug(message);
    }

    protected void fireSessionDebug(String message) {
        this.sessionEventSupport.fireDebug(message);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return this.transferEventSupport.hasTransferListener(listener);
    }

    public void addTransferListener(TransferListener listener) {
        this.transferEventSupport.addTransferListener(listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this.transferEventSupport.removeTransferListener(listener);
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionEventSupport.addSessionListener(listener);
    }

    public boolean hasSessionListener(SessionListener listener) {
        return this.sessionEventSupport.hasSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionEventSupport.removeSessionListener(listener);
    }

    protected void fireTransferError(Resource resource, Exception e, int requestType) {
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, e, requestType);
        this.transferEventSupport.fireTransferError(transferEvent);
    }

    public SessionEventSupport getSessionEventSupport() {
        return this.sessionEventSupport;
    }

    public void setSessionEventSupport(SessionEventSupport sessionEventSupport) {
        this.sessionEventSupport = sessionEventSupport;
    }

    public TransferEventSupport getTransferEventSupport() {
        return this.transferEventSupport;
    }

    public void setTransferEventSupport(TransferEventSupport transferEventSupport) {
        this.transferEventSupport = transferEventSupport;
    }

    protected void postProcessListeners(Resource resource, File source, int requestType) throws TransferFailedException {
        byte[] buffer = new byte[4096];
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 3, requestType);
        try {
            int n;
            FileInputStream input = new FileInputStream(source);
            while ((n = ((InputStream)input).read(buffer)) != -1) {
                this.fireTransferProgress(transferEvent, buffer, n);
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Failed to post-process the source file", e);
        }
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new TransferFailedException("directory copy not supported for " + this.getClass().getName());
    }

    public boolean supportsDirectoryCopy() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createZip(List files, File zipName, File basedir) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipName));
        try {
            for (int i = 0; i < files.size(); ++i) {
                String file = (String)files.get(i);
                file = file.replace('\\', '/');
                this.writeZipEntry(zos, new File(basedir, file), file);
            }
        }
        finally {
            IOUtil.close(zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntry(ZipOutputStream jar, File source, String entryName) throws IOException {
        byte[] buffer = new byte[1024];
        FileInputStream is = new FileInputStream(source);
        try {
            int bytesRead;
            ZipEntry entry = new ZipEntry(entryName);
            jar.putNextEntry(entry);
            while ((bytesRead = is.read(buffer)) != -1) {
                jar.write(buffer, 0, bytesRead);
            }
        }
        finally {
            is.close();
        }
    }

    protected static String getPath(String basedir, String dir) {
        String path = basedir;
        if (!basedir.endsWith("/") && !dir.startsWith("/")) {
            path = path + "/";
        }
        path = path + dir;
        return path;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public abstract /* synthetic */ void openConnection() throws ConnectionException, AuthenticationException;

    public abstract /* synthetic */ void put(File var1, String var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract /* synthetic */ boolean getIfNewer(String var1, File var2, long var3) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract /* synthetic */ void get(String var1, File var2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;
}

