// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use AccelGroup;
use Application;
use Bin;
use Buildable;
use Container;
use Error;
use Widget;
use WindowGroup;
use WindowPosition;
use WindowType;
use ffi;
use gdk;
use gdk_pixbuf;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct Window(Object<ffi::GtkWindow, ffi::GtkWindowClass>): Bin, Container, Widget, Buildable;

    match fn {
        get_type => || ffi::gtk_window_get_type(),
    }
}

impl Window {
    pub fn new(type_: WindowType) -> Window {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_window_new(type_.to_glib())).downcast_unchecked()
        }
    }

    pub fn get_default_icon_list() -> Vec<gdk_pixbuf::Pixbuf> {
        assert_initialized_main_thread!();
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_window_get_default_icon_list())
        }
    }

    pub fn get_default_icon_name() -> Option<String> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::gtk_window_get_default_icon_name())
        }
    }

    pub fn list_toplevels() -> Vec<Widget> {
        assert_initialized_main_thread!();
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_window_list_toplevels())
        }
    }

    pub fn set_auto_startup_notification(setting: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_auto_startup_notification(setting.to_glib());
        }
    }

    pub fn set_default_icon(icon: &gdk_pixbuf::Pixbuf) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon(icon.to_glib_none().0);
        }
    }

    pub fn set_default_icon_from_file<P: AsRef<std::path::Path>>(filename: P) -> Result<(), Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_window_set_default_icon_from_file(filename.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    pub fn set_default_icon_list(list: &[gdk_pixbuf::Pixbuf]) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon_list(list.to_glib_container().0);
        }
    }

    pub fn set_default_icon_name(name: &str) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_default_icon_name(name.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_14", feature = "dox"))]
    pub fn set_interactive_debugging(enable: bool) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_window_set_interactive_debugging(enable.to_glib());
        }
    }
}

pub trait GtkWindowExt {
    fn activate_default(&self) -> bool;

    fn activate_focus(&self) -> bool;

    fn activate_key(&self, event: &gdk::EventKey) -> bool;

    fn add_accel_group(&self, accel_group: &AccelGroup);

    fn add_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P);

    fn begin_move_drag(&self, button: i32, root_x: i32, root_y: i32, timestamp: u32);

    fn begin_resize_drag(&self, edge: gdk::WindowEdge, button: i32, root_x: i32, root_y: i32, timestamp: u32);

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn close(&self);

    fn deiconify(&self);

    fn fullscreen(&self);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn fullscreen_on_monitor(&self, screen: &gdk::Screen, monitor: i32);

    fn get_accept_focus(&self) -> bool;

    fn get_application(&self) -> Option<Application>;

    fn get_attached_to(&self) -> Option<Widget>;

    fn get_decorated(&self) -> bool;

    fn get_default_size(&self) -> (i32, i32);

    fn get_default_widget(&self) -> Option<Widget>;

    fn get_deletable(&self) -> bool;

    fn get_destroy_with_parent(&self) -> bool;

    fn get_focus(&self) -> Option<Widget>;

    fn get_focus_on_map(&self) -> bool;

    fn get_focus_visible(&self) -> bool;

    fn get_gravity(&self) -> gdk::Gravity;

    fn get_group(&self) -> Option<WindowGroup>;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn get_has_resize_grip(&self) -> bool;

    fn get_hide_titlebar_when_maximized(&self) -> bool;

    fn get_icon(&self) -> Option<gdk_pixbuf::Pixbuf>;

    fn get_icon_list(&self) -> Vec<gdk_pixbuf::Pixbuf>;

    fn get_icon_name(&self) -> Option<String>;

    fn get_mnemonic_modifier(&self) -> gdk::ModifierType;

    fn get_mnemonics_visible(&self) -> bool;

    fn get_modal(&self) -> bool;

    #[cfg_attr(feature = "v3_8", deprecated)]
    #[cfg(any(not(feature = "v3_8"), feature = "dox"))]
    fn get_opacity(&self) -> f64;

    fn get_position(&self) -> (i32, i32);

    fn get_resizable(&self) -> bool;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn get_resize_grip_area(&self) -> Option<gdk::Rectangle>;

    fn get_role(&self) -> Option<String>;

    fn get_size(&self) -> (i32, i32);

    fn get_skip_pager_hint(&self) -> bool;

    fn get_skip_taskbar_hint(&self) -> bool;

    fn get_title(&self) -> Option<String>;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_titlebar(&self) -> Option<Widget>;

    fn get_transient_for(&self) -> Option<Window>;

    fn get_type_hint(&self) -> gdk::WindowTypeHint;

    fn get_urgency_hint(&self) -> bool;

    fn get_window_type(&self) -> WindowType;

    fn has_group(&self) -> bool;

    fn has_toplevel_focus(&self) -> bool;

    fn iconify(&self);

    fn is_active(&self) -> bool;

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn is_maximized(&self) -> bool;

    fn maximize(&self);

    fn mnemonic_activate(&self, keyval: u32, modifier: gdk::ModifierType) -> bool;

    fn move_(&self, x: i32, y: i32);

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn parse_geometry(&self, geometry: &str) -> bool;

    fn present_with_time(&self, timestamp: u32);

    fn propagate_key_event(&self, event: &gdk::EventKey) -> bool;

    fn remove_accel_group(&self, accel_group: &AccelGroup);

    fn remove_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P);

    #[cfg_attr(feature = "v3_10", deprecated)]
    fn reshow_with_initial_size(&self);

    fn resize(&self, width: i32, height: i32);

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn resize_grip_is_visible(&self) -> bool;

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn resize_to_geometry(&self, width: i32, height: i32);

    fn set_accept_focus(&self, setting: bool);

    fn set_application<'a, P: Into<Option<&'a Application>>>(&self, application: P);

    fn set_attached_to<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, attach_widget: Q);

    fn set_decorated(&self, setting: bool);

    fn set_default<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, default_widget: Q);

    #[cfg_attr(feature = "v3_20", deprecated)]
    fn set_default_geometry(&self, width: i32, height: i32);

    fn set_default_size(&self, width: i32, height: i32);

    fn set_deletable(&self, setting: bool);

    fn set_destroy_with_parent(&self, setting: bool);

    fn set_focus<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, focus: Q);

    fn set_focus_on_map(&self, setting: bool);

    fn set_focus_visible(&self, setting: bool);

    //fn set_geometry_hints<'a, 'b, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>, R: Into<Option<&'b /*Ignored*/gdk::Geometry>>>(&self, geometry_widget: Q, geometry: R, geom_mask: gdk::WindowHints);

    fn set_gravity(&self, gravity: gdk::Gravity);

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn set_has_resize_grip(&self, value: bool);

    fn set_has_user_ref_count(&self, setting: bool);

    fn set_hide_titlebar_when_maximized(&self, setting: bool);

    fn set_icon<'a, P: Into<Option<&'a gdk_pixbuf::Pixbuf>>>(&self, icon: P);

    fn set_icon_from_file<P: AsRef<std::path::Path>>(&self, filename: P) -> Result<(), Error>;

    fn set_icon_list(&self, list: &[gdk_pixbuf::Pixbuf]);

    fn set_icon_name<'a, P: Into<Option<&'a str>>>(&self, name: P);

    fn set_keep_above(&self, setting: bool);

    fn set_keep_below(&self, setting: bool);

    fn set_mnemonic_modifier(&self, modifier: gdk::ModifierType);

    fn set_mnemonics_visible(&self, setting: bool);

    fn set_modal(&self, modal: bool);

    #[cfg_attr(feature = "v3_8", deprecated)]
    #[cfg(any(not(feature = "v3_8"), feature = "dox"))]
    fn set_opacity(&self, opacity: f64);

    fn set_position(&self, position: WindowPosition);

    fn set_resizable(&self, resizable: bool);

    fn set_role(&self, role: &str);

    fn set_screen(&self, screen: &gdk::Screen);

    fn set_skip_pager_hint(&self, setting: bool);

    fn set_skip_taskbar_hint(&self, setting: bool);

    fn set_startup_id(&self, startup_id: &str);

    fn set_title(&self, title: &str);

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn set_titlebar<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, titlebar: Q);

    fn set_transient_for<'a, P: IsA<Window> + 'a, Q: Into<Option<&'a P>>>(&self, parent: Q);

    fn set_type_hint(&self, hint: gdk::WindowTypeHint);

    fn set_urgency_hint(&self, setting: bool);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn set_wmclass(&self, wmclass_name: &str, wmclass_class: &str);

    fn stick(&self);

    fn unfullscreen(&self);

    fn unmaximize(&self);

    fn unstick(&self);

    fn get_property_default_height(&self) -> i32;

    fn set_property_default_height(&self, default_height: i32);

    fn get_property_default_width(&self) -> i32;

    fn set_property_default_width(&self, default_width: i32);

    fn get_property_has_toplevel_focus(&self) -> bool;

    fn get_property_is_active(&self) -> bool;

    fn get_property_is_maximized(&self) -> bool;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn get_property_resize_grip_visible(&self) -> bool;

    fn get_property_type(&self) -> WindowType;

    fn get_property_window_position(&self) -> WindowPosition;

    fn set_property_window_position(&self, window_position: WindowPosition);

    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_default(&self);

    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_focus(&self);

    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_enable_debugging(&self, toggle: bool) -> bool;

    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_set_focus<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_accept_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_attached_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_default_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_default_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_destroy_with_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_focus_on_map_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_focus_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_gravity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn connect_property_has_resize_grip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_has_toplevel_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_hide_titlebar_when_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_is_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_mnemonics_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v3_14", deprecated)]
    fn connect_property_resize_grip_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_role_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_skip_pager_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_skip_taskbar_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_transient_for_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_type_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_urgency_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_window_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Window> + IsA<glib::object::Object> + glib::object::ObjectExt> GtkWindowExt for O {
    fn activate_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_activate_default(self.to_glib_none().0))
        }
    }

    fn activate_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_activate_focus(self.to_glib_none().0))
        }
    }

    fn activate_key(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_activate_key(self.to_glib_none().0, mut_override(event.to_glib_none().0)))
        }
    }

    fn add_accel_group(&self, accel_group: &AccelGroup) {
        unsafe {
            ffi::gtk_window_add_accel_group(self.to_glib_none().0, accel_group.to_glib_none().0);
        }
    }

    fn add_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P) {
        unsafe {
            ffi::gtk_window_add_mnemonic(self.to_glib_none().0, keyval, target.to_glib_none().0);
        }
    }

    fn begin_move_drag(&self, button: i32, root_x: i32, root_y: i32, timestamp: u32) {
        unsafe {
            ffi::gtk_window_begin_move_drag(self.to_glib_none().0, button, root_x, root_y, timestamp);
        }
    }

    fn begin_resize_drag(&self, edge: gdk::WindowEdge, button: i32, root_x: i32, root_y: i32, timestamp: u32) {
        unsafe {
            ffi::gtk_window_begin_resize_drag(self.to_glib_none().0, edge.to_glib(), button, root_x, root_y, timestamp);
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn close(&self) {
        unsafe {
            ffi::gtk_window_close(self.to_glib_none().0);
        }
    }

    fn deiconify(&self) {
        unsafe {
            ffi::gtk_window_deiconify(self.to_glib_none().0);
        }
    }

    fn fullscreen(&self) {
        unsafe {
            ffi::gtk_window_fullscreen(self.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn fullscreen_on_monitor(&self, screen: &gdk::Screen, monitor: i32) {
        unsafe {
            ffi::gtk_window_fullscreen_on_monitor(self.to_glib_none().0, screen.to_glib_none().0, monitor);
        }
    }

    fn get_accept_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_accept_focus(self.to_glib_none().0))
        }
    }

    fn get_application(&self) -> Option<Application> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_application(self.to_glib_none().0))
        }
    }

    fn get_attached_to(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_attached_to(self.to_glib_none().0))
        }
    }

    fn get_decorated(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_decorated(self.to_glib_none().0))
        }
    }

    fn get_default_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::uninitialized();
            let mut height = mem::uninitialized();
            ffi::gtk_window_get_default_size(self.to_glib_none().0, &mut width, &mut height);
            (width, height)
        }
    }

    fn get_default_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_default_widget(self.to_glib_none().0))
        }
    }

    fn get_deletable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_deletable(self.to_glib_none().0))
        }
    }

    fn get_destroy_with_parent(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_destroy_with_parent(self.to_glib_none().0))
        }
    }

    fn get_focus(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_focus(self.to_glib_none().0))
        }
    }

    fn get_focus_on_map(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_focus_on_map(self.to_glib_none().0))
        }
    }

    fn get_focus_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_focus_visible(self.to_glib_none().0))
        }
    }

    fn get_gravity(&self) -> gdk::Gravity {
        unsafe {
            from_glib(ffi::gtk_window_get_gravity(self.to_glib_none().0))
        }
    }

    fn get_group(&self) -> Option<WindowGroup> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_group(self.to_glib_none().0))
        }
    }

    fn get_has_resize_grip(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_has_resize_grip(self.to_glib_none().0))
        }
    }

    fn get_hide_titlebar_when_maximized(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_hide_titlebar_when_maximized(self.to_glib_none().0))
        }
    }

    fn get_icon(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_icon(self.to_glib_none().0))
        }
    }

    fn get_icon_list(&self) -> Vec<gdk_pixbuf::Pixbuf> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_window_get_icon_list(self.to_glib_none().0))
        }
    }

    fn get_icon_name(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_icon_name(self.to_glib_none().0))
        }
    }

    fn get_mnemonic_modifier(&self) -> gdk::ModifierType {
        unsafe {
            from_glib(ffi::gtk_window_get_mnemonic_modifier(self.to_glib_none().0))
        }
    }

    fn get_mnemonics_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_mnemonics_visible(self.to_glib_none().0))
        }
    }

    fn get_modal(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_modal(self.to_glib_none().0))
        }
    }

    #[cfg(any(not(feature = "v3_8"), feature = "dox"))]
    fn get_opacity(&self) -> f64 {
        unsafe {
            ffi::gtk_window_get_opacity(self.to_glib_none().0)
        }
    }

    fn get_position(&self) -> (i32, i32) {
        unsafe {
            let mut root_x = mem::uninitialized();
            let mut root_y = mem::uninitialized();
            ffi::gtk_window_get_position(self.to_glib_none().0, &mut root_x, &mut root_y);
            (root_x, root_y)
        }
    }

    fn get_resizable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_resizable(self.to_glib_none().0))
        }
    }

    fn get_resize_grip_area(&self) -> Option<gdk::Rectangle> {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            let ret = from_glib(ffi::gtk_window_get_resize_grip_area(self.to_glib_none().0, rect.to_glib_none_mut().0));
            if ret { Some(rect) } else { None }
        }
    }

    fn get_role(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_role(self.to_glib_none().0))
        }
    }

    fn get_size(&self) -> (i32, i32) {
        unsafe {
            let mut width = mem::uninitialized();
            let mut height = mem::uninitialized();
            ffi::gtk_window_get_size(self.to_glib_none().0, &mut width, &mut height);
            (width, height)
        }
    }

    fn get_skip_pager_hint(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_skip_pager_hint(self.to_glib_none().0))
        }
    }

    fn get_skip_taskbar_hint(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_skip_taskbar_hint(self.to_glib_none().0))
        }
    }

    fn get_title(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_title(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_titlebar(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_titlebar(self.to_glib_none().0))
        }
    }

    fn get_transient_for(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gtk_window_get_transient_for(self.to_glib_none().0))
        }
    }

    fn get_type_hint(&self) -> gdk::WindowTypeHint {
        unsafe {
            from_glib(ffi::gtk_window_get_type_hint(self.to_glib_none().0))
        }
    }

    fn get_urgency_hint(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_get_urgency_hint(self.to_glib_none().0))
        }
    }

    fn get_window_type(&self) -> WindowType {
        unsafe {
            from_glib(ffi::gtk_window_get_window_type(self.to_glib_none().0))
        }
    }

    fn has_group(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_has_group(self.to_glib_none().0))
        }
    }

    fn has_toplevel_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_has_toplevel_focus(self.to_glib_none().0))
        }
    }

    fn iconify(&self) {
        unsafe {
            ffi::gtk_window_iconify(self.to_glib_none().0);
        }
    }

    fn is_active(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_is_active(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v3_12", feature = "dox"))]
    fn is_maximized(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_is_maximized(self.to_glib_none().0))
        }
    }

    fn maximize(&self) {
        unsafe {
            ffi::gtk_window_maximize(self.to_glib_none().0);
        }
    }

    fn mnemonic_activate(&self, keyval: u32, modifier: gdk::ModifierType) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_mnemonic_activate(self.to_glib_none().0, keyval, modifier.to_glib()))
        }
    }

    fn move_(&self, x: i32, y: i32) {
        unsafe {
            ffi::gtk_window_move(self.to_glib_none().0, x, y);
        }
    }

    fn parse_geometry(&self, geometry: &str) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_parse_geometry(self.to_glib_none().0, geometry.to_glib_none().0))
        }
    }

    fn present_with_time(&self, timestamp: u32) {
        unsafe {
            ffi::gtk_window_present_with_time(self.to_glib_none().0, timestamp);
        }
    }

    fn propagate_key_event(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_propagate_key_event(self.to_glib_none().0, mut_override(event.to_glib_none().0)))
        }
    }

    fn remove_accel_group(&self, accel_group: &AccelGroup) {
        unsafe {
            ffi::gtk_window_remove_accel_group(self.to_glib_none().0, accel_group.to_glib_none().0);
        }
    }

    fn remove_mnemonic<P: IsA<Widget>>(&self, keyval: u32, target: &P) {
        unsafe {
            ffi::gtk_window_remove_mnemonic(self.to_glib_none().0, keyval, target.to_glib_none().0);
        }
    }

    fn reshow_with_initial_size(&self) {
        unsafe {
            ffi::gtk_window_reshow_with_initial_size(self.to_glib_none().0);
        }
    }

    fn resize(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_resize(self.to_glib_none().0, width, height);
        }
    }

    fn resize_grip_is_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_window_resize_grip_is_visible(self.to_glib_none().0))
        }
    }

    fn resize_to_geometry(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_resize_to_geometry(self.to_glib_none().0, width, height);
        }
    }

    fn set_accept_focus(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_accept_focus(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_application<'a, P: Into<Option<&'a Application>>>(&self, application: P) {
        let application = application.into();
        let application = application.to_glib_none();
        unsafe {
            ffi::gtk_window_set_application(self.to_glib_none().0, application.0);
        }
    }

    fn set_attached_to<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, attach_widget: Q) {
        let attach_widget = attach_widget.into();
        let attach_widget = attach_widget.to_glib_none();
        unsafe {
            ffi::gtk_window_set_attached_to(self.to_glib_none().0, attach_widget.0);
        }
    }

    fn set_decorated(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_decorated(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_default<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, default_widget: Q) {
        let default_widget = default_widget.into();
        let default_widget = default_widget.to_glib_none();
        unsafe {
            ffi::gtk_window_set_default(self.to_glib_none().0, default_widget.0);
        }
    }

    fn set_default_geometry(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_set_default_geometry(self.to_glib_none().0, width, height);
        }
    }

    fn set_default_size(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_window_set_default_size(self.to_glib_none().0, width, height);
        }
    }

    fn set_deletable(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_deletable(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_destroy_with_parent(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_destroy_with_parent(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_focus<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, focus: Q) {
        let focus = focus.into();
        let focus = focus.to_glib_none();
        unsafe {
            ffi::gtk_window_set_focus(self.to_glib_none().0, focus.0);
        }
    }

    fn set_focus_on_map(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_focus_on_map(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_focus_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_focus_visible(self.to_glib_none().0, setting.to_glib());
        }
    }

    //fn set_geometry_hints<'a, 'b, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>, R: Into<Option<&'b /*Ignored*/gdk::Geometry>>>(&self, geometry_widget: Q, geometry: R, geom_mask: gdk::WindowHints) {
    //    unsafe { TODO: call ffi::gtk_window_set_geometry_hints() }
    //}

    fn set_gravity(&self, gravity: gdk::Gravity) {
        unsafe {
            ffi::gtk_window_set_gravity(self.to_glib_none().0, gravity.to_glib());
        }
    }

    fn set_has_resize_grip(&self, value: bool) {
        unsafe {
            ffi::gtk_window_set_has_resize_grip(self.to_glib_none().0, value.to_glib());
        }
    }

    fn set_has_user_ref_count(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_has_user_ref_count(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_hide_titlebar_when_maximized(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_hide_titlebar_when_maximized(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_icon<'a, P: Into<Option<&'a gdk_pixbuf::Pixbuf>>>(&self, icon: P) {
        let icon = icon.into();
        let icon = icon.to_glib_none();
        unsafe {
            ffi::gtk_window_set_icon(self.to_glib_none().0, icon.0);
        }
    }

    fn set_icon_from_file<P: AsRef<std::path::Path>>(&self, filename: P) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_window_set_icon_from_file(self.to_glib_none().0, filename.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_icon_list(&self, list: &[gdk_pixbuf::Pixbuf]) {
        unsafe {
            ffi::gtk_window_set_icon_list(self.to_glib_none().0, list.to_glib_none().0);
        }
    }

    fn set_icon_name<'a, P: Into<Option<&'a str>>>(&self, name: P) {
        let name = name.into();
        let name = name.to_glib_none();
        unsafe {
            ffi::gtk_window_set_icon_name(self.to_glib_none().0, name.0);
        }
    }

    fn set_keep_above(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_keep_above(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_keep_below(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_keep_below(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_mnemonic_modifier(&self, modifier: gdk::ModifierType) {
        unsafe {
            ffi::gtk_window_set_mnemonic_modifier(self.to_glib_none().0, modifier.to_glib());
        }
    }

    fn set_mnemonics_visible(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_mnemonics_visible(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_modal(&self, modal: bool) {
        unsafe {
            ffi::gtk_window_set_modal(self.to_glib_none().0, modal.to_glib());
        }
    }

    #[cfg(any(not(feature = "v3_8"), feature = "dox"))]
    fn set_opacity(&self, opacity: f64) {
        unsafe {
            ffi::gtk_window_set_opacity(self.to_glib_none().0, opacity);
        }
    }

    fn set_position(&self, position: WindowPosition) {
        unsafe {
            ffi::gtk_window_set_position(self.to_glib_none().0, position.to_glib());
        }
    }

    fn set_resizable(&self, resizable: bool) {
        unsafe {
            ffi::gtk_window_set_resizable(self.to_glib_none().0, resizable.to_glib());
        }
    }

    fn set_role(&self, role: &str) {
        unsafe {
            ffi::gtk_window_set_role(self.to_glib_none().0, role.to_glib_none().0);
        }
    }

    fn set_screen(&self, screen: &gdk::Screen) {
        unsafe {
            ffi::gtk_window_set_screen(self.to_glib_none().0, screen.to_glib_none().0);
        }
    }

    fn set_skip_pager_hint(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_skip_pager_hint(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_skip_taskbar_hint(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_skip_taskbar_hint(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_startup_id(&self, startup_id: &str) {
        unsafe {
            ffi::gtk_window_set_startup_id(self.to_glib_none().0, startup_id.to_glib_none().0);
        }
    }

    fn set_title(&self, title: &str) {
        unsafe {
            ffi::gtk_window_set_title(self.to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_10", feature = "dox"))]
    fn set_titlebar<'a, P: IsA<Widget> + 'a, Q: Into<Option<&'a P>>>(&self, titlebar: Q) {
        let titlebar = titlebar.into();
        let titlebar = titlebar.to_glib_none();
        unsafe {
            ffi::gtk_window_set_titlebar(self.to_glib_none().0, titlebar.0);
        }
    }

    fn set_transient_for<'a, P: IsA<Window> + 'a, Q: Into<Option<&'a P>>>(&self, parent: Q) {
        let parent = parent.into();
        let parent = parent.to_glib_none();
        unsafe {
            ffi::gtk_window_set_transient_for(self.to_glib_none().0, parent.0);
        }
    }

    fn set_type_hint(&self, hint: gdk::WindowTypeHint) {
        unsafe {
            ffi::gtk_window_set_type_hint(self.to_glib_none().0, hint.to_glib());
        }
    }

    fn set_urgency_hint(&self, setting: bool) {
        unsafe {
            ffi::gtk_window_set_urgency_hint(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_wmclass(&self, wmclass_name: &str, wmclass_class: &str) {
        unsafe {
            ffi::gtk_window_set_wmclass(self.to_glib_none().0, wmclass_name.to_glib_none().0, wmclass_class.to_glib_none().0);
        }
    }

    fn stick(&self) {
        unsafe {
            ffi::gtk_window_stick(self.to_glib_none().0);
        }
    }

    fn unfullscreen(&self) {
        unsafe {
            ffi::gtk_window_unfullscreen(self.to_glib_none().0);
        }
    }

    fn unmaximize(&self) {
        unsafe {
            ffi::gtk_window_unmaximize(self.to_glib_none().0);
        }
    }

    fn unstick(&self) {
        unsafe {
            ffi::gtk_window_unstick(self.to_glib_none().0);
        }
    }

    fn get_property_default_height(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "default-height".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_default_height(&self, default_height: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "default-height".to_glib_none().0, Value::from(&default_height).to_glib_none().0);
        }
    }

    fn get_property_default_width(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "default-width".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_default_width(&self, default_width: i32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "default-width".to_glib_none().0, Value::from(&default_width).to_glib_none().0);
        }
    }

    fn get_property_has_toplevel_focus(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "has-toplevel-focus".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_is_active(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "is-active".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_is_maximized(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "is-maximized".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_resize_grip_visible(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "resize-grip-visible".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_type(&self) -> WindowType {
        unsafe {
            let mut value = Value::from_type(<WindowType as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "type".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_window_position(&self) -> WindowPosition {
        unsafe {
            let mut value = Value::from_type(<WindowPosition as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "window-position".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_window_position(&self, window_position: WindowPosition) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "window-position".to_glib_none().0, Value::from(&window_position).to_glib_none().0);
        }
    }

    fn connect_activate_default<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "activate-default",
                transmute(activate_default_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_activate_default(&self) {
        let _ = self.emit("activate-default", &[]).unwrap();
    }

    fn connect_activate_focus<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "activate-focus",
                transmute(activate_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_activate_focus(&self) {
        let _ = self.emit("activate-focus", &[]).unwrap();
    }

    fn connect_enable_debugging<F: Fn(&Self, bool) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, bool) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "enable-debugging",
                transmute(enable_debugging_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn emit_enable_debugging(&self, toggle: bool) -> bool {
        let res = self.emit("enable-debugging", &[&toggle]).unwrap();
        res.unwrap().get().unwrap()
    }

    fn connect_keys_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "keys-changed",
                transmute(keys_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_set_focus<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Widget) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "set-focus",
                transmute(set_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_accept_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::accept-focus",
                transmute(notify_accept_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_application_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::application",
                transmute(notify_application_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_attached_to_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::attached-to",
                transmute(notify_attached_to_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_decorated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::decorated",
                transmute(notify_decorated_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_default_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::default-height",
                transmute(notify_default_height_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_default_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::default-width",
                transmute(notify_default_width_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_deletable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::deletable",
                transmute(notify_deletable_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_destroy_with_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::destroy-with-parent",
                transmute(notify_destroy_with_parent_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_focus_on_map_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::focus-on-map",
                transmute(notify_focus_on_map_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_focus_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::focus-visible",
                transmute(notify_focus_visible_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_gravity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::gravity",
                transmute(notify_gravity_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_has_resize_grip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::has-resize-grip",
                transmute(notify_has_resize_grip_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_has_toplevel_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::has-toplevel-focus",
                transmute(notify_has_toplevel_focus_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_hide_titlebar_when_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::hide-titlebar-when-maximized",
                transmute(notify_hide_titlebar_when_maximized_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::icon",
                transmute(notify_icon_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::icon-name",
                transmute(notify_icon_name_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-active",
                transmute(notify_is_active_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_is_maximized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::is-maximized",
                transmute(notify_is_maximized_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_mnemonics_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::mnemonics-visible",
                transmute(notify_mnemonics_visible_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::modal",
                transmute(notify_modal_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::resizable",
                transmute(notify_resizable_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_resize_grip_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::resize-grip-visible",
                transmute(notify_resize_grip_visible_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_role_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::role",
                transmute(notify_role_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::screen",
                transmute(notify_screen_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_skip_pager_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::skip-pager-hint",
                transmute(notify_skip_pager_hint_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_skip_taskbar_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::skip-taskbar-hint",
                transmute(notify_skip_taskbar_hint_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_startup_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::startup-id",
                transmute(notify_startup_id_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::title",
                transmute(notify_title_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_transient_for_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::transient-for",
                transmute(notify_transient_for_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::type",
                transmute(notify_type_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_type_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::type-hint",
                transmute(notify_type_hint_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_urgency_hint_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::urgency-hint",
                transmute(notify_urgency_hint_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_window_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::window-position",
                transmute(notify_window_position_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn activate_default_trampoline<P>(this: *mut ffi::GtkWindow, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn activate_focus_trampoline<P>(this: *mut ffi::GtkWindow, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn enable_debugging_trampoline<P>(this: *mut ffi::GtkWindow, toggle: glib_ffi::gboolean, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<Window> {
    let f: &&(Fn(&P, bool) -> bool + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked(), from_glib(toggle)).to_glib()
}

unsafe extern "C" fn keys_changed_trampoline<P>(this: *mut ffi::GtkWindow, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn set_focus_trampoline<P>(this: *mut ffi::GtkWindow, object: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P, &Widget) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(object))
}

unsafe extern "C" fn notify_accept_focus_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_application_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_attached_to_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_decorated_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_default_height_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_default_width_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_deletable_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_destroy_with_parent_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_focus_on_map_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_focus_visible_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_gravity_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_has_resize_grip_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_has_toplevel_focus_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_hide_titlebar_when_maximized_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_icon_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_icon_name_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_active_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_is_maximized_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_mnemonics_visible_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_modal_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_resizable_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_resize_grip_visible_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_role_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_screen_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_skip_pager_hint_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_skip_taskbar_hint_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_startup_id_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_title_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_transient_for_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_type_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_type_hint_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_urgency_hint_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_window_position_trampoline<P>(this: *mut ffi::GtkWindow, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<Window> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&Window::from_glib_borrow(this).downcast_unchecked())
}
