/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef SC_STACKWALK_H
#define SC_STACKWALK_H

// sc
#include "util/Stackframe.h"

// sys
#include <windows.h>


class Stackwalk
{
public:
  Stackwalk( EXCEPTION_POINTERS* pExp );

  void walk();

  const Stackframes& getFrames() const;

private:
  void fillSymbolInfo( Stackframe& f );
  void fillLineInfo( Stackframe& f );
  void fillModuleInfo( Stackframe& f );
  void fillParameterInfo( Stackframe& f );

private:
  // in
  EXCEPTION_POINTERS* _exp;

  // out
  Stackframes         _frames;
};


#endif //  SC_STACKWALK_H