#ifndef TC_HANDLE_H
#define TC_HANDLE_H

#include "tc_private.h"

#ifdef __cplusplus
extern "C" {
#endif

#define  MAX_OBJECT_NODE_COUNT  10

typedef struct __OPAQUE_TC_CONTEXT_  TC_CONTEXT;
typedef struct __OPAQUE_TC_PRIVATE_  TC_PRIVATE;
typedef struct __OPAQUE_TC_PUBLIC_   TC_PUBLIC;
typedef struct __OPAQUE_TC_NAME_     TC_NAME;

/*
    节点信息
*/
typedef struct {
    uint32_t       parent_handle;
    uint32_t       name_hash_alg;
    uint32_t       alg_object;
    uint32_t       obj_handle;
    uint32_t       persist_index;
    TC_PRIVATE    *obj_private;
    TC_PUBLIC     *obj_public;
    TC_NAME       *obj_name;
} TC_NODE;

/*
    对象信息
*/
typedef struct {
    uint16_t       count;
    TC_NODE       *node_info[MAX_OBJECT_NODE_COUNT];
} TC_OBJECT;

/*
    句柄信息
*/
typedef struct {
    TC_CONTEXT    *tc_context;
    TC_OBJECT     *tc_object;
} HANDLE_CTX;

/*
    TC_Handle
*/
typedef struct {
    HANDLE_CTX      handle;
    ENGINE_CTX     *engine;
} TC_HANDLE_CTX;

#ifdef __cplusplus
}
#endif

#endif /* TC_HANDLE_H */