#!/bin/bash
#
# Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# Fix X550VC wlan software control
fix_productname_x550vc() {
  if is_productname_exists "X550VC"; then
    msg "fix X550VC wlan."

    # Add wapf = 4 to enable software control
    echo "options asus_nb_wmi wapf=4" | tee -a /etc/modprobe.d/asus_nb_wmi.conf
  fi
}

# Fix N551ZU wireless driver
fix_productname_n551zu() {
  if is_productname_exists "N551ZU"; then
    msg "fix N551ZU wireless driver"

    # Add wapf = 1
    echo "options asus_nb_wmi wapf=1" | tee -a /etc/modprobe.d/asus_nb_wmi.conf
  fi
}

# Fix xiaomi notebook 13.3 wireless driver
fix_xiaomi_notebook_133() {
  if is_productname_exists "TM1613"; then
    if is_pci_exists "8086:24f3"; then
      msg "fix Xiaomi notebook 13.3 wireless driver"
      echo "blacklist acer_wmi" | \
      tee -a /etc/modprobe.d/xiaomi_disable_acer_wmi.conf
    fi
  fi
}

# Fix wireless issue of lenovo y700
fix_lenovo_y700() {
  if is_productname_exists "80NV"; then
    if is_pci_exists "8086:3166"; then
      msg "fix lenovo y700"

      # Add ideapad to blacklist of kernel module.
      echo "blacklist ideapad_laptop" | tee -a /etc/modprobe.d/ideapad.conf
    fi
  fi
}

fix_lenovo_r720() {
  if is_productname_exists "80WW"; then
    if is_pci_exists "168c:0042"; then
      msg "fix lenovo r720"

      # Add ideapad to blacklist of kernel module.
      echo "blacklist ideapad_laptop" | tee -a /etc/modprobe.d/ideapad.conf
    fi
  fi
}

# Fix wireless of X450JB
fix_asus_x450jb() {
  if is_productname_exists "X450JB"; then
    msg "fix asus x450jb"

    # Add acer wmi to blacklist of kernel module.
    echo "blacklist acer_wmi" | tee -a /etc/modprobe.d/blacklist_acerwmi.conf
  fi
}

fix_asus_x450jn() {
  if is_productname_exists "X450JN"; then
    msg "fix asus x450jn"
    echo "blacklist acer_wmi" | tee -a /etc/modprobe.d/blacklist_acerwmi.conf
  fi
}

fix_asus_x450jf() {
  if is_productname_exists "X450JF"; then
    msg "fix asus x450jf"
    echo "blacklist acer_wmi" | tee -a /etc/modprobe.d/blacklist_acerwmi.conf
  fi
}

fix_asus_u82u() {
  if is_productname_exists "U82U"; then
    msg "fix asus u82u"
    echo "blacklist asus-nb-wmi" | tee -a /etc/modprobe.d/blacklist_asus_nb_wmi.conf
  fi
}

fix_lenovo_80t9() {
  if is_productname_exists "80T9"; then
    msg "fix lenovo 80t9"
    echo "blacklist ideapad_laptop" | tee -a /etc/modprobe.d/blacklist-ideapad-laptop.conf
  fi
}
# bcm4313 [14e4:4727] wireless driver
fix_pci_bcm4313() {
  if is_pci_exists "14e4:4727"; then
    msg "fix bcm4313"

    # uninstall bcmwl-kernel-source
    apt-get purge -y -f bcmwl-kernel-source

    local PACKAGE_NAME="firmware-brcm80211"
    is_installed $PACKAGE_NAME
		rc=$?
		if [ $rc == 0 ]; then
			msg "$PACKAGE_NAME has been installed"
		fi

    force_overwrite_install $PACKAGE_NAME

    # blacklist b43 and wl driver
    echo "blacklist b43" | tee -a /etc/modprobe.d/bcm.conf
    echo "blacklist wl" | tee -a /etc/modprobe.d/bcm.conf

    # enable brcmsmac
    echo "brcmsmac" | tee -a /etc/modules
  fi
}

# bcm4350 [14e4:43a3] wl is not usable
fix_pci_bcm4350() {
  if is_pci_exists "14e4:43a3"; then
    msg "fix bcm4350"

    # uninstall bcmwl-kernel-source
    apt-get purge -y -f bcmwl-kernel-source

    local PACKAGE_NAME="firmware-brcm80211"
    is_installed $PACKAGE_NAME
		rc=$?
		if [ $rc == 0 ]; then
			msg "$PACKAGE_NAME has been installed"
		fi

    force_overwrite_install $PACKAGE_NAME

    # blacklist wl driver
    echo "blacklist wl" | tee -a /etc/modprobe.d/bcm.conf
  fi
}

# bcm4356 [17aa:0777] wl is not usable
fix_pci_bcm4356() {
  if is_pci_exists "17aa:0777"; then
    msg "fix bcm4356"
    apt-get purge -y -f bcmwl-kernel-source
  fi
}

# bcm4322 [14e4:432b] wl is not usable
fix_pci_bcm4322() {
  if is_pci_exists "14e4:432b"; then
    msg "fix bcm4322"
    apt-get purge -y -f bcmwl-kernel-source
    echo "blacklist wl" | tee -a /etc/modprobe.d/bcm.conf
  fi
}

# ar9485 [168C:0032] wireless driver
fix_pci_ar9485_nohwcrypt() {
  # fix ar9485 issue that could not connect to wifi with password protect
  if is_pci_exists "168c:0032"; then
    msg "fix ar9485"
    echo "options ath9k nohwcrypt=1" | tee -a /etc/modprobe.d/ath9k.conf
  fi
}

# rtl8723be [10ec:b723] wireless driver
fix_pci_rtl8723be_fwlps() {
  # fix rtl8723be issue that could not re-connect to wifi after a
  # period of time
  if is_pci_exists "10ec:b723"; then
    msg "fix rtl8723be"
    echo "options rtl8723be fwlps=0" | tee -a /etc/modprobe.d/rtl8723be.conf
  fi
}

# rtl8188ce [10ec:8176] wireless driver
fix_pci_rtl8188ce() {
  if is_pci_exists "10ec:8176"; then
    msg "fix rtl8188ce"
    echo "options rtl8192ce fwlps=0 ips=0" | tee -a /etc/modprobe.d/rtl8192ce.conf
  fi
}

# rt3290 [1814:3290] wireless driver
fix_pci_rt3290() {
  if is_pci_exists "1814:3290"; then
    msg "fix rt3290"
    echo "options rt2800pci nohwcrypt=1" | tee -a /etc/modprobe.d/rt2800pci.conf
  fi
}

# rtl8723au [0bda:1724] wireless driver
# TODO: no need any more after updating kernel to 3.15
fix_usb_rtl8723au() {
  if is_usb_exists "0bda:1724"; then
    msg "fix rtl8723au"

    local PACKAGE_NAME="rtl8723au-dkms"
    is_installed $PACKAGE_NAME
		rc=$?
		if [ $rc == 0 ]; then
			msg "$PACKAGE_NAME has been installed"
		fi

    safe_install $PACKAGE_NAME
  fi
}

# fix device driver problems
#_kernel_version=$(uname -r)
#case $_kernel_version in
#	4.*)
#		echo "[INFO] Kernel version >> 4.0, skip fix network.."
#		exit 0
#	;;
#esac

fix_pci_rtl8723ae_fwlps() {
  if is_pci_exists "10ec:8723"; then
    msg "fix rtl8723ae"
    echo 'options rtl8723ae fwlps=0' | tee -a /etc/modprobe.d/rtl8723ae.conf
  fi
}

fix_pci_rtl8852ae() {
  if is_productname_exists "N70Z"; then
    if is_pci_exists "10ec:8852"; then
      msg "fix rtl8852ae"

      apt-get purge -y -f bcmwl-kernel-source

      local PACKAGE_NAME="rtl8852ae-dkms"
      is_installed $PACKAGE_NAME
      rc=$?
      if [ $rc == 0 ]; then
        msg "$PACKAGE_NAME has been installed"
      fi

      safe_install $PACKAGE_NAME
    fi
  fi
}

head "-- network device detect and driver adaptation"

fix_pci_bcm4313 || true
fix_pci_bcm4350 || true
fix_pci_bcm4356 || true
#fix_pci_bcm4322 || true
fix_pci_rtl8723be_fwlps || true
#fix_usb_rtl8723au || true
fix_pci_rtl8723ae_fwlps || true
fix_pci_rtl8188ce || true
fix_pci_rt3290 || true
fix_productname_x550vc || true
fix_productname_n551zu || true
fix_xiaomi_notebook_133 || true
fix_lenovo_y700 || true
fix_lenovo_r720 || true
fix_asus_x450jb || true
fix_asus_x450jn || true
fix_asus_x450jf || true
fix_asus_u82u || true
fix_lenovo_80t9 ||true
fix_pci_rtl8852ae || true
