/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SYSTEMCLIPBOARD_H
#define SYSTEMCLIPBOARD_H

#include <vector>
#include <string>
#include <mutex>

using namespace std;
class ClipData;
class X11Clipboard;
class WaylandClipboard;
class SystemClipboard
{
public:
    ClipData *getClipDataAt(int index);
    int getClipDataCount();
    void removeAt(int index);
    void moveAt(int oldindex, int newindex);

    ClipData *createClipData();
    int addClipData(ClipData *_data);

    void clear();

    int loadClipData(string path = "");
    void saveClipdata(string path = "");

    void removeData();
    bool initDir();

    ClipData *getActiveClipData();

    string getPath();

    virtual ~SystemClipboard();

    static SystemClipboard &getInstance();

    void dataAddProcess(int index);
    void dataDeleteProcess(string name);
    void dataStateProcess(int state);

    int setDataTop(ClipData *clip);
    int setDataTop(int index);
    void setDataToClipboard(ClipData *vClip, bool flag = true);

    void setClipState(int state);
    int getClipState();

    int getClipIndexByName(string name);

    void init();
    void initConnect();

    void destroyData();

    void setClipNum(int num);
    int getClipNum();

    void clearClipboardData();

    int cancelTopData();
private:
    SystemClipboard();

    void deleteTopData();

private:
    vector<ClipData *> m_clipdata;
    ClipData     *m_CurrentTopData;
    X11Clipboard *m_x11clipboard;
    WaylandClipboard *m_waylandclipboard;
    string m_dataptah;
    int m_Clipstate;
    int m_version;
    bool m_Isload;       //防止重复加载
    mutex m_clipboardMutex;
    int  m_clipNum;

    static SystemClipboard *m_systemClipboard;
};

#endif // DWMJACK_H
