*** Settings ***
Documentation       Check disk-usage table

Resource            ${CURDIR}${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Ctn Generic Suite Setup
Test Timeout        120s


*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=os::linux::snmp::plugin


*** Test Cases ***
disk-usage ${tc}
    [Tags]    os    linux
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=disk-usage
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=os/linux/snmp/linux
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc    extra_options                       expected_result    --
            ...      1     --filter-counters                   OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100 
            ...      2     --disk-index='25'                   OK: Partition '/run/user/0' usage total: 196.70 MB used: 0.00 B (0.00%) free: 196.70 MB (100.00%), Inodes used: 0 % | 'count'=1;;;0; 'used'=0B;;;0;206258176 'free'=206258176B;;;0;206258176 'used_prct'=0.00%;;;0;100 'inodes'=0%;;;0;100
            ...      3     --filter-disk-path                  OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      4     --filter-disk-device                OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100 
            ...      5     --reload-cache-time='180'           OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      6     --display-transform-src='dev'       OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_//shm'=0B;;;0;1031299072 'free_//shm'=1031299072B;;;0;1031299072 'used_prct_//shm'=0.00%;;;0;100 'inodes_//shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100 
            ...      7     --display-transform-dst             OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100 
            ...      8     --disk-index='2'                    UNKNOWN: No disk path found. Can be: filters, cache file.
            ...      9     --space-reservation='0'             OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      10    --force-use-mib-percent             OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.00%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.00%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100 
            ...      11    --force-counters32='1111'           OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      12    --warning-usage='1'                 WARNING: Partition '/' usage total: 97.87 GB used: 6.89 GB (7.04%) free: 90.98 GB (92.96%) - Partition '/run' usage total: 196.71 MB used: 520.00 KB (0.26%) free: 196.20 MB (99.74%) | 'count'=5;;;0; 'used_/'=7394013184B;0:1;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;0:1;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;0:1;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;0:1;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;0:1;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      13    --critical-usage='1'                CRITICAL: Partition '/' usage total: 97.87 GB used: 6.89 GB (7.04%) free: 90.98 GB (92.96%) - Partition '/run' usage total: 196.71 MB used: 520.00 KB (0.26%) free: 196.20 MB (99.74%) | 'count'=5;;;0; 'used_/'=7394013184B;;0:1;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;0:1;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;0:1;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;0:1;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;0:1;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      14    --warning-usage-free='1'            WARNING: Partition '/' usage total: 97.87 GB used: 6.89 GB (7.04%) free: 90.98 GB (92.96%) - Partition '/dev/shm' usage total: 983.52 MB used: 0.00 B (0.00%) free: 983.52 MB (100.00%) - Partition '/run' usage total: 196.71 MB used: 520.00 KB (0.26%) free: 196.20 MB (99.74%) - Partition '/run/lock' usage total: 5.00 MB used: 0.00 B (0.00%) free: 5.00 MB (100.00%) - Partition '/run/user/0' usage total: 196.70 MB used: 0.00 B (0.00%) free: 196.70 MB (100.00%) | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;0:1;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;0:1;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;0:1;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;0:1;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;0:1;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      15    --critical-usage-free='1'           CRITICAL: Partition '/' usage total: 97.87 GB used: 6.89 GB (7.04%) free: 90.98 GB (92.96%) - Partition '/dev/shm' usage total: 983.52 MB used: 0.00 B (0.00%) free: 983.52 MB (100.00%) - Partition '/run' usage total: 196.71 MB used: 520.00 KB (0.26%) free: 196.20 MB (99.74%) - Partition '/run/lock' usage total: 5.00 MB used: 0.00 B (0.00%) free: 5.00 MB (100.00%) - Partition '/run/user/0' usage total: 196.70 MB used: 0.00 B (0.00%) free: 196.70 MB (100.00%) | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;0:1;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;0:1;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;0:1;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;0:1;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;0:1;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      16    --warning-usage-prct='1'            WARNING: Partition '/' used: 7.04 % | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;0:1;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;0:1;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;0:1;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;0:1;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;0:1;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      17    --critical-usage-prct='1'           CRITICAL: Partition '/' used: 7.04 % | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;0:1;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;0:1;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;0:1;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;0:1;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;0:1;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      18    --warning-inodes='1'                WARNING: Partition '/' Inodes used: 6 % | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;0:1;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;0:1;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;0:1;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;0:1;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;0:1;;0;100
            ...      19    --critical-inodes='1'               CRITICAL: Partition '/' Inodes used: 6 % | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;0:1;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;0:1;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;0:1;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;0:1;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;0:1;0;100
            ...      20    --warning-count='1'                 WARNING: Partitions count : 5 | 'count'=5;0:1;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      21    --critical-count='1'                CRITICAL: Partitions count : 5 | 'count'=5;;0:1;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      22    --filter-disk-path='/dev/shm'       OK: Partition '/dev/shm' usage total: 983.52 MB used: 0.00 B (0.00%) free: 983.52 MB (100.00%), Inodes used: 0 % | 'count'=1;;;0; 'used'=0B;;;0;1031299072 'free'=1031299072B;;;0;1031299072 'used_prct'=0.00%;;;0;100 'inodes'=0%;;;0;100
            ...      23    --filter-disk-path='/run'           OK: All partitions are ok | 'count'=3;;;0; 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      24    --filter-disk-path='/run/lock'      OK: Partition '/run/lock' usage total: 5.00 MB used: 0.00 B (0.00%) free: 5.00 MB (100.00%), Inodes used: 0 % | 'count'=1;;;0; 'used'=0B;;;0;5242880 'free'=5242880B;;;0;5242880 'used_prct'=0.00%;;;0;100 'inodes'=0%;;;0;100
            ...      25    --filter-disk-path='/'              OK: All partitions are ok | 'count'=5;;;0; 'used_/'=7394013184B;;;0;105088212992 'free_/'=97694199808B;;;0;105088212992 'used_prct_/'=7.04%;;;0;100 'inodes_/'=6%;;;0;100 'used_/dev/shm'=0B;;;0;1031299072 'free_/dev/shm'=1031299072B;;;0;1031299072 'used_prct_/dev/shm'=0.00%;;;0;100 'inodes_/dev/shm'=0%;;;0;100 'used_/run'=532480B;;;0;206262272 'free_/run'=205729792B;;;0;206262272 'used_prct_/run'=0.26%;;;0;100 'inodes_/run'=0%;;;0;100 'used_/run/lock'=0B;;;0;5242880 'free_/run/lock'=5242880B;;;0;5242880 'used_prct_/run/lock'=0.00%;;;0;100 'inodes_/run/lock'=0%;;;0;100 'used_/run/user/0'=0B;;;0;206258176 'free_/run/user/0'=206258176B;;;0;206258176 'used_prct_/run/user/0'=0.00%;;;0;100 'inodes_/run/user/0'=0%;;;0;100
            ...      26    --filter-disk-path='/run/user/0'    OK: Partition '/run/user/0' usage total: 196.70 MB used: 0.00 B (0.00%) free: 196.70 MB (100.00%), Inodes used: 0 % | 'count'=1;;;0; 'used'=0B;;;0;206258176 'free'=206258176B;;;0;206258176 'used_prct'=0.00%;;;0;100 'inodes'=0%;;;0;100
