//
// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2013-06-14 17:07:50
// From command line:
//  --cld2 --cc --just_read_raw --delta_bi
//  --wrt=cld2_generated_unicjkchrome0614.bin --cjk --minchars=2
//  --mincount=2 --max_items_per_langscript=2000 --flatmap --rr_alloc
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=224
//  --v25 --kentries=4 --tablename=CjkDeltaBi --remap=xxx-Latn=>ut-Latn
//  sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl    nn-Latn=>no-Latn mo-Cyrl=>ro-Cyrl
//    --include=af-Latn ar-Arab be-Cyrl bg-Cyrl ca-Latn cs-Latn cy-Latn
//  da-Latn de-Latn el-Grek en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn
//    ga-Latn gd-Latn hi-Deva hr-Latn hu-Latn id-Latn is-Latn it-Latn
//  iw-Hebr    ja-Hani ko-Hani lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn
//  nl-Latn no-Latn    pl-Latn pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn
//  sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl    sv-Latn sw-Latn th-Thai
//  tl-Latn tr-Latn uk-Cyrl vi-Latn yi-Hebr    zh-Hani zh-TW zh-Hant
//  sq-Latn az-Latn eu-Latn bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab
//    bh-Deva mr-Deva ne-Deva lg-Latn rw-Latn gd-Latn    ut-Latn ut-Deva
//  tlh-Latn ceb-Latn blu-Latn jw-Latn  --ko_english --force_to_lang_soft
//  --nosoft_cram2 --nomsidlevel --shapeflatprob --langpriorpercent=10
//  --skipnuc --noshapeforcetop --noshapeeventop --noshapesteep2 --spread=15
//  --nodoubleclose --langcounts --writebin --list_items=120
//  i18n/encodings/cld2/prob_data/vetted_bigram_prob_20130614_sort.utf8
//

#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kCjkDeltaBiBuildDate = 20130614;    // yyyymmdd


// Of 2674 offered items into 4096 table entries:
// 2466 filled (92%), 0 merged (0%), 208 dropped (7%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 4 languages in range Japanese..ChineseT:
//

//  Japanese 524
//  Korean 10
//  Chinese 748
//  ChineseT 1184



// Recognized language-script combinations [4]:
static const char* const kCjkDeltaBiRecognizedLangScripts =
  "ja-Hani ko-Hani zh-Hani zh-Hant ";

static const uint32 kCjkDeltaBiSize = 1024;    // Bucket count
static const uint32 kCjkDeltaBiKeyMask = 0xfffff000;    // Mask hash key

static const IndirectProbBucket4 kCjkDeltaBi[kCjkDeltaBiSize] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0xf945f002,0xf93b1003,0x00000000,0x00000000}},	// [000] 手工, も同, --, --,
   {{0xf829b004,0x00000000,0x00000000,0x00000000}},	//   制作, --, --, --,
   {{0xfb731005,0x00000000,0x00000000,0x00000000}},	//   瑕疵, --, --, --,
   {{0xfb83e006,0xf4afd002,0xf8354003,0xf913a004}},	//   佈置, 店面, 能人, 导小,
   {{0xf9268007,0x00000000,0x00000000,0x00000000}},	//   部分, --, --, --,
   {{0xfb5c8006,0xf813f003,0x00000000,0x00000000}},	//   入社, 単位, --, --,
   {{0xfa4c1007,0xfb4d4006,0xf5a6c002,0x00000000}},	//   科技, 寵物, 對象, --,
   {{0xfa77d006,0xf8256008,0xfa7c0003,0xf8404004}},	//   主治, 國中, 値段, 中介,
   {{0xfa4b8009,0xf91df006,0xf923b00a,0xf944c00b}},	//   材料, 員名, 中共, 之外,
   {{0xf597c003,0x00000000,0x00000000,0x00000000}},	//   機能, --, --, --,
   {{0xfb72800c,0xf937c009,0xf90ff00a,0xf9414006}},	//   投稿, 办公, 共和, 指引,
   {{0xf92ca00d,0x00000000,0x00000000,0x00000000}},	//   姑娘, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf93d2005,0xf5b7d003,0xf928b002,0x00000000}},	//   仁哲, へ行, 未分, --,
   {{0xf4bd300a,0xf8227006,0xfb7e700a,0xf93c800a}},	//   的通, 有何, 的第, 一家,
   {{0xfa589004,0xf933c004,0x00000000,0x00000000}},	//   农村, 力度, --, --,
   {{0xf917d008,0x00000000,0x00000000,0x00000000}},	// [010] 覺得, --, --, --,
   {{0xf4a85006,0x00000000,0x00000000,0x00000000}},	//   質量, --, --, --,
   {{0xf92db007,0xf929d00d,0x00000000,0x00000000}},	//   打印, 个字, --, --,
   {{0xf940f006,0xfa4f7006,0x00000000,0x00000000}},	//   則回, 引擎, --, --,
   {{0xf5c5e003,0xfb7f5006,0x00000000,0x00000000}},	//   の解, 項目, --, --,
   {{0xfa6e3006,0xf927a00e,0xfa85500a,0xf4ae9003}},	//   右手, 師傅, 物流, 外部,
   {{0xf9127004,0xf93bc008,0x00000000,0x00000000}},	//   深入, 時候, --, --,
   {{0xf9378003,0xfb66200a,0xf5b4b003,0xfb6f700b}},	//   九州, 全省, 落解, 策略,
   {{0xfa7eb002,0xf9382006,0xf9390006,0x00000000}},	//   內政, 舟山, 一名, --,
   {{0xf91be00f,0xf9456010,0xf82a6004,0x00000000}},	//   产品, 今回, 华人, --,
   {{0xfa586006,0xf9410010,0xf80e800a,0xfa4c4006}},	//   依本, 有名, 民主, 我最,
   {{0xf93cd002,0x00000000,0x00000000,0x00000000}},	//   億元, --, --, --,
   {{0xf938d003,0xfb6ed006,0xfa76e00b,0xf81f4006}},	//   輝度, 斗神, 人文, 的使,
   {{0xfb526004,0x00000000,0x00000000,0x00000000}},	//   政策, --, --, --,
   {{0xf80ca006,0xfa5cf011,0x00000000,0x00000000}},	//   殖事, 省政, --, --,
   {{0xf4bfb003,0xf9187004,0xf939d012,0xfa5da006}},	//   病院, 出口, 最初, 堅持,
   {{0xf920500e,0xf9474010,0x00000000,0x00000000}},	// [020] 廢墟, 富士, --, --,
   {{0xf9339006,0xf92dd006,0xfa49d003,0xfb714013}},	//   務必, 取回, を教, 純粹,
   {{0xf5a77007,0xf90fe002,0x00000000,0x00000000}},	//   不能, 史建, --, --,
   {{0xf93fb00a,0xf9432006,0xf82f200b,0x00000000}},	//   的影, 之前, 到一, --,
   {{0xf4aca00a,0xfa66c00d,0x00000000,0x00000000}},	//   打造, 律援, --, --,
   {{0xfa4cf004,0xfa5ed006,0x00000000,0x00000000}},	//   成本, 的武, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf917f006,0xf592900b,0x00000000,0x00000000}},	//   司名, 定要, --, --,
   {{0xfb864009,0xfa78c00a,0xfa62e00b,0x00000000}},	//   位置, 交流, 按摩, --,
   {{0xf5c5e014,0x00000000,0x00000000,0x00000000}},	//   可能, --, --, --,
   {{0xf83a5015,0xfa5ee004,0xfa844003,0xfa663006}},	//   工作, 规模, 目指, 看板,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf9138004,0xf92d2011,0xf819c00b,0xf80eb002}},	//   国土, 郑州, 十三, 著作,
   {{0xf8237003,0x00000000,0x00000000,0x00000000}},	//   る一, --, --, --,
   {{0xfa61f00a,0x00000000,0x00000000,0x00000000}},	//   三星, --, --, --,
   {{0xf4a23002,0x00000000,0x00000000,0x00000000}},	// [030] 業部, --, --, --,
   {{0xf4bee003,0xf9480003,0xfb5a3004,0x00000000}},	//   掃除, 崎市, 油田, --,
   {{0xffef1010,0xfa79600a,0xf81b0005,0x00000000}},	//   パソ, 司法, 十九, --,
   {{0xf946c008,0xf4c3200a,0x00000000,0x00000000}},	//   國家, 下降, --, --,
   {{0xf5ca2006,0xf815d003,0x00000000,0x00000000}},	//   優良, マ一, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa4be00a,0xfb6a3003,0xf839e00a,0x00000000}},	//   成果, を生, 方便, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf4b2c011,0x00000000,0x00000000,0x00000000}},	//   这里, --, --, --,
   {{0xf942b007,0xf5ba9003,0x00000000,0x00000000}},	//   安全, て行, --, --,
   {{0xfa5c7004,0x00000000,0x00000000,0x00000000}},	//   权所, --, --, --,
   {{0xf925a00d,0x00000000,0x00000000,0x00000000}},	//   周刊, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb6b2004,0x00000000,0x00000000,0x00000000}},	//   隐私, --, --, --,
   {{0xfa7e0004,0x00000000,0x00000000,0x00000000}},	//   满意, --, --, --,
   {{0xf947e009,0xfb608002,0xf926b003,0x00000000}},	//   今年, 灣省, の好, --,
   {{0xf48ef011,0x00000000,0x00000000,0x00000000}},	// [040] 数量, --, --, --,
   {{0xf947e003,0xf4bdc003,0xf59f600d,0x00000000}},	//   が大, 鉄道, 的落, --,
   {{0xf90f4003,0x00000000,0x00000000,0x00000000}},	//   地元, --, --, --,
   {{0xf842c003,0xf82d0002,0xfb7ca006,0x00000000}},	//   は不, 網上, 裁示, --,
   {{0xf6d22016,0xf9474006,0xf91c3003,0xf59ca002}},	//   티벳, 前出, 大分, 還要,
   {{0xfa870003,0xf8256006,0xf823500b,0x00000000}},	//   の新, 行事, 之一, --,
   {{0xf945f003,0xfb64800b,0x00000000,0x00000000}},	//   が分, 聯繫, --, --,
   {{0xf5c0d00a,0xfb4d1006,0xf5c0a00d,0x00000000}},	//   患者, 署立, 语言, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf93bf002,0xf90b6004,0xf92cc004,0x00000000}},	//   時尚, 获得, 青年, --,
   {{0xfa5db009,0xfb76b006,0x00000000,0x00000000}},	//   资源, 衝突, --, --,
   {{0xf5bbb003,0xfa67000e,0xfa764013,0xfb67d006}},	//   で行, 後悔, 活潑, 貨物,
   {{0xfb6e6006,0xf90fd00d,0xfa79200e,0x00000000}},	//   聖火, 讲座, 遺憾, --,
   {{0xf58d3009,0xf80ba009,0x00000000,0x00000000}},	//   或者, 网上, --, --,
   {{0xfa579010,0xf9386003,0xfa5ce00b,0x00000000}},	//   た方, 検定, 的故, --,
   {{0xf942f017,0xf913c002,0xf5b95004,0x00000000}},	//   奈川, 發布, 对象, --,
   {{0xfa661006,0xf93fb00a,0xf8441002,0x00000000}},	// [050] 個方, 各地, 萬人, --,
   {{0xf5a7d013,0xf843a003,0xf9276002,0x00000000}},	//   和諧, の不, 推展, --,
   {{0xf58c000a,0xfb7f4006,0xfb581006,0xf93db00b}},	//   金融, 會社, 人物, 心得,
   {{0xf915200a,0xf9084006,0xf928a006,0x00000000}},	//   施工, 搶先, 未必, --,
   {{0xf498d007,0xfa8ad007,0xf93a4006,0xf9262006}},	//   改革, 自治, 府出, 輩子,
   {{0xf91a1009,0xf48a5002,0xf945d006,0xf492800a}},	//   许可, 嚴重, 國古, 政部,
   {{0xf4af000a,0x00000000,0x00000000,0x00000000}},	//   街道, --, --, --,
   {{0xf9382007,0xf9214003,0xf91e100a,0xf93fb006}},	//   土地, 設定, 模式, 的山,
   {{0xf4bad003,0xfb4a500e,0xf90d5006,0xf9455002}},	//   一部, 收穫, 歷年, 認定,
   {{0xf9447018,0x00000000,0x00000000,0x00000000}},	//   名前, --, --, --,
   {{0xf80ca003,0x00000000,0x00000000,0x00000000}},	//   佐世, --, --, --,
   {{0xfa80a006,0x00000000,0x00000000,0x00000000}},	//   絡方, --, --, --,
   {{0xf4c62003,0xfb82f008,0xfa6ac002,0x00000000}},	//   が高, 先生, 長期, --,
   {{0xfb5b4003,0xfa54c011,0x00000000,0x00000000}},	//   処理, 业执, --, --,
   {{0xf9182004,0x00000000,0x00000000,0x00000000}},	//   顺利, --, --, --,
   {{0xf9436008,0xfb712014,0x00000000,0x00000000}},	//   國小, 引用, --, --,
   {{0xf844e004,0x00000000,0x00000000,0x00000000}},	// [060] 息中, --, --, --,
   {{0xf93fe006,0xf913900a,0xf5c66006,0x00000000}},	//   來回, 精彩, 用者, --,
   {{0xf8115009,0xfa721003,0xf493d003,0x00000000}},	//   进一, 社概, 都道, --,
   {{0xf8393007,0xf91b500a,0xfa539006,0x00000000}},	//   以下, 健全, 香料, --,
   {{0xf90ff006,0xfb838006,0xf947700b,0x00000000}},	//   新回, 轉移, 不好, --,
   {{0xf4a1500a,0xf82c2006,0x00000000,0x00000000}},	//   公里, 長信, --, --,
   {{0xfb7d700a,0xf5c6e003,0xf815e006,0x00000000}},	//   的生, の色, 站使, --,
   {{0xf5c4e013,0xf93b6006,0x00000000,0x00000000}},	//   天蠍, 要引, --, --,
   {{0xf5c61010,0xf919800a,0xf9336006,0xfa650006}},	//   と言, 常委, 肚子, 請注,
   {{0xfa77c010,0xf5bd9003,0xfa6e7006,0xf49da019}},	//   選手, で表, 農村, 纠错,
   {{0xf9497004,0x00000000,0x00000000,0x00000000}},	//   经常, --, --, --,
   {{0xf94af012,0xf91b200b,0x00000000,0x00000000}},	//   美味, 接受, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa62000d,0x00000000,0x00000000,0x00000000}},	//   过渡, --, --, --,
   {{0xf9240003,0xf9482006,0x00000000,0x00000000}},	//   の心, 而出, --, --,
   {{0xfb86d006,0xfb51a005,0xf824e00d,0xfb7a4006}},	//   刊登, 新竹, 不久, 送私,
   {{0xfa647002,0xf9118007,0xfa5c700b,0x00000000}},	// [070] 國民, 平台, 市民, --,
   {{0xf8178003,0xf80fe004,0xf90f0006,0xfb66f004}},	//   た人, 南京, 河川, 邮箱,
   {{0xf93f0007,0xfa5e900a,0x00000000,0x00000000}},	//   的工, 居民, --, --,
   {{0xf845c003,0xf924a004,0xf92e200a,0xf5ae6006}},	//   の中, 确定, 南市, 腳踏,
   {{0xf9214002,0x00000000,0x00000000,0x00000000}},	//   廣州, --, --, --,
   {{0xf844b004,0xfa67b006,0x00000000,0x00000000}},	//   确保, 意思, --, --,
   {{0xf938c002,0xfa63f006,0x00000000,0x00000000}},	//   觀光, 版本, --, --,
   {{0xf8449003,0xfb6f4006,0xf93ee00b,0x00000000}},	//   の保, 金石, 概念, --,
   {{0xfb7d200a,0x00000000,0x00000000,0x00000000}},	//   组织, --, --, --,
   {{0xf91f9011,0xf916f006,0xf9168006,0xf939200b}},	//   加工, 改名, 電子, 回家,
   {{0xf9122010,0xf948f006,0x00000000,0x00000000}},	//   山口, 美少, --, --,
   {{0xf9382006,0xf9364003,0xf9172002,0xf845701a}},	//   攝取, 仙台, 確定, 可以,
   {{0xf48f0009,0xf8164006,0xf9327003,0xf941e00b}},	//   干部, 條例, 婚式, 有多,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf8131004,0xf93db003,0xfb666010,0xf90e9002}},	//   这一, も大, の空, 進展,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb623010,0xfa89701b,0xf935c006,0xf5cb400b}},	// [080] 面白, 木柵, 點名, 只能,
   {{0xf9143006,0x00000000,0x00000000,0x00000000}},	//   覽器, --, --, --,
   {{0xfa65f013,0xf9193003,0xf942d002,0x00000000}},	//   對抗, 日光, 下午, --,
   {{0xf8470006,0xf947500b,0x00000000,0x00000000}},	//   師事, 完全, --, --,
   {{0xfa62f008,0xf939d002,0x00000000,0x00000000}},	//   個月, 攝影, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb798009,0xf808f003,0xf9189004,0xf843a003}},	//   搜索, を上, 对外, の位,
   {{0xf9164006,0xf9126012,0xf4a7b00a,0xf9304002}},	//   主回, 印刷, 全部, 協助,
   {{0xfa7fd004,0xf9146002,0xfb6cb014,0x00000000}},	//   档案, 社工, 世界, --,
   {{0xf93f400b,0xf825800b,0x00000000,0x00000000}},	//   垃圾, 同一, --, --,
   {{0xf9189008,0x00000000,0x00000000,0x00000000}},	//   電影, --, --, --,
   {{0xf814800a,0xf90d1005,0xfa7cd006,0xf9128006}},	//   通信, 網友, 性感, 新年,
   {{0xf9358004,0xfa6a6005,0x00000000,0x00000000}},	//   蒙古, 長沙, --, --,
   {{0xf945f010,0x00000000,0x00000000,0x00000000}},	//   が必, --, --, --,
   {{0xf499400a,0x00000000,0x00000000,0x00000000}},	//   改造, --, --, --,
   {{0xfb6e600a,0xfb55d014,0xfa604006,0xfb515006}},	//   受理, 出版, 資料, 平米,
   {{0xf837e003,0xfb528006,0x00000000,0x00000000}},	// [090] 主人, 就知, --, --,
   {{0xfb87f002,0x00000000,0x00000000,0x00000000}},	//   美秀, --, --, --,
   {{0xfb6d700a,0xfa4da00d,0xfa5f0002,0x00000000}},	//   科研, 字母, 的日, --,
   {{0xf822d007,0xf9405010,0xf93c9002,0xfb5bb00d}},	//   合作, 理士, 紀念, 欧美,
   {{0xfb65301b,0xfb5d5003,0xf92b801a,0xfb6bb014}},	//   修繕, 戦略, 自己, 自然,
   {{0xf8321018,0xf92bb00d,0xfb871006,0x00000000}},	//   東京, 网友, 認知, --,
   {{0xf940e006,0xfa76d00b,0xfa70b00b,0x00000000}},	//   三名, 特殊, 英文, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa785003,0xf90b7004,0xfa872006,0x00000000}},	//   空港, 年初, 器材, --,
   {{0xf914300a,0xfb7e6006,0xf943c006,0x00000000}},	//   房地, 棄物, 證券, --,
   {{0xf4a4c004,0xf90a8006,0xf9429006,0x00000000}},	//   粮食, 年前, 指出, --,
   {{0xfb6b1010,0x00000000,0x00000000,0x00000000}},	//   を目, --, --, --,
   {{0xf92ec006,0xfb6ce00b,0x00000000,0x00000000}},	//   傑出, 民生, --, --,
   {{0xf9327006,0xfb7d0003,0xfa68b00b,0x00000000}},	//   君子, 専用, 明星, --,
   {{0xfa707010,0xfb873004,0xf81b9014,0x00000000}},	//   音波, 经理, 所以, --,
   {{0xfa58e006,0xf9272003,0xf911900b,0x00000000}},	//   一手, の家, 便宜, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [0a0] --, --, --, --,
   {{0xfa496018,0x00000000,0x00000000,0x00000000}},	//   を持, --, --, --,
   {{0xf9299003,0xf837a006,0x00000000,0x00000000}},	//   に加, 為何, --, --,
   {{0xfa5f2004,0xf81af006,0xf90e0006,0xf93d500a}},	//   的方, 時事, 更年, 市公,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf941c007,0xf90f2003,0x00000000,0x00000000}},	//   合同, 田市, --, --,
   {{0xf913000a,0x00000000,0x00000000,0x00000000}},	//   深圳, --, --, --,
   {{0xf4c2401c,0xf91f2002,0x00000000,0x00000000}},	//   有限, 內地, --, --,
   {{0xf82a0002,0xfb749005,0x00000000,0x00000000}},	//   康促, 烘焙, --, --,
   {{0xf923a010,0xf9462003,0x00000000,0x00000000}},	//   の名, 不快, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf944e002,0xfa86e006,0xf9376006,0x00000000}},	//   國外, 溫泉, 高山, --,
   {{0xf5a94006,0xf5a6f006,0xf929e010,0xfa6ba019}},	//   件者, 式脂, を忘, 晶显,
   {{0xf8418007,0xfa63e002,0xf5b3d006,0xf5bd7003}},	//   第二, 國文, 滿足, で自,
   {{0xf91e0006,0xfb889004,0xfa78a00b,0xfb8ab006}},	//   婦女, 栏目, 人次, 明白,
   {{0xfb74c009,0xfa68f003,0xf91b800a,0xf942d006}},	//   通知, 家族, 大型, 月初,
   {{0xfa5e3007,0xfa663002,0xf942e00a,0xf9125006}},	// [0b0] 市政, 國政, 有利, 簽名,
   {{0x0006e013,0xf8483003,0xf82c7004,0x00000000}},	//   ㄏㄏ, に保, 维修, --,
   {{0xf91a7004,0xf9323004,0xf4bc6006,0xfb740006}},	//   符合, 投入, 考量, 博物,
   {{0xfb5e801c,0xfa562006,0xf5c8f01a,0x00000000}},	//   管理, 記本, 部落, --,
   {{0xf5c54018,0xfb86c006,0x00000000,0x00000000}},	//   の著, 告知, --, --,
   {{0xf945f007,0xf910c00b,0x00000000,0x00000000}},	//   不得, 避免, --, --,
   {{0xf8401006,0xfb6e1011,0xf492a00e,0x00000000}},	//   監事, 北省, 能量, --,
   {{0xf5b6d006,0xf91c500d,0xfa63a00b,0x00000000}},	//   曼谷, 书店, 事故, --,
   {{0xfa781003,0xfa869014,0xfb57d00b,0x00000000}},	//   効果, 全文, 書籍, --,
   {{0xf9136006,0x00000000,0x00000000,0x00000000}},	//   放器, --, --, --,
   {{0xfa88d002,0xfa5e9006,0xfa665014,0x00000000}},	//   全政, 謄本, 希望, --,
   {{0xf935b002,0xf81d6002,0x00000000,0x00000000}},	//   務工, 時代, --, --,
   {{0xf8149006,0xf4a21006,0xf9439002,0xf83cb00b}},	//   啟事, 班途, 開心, 加上,
   {{0xfb57e003,0xfa579004,0x00000000,0x00000000}},	//   攻略, 变更, --, --,
   {{0xfb578007,0xf496b005,0xfb591008,0xf5949006}},	//   主管, 基隆, 學生, 記者,
   {{0xfa6c4002,0xfa745002,0x00000000,0x00000000}},	//   男性, 調整, --, --,
   {{0xf9470006,0xf812d00b,0x00000000,0x00000000}},	// [0c0] 納入, 留下, --, --,
   {{0xfb5fa006,0xfb864006,0xf5b35002,0x00000000}},	//   你知, 國社, 發行, --,
   {{0xf90cf014,0xf91c500b,0xfa821006,0x00000000}},	//   年度, 另外, 面板, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf9129002,0xf8213014,0x00000000,0x00000000}},	//   總局, 有一, --, --,
   {{0xf4a04009,0xfb832006,0xfb7b2006,0xf843100a}},	//   务院, 國立, 市立, 第五,
   {{0xf4b75007,0xf929c009,0xf90c500a,0xfa734011}},	//   保障, 结合, 水利, 政执,
   {{0xfa5f3010,0xf93f2010,0xf9151003,0xf490800d}},	//   い方, い出, 現地, 英雄,
   {{0xf93b7003,0xf9288002,0xf5c39003,0xf9415005}},	//   一度, 木工, の行, 轉寄,
   {{0xf91f500a,0xf92d0004,0xf917f005,0x00000000}},	//   形式, 监察, 人士, --,
   {{0xfa526011,0xf923c003,0xfb537004,0xfa88d003}},	//   坚持, の小, 儿童, に比,
   {{0xf9162010,0xfa71c004,0xf5992014,0xf90f6006}},	//   購入, 长期, 需要, 女子,
   {{0xf4a61004,0xf9323011,0x00000000,0x00000000}},	//   质量, 业和, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa53a004,0xf841c014,0xf83e9006,0x00000000}},	//   进性, 第一, 大使, --,
   {{0xf9195009,0xfb6f0006,0xf497f006,0xfa869006}},	// [0d0] 报告, 取締, 數量, 風情,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf5ca5010,0x00000000,0x00000000,0x00000000}},	//   に追, --, --, --,
   {{0xf818e004,0xf923b006,0x00000000,0x00000000}},	//   简介, 中山, --, --,
   {{0xfa554004,0x00000000,0x00000000,0x00000000}},	//   这次, --, --, --,
   {{0xf83bf003,0xf8442002,0x00000000,0x00000000}},	//   で一, 本人, --, --,
   {{0xf820b00a,0xfb870006,0xf9461005,0xf93a9005}},	//   集中, 不知, 名字, 老婆,
   {{0xfa57600b,0x00000000,0x00000000,0x00000000}},	//   生日, --, --, --,
   {{0xfa6d0007,0x00000000,0x00000000,0x00000000}},	//   直接, --, --, --,
   {{0xf945b003,0xf938d006,0xfa52d006,0x00000000}},	//   立大, 門前, 雙手, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa8a5006,0xfb6ae00b,0x00000000,0x00000000}},	//   繪本, 航空, --, --,
   {{0xf938d009,0xf8128009,0xf910500b,0xfa581006}},	//   开始, 给予, 即可, 機械,
   {{0xfa66d003,0xf5b52008,0xf937b002,0xfa7e200b}},	//   住所, 發表, 關心, 造成,
   {{0xf845b00d,0xf91ae00b,0x00000000,0x00000000}},	//   在今, 常常, --, --,
   {{0xf93a800b,0xfa5c9006,0x00000000,0x00000000}},	// [0e0] 所得, 的最, --, --,
   {{0xfa5a200d,0x00000000,0x00000000,0x00000000}},	//   作日, --, --, --,
   {{0xf92ae002,0x00000000,0x00000000,0x00000000}},	//   豐富, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa8b4004,0xf93e000a,0xf9400006,0x00000000}},	//   措施, 市建, 的年, --,
   {{0xfa713006,0xf9385002,0xf4bd7006,0xf921b002}},	//   傳承, 勞工, 宅配, 萬元,
   {{0xf923e003,0xfa75100d,0xf59f000d,0x00000000}},	//   宮城, 导演, 的若, --,
   {{0xf5c57003,0xf490e003,0xfb7d7006,0x00000000}},	//   の表, 共通, 還真, --,
   {{0xf90de003,0xf9465006,0xf82f1003,0x00000000}},	//   観光, 服器, グ一, --,
   {{0xf4a57003,0xf90fe006,0x00000000,0x00000000}},	//   の部, 進出, --, --,
   {{0xfb5bd009,0xf92ac003,0xf9234012,0x00000000}},	//   学生, を受, 趣味, --,
   {{0xf92f3007,0xfa5be002,0xf81f2003,0xf930300a}},	//   法律, 區政, い人, 法定,
   {{0xfa756006,0xf944b00b,0x00000000,0x00000000}},	//   於本, 案工, --, --,
   {{0xf941600a,0xf80bc003,0xf5b61003,0xf4c04011}},	//   指南, 向上, 発行, 过错,
   {{0xf9379006,0xfa759008,0x00000000,0x00000000}},	//   凝土, 落格, --, --,
   {{0xfa4c1003,0x00000000,0x00000000,0x00000000}},	//   近所, --, --, --,
   {{0xf4ca0011,0x00000000,0x00000000,0x00000000}},	// [0f0] 透露, --, --, --,
   {{0xfa775006,0xf5b15004,0x00000000,0x00000000}},	//   人感, 现象, --, --,
   {{0xf90b4003,0xf93a3004,0xfa52a00b,0x00000000}},	//   海外, 作出, 教授, --,
   {{0xf80f0003,0x00000000,0x00000000,0x00000000}},	//   世代, --, --, --,
   {{0xf80c3002,0xf926300a,0x00000000,0x00000000}},	//   們一, 全市, --, --,
   {{0xf921d007,0xf814f006,0xfb7ec00a,0x00000000}},	//   第十, 原住, 的管, --,
   {{0xf59e8006,0xf9287003,0xfb7b0006,0x00000000}},	//   來越, に向, 節目, --,
   {{0xfb7f5012,0xfa497003,0xf90ee006,0x00000000}},	//   装置, を求, 地名, --,
   {{0xfa783009,0xf83a9006,0xf936d006,0xfb56f005}},	//   基本, 辦事, 高出, 麻煩,
   {{0xf93bf003,0xf49ae004,0xfa696002,0xfa5e2006}},	//   広告, 报道, 澎湖, 的木,
   {{0xfa86a003,0xf5b2c00a,0xf9356003,0xf49f8004}},	//   注文, 山西, た商, 删除,
   {{0xf9326002,0xf9098006,0x00000000,0x00000000}},	//   招募, 當初, --, --,
   {{0xf91ac006,0xfa716011,0x00000000,0x00000000}},	//   學出, 长沙, --, --,
   {{0xf707801d,0xf9249003,0xf4ae700a,0xf9089006}},	//   훌륭, は全, 抗震, 當前,
   {{0xf814e004,0xf9392002,0xfa7bf00b,0x00000000}},	//   会主, 門市, 大概, --,
   {{0xf9454003,0xf83ae00b,0x00000000,0x00000000}},	//   同和, 另一, --, --,
   {{0xf93d7004,0xf9207003,0xf921c004,0xf499500b}},	// [100] 的原, ち度, 代化, 人都,
   {{0xfb819004,0xf90fb00d,0x00000000,0x00000000}},	//   采用, 河北, --, --,
   {{0xfa83e003,0xf8442008,0xf93fb006,0x00000000}},	//   の流, 責任, 情形, --,
   {{0xfa5ef006,0xf5c73003,0xf90b4009,0x00000000}},	//   了最, に行, 收入, --,
   {{0xf93f4006,0xf5bb3004,0x00000000,0x00000000}},	//   寄出, 来自, --, --,
   {{0xf58c400d,0xfa840002,0xf59ca00b,0xf9368006}},	//   发言, 華民, 的老, 功夫,
   {{0xf8353004,0xf49a4002,0xf5a7900a,0xfb7c6006}},	//   国人, 學院, 才能, 會福,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb8a5006,0xfa66d006,0xf934e00b,0x00000000}},	//   李登, 緊急, 察局, --,
   {{0xfb83c002,0xf81c6010,0xf82a501a,0x00000000}},	//   專用, 送信, 其他, --,
   {{0xf5b7e003,0x00000000,0x00000000,0x00000000}},	//   発表, --, --, --,
   {{0xf8232010,0xfa840006,0xf9257003,0xf9248003}},	//   る事, 喬治, の全, の多,
   {{0xf93ae013,0xf4c58003,0xfb6ca002,0x00000000}},	//   最夯, お酒, 預算, --,
   {{0xfb895002,0xf921d00a,0xfa5c0004,0xfa85a003}},	//   族群, 京市, 开放, の支,
   {{0xf5a43005,0xfb656006,0xf931800b,0x00000000}},	//   興趣, 顯示, 四十, --,
   {{0xf815c002,0xf925b003,0xfa5d4004,0xfa5c900b}},	//   務人, の公, 的思, 一段,
   {{0xf93b0006,0xfb628008,0x00000000,0x00000000}},	// [110] 要回, 監督, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf5bc1005,0xf90fb00a,0xfa860004,0x00000000}},	//   實踐, 河南, 注明, --,
   {{0xf91f5006,0xf81a000b,0x00000000,0x00000000}},	//   產品, 十二, --, --,
   {{0xfa65700a,0xf5c1a00a,0xf9388014,0xf93b600b}},	//   同意, 形象, 非常, 最大,
   {{0xf4a1c006,0xf81a300a,0xf9136006,0x00000000}},	//   公頃, 作人, 爾夫, --,
   {{0xfa76f004,0x00000000,0x00000000,0x00000000}},	//   养殖, --, --, --,
   {{0xf9254003,0xf5a02006,0xf9361006,0xf9146006}},	//   の外, 資者, 原子, 找出,
   {{0xf92c7009,0xf5bb0003,0xfb50f006,0xf83cc003}},	//   发布, 芸能, 想知, で作,
   {{0xf4992007,0xf4ad4004,0xf910600b,0x00000000}},	//   方面, 频道, 到底, --,
   {{0xf5901006,0xf4b56010,0xfb867003,0xfa845003}},	//   動者, 募集, が生, の文,
   {{0xf93f100a,0xfb82d002,0xf93c600b,0x00000000}},	//   的基, 應用, 七十, --,
   {{0xf92e500a,0xfb7f6006,0xfa643004,0x00000000}},	//   湖南, 稅目, 克思, --,
   {{0xfb4ff010,0xf9481011,0xf5c47003,0xf4c51011}},	//   掲示, 职工, は自, 不错,
   {{0xfb60b006,0xfb545002,0xf9240006,0x00000000}},	//   模特, 社群, 禮品, --,
   {{0xfa7a8006,0xfa5f5004,0x00000000,0x00000000}},	//   核武, 备案, --, --,
   {{0xfa7ac009,0xf814d004,0xf93fd004,0x00000000}},	// [120] 来源, 统一, 领域, --,
   {{0xf822f006,0xf935300a,0xf5c91003,0x00000000}},	//   之事, 做好, に表, --,
   {{0xf9118003,0x00000000,0x00000000,0x00000000}},	//   放同, --, --, --,
   {{0xf936b006,0xfa4c9002,0x00000000,0x00000000}},	//   藝品, 恐怖, --, --,
   {{0xfa4de018,0xfb605003,0xf4c54003,0xfa7d9006}},	//   気持, 業界, 予防, 警方,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf4bda009,0xf933c004,0x00000000,0x00000000}},	//   资金, 进入, --, --,
   {{0xf5a4d007,0xf82b6004,0x00000000,0x00000000}},	//   重要, 况下, --, --,
   {{0xf918c00a,0x00000000,0x00000000,0x00000000}},	//   人大, --, --, --,
   {{0xf940800a,0x00000000,0x00000000,0x00000000}},	//   分娩, --, --, --,
   {{0xf9454017,0xfa5e4006,0xfa4d3006,0xfb7fb006}},	//   開催, 市松, 汐止, 羅素,
   {{0xf8158009,0xf5c55003,0xfa4f6002,0x00000000}},	//   办事, の自, 苗栗, --,
   {{0xf81b900b,0xf9354006,0x00000000,0x00000000}},	//   十五, 期待, --, --,
   {{0xfb7e1006,0xf826a00b,0x00000000,0x00000000}},	//   的火, 事件, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf825d00a,0xf4b9a00b,0x00000000,0x00000000}},	//   事人, 最高, --, --,
   {{0xfa838010,0xf909e004,0xf9198004,0xf811e00b}},	// [130] の手, 海市, 出台, 晚上,
   {{0xf94a8002,0x00000000,0x00000000,0x00000000}},	//   美容, --, --, --,
   {{0xf9465006,0xf49d0004,0xf923a010,0xfa631003}},	//   之女, 学院, の前, 合成,
   {{0xf922e002,0xf8361004,0x00000000,0x00000000}},	//   代役, 人事, --, --,
   {{0xfb7f7004,0xf91dd006,0xf9219002,0xfb645006}},	//   过程, 怡半, 本局, 緬甸,
   {{0xf81a400b,0xf5bac006,0x00000000,0x00000000}},	//   十一, 接近, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf59e5006,0xf9279004,0xfb7ea006,0x00000000}},	//   善良, 扩大, 元素, --,
   {{0xfa57d007,0xfa7d8006,0xfb49d00d,0x00000000}},	//   依法, 大早, 户籍, --,
   {{0xfa53e011,0xf9263006,0xf939000b,0x00000000}},	//   浙江, 孩子, 保健, --,
   {{0xfa54b009,0x00000000,0x00000000,0x00000000}},	//   创新, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf91bf002,0xfa5ce004,0xf927700d,0x00000000}},	//   哥大, 的情, 在北, --,
   {{0xf91bb006,0xf9372006,0x00000000,0x00000000}},	//   學年, 綜合, --, --,
   {{0xf825900a,0xf91e4011,0xf91cc00b,0x00000000}},	//   案件, 务局, 造型, --,
   {{0xf9258003,0xf58f400a,0xfb6e7011,0xfb51b006}},	//   の利, 法行, 民群, 誰知,
   {{0xf492e006,0x00000000,0x00000000,0x00000000}},	// [140] 現金, --, --, --,
   {{0xfb734003,0xf92f900b,0x00000000,0x00000000}},	//   厚生, 我家, --, --,
   {{0xf9278002,0xf91ab006,0x00000000,0x00000000}},	//   復健, 日子, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf5c0f010,0xfa597006,0xf837d002,0x00000000}},	//   読者, 戀情, 數位, --,
   {{0xfb68c018,0xfb534006,0x00000000,0x00000000}},	//   表示, 鋼筋, --, --,
   {{0xf842f003,0xfb7c1004,0x00000000,0x00000000}},	//   は一, 权益, --, --,
   {{0xf9174002,0xfa5e9006,0x00000000,0x00000000}},	//   竹市, 情感, --, --,
   {{0xfb4c0006,0xf911d006,0xf9257006,0x00000000}},	//   寶石, 田尾, 是出, --,
   {{0xfa527011,0xf81d5006,0x00000000,0x00000000}},	//   业技, 故事, --, --,
   {{0xf9367010,0x00000000,0x00000000,0x00000000}},	//   機器, --, --, --,
   {{0xf9242005,0xf912b002,0xf91db006,0xf844600b}},	//   公尺, 共工, 無奈, 是他,
   {{0xf919a003,0xf58b6003,0xf9117006,0xf5be700e}},	//   津市, を解, 鳳山, 葡萄,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa5fc00a,0xf926b004,0xf81a6006,0x00000000}},	//   文明, 动力, 简体, --,
   {{0xf93cf00a,0xfa6e7002,0x00000000,0x00000000}},	//   的商, 郵政, --, --,
   {{0xfa62f006,0x00000000,0x00000000,0x00000000}},	// [150] 葉振, --, --, --,
   {{0xf9237002,0xfa7ba006,0xf5a8d003,0xfa708006}},	//   售屋, 日止, が起, 西洋,
   {{0xf936e006,0xfb4a0003,0xfb52601a,0x00000000}},	//   增回, 究科, 使用, --,
   {{0xf8241004,0xf81ef00b,0x00000000,0x00000000}},	//   不予, 元以, --, --,
   {{0xf843d003,0xfa86800a,0xfb6eb006,0x00000000}},	//   の一, 修改, 我知, --,
   {{0xf8283003,0xf93fe003,0xf4903006,0x00000000}},	//   二人, 縄地, 罰金, --,
   {{0xfa763003,0xf9299006,0xf92e0004,0xf928100a}},	//   発明, 毒品, 帖子, 革命,
   {{0xfb55f00b,0x00000000,0x00000000,0x00000000}},	//   建築, --, --, --,
   {{0xf5980009,0xf9482010,0xf8365002,0xf947900d}},	//   作者, が出, 為一, 后再,
   {{0xf49ad014,0x00000000,0x00000000,0x00000000}},	//   知道, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf92e400a,0xfa767006,0xf4c5a00b,0x00000000}},	//   取得, 繼承, 不限, --,
   {{0xfa7eb018,0xf9174004,0xfb7ca006,0x00000000}},	//   無料, 区域, 的私, --,
   {{0xf8464003,0xf92b1006,0xfa809006,0x00000000}},	//   の交, 說出, 中最, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa621006,0xf93ab006,0xf8133002,0xf9448006}},	//   有感, 讀取, 這一, 養品,
   {{0xfa5e9006,0x00000000,0x00000000,0x00000000}},	// [160] 範本, --, --, --,
   {{0xfb59c006,0xf494c002,0x00000000,0x00000000}},	//   書目, 製造, --, --,
   {{0xf8392007,0xf5b89006,0xfa5ad004,0x00000000}},	//   以上, 學者, 要思, --,
   {{0xf912b010,0xf90c7002,0xfa6db006,0xf847d006}},	//   製品, 職工, 色情, 天使,
   {{0xf59a7005,0xf819f002,0x00000000,0x00000000}},	//   威脅, 條件, --, --,
   {{0xf5a9b002,0xf5c8f003,0xf8091006,0xfb7fe006}},	//   執行, に自, 沒事, 爆笑,
   {{0xfb859003,0xf947b006,0xf9128003,0xfb701008}},	//   再生, 獎名, 東大, 處理,
   {{0xfb77f006,0xf941200b,0x00000000,0x00000000}},	//   土石, 三十, --, --,
   {{0xfa646003,0xf845700a,0x00000000,0x00000000}},	//   構成, 副主, --, --,
   {{0xfb711009,0xf9313002,0xfa888010,0xf947100a}},	//   联系, 列印, 昨日, 重大,
   {{0xfa71d008,0xf91c700a,0xf8253003,0xfb51a004}},	//   地政, 大力, が上, 设立,
   {{0xfa822004,0xf8103010,0x00000000,0x00000000}},	//   财政, 受信, --, --,
   {{0xfa6dc003,0xfb672010,0xfb819004,0x00000000}},	//   更新, に立, 文物, --,
   {{0xf93f8003,0xf942300a,0x00000000,0x00000000}},	//   心地, 理念, --, --,
   {{0xf9334002,0xfa61d006,0xfa57600d,0x00000000}},	//   務局, 與本, 生死, --,
   {{0xfb7da004,0xf90c6006,0x00000000,0x00000000}},	//   调研, 陷入, --, --,
   {{0xf4a88003,0xfa845003,0xf49e5004,0x00000000}},	// [170] に限, の指, 渠道, --,
   {{0xfa4e1003,0xf4a76006,0x00000000,0x00000000}},	//   ご案, 用途, --, --,
   {{0xf928f00a,0xf92af002,0xfb668003,0x00000000}},	//   努力, 壓力, の相, --,
   {{0xfa6eb006,0xf9492006,0x00000000,0x00000000}},	//   詳情, 二年, --, --,
   {{0xf80bd003,0xfa77a003,0x00000000,0x00000000}},	//   子供, 活性, --, --,
   {{0xf59d8011,0xf5b40006,0xf90fb008,0x00000000}},	//   雅虎, 貼者, 報告, --,
   {{0xfa5ff007,0xf90ba006,0xfa768002,0xfb877006}},	//   分析, 念品, 診所, 題目,
   {{0xf9443006,0xf90c0002,0xf5a66004,0xf8247014}},	//   之土, 當地, 不良, 上一,
   {{0xf8461003,0xfb63b010,0x00000000,0x00000000}},	//   と一, の美, --, --,
   {{0xfa5a3007,0xf83e6003,0xf944900a,0xf924b00b}},	//   要求, 大人, 上市, 公共,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf4ab0006,0xfa5c4014,0x00000000,0x00000000}},	//   限量, 如果, --, --,
   {{0xf9134003,0xfa60f002,0xfa4cb006,0x00000000}},	//   格安, 證明, 首歌, --,
   {{0xf931e00a,0xf91d0010,0x00000000,0x00000000}},	//   招商, 映像, --, --,
   {{0xf82ae003,0xfb5a8003,0x00000000,0x00000000}},	//   件中, 学等, --, --,
   {{0xfb831006,0xfa82f006,0xf9114006,0xf9261006}},	//   指甲, 正方, 百合, 用品,
   {{0xf497a010,0xfb831006,0x00000000,0x00000000}},	// [180] 特集, 開立, --, --,
   {{0xf830e00a,0xf937300a,0x00000000,0x00000000}},	//   女人, 速度, --, --,
   {{0xf933e004,0xf9438006,0xfa737006,0x00000000}},	//   业化, 載入, 西方, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa675006,0xf9313006,0x00000000,0x00000000}},	//   反方, 演出, --, --,
   {{0xf4a3e003,0xfa82f006,0x00000000,0x00000000}},	//   是非, 是最, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb839007,0xf5bdf008,0xfb626006,0xf93ee00b}},	//   按照, 歡迎, 設置, 分局,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf914b003,0xf81d6006,0xfb866003,0xf923a00a}},	//   追加, 情事, 同盟, 第六,
   {{0xfa819002,0xf949d006,0xf592d00a,0x00000000}},	//   公所, 小女, 引起, --,
   {{0xf9405009,0xfb82a006,0xf9227006,0x00000000}},	//   内容, 文稿, 聯合, --,
   {{0xfa666006,0xfa66c006,0x00000000,0x00000000}},	//   請河, 題材, --, --,
   {{0xf9298006,0xf8477003,0xf824800a,0xfa5a6006}},	//   太子, に一, 前位, 要情,
   {{0xf946000a,0xf90cb00a,0xf5b5a006,0x00000000}},	//   完善, 更加, 費者, --,
   {{0xf9127006,0xfa809006,0x00000000,0x00000000}},	// [190] 命名, 維持, --, --,
   {{0xf80fe009,0xfb708003,0xfa73b006,0x00000000}},	//   北京, 誕生, 格最, --,
   {{0xf948200a,0xfb743004,0xfa683004,0x00000000}},	//   美元, 优秀, 双方, --,
   {{0xf92e2008,0xf8260003,0xf8300002,0xf9144006}},	//   北市, 友人, 統一, 放入,
   {{0xfa798011,0xf93b800b,0x00000000,0x00000000}},	//   机械, 一大, --, --,
   {{0xf926e003,0xf91d2003,0x00000000,0x00000000}},	//   撮影, て大, --, --,
   {{0xf844a003,0xfa659002,0xfa695002,0xfa5b7006}},	//   の作, 變成, 每日, 一旦,
   {{0xf93cb002,0x00000000,0x00000000,0x00000000}},	//   雄市, --, --, --,
   {{0xf923a003,0xfa4bf008,0xf9121006,0x00000000}},	//   の反, 結果, 房子, --,
   {{0xf8212006,0xf9171002,0x00000000,0x00000000}},	//   來信, 決定, --, --,
   {{0xfa76f004,0x00000000,0x00000000,0x00000000}},	//   论文, --, --, --,
   {{0xf4c22011,0x00000000,0x00000000,0x00000000}},	//   合适, --, --, --,
   {{0xfa56d006,0x00000000,0x00000000,0x00000000}},	//   官方, --, --, --,
   {{0xf9126004,0xfb80e006,0xf8309006,0x00000000}},	//   丰台, 鄉立, 政事, --,
   {{0xf4914002,0xf9440010,0x00000000,0x00000000}},	//   報道, お友, --, --,
   {{0xfa82a002,0xf5a1000a,0xf5c40003,0xfa66e009}},	//   中正, 了解, の考, 反映,
   {{0xf9292003,0xf92b7003,0x00000000,0x00000000}},	// [1a0] 阪府, を加, --, --,
   {{0xf59d6003,0xf93a0006,0xf9423006,0x00000000}},	//   旅行, 九年, 版品, --,
   {{0xfa6f1004,0x00000000,0x00000000,0x00000000}},	//   声明, --, --, --,
   {{0xf58f900b,0xfa84d006,0x00000000,0x00000000}},	//   列表, 是本, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf80f3010,0xfb55b00a,0xfa63a006,0xf90ec002}},	//   仕事, 治理, 事情, 獲得,
   {{0xf5b2300d,0x00000000,0x00000000,0x00000000}},	//   兰花, --, --, --,
   {{0xfb6cc004,0xf91e4003,0xf918e004,0xf596401b}},	//   体系, で大, 许多, 秘訣,
   {{0xf58de009,0xfa6a7010,0xf81c100b,0xf90b0006}},	//   发表, 毎日, 最佳, 男子,
   {{0xfa64c003,0xf910600a,0x00000000,0x00000000}},	//   手法, 西安, --, --,
   {{0xf9417004,0xfa63d00a,0x00000000,0x00000000}},	//   采取, 廉政, --, --,
   {{0xfa57c018,0xf9270003,0xf80b4003,0x00000000}},	//   実施, の地, を中, --,
   {{0xfb55e004,0xfb60a006,0x00000000,0x00000000}},	//   追究, 員登, --, --,
   {{0xfa580003,0xfa5fc00a,0xf935b006,0xf935a002}},	//   感想, 的新, 從前, 記得,
   {{0xfa66d007,0xf92b2003,0xfb65a006,0xfa5d6006}},	//   完成, 結局, 禮物, 終止,
   {{0xf910a002,0xf80a1003,0xf924b006,0x00000000}},	//   彰化, を保, 適合, --,
   {{0xfb4d3008,0xf82cc00b,0x00000000,0x00000000}},	// [1b0] 課程, 年代, --, --,
   {{0xf9360007,0xf4a85017,0xf59b1006,0x00000000}},	//   州市, 太郎, 一般, --,
   {{0xf934e011,0x00000000,0x00000000,0x00000000}},	//   党建, --, --, --,
   {{0xfb686009,0xf4b3a004,0x00000000,0x00000000}},	//   卫生, 创造, --, --,
   {{0xf4a49003,0x00000000,0x00000000,0x00000000}},	//   京都, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf8386004,0xfa556002,0x00000000,0x00000000}},	//   为中, 這次, --, --,
   {{0xf936f003,0xf9257003,0x00000000,0x00000000}},	//   初心, の周, --, --,
   {{0xfb548006,0x00000000,0x00000000,0x00000000}},	//   眼神, --, --, --,
   {{0xf59da003,0xf916b010,0xfa857010,0xf498b013}},	//   必要, 彼女, の注, 烹飪,
   {{0xfa610003,0xf9297002,0xf5b56006,0xfb7f6006}},	//   清水, 編制, 追追, 的白,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf911c011,0xfb56e003,0xfb873006,0xf9181002}},	//   广州, 活用, 才知, 書局,
   {{0xfa58e004,0xfa528006,0xfb5ef003,0xf944b002}},	//   实施, 定最, 校生, 立委,
   {{0xfa6ef002,0xf818e014,0x00000000,0x00000000}},	//   創新, 一下, --, --,
   {{0xf83a8003,0xfa861014,0x00000000,0x00000000}},	//   て下, 注意, --, --,
   {{0xfb6fb002,0x00000000,0x00000000,0x00000000}},	// [1c0] 字第, --, --, --,
   {{0xf93a7004,0xf4966010,0xfb518006,0xf5a7a00a}},	//   开展, 発送, 新知, 上述,
   {{0xf84b0009,0xf923000a,0x00000000,0x00000000}},	//   个人, 正常, --, --,
   {{0xf5c64003,0x00000000,0x00000000,0x00000000}},	//   と考, --, --, --,
   {{0xf90cc009,0xf811f002,0xf5b1b004,0xf5b01006}},	//   电子, 法令, 举行, 鄰近,
   {{0xf912400d,0x00000000,0x00000000,0x00000000}},	//   西北, --, --, --,
   {{0xf9360006,0xf843c009,0xf9144002,0x00000000}},	//   保守, 环保, 政制, --,
   {{0xfb72c013,0xf847f006,0xf924e011,0xfb7fd013}},	//   忙碌, 物使, 港口, 約翰,
   {{0xf5bda010,0xf92ab003,0x00000000,0x00000000}},	//   信越, を得, --, --,
   {{0xfb7db003,0xf4bfd004,0xfa656006,0x00000000}},	//   参照, 预防, 歌手, --,
   {{0xfb614004,0xfa879005,0x00000000,0x00000000}},	//   独立, 表演, --, --,
   {{0xf922500a,0xfa702006,0x00000000,0x00000000}},	//   第四, 色派, --, --,
   {{0xfb6e4004,0xf925d003,0xfa7c4019,0xf9415014}},	//   监督, と同, 警惕, 文字,
   {{0xf9445014,0x00000000,0x00000000,0x00000000}},	//   不同, --, --, --,
   {{0xf5bcf00a,0xf4996014,0x00000000,0x00000000}},	//   日起, 交通, --, --,
   {{0xf9325006,0xfb4fa004,0x00000000,0x00000000}},	//   減少, 佳答, --, --,
   {{0xf947f007,0xf58d6009,0xf92c7004,0xf8120004}},	// [1d0] 城市, 体育, 首先, 会上,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf940a003,0xf91e500b,0xfb76c006,0x00000000}},	//   指定, 股市, 搞笑, --,
   {{0xfa87f00d,0xfb58a004,0xf92fd006,0x00000000}},	//   个月, 费用, 孔子, --,
   {{0xf9476003,0xf91c3006,0x00000000,0x00000000}},	//   が可, 日出, --, --,
   {{0xf9467006,0xf90ed004,0xfb57e006,0x00000000}},	//   國女, 电影, 決策, --,
   {{0xf941400a,0xf92cc004,0xf90b4004,0xf9401004}},	//   理工, 输入, 鉴定, 商引,
   {{0xfa6f6003,0xf941f00f,0xfa4ff013,0xfb4d4019}},	//   平成, 历史, 洗澡, 爷爷,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf946a013,0xf927c002,0x00000000,0x00000000}},	//   伊凡, 在天, --, --,
   {{0xfa517002,0xf81f3006,0xf81e700b,0x00000000}},	//   四技, 會使, 的中, --,
   {{0xfa7a2008,0xfa665002,0x00000000,0x00000000}},	//   價格, 每月, --, --,
   {{0xf9240003,0x00000000,0x00000000,0x00000000}},	//   京大, --, --, --,
   {{0xf92bb003,0xf9253014,0x00000000,0x00000000}},	//   限定, 是否, --, --,
   {{0xf910700d,0xfb53c004,0x00000000,0x00000000}},	//   数字, 设置, --, --,
   {{0xf9436002,0xfa83c003,0x00000000,0x00000000}},	//   個小, の意, --, --,
   {{0xfb5d6006,0xf945f002,0xfa5cf006,0x00000000}},	// [1e0] 大火, 變化, 燃料, --,
   {{0xf4956006,0x00000000,0x00000000,0x00000000}},	//   電量, --, --, --,
   {{0xfa4b5017,0xf938d006,0x00000000,0x00000000}},	//   を探, 一半, --, --,
   {{0xf9199004,0xfb652004,0xfb7d4006,0x00000000}},	//   报名, 问答, 頂端, --,
   {{0xf9304008,0xf91b4003,0x00000000,0x00000000}},	//   志工, 陸地, --, --,
   {{0xf4b57013,0xfa78f004,0xf9395002,0xfb7f100d}},	//   回饋, 根本, 紀元, 的空,
   {{0xfa892002,0x00000000,0x00000000,0x00000000}},	//   風格, --, --, --,
   {{0xf918e006,0xf9240007,0xf917700b,0xf94a5005}},	//   人履, 公室, 改善, 過去,
   {{0xf9313003,0xf8336004,0xf94a5006,0x00000000}},	//   北地, 政主, 每年, --,
   {{0xf49fb009,0xfa661004,0xf93cc004,0xf5a26013}},	//   管部, 行情, 证券, 草莓,
   {{0xf9236003,0x00000000,0x00000000,0x00000000}},	//   の光, --, --, --,
   {{0xf9304003,0xfa73c00a,0xfa544006,0x00000000}},	//   ご利, 能源, 教材, --,
   {{0xf143901e,0xffe6b017,0x00000000,0x00000000}},	//   역삼, のソ, --, --,
   {{0xfb645003,0xfb85101b,0xf4968002,0xf837900b}},	//   修理, 珊瑚, 頻道, 死亡,
   {{0xf81c600a,0xf9218003,0xf49e0006,0x00000000}},	//   的位, 薬局, 素食, --,
   {{0xf9132004,0xfa85b006,0x00000000,0x00000000}},	//   广大, 用手, --, --,
   {{0xfb8ac006,0xf5927004,0x00000000,0x00000000}},	// [1f0] 美白, 陕西, --, --,
   {{0xf836b018,0xf9321006,0xfb763006,0xf93c300b}},	//   紹介, 展出, 沙田, 十六,
   {{0xf91ea00a,0xf9157011,0xf5b3e004,0xfa742019}},	//   加快, 总局, 绿色, 百慧,
   {{0xfa891010,0x00000000,0x00000000,0x00000000}},	//   に注, --, --, --,
   {{0xf8403004,0x00000000,0x00000000,0x00000000}},	//   务中, --, --, --,
   {{0xf946c003,0xfb5ea003,0xf82c6004,0xfa860002}},	//   残念, 無理, 请人, 修正,
   {{0xf81ec011,0xf80c400b,0xfa4f0006,0x00000000}},	//   的信, 我一, 拖欠, --,
   {{0xf9321006,0xf83c3002,0xfa847006,0xfb864006}},	//   多半, 日人, 魯木, 植物,
   {{0xf92c6004,0x00000000,0x00000000,0x00000000}},	//   我市, --, --, --,
   {{0xf9142003,0xf4bed00d,0xf912d00b,0xfa63a00b}},	//   畿地, 视野, 都市, 之旅,
   {{0xf4978004,0xf93d5006,0x00000000,0x00000000}},	//   医院, 較少, --, --,
   {{0xf4b55010,0x00000000,0x00000000,0x00000000}},	//   真集, --, --, --,
   {{0xf8287006,0xf9124002,0x00000000,0x00000000}},	//   當事, 好友, --, --,
   {{0xf4c0e003,0xfa6eb002,0xfa5c5006,0x00000000}},	//   三重, 雲林, 的歌, --,
   {{0xfb539006,0x00000000,0x00000000,0x00000000}},	//   好笑, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [200] --, --, --, --,
   {{0xf5891003,0xfb735004,0xf81ca00a,0xfa577004}},	//   を行, 业生, 的企, 高新,
   {{0xf90af014,0xfa5c0006,0x00000000,0x00000000}},	//   家庭, 言板, --, --,
   {{0xfb761006,0xfa56e006,0x00000000,0x00000000}},	//   務白, 原本, --, --,
   {{0xfa6cc009,0xfa875003,0x00000000,0x00000000}},	//   价格, の水, --, --,
   {{0xfa6c3004,0xf9284002,0xfa649004,0x00000000}},	//   阶段, 溫州, 律法, --,
   {{0xfa72b010,0xf82fc002,0xf912300b,0x00000000}},	//   箱根, 環保, 百分, --,
   {{0xf9497004,0xf93fe00b,0x00000000,0x00000000}},	//   经典, 的家, --, --,
   {{0xf9368011,0xfb4b500d,0xf93e4006,0xf5a4a014}},	//   员工, 时空, 集合, 不要,
   {{0xfb79b018,0xfb659013,0xfa63d004,0x00000000}},	//   検索, 周秉, 友情, --,
   {{0xfb4f5006,0xf9479003,0x00000000,0x00000000}},	//   傳真, 越地, --, --,
   {{0xf4a1a006,0xf93aa00b,0x00000000,0x00000000}},	//   測量, 十分, --, --,
   {{0xfb795002,0xf80d800a,0xf48e5006,0x00000000}},	//   節省, 提交, 飲食, --,
   {{0xf84a9018,0xf915d003,0xf493b006,0xf824a00a}},	//   自信, 発光, 白金, 予以,
   {{0xf90b8006,0xf916b014,0xf90fc005,0x00000000}},	//   水土, 系列, 花卉, --,
   {{0xf9115002,0xf5a87004,0xfa77e004,0x00000000}},	//   影展, 职能, 系方, --,
   {{0xfa77b010,0xfb76b006,0xf93d2003,0xfa69a004}},	// [210] 出演, 期目, も可, 时期,
   {{0xf826e010,0x00000000,0x00000000,0x00000000}},	//   配信, --, --, --,
   {{0xf90ec00b,0x00000000,0x00000000,0x00000000}},	//   平均, --, --, --,
   {{0xf92a1009,0xfb62a002,0x00000000,0x00000000}},	//   当前, 監管, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf90e9004,0x00000000,0x00000000,0x00000000}},	//   阳市, --, --, --,
   {{0xfa661010,0xfa68c005,0x00000000,0x00000000}},	//   る方, 疏濬, --, --,
   {{0xfa735010,0xf91c5003,0xf9254003,0xf90aa004}},	//   稿日, 日常, は大, 伴奏,
   {{0xf9472012,0x00000000,0x00000000,0x00000000}},	//   住宅, --, --, --,
   {{0xf91ff008,0xf9450003,0x00000000,0x00000000}},	//   廣告, 反射, --, --,
   {{0xf9445006,0xf9378006,0xf93c9006,0xfa66000e}},	//   國土, 團年, 流出, 遊憩,
   {{0xf93d8009,0xf4a8200a,0xfa5dd00a,0xf83a6006}},	//   参加, 快速, 的法, 給予,
   {{0xf9166006,0x00000000,0x00000000,0x00000000}},	//   妻子, --, --, --,
   {{0xfa5d2009,0xf5a8a003,0xf946b003,0xf83b7006}},	//   资料, 野菜, 今度, 給付,
   {{0xf5b94004,0x00000000,0x00000000,0x00000000}},	//   履行, --, --, --,
   {{0xf58af003,0x00000000,0x00000000,0x00000000}},	//   を表, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [220] --, --, --, --,
   {{0xf838e004,0xfb582006,0x00000000,0x00000000}},	//   区人, 幸福, --, --,
   {{0xfb885004,0xfb860006,0x00000000,0x00000000}},	//   和社, 癌症, --, --,
   {{0xfb545004,0x00000000,0x00000000,0x00000000}},	//   显示, --, --, --,
   {{0xf815a002,0x00000000,0x00000000,0x00000000}},	//   生保, --, --, --,
   {{0xf9262003,0xfb881003,0xfa58f013,0x00000000}},	//   の大, 野球, 神拳, --,
   {{0xf5b1600d,0x00000000,0x00000000,0x00000000}},	//   艰苦, --, --, --,
   {{0xf9115006,0xf9171014,0x00000000,0x00000000}},	//   英子, 方式, --, --,
   {{0xf91a5003,0xfb769004,0xfa6f8002,0xf922f006}},	//   入力, 战略, 新文, 華夏,
   {{0xfa7de010,0xf93d500a,0xfa592006,0x00000000}},	//   て欲, 考察, 關注, --,
   {{0xf821500a,0xf9243003,0xf917e002,0xf819a00a}},	//   理人, の分, 永和, 作中,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf49bc011,0x00000000,0x00000000,0x00000000}},	//   大量, --, --, --,
   {{0xf93ea008,0x00000000,0x00000000,0x00000000}},	//   參加, --, --, --,
   {{0xfa7b8018,0xf4927002,0xf917e006,0xf8120006}},	//   日本, 沿革, 登入, 通事,
   {{0xfb86300b,0xf816300b,0x00000000,0x00000000}},	//   不用, 高中, --, --,
   {{0xf589b003,0x00000000,0x00000000,0x00000000}},	// [230] を超, --, --, --,
   {{0xf90b3007,0xf8438010,0xf59c500a,0xf848000a}},	//   更多, の事, 的行, 在中,
   {{0xf81bd003,0xf93c7014,0x00000000,0x00000000}},	//   終了, 的小, --, --,
   {{0xf942d003,0xfb60b00a,0xfa4bc006,0x00000000}},	//   予定, 代理, 民歌, --,
   {{0xfa849006,0xfa4d4003,0xfb7d900a,0xf9199011}},	//   公河, 外旅, 突破, 项工,
   {{0xf5a06002,0xf935f006,0xfa84e003,0x00000000}},	//   來自, 孟子, の成, --,
   {{0xf823f003,0x00000000,0x00000000,0x00000000}},	//   り上, --, --, --,
   {{0xf48de002,0xf91d9002,0xf4996003,0xfa88c006}},	//   創造, 廠商, 以降, 貨方,
   {{0xf81a700a,0xfb75a006,0xf8336002,0xfb4c1005}},	//   十七, 標示, 製作, 陶瓷,
   {{0xf8260003,0xf92ff011,0xf92f9004,0xfa78a005}},	//   る人, 窗口, 返回, 智慧,
   {{0xfb66d003,0x00000000,0x00000000,0x00000000}},	//   利用, --, --, --,
   {{0xfb51d006,0xf921a00a,0x00000000,0x00000000}},	//   新社, 杭州, --, --,
   {{0xfa7f3011,0xf9431008,0x00000000,0x00000000}},	//   污染, 開始, --, --,
   {{0xf82ac007,0xfa744003,0xfb7e7006,0x00000000}},	//   其中, 弾性, 清真, --,
   {{0xfa569006,0xf93c6013,0x00000000,0x00000000}},	//   土木, 寂寞, --, --,
   {{0xf8157006,0xf9190006,0x00000000,0x00000000}},	//   務信, 人出, --, --,
   {{0xf4a46003,0x00000000,0x00000000,0x00000000}},	// [240] の高, --, --, --,
   {{0xf948c006,0x00000000,0x00000000,0x00000000}},	//   里山, --, --, --,
   {{0xfa736011,0xf92cf002,0x00000000,0x00000000}},	//   政治, 經常, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa787003,0xf9340011,0xf925300d,0xfb512013}},	//   方法, 创建, 键字, 隱瞞,
   {{0xfa743004,0xfa4b2003,0xf9195006,0x00000000}},	//   链接, を支, 為女, --,
   {{0xf92e1004,0xfa7fb00b,0x00000000,0x00000000}},	//   联合, 加油, --, --,
   {{0xf916000f,0xf9293003,0xf9473003,0xf5c8100b}},	//   国家, と共, お好, 自行,
   {{0xfa59b007,0xf845e003,0xfa60f00a,0xf5ae800b}},	//   思想, の代, 震救, 想要,
   {{0xf5c20003,0xf9480004,0xf9286003,0x00000000}},	//   関西, 减少, と大, --,
   {{0xf914f006,0xf59cb006,0xf942d014,0x00000000}},	//   松山, 的脂, 很多, --,
   {{0xf919700b,0xf92a2006,0x00000000,0x00000000}},	//   書店, 姓名, --, --,
   {{0xf918200a,0x00000000,0x00000000,0x00000000}},	//   方向, --, --, --,
   {{0xfb664014,0x00000000,0x00000000,0x00000000}},	//   全球, --, --, --,
   {{0xf4c6c003,0xf5999006,0xf59e200b,0x00000000}},	//   削除, 讀者, 的表, --,
   {{0xf8438003,0x00000000,0x00000000,0x00000000}},	//   の下, --, --, --,
   {{0xfa79b006,0xf92eb011,0xf4be200b,0x00000000}},	// [250] 入最, 村建, 的部, --,
   {{0xf801a016,0xf92bd00b,0x00000000,0x00000000}},	//   달걀, 結婚, --, --,
   {{0xf929e018,0xfa600002,0xfa4d5004,0x00000000}},	//   に入, 來源, 民法, --,
   {{0xf920c01c,0xf90d2002,0xf591d008,0x00000000}},	//   中心, 強制, 體育, --,
   {{0xf945b010,0xfb870006,0x00000000,0x00000000}},	//   お店, 籍登, --, --,
   {{0xfa513010,0xfa76a00a,0xf830d003,0x00000000}},	//   答日, 方案, 報保, --,
   {{0xf6dac016,0xfa507006,0xf5c3600a,0xf916f00a}},	//   그룹, 字方, 公路, 固定,
   {{0xfb5cb004,0x00000000,0x00000000,0x00000000}},	//   产生, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf9176006,0xf8215003,0xf91eb003,0xf8313004}},	//   人回, 円以, 大好, 现代,
   {{0xfb884006,0xfb702008,0x00000000,0x00000000}},	//   問答, 雖然, --, --,
   {{0xfa793010,0xf9487003,0xfa807019,0x00000000}},	//   示板, が好, 管执, --,
   {{0xf82c700b,0x00000000,0x00000000,0x00000000}},	//   男人, --, --, --,
   {{0xf837a006,0x00000000,0x00000000,0x00000000}},	//   電信, --, --, --,
   {{0xf836b006,0xf946600a,0xf4ac500d,0x00000000}},	//   幹事, 立即, 发送, --,
   {{0xf929c003,0x00000000,0x00000000,0x00000000}},	//   に大, --, --, --,
   {{0xf4a33003,0xf91b9002,0xfa7c8004,0xf4c2a00e}},	// [260] 本部, 學家, 严格, 晉霖,
   {{0xf9181006,0xfa672006,0xf93f0006,0xf81cc004}},	//   出差, 對方, 會出, 省人,
   {{0xfa870006,0xfa848003,0xfa4d7002,0x00000000}},	//   幫手, 本格, 論文, --,
   {{0xfb846013,0xfb632010,0xf58ad003,0x00000000}},	//   光焰, 中空, を自, --,
   {{0xf9381007,0xfa58e006,0xf82dc006,0xfa756008}},	//   增加, 孝武, 徵信, 施政,
   {{0xfa503018,0xf5c30006,0xf9383002,0x00000000}},	//   ご注, 揭諦, 機制, --,
   {{0xfa751003,0xfb4b9003,0xf5c8700b,0x00000000}},	//   能性, 年生, 只要, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf93a0006,0xfa57000a,0xfa4c0002,0x00000000}},	//   區域, 真正, 結束, --,
   {{0xfa80800a,0xf49fd004,0xfb858006,0xfa562004}},	//   形成, 务部, 認真, 勘探,
   {{0xf920a008,0xf929300a,0x00000000,0x00000000}},	//   員工, 用地, --, --,
   {{0xf5b8200d,0xfa663002,0xf92bf00b,0x00000000}},	//   彻落, 開放, 我和, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf946c006,0xf9108008,0xf8256003,0xf9247004}},	//   之年, 台北, が不, 息化,
   {{0xfa638003,0xf9226003,0xfb642004,0xf8369006}},	//   請求, 測定, 转移, 任何,
   {{0xf59a1013,0xf8489003,0xfb63e003,0x00000000}},	//   一趟, 物件, 歯科, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [270] --, --, --, --,
   {{0xf9335006,0xfa836003,0x00000000,0x00000000}},	//   務品, の有, --, --,
   {{0xf81cc006,0xf824200b,0x00000000,0x00000000}},	//   如何, 上下, --, --,
   {{0xfa58a009,0xf92f9002,0xf81a2003,0xf5955005}},	//   农民, 展局, 品一, 舞蹈,
   {{0xfa5ee003,0xf93cb004,0xf49e2006,0xfb89c006}},	//   終更, 杂志, 盡量, 透社,
   {{0xfb6aa002,0x00000000,0x00000000,0x00000000}},	//   經理, --, --, --,
   {{0xfa737003,0xf92f3003,0xf91de004,0xf9442003}},	//   東海, 協力, 左右, 豊富,
   {{0xf92ce007,0xfa4f4006,0xf92b0003,0xf937c006}},	//   限公, 南投, を利, 作品,
   {{0xf937c00b,0x00000000,0x00000000,0x00000000}},	//   生命, --, --, --,
   {{0xf8360006,0xfa5dd00d,0x00000000,0x00000000}},	//   為例, 节日, --, --,
   {{0xfb596006,0xf9278008,0xfb5b5008,0x00000000}},	//   空白, 義工, 辦理, --,
   {{0xfa767006,0xfb5f8004,0x00000000,0x00000000}},	//   人最, 计算, --, --,
   {{0xf92a6006,0xf8465003,0xfa72c006,0x00000000}},	//   兒子, の主, 東方, --,
   {{0xf919f007,0xf93cb004,0xfb5a2004,0xf91da002}},	//   工商, 突出, 方米, 章分,
   {{0xf9108008,0xfa5c2004,0x00000000,0x00000000}},	//   台南, 宁波, --, --,
   {{0xfa5dc004,0x00000000,0x00000000,0x00000000}},	//   组成, --, --, --,
   {{0xfb818003,0xfb5f3004,0xf838d002,0xf844e00a}},	// [280] 雇用, 因素, 為主, 是中,
   {{0xfa5d000b,0x00000000,0x00000000,0x00000000}},	//   的文, --, --, --,
   {{0xf932200f,0xf9144003,0x00000000,0x00000000}},	//   四川, 楽天, --, --,
   {{0xf5b73004,0xf4abb003,0x00000000,0x00000000}},	//   导致, を除, --, --,
   {{0xfa73b004,0xf92cc003,0xfa5f500a,0x00000000}},	//   国民, 道大, 的政, --,
   {{0xf92d6004,0xf58c5014,0x00000000,0x00000000}},	//   抓好, 我要, --, --,
   {{0xfb789006,0xf91f5006,0xf948800b,0xfb828006}},	//   聞稿, 鏡子, 每天, 指示,
   {{0xf90fe006,0xf9209003,0xfb5ab002,0xfb7d7006}},	//   報名, 拡大, 學系, 的神,
   {{0xfb77200c,0xf93ec00a,0xf825500a,0x00000000}},	//   回答, 理局, 程中, --,
   {{0xf9443006,0xfb768006,0x00000000,0x00000000}},	//   之原, 祝福, --, --,
   {{0xfa707006,0xf9420006,0xf824900a,0x00000000}},	//   彰投, 案名, 降低, --,
   {{0xfa4e8003,0x00000000,0x00000000,0x00000000}},	//   ご意, --, --, --,
   {{0xfb58d00f,0xf9294005,0xf4adf00a,0xf8095003}},	//   项目, 在台, 成都, を一,
   {{0xfb52d00b,0xf92d8004,0x00000000,0x00000000}},	//   朱熹, 当地, --, --,
   {{0xf9217006,0xf83a4006,0x00000000,0x00000000}},	//   樣子, 相信, --, --,
   {{0xf931d003,0xfb504006,0x00000000,0x00000000}},	//   何度, 隱私, --, --,
   {{0xf941e006,0xf91e9008,0xf9202004,0xfa4d2006}},	// [290] 先前, 內容, 务公, 我感,
   {{0xf925c010,0xfb704004,0x00000000,0x00000000}},	//   部屋, 应用, --, --,
   {{0xf9465003,0xf59e000a,0x00000000,0x00000000}},	//   お客, 的自, --, --,
   {{0xf9290002,0xf911f002,0x00000000,0x00000000}},	//   幫助, 許可, --, --,
   {{0xfb7f5004,0x00000000,0x00000000,0x00000000}},	//   的社, --, --, --,
   {{0xfb5e1006,0xf91df006,0xf83dd004,0xfb560003}},	//   你真, 占卜, 条例, 人等,
   {{0xfa66e003,0xf9266006,0xf4ab6006,0xf8172006}},	//   手段, 置入, 蒐集, 號信,
   {{0xfa865006,0xf8367004,0xfb7cf004,0xfa5c3006}},	//   揮春, 为一, 适用, 的手,
   {{0xf945b003,0x00000000,0x00000000,0x00000000}},	//   お得, --, --, --,
   {{0xf5ba500a,0xfb7c3006,0xfa5e8004,0x00000000}},	//   特色, 的立, 资本, --,
   {{0xfa84c004,0xf939a006,0x00000000,0x00000000}},	//   术支, 一切, --, --,
   {{0xfa873003,0x00000000,0x00000000,0x00000000}},	//   普段, --, --, --,
   {{0xf93cc00a,0xfb66f00a,0xf941601a,0x00000000}},	//   市委, 全生, 文化, --,
   {{0xf9110004,0xf9223006,0xf598000a,0xf90e2002}},	//   亿元, 爭取, 生育, 鐵工,
   {{0xfa85f003,0x00000000,0x00000000,0x00000000}},	//   用意, --, --, --,
   {{0xfb81a00a,0x00000000,0x00000000,0x00000000}},	//   效益, --, --, --,
   {{0xf9458006,0xfa4bf00a,0xfa5f2006,0xfb6b7002}},	// [2a0] 二名, 民族, 理情, 自由,
   {{0xfa6ac006,0xf8173006,0xf932b00e,0xfa4f400b}},	//   長江, 關事, 驕傲, 我想,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf9399006,0xf90d2005,0x00000000,0x00000000}},	//   要先, 鍵字, --, --,
   {{0xf82fd003,0xfa857003,0xf5a4100a,0xf59c7014}},	//   新作, の推, 诉讼, 一起,
   {{0xfb57d003,0xfa878003,0xf9442004,0xf915700b}},	//   決算, 復活, 压力, 好好,
   {{0xf922f010,0xf5ab6002,0xfb65b003,0xfa6fd00a}},	//   中古, 導致, の第, 育活,
   {{0xf917e003,0xf4a48003,0xf917d006,0x00000000}},	//   特定, の通, 書名, --,
   {{0xfa4f6006,0xfa49d003,0xf49d300d,0xfa59300b}},	//   動手, を指, 赠送, 需求,
   {{0xf90ff002,0x00000000,0x00000000,0x00000000}},	//   詳全, --, --, --,
   {{0xf924e010,0xfb4b6006,0xf4c28013,0xf5a00002}},	//   の子, 創立, 按鈕, 豆腐,
   {{0xf93a9003,0xfa5bd004,0x00000000,0x00000000}},	//   障害, 一方, --, --,
   {{0xf842c009,0xf4c08010,0xfa6df006,0xf8159006}},	//   责任, 超音, 平洋, 從事,
   {{0xfb764009,0xf943c006,0xf8248006,0x00000000}},	//   办理, 有出, 不住, --,
   {{0xf848e006,0xf93d200d,0x00000000,0x00000000}},	//   自付, 七夜, --, --,
   {{0xf911b01c,0xf4a69010,0x00000000,0x00000000}},	//   政府, 編集, --, --,
   {{0xf920800a,0xfb82700a,0x00000000,0x00000000}},	// [2b0] 中小, 合理, --, --,
   {{0xfa82e006,0xf5b7e003,0x00000000,0x00000000}},	//   公投, 出身, --, --,
   {{0xf492f002,0x00000000,0x00000000,0x00000000}},	//   政院, --, --, --,
   {{0xf598a00d,0x00000000,0x00000000,0x00000000}},	//   回落, --, --, --,
   {{0xf922900b,0xfb697003,0xf9351006,0x00000000}},	//   中壢, 全然, 領域, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa5fc004,0xf5a10002,0xf5933008,0x00000000}},	//   调整, 舉行, 留言, --,
   {{0xf93f100a,0xf90ba006,0x00000000,0x00000000}},	//   的建, 極品, --, --,
   {{0xfb531003,0xf5b2a006,0x00000000,0x00000000}},	//   埼玉, 總裁, --, --,
   {{0xf942c006,0xf9212007,0xf922d006,0xfa82e006}},	//   事先, 公安, 賣出, 賣方,
   {{0xfa4ec007,0xfb86c010,0xf92b8003,0xf917600a}},	//   民政, お知, 成分, 添加,
   {{0xfa666006,0xf948e003,0xf926f003,0xf91cd00b}},	//   對本, が家, の影, 工具,
   {{0xf4b99006,0xf81c9007,0xfa6d0011,0xfa554006}},	//   一集, 的一, 整治, 誘惑,
   {{0xfa785006,0xfa60e008,0xf90f8006,0x00000000}},	//   為止, 資源, 至少, --,
   {{0xf5bf5004,0x00000000,0x00000000,0x00000000}},	//   欢迎, --, --, --,
   {{0xf911900c,0xf9188011,0xfb50e011,0xf9142004}},	//   東北, 人口, 西省, 国外,
   {{0xf90ca006,0xf9327011,0xf4a2b005,0x00000000}},	// [2c0] 張子, 业局, 路透, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf5963005,0xfa674002,0xfa5ee011,0x00000000}},	//   回覆, 權政, 的执, --,
   {{0xf80be006,0xf4c4b011,0xfa89800b,0x00000000}},	//   我介, 不适, 用水, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa63a006,0xf93ed006,0xf9243006,0x00000000}},	//   之情, 獅子, 六年, --,
   {{0xfb7f2004,0x00000000,0x00000000,0x00000000}},	//   的特, --, --, --,
   {{0xfa84a012,0xf4b17011,0xf93d6006,0x00000000}},	//   温泉, 力量, 餃子, --,
   {{0xfb716006,0x00000000,0x00000000,0x00000000}},	//   動物, --, --, --,
   {{0xf927b00a,0xf914d00e,0xf9251006,0x00000000}},	//   在全, 發展, 種子, --,
   {{0xf9336011,0x00000000,0x00000000,0x00000000}},	//   进口, --, --, --,
   {{0xfa4b2004,0xfa53600b,0x00000000,0x00000000}},	//   结果, 定期, --, --,
   {{0xf825b002,0xfa5ec00d,0xf4bec019,0x00000000}},	//   後一, 布日, 清醒, --,
   {{0xf48f8007,0xf5a88009,0xfa5a0004,0x00000000}},	//   地震, 银行, 证明, --,
   {{0xf81bc003,0xf80a2003,0xfa56a011,0xf9171006}},	//   一人, を作, 保持, 油品,
   {{0xfb6e6011,0xf918600a,0xf5c97005,0x00000000}},	//   监管, 核心, 鴨脷, --,
   {{0xf945c002,0xf932e00a,0xf823c00b,0xf9417006}},	// [2d0] 態度, 法制, 有人, 等待,
   {{0xf81e8004,0xf92bf006,0x00000000,0x00000000}},	//   担保, 向前, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa71e006,0xf81df003,0x00000000,0x00000000}},	//   影本, 求人, --, --,
   {{0xf9391006,0xf93d1006,0xfb60e006,0x00000000}},	//   保固, 樂器, 螢火, --,
   {{0xf49c9003,0xfa63b006,0xf939100d,0x00000000}},	//   学部, 應急, 东北, --,
   {{0xf918e00b,0xf4a07006,0x00000000,0x00000000}},	//   核定, 搭配, --, --,
   {{0xf83c4002,0xfa76c010,0xf5898003,0xf499d00d}},	//   別人, 人情, を考, 报送,
   {{0xf929a006,0x00000000,0x00000000,0x00000000}},	//   跨年, --, --, --,
   {{0xf81d100a,0xf82e7003,0xf81f5004,0xfb7f300b}},	//   境保, 郵便, 装修, 的相,
   {{0xf9336006,0xf920400a,0xf838300d,0xfa542002}},	//   多回, 正式, 类似, 願意,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb7e4010,0x00000000,0x00000000,0x00000000}},	//   い物, --, --, --,
   {{0xfb52d009,0xfb7cb006,0xfa70e004,0x00000000}},	//   精神, 威特, 平方, --,
   {{0xf9108010,0x00000000,0x00000000,0x00000000}},	//   印字, --, --, --,
   {{0xf8439008,0xf909800a,0xf5a0d004,0xfa67f002}},	//   單位, 制定, 理解, 變更,
   {{0xfb7bd010,0xfa6ab006,0xf4c8e006,0x00000000}},	// [2e0] 丁目, 年最, 獎金, --,
   {{0xf810f006,0xf4bbd006,0xf4bf5004,0xfb4c2002}},	//   些事, 市集, 内部, 當然,
   {{0xf845c006,0xf93f1004,0x00000000,0x00000000}},	//   可使, 庆市, --, --,
   {{0xfa674006,0xf815000b,0x00000000,0x00000000}},	//   式料, 多人, --, --,
   {{0xf9462002,0xfa623006,0x00000000,0x00000000}},	//   權利, 鄉村, --, --,
   {{0xf5a55003,0xf91bc00b,0x00000000,0x00000000}},	//   が行, 大小, --, --,
   {{0xfa55c006,0x00000000,0x00000000,0x00000000}},	//   雙方, --, --, --,
   {{0xf90ff00c,0xfa81a003,0xf83c2003,0xfb666003}},	//   地域, 説明, 日以, の為,
   {{0xf5c0e006,0x00000000,0x00000000,0x00000000}},	//   業者, --, --, --,
   {{0xfa845003,0x00000000,0x00000000,0x00000000}},	//   の教, --, --, --,
   {{0xf597e014,0xf9462006,0x00000000,0x00000000}},	//   功能, 不含, --, --,
   {{0xf9396006,0xfb50f009,0xf91e0006,0xf93ca006}},	//   一千, 关系, 無名, 一年,
   {{0xfa7dd006,0xfa61b010,0xf941200a,0xfa53f006}},	//   實施, 了承, 安局, 高手,
   {{0xf9428003,0xf9213014,0x00000000,0x00000000}},	//   変化, 公告, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa5f9005,0x00000000,0x00000000,0x00000000}},	//   的拳, --, --, --,
   {{0xf9233009,0xf4abb007,0xfb82800a,0xf8241006}},	// [2f0] 环境, 提高, 效率, 車事,
   {{0xf9421006,0xf4ae5002,0x00000000,0x00000000}},	//   鄉土, 預防, --, --,
   {{0xf8243006,0x00000000,0x00000000,0x00000000}},	//   軍事, --, --, --,
   {{0xf8260002,0xf81e000a,0xf5a2400d,0x00000000}},	//   國人, 市人, 三角, --,
   {{0xfb59f003,0xf91aa006,0xfb64f006,0x00000000}},	//   知的, 輸入, 微笑, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf6e15016,0xf5964013,0xfa7f8008,0xfa6b4002}},	//   재밌, 啟詔, 無法, 當日,
   {{0xfa709006,0xfa720006,0xfb5ac005,0xfa765004}},	//   熱情, 由本, 相簿, 场所,
   {{0xf00c4016,0xfa6e8002,0x00000000,0x00000000}},	//   컴퓨, 新消, --, --,
   {{0xfa5c3003,0xfb684006,0xfa71c00e,0xfb560004}},	//   時期, 寫真, 尾椎, 虽然,
   {{0xfa5e8006,0xfb532011,0xf8133004,0xf936b006}},	//   分手, 政管, 会保, 付出,
   {{0xf9478008,0x00000000,0x00000000,0x00000000}},	//   規定, --, --, --,
   {{0xf59d9006,0x00000000,0x00000000,0x00000000}},	//   附近, --, --, --,
   {{0xfb769006,0xfb4f4002,0x00000000,0x00000000}},	//   生物, 地球, --, --,
   {{0xfb64b003,0xf81d600a,0xfa81000b,0xf826a006}},	//   の生, 的作, 中文, 意事,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf935e004,0xfa831008,0xf934a00d,0x00000000}},	// [300] 多年, 縣政, 写字, --,
   {{0xf9225007,0xfa4dd00a,0xf82d5002,0xf9459006}},	//   中央, 科普, 進一, 不少,
   {{0xf80dc006,0xf920b006,0x00000000,0x00000000}},	//   店住, 索引, --, --,
   {{0xfb739003,0xf5ad8006,0xfa50e002,0xf831d004}},	//   料理, 仲裁, 四月, 地使,
   {{0xf81ed003,0xf9209002,0xf9348008,0xfa7db002}},	//   う一, 業局, 租屋, 警政,
   {{0xfa62d00a,0xf9189006,0xfb82c006,0xfa5b1006}},	//   效果, 登山, 與社, 一本,
   {{0xf92e9006,0x00000000,0x00000000,0x00000000}},	//   逐年, --, --, --,
   {{0xf4b48002,0xf9442006,0x00000000,0x00000000}},	//   高雄, 融合, --, --,
   {{0xfa842003,0xf920e006,0xf5a4400d,0x00000000}},	//   の旅, 索取, 棉花, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf6eb201d,0xf9383003,0x00000000,0x00000000}},	//   느낀, 実家, --, --,
   {{0xf9430006,0xf9114006,0xf93c0004,0x00000000}},	//   文山, 朱子, 的合, --,
   {{0xfb5fe003,0xfa637006,0x00000000,0x00000000}},	//   採用, 國最, --, --,
   {{0xf928b006,0xf919800a,0xf4901004,0xf80ce003}},	//   兩年, 基地, 关部, 間以,
   {{0xf6eb6016,0x00000000,0x00000000,0x00000000}},	//   느낄, --, --, --,
   {{0xfb7b9002,0xf9464010,0xf82c9002,0xf8109002}},	//   一群, 総合, 創作, 動作,
   {{0xf93f3004,0xf934e006,0x00000000,0x00000000}},	// [310] 内外, 四年, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf846100a,0xf809f004,0x00000000,0x00000000}},	//   在一, 当事, --, --,
   {{0xf8120006,0xfa53e011,0xf93fc014,0x00000000}},	//   做事, 龙江, 的地, --,
   {{0xf5b56007,0xf908a006,0x00000000,0x00000000}},	//   主要, 戶名, --, --,
   {{0xfb561009,0xfa662003,0xfa728006,0x00000000}},	//   建立, お支, 統治, --,
   {{0xf936800a,0xfa60500a,0xfb600006,0x00000000}},	//   高度, 篇文, 縣立, --,
   {{0xf91c9002,0xfa85600d,0x00000000,0x00000000}},	//   入好, 息日, --, --,
   {{0xf93cd00a,0x00000000,0x00000000,0x00000000}},	//   的各, --, --, --,
   {{0xf5c2500a,0x00000000,0x00000000,0x00000000}},	//   蔬菜, --, --, --,
   {{0xfa867003,0x00000000,0x00000000,0x00000000}},	//   の改, --, --, --,
   {{0xfa83200a,0x00000000,0x00000000,0x00000000}},	//   解放, --, --, --,
   {{0xf91a1006,0xf92f3006,0xf919a011,0x00000000}},	//   別墅, 動合, 机制, --,
   {{0xf93fc006,0xfa8a6006,0x00000000,0x00000000}},	//   七年, 截止, --, --,
   {{0xfa7a8014,0x00000000,0x00000000,0x00000000}},	//   日期, --, --, --,
   {{0xfb52800d,0x00000000,0x00000000,0x00000000}},	//   国美, --, --, --,
   {{0xf4c4c010,0xf92da009,0xfb877002,0xf944b002}},	// [320] 配送, 专家, 美玉, 開展,
   {{0xf946300e,0xfa5a0010,0x00000000,0x00000000}},	//   不妨, 曜日, --, --,
   {{0xfb573003,0xf5949006,0xf80db003,0xf924c00a}},	//   発生, 存者, 世保, 本地,
   {{0xfa838006,0x00000000,0x00000000,0x00000000}},	//   設施, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf8235003,0xfb672010,0xfb5ac00d,0x00000000}},	//   事一, の男, 书籍, --,
   {{0xf9290003,0xf909c004,0x00000000,0x00000000}},	//   を始, 户名, --, --,
   {{0xf9464003,0xf9443006,0xfa656006,0x00000000}},	//   が多, 配合, 二手, --,
   {{0xf4a82007,0xf925e00a,0xfb6d2006,0x00000000}},	//   全面, 良好, 我真, --,
   {{0xf9231004,0xf48b0004,0xfa64d006,0x00000000}},	//   药品, 制造, 楊梅, --,
   {{0xfa864018,0xf910f00a,0x00000000,0x00000000}},	//   の日, 政局, --, --,
   {{0xfb764002,0xfb59a009,0xf8279004,0xf908f004}},	//   儘管, 认真, 从事, 制品,
   {{0xf90a3018,0xf91b0003,0xf4c5a006,0xf492400d}},	//   場合, 以外, 積金, 声音,
   {{0xf9445006,0xf59c000a,0x00000000,0x00000000}},	//   位名, 技能, --, --,
   {{0xf9094009,0xf929c011,0xf9356004,0xf93bf00b}},	//   时候, 纪委, 党史, 最好,
   {{0xfb6df003,0x00000000,0x00000000,0x00000000}},	//   外科, --, --, --,
   {{0xfa68701c,0xf93c1010,0xfa6a4010,0xf90f3008}},	// [330] 行政, い合, 明治, 環境,
   {{0xfb6bd002,0xfa7d4009,0xf92af006,0x00000000}},	//   兒童, 执法, 八年, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf11ce016,0xfb581006,0xf4b42006,0xf9161006}},	//   도쿄, 建物, 標金, 發出,
   {{0xfa5c4014,0x00000000,0x00000000,0x00000000}},	//   最新, --, --, --,
   {{0xf92f500a,0xf9125011,0xf9305006,0x00000000}},	//   化工, 县委, 得出, --,
   {{0xfa67d00a,0x00000000,0x00000000,0x00000000}},	//   掌握, --, --, --,
   {{0xf91f500a,0xfa71b00d,0x00000000,0x00000000}},	//   控制, 记日, --, --,
   {{0xfb685003,0xfa865003,0xf8226004,0x00000000}},	//   に生, の活, 万人, --,
   {{0xf93d600f,0xf90f0004,0x00000000,0x00000000}},	//   规定, 稳定, --, --,
   {{0xf92da011,0xf9207002,0x00000000,0x00000000}},	//   体制, 縣市, --, --,
   {{0xf920b002,0xf927b002,0xf909a009,0xf9423006}},	//   中市, 利工, 汶川, 贈品,
   {{0xfa867018,0xf9266010,0x00000000,0x00000000}},	//   の方, の出, --, --,
   {{0xf90a1006,0xf5960002,0x00000000,0x00000000}},	//   刷品, 語言, --, --,
   {{0xf8454003,0xfa568006,0xfa6ef004,0x00000000}},	//   の他, 期末, 关文, --,
   {{0xf4977003,0xfb839003,0xf82eb006,0x00000000}},	//   画面, 予算, 新事, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [340] --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb6af003,0xfb7f500a,0x00000000,0x00000000}},	//   を用, 的精, --, --,
   {{0xf92f8002,0xf93e200a,0xfb822006,0xf917e004}},	//   動和, 充分, 祈福, 强化,
   {{0xf9260003,0x00000000,0x00000000,0x00000000}},	//   茨城, --, --, --,
   {{0xfa618006,0x00000000,0x00000000,0x00000000}},	//   有情, --, --, --,
   {{0xf5bbb009,0xf490600a,0xf595c004,0xf90ef004}},	//   执行, 关闭, 实行, 丰富,
   {{0xfa5c800a,0xf5a71003,0xf5978004,0xf9196006}},	//   的意, が自, 江西, 以前,
   {{0xf9297002,0xf90c4006,0xfb55b005,0x00000000}},	//   園市, 當年, 玻璃, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa51d006,0xf9298006,0x00000000,0x00000000}},	//   愛情, 親子, --, --,
   {{0xf59ca00a,0xf8281003,0xf944b00a,0x00000000}},	//   的要, れ以, 下列, --,
   {{0xf59e4004,0x00000000,0x00000000,0x00000000}},	//   节能, --, --, --,
   {{0xf813e018,0xfa65f006,0x00000000,0x00000000}},	//   記事, 下方, --, --,
   {{0xf8437003,0xf919e003,0xfb67c004,0x00000000}},	//   の上, 特典, 动物, --,
   {{0xfa4e4008,0x00000000,0x00000000,0x00000000}},	//   檔案, --, --, --,
   {{0xfa59b002,0xf819d006,0x00000000,0x00000000}},	// [350] 十月, 品事, --, --,
   {{0xf92bd010,0xf8107003,0xfb602002,0xfb7e7006}},	//   を入, 研修, 產生, 砂石,
   {{0xf59b9003,0x00000000,0x00000000,0x00000000}},	//   参考, --, --, --,
   {{0xfb6f6006,0xf915e003,0xf919b006,0xfa886008}},	//   圖示, 国地, 藥品, 說明,
   {{0xfa6f0011,0xf93c700d,0xfa62e005,0x00000000}},	//   新技, 摄像, 震撼, --,
   {{0xf9467006,0xf5a0d006,0xf4c4a010,0xf82ef004}},	//   個女, 將近, 重量, 到位,
   {{0xf924c010,0xf5911003,0xfa83c006,0xfa5d7006}},	//   の回, 飛行, 本校, 的感,
   {{0xf9234004,0xf919500d,0x00000000,0x00000000}},	//   积分, 报刊, --, --,
   {{0xfa67b007,0xfa6bb002,0xf9156006,0xf9381003}},	//   上海, 創意, 幾年, 生地,
   {{0xf91d800b,0x00000000,0x00000000,0x00000000}},	//   大利, --, --, --,
   {{0xfb59c006,0xfa869006,0xf9217002,0xf4c8c006}},	//   批示, 種方, 管制, 美食,
   {{0xfb5ab002,0xf594700a,0x00000000,0x00000000}},	//   健科, 高考, --, --,
   {{0xfb7b5002,0xfa557003,0xf936500a,0x00000000}},	//   區管, 務次, 站地, --,
   {{0xfa609002,0xf9132009,0xfa80d00a,0xfb60701f}},	//   三月, 综合, 正文, 中美,
   {{0xf8257004,0xf92bb003,0xf80e6004,0x00000000}},	//   操作, を大, 比例, --,
   {{0xfa671006,0xf8466003,0xf58c400a,0xfa86600b}},	//   上方, の人, 道路, 支援,
   {{0xf596401c,0xfb82c006,0x00000000,0x00000000}},	// [360] 教育, 築物, --, --,
   {{0xf9107009,0xf9090003,0xf9097004,0xf842f014}},	//   广告, 島市, 时尚, 是一,
   {{0xf8311008,0xfb871011,0x00000000,0x00000000}},	//   台中, 苏省, --, --,
   {{0xf93c0003,0xf9236003,0x00000000,0x00000000}},	//   も多, の安, --, --,
   {{0xf59cb002,0xf4a20006,0xf93b1006,0xf825400b}},	//   參考, 召集, 門口, 之中,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfa6f500a,0xfb595006,0x00000000,0x00000000}},	//   防止, 春秋, --, --,
   {{0xf5c1e007,0xf9127003,0xfa5ed00a,0x00000000}},	//   代表, 便利, 病毒, --,
   {{0xfb7ab020,0xfa64a00b,0x00000000,0x00000000}},	//   一番, 立法, --, --,
   {{0xf9414006,0xf927e005,0xf9218006,0xfa6df006}},	//   三千, 兩岸, 陣子, 飲料,
   {{0xf59a1018,0xf4c05006,0xf5b75004,0xf9458006}},	//   最近, 文集, 费者, 車子,
   {{0xf8454003,0xf933b011,0x00000000,0x00000000}},	//   の世, 党委, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf946e002,0x00000000,0x00000000,0x00000000}},	//   舊建, --, --, --,
   {{0xf945a004,0xfb64700a,0x00000000,0x00000000}},	//   程度, 犯罪, --, --,
   {{0xfb873006,0xf8259003,0x00000000,0x00000000}},	// [370] 及社, が一, --, --,
   {{0xf5bc9006,0xfa605006,0xfb64d004,0xf945c014}},	//   入追, 劇情, 利益, 二十,
   {{0xfa514003,0xf810e010,0xfb860006,0x00000000}},	//   北海, 返信, 刊物, --,
   {{0xf8120008,0xfa6ec006,0x00000000,0x00000000}},	//   線上, 陳情, --, --,
   {{0xf82d1006,0xfb7cb00a,0xf5b53004,0xf58ae004}},	//   仲介, 心理, 导航, 运行,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf92a0010,0xf8386003,0x00000000,0x00000000}},	//   に出, 人中, --, --,
   {{0xf92e2010,0xf4bc5007,0x00000000,0x00000000}},	//   取引, 的重, --, --,
   {{0xf5c6f010,0xf5aa4006,0xfa509006,0x00000000}},	//   の花, 長者, 北方, --,
   {{0xf8234007,0xf90f2009,0xfa74e011,0x00000000}},	//   文件, 决定, 设施, --,
   {{0xfa7de006,0x00000000,0x00000000,0x00000000}},	//   寧波, --, --, --,
   {{0xfa7c3002,0x00000000,0x00000000,0x00000000}},	//   辦法, --, --, --,
   {{0xf9350003,0xf9228002,0xfa765006,0xfa83600a}},	//   通常, 召募, 為最, 是指,
   {{0xf8418009,0xf925a009,0xfb83a002,0x00000000}},	//   条件, 帮助, 計算, --,
   {{0xfa874003,0xf5b2f002,0xfa6e9013,0x00000000}},	//   の更, 東西, 極拳, --,
   {{0xf80d700e,0x00000000,0x00000000,0x00000000}},	//   子信, --, --, --,
   {{0xfa685010,0xf837d00a,0xfb58f00d,0x00000000}},	// [380] ヶ月, 主任, 人空, --,
   {{0xf8415002,0x00000000,0x00000000,0x00000000}},	//   馬上, --, --, --,
   {{0xfa6fc011,0xfa7e5004,0xf93ad006,0xfa555006}},	//   防治, 无法, 龜山, 感情,
   {{0xf9155021,0xf92af00d,0x00000000,0x00000000}},	//   画像, 结婚, --, --,
   {{0xfb74e00a,0xfa690002,0x00000000,0x00000000}},	//   江省, 究所, --, --,
   {{0xfa6a4010,0xf4996004,0xf93b7010,0xf4975006}},	//   明日, 严重, 銀座, 基金,
   {{0xf934f009,0x00000000,0x00000000,0x00000000}},	//   食品, --, --, --,
   {{0xfa75a006,0xf8458002,0xf91f9006,0x00000000}},	//   活情, 華人, 加入, --,
   {{0xf9442003,0xfa6ba008,0xf8471003,0xfa886006}},	//   不安, 戶政, に上, 身材,
   {{0xfb583006,0xf908d002,0xf81c3006,0xf827d002}},	//   建置, 當局, 的介, 過一,
   {{0xfa71b009,0xf59ac00d,0xf93ae00b,0x00000000}},	//   地方, 鲜花, 一天, --,
   {{0xf4bd9006,0x00000000,0x00000000,0x00000000}},	//   的金, --, --, --,
   {{0xf8339004,0xfa63b004,0xfa66a006,0xfb59d013}},	//   县人, 等方, 筋混, 肥皂,
   {{0xf921f00d,0xfb685002,0xf93ee014,0x00000000}},	//   饭店, 醫生, 的大, --,
   {{0xf90c8013,0x00000000,0x00000000,0x00000000}},	//   彷彿, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf83fb003,0x00000000,0x00000000,0x00000000}},	// [390] 素人, --, --, --,
   {{0xf814a011,0xf818d003,0xfa69300b,0x00000000}},	//   业信, 初代, 完整, --,
   {{0xf92d8009,0xfa81b003,0x00000000,0x00000000}},	//   发展, 連法, --, --,
   {{0xfa885013,0xfb692007,0x00000000,0x00000000}},	//   煩惱, 部署, --, --,
   {{0xf91f700a,0xf59a7004,0x00000000,0x00000000}},	//   加大, 东西, --, --,
   {{0xfa5ab010,0xf92aa006,0xf92e4006,0xfa80c008}},	//   送料, 結合, 視引, 財政,
   {{0xfa85b010,0xfb6e100a,0xf90a4004,0xfa5ca006}},	//   の本, 南省, 胶南, 心情,
   {{0xfa4f4006,0xf942d006,0x00000000,0x00000000}},	//   北投, 請先, --, --,
   {{0xf4c0c006,0xf81c3006,0x00000000,0x00000000}},	//   資金, 的事, --, --,
   {{0xf48ae003,0x00000000,0x00000000,0x00000000}},	//   海道, --, --, --,
   {{0xf9432006,0xf949f010,0xf48a9006,0xfa783006}},	//   之名, 意味, 水量, 為本,
   {{0xfa567012,0xfa4b3004,0xf5c7e00d,0xfa647006}},	//   高校, 结束, 猪肉, 上最,
   {{0xfb89a006,0xf9173006,0xf9382004,0x00000000}},	//   小白, 為原, 烟台, --,
   {{0xf9415003,0xfa5da00a,0xfa800005,0xfa5c900a}},	//   安心, 的成, 模擬, 的所,
   {{0xf4bc8013,0x00000000,0x00000000,0x00000000}},	//   流鼻, --, --, --,
   {{0xf936a002,0xf9458002,0xfa54d019,0x00000000}},	//   九十, 專家, 定执, --,
   {{0xfa7a7006,0xfa629004,0x00000000,0x00000000}},	// [3a0] 學校, 吉林, --, --,
   {{0xf4a4700a,0xf489f003,0xfa551006,0xf845c006}},	//   普通, 制限, 這本, 推介,
   {{0xf92b4003,0xf9117006,0x00000000,0x00000000}},	//   道府, 鳳凰, --, --,
   {{0xf941c003,0x00000000,0x00000000,0x00000000}},	//   安定, --, --, --,
   {{0xfa88b006,0xf917400a,0xf93b1006,0x00000000}},	//   在根, 主席, 時前, --,
   {{0xf4c5300a,0xf8143006,0xf910a008,0x00000000}},	//   消防, 記住, 房屋, --,
   {{0xf5ba901b,0x00000000,0x00000000,0x00000000}},	//   船舶, --, --, --,
   {{0xf90e6006,0xf84ae003,0xf9357020,0xf4bd100a}},	//   債券, な人, 神奈, 的高,
   {{0xf914f004,0xf90cf002,0xf82de011,0x00000000}},	//   类型, 歷史, 电信, --,
   {{0xf928c003,0xfa48e003,0xf93f9006,0xf92a5006}},	//   自分, を有, 的女, 青少,
   {{0xf83e4004,0x00000000,0x00000000,0x00000000}},	//   级以, --, --, --,
   {{0xfb658006,0x00000000,0x00000000,0x00000000}},	//   斯特, --, --, --,
   {{0xf81b5003,0xf935a002,0xf9164006,0x00000000}},	//   も一, 類型, 人名, --,
   {{0xf921c00a,0xfb61b006,0x00000000,0x00000000}},	//   公布, 解答, --, --,
   {{0xfa572009,0xf5af9009,0xf929e006,0xfa5c900a}},	//   办法, 记者, 寫出, 的技,
   {{0xf9205002,0xf8249006,0xf5ae6011,0x00000000}},	//   中和, 個体, 防腐, --,
   {{0xfb754018,0xf4b40006,0x00000000,0x00000000}},	// [3b0] 会社, 儘量, --, --,
   {{0xfb75a002,0xf9267003,0xfa4e0013,0xfa63500a}},	//   候群, 注射, 恐懼, 合法,
   {{0xf9254003,0xf916f003,0xf4bf3006,0xfb86c00b}},	//   の受, 出力, 集集, 不管,
   {{0xf9207003,0xfb644003,0xfa55d00b,0x00000000}},	//   昭和, の理, 星期, --,
   {{0xf9266003,0xf91fb006,0xf4c06004,0x00000000}},	//   の基, 採取, 理部, --,
   {{0xfb58e006,0xfb5e1004,0xfa6b3002,0x00000000}},	//   人知, 传真, 階段, --,
   {{0xf90dd003,0xf946e004,0xf82d200a,0xfa526006}},	//   歴史, 同志, 年以, 法施,
   {{0xfb489005,0xf93cc006,0x00000000,0x00000000}},	//   耶穌, 送出, --, --,
   {{0xf59b8003,0x00000000,0x00000000,0x00000000}},	//   概要, --, --, --,
   {{0xf9300006,0x00000000,0x00000000,0x00000000}},	//   林口, --, --, --,
   {{0xfa54e014,0xf5a4300b,0x00000000,0x00000000}},	//   香港, 三菱, --, --,
   {{0xf928a006,0x00000000,0x00000000,0x00000000}},	//   被引, --, --, --,
   {{0xf4b1900a,0xf925e010,0xf842d004,0x00000000}},	//   法院, の口, 责人, --,
   {{0xfa6ab003,0xf9321002,0x00000000,0x00000000}},	//   場所, 體制, --, --,
   {{0xf937a003,0xfa653003,0xf9359004,0xf5c5a006}},	//   記念, 予想, 变化, 路追,
   {{0xf80f900f,0xfb6d2009,0xf838f004,0xf4a4f003}},	//   单位, 发生, 为主, の道,
   {{0xfb794007,0xf4c8f006,0xfa6d3002,0xf9382004}},	// [3c0] 作用, 澎金, 聲明, 损失,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf8462009,0xf82f8018,0xf909e006,0xf92f300a}},	//   软件, 甲信, 帶回, 民共,
   {{0xf945d00b,0x00000000,0x00000000,0x00000000}},	//   下去, --, --, --,
   {{0xfa61a002,0x00000000,0x00000000,0x00000000}},	//   專案, --, --, --,
   {{0xf90b2007,0xf5b95004,0xf90fc006,0xf91f000b}},	//   制度, 来越, 進入, 大地,
   {{0xfb618006,0xfa66e004,0x00000000,0x00000000}},	//   檢索, 同比, --, --,
   {{0xf8414007,0xfa4d9006,0xf91f000b,0x00000000}},	//   第三, 著手, 你可, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfb66c006,0x00000000,0x00000000,0x00000000}},	//   央社, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf927d006,0xf91e3013,0xf948800b,0x00000000}},	//   優先, 大埤, 福利, --,
   {{0xfa86d018,0xfa7d3007,0xfb723008,0xf928f006}},	//   と思, 学校, 衛生, 親切,
   {{0xf9400009,0xfb537018,0xf5c9e004,0x00000000}},	//   万元, 対策, 自身, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf9138003,0xfb77c011,0xf59f5006,0x00000000}},	// [3d0] 寿司, 东省, 筆者, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf90c400a,0xf82ad004,0xfb65c006,0xfb79c006}},	//   家具, 时代, 獨立, 私立,
   {{0xfb604006,0xfb62a00a,0xf9255006,0x00000000}},	//   中秋, 督管, 物品, --,
   {{0xfb59301c,0xfa842010,0xf4984006,0xfa7bc006}},	//   工程, の情, 卹金, 若波,
   {{0xfa5c1006,0xf4a98008,0xf8121002,0xf946500b}},	//   球手, 醫院, 法人, 看好,
   {{0xfb74100c,0xf591000f,0xfb860006,0xf91cc002}},	//   写真, 进行, 對策, 辦公,
   {{0xfa6aa004,0x00000000,0x00000000,0x00000000}},	//   说明, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf9297004,0x00000000,0x00000000,0x00000000}},	//   表彰, --, --, --,
   {{0xf8314006,0x00000000,0x00000000,0x00000000}},	//   即使, --, --, --,
   {{0xfb7d2009,0xf9194003,0xfa648002,0x00000000}},	//   处理, 判定, 權所, --,
   {{0xf949600a,0x00000000,0x00000000,0x00000000}},	//   福建, --, --, --,
   {{0xfa701011,0xf917c002,0xf9466014,0x00000000}},	//   关注, 臺北, 不可, --,
   {{0xfb721004,0x00000000,0x00000000,0x00000000}},	//   展示, --, --, --,
   {{0xfa77701c,0xf4aa0003,0xfb6e4006,0xf94af004}},	//   人民, を通, 歐米, 美女,
   {{0xf924e006,0xf58e5003,0x00000000,0x00000000}},	// [3e0] 天前, 子育, --, --,
   {{0xf831f006,0x00000000,0x00000000,0x00000000}},	//   議使, --, --, --,
   {{0xfa55f003,0xfb80a00b,0x00000000,0x00000000}},	//   生成, 等等, --, --,
   {{0xf81f000a,0xf826e00a,0xfb5b5006,0x00000000}},	//   的主, 小企, 藥物, --,
   {{0xfa70b003,0xf4994006,0xfa4a6003,0xf91b9003}},	//   女性, 學金, を提, 大和,
   {{0xfa878004,0xf92e3003,0xf910c002,0xfa68b005}},	//   天津, 気分, 許多, 父母,
   {{0xf9138003,0xfb5fa00a,0xfa534002,0x00000000}},	//   都府, 信用, 務所, --,
   {{0xfa80f003,0xf90ed004,0x00000000,0x00000000}},	//   価格, 电台, --, --,
   {{0xf9244003,0xf80ef003,0xfa64f00a,0xfa777006}},	//   の商, ご了, 合格, 阻止,
   {{0xf93ed021,0x00000000,0x00000000,0x00000000}},	//   商品, --, --, --,
   {{0xf90fe00d,0x00000000,0x00000000,0x00000000}},	//   女士, --, --, --,
   {{0xf92ad010,0xf93bd00b,0x00000000,0x00000000}},	//   を取, 十八, --, --,
   {{0xfa58c003,0xf92db009,0xfa648003,0xfb586002}},	//   作成, 提出, 変更, 基督,
   {{0xfa66e00c,0xf80c1010,0xfb81e003,0xf9346007}},	//   今日, を使, 理由, 博客,
   {{0xf92a0003,0xfa5f9004,0xfb57f004,0xf80da00b}},	//   に基, 资格, 机票, 成人,
   {{0xfa4e300a,0xfa599006,0xf81c7006,0x00000000}},	//   答案, 停止, 的住, --,
   {{0xf80d9003,0xf8401004,0xfa517004,0xf90bb008}},	// [3f0] し上, 董事, 供求, 郵局,
   {{0xf4c57003,0xf918f004,0xf5960004,0xfa869006}},	//   構造, 去年, 优良, 表情,
   {{0xf59e8004,0x00000000,0x00000000,0x00000000}},	//   商行, --, --, --,
   {{0xfa845006,0xf598e008,0x00000000,0x00000000}},	//   種情, 銀行, --, --,
   {{0xf9135007,0xfa6fe006,0xfa799003,0xf9192002}},	//   能力, 唱歌, 特性, 此分,
   {{0xfa82f004,0xf5af3008,0xf819000b,0x00000000}},	//   支持, 網路, 一位, --,
   {{0xfa4e2002,0x00000000,0x00000000,0x00000000}},	//   五月, --, --, --,
   {{0xfb6da004,0xfb56e002,0x00000000,0x00000000}},	//   当然, 費用, --, --,
   {{0xf9308006,0xfa71800d,0x00000000,0x00000000}},	//   列出, 艾滋, --, --,
   {{0xfb851002,0x00000000,0x00000000,0x00000000}},	//   運用, --, --, --,
   {{0xf8386006,0xfa683003,0xf84ad00a,0xfa5e6004}},	//   此事, 小林, 自主, 雅思,
   {{0xfa88a006,0x00000000,0x00000000,0x00000000}},	//   用方, --, --, --,
   {{0xf9286003,0xfb7d2019,0x00000000,0x00000000}},	//   株式, 的矛, --, --,
   {{0xfb75b006,0xf90da007,0xf5b43003,0xf92ae010}},	//   務登, 水平, 対象, を含,
   {{0xf93f5006,0x00000000,0x00000000,0x00000000}},	//   包含, --, --, --,
   {{0xf80d9004,0xfb68b006,0xf947d004,0x00000000}},	//   岗位, 獨特, 半年, --,

  };
  // table_hash = 860b-1885, unused_entries = 1630 (39.79%)

static const uint32 kCjkDeltaBiSizeOne = 34;    // One-langprob count
extern const uint32 kCjkDeltaBiIndSize = 34;    // Largest subscript
static const uint32 kCjkDeltaBiInd[kCjkDeltaBiIndSize] = {
  // [0000]
  0x00000000, 0x00000000, 0x00001d1c, 0x00000242,   // -- --  zh-Hant.un.un_800 ja.un.un_C00
  0x0000051c, 0x00001d15, 0x00001d42, 0x00000503,   // zh.un.un_800 zh-Hant.un.un_700  zh-Hant.un.un_C00 zh.un.un_300
  0x00001d24, 0x00000524, 0x00000501, 0x00001d01,   // zh-Hant.un.un_900 zh.un.un_900  zh.un.un_200 zh-Hant.un.un_200
  0x00000203, 0x00000542, 0x00001d37, 0x0000052d,   // ja.un.un_300 zh.un.un_C00  zh-Hant.un.un_B00 zh.un.un_A00
  // [0010]
  0x0000021c, 0x00000515, 0x00000201, 0x00001d0f,   // ja.un.un_800 zh.un.un_700  ja.un.un_200 zh-Hant.un.un_600
  0x00001d03, 0x0000050a, 0x00000301, 0x00000215,   // zh-Hant.un.un_300 zh.un.un_500  ko.un.un_200 ja.un.un_700
  0x00000224, 0x0000050f, 0x00001d06, 0x00001d2d,   // ja.un.un_900 zh.un.un_600  zh-Hant.un.un_400 zh-Hant.un.un_A00
  0x00000506, 0x0000030f, 0x00000315, 0x00000537,   // zh.un.un_400 ko.un.un_600  ko.un.un_700 zh.un.un_B00
  // [0020] --- double_langprob_start=0022 ---
  0x0000020f, 0x0000022d,                           // ja.un.un_600 ja.un.un_A00
                                                    //
  };

//  COMPILE_ASSERT(34 < (1 << 12), k_indirectbits_too_small);

extern const CLD2TableSummary kCjkDeltaBi_obj = {
  kCjkDeltaBi,
  kCjkDeltaBiInd,
  kCjkDeltaBiSizeOne,
  kCjkDeltaBiSize,
  kCjkDeltaBiKeyMask,
  kCjkDeltaBiBuildDate,
  kCjkDeltaBiRecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
