/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef X11_DND_H
#define X11_DND_H

#include <X11/Xlib.h>
#include <pthread.h>

#include "dnd_security.h"

typedef struct _X11_Dnd_Backend {
    Display *display;
    pthread_mutex_t cond_lock;
    pthread_t dispatch;
    bool lock;
    int fd_read_from_server; // named pipe server(write) ==》client(read)
    int fd_write_to_client;

    int fd_read_client;  // named pipe client(write) ==>server(read)
    int fd_write_to_server;

} X11DndBackend;
typedef struct _X11_Dnd_Backend *X11DndBackendPtr;

int initX11Dnd();

void destoryX11Dnd();

int xGetSecuritySession(SessionType types);

int xDestroySecuritySession(int session);

void xReportSecurityVerified(int session, Permission result);

struct dtk_array* xGetSecurityClients();

#endif
