@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-event-list: List available events
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;
use Term::ReadKey;

my %opt = ( version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );

my $eventidorname = $ARGV[0];

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Get the Token (using the Certificate in $HOME)
my $token = $ecaccess->getToken();

# Get the Control Channel
my $controlChannel = $ecaccess->getControlChannel();

if ( not($eventidorname) ) {

	# Get the list of events
	my $events = $controlChannel->getEventList($token);

	# Display the information for each event
	foreach $event ( $events->valueof('//getEventListResponse/return') ) {
		printf "%-10s %-20s %-40s\n", $event->{eventId}, $event->{name}, $event->{comment};
	}
}
else {

	# Get the information for the specified event
	my $event = $controlChannel->getEvent( $token, $eventidorname )->valueof('//getEventResponse/return');
	print "     Event-id: ", $event->{eventId}, "\n";
	print "         Name: ", $event->{name},    "\n";
	print "       Public: ", ( $event->{isPublic} eq 'true' ? 'yes' : 'no' ), "\n";
	print "        Owner: ", $event->{ownerUserId},       "\n";
	print "      Comment: ", $event->{comment},           "\n" if $event->{comment};
	print "        Title: ", $event->{title},             "\n" if $event->{title};
	print "     Metadata: ", $event->{metadata},          "\n" if $event->{metadata};
	print "     Can send: ", $event->{notifyUserList},    "\n" if $event->{notifyUserList};
	print "Can subscribe: ", $event->{subscribeUserList}, "\n" if $event->{subscribeUserList};
}

# Logout
$ecaccess->releaseToken($token);

__END__

=head1 NAME

ecaccess-event-list - List available events

=head1 SYNOPSIS

B<ecaccess-event-list -version|-help|-manual>

B<ecaccess-event-list [-debug] [>I<event-id>|I<event-name>B<]>

=head1 DESCRIPTION

List all the ECaccess Events which are available to your ECMWF user identifier. If an
I<event-id> or I<event-name> is specified as an argument then this command
will display all the information related to this event.

=head1 ARGUMENTS

=over 8

=item I<event-id>|I<event-name> (optional)

The identifier or name of the Event to retrieve the details.

=back

=head1 OPTIONS

=over 8

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-event-list> I<an00h000>

Gives the information related to the I<event-name> I<an00h000>.

B<ecaccess-event-list>

List all the events available to your ECMWF user identifier.

=head1 SEE ALSO

B<ecaccess-event-grant>, B<ecaccess-event-clear>, B<ecaccess-event-send>, B<ecaccess-event-delete>,
B<ecaccess-event-create> and B<ecaccess>.

=cut

__END__
:endofperl
