#ifdef HAVE_ALSA

#ifndef __MIDI_H__
#define __MIDI_H__

#include <alsa/asoundlib.h>
#include "speciallist.h"
#include <pthread.h>

typedef struct _midi_info{
  	pthread_t     	midithread;
  	snd_seq_t     	*seq;
  	int           	seq_nfds;
  	struct pollfd 	*pfds;
	speciallist_t	*looperdatalist;
	int		input;
	int 		quit;
} midi_info_t;

midi_info_t* midi_info_new (speciallist_t* looperdatalist);
void         midi_info_destroy ();

#endif /* __MIDI_H__ */
#endif /* HAVE_ALSA */


