/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/*
* When adding modules to the namespace, ensure that they are added in alphabetical order according to module name.
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-read-only-property' );


// MAIN //

/**
* Top-level namespace.
*
* @namespace negativeBinomial
*/
var negativeBinomial = {};

/**
* @name cdf
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/cdf}
*/
setReadOnly( negativeBinomial, 'cdf', require( './../../../../base/dists/negative-binomial/cdf' ) );

/**
* @name NegativeBinomial
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/ctor}
*/
setReadOnly( negativeBinomial, 'NegativeBinomial', require( './../../../../base/dists/negative-binomial/ctor' ) );

/**
* @name kurtosis
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/kurtosis}
*/
setReadOnly( negativeBinomial, 'kurtosis', require( './../../../../base/dists/negative-binomial/kurtosis' ) );

/**
* @name logpmf
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/logpmf}
*/
setReadOnly( negativeBinomial, 'logpmf', require( './../../../../base/dists/negative-binomial/logpmf' ) );

/**
* @name mean
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/mean}
*/
setReadOnly( negativeBinomial, 'mean', require( './../../../../base/dists/negative-binomial/mean' ) );

/**
* @name mgf
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/mgf}
*/
setReadOnly( negativeBinomial, 'mgf', require( './../../../../base/dists/negative-binomial/mgf' ) );

/**
* @name mode
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/mode}
*/
setReadOnly( negativeBinomial, 'mode', require( './../../../../base/dists/negative-binomial/mode' ) );

/**
* @name pmf
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/pmf}
*/
setReadOnly( negativeBinomial, 'pmf', require( './../../../../base/dists/negative-binomial/pmf' ) );

/**
* @name quantile
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/quantile}
*/
setReadOnly( negativeBinomial, 'quantile', require( './../../../../base/dists/negative-binomial/quantile' ) );

/**
* @name skewness
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/skewness}
*/
setReadOnly( negativeBinomial, 'skewness', require( './../../../../base/dists/negative-binomial/skewness' ) );

/**
* @name stdev
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/stdev}
*/
setReadOnly( negativeBinomial, 'stdev', require( './../../../../base/dists/negative-binomial/stdev' ) );

/**
* @name variance
* @memberof negativeBinomial
* @readonly
* @type {Function}
* @see {@link module:@stdlib/stats/base/dists/negative-binomial/variance}
*/
setReadOnly( negativeBinomial, 'variance', require( './../../../../base/dists/negative-binomial/variance' ) );


// EXPORTS //

module.exports = negativeBinomial;
