/*
 * asynchronous reading generator for ijson's C backend
 *
 * Contributed by Rodrigo Tobar <rtobar@icrar.org>
 *
 * ICRAR - International Centre for Radio Astronomy Research
 * (c) UWA - The University of Western Australia, 2020
 * Copyright by UWA (in the framework of the ICRAR)
 */

#ifndef ASYNC_READING_GENERATOR_H
#define ASYNC_READING_GENERATOR_H

#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include "coro_utils.h"

/**
 * async_reading_generator definition. It keeps the state of the current reading
 * process, and the list holding the events generated by the yajl parsing.
 */
typedef struct {
	PyObject_HEAD
	PyObject *coro;
	PyObject *file;
	PyObject *read_func;
	PyObject *buf_size;
	PyObject *awaitable;
	PyObject *events;
	Py_ssize_t index;
	int file_exhausted;
} async_reading_generator;

void async_reading_generator_add_coro(async_reading_generator *self, pipeline_node *coro_pipeline);

extern PyTypeObject AsyncReadingGeneratorType;

#endif // ASYNC_READING_GENERATOR_H