/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 2001-2009, William Chia-Wei Cheng.
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Trolltech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/strtbl.e,v 1.109 2011/05/16 16:21:59 william Exp $
 */

#ifndef _TGIF_STRTBL_E_
#define _TGIF_STRTBL_E_

/*
 * ID's that starts with CSTID_ are "cached" for fast access.
 * ID's that starts with STID_ are not cached.
 */

/* ===================== Cached ===================== */

#define MINCACHEDSTIDS                   100

#define CSTID_OK                            100
#define CSTID_CANCEL                        101
#define CSTID_PARANED_NONE                  102
#define CSTID_SET_FONT_TO                   103
#define CSTID_NO_OBJ_SELECTED               104
#define CSTID_SPECIFY_ARC_END               105
#define CSTID_SPECIFY_ARC_START             106
#define CSTID_SPECIFY_ARC_THIRD             107
#define CSTID_SET_ARC_END                   108
#define CSTID_SET_ARC_START                 109
#define CSTID_SET_ARC_THIRD                 110
#define CSTID_SPECIFY_ARC_END_CW            111
#define CSTID_SPECIFY_ARC_END_CCW           112
#define CSTID_CANCEL_NOT_AVAIL              113
#define CSTID_DLG_DEF_CONTINUE              114
#define CSTID_DLG_ACCEPT_CANCEL             115
#define CSTID_MALFORMED_INPUT_STR           116
#define CSTID_CACHING_TEXT_BMP              117
#define CSTID_PROGRESS_PERCENT              118
#define CSTID_FINISHED_CACHEING_TEXT_BMP    119
#define CSTID_BAD_BOX_BBOX_ADJUSTED         120
#define CSTID_MAIN_MENU                     121
#define CSTID_MODE_MENU                     122
#define CSTID_ROTATE_DEGREES_CW             123
#define CSTID_ROTATE_DEGREES_CCW            124
#define CSTID_PRINT_MODE                    125
#define CSTID_EXPORT_MODE                   126
#define CSTID_PRINT_EXPORT_MENU             127
#define CSTID_FLUSH_UNDO_PERCENT            128
#define CSTID_SET_COLOR_TO                  129
#define CSTID_CANNOT_ALLOC_COLOR_USE_ALT    130
#define CSTID_UPDATING_PIXELS               131
#define CSTID_NONE                          132
#define CSTID_PARANED_NULL                  133
#define CSTID_COPY                          134
#define CSTID_SAVE                          135
#define CSTID_PASTE                         136
#define CSTID_RESTORE                       137
#define CSTID_YES                           138
#define CSTID_NO                            139
#define CSTID_EXTRA                         140
#define CSTID_INTERRUPT                     141
#define CSTID_LEAVE_HYPERSPACE              142
#define CSTID_ENTER_HYPERSPACE              143
#define CSTID_CACHING_IMAGE                 144
#define CSTID_TOGGLE_SMOOTH_HINGE           145
#define CSTID_FINISH                        146
#define CSTID_DEL_A_VERTEX                  147
#define CSTID_ADD_A_VERTEX                  148
#define CSTID_START_LAYOUT_ON_ARC           149
#define CSTID_END_LAYOUT_ON_ARC             150
#define CSTID_EXECUTING_GIVEN_PROGRAM       151
#define CSTID_DOTS_DONE                     152
#define CSTID_IMPORTING_FILE                153
#define CSTID_LOADING_FILE                  154
#define CSTID_EDIT_TEXT_SIZE_SUBSTR         155
#define CSTID_SET_FONT_SIZE_TO_PT           156
#define CSTID_SET_FONT_SIZE_TO              157
#define CSTID_MAKING_CONN_TO_HOST           158
#define CSTID_CONN_TO_HOST_ESTABLISHED      159
#define CSTID_LOGIN_SUCC_RETRIEVE_DATA      160
#define CSTID_LAYOUT_MENU                   161
#define CSTID_MAKING_CONN_TO_HOST_PORT      162
#define CSTID_CONN_TO_HOST_PORT_ESTB        163
#define CSTID_SENDING_REQUESTS_DOTS         164
#define CSTID_PARANED_UNKNOWN               165
#define CSTID_READING_RESPONSE_DOTS         166
#define CSTID_RESPONSES_RECEIVED            167
#define CSTID_GEN_FINAL_PIXELS_PERC         168
#define CSTID_BUILDING_HISTOGRAM_DOTS       169
#define CSTID_HISTOGRAM_PERC                170
#define CSTID_COMP_NEW_PIXELS_PERC          171
#define CSTID_QUANTIZING_COLORS_DOTS        172
#define CSTID_REMAPPING_COLORS_DOTS         173
#define CSTID_COMPUTING_NEW_PIXELS_PERC     174
#define CSTID_CALC_ERR_DIFF_PIX_VAL_PERC    175
#define CSTID_CALC_NEW_PIX_1_VAL_PERC       176
#define CSTID_CALC_NEW_PIX_2_VAL_PERC       177
#define CSTID_DLG_ACCEPT_CONTINUE           178
#define CSTID_OPENING_GIVEN                 179
#define CSTID_BACKGROUNDING_CMD             180
#define CSTID_CNTRL_C_TO_INTR_AND_ABEND     181
#define CSTID_MOVE_PINNED_MENU              182
#define CSTID_CLOSE_PINNED_MENU             183
#define CSTID_RELEASE_MOUSE_TO_PIN_MENU     184
#define CSTID_LOCKED_OBJS_NOT_MOVED         185
#define CSTID_SCROLL_DOWN_1_LINE            186
#define CSTID_SCROLL_AROUND                 187
#define CSTID_SCROLL_UP_1_LINE              188
#define CSTID_ENABLE_REDRAW                 189
#define CSTID_DISABLE_REDRAW                190
#define CSTID_GET_DIR_LIST_PLEASE_WAIT      191
#define CSTID_ENTERING_HYPERSPACE           192
#define CSTID_GOTO                          193
#define CSTID_DELETE                        194
#define CSTID_CLOSE                         195
#define CSTID_BAD_OVAL_BBOX_ADJ             196
#define CSTID_SHIFT_ALL_TABS_RIGHT          197
#define CSTID_SHIFT_TABS_RIGHT              198
#define CSTID_SHIFT_TABS_LEFT               199

#define CSTID_SHIFT_ALL_TABS_LEFT           200
#define CSTID_SHIFT_10_TABS_RIGHT           201
#define CSTID_SHIFT_10_TABS_LEFT            202
#define CSTID_PAGE_MENU                     203
#define CSTID_GOTO_GIVEN_PAGE               204
#define CSTID_GOTO_GIVEN_PAGE_WITH_NAME     205
#define CSTID_GRAYSTR_CALLED_WITH_IDX_2     206
#define CSTID_GRAY_SCALE_USED_FOR_PAT       207
#define CSTID_SET_FILL_TO_NONE              208
#define CSTID_SET_FILL_TO_SOLID             209
#define CSTID_SET_FILL_TO_BACKGROUND        210
#define CSTID_SET_FILL_TO_PAT_NUMBER        211
#define CSTID_SET_LINE_WIDTH_TO_GIVEN_S     212
#define CSTID_SET_PEN_DASH_PAT_NO_DASH      213
#define CSTID_SET_PEN_DASH_PAT_PAT_NUM      214
#define CSTID_SET_PEN_TO_NONE               215
#define CSTID_SET_PEN_TO_SOLID              216
#define CSTID_SET_PEN_TO_BACKGROUND         217
#define CSTID_SET_PEN_TO_PAT_NUM            218
#define CSTID_SEL_A_PIN_ESC_TO_END_DOTS     219
#define CSTID_ADD_LAST_VERTEX               220
#define CSTID_SINGLE_PT_POLY_CONVERTED      221
#define CSTID_BAD_SMOOTHHINGE_POLY_FIXED    222
#define CSTID_CLOSE_POLYGON_SPLINE          223
#define CSTID_SNGL_PT_POLYGON_CONVERTED     224
#define CSTID_TWO_PT_POLYGON_CONVERTED      225
#define CSTID_FILEVER_TOO_LARGE_FOR_RCBOX   226
#define CSTID_BAD_RCBOX_BBOX_ADJUSTED       227
#define CSTID_PARANED_SEC_ELAPSED_AVG_SPEED 228
#define CSTID_UNZIPPING_WITH_CMD_DOTS       229
#define CSTID_UNCOMPRESSING_WITH_CMD_DOTS   230
#define CSTID_DATA_RECEIVED                 231
#define CSTID_FORWARDING_URL_TO_URL         232
#define CSTID_SCROLL_UP                     233
#define CSTID_SCROLL_DOWN                   234
#define CSTID_SCROLL_PAGE_UP                235
#define CSTID_SCROLL_PAGE_DOWN              236
#define CSTID_SCROLL_VERTICALLY             237
#define CSTID_SCROLL_HORIZONTALLY           238
#define CSTID_SCROLL_LEFT                   239
#define CSTID_SCROLL_RIGHT                  240
#define CSTID_SCROLL_PAGE_LEFT              241
#define CSTID_SCROLL_PAGE_RIGHT             242
#define CSTID_CANT_FIND_ATTR_WITH_COLOR     243
#define CSTID_CANT_FIND_FILEATTR_WITH_COLOR 244
#define CSTID_CANT_FIND_NAMED_ATTR          245
#define CSTID_CANT_FIND_INTERPRETABLE_ATTR  246
#define CSTID_NO_ACTION_TAKEN               247
#define CSTID_FAIL_READ_ICONPXMP_USE_BMP    248
#define CSTID_DRAG_MOUSE_CREATE_SHAPE_DOTS  249
#define CSTID_CREATE_A_SHAPE_ABORTED        250
#define CSTID_INSTANTIATING_FILE_DOTS       251
#define CSTID_ATTR_PROMOTED_TO_NEW_SYMBOL   252
#define CSTID_ATTR_PROMOTED_TO_NEW_ICON     253
#define CSTID_CREATING_FILE_DOTS            254
#define CSTID_NAMED_FILE_CREATED            255
#define CSTID_WRITING_ATTR_TO_NAMED_FILE    256
#define CSTID_SEMICOLON_USED_AS_SEPARATOR   257
#define CSTID_TAB_USED_AS_SEPARATOR         258
#define CSTID_PROCESSING_OBJ_NUMBER         259
#define CSTID_PLACING_NAMED_OBJ             260
#define CSTID_WRITING_ATTRS_IN_TBL_FORM_TO  261
#define CSTID_CORRUPTED_POLY_MKMULTISPLINE  262
#define CSTID_CORRUPTED_POLY_DMPMULTICURVE  263
#define CSTID_FIX_ATTEMPTED                 264
#define CSTID_PUSHING_INTO_NAMED            265
#define CSTID_CUR_FILE_IS                   266
#define CSTID_DONT_KNOW_HOW_HANDLE_FRAME_CT 267
#define CSTID_CANT_FIND_OBJ_NAME_ON_RESIZE  268
#define CSTID_PASTING_LINE_NUM_DOTS         269
#define CSTID_CANT_PASTE_DEL                270
#define CSTID_CANT_PASTE_BS                 271
#define CSTID_CANT_PASTE_ESC                272
#define CSTID_CANT_PASTE_TAB_REPLACE_BY_SPC 273
#define CSTID_READING_FILE_DOTS             274
#define CSTID_RETURNED_FROM_BASIC_DRIVER    275
#define CSTID_CACHING_BITMAP                276
#define CSTID_FINISHED_CACHEING_BITMAP      277
#define CSTID_NEW_BMP_SIZE_IS_W_X_H         278
#define CSTID_BLD_COLOR_TBL_FROM_PIXEL_DOTS 279
#define CSTID_GENERATING_IMAGEMAP_FILE_DOTS 280
#define CSTID_GENERATING_HTML_FILE_DOTS     281
#define CSTID_GENERATING_IMAGE              282
#define CSTID_FS_HALFTONE_BMP_THRESH_DOTS   283
#define CSTID_THRESHOLD_BMP_THRESH_DOTS     284
#define CSTID_INVALID_FILEVER_FOR_XBM       285
#define CSTID_FIELD_TOO_LONG_IN_OBJ_TRUNC   286
#define CSTID_FILE_LINE_BAD_FLD_IN_OBJ_STR  287
#define CSTID_MALFORMED_LINE_NUM_IN_FILE    288
#define CSTID_CACHING_PIXMAP                289
#define CSTID_FINISHED_CACHEING_PIXMAP      290
#define CSTID_NEW_XPM_SIZE_IS_W_X_H         291
#define CSTID_MANY_COLORS_GT_255_SKIP_XPM   292
#define CSTID_GIVEN_ADDTNL_COLOR_ALLOCATED  293
#define CSTID_INVALID_FILEVER_FOR_XPM       294
#define CSTID_COLOR_SUBS_FOR_UNRECOG_IN_XPM 295
#define CSTID_CONTEXT_MENU                  296
#define CSTID_GEN_TEMPLATE_HTML_FILE_DOTS   297
#define CSTID_SCALING_EVERYTHING_PAGE       298
#define CSTID_SQUARE_BRACK_MODIFIED         299

#define CSTID_SQUARE_BRACK_MODIFIED_UNSAV   300
#define CSTID_SQUARE_BRACK_UNNAMED          301
#define CSTID_PARANED_EMPTY                 302
#define CSTID_OPEN_FILE                     303
#define CSTID_INC_GRID_SIZE                 304
#define CSTID_DEC_GRID_SIZE                 305
#define CSTID_GRID_MENU                     306
#define CSTID_MOVE_EDIT_TEXT_BOX            307
#define CSTID_START_MOVE_EDIT_TEXT_BOX      308
#define CSTID_EDIT_ATTR_IN_EDITOR           309
#define CSTID_GET_NAMED_PROP_FROM_SEL_OBJ   310
#define CSTID_START_AN_EDGE_FROM_A_PORT     311
#define CSTID_ABORT                         312
#define CSTID_START_A_WIRE_FROM_NAMED_PORT  313
#define CSTID_END_A_WIRE_AT_NAMED_PORT      314
#define CSTID_SET_SIGNAME_FOR_NAMED_PORT    315
#define CSTID_CLK_ON_PORT_TO_RENAME_SIGNAME 316
#define CSTID_CLK_ON_PORT_TO_CLEAR_SIGNAME  317
#define CSTID_PORTNAME_TOO_LONG_SKIPPED     318
#define CSTID_CLEAR_SIGNAME_FOR_NAMED_PORT  319
#define CSTID_EDIT_ATTR_GROUP_IN_EDITOR     320
#define CSTID_INVALID_FILEVER_FOR_LINK_JPEG 321
#define CSTID_NO_SUCH_FONT                  322
#define CSTID_ACCEPT                        323
#define CSTID_ADD_A_STRUCT_VERTEX           324

#define MAXCACHEDSTIDS 325

/* ===================== Non-cached ===================== */

#define MINNONCACHEDSTIDS                  1000

#define STID_CANNOT_LOAD_FONTSET           1000
#define STID_CANNOT_LOAD_FONT              1001
#define STID_CANNOT_DISTRIBUTE_LOCKED_OBJS 1002
#define STID_VERTICES_HORI_APART           1003
#define STID_VERTICES_VERT_APART           1004
#define STID_LEFT_SIDES_APART              1005
#define STID_CENTERS_APART                 1006
#define STID_RIGHT_SIDES_APART             1007
#define STID_SPACED_APART_HORI             1008
#define STID_TOP_SIDES_APART               1009
#define STID_MIDDLES_APART                 1010
#define STID_BOTTOM_SIDES_APART            1011
#define STID_SPACED_APART_VERT             1012
#define STID_DISTR_VERTEX_HORI             1013
#define STID_DISTR_VERTEX_VERT             1014
#define STID_DISTR_VERTEX_VERT_AND_HORI    1015
#define STID_MOVE_ALL_VERTICES_YNC         1016
#define STID_CANNOT_ALIGN_OBJS_TOO_MANY    1017
#define STID_ALIGN_VERTICES_HORI_TO_GRID   1018
#define STID_ALIGN_VERTICES_VERT_TO_GRID   1019
#define STID_ALIGN_VERTICES_HORI           1020
#define STID_ALIGN_VERTICES_VERT           1021
#define STID_ALIGN_VERTICES_TO_GRID        1022
#define STID_ALIGN_VERTICES                1023
#define STID_SELECT_ONE_POLY_ONE_NON_POLY  1024
#define STID_CANNOT_MOVE_A_VERTEX_LOCKED   1025
#define STID_SELECT_ONLY_ONE_POLY          1026
#define STID_NO_ARC_CREATED                1027
#define STID_INVALID_ARC_VERSION           1028
#define STID_WARN_INCONSIST_ARC_DIR        1029
#define STID_ARC_SPEC                      1030
#define STID_INVALID_ARC_SPEC_RADIUS       1031
#define STID_INVALID_ARC_SPEC_DIR          1032
#define STID_INVALID_ARC_SPEC_THETA1       1033
#define STID_SELECT_AT_LEAST_ONE_TEXT      1034
#define STID_MORE_THAN_ONE_NON_TEXT        1035
#define STID_NO_TEXT_SELECTED_ADD_ATTRS    1036
#define STID_NO_NON_TEXT_SELECTED          1037
#define STID_TEXT_ATTACHED                 1038
#define STID_TEXT_UNLOCKED_AND_ATTACHED    1039
#define STID_UNEXPECTED_EOF_IN_ABORT_READ  1040
#define STID_STRING_LEN_EXCEEDS_AND_TRUNC  1041
#define STID_MOVE_ONE_ATTR_MOUSE_MSG       1042
#define STID_CANNOT_MOVE_ATTR_IF_LOCKED    1043
#define STID_SHOW_MOVE_ATTR                1044
#define STID_TOGGLE_NAME_SHOWN             1045
#define STID_HIDE_ATTR                     1046
#define STID_CHANGE_ATTR_JUST_MOUSE_MSG    1047
#define STID_LEFT_JUSTIFY                  1048
#define STID_CENTER_JUSTIFY                1049
#define STID_RIGHT_JUSTIFY                 1050
#define STID_SELECT_ONLY_ONE_OBJ           1051
#define STID_SELECT_HAS_NO_ATTR            1052
#define STID_DRAG_LEFT_BTN_TO_SEE_ATTR     1053
#define STID_CHANGE_ATTR_JUST              1054
#define STID_IS_ATTR_OBSOLETE_FOR_ICON_YNC 1055
#define STID_BAD_FORMAT_IN_SHORTCUT_SPEC   1056
#define STID_CANNOT_FIND_NAMED_ATTR        1057
#define STID_ATTACH_FILE_ATTRS_IN_WB       1058
#define STID_CANNOT_ATTACH_NON_TEXT_OBJ    1059
#define STID_DETACH_FILE_ATTRS_IN_WB       1060
#define STID_FILE_CONTAINS_NO_ATTRS        1061
#define STID_SHOW_ATTR_NAME_AND_VALUE      1062
#define STID_SHOW_ATTR_VALUE_ONLY          1063
#define STID_NOT_SHOW_ATTR                 1064
#define STID_SHOW_ATTR                     1065
#define STID_WONT_SHOW_VALUE               1066
#define STID_TGIF_EDIT_ATTR_NAMES          1067
#define STID_EDIT_FILE_ATTRS_IN_WB         1068
#define STID_EDIT_FILE_ATTRS_DOTS          1069
#define STID_FILE_ATTRS_UPDATED            1070
#define STID_SELECT_ONE_OBJ_FOR_EDITATTRS  1071
#define STID_OBJ_CONTAINS_NO_ATTRS         1072
#define STID_EDIT_OBJ_ATTRS_DOTS           1073
#define STID_OBJ_ATTRS_UPDATED             1074
#define STID_INPUT_OCTAL_STR               1075
#define STID_INPUT_STR                     1076
#define STID_WARN_PRINT_COURIER_IN_COLOR   1077
#define STID_MAY_CAUSE_ERROR_IN_PRINTOUT   1078
#define STID_BAD_OCTAL_STRING_ENCOUNTERED  1079
#define STID_SERVER_NOT_STARTED            1080
#define STID_INVISIBLE_COLOR_SELECTED_YNC  1081
#define STID_COLOR_IS_CURRENTLY_INVISIBLE  1082
#define STID_COLOR_SET_TO                  1083
#define STID_TEXT_VSPACE_TOO_SMALL_RESET_0 1084
#define STID_FONT_AND_SIZE_NOT_AVAILABLE   1085
#define STID_LINE_WIDTH_SET_TO             1086
#define STID_LINE_TYPE_IS_STRAIGHT         1087
#define STID_LINE_TYPE_IS_SPLINE           1088
#define STID_LINE_TYPE_IS_INTSPLINE        1089
#define STID_TAB_FOR_FILE_COMPLETION       1090
#define STID_FAIL_TO_CREATE_WINDOW         1091
#define STID_FAIL_TO_CREATE_NAMED_WINDOW   1092
#define STID_UNDO_REDO_MAY_CAUSE_CRASH     1093
#define STID_UNDO_IN_WB                    1094
#define STID_NO_COMMANDS_TO_UNDO           1095
#define STID_REDO_IN_WB                    1096
#define STID_NO_COMMANDS_TO_REDO           1097
#define STID_SELECT_LIST_NOT_SORTED_IN     1098
#define STID_WARN_CANNOT_PARSE_NAMED_COLOR 1099

#define STID_CANNOT_ALLOC_NAMED_COLOR      1100
#define STID_CANNOT_BREAKUP_EPS            1101
#define STID_INVALID_FILE_IN_X_DEFAULT     1102
#define STID_INVALID_XDEF_COLORXPM_GET     1103
#define STID_INVALID_XDEF_COLORXPM_TRANS   1104
#define STID_FAIL_ALLOC_EDIT_TEXT_BGCOLOR  1105
#define STID_FAIL_ALLOC_EDIT_TEXT_HICOLOR  1106
#define STID_FAIL_ALLOC_DEF_BGCOLOR        1107
#define STID_INVALID_XDEF_USE_ALT_VALUE    1108
#define STID_NORM_VIDEO_MODE_ASSUMED       1109
#define STID_ZERO_COLORS_SPECIFIED         1110
#define STID_CANNOT_GET_X_DEFAULT          1111
#define STID_INVALID_XDEF_WILL_TRY_STR     1112
#define STID_FAIL_TO_ALLOC_3D_COLORS       1113
#define STID_FAIL_TO_ALLOC_COLOR_NUM       1114
#define STID_DEFCOLORINDEX_GE_MAXCOLORS    1115
#define STID_FAIL_ALLOC_NAMED_COLOR_ABORT  1116
#define STID_FAIL_ALLOC_COLOR_NUM_ABORT    1117
#define STID_UNEXPECTED_MAX_RGB_ZERO       1118
#define STID_FG_BG_SAME_COLOR_WARNING      1119
#define STID_CANNOT_SET_FG_COLOR           1120
#define STID_INVISIBLE_COLOR_SELECTED      1121
#define STID_ALL_COLOR_LAYERS_VISIBLE      1122
#define STID_ALL_COLOR_LAYERS_INVISIBLE    1123
#define STID_A_COLOR_LAYER_TURNED_ON       1124
#define STID_A_COLOR_LAYER_TURNED_OFF      1125
#define STID_TURN_COLOR_LAYER_NUM_ON       1126
#define STID_TURN_COLOR_LAYER_NUM_OFF      1127
#define STID_COLORMAP_NOT_RESETED          1128
#define STID_ADDCOLOR_FOR_BW_DPY           1129
#define STID_ENTER_COLORS_TO_ADD           1130
#define STID_FAIL_ALLOC_NAMED_COLOR        1131
#define STID_ENTER_EDIT_BG_COLOR           1132
#define STID_ENTER_EDIT_HILIGHT_COLOR      1133
#define STID_COLOR_LAYERS_ENABLED          1134
#define STID_COLOR_LAYERS_DISABLED         1135
#define STID_TOO_MANY_LINES_IN_COLORINFO   1136
#define STID_WAIT_FOR_START_CONV           1137
#define STID_NO_NAMED_SELECTION_OWNER      1138
#define STID_FAIL_TO_CHANGE_CONV_PROP      1139
#define STID_FAIL_TO_INTERN_NAMED_ATOM     1140
#define STID_FAIL_TO_CONNECT_TO_OWNER      1141
#define STID_FAIL_TO_GET_WIN_PROP          1142
#define STID_FAIL_TO_DISCONNECT_FROM_OWNER 1143
#define STID_LOCALE_IS                     1144
#define STID_MODIFIER_IS                   1145
#define STID_CANNOT_OPEN_XIM               1146
#define STID_OVERTHESPOT_CONV              1147
#define STID_ROOT_CONV                     1148
#define STID_IM_NOT_SUPPORT_GIVEN_STYLE    1149
#define STID_FAIL_TO_CREATE_INPUTCONTEXT   1150
#define STID_OPEN_XIM                      1151
#define STID_CLOSE_XIM                     1152
#define STID_INVALID_XDEF_USE_ALT_STR      1153
#define STID_NO_OBJ_SELECTED_FOR_COPY      1154
#define STID_CANNOT_OPEN_FILE_FOR_WRITING  1155
#define STID_CANNOT_OPEN_FILE_FOR_READING  1156
#define STID_FAIL_TO_FSTAT_ABORT_COPY      1157
#define STID_ERR_READING_FILE_COPY_ABORT   1158
#define STID_COPY_FAILED_OBJ_MAYBE_TOO_BIG 1159
#define STID_COPY_BUFFER_UPDATED           1160
#define STID_ESC_KEY_PRESS_IGNORED         1161
#define STID_CUT_BUFFER_EMPTY              1162
#define STID_STR_EXCEEDS_NUM_CH_IGNORED    1163
#define STID_PASTE_FROM_NON_TGIF           1164
#define STID_ERR_WRITING_FILE_PASTE_ABORT  1165
#define STID_FILEVER_TOO_LARGE_PASTE_ABORT 1166
#define STID_CANNOT_PASTE_MIXED_TEXT       1167
#define STID_STR_BLOCKS_PASTED_FROM_TGIF   1168
#define STID_OBJS_PASTED_FROM_TGIF         1169
#define STID_SEL_A_FILE_TO_PASTE_DOTS      1170
#define STID_PASTING_REMOTE_FILE_NOT_SUP   1171
#define STID_NAMED_FILE_IS_EMPTY           1172
#define STID_CANNOT_MALLOC_NUM_BYTES       1173
#define STID_NO_PRIMARY_SELECTION_OWNER    1174
#define STID_CONVERTING_GIVEN_DOTS         1175
#define STID_TIMEOUT_CONVERT_GIVEN         1176
#define STID_PROBLEM_CONVERT_GIVEN         1177
#define STID_PASTE_COMP_TEXT_FROM_NON_TGIF 1178
#define STID_CANNOT_FIND_SIZE_USE_ALT      1179
#define STID_CANNOT_FIND_FONT_USE_ALT      1180
#define STID_CANNOT_PASTE_COMPOUND_OBJ     1181
#define STID_CUT_BUF_HAS_NON_ROT_COMP      1182
#define STID_NO_PROPERTY_TO_PASTE          1183
#define STID_NO_PROPERTY_TO_COPY           1184
#define STID_INVALID_KEY_IN_SEC_OF_INIFILE 1185
#define STID_ENTER_NAME_FOR_PROP_SET       1186
#define STID_PROP_SET_EXISTS_OVERWRITE_YNC 1187
#define STID_NO_PROP_TO_SAVE               1188
#define STID_WILL_COPY_NAMED_PROP          1189
#define STID_WILL_NOT_COPY_NAMED_PROP      1190
#define STID_WILL_SAVE_NAMED_PROP          1191
#define STID_WILL_NOT_SAVE_NAMED_PROP      1192
#define STID_WILL_PASTE_NAMED_PROP         1193
#define STID_WILL_NOT_PASTE_NAMED_PROP     1194
#define STID_WILL_RESTORE_NAMED_PROP       1195
#define STID_WILL_NOT_RESTORE_NAMED_PROP   1196
#define STID_TOOL_COPY_PROP                1197
#define STID_TOOL_SAVE_PROP                1198
#define STID_TOOL_PASTE_PROP               1199

#define STID_TOOL_RESTORE_PROP             1200
#define STID_SEL_ONLY_ONE_FOR_COPY_PROP    1201
#define STID_SEL_ONLY_ONE_FOR_SAVE_PROP    1202
#define STID_UNCHECK_PROP_FOR_COPY_DOTS    1203
#define STID_UNCHECK_PROP_FOR_SAVE_DOTS    1204
#define STID_UNCHECK_PROP_FOR_PASTE_DOTS   1205
#define STID_UNCHECK_PROP_FOR_RESTORE_DOTS 1206
#define STID_MALFORMED_CUT_BUF_WHILE_PASTE 1207
#define STID_NO_PROP_SETS_TO_RESTORE       1208
#define STID_SEL_A_PROP_SET_TO_RESTORE     1209
#define STID_TOOL_EDIT_INI_SECTION         1210
#define STID_BAD_VALUE_FOR_KEY             1211
#define STID_NOTHING_TO_EDIT_SEC_EMPTY     1212
#define STID_EDIT_VALUES_FOR_DOTS          1213
#define STID_TOOL_SEL_FROM_INI_SECTION     1214
#define STID_NOTHING_TO_SEL_SEC_EMPTY      1215
#define STID_SELECT_A_VALUE_FROM_SEC_DOTS  1216
#define STID_COPY_PROP_BEFORE_PASTE        1217
#define STID_INVALID_PARAM_PASSED_TO_FUNC  1218
#define STID_TOOL_INPUT                    1219
#define STID_WARN_INVALID_NUMREDRAWBBOX    1220
#define STID_USER_INTR_ABORT_REPAINT       1221
#define STID_CANNOT_ALLOC_XPM_NO_ANIM      1222
#define STID_SCROLLING_CANCELED            1223
#define STID_CANNOT_ALLOC_PIXMAP_OF_SIZE   1224
#define STID_FORCING_END_ANIMATE           1225
#define STID_TOOL_NOT_FINISH_WITH_EXEC     1226
#define STID_NO_INTSPLINE_SELECTED         1227
#define STID_INTSPLINE_CONVERTED_TO_SPLINE 1228
#define STID_SELECT_ONLY_ONE_POLY_POLYGON  1229
#define STID_CANNOT_TOGGLE_FOR_INTSPLINE   1230
#define STID_BAD_POLY_IN_TOGGLE_SMOOTH     1231
#define STID_CLICK_LEFT_BUTTON_TO_TOGGLE   1232
#define STID_CLICK_OTHER_BUTTON_TO_QUIT    1233
#define STID_ONLY_TOGGLE_SMOOTH_IN_MODES   1234
#define STID_SMOOTHNESS_TOGGLED            1235
#define STID_BREAK_TEXT_CWL                1236
#define STID_BREAK_TEXT_CL                 1237
#define STID_BREAK_TEXT_CW                 1238
#define STID_INVALID_SPEC_ON_BREAK_TEXT    1239
#define STID_NO_TEXT_OBJ_TO_BREAK_UP       1240
#define STID_SOME_TEXT_NOT_BROKEN_UP_SIZE  1241
#define STID_TEXT_BROKEN_INTO_CHARS        1242
#define STID_CUR_TEXT_BG_SET_TO_NAMED      1243
#define STID_SOME_TEXT_BG_SET_TO_NAMED     1244
#define STID_SEL_ONE_POLYGON_TO_MAKE_REG   1245
#define STID_POLYGON_LOCKED                1246
#define STID_POLYGON_TOO_SMALL_FOR_REGULAR 1247
#define STID_VERTEX_AT_3_OCLOCK_YNC        1248
#define STID_CANNOT_DEL_PT_FOR_LOCKED      1249
#define STID_LEFT_BTN_TO_DEL_PTS           1250
#define STID_CANNOT_ADD_PT_FOR_LOCKED      1251
#define STID_CANNOT_ADD_PT_FOR_AUTO_ARROW  1252
#define STID_LEFT_BTN_TO_ADD_PTS           1253
#define STID_UNDO_BUF_AND_CMAP_FLUSHED     1254
#define STID_NUM_COLORS_ALLOCATED          1255
#define STID_UNDO_BUF_FLUSHED              1256
#define STID_SEL_ONE_XBM_OR_XPM_TO_RESTORE 1257
#define STID_CANNOT_RESTORE_LOCKED         1258
#define STID_SEL_ONE_XBM_OR_XPM_TO_CUT     1259
#define STID_CANNOT_CUT_LOCKED             1260
#define STID_CANNOT_CUT_TRANSFORMED_X_OBJ  1261
#define STID_SEL_ONE_XBM_OR_XPM_TO_BREAKUP 1262
#define STID_CANNOT_BREAK_XFORMED_X_OBJ    1263
#define STID_CANNOT_BREAKUP_LOCKED         1264
#define STID_ENTER_NUM_ROWCOL_TO_BREAK     1265
#define STID_INVALID_ROWCOL_SPEC_REENTER   1266
#define STID_ENTER_CONCAVE_OR_CONVEX       1267
#define STID_INVALID_SPEC                  1268
#define STID_SEL_AN_ARC_OBJ                1269
#define STID_NO_ARC_OBJ_SELECTED           1270
#define STID_TOO_MANY_ARC_SEL_ONLY_ONE_ARC 1271
#define STID_NO_OTHER_OBJ_FOR_LAYOUTONARC  1272
#define STID_CANNOT_LAYOUTONARC_LOCKED     1273
#define STID_ARC_XFORMED_FOR_LAYOUTONARC   1274
#define STID_ROT_NOT_AVAIL_ON_VERTEX_MODE  1275
#define STID_ENTER_AN_ANGLE_IN_DEGREES     1276
#define STID_INVALID_SPEC_NUM_EXPECTED     1277
#define STID_SOME_GROUP_OBJ_NOT_MODIFIED   1278
#define STID_CANNOT_REM_XFORM_FOR_GROUPED  1279
#define STID_ENTER_EDIT_TEXT_SIZE          1280
#define STID_EDIT_TEXT_SIZE_OUT_OF_RANGE   1281
#define STID_ACTUAL_EDIT_TEXT_SIZE         1282
#define STID_USE_SPECIFIED_EDIT_TEXT_SIZE  1283
#define STID_CANNOT_FIND_NAMED_STRING      1284
#define STID_FIND_CMD_WRAPPED              1285
#define STID_ENTER_CASE_STR_TO_FIND        1286
#define STID_ENTER_NOCASE_STR_TO_FIND      1287
#define STID_NO_PREVIOUS_FIND              1288
#define STID_CANNOT_ABUT_IN_VERTEX_MODE    1289
#define STID_CANNOT_ABUT_LOCKED            1290
#define STID_ABUTTED_HORI                  1291
#define STID_ABUTTED_VERT                  1292
#define STID_ICONS_BROUGHT_UP_TO_DATE      1293
#define STID_SEL_AT_LEAST_TWO_OBJS         1294
#define STID_CANNOT_SIZE_OF_GIVEN_WIDTH    1295
#define STID_CANNOT_SIZE_OF_GIVEN_HEIGHT   1296
#define STID_SPECIFY_WIDTH_HEIGHT          1297
#define STID_SPECIFY_WIDTH                 1298
#define STID_SPECIFY_HEIGHT                1299

#define STID_NAMED_XDEF_IS_OBSOLETE        1300
#define STID_GIVEN_BPS_PREVIEW_NOT_SUP     1301
#define STID_INVALID_PREVIEW_BMP_IN_EPS    1302
#define STID_FAIL_TO_WRITE_TO_STDOUT       1303
#define STID_FAIL_TO_PARSE_WINEPS_FILE     1304
#define STID_INVALID_PREVIEW_BOX_IN_EPS    1305
#define STID_CANNOT_BBOX_IN_GIVEN_FILE     1306
#define STID_CANNOT_CONVERT_WINEPS_PREVIEW 1307
#define STID_CANNOT_OPEN_EPS_FILE_FOR_READ 1308
#define STID_EPS_OBJ_SKIPPED_FOR_PRINT     1309
#define STID_EPS_FILE_NEWER_THAN_EPS_OBJ   1310
#define STID_NO_TOP_LEVEL_EPS_SELECTED     1311
#define STID_CANNOT_IMPORT_GIVEN_EPS       1312
#define STID_EPS_OBJECT_UPDATED            1313
#define STID_CANNOT_EVAL_INVALID_OP_TYPE   1314
#define STID_DIVIDE_BY_ZERO_FOR_OP_TYPE    1315
#define STID_ILLEGAL_EXPR_INVALID_OP_CODE  1316
#define STID_ILLEGAL_EXPR_EMPTY_OP_STACK   1317
#define STID_ILLEGAL_EXPR_BAD_NUM_VALUE    1318
#define STID_ILLEGAL_EXPR_BAD_STR_VALUE    1319
#define STID_ILLEGAL_EXPR_BAD_IDENTIFIER   1320
#define STID_ILLEGAL_EXPR_BAD_OPERATOR     1321
#define STID_ILLEGAL_EXPR_TOO_MANY_SYMBOL  1322
#define STID_ILL_EXPR_OP_STACK_NON_EMPTY   1323
#define STID_ILL_EXPR_VAL_STACK_NON_EMPTY  1324
#define STID_ILL_EXPR_TOO_MANY_VALS_LEFT   1325
#define STID_CANNOT_OPEN_FOR_READ_PRINT    1326
#define STID_CANNOT_OPEN_FOR_WRITE_PRINT   1327
#define STID_CANNOT_FIND_CMD_EXEC          1328
#define STID_CANNOT_FIND_CMD_IN_PATH_EXEC  1329
#define STID_CANT_FIND_CMD_MSG_EXEC        1330
#define STID_CANT_FIND_CMD_INPATH_MSG_EXEC 1331
#define STID_FILE_EXISTS_OK_OVERWRITE_YNC  1332
#define STID_ONE_PAGE_SYM_ABORT_SAVE       1333
#define STID_ONE_PAGE_PIN_ABORT_SAVE       1334
#define STID_TOO_MANY_SYM_ABORT_SAVE       1335
#define STID_CANT_OPEN_WRITE_FILE_NOT_SAVE 1336
#define STID_SAVE_TMP_FILE_DOTS            1337
#define STID_TMP_FILE_SAVED                1338
#define STID_CANNOT_CHMOD                  1339
#define STID_WORKING_DIRECTORY_IS          1340
#define STID_ENTER_NEW_FNAME_ACCEPT_CANCEL 1341
#define STID_CANT_SAVE_SYM_NO_SYM_FOUND    1342
#define STID_CANT_SAVE_PIN_NO_SYM_FOUND    1343
#define STID_CANT_SAVE_OJB_ONE_SYM_FOUND   1344
#define STID_CANT_SAVE_SYM_SAVE_AS_PIN     1345
#define STID_CANT_SAVE_PIN_ONE_SYM_FOUND   1346
#define STID_CANT_SAVE_OJB_TWO_SYM_FOUND   1347
#define STID_CANT_SAVE_SYM_TWO_SYM_FOUND   1348
#define STID_CANT_FIND_TYPE_ATTR_NOT_SAVED 1349
#define STID_SYM_TYPE_WRONG_PIN_NOT_SAVED  1350
#define STID_NO_FILE_NAME_FILE_NOT_SAVED   1351
#define STID_SAVING_DOTS                   1352
#define STID_PROBLEM_ZIPPING_PLEASE_SAVE   1353
#define STID_FILE_SAVED                    1354
#define STID_FILE_NOT_SAVED                1355
#define STID_NO_SYM_FOUND_SYM_NOT_SAVED    1356
#define STID_ENTER_NEW_FILE_NAME           1357
#define STID_CANT_FIND_DOT_IN_SAVEFILE     1358
#define STID_NO_SYM_FOUND_PIN_NOT_SAVED    1359
#define STID_SYM_TYPE_IS_SHOULD_SAVE_PIN   1360
#define STID_TOO_MANY_SYM_FILE_NOT_SAVED   1361
#define STID_BAD_FIELD_IN_FUNC_ABORT_READ  1362
#define STID_UNRECOG_PAGE_STYLE            1363
#define STID_PORTRAIT_STYLE_ASSUMED        1364
#define STID_CANT_FIND_COLOR_NUM_USE_CUR   1365
#define STID_LINEWIDTH_IDX_RANGE_SET_TO_0  1366
#define STID_BAD_FIELD_IN_OBJ_ABORT_READ   1367
#define STID_BAD_INPUT_WHILE_READ_PAGE     1368
#define STID_BAD_PAGE_FILE_NAME_TRUNC_TO   1369
#define STID_CUR_COLOR_CORRECTED_TO_BE     1370
#define STID_FAIL_ALLOC_BGCOLOR_USE_DEF    1371
#define STID_ONLY_PAGE_1_IMPORTED          1372
#define STID_ONLY_GIVEN_PAGE_IMPORTED      1373
#define STID_INVALID_REMOTE_FNAME          1374
#define STID_CANNOT_READ_TMP_FILE          1375
#define STID_CANNOT_IMPORT_FILE            1376
#define STID_INVALID_PAGE_NUM              1377
#define STID_USER_INTR_ABORT_DRAW          1378
#define STID_FILE_VER_ABORT_IMPORT         1379
#define STID_FILE_CORRUPTED_ABORT_IMPORT   1380
#define STID_FILE_IMPORTED                 1381
#define STID_SEL_AN_OBJ_FILE_TO_IMPORT     1382
#define STID_CANNOT_ALLOC_BGCOLOR_USE_DEF  1383
#define STID_CANNOT_ALLOC_FGCOLOR_USE_DEF  1384
#define STID_CANNOT_SET_BGXPM_TO           1385
#define STID_COLORMAP_FLUSHED              1386
#define STID_FILE_VER_ABORT_OPEN           1387
#define STID_FILE_CORRUPTED_ABORT_OPEN     1388
#define STID_POP_BACK_TO_NAMED             1389
#define STID_WARN_PS_BBOX_EMPTY            1390
#define STID_TIFFEPSI_DIRECTLY_SUPPORTED   1391
#define STID_INVALID_XDEF                  1392
#define STID_FAIL_EXEC_PROG_EPSI_NOT_GEN   1393
#define STID_FAIL_GET_FINFO_EPSI_NOT_GEN   1394
#define STID_CANNOT_OPEN_FILE_FOR_APPEND   1395
#define STID_CANNOT_PRINT_REMOTE_FILE      1396
#define STID_NO_OBJ_TO_PRINT_ON_PAGE       1397
#define STID_NO_OBJ_TO_PRINT               1398
#define STID_NO_CUR_FILE_CANNOT_GEN_FORMAT 1399

#define STID_GENERATING_PRINT_FILE_DOTS    1400
#define STID_NO_OBJ_TO_EXPORT              1401
#define STID_WRITING_TO_DOTS               1402
#define STID_GENERATING_PREVIEW_BITMAP     1403
#define STID_OUTPUT_TRUNC_IN_PRINT_TILED   1404
#define STID_RECOMMEND_REDUCING_SETTING    1405
#define STID_PRINTING_WITH_GIVEN_CMD       1406
#define STID_CANNOT_EXEC_ABORT_PRINT       1407
#define STID_NAMED_FILE_PRINTED            1408
#define STID_PRINT_COMPLETED               1409
#define STID_PRINTING_INTO_NAMED_FILE      1410
#define STID_GENERATING_TIFF_PREVIEW_BMP   1411
#define STID_FORMAT_FILE_NOT_GENERATED     1412
#define STID_CONVERTING_INTO_NAMED_FILE    1413
#define STID_CANNOT_EXEC_FORMAT_NOT_GEN    1414
#define STID_FORMAT_FILE_PRINTED_INTO      1415
#define STID_NO_CUR_FILE_CANNOT_GEN_TEXT   1416
#define STID_TEXT_OUTPUT_NOT_GEN           1417
#define STID_TEXT_PRINTED_INTO_NAMED_FILE  1418
#define STID_TOO_MANY_COLOR_FOR_XPM_EXPORT 1419
#define STID_CANNOT_PRINT_EPS_TILED_PAGE   1420
#define STID_PREPROCESS_PAGE_OF            1421
#define STID_GENERATING_PAGE_OF            1422
#define STID_GIVEN_PAGE_NOT_GENERATED      1423
#define STID_PAGE_RANGE_NOT_GENERATED      1424
#define STID_PRINTWITHCMD_WORKS_PRINTER    1425
#define STID_ENTER_PRINT_CMD_NAME          1426
#define STID_NO_OBJ_SEL_NOTHING_TO_PRINT   1427
#define STID_SPECIFY_PERCENT_REDUCTION     1428
#define STID_INVALID_REDUCTION             1429
#define STID_NEW_REDUCTION_IS_PERCENT      1430
#define STID_NEW_ENLARGEMENT_IS_PERCENT    1431
#define STID_OK_TO_CLEAR_WHITEBOARD        1432
#define STID_FILE_MOD_SAVE_BEFORE_CLEAR    1433
#define STID_EDITING_NO_FILE               1434
#define STID_OPEN_IN_WB                    1435
#define STID_FILE_MOD_SAVE_BEFORE_OPEN     1436
#define STID_SELECT_A_FILE_TO_OPEN         1437
#define STID_INVALID_PAGE_SPECIFIED_FOR    1438
#define STID_SETTEMPLATE_IN_WB             1439
#define STID_SELECT_FILE_AS_TEMPLATE       1440
#define STID_NOT_SUP_REMOTE_TEMPLATE_FILE  1441
#define STID_CANNOT_OPEN_STILL_TEMPLATE    1442
#define STID_STILL_USE_AS_TEMPLATE         1443
#define STID_TEMPLATE_SET_TO               1444
#define STID_FILE_MOD_SAVE_BEFORE_QUIT     1445
#define STID_ANCESTER_MOD_STILL_QUIT       1446
#define STID_ILLEGAL_DOUBLE_BYTE_TRUNC     1447
#define STID_TOOL_CANT_HANDLE_DB_FONT      1448
#define STID_FAIL_LOAD_FONT_FONT_SUBS      1449
#define STID_FONT_SUBSTITUTED              1450
#define STID_CANNOT_GET_IMAGE_OF_SIZE      1451
#define STID_UNRECOG_CHARCODE_DISCARD      1452
#define STID_CANT_FIND_FONT_USE_ALT        1453
#define STID_BAD_XDEF_CANT_FIND_EQ_SKIP    1454
#define STID_BAD_XDEF_MISS_FONT_NAME_SKIP  1455
#define STID_MISS_FONT_SPEC_IN_XDEF        1456
#define STID_INVALID_X_FONT_INFO_IN_XDEF   1457
#define STID_INVALID_X_REG_INFO_IN_XDEF    1458
#define STID_INVALID_PS_INFO_IN_XDEF       1459
#define STID_ERR_PROCESS_FONT_USE_ALT      1460
#define STID_INVALID_SB_FONT_USE_DB_FONT   1461
#define STID_ERR_PROCESS_SIZE_USE_DEF_SIZE 1462
#define STID_OBSOLETE_XDEF_USE_ALT         1463
#define STID_CANT_OPEN_DEF_MSG_FONT_ABORT  1464
#define STID_WARN_VERY_SMALL_DEF_FONT      1465
#define STID_CANT_OPEN_RULER_FONT_ABORT    1466
#define STID_WARN_VERY_SMALL_RULER_FONT    1467
#define STID_CANNOT_SET_INITIAL_FONT_TO    1468
#define STID_CANT_SET_INIT_FONTSTYLE_ALT   1469
#define STID_CANT_SET_INIT_FONTJUST_ALT    1470
#define STID_CANT_SET_INIT_FONTSIZE_ALT    1471
#define STID_FONT_NOT_AVAILABLE            1472
#define STID_CANT_CHANGE_SIZEPT_TO_USE_ALT 1473
#define STID_CANT_CHANGE_SIZE_TO_USE_ALT   1474
#define STID_INVALID_VSPACE_NOT_CHANGED    1475
#define STID_VSPACE_TOO_SMALL_NOT_CHANGED  1476
#define STID_ENTER_POINT_SIZE              1477
#define STID_ENTER_FONT_SIZE               1478
#define STID_FONT_SIZE_TOO_SMALL           1479
#define STID_FONT_SUB_NO_SUCH_FONT_USR_DEF 1480
#define STID_NO_KANJI_FONT_GIVEN_NUMBER    1481
#define STID_FAIL_TO_CONN_TO_HOST          1482
#define STID_NETWORK_READ_ERROR            1483
#define STID_NETWORK_ERROR                 1484
#define STID_CONN_ABORT_BY_USER            1485
#define STID_CONN_TERM_BY_SERVER           1486
#define STID_FAIL_TO_OPEN_DATA_SOCKET      1487
#define STID_USING_METRIC_SYSTEM           1488
#define STID_USING_ENGLISH_SYSTEM          1489
#define STID_SNAP_NOT_ON_GRID_SZ_SAME      1490
#define STID_AT_MAX_GRID_GRID_SZ_SAME      1491
#define STID_AT_MIN_GRID_GRID_SZ_SAME      1492
#define STID_SNAP_TO_GRID_ACTV             1493
#define STID_SNAP_TO_GRID_DISABLED         1494
#define STID_WILL_PRINT_IN_COLOR           1495
#define STID_WILL_PRINT_IN_BW              1496
#define STID_CONSTRAINED_MOVE              1497
#define STID_UNCONSTRAINED_MOVE            1498
#define STID_WILL_DISPLAY_XBM_XPM          1499

#define STID_WILL_NOT_DISPLAY_XBM_XPM      1500
#define STID_GRAY_SCALE_IN_BW_PRINTING     1501
#define STID_NO_GRAY_SCALE_IN_BW_PRINTING  1502
#define STID_CURRENT_SPEC_IS               1503
#define STID_ENTER_MEASURE_UNIT_SPEC       1504
#define STID_WILL_EXPORT_FORMAT_FILE       1505
#define STID_PRINT_DEV_SET_TO_PRINTER      1506
#define STID_WILL_EXPORT_EPS_FILE          1507
#define STID_WILL_EXPORT_RAW_PS_FILE       1508
#define STID_WILL_EXPORT_XPM_FILE          1509
#define STID_WILL_EXPORT_XBM_FILE          1510
#define STID_WILL_EXPORT_TEXT_FILE         1511
#define STID_WILL_EXPORT_EPSI_FILE         1512
#define STID_WILL_EXPORT_GIF_FILE          1513
#define STID_WILL_EXPORT_HTML_FILE         1514
#define STID_WILL_EXPORT_PDF_FILE          1515
#define STID_WILL_EXPORT_TIFFEPSI_FILE     1516
#define STID_ONE_MOTION_SEL_MOVE_MODE      1517
#define STID_CLICK_SEL_CLICK_MOVE_MODE     1518
#define STID_CANT_TOGGLE_COLOR_LAYER_BW    1519
#define STID_STRETCHABLE_TEXT_MODE         1520
#define STID_NON_STRETCHABLE_TEXT_MODE     1521
#define STID_TRANS_PAT_MODE                1522
#define STID_NON_TRANS_PAT_MODE            1523
#define STID_ALREADY_AT_DEF_ZOOM           1524
#define STID_ALREADY_AT_HIGHEST_MAG        1525
#define STID_CURSOR_IGNORED_CSBTN1         1526
#define STID_ZOOMIN_AROUND_EDIT_TEXT       1527
#define STID_SEL_ZOOM_CENTER               1528
#define STID_ZOOMIN_CANCEL_BY_USER         1529
#define STID_AT_PAPER_EDGE_CANT_ZOOMOUT    1530
#define STID_PAGE_STYLE_CHANGE_TO_LAND     1531
#define STID_PAGE_STYLE_CHANGE_TO_PORT     1532
#define STID_WARN_PIN_NOT_SUPPORTED        1533
#define STID_ONE_SIMPLE_GROUP_UNGROUP_ANY  1534
#define STID_ALL_SIMPLE_GROUP_UNGROUP_ANY  1535
#define STID_SEL_OBJ_ARE_UNGROUPED         1536
#define STID_NO_OBJ_TO_LOCK                1537
#define STID_CANNOT_LOCK_IN_VERTEX_MODE    1538
#define STID_SEL_OBJ_ARE_LOCKED            1539
#define STID_NO_OBJ_TO_UNLOCK              1540
#define STID_CANNOT_UNLOCK_IN_VERTEX_MODE  1541
#define STID_SEL_OBJ_ARE_UNLOCKED          1542
#define STID_TOOL_VERSION                  1543
#define STID_TOOL_VERSION_SPC_BUILD        1544
#define STID_TOOL_VERSION_PATCH            1545
#define STID_TOOL_VERSION_PATCH_SPC_BUILD  1546
#define STID_HYPER_TEXT_HOME               1547
#define STID_LATEST_REL_INFO               1548
#define STID_HYPER_GRAPHICS_INFO           1549
#define STID_MAILING_LIST_INFO             1550
#define STID_SEND_BUG_REPORT_TO            1551
#define STID_OPEN_URL_FAIL_USE_BROWSER     1552
#define STID_FIND_VER_FAIL_USE_BROWSER     1553
#define STID_TOOL_CUR_VER_IS_DIFF_INFO     1554
#define STID_TOOL_CUR_VER_IS_DIFF_SPC_INFO 1555
#define STID_TOOL_CUR_VER_PATCH_INFO       1556
#define STID_TOOL_CUR_VER_PATCH_SPC_INFO   1557
#define STID_CANT_DOWNLOAD_VER_USE_BROWSER 1558
#define STID_FAIL_TO_CONN_TO_HOST_PORT     1559
#define STID_LINES_TOO_LONG_CONTENT_LENGTH 1560
#define STID_FAIL_TO_SEND_REQ              1561
#define STID_INVALID_FORMAT_IN_HEADER      1562
#define STID_CHECK_FONT_FAILED_FOR_BROWSE  1563
#define STID_ERROR_ENCOUNTERED_WHILE_RECV  1564
#define STID_SINGLE_XPM_IMGPROC            1565
#define STID_USER_INTR                     1566
#define STID_CANNOT_IMPORT_XPM_FILE        1567
#define STID_MAY_USED_UP_COLORS_RETRY      1568
#define STID_ENTER_PAIR_COLORS_INTERPOLATE 1569
#define STID_GIVEN_IS_NOT_A_VALID_COLOR    1570
#define STID_ENTER_VAL_MINUS_PLUS_ONE_BW   1571
#define STID_FAIL_TO_PARSE_FOR_A_VAL       1572
#define STID_ENTER_VAL_MINUS_PLUS_ONE_SAT  1573
#define STID_ENTER_VAL_FOR_CHANGE_HUE      1574
#define STID_FAIL_TO_PARSE_FOR_4_VAL       1575
#define STID_ENTER_VAL_FOR_CONTRAST_ENH    1576
#define STID_GIVEN_NEG_VAL_NOT_ALLOWED     1577
#define STID_ENTER_VAL_FOR_COLOR_BAL       1578
#define STID_FAIL_TO_PARSE_FOR_3_VAL       1579
#define STID_ENTER_VAL_FOR_GAMMA           1580
#define STID_SEL_TOO_THIN_FLAT_FOR_EDGE    1581
#define STID_SEL_TOO_THIN_FLAT_FOR_EMBOSS  1582
#define STID_ENTER_NUM_COLORS_TO_REDUCE_TO 1583
#define STID_NUM_COLORS_BETWEEN_2_N_GIVEN  1584
#define STID_SEL_XPM_FILE_FOR_RED_COLORS   1585
#define STID_INVALID_GIVEN_XPM_FILE        1586
#define STID_Q_FS_ERROR_DIFFUSE            1587
#define STID_ENTER_NUM_BITS_IN_RGB         1588
#define STID_RGB_LEVELS_CHANGED_TO         1589
#define STID_BAD_VAL_SUM_RGB_LEVEL         1590
#define STID_BAD_VAL_GT_0_RGB_LEVEL        1591
#define STID_RGB_LEVELS_ARE                1592
#define STID_ENTER_INT_AMT_TO_SPREAD       1593
#define STID_SEL_TOO_THIN_FLAT_FOR_SHARPEN 1594
#define STID_SEL_TOO_THIN_FLAT_FOR_BLUR    1595
#define STID_IMAGE_PROC_CANT_USE_XFORMED   1596
#define STID_SEL_3_XPM_FOR_IMAGEPROC_CMD   1597
#define STID_SEL_2_XPM_FOR_IMAGEPROC_CMD   1598
#define STID_PICK_PT_WITHIN_IMAGE_BOUND    1599

#define STID_IMG_TOO_SMALL_IMAGEPROC_CMD   1600
#define STID_NO_WARPING                    1601
#define STID_START_LINE_SEG_DOTS           1602
#define STID_ENDT_LINE_SEG_DOTS            1603
#define STID_ENTER_IMAGE_SIZE_IN_PIX_RC    1604
#define STID_FAIL_TO_EXECUTE_CMD           1605
#define STID_ENTER_CMD_OP_FOR_BGGEN        1606
#define STID_NEW_XPM_WH_GENERATED          1607
#define STID_ENTER_GRAY_LEVELS_222         1608
#define STID_INVALID_GIVEN_VALUE_ENTERED   1609
#define STID_ENTER_COLOR_FOR_RECT_BGGEN    1610
#define STID_CANNOT_PARSE_NAMED_COLOR      1611
#define STID_XPM_NOT_XFORMED_REGEN_ANYWAY  1612
#define STID_DRAG_A_RECT_TO_CROP           1613
#define STID_START_CROP_IMAGE              1614
#define STID_END_CROP_IMAGE                1615
#define STID_ABORT_CROP_IMAGE              1616
#define STID_SELECT_A_COLOR                1617
#define STID_SEL_A_COLOR_TO_USE_AS_CUR     1618
#define STID_SEL_AREA_NOT_INTERSECT_IMAGE  1619
#define STID_SEL_PT_NOT_ON_IMAGE           1620
#define STID_ONE_PRIM_FOR_IMAGEPROC_CMD    1621
#define STID_DARG_TO_FILL_AN_AREA          1622
#define STID_SEL_A_COLOR_TO_BE_REPLACED    1623
#define STID_SEL_A_COLOR_TO_REPLACE        1624
#define STID_BTN1_FLOODFILL_BTN3_SET_COLOR 1625
#define STID_ESC_TO_FINISH                 1626
#define STID_FLOOD_FILL                    1627
#define STID_SET_A_PIXEL                   1628
#define STID_NO_CONTOUR_CAN_BE_GEN_HERE    1629
#define STID_SEL_A_COLOR_TO_BE_TRACED      1630
#define STID_START_CONTOUR                 1631
#define STID_INVALID_XDEF_RNG_USE_ALT_VAL  1632
#define STID_VAL_TOO_LARGE_IN_XDEF_USE_ALT 1633
#define STID_VAL_TOO_SMALL_IN_XDEF_USE_ALT 1634
#define STID_INVALID_GIVEN_PATH_MUST_FULL  1635
#define STID_CANNOT_SET_LOCALE_ENV_VARS    1636
#define STID_XT_CANNOT_SET_LOCALE_ENV_VARS 1637
#define STID_XLIB_CANT_SET_LOCALE_ENV_VARS 1638
#define STID_CANT_SET_LOCALE_MODIFIERS     1639
#define STID_LOCALE_DIR_NOT_EXIST_USE_XDEF 1640
#define STID_WARN_CANT_PUTENV_GIVEN        1641
#define STID_CANT_OPEN_DISPLAY_ABORT       1642
#define STID_CANT_OPEN_GIVEN_DPY_ABORT     1643
#define STID_CUR_EMPTY_FILE_IS             1644
#define STID_LEFT_STEP_MID_RUN_RIGHT_STOP  1645
#define STID_CANT_FIND_POLY_WITH_GIVEN_ID  1646
#define STID_CANT_FIND_OBJ_WITH_GIVEN_ID   1647
#define STID_CANT_FIND_ATTR_NAME_AND_COLOR 1648
#define STID_BAD_FLTR_SPEC_DEF             1649
#define STID_BAD_FLTR_SPEC_MISS_PERC_S     1650
#define STID_BAD_FLTR_SPEC_MANY_PERC_S     1651
#define STID_BAD_XDEF_MUST_BE_GT_0         1652
#define STID_CANT_FIND_XDEF_CONT_LOOK_FLTR 1653
#define STID_SEL_XBM_FILE_TO_IMPORT        1654
#define STID_CANNOT_IMPORT_XBM_FILE        1655
#define STID_ENTER_GEOM_SPEC_ORIG_SIZE     1656
#define STID_GIVEN_XBM_SIZE_FILE_IMPORTED  1657
#define STID_GIVEN_XPM_SIZE_FILE_IMPORTED  1658
#define STID_SEL_XPM_FILE_TO_IMPORT        1659
#define STID_SEL_EPS_FILE_TO_IMPORT        1660
#define STID_IMPORT_REM_FILE_EMBED_INSTEAD 1661
#define STID_GIVEN_EPS_FILE_IMPORTED       1662
#define STID_SEL_GIF_FILE_TO_IMPORT        1663
#define STID_CANNOT_IMPORT_GIVEN_GIF       1664
#define STID_GIVEN_GIF_SIZE_FILE_IMPORTED  1665
#define STID_CANT_FIND_ANY_IMP_FLTR_SPEC   1666
#define STID_SEL_AN_IMPORT_FILTER          1667
#define STID_SEL_A_TYPE_FILE_TO_IMPORT     1668
#define STID_CANT_IMPORT_GIVEN_TYPE_FILE   1669
#define STID_GIVEN_TYPE_SIZE_FILE_IMPORTED 1670
#define STID_INVALID_FMT_IN_SHORTCUT_SPEC  1671
#define STID_CANT_FIND_NAMED_IMP_FLTR      1672
#define STID_SEL_ANIM_GIF_FILE_TO_IMPORT   1673
#define STID_CANT_EXEC_CMD_IMPORT_ANIM_GIF 1674
#define STID_Q_LIKE_TO_USE_AN_IMP_FLTR_GIF 1675
#define STID_CANT_CREATE_NAMED_TMP_FILE    1676
#define STID_CANT_IMP_ANIM_GIF_TMP_DIR     1677
#define STID_CANT_IMP_GIVEN_ANIM_GIF       1678
#define STID_ONLY_ONE_GIF_COMP_EXTRACTED   1679
#define STID_ANIMATING_GIVEN               1680
#define STID_GIF_ANIMATION_STOPPED         1681
#define STID_PRESS_ESC_TO_STOP             1682
#define STID_BROWSING_DIR_FOR_TYPE_FILES   1683
#define STID_SKIP_GIVEN_FILE_SYM_LINK      1684
#define STID_WORKING_DIR_IS_GIVEN          1685
#define STID_MORE_THAN_ONE_CMAP_INSTALLED  1686
#define STID_FIRST_ONE_ON_LIST_USED        1687
#define STID_SPECIFY_AREA                  1688
#define STID_SPECIFY_DELAY_FULL_SCR_CAP    1689
#define STID_WILL_HIDE_TOOL_WHILE_CAPTURE  1690
#define STID_WILL_SHOW_TOOL_WHILE_CAPTURE  1691
#define STID_FUNC_SELECT_SYS_CALL_FAILED   1692
#define STID_FUNC_INVALID_RC_FOR_SELECT    1693
#define STID_CNTRL_C_ABORT_LAUNCH          1694
#define STID_CMD_ABORT_LAUNCH_CLOSE_TOOL   1695
#define STID_INVALID_GIVEN_ATTR_SPEC       1696
#define STID_LAUNCH_NOT_AUTO_IN_HYPER_EXEC 1697
#define STID_USER_ABORT_LAUNCH_IN_HYPER    1698
#define STID_MALFORMED_CMD_EXEC_ABORT      1699

#define STID_NO_OBJ_SEL_WHILE_EXEC_CMD     1700
#define STID_CANT_FIND_NAMED_ATTR_EXEC     1701
#define STID_FILE_ATTR_NOT_ALLOWED_FOR_CMD 1702
#define STID_CANT_FIND_NAMED_OBJ_EXEC      1703
#define STID_INVALID_ARG_WHILE_EXEC_CMD    1704
#define STID_MODIFY_FILE_ATTR_IN_WB        1705
#define STID_USER_INTR_TOOL_WAIT_CLEANUP   1706
#define STID_FUNC_USER_INTR                1707
#define STID_BAD_EVAL_INT_EXP_EXEC_CMD     1708
#define STID_BAD_EVAL_FLOAT_EXP_EXEC_CMD   1709
#define STID_FAIL_FUNC_CMD_EXEC_ABORT      1710
#define STID_FUNC_ONLY_WORK_COMPOSITE_OBJ  1711
#define STID_FUNC_FAIL_TO_IMPORT_GIVEN     1712
#define STID_FUNC_OBJ_NON_XBM_XPM_SUB_OBJS 1713
#define STID_WILL_EXPORT_PNG_FILE          1714
#define STID_CANNOT_IMPORT_GIVEN_PNG       1715
#define STID_GIVEN_PNG_SIZE_FILE_IMPORTED  1716
#define STID_SEL_PNG_FILE_TO_IMPORT        1717
#define STID_FUNC_DIFF_SZ_XBM_XPM_SUBOBJS  1718
#define STID_FUNC_MORE_1_XBM_XPM_SUBOBJS   1719
#define STID_FUNC_ARG_RANGE                1720
#define STID_FUNC_UNDEFINED_ARG            1721
#define STID_INTERNAL_CMD_SELECT_FAILED    1722
#define STID_CANT_OPEN_FILE_READ_EXEC_CMD  1723
#define STID_FAIL_TO_EXECUTE_CMD_EXEC_CMD  1724
#define STID_UNEXP_ERR_EXEC_CMD_ABORT      1725
#define STID_BAD_NAME_TOP_LEVEL_ONLY_CMD   1726
#define STID_BAD_CURSOR_WHILE_EXEC_CMD     1727
#define STID_BAD_COLOR_NAME_WHILE_EXEC_CMD 1728
#define STID_WIDTH_RANGE_WHILE_EXEC_CMD    1729
#define STID_SPLINE_TYPE_WHILE_EXEC_CMD    1730
#define STID_ARROW_STYLE_WHILE_EXEC_CMD    1731
#define STID_DASH_INDEX_WHILE_EXEC_CMD     1732
#define STID_RCB_RAD_RANGE_WHILE_EXEC_CMD  1733
#define STID_BAD_TEXT_JUST_WHILE_EXEC_CMD  1734
#define STID_BAD_FONT_NAME_WHILE_EXEC_CMD  1735
#define STID_UNDO_BUF_FLUSHED_BY_CMD       1736
#define STID_BAD_EVAL_NUM_EXP_EXEC_CMD     1737
#define STID_WRITE_CUT_BUF_WHILE_EXEC_CMD  1738
#define STID_CANT_FIND_DOT_WHILE_EXEC_CMD  1739
#define STID_BAD_WIDTH_WHILE_EXEC_CMD      1740
#define STID_BAD_HEIGHT_WHILE_EXEC_CMD     1741
#define STID_BAD_STYLE_WHILE_EXEC_CMD      1742
#define STID_TOO_MANY_OBJ_WHILE_EXEC_CMD   1743
#define STID_BAD_ATTR_NAME_WHILE_EXEC_CMD  1744
#define STID_END_AN_EDGE_AT_A_PORT         1745
#define STID_DRAW_AN_EDGE_BETWEEN_PORTS    1746
#define STID_CANT_FIND_VRTX_WHILE_EXEC_CMD 1747
#define STID_POLY_NOR_PGON_WHILE_EXEC_CMD  1748
#define STID_BAD_REM_FNAME_WHILE_EXEC_CMD  1749
#define STID_CANT_OPEN_FILE_WRITE_EXEC_CMD 1750
#define STID_GIVEN_CMD_EXECUTED            1751
#define STID_SQRT_NEG_NUM_WHILE_EXEC_CMD   1752
#define STID_CMD_NOT_AVAIL_ON_PLATFORM     1753
#define STID_BAD_SHORTCUT_WHILE_EXEC_CMD   1754
#define STID_STAT_FAILED_WHILE_EXEC_CMD    1755
#define STID_NON_GROUPED_WHILE_EXEC_CMD    1756
#define STID_BAD_SEP_LONG_WHILE_EXEC_CMD   1757
#define STID_BAD_SEP_WHILE_EXEC_CMD        1758
#define STID_MORE_THAN_ONE_WHILE_EXEC_CMD  1759
#define STID_MUST_FULL_PATH_WHILE_EXEC_CMD 1760
#define STID_OBJ_ALRDY_SEL_WHILE_EXEC_CMD  1761
#define STID_INVALID_FNAME_WHILE_EXEC_CMD  1762
#define STID_INVALID_FMODE_WHILE_EXEC_CMD  1763
#define STID_INVALID_FNUM_WHILE_EXEC_CMD   1764
#define STID_FNUM_ARDY_OPEN_WHILE_EXEC_CMD 1765
#define STID_CANT_OPEN_FMOD_WRITE_EXEC_CMD 1766
#define STID_FNUM_NOT_OPEN_WHILE_EXEC_CMD  1767
#define STID_EOF_FOR_FNUM_WHILE_EXEC_CMD   1768
#define STID_WRI_FNUM_FAIL_WHILE_EXEC_CMD  1769
#define STID_WRI_FNN_FAIL_WHILE_EXEC_CMD   1770
#define STID_INVALID_PATH_WHILE_EXEC_CMD   1771
#define STID_APPEND_FAILED_WHILE_EXEC_CMD  1772
#define STID_COPY_FAILED_WHILE_EXEC_CMD    1773
#define STID_INVALID_FORMAT_WHILE_EXEC_CMD 1774
#define STID_INVALID_REC_WHILE_EXEC_CMD    1775
#define STID_CONVERT_FORMAT_WHILE_EXEC_CMD 1776
#define STID_IMPORT_FAILED_WHILE_EXEC_CMD  1777
#define STID_BAD_VER_NUM_WHILE_EXEC_CMD    1778
#define STID_EMPTY_INI_SEC_WHILE_EXEC_CMD  1779
#define STID_BAD_LINENUM_WHILE_EXEC_CMD    1780
#define STID_BAD_SMALL_LNUM_WHILE_EXEC_CMD 1781
#define STID_BAD_EMPTY_STR_WHILE_EXEC_CMD  1782
#define STID_BAD_DIRECTION_WHILE_EXEC_CMD  1783
#define STID_NO_START_VRTX_WHILE_EXEC_CMD  1784
#define STID_TOO_FEW_VRTX_WHILE_EXEC_CMD   1785
#define STID_NO_START_OBJ_WHILE_EXEC_CMD   1786
#define STID_CANT_FIND_MARK_WHILE_EXEC_CMD 1787
#define STID_NO_OBJ_GROUP_WHILE_EXEC_CMD   1788
#define STID_CANT_GRP_SNGL_WHILE_EXEC_CMD  1789
#define STID_UNRECOG_CMD_MAY_BE_BLANKS_ABT 1790
#define STID_UNRECOG_CMD_DOWNLOAD_TOOL     1791
#define STID_UNRECOG_CMD_ABORT             1792
#define STID_TOOL_NOT_DONE_WITH_PREV_FUNC  1793
#define STID_ENTER_INTERN_CMD_FILE_NAME    1794
#define STID_FINISH_EXEC_CMD_FROM_STDIN    1795
#define STID_FATAL_ERROR_IN_FUNC_PLUS_DESC 1796
#define STID_TOOL_ABORTED                  1797
#define STID_ICON_FILEVER_TOO_LARGE        1798
#define STID_UNEQUAL_DEPTHS_IN_FUNC        1799

#define STID_BASELINE_YS_NOT_EQ_IN_FUNC    1800
#define STID_LOCKED_OBJS_CANT_BE_MOVED     1801
#define STID_HINT_CTL_MOVE_ATTR_ONLY       1802
#define STID_OUT_OF_VMEM_CANNOT_MALLOC     1803
#define STID_CANT_ALLOC_BITMAP_OF_SIZE     1804
#define STID_FAIL_TO_WRITE_TO_FILE         1805
#define STID_SAFEST_SAVE_N_EXIT_REPRODUCE  1806
#define STID_FATAL_UNEXPECTED_ERROR        1807
#define STID_ENTER_FNAME_TO_WRITE_MSG_BUF  1808
#define STID_STDOUT_STDERR_ESC_CANCEL      1809
#define STID_MSG_BUF_SAVED_INTO_GIVEN      1810
#define STID_FILE_LINE_MISS_FIELD_IN_OBJ   1811
#define STID_FILE_LINE_BAD_FIELD_IN_OBJ    1812
#define STID_NAMED_SIG_RECV                1813
#define STID_ERR_COUNT_EXCEED_TOOL_ABORTED 1814
#define STID_WORKING_FILE_SAVED_TO         1815
#define STID_UNABLE_TO_SAVE_WORKING_FILE   1816
#define STID_X_ERROR_MSG                   1817
#define STID_BAD_COMPILE_OPT_USE_ALT_STR   1818
#define STID_MISSING_DISPLAY_NAME          1819
#define STID_MISSING_PAGE_NUMBER           1820
#define STID_INVALID_GIVEN_PAGE_NUMBER_STR 1821
#define STID_MISSING_ARG_FOR_CMDLINE_OPT   1822
#define STID_INVALID_ARG_FOR_CMDLINE_OPT   1823
#define STID_TGIF_PATH_SHOULD_NOT_BE_USED  1824
#define STID_PRINT_TO_PRINTER_INCOMPAT     1825
#define STID_BAD_EXEC_FNAME_DASH           1826
#define STID_CANNOT_OPEN_DIR_FOR_READING   1827
#define STID_FAIL_TO_STAT_GIVEN_FILE       1828
#define STID_SET_WORKING_DIR               1829
#define STID_CLICK_SETWORKDIR_TO_SET_DIR   1830
#define STID_SETWORKDIR_NOT_SUP_FOR_STR    1831
#define STID_OPENSAVE_DIR_CHANGE_TO_REMAIN 1832
#define STID_IMPORT_DIR_CHANGED_TO_REMAIN  1833
#define STID_GEN_LIST_OF_DOMAIN_NAMES_WAIT 1834
#define STID_CANT_GEN_DOM_NAMES_INI_ENTRY  1835
#define STID_CANT_GEN_DOM_NAMES_XDEF       1836
#define STID_CANT_GET_LIST_OF_DOM_NAMES    1837
#define STID_PLEASE_SELECT_A_NEW_DOMAIN    1838
#define STID_CURRENT_DOMAIN_IS             1839
#define STID_SYMBOL_PATH_SET_TO            1840
#define STID_PLS_SEL_A_DIR_IN_GIVEN_DOMAIN 1841
#define STID_GEN_LIST_XBM_NAMES_WAIT       1842
#define STID_GEN_LIST_XPM_NAMES_WAIT       1843
#define STID_GEN_LIST_OBJ_NAMES_WAIT       1844
#define STID_GEN_LIST_SYM_NAMES_WAIT       1845
#define STID_GEN_LIST_TYPE_FILE_NAMES_WAIT 1846
#define STID_NO_GIVEN_TYPE_FILE_FOUND      1847
#define STID_NO_DIR_SEP_IN_FUNC_WORK_DIR   1848
#define STID_NO_DIR_SEP_IN_FUNC_SYM_DIR    1849
#define STID_NO_DIR_SEP_IN_FUNC_IMPORT_DIR 1850
#define STID_EMPTY_PATH_DISALLOW_FOR_DOM   1851
#define STID_TOOL_EDIT_DOM_PATHS           1852
#define STID_EDIT_DOMAIN_PATHS_DOTS        1853
#define STID_TOOL_SEL_DEFAULT_DOMAIN       1854
#define STID_SEL_DEFAULT_DOMAIN_DOTS       1855
#define STID_PLS_SPEC_A_NEW_DOMAIN_NAME    1856
#define STID_GIVEN_DOMAIN_ALREADY_EXISTS   1857
#define STID_GIVEN_DOM_ADDED_PATH_SET_TO   1858
#define STID_SEL_DOMAIN_TO_DELETE_DOTS     1859
#define STID_OK_TO_DELETE_NAMED_DOMAIN_YNC 1860
#define STID_OK_TO_RELOAD_DOM_INFO_FROM_X  1861
#define STID_ERR_IN_PARSE_STR_FOR_2_VAL    1862
#define STID_FILE_MOD_SAVE_BEFORE_BACK     1863
#define STID_NOTHING_TO_GO_BACK_TO         1864
#define STID_FILE_MOD_SAVE_BEFORE_FORWARD  1865
#define STID_NOTHING_TO_GO_FORWARD_TO      1866
#define STID_FAIL_TO_FIND_RECORD_IN_FUNC   1867
#define STID_FURTHER_NAVIGATE_MAY_CRASH    1868
#define STID_CANT_REFRESH_UNDEFINED_FILE   1869
#define STID_FILE_MOD_SAVE_BEFORE_RELOAD   1870
#define STID_HOT_LIST_FILE_UNDEF_PLS_SPEC  1871
#define STID_MALFORMED_NAMED_HOT_LIST_FILE 1872
#define STID_HOT_LIST_FILE_IS_EMPTY        1873
#define STID_Q_DEL_NAMED_FROM_HOT_LIST     1874
#define STID_FILE_MOD_SAVE_BEFORE_OPEN_ANO 1875
#define STID_SESSION_HIST_NOT_ESTABLISHED  1876
#define STID_TOOL_HOT_LIST                 1877
#define STID_TOOL_HISTORY                  1878
#define STID_HOT_LIST_DOTS                 1879
#define STID_CANT_ADD_UNDEF_TO_HOT_LIST    1880
#define STID_HOT_LIST_FILE_UPDATED         1881
#define STID_SESSION_HISTORY_DOTS          1882
#define STID_ENTER_HYPERSPACE_DOTS         1883
#define STID_LEAVING_HYPERSPACE_DOTS       1884
#define STID_CANT_SLIDESHOW_IN_TILED_PAGE  1885
#define STID_FILE_MOD_SAVE_BEFORE_SLIDE    1886
#define STID_PAGE_NUM_MOD_IN_SLIDE_NOT_SAV 1887
#define STID_Q_PAGE_NUM_MOD_IN_SLIDE_YNC   1888
#define STID_ENTERING_SLIDESHOW_DOTS       1889
#define STID_LEAVING_SLIDESHOW_DOTS        1890
#define STID_ENTER_A_COLOR_FOR_SLIDE_BRDR  1891
#define STID_PRESS_ENTER_FOR_DEF_COLOR     1892
#define STID_SLIDE_WILL_USE_DEF_BRDR_COLOR 1893
#define STID_SLIDE_BRDR_COLOR_SET_TO_NAMED 1894
#define STID_ENTER_XY_OFFSET_FOR_SLIDE_WIN 1895
#define STID_SLIDE_WIN_XY_OFFSETS_SET_TO   1896
#define STID_GRID_BE_VISIBLE_IN_SLIDE      1897
#define STID_GRID_NOT_BE_VISIBLE_IN_SLIDE  1898
#define STID_CANT_DO_NEXTPAGE_IN_TILED     1899

#define STID_ALREADY_AT_LAST_PAGE          1900
#define STID_CANT_DO_PREVPAGE_IN_TILED     1901
#define STID_ALREADY_AT_FIRST_PAGE         1902
#define STID_TOOL_NAME_PAGES               1903
#define STID_TOOL_GOTO_PAGE                1904
#define STID_CANT_DO_GOTOPAGE_IN_TILED     1905
#define STID_GOTO_PAGE_DOTS                1906
#define STID_NO_PAGE_SELECTED              1907
#define STID_INVALID_GIVEN_PAGE_NUMBER     1908
#define STID_ALREADY_AT_GIVEN_PAGE         1909
#define STID_CUR_PAGE_IS_GIVEN_PAGE_NUM    1910
#define STID_CANT_DO_NAMEPAGES_IN_TILED    1911
#define STID_EDIT_PAGE_NAMES_DOTS          1912
#define STID_CANT_EDITPAGEFNAME_IN_TILED   1913
#define STID_EDIT_PAGE_FILE_NAMES_DOTS     1914
#define STID_PAGE_FNAME_NO_SPACE_TRUNC     1915
#define STID_OK_TO_FLUSH_UNDO_AND_PROCEED  1916
#define STID_ADD_PAGE_BEFORE_GIVEN_FLUSH   1917
#define STID_ADD_PAGE_AFTER_GIVEN_FLUSH    1918
#define STID_DELETE_GIVEN_PAGE_CAUSE_FLUSH 1919
#define STID_DELETE_A_PAGE_CAUSE_FLUSH     1920
#define STID_DELETE_PAGES_PAGE_CAUSE_FLUSH 1921
#define STID_CHNG_PAGE_LAYOUT_FLUSH        1922
#define STID_SET_PAPER_COLOR_CAUSE_FLUSH   1923
#define STID_CANT_DO_ADDPAGE_IN_TILED      1924
#define STID_CANT_DO_DELETEPAGE_IN_TILED   1925
#define STID_CANT_DEL_ONLY_PAGE_IN_TILED   1926
#define STID_CANT_DO_SPECDRAWSIZE_IN_TILED 1927
#define STID_CANT_DO_DELETEPAGES_IN_TILED  1928
#define STID_CANT_DO_POFPP_IN_TILED        1929
#define STID_CANT_DO_POFPP_TO_PRINTER      1930
#define STID_NAMED_TEMPLATE_LOADED         1931
#define STID_PROB_LOADING_NAMED_TEMPLATE   1932
#define STID_GIVEN_PAGE_NUM_ADDED          1933
#define STID_ADDPAGEBEFORE_IN_WB           1934
#define STID_ADDPAGEAFTER_IN_WB            1935
#define STID_GIVEN_PAGE_NUM_DELETED        1936
#define STID_CANT_TPLS_IN_STACKED          1937
#define STID_ENTER_DRAW_SIZE_SPEC_WH       1938
#define STID_BAD_DRAW_SIZE_SPEC_WH         1939
#define STID_BAD_DRAW_SIZE_SPEC_W_TIMES_H  1940
#define STID_INVALID_DRAW_SIZE_SPEC        1941
#define STID_CANT_PRINTONEPAGE_IN_FORMAT   1942
#define STID_BTN1_SEL_PAGE_TO_PRINT        1943
#define STID_OTHER_BTN_CANCEL_PRINTONEPAGE 1944
#define STID_SELECT_A_PAGE_TO_PRINT        1945
#define STID_OPERATION_CANCEL_BY_USER      1946
#define STID_MUST_SEL_A_PT_ON_THE_PAPER    1947
#define STID_MUST_SEL_A_PT_IN_TOOL_WIN     1948
#define STID_NEW_PAPER_SIZE_IS_GIVEN       1949
#define STID_INVALID_GIVEN_PAPER_SIZE_SPEC 1950
#define STID_CUR_PAPER_SIZE_IS_GIVEN       1951
#define STID_ENTER_PAPER_SIZE_WH           1952
#define STID_CANT_DEL_ONLY_PAGE_IN_STACKED 1953
#define STID_SPECIFY_PAGES_TO_DEL_EX       1954
#define STID_GIVEN_PAGE_NUM_IS_OUT_OF_RNG  1955
#define STID_MALFORMED_SPECIFICATION_STR   1956
#define STID_CANT_DEL_ALL_PAGES            1957
#define STID_ONE_PAGE_DELETED              1958
#define STID_MANY_PAGES_DELETED            1959
#define STID_OBJ_OUTSIDE_PAGE_BNRDY_SWITCH 1960
#define STID_SWTCH_TO_TILED_LOSE_ALL_NAMES 1961
#define STID_CHANGE_PAGE_LAYOUT_MODE_IN_WB 1962
#define STID_PAGE_LAYOUT_MODE_IS_STACKED   1963
#define STID_PAGE_LAYOUT_MODE_IS_TILED     1964
#define STID_SPECIFY_A_PAPER_COLOR         1965
#define STID_SPECIFY_A_PAPER_COLOR_CUR_IS  1966
#define STID_ENTER_NONE_TO_REMOVE_COLOR    1967
#define STID_PAPER_COLOR_REMOVED           1968
#define STID_PAPER_COLOR_SET_TO_GIVEN      1969
#define STID_GRAY_SCALE_USED_IN_PRINT_PAT  1970
#define STID_NOTE_SLOW_PRINT_DUE_USE_PAT   1971
#define STID_SUGGEST_USEGRAYSCALE_TO_SPEED 1972
#define STID_FILL_PEN_PAT_OPAQUE           1973
#define STID_FILL_PEN_PAT_TRANSPARENT      1974
#define STID_LINE_WIDTH_SET_TO_GIVEN_STR   1975
#define STID_ENTER_LINE_WIDTH_OPT_AW_AH    1976
#define STID_INVALID_GIVEN_STR_WIDTH       1977
#define STID_INVALID_GIVEN_STR_AW_AH       1978
#define STID_NO_PINS_FOUND_IN_CUR_DRAWING  1979
#define STID_INPUT_PAIRS_OF_POINTS_POLY    1980
#define STID_READ_INT_ERROR_FOR_POLY_PTS   1981
#define STID_TOO_FEW_POINTERS_ENTERED      1982
#define STID_TOO_FEW_VER_TO_CLOSE_POLY     1983
#define STID_HUH_WHERE_ARE_THE_VERTICES    1984
#define STID_HUH_TOPVSEL_NE_BOTVSEL        1985
#define STID_CMD_ONLY_AVAIL_IN_VERSEL_MODE 1986
#define STID_SEL_2_ENDPOINT_VER_TO_JOIN    1987
#define STID_SEL_VER_FROM_POLY_OPEN_ONLY   1988
#define STID_SEL_2_POLYLINES_OPEN_SPLINES  1989
#define STID_CANT_JOIN_INTSPLINE_W_NONEINT 1990
#define STID_SEL_1_VERTEX_TO_CUT           1991
#define STID_SEL_A_VERTEX_FROM_POLY_OR_GON 1992
#define STID_INVALID_SMOOTHHINGE_SPEC_POLY 1993
#define STID_INVALID_NUM_PTS_IN_POLY       1994
#define STID_INPUT_PAIRS_OF_POINTS_POLYGON 1995
#define STID_READ_INT_ERR_FOR_POLYGON_PTS  1996
#define STID_INVALID_NUM_PTS_IN_POLYGON    1997
#define STID_CANT_GET_XDEF_DEF_WIDTHS_USED 1998
#define STID_ERR_SETCTM_CALLED_CTM_NONNULL 1999

#define STID_MEASUREMENT_SHOWN_IN_UNIT     2000
#define STID_BAD_MEASUREMENT_UNIT_SPEC     2001
#define STID_SHOW_CROSSHAIR_ENABLED        2002
#define STID_SHOW_CROSSHAIR_DISABLED       2003
#define STID_SHOW_MEASUREMENT_ENABLED      2004
#define STID_SHOW_MEASUREMENT_DISABLED     2005
#define STID_CANNOT_EXECUTE_GIVEN_CMD      2006
#define STID_CONNECTION_INTERRUPTED        2007
#define STID_CANT_CONN_TO_HOST_PORT        2008
#define STID_FAIL_TO_GET_DATA_FROM_URL     2009
#define STID_NETWORK_ERR_TALK_TO_HOST_PORT 2010
#define STID_FAILED_TO_LOGIN_TO_HOST_PORT  2011
#define STID_CANT_FIND_LOCATION_IN_HDR     2012
#define STID_LNK_FWD_5_TIMES_LOAD_ABORT    2013
#define STID_CANT_FIND_WWW_AUTHEN_IN_HDR   2014
#define STID_AUTHEN_REQ_FOR_REALM          2015
#define STID_ENTER_USERNAME_FOR_REALM      2016
#define STID_ENTER_PASSWORD_FOR_REALM      2017
#define STID_FAIL_TO_PARSE_GIVEN_URL       2018
#define STID_TOOL_NOT_KNOW_HOW_TALK_PROTO  2019
#define STID_LAUNCH_GIVEN_VIEWER           2020
#define STID_CANT_OPEN_GIVEN_MAILCAP_FILE  2021
#define STID_MALFORMED_MAILCAP_ENTRY       2022
#define STID_MALFORMED_MAILCAP_ENTRY_PARAM 2023
#define STID_TOOL_CANT_HANDLE_MP_MIME      2024
#define STID_CANT_FIND_RT_BRACK_MC         2025
#define STID_CANT_FIND_RT_BRACK_MC_PARAM   2026
#define STID_CANT_FIND_NAMED_INFO_IN_CT    2027
#define STID_SAVE_GIVEN_STR_AS             2028
#define STID_NO_VIEWER_SAVE_GIVEN_STR_AS   2029
#define STID_UNKNOWN_ERR_IN_COPYING_FILES  2030
#define STID_CANT_GETHOSTNAME_USE_LOCALH   2031
#define STID_TURN_OFF_AUTO_PAN_SET_XDEF    2032
#define STID_WILL_UPD_WIN_SMOOTH_SCROLL    2033
#define STID_WILL_UPD_WIN_JUMP_SCROLL      2034
#define STID_WILL_NOT_UPD_WIN_SCROLL       2035
#define STID_INCONSIS_VERTEX_SEL_IN_FUNC   2036
#define STID_INVALID_NAMED_TELEPORT_DEST   2037
#define STID_Q_FILE_NOT_EXIST_CREATE       2038
#define STID_CANT_FIND_PAGE_NAMED_TO_TEL   2039
#define STID_CANT_FIND_PAGE_NUM_TO_TEL     2040
#define STID_CANT_GROUP_IN_VERTEX_MODE     2041
#define STID_CANT_GROUP_SINGLE_OBJECT      2042
#define STID_INVALID_XDEF_USE_ALT_OCTVALUE 2043
#define STID_INVALID_XDEF_RNG_USE_ALT_STR  2044
#define STID_CANT_CREATE_NAMED_DIRECTORY   2045
#define STID_OPR_USING_NAMED_DIR_WILL_FAIL 2046
#define STID_CREATE_A_SHAPE_FAILED         2047
#define STID_CREATE_SHADOW_SHAPE_NO_FILL   2048
#define STID_CREATE_SHADOW_SHAPE_TRAN_FILL 2049
#define STID_ENTER_XY_OFFSET_FOR_SHP_SHDW  2050
#define STID_SHAPE_SHDW_XY_OFFSETS_SET_TO  2051
#define STID_INVALID_SHORTCUT_ENTRY_SKIP   2052
#define STID_DUP_SHORTCUT_ENTRY_FOR_CHAR   2053
#define STID_INVALID_SHORTCUT_ENTRY        2054
#define STID_WARN_DUP_CMDID                2055
#define STID_PUSH_IN_WB                    2056
#define STID_FILE_VER_ABORT_READ_SYMBOL    2057
#define STID_CANT_FIND_NAMED_OBJ_IN_FUNC   2058
#define STID_SEL_A_SYM_TO_INSTAN_IN_DOMAIN 2059
#define STID_CANT_INSTAN_FILE_UNKNOWN_EXT  2060
#define STID_CANT_MAKESYMBOLIC_VERTEX_MODE 2061
#define STID_SEL_ONLY_ONE_FOR_MAKESYMBOLIC 2062
#define STID_PIN_CANT_MADE_INTO_SYMBOL     2063
#define STID_SEL_OBJ_IS_NOW_SYMBOLIC       2064
#define STID_ENTER_NAME_FOR_THE_ICON       2065
#define STID_NAME_NOT_SPEC_ICON_NOT_CREATE 2066
#define STID_CANT_SAVE_OBJ_ICON_NOT_CREATE 2067
#define STID_CANT_FIND_DOT_IN_ICON_NAME_MI 2068
#define STID_CANT_SAVE_PIN_ICON_NOT_CREATE 2069
#define STID_CANT_OPEN_FOR_WRITE_ICON_CRET 2070
#define STID_SEL_OBJ_IS_NOW_ICONIC         2071
#define STID_SEL_ONLY_ONE_FOR_MAKEICONIC   2072
#define STID_SEL_OBJS_ARE_NOW_GROUP        2073
#define STID_GIVEN_LINE_SKIP_NOT_AN_ATTR   2074
#define STID_GIVEN_LINE_SKIP_ILLEGAL_CHAR  2075
#define STID_SEL_ONE_OBJ_FOR_IMPORTATTRS   2076
#define STID_SEL_TEXT_FILE_OF_ATTR_TO_IMP  2077
#define STID_CANT_IMPORT_REMOTE_TEXT_FILE  2078
#define STID_SEL_ONE_OBJ_FOR_EXPORTATTRS   2079
#define STID_SEL_OBJ_HAS_NO_ATTR_TO_EXPORT 2080
#define STID_ENTER_TXT_FILE_TO_EXPORT_CRES 2081
#define STID_ATTR_EXPORTED_TO_NAMED_FILE   2082
#define STID_CANT_FIND_ATTR_FOR_MERGEWTBL  2083
#define STID_MALFORMED_ATTR_FOR_MERGEWTBL  2084
#define STID_SEL_ONE_OBJ_FOR_MERGEWTBL     2085
#define STID_FILE_MOD_SAVE_BEFORE_MERGE    2086
#define STID_Q_MERGEWTBL_CANT_UNDO_PROCEED 2087
#define STID_SEL_TEXT_FILE_FOR_MERGEWTBL   2088
#define STID_CANT_MERGE_W_REMOTE_TEXT_FILE 2089
#define STID_FIND_COL_NAMES_IN_FILE_ABORT  2090
#define STID_MALFORMED_COL_NAMES_ABORT_MRG 2091
#define STID_LF_BTN_PLACE_MRG_OTHER_CANCEL 2092
#define STID_MALFORMED_TBL_LINE_ABORT_MRG  2093
#define STID_CANT_FND_NAMED_ATTR_ABORT_MRG 2094
#define STID_NUM_OBJECTS_GENERATED         2095
#define STID_CANT_FND_TABLE_ATTRS_FILE_ATT 2096
#define STID_NUM_OBJECTS_EXPORTED          2097
#define STID_ATTRS_EXPORTED_TO_TBL_FILE    2098
#define STID_SEL_ONE_ICON_OBJ_TO_PUSH      2099

#define STID_CANT_FND_SYM_FILE_IN_PATH     2100
#define STID_CANNOT_OPEN_FOR_READ_PUSH     2101
#define STID_FILE_VER_ABORT_PUSH           2102
#define STID_POP_BACK_TO_PARENT_UNDEF      2103
#define STID_ALREADY_AT_TOP_LEVEL          2104
#define STID_FILE_MOD_SAVE_BEFORE_POP      2105
#define STID_CANT_FND_SYM_IN_NAMED_TO_INST 2106
#define STID_CANT_FIND_XDEF                2107
#define STID_ENTER_USERAGENT_FOR_HTTP      2108
#define STID_ENTER_USERAGENT_FOR_HTTP_CUR  2109
#define STID_PRESS_ENTER_FOR_DEF_USERAGENT 2110
#define STID_WILL_USE_DEF_USERAGENT_HTTP   2111
#define STID_WILL_USE_NAMED_USERAGENT_HTTP 2112
#define STID_ENTER_REFERRER_FOR_HTTP       2113
#define STID_ENTER_REFERRER_FOR_HTTP_CUR   2114
#define STID_PRESS_ENTER_FOR_NO_REFERRER   2115
#define STID_WILL_NOT_USE_REFERRER_HTTP    2116
#define STID_WILL_USE_NAMED_REFERRER_HTTP  2117
#define STID_WILL_USE_KEEP_ALIVE_HTTP      2118
#define STID_NOT_WILL_USE_KEEP_ALIVE_HTTP  2119
#define STID_CANT_LOCATE_NAMED_SERVER_TRY  2120
#define STID_FAIL_TO_MAKE_SOCKET_BLOCK     2121
#define STID_FAIL_TO_MAKE_SOCKET_NON_BLOCK 2122
#define STID_BROKEN_PIPE_CONTACT_HOST      2123
#define STID_WRITE_TO_SOCKET_FAILED        2124
#define STID_READ_FROM_SOCKET_FAILED       2125
#define STID_UNEXP_NETWORK_ERR_WRITE_SOCK  2126
#define STID_UNEXP_NETWORK_ERR_READ_SOCK   2127
#define STID_LOCKED_OBJS_CANT_BE_STRETCHED 2128
#define STID_CANT_STRETCH_OBJ_HAS_0_WIDTH  2129
#define STID_CANT_STRETCH_OBJ_HAS_0_HEIGHT 2130
#define STID_LOCKED_OBJS_CANT_BE_SCALED    2131
#define STID_ENTER_SCALING_FACTORS_XY      2132
#define STID_ENTER_A_SCALING_FACTOR        2133
#define STID_ONLY_INPUT_ONE_NUMERIC_VAL    2134
#define STID_SCALING_EVERYTHING_LARGE_SURE 2135
#define STID_DISABLE_ON_RESIZE_ROTATE      2136
#define STID_DISABLE_ON_RESIZE_SHEAR       2137
#define STID_DISABLE_ON_RESIZE_TRANSFORM   2138
#define STID_LOCKED_OBJS_CANT_BE_FLIPPED   2139
#define STID_LOCKED_OBJS_ARE_NOT_FLIPPED   2140
#define STID_LOCKED_OBJS_ARE_NOT_STRETCHED 2141
#define STID_LOCKED_OBJS_ARE_NOT_ROTATED   2142
#define STID_LOCKED_OBJS_ARE_NOT_SHEARED   2143
#define STID_LOCKED_OBJS_ARE_NOT_XFORMED   2144
#define STID_FLIPPED_HORIZONTALLY          2145
#define STID_FLIPPED_VERTICALLY            2146
#define STID_LOCKED_OBJS_CANT_BE_ROTATED   2147
#define STID_ROTATED_CLOCKWISE             2148
#define STID_ROTATED_COUNTER_CLOCKWISE     2149
#define STID_ENTER_TEXT_ROT_IN_DEGREE_CUR  2150
#define STID_CANT_PARSE_ENTER_ONE_NUM_VAL  2151
#define STID_INVALID_VAL_ENTERED_RNG_INC   2152
#define STID_TEXT_ROTATION_SET_TO_GIVEN    2153
#define STID_ENTER_ROT_INC_IN_DEGREE_CUR   2154
#define STID_INVALID_VAL_ENTERED_RNG_EXC   2155
#define STID_TEXT_ROT_INC_SET_TO_GIVEN     2156
#define STID_LOCKED_OBJS_CANT_BE_XFORMED   2157
#define STID_SEL_OBJ_TOO_SMALL_ROT_ANOTHER 2158
#define STID_SEL_OBJ_TOO_SMALL_SHEAR_ANO   2159
#define STID_CANNOT_CREATE_GC              2160
#define STID_READ_ONLY_TEXT_CANT_BE_EDITED 2161
#define STID_TEXT_SZ_NOT_AVAIL_TRY_DIFF    2162
#define STID_CANT_INS_NON_DB_CH_AT_CUR_REM 2163
#define STID_TOO_MANY_BYTES_IN_CH_IGNORED  2164
#define STID_CANT_TAB_OUT_OF_NON_ATTR_TEXT 2165
#define STID_COMPOUND_TEXT_BUF_IS_EMPTY    2166
#define STID_CUT_BUFFER_IS_EMPTY           2167
#define STID_AN_ESC_KEY_PRESS_IGNORED      2168
#define STID_GIVEN_NUM_LINES_PASTED        2169
#define STID_COPY_FAIL_SEL_STR_MAY_TOO_LNG 2170
#define STID_UNEXPECTED_TOK_IN_ABORT_READ  2171
#define STID_ILLEGAL_FIELD_IN_ABORT_READ   2172
#define STID_INVALID_GIVEN_VALUE_SPECIFIED 2173
#define STID_ENTER_SCRIPT_FRACTION_CUR_IS  2174
#define STID_SCRIPT_FRACTION_SET_TO_STR    2175
#define STID_ENTER_INT_WIDTH_FOR_THIN_SPC  2176
#define STID_ENTER_INT_VAL_FOR_VERT_OFFSET 2177
#define STID_FAIL_INSERT_SCRIPT_FONT_SZ    2178
#define STID_TOOL_DONT_KNOW_HOW_RUN_GUNZIP 2179
#define STID_SPECIFY_DISPLAY_ON_CMD_LINE   2180
#define STID_FILE_VER_ABORT_TOOL           2181
#define STID_FILE_SKIP_CONTAINS_ONE_PAGE   2182
#define STID_FILE_SKIP_CONTAINS_NUM_PAGE   2183
#define STID_FILE_NOT_CONTAIN_COLOR_ABORT  2184
#define STID_SPEC_FILE_WHEN_STDOUT_USED    2185
#define STID_TOOL_FILE_NAME_TO_PRINT       2186
#define STID_CANT_ONEFPPAGE_IN_TILED_PAGE  2187
#define STID_ONE_FILE_ONLY_WITH_STDOUT     2188
#define STID_ONE_FILE_ONLY_RAW_PLUS_H      2189
#define STID_ONE_FILE_ONLY_DOSEPSFILTER    2190
#define STID_CANT_PRTGIF_OFPP_TILED_PAGE   2191
#define STID_INVALID_SHARELIB_VER_IN_FILE  2192
#define STID_FAIL_LOAD_SHARELIB            2193
#define STID_FAIL_GET_ENTRY_PT_IN_SHARELIB 2194
#define STID_SHARELIB_TGEF_MSG_INIT_FAIL   2195
#define STID_SHARELIB_CNFLCT_PROTOCOL_VER  2196
#define STID_SHARELIB_TGEF_MSG_LOAD_FAIL   2197
#define STID_SHARELIB_TGEF_MSG_NO_BMP_INFO 2198
#define STID_ALLOC_BMP_FAIL_FOR_SHARELIB   2199

#define STID_UNSUP_PROTOCOL_VER_SHARELIB   2200
#define STID_SHARELIB_TGEF_MSG_DO_EXPORT_F 2201
#define STID_NEG_VAL_IN_EXP_PXL_TRM_ALT    2202
#define STID_EXP_PXL_TRM_VAL_SET_TO        2203
#define STID_SPECIFY_TO_TRIM_EXP_PXL_TRM   2204
#define STID_ENTER_4_NUM_CUR_TOO_LARGE     2205
#define STID_ENTER_4_NUM_OR_CR_ESC         2206
#define STID_OBSOLETE_XDEF_USE_IGNORED     2207
#define STID_WILL_USE_FS_HALFTONE_BMP      2208
#define STID_WILL_NOT_USE_FS_HALFTONE_BMP  2209
#define STID_WILL_USE_GIVE_SMPLE_THRESHOLD 2210
#define STID_WILL_NOT_USE_SIMPLE_THRESHOLD 2211
#define STID_ENTER_BMP_THRESHOLD_CUR_VAL   2212
#define STID_INVALID_THRESHOLD_REMAINS     2213
#define STID_USE_GIVEN_AS_BMP_THRESHOLD    2214
#define STID_XGETIMAGE_MAY_RUN_OUT_VMEM    2215
#define STID_NO_X11_BITMAP_OBJ_SELECTED    2216
#define STID_CANT_CUT_AN_EPS_OBJECT        2217
#define STID_XBM_CANT_HAVE_0_W_OR_H        2218
#define STID_BAD_RED_MASK_TRUE_COLOR_DPY   2219
#define STID_BAD_GREEN_MASK_TRUE_COLOR_DPY 2220
#define STID_BAD_BLUE_MASK_TRUE_COLOR_DPY  2221
#define STID_NETPBM_PROGS_VISIT_HOME_PAGE  2222
#define STID_NETPBM_PNMTOPNG_VST_HOME_PAGE 2223
#define STID_FNAME_FORMAT_ERROR_IN_FUNC    2224
#define STID_NAMED_IMAGEMAP_FILE_GEN       2225
#define STID_CANT_FND_FATTR_IMGMAP_NOT_GEN 2226
#define STID_CANT_FND_FATTR_NO_IMGMAP_GIF  2227
#define STID_NAMED_HTML_FILE_GEN           2228
#define STID_LARGE_EXP_PXL_TRM_WH_0_USED   2229
#define STID_APPLY_EXP_PXL_TRM_VALS        2230
#define STID_TOO_MANY_COLORS_LIMIT_IS      2231
#define STID_UNRECOG_GIVEN_PIXEL_VAL_PRINT 2232
#define STID_UNRECOG_GIVEN_PIXEL_VAL_1_USE 2233
#define STID_FORMAT_FILE_WH_PRINTED_INTO   2234
#define STID_SEL_XPM_DECK_TO_EXPORT        2235
#define STID_MANY_SZ_FAIL_XPM_DESK_EXPORT  2236
#define STID_INVALID_CH_PER_PIX_IN_FUNC    2237
#define STID_XPM_CANT_HAVE_0_W_OR_H        2238
#define STID_WARN_XPM_ALL_NON_BG_BE_BLACK  2239
#define STID_SAVED_FILE_MAY_BE_CORRUPTED   2240
#define STID_CANT_SAVE_XPM_ON_BW_DPY       2241
#define STID_CANT_IMPORT_GIVEN_FORMAT_XPM  2242
#define STID_CANT_IMPORT_GIVEN_CPP_XPM     2243
#define STID_EDIT_UNNAME_ATTR_DOTS         2244
#define STID_EDIT_VAL_OF_ATTR_DOTS         2245
#define STID_EDIT_UNNAME_ATTR_WITH_CMD     2246
#define STID_EDIT_VAL_OF_ATTR_WITH_CMD     2247
#define STID_STAT_FAIL_EDIT_ATTR_VAL_SAME  2248
#define STID_ENTER_HTML_TEMPLATE           2249
#define STID_ENTER_HTML_TEMPLATE_CUR_IS    2250
#define STID_HTML_TEMPLATE_UNCHANGED       2251
#define STID_HTML_TEMPLATE_SET_TO_GIVEN    2252
#define STID_NO_HTML_TEMPLATE_FILE         2253
#define STID_Q_FILE_NOT_EXIST_USE_ANYWAY   2254
#define STID_CANNOT_OPEN_HTML_TMPL_READ    2255
#define STID_OK_TO_FULL_SCREEN_CAPTURE_YNC 2256
#define STID_Q_FILE_UNSAVABLE_SAVE_NEW_YNC 2257
#define STID_WONT_CONDENSE_READHEXSTRING   2258
#define STID_CMD_ONLY_AVAIL_IN_VERTEX_MODE 2259
#define STID_CANNOT_MERGE_WITH_TILED_PAGE  2260
#define STID_SPECIFY_PAGES_TO_PRINT_EX     2261
#define STID_CANT_PRINT_PAGES_IN_TILED     2262
#define STID_CANT_PRINT_PAGES_IN_FORMAT    2263
#define STID_PRECISE_SCALE_EV_CAUSE_FLUSH  2264
#define STID_GO_HYPERSPACE_IN_SLIDE        2265
#define STID_DONT_GO_HYPERSPACE_IN_SLIDE   2266
#define STID_MOVE_EDIT_TEXT_BOX_ABORTED    2267
#define STID_DRAG_MOUSE_MOVE_EDITTEXT_DOTS 2268
#define STID_EXCEED_BUF_SIZE_LIMIT_IN_WB   2269
#define STID_CANT_REPLACE_GRAPHIC_NOT_TGIF 2270
#define STID_CANT_REPLACE_GRAPHIC_TOO_MANY 2271
#define STID_REPLACE_GRAPHIC_ICON_TO_GROUP 2272
#define STID_REPLACE_GRAPHIC_DONE          2273
#define STID_TOO_MANY_ICON_REPLACE_GRAPHIC 2274
#define STID_Q_CVT_ICON_TO_GRP_IN_REPLACE  2275
#define STID_SHOW_MEASUREMENT_IN_TT_ENAB   2276
#define STID_SHOW_MEASUREMENT_IN_TT_DISB   2277
#define STID_SEL_JPEG_FILE_TO_IMPORT       2278
#define STID_CANNOT_IMPORT_GIVEN_JPEG      2279
#define STID_GIVEN_JPEG_SIZE_FILE_IMPORTED 2280
#define STID_WILL_EXPORT_JPEG_FILE         2281
#define STID_NETPBM_JPEG_VST_HOME_PAGE     2282
#define STID_CANT_GEN_PREVIEW_FOR_PS       2283
#define STID_CANT_GEN_PREVIEW_FOR_EMPTY_PS 2284
#define STID_WILL_AUTO_GEN_PREVIEW_BITMAP  2285
#define STID_WONT_AUTO_GEN_PREVIEW_BITMAP  2286
#define STID_TMP_DIR_NOT_EXIST_USE_XDEF    2287
#define STID_INVALID_DIR_IN_X_DEFAULT      2288
#define STID_RACE_IN_CREATE_TMP_FILE       2289
#define STID_INVALID_GEOM_USE_ALT_GEOM     2290
#define STID_REDUCE_BY_FACTOR              2291
#define STID_ENLARGE_BY_FACTOR             2292
#define STID_CREATE_THUMBNAIL_CAUSE_FLUSH  2293
#define STID_CONNECT_PORTS_CANCEL_BY_USER  2294
#define STID_Q_CNFLCT_SIG_NAME_OKAY_TO_CLR 2295
#define STID_PLS_ENT_SIG_NAME              2296
#define STID_SIGNAL_NAMES_CLEARED          2297
#define STID_PLACING_NAMED_SIGNAL          2298
#define STID_PLS_ENT_SIG_NAME_FOR_PORT     2299

#define STID_NO_CUR_FILE_CANNOT_GEN_NETLST 2300
#define STID_NO_SIGNAME_FOUND_EMPTY_NETLST 2301
#define STID_WILL_EXPORT_NETLIST_FILE      2302
#define STID_Q_OK_TO_CUT_INTO_SEGMENTS     2303
#define STID_NO_POLY_OBJ_SELECTED          2304
#define STID_WILL_SHOW_WIRE_SIGNAL_NAME    2305
#define STID_WILL_HIDE_WIRE_SIGNAL_NAME    2306
#define STID_TRY_AGAIN_AND_CLICK_IN_A_PORT 2307
#define STID_TRY_AGAIN_AND_END_IN_A_PORT   2308
#define STID_CANNOT_CREATE_ARC_WITH_RAD1   2309
#define STID_SEL_ONE_NONE_PORT_PLUS_COMP   2310
#define STID_PORT_OBJ_HAS_EMPTY_NAME       2311
#define STID_CANNOT_FIND_INIT_ATTR_PORT_PA 2312
#define STID_CANNOT_FIND_VAR_IN_INIT_ATTR  2313
#define STID_RENUMBER_OBJ_IDS_CAUSE_FLUSH  2314
#define STID_RENUMBER_OBJ_IDS_DONE         2315
#define STID_RENUMBER_OBJ_IDS_IN_WB        2316
#define STID_SEL_ONE_NONE_PORT_PLUS_BRDCST 2317
#define STID_CONFLICT_SIG_NAME_ENT_NEW     2318
#define STID_BAD_SIG_NAME_UNDO_AND_REDO    2319
#define STID_WILL_USE_WORDWRAP_IMPORT_TEXT 2320
#define STID_NO_WORDWRAP_IMPORT_TEXT       2321
#define STID_CUR_MARGINS_ARE_GIVEN         2322
#define STID_ENTER_MARGINS                 2323
#define STID_NEW_MARGINS_ARE_GIVEN         2324
#define STID_CANT_OBTAIN_TMP_FILE_NAME     2325
#define STID_NO_OBJ_SPEC_WHILE_EXEC_CMD    2326
#define STID_UNRECOG_GIVEN_TRPIX_VAL_PRINT 2327
#define STID_TGIF_DISTRUBITION             2328
#define STID_WRITE_TO_SELF_PIPE_FAIL       2329
#define STID_CREATE_SELF_PIPE_FAIL         2330
#define STID_READ_FROM_SELF_PIPE_FAIL      2331
#define STID_ENTER_BEZIER_NUM_SEGS_CUR_IS  2332
#define STID_BEZIER_NUM_SEGS_SET_TO_INT    2333
#define STID_ENT_VAL_RANGE_ENTER_GE_INT    2334
#define STID_ENTER_TICK_MARK_SIZE_CUR_IS   2335
#define STID_TICK_MARK_SIZE_SET_TO_INT     2336
#define STID_NO_SPLINE_SELECTED            2337
#define STID_SPLINE_CONVERTED_TO_BEZIER    2338
#define STID_PEEK_DIM_LEFT                 2339
#define STID_PEEK_DIM_TOP                  2340
#define STID_PEEK_DIM_RIGHT                2341
#define STID_PEEK_DIM_BOTTOM               2342
#define STID_PEEK_DIM_WIDTH                2343
#define STID_PEEK_DIM_HEIGHT               2344
#define STID_PEEK_DIM_CX                   2345
#define STID_PEEK_DIM_CY                   2346
#define STID_NO_POLY_ETC_SELECTED          2347
#define STID_SEL_A_SYM_TO_INSTAN_IN_NONE   2348
#define STID_WRITE_NOT_AUTO_IN_HYPER_EXEC  2349
#define STID_USER_ABORT_WRITE_IN_HYPER     2350
#define STID_READ_FROM_SELF_PIPE_OVERFLOW  2351
#define STID_BAD_CMDLINE_OPT_USE_ALT_STR   2352
#define STID_BAD_CMDLINE_OPT_IGNORED       2353
#define STID_OBSOLETE_CMDLINE_ASSUME       2354
#define STID_INVALID_XDEF_IGNORED          2355
#define STID_OBSOLETE_XDEF_REPLACED        2356
#define STID_FILE_IS_MARKED_UNSAVABLE      2357
#define STID_ONLYONE_DBIM_OR_SBIM          2358
#define STID_DBIM_UNSUPPORTED              2359
#define STID_SBIM_UNSUPPORTED              2360
#define STID_CANNOT_OPEN_IN_SLIDESHOW      2361
#define STID_TOGGLE_AUTO_SCR_IN_CHAT       2362
#define STID_TOGGLE_BOLD_IN_CHAT           2363
#define STID_TOGGLE_ITALIC_IN_CHAT         2364
#define STID_SEND_CHAT_TEXT                2365
#define STID_MALFORMED_CHAT_LINE           2366
#define STID_UNRECOG_FIELD_IN_CHAT_LINE    2367
#define STID_UNRECOG_BYTE_FROM_SELF_PIPE   2368
#define STID_JOIN_WB_IN_PROGRESS_IGNORED   2369
#define STID_PEEK_AREA                     2370
#define STID_CANT_DO_SAVEPAGESAS_IN_TILED  2371
#define STID_SPECIFY_PAGES_TO_SAVE_EX      2372
#define STID_ONE_PAGE_SAVED_INTO_GIVEN     2373
#define STID_MANY_PAGES_SAVED_INTO_GIVEN   2374
#define STID_CANT_IMP_ANIM_GIF_DIR_OR_PATH 2375
#define STID_WILL_EXPORT_PPM_FILE          2376
#define STID_NETPBM_VST_HOME_PAGE          2377
#define STID_SEL_PPM_FILE_TO_IMPORT        2378
#define STID_CANNOT_IMPORT_GIVEN_PPM       2379
#define STID_GIVEN_PPM_SIZE_FILE_IMPORTED  2380
#define STID_IMPORT_FORMAT_WHILE_EXEC_CMD  2381
#define STID_NO_OBJ_TO_IMP_WHILE_EXEC_CMD  2382
#define STID_CANNOT_LOAD_TGTWB5_FONT       2383
#define STID_TOOL_BIG5_CHINESE_KEYPAD      2384
#define STID_USE_ZYFH_KEYPAD_OR_PINYING    2385
#define STID_INVALID_PINYIN_SEQ            2386
#define STID_ADD_ZYFH                      2387
#define STID_FETCH_CHAR                    2388
#define STID_BACKOUT_ZYFH                  2389
#define STID_SELECT_A_CHAR                 2390
#define STID_SEND_A_CHAR_TO_DRAWING_AREA   2391
#define STID_CLICK_SEND_TO_SEND_CHAR       2392
#define STID_FETCH_CHARS_FROM_DB           2393
#define STID_SEND_SEL_CHAR_TO_DRAWING_AREA 2394
#define STID_SEND_CR_TO_DRAWING_AREA       2395
#define STID_OK_TO_RESET_GIVEN_IM          2396
#define STID_GIVEN_IM_RESETED              2397
#define STID_WILL_EXPORT_PBM_FILE          2398
#define STID_SEL_PBM_FILE_TO_IMPORT        2399

#define STID_CANNOT_IMPORT_GIVEN_PBM       2400
#define STID_GIVEN_PBM_SIZE_FILE_IMPORTED  2401
#define STID_WILL_EXPORT_PGM_FILE          2402
#define STID_SEL_PGM_FILE_TO_IMPORT        2403
#define STID_CANNOT_IMPORT_GIVEN_PGM       2404
#define STID_GIVEN_PGM_SIZE_FILE_IMPORTED  2405
#define STID_CANNOT_IDEN_GS                2406
#define STID_TOOL_NOT_INTV_WHILE_EXEC_CMD  2407
#define STID_CONVERT_TO_XBM_WHILE_EXEC_CMD 2408
#define STID_FUNC_ARG_STRS_RANGE           2409
#define STID_WARN_CANNOT_FIND_SOME_ATTRS   2410
#define STID_BAD_LINE_MAY_HAVE_DEL_EQUAL   2411
#define STID_ATTR_NAME_CHANGED_IMPORT_Q    2412
#define STID_CANT_IMPORT_ATTR_GROUP_RETRY  2413
#define STID_TGIF_FLAGS                    2414
#define STID_INVALID_COMPILER_OPT          2415
#define STID_EXECUTING_GIVEN_SCRIPT        2416
#define STID_STAT_FAILED_WHILE_IMPORT_LINK 2417
#define STID_SEL_JPEG_FILE_TO_LINKTO       2418
#define STID_INVALID_PARAM_LINKED_JPEG     2419
#define STID_INVALID_PATH_WHILE_READ_JPEG  2420
#define STID_PRTGIF_LINK_JPEG_SKIPPED      2421
#define STID_DUP_SHORTCUT_FUNCTION_KEY     2422
#define STID_BAD_STYLE_NAME_WHILE_EXEC_CMD 2423
#define STID_CANT_ACQUIRE_X_SELECTION      2424
#define STID_NO_TEXT_SELECTED_FOR_COPY     2425
#define STID_PASTE_FAILED_CONV_REFUSED     2426
#define STID_BAD_XDEF_MISS_TOKEN_NAME_SKIP 2427
#define STID_BAD_XDEF_CANT_FIND_TOKEN_SKIP 2428
#define STID_BAD_XDEF_MISS_CHAR_NAME_SKIP  2429
#define STID_DUP_CHAR_CODE_XDEF_IGNORED    2430
#define STID_FAIL_TO_PARSE_CHAR_CODE_XDEF  2431
#define STID_CHAR_CODE_OUT_OF_RANGE_XDEF   2432
#define STID_BAD_FAKE_FONT_NAME_NO_ALIAS   2433
#define STID_CANT_FIND_PS_CHAR_SUBS_READ   2434
#define STID_DUP_TOKEN_PS_CHAR_SUBS_READ   2435
#define STID_FAIL_TO_PARSE_CHAR_CODE_FILE  2436
#define STID_CHAR_CODE_OUT_OF_RANGE_FILE   2437
#define STID_DUP_CHAR_CODE_FILE_IGNORED    2438
#define STID_CMDLINE_ARG_GIVEN_TOO_LONG    2439
#define STID_CANT_IMPORT_GIVEN_PPM_MALFORM 2440
#define STID_PPM6_DIM_NOT_MATCH            2441
#define STID_UNSUP_PPM6_MAX_VAL            2442
#define STID_JPEG_DIM_NOT_MATCH_DELETED    2443
#define STID_ENTER_XY_OFFSET_OBJ_SHADOW    2444
#define STID_OBJ_SHADOW_XY_OFFSETS_SET_TO  2445
#define STID_ENTER_A_COLOR_FOR_OBJ_SHADOW  2446
#define STID_OBJ_SHADOW_COLOR_SET_TO_NAMED 2447
#define STID_NO_OBJ_SHADOW_FOUND           2448
#define STID_TRANS_XPM_TOO_MANY_COLORS_SKP 2449
#define STID_NEED_DISABLE_UNDO_WILL_CRASH  2450
#define STID_CANT_LOAD_INITIAL_FONT        2451
#define STID_CANT_CHNG_FONT_SUPSUB_CENTER  2452
#define STID_JOIN_WB_IN_PROGRESS_FAILED    2453
#define STID_JOIN_WB_IN_FAILED_NO_CONTTYPE 2454
#define STID_INVALID_RMCAST_DLIB_PATH      2455
#define STID_NO_INFO_LIBRMCAST_SO          2456
#define STID_BAD_VER_RMCAST_DLIB           2457
#define STID_CANNOT_HANDLE_VER_RMCAST_DLIB 2458
#define STID_MISSING_RMCASTDIR             2459
#define STID_NO_PTHREAD_CONTINUE           2460
#define STID_INVALID_GIVEN_PARAM_GIVEN_OBJ 2461
#define STID_CANNOT_INFLATE_GIVEN_OBJ      2462
#define STID_BAD_LINE_READING_GIVEN_OBJ    2463
#define STID_INSUF_DATA_READING_GIVEN_OBJ  2464
#define STID_PATTERNDIR_NOT_EXIST          2465
#define STID_MISSING_RMCASTLIB             2466
#define STID_INVALID_XBM_CUST_PAT          2467
#define STID_TRANS_PIX_NOT_SUP_PPM_TRUE    2468
#define STID_XPM_HAS_ATTR_IMGPROC          2469
#define STID_PPM_TRUE_LOSSY_CONV_TO_XPM    2470
#define STID_SWITCHED_TO_AUTO_ROTATE_PIVOT 2471
#define STID_SWITCHED_TO_USER_ROTATE_PIVOT 2472
#define STID_NEW_ROTATE_PIVOT_IS           2473
#define STID_ENTER_ROT_PIVOT               2474
#define STID_ENTER_ROT_PIVOT_CUR_IS        2475
#define STID_ROT_PIVOT_SET_TO              2476
#define STID_VISIBLE_ROTATE_PIVOT          2477
#define STID_NOT_VISIBLE_ROTATE_PIVOT      2478
#define STID_SELONLYONEPOLYOBJ             2479
#define STID_SELONLYONEARCOBJ              2480
#define STID_WILL_EXPORT_SVG_FILE          2481
#define STID_TOOL_COLOR_WHEEL              2482
#define STID_COLOR_WHEEL_NOT_AVAIL         2483
#define STID_GIVEN_VAL_MUST_BE_LE          2484
#define STID_TWO_VERTEX_POLY_ONLY          2485
#define STID_ENTER_MULT_FACTOR             2486
#define STID_RES_LINESEG_HAVE_ZERO_LEN     2487
#define STID_WILL_USE_TIGHTER_SPLINES      2488
#define STID_WILL_USE_LOOSER_SPLINES       2489
#define STID_TWO_CONSEC_VERTICES_ONLY      2490
#define STID_LINE_TYPE_IS_STRUCT_SPLINE    2491
#define STID_ONE_V_STRUCT_SPLINE_IN_V_MODE 2492
#define STID_SHUTTING_DOWN_WHITEBOARD      2493
#define STID_SOME_LT_FAILED_TO_CONVERT     2494
#define STID_CANNOT_CONVERT_SEL_LINETYPE   2495
#define STID_CANNOT_CONVERT_TO_STRUCT_SPLN 2496
#define STID_ADD_HINGE_VERTEX              2497
#define STID_ADD_A_SMOOTH_VERTEX           2498
#define STID_CANNOT_ADD_SMOOTH_VERTEX      2499

#define STID_LEFT_ADD_HINGE_MID_ADD_SMOOTH 2500
#define STID_CLICK_RIGHT_BUTTON_TO_QUIT    2501
#define STID_SELECTION_CONV_REFUSED        2502
#define STID_TRY_PASTE_WITH_OLD_X_MECH     2503
#define STID_CANNOT_TOGGLE_FOR_STRUCT_SPLN 2504
#define STID_SEL_2_COMPAT_END_PTS_TO_JOIN  2505
#define STID_CANNOT_CUT_AT_SMOOTH_PT       2506
#define STID_RIGHT_MARGIN_IS               2507
#define STID_RIGHT_MARGIN_DISABLED         2508
#define STID_ENTER_RIGHT_MARGIN            2509
#define STID_CURRENT_RIGHT_MARGIN_IS       2510
#define STID_ERR_PARSE_THRESH_COLORS       2511
#define STID_FLOOD_REPLACE_ENABLED         2512
#define STID_FLOOD_REPLACE_DISABLED        2513
#define STID_SET_FLOOD_REPLACE_THRESH      2514
#define STID_FLOOD_REPLACE_THRESH_SET_TO   2515
#define STID_BADPNG_SHORT_HEADER           2516
#define STID_BADPNG_BAD_HEADER             2517
#define STID_BADPNG_BAD_PALETTE_LEN        2518
#define STID_BADPNG_BAD_CHUNK_LEN          2519
#define STID_BADPNG_SHORT_CHUNK_TYPE       2520
#define STID_BADPNG_SHORT_CRC              2521
#define STID_BAD_TRANS_COLOR_NO_TRANS      2522
#define STID_CUR_COLOR_IS_TRANS_PIXEL      2523
#define STID_BAD_CMD_FOR_TRANS_PPMTRUE     2524
#define STID_SEL_ONE_XPM_TRANSPIX          2525
#define STID_CANNOT_FIND_GOOD_TRANSPIX     2526
#define STID_CANNOT_SET_XDEF_TRUE_NO_ZLIB  2527
#define STID_BAD_GIVEN_LINE_WRITTEN        2528
#define STID_TWO_XDEF_ONE_IGNORED          2529
#define STID_BAD_ENCODING_TGTWB5_FONT      2530
#define STID_TOOL_GB_CHINESE_KEYPAD        2531

#define MAXNONCACHEDSTIDS 2532

extern struct MouseStatusStrRec	colorMouseStatus[];
extern struct MouseStatusStrRec	hAlignMouseStatus[];
extern struct MouseStatusStrRec	vAlignMouseStatus[];
extern struct MouseStatusStrRec	pageMouseStatus[];
extern struct MouseStatusStrRec	pageLayoutMouseStatus[];
extern struct MouseStatusStrRec	justMouseStatus[];
extern struct MouseStatusStrRec	fontMouseStatus[];
extern struct MouseStatusStrRec	vspaceMouseStatus[];
extern struct MouseStatusStrRec	textSizeMouseStatus[];
extern struct MouseStatusStrRec	lineWidthMouseStatus[];
extern struct MouseStatusStrRec	lineStyleMouseStatus[];
extern struct MouseStatusStrRec	lineTypeMouseStatus[];
extern struct MouseStatusStrRec	lineDashMouseStatus[];
extern struct MouseStatusStrRec	rcbRadiusMouseStatus[];
extern struct MouseStatusStrRec	zoomMouseStatus[];
extern struct MouseStatusStrRec	moveModeMouseStatus[];
extern struct MouseStatusStrRec	shapeMouseStatus[];
extern struct MouseStatusStrRec	stretchableTextModeMouseStatus[];
extern struct MouseStatusStrRec	fileMouseStatus[];
extern struct MouseStatusStrRec	fillMouseStatus[];
extern struct MouseStatusStrRec	penMouseStatus[];
extern struct MouseStatusStrRec	transPatMouseStatus[];
extern struct MouseStatusStrRec	autoRotatePivotMouseStatus[];

#ifdef _INCLUDE_FROM_STRTBL_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_STRTBL_C_*/

extern char	*TgLoadCachedString ARGS_DECL((int nID));
extern char	*TgLoadString ARGS_DECL((int nID));

extern char	*DistrDirectLoadString ARGS_DECL((int nIndex));
extern char	*AlignedLoadString ARGS_DECL((int hori_align, int vert_align));
extern char	*HoriAlignLoadString ARGS_DECL((int hori_align));
extern char	*VertAlignLoadString ARGS_DECL((int vert_align));
extern char	*AlignDirectLoadString ARGS_DECL((int nIndex));
extern char	*AlignDirectToGridLoadString ARGS_DECL((int nIndex));
extern char	*AlignDirectToPageLoadString ARGS_DECL((int nIndex));
extern char	*AlignVerticesDirectToPageLoadString ARGS_DECL((int nIndex));

extern void	SetCurChoiceMouseStatusStrings ARGS_DECL((int choice,
			int left_is_none, struct ObjRec *,
			int cur_text_under_mouse, unsigned int state));
extern void	QuickSetMouseStatus ARGS_DECL((struct MouseStatusStrRec *pmssr,
		                               int index));
extern void	SetColorMouseStatusStrings ARGS_DECL((int index,
		                                      int shift_or_cntrl_down));
extern char	*PropLoadString ARGS_DECL((long lWhich));
extern char	*ExportFormatMenuLoadString ARGS_DECL((int where_to_print,
		                                       int color_dump));

extern void	SetMouseStatusToAllNone ARGS_DECL((void));
extern void	CleanUpStrTable ARGS_DECL((void));
extern void	InitStrTable ARGS_DECL((void));

#ifdef _INCLUDE_FROM_STRTBL_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_STRTBL_C_*/

#endif /*_TGIF_STRTBL_E_*/
