#!/usr/bin/python

##
## Copyright (C) 2011-2012 Andrew Atkinson
##
##-------------------------------------------------------------------
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.
##-------------------------------------------------------------------

from __future__ import unicode_literals

import codecs
import io as cStringIO
import os
import re
import wx

import CheckerCreate


def writethconfig(settings, locations):
    filename = os.path.join(locations['surveydir'], settings['configname'])
    surveyname = locations['surveyname']
    contents = settings['thconfigtext']
    #change the wildcards for correct names
    contents = re.sub(r'##NAME##', surveyname, contents)
    fullpathlayout = os.path.join(settings['projectroot'], settings['layout'])
    if os.path.exists(fullpathlayout):
        layout = os.path.relpath(fullpathlayout, locations['surveydir'])
        contents = re.sub(r'##LAYOUT##', layout, contents)
    else:
        print("layout file does not exist at: ", fullpathlayout)
    configfile = cStringIO.StringIO()
    configfile.write(contents)
    CheckerCreate.CreateFile(filename, configfile, settings['overwrite'],
                                settings['add2rep'], settings['repository'])
    return
