# 桌面環境|dde|

## 概述

統信作業系統（簡稱「統信UOS」）是一款美觀易用、安全可靠的國產桌面作業系統。統信UOS預裝了檔案管理器、系統監視器等一系列原生應用程式。隨著功能的不斷升級和完善，統信作業系統已成為中國最受歡迎的桌面作業系統之一。

![1|desk](fig/eu_desk.png)

### 系統簡介

成功登入系統後，即可體驗統信UOS桌面環境。桌面環境主要由桌面、任務欄、啟動器、控制中心等組成，是您使用該作業系統的基礎。

## 桌面

桌面是您登入後看到的主螢幕區域。在桌面上，您可以新增文件/資料夾、排列文件、開啓終端機、設定桌布和螢幕保護程式等，還可以透過 [設定捷徑](#設定捷徑) 向桌面添加應用程式的捷徑。

![0|rightbuttonmenu](fig/contextmenu.png)



### 新增資料夾/文件

在桌面建立資料夾或文件，也可以對文件進行一般操作，和在檔案管理器中一樣。

   - 在桌面上，單擊滑鼠右鍵，單擊 **新增資料夾**，輸入新增資料夾的名稱。
   - 在桌面上，單擊滑鼠右鍵，單擊 **新增文件**，選擇新增文件的類型，輸入新增文件的名稱。

在桌面文件或資料夾上，單擊滑鼠右鍵，您可以使用檔案管理器的相關功能：

| 功能        | 說明                                                     |
| ----------- | -------------------------------------------------------- |
| 用其他程式開啟   | 選定系統預設打開方式，也可以選擇其他關聯應用程式來打開。 |
| 剪下        | 移動文件或資料夾。                                       |
| 複製        | 複製文件或資料夾。                                       |
| 重新命名    | 重新命名文件或資料夾。                                   |
| 刪除        | 刪除文件或資料夾。                                       |
| 建立連結    | 建立一個捷徑。                                           |
| 標籤內容   | 添加標籤內容，以對文件或資料夾進行標籤化管理。           |
| 壓縮/解壓 | 壓縮文件或資料夾，或對壓縮文件進行解壓。                 |
| 病毒查殺 | 對文件或資料夾進行病毒查殺。              |
| 屬性        | 查看文件或資料夾的基本訊息、共享方式及其權限。           |

>![notes](../common/notes.svg) 說明：在鍵盤上按下 **Alt** + **M** 快捷鍵，打開右鍵選單。

### 設定排列方式

您可以對桌面上的圖示按照需要進行排序。

1. 在桌面上，單擊滑鼠右鍵。
2. 單擊 **排列順序**，您可以：

   - 單擊 **檔案名稱**，將按文件的名稱順序顯示。
   - 單擊 **大小**，將按文件的大小順序顯示。
   - 單擊 **類型**，將按文件的類型順序顯示。
   - 單擊 **修改時間**，文件將按最近一次的修改日期順序顯示。

>![tips](../common/tips.svg) 竅門：您也可以勾選 **自動排列**，桌面圖示將從上往下，從左往右按照目前排序規則排列，有圖示被刪除時後面的圖示會自動向前填充。

### 調整圖示大小

1. 在桌面上，單擊滑鼠右鍵。
2. 單擊 **圖示大小**。
3. 選擇一個合適的圖示大小。

>![tips](../common/tips.svg) 竅門：您也可以用 **Ctrl** + ![=](../common/=.svg)/![-](../common/-.svg)/滑鼠滾動來調整桌面和啟動器中的圖示大小。

### 設定顯示器

從這裡快速進入控制中心設定顯示器的縮放比例、解析度和亮度等。

1. 在桌面上，單擊滑鼠右鍵。
2. 單擊 **顯示設定**，快速進入控制中心的顯示設定介面。

>![notes](../common/notes.svg) 說明：關於顯示的設定，具體操作請參閱 [螢幕設定](#螢幕設定)。

### 更改桌布

您可以選擇一些精美、時尚的桌布來美化桌面，讓您的電腦顯示與眾不同。


1. 在桌面上，單擊滑鼠右鍵。
2. 單擊 **桌布和螢幕保護程式**，在桌面底部預覽所有桌布。
3. 選擇某一桌布後，桌布就會在桌面和鎖定螢幕中生效。
4. 您可以單擊 **僅桌面** 和 **僅鎖定畫面** 來控制桌布的生效範圍。

![1|wallpaper](fig/wallpaper.png)

>![tips](../common/tips.svg) 竅門：您還可以在圖片檢視器中設定您喜歡的圖片為桌面桌布。

### 設定螢幕保護程式

螢幕保護程式原本是為了保護映像管，現在一般用來防範他人偷窺您電腦上的一些隱私。

1. 在桌面上，單擊滑鼠右鍵。
2. 單擊 **桌布和螢幕保護程式**，單擊 **螢幕保護程式**，在桌面底部預覽所有螢幕保護程式。
3. 選擇其中一個螢幕保護程式，單擊 **套用**，在上方選擇 **等待時間**。
4. 您可以勾選 **喚醒時需要密碼**，以便更好地保護您的隱私。
5. 待電腦等待指定時間後，將啟動您選擇的螢幕保護程式。

![1|screensaver](fig/screensaver.png)

### 剪貼簿

剪貼簿展示目前使用者登入系統後複製和剪下的所有文字、圖片和文件。使用剪貼簿可以快速複製其中的某項內容。註銷或關機後，剪貼簿會自動清空。

1. 使用快捷鍵 **Ctrl** + **Alt** + **V** 喚出剪貼簿。
2. 雙擊剪貼簿內的某一區塊，會快速複製目前內容，且目前區塊會被移動到剪貼簿頂部。
3. 選擇目標位置貼上。
4. 滑鼠移入剪貼簿的某一區塊，單擊上方的![close](../common/close_normal.svg)，刪除目前內容；單擊頂部的 **全部清除**，清空剪貼簿。

![1|clipboard](fig/clipboard.png)




## 任務欄

任務欄是指位於桌面底部的長條，主要由啟動器、應用程式圖示、託盤區、系統附加元件等組成。在任務欄，您可以打開啟動器、顯示桌面，對其上的應用程式進行打開、建立、關閉、強制離開等操作，還可以設定輸入法，連接Wi-Fi，查看日曆，進入關機介面等。

### 認識任務欄圖示

任務欄圖示包括啟動器圖示、應用程式圖示、系統託盤區圖示、系統附加元件圖示等。

![1|fashion](fig/eu_efficient.png)

| 圖示 | 說明 | 
| ---- | ---- |
| ![launcher](../common/deepin-launcher.svg) | 啟動器 - 點擊查看所有已安裝的應用。 | 
| ![deepin-toggle-desktop](../common/deepin-toggle-desktop.svg) | 顯示桌面。  |
| ![dde-file-manager](../common/dde-file-manager.svg)      | 檔案管理器 - 點擊查看磁碟中的文件、資料夾。  |
| ![browser-cn](../common/org.deepin.browser.svg) | 瀏覽器 - 點擊打開網頁。| 
| ![dde-calendar](../common/dde-calendar.svg) | 日曆 - 查看日期、建立日程。 |
| ![controlcenter](../common/controlcenter.svg) | 控制中心 - 點擊進入系統設定。 | 
| ![notification](../common/notification.svg) | 通知中心 - 顯示所有系統和應用程式的通知。 |
| ![onboard](../common/onboard.svg) | 螢幕鍵盤 - 點擊使用虛擬鍵盤。 |
| ![shutdown](../common/system-shutdown.svg) | 電源 - 點擊進入關機介面。 | 
| ![trash](../common/trash_icon.svg)   | 回收桶。 | 


>![tips](../common/tips.svg) 竅門：在高效模式下，單擊任務欄右側可顯示桌面。將滑鼠指標移到任務欄上已打開視窗的圖示時，會顯示相應的預覽視窗。

### 切換顯示模式

任務欄提供兩種顯示模式：時尚模式和高效模式，顯示不同的圖示大小和應用程式視窗啟動效果。


![1|fashion](fig/eu_fashion.png)

![1|efficient](fig/eu_efficient.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

您可以透過以下操作來切換顯示模式：

1. 右鍵單擊任務欄。
2. 在 **模式** 子選單中選擇一種顯示模式。

### 設定任務欄位置

您可以將任務欄放置在桌面的任意方向。

1. 右鍵單擊任務欄。
2. 在 **位置** 子選單中選擇一個方向。

### 調整任務欄高度 

滑鼠拖動任務欄邊緣，改變任務欄高度。



### 顯示/隱藏附加元件

1. 右鍵單擊任務欄。
2. 在 **附加元件** 子選單中勾選或取消勾選 **回收桶、電源、顯示桌面、螢幕鍵盤、通知中心、日期時間**，可以設定這些附加元件在任務欄上的顯示和隱藏效果。

### 查看通知

當有系統或應用程式通知時，會在桌面上方彈出通知消息。若有按鈕，單擊按鈕執行對應操作；若無按鈕，單擊關閉此消息。

![message](fig/message.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

此外，還可以單擊任務欄上的 ![notification](../common/notification.svg)， 打開通知中心，查看所有通知。

### 查看日期時間

   - 滑鼠指標懸停在任務欄的時間上，查看目前日期、星期和時間。
   - 單擊時間，打開日曆。

### 進入關機介面

您可以單擊任務欄上的 ![shutdown](../common/system-shutdown.svg) 進入關機介面，也可以在啟動器的小視窗模式中單擊 ![poweroff_normal](../common/poweroff_normal.svg)。

| 功能                                                         | 說明                                                         |
| ------------------------------------------------------------ | ------------------------------------------------------------ |
| 關機![poweroff_normal](../common/poweroff_normal.svg)        | 關閉電腦。                                                   |
| 重新啟動![reboot_normal](../common/reboot_normal.svg)        | 關機後再次重新執行您的電腦。                                 |
| 鎖定![lock_normal](../common/lock_normal.svg)                | 鎖定電腦，或按下鍵盤上的 **Super** + **L** 組合鍵鎖定。      |
| 切換使用者![userswitch_normal](../common/userswitch_normal.svg) | 選擇另一個使用者帳戶登入。                                   |
| 登出![logout_normal](../common/logout_normal.svg)            | 清除目前登入使用者的訊息。                                   |
| 啟動系統監視器![deepin-system-monitor](../common/deepin-system-monitor.svg) | 快速啟動系統監視器。                                         |

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

>![notes](../common/notes.svg) 說明：當系統存在多個帳戶時才顯示 **切換使用者**![userswitch_normal](../common/userswitch_normal.svg)。

### 回收桶

電腦中臨時被刪除的所有文件您都可以在回收桶中找到，回收桶中的文件可以被還原或清除。

#### 還原文件

臨時被刪除的文件，可以在回收桶進行還原，或使用快捷鍵 **Ctrl** + **Z** 還原剛刪除的文件。

1. 在回收桶中，選擇要復原的文件。
2. 單擊滑鼠右鍵，選擇 **還原**。
3. 還原文件到原來的儲存路徑下。

>![attention](../common/attention.svg) 注意：如果原來所在的資料夾已經刪除，還原文件時會自動新增資料夾。

#### 刪除文件

回收桶中可以單獨清除某一文件。

1. 在回收桶中，選擇要刪除的文件。
2. 單擊滑鼠右鍵，選擇 **刪除**，即可刪除回收桶的文件。

#### 清空回收桶

在回收桶中，單擊 **清空**，將徹底刪除回收桶的所有內容。

## 啟動器

啟動器 ![launcher](../common/deepin-launcher.svg) 幫助您管理系統中已安裝的所有應用程式，在啟動器中使用分類導航或搜尋功能可以快速找到您需要的應用程式。

您可以進入啟動器查看新安裝的應用程式。新安裝應用程式的旁邊會出現一個小藍點提示。



### 切換模式

啟動器有全螢幕和小視窗兩種模式。單擊啟動器介面右上角的圖示來切換模式。

兩種模式均支援搜尋應用程式、建立捷徑等操作。

小視窗模式還支援快速打開檔案管理器、控制中心和進入關機介面等功能。

![1|launch](fig/eu_fullscreen.png)
![1|launch](fig/eu_mini.png)

### 排列應用程式

在全螢幕模式下，系統預設按照安裝時間排列所有應用程式。

   - 將滑鼠懸停在應用程式圖示上，按住滑鼠左鍵不放，將應用程式圖示拖曳到指定的位置自由排列。
   - 單擊啟動器介面左上角分類圖示 ![category](../common/category_icon.svg) 進行排列。

![1|sortapp](fig/eu_sortapp.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

在小視窗模式下，預設按照使用頻率排列應用程式。

### 尋找應用程式

在啟動器中，您可以滾動滑鼠滾輪或切換分類導航尋找應用程式。

如果知道應用程式名稱，直接在搜尋框中輸入關鍵字，快速定位到需要的應用程式。

### 設定捷徑

捷徑提供了一種簡單快捷地啟動應用程式的方法。

#### 建立捷徑

將應用程式發送到桌面或任務欄上，方便您的後續操作。

在啟動器中，右鍵單擊應用程式圖示，您可以：

   - 單擊 **建立桌面捷徑**，在桌面建立捷徑。

   - 單擊 **釘選到Dock**，將應用程式固定到任務欄。

![0|sendto](fig/eu_sendto.png)

>![notes](../common/notes.svg) 說明：您還可以從啟動器拖曳應用程式圖示到任務欄上放置。但是當應用程式處於執行狀態時您將無法拖曳固定，此時您可以右鍵單擊任務欄上的應用程式圖示，選擇 **駐停** 將應用程式固定到任務欄，以便下次使用時從任務欄上快速開啟。

#### 刪除捷徑

您既可以在桌面直接刪除應用程式的捷徑，也可以在任務欄和啟動器中刪除。

**從任務欄上刪除**

   - 在任務欄上，按住滑鼠左鍵不放，將應用程式圖示拖曳到任務欄以外的區域移除捷徑。
   - 當應用程式處於執行狀態時您將無法拖曳移除，此時可以右鍵單擊任務欄上的應用程式圖示，選擇 **解除駐停** 將應用程式從任務欄上移除。

**從啟動器中刪除**

在啟動器中，右鍵單擊應用程式圖示，您可以：

   - 單擊 **移除桌面捷徑**，刪除桌面捷徑。
   - 單擊 **移除Dock捷徑**，將固定到任務欄上的應用程式移除。

>![notes](../common/notes.svg) 說明：以上操作，只會刪除應用程式的捷徑，而不會移除應用程式。

### 執行應用程式

對於已經建立了桌面捷徑或固定到任務欄上的應用程式，您可以透過以下途徑來打開應用程式。

   - 雙擊桌面圖示，或右鍵單擊桌面圖示選擇 **開啟**。
   - 直接單擊任務欄上的應用程式圖示，或右鍵單擊任務欄上的應用程式圖示選擇 **開放**。

在啟動器中，直接單擊應用程式圖示打開，或右鍵單擊應用程式圖示選擇 **開啟**。

>![tips](../common/tips.svg) 竅門：對於經常使用的應用程式，您可以在啟動器中，右鍵單擊應用程式圖示選擇 **開機啟動**。


## 控制中心

統信UOS作業系統透過控制中心來管理系統的基本設定，包括帳戶管理、網路設定、日期和時間、個性化設定、螢幕設定等。當您進入桌面環境後，單擊任務欄上的 ![controlcenter](../common/controlcenter.svg) 即可打開控制中心視窗。

### 首頁介紹

控制中心首頁主要展示各個設定模組，方便日常查看和快速設定。

![2|dcchomepage](fig/eu_dcc.png)

打開控制中心的某一設定模組後，可以透過左側導航欄快速切換到另一設定模組。

![2|cc-navigation](fig/eu_ccnavigation.png)



#### 標題欄

標題欄包含返回按鈕、搜尋框、主選單及視窗按鈕。

   - 返回按鈕：若要返回首頁，單擊 ![back](../common/back.svg)。
   - 搜尋框：輸入關鍵字，單擊鍵盤上 **Enter** 鍵，搜尋相應設定。
   - 主選單：單擊 ![menu](../common/icon_menu.svg) 進入主選單。在主選單中，您可以設定視窗主題、查看版本或離開控制中心。

### 帳戶設定

在安裝系統時會建立一個帳戶，在控制中心的帳戶設定模組可以修改帳戶設定或建立一個新帳戶。

![0|account](fig/eu_account.png)

#### 建立新帳戶

1. 在控制中心首頁，單擊 ![account_normal](../common/account_normal.svg)。
2. 單擊 **建立帳戶** 按鈕![add](../common/add.svg)。
3. 輸入使用者名稱、密碼和確認密碼。
4. 單擊 **建立**。
5. 在授權對話框輸入目前帳戶的密碼，新帳戶就會添加到帳戶列表中。

#### 更改頭像

1. 在控制中心首頁，單擊 ![account_normal](../common/account_normal.svg)。
2. 單擊列表中的帳戶。
3. 單擊帳戶，選擇一個頭像或添加本機頭像，頭像就取代完成了。

#### 設定全名

帳戶全名會顯示在帳戶列表和系統登入介面，可根據需要設定。

1. 在控制中心首頁，單擊 ![account_normal](../common/account_normal.svg)。
2. 單擊列表中的帳戶。
3. 單擊 **設定全名** 後的 ![edit](../common/edit.svg)，輸入帳戶全名。

#### 修改密碼

1. 在控制中心首頁，單擊 ![account_normal](../common/account_normal.svg)。
2. 單擊目前帳戶。
3. 單擊 **變更密碼**，進入變更密碼頁面。
4. 輸入目前密碼、新的密碼和確認密碼，單擊 **儲存**。

#### 自動登入

開啟 **自動登入** 後， 下次啟動系統時（重新啟動、開機）可直接進入桌面。在鎖定螢幕和登出後再次登入需要密碼。

1. 在控制中心首頁，單擊![account_normal](../common/account_normal.svg)。
2. 單擊目前帳戶。
3. 打開 **自動登入** 開關，在彈出的授權對話框中輸入目前帳戶密碼並確定後，開啟自動登入功能。



#### 設定密碼有效期

1. 在控制中心首頁，單擊![account_normal](../common/account_normal.svg)。
2. 單擊目前帳戶。
3. 設定密碼有效期。可以設定為長期有效或設定一個具體天數。

>![notes](../common/notes.svg) 說明：密碼有效期自修改之日開始計算。

例如，使用者A在9月1日修改了密碼，並設定密碼有效期為30天。在這種情況下，該密碼可以在9月1日至9月30日這期間的30天正常使用。


#### 刪除帳戶

1. 在控制中心首頁，單擊 ![account_normal](../common/account_normal.svg)。
2. 單擊其他未登入的帳號。
3. 單擊 **刪除帳戶** 。
4. 在彈出的確認介面中單擊 **刪除**。

>![attention](../common/attention.svg) 注意: 已登入的帳戶無法被刪除。

#### 權限設定

支援添加管理員使用者、普通使用者、自訂使用者。

##### 設定組

添加或修改帳戶時，可以選擇系統內已有的組。

### 螢幕設定

設定顯示器的解析度、螢幕亮度、螢幕方向以及縮放倍數，讓您的電腦顯示到達最佳狀態。

![0|display](fig/eu_display.png)

#### 單屏設定

當螢幕為單屏時，可以調節螢幕亮度、解析度、重新整理率、顯示方向等。

##### 調節螢幕亮度

1. 在控制中心首頁，單擊 ![display_normal](../common/display_normal.svg)。
2. 在 **螢幕亮度** 區域，透過拖動滑塊調節螢幕亮度。



##### 設定螢幕縮放

當桌面和視窗顯示過大或過小時，您可能需要調節螢幕縮放，以便正常顯示。

1. 在控制中心首頁，單擊 ![display_normal](../common/display_normal.svg)。
2. 在螢幕縮放區域， 單擊或拖動滑塊調整縮放倍數。
3. 註銷後重新登入系統螢幕縮放操作即可生效。

>![notes](../common/notes.svg) 說明：
>   - 當檢測到螢幕為高分屏時，會自動調整縮放倍數。
>   - 部分應用不支援螢幕縮放，您可以在啟動器中右鍵單擊該應用，選擇 **禁用螢幕縮放**，以獲得更好的顯示效果。

##### 更改解析度

1. 在控制中心首頁，單擊 ![display_normal](../common/display_normal.svg)。
2. 在解析度區域的下拉選單中，選擇合適的解析度參數。
3. 單擊 **儲存**。

##### 設定刷新率

1. 在控制中心首頁，單擊 ![display_normal](../common/display_normal.svg)。
2. 在重新整理率區域的下拉選單中，選擇一個合適的刷新率。
3. 單擊 **儲存**。

##### 改變螢幕方向

1. 在控制中心首頁，單擊 ![display_normal](../common/display_normal.svg)。
2. 在方向區域的下拉選單中，選擇一個合適的方向參數，改變螢幕方向。
3. 單擊 **儲存**。

#### 多屏設定

多顯示器模式讓您的視野無限延伸！使用VGA、HDMI、EDP等線纜將您的電腦和另一台顯示器、投影機等連接起來，同時在多個螢幕顯示您電腦上的內容。

1. 在控制中心首頁，單擊 ![display_normal](../common/display_normal.svg)。
2. 在 **多屏設定** 區域，模式下拉框中選擇螢幕顯示樣式。

   - **同步顯示畫面**將主屏的顯示內容同步顯示到其他螢幕。
   - **延伸畫面** 將主屏的顯示內容延伸到其他螢幕，擴大桌面區域。
   - **僅 xxx 屏** 只在某個螢幕顯示內容。

在多顯示器環境下，按下 **Super** + **P**調出多顯示器模式的OSD。

詳細操作方法如下。

1. 按住 **Super** 不放，再按下 **P** 或滑鼠單擊來進行模式選擇。
2. 鬆開按鍵，確認選擇，模式生效。

>![notes](../common/notes.svg) 說明：當多屏顯示時：
>- 副屏也支援桌面圖示顯示、右鍵選單操作等功能。
>- 任務欄右鍵選單顯示 **多屏顯示設定**，多屏顯示設定包含 **僅主屏顯示**、**跟隨滑鼠位置顯示** 選項。


### 預設程式

當安裝有多個功能相似的應用程式時，可以選擇其中的一個應用程式作為對應文件類型的預設啟動程式。

![0|default](fig/eu_ccnavigation.png)

#### 設定預設程式

1. 右鍵單擊文件，選擇 **用其他程式開啟** > **選擇預設開啟程式**。
2. 選擇一個應用程式，自動勾選 **作為預設值**，單擊 **確定**。
3. 該應用程式將自動添加到控制中心的預設程式列表。

#### 更改預設程式

1. 在控制中心首頁，單擊 ![default_applications_normal](../common/default_applications_normal.svg)。
2. 選擇一個文件類型進入預設程式列表。
3. 在列表中選擇另一個應用程式。

#### 添加預設程式

1. 在控制中心首頁，單擊 ![default_applications_normal](../common/default_applications_normal.svg)。
2. 選擇文件類型進入預設程式列表。
3. 單擊列表下的 **添加預設程式** 按鈕![add](../common/add.svg)，選擇desktop文件（一般在/usr/share/applications)，或特定的二進位制文件。
4. 該程式將添加到列表，並自動設定為預設程式。

#### 刪除預設程式

在預設程式列表中，您只能刪除自己添加的應用程式，不能刪除系統已經安裝的應用程式。要刪除系統已經安裝的應用程式，只能移除應用程式。移除後該應用程式將自動從預設程式列表中刪除。

可用以下方法刪除自己添加的預設程式。

1. 在控制中心首頁，單擊 ![default_applications_normal](../common/default_applications_normal.svg)。
2. 選擇文件類型進入預設程式列表。
3. 單擊程式後面的![close](../common/close_normal.svg)，刪除預設程式。

### 個性化設定

在控制中心個性化設定模組可以進行一些通用的個性化設定，包括主題、強調色、字體，改變桌面和視窗的外觀。除此之外還可設定圖示主題、滑鼠主題和字型。

![p0|personalise](fig/eu_personalise.png)

#### 設定視窗主題

1. 在控制中心首頁，單擊 ![personalization_normal](../common/personalization_normal.svg)。
2. 單擊 **一般**，選擇一種視窗主題。
3. 該主題即為系統視窗主題。

>![notes](../common/notes.svg) 說明：自動主題表示根據目前時區的時間，根據日出日落的時間自動更換視窗主題。日出後是淺色，日落後是深色。

#### 更改強調色

強調色是指選中某一選項時的強調色。

1. 在控制中心首頁，單擊 ![personalization_normal](../common/personalization_normal.svg)。
2. 單擊 **一般**。
3. 單擊 **強調色** 下的一種顏色，可即時查看該顏色效果。


#### 設定圖示主題

1. 在控制中心首頁，單擊 ![personalization_normal](../common/personalization_normal.svg)。
2. 單擊 **圖示主題**，選擇一款圖示樣式。

#### 設定滑鼠主題

1. 在控制中心首頁，單擊 ![personalization_normal](../common/personalization_normal.svg)。
2. 單擊 **滑鼠主題**，選擇一款滑鼠樣式。

#### 更改系統字型

1. 在控制中心首頁，單擊 ![personalization_normal](../common/personalization_normal.svg)。
2. 單擊 **字型**，進入設定字型介面。
3. 設定系統文字大小和字型。

### 網路設定

登入系統後，您需要連接網路，才能接收郵件、瀏覽新聞、下載文件、聊天、網路上購物等。

>![tips](../common/tips.svg) 竅門：您可以單擊任務欄託盤區的網路圖示，查看目前網路狀態。

![0|network](fig/eu_network.png)

#### 有線網路

有線網路安全快速穩定，是最常見的網路連接方式。當您設定好路由器後，把網路線兩端分別插入電腦和路由器，即可連接有線網路。

1. 將網路線插入電腦上的網路插孔。
2. 將網路線的另一端插入路由器或網路埠。
3. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
4. 單擊 **有線網路**，進入有線網路設定介面。
5. 打開 **有線網路介面卡**，開啟有線網路連接功能。
6. 當網路連線成功後，桌面右上角將彈出 **已連接到有線連接網路** 的提示訊息。

您還可以在有線網路的設定介面，編輯或建立有線網路設定。

#### 無線網路

無線網路幫助您擺脫線纜的束縛，上網形式更加靈活，支援更多裝置使用。

##### 連接無線網路

1. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
2. 單擊 **無線網路**，進入無線網路設定介面。
3. 打開 **無線網路介面卡**，開啟無線網路連接功能。
4. 電腦會自動搜尋並顯示附近可用的無線網路。
5. 選擇需要連接的無線網路。

   - 如果該網路是開放的，將自動連接到此網路。
   - 如果該網路是加密的，請根據提示輸入密碼，單擊 **連線**，然後將自動完成連接。

##### 連接隱藏網路

為了防止他人掃描到自己的無線網路，進而破解無線網路密碼連接您的網路，您可以在路由器設定介面隱藏無線網路。設定後，您需要手動連接隱藏網路才能上網。

1. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
2. 單擊 **無線網路**，進入無線網路設定介面。
3. 單擊 **連線到隱藏網路**。
4. 輸入網路名稱、SSID和其他必填選項。
5. 單擊 **儲存** 。

#### 無線熱點

無線熱點將電腦連接的網路訊號轉換為無線網路熱點，以供一定距離內的其他裝置無線上網。要開啟無線熱點，電腦必須連接到網路並裝有支援熱點功能的無線網卡。

1. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
2. 單擊 **個人熱點**。
3. 打開 **熱點** 開關，設定熱點訊息。
4. 單擊 **儲存**。

#### 移動網路

當您處於一個沒有網路訊號的地方時，可以使用無線上網卡來上網。在有電話訊號覆蓋的任何地方，無線上網卡透過運營商的移動資料網路接入寬頻服務。

1. 將移動網卡插入電腦上的USB介面中。
2. 電腦將根據移動網卡和運營商訊息，自動適配並自動連接網路。
3. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
4. 單擊 **移動網路**，查看詳細設定訊息。

#### 撥號網路

撥號上網（DSL）是指透過本機電話撥號連接到網路的連接方式。配置好數據機，透過網路線連接數據機的網口和電腦的網口，建立寬頻撥號連接，輸入運營商提供的使用者名稱和密碼，即可撥號連接到Internet上。

##### 建立撥號連接

1. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
2. 單擊 **DSL**，單擊 **建立PPPoE連接** 按鈕 ![add](../common/add.svg)。
3. 輸入寬頻名稱、服務、密碼。
4. 單擊 **儲存**，系統自動建立寬頻連接並嘗試連接。

#### VPN

VPN即虛擬專用網路，其主要功能是在公用網路上建立專用網路，進行加密通訊。無論您是在外地出差還是在家中辦公，只要能上網就能利用VPN訪問企業的內網資源。您還可以使用VPN加速瀏覽其他國家的網站。

1. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
2. 單擊 **VPN**，選擇 **添加VPN** 按鈕 ![add](../common/add.svg) 或 **匯入VPN** 按鈕 ![import](../common/import.svg)。
3. 選擇VPN類型，並輸入名稱、閘道器、使用者名称、密碼等訊息。（匯入VPN會自動填充訊息）
4. 單擊 **儲存**，系統自動嘗試連接VPN網路。
5. 您可以將VPN設定匯出，備用或共享給其他使用者。

>![notes](../common/notes.svg) 說明：打開 **僅套用到相對應來源** 開關，可以不將VPN設定為預設路由，只在特定的網路資源上生效。

#### 系統代理伺服器

1. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
2. 單擊 **系統代理伺服器**，進入系統代理伺服器介面。
3. 開啟系統代理，在代理類型後的下拉框中選擇 **手動** 或 **自動**。

   - 單擊 **手動**，輸入代理伺服器的地址和連線埠訊息。
   - 單擊 **自動**，輸入URL，系統將自動配置代理伺服器的訊息。

4. 單擊 **儲存**。

#### 應用程式代理伺服器

1. 在控制中心首頁，單擊  ![network_normal](../common/network_normal.svg)。
2. 單擊 **應用程式代理伺服器**。
3. 設定應用程式代理伺服器參數。
4. 單擊 **儲存**。

>![notes](../common/notes.svg) 說明：應用程式代理伺服器設定成功後，打開啟動器，右鍵單擊應用程式圖示，可以選擇 **使用代理伺服器**。


#### 網路詳細資訊

在網路詳細資訊介面，您可以查看MAC、IP位址、閘道器和其他網路訊息。

1. 在控制中心首頁，單擊 ![network_normal](../common/network_normal.svg)。
2. 單擊 **網路詳細資訊**，進入網路詳細資訊介面。
3. 查看目前有線網路或無線網路的訊息。

### 通知設定

設定系統通知的勿擾模式，開啟或關閉某些應用程式的通知顯示。

![0|sound](fig/eu_notification.png)

#### 設定系統通知

設定系統通知的勿擾模式及是否在任務欄顯示通知圖示。

1. 在控制中心首頁，單擊 ![dcc_nav_notification_36px](../common/dcc_nav_notification_36px.svg)。

2. 單擊 **系統通知**，進入系統通知介面。

   - 開啟或關閉勿擾模式。
     當開啟勿擾模式後，可以設定勿擾模式的開啟時間、結束時間；也可以設定 **在螢幕鎖定螢幕時** 顯示通知。開啟勿擾模式可以使所有通知靜音，但您可以在通知中心查看所有消息。
   - 設定 **是否在任務欄顯示圖示**。

#### 設定應用程式通知

應用程式可以自設定個性化的通知顯示。

1. 在控制中心首頁，單擊 ![dcc_nav_notification_36px](../common/dcc_nav_notification_36px.svg)。
2. 在應用程式通知區域選擇開啟一個應用程式，在開啟的應用程式介面中，您可以勾選：
   - 通知時提示聲音
   - 鎖定螢幕時顯示消息
   - 在通知中心顯示
   - 顯示消息預覽

### 聲音設定

設定輸出和輸入設備（如設定揚聲器和麥克風），讓您聽得更舒適，錄音更清晰。

![0|sound](fig/eu_sound.png)

#### 輸出裝置

1. 在控制中心首頁，單擊 ![sound_normal](../common/sound_normal.svg)。
2. 單擊 **輸出**，進入輸出設備設定介面，您可以：

   - 透過拖曳滑塊調節輸出裝置音量和左/右聲道平衡。
   - 打開 **音量增強**，音量的可調節區間由0~100%轉變為0~150%。
   - 在輸出裝置後面的下拉框中選擇輸出裝置類型。
#### 輸入裝置

1. 在控制中心首頁，單擊 ![sound_normal](../common/sound_normal.svg)。
2. 單擊 **輸入**，進入輸入設備設定介面，您可以：

   - 透過拖曳滑塊調節輸入裝置音量。
   - 打開 **啟用** 開關，還可以設定 **噪音抑制** 功能。
   - 在輸入裝置後面的下拉框中選擇輸入裝置類型。
>![tips](../common/tips.svg) 竅門：通常，需要調大輸入音量，確保能夠聽到聲源的聲音，但是音量不宜過大，因為這會導致聲音失真。可以對著輸入設備以正常說話的音量講話，並觀察回饋音量的變化，變化較明顯，則說明輸入音量合適。

#### 系統音效

1. 在控制中心首頁，單擊 ![sound_normal](../common/sound_normal.svg)。
2. 單擊 **系統音效**，勾選選項，開啟某一事件發生時的聲音效果。

>![tips](../common/tips.svg) 竅門：您可以單擊試聽音效。

#### 裝置管理

1. 在控制中心首頁，單擊 ![sound_normal](../common/sound_normal.svg)。
2. 單擊 **裝置管理**，啟用/禁用輸入裝置、輸出裝置。

### 藍牙設定

藍牙能夠實現短距離的無線通信。透過藍牙與附近的其它藍牙裝置連接，而無需網路或連接線。常見的藍牙裝置包括：藍牙鍵盤、藍牙滑鼠、藍牙耳機、藍牙音響等。

![0|bluetooth](fig/eu_bluetooth.png)

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

>![notes](../common/notes.svg) 說明：大部分桌上型電腦都沒有配備藍牙，您可以購買藍牙適配器，插入到電腦中使用。

#### 修改藍牙名稱

1. 在控制中心首頁，單擊 ![bluetooth_normal](../common/bluetooth_normal.svg)。
2. 單擊藍牙名稱旁的 ![edit](../common/edit.svg)，輸入本機新的藍牙名稱。

>![notes](../common/notes.svg) 說明：修改藍牙名稱後，將自動對外廣播藍牙裝置的新名字，需要其他裝置重新進行搜尋。

#### 連接藍牙設備

1. 在控制中心首頁，單擊 ![bluetooth_normal](../common/bluetooth_normal.svg)。
2. 開啟 **藍牙**，系統將自動掃描附近的藍牙設備，並顯示在 **其他設備** 列表。
3. 單擊想連接的藍牙設備，在該設備上輸入藍牙配對碼（若需要），配對成功後將自動連接。
4. 連線成功後，藍牙設備會添加到 **我的設備** 列表中。
5. 在我的設備列表中單擊該設備，您可以 **斷開連線**，或修改設備名稱。

#### 使用藍牙傳送/接收文件

統信UOS PC與非統信UOS PC或者統信UOS PC與行動裝置（手機/平板）之間通過藍牙裝置傳送/接收文件。

前提條件：發送端藍牙裝置與接收端藍牙裝置已配對並連接成功。

**使用UOS PC端藍牙傳送文件**

場景：發送端（UOS PC）透過藍牙向接收端（非UOS PC/手機/平板）傳送文件。


1. 在控制中心首頁，單擊 ![bluetooth_normal](../common/bluetooth_normal.svg)。
2. 開啟 **藍牙**，系統將自動掃描附近的藍牙裝置。
3. 進入 **我的裝置** 選擇已配對連接的藍牙裝置，單擊進入詳情，單擊 **發送文件** 按鈕（pc/手機/平板藍牙裝置類型才具有該按鈕），在彈出的檔案管理器視窗中選擇要發送的文件，單擊 **打開**。
4. 在彈出的藍牙文件傳輸視窗中，選擇接收此文件的藍牙裝置，單擊 **發送**，發送傳輸文件請求。


**使用手機端藍牙傳送文件**

場景：發送端（以安卓手機為例）透過藍牙向接收端（統信UOS PC）傳送文件。

1. 開啟 **藍牙**，系統將自動掃描附近的藍牙裝置。
2. 選擇已配對並連線成功的藍牙裝置。
3. 在手機中選擇文件，單擊 **發送**，透過藍牙發送文件。

**使用藍牙接收文件**

發送端發送文件後，接收端彈出提示視窗，使用者可以單擊 **接受** 或 **拒絕** 文件。

   - 如果接收端藍牙裝置同意接收，則發送端開始傳輸文件並顯示發送文件視窗，文件傳輸完成後；接收端會彈出提示訊息，使用者可以查看接收成功的文件。
   - 如果接收端為如下情況，發送端部分文件傳輸失敗，會顯示在傳輸失敗列表。
      + 接收端藍牙裝置選擇拒絕，則結束傳輸，顯示傳輸失敗。
      + 接收端藍牙裝置超時未操作或超出傳輸範圍，則顯示傳輸失敗（藍牙裝置連線失敗）。
      + 接收端即不單擊接收也不單擊拒絕，預設1分鐘後則結束傳輸，顯示傳輸失敗。

### 時間日期

選擇正確的所在時區，即可在電腦上顯示所在地的時間和日期，也可以手動修改時間和日期。

![0|time](fig/eu_time.png)

#### 變更系統時區

在您安裝系統時，已選擇了系統時區。若要修改系統時區，請按如下步驟設定。

1. 在控制中心首頁，單擊 ![time](../common/time.svg)。
2. 單擊 **時區列表**。
3. 單擊 **變更系統時區**， 透過搜尋或單擊地圖選擇時區。
4. 單擊 **確認**。

#### 新增時區

您可以同時使用多個時區，以便查看另一時區的時間。

1. 在控制中心首頁，單擊 ![time](../common/time.svg)。
2. 單擊 **時區列表**。
3. 單擊 ![add](../common/add.svg)，透過搜尋或單擊地圖選擇時區。
4. 單擊 **新增**。

#### 刪除時區

1. 在控制中心首頁，單擊 ![time](../common/time.svg)。
2. 單擊 **時區列表**。
3. 單擊時區列表後面的 **編輯**。
4. 單擊 ![delete](../common/delete.svg)，刪除已添加的時區。

#### 修改時間和日期

預設情況下，系統透過網路自動同步該時區的本機時間和日期。您也可以關閉自動同步配置，手動修改時間和日期。
1. 在控制中心首頁，單擊 ![time](../common/time.svg)。
2. 單擊 **時間設定** 。
3. 關閉 **自動同步配置**。
4. 手動設定正確的時間和日期。
5. 單擊 **確定**。

>![notes](../common/notes.svg) 說明：您還可以打開 **自動同步配置**，設定伺服器同步參數。

#### 設定時間日期格式

系統支援即時設定時間日期的格式。

1. 在控制中心首頁，單擊 ![time](../common/time.svg)。
2. 單擊 **格式設定**，可以設定星期、長短日期、長短時間等格式。


### 電源管理

對系統電源進行一些設定，如設定顯示器的關閉時間、自動鎖定螢幕時間等。

![m0|power](fig/eu_power.png)





#### 設定顯示器關閉時間

1. 在控制中心首頁，單擊 ![power_normal](../common/power_normal.svg)。
2. 單擊 **使用外接電源** 或 **使用電池**。
3. 選擇關閉顯示器的時間。

>![notes](../common/notes.svg) 說明：筆記型電腦使用者可以在 **使用外接電源** 和 **使用電池** 下對同一設定項分別設定不同的時間。



#### 設定自動鎖定螢幕時間

1. 在控制中心首頁，單擊 ![power_normal](../common/power_normal.svg)。
2. 單擊 **使用外接電源** 或 **使用電池**。
3. 選擇自動鎖定螢幕的時間。



#### 設定按電源按鈕時顯示狀態

1. 在控制中心首頁，單擊 ![power_normal](../common/power_normal.svg)。
2. 單擊 **使用外接電源** 或 **使用電池**。
3. 選擇電源按鈕 **關機**、**待機**、**休眠**、**關閉顯示器** 或 **無任何操作**，更改電源設定。

更改設定後會即時生效，同時系統通知使用者已修改電源設定。

### 滑鼠

滑鼠是電腦常用的輸入裝置。使用滑鼠，可以使操作更加簡便快捷。在控制中心滑鼠設定模組，使用者可以對滑鼠進行設定，從而讓裝置使用體驗更加符合自己的使用習慣。

![0|mouse](fig/eu_mouse.png)

#### 一般設定

1. 在控制中心首頁，單擊 ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg)。
2. 單擊 **一般**。
3. 開啟 **按鍵左右對調**，調節滑鼠的 **捲動速度**、**連擊速度**。

>![notes](../common/notes.svg) 說明：開啟 **按鍵左右對調** 模式後，滑鼠的左右鍵功能互換。

#### 滑鼠設定

插入或連接滑鼠後，在控制中心進行相關設定，讓其更符合您的使用習慣。

1. 在控制中心首頁，單擊 ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg)。
2. 單擊 **滑鼠**。
3. 調節 **遊標移動速度**， 控制滑鼠移動時遊標移動的速度。
4. 單擊 **反向捲動**、**滑鼠加速度** 開關，開啟相應功能。

>![notes](../common/notes.svg) 說明：
>
>   - 開啟滑鼠加速度可提高遊標的精確度，滑鼠遊標在螢幕上的移動距離會根據移動速度的加快而增加。可以根據使用情況開啟或關閉。
>   - 反向捲動開啟後，滑鼠滾輪向下滾動，內容會向下滾動；滑鼠滾輪向上滾動，內容會向上滾動。

### 鍵盤和語言

在此模組，您可以設定鍵盤屬性，以便符合您的輸入習慣，還可以根據國家和語言調整鍵盤佈局，設定系統語言，以及自訂快捷鍵。

![0|keyboard](fig/eu_keyboard.png)

#### 鍵盤屬性

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **一般**。
3. 調節 **字元重複延遲**/**字元重複速度**。
4. 單擊 **在此測試**，按下鍵盤上的任意字元不鬆開，查看調節效果。
5. 單擊 **數字鍵盤**/**大寫鎖定提示** 開關，開啟相應功能。

#### 鍵盤佈局

設定鍵盤佈局，可以為目前語言自訂鍵盤。完成鍵盤佈局設定後，按下鍵盤上的按鍵時，螢幕上會按照鍵盤佈局設定好的字元進行顯示。更改鍵盤佈局後，螢幕上的字元可能與鍵盤按鍵上的字元不相符。 

一般在安裝系統時，就已經設定了鍵盤佈局，您也可以添加其他的鍵盤佈局。

![layout](fig/eu_layout.png)

##### 添加鍵盤佈局

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **鍵盤佈局**，進入鍵盤佈局介面。
3. 單擊 **添加** 按鈕 ![add](../common/add.svg)，單擊某一鍵盤佈局即可添加到列表。

##### 刪除鍵盤佈局

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **鍵盤佈局**，進入鍵盤佈局介面。
3. 單擊 **鍵盤佈局** 後的 **編輯**。
4. 單擊 ![delete](../common/delete.svg)，刪除該鍵盤佈局。

#### 輸入法

對輸入法進行設定，可以為系統提供更豐富的輸入方式。在輸入法介面可以添加多個輸入法，設定輸入法切換的快捷鍵，以便使用者選擇符合個人打字習慣的輸入方式。

##### 添加輸入法

您可以添加多個輸入法到輸入法管理列表，以便切換輸入法。

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **輸入法**，進入輸入法介面。
3. 單擊 **添加** 按鈕 ![add](../common/add.svg) ，您可以進入添加輸入法介面，選擇輸入法，將該輸入法添加到輸入法管理列表。

>![notes](../common/notes.svg) 說明： 在輸入法管理介面，單擊 **編輯**，單擊 **刪除** 按鈕![delete](../common/delete.svg)即可移除某輸入法。對於被移除（非移除）的輸入法，可以在添加輸入法介面進行添加。

##### 設定輸入法排序

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **輸入法**，進入輸入法介面。
3. 在輸入法管理區域，上下拖動輸入法或單擊輸入法後面的上下箭頭，進行排序。

##### 設定輸入法配置項

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **輸入法**，進入輸入法介面。
3. 在輸入法管理區域，單擊輸入法後面的 **設定** 按鈕 ![set1](../common/set1.svg)，設定輸入法自身的配置項。

##### 設定輸入法切換快捷鍵

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **輸入法**，進入輸入法介面。
3. 在快捷鍵區域，切換輸入法下列框中，選擇輸入法切換的快捷鍵。

>![notes](../common/notes.svg) 說明：輸入法切換快捷鍵設定成功後，當切換輸入法，自動切換為輸入法對應的鍵盤布局。選擇 **切換方式**， 讓切換後的鍵盤布局應用於整個系統或目前應用。

#### 系統語言

系統語言預設為安裝系統時所選擇的語言，可以隨時進行更改。在系統語言列表可以添加多個語言，以便切換系統語言。

##### 添加系統語言

您可以添加多個語言到系統語言列表，以便切換系統語言。

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **系統語言**，進入系統語言介面。
3. 單擊 **添加** 按鈕 ![add](../common/add.svg) 進入語言列表。
4. 選擇語言，該語言將自動添加到系統語言列表。

##### 設定系統語言

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **系統語言**，進入系統語言介面。
3. 選擇要切換的語言，系統將自動開始安裝語言包。
4. 語言包安裝完成後，需要登出後重新登入，以便讓設定生效。

>![attention](../common/attention.svg) 注意：更改系統語言後，鍵盤佈局可能也會發生改變。重新登入時，請確保使用正確的鍵盤佈局來輸入密碼。


#### 快捷鍵
快捷鍵列表顯示了系統所有的快捷鍵。您可以在這裡查看、修改和自訂快捷鍵。

![0|shortcut](fig/eu_shortcut.png)

##### 查看快捷鍵

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **快捷鍵**，進入快捷鍵設定介面。
3. 搜尋或查看預設的系統快捷鍵、視窗快捷鍵和工作區快捷鍵。

##### 修改快捷鍵

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **快捷鍵**，進入快捷鍵設定介面。
3. 單擊需要修改的快捷鍵。
4. 使用鍵盤輸入新的快捷鍵。

>![tips](../common/tips.svg) 竅門：若要禁用快捷鍵，請按下鍵盤上的 **Backspace** ![Backspace](../common/Backspace.svg) 鍵。若要取消修改快捷鍵，按下 **Esc** 鍵，或單擊下方的 **還原至預設值** 按鈕。

##### 自訂快捷鍵

您可以為常用的應用程式自訂一個快捷鍵。

1. 在控制中心首頁，單擊 ![keyboard_normal](../common/keyboard_normal.svg)。
2. 單擊 **快捷鍵**。
3. 單擊 **添加** 按鈕 ![add](../common/add.svg)，進入新增自訂快捷鍵介面。
4. 輸入快捷鍵名稱、命令和快捷鍵。
5. 單擊 **加入**。
6. 添加成功後，單擊 **自訂快捷鍵** 後的 **編輯**。
7. 單擊某個快捷鍵後 ![delete](../common/delete.svg)， 刪除自訂的快捷鍵。

>![tips](../common/tips.svg) 竅門：若要修改快捷鍵，單擊輸入新的快捷鍵即可。若要修改自訂快捷鍵的名稱和命令，單擊 **自訂快捷鍵** 後的 **編輯** ，單擊快捷鍵名稱後的 ![edit](../common/edit.svg)，進入修改頁面。

### 系統資訊

您可以查看系統版本、版本許可證和電腦硬體等訊息，以及該系統的一些協議。

![0|info](fig/eu_info.png)

#### 關於此電腦

1. 在控制中心首頁，單擊 ![system_info_normal](../common/system_info_normal.svg)。
2. 在 **關於此電腦** 下，您可以：
   - 單擊 ![edit](../common/edit.svg) 修改電腦名。
   - 查看目前系統版本、版本授權及電腦硬體訊息。
3. 若系統未啟用，可在此頁面單擊 **啟用**，進行系統啟用。

#### 版本許可證

1. 在控制中心首頁，單擊 ![system_info_normal](../common/system_info_normal.svg)。
2. 在 **版本許可證** 下，查看系統版本協議。

#### 最終使用者許可協議

1. 在控制中心首頁，單擊 ![system_info_normal](../common/system_info_normal.svg)。
2. 在 **最終使用者許可協議** 下，查看最終使用者許可協議。

#### 隱私政策
1. 在控制中心首頁，單擊 ![system_info_normal](../common/system_info_normal.svg)。
2. 在 **隱私政策** 下，查看隱私政策。

### 授權管理

授權管理是系統預裝的工具，幫助您啟用系統。

以下將從未啟用、啟用方式、啟用成功及啟用失敗這幾個方面進行介紹。

#### 未啟用

1. 執行授權管理工具有兩種方式：

   - 單擊右下角託盤區上的 ![authorize1](../common/uos1.svg) 進入介面。

   - 打開 **控制中心**，選擇 **系統資訊**，單擊 **關於此電腦**。可查看版本授權，單擊 **啟用** 進入頁面。

2. 未啟用狀態分為兩種：未啟用和過期未啟用。

   - 未啟用：介面包括產品名稱、產品版本和授權狀態訊息。

   - 過期未啟用：在截止時間內未啟用系統，介面包括產品名稱、產品版本、授權狀態、授權物件和截止日期訊息。

3. 可選擇啟用方式啟用系統。

>![notes](../common/notes.svg) 說明：如果系統未啟用，授權管理圖示 ![authorize1](../common/uos1.svg) 一直常駐在右下角託盤區，開機即顯示。

#### 啟用方式

授權管理啟用方式分線上啟用和離線啟用，而線上啟用方式包含試用期啟用、輸入序號、匯入啟用文件。

>![attention](../common/attention.svg) 注意：只有在試用期或被啟用成功的系統，才能正常使用統信UOS的所有功能，否則會有部分功能受到限制。

**線上啟用**

線上啟用的前提是系統網路連接正常。

試用期啟用

在線/離線場景下都是開機自動激活，每台裝置僅有一次試用期啟用機會，從啟用當天算起，有效期為180天。試用期間可使用系統全部功能。

1. 單擊右下角託盤區上的 ![authorize1](../common/uos1.svg) 進入介面。

![0|probation1](fig/eu_probation1.png)

2. 單擊 **試用期啟用**，跳轉到啟用介面。

3. 單擊 **立即啟用**，會彈出二次確認彈框，單擊 **確定**，彈出試用期啟用成功介面，任務欄圖示變為 ![authorize2](../common/uos2.svg)。
4. 在此介面，可查看試用到期時間等訊息，也可以選擇永久啟用系統。

   ![0|probation3](fig/eu_probation3.png)

輸入序號

1. 單擊右下角託盤區上的 ![authorize1](../common/uos1.svg) 進入介面。

2. 單擊 **輸入序號**，輸入或複製正確的序號，單擊 **立即啟用**。
   >![notes](../common/notes.svg) 說明：統信UOS既支援16位的序號，也支援25位的序號。

   ![0|activation_code1](fig/p_activation_code1.png)

3. 會彈出二次確認彈框，單擊 **確定**，彈出啟用成功介面。

匯入啟用文件

1. 單擊右下角託盤區上的 ![authorize1](../common/uos1.svg) 進入介面。

2. 單擊 **匯入啟用文件**，彈出檔案管理器，選擇.key格式的啟用文件。

![0|file_activation2](fig/p_activation_via_file2.png)

3. 選擇正確的文件，單擊 **立即啟用**。會彈出二次確認彈框，單擊 **確定**，彈出啟用成功介面。

**離線啟用**

離線啟用的前提是系統網路連接異常。

1. 選擇輸入序號或匯入授權文件啟用時，系統檢測網路連接異常，則跳轉到離線啟用介面。

2. 離線啟用介面顯示二維碼、序號、機器ID及離線啟用碼輸入框。

3. 手機掃描二維碼，手機端彈出啟用介面，介面顯示目前機器ID及序號。

4. 單擊 **立即啟用**，會彈出二次確認彈框，單擊 **確定**。

5. 跳轉到啟用成功介面，顯示機器ID、序號和離線啟用碼。

6. 手動將手機端的離線啟用碼輸入電腦端的離線啟用碼輸入框。

7. 單擊 **離線啟用**，跳轉到啟用成功介面。

#### 啟用成功

1. 啟用成功介面顯示產品名稱、產品版本和啟用方式等訊息。
   - 產品名稱：作業系統的名稱。
   - 產品版本：作業系統的版本。
   - 授權狀態：授權狀態分為未授權、已過期、已授權，啟用成功顯示已授權。
   - 授權物件：被授權的使用者名稱。
   - 啟用方式：啟用方式分為序號、啟用文件及離線啟用碼，根據實際活化方式體現。
   - 到期時間：超過了截止時間，系統會提醒授權即將到期。

   ![0|activation_code3](fig/eu_activation_code3.png)
2. 系統啟用成功後，右下角託盤區不再顯示授權管理圖示，可透過控制中心查看授權管理工具。



##### 更換序號

當系統啟用成功後，由於某些原因需要變更序號。

有且僅當滿足如下條件時，支援更換序號。

   - 僅授權狀態為已啟用時，支援序號更換。
   - 僅授權模式為OPEN時，支援序號更換。

更換序號操作步驟如下：

1. 在啟用詳情介面，單擊 **更換序號**。
2. 彈出更換序號提示框，單擊 **更換**。
3. 進入序號啟用介面，輸入新的序號。
4. 單擊 **立即啟用** 即可更換序號。

>![notes](../common/notes.svg) 說明：系統支援命令列 **uos-activator-cmd -c/-C** 更換序號，僅支援3次序號更換。

#### 啟用失敗

若啟用文件已使用或已失效，則會彈出啟用失敗介面。

#### 啟用伺服器設定

如果目前啟用伺服器崩潰了，透過授權管理工具，單擊 ![menu](../common/icon_menu.svg) 主選單中的設定，可以自訂新的啟用伺服器。