// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "llamacppmodelconfig.h"

#include <QFile>
#include <QJsonDocument>
#include <QJsonObject>

GLOBAL_USE_NAMESPACE

LlamacppModelConfig::LlamacppModelConfig(const QString &file)
{
    QFile f(file);
    if (f.open(QFile::ReadOnly)) {
        auto doc = QJsonDocument::fromJson(f.readAll());
        configs = doc.object().toVariantHash();
    }
}

QStringList LlamacppModelConfig::architectures() const
{
    return configs.value("architectures").toStringList();
}

QVariantHash LlamacppModelConfig::params() const
{
    return configs.value("params").value<QVariantHash>();
}
