// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef BACKENDLOADER_P_H
#define BACKENDLOADER_P_H

#include "backendloader.h"
#include "backendmetaobject.h"

#include <QPluginLoader>

GLOBAL_BEGIN_NAMESPACE

class BackendMetaObjectPrivate
{
public:
    explicit BackendMetaObjectPrivate(BackendMetaObject *parent);
    QSharedPointer<QPluginLoader> loader;
    QVariantHash extra;
    QJsonValue metaData(const QString &key) const;
private:
    BackendMetaObject *q;
};

class BackendLoaderPrivate
{
public:
    explicit BackendLoaderPrivate(BackendLoader *parent);
    QList<BackendMetaObjectPointer> sorted() const;
    void preload(BackendMetaObjectPointer mo);
    void checkRuntime(BackendMetaObjectPointer mo);
public:
    QStringList loadPaths;

    QList<BackendMetaObjectPointer> backends;
    QString fixedBackend() const;
    QString llamacppBackend() const;
    QString configPath() const;

private:
    BackendLoader *q;
};

GLOBAL_END_NAMESPACE


#endif // BACKENDLOADER_P_H
