# Document Viewer|deepin-reader|

## Overview

Document Viewer is a powerful and easy-to-use software built-in the system for opening and viewing files quickly, supporting operations such as adding bookmarks, adding notes, and highlighting some text. 


## Guide

You can run, close or create a shortcut of Document Viewer as follows. 


### Run Document Viewer

1. Click   ![deepin_launcher](../common/deepin_launcher.svg) in the lower left corner of the dock to enter launcher interface.
2. Locate  ![deepin_reader_24](../common/deepin_reader_24.svg) by scrolling up and down the mouse wheel or search “Document Viewer” in launcher, and click it to run.
3. Right-click ![deepin_reader_24](../common/deepin_reader_24.svg) to:

 - Select **Send to desktop** to create a shortcut on the desktop.
 - Select **Send to dock** to fix it onto the dock.
 - Select **Add to startup** to add it to startup. When the computer starts up, it runs automatically.




### Exit Document Viewer

- On Document Viewer interface, click![close_icon](../common/close_icon.svg) to exit. 
- Right-click ![deepin_reader_24](../common/deepin_reader_24.svg) on Dock and select  **Close All** to exit.
- On Document Viewer interface, click  ![icon_menu](../common/icon_menu.svg) and select  **Exit**.


### View Shortcut Keys

On Document Viewer interface, press  **Ctrl + Shift+ ?** to view all shortcut keys quickly, which helps you to use them skillfully and improves your working efficiency. 

![1|hotkey](fig/hotkey.png)


## Basic functions

Document Viewer realizes basic document management such as opening files, saving files, printing files, as well as managing tabs, bookmarks and notes. 


### Open files

Document Viewer supports PDF and DJVU formats. You can open a file by: 

- Dragging it directly into the interface or onto the icon. 
- Right-clicking it and selecting **Open with** > **Document Viewer**. After setting Document Viewer as the default program, you can open it by double-clicking it directly.

- Clicking **Select File** and selecting a file on Document Viewer interface.
- On Document Viewer interface, pressing **Ctrl+O** and selecting the file you want to open. 

### Save documents

To save the document that has been edited and modified, you can 

- Press **Ctrl+S** or click ![icon_menu](../common/icon_menu.svg) > **Save**.
- Press **Ctrl + Shift + S** or click ![icon_menu](../common/icon_menu.svg) > **Save as**.

### Print documents

To print you have to connect and configure a printer. 

1. Open a document in Document Viewer, right-click and select **Print**, or press **Ctrl  + P** to open the preview page.
2. In this previewing interface, you can preview and set the printing page. 
3. In this previewing interface, click **Advanced** to set the page size, print method and other parameters. 
4. Click **Print**  then the document will be sent to the printer for printing. 

![preview](fig/previewdoc1.png)

![pagesetup](fig/pageSetupdoc.png)



### Manage tabs

New tab

- Click ![icon_menu](../common/icon_menu.svg) > **New tab** to add a tab. 
- When there are two or more tabs, you will see ![add](../common/add.svg) button. And you can click it to add new tabs.

To switch/adjust tabs, you can:

- Drag within the window to adjust the sequence of tabs. 
- Click the ![previous](../common/previous.svg) or ![next](../common/next.svg)button to move left and right. 
- Scroll the mouse wheel to switch tabs automatically.  


Operations among windows

- Drag any tab to move it out of the current window and create a new one. 
- Drag a tab from one window to another. 

  

### Manage bookmarks

On Document Viewer interface, open a file. 

- Add bookmark:
   - Right-click any page in Document Viewer, select **Add bookmark** to mark this page. 
   - Move the cursor to the top right corner of the page until ![view](../common/bookmark.svg) appears, click this icon to add a bookmark for this page, and this icon will be filled in blue ![view](../common/bookmarkbig_checked_light.svg).
- Delete bookmark:
   - Right-click the bookmark and select **Remove bookmark**. 
   - Click the colored bookmark icon ![view](../common/bookmarkbig_checked_light.svg) to cancel/delete the bookmark.

> ![notes](../common/notes.svg)Notes: The bookmark icon appears only when the cursor moves to the bookmark area, and it disappears when the cursor moves out of the area. When a bookmark is added successfully, the icon would be displayed always.

### Manage annotation

On Document Viewer interface, open a file. 

- Add annotation

   - Select text using the selecting tool and right-click, select **Add annotation**. The selected text will be highlighted after the annotation is added successfully.
   - Right-click at any blank area or the place you want to add an annotation and select **Add annotation**. After a note is successfully added, a highlighted note icon appears.
     
      > ![notes](../common/notes.svg)Notes: 
      > - Click in any blank area outside the window without inputing any content, then the note is not added successfully or is deleted automatically. 
      > - Click in any blank area outside the window after inputing some content, the content will be saved automatically. 

- Copy note
   - Right-click the highlighted text to which a note is successfully added and select **Copy**.
   - Right-click the note icon, select **Copy**.
   - Click![menu](../common/thumbnail_normal_light.svg) and the catalog icon ![view](../common/comments_normal_light.svg) on the left and select a note, right-click and select **Copy**. 
   
- Show note  
   1. Hove the cursor over the note icon to show the content. 
   2. Click the note icon to pop up a window, you can view and re-edit. 

- Delete note 
   - Right-click the highlighted text to which you have added a note, and select **Remove highlight**. 
   - Right-click the note icon and select **Remove annotation**. 
   - Click the catalog icon ![view](../common/comments_normal_light.svg) on the left column, and select a note, right-click to select **Remove annotation**, this note is deleted and so is its content. 

   > ![notes](../common/notes.svg)Notes: 
   > + You can move the note icon in the current page.
   > + You can not add annotations to DJVU files.

## Common operations

Document Viewer integrates many features to make document management simpler and more efficient. 

### Search
This function is only applicable for the current tab.
1. On Document Viewer interface, open a file. 
2. Right-click and select **Search** or press **Ctrl**+**F** to open a searching window. 
   
3. In the searching box, you can click ![search](../common/search.svg) to input keywords. 
   
4. Press  **Enter** to locate quickly. 
   - All matching information will be displayed in a list and are highlighted in the document.
   - If searching fails, "No search results" will be displayed. 
   
5.  When matching results are found, click![search](../common/previousup.svg) or ![search](../common/nextdown.svg) to view results one by one. 

6. Click one result, you can skip to the page where it's located, and it's highlighted. 
> ![attention](../common/attention.svg)Attention: Searching fails in case the text is coded in pictures in some PDF files. 

7. Clear up words in the searching box to clear up all results. 

> ![notes](../common/notes.svg)Notes: You can not search in DJVU files.



### Flip pages quickly 

To move from page to page quickly, you can: 

- Right-click and select **Previous page** or **Next page**. 
- To go the beginning or the end of the file, you can right-click and select **First page** or **Last page**. 
- Press ![Down](../common/Down.svg)  or ![Up](../common/Up.svg) on the keyboard. 
- Input the page number and press **Enter** key. 


### Switch catalog 

Using thumbnails you can switch file thumbnails catalog![view](../common/view_normal.svg), file catalog![catalog](../common/catalog.svg), bookmark catalog![view](../common/bookmark_normal.svg) and annotation catalog![view](../common/comments_normal_light.svg). 

### Fullscreen

1. On Document Viewer interface, right-click and select **Fullscreen** or press shortcut key **F11**.
2. Move the cursor to the top or the left part of the window to call out the top tool bar or the left tool bar. Otherwise, the tool bar will be hidden.
3. After you call out the side tool bar under **Fullscreen** mode, click ![icon](../common/thumbnail_normal_light.svg) to keep it shown.
4. Press **Esc** or **F11** key to exit **Fullscreen** mode.

### Slide show

1. On Document Viewer interface, right-click and select **Slide show** to display the file as slides. 
3. Click![play](../common/previous.svg)or![play](../common/next.svg) to switch pages, or click ![play](../common/suspend_normal.svg)to pause. 
4. Press **Esc** key to exit. 

### Zoom in and out

On Document Viewer interface, to zoom in or out a page, you can:

- Press **Ctrl +“+”**  or **Ctrl +“-”** .
- Press **Ctrl** and scroll the mouse wheel up and down at the same time. 
- Click "**+**"  or  "**-**" in the title bar. 
- Manual input the display percentage in the title bar or select one from the drop-down box of the menu bar, according to which the file is zoomed in and out.



### Adjust view

In the scaling drop-down box of tool bar, you can:

- Click **Two-page View** to view two pages at a time. 
- Click **1:1 size** to display the file in 100% ratio.
- Click **Fit Page** to display a whole page in the current window.
- Click **Fit Height** to display the page in the window fully in vertical direction. 
- Click **Fit Width**  to display the page in the window fully in horizontal direction.

### Highlight

1. On Document Viewer interface, select some text and right-click, select **Highlight**, there are several colors for you to choose. 

2. Select a color, the text selected will be highlighted in that color. 

3. Select the highlighted text, click **Remove highlight** to restore it to the status it was. 

> ![notes](../common/notes.svg)Notes: 
>
> - Document Viewer memorizes the color choice of the user, which will be the default color used when the user highlights any text the next time.  
> - You can not highlight in DJVU files.



### Rotate

1. On Document Viewer interface, open a document. 
2. Right-click and select **Rotate Left** or **Rotate Right** from the submenu, the page will rotate to the left or right by 90°. 



### Document info
1. On Document Viewer interface, open a document. 
2. Right-click and select **Document info** to check the relevant information such as properties about the document.

## Main Menu

In the main menu, you can create new window and new tabs, [save documents](#Save documents), [search](#Search), switch themes, view help to know more about Document Viewer. 

### Display in file manager

1. Click ![icon_menu](../common/icon_menu.svg) on the main interface.
2. Click **Display in file manager** to open and show the file's storing location in File Manager. 

### Magnifier 

1. On Document Viewer interface, open a document. 
2. Click![icon_menu](../common/icon_menu.svg) >  **Magnifier**.
3. Move the cursor to the area you want to view to magnify. 
4. Press **Esc** or right-click to cancel magnifying. 

### Tools

1. Click ![icon_menu](../common/icon_menu.svg) on the main interface.
2. Select **Tools** to switch from two tools.
   - Click **Select Text** to select text.
   - Click **Hand Tool** to move the document.

### Theme

There are options including light theme, dark theme and system theme. 

   1. Click ![icon_menu](../common/icon_menu.svg) on the main interface.
   2. Click **Theme** to select one.

### Help

Select **Help** to get the manual, which will help you further know and use Document Viewer.

   1. Click ![icon_menu](../common/icon_menu.svg) on the main interface.
   2. Click **Help** to view the manual.


### About

1. Click ![icon_menu](../common/icon_menu.svg) on the main interface.
2. Click **About** to view version information and introduction about Document Viewer. 

### Exit

1. Click ![icon_menu](../common/icon_menu.svg) on the main interface.
2. Click  **Exit**.

