/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;

public class BinaryResource
implements Resource {
    private final String href;
    private final String contentType;
    private byte[] data;
    private URLConnection connection = null;
    public static final ResourceFactory FACTORY = (context, details) -> new BinaryResource(details);

    public BinaryResource(AbstractResourceCollection.InputDetails in) {
        this.contentType = in.contentType;
        this.href = in.resourceUri;
        this.data = in.binaryContent;
    }

    public BinaryResource(String href, String contentType, byte[] content) {
        this.contentType = contentType;
        this.href = href;
        this.data = content;
    }

    public static byte[] encode(String s2, String encoding) throws XPathException {
        CharsetEncoder encoder;
        try {
            encoder = Charset.forName(encoding).newEncoder();
        }
        catch (Exception e) {
            throw new XPathException("Unsupported encoding " + encoding);
        }
        encoder.onMalformedInput(CodingErrorAction.REPORT);
        CharBuffer in = CharBuffer.wrap(s2);
        ByteBuffer out = null;
        try {
            out = encoder.encode(in);
        }
        catch (MalformedInputException e) {
            BinaryResource.error("Malformed input in encoding:" + e);
        }
        catch (UnmappableCharacterException e) {
            BinaryResource.error("Unmappable input in encoding:" + e);
        }
        catch (CharacterCodingException e) {
            BinaryResource.error("Character code problem in encoding:" + e);
        }
        byte[] data = new byte[out.limit()];
        System.arraycopy(out.array(), 0, data, 0, out.limit());
        return data;
    }

    public static String decode(byte[] value, String encoding) throws XPathException {
        return BinaryResource.decode(value, 0, value.length, encoding);
    }

    public static String decode(byte[] value, int offset, int len, String encoding) throws XPathException {
        CharsetDecoder decoder;
        try {
            decoder = Charset.forName(encoding).newDecoder();
        }
        catch (Exception e) {
            throw new XPathException("Unsupported encoding " + encoding);
        }
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        ByteBuffer in = ByteBuffer.wrap(value, offset, len);
        char[] outChars = new char[len];
        CharBuffer out = CharBuffer.wrap(outChars);
        CoderResult res = decoder.decode(in, out, true);
        if (res.isError()) {
            if (res.isMalformed()) {
                BinaryResource.error("Malformed input found when decoding binary resource");
            }
            if (res.isUnmappable()) {
                BinaryResource.error("Unmappable input found when decoding binary resource");
            }
            BinaryResource.error("Other error when decoding binary resource");
        }
        char[] resChars = new char[out.position()];
        System.arraycopy(outChars, 0, resChars, 0, out.position());
        return new String(resChars);
    }

    public static void error(String message) throws XPathException {
        throw new XPathException(message);
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getResourceURI() {
        return this.href;
    }

    private byte[] readBinaryFromConn(URLConnection con) throws XPathException {
        InputStream raw = null;
        this.connection = con;
        try {
            raw = this.connection.getInputStream();
            long contentLength = this.connection.getContentLengthLong();
            if (contentLength > Integer.MAX_VALUE) {
                throw new XPathException("Cannot handle binary resources longer than 2G octets");
            }
            BufferedInputStream in = new BufferedInputStream(raw);
            if (contentLength < 0L) {
                byte[] result = BinaryResource.readBinaryFromStream(in, this.connection.getURL().getPath());
                ((InputStream)in).close();
                return result;
            }
            byte[] data = new byte[(int)contentLength];
            int bytesRead = 0;
            int offset = 0;
            while ((long)offset < contentLength && (bytesRead = ((InputStream)in).read(data, offset, data.length - offset)) != -1) {
                offset += bytesRead;
            }
            ((InputStream)in).close();
            if ((long)offset != contentLength) {
                throw new XPathException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
            return data;
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static byte[] readBinaryFromStream(InputStream in, String path) throws XPathException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new XPathException("Failed to read: " + path + " " + e);
        }
    }

    @Override
    public Base64BinaryValue getItem() throws XPathException {
        if (this.data != null) {
            return new Base64BinaryValue(this.data);
        }
        if (this.connection != null) {
            this.data = this.readBinaryFromConn(this.connection);
            return new Base64BinaryValue(this.data);
        }
        try {
            this.connection = ResourceLoader.urlConnection(new URI(this.href).toURL());
            this.data = this.readBinaryFromConn(this.connection);
            return new Base64BinaryValue(this.data);
        }
        catch (IOException | URISyntaxException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

