# modified from https://shiny.rstudio.com/articles/progress.html

library(cli)

# !!! You don't need these in real code.
# cli.progress_show_after makes sure that we see the progress bar from
# the beginning, not only after a delay.
options(cli.progress_show_after = 0)

# !!! You don't need this in real code.
options(cli.progress_handlers_only = "shiny")

server <- function(input, output) {
  output$plot <- renderPlot({
    input$goPlot # Re-run when button is clicked

    # Create 0-row data frame which will be used to store data
    dat <- data.frame(x = numeric(0), y = numeric(0))

    # Number of times we'll go through the loop
    n <- 10

    cli_progress_bar(total = n, "Rendering plot")
    for (i in 1:n) {
      # Each time through the loop, add another row of data. This is
      # a stand-in for a long-running computation.
      dat <- rbind(dat, data.frame(x = rnorm(1), y = rnorm(1)))

      cli_progress_update(status = paste("Doing part", i))

      # Pause for 0.5 seconds to simulate a long computation.
      # Produce some extra output
      Sys.sleep(0.5)
      msg <- paste(strwrap(cli:::lorem_ipsum(1, 1)), collapse = "\n")
      if (i != n) cli_progress_output(msg)
      Sys.sleep(0.5)
    }

    plot(dat$x, dat$y)
  })
}

ui <- shinyUI(basicPage(
  plotOutput('plot', width = "300px", height = "300px"),
  actionButton('goPlot', 'Go plot')
))

shinyApp(ui = ui, server = server)
