// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Buildable, CellArea, CellLayout, TreeIter, TreeModel};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkEntryCompletion")]
    pub struct EntryCompletion(Object<ffi::GtkEntryCompletion, ffi::GtkEntryCompletionClass>) @implements Buildable, CellLayout;

    match fn {
        type_ => || ffi::gtk_entry_completion_get_type(),
    }
}

impl EntryCompletion {
    pub const NONE: Option<&'static EntryCompletion> = None;

    #[doc(alias = "gtk_entry_completion_new")]
    pub fn new() -> EntryCompletion {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_entry_completion_new()) }
    }

    #[doc(alias = "gtk_entry_completion_new_with_area")]
    #[doc(alias = "new_with_area")]
    pub fn with_area(area: &impl IsA<CellArea>) -> EntryCompletion {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_entry_completion_new_with_area(
                area.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`EntryCompletion`] objects.
    ///
    /// This method returns an instance of [`EntryCompletionBuilder`](crate::builders::EntryCompletionBuilder) which can be used to create [`EntryCompletion`] objects.
    pub fn builder() -> EntryCompletionBuilder {
        EntryCompletionBuilder::new()
    }
}

impl Default for EntryCompletion {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`EntryCompletion`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct EntryCompletionBuilder {
    builder: glib::object::ObjectBuilder<'static, EntryCompletion>,
}

impl EntryCompletionBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn cell_area(self, cell_area: &impl IsA<CellArea>) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-area", cell_area.clone().upcast()),
        }
    }

    pub fn inline_completion(self, inline_completion: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("inline-completion", inline_completion),
        }
    }

    pub fn inline_selection(self, inline_selection: bool) -> Self {
        Self {
            builder: self.builder.property("inline-selection", inline_selection),
        }
    }

    pub fn minimum_key_length(self, minimum_key_length: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("minimum-key-length", minimum_key_length),
        }
    }

    pub fn model(self, model: &impl IsA<TreeModel>) -> Self {
        Self {
            builder: self.builder.property("model", model.clone().upcast()),
        }
    }

    pub fn popup_completion(self, popup_completion: bool) -> Self {
        Self {
            builder: self.builder.property("popup-completion", popup_completion),
        }
    }

    pub fn popup_set_width(self, popup_set_width: bool) -> Self {
        Self {
            builder: self.builder.property("popup-set-width", popup_set_width),
        }
    }

    pub fn popup_single_match(self, popup_single_match: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("popup-single-match", popup_single_match),
        }
    }

    pub fn text_column(self, text_column: i32) -> Self {
        Self {
            builder: self.builder.property("text-column", text_column),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`EntryCompletion`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> EntryCompletion {
        self.builder.build()
    }
}

pub trait EntryCompletionExt: 'static {
    #[doc(alias = "gtk_entry_completion_complete")]
    fn complete(&self);

    #[doc(alias = "gtk_entry_completion_compute_prefix")]
    fn compute_prefix(&self, key: &str) -> Option<glib::GString>;

    #[doc(alias = "gtk_entry_completion_delete_action")]
    fn delete_action(&self, index_: i32);

    #[doc(alias = "gtk_entry_completion_get_completion_prefix")]
    #[doc(alias = "get_completion_prefix")]
    fn completion_prefix(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_entry_completion_get_inline_completion")]
    #[doc(alias = "get_inline_completion")]
    fn is_inline_completion(&self) -> bool;

    #[doc(alias = "gtk_entry_completion_get_inline_selection")]
    #[doc(alias = "get_inline_selection")]
    fn is_inline_selection(&self) -> bool;

    #[doc(alias = "gtk_entry_completion_get_minimum_key_length")]
    #[doc(alias = "get_minimum_key_length")]
    fn minimum_key_length(&self) -> i32;

    #[doc(alias = "gtk_entry_completion_get_model")]
    #[doc(alias = "get_model")]
    fn model(&self) -> Option<TreeModel>;

    #[doc(alias = "gtk_entry_completion_get_popup_completion")]
    #[doc(alias = "get_popup_completion")]
    fn is_popup_completion(&self) -> bool;

    #[doc(alias = "gtk_entry_completion_get_popup_set_width")]
    #[doc(alias = "get_popup_set_width")]
    fn is_popup_set_width(&self) -> bool;

    #[doc(alias = "gtk_entry_completion_get_popup_single_match")]
    #[doc(alias = "get_popup_single_match")]
    fn is_popup_single_match(&self) -> bool;

    #[doc(alias = "gtk_entry_completion_get_text_column")]
    #[doc(alias = "get_text_column")]
    fn text_column(&self) -> i32;

    #[doc(alias = "gtk_entry_completion_insert_action_markup")]
    fn insert_action_markup(&self, index_: i32, markup: &str);

    #[doc(alias = "gtk_entry_completion_insert_action_text")]
    fn insert_action_text(&self, index_: i32, text: &str);

    #[doc(alias = "gtk_entry_completion_insert_prefix")]
    fn insert_prefix(&self);

    #[doc(alias = "gtk_entry_completion_set_inline_completion")]
    fn set_inline_completion(&self, inline_completion: bool);

    #[doc(alias = "gtk_entry_completion_set_inline_selection")]
    fn set_inline_selection(&self, inline_selection: bool);

    #[doc(alias = "gtk_entry_completion_set_match_func")]
    fn set_match_func<P: Fn(&EntryCompletion, &str, &TreeIter) -> bool + 'static>(&self, func: P);

    #[doc(alias = "gtk_entry_completion_set_minimum_key_length")]
    fn set_minimum_key_length(&self, length: i32);

    #[doc(alias = "gtk_entry_completion_set_model")]
    fn set_model(&self, model: Option<&impl IsA<TreeModel>>);

    #[doc(alias = "gtk_entry_completion_set_popup_completion")]
    fn set_popup_completion(&self, popup_completion: bool);

    #[doc(alias = "gtk_entry_completion_set_popup_set_width")]
    fn set_popup_set_width(&self, popup_set_width: bool);

    #[doc(alias = "gtk_entry_completion_set_popup_single_match")]
    fn set_popup_single_match(&self, popup_single_match: bool);

    #[doc(alias = "gtk_entry_completion_set_text_column")]
    fn set_text_column(&self, column: i32);

    #[doc(alias = "cell-area")]
    fn cell_area(&self) -> Option<CellArea>;

    #[doc(alias = "action-activated")]
    fn connect_action_activated<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-on-match")]
    fn connect_cursor_on_match<
        F: Fn(&Self, &TreeModel, &TreeIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "insert-prefix")]
    fn connect_insert_prefix<F: Fn(&Self, &str) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "match-selected")]
    fn connect_match_selected<
        F: Fn(&Self, &TreeModel, &TreeIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "no-matches")]
    fn connect_no_matches<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "inline-completion")]
    fn connect_inline_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "inline-selection")]
    fn connect_inline_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "minimum-key-length")]
    fn connect_minimum_key_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "model")]
    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "popup-completion")]
    fn connect_popup_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "popup-set-width")]
    fn connect_popup_set_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "popup-single-match")]
    fn connect_popup_single_match_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "text-column")]
    fn connect_text_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<EntryCompletion>> EntryCompletionExt for O {
    fn complete(&self) {
        unsafe {
            ffi::gtk_entry_completion_complete(self.as_ref().to_glib_none().0);
        }
    }

    fn compute_prefix(&self, key: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_entry_completion_compute_prefix(
                self.as_ref().to_glib_none().0,
                key.to_glib_none().0,
            ))
        }
    }

    fn delete_action(&self, index_: i32) {
        unsafe {
            ffi::gtk_entry_completion_delete_action(self.as_ref().to_glib_none().0, index_);
        }
    }

    fn completion_prefix(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_entry_completion_get_completion_prefix(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_inline_completion(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_completion_get_inline_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_inline_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_completion_get_inline_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn minimum_key_length(&self) -> i32 {
        unsafe { ffi::gtk_entry_completion_get_minimum_key_length(self.as_ref().to_glib_none().0) }
    }

    fn model(&self) -> Option<TreeModel> {
        unsafe {
            from_glib_none(ffi::gtk_entry_completion_get_model(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_popup_completion(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_completion_get_popup_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_popup_set_width(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_completion_get_popup_set_width(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_popup_single_match(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_entry_completion_get_popup_single_match(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn text_column(&self) -> i32 {
        unsafe { ffi::gtk_entry_completion_get_text_column(self.as_ref().to_glib_none().0) }
    }

    fn insert_action_markup(&self, index_: i32, markup: &str) {
        unsafe {
            ffi::gtk_entry_completion_insert_action_markup(
                self.as_ref().to_glib_none().0,
                index_,
                markup.to_glib_none().0,
            );
        }
    }

    fn insert_action_text(&self, index_: i32, text: &str) {
        unsafe {
            ffi::gtk_entry_completion_insert_action_text(
                self.as_ref().to_glib_none().0,
                index_,
                text.to_glib_none().0,
            );
        }
    }

    fn insert_prefix(&self) {
        unsafe {
            ffi::gtk_entry_completion_insert_prefix(self.as_ref().to_glib_none().0);
        }
    }

    fn set_inline_completion(&self, inline_completion: bool) {
        unsafe {
            ffi::gtk_entry_completion_set_inline_completion(
                self.as_ref().to_glib_none().0,
                inline_completion.into_glib(),
            );
        }
    }

    fn set_inline_selection(&self, inline_selection: bool) {
        unsafe {
            ffi::gtk_entry_completion_set_inline_selection(
                self.as_ref().to_glib_none().0,
                inline_selection.into_glib(),
            );
        }
    }

    fn set_match_func<P: Fn(&EntryCompletion, &str, &TreeIter) -> bool + 'static>(&self, func: P) {
        let func_data: Box_<P> = Box_::new(func);
        unsafe extern "C" fn func_func<
            P: Fn(&EntryCompletion, &str, &TreeIter) -> bool + 'static,
        >(
            completion: *mut ffi::GtkEntryCompletion,
            key: *const libc::c_char,
            iter: *mut ffi::GtkTreeIter,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let completion = from_glib_borrow(completion);
            let key: Borrowed<glib::GString> = from_glib_borrow(key);
            let iter = from_glib_borrow(iter);
            let callback: &P = &*(user_data as *mut _);
            (*callback)(&completion, key.as_str(), &iter).into_glib()
        }
        let func = Some(func_func::<P> as _);
        unsafe extern "C" fn func_notify_func<
            P: Fn(&EntryCompletion, &str, &TreeIter) -> bool + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(func_notify_func::<P> as _);
        let super_callback0: Box_<P> = func_data;
        unsafe {
            ffi::gtk_entry_completion_set_match_func(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    fn set_minimum_key_length(&self, length: i32) {
        unsafe {
            ffi::gtk_entry_completion_set_minimum_key_length(
                self.as_ref().to_glib_none().0,
                length,
            );
        }
    }

    fn set_model(&self, model: Option<&impl IsA<TreeModel>>) {
        unsafe {
            ffi::gtk_entry_completion_set_model(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_popup_completion(&self, popup_completion: bool) {
        unsafe {
            ffi::gtk_entry_completion_set_popup_completion(
                self.as_ref().to_glib_none().0,
                popup_completion.into_glib(),
            );
        }
    }

    fn set_popup_set_width(&self, popup_set_width: bool) {
        unsafe {
            ffi::gtk_entry_completion_set_popup_set_width(
                self.as_ref().to_glib_none().0,
                popup_set_width.into_glib(),
            );
        }
    }

    fn set_popup_single_match(&self, popup_single_match: bool) {
        unsafe {
            ffi::gtk_entry_completion_set_popup_single_match(
                self.as_ref().to_glib_none().0,
                popup_single_match.into_glib(),
            );
        }
    }

    fn set_text_column(&self, column: i32) {
        unsafe {
            ffi::gtk_entry_completion_set_text_column(self.as_ref().to_glib_none().0, column);
        }
    }

    fn cell_area(&self) -> Option<CellArea> {
        glib::ObjectExt::property(self.as_ref(), "cell-area")
    }

    fn connect_action_activated<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn action_activated_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P, i32) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            index: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                EntryCompletion::from_glib_borrow(this).unsafe_cast_ref(),
                index,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"action-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    action_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_on_match<
        F: Fn(&Self, &TreeModel, &TreeIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn cursor_on_match_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P, &TreeModel, &TreeIter) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                EntryCompletion::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(model),
                &from_glib_borrow(iter),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cursor-on-match\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cursor_on_match_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_prefix<F: Fn(&Self, &str) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn insert_prefix_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P, &str) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            prefix: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                EntryCompletion::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(prefix),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-prefix\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    insert_prefix_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_match_selected<
        F: Fn(&Self, &TreeModel, &TreeIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn match_selected_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P, &TreeModel, &TreeIter) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                EntryCompletion::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(model),
                &from_glib_borrow(iter),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"match-selected\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    match_selected_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_no_matches<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn no_matches_trampoline<P: IsA<EntryCompletion>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkEntryCompletion,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"no-matches\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    no_matches_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_inline_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_inline_completion_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::inline-completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_inline_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_inline_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_inline_selection_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::inline-selection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_inline_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_minimum_key_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_minimum_key_length_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::minimum-key-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_minimum_key_length_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::model\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_model_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_popup_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_popup_completion_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::popup-completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_popup_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_popup_set_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_popup_set_width_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::popup-set-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_popup_set_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_popup_single_match_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_popup_single_match_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::popup-single-match\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_popup_single_match_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_text_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_column_trampoline<
            P: IsA<EntryCompletion>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkEntryCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(EntryCompletion::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for EntryCompletion {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("EntryCompletion")
    }
}
