// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Buildable, SizeGroupMode, Widget};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkSizeGroup")]
    pub struct SizeGroup(Object<ffi::GtkSizeGroup, ffi::GtkSizeGroupClass>) @implements Buildable;

    match fn {
        type_ => || ffi::gtk_size_group_get_type(),
    }
}

impl SizeGroup {
    pub const NONE: Option<&'static SizeGroup> = None;

    #[doc(alias = "gtk_size_group_new")]
    pub fn new(mode: SizeGroupMode) -> SizeGroup {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_size_group_new(mode.into_glib())) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SizeGroup`] objects.
    ///
    /// This method returns an instance of [`SizeGroupBuilder`](crate::builders::SizeGroupBuilder) which can be used to create [`SizeGroup`] objects.
    pub fn builder() -> SizeGroupBuilder {
        SizeGroupBuilder::new()
    }
}

impl Default for SizeGroup {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SizeGroup`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SizeGroupBuilder {
    builder: glib::object::ObjectBuilder<'static, SizeGroup>,
}

impl SizeGroupBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn mode(self, mode: SizeGroupMode) -> Self {
        Self {
            builder: self.builder.property("mode", mode),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SizeGroup`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SizeGroup {
        self.builder.build()
    }
}

pub trait SizeGroupExt: 'static {
    #[doc(alias = "gtk_size_group_add_widget")]
    fn add_widget(&self, widget: &impl IsA<Widget>);

    #[doc(alias = "gtk_size_group_get_mode")]
    #[doc(alias = "get_mode")]
    fn mode(&self) -> SizeGroupMode;

    #[doc(alias = "gtk_size_group_get_widgets")]
    #[doc(alias = "get_widgets")]
    fn widgets(&self) -> Vec<Widget>;

    #[doc(alias = "gtk_size_group_remove_widget")]
    fn remove_widget(&self, widget: &impl IsA<Widget>);

    #[doc(alias = "gtk_size_group_set_mode")]
    fn set_mode(&self, mode: SizeGroupMode);

    #[doc(alias = "mode")]
    fn connect_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<SizeGroup>> SizeGroupExt for O {
    fn add_widget(&self, widget: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_size_group_add_widget(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
            );
        }
    }

    fn mode(&self) -> SizeGroupMode {
        unsafe { from_glib(ffi::gtk_size_group_get_mode(self.as_ref().to_glib_none().0)) }
    }

    fn widgets(&self) -> Vec<Widget> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_size_group_get_widgets(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn remove_widget(&self, widget: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_size_group_remove_widget(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_mode(&self, mode: SizeGroupMode) {
        unsafe {
            ffi::gtk_size_group_set_mode(self.as_ref().to_glib_none().0, mode.into_glib());
        }
    }

    fn connect_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mode_trampoline<P: IsA<SizeGroup>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSizeGroup,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SizeGroup::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for SizeGroup {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SizeGroup")
    }
}
