/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package eric.jobs;

import eric.GUI.ZDialog.ZButton;
import eric.GUI.ZDialog.ZCheckBox;
import eric.GUI.ZDialog.ZDialog;
import eric.GUI.ZDialog.ZTextFieldAndLabel;
import eric.GUI.ZDialog.ZTools;
import eric.GUI.palette.PaletteManager;
import eric.GUI.themes;
import eric.GUI.windowComponent;
import eric.JZirkelCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import rene.gui.Global;
import rene.zirkel.ZirkelCanvas;

/**
 *
 * @author erichake
 */
public class JobControlPanel extends ZDialog {


    private ZButton createBTN, removeBTN;
    private ZCheckBox hideFinalBox;
    private ZTextFieldAndLabel okMessage, failedMessage, targetslist;
    private JobManager MAN;

    public JobControlPanel(JobManager man,int x,int y,int w,int h) {
        super(Global.Loc("job.gui.title"), x,y,w,h,true,true);
        MAN=man;

        createBTN=new ZButton(Global.Loc("job.gui.close")) {

            @Override
            public void action() {
                MAN.hideControlDialog(true);
            }
        };
        removeBTN=new ZButton(Global.Loc("job.gui.delete")) {

            @Override
            public void action() {
                MAN.hideControlDialog(false);
            }
        };
        okMessage=new ZTextFieldAndLabel(Global.Loc("job.gui.ok"), man.getMessage_ok(), LWIDTH,CHEIGHT) {

            @Override
            public void actionKey() {
                MAN.setMessage_ok(okMessage.getText());
            }
        };
        failedMessage=new ZTextFieldAndLabel(Global.Loc("job.gui.failed"), man.getMessage_failed(), LWIDTH,CHEIGHT) {

            @Override
            public void actionKey() {
                MAN.setMessage_failed(failedMessage.getText());
            }
        };
        targetslist=new ZTextFieldAndLabel(Global.Loc("job.gui.targets"), man.getTargetNames(), 0,CHEIGHT) {

            @Override
            public void actionMouse() {
                MAN.setJobTool();
            }

            @Override
            public void actionKey() {
                MAN.setTargets(targetslist.getText());
            }
        };
        hideFinalBox=new ZCheckBox(Global.Loc("job.gui.hidebox"), man.isHidefinals()) {

            public void action() {
                MAN.setHidefinals(hideFinalBox.isSelected());
            }
        };
//        add(title);
//
        add(createBTN);
        add(removeBTN);
        add(hideFinalBox);
        add(okMessage);
        add(failedMessage);
        add(targetslist);
        fixComponents();

    }

    public void fixComponents() {
        targetslist.setBounds(MARGINW, MARGINTOP1, CWIDTH, CHEIGHT);
        okMessage.setBounds(MARGINW, MARGINTOP2, CWIDTH, CHEIGHT);
        failedMessage.setBounds(MARGINW, MARGINTOP3, CWIDTH, CHEIGHT);
        hideFinalBox.setBounds(MARGINW, MARGINTOP4, CWIDTH, CHEIGHT);
        createBTN.setBounds(D_WIDTH-BWIDTH-MARGINW, MARGINTOP4, BWIDTH, CHEIGHT);
        removeBTN.setBounds(D_WIDTH-MARGINW-CWIDTH+LWIDTH, MARGINTOP4, BWIDTH, CHEIGHT);
    }


    @Override
    public void doClose() {
        MAN.cancelControlDialog();
    }

    public String getTargetslist() {
        return targetslist.getText();
    }

    public void setTargetslist(String targets) {
        targetslist.setText(targets);
    }
}
