% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbHasCompleted}
\alias{dbHasCompleted}
\title{Completion status}
\usage{
dbHasCompleted(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbHasCompleted()} returns a logical scalar.
For a query initiated by \code{\link[=dbSendQuery]{dbSendQuery()}} with non-empty result set,
\code{dbHasCompleted()} returns \code{FALSE} initially
and \code{TRUE} after calling \code{\link[=dbFetch]{dbFetch()}} without limit.
For a query initiated by \code{\link[=dbSendStatement]{dbSendStatement()}},
\code{dbHasCompleted()} always returns \code{TRUE}.
Attempting to query completion status for a result set cleared with
\code{\link[=dbClearResult]{dbClearResult()}} gives an error.
}
\description{
This method returns if the operation has completed.
A \code{SELECT} query is completed if all rows have been fetched.
A data manipulation statement is always completed.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbHasCompleted")}
}
\section{Specification}{


The completion status for a query is only guaranteed to be set to
\code{FALSE} after attempting to fetch past the end of the entire result.
Therefore, for a query with an empty result set,
the initial return value is unspecified,
but the result value is \code{TRUE} after trying to fetch only one row.
Similarly, for a query with a result set of length n,
the return value is unspecified after fetching n rows,
but the result value is \code{TRUE} after trying to fetch only one more
row.

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
rs <- dbSendQuery(con, "SELECT * FROM mtcars")

dbHasCompleted(rs)
ret1 <- dbFetch(rs, 10)
dbHasCompleted(rs)
ret2 <- dbFetch(rs)
dbHasCompleted(rs)

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
\concept{DBIResult generics}
