/*
 * Copyright (C) 2014 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     jouyouyun <jouyouwen717@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package x_event_monitor

const (
	MotionFlag = int32(1)		//当此标志为1, 则鼠标在册注区域中移动时,会实时发送鼠标位置信号
	ButtonFlag = int32(1 << 1)
	KeyFlag    = int32(1 << 2)
)

func hasMotionFlag(flag int32) bool {
	return flag&MotionFlag != 0
}

func hasKeyFlag(flag int32) bool {
	return flag&KeyFlag != 0
}

func hasButtonFlag(flag int32) bool {
	return flag&ButtonFlag != 0
}

func isInArea(x, y int32, area coordinateRange) bool {
	if (x >= area.X1 && x <= area.X2) &&
		(y >= area.Y1 && y <= area.Y2) {
		return true
	}

	return false
}

func isInIdList(md5Str string, list []string) bool {
	for _, v := range list {
		if md5Str == v {
			return true
		}
	}

	return false
}
