package storage

import (
	"context"
	"io"
	"path/filepath"
	"strings"

	"github.com/pkg/errors"

	"github.com/google/go-cloud/blob"
)

type ListOptions struct {
	Prefix string
}

type ListObject struct {
	Key     string
	Version string
	Size    int64
}

type ListIterator struct {
	prefix   string
	blobList *blob.ListIterator
}

func (iterator *ListIterator) Next(ctx context.Context) (*ListObject, error) {
	obj, err := iterator.blobList.Next(ctx)
	if err != nil {
		if err == io.EOF {
			return nil, err
		}
		return nil, errors.Wrap(err, "Next")
	}
	if obj == nil {
		return nil, nil
	}
	if len(iterator.prefix) > 0 && strings.HasPrefix(obj.Key, iterator.prefix) {
		obj.Key = obj.Key[len(iterator.prefix)+1:]
	}
	ext := filepath.Ext(obj.Key)
	// 15位后缀为版本后缀
	if len(ext) == 15 {
		return &ListObject{Key: obj.Key[:len(obj.Key)-len(ext)], Version: ext[1:], Size: obj.Size}, nil
	}
	return &ListObject{Key: obj.Key, Version: "", Size: obj.Size}, nil
}
