/*
 * Copyright (C) 2014-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * For infos look at:
 * "KL02 Sub-Family Reference Manual for 48 MHz devices 32 pin package
 * Reference Manual".
 *
 * "17: Miscellaneous Control Module (MCM)"
 */

#define DEBUG	0

#ifdef INCLUDE

#include <assert.h>
#include <stdio.h>
#include <string.h>

#endif /* INCLUDE */
#ifdef STATE

struct {
	int dummy;
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val);
/*forward*/ static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp);
/*forward*/ static void                                       
NAME_(reset)(struct cpssp *cpssp);
/*forward*/ static void                                       
NAME_(create)(struct cpssp *cpssp);
/*forward*/ static void                                       
NAME_(destroy)(struct cpssp *cpssp);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0x1000 - 1;

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	case 0x008:
		if (((bs >> 0) & 0b11) == 0b11) {
			/* Crossbar Switch (AXBS) Slave Configuration */
			/* 17.2.1 */
			assert(0); /* FIXME */
		}
		if (((bs >> 2) & 0b11) == 0b11) {
			/* Crossbar Switch (AXBS) Slave Configuration */
			/* 17.2.2 */
			assert(0); /* FIXME */
		}
		break;

	case 0x00c:
		/* Platform Control Register */
		/* 17.2.3 */
		/* FIXME */
		break;

	case 0x040:
		/* Compute Operation Control Register */
		/* 17.2.4 */
		assert(0); /* FIXME */
		break;

	default:
		fprintf(stderr, "%s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, val);
		assert(0);
	}
}

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0x1000 - 1;
	*valp = 0;

	switch (addr) {
	case 0x008:
		if (((bs >> 0) & 0b11) == 0b11) {
			/* Crossbar Switch (AXBS) Slave Configuration */
			/* 17.2.1 */
			assert(0); /* FIXME */
		}
		if (((bs >> 2) & 0b11) == 0b11) {
			/* Crossbar Switch (AXBS) Slave Configuration */
			/* 17.2.2 */
			assert(0); /* FIXME */
		}
		break;

	case 0x00c:
		/* Platform Control Register */
		/* 17.2.3 */
		/* FIXME */
		break;

	case 0x040:
		/* Compute Operation Control Register */
		/* 17.2.4 */
		assert(0); /* FIXME */
		break;

	default:
		fprintf(stderr, "%s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, *valp);
		assert(0);
		break;
	}

	if (DEBUG) {
		fprintf(stderr, "%s: addr=0x%08lx bs=0x%x val=0x%08lx\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG
