/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "glue.h"
#include "glue-gui-gtk.h"

#include "chip_st_l3gd20_gui_gtk.h"

#define COMP		"chip_st_l3gd20"
#define COMP_(x)	chip_st_l3gd20_gui_gtk_ ## x

#define GYRO_MAX	2000.0
#define TEMP_MAX	128.0

struct cpssp {
	GtkAdjustment *gui_gyro_x;
	GtkAdjustment *gui_gyro_y;
	GtkAdjustment *gui_gyro_z;
	GtkAdjustment *gui_temp;

	struct sig_integer *port_gyro_x;
	struct sig_integer *port_gyro_y;
	struct sig_integer *port_gyro_z;
	struct sig_integer *port_temp;
};

/*
 * Simulator Callbacks
 */
static void
COMP_(gyro_x_sim_set)(void *_cpssp, int value)
{
	struct cpssp *cpssp = _cpssp;
	double val;

	assert(-1023 <= value && value <= 1023);

	val = (double) value * GYRO_MAX / 1023;

	gtk_adjustment_set_value(cpssp->gui_gyro_x, (gdouble) val);
	g_signal_emit_by_name(cpssp->gui_gyro_x, "changed");
}

static void
COMP_(gyro_y_sim_set)(void *_cpssp, int value)
{
	struct cpssp *cpssp = _cpssp;
	double val;

	assert(-1023 <= value && value <= 1023);

	val = (double) value * GYRO_MAX / 1023;

	gtk_adjustment_set_value(cpssp->gui_gyro_y, (gdouble) val);
	g_signal_emit_by_name(cpssp->gui_gyro_y, "changed");
}

static void
COMP_(gyro_z_sim_set)(void *_cpssp, int value)
{
	struct cpssp *cpssp = _cpssp;
	double val;

	assert(-1023 <= value && value <= 1023);

	val = (double) value * GYRO_MAX / 1023;

	gtk_adjustment_set_value(cpssp->gui_gyro_z, (gdouble) val);
	g_signal_emit_by_name(cpssp->gui_gyro_z, "changed");
}

static void
COMP_(temp_sim_set)(void *_cpssp, int value)
{
	struct cpssp *cpssp = _cpssp;
	double val;

	assert(-1023 <= value && value <= 1023);

	val = (double) value * TEMP_MAX / 1023;

	gtk_adjustment_set_value(cpssp->gui_temp, (gdouble) val);
	g_signal_emit_by_name(cpssp->gui_temp, "changed");
}

/*
 * GUI  Callbacks
 */
static void
COMP_(gyro_x_gui_set)(GtkAdjustment *adj, void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int val;

	assert(-GYRO_MAX <= adj->value && adj->value <= GYRO_MAX);

	val = (int) (adj->value / GYRO_MAX * 1023.0);

	assert(-1023 <= val && val <= 1023);

	sig_integer_set(cpssp->port_gyro_x, cpssp, val);
}

static void
COMP_(gyro_y_gui_set)(GtkAdjustment *adj, void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int val;

	assert(-GYRO_MAX <= adj->value && adj->value <= GYRO_MAX);

	val = (int) (adj->value / GYRO_MAX * 1023.0);

	assert(-1023 <= val && val <= 1023);

	sig_integer_set(cpssp->port_gyro_y, cpssp, val);
}

static void
COMP_(gyro_z_gui_set)(GtkAdjustment *adj, void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int val;

	assert(-GYRO_MAX <= adj->value && adj->value <= GYRO_MAX);

	val = (int) (adj->value / GYRO_MAX * 1023.0);

	assert(-1023 <= val && val <= 1023);

	sig_integer_set(cpssp->port_gyro_z, cpssp, val);
}

static void
COMP_(temp_gui_set)(GtkAdjustment *adj, void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	int val;

	assert(-TEMP_MAX <= adj->value && adj->value <= TEMP_MAX);

	val = (int) (adj->value / TEMP_MAX * 1023.0);

	assert(-1023 <= val && val <= 1023);

	sig_integer_set(cpssp->port_temp, cpssp, val);
}

void *
COMP_(create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_gnd,
	struct sig_std_logic *port_vdd,
	struct sig_std_logic *port_vdd_io,
	struct sig_std_logic *port_cs,
	struct sig_std_logic *port_int1,
	struct sig_std_logic *port_drdy_int2_,
	struct sig_std_logic *port_scl_spc,
	struct sig_std_logic *port_sda_sdi_sdo,
	struct sig_std_logic *port_sdo_sao,
	struct sig_std_logic *port_res8,
	struct sig_std_logic *port_res9,
	struct sig_std_logic *port_res10,
	struct sig_std_logic *port_res11,
	struct sig_std_logic *port_res12,
	struct sig_std_logic *port_res14,
	struct sig_std_logic *port_res15,
	struct sig_integer *port_gyro_x,
	struct sig_integer *port_gyro_y,
	struct sig_integer *port_gyro_z,
	struct sig_integer *port_temp
)
{
	static const struct sig_integer_funcs gyro_x_funcs = {
		.set = COMP_(gyro_x_sim_set),
	};
	static const struct sig_integer_funcs gyro_y_funcs = {
		.set = COMP_(gyro_y_sim_set),
	};
	static const struct sig_integer_funcs gyro_z_funcs = {
		.set = COMP_(gyro_z_sim_set),
	};
	static const struct sig_integer_funcs temp_funcs = {
		.set = COMP_(temp_sim_set),
	};
	struct cpssp *cpssp;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *hbox2;
	GtkWidget *label;
	GtkWidget *scale;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	hbox = gtk_hbox_new(FALSE, 1);

	vbox = gtk_vbox_new(FALSE, 1);
	label = gtk_label_new("Gyroscope");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

#define SLIDER(v, n1, n2) \
	hbox2 = gtk_hbox_new(FALSE, 1); \
	label = gtk_label_new(n1); \
	gtk_widget_show(label); \
	gtk_box_pack_start(GTK_BOX(hbox2), label, TRUE, FALSE, 0); \
	\
	cpssp->gui_ ## n2 = (GtkAdjustment *) gtk_adjustment_new(0.0, /* value */ \
			-v, /* lower */ \
			v + v / 10.0, /* upper + pagesize */ \
			v / 20.0, /* step increment */ \
			v / 10.0, /* page increment */ \
			v / 10.0 /* page size */); \
	g_signal_connect(cpssp->gui_ ## n2, "value_changed", \
			G_CALLBACK(COMP_(n2 ## _gui_set)), cpssp); \
	scale = gtk_hscale_new(cpssp->gui_ ## n2); \
	gtk_widget_show(scale); \
	gtk_box_pack_start(GTK_BOX(hbox2), scale, TRUE, TRUE, 0); \
	\
	gtk_widget_show(hbox2); \
	gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 0);

	SLIDER(GYRO_MAX, "X", gyro_x)
	SLIDER(GYRO_MAX, "Y", gyro_y)
	SLIDER(GYRO_MAX, "Z", gyro_z)

	gtk_widget_show(vbox);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, FALSE, 5);

	vbox = gtk_vbox_new(FALSE, 1);
	label = gtk_label_new("Thermometer");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

	SLIDER(TEMP_MAX, "C", temp)

#undef SLIDER

	gtk_widget_show(vbox);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, FALSE, 5);

	gtk_widget_show(hbox);

	gui_gtk_comp_add(page, COMP, name, hbox, FALSE, FALSE, NULL);

	/* FIXME */

	/* Out */
	cpssp->port_gyro_x = port_gyro_x;
	cpssp->port_gyro_y = port_gyro_y;
	cpssp->port_gyro_z = port_gyro_z;
	cpssp->port_temp = port_temp;

	/* In */
	sig_integer_connect_in(port_gyro_x, cpssp, &gyro_x_funcs);
	sig_integer_connect_in(port_gyro_y, cpssp, &gyro_y_funcs);
	sig_integer_connect_in(port_gyro_z, cpssp, &gyro_z_funcs);
	sig_integer_connect_in(port_temp, cpssp, &temp_funcs);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}

void
COMP_(resume)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}
