/*
 * Copyright (C) 2015-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
	unsigned int state[12];
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR

static void
NAME_(N_update)(struct cpssp *cpssp, int n)
{
	unsigned int res;

	switch (n) {
	case 12:
		res = cpssp->NAME.state[11]
			| cpssp->NAME.state[7]
			| cpssp->NAME.state[9];
		NAME_(12_out_set)(cpssp, res ? SIG_STD_LOGIC_H : SIG_STD_LOGIC_0);
		break;
	case 13:
		res = cpssp->NAME.state[8]
			| cpssp->NAME.state[7]
			| cpssp->NAME.state[9];
		NAME_(13_out_set)(cpssp, res ? SIG_STD_LOGIC_H : SIG_STD_LOGIC_0);
		break;
	case 14:
		res = cpssp->NAME.state[6]
			| cpssp->NAME.state[7]
			| cpssp->NAME.state[9];
		NAME_(14_out_set)(cpssp, res ? SIG_STD_LOGIC_H : SIG_STD_LOGIC_0);
		break;
	case 15:
		res = cpssp->NAME.state[4]
			| cpssp->NAME.state[7]
			| cpssp->NAME.state[9];
		NAME_(15_out_set)(cpssp, res ? SIG_STD_LOGIC_H : SIG_STD_LOGIC_0);
		break;
	default:
		assert(0); /* Cannot happen. */
	}
}

static void
NAME_(N_in_set)(struct cpssp *cpssp, int n, unsigned int val)
{
	switch (val) {
	case SIG_STD_LOGIC_L:
	case SIG_STD_LOGIC_0:
		val = 0;
		break;
	case SIG_STD_LOGIC_H:
	case SIG_STD_LOGIC_1:
		val = 1;
		break;
	default:
		val = 0;
		break;
	}
	cpssp->NAME.state[n] = val;

	switch (n) {
	case 7:
	case 9:
		NAME_(N_update)(cpssp, 12);
		NAME_(N_update)(cpssp, 13);
		NAME_(N_update)(cpssp, 14);
		NAME_(N_update)(cpssp, 15);
		break;
	case 11:
		NAME_(N_update)(cpssp, 12);
		break;
	case 8:
		NAME_(N_update)(cpssp, 13);
		break;
	case 6:
		NAME_(N_update)(cpssp, 14);
		break;
	case 4:
		NAME_(N_update)(cpssp, 15);
		break;
	default:
		assert(0); /* Cannot happen. */
	}
}

static void
NAME_(4_in_set)(struct cpssp *cpssp, unsigned int val)
{
	NAME_(N_in_set)(cpssp, 4, val);
}

static void
NAME_(6_in_set)(struct cpssp *cpssp, unsigned int val)
{
	NAME_(N_in_set)(cpssp, 6, val);
}

static void
NAME_(7_in_set)(struct cpssp *cpssp, unsigned int val)
{
	NAME_(N_in_set)(cpssp, 7, val);
}

static void
NAME_(8_in_set)(struct cpssp *cpssp, unsigned int val)
{
	NAME_(N_in_set)(cpssp, 8, val);
}

static void
NAME_(9_in_set)(struct cpssp *cpssp, unsigned int val)
{
	NAME_(N_in_set)(cpssp, 9, val);
}

static void
NAME_(11_in_set)(struct cpssp *cpssp, unsigned int val)
{
	NAME_(N_in_set)(cpssp, 11, val);
}

static void
NAME_(create)(struct cpssp *cpssp)
{
	cpssp->NAME.state[4] = SIG_STD_LOGIC_Z;
	cpssp->NAME.state[6] = SIG_STD_LOGIC_Z;
	cpssp->NAME.state[7] = SIG_STD_LOGIC_Z;
	cpssp->NAME.state[8] = SIG_STD_LOGIC_Z;
	cpssp->NAME.state[9] = SIG_STD_LOGIC_Z;
	cpssp->NAME.state[11] = SIG_STD_LOGIC_Z;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /*BEHAVIOUR*/
