/*
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#ifdef CONFIG_DMI_SUPPORT

#include "compiler.h"
#include "fixme.h"
#include "stdio.h"

#ifdef RUNTIME_RM

CODE16;

uint16_t
dmi_0050(void *_param)
{
	struct {
		uint16_t dmiBIOSRevision_seg;
		uint16_t dmiBIOSRevision_off;
	} *param = _param;

	dprintf("WARNING: %s called (%04x:%04x).\n", __FUNCTION__,
			param->dmiBIOSRevision_seg,
			param->dmiBIOSRevision_off);
	return 0x0082;
}

struct dmi_0051_param {
	uint16_t dummy;
};

uint16_t
dmi_0051(struct dmi_0051_param *param)
{
	dprintf("WARNING: %s called.\n", __FUNCTION__);
	return 0x0082;
}

struct dmi_0052_param {
	uint16_t dummy;
};

uint16_t
dmi_0052(struct dmi_0052_param *param)
{
	dprintf("WARNING: %s called.\n", __FUNCTION__);
	return 0x0082;
}

struct dmi_0053_param {
	uint16_t dummy;
};

uint16_t
dmi_0053(struct dmi_0053_param *param)
{
	dprintf("WARNING: %s called.\n", __FUNCTION__);
	return 0x0082;
}

struct dmi_0054_param {
	uint16_t dummy;
};

uint16_t
dmi_0054(struct dmi_0054_param *param)
{
	dprintf("WARNING: %s called.\n", __FUNCTION__);
	return 0x0082;
}

struct dmi_0055_param {
	uint16_t dummy;
};

uint16_t
dmi_0055(struct dmi_0055_param *param)
{
	dprintf("WARNING: %s called.\n", __FUNCTION__);
	return 0x0082;
}

struct dmi_0056_param {
	uint16_t dummy;
};

uint16_t
dmi_0056(struct dmi_0056_param *param)
{
	dprintf("WARNING: %s called.\n", __FUNCTION__);
	return 0x0082;
}

struct dmi_0057_param {
	uint16_t dummy;
};

uint16_t
dmi_0057(struct dmi_0057_param *param)
{
	dprintf("WARNING: %s called.\n", __FUNCTION__);
	return 0x0082;
}

uint16_t
dmi_entry(uint16_t *ptr)
{
	uint16_t func;
	void *param;

	func = *ptr;
	param = ptr + 1;

	if (func == 0x0050) {
		return dmi_0050(param);
	} else if (func == 0x0051) {
		return dmi_0051(param);
	} else if (func == 0x0052) {
		return dmi_0052(param);
	} else if (func == 0x0053) {
		return dmi_0053(param);
	} else if (func == 0x0054) {
		return dmi_0054(param);
	} else if (func == 0x0055) {
		return dmi_0055(param);
	} else if (func == 0x0056) {
		return dmi_0056(param);
	} else if (func == 0x0057) {
		return dmi_0057(param);
	} else {
		dprintf("WARNING: %s: func=0x%x.\n", __FUNCTION__, func);
		return 0x0082;	/* Function not supported. */
	}
}

#endif /* RUNTIME_RM */

#endif /* CONFIG_DMI_SUPPORT */
