/*
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#if defined(RUNTIME_RM) || defined(RUNTIME_PM)

#include "compiler.h"
#if defined(RUNTIME_PM)
CODE32;
#else
CODE16;
#endif

#include "stdio.h"

#include "fixme.h"

void
__faum_fixme(const char *file, unsigned int line, const char *function)
{
	dprintf("%s:%d: %s: FIXME\n", file, line, function);

	/*
	 * Use inline assembler below to fool gcc.
	 * If we use "for (;;);" or similar gcc will complain that
	 * __faum_fixme should have noreturn attribute.
	 */
	__asm__("1: jmp 1b");
}

#endif /* defined(RUNTIME_RM) || defined(RUNTIME_PM) */
