
## Accessors

# $ahat access
Resultado: 	serie 

Debe ejecutarse después de que el último modelo se haya estimado con datos de panel de efectos fijos o de efectos aleatorios. Devuelve una serie que contiene las estimaciones de los efectos individuales. 

# $aic access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con el valor del Criterio de Información de Akaike (AIC) del último modelo estimado. Más detalles sobre el cálculo en <@pdf="El manual de gretl#chap:criteria"> (Capítulo 25). 

# $bic access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con el valor del Criterio de Información Bayesiano (BIC) de Schwarz del último modelo estimado. Más detalles sobre el cálculo en <@pdf="El manual de gretl#chap:criteria"> (Capítulo 25). 

# $chisq access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con el valor del estadístico chi-cuadrado global del contraste de Razón de Verosimilitudes del último modelo estimado. 

# $coeff access
Resultado: 	matriz o escalar 
Argumento: 	<@var="nombre">  (nombre de coeficiente, opcional)

Sin argumentos <@lit="$coeff"> devuelve un vector columna que contiene los coeficientes del último modelo estimado. Con el argumento opcional de texto <@lit="(nombre de un regresor)"> la función devuelve un escalar con el valor del parámetro estimado de ese regresor. Ver también <@ref="$stderr">, <@ref="$vcv">. 

Ejemplo: 

<code>          
     open bjg
     arima 0 1 1 ; 0 1 1 ; lg
     b = $coeff               # Devuelve un vector
     macoef = $coeff(theta_1) # Devuelve un escalar
</code>

Si el “modelo” en cuestión es un sistema de ecuaciones, el resultado depende de las características de este; para VARs y VECMs el resultado devuelto es una matriz con una columna por cada ecuación; de lo contario, es un vector columna que contiene los coeficientes de la primera ecuación seguidos por los coeficientes de la segunda ecuación y así sucesivamente. 

# $command access
Resultado: 	cadena 

Debe ejecutarse tras estimar un modelo, y devuelve la cadena con los caracteres de la instrucción utilizada (ejemplo: <@lit="ols"> o <@lit="probit">). 

# $compan access
Resultado: 	matriz 

Debe ejecutarse después de la estimación de un VAR o de un VECM, y devuelve la matriz compañera. 

# $datatype access
Resultado: 	escalar 

Devuelve un escalar entero que representa el tipo de datos que se están utilizando en ese momento: 0 = sin datos; 1 = datos de corte transversal; 2 = datos de series temporales; 3 = datos de panel. 

# $depvar access
Resultado: 	cadena 

Debe ejecutarse después de la estimación de un modelo con una única ecuación, y devuelve una cadena de texto con el nombre de la variable dependiente. 

# $df access
Resultado: 	escalar 

Devuelve un escalar con los grados de libertad del último modelo estimado. Si este consiste en un sistema de ecuaciones, el valor devuelto es el número de grados de libertad por cada ecuación. Si los grados de libertad de las diferentes ecuaciones no son los mismos en todas ellas, entonces el valor devuelto se calcula restando el número de observaciones menos la media del número de coeficientes de las ecuaciones (esta media se redondea al valor entero inmediatamente superior). 

# $diagpval access
Resultado: 	escalar 

Debe ejecutarse después de la estimación de un sistema de ecuaciones, y devuelve un escalar con la probabilidad asociada al valor del estadístico <@ref="$diagtest">. 

# $diagtest access
Resultado: 	escalar 

Debe ejecutarse después de la estimación de un sistema de ecuaciones. Devuelve un escalar con el valor del estadístico utilizado para contrastar la hipótesis nula de que la matriz de varianzas-covarianzas de las perturbaciones de las ecuaciones del sistema, es diagonal. Este es el contraste de Breusch-Pagan, excepto cuando el estimador es el de un SUR iterado (sin restricciones), pues en ese caso es un contraste de Razón de Verosimilitudes. Para obtener más detalles, véase <@pdf="El manual de gretl#chap:system"> (Capítulo 31) (también <@ref="$diagpval">). 

# $dw access
Resultado: 	escalar 

Devuelve (si es posible) un escalar con el valor del estadístico de Durbin–Watson para contrastar autocorrelación de primer orden en el último modelo estimado. 

# $dwpval access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con la probabilidad asociada al valor del estadístico de Durbin-Watson del último modelo estimado. Se calcula utilizando el método Imhof. 

Debido a la limitada precisión de la aritmética de las computadoras, el resultado del cálculo de la integral del método Imhof puede volverse negativo cuando el estadístico de Durbin-Watson está próximo a su límite inferior; por eso este acceso devuelve <@lit="NA"> en esa situación. Dado que cualquier otra modalidad de fallo tiene como resultado un error que se señaliza, posiblemente sea seguro asumir que un resultado NA indica que la verdadera probabilidad asociada es “muy pequeña”, aunque no sea posible cuantificarla. 

# $ec access
Resultado: 	matriz 

Debe ejecutarse después de la estimación de un VECM, y devuelve una matriz que contiene los términos de Corrección de Errores. El número de filas es igual al número de observaciones utilizadas, y el número de columnas es igual al orden de cointegración del sistema. 

# $error access
Resultado: 	escalar 

Devuelve un escalar con uno de los códigos internos de fallo del programa. Ese código es un valor no nulo cuando ocurre un fallo pero es capturado usando la función <@xrf="catch">. Ten en cuenta que, al utilizar este acceso, el código interno de fallo se vuelve nuevamente cero. Si deseas obtener el mensaje de fallo asociado a un <@lit="$error"> en concreto, es preciso guardar su valor en una variable provisional, por ejemplo utilizando el código: 

<code>          
     err = $error
     if (err)
         printf "Se obtuvo el fallo %d (%s)\n", err, errmsg(err);
     endif
</code>

Ver también <@xrf="catch">, <@ref="errmsg">. 

# $ess access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con la suma de los cuadrados de los errores del último modelo estimado. 

# $evals access
Resultado: 	matriz 

Debe ejecutarse después de la estimación de un VECM, y devuelve un vector que contiene los autovalores que se utilizan en el cálculo del contraste de la traza para verificar si existe cointegración. 

# $fcast access
Resultado: 	matriz 

Debe ejecutarse después de la instrucción de predicción <@xrf="fcast">, y devuelve una matriz con los valores previstos. Si el modelo que se utiliza para hacer las predicciones es un sistema de ecuaciones, la matriz está formada por una columna para cada ecuación; en caso contrario, es un vector columna. 

# $fcse access
Resultado: 	matriz 

Si puede calcularse, debe ejecutarse después de procesar la instrucción <@xrf="fcast"> y devuelve una matriz con las desviaciones típicas de las predicciones. Si el modelo que se utiliza para hacer las predicciones es un sistema de ecuaciones, la matriz está formada por una columna para cada ecuación; en caso contrario, es un vector columna. 

# $fevd access
Resultado: 	matriz 

Debe ejecutarse después de la estimación de un VAR, y devuelve una matriz que contiene la descomposición de la varianza de los errores de predicción (FEVD, siglas en inglés). Esa matriz tiene <@mth="h"> filas que indican el número de períodos del horizonte de predicción, lo que puede escogerse de forma manual por medio de <@lit="set horizon"> o de forma automática en base a la frecuencia de los datos. 

Para un VAR con <@mth="p"> variables, la matriz tiene <@mth="p"> <@sup="2"> columnas: las primeras <@mth="p"> columnas contienen la FEVD para la primera variable del VAR; las <@mth="p"> columnas siguientes contienen la FEVD para la segunda variable del VAR y así sucesivamente. La fracción (decimal) del error de predicción de la variable <@mth="i"> causada por una innovación en la variable <@mth="j"> va a encontrarse entonces inspeccionando la columna (<@mth="i"> – 1) <@mth="p"> + <@mth="j">. 

Para una variante más flexible de esta funcionalidad, consulta la función <@ref="fevd">. 

# $Fstat access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con el estadístico F del contraste de validez global del último modelo estimado. 

# $gmmcrit access
Resultado: 	escalar 

Debe ejecutarse después de un bloque <@lit="gmm"> (del Método Generalizado de los Momentos), y devuelve un escalar con el mínimo de la función objetivo. 

# $h access
Resultado: 	serie 

Debe ejecutarse después de la instrucción <@lit="garch">, y devuelve una serie con las varianzas condicionales estimadas. 

# $hausman access
Resultado: 	vector fila 

Debe ejecutarse después de estimar un modelo por medio de <@lit="tsls"> o <@lit="panel"> con la opción de efectos aleatorios, y devuelve un vector fila 1×3 que contiene en este orden: el valor del estadístico del contraste de Hausman, los grados de libertad que corresponden y la probabilidad asociada al valor del estadístico. 

# $hqc access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con el valor del Criterio de Información de Hannan-Quinn para el último modelo estimado. Para detalles sobre el cálculo, consulta <@pdf="El manual de gretl#chap:criteria"> (Capítulo 25). 

# $huge access
Resultado: 	escalar 

Devuelve un escalar con un número positivo muy grande. Por defecto es igual a 1.0E100, pero puede cambiarse con la instrucción <@xrf="set">. 

# $jalpha access
Resultado: 	matriz 

Debe ejecutarse después de estimar un VECM, y devuelve la matriz de carga. El número de filas de esa matriz es igual al número de variables del VECM, y el número de columnas es igual al rango de cointegración. 

# $jbeta access
Resultado: 	matriz 

Debe ejecutarse después de estimar un VECM, y devuelve la matriz de cointegración. Su número de filas es igual al número de variables del VECM (más el número de variables exógenas que se restringen al espacio de cointegración, si hay alguna); y su número de columnas es igual al rango de cointegración. 

# $jvbeta access
Resultado: 	matriz cuadradax 

Debe ejecutarse después de estimar un VECM, y devuelve la matriz estimada de varianzas-covarianzas de los elementos de los vectores de cointegración. 

En caso de tratarse de una estimación sin restricciones, el número de filas de esa matriz es igual al número de elementos no restringidos del espacio de cointegración, después de la normalización de Phillips. Por el contrario, si se trata de la estimación de un sistema restringido por medio de la instrucción <@lit="restrict"> con la opción <@lit="--full">, se obtiene una matriz singular con <@mth="(n+m)r"> filas (donde <@mth="n"> es el número de variables endógenas, <@mth="m"> el número de variables exógenas restringidas al espacio de cointegración y <@mth="r"> el rango de cointegración). 

Ejemplo: el código... 

<code>          
     open denmark.gdt
     vecm 2 1 LRM LRY IBO IDE --rc --seasonals -q
     s0 = $jvbeta

     restrict --full
       b[1,1] = 1
       b[1,2] = -1
       b[1,3] + b[1,4] = 0
     end restrict
     s1 = $jvbeta

     print s0
     print s1
</code>

... origina el siguiente resultado: 

<code>          
     s0 (4 x 4)

          0.019751     0.029816  -0.00044837   -0.12227
          0.029816     0.31005   -0.45823      -0.18526
         -0.00044837  -0.45823    1.2169       -0.035437
         -0.12227     -0.18526   -0.035437      0.76062

     s1 (5 x 5)

     0.0000       0.0000       0.0000       0.0000       0.0000
     0.0000       0.0000       0.0000       0.0000       0.0000
     0.0000       0.0000      0.27398     -0.27398    -0.019059
     0.0000       0.0000     -0.27398      0.27398     0.019059
     0.0000       0.0000    -0.019059     0.019059    0.0014180
</code>

# $lang access
Resultado: 	cadena 

Devuelve una cadena de texto que representa el idioma que se está usando (si este puede determinarse). La cadena de texto está compuesta por dos letras del código de lenguaje ISO 639-1 (por ejemplo, <@lit="en"> para el idioma inglés, <@lit="jp"> para el japonés, <@lit="el"> para el griego) seguidas de un guion bajo más otras dos letras del código de país ISO 3166-1. Así, por ejemplo, el idioma portugués de Portugal se representa por <@lit="pt_PT"> mientras que el idioma portugués de Brasil se representa por <@lit="pt_BR">. 

Si no es posible determinar el idioma vigente, se devuelve el texto “<@lit="unknown">”. 

# $llt access
Resultado: 	serie 

Para una selección de modelos que se estiman por el método de Máxima Verosimilitud, la función devuelve una serie con los valores del logaritmo de la verosimilitud para cada observación. Por el momento esa función solo está disponible para logit y probit binarios, tobit y heckit. 

# $lnl access
Resultado: 	escalar 

Devuelve un escalar con el logaritmo de la verosimilitud del último modelo estimado (si fuese aplicable). 

# $macheps access
Resultado: 	escalar 

Devuelve un escalar con el valor de la “épsilon de la máquina”, lo que proporciona un límite superior para el error relativo debido al redondeo en la aritmética de punto flotante con doble precisión. 

# $mnlprobs access
Resultado: 	matriz 

Debe ejecutarse tras estimar un modelo logit multinomial (únicamente), y devuelve una matriz con las probabilidades estimadas de cada resultado posible, en cada observación de la muestra utilizada en la estimación del modelo. Cada línea representa una observación y cada columna un resultado. 

# $model access
Resultado: 	bundle 

Debe ejecutarse después de estimar modelos con una única ecuación, y devuelve un “bundle” que contiene varias unidades de datos pertenecientes al modelo. Se incluyen todos los accesores habituales de los modelos, que son designados mediante claves iguales a los nombres de esos accesores habituales, sin el signo dólar inicial. Por ejemplo, los errores aparecen bajo la clave <@lit="uhat"> y la suma de cuadrados de los errores bajo <@lit="ess">. 

Dependiendo del estimador, puedes disponer de información adicional. Las claves para tal información es de esperar que sean explicativas por sí mismas. Para ver lo que está disponible, puedes guardar una copia del 'bundle' y mostrar su contenido, como por ejemplo con el código: 

<code>          
     ols y 0 x
     bundle b = $model
     print b
</code>

# $ncoeff access
Resultado: 	entero 

Devuelve un número entero con la cantidad de coeficientes estimados en el último modelo. 

# $nobs access
Resultado: 	entero 

Devuelve un número entero con la cantidad total de observaciones que están seleccionadas en la muestra vigente. Relacionado: <@ref="$tmax">. 

# $nvars access
Resultado: 	entero 

Devuelve un número entero con la cantidad de variables incluidas en el conjunto vigente de datos (contando con la constante). 

# $obsdate access
Resultado: 	serie 

Puede ejecutarse cuando el conjunto vigente de datos está formado por series temporales con frecuencia decenal, anual, trimestral, mensual, fechadas semanalmente o fechadas diariamente. También puede utilizarse con datos de panel si la información temporal está ajustada correctamente (consulta la instrucción <@xrf="setobs">). Devuelve una serie formada por números con 8 dígitos con el patrón <@lit="YYYYMMDD"> (el formato de datos “básico” del ISO 8601), que corresponden al día de la observación, o al primer día de la observación en caso de una frecuencia temporal menor que la diaria. 

Estas series pueden resultar de utilidad cuando se emplea la instrucción <@xrf="join">. 

# $obsmajor access
Resultado: 	serie 

Puede ejecutarse cuando las observaciones del conjunto vigente de datos tienen una estructura mayor:menor, como en series temporales trimestrales (año:trimestre), en series temporales mensuales (año:mes), datos de horas (día:hora) y datos de panel (individuo:período). Devuelve una serie que mantiene la componente mayor (de menor frecuencia), de cada observación (por ejemplo, el año). 

Ver también <@ref="$obsminor">, <@ref="$obsmicro">. 

# $obsmicro access
Resultado: 	serie 

Puede ejecutarse cuando las observaciones del conjunto vigente de datos tienen una estructura mayor:menor:micro, como en las series temporales fechadas diariamente (año:mes:día). Devuelve una serie que contiene la componente micro (de mayor frecuencia) de cada observación (por ejemplo, el día). 

Ver también <@ref="$obsmajor">, <@ref="$obsminor">. 

# $obsminor access
Resultado: 	serie 

Puede ejecutarse cuando las observaciones del conjunto vigente de datos tienen una estructura mayor:menor, como en series temporales trimestrales (año:trimestre), series temporales mensuales (año:mes), datos de horas (día:hora) y datos de panel (individuo:período). Devuelve una serie que contiene la componente menor (de mayor frecuencia) de cada observación (por ejemplo, el mes). 

En caso de datos fechados diariamente, <@lit="$obsminor"> devuelve una serie con el mes de cada observación. 

Ver también <@ref="$obsmajor">, <@ref="$obsmicro">. 

# $pd access
Resultado: 	entero 

Devuelve un número entero con la frecuencia o periodicidad de los datos (por ejemplo: 4 para datos trimestrales). En caso de datos de panel, el valor devuelto es la cantidad de períodos de tiempo del conjunto de datos. 

# $pi access
Resultado: 	escalar 

Devuelve un escalar con el valor de π con doble precisión. 

# $pvalue access
Resultado: 	escalar o matriz 

Devuelve la probabilidad asociada al valor del estadístico de prueba que fue generado por la última instrucción explícita de contraste de hipótesis (por ejemplo: <@lit="chow">). Consulta <@pdf="El manual de gretl#chap:genr"> (Capítulo 9) para obtener más detalles. 

Generalmente devuelve un escalar, pero en algunos casos devuelve una matriz (por ejemplo, esto ocurre con las probabilidades asociadas a los valores de los estadísticos de la traza y del máximo-lambda del contraste de cointegración de Johansen). En este caso, los valores están dispuestos en la matriz del mismo modo que en los resultados presentados. 

Ver también <@ref="$test">. 

# $qlrbreak access
Resultado: 	escalar 

Debe ejecutarse después de la instrucción <@xrf="qlrtest"> (que permite hacer el contraste QLR para el cambio estructural en un punto desconocido). Devuelve un escalar con el número entero positivo que indexa la observación en la que se maximiza el valor del estadístico de contraste. 

# $rho access
Resultado: 	escalar 
Argumento: 	<@var="n">  (escalar, opcional)

Sin argumentos, este acceso devuelve el coeficiente de autocorrelación de primer orden para los errores del último modelo estimado. Ahora bien, con la sintaxis <@lit="$rho(n)"> después de la estimación de un modelo por medio de la instrucción <@lit="ar">, devuelve el valor estimado correspondiente al coeficiente ρ(<@mth="n">). 

# $rsq access
Resultado: 	escalar 

Si puede calcularse, devuelve un escalar con el valor del coeficiente <@mth="R"><@sup="2"> no corregido del último modelo estimado. 

# $sample access
Resultado: 	serie 

Debe ejecutarse después de estimar un modelo de una sola ecuación. Devuelve una serie con una variable ficticia que tiene valores iguales a: 1 en las observaciones utilizadas en la estimación, 0 en las observaciones de la muestra vigente no utilizadas en la estimación (posiblemente debido a valores ausentes), y NA en las observaciones fuera de la muestra vigente seleccionada. 

Si deseas calcular estadísticos basados en la muestra que se utiliza para un modelo dado, puede hacerse, por ejemplo con el código: 

<code>          
     ols y 0 xlist
     genr sdum = $sample
     smpl sdum --dummy
</code>

# $sargan access
Resultado: 	vector fila 

Debe ejecutarse después de la instrucción <@lit="tsls">. Devuelve un vector fila 1×3 que contiene, en este orden: el valor del estadístico del contraste de Sobreidentificación de Sargan, los correspondientes grados de libertad y la probabilidad asociada al valor del estadístico. Si el modelo está exactamente identificado, el estadístico no se puede calcular y tratar de hacerlo provoca un fallo. 

# $sigma access
Resultado: 	escalar o matriz 

Si el último modelo estimado fue uniecuacional, devuelve un escalar con la Desviación Típica de la regresión (S, o en otras palabras, la desviación típica de los errores del modelo con la oportuna corrección de los grados de libertad). Si el último modelo estimado fue un sistema de ecuaciones, devuelve una matriz con las varianzas-covarianzas de los errores de las ecuaciones del sistema. 

# $stderr access
Resultado: 	matriz o escalar 
Argumento: 	<@var="nombre">  (nombre de coeficiente, opcional)

Cuando se utiliza sin argumentos, <@lit="$stderr"> devuelve un vector columna que contiene las desviaciones típicas de los coeficientes del último modelo estimado. Con el argumento opcional <@lit="(nombre de un regresor)"> devuelve un escalar con el valor del parámetro estimado de ese regresor <@var="s">. 

Si el “modelo” es un sistema de ecuaciones, el resultado depende de las características de este: para VARs y VECMs, el valor devuelto es una matriz que contiene una columna por cada ecuación; en otro caso, es un vector columna que contiene los coeficientes de la primera ecuación seguidos por los coeficientes de la segunda ecuación y así sucesivamente. 

Ver también <@ref="$coeff">, <@ref="$vcv">. 

# $stopwatch access
Resultado: 	escalar 

Debe ejecutarse después de la instrucción <@lit="set stopwatch"> que activa la medición de tiempo de la CPU. Al usar este acceso por primera vez se obtiene un escalar con la cantidad de segundos de CPU que pasaron desde la instrucción <@lit="set stopwatch">. Con cada acceso, se reinicia el reloj, por lo que las sucesivas utilizaciones de <@lit="$stopwatch"> generan cada vez un escalar indicativo de los segundos de CPU desde el acceso previo. 

# $sysA access
Resultado: 	matriz 

Debe ejecutarse después de estimar un sistema de ecuaciones simultáneas. Devuelve la matriz con los coeficientes de las variables endógenas retardadas (en caso de que existan), en la forma estructural del sistema. Consulta también la instrucción <@xrf="system">. 

# $sysB access
Resultado: 	matriz 

Debe ejecutarse después de estimar un sistema de ecuaciones simultáneas. Devuelve una matriz con los coeficientes de las variables exógenas, en la forma estructural del sistema. Consulta la instrucción <@xrf="system">. 

# $sysGamma access
Resultado: 	matriz 

Debe ejecutarse después de estimar un sistema de ecuaciones simultáneas. Devuelve una matriz con los coeficientes de las variables endógenas contemporáneas, en la forma estructural del sistema. Consulta la instrucción <@xrf="system">. 

# $sysinfo access
Resultado: 	bundle 

Devuelve un “bundle” que contiene información de las capacidades de Gretl y del sistema operativo en el que se está ejecutando. Los elementos del 'bundle' se indican a continuación: 

<indent>
• <@lit="mpi">: número entero igual a 1 si el sistema admite MPI (Message Passing Interface), y 0 en caso contrario. 
</indent>

<indent>
• <@lit="omp">: número entero igual a 1 si Gretl se compiló con soporte para Open MP, y 0 en caso contrario. 
</indent>

<indent>
• <@lit="nproc">: número entero que indica el número de procesadores disponibles. 
</indent>

<indent>
• <@lit="mpimax">: número entero que indica el máximo número de procesos MPI que pueden ejecutarse en paralelo. Es igual a cero si no se admite MPI; en caso contrario, es igual al valor de <@lit="nproc"> local, excepto que se especifique un archivo de hosts MPI, caso en el que es igual a la suma del número de procesadores o “slots” a lo largo de todas las máquinas a las que se hace referencia en el archivo. 
</indent>

<indent>
• <@lit="wordlen">: número entero igual a 32 o a 64 en sistemas de 32 bit y 64 bit, respectivamente. 
</indent>

<indent>
• <@lit="os">: cadena de texto que representa el sistema operativo, bien <@lit="linux">, <@lit="osx">, <@lit="windows"> o <@lit="other">. 
</indent>

<indent>
• <@lit="hostname">: cadena de texto con el nombre de la máquina (o “host”) en la que se está ejecutando el proceso vigente de Gretl. Si no es posible determinar el nombre, se produce una vuelta atrás del <@lit="localhost">. 
</indent>

Fíjate en que puedes acceder a elementos individuales del 'bundle' mediante la notación del“punto”, sin necesidad de copiar el 'bundle' entero con un nombre de usuario específico. Por ejemplo con el código: 

<code>          
     if $sysinfo.os == "linux"
         # Haga algo que sea propio del Linux
     endif
</code>

# $system access
Resultado: 	bundle 

Debe seguir a la estimación de un sistema de ecuaciones, realizada con la instrucción <@xrf="system">, con <@xrf="var"> o con <@xrf="vecm">; y devuelve un 'bundle' que contiene muchos apartados de datos que se refieren al sistema. Se incluyen todos los accesores importantes y habituales del sistema, que se nombran mediante símbolos clave que son idénticos a los nombres habituales de los accesores, menos el símbolo de dólar inicial. Así, por ejemplo, los errores aparecen bajo la clave <@lit="uhat"> y los coeficientes bajo <@lit="coeff">. Las claves para obtener información adicional se espera que debieran explicarse suficientemente por si mismas. Para comprobar lo que tienes a tu disposición, puedes obtener una copia del 'bundle' y representar su contenido, como en 

<code>          
     var 4 y1 y2 y2
     bundle b = $system
     print b
</code>

Puedes pasar un 'bundle' obtenido de este modo como argumento final (opcional) de las funciones <@ref="fevd"> e <@ref="irf">. 

# $T access
Resultado: 	entero 

Devuelve un número entero con el número de observaciones utilizadas en la estimación del último modelo. 

# $t1 access
Resultado: 	entero 

Devuelve un entero positivo con el número que indexa la primera observación de la muestra vigente seleccionada. 

# $t2 access
Resultado: 	entero 

Devuelve un entero positivo con el número que indexa la última observación de la muestra vigente seleccionada. 

# $test access
Resultado: 	escalar o matriz 

Devuelve el valor del estadístico de prueba que fue generado por la última instrucción explícita para un contraste de hipótesis (por ejemplo: <@lit="chow">). Consulta <@pdf="El manual de gretl#chap:genr"> (Capítulo 9) para obtener más detalles. 

Generalmente devuelve un escalar, pero en algunos casos devuelve una matriz (por ejemplo, eso ocurre con los estadísticos de la traza y del máximo-lambda del contraste de cointegración de Johansen). En este caso, los valores están dispuestos en la matriz del mismo modo que en los resultados presentados. 

Ver también <@ref="$pvalue">. 

# $tmax access
Resultado: 	entero 

Devuelve un entero con el máximo valor válido establecido para indicar el final del rango de la muestra mediante la instrucción <@xrf="smpl">. En la mayoría de los casos, esto va a ser igual al número de observaciones del conjunto de datos; pero en una función de Hansl, el valor <@lit="$tmax"> podría ser menor, puesto que el acceso habitual a los datos dentro de las funciones, se limita al rango muestral establecido por el solicitante. 

Ten en cuenta que, en general, <@lit="$tmax"> no es igual a <@ref="$nobs">, que proporciona el número de observaciones del rango de la muestra vigente. 

# $trsq access
Resultado: 	escalar 

Devuelve el escalar <@mth="TR"><@sup="2"> (el tamaño de la muestra multiplicado por el R-cuadrado del último modelo), si está disponible. 

# $uhat access
Resultado: 	serie 

Devuelve una serie con los errores del último modelo estimado. Esto puede tener diferentes significados dependiendo de los estimadores utilizados. Por ejemplo, después de la estimación de un modelo ARMA, <@lit="$uhat"> contiene los errores de la predicción adelantados 1 paso; después de la estimación de un probit, contiene los errores generalizados. 

Cuando el “modelo” vigente en cuestión es un sistema de ecuaciones (un VAR, un VECM o un sistema de ecuaciones simultáneas), el <@lit="$uhat"> genera una matriz con los errores de estimación de cada ecuación, ordenados por columnas. 

# $unit access
Resultado: 	serie 

Solo es válido para datos de panel. Devuelve una serie con valor igual a 1 en todas las observaciones en la primera unidad o grupo, 2 en todas las observaciones en la segunda unidad o grupo, y así sucesivamente. 

# $vcv access
Resultado: 	matriz o escalar 
Argumentos:	<@var="nombre1">  (nombre de coeficiente, opcional)
		<@var="nombre2">  (nombre de coeficiente, opcional)

Cuando se utiliza sin argumentos, <@lit="$vcv"> devuelve una matriz cuadrada que contiene las varianzas-covarianzas estimadas de los coeficientes del último modelo estimado. Si este último era uniecuacional, se pueden indicar los nombres de dos regresores entre paréntesis, para así obtener un escalar con la covarianza estimada entre <@var="nombre1"> y <@var="nombre2">. Ver también <@ref="$coeff">, <@ref="$stderr">. 

Este acceso no está disponible para VARs o VECMs. Para modelos de ese tipo <@ref="$sigma"> y <@ref="$xtxinv">. 

# $vecGamma access
Resultado: 	matriz 

Debe ejecutarse después de estimar un VECM y devuelve una matriz en la que las matrices Gamma (con los coeficientes de las diferencias retardadas de las variables cointegradas) se agrupan unas al lado de las otras. Cada fila indica una ecuación; para un VECM con nivel de retardo <@mth="p"> existen <@mth="p"> – 1 submatrices. 

# $version access
Resultado: 	escalar 

Devuelve un escalar con un valor entero que designa la versión de Gretl. La versión actual de Gretl está formada por una cadena de texto que indica el año con formato de 4 dígitos seguido de una letra desde a hasta j, que representa las sucesivas actualizaciones dentro de cada año (por ejemplo, 2015d). El valor devuelto por este acceso está calculado multiplicando el año por 10, y sumándole un número que representa a la letra, en el orden léxico en base cero. Así, 2015d se representa mediante 20153. 

En versiones anteriores al Gretl 2015d, el identificador tenía el siguiente formato: x.y.z (tres números enteros separados por puntos); en ese caso, el valor de la función se calculaba con <@lit="10000*x + 100*y + z">. Por ejemplo, la última versión con el formato antiguo (1.10.2) se transcribía mediante 11002. De este modo el orden numérico de <@lit="$version"> fue preservado aún después de cambiar el esquema de las versiones. 

# $vma access
Resultado: 	matriz 

Debe ejecutarse después de estimar un VAR o un VECM, y devuelve una matriz que contiene la representación VMA hasta el orden especificado por medio de la instrucción <@lit="set horizon">. Para tener más detalles, consulta <@pdf="El manual de gretl#chap:var"> (Capítulo 29). 

# $windows access
Resultado: 	entero 

Devuelve un número entero con el valor 1 si Gretl se está ejecutando en Windows, y 0 en caso contrario. Poniendo como condición uno de estos valores, puedes escribir instrucciones “shell ” que puedan ejecutarse en diferentes sistemas operativos. 

Consulta también la instrucción <@xrf="shell">. 

# $xlist access
Resultado: 	lista 

Si el último modelo estimado era uniecuacional, el acceso devuelve una lista con sus regresores. Si el último modelo era un sistema de ecuaciones, devuelve una lista “global” con las variables exógenas y predeterminadas (en el mismo orden en el que aparecen con el acceso <@ref="$sysB">). Si el último modelo era un VAR, devuelve una lista con los regresores exógenos, si hay alguno. 

# $xtxinv access
Resultado: 	matriz 

Debe ejecutarse después de la estimación de un VAR o VECM (únicamente), y devuelve la matriz <@mth="X'X"><@sup="-1">, donde <@mth="X"> es la matriz habitual con los regresores utilizados en cada ecuación. Este acceso no está disponible para un VECM estimado con restricciones impuestas sobre la matriz de cargas (α). 

# $yhat access
Resultado: 	serie 

Devuelve una serie con los valores estimados de la variable explicada de la última regresión. 

# $ylist access
Resultado: 	lista 

Si el último modelo estimado fue un VAR, un VECM o un sistema de ecuaciones simultáneas, el acceso devuelve una lista con las variables endógenas. Si el último modelo estimado fue uniecuacional, el acceso devuelve una lista con un único elemento, la variable dependiente. En el caso especial del modelo biprobit, la lista contiene dos elementos. 

## Functions proper

# abs math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el valor absoluto de <@var="x">. 

# acos math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con los radianes del arco coseno de <@var="x">; es decir, proporciona el arco cuyo coseno es <@var="x"> (el argumento debe estar entre –1 y 1). 

# acosh math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el coseno hiperbólico inverso de <@var="x"> (solución positiva). Este último debe ser mayor que 1, pues de lo contrario la función devolverá NA. Ver también <@ref="cosh">. 

# aggregate stats
Resultado: 	matriz 
Argumentos:	<@var="x">  (serie o lista)
		<@var="segunvar">  (serie o lista)
		<@var="nombrefunc">  (cadena, opcional)

En la forma más simple de uso de esta función, <@var="x"> se establece igual a <@lit="null">, <@var="segunvar"> es una serie individual y el tercer argumento se omite. En ese caso, se devuelve una matriz con dos columnas que contiene: los distintos valores de <@var="segunvar"> ordenados de forma creciente en la primera columna, y el número de observaciones en las que <@var="segunvar"> toma cada uno de esos valores. Por ejemplo... 

<code>          
     open data4-1
     eval aggregate(null, bedrms)
</code>

... mostrará que la serie <@lit="bedrms"> tiene los valores 3 (en total 5 veces) y 4 (en total 9 veces). 

Si <@var="x"> y <@var="segunvar"> son ambas series individuales, e indicas el tercer argumento de esta función, el valor que se devuelve es una matriz con tres columnas que va a contener respectivamente: los distintos valores de <@var="segunvar"> ordenados de forma creciente, el número de observaciones en las que <@var="segunvar"> toma cada uno de esos valores, y los valores del estadístico que especifica la función <@var="nombrefunc">, calculado para la serie <@var="x">, pero usando tan solo aquellas observaciones en las que <@var="segunvar"> toma el mismo valor que se especifica en la primera columna de la matriz. 

De modo más general, si <@var="segunvar"> es una lista con <@mth="n"> elementos, entonces las <@mth="n"> columnas a la izquierda contienen las combinaciones de los distintos valores de cada una de las <@mth="n"> series, y la columna de recuento contiene el número de observaciones en las que se produce cada combinación. Si <@var="x"> es una lista con <@mth="m"> elementos, entonces las <@mth="m"> columnas más a la derecha contienen los valores del estadístico especificado, para cada una de las variables de <@var="x">, nuevamente calculadas en la submuestra indicada en la(s) primera(s) columna(s). 

Las siguientes opciones de <@var="nombrefunc"> se mantienen de forma “original”: <@ref="sum">, <@ref="sumall">, <@ref="mean">, <@ref="sd">, <@ref="var">, <@ref="sst">, <@ref="skewness">, <@ref="kurtosis">, <@ref="min">, <@ref="max">, <@ref="median">, <@ref="nobs"> y <@ref="gini">. Cada una de estas funciones utiliza a su vez una serie como argumento y devuelve un valor escalar; por eso, en este sentido, puede decirse que de algún modo “agregan” la serie. Puedes utilizar una función definida por el usuario como “agregador”; en ese caso, del mismo modo que las funciones originales, esa función debe tener como argumento únicamente una serie, y devolver un valor escalar. 

Ten en cuenta que, a pesar de que <@lit="aggregate"> hace el recuento de casos de forma automática, la opción <@lit="nobs">, no es redundante como función “agregadora”, puesto que proporciona el número de observaciones válidas (no ausentes) de <@var="x"> en cada combinación de <@var="segunvar">. 

Como ejemplo sencillo, supón que con <@lit="region"> se definen unos códigos para representar una distribución geográfica por regiones, utilizándose para ello enteros desde 1 hasta <@mth="n">, y que con <@lit="renta"> se representa la renta de los hogares. Entonces el código indicado a continuación debe producir una matriz de orden <@itl="n">×3 que contiene los códigos de las regiones, el recuento de observaciones de cada una, y la renta media de los hogares en cada una: 

<code>          
     matrix m = aggregate(renta, region, mean)
</code>

Como ejemplo de utilización con listas de variables, sea <@lit="genero"> una variable binaria hombre/mujer, sea <@lit="raza"> una variable categórica con tres valores, y considera el siguiente código: 

<code>          
     list BY = genero raza
     list X = renta edad
     matrix m = aggregate(X, BY, sd)
</code>

Invocar la función <@lit="aggregate"> producirá una matriz de orden 6×5. En las dos primeras columnas se expresan las 6 distintas combinaciones de los valores de 'genero' y 'raza'; la columna del medio contiene el recuento del número de casos para cada una de esas combinaciones; y las dos columnas más a la derecha contienen las desviaciones típicas muestrales de <@lit="renta"> y <@lit="edad">. 

Observa que si <@var="segunvar"> es una lista de variables, algunas combinaciones de los valores de <@var="segunvar"> pueden no estar presentes en los datos (produciéndose un recuento igual a cero). En ese caso, los valores de los estadísticos para <@var="x"> se registran como <@lit="NaN"> (es decir, no son números). Si quieres ignorar esos casos, puedes usar la función <@ref="selifr"> para escoger solo aquellas filas que no tengan recuento igual a cero. La columna a comprobar estará una posición a la derecha de la indicada por el número de variables de <@var="segunvar">, por lo que puede usarse el código: 

<code>          
     matrix m = aggregate(X, BY, sd)
     scalar c = nelem(BY)
     m = selifr(m, m[,c+1])
</code>

# argname strings
Resultado: 	cadena 
Argumento: 	<@var="s">  (cadena)

Si <@var="s"> es el nombre de un parámetro de una función definida previamente por el usuario, devuelve una cadena de texto con el nombre de ese argumento, o vacía si el argumento fuese anónimo. 

# array data-utils
Resultado: 	mira más abajo 
Argumento: 	<@var="n">  (entero)

Esta es la función “generadora” básica de una nueva variable de tipo “array”. Al usar esta función es necesario que especifiques un tipo (en forma plural) para el 'array': <@lit="strings">, <@lit="matrices">, <@lit="bundles"> o <@lit="lists">. Devuelve un 'array' del tipo especificado con <@var="n"> elementos “vacíos” (por ejemplo, una cadena de texto (“string”) vacía o una matriz nula). Ejemplos de utilización: 

<code>          
     strings S = array(5)
     matrices M = array(3)
</code>

Consulta también <@ref="defarray">. 

# asin math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con los radianes del arco seno de <@var="x">; es decir, proporciona el arco cuyo seno es <@var="x"> (el argumento debe estar entre –1 y 1). 

# asinh math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el seno hiperbólico inverso de <@var="x">. Ver también <@ref="sinh">. 

# atan math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con los radianes del arco tangente de <@var="x">; es decir, devuelve el arco cuya tangente es <@var="x">. 

Ver también <@ref="tan">, <@ref="atan2">. 

# atan2 math
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="y">  (escalar, serie o matriz)
		<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el valor principal de la arco tanxente de <@var="y">/<@var="x">, utilizando los signos de los dos argumentos indicados para determinar el cuadrante del resultado. El valor que se devuelve está en radianes, dentro del rango [–π, π]. 

Si los dos argumentos son de tipos difirentes, el tipo del resultado es el mismo que el del “mayor” de los dos, donde la jerarquía es matriz > serie > escalar. Por ejemplo, si <@var="y"> es un escalar, y <@var="x"> es un vector de dimensión <@mth="n"> (o viceversa), el resultado es un vector de dimensión <@mth="n">. Ten en cuenta que los argumentos de una matriz deben ser vectores; y que, si ningún argumento es un escalar, los dos argumentos deben ser de la misma longitud. 

Ver también <@ref="tan">, <@ref="tanh">. 

# atanh math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con la tangente hiperbólica inversa de <@var="x">. Ver también <@ref="tanh">. 

# atof strings
Resultado: 	escalar 
Argumento: 	<@var="s">  (cadena)

Función muy relacionada con la del lenguaje de programación C con el mismo nombre. Devuelve un escalar con el resultado de convertir la cadena de texto <@var="s"> (o su trozo relevante después de descartar cualquier espacio inicial en blanco) en un número de punto flotante. A diferencia de lo que ocurre en el lenguaje C, la función <@lit="atof"> siempre asume que el carácter decimal es el “<@lit=".">” (por cuestiones de portabilidad). Se ignoran todos los caracteres que siguen después de la parte de <@var="s"> que se convierte en número de punto flotante. 

Si, bajo el supuesto establecido, no pudiera convertirse ninguno de los caracteres de <@var="s"> que queden después de descartar los espacios en blanco, la función devuelve <@lit="NA">. 

<code>          
     # Ejemplos:
     x = atof("1.234") # Devuelve x = 1.234
     x = atof("1,234") # Devuelve x = 1
     x = atof("1.2y")  # Devuelve x = 1.2
     x = atof("y")     # Devuelve x = NA
     x = atof(",234")  # Devuelve x = NA
</code>

Consulta también <@ref="sscanf"> si quieres tener mayor flexibilidad en las conversiones de cadenas de texto en números. 

# bessel math
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="tipo">  (carácter)
		<@var="v">  (escalar)
		<@var="x">  (escalar, serie o matriz)

Permite calcular una de las variantes de la función de Bessel de clase <@var="v"> con argumento <@var="x">. El valor que devuelve es del mismo tipo que este <@var="x">. La clase de la función se escoge con el primer argumento que debe ser <@lit="J">, <@lit="Y">, <@lit="I"> o <@lit="K">. Una buena discusión sobre las funciones de Bessel puede encontrarse en la Wikipedia, pero aquí se ofrecen unos breves comentarios. 

Caso <@lit="J">: función de Bessel de primera clase que se parece a una onda sinusoidal amortiguada. Se define para <@var="v"> real y <@var="x">; pero si <@var="x"> fuese negativo, entonces <@var="v"> debe ser un número entero. 

Caso <@lit="Y">: función de Bessel de segunda clase. Se define para <@var="v"> real y <@var="x">, pero con una singularidad en <@var="x"> = 0. 

Caso <@lit="I">: función de Bessel modificada de primera clase que presenta un crecimiento exponencial. Los argumentos que pueden usarse con ella son los mismos que en el caso <@lit="J">. 

Caso <@lit="K">: función de Bessel modificada de segunda clase que presenta un decrecimiento exponencial. Diverge en <@var="x"> = 0, no está definida para valores negativos de <@var="x">, y es simétrica en torno a <@var="v"> = 0. 

# BFGSmax numerical
Resultado: 	escalar 
Argumentos:	<@var="&b">  (referencia a matriz)
		<@var="f">  (llamada a función)
		<@var="g">  (llamada a función, opcional)

Devuelve un escalar con el resultado de una maximización numérica hecha con el método de Broyden, Fletcher, Goldfarb y Shanno. El argumento vectorial <@var="b"> debe contener los valores iniciales de un conjunto de parámetros, y el argumento <@var="f"> debe especificar una llamada a la función que va a calcular el criterio objetivo (escalar) que se quiere maximizar, dados los valores vigentes de los parámetros, así como cualesquiera otros datos que sean relevantes. Si lo que pretendes es en realidad minimizar el criterio objetivo, esta función devuelve el valor negativo de ese criterio objetivo. Cuando se completa con éxito su ejecución, <@lit="BFGSmax"> devuelve el valor maximizado del criterio objetivo, y <@var="b"> contiene finalmente los valores de los parámetros que proporcionan el máximo de ese criterio. 

El tercer argumento (opcional) establece una manera de proporcionar derivadas analíticas (en otro caso, el gradiente se computa numéricamente). La llamada <@var="g"> a la función gradiente debe tener como primer argumento a una matriz definida previamente que tenga el tamaño adecuado para poder almacenar el gradiente, indicado en forma de puntero. Así mismo, también necesita tener como argumento (en forma de puntero o no) al vector de parámetros. Otros argumentos son opcionales. 

Para más detalles y ejemplos, consulta <@pdf="El manual de gretl#chap:numerical"> (Capítulo 34). Ver también <@ref="BFGScmax">, <@ref="NRmax">, <@ref="fdjac">, <@ref="simann">. 

# BFGSmin numerical
Resultado: 	escalar 

Un alias de <@ref="BFGSmax">. Si invocas la función bajo este nombre, se ejecuta haciendo una minimización. 

# BFGScmax numerical
Resultado: 	escalar 
Argumentos:	<@var="&b">  (referencia a matriz)
		<@var="limites">  (matriz)
		<@var="f">  (llamada a función)
		<@var="g">  (llamada a función, opcional)

Devuelve un escalar con el resultado de una maximización con restricciones por medio del método L-BFGS-B (BFGS con memoria limitada, consulta <@bib="Byrd, Lu, Nocedal y Zhu, 1995;byrd-etal95">). El argumento vectorial <@var="b"> debe contener los valores iniciales de un conjunto de parámetros, el argumento <@var="limites"> debe contener las restricciones aplicadas a los valores de los parámetros (consulta más abajo), y el argumento <@var="f"> debe especificar una llamada a la función que va a calcular el criterio objetivo (escalar) que se quiere maximizar, dados los valores vigentes de los parámetros así como cualesquiera otros datos que sean relevantes. Si lo que pretendes realmente es minimizar el criterio objetivo, esta función debe devolver el valor negativo de ese criterio. Al completar con éxito su ejecución, <@lit="BFGScmax"> devuelve el valor máximo del criterio objetivo, dadas las restricciones de <@var="limites">, y <@var="b"> contiene finalmente los valores de los parámetros que maximizan el criterio. 

La matriz <@var="limites"> debe tener 3 columnas, y un número de filas igual al número de elementos restringidos en el vector de parámetros. El primer elemento de una fila dada es el entero positivo que indexa el parámetro restringido; el segundo y el tercer elementos son los límites inferior y superior, respectivamente. Los valores <@lit="-$huge"> y <@lit="$huge"> deben usarse para indicar que el parámetro no posee restricciones inferiores o superiores, respectivamente. Por ejemplo, la siguiente expresión es la forma de especificar que el segundo elemento del vector de parámetros debe ser no negativo: 

<code>          
     matrix limites = {2, 0, $huge}
</code>

El cuarto argumento (opcional) establece una manera de proporcionar derivadas analíticas (en otro caso, el gradiente se calcula numéricamente). La llamada <@var="g"> a la función gradiente debe tener como primer argumento a una matriz definida previamente que tenga el tamaño adecuado para poder almacenar el gradiente, indicado en forma de puntero. Así mismo, también necesita tener como argumento (en forma de puntero o no) al vector de parámetros. Otros argumentos son opcionales. 

Para más detalles y ejemplos, consulta <@pdf="El manual de gretl#chap:numerical"> (Capítulo 34). Ver también <@ref="BFGSmax">, <@ref="NRmax">, <@ref="fdjac">, <@ref="simann">. 

# BFGScmin numerical
Resultado: 	escalar 

Un alias de <@ref="BFGScmax">. Si invocas la función bajo este nombre, se ejecuta haciendo una minimización. 

# bkfilt filters
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="f1">  (entero, opcional)
		<@var="f2">  (entero, opcional)
		<@var="k">  (entero, opcional)

Devuelve una serie con el resultado de la aplicación del filtro paso-banda de Baxter–King a una serie <@var="y">. Los parámetros opcionales <@var="f1"> y <@var="f2"> representan, respectivamente, los límites inferior y superior del rango de frecuencias que se va a extraer, mientras que <@var="k"> representa el orden de aproximación que se va a utilizar. 

Si no se proporcionan esos argumentos, entonces los valores por defecto van a depender de la periodicidad del conjunto de datos. Para datos anuales los valores por defecto para <@var="f1">, <@var="f2"> y <@var="k"> son 2, 8 y 3 respectivamente; para datos trimestrales son 6, 32 y 12; y para datos mensuales son 18, 96 y 36. Esos valores se escogen para coincidir con la elección más común entre los usuarios, que consiste en la utilización de este filtro para extraer la componente de frecuencia del “ciclo de negocios”. Esto, a su vez, se define habitualmente comprendido entre 18 meses y 8 años. El filtro abarca 3 años de datos, en la elección por defecto. 

Si <@var="f2"> es mayor o igual al número de observaciones disponibles, entonces se ejecuta la versión “paso-bajo” del filtro, y la serie resultante debe considerarse como una estimación de la componente de tendencia, más que de la componente del ciclo. Ver también <@ref="bwfilt">, <@ref="hpfilt">. 

# boxcox filters
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="y">  (serie o matriz)
		<@var="d">  (escalar)

Devuelve el resultado de la transformación de Box–Cox con parámetro <@var="d"> de una serie positiva <@var="y"> (o de las columnas de una matriz <@var="y">). 

El resultado es (<@mth="y"><@sup="d"> - 1)/<@mth="d"> para <@mth="d"> distinto de cero, o log(<@mth="y">) para <@mth="d"> = 0. 

# bread data-utils
Resultado: 	bundle 
Argumentos:	<@var="nombrearchivo">  (cadena)
		<@var="importar">  (booleano, opcional)

Devuelve la lectura de un “bundle” a partir de un archivo de texto. La cadena de texto debe contener el nombre del archivo del cual se lee el 'bundle'. Si ese nombre tiene la extensión “<@lit=".gz">”, se asume que se aplicó la compresión gzip cuando se guardó ese archivo. 

El archivo en cuestión debe ser un archivo XML definido apropiadamente: debe contener un elemento <@lit="gretl-bundle">, que se use para almacenar cero o más elementos <@lit="bundled-item">. Por ejemplo: 

<code>          
     <?xml version="1.0" encoding="UTF-8"?>
     <gretl-bundle name="temp">
          <bundled-item key="s" type="string">moo</bundled-item>
          <bundled-item key="x" type="scalar">3</bundled-item>
     </gretl-bundle>
</code>

Como cabría esperar, estos archivos los genera automáticamente la función asociada <@ref="bwrite">. 

Si el nombre del archivo no contiene la especificación completa de la ruta al directorio que lo contiene, entonces va a buscarse en varias localizaciones “probables”, comenzando en lo establecido como <@xrf="workdir"> vigente. Ahora bien, cuando se proporciona un valor no nulo para el argumento opcional <@var="importar">, el archivo va a buscarse en el directorio “punto” del usuario. En este caso, el argumento <@var="nombrearchivo"> deberá ser un nombre simple de archivo, sin la inclusión de la ruta al directorio. 

Si ocurre algún fallo (por ejemplo que el archivo esté mal formateado o sea inaccesible), se devuelve el fallo por medio del acceso <@ref="$error">. 

Ver también <@ref="mread">, <@ref="bwrite">. 

# brename data-utils
Resultado: 	escalar 
Argumentos:	<@var="B">  (bundle)
		<@var="antiguaclave">  (cadena)
		<@var="nuevaclave">  (cadena)

Si el 'bundle' <@var="B"> contiene un elemento que tenga la clave <@var="antiguaclave">, esa clave se cambia por <@var="nuevaclave">; en caso contrario, se muestra un fallo. La función devuelve un 0 cuando se hace correctamente el cambio de nombre. 

# bwfilt filters
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="n">  (entero)
		<@var="omega">  (escalar)

Devuelve una serie con lo que resulta al aplicar un filtro paso-bajo de Butterworth de orden <@var="n"> y frecuencia de corte <@var="omega">, en la serie <@var="y">. El corte se expresa en grados y debe ser mayor o igual a cero, y menor que 180. Los valores de corte más pequeños van a restringir el paso-banda a menores frecuencias, y así producen una tendencia más suave. Los valores mayores de <@var="n"> producen un corte más agudo, pero con el coste de poder tener inestabilidad numérica. 

La inspección preliminar del periodograma de la serie de interés es muy útil cuando se desea aplicar esta función. Para obtener más detalles, consulta <@pdf="El manual de gretl#chap:tsfilter"> (Capítulo 27). Ver también <@ref="bkfilt">, <@ref="hpfilt">. 

# bwrite data-utils
Resultado: 	entero 
Argumentos:	<@var="B">  (bundle)
		<@var="nombrearchivo">  (cadena)
		<@var="exportar">  (booleano, opcional)

Escribe el “bundle” <@var="B"> en un archivo XML con nombre <@var="nombrearchivo">. Si ya existe un archivo denominado <@var="nombrearchivo">, va a sobrescribirse. Para una descripción concisa de su formato, consulta <@ref="bread">. Esta función devuelve el valor 0 en caso de que concluya con éxito; si ocurren fallos, tales como la imposibilidad de sobrescribir el archivo, la función devuelve un valor no nulo. 

El archivo de salida se guarda en el directorio <@xrf="workdir"> vigente, excepto que la cadena <@var="nombrearchivo"> contenga la ruta completa con el directorio en el que va a guardarse. Ahora bien, cuando se indica un valor no nulo para el argumento <@var="exportar">, el archivo de salida se va a guardar en el directorio “punto” del usuario. En este caso, el argumento <@var="nombrearchivo"> deberá ser un nombre simple de archivo, sin la inclusión de la ruta al directorio. 

Por defecto, el archivo XML se guarda sin comprimir, pero si <@var="nombrearchivo"> contiene la extensión <@lit=".gz"> entonces se aplica la compresión gzip. 

Ver también <@ref="bread">, <@ref="mwrite">. 

# cdemean stats
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="tipificar">  (booleano, opcional)

Centra las columnas de la matriz <@var="X"> respecto a sus medias. Si el segundo argumento (opcional) tiene un valor no nulo, entonces los valores centrados se dividen además por las desviaciones típicas de cada columna (que se caculan utilizando <@mth="n"> – 1 como divisor, en el que <@mth="n"> es el número de filas de <@var="X">). 

# cdf probdist
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="d">  (cadena)
		<@var="…">  (mira más abajo)
		<@var="x">  (escalar, serie o matriz)
Ejemplos: 	<@lit="p1 = cdf(N, -2.5)">
		<@lit="p2 = cdf(X, 3, 5.67)">
		<@lit="p3 = cdf(D, 0.25, -1, 1)">

Calcula el valor de la función de distribución acumulativa, y devuelve un resultado (del mismo tipo que el argumento) con la probabilidad <@mth="P(X ≤ x)">, donde la distribución de <@mth="X"> se especifica mediante la letra <@var="d">. Entre los argumentos <@var="d"> y <@var="x"> puede necesitarse algún argumento adicional escalar para especificar los parámetros de la distribución, tal y como se indica a continuación (pero observa que la distribución Normal tiene su propia función, por conveniencia, <@ref="cnorm">): 

<indent>
• Normal estándar (d = z, n o N): sin argumentos extras 
</indent>

<indent>
• Normal bivariante (D): coeficiente de correlación 
</indent>

<indent>
• Logistic (lgt): sin más argumentos 
</indent>

<indent>
• t de Student (t): grados de libertad 
</indent>

<indent>
• Chi-cuadrado (c, x o X): grados de libertad 
</indent>

<indent>
• F de Snedecor (f o F): grados de libertad (num.), grados de libertad (den.) 
</indent>

<indent>
• Gamma (g o G): forma, escala 
</indent>

<indent>
• Binomial (b o B): probabilidad, cantidad de ensayos 
</indent>

<indent>
• Poisson (p o P): media 
</indent>

<indent>
• Exponencial (exp): escala 
</indent>

<indent>
• Weibull (w o W): forma, escala 
</indent>

<indent>
• Laplace (l o L): media; escala 
</indent>

<indent>
• Error Generalizado (E): forma 
</indent>

<indent>
• Chi-cuadrado no central (ncX): grados de libertad, parámetro de no centralidad 
</indent>

<indent>
• F no central (ncF): grados de libertad (num.), grados de libertad (den.), parámetro de no centralidad 
</indent>

<indent>
• t no central (nct): grados de libertad, parámetro de no centralidad 
</indent>

Ten en cuenta que, en la mayoría de los casos, existen alias para ayudar a memorizar los códigos. El caso de la Normal bivariante es especial: la la sintaxis es <@lit="x = cdf(D, rho, z1, z2)"> donde <@lit="rho"> es el coeficiente de correlación entre las variables <@lit="z1"> y <@lit="z2">. 

Ver también <@ref="pdf">, <@ref="critical">, <@ref="invcdf">, <@ref="pvalue">. 

# cdiv linalg
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="Y">  (matriz)

Devuelve una matriz con el resultado de dividir números complejos. Los dos argumentos deben componerse del mismo número de filas, <@mth="n">, y de una o dos columnas. La primera columna contiene la parte real, y la segunda (si existe) contiene la parte imaginaria. El resultado que se devuelve es una matriz de orden <@itl="n">×2 o, en caso de no existir la parte imaginaria, un vector con <@mth="n"> filas. Ver también <@ref="cmult">. 

# cdummify transforms
Resultado: 	lista 
Argumento: 	<@var="L">  (lista)

Esta función devuelve una lista en la que cada serie del argumento <@var="L"> que tenga el atributo “codificado”, se substituye por un conjunto de variables ficticias que representan cada uno de sus valores codificados, pero omitiendo el valor más pequeño. Si el argumento <@var="L"> no contiene ninguna serie codificada, el valor que se devuelve va a ser idéntico a <@var="L">. 

En caso de que se generen, las variables ficticias se nombran con el patrón <@lit="D"><@var="varname"><@lit="_"><@var="vi">, en el que <@var="vi"> indica el <@var="i"><@sup="-ésimo"> valor representado de la variable que se codifica. En caso de que algunos de los valores sean negativos, se va a insertar “m” antes del valor (absoluto) de <@var="vi">. 

Por ejemplo, supón que <@var="L"> contiene una serie codificada llamada <@lit="C1"> con los valores –9, –7, 0, 1 y 2. Entonces, las variables ficticias generadas van a ser <@lit="DC1_m7"> (que codifica cuando C1 = –7), <@lit="DC1_0"> (que codifica cuando C1 = 0), etcétera. 

Ver también <@ref="dummify">, <@ref="getinfo">. 

# ceil math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Función tope: devuelve un resultado (del tipo del argumento) con el menor entero que sea mayor o igual a <@var="x">. Ver también <@ref="floor">, <@ref="int">. 

# cholesky linalg
Resultado: 	matriz cuadradax 
Argumento: 	<@var="A">  (matriz definida positiva)

Realiza la descomposición de Cholesky de la matriz <@var="A">, asumiendo que esta es simétrica y definida positiva. El resultado es una matriz triangular inferior <@mth="L"> que verifica la igualdad <@mth="A = LL'">. La función va a fallar si <@var="A"> no es simétrica o no es definida positiva. Ver también <@ref="psdroot">. 

# chowlin transforms
Resultado: 	matriz 
Argumentos:	<@var="Y">  (matriz)
		<@var="factorx">  (entero)
		<@var="X">  (matriz, opcional)

Devuelve una matriz como resultado de expandir los datos de entrada, <@var="Y">, a una frecuencia mayor, con el método de <@bib="Chow y Lin (1971);chowlin71">. Se asume que las columnas de <@var="Y"> representan series de datos. La matriz que se devuelve tiene el mismo número de columnas que <@var="Y"> y <@var="factorx"> veces su número de filas. 

El segundo argumento representa el factor de expansión: debe ser igual a 3 para expandir datos trimestrales a mensuales, o igual a 4 para hacerlo de datos anuales a trimestrales (estos son los únicos factores admitidos actualmente). El tercer argumento (opcional) puede usarse para proveer una matriz de covariables con mayor frecuencia objetivo. 

Los regresores que se utilizan por defecto son una constante y una tendencia cuadrada. Cuando se proporciona <@var="X">, sus columnas se utilizan como regresores adicionales. La función devuelve un fallo si el número de filas de <@var="X"> no es igual a <@var="factorx"> veces el número de filas de <@var="Y">. 

# cmult linalg
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="Y">  (matriz)

Devuelve una matriz con el resultado de multiplicar números complejos. Los dos argumentos deben componerse del mismo número de filas, <@mth="n">, y de una o dos columnas. La primera columna contiene la parte real y la segunda (si existe) contiene la parte imaginaria. El resultado que se devuelve es una matriz de orden <@itl="n">×2 o, en caso de no existir la parte imaginaria, un vector con <@mth="n"> filas. Ver también <@ref="cdiv">. 

# cnorm probdist
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve la función de distribución acumulativa para una Normal estándar. Ver también <@ref="dnorm">, <@ref="qnorm">. 

# cnumber linalg
Resultado: 	escalar 
Argumento: 	<@var="X">  (matriz)

Devuelve un escalar con el número de condición de una matriz <@var="X"> de orden <@itl="n">×<@itl="k">, conforme se define en <@bib=" Belsley, Kuh y Welsch (1980);belsley-etal80">. Si las columnas de <@var="X"> son mutuamente ortogonales, el número de condición de <@var="X"> es la unidad. Por el contrario, un valor grande del número de condición se entiende como un indicio de alto grado de multicolinealidad; habitualmente se considera que el valor es “grande” si es mayor o igual a 50 (o, algunas veces, a 30). 

Los pasos para hacer los cálculos son: (1) formar una matriz <@mth="Z"> cuyas columnas sean el resultado de dividir cada columna de <@var="X"> por su respectiva norma euclidiana; (2) construir la matriz <@mth="Z'Z"> y obtener sus autovalores; y (3) calcular la raíz cuadrada de la razón entre el mayor y el menor autovalor. 

Ver también <@ref="rcond">. 

# cnameget strings
Resultado: 	cadena o array de cadenas 
Argumentos:	<@var="M">  (matriz)
		<@var="col">  (entero, opcional)

Si indicas el argumento <@var="col">, devuelve una cadena de texto con el nombre de la columna <@var="col"> de la matriz <@var="M">. Si las columnas de <@var="M"> no tienen nombre, entonces se devuelve una cadena vacía; y si <@var="col"> está fuera de los límites del número de columnas de esta matriz, se muestra un fallo. 

Si no indicas el segundo argumento, devuelve un 'array' de cadenas de texto que contiene los nombres de las columnas de <@var="M">, o un 'array' vacío si <@var="M"> no tiene asignados nombres de columnas. 

Ejemplo: 

<code>          
     matrix A = { 11, 23, 13 ; 54, 15, 46 }
     cnameset(A, "Col_A Col_B Col_C")
     string name = cnameget(A, 3)
     print name
</code>

Ver también <@ref="cnameset">. 

# cnameset matbuild
Resultado: 	escalar 
Argumentos:	<@var="M">  (matriz)
		<@var="S">  (array de cadenas o lista)

Añade nombres a las columnas de la matriz de orden <@itl="T">×<@itl="k">, <@var="M">. Cuando <@var="S"> es una lista, los nombres son los de las series listadas (es necesario que esa lista tenga <@mth="k">elementos). Cuando <@var="S"> es un 'array' de cadenas de texto, deberá tener <@mth="k"> elementos. Para mantener la compatibilidad con versiones anteriores de Gretl, puedes también utilizar una única cadena de texto como segundo argumento. En ese caso, esta cadena necesita tener <@mth="k"> subcadenas separadas por espacios. 

Devuelve el valor 0 si las columnas son nombradas con éxito; en caso contrario, devuelve un valor no nulo. Consulta también <@ref="rnameset">. 

Ejemplo: 

<code>          
     matrix M = {1, 2; 2, 1; 4, 1}
     strings S = array(2)
     S[1] = "Col1"
     S[2] = "Col2"
     cnameset(M, S)
     print M
</code>

# cols matshape
Resultado: 	entero 
Argumento: 	<@var="X">  (matriz)

Devuelve un entero con el número de columnas de la matriz <@var="X">. Ver también <@ref="mshape">, <@ref="rows">, <@ref="unvech">, <@ref="vec">, <@ref="vech">. 

# corr stats
Resultado: 	escalar 
Argumentos:	<@var="y1">  (serie o vector)
		<@var="y2">  (serie o vector)

Devuelve un escalar con el valor del coeficiente de correlación entre <@var="y1"> e <@var="y2">. Los argumentos deben ser dos series o dos vectores del mismo tamaño. Ver también <@ref="cov">, <@ref="mcov">, <@ref="mcorr">, <@ref="npcorr">. 

# corrgm stats
Resultado: 	matriz 
Argumentos:	<@var="x">  (serie, matriz o lista)
		<@var="p">  (entero)
		<@var="y">  (serie o vector, opcional)

Cuando se proporcionan solo los dos primeros argumentos, la función devuelve una matriz con el correlograma de <@var="x"> para los retardos desde 1 hasta <@var="p">. Si <@mth="k"> es el número de elementos de <@var="x"> (igual a 1 si <@var="x"> es una serie, igual al número de columnas si <@var="x"> es una matriz, o igual al número de elementos si <@var="x"> es una lista), el valor que se devuelve es una matriz con <@var="p"> filas y 2<@mth="k"> columnas, en la que las <@mth="k"> primeras columnas contienen las respectivas autocorrelaciones, y las restantes contienen las respectivas autocorrelaciones parciales. 

Cuando se indica el tercer argumento, esta función calcula el correlograma cruzado desde <@mth="+"><@var="p"> hasta <@mth="-"><@var="p"> para cada uno de los <@mth="k"> elementos de <@var="x"> e <@var="y">. La matriz que se devuelve se compone de 2<@mth="p"> + 1 filas y <@mth="k"> columnas. Si <@var="x"> es una serie o una lista, e <@var="y"> es un vector, este último es necesario que tenga tantas filas como el número total de observaciones que hay en la muestra seleccionada en vigor. 

# cos math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el coseno de <@var="x">. Ver también <@ref="sin">, <@ref="tan">, <@ref="atan">. 

# cosh math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el coseno hiperbólico de <@var="x">. 

Ver también <@ref="acosh">, <@ref="sinh">, <@ref="tanh">. 

# cov stats
Resultado: 	escalar 
Argumentos:	<@var="y1">  (serie o vector)
		<@var="y2">  (serie o vector)

Devuelve un escalar con la covarianza entre <@var="y1"> e <@var="y2">. Los argumentos deben ser dos series, o bien dos vectores de la misma longitud. Ver también <@ref="corr">, <@ref="mcov">, <@ref="mcorr">. 

# critical probdist
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="c">  (carácter)
		<@var="…">  (mira más abajo)
		<@var="p">  (escalar, serie o matriz)
Ejemplos: 	<@lit="c1 = critical(t, 20, 0.025)">
		<@lit="c2 = critical(F, 4, 48, 0.05)">

Permite calcular valores críticos, y devuelve un resultado del mismo tipo que el introducido. El valor <@mth="x"> que se devuelve va a cumplir <@mth="P(X > x) = p">, donde la distribución de <@mth="X"> se determina por la letra <@var="c">. Entre los argumentos <@var="d"> y <@var="x">, puede necesitarse algún otro adicional (escalar) para indicar los parámetros de la distribución. Esto se hace de este modo: 

<indent>
• Normal estándar (c = z, n o N): sin argumentos extras 
</indent>

<indent>
• t de Student (t): grados de libertad 
</indent>

<indent>
• Chi-cuadrado (c, x o X): grados de libertad 
</indent>

<indent>
• F de Snedecor (f o F): grados de libertad (num.), grados de libertad (den.) 
</indent>

<indent>
• Binomial (b o B): probabilidad, cantidad de ensayos 
</indent>

<indent>
• Poisson (p o P): media 
</indent>

<indent>
• Laplace (l o L): media; escala 
</indent>

<indent>
• Error Generalizado (E): forma 
</indent>

Ver también <@ref="cdf">, <@ref="invcdf">, <@ref="pvalue">. 

# cum transforms
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (serie o matriz)

Acumula <@var="x"> (es decir, crea una suma móvil). Cuando <@var="x"> es una serie, produce una serie <@mth="y"> en la que cada uno de sus elementos es igual a la suma de los valores de <@var="x"> hasta la observación correspondiente. El punto de partida para la acumulación es la primera observación no ausente de la muestra vigente seleccionada. Cuando <@var="x"> es una matriz, sus elementos se acumulan por columnas. 

Ver también <@ref="diff">. 

# curl data-utils
Resultado: 	escalar 
Argumento: 	<@var="&b">  (referenia a bundle)

Ofrece un medio bastante flexible de obtener un “buffer” de texto que contiene datos de un servidor de internet, utilizando la biblioteca 'libcurl'. Al escribirla, el argumento de tipo 'bundle' <@var="b">, debe contener una cadena de texto llamada <@lit="URL"> que indica la dirección completa del recurso en el 'host' de destino. Otros elementos opcionales se presentan a continuación: 

<indent>
• “<@lit="header">”: una cadena de texto que especifica un 'header' HTTP que va a enviarse al 'host'. 
</indent>

<indent>
• “<@lit="postdata">”: una cadena de texto que contiene los datos que van a enviarse al 'host'. 
</indent>

Los campos <@lit="header"> y <@lit="postdata"> se destinan para usarse con una solicitud HTTP de tipo <@lit="POST">. Si está presente <@lit="postdata">, va implícito el método <@lit="POST">; en caso contrario, va implícito el método <@lit="GET">. (Pero observa que para sencillas solicitudes <@lit="GET">, la función <@ref="readfile"> ofrece una interface más simple.) 

Se reconoce otro elemento opcional del 'bundle': si está presente un escalar llamado <@lit="include"> y tiene un valor no nulo, esto se entiende como una solicitud para incluir el 'header' recibido del 'host', en el cuerpo del resultado. 

Al completarse la solicitud, el texto recibido del servidor se añade al 'bundle' con la clave “<@lit="output">”. 

La función va a fallar si hay una equivocación al formular la solicitud (por ejemplo, si no existe una <@lit="URL"> en la entrada); en caso contrario, va a devolver el valor 0 si la solicitud prospera, o un valor no nulo si no lo hace. En este último caso, se añade el mensaje de fallo de la biblioteca 'curl' al 'bundle', con el identificador “<@lit="errmsg">”. Ten en cuenta, sin embargo, que “éxito” en este sentido no significa necesariamente que obtienes los datos que deseabas; en realidad significa tan solo que se recibió alguna respuesta del servidor. Debes comprobar el contenido del “buffer” de salida (que de hecho puede ser un mensaje tal como “Página no encontrada”). 

Aquí tenemos un ejemplo de cómo utilizar esta función: para bajar algunos datos de la web de la US Bureau of Labor Statistics, que requiere el envío de una consulta JSON. Observa el uso de para insertar comillas en los datos <@lit="POST">. 

<code>          
     bundle req
     req.URL = "http://api.bls.gov/publicAPI/v1/timeseries/data/"
     req.include = 1
     req.header = "Content-Type: application/json"
     string s = sprintf("{\"seriesid\":[\"LEU0254555900\"]}")
     req.postdata = s
     err = curl(&req)
     if err == 0
         s = req.output
         string line
         loop while getline(s, line) --quiet
             printf "%s\n", line
         endloop
     endif
</code>

Consulta también las funciones <@ref="jsonget"> y <@ref="xmlget"> para ver modos de procesamiento de datos recibidos en formato JSON y XML, respectivamente. 

# dayspan calendar
Resultado: 	entero 
Argumentos:	<@var="d1">  (entero)
		<@var="d2">  (entero)
		<@var="duracsemana">  (entero)

Devuelve un número entero con el número de días (relevantes) entre los días de época <@var="d1"> y <@var="d2">, ambos incluidos, considerando la duración de semana indicada por el argumento <@var="duracsemana">. Este debe ser igual a 5, 6 o 7 (indicando el valor 6 que no se cuentan los domingos, y el 5 que no se cuentan ni los sábados ni los domingos). 

Para obtener los días de época en el formato más familiar de las fechas, consulta <@ref="epochday">. Relacionado con esto, consulta <@ref="smplspan">. 

# defarray data-utils
Resultado: 	mira más abajo 
Argumento: 	... (mira más abajo)

Permite definir <@itl="detalladamente"> una variable de tipo “array”, proporcionando uno o más elementos. Al utilizar esta función debes especificar el tipo de 'array' (en forma plural): <@lit="strings">, <@lit="matrices">, <@lit="bundles"> o <@lit="lists">. Cada uno de los argumentos debe ser un objeto del mismo tipo que el tipo especificado en la definición del 'array'. En caso de completarse con éxito, la función devuelve como resultado un 'array' con <@mth="n"> elementos, donde <@mth="n"> es igual al número de argumentos. 

<code>          
     strings S = defarray("foo", "bar", "baz")
     matrices M = defarray(I(3), X'X, A*B, P[1:])
</code>

Consulta también <@ref="array">. 

# defbundle data-utils
Resultado: 	bundle 
Argumento: 	... (mira más abajo)

Te permite la carga inicial de una variable de tipo 'bundle' <@itl="extensamente">, proporcionando cero o más parejas con el formato <@var="clave">, <@var="elemento">. Si contamos los argumentos desde 1, cada argumento numerado impar debe evaluar una cadena de texto (clave), y cada argumento numerado par debe evaluar un objeto de un tipo que pueda incluirse en un 'bundle'. 

Un par de ejemplos sencillos: 

<code>          
     bundle b1 = defbundle("s", "Sample string", "m", I(3))
     bundle b2 = defbundle("yn", normal(), "x", 5)
</code>

El primer ejemplo genera un 'bundle' cuyos elementos son una cadena de texto y una matriz; el segundo, un 'bundle' con un elemento que es una serie y otro que es escalar. Ten en cuenta que no puedes especificar un tipo para cada argumento cuando utilizas esta función, entonces debes aceptar el tipo “natural” de argumento en cuestión. Si quieres añadir una serie con un valor constante de 5 a un 'bundle' llamado <@lit="b1"> sería necesario hacer algo como lo siguiente (después de definir <@lit="b1">): 

<code>          
     series b1.s5 = 5
</code>

Si no indicas ningún argumento para esta función, eso equivale a generar un 'bundle' vacío (o a vaciar un 'bundle' existente de su contenido), como podrías hacer mediante 

<code>          
     bundle b = null
</code>

# deflist data-utils
Resultado: 	lista 
Argumento: 	... (mira más abajo)

Genera una lista (de series ya definidas) dados uno o más argumentos apropiados. Cada argumento debe ser, una serie ya definida (indicada por su nombre o el número entero ID), una lista ya definida, o una expresión que se corresponda con una lista (incluyendo un vector que pueda interpretarse como un conjunto de números ID de series). 

Un aspecto a tener en cuenta es que esta función simplemente encadena sus argumentos para producir la lista que devuelve. Cuando se pretende que el valor que devuelva no contenga duplicados (que no se refiera a ninguna serie más de una vez), depende del solicitante asegurarse de que se satisfaga ese requerimiento. 

# deseas filters
Resultado: 	serie 
Argumentos:	<@var="x">  (serie)
		<@var="c">  (carácter, opcional)

Precisa que estén instalados el TRAMO/SEATS y/o X-12-ARIMA. Devuelve una versión desestacionalizada (ajustada estacionalmente) de la serie <@var="x">, que debe ser una serie temporal mensual o trimestral. Para utilizar el X-12-ARIMA indica <@lit="X"> como segundo argumento; y para usar el TRAMO/SEATS indica <@lit="T">. Si omites el segundo argumento, Gretl utiliza el X-12-ARIMA. 

Observa que, cuando la serie de entrada no tiene una componente estacional detectable, la ejecución de la función va a fallar. Ten en cuenta también que tanto el TRAMO/SEATS como el X-12-ARIMA ofrecen un gran número de opciones; ahora bien, la función <@lit="deseas"> las utiliza con todas sus opciones en sus valores por defecto. En ambos programas, los factores estacionales se calculan basados en un modelo ARIMA seleccionado automáticamente. Una de las diferencias entre los dos que puede llevar a resultados bastante distintos, es que el TRAMO/SEATS realiza un ajuste previo de las observaciones con valores atípicos, mientras que el X-12-ARIMA no lo hace. 

# det linalg
Resultado: 	escalar 
Argumento: 	<@var="A">  (matriz cuadradax)

Devuelve un escalar con el valor del determinante de <@var="A">, calculado mediante la descomposición LU. Ver también <@ref="ldet">, <@ref="rcond">, <@ref="cnumber">. 

# diag matbuild
Resultado: 	matriz 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna con los valores de la diagonal principal de <@var="X">. Observa que si <@var="X"> es una matriz de orden <@itl="m">×<@itl="n">, el número de elementos del vector resultante es igual a min(<@mth="m">, <@mth="n">). Ver también <@ref="tr">. 

# diagcat matbuild
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz)
		<@var="B">  (matriz)

Devuelve una matriz con la suma directa de <@var="A"> y <@var="B">; es decir, una matriz que abarca a <@var="A"> en la esquina superior izquierda y a <@var="B"> en la esquina inferior derecha. Si <@var="A"> y <@var="B"> son ambas cuadradas, la matriz resultante es diagonal por bloques. 

# diff transforms
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="y">  (serie, matriz o lista)

Devuelve un resultado (del mismo tipo que el argumento) con las primeras diferencias. Si <@var="y"> es una serie o una lista de series, los valores iniciales son <@lit="NA">; si <@var="y"> es una matriz, la diferenciación se hace por columnas y los valores iniciales son 0. 

Cuando esta función devuelve una lista, cada una de las variables de la misma se nombra de modo automático conforme al patrón <@lit="d_"><@var="varname">, donde <@var="varname"> se substituye por el nombre de la serie original. De ser necesario, el nombre se va a truncar; e incluso se ajustará en caso de que el conjunto de nombres que se construye así, dé lugar a que alguno de ellos no sea único. 

Ver también <@ref="cum">, <@ref="ldiff">, <@ref="sdiff">. 

# digamma math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el valor de la función digamma (o Psi) de <@var="x">, es decir, la derivada del logaritmo de la función Gamma. 

# dnorm probdist
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del mismo tipo que el argumento) con el valor de la densidad de la distribución de probabilidad Normal estándar en <@var="x">. Para obtener la densidad de una distribución Normal no estándar en <@mth="x">, transforma tipificando <@mth="x"> en <@mth="z">, aplícale a esto la función <@lit="dnorm"> y multiplica el resultado por el Jacobiano de la transformación <@mth="z">, es decir , 1/σ, conforme se ilustra a continuación: 

<code>          
     mu = 100
     sigma = 5
     x = 109
     fx = (1/sigma) * dnorm((x-mu)/sigma)
</code>

Ver también <@ref="cnorm">, <@ref="qnorm">. 

# dropcoll transforms
Resultado: 	lista 
Argumentos:	<@var="X">  (lista)
		<@var="epsilon">  (escalar, opcional)

Devuelve una lista con los mismos elementos que <@var="X">, pero excluyendo las series que causan multicolinealidad perfecta. En consecuencia, si todas las series que hay en <@var="X"> son linealmente independientes, la lista que resulta es simplemente una copia de <@var="X">. 

El algoritmo usa la descomposición QR (transformación de Householder), por lo que está sujeto a error de precisión finita. Con el objeto de calibrar la sensibilidad del algoritmo, puedes especificar un segundo parámetro (opcional) <@var="epsilon"> para hacer el contraste de multicolinealidad más o menos estricto, según desees. Por defecto, el valor para <@var="epsilon"> es 1.0e-8, pero ajustando <@var="epsilon"> dándole valores mayores, se eleva la probabilidad de que se descarte una de las series. 

El ejemplo 

<code>          
     nulldata 20
     set seed 9876
     series foo = normal()
     series bar = normal()
     series foobar = foo + bar
     list X = foo bar foobar
     list Y = dropcoll(X)
     list print X
     list print Y
     # Indica un épsilon con un valor muy pequeño
     list Y = dropcoll(X, 1.0e-30)
     list print Y
</code>

produce 

<code>          
     ? list print X
     foo bar foobar
     ? list print Y
     foo bar
     ? list Y = dropcoll(X, 1.0e-30)
     Se ha reemplazado la lista Y
     ? list print Y
     foo bar foobar
</code>

# dsort matshape
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (serie o vector)

Ordena <@var="x"> de forma decreciente, descartando observaciones con valores ausentes cuando <@var="x"> es una serie. Ver también <@ref="sort">, <@ref="values">. 

# dummify transforms
Resultado: 	lista 
Argumentos:	<@var="x">  (serie)
		<@var="omitval">  (escalar, opcional)

El argumento <@var="x"> debe ser una serie discreta. Esta función devuelve una lista con un conjunto de variables ficticias, una para cada uno de los diferentes valores de la serie. Por defecto, el menor valor se trata como la categoría omitida y no va a representarse explícitamente. 

El segundo argumento (opcional) indica el valor de <@var="x"> que debe ser tratado como categoría omitida. Cuando se indica un único argumento, el efecto es equivalente al de utilizar la instrucción: <@lit="dummify(x, min(x))">. Para producir un conjunto completo de variables ficticias, es decir, sin omitir ninguna categoría, puedes usar <@lit="dummify(x, NA)">. 

Las variables que se generan se nombran automáticamente de acuerdo con el siguiente patrón: <@lit="D"><@var="nombrevariable"><@lit="_"><@var="i"> donde <@var="nombrevariable"> indica el nombre de la serie original e <@var="i"> es un índice entero positivo. De ser necesario, la porción original del nombre se va a truncar, e incluso se ajustará en caso de que el conjunto de nombres que se construye así, dé lugar a que alguno de ellos no sea único. 

# easterday calendar
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Poniendo un año como argumento <@var="x">, devuelve un resultado del mismo tipo que este, con la fecha del domingo de Pascua de ese año en el calendario gregoriano, con el formato <@mth="mes + día/100">. Con esta convención, observa que el 10 de abril es 4,1; de ahí que 4,2 represente el día 20 de abril y no el día 2 de abril (que es 4,02). Ejemplo: 

<code>          
     scalar e = easterday(2014)
     scalar m = floor(e)
     scalar d = 100*(e-m)
</code>

# ecdf stats
Resultado: 	matriz 
Argumento: 	<@var="y">  (serie o vector)

Calcula la función de distribución acumulativa (CDF) empírica de <@var="y">. El resultado se devuelve en formato de matriz con dos columnas: la primera contiene los valores únicos ordenados de <@var="y">; y la segunda contiene la frecuencia relativa acumulada, es decir el número de casos en los que su valor es menor o igual al valor correspondiente de la primera columna, dividido por el número total de observaciones. 

# eigengen linalg
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz cuadradax)
		<@var="&U">  (referencia a matriz, o <@lit="null">)

Calcula los autovalores y, opcionalmente, los autovectores de la matriz <@var="A"> de orden <@itl="n">×<@itl="n">. Cuando todos los autovalores son reales, se devuelve una matriz <@itl="n">×1. En caso contrario, el resultado es una matriz <@itl="n">×2, con una primera columna que contiene los elementos reales, y una segunda columna con los elementos imaginarios. No se garantiza que los autovalores se vayan a clasificar en ningún orden en particular. 

Hay dos opciones para el segundo argumento: que se trate del nombre de una matriz ya existente precedida por <@lit="&"> (para indicar la “dirección” de la matriz en cuestión), en cuyo caso en esta matriz se guarda un resultado auxiliar; o que se trate de la palabra clave <@lit="null">, en cuyo caso no se produce el resultado auxiliar. 

Cuando el segundo argumento no es nulo, se va a sobrescribir la matriz especificada con el resultado auxiliar (y no es necesario que la matriz existente tenga la dimensión adecuada para recibir el resultado). El resultado en la matriz <@var="U"> se organiza del siguiente modo: 

<indent>
• Si el <@mth="i">-ésimo autovalor es real, la <@mth="i">-ésima columna de <@mth="U"> va a contener el autovector correspondiente; 
</indent>

<indent>
• Si el <@mth="i">-ésimo autovalor es complejo, la <@mth="i">-ésima columna de <@mth="U"> va a contener la parte real del autovector correspondiente, y la siguiente columna la parte imaginaria. El autovector del autovalor conjugado es el conjugado del autovector. 
</indent>

En otras palabras, los autovectores se guardan en el mismo orden que los autovalores; ahora bien, los autovectores reales ocupan una columna, mientras que los autovectores complejos ocupan dos (y la parte real se guarda primero). Aún así, el número total de columnas es <@mth="n">, pues el autovector conjugado se ignora. 

Ver también <@ref="eigensym">, <@ref="eigsolve">, <@ref="qrdecomp">, <@ref="svd">. 

# eigensym linalg
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz simétrica)
		<@var="&U">  (referencia a matriz, o <@lit="null">)

Funciona del mismo modo que la función <@ref="eigengen">, excepto que el argumento <@var="A"> debe ser simétrico (por lo que, en este caso, se pueden acortar los cálculos), y los autovalores se devuelven en orden ascendente. Si deseas obtener los autovalores en orden descendente (y tener los autovectores reordenados en consecuencia), puedes hacer lo siguiente: 

<code>          
     matrix U
     e = eigensym(A, &U)
     Tmp = msortby((-e' | U)',1)'
     e = -Tmp[1,]'
     U = Tmp[2:,]
     # Ahora los autovalores de mayor a menor
     print e U
</code>

Aviso: Si lo que te interesa es la descomposición espectral de una matriz de la forma <@mth="X'X">, es preferible calcular el argumento mediante el operador <@lit="X'X">, en lugar de utilizar la sintaxis más general <@lit="X'*X">. La primera expresión utiliza un algoritmo especializado que ofrece mayor eficiencia desde el punto de vista del cómputo, y garantiza que el resultado va a ser exactamente simétrico. 

# eigsolve linalg
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz simétrica)
		<@var="B">  (matriz simétrica)
		<@var="&U">  (referencia a matriz, o <@lit="null">)

Resuelve el problema del autovalor generalizado de tipo |<@mth="A"> – λ<@mth="B">| = 0, donde ambas <@mth="A"> y <@mth="B"> son matrices simétricas, y <@mth="B"> se define positiva. Se devuelve directamente una matriz con los autovalores ordenados de forma ascendente. Cuando utilizas el tercer argumento (opcional), este debe ser el nombre de una matriz ya existente, precedida por <@lit="&">. En este caso, los autovectores generalizados se escriben en esta matriz que se indica. 

# epochday calendar
Resultado: 	escalar o serie 
Argumentos:	<@var="año">  (escalar o serie)
		<@var="mes">  (escalar o serie)
		<@var="día">  (escalar o serie)

Devuelve un escalar o una serie, con el número del día especificado por el año, mes y día, en ese orden, en la época actual. El número del día es igual a 1 para el día 1 de enero del año 1 después de Cristo, en el proléptico calendario Gregoriano, y a 733786 para la fecha 01-01-2010. Si alguno de los argumentos es una serie, el valor que se devuelve también tendrá la forma de una serie; en caso contrario, se devuelve un escalar. 

Por defecto, los valores de los argumentos <@var="año">, <@var="mes"> y <@var="día"> se presupone que se están indicando de acuerdo con calendario Gregoriano, pero si el año tiene un valor negativo, la interpretación cambia a la del calendario Juliano. 

Para la inversa de esta función consulta <@ref="isodate">, y también <@ref="juldate"> (para el calendario Juliano). 

# errmsg strings
Resultado: 	cadena 
Argumento: 	<@var="errno">  (entero)

Devuelve una cadena de texto con el mensaje de fallo de Gretl asociada a <@var="errno">, que debe ser un número entero. Consulta también <@ref="$error">. 

# exists data-utils
Resultado: 	entero 
Argumento: 	<@var="nombre">  (cadena)

Devuelve un escalar no nulo si <@var="nombre"> es el nombre que identifica un objeto que ya se definió, sea un escalar, una serie, una matriz, una lista, una cadena de texto, un 'bundle' o un 'array'. En otro caso devuelve 0. Consulta también <@ref="typeof">. 

# exp math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del mismo tipo que el argumento) con la transformación <@mth="e"><@sup="x"> . Con matrices se aplica elemento a elemento. Para la función exponencial matricial consulta <@ref="mexp">. 

# fcstats stats
Resultado: 	matriz 
Argumentos:	<@var="y">  (serie o vector)
		<@var="f">  (serie, lista o matriz)

Genera una matriz que contiene varios estadísticos que sirven para evaluar <@var="f"> como predicción de los datos observados <@var="y">. 

Cuando <@var="f"> es una serie o un vector, el resultado es un vector columna. Cuando <@var="f"> es una lista con <@mth="k"> elementos o una matriz de dimensión <@itl="T">×<@itl="k">, el resultado tiene <@mth="k"> columnas en las que cada una contiene los estadísticos del término correspondiente (serie de la lista o columna de la matriz) como predicción de <@var="y">. 

En todo caso, la dimensión “vertical” de los datos introducidos (la longitud de la muestra vigente para una serie o lista, y el número de filas para una matriz) debe coincidir entre los dos argumentos. 

Las filas de la matriz que se devuelven son como se indica a continuación: 

<code>          
     1  Error medio
     2  Raíz del Error cuadrático medio
     3  Error absoluto medio
     4  Porcentaje de error medio
     5  Porcentaje de error absoluto medio
     6  U de Theil
     7  Proporción de sesgo, UM
     8  Proporción de regresión, UR
     9  Proporción de perturbación, UD
</code>

Para obtener más detalles sobre el cálculo de esos estadísticos y de la interpretación de los valores de <@mth="U">, consulta <@pdf="El manual de gretl#chap:forecast"> (Capítulo 32). 

# fdjac numerical
Resultado: 	matriz 
Argumentos:	<@var="b">  (vector columna)
		<@var="llamaf">  (llamada a función)
		<@var="h">  (escalar, opcional)

Permite calcular una aproximación numérica al Jacobiano asociado al <@mth="n">-vector <@var="b">, así como la función de transformación especificada por el argumento <@var="llamaf">. Al apelar a esta función debes utilizar <@var="b"> como primer argumento de la misma (bien directamente o en forma de puntero), seguido de cualquier argumento adicional que pueda necesitarse; y como resultado se debiera producir una matriz <@itl="m">×1. Cuando se ejecuta con éxito, <@lit="fdjac"> va a devolver una matriz <@itl="m">×<@itl="n"> que contiene el Jacobiano. 

Puedes utilizar el tercer argumento (opcional) para determinar el tamaño de la medida <@mth="h"> que se usa en el mecanismo de aproximación (mira más abajo). Cuando omites este argumento, el tamaño de la medida se determina automáticamente. 

Aquí tienes un ejemplo de su uso: 

<code>          
     matrix J = fdjac(theta, mifunc(&theta, X))
</code>

La función puede utilizar tres métodos distintos: diferencia simple hacia adelante, diferencia bilateral o extrapolación de 4-nodos de Richardson. Estas se corresponden respectivamente con: 

<@mth="J"><@sub="0"> = <@mth="(f(x+h) - f(x))/h"> 

<@mth="J"><@sub="1"> = <@mth="(f(x+h) - f(x-h))/2h"> 

<@mth="J"><@sub="2"> = <@mth="[8(f(x+h) - f(x-h)) - (f(x+2h) - f(x-2h))] /12h"> 

Estas tres alternativas generalmente proporcionan una conciliación entre precisión y velocidad. Puedes elegir entre los distintos métodos utilizando la instrucción <@xrf="set">, y especificando el valor 0, 1 o 2 para la variable <@lit="fdjac_quality">. 

Para más detalles y ejemplos, consulta <@pdf="El manual de gretl#chap:numerical"> (Capítulo 34). 

Ver también <@ref="BFGSmax">, <@ref="numhess">, <@xrf="set">. 

# fevd stats
Resultado: 	matriz 
Argumentos:	<@var="efecto">  (entero)
		<@var="motivo">  (entero)
		<@var="sys">  (bundle, opcional)

Esta función proporciona una alternativa más flexible que el acceso <@ref="$fevd"> para obtener una matriz de descomposición de la varianza del error de predicción (FEVD), después de estimar un VAR o un VECM. Si el argumento final (opcional), solo está disponible cuando el último modelo estimado fue un VAR o un VECM. Como alternativa, puedes guardar en un 'bundle' la información sobre estos tipos de sistemas, mediante el acceso <@ref="$system">, y posteriormente pasarle la función <@lit="fevd">. 

Los argumentos de la función, <@var="efecto"> e <@var="motivo">, tienen la forma de índices enteros positivos de las variables endógenas del sistema, tomando el 0 para representar “todas”. El siguiente fragmento de código, ilustra su uso. En el primer ejemplo, la matriz <@lit="fe1"> contiene las partes de la FEVD para <@lit="y1"> debidas a cada parte de <@lit="y1">, <@lit="y2"> e <@lit="y3"> (por lo tanto, las filas suman 1 en total). En el segundo, <@lit="fe2"> contiene la contribución de <@lit="y2"> a la varianza del error de predicción de las tres variables (entonces, las filas no suman 1 en total). En el tercer caso, lo que se devuelve es un vector columna que muestra la “parte propia” de la FEVD de <@lit="y1">. 

<code>          
     var 4 y1 y2 y3
     bundle vb = $system
     matrix fe1 = fevd(1, 0, vb)
     matrix fe2 = fevd(0, 2, vb)
     matrix fe3 = fevd(1, 1, vb)
</code>

El número de períodos (filas) sobre los que se traza la descomposición, se determina automáticamente en base a la frecuencia de los datos, pero puedes ignorar esto mediante el argumento <@lit="horizon"> de la instrucción <@xrf="set">, como en <@lit="set horizon 10">. 

Ver también <@ref="irf">. 

# fft linalg
Resultado: 	matriz 
Argumento: 	<@var="X">  (matriz)

Devuelve una matriz con la transformación de Fourier real. Si la matriz <@var="X"> del argumento tiene <@mth="n"> columnas, la que se devuelve tiene 2<@mth="n"> columnas, donde las partes reales se guardan en las columnas impares y las partes complejas en las columnas pares. 

Cuando necesites aplicar la transformación de Fourier sobre varios vectores con el mismo número de elementos, resulta numéricamente más eficiente agrupar los vectores en una matriz que ejecutar <@lit="fft"> para cada uno por separado. Ver también <@ref="ffti">. 

# ffti linalg
Resultado: 	matriz 
Argumento: 	<@var="X">  (matriz)

Devuelve una matriz con <@mth="n"> columnas, con el resultado de la transformación inversa discreta real de Fourier. Se asume que la matriz <@var="X"> consta de <@mth="n"> vectores columna complejos, con la parte real en las columnas impares y la parte imaginaria en las columnas pares, de forma que deberá tener 2<@mth="n"> columnas. 

Cuando necesites aplicar la transformación inversa de Fourier sobre varios vectores con el mismo número de elementos, resulta numéricamente más eficiente agrupar los vectores en una matriz que ejecutar <@lit="ffti"> para cada uno por separado. Ver también <@ref="fft">. 

# filter filters
Resultado: 	mira más abajo 
Argumentos:	<@var="x">  (serie o matriz)
		<@var="a">  (escalar o vector, opcional)
		<@var="b">  (escalar o vector, opcional)
		<@var="y0">  (escalar, opcional)

Devuelve el resultado de aplicar un filtro parecido a un ARMA, al argumento <@var="x">. La transformación puede escribirse como 

<@mth="y"><@sub="t"> = <@mth="a"><@sub="0"> <@mth="x"><@sub="t"> + <@mth="a"><@sub="1"> <@mth="x"><@sub="t-1"> + ... <@mth="a"><@sub="q"> <@mth="x"><@sub="t-q"> + <@mth="b"><@sub="1"> <@mth="y"><@sub="t-1"> + ... <@mth="b"><@sub="p"><@mth="y"><@sub="t-p"> 

Si el argumento <@var="x"> es una serie, el resultado que se devuelve también es una serie. En caso contrario, si <@var="x"> es una matriz con <@mth="T"> filas y <@mth="k"> columnas, lo que se devuelve es la matriz del mismo tamaño que resulta de aplicar el filtro columna por columna. 

Los argumentos <@var="a"> y <@var="b"> son opcionales. Pueden ser escalares, vectores o la palabra clave <@lit="null">. 

Cuando <@var="a"> es un escalar, se va a utilizar como <@mth="a"><@sub="0"> y eso implicará que <@mth="q=0">. Cuando es un vector con <@mth="q+1"> elementos, va a contener los coeficientes desde <@mth="a"><@sub="0"> hasta <@mth="a"><@sub="q">. Cuando <@var="a"> es <@lit="null"> o se omite, esto es equivalente a definir <@mth="a"><@sub="0"> <@mth="=1"> y <@mth="q=0">. 

Cuando <@var="b"> es un escalar, se va a utilizar como <@mth="b"><@sub="1"> e implicará que <@mth="p=1">. Cuando es un vector con <@mth="p"> elementos, va a contener los coeficientes desde <@mth="b"><@sub="1"> hasta <@mth="b"><@sub="p">. Cuando <@var="b"> es <@lit="null"> o se omite, esto es equivalente a definir <@mth="B(L)=1">. 

El argumento escalar opcional <@var="y0"> se utiliza para representar todos los valores de <@mth="y"> anteriores al inicio de la muestra (se usa solo cuando <@mth="p>0">). Cuando se omite, se entiende que es igual a 0. Se asume que los valores de <@var="x"> anteriores al inicio de la muestra son siempre 0. 

Ver también <@ref="bkfilt">, <@ref="bwfilt">, <@ref="fracdiff">, <@ref="hpfilt">, <@ref="movavg">, <@ref="varsimul">. 

Ejemplo: 

<code>          
     nulldata 5
     y = filter(index, 0.5, -0.9, 1)
     print index y --byobs
     x = seq(1,5)' ~ (1 | zeros(4,1))
     w = filter(x, 0.5, -0.9, 1)
     print x w
</code>

produce 

<code>          
          index            y
          
          1            1     -0.40000
          2            2      1.36000
          3            3      0.27600
          4            4      1.75160
          5            5      0.92356
          
          x (5 x 2)
          
          1   1
          2   0
          3   0
          4   0
          5   0
          
          w (5 x 2)
          
          -0.40000     -0.40000
          1.3600      0.36000
          0.27600     -0.32400
          1.7516      0.29160
          0.92356     -0.26244
</code>

# firstobs data-utils
Resultado: 	entero 
Argumento: 	<@var="y">  (serie)

Devuelve el número entero positivo que indexa la primera observación no ausente de la serie <@var="y">. Ten en cuenta que, si está activa alguna forma de submuestreo, el valor que se devuelve puede ser menor que el valor devuelto por el acceso <@ref="$t1">. Ver también <@ref="lastobs">. 

# fixname strings
Resultado: 	cadena 
Argumentos:	<@var="nombresobrio">  (cadena)
		<@var="underscore">  (booleano, opcional)

En principio, esta función está ideada para utilizarse en conjunto con la instrucción <@xrf="join">. Devuelve una cadena con el resultado de la conversión de <@var="nombresobrio"> en un identificador válido de Gretl; debe iniciarse con una letra, debe contener solo letras ASCII, dígitos y/o guion bajo, y no debe tener más de 31 caracteres. Las reglas que se utilizan en la conversión son: 

1. Quitar, del principio del nombre, cualquier carácter que no sea una letra. 

2. Hasta que se alcanza el límite de los 31 caracteres o hasta que se agota lo indicado en el argumento: transcribe los caracteres “legales”, substituye uno o varios espacios consecutivos por un guion bajo (excepto que el carácter anterior transcrito sea un guion bajo, pues entonces se elimina el espacio), y omite los otros tipos de caracteres “ilegales”. 

Si estás convencido de que la entrada no es demasiado larga (entonces susceptible de ser truncada), puedes querer substituir secuencias de uno o más caracteres ilícitos mediante un guion bajo (en lugar de solo eliminarlos) pues esto podría generar un identificador más legible. Para lograr este efecto, proporciona un valor no nulo para el segundo argumento (opcional). Pero esto no es recomendable en el contexto de la instrucción <@xrf="join">, puesto que el nombre “fijado” automáticamente no va a utilizar guiones bajos de esta manera. 

# floor math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="y">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el valor del mayor entero que es menor o igual que <@var="x">. Ten en cuenta que <@ref="int"> y <@lit="floor"> tienen efectos distintos con argumentos negativos:<@lit="int(-3.5)"> genera –3, mientras que <@lit="floor(-3.5)"> genera –4. 

# fracdiff filters
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="d">  (escalar)

Devuelve una serie con la diferencia fraccionaria de orden <@var="d"> de la serie <@var="y">. 

Observa que, en teoría, la diferenciación fraccionaria supone un filtro infinitamente largo. Los valores de <@mth="y"><@sub="t"> anteriores a la muestra, en la práctica se asume que son iguales a cero. 

Puedes utilizar valores negativos para <@var="d">, y en ese caso la función realiza la integración fraccionaria. 

# gammafun math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el valor de la función Gamma de <@var="x">. 

# genseries data-utils
Resultado: 	escalar 
Argumentos:	<@var="nombrevar">  (cadena)
		<@var="rhs">  (serie)

Le proporciona al guionista un procedimiento adecuado para generar series cuyos nombres no se conocen a priori; y/o de crear series y añadirlas a una lista por medio de una única operación (devuelve un escalar). 

El primer argumento proporciona el nombre de la serie que se va a crear (o modificar); y puede ser un texto literal, una cadena de texto o una expresión cuyo resultado sea una cadena de texto. El segundo argumento, <@var="rhs"> (“lado derecho” en inglés), define la serie original: esto puede ser el nombre de una serie existente o una expresión cuyo resultado sea una serie, en el modo en que aparece habitualmente al lado derecho del símbolo de igualdad cuando se definen series. 

El valor que devuelve esta función es un escalar con el número ID de la serie en el conjunto de datos, que es adecuado para incluir la serie en una lista (o –1 en caso de fallar la ejecución de la función). 

Por ejemplo, supón que quieres añadir <@mth="n"> series aleatorias con distribución de probabilidad Normal al conjunto de datos, y colocarlas en una lista. El siguiente código hace eso: 

<code>          
     list Normales = null
     loop i=1..n --quiet
         Normales += genseries(sprintf("norm%d", i), normal())
     endloop
</code>

Al finalizar la ejecución, la lista <@lit="Normales"> va a contener las series <@lit="norm1">, <@lit="norm2"> y así sucesivamente. 

# getenv strings
Resultado: 	cadena 
Argumento: 	<@var="s">  (cadena)

Cuando ya está definida una variable de entorno con el nombre del argumento <@var="s">, la función devuelve el valor de esa variable como cadena de texto; en caso contrario, devuelve una cadena de texto vacía. Consulta también <@ref="ngetenv">. 

# getinfo data-utils
Resultado: 	bundle 
Argumento: 	<@var="y">  (serie)

Devuelve información sobre la serie especificada, la cual puedes indicar mediante su nombre o su número ID. El 'bundle' que se devuelve contiene todos los atributos que se pueden establecer por medio de la instrucción <@xrf="setinfo">. Y también contiene información adicional relevante para series que se generaron como transformaciones de datos primarios (mediante retardos, logaritmos, etc.); esto incluye la palabra de la instrucción de Gretl para la transformación con la clave “transform”, y el nombre de la serie asociada primaria con la clave “parent”. Para las series retardadas, puedes encontrar el número específico de retardos bajo la clave “lag”. 

Aquí tienes un ejemplo de su uso: 

<code>          
     open data9-7
     lags QNC
     bundle b = getinfo(QNC_2)
     print b
</code>

Al ejecutar lo anterior, podemos ver: 

<code>          
     has_string_table = 0
     lag = 2
     parent = QNC
     name = QNC_2
     graph_name = 
     coded = 0
     discrete = 0
     transform = lags
     description = = QNC(t - 2)
</code>

Para comprobar si la serie 5 de un conjunto de datos es un término retardado, puedes hacer este tipo de cosas: 

<code>          
     if getinfo(5).lag != 0
        printf "La serie 5 es un retardo de %s\n", getinfo(5).parent
     endif
</code>

Ten en cuenta que puedes utilizar la notación con el punto para acceder a los elementos de un 'bundle', incluso cuando el 'bundle' es “anónimo” (no guardado con su propio nombre). 

# getkeys data-utils
Resultado: 	array de cadenas 
Argumento: 	<@var="b">  (bundle)

Devuelve un 'array' de las cadenas de texto que contienen las claves que identifican el contenido de <@var="b">. Si el 'bundle' está vacío, se devuelve un 'array' vacío. 

# getline strings
Resultado: 	escalar 
Argumentos:	<@var="origen">  (cadena)
		<@var="destino">  (cadena)

Esta función lee filas consecutivas de <@var="origen">, que debe ser una cadena de texto ya definida. Con cada llamada a la función se escribe una línea de texto en <@var="destino"> (que también debe ser una cadena de texto) sin el carácter de línea nueva. El valor que se devuelve es un escalar igual a 1, cuando existe algo por leer (incluidas filas en blanco), o igual a 0 si todas las filas de <@var="origen"> ya se leyeron. 

A continuación se presenta un ejemplo en el que el contenido de un archivo de texto se divide en filas: 

<code>          
     string s = readfile("data.txt")
     string line
     scalar i = 1
     loop while getline(s, line)
         printf "line %d = '%s'\n", i++, line
     endloop
</code>

En el ejemplo se puede asegurar que, cuando finalice el bucle, el texto de <@var="origen"> ya está agotado. Si no deseas agotarlo todo, puedes hacer una llamada normal a <@lit="getline">, seguida de una nueva llamada de “limpieza”, cambiando el argumento <@var="destino"> por <@lit="null"> (o dejarlo en blanco), con lo que se reinicia la lectura de <@var="origen">, como en 

<code>          
     getline(s, line) # Obtiene una única fila
     getline(s, null) # Reinicia la lectura
</code>

Ten en cuenta que, aunque avanza la posición de lectura cada vez que se ejecuta <@lit="getline">, el argumento <@var="origen"> no se altera con esa función; solo cambia <@var="destino">. 

# ghk stats
Resultado: 	matriz 
Argumentos:	<@var="C">  (matriz)
		<@var="A">  (matriz)
		<@var="B">  (matriz)
		<@var="U">  (matriz)
		<@var="&dP">  (referencia a matriz, o <@lit="null">)

Calcula la aproximación GHK (Geweke, Hajivassiliou, Keane) a la función de distribución Normal multivariante; puedes consultar, por ejemplo, <@bib="Geweke (1991);geweke91">. El valor que se devuelve es un vector <@itl="n">×1 de probabilidades. 

El argumento matricial <@var="C"> (<@itl="m">×<@itl="m">) debe aportar el factor de Cholesky (matriz triangular inferior) de la matriz de covarianzas de <@mth="m"> variables Normales. Los argumentos matriciales <@var="A"> y <@var="B"> deben ser ambos <@itl="n">×<@itl="m">; e indicar respectivamente los límites inferior y superior que se aplican a las variables en cada una de las <@mth="n"> observaciones. Donde las variables no tengan límites, eso se debe indicar usando la constante <@ref="$huge"> o su negativo. 

La matriz <@var="U"> debe ser <@itl="m">×<@itl="r">, donde <@mth="r"> indica el número de extracciones pseudoaleatorias de una distribución Uniforme. Para crear <@var="U"> son adecuadas las funciones <@ref="muniform"> y <@ref="halton">. 

Debajo se ilustra esto con un ejemplo relativamente simple, en el que las probabilidades multivariantes pueden calcularse analíticamente. Las series <@lit="P"> y <@lit="Q"> deben ser numéricamente muy semejantes una a la otra, denotando como <@lit="P"> a la probabilidad “verdadera” y como <@lit="Q"> a su aproximación GHK: 

<code>          
     nulldata 20
     series inf1 = -2*uniform()
     series sup1 = 2*uniform()
     series inf2 = -2*uniform()
     series sup2 = 2*uniform()

     scalar rho = 0.25
     matrix V = {1, rho; rho, 1}

     series P = cdf(D, rho, inf1, inf2) - cdf(D, rho, sup1, inf2) \
     - cdf(D, rho, inf1, sup2) + cdf(D, rho, sup1, sup2)

     C = cholesky(V)
     U = halton(2, 100)

     series Q = ghk(C, {inf1, inf2}, {sup1, sup2}, U)
</code>

El argumento opcional <@var="dP"> se usa para obtener la matriz <@itl="n">×<@itl="k"> de derivadas de las probabilidades, donde <@mth="k"> equivale a 2<@mth="m"> + <@mth="m">(<@mth="m"> + 1)/2. Las primeras <@mth="m"> columnas van a contener las derivadas con respecto a los límites inferiores; las <@mth="m"> siguientes van a recoger las derivadas con respecto a los límites superiores; y las restantes columnas van a recoger las derivadas con respecto a los elementos singulares de la matriz <@mth="C">, en el orden que sigue la semivectorización “vech” de una matriz simétrica. 

# gini stats
Resultado: 	escalar 
Argumento: 	<@var="y">  (serie o vector)

Devuelve un escalar con el índice de desigualdad de Gini para la serie o vector (no negativos) <@var="y">. Un valor de Gini igual a cero indica igualdad perfecta. El máximo valor de Gini para una serie con <@mth="n"> elementos es (<@mth="n"> – 1)/<@mth="n">, lo que sucede cuando únicamente un elemento tiene un valor positivo; por lo tanto, un valor de Gini igual a 1.0 es el límite que se alcanza cuando una serie muy larga tiene máxima desigualdad. 

# ginv linalg
Resultado: 	matriz 
Argumento: 	<@var="A">  (matriz)

Devuelve la matriz <@mth="A"><@sup="+">, la matriz pseudoinversa de Moore–Penrose o inversa generalizada de <@var="A">, calculada mediante la descomposición en valores singulares. 

Esta matriz posee las siguientes propiedades: <@mth="A"> <@mth="A"><@sup="+"> <@mth="A"> = <@mth="A"> y <@mth="A"><@sup="+"> <@mth="A"> <@mth="A"><@sup="+"> = <@mth="A"><@sup="+">. Además de eso, los productos <@mth="A"> <@mth="A"><@sup="+"> y <@mth="A"><@sup="+"> <@mth="A"> son simétricos por construcción. 

Ver también <@ref="inv">, <@ref="svd">. 

# GSSmax numerical
Resultado: 	escalar 
Argumentos:	<@var="&b">  (referencia a matriz)
		<@var="f">  (llamada a función)
		<@var="toler">  (escalar, opcional)

Maximización unidimensional mediante el método Golden Section Search (GSS). La matriz <@var="b"> del argumento debe ser un vector de 3 elementos. Al definirla, el primer elemento se ignora, mientras que el segundo y tercer elementos establecen los límites inferior y superior de la búsqueda. El argumento <@var="fncall"> deberá especificar una llamada a la función que devuelve el valor del concepto a maximizar; el término 1 de <@var="b"> (que deberá contener el valor vigente del parámetro que se ajusta cuando se invoca la función) debe indicarse como primer argumento; cualquier otro argumento requerido puede ir entonces a continuación. La función en cuestión deberá ser unimodal (no debe tener otro máximo local que no sea el máximo global) en el rango estipulado, pues de lo contrario no se asegura que GSS encuentre el máximo. 

Al completarse con éxito, <@lit="GSSmax"> devolverá el valor óptimo del concepto que se quiere maximizar, mientras que <@var="b"> contendrá el valor óptimo del parámetro junto con los límites de su ventana de valores. 

El tercer argumento (opcional) puede utilizarse para establecer la tolerancia para alcanzar la convergencia; es decir, la amplitud máxima admisible de la ventana final de valores del parámetro. Si no indicas este argumento, se utiliza el valor 0.0001. 

Si tu objetivo realmente es alcanzar un mínimo, puedes bien cambiar la función considerando el negativo del criterio, o bien, alternativamente, puedes invocar la función <@lit="GSSmax">bajo el alias <@lit="GSSmin">. 

Aquí tienes un ejemplo sencillo de utilización: 

<code>          
     function scalar trigfunc (scalar theta)
         return 4 * sin(theta) * (1 + cos(theta))
     end function

     matrix m = {0, 0, $pi/2}
     eval GSSmax(&m, trigfunc(m[1]))
     printf "\n%10.7f", m
</code>

# GSSmin numerical
Resultado: 	escalar 

Un alias de <@ref="GSSmax">. Si invocas la función bajo este nombre, se ejecuta haciendo una minimización. 

# halton stats
Resultado: 	matriz 
Argumentos:	<@var="m">  (entero)
		<@var="r">  (entero)
		<@var="desfase">  (entero, opcional)

Devuelve una matriz <@itl="m">×<@itl="r"> que contiene <@mth="m"> secuencias de Halton de longitud <@mth="r">, donde el valor de <@mth="m"> está limitado a un máximo de 40. Las secuencias se construyen utilizando los primeros <@mth="m"> números primos. Por defecto, se descartan los primeros 10 elementos de cada una de las secuencias, aunque puedes ajustar esto por medio del argumento opcional <@var="desfase">, que debe ser un número entero no negativo. Para obtener más detalles puedes consultar <@bib="Halton y Smith (1964);halton64">. 

# hdprod linalg
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="Y">  (matriz)

Devuelve la matriz que resulta del producto directo horizontal de dos matrices. Los dos argumentos deben tener el mismo número de filas, <@mth="r">. El valor que se devuelve es una matriz que tiene <@mth="r"> filas, y en la que la <@mth="i">-ésima fila es el producto de Kronecker de las respectivas filas de las matrices <@var="X"> e <@var="Y">. 

Esta operación se llama “producto directo horizontal” de acuerdo con la forma en la que se pone en funcionamiento, y se aplica en el lenguaje de programación GAUSS. Su equivalente en el álgebra matricial estándar podría denominarse producto horizontal (row-wise) de Khatri-Rao. 

Ejemplo: el código... 

<code>          
     A = {1,2,3; 4,5,6}
     B = {0,1; -1,1}
     C = hdprod(A, B)
</code>

produce la siguiente matriz: 

<code>          
          0    1    0    2    0    3
         -4    4   -5    5   -6    6
</code>

# hfdiff midas
Resultado: 	lista 
Argumentos:	<@var="hfvars">  (lista)
		<@var="multiplicador">  (escalar)

Dada una <@xrf="MIDAS_list">, la función devuelve otra lista de la misma longitud que contiene las primeras diferencias de alta frecuencia. El segundo argumento es opcional y, por defecto, igual a 1: puedes utilizarlo para multiplicar las diferencias por alguna constante. 

# hfldiff midas
Resultado: 	lista 
Argumentos:	<@var="hfvars">  (lista)
		<@var="multiplicador">  (escalar)

Dada una <@xrf="MIDAS_list">, la función devuelve otra lista de la misma longitud que contiene las diferencias logarítmicas de alta frecuencia. El segundo argumento es opcional y, por defecto, igual a 1: puede utilizarse para multiplicar las diferencias por alguna constante; por ejemplo, podrías darle el valor 100 para obtener aproximadamente las variaciones porcentuales. 

# hflags midas
Resultado: 	lista 
Argumentos:	<@var="retardomin">  (entero)
		<@var="retardomax">  (entero)
		<@var="hfvars">  (lista)

Dada una <@xrf="MIDAS_list">, <@var="hfvars">, la función devuelve otra lista con los retardos de alta frecuencia desde <@var="retardomin"> hasta <@var="retardomax">. Debes utilizar valores positivos para indicar los retardos, y negativos para indicar los adelantos. Por ejemplo, si <@var="retardomin"> es –3, y <@var="retardomax"> es 5, entonces la lista que se va a devolver contendrá 9 series: 3 adelantos, el valor actual y 5 retardos. 

Ten en cuenta que el retardo 0 de alta frecuencia se corresponde con el primer período de alta frecuencia, dentro de un período de baja frecuencia; por ejemplo, correspondería con el primer mes dentro de un trimestre o con el primer día dentro de un mes. 

# hflist midas
Resultado: 	lista 
Argumentos:	<@var="x">  (vector)
		<@var="m">  (entero)
		<@var="prefijo">  (cadena)

Produce una <@xrf="MIDAS_list"> de <@var="m"> series a partir del vector <@var="x">, donde <@var="m"> indica la razón entre la frecuencia (mayor) de las observaciones de la variable <@var="x"> y la frecuencia base (menor) del conjunto vigente de datos. El valor de <@var="m"> debe ser mayor o igual a 3, y el tamaño de <@var="x"> debe ser igual a <@var="m"> veces el tamaño del rango de la muestra vigente. 

Los nombres de las series de la lista que se devuelve, se construyen a partir del <@var="prefijo"> indicado (que debe ser una cadena de texto, de una longitud máxima de 24 caracteres ASCII, y válida como identificador de Gretl), a la que se añade uno o más dígitos que representan el subperíodo de la observación. Si alguno de esos nombres repite el de algún objeto ya existente, se muestra un fallo. 

# hpfilt filters
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="lambda">  (escalar, opcional)
		<@var="una-parte">  (booleano, opcional)

Devuelve una serie que recoge la componente cíclica del filtro de Hodrick–Prescott aplicado a la serie <@var="y">. Si no se indica el parámetro de suavizado <@var="lambda">, Gretl usa valores por defecto basados en la periodicidad de los datos; en concreto, el parámetro es igual a 100 veces el cuadrado de la periodicidad (100 para datos anuales, 1600 para datos trimestrales, etc). 

Por defecto, el filtro es el de la habitual versión de dos partes (pasado y futuro), pero si indicas el tercer argumento (opcional) mediante un valor no nulo, se calcula la variante de una sola parte (sin mirada hacia adelante) del modo que se indica en <@bib="Stock y Watson (1999);stock-watson1999">. 

El uso más habitual del filtro HP es para la eliminación de la tendencia, pero si estás interesado en la propia tendencia, es fácil obtenerla mediante substracción, como en el ejemplo siguiente: 

<code>          
     series hptrend = y - hfilt(y)
</code>

Ver también <@ref="bkfilt">, <@ref="bwfilt">. 

# hyp2f1 math
Resultado: 	escalar o matriz 
Argumentos:	<@var="a">  (escalar)
		<@var="b">  (escalar)
		<@var="c">  (escalar)
		<@var="x">  (escalar o matriz)

Devuelve el valor de la función hipergeométrica de Gauss para el argumento real <@var="x">. 

Cuando <@var="x"> es un escalar, el valor que se devuelve va a ser un escalar; en caso contrario, va a ser una matriz con la misma dimensión que <@var="x">. 

# I matbuild
Resultado: 	matriz cuadradax 
Argumento: 	<@var="n">  (entero)

Devuelve una matriz identidad con <@var="n"> filas y columnas. 

# imaxc stats
Resultado: 	vector fila 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector fila que indica, para cada columna de la matriz <@var="X">, cual es la fila que tiene el valor más grande. 

Ver también <@ref="imaxr">, <@ref="iminc">, <@ref="maxc">. 

# imaxr stats
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna que indica, para cada fila de la matriz <@var="X">, cual es la columna que tiene el valor más grande. 

Ver también <@ref="imaxc">, <@ref="iminr">, <@ref="maxr">. 

# imhof probdist
Resultado: 	escalar 
Argumentos:	<@var="M">  (matriz)
		<@var="x">  (escalar)

Calcula la Prob(<@mth="u'Au"> < <@mth="x">) para una forma cuadrática de variables Normales estándar, <@mth="u">, usando el procedimiento desarrollado por <@bib="Imhof (1961);imhof61">. 

Si el primer argumento <@var="M"> es una matriz cuadrada, se toma para que represente a <@mth="A">. Si es un vector columna, se toman sus elementos como si fuesen los autovalores calculados previamente de <@mth="A">, y en otro caso se presenta un fallo. 

Ver también <@ref="pvalue">. 

# iminc stats
Resultado: 	vector fila 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector fila que indica, para cada columna de la matriz <@var="X">, cual es la fila que tiene el valor más pequeño. 

Ver también <@ref="iminr">, <@ref="imaxc">, <@ref="minc">. 

# iminr stats
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna que indica, para cada fila de la matriz <@var="X">, cual es la columna que tiene el valor más pequeño. 

Ver también <@ref="iminc">, <@ref="imaxr">, <@ref="minr">. 

# inbundle data-utils
Resultado: 	entero 
Argumentos:	<@var="b">  (bundle)
		<@var="llave">  (cadena)

Comprueba si el 'bundle' <@var="b"> contiene un elemento con el nombre <@var="llave">. Devuelve un entero con el código del tipo de elemento: 0 en caso de no encontrarlo y, en caso de hacerlo, 1 para un escalar, 2 para una serie, 3 para una matriz, 4 para una cadena de texto, 5 para un 'bundle', 6 para un 'array' y 7 para una lista. En base al valor de su código, la función <@ref="typestr"> se puede usar para obtener la cadena de texto que expresa el tipo de elemento que es. 

# infnorm linalg
Resultado: 	escalar 
Argumento: 	<@var="X">  (matriz)

Devuelve un escalar con la norma-infinito de la matriz <@var="X">, es decir, el máximo valor que se obtiene al sumar los valores absolutos de los elementos de la matriz <@var="X"> que hay en cada fila. 

Ver también <@ref="onenorm">. 

# inlist data-utils
Resultado: 	entero 
Argumentos:	<@var="L">  (lista)
		<@var="y">  (serie)

Devuelve un entero positivo con la posición de <@var="y"> en la lista <@var="L">, o 0 si <@var="y"> no está presente en <@var="L">. 

El segundo argumento puedes indicarlo tanto con el nombre de la serie como con el entero positivo que identifica la serie (ID). Cuando sabes que existe una serie con un nombre concreto (por ejemplo, <@lit="foo">), puedes ejecutar esta función de la siguiente forma: 

<code>          
     pos = inlist(L, foo)
</code>

Con la expresión anterior estás pidiendo: “Indícame con un entero la posición de la serie <@lit="foo"> en la lista <@lit="L"> (o 0 si no está incluida en esa lista)”. De cualquier modo, si no tienes certeza de que exista una serie con un nombre concreto, debes indicar ese nombre entre comillas de esta forma: 

<code>          
     pos = inlist(L, "foo")
</code>

En este caso, lo que estás solicitando es: “Si existe una serie llamada <@lit="foo"> en la lista <@lit="L">, indícame su posición; en caso de que no exista, devuelve un 0.” 

# instring strings
Resultado: 	entero 
Argumentos:	<@var="s1">  (cadena)
		<@var="s2">  (cadena)

Este es un booleano relativo de <@ref="strstr">: devuelve 1 si <@var="s1"> contiene <@var="s2">, y 0 en caso contrario. De este modo, la expresión condicional 

<code>          
     if instring("gatada", "gata")
</code>

es equivalente lógicamente (pero más eficiente) que 

<code>          
     if strlen(strstr("gatada", "gata")) > 0
</code>

# int math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con la parte entera de <@var="x">, truncando la parte decimal. Ten en cuenta que <@lit="int"> y <@ref="floor"> producen distintos efectos con argumentos negativos: <@lit="int(-3.5)"> genera –3, mientras que <@lit="floor(-3.5)"> genera –4. Ver también <@ref="ceil">. 

# inv linalg
Resultado: 	matriz 
Argumento: 	<@var="A">  (matriz cuadradax)

Devuelve la matriz inversa de <@var="A">. Cuando esta última es una matriz singular o no cuadrada, se produce un mensaje de fallo y no se devuelve nada. Ten en cuenta que Gretl comprueba automáticamente la estructura de <@var="A">, y utiliza el procedimiento numérico más eficiente para realizar la inversión. 

Los tipos de matriz que Gretl comprueba automáticamente son: identidad, diagonal, simétrica definida positiva, simétrica definida no positiva, y triangular. 

Nota: En buena lógica, solo debes utilizar esta función cuando tratas de aplicar la inversa de <@var="A"> más de una vez. Cuando únicamente necesitas calcular, por ejemplo, una expresión de la forma <@mth="A"><@sup="-1"><@mth="B">, es preferible que utilices los operadores de “división”: <@lit="\"> y <@lit="/">. Para obtener más detalles, puedes consultar <@pdf="El manual de gretl#chap:matrices"> (Capítulo 16). 

Ver también <@ref="ginv">, <@ref="invpd">. 

# invcdf probdist
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="d">  (cadena)
		<@var="…">  (mira más abajo)
		<@var="p">  (escalar, serie o matriz)

Calcula la inversa de la función de distribución acumulativa, y devuelve un resultado (del tipo del argumento) con el valor de <@mth="x"> que cumple <@mth="P(X ≤ x) = p">, donde el tipo de distribución de <@mth="X"> se especifica mediante la letra <@var="d">. Entre los argumentos <@var="d"> y <@var="p">, puedes necesitar algún argumento adicional escalar para especificar los parámetros de la distribución de que se trate. Esto se hace del modo que se indica a continuación: 

<indent>
• Normal estándar (c = z, n o N): sin argumentos extras 
</indent>

<indent>
• Gamma (g o G): forma, escala 
</indent>

<indent>
• t de Student (t): grados de libertad 
</indent>

<indent>
• Chi-cuadrado (c, x o X): grados de libertad 
</indent>

<indent>
• F de Snedecor (f o F): grados de libertad (num.), grados de libertad (den.) 
</indent>

<indent>
• Binomial (b o B): probabilidad, cantidad de ensayos 
</indent>

<indent>
• Poisson (p o P): media 
</indent>

<indent>
• Laplace (l o L): media, escala 
</indent>

<indent>
• Error Generalizado (E): forma 
</indent>

<indent>
• Chi-cuadrado no central (ncX): grados de libertad, parámetro de no centralidad 
</indent>

<indent>
• F no central (ncF): grados de libertad (num.), grados de libertad (den.), parámetro de no centralidad 
</indent>

<indent>
• t no central (nct): grados de libertad, parámetro de no centralidad 
</indent>

Ver también <@ref="cdf">, <@ref="critical">, <@ref="pvalue">. 

# invmills probdist
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con la razón inversa de Mills en <@var="x">, es decir, la razón entre la densidad Normal estándar y el complementario de la función de distribución Normal estándar, ambas evaluadas en <@var="x">. 

Esta función utiliza un algoritmo adecuado que proporciona una precisión mucho mejor que la que se alcanza haciendo los cálculos con <@ref="dnorm"> y <@ref="cnorm">; ahora bien, la diferencia entre los dos métodos es considerable solo para valores muy negativos de <@var="x">. 

Ver también <@ref="cdf">, <@ref="cnorm">, <@ref="dnorm">. 

# invpd linalg
Resultado: 	matriz cuadradax 
Argumento: 	<@var="A">  (matriz definida positiva)

Devuelve la matriz cuadrada resultante de invertir la matriz simétrica definida positiva <@var="A">. Para matrices muy grandes, esta función es ligeramente más rápida que <@ref="inv"> puesto que con ella no se comprueba si la matriz es simétrica. Por esta razón, la función debe utilizarse con prudencia. 

Nota: Si pretendes invertir una matriz de la forma <@mth="X'X">, donde <@mth="X"> es una matriz muy grande, es preferible que la calcules mediante el operador principal <@lit="X'X"> en lugar de usar la sintaxis más general <@lit="X'*X">. La primera expresión utiliza un algoritmo especializado que tiene una doble ventaja: resulta más eficiente desde el punto de vista del cómputo; y va a garantizar que la matriz resultante esté libre, por construcción, de los artefactos de precisión de máquina que pudieran convertirla en numéricamente no simétrica. 

# irf stats
Resultado: 	matriz 
Argumentos:	<@var="efecto">  (entero)
		<@var="motivo">  (entero)
		<@var="alpha">  (escalar entre 0 y 1, opcional)
		<@var="sys">  (bundle, opcional)

Sin el argumento final (opcional), esta función solo está disponible cuando el último modelo estimado fue un VAR o un VECM. Como alternativa, puedes guardar en un 'bundle' la información sobre un VAR o un VECM con el acceso <@ref="$system">, y posteriormente pasarle la función <@lit="irf">. 

Como resultado, devuelve una matriz que contiene la respuesta estimada de la variable <@var="efecto"> ante un impulso en la variable <@var="motivo"> de magnitud igual a su desviación típica. Estas dos variables se identifican teniendo en cuenta sus posiciones en la especificación del modelo: por ejemplo, cuando indicas los argumentos <@var="efecto"> y <@var="motivo"> con los valores 1 y 3, respectivamente, la matriz que se devuelve proporciona la respuesta de la primera variable del sistema, ante un impulso de la tercera variable. 

Si indicas el tercer argumento <@var="alpha"> (opcional), la matriz que te devuelve la función tiene tres columnas: la primera con la estimación por punto de las respuestas, y las otras con los límites inferior y superior del intervalo con confianza (1 – α) para las mismas, obtenidas mediante autosuficiencia (“bootstrapping”). Si <@var="alpha"> = 0.1, la confianza será del 90 por ciento. Cuando <@var="alpha"> se omite o se iguala a cero, tan solo se proporciona la estimación por punto. 

El número de períodos (filas) sobre los que se traza la respuesta se determina automáticamente dependiendo de la frecuencia de los datos; pero eso puede ajustarse por medio de la instrucción <@xrf="set">, como por ejemplo con <@lit="set horizon 10">. 

Ver también <@ref="fevd">. 

# irr math
Resultado: 	escalar 
Argumento: 	<@var="x">  (serie o vector)

Devuelve un escalar con la Tasa Interna de Rendimiento (TIR) para <@var="x">, considerada como una secuencia de pagos (negativos) e ingresos (positivos). Ver también <@ref="npv">. 

# isconst data-utils
Resultado: 	entero 
Argumentos:	<@var="y">  (serie o vector)
		<@var="codigo-panel">  (entero, opcional)

Sin el segundo argumento (opcional), devuelve el número entero igual a 1 cuando <@var="y"> tenga un valor constante a lo largo de la muestra vigente seleccionada (o a lo largo de toda su extensión si <@var="y"> es un vector); en otro caso, devuelve el entero 0. 

El segundo argumento solo se acepta cuando <@var="y"> es una serie, y el conjunto vigente de datos es un panel. En este caso, un valor de <@var="codigo-panel"> igual a 0 solicita que la función verifique si la serie no varía con el paso del tiempo; y un valor igual a 1 hace que la función verifique si la serie no varía transversalmente (es decir, si el valor de <@var="y"> en cada período de tiempo, es el mismo para todos los grupos). 

Si <@var="y"> es una serie, las observaciones con valores ausentes se ignoran durante la verificación de la invariabilidad de la serie. 

# isdiscrete data-utils
Resultado: 	entero 
Argumento: 	<@var="nombre">  (cadena)

Si <@var="nombre"> es una cadena que identifica una serie ya definida, y si está marcada como de tipo discreto, la función devuelve un entero igual a1; en caso contrario, devuelve 0. Si <@var="nombre"> no identifica una serie, la función devuelve <@lit="NA">. 

# isdummy data-utils
Resultado: 	entero 
Argumento: 	<@var="x">  (serie o vector)

Si todos los valores contenidos en <@var="x"> son iguales a 0 o a 1 (o ausentes), devuelve un entero con el recuento de unos; si no, devuelve 0. 

# isnan data-utils
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar o matriz)

Dado un argumento escalar, devuelve 1 si <@var="x"> no es un número, “Not a Number” (NaN); en caso contrario, devuelve 0. Dada una matriz como argumento, devuelve otra matriz de la misma dimensión que contiene valores iguales a 1 en las posiciones en las que los elementos que les corresponden de la matriz de entrada son NaN, y 0 en las demás posiciones. 

# isoconv calendar
Resultado: 	escalar 
Argumentos:	<@var="fecha">  (serie)
		<@var="&año">  (referencia a serie)
		<@var="&mes">  (referencia a serie)
		<@var="&día">  (referencia a serie, opcional)

Dada la serie <@var="fecha"> que contiene fechas en el formato ISO 8601 “básico” (<@lit="YYYYMMDD">), esta función convierte las componentes de año, mes y (opcionalmente) día en nuevas series designadas por el segundo y siguientes argumentos. Un ejemplo de su aplicación, asumiendo que la serie <@lit="fechas"> contiene valores adecuados de 8 dígitos, sería: 

<code>          
     series y, m, d
     isoconv(fechas, &y, &m, &d)
</code>

Esta función devuelve el escalar 0 en caso de completarse con éxito, y un escalar no nulo en caso de fallo. 

# isocountry strings
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="origen">  (cadena o array de cadenas)
		<@var="resultado">  (entero, opcional)

Esta función está relacionada con las cuatro notaciones para países que están incluídas en el estándar ISO 3166; concretamente 

<indent>
1. Nombre de país 
</indent>

<indent>
2. Código alfa-2 (dos letras mayúsculas) 
</indent>

<indent>
3. Código alfa-3 (tres letras mayúsculas) 
</indent>

<indent>
4. Código numérico (3 dígitos) 
</indent>

Cuando indicas un país con alguna de esas formas, el resultado es su representación en la forma (de 1 a 4) que elijas mediante el argumento opcional <@var="resultado">. Si omites ese argumento, la conversión por defecto se hace del siguiente modo: cuando el argumento <@var="origen"> es un nome de un país, el resultado es el código de 2 letras del país; en caso contrario, el resultado es el nombre del país. Debajo se ilustran varias solicitudes válidas con formato interactivo. 

<code>          
     ? eval isocountry("Bolivia")
     BO
     ? eval isocountry("Bolivia", 3)
     BOL
     ? eval isocountry("GB")
     United Kingdom of Great Britain and Northern Ireland
     ? eval isocountry("GB", 3)
     GBR
     ? strings S = defarray("ES", "DE", "SD")
     ? strings C = isocountry(S)
     ? print C
     Array de strings, longitud 3
     [1] "Spain"
     [2] "Germany"
     [3] "Sudan"
     ? matrix m = {4, 840}
     ? C = isocountry(m)
     ? print C
     Array de strings, longitud 2
     [1] "Afghanistan"
     [2] "United States of America"
</code>

Cuando <@var="origen"> tiene la forma 4 (código numérico), esto puede indicarse mediante una cadena de texto o un 'array' de cadenas (por ejemplo, “032” para Argentina) o con formato numérico. En este último caso, <@var="origen"> puede indicarse como una serie o como un vector, pero se va a mostrar un fallo si alguno de los números está fuera del rango de 0 a 999. 

En todos los casos (incluso cuando elijas el formato 4 de resultados) se devuelve una cadena de texto o un 'array' de cadenas; si necesitas los valores numéricos, puedes obtenerlos usando la función <@ref="atof">. Cuando <@var="origen"> no coincide con ninguna entrada de la tabla ISO 3166, el resultado es una cadena vacía, y en ese caso se muestra una advertencia. 

# isodate calendar
Resultado: 	mira más abajo 
Argumentos:	<@var="ed">  (escalar o serie)
		<@var="como-cadena">  (booleano, opcional)

El argumento <@var="ed"> se interpreta como un día de época (que tomará el valor 1 para el primer día de enero del año 1 después de Cristo, en el proléptico calendario Gregoriano). El valor que se devuelve por defecto es un número de 8 dígitos del mismo tipo que <@var="ed">, o una serie compuesta por números de esa clase. Se sigue el patrón <@lit="YYYYMMDD"> (formato ISO 8601 “básico”) para proporcionar la fecha en el calendario Gregoriano que se corresponde al día en la época actual. 

Cuando <@var="ed"> es únicamente un escalar y el segundo argumento <@var="como-cadena"> (opcional) es no nulo, la función no devuelve un valor numérico sino una cadena de texto que sigue el patrón <@lit="YYYY-MM-DD"> (formato ISO 8601 “extendido”). 

En relación a la función inversa consulta <@ref="epochday">. Consulta también <@ref="juldate">. 

# iwishart stats
Resultado: 	matriz 
Argumentos:	<@var="S">  (matriz simétrica)
		<@var="v">  (entero)

Dada <@var="S"> (una matriz de orden <@itl="p">×<@itl="p"> definida positiva), esta función devuelve una matriz generada a partir de una realización de la distribución Inversa de Wishart con <@var="v"> grados de libertad. El resultado que se devuelve también es una matriz <@itl="p">×<@itl="p">. Se utiliza el algoritmo de <@bib="Odell y Feiveson (1966);odell-feiveson66">. 

# jsonget data-utils
Resultado: 	cadena 
Argumentos:	<@var="buf">  (cadena)
		<@var="ruta">  (cadena)
		<@var="nleer">  (referencia a escalar, opcional)

Como argumento <@var="buf"> deberás utilizar un buffer JSON, tal como puede recuperarse de un sitio web adecuado mediante la función <@ref="curl">; y como argumento <@var="ruta"> deberás usar una especificación de tipo JsonPath. 

Esta función devuelve una cadena de texto que representa los datos que se encuentran en el buffer en la ruta especificada. Se admiten los tipos de datos “double” (punto flotante), “int” (entero) y cadena de texto. En caso de enteros o de puntos flotantes, se devuelve su representación como cadenas de texto (usando para los segundos, “C” local). Si el objeto al que se refiere la <@var="ruta"> es un 'array', sus elementos se imprimen en la cadena de texto devuelta, uno por cada fila. 

Por defecto, se muestra un fallo si <@var="ruta"> no coincide en el buffer JSON; pero este comportamiento se modifica si indicas el tercer argumento (opcional) pues, en este caso, el argumento recupera un recuento de las coincidencias, devolviéndose una cadena vacía si no hay ninguna. Llamada de ejemplo: 

<code>          
     ngot = 0
     ret = jsonget(jbuf, "$.some.thing", &ngot)
</code>

Ahora bien, todavía se va a mostrar un fallo en caso de hacer una solicitud mal configurada. 

Puedes encontrar una exposición fidedigna de la sintaxis JsonPath en <@url="http://goessner.net/articles/JsonPath/">. De cualquier modo, observa que el soporte de <@lit="jsonget"> lo proporciona <@lit="json-glib">, que no necesariamente soporta todos los elementos de JsonPath. Y además, la funcionalidad concreta que desarrolla <@lit="json-glib"> puede ser muy diferente, dependiendo de la versión que tengas en tu sistema. Puedes consultar <@url="http://developer.gnome.org/json-glib/"> si necesitas tener más detalles. 

Dicho esto, los siguientes operadores debieran de estar disponibles para <@lit="jsonget">: 

<indent>
• nodo raíz, por medio del carácter <@lit="$"> 
</indent>

<indent>
• operador descendente recursivo: <@lit=".."> 
</indent>

<indent>
• operador comodín: <@lit="*"> 
</indent>

<indent>
• operador subíndice: <@lit="[]"> 
</indent>

<indent>
• operador de notación de conjunto, por ejemplo <@lit="[i,j]"> 
</indent>

<indent>
• operador de truncado: <@lit="[principio:fin:paso]"> 
</indent>

# jsongetb data-utils
Resultado: 	bundle 
Argumentos:	<@var="buf">  (cadena)
		<@var="ruta">  (cadena, opcional)

Como argumento <@var="buf"> deberás utilizar un buffer JSON, tal como puede recuperarse de un sitio web adecuado mediante la función <@ref="curl">. La especificación y el efecto del argumento opcional <@var="ruta"> se describe más abajo. 

Lo que se devuelve es un 'bundle' cuya estructura básicamente refleja la de la entrada: los objetos JSON se convierten en 'bundles' de Gretl, y los 'arrays' JSON se convierten en 'arrays' de Gretl, cada uno de ellos conteniendo cadenas de texto o 'bundles'. Los nodos de “valor” JSON se convierten en componentes de 'bundles' o elementos de 'arrays'; en el último caso, los valores numéricos se convierten en cadenas de texto utilizando <@lit="sprintf">. Ten en cuenta que, dado que no puedes anidar los 'arrays' de Gretl, el argumento que acepta esta función es un poco más restrictivo que la especificación JSON, pues esta admite anidar los 'arrays'. 

Puedes usar el argumento <@var="ruta"> para limitar los elementos JSON incluidos en el 'bundle' que se devuelve. Ten en cuenta que esto no es un “JsonPath” tal como se describe en la ayuda para <@ref="jsonget">; esto es una sencilla composición sujeta a la siguiente especificación: 

<indent>
• <@var="ruta"> es una formación de elementos separados por una barra, donde esta barra (“/”) indica el desplazamiento a un nivel “más bajo” en el árbol JSON representado por <@var="buf">. Se permite una barra inicial pero no es necesaria, pues implícitamente la ruta siempre comienza en la raíz. No debes incluir caracteres extraños para espacios en blanco. 
</indent>

<indent>
• Cada elemento que se separa con una barra debe tener una de las siguientes formas: (a) un nombre únicamente, en cuyo caso solo se va a incluir un elemento JSON cuyo nombre coincida en el nivel estructural indicado; o (b) “*” (asterisco), en cuyo caso se van a incluir todos aquellos elementos del nivel indicado; o (c) un 'array' de nombres separados con comas y delimitados por llaves (“{” y “}”), en cuyo caso solo se van a incluir los elementos JSON cuyos nombres coincidan con uno de los nombres indicados. 
</indent>

Consulta también la función orientada a cadenas <@ref="jsonget">; pues, dependiendo de tu intención, una de estas funciones puede serte de más ayuda que la otra. 

# juldate calendar
Resultado: 	mira más abajo 
Argumentos:	<@var="ed">  (escalar o serie)
		<@var="como-cadena">  (booleano, opcional)

El argumento <@var="ed"> se interpreta como un día de época (que tomará el valor 1 para el primer día de enero del año 1 después de Cristo, en el proléptico calendario Gregoriano). El valor que se devuelve por defecto es un número de 8 dígitos del mismo tipo que <@var="ed">, o una serie compuesta por números de esa clase. Se sigue el patrón <@lit="YYYYMMDD"> (formato ISO 8601 “básico”) para proporcionar la fecha en el calendario Juliano que se corresponde con el día en la época actual. 

Cuando <@var="ed"> es únicamente un escalar, y el segundo argumento <@var="como-cadena"> (opcional) es no nulo, la función no devuelve un valor numérico sino una cadena de texto que sigue el patrón <@lit="YYYY-MM-DD"> (formato ISO 8601 “extendido”). 

Consulta también <@ref="isodate">. 

# kdensity stats
Resultado: 	matriz 
Argumentos:	<@var="x">  (serie o vector)
		<@var="escala">  (escalar, opcional)
		<@var="control">  (booleano, opcional)

Calcula una estimación de la densidad kernel de la serie o vector <@var="x">. La matriz que se devuelve tiene dos columnas: la primera incluye un conjunto de abscisas equidistantes, y la segunda la densidad estimada correspondiente a cada una de ellas. 

El parámetro <@var="escala"> (opcional) puedes usarlo para ajustar el grado de suavizado en relación al valor por defecto que es 1.0 (valores mayores producen un resultado más suave). El parámetro <@var="control"> (opcional) actúa como un booleano: 0 (valor por defecto) significa que se utiliza el kernel gaussiano; un valor no nulo cambia al kernel de Epanechnikov. 

Puedes obtener un gráfico de los resultados utilizando la instrucción <@xrf="gnuplot">, como en 

<code>          
     matrix d = kdensity(x)
     gnuplot 2 1 --matrix=d --with-lines --fit=none
</code>

# kdsmooth sspace
Resultado: 	escalar 
Argumentos:	<@var="&Mod">  (referenia a bundle)
		<@var="MSE">  (booleano, opcional)

Realiza el suavizado de las perturbaciones de un 'bundle' de Kalman, configurado previamente mediante la instrucción <@ref="ksetup">; y devuelve el escalar 0 cuando se completa con éxito, o el escalar 1 cuando se encuentran problemas numéricos. 

Cuando se completa con éxito la operación, las perturbaciones suavizadas van a estar disponibles como <@lit="Mod.smdist">. 

El argumento <@var="MSE"> (opcional) determina el contenido de la clave <@lit="Mod.smdisterr">. Cuando es 0 o se omite, esta matriz va a estar compuesta por las desviaciones típicas incondicionales de las perturbaciones suavizadas, que habitualmente se utilizan para calcular los denominados <@itl="errores auxiliares">. Pero, en caso contrario, <@lit="Mod.smdisterr"> va a contener las raíces de las desviaciones cuadradas medias entre los errores auxiliares y sus valores verdaderos. 

Para obtener más detalles, consulta <@pdf="El manual de gretl#chap:kalman"> (Capítulo 33). 

Ver también <@ref="ksetup">, <@ref="kfilter">, <@ref="ksmooth">, <@ref="ksimul">. 

# kfilter sspace
Resultado: 	escalar 
Argumento: 	<@var="&Mod">  (referenia a bundle)

Realiza el filtrado hacia adelante de un 'bundle' de Kalman configurado previamente mediante la instrucción <@ref="ksetup">, y devuelve el escalar 0 cuando se completa con éxito, o el escalar 1 cuando se encuentran problemas numéricos. 

Cuando se completa con éxito, los errores de predicción adelantados un paso van a estar disponibles como <@lit="Mod.prederr">, y la secuencia de sus matrices de covarianzas como <@lit="Mod.pevar">. Por otro lado, <@lit="Mod.llt"> permitirá que tengas acceso a un <@mth="T">-vector que va a contener el logaritmo de la verosimilitud de cada observación. 

Para obtener más detalles, consulta <@pdf="El manual de gretl#chap:kalman"> (Capítulo 33). 

Ver también <@ref="kdsmooth">, <@ref="ksetup">, <@ref="ksmooth">, <@ref="ksimul">. 

# kmeier stats
Resultado: 	matriz 
Argumentos:	<@var="d">  (serie o vector)
		<@var="cens">  (serie o vector, opcional)

Devuelve una matriz con el cálculo del estimador no paramétrico de Kaplan–Meier de la función de supervivencia (<@bib="Kaplan y Meier, 1958;kaplan-meier">), dada una muestra <@var="d"> de datos de duración, posiblemente acompañada de un registro de estado de censura, <@var="cens">. La matriz que se devuelve tiene tres columnas que contienen, respectivamente: los valores únicos ordenados en <@var="d">, la estimación de la función de supervivencia que se corresponde con los valores de duración de la columna 1, y la desviación típica (para muestras grandes) del estimador, calculados mediante el método de <@bib="Greenwood (1926);greenwood26">. 

Cuando indicas la serie <@var="cens">, se utiliza el valor 0 para señalar que una observación no está censurada, mientras que el valor 1 indica que una observación está censurada del lado derecho (es decir, el período de observación del individuo en cuestión concluyó antes de la duración, o el período se registró como finalizado). Cuando no indicas <@var="cens">, se asume que todas las observaciones son no censuradas. (Aviso: la semántica de <@var="cens"> puede extenderse en algún punto para cubrir otros tipos de censura.) 

Ver también <@ref="naalen">. 

# kpsscrit stats
Resultado: 	matriz 
Argumentos:	<@var="T">  (escalar)
		<@var="tendenc">  (booleano)

Devuelve un vector fila que contiene los valores críticos a los niveles de 10, 5 y 1 por ciento del contraste KPSS para la estacionariedad de una serie temporal. El argumento <@var="T"> debe indicar el número de observaciones, y el argumento <@var="tendenc"> debe ser igual a 1 si el contraste incluye una constante (o 0 en caso contrario). 

Los valores críticos que se ofrecen están basados en superficies de respuesta estimadas del modo que está establecido por <@bib="Sephton (Economics Letters,1995);sephton95">. Consulta también la instrucción <@xrf="kps">. 

# ksetup sspace
Resultado: 	bundle 
Argumentos:	<@var="Y">  (serie, matriz o lista)
		<@var="H">  (escalar o matriz)
		<@var="F">  (escalar o matriz)
		<@var="Q">  (escalar o matriz)
		<@var="C">  (matriz, opcional)

Configura un 'bundle' de Kalman, es decir, un objeto que contiene toda la información necesaria para definir un modelo de espacio de los estados lineal, de la forma 

  <@fig="kalman1">

y con la ecuación de transición de estado 

  <@fig="kalman2">

en la que Var<@mth="(u) = Q">. 

Los objetos que creas mediante esta función puedes utilizalos más adelante, con la intervención de las siguientes funciones específicas: <@ref="kfilter"> para hacer filtrado, <@ref="ksmooth"> y <@ref="kdsmooth"> para suavizado, y <@ref="ksimul"> para hacer simulaciones. 

En realidad, el tipo de modelos que Gretl puede manejar es mucho más amplio que el implicado en la anterior representación: es posible disponer de modelos variantes en el tiempo, de modelos con precedentes difusos y con variable exógena en la ecuación de medida, y de modelos con innovaciones con correlaciones cruzadas. Para obtener más detalles, consulta <@pdf="El manual de gretl#chap:kalman"> (Capítulo 33). 

Ver también <@ref="kdsmooth">, <@ref="kfilter">, <@ref="ksmooth">, <@ref="ksimul">. 

# ksimul sspace
Resultado: 	escalar 
Argumento: 	<@var="&Mod">  (referenia a bundle)

Devuelve un escalar. Utiliza un 'bundle' de tipo Kalman previamente definido con la función <@ref="ksetup"> para simular datos. 

Para obtener más detalles, consulta <@pdf="El manual de gretl#chap:kalman"> (Capítulo 33). 

Ver también <@ref="ksetup">, <@ref="kfilter">, <@ref="ksmooth">. 

# ksmooth sspace
Resultado: 	matriz 
Argumento: 	<@var="&Mod">  (referenia a bundle)

Realiza un suavizado de punto fijo (hacia atrás) de un 'bundle' de Kalman previamente configurado mediante <@ref="ksetup">; y devuelve un 0 cuando se ejecuta con éxito, o un 1 cuando se encuentran problemas de tipo numérico. 

Cuando se completa con éxito, vas a tener a tu disposición el estado ya suavizado como <@lit="Mod.state">, y la secuencia de sus matrices de varianzas-covarianzas como <@lit="Mod.stvar">. Para obtener más detalles, consulta <@pdf="El manual de gretl#chap:kalman"> (Capítulo 33). 

Ver también <@ref="ksetup">, <@ref="kdsmooth">, <@ref="kfilter">, <@ref="ksimul">. 

# kurtosis stats
Resultado: 	escalar 
Argumento: 	<@var="x">  (serie)

Devuelve el exceso de curtosis de la serie <@var="x">, descartando cualquier observación ausente. 

# lags transforms
Resultado: 	lista o matriz 
Argumentos:	<@var="p">  (escalar o vector)
		<@var="y">  (serie, lista o matriz)
		<@var="xretardo">  (booleano, opcional)

Cuando el primer argumento es un escalar, genera los retardos del 1 al <@var="p"> de la serie <@var="y">. Cuando <@var="y"> es una lista, genera esos retardos para todas las series que contiene esa lista. Cuando <@var="y"> es una matriz, genera esos retardos para todas las columnas de la matriz. En caso de que <@var="p"> = 0, e <@var="y"> sea una serie o una lista, el retardo máximo toma por defecto la periodicidad de los datos; aparte de eso <@var="p"> deberá ser positivo. 

Cuando el primer argumento es un vector, los retardos generados son los que están especificados en ese vector. En este caso, un uso habitual podría ser el de poner, por ejemplo, <@var="p"> como <@lit="seq(3,7)">, omitiendo entonces el primer y segundo retardos. Así y todo, también es correcto indicar un vector con saltos como en <@lit="{3,5,7}">, aunque los retardos deberán indicarse siempre en orden ascendente. 

En caso de que el resultado sea una lista, se nombran automáticamente las variables generadas con el patrón <@var="nombrevar"><@lit="_"><@var="i">, en el que <@var="nombrevar"> estará indicando el nombre de la serie original, e <@var="i"> expresará el retardo concreto de cada caso. La parte original del nombre se va a truncar cuando así resulte necesario, e incluso podrá ajustarse oportunamente para garantizar que resulte único dentro del conjunto de nombres que así se vayan a construir. 

Cuando el segundo argumento <@var="y"> es una lista o una matriz con más de una columna, y el nivel de retardo es mayor que 1, la disposición por defecto de los elementos en la lista que se devuelve es por orden de variable: primero se devuelven todos los retardos de la primera serie o columna contenida en ese argumento, seguidos de todos los de la segunda, y así sucesivamente. El tercer argumento (opcional) puedes usarlo para cambiar esto: si <@var="xretardo"> es no nulo, entonces los elementos se ordenan por retardo: el primer retardo de todas las series o columnas, después el segundo retardo de todas las series o columnas, etc. 

Consulta también <@ref="mlag"> para la utilización con matrices. 

# lastobs data-utils
Resultado: 	entero 
Argumento: 	<@var="y">  (serie)

Devuelve el número entero positivo que indexa la última observación no ausente de la serie <@var="y">. Ten en cuenta que, si está activa alguna forma de submuestreo, el valor que se devuelve puede ser mayor que el valor devuelto por el acceso <@ref="$t2">. Ver también <@ref="firstobs">. 

# ldet linalg
Resultado: 	escalar 
Argumento: 	<@var="A">  (matriz cuadradax)

Devuelve un escalar con el logaritmo natural del determinante de <@mth="A">, calculado mediante la descomposición LU. Ver también <@ref="det">, <@ref="rcond">, <@ref="cnumber">. 

# ldiff transforms
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="y">  (serie o lista)

Devuelve un resultado (del tipo del argumento) con las primeras diferencias del logaritmo de este; los valores iniciales se consideran <@lit="NA">. 

Cuando se devuelve una lista, las variables individuales se nombran de forma automática siguiendo el patrón <@lit="ld_"><@var="varname">, en el que <@var="varname"> indica el nombre de la serie original. La parte original del nombre se va a truncar cuando así resulte necesario, e incluso podrá ajustarse para garantizar que sea único dentro del conjunto de nombres que así se vayan a construir. 

Ver también <@ref="diff">, <@ref="sdiff">. 

# lincomb transforms
Resultado: 	serie 
Argumentos:	<@var="L">  (lista)
		<@var="b">  (vector)

Devuelve una nueva serie calculada como una combinación lineal de las series de la lista <@var="L">. Los coeficientes vienen dados por el vector <@var="b">, cuyo tamaño debe ser igual al número de series que hay en <@var="L">. 

Ver también <@ref="wmean">. 

# linearize filters
Resultado: 	serie 
Argumento: 	<@var="x">  (serie)

Para ejecutarlo es preciso tener instalado el TRAMO. Devuelve una serie que es una versión “linealizada” del argumento; es decir, una serie en la que cualquier valor ausente se substituye por valores interpolados, y en la que las observaciones anómalas se ajustan. Para eso se utiliza un mecanismo completamente automático del TRAMO. Para obtener más detalles, consulta la documentación del TRAMO. 

Ten en cuenta que, si la serie del argumento no posee valores ausentes ni observaciones que el TRAMO considere anómalas, esta función devuelve una copia de la serie original. 

# ljungbox stats
Resultado: 	escalar 
Argumentos:	<@var="y">  (serie)
		<@var="p">  (entero)

Devuelve un escalar con el cálculo del estadístico Q de Ljung–Box para la serie <@var="y">, utilizando el nivel de retardo <@var="p">, a lo largo de la muestra seleccionada en ese momento. El nivel de retardo debe ser mayor o igual a 1, y menor que el número de observaciones disponibles. 

Ese valor del estadístico puedes cotejarlo con la distribución Chi-cuadrado con <@var="p"> grados de libertad, para verificar la hipótesis nula de que la serie <@var="y"> no tiene autocorrelación. Ver también <@ref="pvalue">. 

# lngamma math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el logaritmo de la función Gamma de <@var="x">. 

# loess stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="x">  (serie)
		<@var="d">  (entero, opcional)
		<@var="q">  (escalar, opcional)
		<@var="robusta">  (booleano, opcional)

Realiza una regresión polinómica ponderada localmente, y devuelve una serie que contiene los valores previstos de <@var="y"> para cada valor no ausente de <@var="x">. El método que se utiliza es del tipo que está descrito por <@bib="William Cleveland (1979);cleveland79">. 

Los argumentos <@var="d"> y <@var="q"> (opcionales) permiten especificar: el grado del polinomio de <@var="x"> y que proporción de los puntos de datos se van a utilizar en la estimación local, respectivamente. Los valores que se les suponen por defecto son <@var="d"> = 1 y <@var="q"> = 0.5; y otros valores admisibles para <@var="d"> son 0 y 2. Cuando establezcas <@var="d"> = 0, vas a reducir la regresión local a una forma de media móvil. El valor de <@var="q"> debe de ser mayor que 0, y no puede ser mayor que 1; los valores más grandes producen un resultado final más suavizado. 

Cuando se especifica un valor no nulo para el argumento <@var="robusta">, las regresiones locales se reiteran dos veces, con modificaciones en las ponderaciones en base a los errores de la iteración previa, y de modo que tengan menos influencia las observaciones anómalas. 

Revisa también la función <@ref="nadarwat"> y, por añadido, consulta <@pdf="El manual de gretl#chap:nonparam"> (Capítulo 37) para obtener más detalles sobre métodos no paramétricos. 

# log math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie, matriz o lista)

Devuelve un resultado (del tipo del argumento) con el logaritmo natural de <@var="x">, generando <@lit="NA"> si este no es positivo. Aviso: <@lit="ln"> es un seudónimo admisible para <@lit="log">. 

Cuando se devuelve una lista, las variables individuales se nombran de forma automática siguiendo el patrón <@lit="l_"><@var="varname">, en el que <@var="varname"> indica el nombre de la serie original. La parte original del nombre va a truncarse cuando así resulte necesario, e incluso podrá ajustarse para garantizar que sea único dentro del conjunto de nombres que así se vayan a construir. 

# log10 math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el logaritmo en base 10 de <@var="x">, generando <@lit="NA"> si este no es positivo. 

# log2 math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el logaritmo en base 2 de <@var="x">, generando <@lit="NA"> si este no es positivo. 

# logistic math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del mismo tipo que el argumento <@var="x">) con la función FDA logística de este; es decir, 1/(1+<@mth="e"><@sup="–x">). Si <@var="x"> es una matriz, la función se aplica a cada elemento. 

# lower matbuild
Resultado: 	matriz cuadradax 
Argumento: 	<@var="A">  (matriz)

Devuelve una matriz triangular inferior de orden <@itl="n">×<@itl="n">: los elementos de la diagonal principal y de debajo de esta son iguales a los elementos correspondientes de <@var="A">, y los demás son iguales a cero. 

Ver también <@ref="upper">. 

# lrcovar filters
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz)
		<@var="sinmedia">  (booleano, opcional)

Devuelve una matriz con las varianzas y covarianzas de largo plazo de las columnas de la matriz <@var="A">. Primero, a los datos se les resta la media, excepto que se asigne un cero al segundo argumento (opcional). Puedes escoger el tipo de kernel y el parámetro de truncado del retardo (el tamaño de la ventana), antes de llamar a esta función mediante las opciones relacionadas con el HAC que ofrece la instrucción <@xrf="set">, tales como <@lit="hac_kernel">, <@lit="hac_lag">, o <@lit="hac_prewhiten">. Consulta también la sección sobre datos de series de tiempo y matrices de covarianzas HAC en <@pdf="El manual de gretl#chap:robust_vcv"> (Capítulo 19). 

Ver también <@ref="lrvar">. 

# lrvar filters
Resultado: 	escalar 
Argumentos:	<@var="y">  (serie o vector)
		<@var="k">  (entero, opcional)
		<@var="mu">  (escalar, opcional)

Devuelve un escalar con la varianza de largo plazo del argumento <@var="y">, calculada usando un núcleo (“kernel”) de Bartlett con tamaño de ventana igual a <@var="k">. Si omites el segundo argumento (o le asignas un valor negativo), el tamaño de la ventana se establece por defecto igual a la parte entera de la raíz cúbica del tamaño de la muestra. 

Para el cálculo de la varianza, la serie <@var="y"> se centra con respecto al parámetro opcional <@var="mu">; y cando este se omite o es <@lit="NA">, se utiliza la media muestral. 

Para una contrapartida multivariante, consulta <@ref="lrcovar">. 

# max stats
Resultado: 	escalar o serie 
Argumento: 	<@var="y">  (serie o lista)

Si el argumento <@var="y"> es una serie, la función devuelve un escalar con el valor máximo de esa serie (en las observaciones no ausentes). Si el argumento es una lista, devuelve una serie en la que cada uno de sus valores indica el máximo de entre las series listadas, para cada observación. 

Ver también <@ref="min">, <@ref="xmax">, <@ref="xmin">. 

# maxc stats
Resultado: 	vector fila 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector fila que contiene los valores máximos de cada columna de la matriz <@var="X">. 

Ver también <@ref="imaxc">, <@ref="maxr">, <@ref="minc">. 

# maxr stats
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna que contiene los valores máximos de cada fila de la matriz <@var="X">. 

Ver también <@ref="imaxc">, <@ref="maxc">, <@ref="minr">. 

# mcorr stats
Resultado: 	matriz 
Argumento: 	<@var="X">  (matriz)

Calcula una matriz de correlaciones (de Pearson), tratando cada columna de la matriz argumento <@var="X"> como si fuese una variable. Ver también <@ref="corr">, <@ref="cov">, <@ref="mcov">. 

# mcov stats
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="dfcorr">  (entero, opcional)

Calcula una matriz de varianzas-covarianzas, tratando cada columna de la matriz argumento <@var="X"> como si fuese una variable. El divisor es <@mth="n"> – 1, en el que <@mth="n"> es el número de filas de <@var="X">; excepto que el argumento <@var="dfcorr"> (opcional) sea 0, en cuyo caso se utiliza <@mth="n">. 

Ver también <@ref="corr">, <@ref="cov">, <@ref="mcorr">. 

# mcovg stats
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="u">  (vector, opcional)
		<@var="w">  (vector, opcional)
		<@var="p">  (entero)

Devuelve la matriz covariograma para otra matriz <@var="X"> de orden <@itl="T">×<@itl="k"> (que generalmente contiene regresores), un vector <@var="u"> de orden <@mth="T"> (opcional, que suele contener los errores), un vector <@var="w"> de orden <@mth="p">+1 (opcional, que contiene unas ponderaciones), y un número entero <@var="p"> que indica el nivel de retardo y debe ser mayor o igual a 0. 

La matriz que se devuelve es la suma para <@mth="j"> desde <@mth="-p"> hasta <@mth="p"> de <@mth="w(|j|) * X(t)X(t-j)' * u(t)u(t-j)">, donde <@mth="X(t)'"> es la <@mth="t">-ésima fila de <@var="X">. 

Si <@var="u"> viene indicado como <@lit="nulo">, los términos <@mth="u"> se omiten, y si <@var="w"> viene indicado como <@lit="nulo">, todas las ponderaciones se asume que son 1.0. 

Por ejemplo, el siguiente trozo de código 

<code>          
     set seed 123
     X    = mnormal(6,2)
     Retardo  = mlag(X,1)
     Adelanto = mlag(X,-1)
     print X Retardo Adelanto
     eval X'X
     eval mcovg(X, , , 0)
     eval X'(X + Retardo + Adelanto)
     eval mcovg(X, , , 1)
</code>

produce este resultado: 

<code>          
     ? print X Retardo Adelanto
     X (6 x 2)

       -0.76587      -1.0600
       -0.43188      0.30687
       -0.82656      0.40681
        0.39246      0.75479
        0.36875       2.5498
        0.28855     -0.55251

     Retardo (6 x 2)

         0.0000       0.0000
       -0.76587      -1.0600
       -0.43188      0.30687
       -0.82656      0.40681
        0.39246      0.75479
        0.36875       2.5498

     Adelanto (6 x 2)

       -0.43188      0.30687
       -0.82656      0.40681
        0.39246      0.75479
        0.36875       2.5498
        0.28855     -0.55251
         0.0000       0.0000

     ? eval X'X
         1.8295       1.4201
         1.4201       8.7596

     ? eval mcovg(X,,, 0)
         1.8295       1.4201
         1.4201       8.7596

     ? eval X'(X + Retardo + Adelanto)
         3.0585       2.5603
         2.5603       10.004

     ? eval mcovg(X,,, 1)
         3.0585       2.5603
         2.5603       10.004
</code>

# mean stats
Resultado: 	escalar o serie 
Argumento: 	<@var="x">  (serie o lista)

Si <@var="x"> es una serie, la función devuelve un escalar con su media muestral, ignorando cualquier observación ausente. 

Si <@var="x"> es una lista, la función devuelve una serie <@mth="y"> tal que <@mth="y"><@sub="t"> indica la media de los valores de las variables de esa lista en la observación <@mth="t">, o <@lit="NA"> en caso de que exista algún valor ausente en <@mth="t">. 

# meanc stats
Resultado: 	vector fila 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector fila con la media de cada columna de <@var="X">. Ver también <@ref="meanr">, <@ref="sumc">, <@ref="sdc">. 

# meanr stats
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna con la media de cada fila de <@var="X">. Ver también <@ref="meanc">, <@ref="sumr">. 

# median stats
Resultado: 	escalar o serie 
Argumento: 	<@var="x">  (serie o lista)

Si <@var="x"> es una serie, la función devuelve un escalar con su mediana muestral, ignorando cualquier observación ausente. 

Si <@var="x"> es una lista, la función devuelve una serie <@mth="y"> tal que <@mth="y"><@sub="t"> indica la mediana de los valores de las variables de esa lista en la observación <@mth="t">, o <@lit="NA"> en caso de que exista algún valor ausente en <@mth="t">. 

# mexp linalg
Resultado: 	matriz cuadradax 
Argumento: 	<@var="A">  (matriz cuadradax)

Calcula y devuelve la matriz exponencial de una matriz cuadrada <@var="A"> utilizando para ello el algoritmo 11.3.1 de <@bib="Golub y Van Loan (1996);golub96">. 

# mgradient midas
Resultado: 	matriz 
Argumentos:	<@var="p">  (entero)
		<@var="theta">  (vector)
		<@var="tipo">  (entero o cadena)

Derivadas analíticas para las ponderaciones de un MIDAS. Denotando como <@mth="k"> al número de elementos que componen el vector <@var="theta"> de hiperparámetros, esta función devuelve una matriz de orden <@itl="p">×<@itl="k">, que contiene el gradiente del vector de ponderaciones (tal como lo calcula la función <@ref="mweights">) con respecto a los elementos de <@var="theta">. El primer argumento representa el nivel de retardo deseado, y el último argumento especifica el tipo de disposición de parámetros. Consulta la función <@lit="mweights"> para tener una relación de los valores admisibles para <@var="tipo">. 

Ver también <@ref="mweights">, <@ref="mlincomb">. 

# min stats
Resultado: 	escalar o serie 
Argumento: 	<@var="y">  (serie o lista)

Cuando el argumento <@var="y"> es una serie, devuelve un escalar con el valor mínimo de las observaciones no ausentes de la serie. Cuando el argumento es una lista, devuelve una serie en la que cada elemento es el valor mínimo de entre las series listadas, en cada observación. 

Ver también <@ref="max">, <@ref="xmax">, <@ref="xmin">. 

# minc stats
Resultado: 	vector fila 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector fila con el valor mínimo de cada columna de <@var="X">. 

Ver también <@ref="iminc">, <@ref="maxc">, <@ref="minr">. 

# minr stats
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna con el valor mínimo de cada fila de <@var="X">. 

Ver también <@ref="iminr">, <@ref="maxr">, <@ref="minc">. 

# missing data-utils
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o lista)

Devuelve una variable binaria (del mismo tipo que el argumento) que toma el valor 1 cuando <@var="x"> es <@lit="NA">. Cuando <@var="x"> es una serie, se hace la comprobación para cada elemento. Cuando <@var="x"> es una lista de series, devuelve una serie que toma el valor 1 en las observaciones en las que al menos una de las series presenta un valor ausente, y el valor 0 en otro caso. 

Ver también <@ref="misszero">, <@ref="ok">, <@ref="zeromiss">. 

# misszero data-utils
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar o serie)

Devuelve un resultado del tipo del argumento, cambiando los <@lit="NA">s por ceros. Si <@var="x"> es una serie, se cambia cada elemento. Ver también <@ref="missing">, <@ref="ok">, <@ref="zeromiss">. 

# mlag stats
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="p">  (escalar o vector)
		<@var="m">  (escalar, opcional)

Mueve hacia arriba o abajo las filas de la matriz <@var="X">. Cuando <@var="p"> es un escalar positivo, la función devuelve una matriz semejante a <@var="X">, pero con los valores de cada columna desplazados <@var="p"> filas hacia abajo, y con las primeras <@var="p"> filas cubiertas con el valor <@var="m">. Cuando <@var="p"> es un número negativo, la matriz que se devuelve se parece a <@var="X">, pero con los valores de cada columna desplazados hacia arriba, y las últimas filas cubiertas con el valor <@var="m">. Si omites <@var="m">, se entiende que es igual a cero. 

Si <@var="p"> es un vector, la operación indicada en el párrafo anterior se realiza con cada uno de los elementos de <@var="p">, juntando horizontalmente las matrices resultantes. 

Consulta también <@ref="lags">. 

# mlincomb midas
Resultado: 	serie 
Argumentos:	<@var="hfvars">  (lista)
		<@var="theta">  (vector)
		<@var="tipo">  (entero o cadena)

Esta es una función MIDAS muy oportuna que combina las funciones <@ref="lincomb"> y <@ref="mweights">. Dada la lista <@var="hfvars">, elabora una serie que es una suma ponderada de los elementos de esa lista. Las ponderaciones se basan en el vector <@var="theta"> de hiperparámetros y en el tipo de disposición de parámetros: consulta la función <@lit="mweights"> para obtener más detalles. Ten en cuenta que <@ref="hflags"> generalmente es el mejor modo de crear una lista apropiada para que sea el primer argumento de esta función. 

Para ser más explícitos, la expresión 

<code>          
     series s = mlincomb(hfvars, theta, 2)
</code>

es equivalente a 

<code>          
     matrix w = mweights(nelem(hfvars), theta, 2)
     series s = lincomb(hfvars, w)
</code>

pero utilizar la función <@lit="mlincomb">, permite economizar algo al teclear y también en algunos ciclos de uso de CPU. 

# mnormal matbuild
Resultado: 	matriz 
Argumentos:	<@var="r">  (entero)
		<@var="c">  (entero)

Devuelve una matriz formada con valores generados de forma pseudoaleatoria mediante variables con distribución Normal estándar, y que va a tener <@var="r"> filas y <@var="c"> columnas. Ver también <@ref="normal">, <@ref="muniform">. 

# mols stats
Resultado: 	matriz 
Argumentos:	<@var="Y">  (matriz)
		<@var="X">  (matriz)
		<@var="&U">  (referencia a matriz, o <@lit="null">)
		<@var="&V">  (referencia a matriz, o <@lit="null">)

Devuelve una matriz <@itl="k">×<@itl="n"> de estimaciones de parámetros obtenidos mediante la regresión de Mínimos Cuadrados Ordinarios de la matriz <@var="Y"> de orden <@itl="T">×<@itl="n"> sobre la matriz <@var="X"> de orden <@itl="T">×<@itl="k">. 

Cuando se indica el tercer argumento, y no es <@lit="null">, la función va a generar una nueva matriz <@var="U"> de orden <@itl="T">×<@itl="n">, que contiene los errores. Cuando se indica el último argumento, y no es <@lit="null">, la matriz <@var="V"> que se genera va a ser de orden <@itl="k">×<@itl="k">, y contiene (a) la matriz de covarianzas de los estimadores de los parámetros, si <@var="Y"> tiene solo una columna, o (b) la matriz <@mth="X'X"><@sup="-1"> si <@var="Y"> tiene varias columnas. 

Por defecto, las estimaciones se obtienen por medio de la descomposición de Cholesky, con un último recurso a la descomposición QR si las columnas de <@var="X"> tienen alto grado de multicolinealidad. Puedes forzar el uso de la descomposición SVD mediante la instrucción <@lit="set svd on">. 

Ver también <@ref="mpols">, <@ref="mrls">. 

# monthlen calendar
Resultado: 	entero 
Argumentos:	<@var="mes">  (entero)
		<@var="año">  (entero)
		<@var="duracsemana">  (entero)

Devuelve un número entero que expresa cuantos días (relevantes) tiene un mes de un año (en el proléptico calendario Gregoriano), especificados en los dos primeros argumentos y considerando la duración de semana indicada por <@var="duracsemana">. Este debe ser igual a 5, 6 o 7 (indicando el valor 6 que no se cuentan los domingos, y 5 que no se cuentan ni los sábados ni los domingos). 

# movavg filters
Resultado: 	serie 
Argumentos:	<@var="x">  (serie)
		<@var="p">  (escalar)
		<@var="control">  (entero, opcional)
		<@var="y0">  (escalar, opcional)

Devuelve una serie que es una media móvil de <@var="x"> y, dependiendo del valor del parámetro <@var="p">, resultará una media móvil simple o ponderada exponencialmente. 

Cuando <@var="p"> > 1, la función calcula una media móvil simple de <@var="p"> elementos; es decir, calcula la media aritmética de <@mth="x"> desde el período <@mth="t"> hasta el período <@mth="t-p+1">. Cuando indicas un valor no nulo para el argumento <@var="control"> (opcional), la media móvil “se centra”; en caso contrario, “se retarda”. El otro argumento <@var="y0"> no se va a tener en cuenta. 

Cuando <@var="p"> es un fracción decimal entre 0 y 1, la función calcula una media móvil exponencial: 

<@mth="y(t) = p*x(t) + (1-p)*y(t-1)"> 

Por defecto, la serie <@mth="y"> que se devuelve, se inicia utilizando el primer valor válido de <@var="x">. Pero puedes utilizar el parámetro <@var="control"> para especificar un número de observaciones iniciales, de forma que su media se tomará como <@mth="y(0)">; un valor de cero para <@var="control"> indica que deben tomarse todas las observaciones para calcular ese valor. Otra posibilidad consiste en que puedes especificar el valor inicial utilizando el argumento opcional <@var="y0">; en ese caso, el argumento <@var="control"> no va a tenerse en cuenta. 

# mpols stats
Resultado: 	matriz 
Argumentos:	<@var="Y">  (matriz)
		<@var="X">  (matriz)
		<@var="&U">  (referencia a matriz, o <@lit="null">)

Funciona igual que <@ref="mols">, devolviendo una matriz, salvo que los cálculos se hacen con alta precisión utilizando la biblioteca GMP. 

Por defecto, GMP utiliza 256 bits para cada número de punto flotante, pero puedes ajustar esto utilizando la variable de contexto <@lit="GRETL_MP_BITS">; por ejemplo, <@lit="GRETL_MP_BITS=1024">. 

# mrandgen probdist
Resultado: 	matriz 
Argumentos:	<@var="d">  (cadena)
		<@var="p1">  (escalar o matriz)
		<@var="p2">  (escalar o matriz, condicional)
		<@var="p3">  (escalar, condicional)
		<@var="filas">  (entero)
		<@var="columnas">  (entero)
Ejemplos: 	<@lit="matrix mx = mrandgen(u, 0, 100, 50, 1)">
		<@lit="matrix mt14 = mrandgen(t, 14, 20, 20)">

Funciona de la misma forma que la función <@ref="randgen"> excepto por el hecho de que devuelve una matriz en lugar de una serie. Los argumentos iniciales (cuyo número depende de la distribución escogida) para esta función ya se describen para <@lit="randgen">, pero deben estar seguidos por dos números enteros para especificar el número de filas y de columnas que va a tener la matriz aleatoria deseada. Si indicas <@var="p1"> o <@var="p2"> en forma matricial, deben tener un número de elementos que sea igual al producto de <@var="filas"> por <@var="columnas">. 

El primero de los ejemplos precedentes crea un vector columna con 50 elementos, a partir de una distribución Uniforme. El segundo ejemplo crea una matriz aleatoria de orden 20×20, con valores generados de la distribución <@mth="t"> con 14 grados de libertad. 

Ver también <@ref="mnormal">, <@ref="muniform">. 

# mread matbuild
Resultado: 	matriz 
Argumentos:	<@var="nombrearchivo">  (cadena)
		<@var="importar">  (booleano, opcional)

Lee una matriz guardada en el archivo llamado <@var="nombrearchivo">. Si el archivo posee la extensión “<@lit=".gz">” se asume que se aplicó la compresión gzip al guardar los datos. Si tiene la extensión “<@lit=".bin">” se asume que el archivo está en formato binario (consulta la función <@ref="mwrite"> para tener más detalles). En caso contrario, se asume que el archivo tiene un formato de texto simple, de acuerdo con las siguientes especificaciones: 

<indent>
• El archivo puede comenzar con una cantidad cualquiera de comentarios, definidos por líneas que comienzan con el carácter numeral, <@lit="#">; estas líneas van a ignorarse. 
</indent>

<indent>
• La primera línea que no sea un comentario debe contener dos enteros, separados por un espacio o una tabulación, para indicar el número de filas y columnas, respectivamente. 
</indent>

<indent>
• Las columnas deben estar separadas por espacios o por tabulaciones. 
</indent>

<indent>
• El separador decimal debe ser el carácter punto, “<@lit=".">”. 
</indent>

Si en el primer argumento no está especificada la ruta completa hasta el archivo, se va a buscar en algunas localizaciones que se consideren “probables”, empezando por el directorio de trabajo establecido en ese momento en <@xrf="workdir">. No obstante, cuando se indica un valor no nulo para el segundo argumento <@var="importar"> (opcional) de la función, el archivo se busca en el directorio “punto” del usuario. Esto tiene la intención de que se use esta función junto con las que exportan matrices, y que se ofrecen en el contexto de la instrucción <@xrf="foreign">. En ese caso, el argumento <@var="nombrearchivo"> debe ser un nombre de archivo simple, sin indicar la ruta hasta el archivo. 

Ver también <@ref="bread">, <@ref="mwrite">. 

# mreverse matshape
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="porcolumna">  (booleano, opcional)

Devuelve una matriz que contiene las filas de <@var="X"> en orden inverso; o las columnas en orden inverso si el segundo argumento tiene un valor no nulo. 

# mrls stats
Resultado: 	matriz 
Argumentos:	<@var="Y">  (matriz)
		<@var="X">  (matriz)
		<@var="R">  (matriz)
		<@var="q">  (vector columna)
		<@var="&U">  (referencia a matriz, o <@lit="null">)
		<@var="&V">  (referencia a matriz, o <@lit="null">)

Mínimos cuadrados restringidos: Genera la matriz de orden <@itl="k">×<@itl="n"> con los parámetros estimados mediante la regresión de mínimos cuadrados de la matriz <@var="Y"> de orden <@itl="T">×<@itl="n">, sobre la matriz <@var="X"> de orden <@itl="T">×<@itl="k">, sujeta al conjunto de restricciones lineales de los parámetros <@mth="RB "> = <@mth="q">, donde <@mth="B"> representa el vector que formarían los parámetros apilados unos sobre los otros. <@var="R"> debe tener <@mth="kn"> columnas, y cada línea de ella indica los coeficientes de una de las restricciones lineales. El número de filas de <@var="q"> debe coincidir con el número de filas de <@var="R">. 

Si el quinto argumento de la función no es <@lit="null">, entonces la matriz <@var="U"> de orden <@itl="T">×<@itl="n"> va a contener los errores. Cuando proporcionas un argumento final que no es <@lit="null">, entonces la matriz <@var="V"> de orden <@itl="k">×<@itl="k"> va a guardar la contrapartida restringida de la matriz <@mth="X'X"><@sup="-1">. Puedes construir la matriz de varianzas-covarianzas de los estimadores de la ecuación <@mth="i"> multiplicando la submatriz apropiada de <@var="V"> por una estimación de la varianza de la perturbación de esa ecuación. 

# mshape matshape
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="r">  (entero)
		<@var="c">  (entero)

Reordena los elementos de la matriz <@var="X"> en una nueva matriz que tiene <@var="r"> filas y <@var="c"> columnas. Los elementos se leen y se guardan comenzando por el de las primeras columna y fila de <@var="X">, y siguiendo con los de las siguientes filas hasta acabar con los de esa columna; y luego con las demás columnas. Si <@var="X"> tiene menos elementos que <@mth="k">= <@mth="rc">, estos se van a repetir de forma cíclica. En otro caso, si <@var="X"> tiene más elementos, solo se utilizan los primeros <@mth="k"> elementos. 

Ver también <@ref="cols">, <@ref="rows">, <@ref="unvech">, <@ref="vec">, <@ref="vech">. 

# msortby matshape
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="j">  (entero)

Devuelve una matriz con las mismas filas de la matriz del argumento <@var="X"> reordenadas de forma creciente de acuerdo con los elementos de la columna <@var="j">. Este orden es estable: las filas que comparten el mismo valor en la columna <@var="j"> no se intercambian. 

# muniform matbuild
Resultado: 	matriz 
Argumentos:	<@var="r">  (entero)
		<@var="c">  (entero)

Devuelve una matriz formada con números generados de forma pseudoaleatoria mediante variables con distribución Uniforme (0,1), y que va a tener <@var="r"> filas y <@var="c"> columnas. Aviso: El método predilecto para generar números pseudoaleatorios con distribución Uniforme es el que usa la función <@ref="randgen1">. 

Ver también <@ref="mnormal">, <@ref="uniform">. 

# mweights midas
Resultado: 	matriz 
Argumentos:	<@var="p">  (entero)
		<@var="theta">  (vector)
		<@var="tipo">  (entero o cadena)

Devuelve un vector de orden <@mth="p"> con las ponderaciones MIDAS que se aplican a los <@mth="p"> retardos de una serie de alta frecuencia, basado en el vector <@var="theta"> de hiperparámetros. 

El argumento <@var="tipo"> identifica el tipo de disposición de parámetros que va a regular el número <@mth="k"> de elementos que se solicitan para <@var="theta">: 1 = para Almon exponencial normalizada (<@mth="k"> debe ser cuando menos igual a1, habitualmente 2); 2 = para Beta normalizada con el retardo final nulo (<@mth="k"> = 2); 3 = para Beta normalizada con el retardo final no nulo (<@mth="k"> = 3); y 4 = para Almon polinómico (<@mth="k"> debe ser cuando menos igual a 1). Ten en cuenta que, en el caso de Beta normalizada, los dos primeros elementos de <@var="theta"> deben ser positivos. 

Puedes indicar el <@var="tipo"> como un código entero, tal y como se muestra más abajo, o mediante una de las siguientes cadenas de texto (respectivamente): <@lit="nealmon">, <@lit="beta0">, <@lit="betan"> o <@lit="almonp">. Si utilizas una cadena de texto, esta deberá estar situada entre comillas. Por ejemplo, las dos siguientes expresiones son equivalentes: 

<code>          
     W = mweights(8, theta, 2)
     W = mweights(8, theta, "beta0")
</code>

Ver también <@ref="mgradient">, <@ref="mlincomb">. 

# mwrite data-utils
Resultado: 	entero 
Argumentos:	<@var="X">  (matriz)
		<@var="nombrearchivo">  (cadena)
		<@var="exportar">  (booleano, opcional)

Escribe la matriz del argumento <@var="X"> en un archivo con el nombre <@var="nombrearchivo">. Por defecto, este archivo va a ser de texto plano y, en la primera línea, va a contener dos números enteros que representan el número de filas y de columnas (respectivamente) separados por un carácter de tabulación. En las siguientes filas, los elementos de la matriz se muestran con notación científica, separados por tabulaciones (una línea por fila). Para formatos alternativos, mira más abajo. 

Cuando ya existe un archivo llamado <@var="nombrearchivo">, se va a sobrescribir. La ejecución de la función devuelve un entero igual a 0 si no se completa con éxito; y devuelve un entero que no es cero cuando sucede un fallo (por ejemplo si no se puede sobrescribir el archivo). 

El archivo con los resultados va a escribirse en el directorio establecido como vigente, <@xrf="workdir">, excepto que la cadena de texto del argumento <@var="nombrearchivo"> especifique el directorio con la ruta completa. No obstante, si indicas un valor no nulo para el argumento <@var="exportar">, el archivo con los resultados va a escribirse en el directorio “punto” del usuario, donde estará accesible por defecto mediante las funciones para cargar matrices que se ofrecen en el contexto de la instrucción <@xrf="foreign">. En este caso, debes indicar un simple nombre de archivo para el segundo argumento, sin la parte que expresa la ruta al directorio. 

Las matrices guardadas mediante la forma que tiene por defecto la función <@lit="mwrite">, pueden leerse fácilmente con otros programas. Consulta <@pdf="El manual de gretl#chap:matrices"> (Capítulo 16) para obtener más detalles. 

Dos matizaciones, que se excluyen mutuamente, de esta función están disponibles como se indica a continuación: 

<indent>
• Si el argumento <@var="nombrearchivo"> tiene la extensión “<@lit=".gz">”, entonces el archivo se guarda con la compresión gzip. 
</indent>

<indent>
• Si el argumento <@var="nombrearchivo"> tiene la extensión “<@lit=".bin">”, entonces el archivo se guarda con formato binario. En este caso, los primeros 19 bytes contienen los caracteres <@lit="gretl_binary_matrix">; los siguientes 8 bytes contienen dos enteros de 32 bits que proporcionan el número de filas y de columnas; y lo que resta del archivo contiene los elementos de la matriz ordenados por columnas, en formato “little-endian doubles”. Cuando ejecutas Gretl en un sistema “big-endian”, los valores binarios se convierten a “little-endian” al escribirlos, y a “big-endian” al leerlos. 
</indent>

Ten en cuenta que, si vas a leer el archivo con la matriz utilizando otro software ajeno, no resulta aconsejable que utilices las opciones gzip ni binario. Pero si lo quieres para que lo lea Gretl, estos dos formatos alternativos permiten ahorrar espacio; y con el formato binario logras una lectura más rápida de matrices grandes. El formato gzip no es recomendable para matrices muy grandes porque la descompresión puede ser bastante lenta. 

Ver también <@ref="mread">. 

# mxtab stats
Resultado: 	matriz 
Argumentos:	<@var="x">  (serie o vector)
		<@var="y">  (serie o vector)

Devuelve una matriz que incluye la tabulación cruzada de los valores contenidos en <@var="x"> (por filas) e <@var="y"> (por columnas). Los dos argumentos de esta función deben ser del mismo tipo (ambas series o ambos vectores columna) y, a causa de la utilización típica de esta función, se asume que contiene únicamente valores enteros. 

Ver también <@ref="values">. 

# naalen stats
Resultado: 	matriz 
Argumentos:	<@var="d">  (serie o vector)
		<@var="cens">  (serie o vector, opcional)

Devuelve el cálculo del estimador no paramétrico de Nelson–Aalen de la función de riesgo (<@bib="Nelson, 1972;nelson72">; <@bib="Aalen, 1978;aalen78">), dada una muestra <@var="d"> de datos de duración, que posiblemente esté acompañada de un registro de estado de censura, <@var="cens">. La matriz que devuelve la función tiene tres columnas que contienen, respectivamente: los valores únicos ordenados en <@var="d">, la estimación de la función de riesgo acumulado que se corresponde con los valores de duración de la columna 1, y la desviación típica del estimador. 

Cuando indicas la serie <@var="cens">, se utiliza el valor 0 para señalar que una observación no está censurada, mientras que el valor 1 indica que una observación está censurada del lado derecho (es decir, el período de observación del individuo en cuestión concluyó antes de la duración o el período se registró como finalizado). Cuando no indicas <@var="cens">, se asume que todas las observaciones son no censuradas. (Aviso: la semántica de <@var="cens"> puede extenderse en algún punto para cubrir otros tipos de censura.) 

Ver también <@ref="kmeier">. 

# nadarwat stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="x">  (serie)
		<@var="h">  (escalar, opcional)
		<@var="LOO">  (booleano, opcional)
		<@var="recorte">  (escalar, opcional)

Calcula una serie con la estimación no paramétrica de la media condicional de <@var="y"> dado <@var="x">, de Nadaraya-Watson. La serie que devuelve la función, contiene <@mth="m(x"><@sub="i"><@mth=")">, los valores de las estimaciones de <@mth="E(y"><@sub="i"><@mth="|x"><@sub="i"><@mth=")"> para cada uno de los elementos no ausentes de la serie <@var="x">. 

La función núcleo (kernel) empleada por este estimador viene dada por <@mth="K = exp(-x"><@sup="2"><@mth="/2h)"> cuando <@mth="|x|<T">, y es igual a cero en otro caso. (<@mth="T"> = Parámetro de recorte.) 

Los tres argumentos opcionales modulan el comportamiento del estimador tal como se describe más abajo. 

<@itl="Ancho de banda"> 

Puedes usar el argumento <@var="h"> para controlar el ancho de banda (“bandwidth”), mediante un número real positivo. Habitualmente este es un número pequeño, pues valores más grandes de <@var="h"> hacen que <@mth="m(x)"> sea más suave. Una elección popular es hacer que <@var="h"> sea proporcional a <@mth="n"><@sup="-0.2">. Si omites <@var="h"> o lo igualas a cero, el ancho de banda se establece por defecto con un valor determinado por los datos, utilizando la proporcionalidad que se acaba de mencionar, pero introduciendo la dispersión de los datos de <@var="x"> tal como la mide el rango inter-cuartil o la desviación estándar; consulta <@pdf="El manual de gretl#chap:nonparam"> (Capítulo 37) para obtener más detalles. 

<@itl="Dejar-una-fuera"> 

“Dejar-una-fuera” es una variante del algoritmo, que omite la observación <@mth="i">-ésima cando se evalúa <@mth="m(x"><@sub="i"><@mth=")">. Esto hace que el estimador de Nadaraya–Watson sea numéricamente más robusto, y por eso se recomienda habitualmente utilizarlo cuando el estimador se calcula con intención de hacer inferencias. Esta variante no está permitida por defecto, pero se activa cuando se indica un valor no nulo para el argumento <@var="LOO">. 

<@itl="Recorte"> 

Puedes usar el argumento <@var="recorte"> para controlar el grao de “recorte” que se impone para prevenir problemas numéricos, cuando la función 'kernel' se está evaluando demasiado lejos de cero. Este parámetro se expresa como un múltiplo de <@var="h">, siendo 4 el valor por defecto. En algunos casos, puede ser preferible utilizar un valor mayor que 4. De nuevo, consulta <@pdf="El manual de gretl#chap:nonparam"> (Capítulo 37) para obtener más detalles. 

Consulta también <@ref="loess">. 

# nelem data-utils
Resultado: 	entero 
Argumento: 	<@var="L">  (lista, matriz, bundle o array)

Devuelve un entero con el número de elementos que hay en el argumento; este puede ser una lista, una matriz, un 'bundle' o un 'array' (pero no una serie). 

# ngetenv strings
Resultado: 	escalar 
Argumento: 	<@var="s">  (cadena)

Devuelve un escalar con el valor numérico de una variable de contexto que tiene el nombre del argumento <@var="s">, se esa variable está definida y se tiene un valor numérico; en otro caso devuelve NA. Consulta también <@ref="getenv">. 

# nlines strings
Resultado: 	escalar 
Argumento: 	<@var="buf">  (cadena)

Devuelve un escalar con la cantidad de filas completas (es decir, filas que rematan con el carácter de nueva línea) en <@var="buf">. 

Ejemplo: 

<code>          
        string web_page = readfile("http://gretl.sourceforge.net/")
        scalar number = nlines(web_page)
        print number
</code>

# NMmax numerical
Resultado: 	escalar 
Argumentos:	<@var="&b">  (referencia a matriz)
		<@var="f">  (llamada a función)
		<@var="maxevalfunc">  (entero, opcional)

Devuelve un escalar con el resultado de una maximización numérica hecha con el método del simplex sin derivadas de Nelder–Mead. El argumento <@var="b"> debe contener los valores iniciales de un conjunto de parámetros, y el argumento <@var="f"> debe especificar una llamada a la función que va a calcular el criterio objetivo (escalar) que se quiere maximizar, dados los valores vigentes de los parámetros, así como cualesquiera otros datos que sean relevantes. Cuando se completa con éxito su ejecución, <@lit="NMmax"> devuelve el valor maximizado del criterio objetivo, y <@var="b"> contiene finalmente los valores de los parámetros que producen el máximo. 

Puedes utilizar el tercer argumento (opcional) para indicar el número máximo de evaluaciones de la función; si lo omites o lo estableces igual a cero, el máximo se toma por defecto igual a 2000. Como indicación especial para esta función, puedes poner un valor negativo para o argumento <@var="maxevalfunc">. En ese caso, se toma su valor absoluto y <@lit="NMmax"> muestra un fallo si el mejor valor encontrado para la función objetivo después de realizar el máximo número de evaluaciones de la función, no es un óptimo local. Por otra parte, en este sentido la no convergencia no se trata como un fallo. 

Si tu objetivo realmente es alcanzar un mínimo, puedes bien cambiar la función considerando el negativo del criterio, o bien, alternativamente, puedes invocar la función <@lit="NMmax">bajo el alias <@lit="NMmin">.. 

Para más detalles y ejemplos, consulta <@pdf="El manual de gretl#chap:numerical"> (Capítulo 34). Ver también <@ref="simann">. 

# NMmin numerical
Resultado: 	escalar 

Un alias de <@ref="NMmax">. Si invocas la función bajo este nombre, se ejecuta haciendo una minimización. 

# nobs stats
Resultado: 	entero 
Argumento: 	<@var="y">  (serie)

Devuelve el número de observaciones no ausentes de la variable <@var="y"> en la muestra vigente seleccionada. 

# normal probdist
Resultado: 	serie 
Argumentos:	<@var="μ">  (escalar)
		<@var="σ">  (escalar)

Devuelve una serie generada con una variable pseudoaleatoria gaussiana de media μ y desviación típica σ. Si no indicas ningún argumento, los valores que se devuelven son los de una variable con distribución de probabilidad Normal estándar, <@mth="N">(0,1). Los valores se producen utilizando el método Ziggurat (<@bib="Marsaglia y Tsang, 2000;marsaglia00">). 

Ver también <@ref="randgen">, <@ref="mnormal">, <@ref="muniform">. 

# normtest stats
Resultado: 	matriz 
Argumentos:	<@var="y">  (serie o vector)
		<@var="método">  (cadena, opcional)

Devuelve un vector fila con los resultados de realizar un contraste de Normalidad sobre <@var="y">. La función realiza por defecto el contraste de Doornik–Hansen, pero puedes utilizar el argumento <@var="método"> (opcional) para escoger una alternativa. Indica: <@lit="swilk"> para ejecutar el contraste de Shapiro–Wilk, <@lit="jbera"> para realizar el contraste de Jarque–Bera, o <@lit="lillie"> para efectuar el contraste de Lilliefors. 

Puedes indicar el segundo argumento con formato entre comillas o sin ellas. En este último caso, también puedes indicar una cadena de texto cuyo valor sea el nombre de uno de los métodos, por el que se va a substituir cuando se ejecuta. A continuación se muestran tres modos aceptables de ejecutar el contraste de Shapiro–Wilk: 

<code>          
     matrix nt = normtest(y, swilk)
     matrix nt = normtest(y, "swilk")
     string testtype = "swilk"
     matrix nt = normtest(y, testtype)
</code>

El vector fila que se devuelve es de orden 1×2; contiene el valor del estadístico de contraste solicitado y la probabilidad asociada a ese valor. Consulta también la instrucción <@xrf="normtest">. 

# npcorr stats
Resultado: 	matriz 
Argumentos:	<@var="x">  (serie o vector)
		<@var="y">  (serie o vector)
		<@var="método">  (cadena, opcional)

Devuelve un vector fila con los cálculos de una medida de correlación entre <@var="x"> e <@var="y">, utilizando un método no paramétrico. Si indicas el tercer argumento, este debe ser <@lit="kendall"> (para el método por defecto, el tau de Kendall, versión b) o bien <@lit="spearman"> (para el rho de Spearman). 

El resultado que se devuelve es un vector fila con 3 valores que indican: la medición de la correlación, el valor del estadístico de contraste de la hipótesis nula de incorrelación, y la probabilidad asociada a ese valor. Observa que, si el tamaño de la muestra es muy pequeño, el estadístico de contraste y/o la probabilidad puede ser <@lit="NaN"> (no es número, o ausente). 

Consulta también <@ref="corr"> para la correlación de Pearson. 

# npv math
Resultado: 	escalar 
Argumentos:	<@var="x">  (serie o vector)
		<@var="r">  (escalar)

Devuelve un escalar con el Valor Actual Neto de <@var="x">, considerado este como una secuencia de pagos (negativos) e ingresos (positivos), evaluados a una tasa de descuento anual que debes indicar en el argumento <@var="r"> como fracción decimal entre 0 y 1, no como porcentaje (por ejemplo 0.05, y no 5<@lit="%">). El primer valor de la serie/vector del primer argumento se considera que está fechado “ahora”, y no se descuenta. Para imitar una función VAN en la que se descuente el primer valor, añade un cero al principio de la serie/vector del primer argumento. 

El tipo de frecuencia de los datos que admite esta función puede ser anual, trimestral, mensual y sin fecha (este tipo se trata como si fuera anual). 

Ver también <@ref="irr">. 

# NRmax numerical
Resultado: 	escalar 
Argumentos:	<@var="&b">  (referencia a matriz)
		<@var="f">  (llamada a función)
		<@var="g">  (llamada a función, opcional)
		<@var="h">  (llamada a función, opcional)

Devuelve un escalar con el resultado de una maximización numérica hecha con el método de Newton–Raphson. El argumento <@var="b"> debe contener los valores iniciales del conjunto de parámetros, y el argumento <@var="f"> debe indicar una llamada a la función que va a calcular el criterio objetivo (escalar) que quieres maximizar, dados los valores vigentes de los parámetros, así como cualquier otro dato relevante. Si lo que quieres realmente es minimizar el criterio objetivo, esta función debería devolver el valor negativo del mismo. Cuando se completa con éxito su ejecución, <@lit="NRmax"> devuelve el valor maximizado del criterio objetivo, y <@var="b"> va a contener los valores de los parámetros que proporcionan el máximo de ese criterio. 

El tercer y cuarto argumentos (opcionales) proporcionan modos de indicar, respectivamente, las derivadas analíticas y una matriz hessiana analítica (negativa). Las funciones a las que se refieren estos argumentos <@var="g"> y <@var="h"> deben tener, como primer elemento, una matriz definida con anterioridad que sea del rango correcto para poder contener el vector gradiente o la matriz hessiana, indicados en forma de puntero. Además, otro de sus elementos, debe ser el vector de parámetros (en forma de puntero o no). Otro tipo de elementos son opcionales. Si omites cualquiera de los argumentos opcionales (o los dos), se utiliza una aproximación numérica. 

Para más detalles y ejemplos, consulta <@pdf="El manual de gretl#chap:numerical"> (Capítulo 34). Ver también <@ref="BFGSmax">, <@ref="fdjac">. 

# NRmin numerical
Resultado: 	escalar 

Un alias de <@ref="NRmax">. Si invocas la función bajo este nombre, se ejecuta haciendo una minimización. 

# nullspace linalg
Resultado: 	matriz 
Argumento: 	<@var="A">  (matriz)

Devuelve una matriz con el cálculo del espacio nulo a la derecha correspondiente a la matriz <@var="A">, hecho mediante la descomposición en valores singulares: el resultado es una matriz <@mth="B"> que hace que el producto <@mth="AB"> sea una matriz nula. Como excepción, si la matriz <@var="A"> tiene rango completo por columnas, el resultado que se devuelve es una matriz vacía. Por otro lado, si <@var="A"> es de orden <@itl="m">×<@itl="n">, entonces <@mth="B"> va a ser <@mth="n"> por (<@mth="n"> – <@mth="r">), donde <@mth="r"> es el rango de <@var="A">. 

Si <@var="A"> no tiene rango completo por columnas, entonces al concatenar verticalmente la matriz <@var="A"> y la matriz traspuesta de <@var="B">, se genera una matriz con rango completo. 

Ejemplo: 

<code>          
      A = mshape(seq(1,6),2,3)
      B = nullspace(A)
      C = A | B'

      print A B C

      eval A*B
      eval rank(C)
</code>

produce... 

<code>          
      ? print A B C
      A (2 x 3)

      1   3   5
      2   4   6

      B (3 x 1)

      -0.5
         1
      -0.5

      C (3 x 3)

         1      3      5
         2      4      6
      -0.5      1   -0.5

      ? eval A*B
      -4.4409e-16
      -4.4409e-16

      ? eval rank(C)
      3
</code>

Ver también <@ref="rank">, <@ref="svd">. 

# numhess numerical
Resultado: 	matriz 
Argumentos:	<@var="b">  (vector columna)
		<@var="fcall">  (llamada a función)
		<@var="d">  (escalar, opcional)

Calcula una aproximación numérica a la matriz hessiana asociada al vector <@mth="n">-dimensional <@var="b">, y a la función objetivo que se especifique mediante el argumento <@var="fcall">. La llamada a la función debe tener <@var="b"> como primer argumento (bien directamente o bien en forma de puntero), seguido de cualquier argumento adicional que pueda ser necesario, y debe devolver como resultado un escalar. Al completarse con éxito <@lit="numhess"> devuelve una matriz <@itl="n">×<@itl="n"> que contiene la hessiana, y que es exactamente simétrica por construcción. 

El método utiliza la extrapolación de Richardson, con cuatro pasos. Puedes usar el tercer argumento (opcional) para establecer la fracción <@mth="d"> del valor del parámetro que se utiliza para determinar el tamaño del paso inicial. Cuando omites este argumento, por defecto va a ser <@mth="d"> = 0.01. 

Aquí tienes un ejemplo de su uso: 

<code>          
     matrix H = numhess(theta, myfunc(&theta, X))
</code>

Ver también <@ref="BFGSmax">, <@ref="fdjac">. 

# obs data-utils
Resultado: 	serie 

Devuelve una serie de números enteros consecutivos, correspondiendo el 1 con el inicio del conjunto de datos. Ten en cuenta que el resultado no va a depender de que tengas escogida una submuestra. Esta función es útil especialmente con conjuntos de datos de series temporales. Advertencia: Puedes escribir <@lit="t"> en lugar de <@lit="obs">, con el mismo efecto. 

Ver también <@ref="obsnum">. 

# obslabel data-utils
Resultado: 	cadena 
Argumento: 	<@var="t">  (entero)

Devuelve la etiqueta de la observación <@var="t">, siendo <@var="t"> un número entero positivo que representa a esa observación. La operación inversa se puede hacer mediante la función <@ref="obsnum">. 

# obsnum data-utils
Resultado: 	entero 
Argumento: 	<@var="s">  (cadena)

Devuelve el número entero que indica la observación que se corresponde con la cadena del argumento <@mth="s">. Ten en cuenta que el resultado no va a depender de que tengas escogida una submuestra. Esta función es útil con conjuntos de datos de series temporales. Por ejemplo, el siguiente código ... 

<code>          
     open denmark
     k = obsnum(1980:1)
</code>

... genera <@lit="k = 25">, indicando que el primer trimestre de 1980 es la vigésimo quinta observación de la base de datos <@lit="denmark">. 

Ver también <@ref="obs">, <@ref="obslabel">. 

# ok data-utils
Resultado: 	mira más abajo 
Argumento: 	<@var="x">  (escalar, serie, matriz o lista)

Cuando el argumento <@var="x"> es un escalar, esta función devuelve 1 se <@var="x"> no es <@lit="NA">, y 0 en otro caso. Cuando <@var="x"> es una serie, devuelve otra serie que toma el valor 1 en las observaciones en las que el argumento no tiene valores ausentes, y toma el valor cero en los demás. Si <@var="x"> es una lista, el resultado es una serie con 0 en las observaciones en las que al menos una serie de la lista tiene un valor ausente, y 1 en otro caso. 

Cuando el argumento <@var="x"> es una matriz, la función devuelve otra matriz de la misma dimensión que <@var="x">, con el valor 1 en las posiciones que se corresponden con elementos finitos de <@var="x">, y con el valor 0 en las posiciones en las que los elementos no son finitos (o bien infinitos, o bien “no números”, para el estándar IEEE 754). 

Ver también <@ref="missing">, <@ref="misszero">, <@ref="zeromiss">. Pero ten en cuenta que estas funciones no son aplicables a matrices. 

# onenorm linalg
Resultado: 	escalar 
Argumento: 	<@var="X">  (matriz)

Devuelve un escalar con la norma 1 de la matriz <@var="X">, es decir, el máximo de los resultados de sumar los valores absolutos de los elementos de <@var="X"> por columnas. 

Ver también <@ref="infnorm">, <@ref="rcond">. 

# ones matbuild
Resultado: 	matriz 
Argumentos:	<@var="r">  (entero)
		<@var="c">  (entero)

Devuelve una matriz con <@mth="r"> filas y <@mth="c"> columnas, cubierta con valores iguales a 1. 

Ver también <@ref="seq">, <@ref="zeros">. 

# orthdev transforms
Resultado: 	serie 
Argumento: 	<@var="y">  (serie)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie con el cálculo de las desviaciones ortogonales adelantadas para la variable <@var="y">. 

Algunas veces se utiliza esta transformación en lugar de la diferenciación para eliminar los efectos individuales de los datos de panel. Por compatibilidad con las primeras diferencias, las desviaciones se guardan adelantadas un paso de su localización temporal verdadera (es decir, el valor en la observación <@mth="t"> es la desviación que, expresándolo de manera estricta, pertenece a <@mth="t"> – 1). De este modo, se pierde la primera observación en cada serie temporal, no la última. 

Ver también <@ref="diff">. 

# pdf probdist
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="d">  (cadena)
		<@var="…">  (mira más abajo)
		<@var="x">  (escalar, serie o matriz)
Ejemplos: 	<@lit="f1 = pdf(N, -2.5)">
		<@lit="f2 = pdf(X, 3, y)">
		<@lit="f3 = pdf(W, forma, escala, y)">

Calcula el valor de la función de densidad de probabilidad, y devuelve un resultado (del mismo tipo que el argumento) con la densidad en <@var="x"> de la distribución identificada por el código <@var="d">. Consulta <@ref="cdf"> para obtener más detalles acerca de los argumentos (escalares) exigidos. Esta función <@lit="pdf"> acepta las distribuciones: Normal, <@mth="t"> de Student, Chi-cuadrado, <@mth="F">, Gamma, Exponencial, Weibull, Laplace, Error Generalizado, Binomial y Poisson. Ten en cuenta que para la Binomial y la Poisson, lo que se calcula de hecho es la masa de probabilidad en el punto especificado. Para <@mth="t"> de Student, Chi-cuadrado y <@mth="F"> también están disponibles sus variantes no centrales. 

Para la distribución Normal, consulta también <@ref="dnorm">. 

# pergm stats
Resultado: 	matriz 
Argumentos:	<@var="x">  (serie o vector)
		<@var="anchobanda">  (escalar, opcional)

Si solo indicas la serie o vector del primer argumento, se calcula su periodograma en la muestra. Si indicas el escalar del segundo argumento, calcula la estimación del espectro de <@var="x"> con una ventana de retardos de Bartlett con un ancho de banda igual a ese escalar, hasta un máximo igual a la mitad del número de observaciones (<@mth="T">/2). 

Devuelve una matriz con <@mth="T">/2 filas y dos columnas: la primera de estas contiene la frecuencia (ω) desde 2π/<@mth="T"> hasta π, y la segunda de las columnas contiene la densidad espectral correspondiente. 

# pexpand data-utils
Resultado: 	serie 
Argumento: 	<@var="v">  (vector)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y realiza la operación inversa de <@ref="pshrink">. Es decir, dado un vector que tiene una longitud igual al número de elementos de la muestra (de panel) vigente seleccionada, esta función devuelve una serie en la cual cada valor del argumento se repite <@mth="T"> veces, donde <@mth="T"> expresa la longitud temporal del panel. De este modo, la serie resultante es invariante con respecto al tiempo. 

# pmax stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie que contiene cada uno de los valores máximos de la variable <@var="y"> en cada unidad de corte transversal (repitiéndolo en los períodos temporales de cada una de estas). 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Ver también <@ref="pmin">, <@ref="pmean">, <@ref="pnobs">, <@ref="psd">, <@ref="pxsum">, <@ref="pshrink">, <@ref="psum">. 

# pmean stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie que contiene cada una de las medias temporales de la variable <@var="y"> en cada unidad de corte transversal (repitiendo cada valor en los períodos temporales de cada una de estas). Las observaciones ausentes se ignoran al calcular las medias. 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Ver también <@ref="pmax">, <@ref="pmin">, <@ref="pnobs">, <@ref="psd">, <@ref="pxsum">, <@ref="pshrink">, <@ref="psum">. 

# pmin stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie que contiene cada uno de los valores mínimos de la variable <@var="y"> en cada unidad de corte transversal (repitiendo cada valor en los períodos temporales de cada una de estas). 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Ver también <@ref="pmax">, <@ref="pmean">, <@ref="pnobs">, <@ref="psd">, <@ref="pshrink">, <@ref="psum">. 

# pnobs stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie que contiene el número de observaciones válidas de la variable <@var="y"> en cada unidad de corte transversal (repitiéndolo en los períodos temporales de cada una de estas). 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Ver también <@ref="pmax">, <@ref="pmin">, <@ref="pmean">, <@ref="psd">, <@ref="pshrink">, <@ref="psum">. 

# polroots linalg
Resultado: 	matriz 
Argumento: 	<@var="a">  (vector)

Devuelve una matriz con las raíces de un polinomio. Si el polinomio es de grado <@mth="p">, el vector <@var="a"> debe contener <@mth="p"> + 1 coeficientes en orden ascendente; es decir, comenzando con la constante y finalizando con el coeficiente de <@mth="x"><@sup="p">. 

Si todas las raíces son reales, se van a devolver en un vector columna de dimensión <@mth="p">; en caso contrario, se devuelve una matriz de orden <@itl="p">×2, con las partes reales en la primera columna y las partes imaginarias en la segunda. 

# polyfit filters
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="q">  (entero)

Devuelve una serie, ajustando una tendencia polinómica de orden <@var="q"> a la serie del argumento <@var="y">, utilizando el método de polinomios ortogonales. La serie que se genera contiene los valores ajustados. 

# princomp stats
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="p">  (entero)
		<@var="matrizcov">  (booleano, opcional)

Sea <@var="X"> una matriz de orden <@itl="T">×<@itl="k">, que contiene <@mth="T"> observaciones sobre <@mth="k"> variables. El argumento <@var="p"> debe ser un número entero positivo menor que o igual a <@mth="k">. Esta función devuelve una matriz <@mth="P">, de orden <@itl="T">×<@itl="p">, que contiene las <@mth="p"> primeras componentes principales de <@var="X">. 

El tercer argumento (opcional) opera como un conmutador booleano: si no es cero, las componentes principales se calculan en base a la matriz de varianzas-covarianzas de las columnas de <@var="X"> (por defecto se utiliza la matriz de correlaciones). 

Los elementos de la matriz <@mth="P"> que se devuelve, se calculan como la suma desde <@mth="i"> hasta <@mth="k"> de <@mth="Z"><@sub="ti"> veces <@mth="v"><@sub="ji">, donde <@mth="Z"><@sub="ti"> representa el valor estandarizado (o simplemente el valor centrado, si utilizas la matriz de covarianzas) de la variable <@mth="i"> en la observación <@mth="t">, y <@mth="v"><@sub="ji"> representa el <@mth="j">-ésimo autovector de la matriz de correlaciones (o la matriz de covarianzas) entre las <@mth="X"><@sub="i">s, con los autovectores ordenados de acuerdo con los valores decrecientes de los autovalores correspondientes. 

Ver también <@ref="eigensym">. 

# prodc stats
Resultado: 	vector fila 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector fila con el producto de los elementos de las columnas de <@var="X">. Ver también <@ref="prodr">, <@ref="meanc">, <@ref="sdc">, <@ref="sumc">. 

# prodr stats
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna con el producto de los elementos de las filas de <@var="X">. Ver también <@ref="prodc">, <@ref="meanr">, <@ref="sumr">. 

# psd stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie que contiene la desviación típica (muestral) de la variable <@mth="y">, en cada unidad de corte transversal (repitiendo cada valor en los períodos temporales de cada una de estas). El denominador que se utiliza es el tamaño de la muestra en cada unidad menos 1, excepto que solo haya 1 única observación válida para una unidad dada (pues en este caso se devuelve 0) o que no haya ninguna (en este caso se devuelve <@lit="NA">). 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Nota: Esta función permite comprobar si una variable cualquiera (por ejemplo, <@lit="X">) es invariante a lo largo del tiempo, por medio de la condición <@lit="max(psd(X)) == 0">. 

Ver también <@ref="pmax">, <@ref="pmin">, <@ref="pmean">, <@ref="pnobs">, <@ref="pshrink">, <@ref="psum">. 

# psdroot linalg
Resultado: 	matriz cuadradax 
Argumentos:	<@var="A">  (matriz simétrica)
		<@var="probapsd">  (booleano, opcional)

Devuelve la matriz cuadrada que resulta de aplicarle a la matriz simétrica <@var="A"> del argumento, una variante generalizada de la descomposición de Cholesky. La matriz del argumento debe ser semidefinida positiva (aunque puede ser singular) pero, si no es cuadrada, se muestra un mensaje de fallo. La simetría se asume y no se comprueba; solo se lee el triángulo inferior de <@var="A">. El resultado es una matriz triangular inferior, <@mth="L">, que cumple <@mth="A = LL'">. Los elementos indeterminados de la solución se establecen como iguales a cero. 

Para forzar la comprobación de que <@var="A"> es semidefinida positiva, indica un valor no nulo para el segundo argumento (opcional). En ese caso, se muestra un fallo si el máximo valor absoluto de <@mth="A – LL'"> es mayor que 1.0e-8. Este tipo de comprobación también puedes hacerla manualmente: 

<code>          
     L = psdroot(A)
     chk = maxc(maxr(abs(A - L*L')))
</code>

Para el caso en el que la matriz <@var="A"> es definida positiva, consulta <@ref="cholesky">. 

# pshrink data-utils
Resultado: 	matriz 
Argumento: 	<@var="y">  (serie)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve un vector que contiene cada una de las primeras observaciones válidas de la serie <@var="y"> en cada unidad de corte transversal del panel, a lo largo del rango de la muestra vigente. Si la serie tiene alguna unidad sin observaciones válidas, esa unidad se ignora. 

Esta función te proporciona un modo de compactar las series que te van a devolver algunas funciones tales como <@ref="pmax"> y <@ref="pmean">, en las que se repite un mismo valor en los diferentes períodos de tiempo de una misma unidad de corte transversal. 

Consulta <@ref="pexpand"> para la operación inversa. 

# psum stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie en la que cada valor es la suma de la variable <@var="y"> en los distintos períodos temporales de cada unidad de corte transversal. En cada una de estas, la suma así calculada se repite para cada período temporal. Las observaciones ausentes se ignoran en el cálculo de las sumas. 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Ver también <@ref="pmax">, <@ref="pmean">, <@ref="pmin">, <@ref="pnobs">, <@ref="psd">, <@ref="pxsum">, <@ref="pshrink">. 

# pvalue probdist
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="c">  (carácter)
		<@var="…">  (mira más abajo)
		<@var="x">  (escalar, serie o matriz)
Ejemplos: 	<@lit="p1 = pvalue(z, 2.2)">
		<@lit="p2 = pvalue(X, 3, 5.67)">
		<@lit="p2 = pvalue(F, 3, 30, 5.67)">

Calcula valores <@mth="P"> de probabilidad, y devuelve un resultado (del mismo tipo que el argumento) con la probabilidad <@mth="P(X > x)">, donde la distribución de probabilidad de <@mth="X"> se indica con la letra <@var="c">. Entre los argumentos <@var="d"> y <@var="p">, puedes necesitar algún argumento adicional escalar para especificar los parámetros de la distribución de que se trate. Para más detalles, consulta <@ref="cdf">. Las distribuciones soportadas por la función <@lit="pvalue"> son: Normal estándar, <@mth="t">, Chi-cuadrado, <@mth="F">, Gamma, Binomial, Poisson, Exponencial, Weibull, Laplace y Error Generalizado. 

Ver también <@ref="critical">, <@ref="invcdf">, <@ref="urcpval">, <@ref="imhof">. 

# pxnobs stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de panel, y devuelve una serie que contiene el número de observaciones válidas de <@var="y"> en cada período de tiempo (el valor calculado se repite en cada una de las unidades de corte transversal). 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Ten en cuenta que esta función opera en la otra dimensión del panel, diferente a la de la función <@ref="pnobs">. 

# pxsum stats
Resultado: 	serie 
Argumentos:	<@var="y">  (serie)
		<@var="máscara">  (serie, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene estructura de panel, y devuelve una serie en la que cada valor es la suma de <@var="y"> en las distintas unidades de corte transversal de cada período temporal. Las sumas así calculadas se repiten en cada unidad de corte transversal. 

Cuando indicas el segundo argumento (opcional), se van a ignorar aquellas observaciones en las que el valor de <@var="máscara"> sea igual a cero. 

Ten en cuenta que esta función opera en la otra dimensión del panel, diferente a la de la función <@ref="psum">. 

# qform linalg
Resultado: 	matriz 
Argumentos:	<@var="x">  (matriz)
		<@var="A">  (matriz simétrica)

Devuelve una matriz con el resultado de calcular la forma cuadrática <@mth="Y = xAx'">. Si la matriz simétrica <@var="A"> del argumento es de tipo genérico, cuando utilizas esta función en lugar de la típica multiplicación de matrices, garantizas una mayor rapidez y mejor precisión. Sin embargo, en el caso especial de que <@var="A"> sea una matriz identidad, la simple expresión <@lit="x'x"> resulta mucho mejor ca <@lit="qform(x',I(rows(x))">. 

Si <@var="x"> y <@var="A"> no son matrices conformables, o si <@var="A"> no es simétrica, la función devuelve un fallo. 

# qlrpval probdist
Resultado: 	escalar 
Argumentos:	<@var="X2">  (escalar)
		<@var="df">  (entero)
		<@var="p1">  (escalar)
		<@var="p2">  (escalar)

Devuelve un escalar con la probabilidad asociada (<@mth="P">) al valor del estadístico para hacer el contraste LR de Quandt (o sup-Wald) de cambio estructural en un punto desconocido (consulta <@xrf="qlrtest">), según <@bib="Bruce Hansen (1997);hansen97">. 

El primer argumento, <@var="X2">, indica el valor del estadístico de contraste de Wald máximo (en formato chi-cuadrado), y el segundo, <@var="df">, indica sus grados de libertad. El tercer y el cuarto argumentos, representan los puntos de inicio y de fin del rango central de observaciones sobre el que se van a calcular los sucesivos estadísticos de Wald de los contrastes, y debes expresarlos como fracciones decimales en relación al rango total de estimación. Por ejemplo, si quieres adoptar el enfoque estándar de recorte del 15 por ciento, debes establecer <@var="p1"> igual a 0.15 y <@var="p2"> igual a 0.85. 

Ver también <@ref="pvalue">, <@ref="urcpval">. 

# qnorm probdist
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con los cuantiles de una Normal estándar que se corresponden con cada valor del argumento. Si <@var="x"> no está entre 0 y 1, se devuelve <@lit="NA">. Ver también <@ref="cnorm">, <@ref="dnorm">. 

# qrdecomp linalg
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="&R">  (referencia a matriz, o <@lit="null">)

Devuelve una matriz con el cálculo de la descomposición QR de una matriz <@var="X"> de orden <@itl="m">×<@itl="n">; es decir, <@mth="X = QR"> donde <@mth="Q"> es una matriz <@itl="m">×<@itl="n"> ortogonal, y <@mth="R"> es una matriz <@itl="n">×<@itl="n"> triangular superior. La matriz <@mth="Q"> se devuelve directamente, mientras que puedes obtener <@mth="R"> mediante el segundo argumento (opcional). 

Ver también <@ref="eigengen">, <@ref="eigensym">, <@ref="svd">. 

# quadtable stats
Resultado: 	matriz 
Argumentos:	<@var="n">  (entero)
		<@var="tipo">  (entero, opcional)
		<@var="a">  (escalar, opcional)
		<@var="b">  (escalar, opcional)

Devuelve una matriz <@itl="n">×2 para utilizar con la cuadratura Gaussiana (en integración numérica). La primera columna contiene los nodos o abscisas, y la segunda las ponderaciones. 

El primer argumento especifica el número de puntos (filas) que se van a calcular. El segundo argumento codifica el tipo de cuadratura: utiliza 1 para la Gauss–Hermite (la establecida por defecto); 2 para la Gauss–Legendre; o 3 para la Gauss–Laguerre. El sentido de los parámetros <@var="a"> y <@var="b"> (opcionales) depende del <@var="tipo"> seleccionado, como se explica a continuación. 

La cuadratura Gaussiana es un método para aproximar numéricamente la integral definida de alguna función que te interese. Supongamos que la función se representa mediante el producto <@mth="f(x)W(x)">. Los distintos tipos de cuadratura difieren en la especificación de la componente <@mth="W(x)">: en el caso de la Hermite esto es igual a exp(–<@mth="x"><@sup="2">); en el caso de la Laguerre es igual a exp(–<@mth="x">); y en el caso de la Legendre simplemente es <@mth="W(x)"> = 1. 

Para cada especificación de <@mth="W">, puede calcularse un conjunto de nodos (<@mth="x"><@sub="i">) y un conjunto de ponderaciones (<@mth="w"><@sub="i">), de tal modo que la suma desde <@mth="i">=1 hasta <@mth="n"> de <@mth="w"><@sub="i"> <@mth="f">(<@mth="x"><@sub="i">) se va a aproximar a la integral deseada. Para esto se va a utilizar el método de <@bib="Golub y Welsch (1969);golub69">. 

Cuando se selecciona el tipo de Gauss–Legendre, puedes utilizar los argumentos opcionales <@var="a"> y <@var="b"> para controlar los límites inferior y superior de la integración, siendo en este caso los valores por defecto –1 y 1. (En la cuadratura de Hermite, los límites están fijados en menos y más infinito; mientras que en el caso de la cuadratura de Laguerre, están fijados en 0 e infinito.) 

En el caso de Hermite, <@var="a"> y <@var="b"> juegan papeles diferentes: pueden utilizarse para substituir la forma por defecto de <@mth="W">(<@mth="x">) por la distribución Normal de probabilidad con media <@var="a"> y desviación típica <@var="b"> (con la que está estrechamente emparentada). Por ejemplo, si indicas los valores 0 y 1 para estos parámetros, respectivamente, vas a provocar que <@mth="W">(<@mth="x">) sea la función de densidad de probabilidad Normal estándar; lo que es equivalente a multiplicar los nodos por defecto por la raíz cuadrada de dos, y dividir las ponderaciones por la raíz cuadrada de π. 

# quantile stats
Resultado: 	escalar o matriz 
Argumentos:	<@var="y">  (serie o matriz)
		<@var="p">  (escalar entre 0 y 1)

Si <@var="y"> es una serie, devuelve un escalar que representa el cuantil <@var="p"> de la misma. Por ejemplo, cuando <@mth="p"> = 0.5, se devuelve la mediana. 

Si <@var="y"> es una matriz, devuelve un vector fila que contiene los <@var="p"> cuantiles de las diferentes columnas de <@var="y">; es decir, cada una de sus columnas se trata como una serie. 

Además, para una matriz <@var="y"> se admite una forma alternativa del segundo argumento: puedes indicar <@var="p"> como un vector. En ese caso, el valor que se te devuelve es una matriz de orden <@itl="m">×<@itl="n">, en la que <@var="m"> indica el número de elementos de <@var="p"> y <@var="n"> indica el número de columnas de <@var="y">. 

# randgen probdist
Resultado: 	serie 
Argumentos:	<@var="d">  (cadena)
		<@var="p1">  (escalar o serie)
		<@var="p2">  (escalar o serie, condicional)
		<@var="p3">  (escalar, condicional)
Ejemplos: 	<@lit="series x = randgen(u, 0, 100)">
		<@lit="series t14 = randgen(t, 14)">
		<@lit="series y = randgen(B, 0.6, 30)">
		<@lit="series g = randgen(G, 1, 1)">
		<@lit="series P = randgen(P, mu)">

Devuelve una serie calculada con un generador universal de números aleatorios. El argumento <@var="d"> es una cadena de texto (que generalmente está formada por un solo carácter) que permite especificar el tipo de distribución de probabilidad de la que se extraen los números pseudoaleatorios. Los argumentos de <@var="p1"> a <@var="p3"> especifican los parámetros de la distribución escogida, y el número de estos parámetros depende de esa distribución. Para otras distribuciones diferentes a la Beta-Binomial, los parámetros <@var="p1"> y (caso de ser aplicable) <@var="p2"> puedes indicarlos en formato de escalar o de serie. Cuando los utilizas en formato escalar, la serie que resulta procede de distribuciones idénticamente distribuidas. Cuando utilizas series para los argumentos <@var="p1"> o <@var="p2">, la serie resultante procede de distribuciones condicionadas al valor de los parámetros en cada observación. En el caso de la Beta-Binomial, todos los parámetros deben ser escalares. 

A continuación se indican detalles más específicos: el código de texto para cada tipo de distribución se muestra entre paréntesis, seguido de la interpretación del argumento <@var="p1"> y, cuando es aplicable, de la interpretación de <@var="p2"> y <@var="p3">. 

<indent>
• Uniforme (continua) (u o U): mínimo, máximo 
</indent>

<indent>
• Uniforme (discreta) (i): mínimo, máximo 
</indent>

<indent>
• Normal (z, n o N): media, desviación típica 
</indent>

<indent>
• t de Student (t): grados de libertad 
</indent>

<indent>
• Chi-cuadrado (c, x o X): grados de libertad 
</indent>

<indent>
• F de Snedecor (f o F): grados de libertad (num.), grados de libertad (den.) 
</indent>

<indent>
• Gamma (g o G): forma, escala 
</indent>

<indent>
• Binomial (b o B): probabilidad, cantidad de ensayos 
</indent>

<indent>
• Poisson (p o P): media 
</indent>

<indent>
• Exponencial (exp): escala 
</indent>

<indent>
• Weibull (w o W): forma, escala 
</indent>

<indent>
• Laplace (l o L): media, escala 
</indent>

<indent>
• Error Generalizado (E): forma 
</indent>

<indent>
• Beta (beta): forma1, forma2 
</indent>

<indent>
• Beta-Binomial (bb): ensayos, forma1, forma2 
</indent>

Ver también <@ref="normal">, <@ref="uniform">, <@ref="mrandgen">, <@ref="randgen1">. 

# randgen1 probdist
Resultado: 	escalar 
Argumentos:	<@var="d">  (carácter)
		<@var="p1">  (escalar)
		<@var="p2">  (escalar, condicional)
Ejemplos: 	<@lit="scalar x = randgen1(z, 0, 1)">
		<@lit="scalar g = randgen1(g, 3, 2.5)">

Funciona del mismo modo que <@ref="randgen"> excepto por el hecho de que devuelve un escalar en lugar de una serie. 

El primer ejemplo de arriba devuelve un valor extraído de la distribución Normal estándar, mientras que el segundo devuelve un valor extraído de la distribución Gamma con un parámetro de forma igual a 3 y de escala a 2.5. 

Ver también <@ref="mrandgen">. 

# randint probdist
Resultado: 	entero 
Argumentos:	<@var="min">  (entero)
		<@var="max">  (entero)

Devuelve un entero pseudoaleatorio en el intervalo cerrado [<@var="min">, <@var="max">]. Ver también <@ref="randgen">. 

# rank linalg
Resultado: 	entero 
Argumento: 	<@var="X">  (matriz)

Devuelve un entero con el rango de la matriz <@var="X">, calculado numéricamente mediante la descomposición en valores singulares. Ver también <@ref="svd">. 

# ranking stats
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="y">  (serie o vector)

Devuelve una serie o vector con las posiciones jerárquicas de los valores de <@mth="y">. La observación <@mth="i"> tiene una posición en la jerarquía que viene determinada por el número de elementos que son menores que <@mth="y"><@sub="i">, más la mitad del número de elementos que son iguales a <@mth="y"><@sub="i">. (Intuitivamente, puedes imaginarlo como la jerarquía en un torneo de ajedrez, en el que cada vitoria supone conceder un punto al ganador, y cada empate supone conceder medio punto). Se añade un 1 de forma que el número más pequeño para una posición es 1, y no 0. 

Ver también <@ref="sort">, <@ref="sortby">. 

# rcond linalg
Resultado: 	escalar 
Argumento: 	<@var="A">  (matriz cuadradax)

Devuelve un escalar con el número de condición recíproco de la matriz cuadrada <@var="A"> respecto a la norma 1. En muchos casos, este mide de forma más adecuada que el determinante, la sensibilidad de <@var="A"> a las operaciones numéricas tales como la inversión. 

El valor se calcula como el inverso (o recíproco) del resultado de multiplicar la norma 1 de la matriz cuadrada <@var="A">, por la norma 1 de la matriz inversa de <@var="A">. 

Ver también <@ref="det">, <@ref="ldet">, <@ref="onenorm">. 

# readfile strings
Resultado: 	cadena 
Argumentos:	<@var="nombrearchivo">  (cadena)
		<@var="código">  (cadena, opcional)

Si existe un archivo con el nombre del argumento <@var="nombrearchivo">, y puede leerse, la función devuelve una cadena de texto que incluye el contenido de ese archivo; en otro caso muestra un fallo. Si <@var="nombrearchivo"> no indica una especificación de la ruta completa al archivo, se va a buscar en distintas localizaciones “probables”, comenzando por el directorio vigente en ese momento, <@xrf="workdir">. 

Si <@var="nombrearchivo"> comienza con un identificador de un protocolo de internet que sea admisible (<@lit="http://">, <@lit="ftp://"> o <@lit="https://">), se activa una orden a 'libcurl' para que descargue el recurso. Para otras operaciones de descarga más complicadas, consulta también <@ref="curl">. 

Cuando el texto que se quiere leer no está codificado en UTF-8, Gretl va a tratar de volver a codificarlo desde el tipo vigente de codificación local (si este no es UTF-8), o desde ISO-8859-15 en otro caso. Si este sencillo funcionamiento por defecto no cumple con tus necesidades, puedes usar el segundo argumento (opcional) para especificar un tipo de codificación. Por ejemplo, si quieres leer texto que está en el tipo de página de código Microsoft 1251, y este no es tu tipo de código local, deberás indicar <@lit=""cp1251""> como segundo argumento. 

Ejemplos: 

<code>          
        string web_page = readfile("http://gretl.sourceforge.net/")
        print web_page

        string current_settings = readfile("@dotdir/.gretl2rc")
        print current_settings
</code>

Consulta también las funciones <@ref="sscanf"> y <@ref="getline">. 

# regsub strings
Resultado: 	cadena 
Argumentos:	<@var="s">  (cadena)
		<@var="hallada">  (cadena)
		<@var="substit">  (cadena)

Devuelve una cadena de texto con una copia de <@var="s"> en la que todos los casos en los que ocurre el patrón <@var="hallada">, se substituyen por <@var="substit">. Los dos argumentos <@var="hallada"> y <@var="substit"> se interpretan como expresiones regulares de estilo Perl. 

Consulta también la función <@ref="strsub"> para la substitución simple de cadenas de texto. 

# remove data-utils
Resultado: 	entero 
Argumento: 	<@var="nombrearchivo">  (cadena)

Elimina el archivo del argumento <@var="nombrearchivo"> en caso de que este exista, y que el usuario lo pueda modificar. Esta función devuelve un entero igual a 0 en caso de que la operación tenga éxito, y un valor no nulo si el archivo no existe o no se puede eliminar. 

Cuando <@var="fname"> contiene la ruta completa hasta el archivo, Gretl tratará de eliminarlo, y devolverá un fallo si ese archivo no existe o no puede ser eliminado por algún motivo (por ejemplo, por no tener suficientes privilegios para poder hacerlo). Cuando <@var="fname"> no contiene la ruta completa, entonces se asume que el archivo al que se refiere, está en el directorio vigente de trabajo (<@xrf="workdir">). Si el archivo no existe o no puede guardarse, no se va a buscar en ningún otro directorio. 

# replace data-utils
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="x">  (serie o matriz)
		<@var="hallar">  (escalar o vector)
		<@var="substit">  (escalar o vector)

Devuelve un resultado (del tipo de) <@var="x"> cambiando sus elementos que sean iguales al elemento <@mth="i">-ésimo de <@var="hallar"> por el concordante de <@var="substit">. 

Cuando el segundo argumento (<@var="hallar">) es un escalar, el tercer argumento (<@var="substit">) también debe ser un escalar. Cuando ambos son vectores, deben tener el mismo número de elementos. Pero cuando <@var="hallar"> es un vector y <@var="substit"> es un escalar, entonces todas las coincidencias de aquel se substituyen en <@var="x"> por <@var="substit">. 

Ejemplo: 

<code>          
     a = {1,2,3;3,4,5}
     halla = {1,3,4}
     subst = {-1,-8, 0}
     b = replace(a, halla, subst)
     print a b
</code>

produce... 

<code>          
          a (2 x 3)

          1   2   3
          3   4   5

          b (2 x 3)

          -1    2   -8
          -8    0    5
</code>

# resample stats
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="x">  (serie o matriz)
		<@var="tamañobloque">  (entero, opcional)

La descripción inicial de esta función se refiere a los casos con datos de corte transversal o con series temporales; mira más abajo para los casos con datos de panel. 

Devuelve el resultado (del tipo del argumento) que se obtiene haciendo un muestreo por repetición de <@var="x"> con substitución. Si el argumento es una serie, cada valor <@mth="y"><@sub="t"> de la serie que se devuelve, se obtiene de entre todos los valores de <@mth="x"><@sub="t"> que tienen la misma probabilidad. Cuando el argumento es una matriz, cada fila de la matriz que se devuelve, se obtiene de las filas de <@var="x"> que tienen la misma probabilidad. 

El argumento <@var="tamañobloque"> (opcional) representa el tamaño del bloque para hacer el muestreo por repetición moviendo bloques. Cuando se indica este argumento, deberá ser un entero positivo mayor o igual a 2. Como consecuencia, el resultado se va a componer por selección aleatoria con substitución, de entre todas las posibles secuencias contiguas de longitud <@var="tamañobloque"> del argumento. (En caso de que el argumento sea una matriz, esto significa filas contiguas.) Si la longitud de los datos no es un número entero que sea múltiplo del tamaño del bloque, el último bloque seleccionado se trunca para que se ajuste. 

Cuando el argumento <@var="x"> es una serie, y el conjunto de datos tiene formato de panel, no se admite hacer el muestreo por repetición moviendo bloques. La forma básica de hacer este tipo de muestreo está admitida, pero tiene su propia interpretación: se hace el muestreo por repetición de los datos “por individuo”. Supón que tienes un panel en el que se observan 100 individuos a lo largo de 5 períodos. Entonces, la serie que se devuelve también va a estar compuesta por 100 bloques de 5 observaciones: cada bloque va a obtenerse con igual probabilidad de las 100 series temporales individuales, conservándose el orden de las series temporales. 

# round math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado, del tipo del argumento, que lo redondea al entero más próximo. Ten en cuenta que si <@mth="x"> está justo entre dos enteros, el redondeo se hace "alejándose de cero" de modo que, por ejemplo, 2.5 se redondea a 3, pero <@lit="round(-3.5)"> devuelve –4. Esta convención es común en software de hojas de cálculo, pero otro tipo de software puede generar resultados diferentes. Ver también <@ref="ceil">, <@ref="floor">, <@ref="int">. 

# rnameget strings
Resultado: 	cadena o array de cadenas 
Argumentos:	<@var="M">  (matriz)
		<@var="r">  (entero, opcional)

Si indicas el argumento <@var="r">, devuelve una cadena con el nombre de la fila <@var="r"> de la matriz <@var="M">. Si las filas de <@var="M"> no tienen nombre, entonces se devuelve una cadena vacía; y si <@var="r"> está fuera de los límites del número de filas de esta matriz, se muestra un fallo. 

Si no indicas el segundo argumento, devuelve un 'array' de cadenas de texto que contiene los nombres de las filas de <@var="M">, o un 'array' vacío si la matriz no tiene asignados nombres para sus filas. 

Ejemplo: 

<code>          
     matrix A = { 11, 23, 13 ; 54, 15, 46 }
     rnameset(A, "Primera Segunda")
     string name = rnameget(A, 2)
     print name
</code>

Ver también <@ref="rnameset">. 

# rnameset matbuild
Resultado: 	entero 
Argumentos:	<@var="M">  (matriz)
		<@var="S">  (array de cadenas o lista)

Permite añadir nombres a las filas de una matriz <@var="M"> de orden <@itl="m">×<@itl="n">. Cuando el argumento <@var="S"> se refiere a una lista, los nombres se toman de las series de la lista (que deberá tener <@mth="m"> elementos). Cuando <@var="S"> es un 'array' de cadenas de texto, deberá tener <@mth="m"> elementos. Para mantener la compatibilidad con versiones anteriores de Gretl, también puedes utilizar una única cadena de texto como segundo argumento; en este caso esta deberá tener <@mth="m"> subcadenas de texto separadas por espacios. 

Devuelve el valor entero 0 si las filas se nombran con éxito, y un valor no nulo en caso de fallo. Consulta también <@ref="cnameset">. 

Ejemplo: 

<code>          
     matrix M = {1, 2; 2, 1; 4, 1}
     strings S = array(3)
     S[1] = "Fila1"
     S[2] = "Fila2"
     S[3] = "Fila3"
     rnameset(M, S)
     print M
</code>

# rows matshape
Resultado: 	entero 
Argumento: 	<@var="X">  (matriz)

Devuelve un entero con el número de filas de la matriz <@var="X">. Ver también <@ref="cols">, <@ref="mshape">, <@ref="unvech">, <@ref="vec">, <@ref="vech">. 

# sd stats
Resultado: 	escalar o serie 
Argumento: 	<@var="x">  (serie o lista)

Si <@var="x"> es una serie, la función devuelve un escalar con su desviación típica muestral, descartando las observaciones ausentes. 

Si <@var="x"> es una lista, la función devuelve una serie <@mth="y"> tal que <@mth="y"><@sub="t"> representa la desviación típica muestral de los valores de las variables de la lista, en la observación <@mth="t">; o <@lit="NA"> si existe algún valor ausente para la observación <@mth="t">. 

Ver también <@ref="var">. 

# sdc stats
Resultado: 	vector fila 
Argumentos:	<@var="X">  (matriz)
		<@var="df">  (escalar, opcional)

Devuelve un vector fila con las desviaciones típicas de las columnas de la matriz <@var="X">. Si <@var="df"> es positivo, se utiliza como divisor para las varianzas de las columnas; en otro caso, el divisor es igual al número de filas que tiene <@var="X"> (es decir, en ese caso no se aplica la corrección por los grados de libertad). Ver también <@ref="meanc">, <@ref="sumc">. 

# sdiff transforms
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="y">  (serie o lista)

Devuelve un resultado con el cálculo de las diferencias estacionales: <@mth="y(t) - y(t-k)">, donde <@mth="k"> indica la periodicidad del conjunto vigente de datos (consulta <@ref="$pd">). Los valores iniciales se definen como <@lit="NA">. 

Cuando se devuelve una lista, cada variable individual de esta se nombra de forma automática siguiendo el patrón <@lit="sd_"><@var="nombrevar">, en el que <@var="nombrevar"> indica el nombre de la serie original. La parte original del nombre va a truncarse cuando así resulte necesario, e incluso podrá ajustarse para garantizar que sea único dentro del conjunto de nombres que así se vayan a construir. 

Ver también <@ref="diff">, <@ref="ldiff">. 

# seasonals data-utils
Resultado: 	lista 
Argumentos:	<@var="base">  (entero, opcional)
		<@var="centro">  (booleano, opcional)

Se aplica tan solo si el conjunto vigente de datos tiene una estructura de series temporales con periodicidad mayor que 1. Devuelve una lista con variables ficticias que representan cada período o estación, y que se nombran como <@lit="S1">, <@lit="S2">, etc. 

Utiliza el argumento <@var="base"> (opcional) para excluir de la lista a la variable ficticia que representa uno de los períodos. Por ejemplo, si le asignas un valor igual a 1 teniendo un conjunto de datos trimestrales, obtienes una lista que solo tiene las variables ficticias de los trimestres 2, 3 y 4. Si omites este argumento o es igual a 0, se generan variables ficticias para todos los períodos; y si no es cero, deberá ser un entero comprendido entre 1 y la periodicidad de los datos. 

El argumento <@var="centro">, si no es nulo, indica que las variables ficticias van a centrarse; es decir, sus valores van a calcularse restándole las medias en la población. Por ejemplo, con datos trimestrales, las variables ficticias estacionales centradas van a tener valores iguales a –0.25 y 0.75 en vez de 0 y 1. 

# selifc matshape
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz)
		<@var="b">  (vector fila)

Devuelve una matriz tras seleccionar solo aquellas columnas de <@var="A"> en las que el elemento correspondiente de <@var="b"> no es nulo. El <@var="b"> debe ser un vector fila con el mismo número de columnas que <@var="A">. 

Ver también <@ref="selifr">. 

# selifr matshape
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz)
		<@var="b">  (vector columna)

Devuelve una matriz tras seleccionar solo aquellas filas de <@var="A"> en las que el elemento correspondiente de <@var="b"> no es nulo. El <@var="b"> debe ser un vector columna con el mismo número de filas que <@var="A">. 

Ver también <@ref="selifc">, <@ref="trimr">. 

# seq matbuild
Resultado: 	vector fila 
Argumentos:	<@var="a">  (escalar)
		<@var="b">  (escalar)
		<@var="k">  (escalar, opcional)

Con solo dos argumentos, devuelve un vector fila con la secuencia creciente (sumando 1) desde <@var="a"> hasta <@var="b">, si el primer argumento es menor que el segundo; o con la secuencia decreciente (restando 1) si el primer argumento es mayor que el segundo. 

Si indicas el tercer argumento <@var="k"> (opcional), la función va a devolver un vector fila con la secuencia iniciada en <@var="a">, y ampliada (o disminuida en el caso inverso de que <@var="a"> sea mayor que <@var="b">) en <@var="k"> unidades a cada paso. La secuencia finaliza en el mayor valor posible que sea menor o igual a <@var="b"> (o en el menor valor posible que sea mayor o igual a <@var="b">, en el caso inverso). El argumento <@var="k "> debe ser positivo. 

Ver también <@ref="ones">, <@ref="zeros">. 

# setnote data-utils
Resultado: 	entero 
Argumentos:	<@var="b">  (bundle)
		<@var="clave">  (cadena)
		<@var="nota">  (cadena)

Inserta una nota descriptiva para un objeto que se identifica por la <@var="clave">, dentro de un 'bundle' <@var="b">. Se va a mostrar esa nota cuando se utilice la instrucción <@lit="print"> con el 'bundle'. Esta función devuelve un entero igual a 0 en caso de ejecutarse con éxito, y un valor no nulo en caso de fallo (por ejemplo, si no existe ningún objeto <@var="clave"> en el 'bundle' <@var="b">). 

# simann numerical
Resultado: 	escalar 
Argumentos:	<@var="&b">  (referencia a matriz)
		<@var="f">  (llamada a función)
		<@var="maxit">  (entero, opcional)

Pone en práctica el templado simulado, que puede ser útil para mejorar la determinación del punto de partida de un problema de optimización numérica. 

Indicando el primer argumento, se establece el valor inicial de un vector de parámetros; e indicando el segundo argumento, se especifica una llamada a una función que devuelve el valor escalar de la función objetivo a maximizar. El tercer argumento (opcional) especifica el número máximo de iteraciones (que por defecto es de 1024). Cuando se completa con éxito, la función <@lit="simann"> devuelve un escalar con el valor final de la función objetivo a maximizar, y <@var="b"> contiene el vector de parámetros asociado. 

Para obtener más detalles y un ejemplo, consulta <@pdf="El manual de gretl#chap:numerical"> (Capítulo 34). Ver también <@ref="BFGSmax">, <@ref="NRmax">. 

# sin math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el seno de <@var="x">. Ver también <@ref="cos">, <@ref="tan">, <@ref="atan">. 

# sinh math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con el seno hiperbólico de <@var="x">. 

Ver también <@ref="asinh">, <@ref="cosh">, <@ref="tanh">. 

# skewness stats
Resultado: 	escalar 
Argumento: 	<@var="x">  (serie)

Devuelve un escalar con el valor del coeficiente de asimetría de la serie <@var="x">, descartando cualquier observación ausente. 

# sleep data-utils
Resultado: 	escalar 
Argumento: 	<@var="ns">  (entero)

Esta función no tiene ningún uso directo en Econometría, pero puede ser de utilidad para comprobar métodos de computación en paralelo. Simplemente provoca que se “duerma” la línea de cómputo vigente (es decir, que se pare) durante <@var="ns"> segundos. Al “despertar”, la función devuelve el escalar 0. 

# smplspan data-utils
Resultado: 	escalar 
Argumentos:	<@var="obsinicio">  (cadena)
		<@var="obsfin">  (cadena)
		<@var="pd">  (entero)

Devuelve el número de observaciones que hay contando desde <@var="obsinicio"> hasta <@var="obsfin"> (ambas incluidas), para datos de series temporales que tienen una frecuencia <@var="pd">. 

Deberías indicar los dos primeros argumentos en el formato que prefiere Gretl para datos de tipo anual, trimestral o mensual (por ejemplo, <@lit="1970">, <@lit="1970:1"> o <@lit="1970:01"> para cada una de esas frecuencias, respectivamente) o como fechas en el formato ISO 8601, <@lit="YYYY-MM-DD">. 

El argumento <@var="pd"> debe ser bien 1, 4 o 12 (datos anuales, trimestrales o mensuales), bien una de las frecuencias diarias (5, 6, 7), o bien 52 (semanal). Si <@var="pd"> es igual a 1, 4 o 12, entonces las fechas ISO 8601 se aceptan para los dos primeros argumentos, si indican el inicio del período en cuestión. Por ejemplo, <@lit="2015-04-01"> se admite en lugar de <@lit="2015:2"> para representar el segundo trimestre de 2015. 

Si ya tienes un conjunto de datos con frecuencia <@var="pd"> preparado, y con un rango suficiente de observaciones, entonces puedes imitar fácilmente el comportamiento de esta función utilizando la función <@ref="obsnum">. La ventaja de <@lit="smplspan"> consiste en que puedes calcular el número de observaciones sin necesidad de tener preparado un conjunto apropiado de datos (ni ningún conjunto de datos). A continuación, un ejemplo: 

<code>          
     scalar T = smplspan("2010-01-01", "2015-12-31", 5)
     nulldata T
     setobs 5 2010-01-01
</code>

Esto genera 

<code>          
     ? scalar T = smplspan("2010-01-01", "2015-12-31", 5)
     Se ha generado el escalar T = 1565
     ? nulldata T
     Periodicidad: 1, máx. obs: 1565
     Rango de observaciones: 1 a 1565
     ? setobs 5 2010-01-01
     Rango completo de datos: 2010-01-01 - 2015-12-31 (n = 1565)
</code>

Después de lo anterior, puedes tener confianza en que la última observación del conjunto de datos que se va a generar por medio de <@xrf="nulldata"> va a ser <@lit="2015-12-31">. Ten en cuenta que el número 1565 sería más bien complicado calcularlo de otro modo. 

# sort matshape
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (serie o vector)

Devuelve un resultado del mismo tipo que <@var="x"> con sus valores ordenados de forma ascendente, descartando las observaciones con valores ausentes cuando <@mth="x"> es una serie. Ver también <@ref="dsort">, <@ref="values">. Para matrices, en especial, consulta <@ref="msortby">. 

# sortby stats
Resultado: 	serie 
Argumentos:	<@var="y1">  (serie)
		<@var="y2">  (serie)

Devuelve una serie que contiene los elementos de <@var="y2"> ordenados de acuerdo con los valores crecientes del primer argumento <@var="y1">. Ver también <@ref="sort">, <@ref="ranking">. 

# sprintf strings
Resultado: 	cadena 
Argumentos:	<@var="formato">  (cadena)
		... (mira más abajo)

Devuelve una cadena de texto (“string”) que se construye representando los valores de los argumentos (indicados por los puntos de arriba) que acompañan a la instrucción, bajo el control del argumento <@var="formato">. Tiene la intención de darte gran flexibilidad para crear cadenas de texto. Utiliza <@var="formato"> para indicar el modo preciso en el que quieres que se presenten los argumentos. 

En general, el argumento <@var="formato"> debe ser una expresión que se corresponda con una cadena de texto, pero en la mayoría de los casos solo va a ser una cadena de texto literal (una secuencia alfanumérica entrecomillada). Algunas secuencias de caracteres de formato tienen un significado especial: aquellas que comienzan con el símbolo (%) se interpretan como “comodines” para los elementos que contiene la lista de argumentos. Además, caracteres especiales (por ejemplo, el de nueva línea) se representan por medio de una combinación de símbolos que comienza con una barra diagonal inversa. 

Por ejemplo, el código de abajo... 

<code>          
     scalar x = sqrt(5)
     string claim = sprintf("sqrt(%d) es (aproximadamente) %6.4f.\n", 5, x)
     print claim
</code>

va a producir... 

<code>          
     sqrt(5) es (aproximadamente) 2.2361.
</code>

La expresión <@lit="%d"> en la cadena de formato, indica que se quiere un número entero en ese preciso lugar de la salida que se va a presentar, y dado que esa es la expresión con el símbolo “por ciento” que está más a la izquierda, se empareja con el primer argumento, es decir 5. La segunda secuencia especial es <@lit="%6.4f">, y representa un valor con 6 dígitos de ancho como mínimo, y con 4 dígitos después del separador decimal. El número de esas secuencias debe coincidir con la cantidad de argumentos que acompañan a la cadena de texto para el formato. 

Consulta la página de ayuda de la instrucción <@xrf="printf"> para obtener más detalles en relación con la sintaxis que puedes utilizar en las cadenas de texto para el formato. 

# sqrt math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado, del mismo tipo que <@var="x">, con la raíz cuadrada positiva de este. Genera <@lit="NA"> para valores negativos de este. 

Observa que, si el argumento es una matriz, se realiza la operación para cada elemento. Para la “raíz cuadrada matricial” consulta <@ref="cholesky">. 

# square transforms
Resultado: 	lista 
Argumentos:	<@var="L">  (lista)
		<@var="productos-cruz">  (booleano, opcional)

Devuelve una lista que contiene los cuadrados de las variables de la lista <@var="L">, con sus elementos nombrados de acuerdo con el siguiente patrón :<@lit="sq_"><@var="nombrevariable">. Cuando indicas el segundo argumento (opcional) y tiene un valor no nulo, la lista también va a incluir los productos cruzados de los elementos de la lista <@var="L">, que se nombrarán de acuerdo con el formato del patrón <@var="var1"><@lit="_"><@var="var2">. De ser necesario, el nombre de las series de los argumentos va a truncarse e incluso ajustarse el nombre del resultado final, para evitar la duplicación de nombres en la lista que se devuelve. 

# sscanf strings
Resultado: 	entero 
Argumentos:	<@var="origen">  (cadena)
		<@var="formato">  (cadena)
		... (mira más abajo)

Lee valores indicados por el argumento <@var="origen"> bajo el control del argumento <@var="formato">, y asigna estos valores a uno o más de los argumentos siguientes, indicados por los puntos de arriba. Devuelve un entero con el número de valores que se asignan. Esta función es una versión simplificada de la función <@lit="sscanf"> del lenguaje C de programación. 

Como argumento <@var="origen"> puedes usar una cadena de texto literal entrecomillada, o bien el nombre de una cadena de texto que hayas definido previamente. El argumento <@var="formato"> se indica de modo similar a la cadena del argumento “formato” en <@xrf="printf"> (mira más abajo); en esta última función, <@var="elementos"> debe ser una lista de variables definidas antes, separadas por comas y que son los objetivos de la conversión de <@var="origen">. (Para los acostumbrados a C: podéis fijar previamente los nombres de las variables numéricas con <@lit="&">, pero es necesario.) 

El texto literal en el argumento <@var="formato"> se compara con <@var="origen">. Los elementos que especifican la conversión comienzan con el carácter <@lit="%">, y las conversiones que están admitidas incluyen: <@lit="%f">, <@lit="%g"> o <@lit="%lf"> para números de punto flotante; <@lit="%d"> para números enteros; <@lit="%s"> para cadenas de texto; y <@lit="%m"> para matrices. Puedes insertar un entero positivo después del símbolo de porcentaje, que establece el número máximo de caracteres que se van a leer para la conversión indicada (o el número máximo de filas en caso de la conversión de una matriz). Como forma alternativa, puedes insertar un carácter literal de asterisco, <@lit="*">, después del símbolo de porcentaje para eliminar la conversión (saltándose así cualquier carácter que, de otro modo, podría haberse convertido al tipo indicado). Por ejemplo, la expresión <@lit="%3d"> convierte los siguientes 3 caracteres de <@var="origen"> en un entero, en caso de que sea posible; y la expresión <@lit="%*g"> permite saltarse tantos caracteres de <@var="origen"> como los que podrían convertirse en un número de punto flotante simple. 

La conversión para matrices funciona así: el escáner lee una línea del argumento, y cuenta la cantidad de campos numéricos (separados por espacios o por tabulaciones). De este modo se define el número de columnas de la matriz. Por defecto, el proceso de lectura continúa entonces con tantas líneas (filas) como contengan el mismo número de columnas, pero el número máximo de filas que se van a leer puede limitarse tal como se describe arriba. 

Además de la conversión <@lit="%s"> para cadenas de texto, también está disponible una versión simplificada del formato C <@lit="%"><@var="N"><@lit="["><@var="chars"><@lit="]">. En este formato, <@var="N"> representa el número máximo de caracteres que se van a leer, y <@var="chars"> expresa un conjunto de caracteres que sean admisibles, expresados entre corchetes: el proceso de lectura finaliza cuando se alcanza <@var="N">, o cuando se encuentra un carácter que no está en <@var="chars">. Puedes cambiar el funcionamiento de <@var="chars">indicando el circunflejo <@lit="^"> como primer carácter; en ese caso, el proceso de lectura finaliza cuando se encuentra un carácter que está indicado en el conjunto. (A diferencia de lo que sucede en C, el guion no juega ningún papel especial en el conjunto <@var="chars">.) 

Si la cadena de texto del origen no coincide (exactamente) con el formato, el número de conversiones puede quedarse corta respecto al número de argumentos indicados. Esto no es por si mismo un fallo en lo que atañe a Gretl. Así y todo, podrías querer comprobar el número de conversiones que se completaron; esto se indica en el valor que se devuelve. 

A continuación tienes varios ejemplos: 

<code>          
     scalar x
     scalar y
     sscanf("123456", "%3d%3d", x, y)

     S = sprintf("1 2 3 4\n5 6 7 8")
     S
     matrix m
     sscanf(S, "%m", m)
     print m
</code>

# sst stats
Resultado: 	escalar 
Argumento: 	<@var="y">  (serie)

Devuelve un escalar con la suma de los cuadrados de las desviaciones respecto a la media (SCT), de las observaciones no ausentes de la serie <@var="y">. Ver también <@ref="var">. 

# stringify strings
Resultado: 	entero 
Argumentos:	<@var="y">  (serie)
		<@var="S">  (array de cadenas)

Proporciona un modo de definir valores de cadena de texto para la serie <@var="y">. Para que esto funcione, deben cumplirse dos condiciones: la serie objetivo no debe tener otra cosa que no sean valores enteros positivos (ninguno de ellos menor que 1); y el 'array' <@var="S"> debe tener por lo menos <@mth="n"> elementos, siendo <@mth="n"> el mayor valor de <@var="y">. Además, cada elemento de <@var="S"> debe tener un formato UTF-8 válido. Ver también <@ref="strvals">. 

El valor que devuelve esta función es cero en caso de completarse con éxito, o un código de fallo positivo en caso de fallar. 

# strlen strings
Resultado: 	entero 
Argumento: 	<@var="s">  (cadena)

Devuelve un número entero con la cantidad de caracteres que tiene la cadena de texto <@var="s">. Ten en cuenta que eso no es necesariamente igual al número de bytes, si algunos caracteres están fuera del intervalo de impresión ASCII. 

Ejemplo: 

<code>          
        string s = "Regresión"
        scalar number = strlen(s)
        print number
</code>

# strncmp strings
Resultado: 	entero 
Argumentos:	<@var="s1">  (cadena)
		<@var="s2">  (cadena)
		<@var="n">  (entero, opcional)

Compara las dos cadenas de texto de los argumentos, y devuelve un entero que es menor, igual o mayor que 0 cuando <@var="s1"> es (respectivamente) menor, igual o mayor que <@var="s2">, hasta los <@var="n"> primeros caracteres. Cuando se omite <@var="n">, la comparación continúa hasta donde resulte posible. 

Ten en cuenta que, si solo quieres comprobar si dos cadenas de texto son iguales, puedes hacerlo sin necesidad de utilizar esta función, como con la indicación <@lit="if (s1 == s2)...">. 

# strsplit strings
Resultado: 	cadena o array de cadenas 
Argumentos:	<@var="s">  (cadena)
		<@var="sep">  (cadena, opcional)
		<@var="i">  (entero, opcional)

En su funcionamiento básico, con un único argumento, devuelve el 'array' de cadenas de texto que resulta al separar el contenido de <@var="s"> conforme a los espacios vacíos que tiene (es decir, conforme a cualquier combinación de los caracteres de espacio, tabulación y/o línea nueva). 

Puedes utilizar el segundo argumento (opcional) para especificar el separador que se usa para separar <@var="s">. Por ejemplo... 

<code>          
     string Cesta = "Plátano,Manzana,Yaca,Naranja"
     strings S = strsplit(Cesta,",")
</code>

va a separar el primer argumento de la función en un 'array' de cuatro cadenas de texto, usando la coma como elemento separador. 

Las secuencias de barra diagonal izquierda para escapar, indicadas mediante “<@lit="\n">” y “<@lit="\t">”, se considera que representan una línea nueva y una tabulación cuando se indican en el argumento opcional <@var="sep">. Si quieres incluir una barra diagonal izquierda literal como carácter separador, debes duplicarla como en “<@lit="\\">”. Ejemplo: 

<code>          
     string s = "c:\fiddle\sticks"
     strings S = strsplit(s, "\\")
</code>

Independientemente del separador, a los elementos del 'array' que se devuelve, se les recorta cualquier espacio en blanco al principio o al final. En consecuencia, si <@var="sep"> contiene caracteres que no son espacios en blanco, entonces se le quita cualquier espacio al principio o al final. 

Cuando indicas un valor entero mayor que cero como tercer argumento, el valor que se devuelve es una única cadena de texto; concretamente, el elemento <@var="i"> (en base 1) del 'array' que se generaría de otro modo sin ese tercer argumento. Cuando <@var="i"> sea menor que 1, se produce un fallo; pero cuando <@var="i"> excede el número de elementos implicados, se devuelve una cadena de texto vacía. 

# strstr strings
Resultado: 	cadena 
Argumentos:	<@var="s1">  (cadena)
		<@var="s2">  (cadena)

Busca en <@var="s1"> la cadena <@var="s2">. En caso de encontrar la cadena de texto, devuelve otra cadena con una copia de la parte de <@var="s1"> que comienza con <@var="s2">; en caso contrario, devuelve una cadena de texto vacía. 

Ejemplo: 

<code>          
          string s1 = "Gretl es un programa de Econometría"
          string s2 = strstr(s1, "un")
          print s2
</code>

Si únicamente quieres descubrir si <@var="s1"> contiene a <@var="s2"> (prueba booleana), consulta <@ref="instring">. 

# strstrip strings
Resultado: 	cadena 
Argumento: 	<@var="s">  (cadena)

Devuelve una cadena de texto con una copia de <@var="s"> en la que se eliminaron los espacios en blanco del inicio y del final. 

Ejemplo: 

<code>          
          string s1 = "    Mucho espacio en blanco.  "
          string s2 = strstrip(s1)
          print s1 s2
</code>

# strsub strings
Resultado: 	cadena 
Argumentos:	<@var="s">  (cadena)
		<@var="hallada">  (cadena)
		<@var="substit">  (cadena)

Devuelve una cadena de texto con una copia de <@var="s"> en la que se substituyó toda la cadena <@var="hallada"> por <@var="substit">. Consulta también <@ref="regsub"> para otras substituciones más complejas mediante expresiones regulares. 

Ejemplo: 

<code>          
          string s1 =  "Hola, Gretl!"
          string s2 = strsub(s1, "Gretl", "Hansl")
          print s2
</code>

# strvals strings
Resultado: 	array de cadenas 
Argumento: 	<@var="y">  (serie)

Cuando la serie <@var="y"> se compone de cadenas de texto que expresan valores, esta función devuelve un 'array' que contiene todos esos valores, ordenados numéricamente comenzando por el 1. Cuando <@var="y"> no se compone de cadenas de texto que expresan valores, se devuelve un 'array' de cadenas de texto vacías. Ver también <@ref="stringify">. 

# substr strings
Resultado: 	cadena 
Argumentos:	<@var="s">  (cadena)
		<@var="inicio">  (entero)
		<@var="fin">  (entero)

Devuelve una subcadena del argumento <@var="s">, empezando en el carácter indicado por el entero positivo de <@var="inicio">, y finalizando en el indicado por el de <@var="fin">, ambos incluidos. 

Por ejemplo, el código de abajo 

<code>          
          string s1 = "Hola, Gretl!"
          string s2 = substr(s1, 7, 11)
          string s3 = substr("Hola, Gretl!", 7, 11)
          print s2
          print s3
</code>

proporciona: 

<code>          
    ? print s2
    Gretl
    ? print s3
    Gretl
</code>

Debes darte cuenta de que, en algunos casos, podrías estar deseando intercambiar claridad por concisión, y utilizar operadores de reducción e incremento, como en 

<code>          
          string s1 = "Hola, Gretl!"
          string s2 = s1[7:11]
          string s3 = s1 + 6
          print s2
          print s3
</code>

lo que te proporcionaría 

<code>          
    ? print s2
    Gretl
    ? print s3
    Gretl!
</code>

# sum stats
Resultado: 	escalar o serie 
Argumento: 	<@var="x">  (serie, matriz o lista)

Cuando <@var="x"> es una serie, devuelve un escalar con el resultado de sumar las observaciones no ausentes del argumento <@var="x">. Consulta también <@ref="sumall">. 

Cuando <@var="x"> es una matriz, devuelve un escalar con el resultado de sumar los elementos de la matriz. 

Cuando <@var="x"> es una lista de variables, la función devuelve una serie <@mth="y">, en la que cada valor <@mth="y"><@sub="t"> indica la suma de los valores de las variables de la lista en la observación <@mth="t">, o <@lit="NA"> si alguno de esos valores está ausente en <@mth="t">. 

# sumall stats
Resultado: 	escalar 
Argumento: 	<@var="x">  (serie)

Devuelve un escalar con el resultado de sumar las observaciones de la serie <@var="x"> en la muestra seleccionada, o <@lit="NA"> si existe algún valor ausente. Utiliza <@ref="sum"> si quieres obtener la suma descartando los valores ausentes. 

# sumc stats
Resultado: 	vector fila 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector fila con la suma de las columnas de <@var="X">. Ver también <@ref="meanc">, <@ref="sumr">. 

# sumr stats
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna con la suma de las filas de <@var="X">. Ver también <@ref="meanr">, <@ref="sumc">. 

# svd linalg
Resultado: 	vector fila 
Argumentos:	<@var="X">  (matriz)
		<@var="&U">  (referencia a matriz, o <@lit="null">)
		<@var="&V">  (referencia a matriz, o <@lit="null">)

Devuelve un vector fila con el resultado de descomponer la matriz <@var="X"> en valores singulares. 

Los valores singulares se devuelven en un vector fila. Puedes obtener el vector singular izquierdo <@mth="U"> y/o el derecho <@mth="V"> indicando valores no nulos en los argumentos 2 y 3, respectivamente. Para cualquier matriz <@lit="A">, el código... 

<code>          
     s = svd(A, &U, &V)
     B = (U .* s) * V
</code>

... debiera de proporcionar una matriz <@lit="B"> idéntica a <@lit="A"> (excepto pequeñas diferencias debida a la precisión de cálculo). 

Ver también <@ref="eigengen">, <@ref="eigensym">, <@ref="qrdecomp">. 

# svm stats
Resultado: 	serie 
Argumentos:	<@var="L">  (lista)
		<@var="bparms">  (bundle)
		<@var="bmod">  (referenia a bundle, opcional)
		<@var="bprob">  (referenia a bundle, opcional)

Esta función te permite el entrenamiento (y la predicción basada en él) de un modelo MSV (Máquina de Soporte Vectorial o SVM), utilizando la librería LIBSVM como soporte. El argumento de tipo lista <@var="L"> deberá incluir la variable dependiente seguida de las variables independientes; y el 'bundle' <@var="bparms"> se utiliza para pasarle opciones al mecanismo MSV. El valor que se devuelve es una serie que contiene las predicciones del modelo. Puedes utilizar los dos argumentos opcionales puntero-bundle para recuperar información adicional después del entrenamiento y/o predicción. 

Para obtener más detalles, consulta la documentación PDF para <@mnu="gretlSVM">. 

# tan math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con la tangente de <@var="x">. Ver también <@ref="atan">, <@ref="cos">, <@ref="sin">. 

# tanh math
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar, serie o matriz)

Devuelve un resultado (del tipo del argumento) con la tangente hiperbólica de <@var="x">. 

Ver también <@ref="atanh">, <@ref="cosh">, <@ref="sinh">. 

# toepsolv linalg
Resultado: 	vector columna 
Argumentos:	<@var="c">  (vector)
		<@var="r">  (vector)
		<@var="b">  (vector)

Devuelve un vector columna con la solución de un sistema Toeplitz de ecuaciones lineales, es decir <@mth="Tx = b"> donde <@mth="T "> es una matriz cuadrada cuyo elemento <@mth="T"><@sub="i,j"> es igual a <@mth="c"><@sub="i-j"> cuando <@mth="i>=j">, e igual a <@mth="r"><@sub="j-i"> cuando <@mth="i<=j">. Ten en cuenta que los primeros elementos de los dos vectores <@mth="c"> y <@mth="r"> deben ser iguales, pues en caso contrario se devuelve un fallo. Cuando se completa con éxito, la ejecución de esta función permite obtener el vector <@mth="x">. 

El algoritmo que se utiliza aquí aprovecha la especial estructura de la matriz <@mth="T">, lo que lo hace mucho más eficiente que otros algoritmos no especializados, particularmente para problemas muy largos. Advertencia: En algunos casos, la función podría sugerir falsamente un fallo en la singularidad de la matriz <@mth="T"> cuando realmente no es singular; de cualquier modo, este problema no podrá surgir cuando la matriz <@mth="T"> sea definida positiva. 

# tolower strings
Resultado: 	cadena 
Argumento: 	<@var="s">  (cadena)

Devuelve una cadena de texto que es una copia de <@var="s">, en la que todas las letras en mayúsculas se convirtieron en minúsculas. 

Ejemplos: 

<code>          
        string s1 = "Hola, Gretl!"
        string s2 = tolower(s1)
        print s2

        string s3 = tolower("Hola, Gretl!")
        print s3
</code>

# toupper strings
Resultado: 	cadena 
Argumento: 	<@var="s">  (cadena)

Devuelve una cadena de texto que es una copia de <@var="s">, en la que todas las letras en minúsculas se convirtieron en mayúsculas. 

Ejemplos: 

<code>          
        string s1 = "Hola, Gretl!"
        string s2 = toupper(s1)
        print s2

        string s3 = toupper("Hola, Gretl!")
        print s3
</code>

# tr linalg
Resultado: 	escalar 
Argumento: 	<@var="A">  (matriz cuadradax)

Devuelve un escalar con la traza de la matriz cuadrada <@var="A">, es decir, la suma de los elementos de su diagonal. Ver también <@ref="diag">. 

# transp linalg
Resultado: 	matriz 
Argumento: 	<@var="X">  (matriz)

Devuelve una matriz que es la traspuesta de <@var="X">. Aviso: Esta función se utiliza raramente. Para trasponer una matriz, en general puedes usar simplemente el operador para trasposición: <@lit="X'">. 

# trimr matshape
Resultado: 	matriz 
Argumentos:	<@var="X">  (matriz)
		<@var="tsup">  (entero)
		<@var="tinf">  (entero)

Devuelve una matriz que es una copia de la matriz <@var="X"> en la que se eliminaron las <@var="tsup"> filas superiores y las <@var="tinf"> filas inferiores. Los dos últimos argumentos no deben ser negativos, y su suma debe ser menor que el total de filas de <@var="X">. 

Ver también <@ref="selifr">. 

# typeof data-utils
Resultado: 	entero 
Argumento: 	<@var="nombre">  (cadena)

Devuelve un código de tipo numérico cuando <@var="nombre"> es una cadena de texto que identifica un objeto que ya está definido: 1 para un escalar, 2 para una serie, 3 para una matriz, 4 para una cadena de texto, 5 para un 'bundle', 6 para un 'array' y 7 para una lista; en otro caso devuelve 0. Para obtener la cadena de texto que concuerda con el valor que se devuelve, puedes usar la función <@ref="typestr">. 

También puedes utilizar esta función para obtener qué tipo de elemento es uno de los que componen un 'bundle' o un 'array'. Por ejemplo... 

<code>          
     matrices M = array(1)
     eval typestr(typeof(M))
     eval typestr(typeof(M[1]))
</code>

... en el que el primer resultado de la función <@lit="eval"> es un “array”, y el segundo es una “matriz”. 

# typestr data-utils
Resultado: 	cadena 
Argumento: 	<@var="codigotipo">  (entero)

Devuelve una cadena de texto con el nombre del tipo de dato de Gretl que se corresponde con el argumento <@var="codigotipo">. Puedes utilizarlo junto con las funciones <@ref="typeof"> e <@ref="inbundle">. La cadena de texto que se devuelve puede ser una de las siguientes: “scalar”, “series”, “matrix”, “string”, “bundle”, “array”, “list”, o “null”. 

# uniform probdist
Resultado: 	serie 
Argumentos:	<@var="a">  (escalar)
		<@var="b">  (escalar)

Devuelve una serie que se genera con una variable pseudoaleatoria Uniforme que toma valores dentro del intervalo (<@var=" a">, <@var="b">) o, si no indicas esos argumentos, en el intervalo (0,1). El algoritmo que se utiliza por defecto es el “SIMD-oriented Fast Mersenne Twister” desarrollado por <@bib="Saito y Matsumoto (2008);saito_matsumoto08">. 

Ver también <@ref="randgen">, <@ref="normal">, <@ref="mnormal">, <@ref="muniform">. 

# uniq stats
Resultado: 	vector columna 
Argumento: 	<@var="x">  (serie o vector)

Devuelve un vector que contiene los distintos elementos del argumento <@var="x"> sin ningún orden especial, sino en el que están en <@var="x">. Consulta <@ref="values"> para la variante de esta función que devuelve los valores ordenados. 

# unvech matbuild
Resultado: 	matriz cuadradax 
Argumento: 	<@var="v">  (vector)

Devuelve la matriz simétrica de orden <@itl="n">×<@itl="n"> que se obtiene reordenando los elementos del vector <@mth="v"> en forma de matriz triangular inferior, y copiando los de las posiciones simétricas. El número de elementos de <@mth="v"> debe ser un entero triangular, o sea, un número <@mth="k"> tal que exista un entero <@mth="n"> que cumpla la siguiente propiedad: <@mth="k = n(n+1)/2">. Esta función es la inversa de <@ref="vech">. 

Ver también <@ref="mshape">, <@ref="vech">. 

# upper matbuild
Resultado: 	matriz cuadradax 
Argumento: 	<@var="A">  (matriz cuadradax)

Devuelve una matriz triangular superior de orden <@itl="n">×<@itl="n">. Los elementos de la diagonal y los de arriba de esta, son iguales a los elementos que se corresponden en <@var="A">; los demás son iguales a cero. 

Ver también <@ref="lower">. 

# urcpval probdist
Resultado: 	escalar 
Argumentos:	<@var="tau">  (escalar)
		<@var="n">  (entero)
		<@var="niv">  (entero)
		<@var="itv">  (entero)

Devuelve un escalar con la probabilidad asociada (<@mth="P">) al valor del estadístico para hacer el contraste de raíces unitarias de Dickey-Fuller o el contraste de cointegración de Engle–Granger, de acuerdo con <@bib="James MacKinnon (1996);mackinnon96">. 

Los argumentos se expresan de este modo: <@var="tau"> indica el valor del estadístico de contraste que corresponda; <@var="n"> señala el número de observaciones (o 0 si lo que quieres es un resultado asintótico);<@var="niv"> denota el número de variables potencialmente cointegradas, si compruebas la cointegración (o 1 si haces un contraste univariante de raíces unitarias); e <@var="itv"> es un código que especifica el tipo modelo (1 = sin constante, 2 = con constante, 3 = con constante más tendencia lineal, 4 = con constante más tendencia cuadrada). 

Ten en cuenta que debes darle un valor de 0 a <@var="n"> para obtener un resultado asintótico, si la regresión auxiliar para el contraste es “aumentada” con retardos de la variable dependiente. 

Ver también <@ref="pvalue">, <@ref="qlrpval">. 

# values stats
Resultado: 	vector columna 
Argumento: 	<@var="x">  (serie o vector)

Devuelve un vector que contiene los distintos elementos del argumento <@var="x"> ordenados de forma ascendente. Si quieres descartar la parte decimal antes de aplicar esta función, utiliza la expresión <@lit="values(int(x))">. 

Ver también <@ref="uniq">, <@ref="dsort">, <@ref="sort">. 

# var stats
Resultado: 	escalar o serie 
Argumento: 	<@var="x">  (serie o lista)

Cuando <@var="x"> es una serie, devuelve un escalar con su varianza muestral, descartando cualquier observación ausente. 

Cuando <@var="x"> es una lista, devuelve una serie <@mth="y"> en la que cada valor <@mth="y"><@sub="t"> indica la varianza muestral de los valores de las variables de la lista en la observación <@mth="t">, o <@lit="NA"> si alguno de esos valores está ausente en <@mth="t">. 

En cada uno de esos casos, la suma de los cuadrados de las desviaciones con respecto a la media se divide por (<@mth="n"> – 1) cuando <@mth="n"> > 1. En otro caso, se indica que la varianza es igual a cero si <@mth="n"> = 1, o es igual a <@lit="NA"> si <@mth="n"> = 0. 

Ver también <@ref="sd">. 

# varname strings
Resultado: 	cadena 
Argumento: 	<@var="v">  (entero o lista)

Cuando se indica un número entero como argumento, la función devuelve una cadena de texto con el nombre de la variable que tiene un número ID igual a <@var="v">, o genera un fallo si esa variable no existe. 

Cuando se indica una lista como argumento, devuelve una cadena de texto que contiene los nombres de las variables de la lista, separados por comas. Si indicas una lista que está vacía, se devuelve una cadena de texto vacía. En su lugar, puedes utilizar <@ref="varnames"> para obtener un 'array' de cadenas de texto . 

Ejemplo: 

<code>          
        open broiler.gdt
        string s = varname(7)
        print s
</code>

# varnames strings
Resultado: 	array de cadenas 
Argumento: 	<@var="L">  (lista)

Devuelve un 'array' de cadenas de texto que contiene los nombres de las variables de la lista <@var="L">. Si la lista que indicas está vacía, se devuelve un 'array' vacío. 

Ejemplo: 

<code>          
        open keane.gdt
        list L = year wage status
        strings S = varnames(L)
        eval S[1]
        eval S[2]
        eval S[3]
</code>

# varnum data-utils
Resultado: 	entero 
Argumento: 	<@var="nombrevar">  (cadena)

Devuelve un número entero con el código ID de la variable que tiene el nombre del argumento <@var="nombrevar">, o NA si esa variable no existe. 

# varsimul linalg
Resultado: 	matriz 
Argumentos:	<@var="A">  (matriz)
		<@var="U">  (matriz)
		<@var="y0">  (matriz)

Devuelve una matriz al simular un VAR de orden <@mth="p"> y <@mth="n"> variables, es decir <@mth="y(t) = A1 y(t-1) + ... + Ap y(t-p) + u(t)."> La matriz <@var="A"> de coeficientes se forma agrupando horizontalmente las matrices <@mth="A"><@sub="i">; y es de orden <@itl="n">×<@itl="np">, con una fila por cada ecuación. Esta se corresponde con las primeras <@mth="n"> filas de la matriz <@lit="$compan"> que proporcionan las instrucciones <@lit="var"> y <@lit="vecm"> de Gretl. 

Los vectores <@mth="u_t"> están incluidos (como filas) en la matriz <@var="U"> (<@itl="T">×<@itl="n">). Los valores iniciales están en <@var="y0"> (<@itl="p">×<@itl="n">). 

Cuando el VAR contiene algún término determinista y/o regresores exógenos, puedes manejarlos incorporándolos a la matriz <@var="U">: en este caso cada fila de <@var="U"> pasa a ser entonces <@mth="u(t) = B'x(t) + e(t)."> 

La matriz que resulta tiene <@mth="T"> + <@mth="p"> filas y <@mth="n"> columnas; contiene los <@mth="p"> valores iniciales de las variables endógenas, además de <@mth="T"> valores simulados. 

Ver también <@ref="$compan">, <@xrf="var">, <@xrf="vecm">. 

# vec matbuild
Resultado: 	vector columna 
Argumento: 	<@var="X">  (matriz)

Devuelve un vector columna, apilando las columnas de <@var="X">. Ver también <@ref="mshape">, <@ref="unvech">, <@ref="vech">. 

# vech matbuild
Resultado: 	vector columna 
Argumento: 	<@var="A">  (matriz cuadradax)

Devuelve un vector columna con los elementos de <@var="A"> que están en su diagonal principal y por arriba de ella. Normalmente esta función se utiliza con matrices simétricas; en este caso, esa operación puede revertirse a través de la función <@ref="unvech">. Ver también <@ref="vec">. 

# weekday calendar
Resultado: 	mismo tipo que introducido 
Argumentos:	<@var="año">  (escalar o serie)
		<@var="mes">  (escalar o serie)
		<@var="día">  (escalar o serie)

Devuelve el día de la semana (domingo = 0, lunes = 1, etc.) de la fecha especificada por los tres argumentos, o <@lit="NA"> si la fecha no es correcta. Ten en cuenta que los tres argumentos deben ser del mismo tipo; o sea, deben ser todos de tipo escalar (entero) o todos de tipo serie. 

# wmean stats
Resultado: 	serie 
Argumentos:	<@var="Y">  (lista)
		<@var="W">  (lista)

Devuelve una serie <@mth="y"> calculada de forma que cada <@mth="y"><@sub="t"> indica la media ponderada de los valores (en la observación <@mth="t">) de las variables presentes en la lista <@var="Y">, con las respectivas ponderaciones señaladas por los valores de las variables que forman la lista <@var="W"> en cada <@mth="t">. Las ponderaciones pueden así variar con el tiempo. Las listas <@var="Y"> y <@var="W"> de variables deben tener el mismo tamaño, y las ponderaciones deben ser no negativas. 

Ver también <@ref="wsd">, <@ref="wvar">. 

# wsd stats
Resultado: 	serie 
Argumentos:	<@var="Y">  (lista)
		<@var="W">  (lista)

Devuelve una serie <@mth="y"> calculada de forma que cada <@mth="y"><@sub="t"> indica la desviación típica ponderada muestral, de los valores (en la observación <@mth="t">) de las variables presentes en la lista <@var="Y">, con las respectivas ponderaciones señaladas por los valores de las variables de la lista <@var="W"> en cada <@mth="t">. Las ponderaciones pueden así variar con el tiempo. Las listas <@var="Y"> y <@var="W"> de variables deben tener el mismo tamaño, y las ponderaciones deben ser no negativas. 

Ver también <@ref="wmean">, <@ref="wvar">. 

# wvar stats
Resultado: 	serie 
Argumentos:	<@var="X">  (lista)
		<@var="W">  (lista)

Devuelve una serie <@mth="y"> calculada de forma que cada <@mth="y"><@sub="t"> indica la varianza ponderada muestral, de los valores (en la observación <@mth="t">) de las variables presentes en la lista <@var="Y">, con las respectivas ponderaciones señaladas por los valores de las variables que forman la lista <@var="W"> en cada <@mth="t">. Las ponderaciones pueden así variar con el tiempo. Las listas <@var="Y"> y <@var="W"> de variables deben tener el mismo tamaño, y las ponderaciones deben ser no negativas. 

Ver también <@ref="wmean">, <@ref="wsd">. 

# xmax math
Resultado: 	escalar 
Argumentos:	<@var="x">  (escalar)
		<@var="y">  (escalar)

Devuelve un escalar con el mayor valor que resulta de comparar <@var="x"> e <@var="y">. Si alguno de los valores está ausente, se devuelve <@lit="NA">. 

Ver también <@ref="xmin">, <@ref="max">, <@ref="min">. 

# xmin math
Resultado: 	escalar 
Argumentos:	<@var="x">  (escalar)
		<@var="y">  (escalar)

Devuelve un escalar con el menor valor que resulta de comparar <@var="x"> e <@var="y">. Si alguno de los valores está ausente, se devuelve <@lit="NA">. 

Ver también <@ref="xmax">, <@ref="max">, <@ref="min">. 

# xmlget data-utils
Resultado: 	cadena 
Argumentos:	<@var="buf">  (cadena)
		<@var="ruta">  (cadena o array de cadenas)

El argumento <@var="buf"> debe ser un buffer XML, tal como puede recuperarse de un lugar web adecuado mediante la función <@ref="curl"> (o leerse de un archivo mediante la función <@ref="readfile">); y el argumento <@var="ruta"> debe ser una especificación XPath sencilla o un 'array' de ellas. 

Esta función devuelve una cadena de texto que representa los datos encontrados en el buffer XML en la ruta especificada. Si hay múltiples nodos que coincidan con la expresión de la ruta, las unidades de datos se presentan una por cada línea de la cadena que se devuelve. Cuando indicas un 'array' de rutas como segundo argumento, la cadena que se devuelve tiene la forma de un buffer separado con comas, cuya columna <@mth="i"> contiene las coincidencias de la ruta <@mth="i">. En este caso, si una cadena obtenida del buffer XML contiene algún espacio o coma, se entrecomilla. 

Por defecto, se muestra un fallo si <@var="ruta"> no coincide en el buffer XML; pero este comportamiento se modifica si indicas el tercer argumento (opcional) pues, en este caso, el argumento recupera un recuento de las coincidencias, devolviéndose una cadena vacía si no hay ninguna. Llamada de ejemplo: 

<code>          
     ngot = 0
     ret = xmlget(xbuf, "//some/thing", &ngot)
</code>

Ahora bien, todavía se va a mostrar un fallo en caso de hacer una solicitud mal configurada. 

Puedes encontrar una buena introducción al uso y a la sintaxis de XPath en <@url="https://www.w3schools.com/xml/xml_xpath.asp">. El programa de soporte (back-end) para <@lit="xmlget"> lo proporciona el módulo xpath de libxml2, que admite XPath 1.0 pero no XPath 2.0. 

Ver también <@ref="jsonget">, <@ref="readfile">. 

# zeromiss data-utils
Resultado: 	mismo tipo que introducido 
Argumento: 	<@var="x">  (escalar o serie)

Devuelve un resultado (del tipo del argumento) cambiando los ceros por <@lit="NA">s. Si <@var="x"> es una serie, cambia cada elemento. Ver también <@ref="missing">, <@ref="misszero">, <@ref="ok">. 

# zeros matbuild
Resultado: 	matriz 
Argumentos:	<@var="r">  (entero)
		<@var="c">  (entero)

Devuelve una matriz nula con <@mth="r"> filas y <@mth="c"> columnas. Ver también <@ref="ones">, <@ref="seq">. 

