/* candidatearea.c generated by valac 0.40.8, the Vala compiler
 * generated from candidatearea.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <pango/pango.h>


#define TYPE_CANDIDATE_AREA (candidate_area_get_type ())
#define CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_AREA, CandidateArea))
#define CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_AREA, CandidateAreaClass))
#define IS_CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_AREA))
#define IS_CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_AREA))
#define CANDIDATE_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_AREA, CandidateAreaClass))

typedef struct _CandidateArea CandidateArea;
typedef struct _CandidateAreaClass CandidateAreaClass;
typedef struct _CandidateAreaPrivate CandidateAreaPrivate;

#define TYPE_THEMED_RGBA (themed_rgba_get_type ())
#define THEMED_RGBA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMED_RGBA, ThemedRGBA))
#define THEMED_RGBA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMED_RGBA, ThemedRGBAClass))
#define IS_THEMED_RGBA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMED_RGBA))
#define IS_THEMED_RGBA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMED_RGBA))
#define THEMED_RGBA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMED_RGBA, ThemedRGBAClass))

typedef struct _ThemedRGBA ThemedRGBA;
typedef struct _ThemedRGBAClass ThemedRGBAClass;
enum  {
	CANDIDATE_AREA_0_PROPERTY,
	CANDIDATE_AREA_NUM_PROPERTIES
};
static GParamSpec* candidate_area_properties[CANDIDATE_AREA_NUM_PROPERTIES];
#define _themed_rgba_unref0(var) ((var == NULL) ? NULL : (var = (themed_rgba_unref (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VSEPARATOR (vseparator_get_type ())
#define VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VSEPARATOR, VSeparator))
#define VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VSEPARATOR, VSeparatorClass))
#define IS_VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VSEPARATOR))
#define IS_VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VSEPARATOR))
#define VSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VSEPARATOR, VSeparatorClass))

typedef struct _VSeparator VSeparator;
typedef struct _VSeparatorClass VSeparatorClass;

#define TYPE_HSEPARATOR (hseparator_get_type ())
#define HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSEPARATOR, HSeparator))
#define HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSEPARATOR, HSeparatorClass))
#define IS_HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSEPARATOR))
#define IS_HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSEPARATOR))
#define HSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSEPARATOR, HSeparatorClass))

typedef struct _HSeparator HSeparator;
typedef struct _HSeparatorClass HSeparatorClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
enum  {
	CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL,
	CANDIDATE_AREA_PAGE_UP_SIGNAL,
	CANDIDATE_AREA_PAGE_DOWN_SIGNAL,
	CANDIDATE_AREA_CURSOR_UP_SIGNAL,
	CANDIDATE_AREA_CURSOR_DOWN_SIGNAL,
	CANDIDATE_AREA_NUM_SIGNALS
};
static guint candidate_area_signals[CANDIDATE_AREA_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CandidateArea {
	GtkBox parent_instance;
	CandidateAreaPrivate * priv;
};

struct _CandidateAreaClass {
	GtkBoxClass parent_class;
};

struct _CandidateAreaPrivate {
	gboolean m_vertical;
	GtkLabel** m_labels;
	gint m_labels_length1;
	gint _m_labels_size_;
	GtkLabel** m_candidates;
	gint m_candidates_length1;
	gint _m_candidates_size_;
	GtkWidget** m_widgets;
	gint m_widgets_length1;
	gint _m_widgets_size_;
	IBusText** m_ibus_candidates;
	gint m_ibus_candidates_length1;
	gint _m_ibus_candidates_size_;
	guint m_focus_candidate;
	gboolean m_show_cursor;
	ThemedRGBA* m_rgba;
};

struct _Block1Data {
	int _ref_count_;
	CandidateArea* self;
	gint i;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint index;
};

struct _Block3Data {
	int _ref_count_;
	CandidateArea* self;
	gint index;
};


static gpointer candidate_area_parent_class = NULL;

GType candidate_area_get_type (void) G_GNUC_CONST;
gpointer themed_rgba_ref (gpointer instance);
void themed_rgba_unref (gpointer instance);
GParamSpec* param_spec_themed_rgba (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_themed_rgba (GValue* value,
                            gpointer v_object);
void value_take_themed_rgba (GValue* value,
                             gpointer v_object);
gpointer value_get_themed_rgba (const GValue* value);
GType themed_rgba_get_type (void) G_GNUC_CONST;
#define CANDIDATE_AREA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANDIDATE_AREA, CandidateAreaPrivate))
CandidateArea* candidate_area_new (gboolean vertical);
CandidateArea* candidate_area_construct (GType object_type,
                                         gboolean vertical);
void candidate_area_set_vertical (CandidateArea* self,
                                  gboolean vertical,
                                  gboolean force);
ThemedRGBA* themed_rgba_new (GtkWidget* widget);
ThemedRGBA* themed_rgba_construct (GType object_type,
                                   GtkWidget* widget);
gboolean candidate_area_candidate_scrolled (CandidateArea* self,
                                            GdkEventScroll* event);
gboolean candidate_area_get_vertical (CandidateArea* self);
static void candidate_area_recreate_ui (CandidateArea* self);
void candidate_area_set_candidates (CandidateArea* self,
                                    IBusText** candidates,
                                    int candidates_length1,
                                    guint focus_candidate,
                                    gboolean show_cursor);
void candidate_area_set_labels (CandidateArea* self,
                                IBusText** labels,
                                int labels_length1);
static IBusText** _vala_array_dup1 (IBusText** self,
                             int length);
PangoAttrList* get_pango_attr_list_from_ibus_text (IBusText* text);
GdkRGBA* themed_rgba_get_selected_fg (ThemedRGBA* self);
GdkRGBA* themed_rgba_get_selected_bg (ThemedRGBA* self);
static void __lambda5_ (CandidateArea* self,
                 GtkButton* b);
static void ___lambda5__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda6_ (CandidateArea* self,
                 GtkButton* b);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static gboolean _candidate_area_candidate_scrolled_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                     GdkEventScroll* event,
                                                                     gpointer self);
VSeparator* vseparator_new (void);
VSeparator* vseparator_construct (GType object_type);
GType vseparator_get_type (void) G_GNUC_CONST;
HSeparator* hseparator_new (void);
HSeparator* hseparator_construct (GType object_type);
GType hseparator_get_type (void) G_GNUC_CONST;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _vala_array_add1 (GtkLabel** * array,
                       int* length,
                       int* size,
                       GtkLabel* value);
static void _vala_array_add2 (GtkLabel** * array,
                       int* length,
                       int* size,
                       GtkLabel* value);
static gboolean ______lambda7_ (Block2Data* _data2_,
                         GtkWidget* w,
                         GdkEventButton* e);
static gboolean _______lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
static void _vala_array_add3 (GtkWidget** * array,
                       int* length,
                       int* size,
                       GtkWidget* value);
static gboolean ______lambda8_ (Block2Data* _data2_,
                         GtkWidget* w,
                         GdkEventButton* e);
static gboolean _______lambda8__gtk_widget_button_press_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
static void _vala_array_add4 (GtkWidget** * array,
                       int* length,
                       int* size,
                       GtkWidget* value);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _vala_array_add5 (GtkLabel** * array,
                       int* length,
                       int* size,
                       GtkLabel* value);
static void _vala_array_add6 (GtkLabel** * array,
                       int* length,
                       int* size,
                       GtkLabel* value);
static gboolean ______lambda9_ (Block3Data* _data3_,
                         GtkWidget* w,
                         GdkEventButton* e);
static gboolean _______lambda9__gtk_widget_button_press_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
static void _vala_array_add7 (GtkWidget** * array,
                       int* length,
                       int* size,
                       GtkWidget* value);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void candidate_area_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const gchar* CANDIDATE_AREA_LABELS[16] = {"1.", "2.", "3.", "4.", "5.", "6.", "7.", "8.", "9.", "0.", "a.", "b.", "c.", "d.", "e.", "f."};
static const gchar* CANDIDATE_AREA_PREV_PAGE_ICONS[2] = {"go-previous", "go-up"};
static const gchar* CANDIDATE_AREA_NEXT_PAGE_ICONS[2] = {"go-next", "go-down"};

CandidateArea*
candidate_area_construct (GType object_type,
                          gboolean vertical)
{
	CandidateArea * self = NULL;
	ThemedRGBA* _tmp0_;
	self = (CandidateArea*) g_object_new (object_type, NULL);
	candidate_area_set_vertical (self, vertical, TRUE);
	_tmp0_ = themed_rgba_new ((GtkWidget*) self);
	_themed_rgba_unref0 (self->priv->m_rgba);
	self->priv->m_rgba = _tmp0_;
	return self;
}


CandidateArea*
candidate_area_new (gboolean vertical)
{
	return candidate_area_construct (TYPE_CANDIDATE_AREA, vertical);
}


gboolean
candidate_area_candidate_scrolled (CandidateArea* self,
                                   GdkEventScroll* event)
{
	gboolean result = FALSE;
	GdkScrollDirection _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->direction;
	switch (_tmp0_) {
		case GDK_SCROLL_UP:
		{
			g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CURSOR_UP_SIGNAL], 0);
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CURSOR_DOWN_SIGNAL], 0);
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}


gboolean
candidate_area_get_vertical (CandidateArea* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_vertical;
	result = _tmp0_;
	return result;
}


void
candidate_area_set_vertical (CandidateArea* self,
                             gboolean vertical,
                             gboolean force)
{
	gboolean _tmp0_ = FALSE;
	GtkOrientation _tmp2_ = 0;
	IBusText** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	if (!force) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->m_vertical;
		_tmp0_ = _tmp1_ == vertical;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->m_vertical = vertical;
	if (vertical) {
		_tmp2_ = GTK_ORIENTATION_VERTICAL;
	} else {
		_tmp2_ = GTK_ORIENTATION_HORIZONTAL;
	}
	gtk_orientable_set_orientation ((GtkOrientable*) self, _tmp2_);
	candidate_area_recreate_ui (self);
	_tmp3_ = self->priv->m_ibus_candidates;
	_tmp3__length1 = self->priv->m_ibus_candidates_length1;
	if (_tmp3__length1 > 0) {
		IBusText** _tmp4_;
		gint _tmp4__length1;
		IBusText** _tmp5_;
		gint _tmp5__length1;
		guint _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->m_ibus_candidates;
		_tmp4__length1 = self->priv->m_ibus_candidates_length1;
		self->priv->m_ibus_candidates = NULL;
		self->priv->m_ibus_candidates_length1 = 0;
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		_tmp6_ = self->priv->m_focus_candidate;
		_tmp7_ = self->priv->m_show_cursor;
		candidate_area_set_candidates (self, _tmp5_, _tmp4__length1, _tmp6_, _tmp7_);
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_object_unref), NULL);
		gtk_widget_show_all ((GtkWidget*) self);
	}
}


void
candidate_area_set_labels (CandidateArea* self,
                           IBusText** labels,
                           int labels_length1)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_;
			GtkLabel** _tmp3_;
			gint _tmp3__length1;
			gint _tmp4_;
			GtkLabel* _tmp5_;
			gint _tmp6_;
			IBusText* _tmp7_;
			const gchar* _tmp8_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			if (!(_tmp2_ < MIN (16, labels_length1))) {
				break;
			}
			_tmp3_ = self->priv->m_labels;
			_tmp3__length1 = self->priv->m_labels_length1;
			_tmp4_ = i;
			_tmp5_ = _tmp3_[_tmp4_];
			_tmp6_ = i;
			_tmp7_ = labels[_tmp6_];
			_tmp8_ = ibus_text_get_text (_tmp7_);
			gtk_label_set_text (_tmp5_, _tmp8_);
		}
	}
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			gint _tmp11_;
			GtkLabel** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			GtkLabel* _tmp14_;
			gint _tmp15_;
			const gchar* _tmp16_;
			if (!_tmp9_) {
				gint _tmp10_;
				_tmp10_ = i;
				i = _tmp10_ + 1;
			}
			_tmp9_ = FALSE;
			_tmp11_ = i;
			if (!(_tmp11_ < 16)) {
				break;
			}
			_tmp12_ = self->priv->m_labels;
			_tmp12__length1 = self->priv->m_labels_length1;
			_tmp13_ = i;
			_tmp14_ = _tmp12_[_tmp13_];
			_tmp15_ = i;
			_tmp16_ = CANDIDATE_AREA_LABELS[_tmp15_];
			gtk_label_set_text (_tmp14_, _tmp16_);
		}
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static IBusText**
_vala_array_dup1 (IBusText** self,
                  int length)
{
	IBusText** result;
	int i;
	result = g_new0 (IBusText*, length + 1);
	for (i = 0; i < length; i++) {
		IBusText* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void
candidate_area_set_candidates (CandidateArea* self,
                               IBusText** candidates,
                               int candidates_length1,
                               guint focus_candidate,
                               gboolean show_cursor)
{
	IBusText** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (candidates != NULL) ? _vala_array_dup1 (candidates, candidates_length1) : ((gpointer) candidates);
	_tmp0__length1 = candidates_length1;
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = _tmp0_;
	self->priv->m_ibus_candidates_length1 = _tmp0__length1;
	self->priv->_m_ibus_candidates_size_ = self->priv->m_ibus_candidates_length1;
	self->priv->m_focus_candidate = focus_candidate;
	self->priv->m_show_cursor = show_cursor;
	_vala_assert (candidates_length1 < 16, "candidates.length < 16");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				GtkLabel* label = NULL;
				GtkLabel** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				GtkLabel* _tmp6_;
				GtkLabel* _tmp7_;
				gboolean visible = FALSE;
				gint _tmp8_;
				gboolean _tmp68_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < 16)) {
					break;
				}
				_tmp4_ = self->priv->m_candidates;
				_tmp4__length1 = self->priv->m_candidates_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _g_object_ref0 (_tmp6_);
				label = _tmp7_;
				visible = FALSE;
				_tmp8_ = i;
				if (_tmp8_ < candidates_length1) {
					PangoAttrList* attrs = NULL;
					gint _tmp9_;
					IBusText* _tmp10_;
					PangoAttrList* _tmp11_;
					gboolean _tmp12_ = FALSE;
					gint _tmp13_;
					GtkLabel* _tmp58_;
					gint _tmp59_;
					IBusText* _tmp60_;
					const gchar* _tmp61_;
					GtkLabel* _tmp62_;
					PangoAttrList* _tmp63_;
					_tmp9_ = i;
					_tmp10_ = candidates[_tmp9_];
					_tmp11_ = get_pango_attr_list_from_ibus_text (_tmp10_);
					attrs = _tmp11_;
					_tmp13_ = i;
					if (((guint) _tmp13_) == focus_candidate) {
						_tmp12_ = show_cursor;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						PangoAttribute* pango_attr = NULL;
						ThemedRGBA* _tmp14_;
						GdkRGBA* _tmp15_;
						GdkRGBA* _tmp16_;
						gdouble _tmp17_;
						ThemedRGBA* _tmp18_;
						GdkRGBA* _tmp19_;
						GdkRGBA* _tmp20_;
						gdouble _tmp21_;
						ThemedRGBA* _tmp22_;
						GdkRGBA* _tmp23_;
						GdkRGBA* _tmp24_;
						gdouble _tmp25_;
						PangoAttribute* _tmp26_;
						PangoAttribute* _tmp27_;
						PangoAttribute* _tmp28_;
						gint _tmp29_;
						IBusText* _tmp30_;
						const gchar* _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						PangoAttrList* _tmp34_;
						PangoAttribute* _tmp35_;
						ThemedRGBA* _tmp36_;
						GdkRGBA* _tmp37_;
						GdkRGBA* _tmp38_;
						gdouble _tmp39_;
						ThemedRGBA* _tmp40_;
						GdkRGBA* _tmp41_;
						GdkRGBA* _tmp42_;
						gdouble _tmp43_;
						ThemedRGBA* _tmp44_;
						GdkRGBA* _tmp45_;
						GdkRGBA* _tmp46_;
						gdouble _tmp47_;
						PangoAttribute* _tmp48_;
						PangoAttribute* _tmp49_;
						PangoAttribute* _tmp50_;
						gint _tmp51_;
						IBusText* _tmp52_;
						const gchar* _tmp53_;
						gint _tmp54_;
						gint _tmp55_;
						PangoAttrList* _tmp56_;
						PangoAttribute* _tmp57_;
						_tmp14_ = self->priv->m_rgba;
						_tmp15_ = themed_rgba_get_selected_fg (_tmp14_);
						_tmp16_ = _tmp15_;
						_tmp17_ = (*_tmp16_).red;
						_tmp18_ = self->priv->m_rgba;
						_tmp19_ = themed_rgba_get_selected_fg (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = (*_tmp20_).green;
						_tmp22_ = self->priv->m_rgba;
						_tmp23_ = themed_rgba_get_selected_fg (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = (*_tmp24_).blue;
						_tmp26_ = pango_attr_foreground_new ((guint16) (_tmp17_ * G_MAXUINT16), (guint16) (_tmp21_ * G_MAXUINT16), (guint16) (_tmp25_ * G_MAXUINT16));
						pango_attr = _tmp26_;
						_tmp27_ = pango_attr;
						_tmp27_->start_index = (guint) 0;
						_tmp28_ = pango_attr;
						_tmp29_ = i;
						_tmp30_ = candidates[_tmp29_];
						_tmp31_ = ibus_text_get_text (_tmp30_);
						_tmp32_ = strlen (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp28_->end_index = (guint) _tmp33_;
						_tmp34_ = attrs;
						_tmp35_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp34_, _tmp35_);
						_tmp36_ = self->priv->m_rgba;
						_tmp37_ = themed_rgba_get_selected_bg (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = (*_tmp38_).red;
						_tmp40_ = self->priv->m_rgba;
						_tmp41_ = themed_rgba_get_selected_bg (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = (*_tmp42_).green;
						_tmp44_ = self->priv->m_rgba;
						_tmp45_ = themed_rgba_get_selected_bg (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = (*_tmp46_).blue;
						_tmp48_ = pango_attr_background_new ((guint16) (_tmp39_ * G_MAXUINT16), (guint16) (_tmp43_ * G_MAXUINT16), (guint16) (_tmp47_ * G_MAXUINT16));
						_pango_attribute_destroy0 (pango_attr);
						pango_attr = _tmp48_;
						_tmp49_ = pango_attr;
						_tmp49_->start_index = (guint) 0;
						_tmp50_ = pango_attr;
						_tmp51_ = i;
						_tmp52_ = candidates[_tmp51_];
						_tmp53_ = ibus_text_get_text (_tmp52_);
						_tmp54_ = strlen (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp50_->end_index = (guint) _tmp55_;
						_tmp56_ = attrs;
						_tmp57_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp56_, _tmp57_);
						_pango_attribute_destroy0 (pango_attr);
					}
					_tmp58_ = label;
					_tmp59_ = i;
					_tmp60_ = candidates[_tmp59_];
					_tmp61_ = ibus_text_get_text (_tmp60_);
					gtk_label_set_text (_tmp58_, _tmp61_);
					_tmp62_ = label;
					_tmp63_ = attrs;
					gtk_label_set_attributes (_tmp62_, _tmp63_);
					visible = TRUE;
					_pango_attr_list_unref0 (attrs);
				} else {
					GtkLabel* _tmp64_;
					GtkLabel* _tmp65_;
					PangoAttrList* _tmp66_;
					PangoAttrList* _tmp67_;
					_tmp64_ = label;
					gtk_label_set_text (_tmp64_, "");
					_tmp65_ = label;
					_tmp66_ = pango_attr_list_new ();
					_tmp67_ = _tmp66_;
					gtk_label_set_attributes (_tmp65_, _tmp67_);
					_pango_attr_list_unref0 (_tmp67_);
				}
				_tmp68_ = self->priv->m_vertical;
				if (_tmp68_) {
					GtkWidget** _tmp69_;
					gint _tmp69__length1;
					gint _tmp70_;
					GtkWidget* _tmp71_;
					gboolean _tmp72_;
					GtkWidget** _tmp73_;
					gint _tmp73__length1;
					gint _tmp74_;
					GtkWidget* _tmp75_;
					gboolean _tmp76_;
					_tmp69_ = self->priv->m_widgets;
					_tmp69__length1 = self->priv->m_widgets_length1;
					_tmp70_ = i;
					_tmp71_ = _tmp69_[_tmp70_ * 2];
					_tmp72_ = visible;
					gtk_widget_set_visible (_tmp71_, _tmp72_);
					_tmp73_ = self->priv->m_widgets;
					_tmp73__length1 = self->priv->m_widgets_length1;
					_tmp74_ = i;
					_tmp75_ = _tmp73_[(_tmp74_ * 2) + 1];
					_tmp76_ = visible;
					gtk_widget_set_visible (_tmp75_, _tmp76_);
				} else {
					GtkWidget** _tmp77_;
					gint _tmp77__length1;
					gint _tmp78_;
					GtkWidget* _tmp79_;
					gboolean _tmp80_;
					_tmp77_ = self->priv->m_widgets;
					_tmp77__length1 = self->priv->m_widgets_length1;
					_tmp78_ = i;
					_tmp79_ = _tmp77_[_tmp78_];
					_tmp80_ = visible;
					gtk_widget_set_visible (_tmp79_, _tmp80_);
				}
				_g_object_unref0 (label);
			}
		}
	}
}


static void
__lambda5_ (CandidateArea* self,
            GtkButton* b)
{
	g_return_if_fail (b != NULL);
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_PAGE_UP_SIGNAL], 0);
}


static void
___lambda5__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda5_ ((CandidateArea*) self, _sender);
}


static void
__lambda6_ (CandidateArea* self,
            GtkButton* b)
{
	g_return_if_fail (b != NULL);
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_PAGE_DOWN_SIGNAL], 0);
}


static void
___lambda6__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda6_ ((CandidateArea*) self, _sender);
}


static gboolean
_candidate_area_candidate_scrolled_gtk_widget_scroll_event (GtkWidget* _sender,
                                                            GdkEventScroll* event,
                                                            gpointer self)
{
	gboolean result;
	result = candidate_area_candidate_scrolled ((CandidateArea*) self, event);
	return result;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CandidateArea* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CandidateArea* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void
_vala_array_add1 (GtkLabel** * array,
                  int* length,
                  int* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add2 (GtkLabel** * array,
                  int* length,
                  int* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean
______lambda7_ (Block2Data* _data2_,
                GtkWidget* w,
                GdkEventButton* e)
{
	Block1Data* _data1_;
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	GdkModifierType _tmp2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data1_->i;
	_tmp1_ = e->button;
	_tmp2_ = e->state;
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL], 0, (guint) _tmp0_, _tmp1_, (guint) _tmp2_);
	result = TRUE;
	return result;
}


static gboolean
_______lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = ______lambda7_ (self, _sender, event);
	return result;
}


static void
_vala_array_add3 (GtkWidget** * array,
                  int* length,
                  int* size,
                  GtkWidget* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean
______lambda8_ (Block2Data* _data2_,
                GtkWidget* w,
                GdkEventButton* e)
{
	Block1Data* _data1_;
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	GdkModifierType _tmp2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data2_->index;
	_tmp1_ = e->button;
	_tmp2_ = e->state;
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL], 0, (guint) _tmp0_, _tmp1_, (guint) _tmp2_);
	result = TRUE;
	return result;
}


static gboolean
_______lambda8__gtk_widget_button_press_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = ______lambda8_ (self, _sender, event);
	return result;
}


static void
_vala_array_add4 (GtkWidget** * array,
                  int* length,
                  int* size,
                  GtkWidget* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CandidateArea* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void
_vala_array_add5 (GtkLabel** * array,
                  int* length,
                  int* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add6 (GtkLabel** * array,
                  int* length,
                  int* size,
                  GtkLabel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean
______lambda9_ (Block3Data* _data3_,
                GtkWidget* w,
                GdkEventButton* e)
{
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	GdkModifierType _tmp2_;
	self = _data3_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data3_->index;
	_tmp1_ = e->button;
	_tmp2_ = e->state;
	g_signal_emit (self, candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL], 0, (guint) _tmp0_, _tmp1_, (guint) _tmp2_);
	result = TRUE;
	return result;
}


static gboolean
_______lambda9__gtk_widget_button_press_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = ______lambda9_ (self, _sender, event);
	return result;
}


static void
_vala_array_add7 (GtkWidget** * array,
                  int* length,
                  int* size,
                  GtkWidget* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
candidate_area_recreate_ui (CandidateArea* self)
{
	GList* _tmp0_;
	GtkButton* prev_button = NULL;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkOrientation _tmp6_;
	GtkOrientation _tmp7_;
	const gchar* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* next_button = NULL;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkOrientation _tmp15_;
	GtkOrientation _tmp16_;
	const gchar* _tmp17_;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	GtkButton* _tmp20_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* w = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp1_;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = w;
				gtk_widget_destroy (_tmp2_);
				_g_object_unref0 (w);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	prev_button = _tmp3_;
	_tmp4_ = prev_button;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) ___lambda5__gtk_button_clicked, self, 0);
	_tmp5_ = prev_button;
	_tmp6_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = CANDIDATE_AREA_PREV_PAGE_ICONS[_tmp7_];
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp8_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	gtk_button_set_image (_tmp5_, (GtkWidget*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = prev_button;
	gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
	_tmp12_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp12_);
	next_button = _tmp12_;
	_tmp13_ = next_button;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda6__gtk_button_clicked, self, 0);
	_tmp14_ = next_button;
	_tmp15_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = CANDIDATE_AREA_NEXT_PAGE_ICONS[_tmp16_];
	_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp17_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_button_set_image (_tmp14_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = next_button;
	gtk_button_set_relief (_tmp20_, GTK_RELIEF_NONE);
	_tmp21_ = self->priv->m_vertical;
	if (_tmp21_) {
		GtkEventBox* container_ebox = NULL;
		GtkEventBox* _tmp22_;
		GtkEventBox* _tmp23_;
		GtkEventBox* _tmp24_;
		GtkEventBox* _tmp25_;
		GtkBox* vbox = NULL;
		GtkBox* _tmp26_;
		GtkEventBox* _tmp27_;
		GtkBox* _tmp28_;
		GtkBox* candidates_hbox = NULL;
		GtkBox* _tmp29_;
		GtkBox* _tmp30_;
		GtkBox* _tmp31_;
		GtkBox* labels_vbox = NULL;
		GtkBox* _tmp32_;
		GtkBox* _tmp33_;
		GtkBox* candidates_vbox = NULL;
		GtkBox* _tmp34_;
		GtkBox* _tmp35_;
		GtkBox* _tmp36_;
		GtkBox* _tmp37_;
		GtkBox* _tmp38_;
		VSeparator* _tmp39_;
		VSeparator* _tmp40_;
		GtkBox* _tmp41_;
		GtkBox* _tmp42_;
		GtkBox* _tmp43_;
		HSeparator* _tmp44_;
		HSeparator* _tmp45_;
		GtkBox* buttons_hbox = NULL;
		GtkBox* _tmp46_;
		GtkLabel* state_label = NULL;
		GtkLabel* _tmp47_;
		GtkLabel* _tmp48_;
		GtkBox* _tmp49_;
		GtkLabel* _tmp50_;
		GtkBox* _tmp51_;
		GtkButton* _tmp52_;
		GtkBox* _tmp53_;
		GtkButton* _tmp54_;
		GtkBox* _tmp55_;
		GtkBox* _tmp56_;
		GtkLabel** _tmp57_;
		GtkLabel** _tmp58_;
		GtkWidget** _tmp59_;
		_tmp22_ = (GtkEventBox*) gtk_event_box_new ();
		g_object_ref_sink (_tmp22_);
		container_ebox = _tmp22_;
		_tmp23_ = container_ebox;
		gtk_widget_add_events ((GtkWidget*) _tmp23_, (gint) GDK_SCROLL_MASK);
		_tmp24_ = container_ebox;
		g_signal_connect_object ((GtkWidget*) _tmp24_, "scroll-event", (GCallback) _candidate_area_candidate_scrolled_gtk_widget_scroll_event, self, 0);
		_tmp25_ = container_ebox;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
		_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp26_);
		vbox = _tmp26_;
		_tmp27_ = container_ebox;
		_tmp28_ = vbox;
		gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
		_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp29_);
		candidates_hbox = _tmp29_;
		_tmp30_ = vbox;
		_tmp31_ = candidates_hbox;
		gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
		_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp32_);
		labels_vbox = _tmp32_;
		_tmp33_ = labels_vbox;
		gtk_box_set_homogeneous (_tmp33_, TRUE);
		_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp34_);
		candidates_vbox = _tmp34_;
		_tmp35_ = candidates_vbox;
		gtk_box_set_homogeneous (_tmp35_, TRUE);
		_tmp36_ = candidates_hbox;
		_tmp37_ = labels_vbox;
		gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 4);
		_tmp38_ = candidates_hbox;
		_tmp39_ = vseparator_new ();
		g_object_ref_sink (_tmp39_);
		_tmp40_ = _tmp39_;
		gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp40_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp40_);
		_tmp41_ = candidates_hbox;
		_tmp42_ = candidates_vbox;
		gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, TRUE, TRUE, (guint) 4);
		_tmp43_ = vbox;
		_tmp44_ = hseparator_new ();
		g_object_ref_sink (_tmp44_);
		_tmp45_ = _tmp44_;
		gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp45_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp45_);
		_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp46_);
		buttons_hbox = _tmp46_;
		_tmp47_ = (GtkLabel*) gtk_label_new (NULL);
		g_object_ref_sink (_tmp47_);
		state_label = _tmp47_;
		_tmp48_ = state_label;
		gtk_widget_set_size_request ((GtkWidget*) _tmp48_, 20, -1);
		_tmp49_ = buttons_hbox;
		_tmp50_ = state_label;
		gtk_box_pack_start (_tmp49_, (GtkWidget*) _tmp50_, TRUE, TRUE, (guint) 0);
		_tmp51_ = buttons_hbox;
		_tmp52_ = prev_button;
		gtk_box_pack_start (_tmp51_, (GtkWidget*) _tmp52_, FALSE, FALSE, (guint) 0);
		_tmp53_ = buttons_hbox;
		_tmp54_ = next_button;
		gtk_box_pack_start (_tmp53_, (GtkWidget*) _tmp54_, FALSE, FALSE, (guint) 0);
		_tmp55_ = vbox;
		_tmp56_ = buttons_hbox;
		gtk_box_pack_start (_tmp55_, (GtkWidget*) _tmp56_, FALSE, FALSE, (guint) 0);
		_tmp57_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp57_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp58_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp58_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp59_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp59_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			Block1Data* _data1_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_data1_->i = 0;
			{
				gboolean _tmp60_ = FALSE;
				_tmp60_ = TRUE;
				while (TRUE) {
					Block2Data* _data2_;
					gint _tmp62_;
					GtkLabel* label = NULL;
					gint _tmp63_;
					const gchar* _tmp64_;
					GtkLabel* _tmp65_;
					GtkLabel* _tmp66_;
					GtkLabel* _tmp67_;
					GtkLabel* _tmp68_;
					GtkLabel** _tmp69_;
					gint _tmp69__length1;
					GtkLabel* _tmp70_;
					GtkLabel* _tmp71_;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp72_;
					GtkLabel* _tmp73_;
					GtkLabel* _tmp74_;
					GtkLabel* _tmp75_;
					GtkLabel** _tmp76_;
					gint _tmp76__length1;
					GtkLabel* _tmp77_;
					GtkLabel* _tmp78_;
					GtkLabel* _tmp79_;
					GtkLabel* _tmp80_;
					gint _tmp81_;
					GtkEventBox* label_ebox = NULL;
					GtkEventBox* _tmp82_;
					GtkEventBox* _tmp83_;
					GtkEventBox* _tmp84_;
					GtkEventBox* _tmp85_;
					GtkLabel* _tmp86_;
					GtkBox* _tmp87_;
					GtkEventBox* _tmp88_;
					GtkWidget** _tmp89_;
					gint _tmp89__length1;
					GtkEventBox* _tmp90_;
					GtkWidget* _tmp91_;
					GtkEventBox* candidate_ebox = NULL;
					GtkEventBox* _tmp92_;
					GtkEventBox* _tmp93_;
					GtkEventBox* _tmp94_;
					GtkEventBox* _tmp95_;
					GtkLabel* _tmp96_;
					GtkBox* _tmp97_;
					GtkEventBox* _tmp98_;
					GtkWidget** _tmp99_;
					gint _tmp99__length1;
					GtkEventBox* _tmp100_;
					GtkWidget* _tmp101_;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->_data1_ = block1_data_ref (_data1_);
					if (!_tmp60_) {
						gint _tmp61_;
						_tmp61_ = _data1_->i;
						_data1_->i = _tmp61_ + 1;
					}
					_tmp60_ = FALSE;
					_tmp62_ = _data1_->i;
					if (!(_tmp62_ < 16)) {
						block2_data_unref (_data2_);
						_data2_ = NULL;
						break;
					}
					_tmp63_ = _data1_->i;
					_tmp64_ = CANDIDATE_AREA_LABELS[_tmp63_];
					_tmp65_ = (GtkLabel*) gtk_label_new (_tmp64_);
					g_object_ref_sink (_tmp65_);
					label = _tmp65_;
					_tmp66_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_START);
					_tmp67_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp67_, GTK_ALIGN_CENTER);
					_tmp68_ = label;
					gtk_widget_show ((GtkWidget*) _tmp68_);
					_tmp69_ = self->priv->m_labels;
					_tmp69__length1 = self->priv->m_labels_length1;
					_tmp70_ = label;
					_tmp71_ = _g_object_ref0 (_tmp70_);
					_vala_array_add1 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp71_);
					_tmp72_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp72_);
					candidate = _tmp72_;
					_tmp73_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp73_, GTK_ALIGN_START);
					_tmp74_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp74_, GTK_ALIGN_CENTER);
					_tmp75_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp75_);
					_tmp76_ = self->priv->m_candidates;
					_tmp76__length1 = self->priv->m_candidates_length1;
					_tmp77_ = candidate;
					_tmp78_ = _g_object_ref0 (_tmp77_);
					_vala_array_add2 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp78_);
					_tmp79_ = label;
					gtk_misc_set_padding ((GtkMisc*) _tmp79_, 8, 0);
					_tmp80_ = candidate;
					gtk_misc_set_padding ((GtkMisc*) _tmp80_, 8, 0);
					_tmp81_ = _data1_->i;
					_data2_->index = _tmp81_;
					_tmp82_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp82_);
					label_ebox = _tmp82_;
					_tmp83_ = label_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp83_, TRUE);
					_tmp84_ = label_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp84_, "button-press-event", (GCallback) _______lambda7__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp85_ = label_ebox;
					_tmp86_ = label;
					gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
					_tmp87_ = labels_vbox;
					_tmp88_ = label_ebox;
					gtk_box_pack_start (_tmp87_, (GtkWidget*) _tmp88_, FALSE, FALSE, (guint) 2);
					_tmp89_ = self->priv->m_widgets;
					_tmp89__length1 = self->priv->m_widgets_length1;
					_tmp90_ = label_ebox;
					_tmp91_ = _g_object_ref0 ((GtkWidget*) _tmp90_);
					_vala_array_add3 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp91_);
					_tmp92_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp92_);
					candidate_ebox = _tmp92_;
					_tmp93_ = candidate_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp93_, TRUE);
					_tmp94_ = candidate_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp94_, "button-press-event", (GCallback) _______lambda8__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp95_ = candidate_ebox;
					_tmp96_ = candidate;
					gtk_container_add ((GtkContainer*) _tmp95_, (GtkWidget*) _tmp96_);
					_tmp97_ = candidates_vbox;
					_tmp98_ = candidate_ebox;
					gtk_box_pack_start (_tmp97_, (GtkWidget*) _tmp98_, FALSE, FALSE, (guint) 2);
					_tmp99_ = self->priv->m_widgets;
					_tmp99__length1 = self->priv->m_widgets_length1;
					_tmp100_ = candidate_ebox;
					_tmp101_ = _g_object_ref0 ((GtkWidget*) _tmp100_);
					_vala_array_add4 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp101_);
					_g_object_unref0 (candidate_ebox);
					_g_object_unref0 (label_ebox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_g_object_unref0 (state_label);
		_g_object_unref0 (buttons_hbox);
		_g_object_unref0 (candidates_vbox);
		_g_object_unref0 (labels_vbox);
		_g_object_unref0 (candidates_hbox);
		_g_object_unref0 (vbox);
		_g_object_unref0 (container_ebox);
	} else {
		GtkEventBox* container_ebox = NULL;
		GtkEventBox* _tmp102_;
		GtkEventBox* _tmp103_;
		GtkEventBox* _tmp104_;
		GtkEventBox* _tmp105_;
		GtkBox* hbox = NULL;
		GtkBox* _tmp106_;
		GtkEventBox* _tmp107_;
		GtkBox* _tmp108_;
		GtkLabel** _tmp109_;
		GtkLabel** _tmp110_;
		GtkWidget** _tmp111_;
		GtkBox* _tmp148_;
		VSeparator* _tmp149_;
		VSeparator* _tmp150_;
		GtkBox* _tmp151_;
		GtkButton* _tmp152_;
		GtkBox* _tmp153_;
		GtkButton* _tmp154_;
		_tmp102_ = (GtkEventBox*) gtk_event_box_new ();
		g_object_ref_sink (_tmp102_);
		container_ebox = _tmp102_;
		_tmp103_ = container_ebox;
		gtk_widget_add_events ((GtkWidget*) _tmp103_, (gint) GDK_SCROLL_MASK);
		_tmp104_ = container_ebox;
		g_signal_connect_object ((GtkWidget*) _tmp104_, "scroll-event", (GCallback) _candidate_area_candidate_scrolled_gtk_widget_scroll_event, self, 0);
		_tmp105_ = container_ebox;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp105_);
		_tmp106_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp106_);
		hbox = _tmp106_;
		_tmp107_ = container_ebox;
		_tmp108_ = hbox;
		gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp108_);
		_tmp109_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp109_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp110_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp110_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp111_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp111_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp112_ = FALSE;
				_tmp112_ = TRUE;
				while (TRUE) {
					Block3Data* _data3_;
					gint _tmp114_;
					GtkLabel* label = NULL;
					gint _tmp115_;
					const gchar* _tmp116_;
					GtkLabel* _tmp117_;
					GtkLabel* _tmp118_;
					GtkLabel* _tmp119_;
					GtkLabel* _tmp120_;
					GtkLabel** _tmp121_;
					gint _tmp121__length1;
					GtkLabel* _tmp122_;
					GtkLabel* _tmp123_;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp124_;
					GtkLabel* _tmp125_;
					GtkLabel* _tmp126_;
					GtkLabel* _tmp127_;
					GtkLabel** _tmp128_;
					gint _tmp128__length1;
					GtkLabel* _tmp129_;
					GtkLabel* _tmp130_;
					GtkBox* candidate_hbox = NULL;
					GtkBox* _tmp131_;
					GtkBox* _tmp132_;
					GtkBox* _tmp133_;
					GtkLabel* _tmp134_;
					GtkBox* _tmp135_;
					GtkLabel* _tmp136_;
					gint _tmp137_;
					GtkEventBox* ebox = NULL;
					GtkEventBox* _tmp138_;
					GtkEventBox* _tmp139_;
					GtkEventBox* _tmp140_;
					GtkEventBox* _tmp141_;
					GtkBox* _tmp142_;
					GtkBox* _tmp143_;
					GtkEventBox* _tmp144_;
					GtkWidget** _tmp145_;
					gint _tmp145__length1;
					GtkEventBox* _tmp146_;
					GtkWidget* _tmp147_;
					_data3_ = g_slice_new0 (Block3Data);
					_data3_->_ref_count_ = 1;
					_data3_->self = g_object_ref (self);
					if (!_tmp112_) {
						gint _tmp113_;
						_tmp113_ = i;
						i = _tmp113_ + 1;
					}
					_tmp112_ = FALSE;
					_tmp114_ = i;
					if (!(_tmp114_ < 16)) {
						block3_data_unref (_data3_);
						_data3_ = NULL;
						break;
					}
					_tmp115_ = i;
					_tmp116_ = CANDIDATE_AREA_LABELS[_tmp115_];
					_tmp117_ = (GtkLabel*) gtk_label_new (_tmp116_);
					g_object_ref_sink (_tmp117_);
					label = _tmp117_;
					_tmp118_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp118_, GTK_ALIGN_START);
					_tmp119_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp119_, GTK_ALIGN_CENTER);
					_tmp120_ = label;
					gtk_widget_show ((GtkWidget*) _tmp120_);
					_tmp121_ = self->priv->m_labels;
					_tmp121__length1 = self->priv->m_labels_length1;
					_tmp122_ = label;
					_tmp123_ = _g_object_ref0 (_tmp122_);
					_vala_array_add5 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp123_);
					_tmp124_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp124_);
					candidate = _tmp124_;
					_tmp125_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp125_, GTK_ALIGN_START);
					_tmp126_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp126_, GTK_ALIGN_CENTER);
					_tmp127_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp127_);
					_tmp128_ = self->priv->m_candidates;
					_tmp128__length1 = self->priv->m_candidates_length1;
					_tmp129_ = candidate;
					_tmp130_ = _g_object_ref0 (_tmp129_);
					_vala_array_add6 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp130_);
					_tmp131_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
					g_object_ref_sink (_tmp131_);
					candidate_hbox = _tmp131_;
					_tmp132_ = candidate_hbox;
					gtk_widget_show ((GtkWidget*) _tmp132_);
					_tmp133_ = candidate_hbox;
					_tmp134_ = label;
					gtk_box_pack_start (_tmp133_, (GtkWidget*) _tmp134_, FALSE, FALSE, (guint) 2);
					_tmp135_ = candidate_hbox;
					_tmp136_ = candidate;
					gtk_box_pack_start (_tmp135_, (GtkWidget*) _tmp136_, FALSE, FALSE, (guint) 2);
					_tmp137_ = i;
					_data3_->index = _tmp137_;
					_tmp138_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp138_);
					ebox = _tmp138_;
					_tmp139_ = ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp139_, TRUE);
					_tmp140_ = ebox;
					g_signal_connect_data ((GtkWidget*) _tmp140_, "button-press-event", (GCallback) _______lambda9__gtk_widget_button_press_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp141_ = ebox;
					_tmp142_ = candidate_hbox;
					gtk_container_add ((GtkContainer*) _tmp141_, (GtkWidget*) _tmp142_);
					_tmp143_ = hbox;
					_tmp144_ = ebox;
					gtk_box_pack_start (_tmp143_, (GtkWidget*) _tmp144_, FALSE, FALSE, (guint) 4);
					_tmp145_ = self->priv->m_widgets;
					_tmp145__length1 = self->priv->m_widgets_length1;
					_tmp146_ = ebox;
					_tmp147_ = _g_object_ref0 ((GtkWidget*) _tmp146_);
					_vala_array_add7 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp147_);
					_g_object_unref0 (ebox);
					_g_object_unref0 (candidate_hbox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block3_data_unref (_data3_);
					_data3_ = NULL;
				}
			}
		}
		_tmp148_ = hbox;
		_tmp149_ = vseparator_new ();
		g_object_ref_sink (_tmp149_);
		_tmp150_ = _tmp149_;
		gtk_box_pack_start (_tmp148_, (GtkWidget*) _tmp150_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp150_);
		_tmp151_ = hbox;
		_tmp152_ = prev_button;
		gtk_box_pack_start (_tmp151_, (GtkWidget*) _tmp152_, FALSE, FALSE, (guint) 0);
		_tmp153_ = hbox;
		_tmp154_ = next_button;
		gtk_box_pack_start (_tmp153_, (GtkWidget*) _tmp154_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (hbox);
		_g_object_unref0 (container_ebox);
	}
	_g_object_unref0 (next_button);
	_g_object_unref0 (prev_button);
}


static void
g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void
candidate_area_class_init (CandidateAreaClass * klass)
{
	candidate_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CandidateAreaPrivate));
	G_OBJECT_CLASS (klass)->finalize = candidate_area_finalize;
	candidate_area_signals[CANDIDATE_AREA_CANDIDATE_CLICKED_SIGNAL] = g_signal_new ("candidate-clicked", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
	candidate_area_signals[CANDIDATE_AREA_PAGE_UP_SIGNAL] = g_signal_new ("page-up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_area_signals[CANDIDATE_AREA_PAGE_DOWN_SIGNAL] = g_signal_new ("page-down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_area_signals[CANDIDATE_AREA_CURSOR_UP_SIGNAL] = g_signal_new ("cursor-up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_area_signals[CANDIDATE_AREA_CURSOR_DOWN_SIGNAL] = g_signal_new ("cursor-down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
candidate_area_instance_init (CandidateArea * self)
{
	self->priv = CANDIDATE_AREA_GET_PRIVATE (self);
}


static void
candidate_area_finalize (GObject * obj)
{
	CandidateArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANDIDATE_AREA, CandidateArea);
	self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_themed_rgba_unref0 (self->priv->m_rgba);
	G_OBJECT_CLASS (candidate_area_parent_class)->finalize (obj);
}


GType
candidate_area_get_type (void)
{
	static volatile gsize candidate_area_type_id__volatile = 0;
	if (g_once_init_enter (&candidate_area_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CandidateAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) candidate_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CandidateArea), 0, (GInstanceInitFunc) candidate_area_instance_init, NULL };
		GType candidate_area_type_id;
		candidate_area_type_id = g_type_register_static (gtk_box_get_type (), "CandidateArea", &g_define_type_info, 0);
		g_once_init_leave (&candidate_area_type_id__volatile, candidate_area_type_id);
	}
	return candidate_area_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



